// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2017-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "common.hpp"
#include "gfx/shader/gfx-shader.hpp"
#include "obs/gs/gs-rendertarget.hpp"
#include "obs/obs-source-factory.hpp"
#include "plugin.hpp"

namespace streamfx::transition::shader {
	class shader_instance : public obs::source_instance {
		std::shared_ptr<streamfx::gfx::shader::shader> _fx;

		public:
		shader_instance(obs_data_t* data, obs_source_t* self);
		virtual ~shader_instance();

		virtual uint32_t get_width() override;
		virtual uint32_t get_height() override;

		void properties(obs_properties_t* props);

		virtual void load(obs_data_t* data) override;
		virtual void update(obs_data_t* data) override;

		virtual void video_tick(float sec_since_last) override;
		virtual void video_render(gs_effect_t* effect) override;

		void transition_render(gs_texture_t* a, gs_texture_t* b, float t, uint32_t cx, uint32_t cy);

		virtual bool audio_render(uint64_t* ts_out, struct obs_source_audio_mix* audio_output, uint32_t mixers, std::size_t channels, std::size_t sample_rate) override;

		virtual void transition_start() override;
		virtual void transition_stop() override;
	};

	class shader_factory : public obs::source_factory<streamfx::transition::shader::shader_factory, transition::shader::shader_instance> {
		public:
		shader_factory();
		virtual ~shader_factory();

		virtual const char* get_name() override;

		virtual void get_defaults2(obs_data_t* data) override;

		virtual obs_properties_t* get_properties2(transition::shader::shader_instance* data) override;

		static bool on_manual_open(obs_properties_t* props, obs_property_t* property, void* data);

		public: // Singleton
		static std::shared_ptr<shader_factory> instance();
	};
} // namespace streamfx::transition::shader
