// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2017-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// Copyright (C) 2021 coolsoft.rf <coolsoft.rf@gmail.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "common.hpp"
#include "gfx/shader/gfx-shader.hpp"
#include "obs/gs/gs-rendertarget.hpp"
#include "obs/obs-source-factory.hpp"
#include "plugin.hpp"

namespace streamfx::source::shader {
	class shader_instance : public obs::source_instance {
		std::shared_ptr<streamfx::gfx::shader::shader> _fx;

		public:
		shader_instance(obs_data_t* data, obs_source_t* self);
		virtual ~shader_instance();

		virtual uint32_t get_width() override;
		virtual uint32_t get_height() override;

		void properties(obs_properties_t* props);

		virtual void load(obs_data_t* data) override;
		virtual void update(obs_data_t* data) override;

		virtual void video_tick(float sec_since_last) override;
		virtual void video_render(gs_effect_t* effect) override;

		void show() override;
		void hide() override;

		void activate() override;
		void deactivate() override;
	};

	class shader_factory : public obs::source_factory<source::shader::shader_factory, source::shader::shader_instance> {
		public:
		shader_factory();
		virtual ~shader_factory();

		virtual const char* get_name() override;

		virtual void get_defaults2(obs_data_t* data) override;

		virtual obs_properties_t* get_properties2(source::shader::shader_instance* data) override;

		static bool on_manual_open(obs_properties_t* props, obs_property_t* property, void* data);

		public: // Singleton
		static std::shared_ptr<shader_factory> instance();
	};
} // namespace streamfx::source::shader
