// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2019-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// Copyright (C) 2021 coolsoft.rf <coolsoft.rf@gmail.com>
// Copyright (C) 2022 lainon <GermanAizek@yandex.ru>
// AUTOGENERATED COPYRIGHT HEADER END

#include "gfx-shader-param.hpp"
#include "gfx-shader-param-basic.hpp"
#include "gfx-shader-param-texture.hpp"

#include "warning-disable.hpp"
#include <algorithm>
#include <sstream>
#include "warning-enable.hpp"

#define ST_ANNO_ORDER "order"
#define ST_ANNO_VISIBILITY "visible"
#define ST_ANNO_AUTOMATIC "automatic"
#define ST_ANNO_NAME "name"
#define ST_ANNO_DESCRIPTION "description"
#define ST_ANNO_TYPE "type"
#define ST_ANNO_SIZE "size"

typedef streamfx::obs::gs::effect_parameter::type eptype;

streamfx::gfx::shader::parameter_type streamfx::gfx::shader::get_type_from_effect_type(streamfx::obs::gs::effect_parameter::type type)
{
	switch (type) {
	case eptype::Boolean:
		return parameter_type::Boolean;
	case eptype::Integer:
	case eptype::Integer2:
	case eptype::Integer3:
	case eptype::Integer4:
		return parameter_type::Integer;
	case eptype::Float:
	case eptype::Float2:
	case eptype::Float3:
	case eptype::Float4:
	case eptype::Matrix:
		return parameter_type::Float;
	case eptype::String:
		return parameter_type::String;
	case eptype::Texture:
		return parameter_type::Texture;
	default:
		return parameter_type::Unknown;
	}
}

std::size_t streamfx::gfx::shader::get_length_from_effect_type(streamfx::obs::gs::effect_parameter::type type)
{
	switch (type) {
	default:
	case eptype::Unknown:
	case eptype::Invalid:
	case eptype::String:
		return 0;
	case eptype::Boolean:
	case eptype::Float:
	case eptype::Integer:
	case eptype::Texture:
		return 1;
	case eptype::Float2:
	case eptype::Integer2:
		return 2;
	case eptype::Float3:
	case eptype::Integer3:
		return 3;
	case eptype::Float4:
	case eptype::Integer4:
		return 4;
	case eptype::Matrix:
		return 16;
	}
}

streamfx::gfx::shader::parameter_type streamfx::gfx::shader::get_type_from_string(std::string_view v)
{
	if ((v == "bool") || (v == "boolean")) {
		return parameter_type::Boolean;
	}
	if ((v == "float") || (v == "single")) {
		return parameter_type::Float;
	}
	if ((v == "int") || (v == "integer")) {
		return parameter_type::Integer;
	}
	if ((v == "text") || (v == "string")) {
		return parameter_type::String;
	}
	if ((v == "tex") || (v == "texture")) {
		return parameter_type::Texture;
	}
	if ((v == "sampler")) {
		return parameter_type::Sampler;
	}
	/* To decide on in the future:
	 * - Double support?
	 * - Half Support?
	 * - Texture Arrays? (Likely not supported in libobs)
	 */
	throw std::invalid_argument("Invalid parameter type string.");
}

streamfx::gfx::shader::parameter::parameter(streamfx::gfx::shader::shader* parent, streamfx::obs::gs::effect_parameter param, std::string key_prefix) : _parent(parent), _param(param), _order(0), _key(_param.get_name()), _visible(true), _automatic(false), _name(_key), _description()
{
	{
		std::stringstream ss;
		ss << key_prefix << "." << param.get_name();
		_name = (_key);
	}

	// Read Order
	if (auto anno = _param.get_annotation(ST_ANNO_VISIBILITY); anno) {
		_visible = anno.get_default_bool();
	}
	if (auto anno = _param.get_annotation(ST_ANNO_AUTOMATIC); anno) {
		_automatic = anno.get_default_bool();
	}

	// Read Order
	if (auto anno = _param.get_annotation(ST_ANNO_ORDER); anno) {
		_order = anno.get_default_int();
	}

	// Read Name
	if (auto anno = _param.get_annotation(ST_ANNO_NAME); anno) {
		if (std::string v = anno.get_default_string(); v.length() > 0) {
			_name = std::move(v);
		} else {
			throw std::out_of_range("'" ST_ANNO_NAME "' annotation has zero length.");
		}
	}

	// Read Description
	if (auto anno = _param.get_annotation(ST_ANNO_DESCRIPTION); anno) {
		if (std::string v = anno.get_default_string(); v.length() > 0) {
			_description = std::move(v);
		} else {
			throw std::out_of_range("'" ST_ANNO_DESCRIPTION "' annotation has zero length.");
		}
	}

	// Read Type override.
	_type = get_type_from_effect_type(_param.get_type());
	if (auto anno = _param.get_annotation(ST_ANNO_TYPE); anno) {
		// We have a type override.
		_type = get_type_from_string(anno.get_default_string());
	}

	// Read Size override.
	_size = get_length_from_effect_type(_param.get_type());
	if (auto anno = _param.get_annotation(ST_ANNO_SIZE); anno) {
		std::size_t ov = static_cast<size_t>(anno.get_default_int());
		if (ov > 0)
			_size = ov;
	}
	_size = std::clamp<size_t>(_size, size_t{1}, size_t{32});
}

void streamfx::gfx::shader::parameter::defaults(obs_data_t* settings) {}

void streamfx::gfx::shader::parameter::properties(obs_properties_t* props, obs_data_t* settings) {}

void streamfx::gfx::shader::parameter::update(obs_data_t* settings) {}

void streamfx::gfx::shader::parameter::assign() {}

void streamfx::gfx::shader::parameter::visible(bool visible) {}

void streamfx::gfx::shader::parameter::active(bool active) {}

std::shared_ptr<streamfx::gfx::shader::parameter> streamfx::gfx::shader::parameter::make_parameter(streamfx::gfx::shader::shader* parent, streamfx::obs::gs::effect_parameter param, std::string prefix)
{
	if (!parent || !param) {
		throw std::runtime_error("Bad call to make_parameter. This is a bug in the plugin.");
	}

	parameter_type real_type = get_type_from_effect_type(param.get_type());
	if (auto anno = param.get_annotation(ST_ANNO_TYPE); anno) {
		// We have a type override.
		real_type = get_type_from_string(param.get_default_string());
	}

	switch (real_type) {
	case parameter_type::Boolean:
		return std::make_shared<streamfx::gfx::shader::bool_parameter>(parent, param, prefix);
	case parameter_type::Integer:
		return std::make_shared<streamfx::gfx::shader::int_parameter>(parent, param, prefix);
	case parameter_type::Float:
		return std::make_shared<streamfx::gfx::shader::float_parameter>(parent, param, prefix);
	case parameter_type::Texture:
		return std::make_shared<streamfx::gfx::shader::texture_parameter>(parent, param, prefix);
	default:
		return nullptr;
	}
}
