// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2018-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "common.hpp"
#include "gfx/gfx-util.hpp"
#include "obs/gs/gs-effect.hpp"
#include "obs/gs/gs-rendertarget.hpp"
#include "obs/gs/gs-sampler.hpp"
#include "obs/gs/gs-texture.hpp"
#include "obs/gs/gs-vertexbuffer.hpp"
#include "obs/obs-source-factory.hpp"

namespace streamfx::filter::sdf_effects {
	class sdf_effects_instance : public obs::source_instance {
		streamfx::obs::gs::effect            _sdf_producer_effect;
		streamfx::obs::gs::effect            _sdf_consumer_effect;
		std::shared_ptr<streamfx::gfx::util> _gfx_util;

		// Input
		std::shared_ptr<streamfx::obs::gs::rendertarget> _source_rt;
		std::shared_ptr<streamfx::obs::gs::texture>      _source_texture;
		bool                                             _source_rendered;

		// Distance Field
		std::shared_ptr<streamfx::obs::gs::rendertarget> _sdf_write;
		std::shared_ptr<streamfx::obs::gs::rendertarget> _sdf_read;
		std::shared_ptr<streamfx::obs::gs::texture>      _sdf_texture;
		double_t                                         _sdf_scale;
		float                                          _sdf_threshold;

		// Effects
		bool                                             _output_rendered;
		std::shared_ptr<streamfx::obs::gs::texture>      _output_texture;
		std::shared_ptr<streamfx::obs::gs::rendertarget> _output_rt;
		/// Inner Shadow
		bool    _inner_shadow;
		vec4    _inner_shadow_color;
		float _inner_shadow_range_min;
		float _inner_shadow_range_max;
		float _inner_shadow_offset_x;
		float _inner_shadow_offset_y;
		/// Outer Shadow
		bool    _outer_shadow;
		vec4    _outer_shadow_color;
		float _outer_shadow_range_min;
		float _outer_shadow_range_max;
		float _outer_shadow_offset_x;
		float _outer_shadow_offset_y;
		/// Inner Glow
		bool    _inner_glow;
		vec4    _inner_glow_color;
		float _inner_glow_width;
		float _inner_glow_sharpness;
		float _inner_glow_sharpness_inv;
		/// Outer Glow
		bool    _outer_glow;
		vec4    _outer_glow_color;
		float _outer_glow_width;
		float _outer_glow_sharpness;
		float _outer_glow_sharpness_inv;
		/// Outline
		bool    _outline;
		vec4    _outline_color;
		float _outline_width;
		float _outline_offset;
		float _outline_sharpness;
		float _outline_sharpness_inv;

		public:
		sdf_effects_instance(obs_data_t* settings, obs_source_t* self);
		virtual ~sdf_effects_instance();

		virtual void load(obs_data_t* settings) override;
		virtual void migrate(obs_data_t* data, uint64_t version) override;
		virtual void update(obs_data_t* settings) override;

		virtual void video_tick(float) override;
		virtual void video_render(gs_effect_t*) override;
	};

	class sdf_effects_factory : public obs::source_factory<filter::sdf_effects::sdf_effects_factory, filter::sdf_effects::sdf_effects_instance> {
		public:
		sdf_effects_factory();
		virtual ~sdf_effects_factory();

		virtual const char* get_name() override;

		virtual void get_defaults2(obs_data_t* data) override;

		virtual obs_properties_t* get_properties2(filter::sdf_effects::sdf_effects_instance* data) override;

		static bool on_manual_open(obs_properties_t* props, obs_property_t* property, void* data);

		public: // Singleton
		static void initialize();

		static void finalize();

		static std::shared_ptr<sdf_effects_factory> instance();
	};

} // namespace streamfx::filter::sdf_effects
