// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2020-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// Copyright (C) 2022 lainon <GermanAizek@yandex.ru>
// AUTOGENERATED COPYRIGHT HEADER END

#include "nvidia/cuda/nvidia-cuda-gs-texture.hpp"
#include "obs/gs/gs-helper.hpp"
#include "util/util-logging.hpp"

#ifdef _DEBUG
#define ST_PREFIX "<%s> "
#define D_LOG_ERROR(x, ...) P_LOG_ERROR(ST_PREFIX##x, __FUNCTION_SIG__, __VA_ARGS__)
#define D_LOG_WARNING(x, ...) P_LOG_WARN(ST_PREFIX##x, __FUNCTION_SIG__, __VA_ARGS__)
#define D_LOG_INFO(x, ...) P_LOG_INFO(ST_PREFIX##x, __FUNCTION_SIG__, __VA_ARGS__)
#define D_LOG_DEBUG(x, ...) P_LOG_DEBUG(ST_PREFIX##x, __FUNCTION_SIG__, __VA_ARGS__)
#else
#define ST_PREFIX "<nvidia::cuda::gstexture> "
#define D_LOG_ERROR(...) P_LOG_ERROR(ST_PREFIX __VA_ARGS__)
#define D_LOG_WARNING(...) P_LOG_WARN(ST_PREFIX __VA_ARGS__)
#define D_LOG_INFO(...) P_LOG_INFO(ST_PREFIX __VA_ARGS__)
#define D_LOG_DEBUG(...) P_LOG_DEBUG(ST_PREFIX __VA_ARGS__)
#endif

streamfx::nvidia::cuda::gstexture::~gstexture()
{
	D_LOG_DEBUG("Finalizing... (Addr: 0x%" PRIuPTR ")", this);

	unmap();
	_cuda->cuGraphicsUnregisterResource(_resource);
}

streamfx::nvidia::cuda::gstexture::gstexture(std::shared_ptr<streamfx::obs::gs::texture> texture) : _cuda(::streamfx::nvidia::cuda::cuda::get()), _texture(texture), _resource(), _is_mapped(false), _pointer()
{
	D_LOG_DEBUG("Initializating... (Addr: 0x%" PRIuPTR ")", this);

	if (!texture)
		throw std::invalid_argument("texture");

	streamfx::obs::gs::context gctx;
	int                        dev_type = gs_get_device_type();

	if (dev_type == GS_DEVICE_OPENGL) {
		// ToDo
	}
#ifdef WIN32
	if (dev_type == GS_DEVICE_DIRECT3D_11) {
		ID3D11Resource* resource = nullptr;
		switch (_texture->get_type()) {
		case streamfx::obs::gs::texture::type::Cube:
		case streamfx::obs::gs::texture::type::Volume:
		case streamfx::obs::gs::texture::type::Normal: {
			resource = static_cast<ID3D11Resource*>(gs_texture_get_obj(_texture->get_object()));
			break;
		}
		}

		if (!resource) {
			throw std::runtime_error("nvidia::cuda::gstexture: Failed to get resource from gs::texture.");
		}

		switch (_cuda->cuGraphicsD3D11RegisterResource(&_resource, resource, 0)) {
		case streamfx::nvidia::cuda::result::SUCCESS:
			break;
		default:
			throw std::runtime_error("nvidia::cuda::gstexture: Failed to register resource.");
		}
	}
#endif
}

streamfx::nvidia::cuda::array_t streamfx::nvidia::cuda::gstexture::map(std::shared_ptr<streamfx::nvidia::cuda::stream> stream)
{
	if (_is_mapped) {
		return _pointer;
	}

	graphics_resource_t resources[] = {_resource};
	switch (_cuda->cuGraphicsMapResources(1, resources, stream->get())) {
	case streamfx::nvidia::cuda::result::SUCCESS:
		break;
	default:
		throw std::runtime_error("nvidia::cuda::gstexture: Mapping failed.");
	}

	_stream    = std::move(stream);
	_is_mapped = true;

	switch (_cuda->cuGraphicsSubResourceGetMappedArray(&_pointer, _resource, 0, 0)) {
	case streamfx::nvidia::cuda::result::SUCCESS:
		break;
	default:
		unmap();
		throw std::runtime_error("nvidia::cuda::gstexture: Mapping pointer failed.");
	}

	return _pointer;
}

void streamfx::nvidia::cuda::gstexture::unmap()
{
	if (!_is_mapped)
		return;

	graphics_resource_t resources[] = {_resource};
	switch (_cuda->cuGraphicsUnmapResources(1, resources, _stream->get())) {
	case streamfx::nvidia::cuda::result::SUCCESS:
		break;
	default:
		throw std::runtime_error("nvidia::cuda::gstexture: Unmapping failed.");
	}

	_is_mapped = false;
	_pointer   = nullptr;
	_stream.reset();
}

std::shared_ptr<streamfx::obs::gs::texture> streamfx::nvidia::cuda::gstexture::get_texture()
{
	return _texture;
}

::streamfx::nvidia::cuda::graphics_resource_t streamfx::nvidia::cuda::gstexture::get()
{
	return _resource;
}
