// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2017-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// Copyright (C) 2022 lainon <GermanAizek@yandex.ru>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "nvidia-cuda.hpp"

#include "warning-disable.hpp"
#include <memory>
#include "warning-enable.hpp"

namespace streamfx::nvidia::cuda {
	class context_stack;

	class context : public std::enable_shared_from_this<::streamfx::nvidia::cuda::context> {
		std::shared_ptr<::streamfx::nvidia::cuda::cuda> _cuda;
		::streamfx::nvidia::cuda::context_t             _ctx;
		bool                                            _has_device;
		::streamfx::nvidia::cuda::device_t              _device;

		public:
		~context();

		private:
		context();

		public:
#ifdef WIN32
		context(ID3D11Device* device);
#endif

		::streamfx::nvidia::cuda::context_t get();

		void push();
		void pop();

		void synchronize();

		public:
		std::shared_ptr<::streamfx::nvidia::cuda::context_stack> enter();
	};

	class context_stack {
		std::shared_ptr<::streamfx::nvidia::cuda::context> _ctx;

		public:
		inline ~context_stack()
		{
			_ctx->pop();
		}
		inline context_stack(std::shared_ptr<::streamfx::nvidia::cuda::context> ctx) : _ctx(std::move(ctx))
		{
			_ctx->push();
		}
	};
} // namespace streamfx::nvidia::cuda
