// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2021-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "nvidia-ar-feature.hpp"
#include "nvidia/cuda/nvidia-cuda-gs-texture.hpp"
#include "nvidia/cuda/nvidia-cuda-obs.hpp"
#include "nvidia/cuda/nvidia-cuda.hpp"
#include "nvidia/cv/nvidia-cv-image.hpp"
#include "nvidia/cv/nvidia-cv-texture.hpp"
#include "obs/gs/gs-texture.hpp"

namespace streamfx::nvidia::ar {
	class facedetection : public feature {
		std::shared_ptr<::streamfx::nvidia::cv::texture> _input;
		std::shared_ptr<::streamfx::nvidia::cv::image>   _source;
		std::shared_ptr<::streamfx::nvidia::cv::image>   _tmp;

		std::vector<rect_t> _rects;
		std::vector<float>  _rects_confidence;
		bounds_t            _bboxes;

		bool _dirty;

		public:
		~facedetection();

		/** Create a new face detection feature.
		 *
		 * Must be in a graphics and CUDA context when calling.
		 */
		facedetection();

		std::pair<size_t, size_t> tracking_limit_range();

		size_t tracking_limit();

		void set_tracking_limit(size_t v);

		void process(std::shared_ptr<::streamfx::obs::gs::texture> in);

		size_t count();

		rect_t const& at(size_t index);

		rect_t const& at(size_t index, float& confidence);

		private:
		void resize(uint32_t width, uint32_t height);

		void load();
	};
} // namespace streamfx::nvidia::ar
