// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2017-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "common.hpp"
#include "gfx/gfx-source-texture.hpp"
#include "obs/gs/gs-rendertarget.hpp"
#include "obs/gs/gs-sampler.hpp"
#include "obs/obs-signal-handler.hpp"
#include "obs/obs-source-active-child.hpp"
#include "obs/obs-source-factory.hpp"
#include "obs/obs-source.hpp"
#include "obs/obs-tools.hpp"

#include "warning-disable.hpp"
#include <condition_variable>
#include <mutex>
#include <queue>
#include <thread>
#include <vector>
#include "warning-enable.hpp"

namespace streamfx::source::mirror {
	struct mirror_audio_data {
		mirror_audio_data(const audio_data*, speaker_layout);

		obs_source_audio                  osa;
		std::vector<std::vector<uint8_t>> data;
	};

	class mirror_instance : public obs::source_instance {
		// Source
		::streamfx::obs::source                               _source;
		std::shared_ptr<::streamfx::obs::source_active_child> _source_child;
		std::shared_ptr<obs::source_signal_handler>           _signal_rename;
		std::shared_ptr<obs::audio_signal_handler>            _signal_audio;
		std::pair<uint32_t, uint32_t>                         _source_size;

		// Audio
		bool                          _audio_enabled;
		speaker_layout                _audio_layout;
		std::mutex                    _audio_queue_lock;
		std::queue<mirror_audio_data> _audio_queue;

		public:
		mirror_instance(obs_data_t* settings, obs_source_t* self);
		virtual ~mirror_instance();

		virtual uint32_t get_width() override;
		virtual uint32_t get_height() override;

		virtual void load(obs_data_t*) override;
		virtual void migrate(obs_data_t*, uint64_t) override;
		virtual void update(obs_data_t*) override;
		virtual void save(obs_data_t*) override;

		virtual void video_tick(float) override;
		virtual void video_render(gs_effect_t*) override;

		virtual void enum_active_sources(obs_source_enum_proc_t, void*) override;
		virtual void enum_all_sources(obs_source_enum_proc_t, void*) override;

		private:
		void acquire(std::string source_name);
		void release();

		void on_audio(::streamfx::obs::source, const struct audio_data*, bool);

		void audio_output(std::shared_ptr<void> data);
	};

	class mirror_factory : public obs::source_factory<source::mirror::mirror_factory, source::mirror::mirror_instance> {
		public:
		mirror_factory();
		virtual ~mirror_factory() override;

		virtual const char* get_name() override;

		virtual void get_defaults2(obs_data_t* data) override;

		virtual obs_properties_t* get_properties2(source::mirror::mirror_instance* data) override;

		static bool on_manual_open(obs_properties_t* props, obs_property_t* property, void* data);

		public: // Singleton
		static void initialize();

		static void finalize();

		static std::shared_ptr<mirror_factory> instance();
	};
} // namespace streamfx::source::mirror
