// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2020-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// Copyright (C) 2022 lainon <GermanAizek@yandex.ru>
// AUTOGENERATED COPYRIGHT HEADER END

#include "swscale.hpp"

#include "warning-disable.hpp"
#include <stdexcept>
#include "warning-enable.hpp"

using namespace streamfx::ffmpeg;

swscale::swscale() = default;

swscale::~swscale()
{
	finalize();
}

void swscale::set_source_size(uint32_t width, uint32_t height)
{
	source_size.first  = width;
	source_size.second = height;
}

void swscale::get_source_size(uint32_t& width, uint32_t& height)
{
	width  = this->source_size.first;
	height = this->source_size.second;
}

std::pair<uint32_t, uint32_t> swscale::get_source_size()
{
	return this->source_size;
}

uint32_t swscale::get_source_width()
{
	return this->source_size.first;
}

uint32_t swscale::get_source_height()
{
	return this->source_size.second;
}

void swscale::set_source_format(AVPixelFormat format)
{
	source_format = format;
}

AVPixelFormat swscale::get_source_format()
{
	return this->source_format;
}

void swscale::set_source_color(bool full_range, AVColorSpace space)
{
	source_full_range = full_range;
	source_colorspace = space;
}

void swscale::set_source_colorspace(AVColorSpace space)
{
	this->source_colorspace = space;
}

AVColorSpace swscale::get_source_colorspace()
{
	return this->source_colorspace;
}

void swscale::set_source_full_range(bool full_range)
{
	this->source_full_range = full_range;
}

bool swscale::is_source_full_range()
{
	return this->source_full_range;
}

void swscale::set_target_size(uint32_t width, uint32_t height)
{
	target_size.first  = width;
	target_size.second = height;
}

void swscale::get_target_size(uint32_t& width, uint32_t& height)
{
	width  = target_size.first;
	height = target_size.second;
}

std::pair<uint32_t, uint32_t> swscale::get_target_size()
{
	return this->target_size;
}

uint32_t swscale::get_target_width()
{
	return this->target_size.first;
}

uint32_t swscale::get_target_height()
{
	return this->target_size.second;
}

void swscale::set_target_format(AVPixelFormat format)
{
	target_format = format;
}

AVPixelFormat swscale::get_target_format()
{
	return this->target_format;
}

void swscale::set_target_color(bool full_range, AVColorSpace space)
{
	target_full_range = full_range;
	target_colorspace = space;
}

void swscale::set_target_colorspace(AVColorSpace space)
{
	this->target_colorspace = space;
}

AVColorSpace swscale::get_target_colorspace()
{
	return this->target_colorspace;
}

void swscale::set_target_full_range(bool full_range)
{
	this->target_full_range = full_range;
}

bool swscale::is_target_full_range()
{
	return this->target_full_range;
}

bool swscale::initialize(int flags)
{
	if (this->context) {
		return false;
	}
	if (source_size.first == 0 || source_size.second == 0 || source_format == AV_PIX_FMT_NONE || source_colorspace == AVCOL_SPC_UNSPECIFIED) {
		throw std::invalid_argument("not all source parameters were set");
	}
	if (target_size.first == 0 || target_size.second == 0 || target_format == AV_PIX_FMT_NONE || target_colorspace == AVCOL_SPC_UNSPECIFIED) {
		throw std::invalid_argument("not all target parameters were set");
	}

	this->context = sws_getContext(static_cast<int>(source_size.first), static_cast<int>(source_size.second), source_format, static_cast<int>(target_size.first), static_cast<int>(target_size.second), target_format, flags, nullptr, nullptr, nullptr);
	if (!this->context) {
		return false;
	}

	sws_setColorspaceDetails(this->context, sws_getCoefficients(source_colorspace), source_full_range ? 1 : 0, sws_getCoefficients(target_colorspace), target_full_range ? 1 : 0, 1L << 16 | 0L, 1L << 16 | 0L, 1L << 16 | 0L);

	return true;
}

bool swscale::finalize()
{
	if (this->context) {
		sws_freeContext(this->context);
		this->context = nullptr;
		return true;
	}
	return false;
}

int32_t swscale::convert(const uint8_t* const source_data[], const int source_stride[], int32_t source_row, int32_t source_rows, uint8_t* const target_data[], const int target_stride[])
{
	if (!this->context) {
		return 0;
	}
	int height = sws_scale(this->context, source_data, source_stride, source_row, source_rows, target_data, target_stride);
	return height;
}
