// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2020-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// Copyright (C) 2022 lainon <GermanAizek@yandex.ru>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "common.hpp"

#include "warning-disable.hpp"
#include <list>
#include <utility>
#include "warning-enable.hpp"

extern "C" {
#include "warning-disable.hpp"
#include <libavutil/frame.h>
#include <libavutil/hwcontext.h>
#include "warning-enable.hpp"
}

namespace streamfx::ffmpeg::hwapi {
	struct device {
		std::pair<int64_t, int64_t> id;
		std::string                 name;
	};

	class instance {
		public:
		virtual ~instance(){};

		virtual AVBufferRef* create_device_context() = 0;

		virtual std::shared_ptr<AVFrame> allocate_frame(AVBufferRef* frames) = 0;

		virtual void copy_from_obs(AVBufferRef* frames, uint32_t handle, uint64_t lock_key, uint64_t* next_lock_key, std::shared_ptr<AVFrame> frame) = 0;

		virtual std::shared_ptr<AVFrame> avframe_from_obs(AVBufferRef* frames, uint32_t handle, uint64_t lock_key, uint64_t* next_lock_key) = 0;
	};

	class base {
		public:
		virtual ~base(){};

		virtual std::list<hwapi::device> enumerate_adapters() = 0;

		virtual std::shared_ptr<hwapi::instance> create(const hwapi::device& target) = 0;

		virtual std::shared_ptr<hwapi::instance> create_from_obs() = 0;
	};
} // namespace streamfx::ffmpeg::hwapi
