// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2020-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "common.hpp"

#include "warning-disable.hpp"
#include <deque>
#include <mutex>
#include "warning-enable.hpp"

extern "C" {
#include "warning-disable.hpp"
#include <libavutil/frame.h>
#include "warning-enable.hpp"
}

namespace streamfx::ffmpeg {
	class avframe_queue {
		std::deque<std::shared_ptr<AVFrame>> _frames;
		std::mutex                           _lock;

		std::pair<int32_t, int32_t> _resolution;
		AVPixelFormat               _format = AV_PIX_FMT_NONE;

		std::shared_ptr<AVFrame> create_frame();

		public:
		avframe_queue();
		~avframe_queue();

		void    set_resolution(int32_t width, int32_t height);
		void    get_resolution(int32_t& width, int32_t& height);
		int32_t get_width();
		int32_t get_height();

		void          set_pixel_format(AVPixelFormat format);
		AVPixelFormat get_pixel_format();

		void precache(std::size_t count);

		void clear();

		void push(std::shared_ptr<AVFrame> frame);

		std::shared_ptr<AVFrame> pop();

		std::shared_ptr<AVFrame> pop_only();

		bool empty();

		std::size_t size();
	};
} // namespace streamfx::ffmpeg
