// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2020-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#include "prores_aw.hpp"
#include "common.hpp"
#include "../codecs/prores.hpp"
#include "ffmpeg/tools.hpp"
#include "plugin.hpp"

#include "warning-disable.hpp"
#include <array>
#include "warning-enable.hpp"

using namespace streamfx::encoder::ffmpeg;
using namespace streamfx::encoder::codec::prores;

inline const char* profile_to_name(const AVProfile* ptr)
{
	switch (static_cast<profile>(ptr->profile)) {
	case profile::APCO:
		return D_TRANSLATE(S_CODEC_PRORES_PROFILE_APCO);
	case profile::APCS:
		return D_TRANSLATE(S_CODEC_PRORES_PROFILE_APCS);
	case profile::APCN:
		return D_TRANSLATE(S_CODEC_PRORES_PROFILE_APCN);
	case profile::APCH:
		return D_TRANSLATE(S_CODEC_PRORES_PROFILE_APCH);
	case profile::AP4H:
		return D_TRANSLATE(S_CODEC_PRORES_PROFILE_AP4H);
	case profile::AP4X:
		return D_TRANSLATE(S_CODEC_PRORES_PROFILE_AP4X);
	default:
		return ptr->name;
	}
}

prores_aw::prores_aw() : handler("prores_aw") {}

prores_aw::~prores_aw() {}

bool prores_aw::has_keyframes(ffmpeg_factory* instance)
{
	return false;
}

void prores_aw::defaults(ffmpeg_factory* factory, obs_data_t* settings)
{
	obs_data_set_default_int(settings, S_CODEC_PRORES_PROFILE, 0);
}

void prores_aw::properties(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_properties_t* props)
{
	if (!instance) {
		auto p = obs_properties_add_list(props, S_CODEC_PRORES_PROFILE, D_TRANSLATE(S_CODEC_PRORES_PROFILE), OBS_COMBO_TYPE_LIST, OBS_COMBO_FORMAT_INT);
		for (auto ptr = factory->get_avcodec()->profiles; ptr->profile != FF_PROFILE_UNKNOWN; ptr++) {
			obs_property_list_add_int(p, profile_to_name(ptr), static_cast<int64_t>(ptr->profile));
		}
	} else {
		obs_property_set_enabled(obs_properties_get(props, S_CODEC_PRORES_PROFILE), false);
	}
}

void prores_aw::update(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings)
{
	if (instance) {
		instance->get_avcodeccontext()->profile = static_cast<int>(obs_data_get_int(settings, S_CODEC_PRORES_PROFILE));
	}
}

void prores_aw::log(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings)
{
	DLOG_INFO("[%s]   Apple ProRes:", factory->get_avcodec()->name);
	::streamfx::ffmpeg::tools::print_av_option_string(instance->get_avcodeccontext(), "profile", "    Profile", [&factory](int64_t v) {
		int val = static_cast<int>(v);
		for (auto ptr = factory->get_avcodec()->profiles; (ptr->profile != FF_PROFILE_UNKNOWN) && (ptr != nullptr); ptr++) {
			if (ptr->profile == val) {
				return std::string(profile_to_name(ptr));
			}
		}
		return std::string("<Unknown>");
	});
}

void prores_aw::override_colorformat(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings, AVPixelFormat& target_format)
{
	static const std::array<std::pair<profile, AVPixelFormat>, static_cast<size_t>(profile::_COUNT)> profile_to_format_map{
		std::pair{profile::APCO, AV_PIX_FMT_YUV422P10}, std::pair{profile::APCS, AV_PIX_FMT_YUV422P10}, std::pair{profile::APCN, AV_PIX_FMT_YUV422P10}, std::pair{profile::APCH, AV_PIX_FMT_YUV422P10}, std::pair{profile::AP4H, AV_PIX_FMT_YUV444P10}, std::pair{profile::AP4X, AV_PIX_FMT_YUV444P10},
	};

	const int64_t profile_id = obs_data_get_int(settings, S_CODEC_PRORES_PROFILE);
	for (auto kv : profile_to_format_map) {
		if (kv.first == static_cast<profile>(profile_id)) {
			target_format = kv.second;
			break;
		}
	}
}

static auto inst = prores_aw();
