// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END
// Copyright (C) 2020-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>

#pragma once
#include "encoders/encoder-ffmpeg.hpp"
#include "encoders/ffmpeg/handler.hpp"

#include "warning-disable.hpp"
#include <cinttypes>
#include <string>
extern "C" {
#include <libavcodec/avcodec.h>
}
#include "warning-enable.hpp"

/* NVENC has multiple compression modes:
- CBR: Constant Bitrate (rc=cbr)
- VBR: Variable Bitrate (rc=vbr)
- CQP: Constant QP (rc=cqp)
- CQ: Constant Quality (rc=vbr b=0 maxrate=0 qmin=0 qmax=51 cq=qp), this is basically CRF in X264.
*/

namespace streamfx::encoder::ffmpeg {
	namespace nvenc {
		bool is_available();

		void defaults(ffmpeg_factory* factory, obs_data_t* settings);
		void properties_before(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_properties_t* props, AVCodecContext* context);
		void properies_after(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_properties_t* props, AVCodecContext* context);
		void properties_runtime(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_properties_t* props);
		void migrate(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings, uint64_t version);
		void update(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings);
		void override_update(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings);
		void log(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings);
	} // namespace nvenc

	class nvenc_h264 : public handler {
		public:
		nvenc_h264();
		virtual ~nvenc_h264();

		bool has_keyframes(ffmpeg_factory* factory) override;
		bool has_threading(ffmpeg_factory* factory) override;
		bool is_hardware(ffmpeg_factory* factory) override;
		bool is_reconfigurable(ffmpeg_factory* factory, bool& threads, bool& gpu, bool& keyframes) override;

		void adjust_info(ffmpeg_factory* factory, std::string& id, std::string& name, std::string& codec) override;

		std::string help(ffmpeg_factory* factory) override
		{
			return "https://github.com/Xaymar/obs-StreamFX/wiki/Encoder-FFmpeg-NVENC";
		};

		void defaults(ffmpeg_factory* factory, obs_data_t* settings) override;
		void properties(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_properties_t* props) override;
		void migrate(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings, uint64_t version) override;
		void update(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings) override;
		void override_update(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings) override;
		void log(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings) override;

		private:
		void properties_encoder(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_properties_t* props);
		void properties_runtime(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_properties_t* props);
	};

	class nvenc_hevc : public handler {
		public:
		nvenc_hevc();
		virtual ~nvenc_hevc();

		bool has_keyframes(ffmpeg_factory* factory) override;
		bool has_threading(ffmpeg_factory* factory) override;
		bool is_hardware(ffmpeg_factory* factory) override;
		bool is_reconfigurable(ffmpeg_factory* factory, bool& threads, bool& gpu, bool& keyframes) override;

		void adjust_info(ffmpeg_factory* factory, std::string& id, std::string& name, std::string& codec) override;

		std::string help(ffmpeg_factory* factory) override
		{
			return "https://github.com/Xaymar/obs-StreamFX/wiki/Encoder-FFmpeg-NVENC";
		};

		void defaults(ffmpeg_factory* factory, obs_data_t* settings) override;
		void properties(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_properties_t* props) override;
		void migrate(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings, uint64_t version) override;
		void update(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings) override;
		void override_update(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings) override;
		void log(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_data_t* settings) override;

		private:
		void properties_encoder(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_properties_t* props);
		void properties_runtime(ffmpeg_factory* factory, ffmpeg_instance* instance, obs_properties_t* props);
	};
} // namespace streamfx::encoder::ffmpeg
