// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2021-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// Copyright (C) 2022 lainon <GermanAizek@yandex.ru>
// AUTOGENERATED COPYRIGHT HEADER END

#include "gfx-lut-producer.hpp"

#include "obs/gs/gs-helper.hpp"

gs_color_format format_from_depth(streamfx::gfx::lut::color_depth depth)
{
	switch (depth) {
	case streamfx::gfx::lut::color_depth::_2:
	case streamfx::gfx::lut::color_depth::_4:
	case streamfx::gfx::lut::color_depth::_6:
	case streamfx::gfx::lut::color_depth::_8:
		return gs_color_format::GS_RGBA;
	case streamfx::gfx::lut::color_depth::_10:
		return gs_color_format::GS_R10G10B10A2;
	case streamfx::gfx::lut::color_depth::_12:
	case streamfx::gfx::lut::color_depth::_14:
	case streamfx::gfx::lut::color_depth::_16:
		return gs_color_format::GS_RGBA16;
	default:
		return GS_RGBA32F;
	}
}

streamfx::gfx::lut::producer::producer() : _gfx_util(::streamfx::gfx::util::get())
{
	_data = streamfx::gfx::lut::data::instance();
	if (!_data->producer_effect())
		throw std::runtime_error("Unable to get LUT producer effect.");
}

streamfx::gfx::lut::producer::~producer() = default;

std::shared_ptr<streamfx::obs::gs::texture> streamfx::gfx::lut::producer::produce(streamfx::gfx::lut::color_depth depth)
{
	auto gctx = streamfx::obs::gs::context();

	if (!_rt || (_rt->get_color_format() != format_from_depth((depth)))) {
		_rt = std::make_shared<streamfx::obs::gs::rendertarget>(format_from_depth(depth), GS_ZS_NONE);
	}

	auto effect = _data->producer_effect();

	int32_t idepth         = static_cast<int32_t>(depth);
	int32_t size           = static_cast<int32_t>(pow(2l, idepth));
	int32_t grid_size      = static_cast<int32_t>(pow(2l, (idepth / 2)));
	int32_t container_size = static_cast<int32_t>(pow(2l, (idepth + (idepth / 2))));

	{
		auto op = _rt->render(static_cast<uint32_t>(container_size), static_cast<uint32_t>(container_size));

		gs_blend_state_push();
		gs_enable_color(true, true, true, false);
		gs_enable_blending(false);
		gs_enable_stencil_test(false);
		gs_enable_stencil_write(false);
		gs_ortho(0, 1, 0, 1, 0, 1);

		if (streamfx::obs::gs::effect_parameter efp = effect->get_parameter("lut_params_0"); efp) {
			efp.set_int4(size, grid_size, container_size, 0l);
		}

		while (gs_effect_loop(effect->get_object(), "Draw")) {
			_gfx_util->draw_fullscreen_triangle();
		}

		gs_enable_color(true, true, true, true);
		gs_blend_state_pop();
	}

	return _rt->get_texture();
}
