// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2021-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// Copyright (C) 2022 lainon <GermanAizek@yandex.ru>
// AUTOGENERATED COPYRIGHT HEADER END

#include "gfx-lut-consumer.hpp"
#include "obs/gs/gs-helper.hpp"

streamfx::gfx::lut::consumer::consumer()
{
	_data = streamfx::gfx::lut::data::instance();
	if (!_data->consumer_effect())
		throw std::runtime_error("Unable to get LUT consumer effect.");
}

streamfx::gfx::lut::consumer::~consumer() = default;

std::shared_ptr<streamfx::obs::gs::effect> streamfx::gfx::lut::consumer::prepare(streamfx::gfx::lut::color_depth depth, std::shared_ptr<streamfx::obs::gs::texture> lut)
{
	auto gctx = streamfx::obs::gs::context();

	auto effect = _data->consumer_effect();

	int32_t idepth         = static_cast<int32_t>(depth);
	int32_t size           = static_cast<int32_t>(pow(2l, idepth));
	int32_t grid_size      = static_cast<int32_t>(pow(2l, (idepth / 2)));
	int32_t container_size = static_cast<int32_t>(pow(2l, (idepth + (idepth / 2))));

	if (streamfx::obs::gs::effect_parameter efp = effect->get_parameter("lut_params_0"); efp) {
		efp.set_int4(size, grid_size, container_size, 0l);
	}

	if (streamfx::obs::gs::effect_parameter efp = effect->get_parameter("lut_params_1"); efp) {
		float inverse_size           = 1.f / static_cast<float>(size);
		float inverse_z_size         = 1.f / static_cast<float>(grid_size);
		float inverse_container_size = 1.f / static_cast<float>(container_size);
		float half_texel             = inverse_container_size / 2.f;
		efp.set_float4(inverse_size, inverse_z_size, inverse_container_size, half_texel);
	}

	if (streamfx::obs::gs::effect_parameter efp = effect->get_parameter("lut"); efp) {
		efp.set_texture(lut);
	}

	return effect;
}

void streamfx::gfx::lut::consumer::consume(streamfx::gfx::lut::color_depth depth, std::shared_ptr<streamfx::obs::gs::texture> lut, std::shared_ptr<streamfx::obs::gs::texture> texture)
{
	auto gctx = streamfx::obs::gs::context();

	auto effect = prepare(depth, lut);

	if (streamfx::obs::gs::effect_parameter efp = effect->get_parameter("image"); efp) {
		efp.set_texture(texture->get_object());
	}

	// Draw a simple quad.
	while (gs_effect_loop(effect->get_object(), "Draw")) {
		gs_draw_sprite(nullptr, 0, 1, 1);
	}
}
