// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2019-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "gfx/gfx-mipmapper.hpp"
#include "gfx/lut/gfx-lut-consumer.hpp"
#include "gfx/lut/gfx-lut-producer.hpp"
#include "gfx/lut/gfx-lut.hpp"
#include "obs/gs/gs-rendertarget.hpp"
#include "obs/gs/gs-texture.hpp"
#include "obs/gs/gs-vertexbuffer.hpp"
#include "obs/obs-source-factory.hpp"
#include "plugin.hpp"

#include "warning-disable.hpp"
#include <vector>
#include "warning-enable.hpp"

namespace streamfx::filter::color_grade {
	enum class detection_mode {
		HSV,
		HSL,
		YUV_SDR,
	};

	enum class luma_mode {
		Linear,
		Exp,
		Exp2,
		Log,
		Log10,
	};

	class color_grade_instance : public obs::source_instance {
		streamfx::obs::gs::effect            _effect;
		std::shared_ptr<streamfx::gfx::util> _gfx_util;

		// User Configuration
		vec4                            _lift;
		vec4                            _gamma;
		vec4                            _gain;
		vec4                            _offset;
		detection_mode                  _tint_detection;
		luma_mode                       _tint_luma;
		float                         _tint_exponent;
		vec3                            _tint_low;
		vec3                            _tint_mid;
		vec3                            _tint_hig;
		vec4                            _correction;
		bool                            _lut_enabled;
		streamfx::gfx::lut::color_depth _lut_depth;

		// Capture Cache
		std::shared_ptr<streamfx::obs::gs::rendertarget> _ccache_rt;
		std::shared_ptr<streamfx::obs::gs::texture>      _ccache_texture;
		bool                                             _ccache_fresh;

		// LUT work flow
		bool                                             _lut_initialized;
		bool                                             _lut_dirty;
		std::shared_ptr<streamfx::gfx::lut::producer>    _lut_producer;
		std::shared_ptr<streamfx::gfx::lut::consumer>    _lut_consumer;
		std::shared_ptr<streamfx::obs::gs::rendertarget> _lut_rt;
		std::shared_ptr<streamfx::obs::gs::texture>      _lut_texture;

		// Render Cache
		std::shared_ptr<streamfx::obs::gs::rendertarget> _cache_rt;
		std::shared_ptr<streamfx::obs::gs::texture>      _cache_texture;
		bool                                             _cache_fresh;

		public:
		color_grade_instance(obs_data_t* data, obs_source_t* self);
		virtual ~color_grade_instance();

		void allocate_rendertarget(gs_color_format format);

		virtual void load(obs_data_t* data) override;
		virtual void migrate(obs_data_t* data, uint64_t version) override;
		virtual void update(obs_data_t* data) override;

		void prepare_effect();

		void rebuild_lut();

		virtual void video_tick(float time) override;
		virtual void video_render(gs_effect_t* effect) override;
	};

	class color_grade_factory : public obs::source_factory<filter::color_grade::color_grade_factory, filter::color_grade::color_grade_instance> {
		public:
		color_grade_factory();
		virtual ~color_grade_factory();

		virtual const char* get_name() override;

		virtual void get_defaults2(obs_data_t* data) override;

		virtual obs_properties_t* get_properties2(color_grade_instance* data) override;

		static bool on_manual_open(obs_properties_t* props, obs_property_t* property, void* data);

		public: // Singleton
		static std::shared_ptr<color_grade_factory> instance();
	};
} // namespace streamfx::filter::color_grade
