// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2017-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "common.hpp"
#include "gfx/blur/gfx-blur-base.hpp"
#include "gfx/gfx-source-texture.hpp"
#include "gfx/gfx-util.hpp"
#include "obs/gs/gs-effect.hpp"
#include "obs/gs/gs-helper.hpp"
#include "obs/gs/gs-rendertarget.hpp"
#include "obs/gs/gs-texture.hpp"
#include "obs/obs-source-factory.hpp"

#include "warning-disable.hpp"
#include <chrono>
#include <functional>
#include <list>
#include <map>
#include "warning-enable.hpp"

namespace streamfx::filter::blur {
	enum class mask_type : int64_t {
		Region,
		Image,
		Source,
	};

	class blur_instance : public obs::source_instance {
		// Effects
		streamfx::obs::gs::effect            _effect_mask;
		std::shared_ptr<streamfx::gfx::util> _gfx_util;

		// Input
		std::shared_ptr<streamfx::obs::gs::rendertarget> _source_rt;
		std::shared_ptr<streamfx::obs::gs::texture>      _source_texture;
		bool                                             _source_rendered;

		// Rendering
		std::shared_ptr<streamfx::obs::gs::texture>      _output_texture;
		std::shared_ptr<streamfx::obs::gs::rendertarget> _output_rt;
		bool                                             _output_rendered;

		// Blur
		std::shared_ptr<::streamfx::gfx::blur::base> _blur;
		double_t                                     _blur_size;
		double_t                                     _blur_angle;
		std::pair<double_t, double_t>                _blur_center;
		bool                                         _blur_step_scaling;
		std::pair<double_t, double_t>                _blur_step_scale;

		// Masking
		struct {
			bool      enabled;
			mask_type type;
			struct {
				float left;
				float top;
				float right;
				float bottom;
				float feather;
				float feather_shift;
				bool    invert;
			} region;
			struct {
				std::string                                 path;
				std::string                                 path_old;
				std::shared_ptr<streamfx::obs::gs::texture> texture;
			} image;
			struct {
				std::string                                    name_old;
				std::string                                    name;
				bool                                           is_scene;
				std::shared_ptr<streamfx::gfx::source_texture> source_texture;
				std::shared_ptr<streamfx::obs::gs::texture>    texture;
			} source;
			struct {
				float r;
				float g;
				float b;
				float a;
			} color;
			float multiplier;
		} _mask;

		public:
		blur_instance(obs_data_t* settings, obs_source_t* self);
		~blur_instance();

		public:
		virtual void load(obs_data_t* settings) override;
		virtual void migrate(obs_data_t* settings, uint64_t version) override;
		virtual void update(obs_data_t* settings) override;

		virtual void video_tick(float time) override;
		virtual void video_render(gs_effect_t* effect) override;

		private:
		bool apply_mask_parameters(streamfx::obs::gs::effect effect, gs_texture_t* original_texture, gs_texture_t* blurred_texture);
	};

	class blur_factory : public obs::source_factory<filter::blur::blur_factory, filter::blur::blur_instance> {
		std::vector<std::string> _translation_cache;

		public:
		blur_factory();
		virtual ~blur_factory();

		virtual const char* get_name() override;

		virtual void get_defaults2(obs_data_t* settings) override;

		virtual obs_properties_t* get_properties2(filter::blur::blur_instance* data) override;

		std::string translate_string(const char* format, ...);

		static bool on_manual_open(obs_properties_t* props, obs_property_t* property, void* data);

		public: // Singleton
		static std::shared_ptr<blur_factory> instance();
	};
} // namespace streamfx::filter::blur
