﻿$(document).ready(function () {
    var iCms = 1000;
    var iMms = 60 * iCms;
    var iHms = 3600 * iCms;
    var iDms = 24 * 3600 * iCms;

    jQuery.fn.anim_progressbar = function (aOptions) {
        // def values

        // def options
        var aDefOpts = {
            start: new Date(), // now
            finish: new Date().setTime(new Date().getTime() + 60 * iCms), // now + 60 sec
            interval: 100,
            progress: 0,
            leftms: 0
        }
        var aOpts = jQuery.extend(aDefOpts, aOptions);
        var vPb = this;
        var setProgressbar;
        // each progress bar
        this.each(
            function () {
                var iDuration = aOpts.finish - aOpts.start;

                // calling original progressbar
                $(vPb).children('.pbar').progressbar();
                // looping process

                setProgressbar = function (s, p, m) {
                    var iLeftMs = s; // left time in MS
                    var iPerc = p; // percentages

                    var iDays = parseInt(iLeftMs / iDms) // elapsed days
                    var iHours = parseInt((iLeftMs - (iDays * iDms)) / iHms) // elapsed hours
                    var iMin = parseInt((iLeftMs - (iDays * iDms) - (iHours * iHms)) / iMms) // elapsed minutes
                    var iSec = parseInt((iLeftMs - (iDays * iDms) - (iMin * iMms) - (iHours * iHms)) / iCms) // elapsed seconds


                    // display current positions and progress
                    $(vPb).children('.percent').html('<b>' + iPerc.toFixed(1) + '%</b>');
                    $(vPb).children('.elapsed').html("剩余时间:" + iDays + ' 天' + iHours + '时' + iMin + '分' + iSec + '秒</b>');
                    $(vPb).children('.pbar').children('.ui-progressbar-value').css('width', iPerc + '%');
                    $(vPb).children('.message').html(m);
                    // in case of Finish
                    if (iPerc >= 100) {
                        $(vPb).children('.percent').html('<b>100%</b>');
                        $(vPb).children('.elapsed').html('完成');
                    }
                }

            }

        );
        return setProgressbar;
    }
    var PublishStatus;
    VW.AjaxPost("InitPublish", function (r) {
        if (r.type) {
            setProgressbar = $("#progress1").anim_progressbar();
            var Pool = setInterval(function () {
                VW.AjaxPost("Pool", function (r) {


                    if (r.status == 0) {
                        setProgressbar(r.s, r.p, r.m + "<br/>" + r.msg);

                        $("#ExtTime").html(r.ms);
                        PublishStatus = false;
                    }
                    else if (r.status == 1) {
                        setProgressbar(0, 100, r.m + "<br/>生成完成,单击 \'取消\' 返回。");
                        clearInterval(Pool);

                        PublishStatus = true;
                    }
                    else if (r.status == 2) {
                        setProgressbar(0, 0, r.m + "<br/><span style='color:red'>出错:" + r.msg + "</span>");
                        clearInterval(Pool);
                        PublishStatus = true;
                    }

                })
            }, 1000);
        }
        else {
            location.href = "PublishSite.aspx";
        }
    })


});
