#pragma once

#include <Engine/Light/Light.h>
#include <Basic/Sampler/AliasMethod.h>

namespace Ubpa {
	class Image;

	class InfiniteAreaLight : public Light {
	public:
		InfiniteAreaLight(Ptr<Image> img, const rgbf& colorFactor = rgbf(1.f), float intensity = 1.f)
			: colorFactor(colorFactor), intensity(intensity) {
			SetImg(img);
		}

	public:
		static const Ptr<InfiniteAreaLight> New(Ptr<Image> img, const rgbf& colorFactor = rgbf(1.f), float intensity = 1.f) {
			return Ubpa::New<InfiniteAreaLight>(img, colorFactor, intensity);
		}

	public:
		const PtrC<Image> GetImg() const { return img; }
		void SetImg(Ptr<Image> img);

	public:
		//  L 
		// !!! pwi ڹԴռ
		// @arg0  in p  distToLight  PD
		// @arg1 outwi ָԴΪλ
		// @arg2 outp 㵽Դľ
		// @arg3 outܶ probability density
		virtual const rgbf Sample_L(const pointf3& p, normalf& wi, float& distToLight, float& PD) const override;

		// ܶȺ
		// !!! pwi ڵƵռ
		virtual float PDF(const pointf3& p, const normalf& wi) const override;

		virtual bool IsDelta() const override { return false; }

		// Щûлκߵ
		virtual const rgbf Le(const Ray& ray) const override;

	private:
		const rgbf GetColor(const pointf2& texcoord) const;

	public:
		rgbf colorFactor;
		float intensity;

	private:
		Ptr<Image> img;
		AliasMethod aliasMethod;
	};
}
