#pragma once

#include <Engine/Light/Light.h>

namespace Ubpa {
	// 
	class DiskLight : public Light {
	public:
		DiskLight(const rgbf& color = 1.f, float intensity = 1.f, float radius = 1.f)
			: color(color), intensity(intensity), radius(radius) { }

	public:
		static const Ptr<DiskLight> New(const rgbf& color = 1.f, float intensity = 1.f, float radius = 1.f) {
			return Ubpa::New<DiskLight>(color, intensity, radius);
		}

	protected:
		virtual ~DiskLight() = default;

	public:
		float Area() const { return PI<float> * radius * radius; }
		const rgbf LuminancePower() const { return intensity * color; }
		const rgbf Luminance() const { return LuminancePower() / (Area() * PI<float>); }

	public:
		//  L 
		// !!! pwi ڹԴռ
		// @arg0  in p  distToLight  PD
		// @arg1 outwi ָԴΪλ
		// @arg2 outp 㵽Դľ
		// @arg3 outܶ probability density
		virtual const rgbf Sample_L(const pointf3& p, normalf& wi, float& distToLight, float& PD) const override;

		// ܶȺ
		// !!! pwi ڵƵռ
		virtual float PDF(const pointf3& p, const normalf& wi) const override;

		virtual bool IsDelta() const override { return false; }

	public:
		rgbf color;
		float intensity;
		float radius;
	};
}
