#pragma once

#include <Engine/Light/Light.h>

namespace Ubpa {
	// ֲϵУ -y
	class DirectionalLight : public Light {
	public:
		DirectionalLight(const rgbf& color = rgbf(1.f), float intensity = 1.0f)
			: color(color), intensity(intensity) { }

	public:
		static const Ptr<DirectionalLight> New(const rgbf& color = rgbf(1.f), float intensity = 1.0f) {
			return Ubpa::New<DirectionalLight>(color, intensity);
		}

	protected:
		virtual ~DirectionalLight() = default;

	public:
		//  L 
		// !!! pwi ڹԴռ
		// @arg0  in p  distToLight  PD
		// @arg1 outwi ָԴΪλ
		// @arg2 outp 㵽Դľ
		// @arg3 outܶ probability density
		virtual const rgbf Sample_L(const pointf3& p, normalf& wi, float& distToLight, float& PD) const override;

		// ܶȺ
		// !!! pwi ڵƵռ
		virtual float PDF(const pointf3& p, const normalf& wi) const override { return 0.f; }

		virtual bool IsDelta() const override { return true; }

	public:
		rgbf color;
		float intensity;
	};
}
