using System.Diagnostics.CodeAnalysis;

namespace YoutubeExplode.Videos.ClosedCaptions;

/// <summary>
/// Metadata associated with a closed caption track of a YouTube video.
/// </summary>
public class ClosedCaptionTrackInfo(string url, Language language, bool isAutoGenerated)
{
    /// <summary>
    /// Track URL.
    /// </summary>
    public string Url { get; } = url;

    /// <summary>
    /// Track language.
    /// </summary>
    public Language Language { get; } = language;

    /// <summary>
    /// Whether the track was automatically generated.
    /// </summary>
    public bool IsAutoGenerated { get; } = isAutoGenerated;

    /// <inheritdoc />
    [ExcludeFromCodeCoverage]
    public override string ToString() => $"CC Track ({Language})";
}
