# Orb

<p align="center">
  <img width="100" src="https://i.imgur.com/EN1OWqc.png">
</p>

<p align="center">"Let your task orbit!"</p>

## 🪐Description

Orb is an easy-to-use task manager app that help you manage your daily struggles to get your things done effortlessly with minimal and modern UI, which is one of the winners for Google DevFest 2021! Let's send your tasks back to their orbits!

<img src="https://github.com/TomHuynhSG/flutter_project_devfest/blob/main/screenshots/main_white_empty.png?raw=true" width="230" > <img src="https://github.com/TomHuynhSG/flutter_project_devfest/blob/main/screenshots/main_black_empty.png?raw=true" width="230" >

## 📱 Download the latest release

Click here to download the APK file to install on your phone:
\
[![Latest release](https://img.shields.io/github/v/release/TomHuynhSG/flutter_project_devfest.svg)](https://github.com/TomHuynhSG/flutter_project_devfest/releases/latest)

## 🔧 Current Functionality

Orb have these following features:
- Dark/Light theme
- Scrollable calendar match with your time zone
- Allow adding multiple tasks daily include title, note, date, start/end time, and tab color 
- Pop up notification to notify start/end time
- Mark tasks as TODO/Complete
- Delete tasks

## 🌟 Screenshots



### App Overview


<table>
  <tr>
    <td>White Mode</td>
     <td>Dark Mode</td>
  </tr>
  <tr>
    <td><img src="https://github.com/TomHuynhSG/flutter_project_devfest/blob/main/screenshots/main_white_full.png?raw=true" width="230"></td>
    <td><img src="https://github.com/TomHuynhSG/flutter_project_devfest/blob/main/screenshots/main_black_full.png?raw=true" width="230"></td>
   </tr>

 </table>


### Add Task with Beautiful UI
<table>
  <tr>
    <td>Time UI</td>
     <td>Form for Task Creation</td>
     <td>Calendar UI</td>
  </tr>
  <tr>
    <td><img src="https://github.com/TomHuynhSG/flutter_project_devfest/blob/main/screenshots/clock_ui.png?raw=true" width="230"></td>
    <td><img src="https://github.com/TomHuynhSG/flutter_project_devfest/blob/main/screenshots/form_ui.png?raw=true" width="230"></td>
    <td><img src="https://github.com/TomHuynhSG/flutter_project_devfest/blob/main/screenshots/calendar_ui.png?raw=true" width="230"></td>
   </tr>

 </table>


### Notification for Start Date and End Date



<table>
  <tr>
    <td>Notification Pop-up</td>
     <td>Notification Message</td>
  </tr>
  <tr>
    <td><img src="https://github.com/TomHuynhSG/flutter_project_devfest/blob/main/screenshots/noti.png?raw=true" width="300"></td>
    <td><img src="https://github.com/TomHuynhSG/flutter_project_devfest/blob/main/screenshots/noti_message.png?raw=true" width="300"></td>
   </tr>
 </table>


### Live Demo (Animation GIF)

<table>
  <tr>
    <td>Filtering by Day</td>
     <td>Mark "Completed" or Delete Task</td>
     <td>Full Live Demo for all features</td>
  </tr>
  <tr>
    <td><img src="https://github.com/TomHuynhSG/flutter_project_devfest/blob/main/screenshots/one-click-filtering.gif?raw=true" width="230"></td>
    <td><img src="https://github.com/TomHuynhSG/flutter_project_devfest/blob/main/screenshots/complete-delete.gif?raw=true" width="230"></td>
    <td><img src="https://github.com/TomHuynhSG/flutter_project_devfest/blob/main/screenshots/live-demo.gif?raw=true" width="230"></td>
   </tr>

 </table>



## 🔮Next Steps
- Add sign-up/log-in page → enhance security & privacy 
- Customize profile page → personalized experience 
- Repeat-tasks → save time for daily tasks 
- Visualize task completion → induce sense of accomplishment 
- Integrate with Budget Management → one-stop personal application

## 🔩 Build & Run App

- Make sure get important libraries from pubspec.yaml
```
flutter pub get
```

- Run the flutter app with target deployment (Web Browser, Android, iOS)
```
flutter run --no-sound-null-safety
```

## ⚙️ Architecture

<img src="https://github.com/TomHuynhSG/flutter_project_devfest/blob/main/screenshots/architecture.png?raw=true" width="900">

## 🏆 DevFest Team
- Huynh Nguyen Minh Thong (Tom Huynh) - tomhuynhsg@gmail.com
- Do Minh Nguyet - dominhnguyet435382@gmail.com
- Vu Lam Chi Tai - duhkyv@gmail.com
- Do Tuan Kiet - huyhoang661966@gmail.com

With the help of the mentor Vu Tuan Minh - vtminh1805@gmail.com 👏
