import requests
from bs4 import BeautifulSoup

def get_song_info(url):
    headers = {'User-Agent': 'Mozilla/5.0'}
    response = requests.get(url, headers=headers)
    soup = BeautifulSoup(response.content, 'html.parser')
    meta_tags = soup.find_all('meta')

    song_info = {}

    for tag in meta_tags:
        if tag.get('property') == 'og:title':
            song_info['title'] = tag.get('content')
        if tag.get('property') == 'og:description':
            song_info['artist'] = tag.get('content').split('·')[0].strip()

    return song_info

spotify_links = [
    'https://open.spotify.com/track/1zBsc3zoU1jvy1dfQzFIOC',
    'https://open.spotify.com/track/47PUM9NSxvRJ1XUcXPCzD4',
    'https://open.spotify.com/track/3YLOLG3mAWFlC68D2DseZx',
    'https://open.spotify.com/track/0fE1NThblS3w2eVu13XY31',
    'https://open.spotify.com/track/7JbjBjqG12G2quhtnWXpZu',
    'https://open.spotify.com/track/3ktye8UiJXiXHbp1Elonn6',
    'https://open.spotify.com/track/6d4coUq41pMGtHBs73Mf3b',
    'https://open.spotify.com/track/1Ru8cW0XGfQjMU9hQW2Uts',
    'https://open.spotify.com/track/6aRJzglSuMYPGuPW9k858r',
    'https://open.spotify.com/track/3hDJ0aEqeywrwGrr0Q3GZV',
    'https://open.spotify.com/track/5ocsuTmgDCOybBdRThm6Uz',
    'https://open.spotify.com/track/3tZPe40hyxBk8AeoU1zSzc',
    'https://open.spotify.com/track/3Q211SgoRM8zMmGV35IaIN',
    'https://open.spotify.com/track/5vEwxJt60nbmz3VYdIpdeM',
    'https://open.spotify.com/track/1c6j6uYwk6DwuqwFAzetz2',
    'https://open.spotify.com/track/70TfoTiUn1aZt29k8mDsGL',
    'https://open.spotify.com/track/6NFkRvsPlBOiAGDIJitlUF',
    'https://open.spotify.com/track/1KVLRGGMh973EPZ4WaqDtN',
    'https://open.spotify.com/track/4lYBePQ9GrpuOmNB3QhSmm',
    'https://open.spotify.com/track/6ZRxnIHvjN0qTVRwz3PLtO',
    'https://open.spotify.com/track/4XLnSuK31qAj6Povuy7oqE',
    'https://open.spotify.com/track/07J28hVvFyaXnmUe7UtkVt',
    'https://open.spotify.com/track/5weWmMBapNLTqbgJvim0op',
    'https://open.spotify.com/track/4FULAlQuDeDlv1FidteGv0',
    'https://open.spotify.com/track/00SmB7n85SKROGjybsyq5i',
    'https://open.spotify.com/track/0tZFL2LU8XSThRttMJif6Q',
    'https://open.spotify.com/track/6GHSAsG90unrc5tTguNj4f',
    'https://open.spotify.com/track/2iEtBVmz1N2XSLYD7Dsszv',
    'https://open.spotify.com/track/3qfzns5jryamL2L8oiZKJS',
    'https://open.spotify.com/track/6Np4hDkD8SqfFOmUhE6wdP',
    'https://open.spotify.com/track/11vTDizUttoqwZofrMDj2H',
    'https://open.spotify.com/track/1lK8OlJuuoVsGHsWaKFAfk',
    'https://open.spotify.com/track/7tvHJ3UIPGFCsD8VAgLI6V',
    'https://open.spotify.com/track/4NQ4fDehLC8QRTts4jXaYP',
    'https://open.spotify.com/track/6AGv4MOcVWwmBZLdfiUBq4',
    'https://open.spotify.com/track/5ebmgjX1AIlMPXmAvmxfoH',
    'https://open.spotify.com/track/4fuPFCrsnZ85emMfL52CKp',
    'https://open.spotify.com/track/4SIbeP1KWMPARskNh50Qs3',
    'https://open.spotify.com/track/0y9DZYjvqGQWXkObv6RMDa',
    'https://open.spotify.com/track/1wPZSxai0IQWb3eB0iabbH',
    'https://open.spotify.com/track/0PbSQnADc9tMBsWduwDCId',
    'https://open.spotify.com/track/2H7F7EfsVhy0jNLsVz8MLH',
    'https://open.spotify.com/track/25AvaE23MXl06YRtQcQoJS',
    'https://open.spotify.com/track/47emsK4Cj4dMqctYq18U03',
    'https://open.spotify.com/track/1r9xUipOqoNwggBpENDsvJ',
    'https://open.spotify.com/track/6R8XyDz1qxH8C8bd31sEvh',
    'https://open.spotify.com/track/6xXaVjXPv6aR6PhQjn7jTN',
    'https://open.spotify.com/track/050E99Wa4bvpUbHVz62KHU',
    'https://open.spotify.com/track/5XRdRWNdYCnkLAJ7qgJpt9',
    'https://open.spotify.com/track/0O8k8aChBTHLOBaYyHmz8m',
    'https://open.spotify.com/track/4bP40g2ZJWN9P2aVtf1hJx',
    'https://open.spotify.com/track/6FuGdbjGbdd6dRdDytiTdP',
    'https://open.spotify.com/track/1r6c5dGV2MQmRmSyDpE5lG',
    'https://open.spotify.com/track/2eM9vj5So8nwcIU0snJ9bc',
    'https://open.spotify.com/track/76dNOoLlSuNBxlSbACB9nJ',
    'https://open.spotify.com/track/4z4lmHZnpBsfmc5Bgg7pGN',
    'https://open.spotify.com/track/548fnL6dPKkGu4mJN5Gv4N',
    'https://open.spotify.com/track/5Wvsg0WKBqKGgEMp0tBl2q',
    'https://open.spotify.com/track/6b2LfMeveQB16SGFWQNWiz',
    'https://open.spotify.com/track/51q75hNecOooZoFdON9GOh',
    'https://open.spotify.com/track/2zhU8YyptZfeDDq3ShGaV4',
    'https://open.spotify.com/track/6t4bBWQyoEpAHvQIFzf2X5',
    'https://open.spotify.com/track/1jydxp59Sa8bcxUVXKn5QR',
    'https://open.spotify.com/track/4HmqqOpqk1IMyMvsrSciQa',
    'https://open.spotify.com/track/66KQWFfSsw8t2DYhS99ff9',
    'https://open.spotify.com/track/4x2Usqp6IeIR4v2EqHXKog',
    'https://open.spotify.com/track/2Qwp9Gjnwq7wnMTQKrWXWD',
    'https://open.spotify.com/track/4jgC4WgHinXg5dXGWfbNJr',
    'https://open.spotify.com/track/6wUuajhXFPwYg2hLW5jaIv',
    'https://open.spotify.com/track/18jMAFCSHUa8HOtwDe28vI',
    'https://open.spotify.com/track/2TNDvSljAu4Rjh9iM3VTcf',
    'https://open.spotify.com/track/4Cadk17BZse20uegkkIXFR',
    'https://open.spotify.com/track/18MlLrfCkYOnKutil99GwY',
    'https://open.spotify.com/track/7mfvOqsvzZaUl7sfbcNk4E',
    'https://open.spotify.com/track/4EFb9FhLyFiDbYKwBwDZre',
    'https://open.spotify.com/track/3iXNlPQNYPrtimAEM49PsG',
    'https://open.spotify.com/track/1bFgMkoazsyZGSflpCzYm6',
    'https://open.spotify.com/track/386ZcoJUhpxqunqXipLapD',
    'https://open.spotify.com/track/228BxWXUYQPJrJYHDLOHkj',
    'https://open.spotify.com/track/235UDSE1c89C1Ok3XZiHeb',
    'https://open.spotify.com/track/4sb468VjjFqLKE81zH5cCM',
    'https://open.spotify.com/track/6VVsGgrp0iLykPKKwDIyAX',
    'https://open.spotify.com/track/2kOX1YmJcVJeShkPRo8TwB',
    'https://open.spotify.com/track/0Zy1tSVAQ8pIugxsEbeAar',
    'https://open.spotify.com/track/3W0pgUJ5MhTj5ma6XBz4Wh',
    'https://open.spotify.com/track/7o4i6eiHjZqbASnSy3pKAq',
    'https://open.spotify.com/track/2GPIAfzDdgLv1UKC6afaCn',
    'https://open.spotify.com/track/1GZXikoTxtTJuTtcwJRpfX',
    'https://open.spotify.com/track/4Jgo6KqKxn6qVkuuwjIK3t',
    'https://open.spotify.com/track/6gjgrFqd11MIDNJZxdHmvk',
    'https://open.spotify.com/track/7E2fEfqeaxPA9vcCHemhrg',
    'https://open.spotify.com/track/20GP6sMY9DOPFu2iKJafTG',
    'https://open.spotify.com/track/1sODGZcJRit5E9OzeMovjL',
    'https://open.spotify.com/track/2sOR0wjCKhsZCqdsYqVOdH',
    'https://open.spotify.com/track/4rqrN39GovnGtscW6q9SBr',
    'https://open.spotify.com/track/1mfGkZuwd1ocZYBKJCFEFx',
    'https://open.spotify.com/track/1neVIZzrSxqJQGXtrJmgzQ',
    'https://open.spotify.com/track/5IxgfJpcb54erxdn4o4aeb',
    'https://open.spotify.com/track/0w8hlwwLqFZrqOPyipvMQC',
    'https://open.spotify.com/track/3WW5HlIlGtnRX7h0OjWH9i',
    'https://open.spotify.com/track/6FKPPNjMFEekgUfy5v838t',
    'https://open.spotify.com/track/1J03Vp93ybKIxfzYI4YJtL',
    'https://open.spotify.com/track/6ZT36tXEKY2vvTCuNK4fi1',
    'https://open.spotify.com/track/3aiGshuqYhdBBBhHqRf6jn',
    'https://open.spotify.com/track/2JECanW48F4VC3ik2tn1rj',
    'https://open.spotify.com/track/2lTg05dfPVSLZAcyM5veiF',
    'https://open.spotify.com/track/6arBmB6pDSG4zSJSZe5wMf',
    'https://open.spotify.com/track/1qzPZrJNGO3PNWjmSTZVZW',
    'https://open.spotify.com/track/75Zw4VByNfabLgBDWFfqgf',
    'https://open.spotify.com/track/5I5VGPnzKAloFZMwkNVr2u',
    'https://open.spotify.com/track/3JNON1jA3viabGmUDiMoHw',
    'https://open.spotify.com/track/0BnYI0cKJ5swDRNWYVJvxg',
    'https://open.spotify.com/track/12jnnXbCDmbGsdTyfkCh5r',
    'https://open.spotify.com/track/7wvgUMPQV7jZugQoWKl07d',
    'https://open.spotify.com/track/4sGTEtCCf43jR5QtvYY2Yf',
    'https://open.spotify.com/track/2JsHzQPt9Xo07ApvilvdpZ',
    'https://open.spotify.com/track/5rpLPal82U3JYr6YAAe7rC',
    'https://open.spotify.com/track/5Pophj3JaLq2Xzm7ncXgbF',
    'https://open.spotify.com/track/45gdJm5UPBR1zQWVuK50eJ',
    'https://open.spotify.com/track/3jwao2PsCBAJZzpoic33yW',
    'https://open.spotify.com/track/7pheKiMA7iqlIVRTbUEOCm',
    'https://open.spotify.com/track/6A3LllKRvquXxypzjVWLPc',
    'https://open.spotify.com/track/5M1F51adBArusOE0wwDn5z',
    'https://open.spotify.com/track/4QntHiDb5tbfZAJRSK1diV',
    'https://open.spotify.com/track/1lK8NqeweU3yKJq8ql05gu',
    'https://open.spotify.com/track/4QSvuuCVqoXMKkkTuCuz6H',
    'https://open.spotify.com/track/1oT0X4ha0449NBqsNJUne8',
    'https://open.spotify.com/track/6Qm7amP8b2hBwuvjMIhCy0',
    'https://open.spotify.com/track/6C3CuWoCoYELcX1aQGqC9V',
    'https://open.spotify.com/track/3wwiBsma2wPAJ769kN7k3r',
    'https://open.spotify.com/track/3vbApNPrKa8HhvGVT6tk8E',
    'https://open.spotify.com/track/2riGfIdTac01gA3eDJimm2',
    'https://open.spotify.com/track/51J5JMRlIMKLMiickkZSoE',
    'https://open.spotify.com/track/1l80Li3fe6slAbdQCz0244',
    'https://open.spotify.com/track/6MX1EcqEJ4bDTnnEAPlSkf',
    'https://open.spotify.com/track/7fM83SPoZ8rM23vfUg6Rsx',
    'https://open.spotify.com/track/7xNYm6SHFQ2WKKA0gFZ7NA',
    'https://open.spotify.com/track/4A6yDPK2585YJUoaw32mhi',
    'https://open.spotify.com/track/0Ygf9Erqojr3ciuyvljKMO',
    'https://open.spotify.com/track/2rjPF6L9EndsFYmiIGch3e',
    'https://open.spotify.com/track/46hiSBPOv7m4xspNdlolu2',
    'https://open.spotify.com/track/086iznqzaVOAmuYMYyjUpn',
    'https://open.spotify.com/track/1FvpCfgRi97XvYeBagkPtj',
    'https://open.spotify.com/track/1VG0eIPOPzkfJC8C14tlcY',
    'https://open.spotify.com/track/2PgK8gUqh6liIimyMoOnmV',
    'https://open.spotify.com/track/6mGP1LAOLKTUcu1TpAF8vy',
    'https://open.spotify.com/track/6yT55ng9U6fKqz4z9ktee5',
    'https://open.spotify.com/track/17WANCKUj56nZ9gPC9MlnY',
    'https://open.spotify.com/track/0GTuwDHbDTycaxkCQC3Rs1',
    'https://open.spotify.com/track/503uL29FoEuFHyn6YLBV5g',
    'https://open.spotify.com/track/3Oeej1fmZiwJGpaPdoPQt2',
    'https://open.spotify.com/track/7M0hyrLQddwoVRazGU2yOI',
    'https://open.spotify.com/track/4zlL6i5F0qUBksxUTzn5Ox',
    'https://open.spotify.com/track/7HRGTTn0QJcpfB89dBfWIX',
    'https://open.spotify.com/track/4eE4vEaakr3ZnSt1UNfOhz',
    'https://open.spotify.com/track/2yKkdk4UIm43wIJ4UafFe5',
    'https://open.spotify.com/track/3WTSVuJewaXTakNZlSiIMx',
    'https://open.spotify.com/track/3QAT6LyaUbAbH5Az3PrzyX',
    'https://open.spotify.com/track/6CMjaUiyl7WLPop2AoLbn6',
    'https://open.spotify.com/track/2S3M2ZRJT6jnMUQQ4AvlDZ',
    'https://open.spotify.com/track/6ZZAWyuSScJwOMBXPDNa2Y',
    'https://open.spotify.com/track/4MjGxmNJ1CdBDbxtmZiw1y',
    'https://open.spotify.com/track/0kIjR1w6Pwef6NYU0RS5dc',
    'https://open.spotify.com/track/5p8II7VY2RD1Gh1li3ZlBr',
    'https://open.spotify.com/track/1rZwpn0SCg7dBkOJjUuJwI',
    'https://open.spotify.com/track/24bvqiohlG5cgd19sFsmwp',
    'https://open.spotify.com/track/7LJvsAgcXm3ul6xR72rUBs',
    'https://open.spotify.com/track/4CKak8FDfpm5nA9DZstUj6',
    'https://open.spotify.com/track/71xw9CaZJ6EHfMOHaSS45K',
    'https://open.spotify.com/track/5XyO0Fr068soEkVfyuqINg',
    'https://open.spotify.com/track/4s5zfEwFuufmA9KLDHF8ft',
    'https://open.spotify.com/track/42gNEPDnzXNifjpE1lmlr3',
    'https://open.spotify.com/track/7CaQbeNAccfyQrBQqu8X64',
    'https://open.spotify.com/track/2c6mb0DBzGcJgO0hzwOtyr',
    'https://open.spotify.com/track/3syzfIcScm1XsjcF9q1KIk',
    'https://open.spotify.com/track/6JWFUNMpaaPWnOHovjOPiL',
    'https://open.spotify.com/track/0gcnebcEyowLhpFHQnIMkZ',
    'https://open.spotify.com/track/0wXbZ4QuBANkUfmLQc6d3U',
    'https://open.spotify.com/track/1JuR8Kt9DEhVK9EQEHI1Gk',
    'https://open.spotify.com/track/1Gw1WC1uZUCsQsWJ3PoFDL',
    'https://open.spotify.com/track/0huW9xnNCv4Mge6aohKzE1',
    'https://open.spotify.com/track/065lRX1Ddb5m24s4Auhp8L',
    'https://open.spotify.com/track/4v5fqaJGR38Ir6MT93bXgz',
    'https://open.spotify.com/track/0XWYwWCDwYO2dYmG3EqkW6',
    'https://open.spotify.com/track/1KX9IytHStLf1YCaBUqB22',
    'https://open.spotify.com/track/0M6lfckrMvgq8tJm9rAfBd',
    'https://open.spotify.com/track/2tnlbHftCXW3CIWGJZLgw5',
    'https://open.spotify.com/track/4MbSDqFx603RDKi3MSYeL0',
    'https://open.spotify.com/track/2CHz3QplSkD6pkMuDlBwGA',
    'https://open.spotify.com/track/3mO4c7lqY78SjDkWXE4cp3',
    'https://open.spotify.com/track/0ULvXwvXirxbzArIddWCDY',
    'https://open.spotify.com/track/6qKOpuXoO9sZs9GA6y7FaQ'
]

for link in spotify_links:
    info = get_song_info(link)
    print(f"{info['artist']} - {info['title']}")
