/*
* CanvasXpress 7.8 - JavaScript Canvas Library
*
* Copyright (c) 2009-2013 Isaac Neuhaus
*
* imnphd@gmail.com
*
*
* Redistributions of this source code must retain this copyright
* notice and the following disclaimer.
*
* CanvasXpress is licensed under the terms of the Open Source
* GPL version 3.0 license.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Commercial use may be granted to the extent that this source code
* does NOT become part of any other Open Source or Commercially licensed
* development library or toolkit without explicit permission.
*
* Network graphs were implemented based on the HeyGraph by Tom Martin
* <http://www.heychinaski.com>.
*
* Thanks to Mingyi Liu for his contributions with the Ext-JS panel and
* network graphs and Charles Tilford for his input to the Genome Browser.
*
*/

function str_repeat(b,a){for(var c=[];a>0;c[--a]=b){}return(c.join(""))}function sprintf(){var g=0,e,h=arguments[g++],k=[],d,j,l,b;while(h){if(d=/^[^\x25]+/.exec(h)){k.push(d[0])}else{if(d=/^\x25{2}/.exec(h)){k.push("%")}else{if(d=/^\x25(?:(\d+)\$)?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-fosuxX])/.exec(h)){if(((e=arguments[d[1]||g++])==null)||(e==undefined)){throw ("Too few arguments.")}if(/[^s]/.test(d[7])&&(typeof(e)!="number")){throw ("Expecting number but found "+typeof(e))}switch(d[7]){case"b":e=e.toString(2);break;case"c":e=String.fromCharCode(e);break;case"d":e=parseInt(e);break;case"e":e=d[6]?e.toExponential(d[6]):e.toExponential();break;case"f":e=d[6]?parseFloat(e).toFixed(d[6]):parseFloat(e);break;case"o":e=e.toString(8);break;case"s":e=((e=String(e))&&d[6]?e.substring(0,d[6]):e);break;case"u":e=Math.abs(e);break;case"x":e=e.toString(16);break;case"X":e=e.toString(16).toUpperCase();break}e=(/[def]/.test(d[7])&&d[2]&&e>0?"+"+e:e);l=d[3]?d[3]=="0"?"0":d[3].charAt(1):" ";b=d[5]-String(e).length;j=d[5]?str_repeat(l,b):"";k.push(d[4]?e+j:j+e)}else{throw ("Huh ?!")}}}h=h.substring(d[0].length)}return k.join("")};var dateFormat=function(){var a=/d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g,b=/\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,d=/[^-+\dA-Z]/g,c=function(f,e){f=String(f);e=e||2;while(f.length<e){f="0"+f}return f};return function(i,v,q){var g=dateFormat;if(arguments.length==1&&Object.prototype.toString.call(i)=="[object String]"&&!/\d/.test(i)){v=i;i=undefined}i=i?new Date(i):new Date;if(isNaN(i)){throw SyntaxError("invalid date")}v=String(g.masks[v]||v||g.masks["default"]);if(v.slice(0,4)=="UTC:"){v=v.slice(4);q=true}var t=q?"getUTC":"get",l=i[t+"Date"](),e=i[t+"Day"](),j=i[t+"Month"](),p=i[t+"FullYear"](),r=i[t+"Hours"](),k=i[t+"Minutes"](),u=i[t+"Seconds"](),n=i[t+"Milliseconds"](),f=q?0:i.getTimezoneOffset(),h={d:l,dd:c(l),ddd:g.i18n.dayNames[e],dddd:g.i18n.dayNames[e+7],m:j+1,mm:c(j+1),mmm:g.i18n.monthNames[j],mmmm:g.i18n.monthNames[j+12],yy:String(p).slice(2),yyyy:p,h:r%12||12,hh:c(r%12||12),H:r,HH:c(r),M:k,MM:c(k),s:u,ss:c(u),l:c(n,3),L:c(n>99?Math.round(n/10):n),t:r<12?"a":"p",tt:r<12?"am":"pm",T:r<12?"A":"P",TT:r<12?"AM":"PM",Z:q?"UTC":(String(i).match(b)||[""]).pop().replace(d,""),o:(f>0?"-":"+")+c(Math.floor(Math.abs(f)/60)*100+Math.abs(f)%60,4),S:["th","st","nd","rd"][l%10>3?0:(l%100-l%10!=10)*l%10]};return v.replace(a,function(m){return m in h?h[m]:m.slice(1,m.length-1)})}}();dateFormat.masks={"default":"ddd mmm dd yyyy HH:MM:ss",shortDate:"m/d/yy",mediumDate:"mmm d, yyyy",longDate:"mmmm d, yyyy",fullDate:"dddd, mmmm d, yyyy",shortTime:"h:MM TT",mediumTime:"h:MM:ss TT",longTime:"h:MM:ss TT Z",isoDate:"yyyy-mm-dd",isoTime:"HH:MM:ss",isoDateTime:"yyyy-mm-dd'T'HH:MM:ss",isoUtcDateTime:"UTC:yyyy-mm-dd'T'HH:MM:ss'Z'"};dateFormat.i18n={dayNames:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],monthNames:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","January","February","March","April","May","June","July","August","September","October","November","December"]};Date.prototype.format=function(a,b){return dateFormat(this,a,b)};var m=Math;var mr=m.round;var ms=m.sin;var mc=m.cos;var abs=m.abs;var sqrt=m.sqrt;function createMatrixIdentity(){return[[1,0,0],[0,1,0],[0,0,1]]}function matrixMultiply(d,c){var b=createMatrixIdentity();for(var a=0;a<3;a++){for(var g=0;g<3;g++){var e=0;for(var f=0;f<3;f++){e+=d[a][f]*c[f][g]}b[a][g]=e}}return b}function copyState(b,a){a.fillStyle=b.fillStyle;a.lineCap=b.lineCap;a.lineJoin=b.lineJoin;a.lineWidth=b.lineWidth;a.miterLimit=b.miterLimit;a.shadowBlur=b.shadowBlur;a.shadowColor=b.shadowColor;a.shadowOffsetX=b.shadowOffsetX;a.shadowOffsetY=b.shadowOffsetY;a.strokeStyle=b.strokeStyle;a.globalAlpha=b.globalAlpha}function CanvasWrapper(a){this.m_=createMatrixIdentity();this.mStack_=[];this.aStack_=[];this.canvas=a;this.strokeStyle="#000";this.fillStyle="#000";this.lineWidth=1;this.lineJoin="miter";this.lineCap="butt";this.miterLimit=1;this.globalAlpha=1}var cwPrototype=CanvasWrapper.prototype;cwPrototype.applyContextProperties=function(){this.canvas.strokeStyle=this.strokeStyle;this.canvas.fillStyle=this.fillStyle;this.canvas.lineWidth=this.lineWidth;this.canvas.lineJoin=this.lineJoin;this.canvas.lineCap=this.lineCap;this.canvas.miterLimit=this.miterLimit;this.canvas.globalAlpha=this.globalAlpha;this.canvas.font=this.font};cwPrototype.beginPath=function(){this.canvas.beginPath()};cwPrototype.moveTo=function(b,a){this.canvas.moveTo(b,a);var c=this.getCoords(b,a);this.currentX_=c.x;this.currentY_=c.y};cwPrototype.lineTo=function(b,a){this.applyContextProperties();this.canvas.lineTo(b,a);var c=this.getCoords(b,a);this.currentX_=c.x;this.currentY_=c.y};cwPrototype.bezierCurveTo=function(c,a,f,e,d,b){this.applyContextProperties();this.canvas.bezierCurveTo(c,a,f,e,d,b);var g=this.getCoords(d,b);this.currentX_=g.x;this.currentY_=g.y};cwPrototype.quadraticCurveTo=function(e,c,b,a){this.applyContextProperties();this.canvas.quadraticCurveTo(e,c,b,a);var d=this.getCoords(b,a);this.currentX_=d.x;this.currentY_=d.y};cwPrototype.arc=function(e,d,f,c,b,a){this.applyContextProperties();this.canvas.arc(e,d,f,c,b,a)};cwPrototype.rect=function(c,b,a,e){this.applyContextProperties();this.canvas.rect(c,b,a,e);var d=this.getCoords(c,b);this.currentX_=d.x;this.currentY_=d.y};cwPrototype.strokeRect=function(c,b,a,e){this.applyContextProperties();this.canvas.strokeRect(c,b,a,e);var d=this.getCoords(c,b);this.currentX_=d.x;this.currentY_=d.y};cwPrototype.fillRect=function(c,b,a,e){this.applyContextProperties();this.canvas.fillRect(c,b,a,e);var d=this.getCoords(c,b);this.currentX_=d.x;this.currentY_=d.y};cwPrototype.createLinearGradient=function(b,d,a,c){this.applyContextProperties();return this.canvas.createLinearGradient(b,d,a,c)};cwPrototype.createRadialGradient=function(d,f,c,b,e,a){this.applyContextProperties();return this.canvas.createRadialGradient(d,f,c,b,e,a)};cwPrototype.stroke=function(a){this.applyContextProperties();this.canvas.stroke(a)};cwPrototype.fill=function(){this.applyContextProperties();this.canvas.fill()};cwPrototype.clearRect=function(c,b,a,d){this.canvas.clearRect(c,b,a,d)};cwPrototype.closePath=function(){this.canvas.closePath()};cwPrototype.measureText=function(a){this.applyContextProperties();return this.canvas.measureText(a)};cwPrototype.fillText=function(d,c,b,a){this.applyContextProperties();this.canvas.fillText(d,c,b,a)};cwPrototype.createPattern=function(b,a){this.canvas.createPattern(b,a)};cwPrototype.getCoords=function(c,b){var a=this.m_;return{x:c*a[0][0]+b*a[1][0]+a[2][0],y:c*a[0][1]+b*a[1][1]+a[2][1]}};cwPrototype.save=function(){this.canvas.save();var a={};copyState(this,a);this.aStack_.push(a);this.mStack_.push(this.m_);this.m_=matrixMultiply(createMatrixIdentity(),this.m_)};cwPrototype.restore=function(){this.canvas.restore();copyState(this.aStack_.pop(),this);this.m_=this.mStack_.pop()};function matrixIsFinite(a){for(var c=0;c<3;c++){for(var b=0;b<2;b++){if(!isFinite(a[c][b])||isNaN(a[c][b])){return false}}}return true}function setM(b,a){if(!matrixIsFinite(a)){return}b.m_=a}cwPrototype.setMatrix=function(a){this.setTransform(a[0][0],a[0][1],a[1][0],a[1][1],a[2][0],a[2][1])};cwPrototype.getMatrix=function(){return this.m_};cwPrototype.translate=function(c,b){this.canvas.translate(c,b);var a=[[1,0,0],[0,1,0],[c,b,1]];setM(this,matrixMultiply(a,this.m_))};cwPrototype.rotate=function(b){this.canvas.rotate(b);var e=mc(b);var d=ms(b);var a=[[e,d,0],[-d,e,0],[0,0,1]];setM(this,matrixMultiply(a,this.m_))};cwPrototype.scale=function(c,b){this.canvas.scale(c,b);var a=[[c,0,0],[0,b,0],[0,0,1]];setM(this,matrixMultiply(a,this.m_))};cwPrototype.transform=function(e,d,g,f,b,a){this.canvas.transform(e,d,g,f,b,a);var c=[[e,d,0],[g,f,0],[b,a,1]];setM(this,matrixMultiply(c,this.m_))};cwPrototype.setTransform=function(e,d,g,f,c,b){this.canvas.setTransform(e,d,g,f,c,b);var a=[[e,d,0],[g,f,0],[c,b,1]];setM(this,a)};if(typeof(CanvasXpress)=="undefined"){CanvasXpress={}}var CanvasXpress=function(f,d,a,b,c,e){this.$=function(g){return document.getElementById(g)};this.$cX=function(h,l,j){var k=document.createElement(h);if(l){for(var g in l){k[g]=l[g]}}if(j){for(var g in j){k.style[g]=j[g]}}return k};if(!f){f=this.createNewTarget()}else{if(typeof(f)=="object"){d=f.data||false;a=f.config||false;b=f.events||false;c=f.hidden||false;e=f.info||false;f=f.renderTo||this.createNewTarget();if(a.alertIE){CanvasXpress.alertIE=true}}}this.setInit=function(){this.version=7.8;this.target=f;this.events=b;this.info=e;this.userId=3818113811432451;this.startTime=new Date().getTime()};this.validateParameters=function(){this.validateData();this.validateConfig();this.validateEvents();this.validateInfo()};this.validateData=function(){if(d&&!this.subBrowser){try{JSON.stringify(d)}catch(g){alert("Data object malformed:\n"+g)}}};this.validateConfig=function(){this.addConfigLocation();if(!a){a={}}else{if(!this.subBrowser){try{JSON.stringify(a)}catch(g){alert("Config object malformed:\n"+g)}}}this.userConfig=a};this.validateEvents=function(){if(b){}};this.validateInfo=function(){if(!e){e=""}};this.addConfigLocation=function(){var n=window.location.href.split(/&/);if(n&&n.length>0){for(var h=0;h<n.length;h++){var g=n[h].match(/canvasXpress=(\{.+\})/);if(g&&g.length>1){var m=decodeURIComponent(JSON.stringify(g[1]).replace(/^\"/,"").replace(/\"$/,""));var j;try{j=JSON.parse(m)}catch(l){alert("Location parameters malformed:\n"+l)}if(j){if(!a){a={}}for(var k in j){if(!a[k]){a[k]=j[k]}}}}}}};this.newId=function(h){var k=0;var g=this.target+h+k;var j=this.$(g);while(j){k++;g=this.target+h+k;j=this.$(g)}return g};this.createNewTarget=function(){var g=this.$cX("canvas",{id:this.newId("canvasXpress")});document.body.appendChild(g);return g.id};this.insertTarget=function(j,l,i,k,g){if(j&&l){var m=this.$(j);if(m){return}else{m=this.$cX("canvas",{id:j,width:i,height:k})}if(g){l.parentNode.insertBefore(m,l.nextSibling)}else{l.parentNode.insertBefore(m,l)}}};this.removeTarget=function(g){var h=this.$(g);if(h){h.parentNode.removeChild(h)}};this.save=function(h,g){if(this.remoteService){this.removeMenus();if(g=="save"){this.addRemoteDataSaveForm(h)}else{if(g=="params"){this.addRemoteParamsSaveForm(h)}else{this.saveRemote(g)}}}else{return{renderTo:this.target,data:this.data,config:this.getConfig(),events:this.events}}};this.print=function(g){return function(h){g.resetConfigurator();alert("A new window will open so you can right click on the graph and save it");if(g.isIE){var j=g.canvas.parentNode.childNodes[0];return window.open().document.write("<html><body>"+j.innerHTML+"</body></html>")}else{var i=g.canvas.toDataURL("image/png");return window.open().document.write('<html><body><img src="'+i+'" /></body></html>')}}}(this);this.exportToExcel=function(j){var h="";for(var g=0;g<j.length;g++){h+=j[g].join("%09")+"%0D"}return window.open("data:text/tab-separeted-values,"+h)};this.exporttoHTML=function(j){var h="<table>";for(var g=0;g<j.length;g++){h+="<tr><td>";h+=j[g].join("</td><td>");h+="</td></tr>"}h+="</table>";return window.open().document.write(h)};this.exporttoHTML=function(j){var h="<table>";for(var g=0;g<j.length;g++){h+="<tr><td>";h+=j[g].join("</td><td>");h+="</td></tr>"}h+="</table>";return window.open().document.write(h)};this.arrayToHTML=function(l){var k='<div style="padding:2px;overflow:scroll;max-height:400px;max-width:600px;"><table style="border-collapse: collapse;">';for(var h=0;h<l[0].length;h++){k+="<tr>";for(var g=0;g<l[0][h].length;g++){if(l[1][h][g]&&l[1][h][g]=="cxy"){k+='<td class="'+(l[1][h][g]||"cxb")+'">'+this.bestFormatNumber(l[0][h][g])+"</td>"}else{k+='<td class="'+(l[1][h][g]||"cxb")+'">'+l[0][h][g]+"</td>"}}k+="</tr>"}k+="</table></div>";return k};this.prettyJSON=function(g,p){var q=function(i){if(typeof(i)=="object"){if(i===null){return"null"}if(i.constructor==(new Array).constructor){return"array"}if(i.constructor==(new Date).constructor){return"date"}if(i.constructor==(new RegExp).constructor){return"regex"}return"object"}return typeof(i)};if(!p){p=""}var r;var m="  ";var h=q(g);var j=0;if(h=="array"){if(g.length==0){return"[]"}r="["}else{for(var n in g){j++;break}if(j==0){return"{}"}r="{"}j=0;for(var l in g){v=g[l];if(j>0){r+=","}if(h=="array"){r+=("\n"+p+m)}else{r+=("\n"+p+m+'"'+l+'": ')}switch(q(v)){case"array":case"object":r+=this.prettyJSON(v,(p+m));break;case"boolean":case"number":r+=v.toString();break;case"null":r+="null";break;case"string":r+=('"'+v+'"');break;default:}j++}if(h=="array"){r+=("\n"+p+"]")}else{r+=("\n"+p+"}")}return r};this.dumpToConsole=function(g){console.log(this.target);console.log(this.prettyJSON(g))};this.profile=function(i){var g=new Date().getTime();var h=this.profileTime||this.startTime;if(!i){i=""}console.log(this.target+": "+i+": "+(g-h));this.profileTime=g};this.stack=function(){if(this.debug){for(var g in this){if(arguments.callee.caller===this[g]){CanvasXpress.stack[this.target].push(g);return}}}};this.initialize=function(){this.initCSS();this.setInit();this.initCrossBrowser();this.validateParameters();this.initConfig(a);this.initViewport(c);this.initUtils();this.initMathUtils();this.initLegendUtils();this.initFilterUtils();this.initClusterUtils();this.initSortUtils();this.initPrimitives();this.initExample();this.initData(d);this.initLayout();this.initEvents();this.initAnimation();this.initRemote();this.initGraph();this.showToolbar(true)};this.initialize();CanvasXpress.references.push(this);CanvasXpress.stack[this.target]=[]};CanvasXpress.references=[];CanvasXpress.cacheImages={};CanvasXpress.cacheImagesReady=false;CanvasXpress.cachePatterns={};CanvasXpress.cacheText={};CanvasXpress.stack={};CanvasXpress.current=false;CanvasXpress.resizing=false;CanvasXpress.alertIE=false;CanvasXpress.getObject=function(c,b){for(var a=0;a<CanvasXpress.references.length;a++){if(CanvasXpress.references[a].target==c){return CanvasXpress.references[a]}}if(b){return CanvasXpress.injectObject(c)}};CanvasXpress.injectObject=function(d){var a=document.getElementById(d);if(!a){var b=document.createElement("canvas");b.id=d;b.width=100;b.height=100;document.body.appendChild(b);a=new CanvasXpress(d,false,false,false,true)}return a};CanvasXpress.setExampleContainer=function(a){if(!a){a="Show-All"}var j=CanvasXpress.getObject("CanvasXpress-Silent",true);var d=j.getWindowSize();var e=j.getWindowScroll();var c=Math.max(0,((d[0]-500)/2)+e[0]);var h=Math.max(0,((d[1]-500)/2)+e[1]);var g=j.$cX("div",{id:a+"-cX-API-Example",className:"CanvasXpressConfiguratorExample draggable"},{width:"535px",maxHeight:"500px",cursor:"move",display:"block",padding:"10px",position:"absolute",overflow:"hidden",paddingBottom:"35px",left:c+"px",top:h+"px"});var b=j.$cX("span",{id:a+"-cX-API-ExampleSpan",className:"CanvasXpressConfiguratorExample",innerHTML:""});var f=j.$cX("img",{id:a+"-cX-API-ExampleClose",className:"CanvasXpressConfigurator",property:a,src:j.imageDir+"cancel1.png",alt:"Close",title:"Close"});var i=j.$cX("div",{id:a+"-cX-API-ExampleContent",className:"CanvasXpressConfiguratorExampleContent"},{maxWidth:"535px",maxHeight:"500px",overflow:"auto"});g.appendChild(b);g.appendChild(f);g.appendChild(j.$cX("br"));g.appendChild(i);document.body.appendChild(g);return j};CanvasXpress.showExample=function(h,g){if(g){var c=CanvasXpress.setExampleContainer(g);var b=c.$(g+"-cX-API-Example");var f=c.$(g+"-cX-API-ExampleSpan");var d=c.$(g+"-cX-API-ExampleClose");var a=c.$(g+"-cX-API-ExampleContent");d.onclick=function(){var e=c.$(this.property+"-cX-API-Example");if(e){c.removeEvtListener(e,"mousedown",c.registerMousemove,false);var i=e.getElementsByTagName("canvas");while(i.length>0){c.destroy(i[0].id)}e.parentNode.removeChild(e)}};c.addEvtListener(b,"mousedown",c.registerMousemove,false);c.stopEvent(h);c.cancelEvent(h);c.clickExamplePropertyDescription(h,g,true);return false}};CanvasXpress.showAllExamples=function(w,y){var o=CanvasXpress.setExampleContainer();var u=o.$("Show-All-cX-API-Example");var g=o.$("Show-All-cX-API-ExampleSpan");var m=o.$("Show-All-cX-API-ExampleClose");var p=o.$("Show-All-cX-API-ExampleContent");m.onclick=function(){var c=o.$(this.property+"-cX-API-Example");if(c){clearInterval(x);o.removeEvtListener(c,"mousedown",o.registerMousemove,false);var e=c.getElementsByTagName("canvas");while(e.length>0){o.destroy(e[0].id)}c.parentNode.removeChild(c)}};p.appendChild(o.$cX("canvas",{id:"Show-All-cX-API-Example-Canvas",width:500,height:500}));o.addEvtListener(u,"mousedown",o.registerMousemove,false);o.stopEvent(w);o.cancelEvent(w);new CanvasXpress("Show-All-cX-API-Example-Canvas");var a=[];var l=y?[y]:o.getKeys(CanvasXpress.doc.M).sort();for(var s=0;s<l.length;s++){var k=l[s];for(var q=0;q<CanvasXpress.doc.M[k]["P"].length;q++){var b=CanvasXpress.doc.M[k]["P"][q];var n=CanvasXpress.doc.P[b];if(n.H){var h=o.getExamplesDocObject(b);a=a.concat(h)}}}var r=0;var d="Show-All-cX-API-Example-Canvas";var f=function(){o.destroy(d);d=a[r][0];o.insertTarget(d,p,500,500);var z=a[r][1];var A=a[r][2];A.disableToolbar=true;var e=new CanvasXpress(d,z,A);g.innerHTML=d.replace("CanvasXpress-Silent-cX-ConfiguratorExample-","").split("-")[0];var t=a[r][3];if(t){for(var j=0;j<t.length;j++){if(t[j].match(/:/)){var c=t[j].split(":");e[c.shift()].apply(e,c)}else{e[t[j]]()}}}r++;if(r==a.length){r=0}};var x=setInterval(function(){f()},1000);return false};CanvasXpress.prototype.initCrossBrowser=function(){this.getWindowSize=function(){if(typeof window.innerWidth!="undefined"){return[window.innerWidth,window.innerHeight]}else{if(typeof document.documentElement!="undefined"&&typeof document.documentElement.clientWidth!="undefined"&&document.documentElement.clientWidth!=0){return[document.documentElement.clientWidth,document.documentElement.clientHeight]}else{return[document.getElementsByTagName("body")[0].clientWidth,document.getElementsByTagName("body")[0].clientHeight]}}};this.getWindowScroll=function(){var c,f;if(typeof pageXOffset!="undefined"){c=pageXOffset}else{var a=document.body;var e=document.documentElement;e=(e.clientWidth)?e:a;c=e.scrollLeft}if(typeof pageYOffset!="undefined"){f=pageYOffset}else{var a=document.body;var e=document.documentElement;e=(e.clientHeight)?e:a;f=e.scrollTop}return[c,f]};this.hasClass=function(a,b){return new RegExp("(\\s|^)"+b+"(\\s|$)").test(a.className)};this.addClass=function(a,b){if(!this.hasClass(a,b)){a.className+=(a.className?" ":"")+b}};this.removeClass=function(a,b){if(this.hasClass(a,b)){a.className=a.className.replace(new RegExp("(\\s|^)"+b+"(\\s|$)")," ").replace(/^\s+|\s+$/g,"")}};this.cancelEvent=function(a){if(!a){a=window.event}if(!a){return}if(a.preventDefault){a.preventDefault()}else{a.returnValue=false}};this.stopEvent=function(a){if(!a){a=window.event}if(!a){return}if(a.stopPropagation){a.stopPropagation()}else{a.cancelBubble=true}};this.normalizeEvtName=function(a){return this.isIE?"on"+a:a};this.copyEvent=function(c){var b={};for(var a in c){b[a]=c[a]}return b};this.addEvtListener=function(d,b,g,a){if(d&&b&&g){if(!this.registeredEvents){this.registeredEvents={}}if(d.id){if(!this.registeredEvents[d.id]){this.registeredEvents[d.id]={}}this.registeredEvents[d.id][b]=[g,a]}else{if(!this.registeredEvents[d]){this.registeredEvents[d]={}}this.registeredEvents[d][b]=[g,a]}if(this.isIE){d.attachEvent(this.normalizeEvtName(b),g)}else{d.addEventListener(b,g,a);if(b=="mousewheel"){d.addEventListener("DOMMouseScroll",g,a)}}}};this.removeEvtListener=function(h,g,i,d){if(h&&g&&i){var b=this.registeredEvents[h.id||h];if(b&&b.hasOwnProperty(g)){delete (b[g]);if(this.isIE){h.detachEvent(this.normalizeEvtName(g),i)}else{h.removeEventListener(g,i,d);if(g=="mousewheel"){h.removeEventListener("DOMMouseScroll",i,d)}}var a=this.getKeys(this.registeredEvents[h.id||h]);if(a&&a.length<1){delete (this.registeredEvents[h.id||h])}}}};this.addRemoveEvtListener=function(a,g,d,h,b){if(a&&g&&d&&h){this[a](g,d,h,b)}};this.purgeEventListeners=function(){for(var a in this.registeredEvents){var c=this.$(a)||a;for(var b in this.registeredEvents[a]){this.removeEvtListener(c,b,this.registeredEvents[a][0],this.registeredEvents[a][1])}}};this.preventSelection=function(){if(document.selection){document.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}};this.getTargetEvent=function(a){if(this.isIE&&this.useFlashIE&&this.browserVersion<9&&a.srcElement.tagName.match(/object/i)){return a.srcElement.parentNode}else{return a.target||a.srcElement}};this.dataBrowser=[{string:navigator.platform,subString:"iPhone",identity:"iPhone"},{string:navigator.platform,subString:"iPod",identity:"iPod"},{string:navigator.userAgent,subString:"iPad",identity:"iPad"},{string:navigator.userAgent,subString:"Android",identity:"Android"},{string:navigator.userAgent,subString:"BlackBerry",identity:"BlackBerry"},{string:navigator.userAgent,subString:"Chrome",identity:"Chrome"},{string:navigator.userAgent,subString:"OmniWeb",versionSearch:"OmniWeb/",identity:"OmniWeb"},{string:navigator.vendor,subString:"Apple",identity:"Safari",versionSearch:"Version"},{prop:window.opera,identity:"Opera"},{string:navigator.vendor,subString:"iCab",identity:"iCab"},{string:navigator.vendor,subString:"KDE",identity:"Konqueror"},{string:navigator.userAgent,subString:"Firefox",identity:"Firefox"},{string:navigator.vendor,subString:"Camino",identity:"Camino"},{string:navigator.userAgent,subString:"Netscape",identity:"Netscape"},{string:navigator.userAgent,subString:"MSIE",identity:"Explorer",versionSearch:"MSIE"},{string:navigator.userAgent,subString:"Gecko",identity:"Mozilla",versionSearch:"rv"},{string:navigator.userAgent,subString:"Mozilla",identity:"Netscape",versionSearch:"Mozilla"}];this.dataOS=[{string:navigator.platform,subString:"Win",identity:"Windows"},{string:navigator.platform,subString:"Mac",identity:"Mac"},{string:navigator.platform,subString:"iPhone",identity:"iPhone"},{string:navigator.platform,subString:"iPod",identity:"iPod"},{string:navigator.userAgent,subString:"iPad",identity:"iPad"},{string:navigator.userAgent,subString:"Android",identity:"Android"},{string:navigator.userAgent,subString:"BlackBerry",identity:"BlackBerry"},{string:navigator.platform,subString:"Linux",identity:"Linux"}];this.isSubstandardBrowser=function(){if((this.browser=="Firefox"&&this.browserVersion>4)||(this.browser=="Opera"&&this.browserVersion>9)||(this.browser=="Safari"&&this.browserVersion>4)||(this.browser=="Chrome"&&this.browserVersion>1)){return false}else{return true}};this.isMobileApp=function(){if(this.browser.match(/iPhone|iPod|iPad|Android|BlackBerry/i)){return true}else{return false}};this.searchString=function(d){for(var a=0;a<d.length;a++){var b=d[a].string;var c=d[a].prop;this.versionSearchString=d[a].versionSearch||d[a].identity;if(b){if(b.indexOf(d[a].subString)!=-1){return d[a].identity}}else{if(c){return d[a].identity}}}};this.searchVersion=function(b){var a=b.indexOf(this.versionSearchString);if(a==-1){return}return parseFloat(b.substring(a+this.versionSearchString.length+1))};this.initializeBrowser=function(){this.browser=this.searchString(this.dataBrowser)||"An unknown browser";this.browserVersion=this.searchVersion(navigator.userAgent)||this.searchVersion(navigator.appVersion)||"an unknown version";this.browserOS=this.searchString(this.dataOS)||"an unknown OS";if(this.browser=="Explorer"){this.isIE=true;this.subBrowser=true;this.mobileApp=false;if(this.browser=="Explorer"&&this.browserVersion<9&&!CanvasXpress.alertIE){CanvasXpress.alertIE=true;alert("CanvasXpress works much faster in fully HTML 5 compliant browsers.\nPlease consider using Google Chrome, Firefox or a newer version of Internet Explorer.")}}else{this.isIE=false;this.subBrowser=this.isSubstandardBrowser();this.mobileApp=this.isMobileApp()}};this.initializeBrowser()};CanvasXpress.prototype.initCSS=function(){var a="table.shorts{margin:2px 3px;padding:2px 3px;border:1px solid #fafafa;border-collapse:collapse;font-size:x-small}";a+=" td.k{text-align:center;padding:2px 5px;margin:2px 5px;border:1px solid #cccccc;}";a+=" td.d{padding:2px 5px;margin:2px 5px;border:1px solid #cccccc;}";a+=" th.d{padding:2px 5px;margin:2px 5px;border:1px solid #cccccc;}";a+=" th.cxx,th.cxz,th.cxb,th.cxs,th.cxv,td.cxx,td.cxz,td.cxb,td.cxs,td.cxv{background-image:url(http://www.canvasxpress.org/images/accordion.png);background-repeat:repeat-x;border:1px solid #cccccc;vertical-align:middle;}";a+=" td.cxx,td.cxz,td.cxb,td.cxs,td.cxv{font:normal 11px arial, tahoma, sans-serif;line-height:16px;background:#fefefe;padding:1px;}";a+=" td.cxy{font:normal 11px arial, tahoma, sans-serif;line-height:16px;border:1px solid #cccccc;vertical-align:middle;text-align:right;background:#fefefe;padding:1px;}";a+=" div.cxc{left:0px;top:0px;margin-left:5px;margin-top:2px;white-space:nowrap;overflow:hidden;}";a+=" div.CanvasXpressCode{border:1px solid rgb(113,139,183);border-radius:5px;background-color:rgb(240,240,240);cursor:move;color:rgb(34,34,34);font:normal 11px arial, tahoma, sans-serif;margin:2px 3px;padding:2px 3px;position:absolute;white-space:nowrap;}";a+=" img.CanvasXpressCode{cursor:default;float:right;height:13px;margin:2px 3px 0px 0px;padding-bottom:5px;width:13px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.CanvasXpressCodeContainer{background-color:rgb(240,240,240);clear:both;max-height:500px;max-width:600px;overflow:auto;}";a+=" div.CanvasXpressCodeContent{background-color:rgb(240,240,240);margin:2px 3px;padding:2px 3px;}";a+=" pre.CanvasXpressCodeContent{background-color:rgb(240,240,240);border:none;margin:0px;padding:10px;white-space:pre;}";a+=" div.CanvasXpressDrag{opacity:0.5;filter:alpha(opacity=50);background-color:rgb(240,240,240);position:absolute;}";a+=" div.CanvasXpressTooltip{border:1px solid rgb(113,139,183);border-radius:5px;background-color:rgb(240,240,240);cursor:move;color:rgb(34,34,34);font:normal 11px arial, tahoma, sans-serif;margin:2px 3px;overflow:hidden;padding:2px 3px;position:absolute;white-space:nowrap;}";a+=" img.CanvasXpressTooltip{cursor:default;float:right;height:13px;margin:2px 3px 0px 0px;width:13px;cursor:default;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" span.CanvasXpressTooltip{border:1px solid rgb(113,139,183);border-radius:5px;background-color:rgb(240,240,240);cursor:move;color:rgb(34,34,34);font:normal 11px arial, tahoma, sans-serif;margin:2px 3px;overflow:hidden;padding:2px 3px;position:absolute;white-space:nowrap;}";a+=" div.CanvasXpressDataTable{border:1px solid rgb(113,139,183);border-radius:5px;background-color:rgb(240,240,240);clear:both;color:rgb(34,34,34);font:normal 11px arial, tahoma, sans-serif;overflow:hidden;position:absolute;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.CanvasXpressDataTableToolbar{border:0px;border-radius:5px 5px 0px 0px;background-color:rgb(240,240,240);color:rgb(34,34,34);cursor:move;font:normal 11px arial, tahoma, sans-serif;height:18px;left:0px;line-height:100%;position:absolute;top:0px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" img.CanvasXpressDataTableToolbarImage{cursor:default;float:right;height:13px;margin:2px 3px 0px 0px;width:13px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.CanvasXpressDataTableContainer{background-color:rgb(240,240,240);border-radius:0px 0px 5px 5px;color:rgb(34,34,34);display:block;font:normal 11px arial, tahoma, sans-serif;left:0px;line-height:100%;position:absolute;top:20px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.CanvasXpressDataTableVertical{background-color:rgb(240,240,240);overflow:auto;position:absolute;right:2px;top:2px;width:18px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.CanvasXpressDataTableHorizontal{background-color:rgb(240,240,240);bottom:2px;height:18px;left:2px;overflow:auto;position:absolute;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.CanvasXpressDataTableResizer{background-color:rgb(240,240,240);background-image:url(http://www.canvasxpress.org/images/resize_w.png);background-repeat:no-repeat;cursor:se-resize;bottom:1px;height:15px;position:absolute;right:1px;width:15px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" table.CanvasXpressDataTable{border:0px;border-spacing:1px;color:rgb(34,34,34);font:normal 11px arial, tahoma, sans-serif;left:1px;line-height:20px;position:absolute;table-layout:fixed;top:1px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.CanvasXpressDataTableMask{border:0px;left:1px;position:absolute;top:1px;overflow:hidden;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" th.CanvasXpressTableCellHead{background-image:url(http://www.canvasxpress.org/images/accordion.png);background-repeat:repeat-x;border-left:1px solid #ffffff;border-top:1px solid #ffffff;color:rgb(34,34,34);font:normal 11px arial, tahoma, sans-serif;line-height:20px;padding:0px;text-align:left;vertical-align:middle;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" th.CanvasXpressTableCellHeadActive{background-image:url(http://www.canvasxpress.org/images/accordion_active.png);background-repeat:repeat-x;border-left:1px solid #ffffff;border-top:1px solid #ffffff;color:rgb(34,34,34);font:normal 11px arial, tahoma, sans-serif;line-height:20px;padding:0px;text-align:left;vertical-align:middle;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" a.CanvasXpressTableCellHead{background:no-repeat left center;background-color:#dfe8f9;background-image:url(http://www.canvasxpress.org/images/header_arrow_down.png);cursor:pointer;display:none;height:20px;position:absolute;right:0px;top:0px;white-space:normal;width:14px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" a.CanvasXpressTableCellHeadActive{background:no-repeat left center;background-color:#dfe8f9;background-image:url(http://www.canvasxpress.org/images/header_arrow_down.png);cursor:pointer;display:block;height:20px;position:absolute;right:0px;top:0px;white-space:normal;width:14px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" td.CanvasXpressTableCell{background-color:#ffffff;border:0px;color:rgb(34,34,34);font:normal 11px arial, tahoma, sans-serif;line-height:20px;padding:0px;vertical-align:middle;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" td.CanvasXpressTableCellActive{background-color:#dfe8f9;border:0px;color:rgb(34,34,34);font:normal 11px arial, tahoma, sans-serif;line-height:20px;padding:0px;vertical-align:middle;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.CanvasXpressTableCell{font:normal 11px arial, tahoma, sans-serif;line-height:20px;margin:2px 2px 1px 5px;overflow:hidden;position:relative;text-overflow:ellipsis;white-space:nowrap;}";a+=" div.CanvasXpressTableCellSortAsc{background:url(http://www.canvasxpress.org/images/sort_asc.gif) no-repeat right 7px;font:normal 11px arial, tahoma, sans-serif;line-height:20px;margin:2px 2px 1px 5px;overflow:hidden;white-space:nowrap;}";a+=" div.CanvasXpressTableCellSortDesc{background:url(http://www.canvasxpress.org/images/sort_desc.gif) no-repeat right 7px;font:normal 11px arial, tahoma, sans-serif;line-height:20px;margin:2px 2px 1px 5px;overflow:hidden;white-space:nowrap;}";a+=" div.CanvasXpressConfigurator{background-color:rgb(240,240,240);border-radius:5px;border:1px solid rgb(113,139,183);box-shadow:rgba(154,154,154,0.2) 3px 3px;color:rgb(34,34,34);cursor:default;font:normal 11px arial, tahoma, sans-serif;line-height:16px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" span.CanvasXpressConfigurator{cursor:default;font:normal 11px arial, tahoma, sans-serif;line-height:16px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" textarea.CanvasXpressConfigurator{background-color:rgb(240,240,240);border-radius:5px;border:1px solid rgb(113,139,183);box-shadow:rgba(154,154,154,0.2) 3px 3px;color:rgb(34,34,34);cursor:default;font:normal 11px arial, tahoma, sans-serif;line-height:16px;}";a+=" img.CanvasXpressConfigurator{cursor:default;float:right;height:13px;margin-left:2px;width:13px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" select.CanvasXpressConfigurator{background-color:rgb(255,255,255);border:1px solid rgb(113,139,183);color:rgb(34,34,34);cursor:default;font:normal 11px arial, tahoma, sans-serif;line-height:16px;padding-left:3px;}";a+=" input.CanvasXpressConfigurator{background-color:rgb(255,255,255);border:1px solid rgb(113,139,183);color:rgb(34,34,34);cursor:default;font:normal 11px arial, tahoma, sans-serif;line-height:16px;padding-left:3px;}";a+=" div.CanvasXpressConfiguratorOptions{cursor:default;font:normal 11px arial, tahoma, sans-serif;height:100px;line-height:16px;margin-top:8px;overflow:auto;width:180px;}";a+=" div.CanvasXpressConfiguratorFilter{background-color:rgb(240,240,240);border-radius:5px;border:1px solid rgb(113,139,183);box-shadow:rgba(154,154,154,0.2) 3px 3px;color:rgb(34,34,34);font:normal 11px arial, tahoma, sans-serif;line-height:16px;}";a+=" select.CanvasXpressConfiguratorFilter{border:1px solid rgb(113,139,183);font:normal 11px arial, tahoma, sans-serif;line-height:16px;}";a+=" input.CanvasXpressConfiguratorFilter{border:1px solid rgb(113,139,183);font:normal 11px arial, tahoma, sans-serif;line-height:16px;}";a+=" div.CanvasXpressConfiguratorExample{background-color:rgb(240,240,240);border-radius:5px;border:1px solid rgb(113,139,183);box-shadow:rgba(154,154,154,0.2) 3px 3px;color:rgb(34,34,34);font:normal 11px arial, tahoma, sans-serif;line-height:16px;}";a+=" span.CanvasXpressConfiguratorExample{cursor:default;font:normal 11px arial, tahoma, sans-serif;line-height:16px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.CanvasXpressConfiguratorColor{border:1px solid rgb(113,139,183);font:normal 11px arial, tahoma, sans-serif;line-height:16px;}";a+=" div.accordionHead{margin-top:2px;height:16px;overflow:hidden;float:left;cursor:pointer;vertical-align:middle;text-align:left;display:table-cell;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.accordionContent{overflow:auto;}";a+=" div.hoverable:hover{background-color:#dfe8f6;}";a+=" div.CanvasXpressContainer{position:relative;float:left;}";a+=" div.CanvasXpressHandler{position:relative;float:left;background-position:50% 50%;background-repeat:no-repeat;}";a+=" div.CanvasXpressWrapper{position:relative;float:left;line-height:100%;}";a+=" div.CanvasXpressDataFilter{color:rgb(34,34,34);font:normal 11px arial, tahoma, sans-serif;line-height:100%;margin:0px;padding:0px;position:absolute;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.CanvasXpressDataFilterToolbar{background-image:url(http://www.canvasxpress.org/images/accordion.png);background-repeat:repeat-x;border:1px solid rgb(113,139,183);border-radius:5px;color:rgb(34,34,34);cursor:move;font:normal 11px arial, tahoma, sans-serif;height:18px;left:0px;line-height:100%;margin:0px;padding:2px;position:absolute;top:0px;}";a+=" span.CanvasXpressDataFilterToolbarText{font:normal 11px arial, tahoma, sans-serif;left:8px;line-height:100%;position:relative;top:5px;}";a+=" img.CanvasXpressDataFilterToolbarImage{cursor:default;width:13px;height:13px;margin-top:2px;margin-right:2px;float:right;}";a+=" span.CanvasXpressDataFilterText{background-image:url(http://www.canvasxpress.org/images/arrowright.png);background-repeat:no-repeat;background-position:-3px;font:normal 11px arial, tahoma, sans-serif;left:8px;line-height:100%;position:relative;top:5px;}";a+=" span.CanvasXpressDataFilterTextActive{background-image:url(http://www.canvasxpress.org/images/arrowdown.png);background-repeat:no-repeat;background-position:-3px;font:normal 11px arial, tahoma, sans-serif;left:8px;line-height:100%;position:relative;top:5px;}";a+=" div.CanvasXpressDataFilterContainer{border:0px;left:0px;margin:0px;padding:0px;position:absolute;top:24px;}";a+=" div.CanvasXpressDataFilterContainerMask{background-color:#ffffff;border:1px solid #d0d0d0;margin:1px 3px 3px 3px;overflow-x:hidden;overflow-y:scroll;}";a+=" div.CanvasXpressDataFilterContainerItem{background-color:#ffffff;color:#4181ba;height:15px;padding:1px 0px 0px 1px;}";a+=" div.CanvasXpressDataFilterContainerItemSelected{background-color:#4181ba;color:rgb(255,255,255);height:15px;padding:1px 0px 0px 1px;}";a+=" div.CanvasXpressDataFilterContainerHoverable{border:1px solid rgb(113,139,183);margin:2px;margin-bottom:4px;}";a+=" div.CanvasXpressDataFilterContainerHoverable:hover{background-color:#dfe8f6}";a+=" div.CanvasXpressDataFilterContainerNumeric{background-color:#ffffff;border:1px solid rgb(113,139,183);clear:both;height:14px;margin:2px;}";a+=" div.CanvasXpressDataFilterContainerMin{background-image:url(http://www.canvasxpress.org/images/move_right.png);background-repeat:no-repeat;float:left;height:14px;position:relative;width:14px;z-index:10002;}";a+=" div.CanvasXpressDataFilterContainerMax{background-image:url(http://www.canvasxpress.org/images/move_left.png);background-repeat:no-repeat;float:left;height:14px;position:relative;width:14px;z-index:10002;}";a+=" div.CanvasXpressDataFilterContainerRange{background-color:#4181ba;float:left;height:14px;left:0px;position:relative;z-index:10001;}";a+=" select.CanvasXpressDataFilterContainerString{background-color:rgb(255,255,255);font:normal 11px arial, tahoma, sans-serif;margin-left:3px;margin-bottom:3px;}";a+=" div.CanvasXpressDataFilterHead{background-image:url(http://www.canvasxpress.org/images/accordion.png);background-repeat:repeat-x;border:1px solid rgb(113,139,183);border-radius:5px 5px 5px 5px;color:rgb(34,34,34);cursor:pointer;float:left;height:18px;margin-top:2px;overflow:hidden;padding:2px;text-align:left;vertical-align:middle;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.CanvasXpressDataFilterHeadActive{background-color:rgb(240,240,240);background-image:url(http://www.canvasxpress.org/images/accordion_active.png);background-repeat:repeat-x;border:1px solid rgb(113,139,183);border-radius:5px 5px 0px 0px;color:rgb(34,34,34);cursor:pointer;float:left;height:18px;margin-top:2px;overflow:hidden;padding:2px;text-align:left;vertical-align:middle;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.CanvasXpressDataFilterContent{background-color:rgb(255,255,255);border:1px solid rgb(113,139,183);border-radius:0px 0px 5px 5px;border-top:0px;color:rgb(113,139,183);overflow:auto;padding:2px;}";a+=" div.CanvasXpressLink{background-color:rgb(240,240,240);background-image:url(http://www.canvasxpress.org/images/menu.gif);background-repeat:repeat-y;border:1px solid rgb(113,139,183);border-radius:3px;box-shadow:rgba(154,154,154,0.2) 3px 3px;color:rgb(34,34,34);cursor:default;font:normal 11px arial, tahoma, sans-serif;line-height:100%;margin:0px;padding:0px;position:absolute;-moz-box-shadow:rgba(154,154,154,0.2) 3px 3px;}";a+=" div.CanvasXpressMenu{background-color:rgb(240,240,240);background-image:url(http://www.canvasxpress.org/images/menu.gif);background-repeat:repeat-y;border:1px solid rgb(113,139,183);border-radius:3px;box-shadow:rgba(154,154,154,0.2) 3px 3px;color:rgb(34,34,34);cursor:default;font:normal 11px arial, tahoma, sans-serif;line-height:100%;margin:0px;padding:0px;position:absolute;-moz-box-shadow:rgba(154,154,154,0.2) 3px 3px;}";a+=" ul.CanvasXpressList{background:transparent;border:0px none;cursor:default;list-style:none;margin:0px;overflow:hidden;padding:2px;}";a+=" li.CanvasXpressListItemSep{cursor:default;display:block;font:normal 11px arial, tahoma, sans-serif;font-size:1px;height:100%;line-height:1px;list-style:none;margin:0px;padding:1px;width:100%;white-space:nowrap;}";a+=" li.CanvasXpressListItem{cursor:default;display:block;font:normal 11px arial, tahoma, sans-serif;height:100%;line-height:100%;list-style:none;margin:0px;padding:1px;width:100%;white-space:nowrap;}";a+=" input.CanvasXpressListItem{cursor:default;display:block;font:normal 11px arial, tahoma, sans-serif;line-height:100%;list-style:none;margin:0px;padding:1px;white-space:nowrap;}";a+=" div.CanvasXpressListItem{border:1px solid rgb(113,139,183);font:normal 11px arial, tahoma, sans-serif;line-height:16px;}";a+=" li.CanvasXpressListItemActive{background-color:rgb(219,236,244);background-image:url(http://www.canvasxpress.org/images/item-over.gif);background-repeat:repeat-x;background-position:left bottom;border-color:rgb(170,204,246);border-style:solid;border-width:1px 0px;cursor:default;display:block;font:normal 11px arial, tahoma, sans-serif;height:100%;line-height:100%;list-style:none;margin:0px 1px;padding:0px;width:100%;white-space:nowrap;}";a+=" li.CanvasXpressListItemScrollTop{background-image:url(http://www.canvasxpress.org/images/mini-top-grey.png);background-repeat:no-repeat;background-position:50% 50%;border:0px;cursor:pointer;height:9px;line-height:9px;width:100%;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" li.CanvasXpressListItemScrollTopActive{background-color:rgb(219,236,244);background-image:url(http://www.canvasxpress.org/images/mini-top.png);background-repeat:no-repeat;background-position:50% 50%;border:1px;border-color:rgb(170,204,246);border-style:solid;cursor:pointer;height:7px;line-height:7px;width:100%;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" li.CanvasXpressListItemScrollBottom{background-image:url(http://www.canvasxpress.org/images/mini-bottom-grey.png);background-repeat:no-repeat;background-position:50% 50%;border:0px;cursor:pointer;height:9px;line-height:9px;width:100%;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" li.CanvasXpressListItemScrollBottomActive{background-color:rgb(219,236,244);background-image:url(http://www.canvasxpress.org/images/mini-bottom.png);background-repeat:no-repeat;background-position:50% 50%;border:1px;border-color:rgb(170,204,246);border-style:solid;cursor:pointer;height:7px;line-height:7px;width:100%;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" a.CanvasXpressListItemA{color:rgb(34,34,34);cursor:pointer;display:block;font:normal 11px arial, tahoma, sans-serif;line-height:16px;list-style:none;outline-style:none;outline-width:0px;padding:3px 21px 3px 27px;position:relative;text-decoration:none;white-space:nowrap;}";a+=" a.CanvasXpressListItemAArrow{background:url(http://www.canvasxpress.org/images/menu-parent.gif) no-repeat scroll right 50% transparent;color:rgb(34,34,34);cursor:pointer;display:block;font:normal 11px arial, tahoma, sans-serif;line-height:16px;list-style:none;outline-style:none;outline-width:0px;padding:3px 21px 3px 27px;position:relative;text-decoration:none;white-space:nowrap;}";a+=" a.CanvasXpressListItemAActive{border-color:rgb(170,204,246);border-style:solid;border-width:0px 1px;color:rgb(34,34,34);cursor:pointer;display:block;font:normal 11px arial, tahoma, sans-serif;line-height:16px;list-style:none;outline-style:none;outline-width:0px;margin:0px -1px;padding:3px 21px 3px 27px;position:relative;text-decoration:none !important;white-space:nowrap;}";a+=" a.CanvasXpressListItemAArrowActive{background:url(http://www.canvasxpress.org/images/menu-parent.gif) no-repeat scroll right 50% transparent;border-color:rgb(170,204,246);border-style:solid;border-width:0px 1px;color:rgb(34,34,34);cursor:pointer;display:block;font:normal 11px arial, tahoma, sans-serif;line-height:16px;list-style:none;margin:0px -1px;outline-style:none;outline-width:0px;padding:3px 21px 3px 27px;position:relative;text-decoration:none !important;white-space:nowrap;}";a+=" img.CanvasXpressListIcon{background-position:center;border:0px none;color:rgb(34,34,34);cursor:pointer;font:normal 11px arial, tahoma, sans-serif;height:16px;left:3px;line-height:16px;list-style:none;margin:0px;padding:0px;position:absolute;top:3px;vertical-align:top;width:16px;white-space:nowrap;}";a+=" span.CanvasXpressListItemText{color:rgb(34,34,34);cursor:pointer;font:normal 11px arial, tahoma, sans-serif;line-height:16px;list-style:none;margin-right:50px;white-space:nowrap;}";a+=" span.CanvasXpressListItemTextShort{color:rgb(34,34,34);cursor:pointer;font:italic 9px arial, tahoma, sans-serif;line-height:16px;list-style:none;position:absolute;right:4px;white-space:nowrap;}";a+=" span.CanvasXpressListItemTextSep{background-color:rgb(224,224,224);border-bottom:1px solid;border-bottom-color:rgb(255,255,255);cursor:default;display:block;font:normal 11px arial, tahoma, sans-serif;font-size:1px;line-height:1px;list-style:none;margin:2px 3px;overflow:hidden;white-space:nowrap;}";a+=" img.CanvasXpressToolbarHelp{cursor:default;float:right;height:13px;margin-left:2px;width:13px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" div.CanvasXpressToolbarHelp{background-color:rgb(240,240,240);border-radius:5px;border:1px solid rgb(113,139,183);box-shadow:rgba(154,154,154,0.2) 3px 3px;color:rgb(34,34,34);cursor:default;font:normal 11px arial, tahoma, sans-serif;line-height:16px;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" p.CanvasXpressToolbarHelp{cursor:default;font:normal 11px arial, tahoma, sans-serif;line-height:16px;margin:0px;padding:5px 5px 5px 20px;}";a+=" img.CanvasXpressToolbarImage{margin-left:4px;float:right;}";a+=" div.CanvasXpressForm{border:1px solid rgb(113,139,183);border-radius:5px;background-color:rgb(240,240,240);color:rgb(34,34,34);cursor:move;font:normal 11px arial, tahoma, sans-serif;margin:8px;padding:8px;position:absolute;white-space:nowrap;}";a+=" input.CanvasXpressFormButton{background-image:url(http://www.canvasxpress.org/images/accordion.png);background-repeat:repeat-x;border:1px solid rgb(113,139,183);border-radius:5px 5px 5px 5px;color:rgb(34,34,34);cursor:pointer;float:left;height:22px;margin-top:2px;overflow:hidden;padding:2px;vertical-align:middle;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" input.CanvasXpressFormButtonActive{background-color:rgb(240,240,240);background-image:url(http://www.canvasxpress.org/images/accordion_active.png);background-repeat:repeat-x;border:1px solid rgb(113,139,183);border-radius:5px 5px 0px 0px;color:rgb(34,34,34);cursor:pointer;float:left;height:22px;margin-top:2px;overflow:hidden;padding:2px;vertical-align:middle;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";a+=" input.CanvasXpressFormText{background-color:rgb(255,255,255);border:1px solid rgb(113,139,183);color:rgb(34,34,34);cursor:default;font:normal 11px arial, tahoma, sans-serif;line-height:16px;padding-left:3px;}";a+=" form.CanvasXpressFormForm{background-color: rgb(255,255,255);border: 1px solid rgb(113,139,183);color: rgb(34,34,34);cursor: default;font: normal 11px arial, tahoma, sans-serif;line-height: 16px;margin: 8px;overflow: auto;padding-left: 3px;}";a+=" canvas.CanvasXpress{-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;-o-user-select:none;-user-select:none;}";var b=document.createElement("style");b.type="text/css";if(b.styleSheet){b.styleSheet.cssText=a}else{b.appendChild(document.createTextNode(a))}document.getElementsByTagName("head")[0].appendChild(b)};CanvasXpress.prototype.initConfig=function(a){this.setConfigDefaults=function(){this.config=[];this.graphType="Bar";this.config.push("graphType");this.graphOrientation="horizontal";this.config.push("graphOrientation");this.transparency=null;this.config.push("transparency");this.canvasBox=true;this.config.push("canvasBox");this.canvasBoxColor="rgb(204,204,204)";this.config.push("canvasBoxColor");this.useFlashIE=true;this.config.push("useFlashIE");this.loadImagesTimeOut=100;this.config.push("loadImagesTimeOut");this.functions=[];this.gradient=false;this.config.push("gradient");this.gradientType="radial";this.config.push("gradientType");this.gradientOrientation="vertical";this.config.push("gradientOrientation");this.gradientRatio=1.3;this.config.push("gradientRatio");this.adjustAspectRatio=true;this.config.push("adjustAspectRatio");this.adjustAspectRatioMax=3;this.config.push("adjustAspectRatioMax");this.adjustAspectRatioYTries=0;this.adjustAspectRatioXTries=0;this.variableSeparationFactor=2;this.config.push("variableSeparationFactor");this.sampleSeparationFactor=1;this.config.push("sampleSeparationFactor");this.widthFactor=1;this.config.push("widthFactor");this.acknowledgment=false;this.config.push("acknowledgment");this.acknowledgmentIcon="cx.png";this.config.push("acknowledgmentIcon");this.acknowledgmentIconPosition="inside";this.config.push("acknowledgmentIconPosition");this.foreground="rgb(0,0,0)";this.config.push("foreground");this.foregroundWindow="rgb(0,0,0)";this.config.push("foregroundWindow");this.background="rgb(255,255,255)";this.config.push("background");this.backgroundWindow="rgb(244,244,244)";this.config.push("backgroundWindow");this.backgroundType="solid";this.config.push("backgroundType");this.backgroundImage=false;this.config.push("backgroundImage");this.backgroundVideo=false;this.config.push("backgroundVideo");this.backgroundWindowGradientOrientation="vertical";this.config.push("backgroundWindowGradientOrientation");this.backgroundGradient1Color="rgb(0,0,200)";this.config.push("backgroundGradient1Color");this.backgroundGradient2Color="rgb(0,0,36)";this.config.push("backgroundGradient2Color");this.backgroundWindowGradient1Color="rgb(0,0,200)";this.config.push("backgroundWindowGradient1Color");this.backgroundWindowGradient2Color="rgb(0,0,36)";this.config.push("backgroundWindowGradient2Color");this.margin=5;this.config.push("margin");this.marginLeft=20;this.config.push("marginLeft");this.marginTop=20;this.config.push("marginTop");this.marginBottom=20;this.config.push("marginBottom");this.marginRight=20;this.config.push("marginRight");this.showShadow=false;this.config.push("showShadow");this.showTextShadow=false;this.config.push("showTextShadow");this.shadowOffsetX=1;this.config.push("shadowOffsetX");this.shadowOffsetY=1;this.config.push("shadowOffsetY");this.shadowBlur=2;this.config.push("shadowBlur");this.shadowColor="rgba(0,0,0,0.5)";this.config.push("shadowColor");this.videoControls=true;this.config.push("videoControls");this.videoAutoplay=true;this.config.push("videoAutoplay");this.videoLoop=false;this.config.push("videoLoop");this.videoPreload="none";this.config.push("videoPreload");this.videoData="{}";this.config.push("videoData");this.videoPoster="";this.config.push("videoPoster");this.videoClassName="video-js vjs-default-skin";this.config.push("videoClassName");this.videoPlaybackRate=1;this.config.push("videoPlaybackRate");this.videoCurrentTime=false;this.config.push("videoCurrentTime");this.videoGrid=false;this.config.push("videoGrid");this.videoGridStep=10;this.config.push("videoGridStep");this.videoColor="rgb(255,0,0)";this.config.push("videoColor");this.fontName="Verdana";this.config.push("fontName");this.fontStyle="";this.config.push("fontStyle");this.fontSize=12;this.config.push("fontSize");this.font=this.fontStyle+" "+this.fontSize+"px "+this.fontName;this.align="center";this.config.push("align");this.baseline="middle";this.config.push("baseline");this.maxTextSize=14;this.config.push("maxTextSize");this.minTextSize=4;this.config.push("minTextSize");this.autoScaleFont=true;this.config.push("autoScaleFont");this.scaleTextConstantMult=40;this.scaleTextConstantAdd=2.5;this.title=false;this.config.push("title");this.titleHeight=30;this.config.push("titleHeight");this.titleColor="rgb(0,0,0)";this.config.push("titleColor");this.titleFontStyle="";this.config.push("titleFontStyle");this.subtitle=false;this.config.push("subtitle");this.subtitleHeight=16;this.config.push("subtitleHeight");this.subtitleColor="rgb(0,0,0)";this.config.push("subtitleColor");this.subtitleFontStyle="";this.config.push("subtitleFontStyle");this.citation=false;this.config.push("citation");this.citationColor="rgb(0,0,0)";this.config.push("citationColor");this.citationFontStyle="";this.config.push("citationFontStyle");this.citationFontSize=7;this.config.push("citationFontSize");this.citationFont=this.citationFontStyle+" "+this.citationFontSize+"px "+this.fontName;this.citationScaleFontFactor=1;this.config.push("citationScaleFontFactor");this.dashLength=8;this.config.push("dashLength");this.dotLength=1;this.config.push("dotLength");this.arrowPointSize=10;this.config.push("arrowPointSize");this.capType="butt";this.config.push("capType");this.joinType="mitter";this.config.push("joinType");this.lineWidthEvent=2;this.config.push("lineWidthEvent");this.outlineWidth=1;this.config.push("outlineWidth");this.lines=[];this.colorScheme="user";this.config.push("colorScheme");this.colors0=["rgb(255,0,0)","rgb(0,0,255)","rgb(0,255,0)","rgb(255,255,0)","rgb(0,255,255)","rgb(255,0,255)","rgb(153,51,0)","rgb(0,0,128)","rgb(128,128,0)","rgb(255,102,0)","rgb(0,128,128)","rgb(102,0,102)","rgb(255,153,204)","rgb(102,102,153)","rgb(51,51,0)","rgb(255,204,153)","rgb(204,255,255)","rgb(153,153,255)","rgb(255,128,128)","rgb(51,102,255)","rgb(51,153,102)","rgb(255,204,0)","rgb(0,204,255)","rgb(208,32,144)","rgb(153,51,102)","rgb(0,102,204)","rgb(153,204,0)","rgb(255,153,0)","rgb(51,204,204)","rgb(204,153,255)","rgb(128,0,0)","rgb(51,51,153)","rgb(0,128,0)","rgb(255,255,204)","rgb(153,204,255)","rgb(128,0,128)"];this.colors1=["rgb(0,0,255)","rgb(255,0,77)","rgb(255,191,0)","rgb(116,255,0)","rgb(164,0,255)","rgb(255,116,0)","rgb(255,255,0)","rgb(0,255,255)","rgb(255,0,0)","rgb(255,211,0)","rgb(61,0,255)","rgb(0,255,0)","rgb(255,0,255)","rgb(255,146,0)","rgb(211,255,0)","rgb(0,144,255)","rgb(109,0,255)","rgb(255,73,0)","rgb(255,232,0)","rgb(0,255,146)","rgb(255,0,144)","rgb(255,170,0)","rgb(170,255,0)","rgb(0,77,255)"];this.colors2=["rgb(60,60,157)","rgb(157,60,90)","rgb(157,133,60)","rgb(104,157,60)","rgb(122,60,157)","rgb(157,104,60)","rgb(157,157,60)","rgb(60,157,157)","rgb(157,60,60)","rgb(157,140,60)","rgb(83,60,157)","rgb(60,157,60)","rgb(157,60,157)","rgb(157,115,60)","rgb(140,157,60)","rgb(60,115,157)","rgb(102,60,157)","rgb(157,88,60)","rgb(157,148,60)","rgb(60,157,115)","rgb(157,60,115)","rgb(157,125,60)","rgb(125,157,60)","rgb(60,90,157)"];this.colors3=["rgb(0,0,117)","rgb(117,0,36)","rgb(117,88,0)","rgb(53,117,0)","rgb(76,0,117)","rgb(117,53,0)","rgb(117,117,0)","rgb(0,117,117)","rgb(117,0,0)","rgb(117,97,0)","rgb(28,0,117)","rgb(0,117,0)","rgb(117,0,117)","rgb(117,67,0)","rgb(97,117,0)","rgb(0,66,117)","rgb(50,0,117)","rgb(117,33,0)","rgb(117,107,0)","rgb(0,117,67)","rgb(117,0,66)","rgb(117,78,0)","rgb(78,117,0)","rgb(0,36,117)"];this.colors4=["rgb(101,101,255)","rgb(255,101,147)","rgb(255,216,101)","rgb(171,255,101)","rgb(200,101,255)","rgb(255,171,101)","rgb(255,255,101)","rgb(101,255,255)","rgb(255,101,101)","rgb(255,229,101)","rgb(137,101,255)","rgb(101,255,101)","rgb(255,101,255)","rgb(255,189,101)","rgb(229,255,101)","rgb(101,188,255)","rgb(167,101,255)","rgb(255,145,101)","rgb(255,241,101)","rgb(101,255,189)","rgb(255,101,188)","rgb(255,204,101)","rgb(204,255,101)","rgb(101,147,255)"];this.colors5=["rgb(181,181,255)","rgb(255,181,203)","rgb(255,237,181)","rgb(215,255,181)","rgb(229,181,255)","rgb(255,215,181)","rgb(255,255,181)","rgb(181,255,255)","rgb(255,181,181)","rgb(255,242,181)","rgb(199,181,255)","rgb(181,255,181)","rgb(255,181,255)","rgb(255,223,181)","rgb(242,255,181)","rgb(181,223,255)","rgb(213,181,255)","rgb(255,202,181)","rgb(255,248,181)","rgb(181,255,223)","rgb(255,181,223)","rgb(255,230,181)","rgb(230,255,181)","rgb(181,203,255)"];this.colors6=["rgb(254,41,108)","rgb(72,126,182)","rgb(167,206,49)","rgb(248,204,3)","rgb(255,140,2)","rgb(105,150,150)","rgb(183,120,68)","rgb(131,172,208)","rgb(194,224,118)","rgb(250,220,90)","rgb(255,84,159)","rgb(255,175,84)","rgb(154,184,183)","rgb(210,166,131)","rgb(61,105,155)","rgb(135,172,34)","rgb(205,169,8)","rgb(208,33,88)","rgb(208,115,0)","rgb(86,118,118)"];this.colors=this.colors6;this.config.push("colors");this.colorHSV=[0,0,1];this.colorRGB=[1,1,1];this.oddColor=this.background;this.config.push("oddColor");this.evenColor="rgb(240,240,240)";this.config.push("evenColor");this.patternImages=["patt_diag_nw_se.png","patt_diag_sw_ne.png","patt_hor.png","patt_ver.png","patt_polkadot.png","patt_cross.png","patt_ver_hor.png","patt_square.png","patt_circles.png","patt_plus.png","patt_squigle.png","patt_stairs.png","patt_art.png","patt_cx.png"];this.config.push("patternImages");this.patternNames=["hatchForward","hatchReverse","stripeHorizontal","stripeVertical","polkaDot","crossHatch","crossStripe","squares","circles","plus","squigles","brick","art","cx"];this.config.push("patternNames");this.patterns=["solid","hatchForward","hatchReverse","stripeHorizontal","stripeVertical","polkaDot","crossHatch","crossStripe","squares","circles","plus","squigles","brick","art","cx"];this.config.push("patterns");this.shapes=["sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","pacman","pacman2","mdavid","rect2","rect3","arc","rectangle","image"];this.config.push("shapes");this.sizes=[8,10,12,14,16,18,20,22,24,26,28,30,31,32,33,34];this.config.push("sizes");this.images=[];this.config.push("images");this.timeFormat="isoDate";this.config.push("timeFormat");this.maxSmpStringLen=50;this.config.push("maxSmpStringLen");this.smpLabelDescription=false;this.config.push("smpLabelDescription");this.smpTitle=false;this.config.push("smpTitle");this.smpTitleFontStyle="";this.config.push("smpTitleFontStyle");this.smpTitleFontSize=10;this.config.push("smpTitleFontSize");this.smpTitleFont=this.smpTitleFontStyle+" "+this.smpTitleFontSize+"px "+this.fontName;this.smpTitleFontColor=this.foreground;this.config.push("smpTitleFontColor");this.smpTitleScaleFontFactor=1;this.config.push("smpTitleScaleFontFactor");this.smpLabelFontStyle="";this.config.push("smpLabelFontStyle");this.smpLabelFontSize=10;this.config.push("smpLabelFontSize");this.smpLabelFont=this.smpLabelFontStyle+" "+this.smpLabelFontSize+"px "+this.fontName;this.smpLabelFontColor=this.foreground;this.config.push("smpLabelFontColor");this.smpLabelScaleFontFactor=1;this.config.push("smpLabelScaleFontFactor");this.smpLabelRotate=0;this.config.push("smpLabelRotate");this.smpLabelInterval=1;this.config.push("smpLabelInterval");this.showSampleNames=true;this.config.push("showSampleNames");this.highlightSmp=[];this.config.push("highlightSmp");this.smpHighlightColor="rgb(255,0,0)";this.config.push("smpHighlightColor");this.filterSmpBy=[];this.config.push("filterSmpBy");this.filterSmpByOp=[];this.config.push("filterSmpByOp");this.filterSmpByValue=[];this.config.push("filterSmpByValue");this.filterSmpByCase=[];this.config.push("filterSmpByCase");this.filteredSmpIndices=[];this.config.push("filteredSmpIndices");this.maxVarStringLen=30;this.config.push("maxVarStringLen");this.varLabelDescription=false;this.config.push("varLabelDescription");this.varTitle=false;this.config.push("varTitle");this.varTitleFontStyle="";this.config.push("varTitleFontStyle");this.varTitleFontSize=10;this.config.push("varTitleFontSize");this.varTitleFont=this.varTitleFontStyle+" "+this.varTitleFontSize+"px "+this.fontName;this.varTitleFontColor=this.foreground;this.config.push("varTitleFontColor");this.varTitleScaleFontFactor=1;this.config.push("varTitleScaleFontFactor");this.varLabelFontStyle="";this.config.push("varLabelFontStyle");this.varLabelFontSize=10;this.config.push("varLabelFontSize");this.varLabelFont=this.varLabelFontStyle+" "+this.varLabelFontSize+"px "+this.fontName;this.varLabelFontColor=this.foreground;this.config.push("varLabelFontColor");this.varLabelScaleFontFactor=1;this.config.push("varLabelScaleFontFactor");this.varLabelRotate=0;this.config.push("varLabelRotate");this.varLabelInterval=1;this.config.push("varLabelInterval");this.showVariableNames=true;this.config.push("showVariableNames");this.highlightVar=[];this.config.push("highlightVar");this.varHighlightColor="rgb(255,0,0)";this.config.push("varHighlightColor");this.filterVarBy=[];this.config.push("filterVarBy");this.filterVarByOp=[];this.config.push("filterVarByOp");this.filterVarByValue=[];this.config.push("filterVarByValue");this.filterVarByCase=[];this.config.push("filterVarByCase");this.filteredVarIndices=[];this.config.push("filteredVarIndices");this.overlaysWidth=30;this.config.push("overlaysWidth");this.smpOverlays=[];this.config.push("smpOverlays");this.varOverlays=[];this.config.push("varOverlays");this.showOverlays=true;this.config.push("showOverlays");this.showLevelOverlays=true;this.config.push("showLevelOverlays");this.overlayFontStyle="";this.config.push("overlayFontStyle");this.overlayFontSize=6;this.config.push("overlayFontSize");this.overlayFont=this.overlayFontStyle+" "+this.overlayFontSize+"px "+this.fontName;this.overlayFontColor=this.foreground;this.config.push("overlayFontColor");this.overlayScaleFontFactor=1;this.config.push("overlayScaleFontFactor");this.smpOverlayRecycleColors=false;this.config.push("smpOverlayRecycleColors");this.varOverlayRecycleColors=false;this.config.push("varOverlayRecycleColors");this.showLegend=true;this.config.push("showLegend");this.legendPosition="right";this.config.push("legendPosition");this.legendColor=this.foreground;this.config.push("legendColor");this.legendBox=true;this.config.push("legendBox");this.legendBoxColor="rgb(204,204,204)";this.config.push("legendBoxColor");this.legendBackgroundColor=this.background;this.config.push("legendBackgroundColor");this.legendFontStyle="";this.config.push("legendFontStyle");this.legendFontSize=10;this.config.push("legendFontSize");this.legendFont=this.legendFontStyle+" "+this.legendFontSize+"px "+this.fontName;this.legendScaleFontFactor=1;this.config.push("legendScaleFontFactor");this.showIndicators=true;this.config.push("showIndicators");this.indicatorsPosition="bottom";this.config.push("indicatorsPosition");this.showDecorations=false;this.config.push("showDecorations");this.decorationsPosition="bottom";this.config.push("decorationsPosition");this.decorationsColor=this.foreground;this.config.push("decorationsColor");this.decorationFontStyle="";this.config.push("decorationFontStyle");this.decorationFontSize=10;this.config.push("decorationFontSize");this.decorationFont=this.decorationFontStyle+" "+this.decorationFontSize+"px "+this.fontName;this.decorationScaleFontFactor=1;this.config.push("decorationScaleFontFactor");this.decorationsWidth=10;this.config.push("decorationsWidth");this.decorationsHeight=20;this.config.push("decorationsHeight");this.decorationsType="bar";this.config.push("decorationsType");this.decorations=[];this.config.push("decorations");this.showDecorationsKaplanMeyerConfidence=false;this.config.push("showDecorationsKaplanMeyerConfidence");this.decorationsColors=[];this.config.push("decorationsColors");this.decorationsProperties={};this.config.push("decorationsProperties");this.isGroupedData=false;this.isTransformedData=false;this.isBoxPlotCalc=false;this.isMarketDataFormated=false;this.isMarketSwitched=false;this.isGraphTime=false;this.config.push("isGraphTime");this.groupingFactors=[];this.config.push("groupingFactors");this.segregateSamplesBy=false;this.config.push("segregateSamplesBy");this.segregateVariablesBy=false;this.config.push("segregateVariablesBy");this.isLogData=false;this.config.push("isLogData");this.smpSort=-1;this.varSort=-1;this.tmpAsciiArray=[];this.sortDir="ascending";this.config.push("sortDir");this.transformBase=2;this.config.push("transformBase");this.transformType=false;this.config.push("transformType");this.ratioReference=0;this.config.push("ratioReference");this.ratioSampleReference=false;this.config.push("ratioSampleReference");this.ratioGroupReference=false;this.config.push("ratioGroupReference");this.ratioLevelReference="";this.config.push("ratioLevelReference");this.transformAxis="samples";this.config.push("transformAxis");this.zscoreAxis="samples";this.config.push("zscoreAxis");this.showErrorBars=true;this.config.push("showErrorBars");this.showErrorBarsWidth=2;this.config.push("showErrorBarsWidth");this.missingDataColor="rgb(255,255,0)";this.config.push("missingDataColor");this.randomSeed=8;this.config.push("randomSeed");this.pseudoRandom=false;this.config.push("pseudoRandom");this.randomData=false;this.randomDataUniform=false;this.config.push("randomDataUniform");this.randomDataSymmetrical=false;this.config.push("randomDataSymmetrical");this.randomDataMissing=false;this.config.push("randomDataMissing");this.randomDataMean=100;this.config.push("randomDataMean");this.randomDataSigma=50;this.config.push("randomDataSigma");this.randomDataVariables=6;this.config.push("randomDataVariables");this.randomDataSamples=12;this.config.push("randomDataSamples");this.randomDataVariableAnnotations=2;this.config.push("randomDataVariableAnnotations");this.randomDataSampleAnnotations=3;this.config.push("randomDataSampleAnnotations");this.randomDataVariableAnnotationRatio=2;this.config.push("randomDataVariableAnnotationRatio");this.randomDataSampleAnnotationRatio=2;this.config.push("randomDataSampleAnnotationRatio");this.randomMissingDataPercentage=0;this.config.push("randomMissingDataPercentage");this.randomNetworkReduce=true;this.config.push("randomNetworkReduce");this.randomNetworkNodes=50;this.config.push("randomNetworkNodes");this.randomNetworkNodeEdgesMax=5;this.config.push("randomNetworkNodeEdgesMax");this.zoom=1;this.config.push("zoom");this.zoomGlobal=1;this.zoomStep=0.2;this.config.push("zoomStep");this.zoomVariablesDisable=false;this.config.push("zoomVariablesDisable");this.zoomSamplesDisable=false;this.config.push("zoomSamplesDisable");this.panningX=0;this.config.push("panningX");this.panningY=0;this.config.push("panningY");this.panningGlobalX=0;this.panningGlobalY=0;this.panningStep=0.2;this.config.push("panningStep");this.distance="euclidian";this.config.push("distance");this.linkage="single";this.config.push("linkage");this.clusterAxis="samples";this.config.push("clusterAxis");this.kmeansClusters=3;this.config.push("kmeansClusters");this.maxIterations=10;this.config.push("maxIterations");this.imputeMethod="mean";this.config.push("imputeMethod");this.centerData=false;this.config.push("centerData");this.xAxisAbsMax=null;this.xAxisAbsMin=null;this.xAxisMaxStrLength=false;this.setMaxX=null;this.config.push("setMaxX");this.setMinX=null;this.config.push("setMinX");this.xAxisCurrent=0;this.config.push("xAxisCurrent");this.xAxisTitle=false;this.config.push("xAxisTitle");this.xAxis=[];this.config.push("xAxis");this.xAxisTickStyle="solid";this.config.push("xAxisTickStyle");this.xAxisTickFormat=false;this.config.push("xAxisTickFormat");this.xAxisTickColor="rgb(204,204,204)";this.config.push("xAxisTickColor");this.xAxisExact=false;this.config.push("xAxisExact");this.xAxisValues=[];this.config.push("xAxisValues");this.xAxisMinorValues=[];this.config.push("xAxisMinorValues");this.xAxisTransform=false;this.config.push("xAxisTransform");this.xAxisTransformTicks=true;this.config.push("xAxisTransformTicks");this.xAxisShow=true;this.config.push("xAxisShow");this.xAxisTicks=5;this.config.push("xAxisTicks");this.xAxisMinorTicks=true;this.config.push("xAxisMinorTicks");this.timeValues=[];this.config.push("timeValues");this.timeValueIndices=[];this.config.push("timeValueIndices");this.timeTicksFirst=false;this.config.push("timeTicksFirst");this.xAxis2AbsMax=null;this.xAxis2AbsMin=null;this.xAxis2MaxStrLength=false;this.setMaxX2=null;this.config.push("setMaxX2");this.setMinX2=null;this.config.push("setMinX2");this.xAxis2Title=false;this.config.push("xAxis2Title");this.xAxis2TickFormat=false;this.config.push("xAxis2TickFormat");this.xAxis2Exact=false;this.config.push("xAxis2Exact");this.xAxis2Values=[];this.config.push("xAxis2Values");this.xAxis2MinorValues=[];this.config.push("xAxis2MinorValues");this.xAxis2Show=true;this.config.push("xAxis2Show");this.xAxis2Ticks=null;this.yAxisAbsMax=null;this.yAxisAbsMin=null;this.yAxisMaxStrLength=false;this.setMaxY=null;this.config.push("setMaxY");this.setMinY=null;this.config.push("setMinY");this.yAxisCurrent=0;this.config.push("yAxisCurrent");this.yAxisTitle=false;this.config.push("yAxisTitle");this.yAxis=[];this.config.push("yAxis");this.yAxisTickStyle="solid";this.config.push("yAxisTickStyle");this.yAxisTickFormat=false;this.config.push("yAxisTickFormat");this.yAxisTickColor="rgb(204,204,204)";this.config.push("yAxisTickColor");this.yAxisExact=false;this.config.push("yAxisExact");this.yAxisValues=[];this.config.push("yAxisValues");this.yAxisMinorValues=[];this.config.push("yAxisMinorValues");this.yAxisTransform=false;this.config.push("yAxisTransform");this.yAxisTransformTicks=true;this.config.push("yAxisTransformTicks");this.yAxisShow=true;this.config.push("yAxisShow");this.yAxisTicks=5;this.config.push("yAxisTicks");this.yAxisMinorTicks=true;this.config.push("yAxisMinorTicks");this.zAxisAbsMax=null;this.zAxisAbsMin=null;this.zAxisMaxStrLength=false;this.setMaxZ=null;this.config.push("setMaxZ");this.setMinZ=null;this.config.push("setMinZ");this.zAxisCurrent=0;this.config.push("zAxisCurrent");this.zAxisTitle=false;this.config.push("zAxisTitle");this.zAxis=[];this.config.push("zAxis");this.zAxisTickStyle="solid";this.config.push("zAxisTickStyle");this.zAxisTickFormat=false;this.config.push("zAxisTickFormat");this.zAxisTickColor="rgb(204,204,204)";this.config.push("zAxisTickColor");this.zAxisExact=false;this.config.push("zAxisExact");this.zAxisValues=[];this.config.push("zAxisValues");this.zAxisMinorValues=[];this.config.push("zAxisMinorValues");this.zAxisShow=true;this.config.push("zAxisShow");this.zAxisTicks=10;this.rAxisAbsMax=null;this.rAxisAbsMin=null;this.rAxisMaxStrLength=false;this.rAxisTickColor="rgb(0,0,0)";this.config.push("rAxisTickColor");this.rAxisValues=[];this.config.push("rAxisValues");this.rAxisMinorValues=[];this.config.push("rAxisMinorValues");this.rAxisShow=true;this.config.push("rAxisShow");this.rAxisLabelOrientation="perpendicular";this.config.push("rAxisLabelOrientation");this.rAxisTicks=5;this.config.push("rAxisTicks");this.axisTickColor=this.foreground;this.config.push("axisTickColor");this.axisTickFontStyle="";this.config.push("axisTickFontStyle");this.axisTickFontSize=10;this.config.push("axisTickFontSize");this.axisTickFont=this.axisTickFontStyle+" "+this.axisTickFontSize+"px "+this.fontName;this.axisTickScaleFontFactor=1;this.config.push("axisTickScaleFontFactor");this.axisTitleColor=this.foreground;this.config.push("axisTitleColor");this.axisTitleFontStyle="";this.config.push("axisTitleFontStyle");this.axisTitleFontSize=10;this.config.push("axisTitleFontSize");this.axisTitleFont=this.axisTitleFontStyle+" "+this.axisTitleFontSize+"px "+this.fontName;this.axisTitleScaleFontFactor=1;this.config.push("axisTitleScaleFontFactor");this.axisExtension=0.1;this.config.push("axisExtension");this.axisAlgorithm="default";this.config.push("axisAlgorithm");this.axisWilkinsonLoose=false;this.config.push("axisWilkinsonLoose");this.axisTicksAutoAdjust=false;this.config.push("axisTicksAutoAdjust");this.setMax=null;this.setMin=null;this.smpHairline=false;this.config.push("smpHairline");this.smpHairlineWidth=0.3;this.config.push("smpHairlineWidth");this.smpHairlineColor="rgb(204,204,204)";this.config.push("smpHairlineColor");this.blockContrast=false;this.config.push("blockContrast");this.plotByVariable=false;this.config.push("plotByVariable");this.is3DPlot=false;this.config.push("is3DPlot");this.showDataValues=false;this.config.push("showDataValues");this.jitter=false;this.config.push("jitter");this.lineDecoration="symbol";this.config.push("lineDecoration");this.coordinateLineColor=false;this.config.push("coordinateLineColor");this.lineThickness=1;this.config.push("lineThickness");this.lineType="rect";this.config.push("lineType");this.tension=0.3;this.config.push("tension");this.boxPlotOutliersRatio=8;this.config.push("boxPlotOutliersRatio");this.showBoxplotOriginalData=false;this.config.push("showBoxplotOriginalData");this.boxplotDataPointRatio=2;this.config.push("boxplotDataPointRatio");this.boxplotDataPointTransparency=0.5;this.config.push("boxplotDataPointTransparency");this.areaIsCumulative=false;this.config.push("areaIsCumulative");this.colorBy=false;this.config.push("colorBy");this.shapeBy=false;this.config.push("shapeBy");this.shapeByData=false;this.config.push("shapeByData");this.shapeByShape=false;this.config.push("shapeByShape");this.sizeBy=false;this.config.push("sizeBy");this.sizeByData=false;this.config.push("sizeByData");this.outlineBy=false;this.config.push("outlineBy");this.outlineByData=false;this.config.push("outlineByData");this.patternBy=false;this.config.push("patternBy");this.patternByData=false;this.config.push("patternByData");this.connectBy=false;this.config.push("connectBy");this.connectByColor="rgb(0,0,0)";this.config.push("connectByColor");this.connectByData={};this.scatterType=false;this.config.push("scatterType");this.scatterOutlineThereshold=4000;this.config.push("scatterOutlineThereshold");this.functionIntervals=25;this.config.push("functionIntervals");this.selectDataMode="area";this.config.push("selectDataMode");this.selectDataModeDescription=false;this.config.push("selectDataModeDescription");this.selectDataPoint=[];this.hideDataPoint=[];this.isSelectDataPoints=0;this.isHistogram=false;this.config.push("isHistogram");this.histogramBarWidth=0.5;this.config.push("histogramBarWidth");this.histogramBins=false;this.config.push("histogramBins");this.histogramStagger=false;this.config.push("histogramStagger");this.showHistogramDensity=false;this.config.push("showHistogramDensity");this.histogramDensityKernel="epanechnikovKernel";this.config.push("epanechnikovKernel");this.isCreateHistogram=false;this.maxDOENumber=8;this.config.push("maxDOENumber");this.includeDOE=[];this.config.push("includeDOE");this.scatterPlotMatrix=false;this.config.push("scatterPlotMatrix");this.scatterPlotMatrixType="both";this.config.push("scatterPlotMatrixType");this.xRotate=45;this.config.push("xRotate");this.yRotate=0;this.config.push("yRotate");this.zRotate=0;this.config.push("zRotate");this.x3DRatio=1;this.config.push("x3DRatio");this.y3DRatio=1;this.config.push("y3DRatio");this.z3DRatio=1;this.config.push("z3DRatio");this.bar3DInverseWeight=1;this.config.push("bar3DInverseWeight");this.minRotate=null;this.config.push("minRotate");this.maxRotate=null;this.config.push("maxRotate");this.show3DGrid=true;this.config.push("show3DGrid");this.rotationDelay=100;this.config.push("rotationDelay");this.rotationSensitivity=45;this.config.push("rotationSensitivity");this.rotationStep=2;this.config.push("rotationStep");this.perspectiveFactor=1.5;this.config.push("perspectiveFactor");this.indicatorCenter="white";this.config.push("indicatorCenter");this.indicatorHeight=8;this.config.push("indicatorHeight");this.indicatorWidth=1;this.config.push("indicatorWidth");this.heatmapType="blue-red";this.config.push("heatmapType");this.varIndicesStart=-1;this.smpIndicesStart=-1;this.isMultidimensionalData=false;this.varTitleLabelOverlayPosition="bottom";this.config.push("varTitleLabelOverlayPosition");this.isOncoprint=false;this.config.push("isOncoprint");this.oncoprintAmplification=3;this.config.push("oncoprintAmplification");this.oncoprintDeletion=1;this.config.push("oncoprintDeletion");this.correlationAxis="samples";this.config.push("correlationAxis");this.correlationAnchorLegend=false;this.config.push("correlationAnchorLegend");this.correlationAnchorLegendAlignWidth=40;this.config.push("correlationAnchorLegendAlignWidth");this.correlationLabelInterval=1;this.config.push("correlationLabelInterval");this.showSmpDendrogram=false;this.config.push("showSmpDendrogram");this.showVarDendrogram=false;this.config.push("showVarDendrogram");this.varDendrogramPosition="top";this.config.push("varDendrogramPosition");this.smpDendrogramPosition="left";this.config.push("smpDendrogramPosition");this.dendrogramSpace=6;this.config.push("dendrogramSpace");this.dendrogramHang=false;this.config.push("dendrogramHang");this.dendrogramHeight=false;this.config.push("dendrogramHeight");this.dendrogramColor="rgb(204,204,204)";this.config.push("dendrogramColor");this.vennLegendColors=false;this.config.push("vennLegendColors");this.vennGroups=4;this.config.push("vennGroups");this.vennCompartments=["A","B","AB","C","AC","BC","ABC","D","AD","BD","CD","ABD","ACD","BCD","ABCD"];this.vennColors=[];this.config.push("vennColors");this.pieType="separated";this.config.push("pieType");this.pieSegmentPrecision=0;this.config.push("pieSegmentPrecision");this.pieSegmentSeparation=1;this.config.push("pieSegmentSeparation");this.pieSegmentLabels="inside";this.config.push("pieSegmentLabels");this.pieLabeType="percentage";this.config.push("pieLabelType");this.maxPieSectors=20;this.config.push("maxPieSectors");this.showPieGrid=true;this.config.push("showPieGrid");this.showPieValues=true;this.config.push("showPieValues");this.showPieSampleLabel=true;this.config.push("showPieSampleLabel");this.startPieSectors=0;this.config.push("startPieSectors");this.pieInnerRadius=0;this.config.push("pieInnerRadius");this.pieColors=[];this.config.push("pieColors");this.circularCenterProportion=0.3;this.config.push("circularCenterProportion");this.arcSegmentsSeparation=8;this.config.push("arcSegmentsSeparation");this.ringSeparation=9;this.config.push("ringSeparation");this.ringsType=[];this.config.push("ringsType");this.ringsWeight=[];this.config.push("ringsWeight");this.rAxis=false;this.config.push("rAxis");this.rAxisZero=false;this.config.push("rAxisZero");this.showRingLegend=true;this.config.push("showRingLegend");this.showCircularConnections=true;this.config.push("showCircularConnections");this.circularLetterSeparationFactor=2;this.config.push("circularLetterSeparationFactor");this.circularConnectionsTransparency=0.5;this.config.push("circularConnectionsTransparency");this.smpLabelOrientation="perpendicular";this.config.push("smpLabelOrientation");this.tagCloudTextWeightFactor=1;this.config.push("tagCloudTextWeightFactor");this.tagCloudTextGridSize=8;this.config.push("tagCloudTextGridSize");this.tagCloudTextEllipticity=0.65;this.config.push("tagCloudTextEllipticity");this.tagCloudTextRotateRatio=0.1;this.config.push("tagCloudTextRotateRatio");this.tagCloudGridPoints=[];this.showVolume=true;this.config.push("showVolume");this.stockIndicators=["Sma5","Sma10","Sma25"];this.config.push("stockIndicators");this.sma5Color="rgb(255,0,0)";this.config.push("sma5Color");this.sma10Color="rgb(0,255,0)";this.config.push("sma10Color");this.sma20Color="rgb(0,0,255)";this.config.push("sma20Color");this.sma25Color="rgb(255,0,255)";this.config.push("sma25Color");this.sma50Color="rgb(0,0,0)";this.config.push("sma50Color");this.calculateLayout=true;this.config.push("calculateLayout");this.networkFreeze=false;this.config.push("networkFreeze");this.networkFreezeOnLoad=false;this.config.push("networkFreezeOnLoad");this.networkStack=[];this.subNetworks=false;this.networkStackStates=8;this.config.push("networkStackStates");this.networkStackIndex=0;this.approximateNodePositions=false;this.config.push("approximateNodePositions");this.networkLayoutType="forceDirected";this.config.push("networkLayoutType");this.networkForceConstant=0;this.config.push("networkForceConstant");this.temperature=0;this.config.push("temperature");this.initialTemperature=0;this.config.push("initialTemperature");this.networkNodeMinDistance=4;this.config.push("networkNodeMinDistance");this.attractiveForceFunction="FruchtermanReingold";this.config.push("attractiveForceFunction");this.repulsiveForceFunction="square";this.config.push("repulsiveForceFunction");this.networkRoot=false;this.config.push("networkRoot");this.showNetworkRadialLayout=false;this.config.push("showNetworkRadialLayout");this.networkDepth=0;this.networkDivisions=0;this.preScaleNetwork=false;this.config.push("preScaleNetwork");this.showNetworkNodesLegend=true;this.config.push("showNetworkNodesLegend");this.showNetworkEdgesLegend=true;this.config.push("showNetworkEdgesLegend");this.showNetworkTextLegend=true;this.config.push("showNetworkTextLegend");this.showNetworkDecorationsLegend=true;this.config.push("showNetworkDecorationsLegend");this.highlightNode=[];this.config.push("highlightNode");this.nodeHighlightColor="rgb(255,0,0)";this.config.push("nodeHighlightColor");this.selectNode={};this.isSelectNodes=0;this.showNodeNameThreshold=50;this.config.push("showNodeNameThreshold");this.showHiddenChildEdges=true;this.config.push("showHiddenChildEdges");this.nodeSize=this.preScaleNetwork?10:20;this.config.push("nodeSize");this.edgeWidth=1;this.config.push("edgeWidth");this.layoutTime=15;this.config.push("layoutTime");this.nodeFontStyle="";this.config.push("nodeFontStyle");this.nodeFontSize=this.nodeSize;this.config.push("nodeFontSize");this.nodeFont=this.nodeFontStyle+" "+this.nodeFontSize+"px "+this.fontName;this.nodeFontColor=this.foreground;this.config.push("nodeFontColor");this.nodeScaleFontFactor=1;this.config.push("nodeScaleFontFactor");this.colorNodeBy=false;this.config.push("colorNodeBy");this.shapeNodeBy=false;this.config.push("shapeNodeBy");this.sizeNodeBy=false;this.config.push("sizeNodeBy");this.colorEdgeBy=false;this.config.push("colorEdgeBy");this.shapeEdgeBy=false;this.config.push("shapeEdgeBy");this.sizeEdgeBy=false;this.config.push("sizeEdgeBy");this.sizeDecorationBy=false;this.config.push("sizeDecorationBy");this.is3DNetwork=false;this.config.push("is3DNetwork");this.network2DRotate=0;this.skipClick=false;this.autoHideOnDecorationsCenter=false;this.config.push("autoHideOnDecorationsCenter");this.networkNodesOnTop=true;this.config.push("networkNodesOnTop");this.overrideEventlessNodes=false;this.config.push("overrideEventlessNodes");this.overrideAnchorNodes=false;this.config.push("overrideAnchorNodes");this.moveParentsWithChildren=false;this.config.push("moveParentsWithChildren");this.nodeConfigurableProperties=["x","y","z","parentNode","shape","color","outline","size","width","height","pattern","rotate","outlineWidth","imagePath","zIndex","eventless","hide","hideLabel","anchor"];this.config.push("nodeConfigurableProperties");this.edgeConfigurableProperties=["color","width","cap","exact","type"];this.config.push("edgeConfigurableProperties");this.filterNodeBy=[];this.config.push("filterNodeBy");this.filterNodeByOp=[];this.config.push("filterNodeByOp");this.filterNodeByValue=[];this.config.push("filterNodeByValue");this.filterNodeByCase=[];this.config.push("filterNodeByCase");this.filterEdgeBy=[];this.config.push("filterEdgeBy");this.filterEdgeByOp=[];this.config.push("filterEdgeByOp");this.filterEdgeByValue=[];this.config.push("filterEdgeByValue");this.filterEdgeByCase=[];this.config.push("filterEdgeByCase");this.genomeTicks=50;this.config.push("genomeTicks");this.trackNameFontStyle="";this.config.push("trackNameFontStyle");this.trackNameFontSize=10;this.config.push("trackNameFontSize");this.trackNameFont=this.trackNameFontStyle+" "+this.trackNameFontSize+"px "+this.fontName;this.trackNameFontColor=this.foreground;this.config.push("trackNameFontColor");this.trackFillColor=this.background;this.config.push("trackFillColor");this.trackDirColor=this.foreground;this.config.push("trackDirColor");this.subtracksMaxDefault=8;this.config.push("subtracksMaxDefault");this.showFeatureNameThereshold=20;this.config.push("showFeatureNameThereshold");this.featureNameFontStyle="";this.config.push("featureNameFontStyle");this.featureNameFontSize=10;this.config.push("featureNameFontSize");this.featureNameFont=this.featureNameFontStyle+" "+this.featureNameFontSize+"px "+this.fontName;this.featureNameFontColor=this.foreground;this.config.push("featureNameFontColor");this.featureFillColor=this.background;this.config.push("featureFillColor");this.featureDirColor=this.foreground;this.config.push("featureDirColor");this.maxFeatureStringLen=50;this.config.push("maxFeatureStringLen");this.featureWidthDefault=3;this.config.push("featureWidthDefault");this.featureHeightDefault=14;this.config.push("featureHeightDefault");this.featureTraceHeight=40;this.config.push("featureTraceHeight");this.featureTraceTrim=1;this.config.push("featureTraceTrim");this.featureTracesShow=true;this.config.push("featureTracesShow");this.featureQualityHeight=12;this.config.push("featureQualityHeight");this.featureQualityValues=false;this.config.push("featureQualityValues");this.featureQualityShow=true;this.config.push("featureQualityShow");this.featureSignalToNoiseHeight=12;this.config.push("featureSignalToNoiseHeight");this.featureSignalToNoiseValues=false;this.config.push("featureSignalToNoiseValues");this.featureSignalToNoiseShow=true;this.config.push("featureSignalToNoiseShow");this.featureCoordinateHeight=12;this.config.push("featureCoordinateHeight");this.featureCoordinateShow=true;this.config.push("featureCoordinateShow");this.featureTranslateHeight=12;this.config.push("featureTranslateHeight");this.featureTranslateShow=true;this.config.push("featureTranslateShow");this.featureTypeDefault="line";this.config.push("featureTypeDefault");this.featureStaggered=false;this.config.push("featureStaggered");this.sequenceFontStyle="";this.config.push("sequenceFontStyle");this.sequenceFontSize=10;this.config.push("sequenceFontSize");this.sequenceFont=this.sequenceFontStyle+" "+this.sequenceFontSize+"px "+this.fontName;this.sequenceFill=false;this.config.push("sequenceFill");this.sequenceGAPColor="rgb(255,0,255)";this.config.push("sequenceGAPColor");this.sequenceAColor="rgb(0,103,0)";this.config.push("sequenceAColor");this.sequenceBColor="rgb(0,0,0)";this.config.push("sequenceBColor");this.sequenceCColor="rgb(0,0,255)";this.config.push("sequenceCColor");this.sequenceDColor="rgb(0,0,0)";this.config.push("sequenceDColor");this.sequenceEColor="rgb(0,0,0)";this.config.push("sequenceEColor");this.sequenceFColor="rgb(0,0,255)";this.config.push("sequenceFColor");this.sequenceGColor="rgb(0,0,0)";this.config.push("sequenceGColor");this.sequenceHColor="rgb(255,0,0)";this.config.push("sequenceHColor");this.sequenceIColor="rgb(0,103,0)";this.config.push("sequenceIColor");this.sequenceKColor="rgb(255,0,0)";this.config.push("sequenceKColor");this.sequenceLColor="rgb(0,103,0)";this.config.push("sequenceLColor");this.sequenceMColor="rgb(0,103,0)";this.config.push("sequenceMColor");this.sequenceNColor="rgb(0,0,0)";this.config.push("sequenceNColor");this.sequencePColor="rgb(255,165,0)";this.config.push("sequencePColor");this.sequenceQColor="rgb(0,0,0)";this.config.push("sequenceQColor");this.sequenceRColor="rgb(255,0,0)";this.config.push("sequenceRColor");this.sequenceSColor="rgb(255,165,0)";this.config.push("sequenceSColor");this.sequenceTColor="rgb(255,0,0)";this.config.push("sequenceTColor");this.sequenceUColor="rgb(255,0,0)";this.config.push("sequenceUColor");this.sequenceVColor="rgb(0,103,0)";this.config.push("sequenceVColor");this.sequenceWColor="rgb(0,0,255)";this.config.push("sequenceWColor");this.sequenceXColor="rgb(0,0,0)";this.config.push("sequenceXColor");this.sequenceYColor="rgb(0,0,255)";this.config.push("sequenceYColor");this.sequenceZColor="rgb(0,0,0)";this.config.push("sequenceZColor");this.sequenceStartColor="rgb(0,204,0)";this.config.push("sequenceStartColor");this.sequenceEndColor="rgb(255,0,0)";this.config.push("sequenceEndColor");this.wireColor=this.isVML?"rgb(204,204,204)":"rgba(204,204,204,0.1)";this.config.push("wireColor");this.periodTicksLabels=5;this.config.push("periodTicksLabels");this.genomeResolution="low";this.trackConfigurableProperties=["name","hideName","hideFeatureNames","type","height","fill","outline","hide","connect","subtracksMax","highlight"];this.config.push("trackConfigurableProperties");this.featureConfigurableProperties=["id","name","label","hideName","fill","outline","dir","showDir","connect","offset","data","subtype","quality","signalToNoise","coordinate","sequence","trace","gaps","translate","hide","counter"];this.config.push("featureConfigurableProperties");this.filterFeatureBy=[];this.config.push("filterFeatureBy");this.filterFeatureByOp=[];this.config.push("filterFeatureByOp");this.filterFeatureByValue=[];this.config.push("filterFeatureByValue");this.filterFeatureByCase=[];this.config.push("filterFeatureByCase");this.errors=[];this.debug=false;this.config.push("debug");this.showVersion=true;this.config.push("showVersion");this.showCode=false;this.config.push("showCode");this.codeType="params";this.config.push("codeType");this.skin="grey";this.config.push("skin");this.skinProperties=["skinBackgroundColor","skinBorderColor","skinColor","skinShadowColor"];this.skinPropertiesBlue=["rgb(223,232,246)","rgb(224,224,224)","rgb(68,68,68)","rgba(204,204,204,0.2)"];this.skinPropertiesGrey=["rgb(240,240,240)","rgb(113,139,183)","rgb(34,34,34)","rgba(154,154,154,0.2)"];this.selectedBackgroundColor="rgba(255,0,0,0.3)";this.config.push("selectedBackgroundColor");this.disableMenu=false;this.config.push("disableMenu");this.disableToolbar=false;this.config.push("disableToolbar");this.toolbarPermanent=false;this.config.push("toolbarPermanent");this.disableDataTable=false;this.config.push("disableDataTable");this.disableDataFilters=false;this.config.push("disableDataFilters");this.disableConfigurator=false;this.config.push("disableConfigurator");this.disableAxisResizer=false;this.config.push("disableAxisResizer");this.isLayoutConfigurator=false;this.config.push("isLayoutConfigurator");this.resizable=true;this.config.push("resizable");this.maxSubMenus=15;this.config.push("maxSubMenus");this.showAdvancedConfiguration=false;this.config.push("showAdvancedConfiguration");this.showFadeResizeMoveAnimation=true;this.config.push("showFadeResizeMoveAnimation");this.configuratorWidth=250;this.config.push("configuratorWidth");this.configuratorExamplesSize=400;this.config.push("configuratorExamplesSize");this.alignConfiguratorExamples=false;this.config.push("alignConfiguratorExamples");this.showConfiguratorExamplesOnSelect=false;this.config.push("showConfiguratorExamplesOnSelect");this.dataFilterWidth=200;this.config.push("dataFilterWidth");this.resizeWidthOnLayout=true;this.config.push("resizeWidthOnLayout");this.resizeHeightOnLayout=true;this.config.push("resizeHeightOnLayout");this.disableEvents=false;this.config.push("disableEvents");this.eventKeys=true;this.config.push("eventKeys");this.eventArrowKeys=true;this.config.push("eventArrowKeys");this.eventPlusMinusKeys=false;this.config.push("eventPlusMinusKeys");this.helpKeyEvents=false;this.config.push("helpKeyEvents");this.maintainZoomOnDrag=false;this.config.push("maintainZoomOnDrag");this.infoTimeOut=3000;this.config.push("infoTimeOut");this.infoStartTime=new Date().getTime();this.infoTimeIn=50;this.config.push("infoTimeIn");this.dataEvent=[];this.broadcast=false;this.config.push("broadcast");this.broadcastType="var";this.config.push("broadcastType");this.destroyCanvasXpressZombies=true;this.config.push("destroyCanvasXpressZombies");this.monitorCanvasXpressZombiesTime=30000;this.config.push("monitorCanvasXpressZombiesTime");this.resizerBackgroundColor=this.isIE?"rgb(204,204,204)":"rgba(204,204,204,0.7)";this.config.push("resizerBackgroundColor");this.resizerBackgroundColorCurrent="rgb(237,247,255)";this.config.push("resizerBackgroundColorCurrent");this.resizerBackgroundColorOutlineCurrent="rgb(59,138,229)";this.config.push("resizerBackgroundColorOutlineCurrent");this.resizerTransparency=true;this.config.push("resizerTransparency");this.resizerType=false;this.config.push("resizerType");this.resizerDraw=false;this.config.push("resizerDraw");this.resizerPosition="bottom";this.config.push("resizerPosition");this.resizerWidth=50;this.config.push("resizerWidth");this.resizerBackgroundImage=false;this.config.push("resizerBackgroundImage");this.resizerDataIndex=0;this.config.push("resizerDataIndex");this.resizerEventData={};this.showAnimation=false;this.config.push("showAnimation");this.showAnimationFontStyle="";this.config.push("showAnimationFontStyle");this.showAnimationFontSize=10;this.config.push("showAnimationFontSize");this.showAnimationFont=this.showAnimationFontStyle+" "+this.showAnimationFontSize+"px "+this.fontName;this.showAnimationFontColor=this.background;this.config.push("showAnimationFontColor");this.animationTime=30;this.config.push("animationTime");this.animationType="grow";this.config.push("animationType");this.animationCycles=20;this.config.push("animationCycles");this.snapshotCopyChangeOnly=true;this.config.push("snapshotCopyChangeOnly");this.snapshots=[];this.isAnimation=false;this.weight=1;this.scaleX=1;this.scaleY=1;this.translateX=0;this.translateY=0;this.offsetX=0;this.offsetY=0;this.layoutWidth=0;this.layoutHeight=0;this.layout="1X1";this.config.push("layout");this.layoutComb=false;this.config.push("layoutComb");this.layoutAdjust=false;this.config.push("layoutAdjust");this.layoutCurrent=0;this.layoutMaxVarLegend=0;this.layoutMulticolor=true;this.config.push("layoutMulticolor");this.layoutAxis=3;this.imageDir=false;this.config.push("imageDir");this.playButton="control_play_blue.png";this.config.push("playButton");this.stopButton="control_stop_blue.png";this.config.push("stopButton");this.previousButton="control_rewind_blue.png";this.config.push("previousButton");this.nextButton="control_forward_blue.png";this.config.push("nextButton");this.dropdownButton="menu_dropdown.png";this.config.push("dropdownButton");this.loadingImage="loading1.gif";this.config.push("loadingImage");this.remoteService=false;this.config.push("remoteService");this.remoteParams={};this.config.push("remoteParams");this.remoteDirection="next";this.config.push("remoteDirection");this.remoteParentId="";this.remoteDataIndex=0;this.remoteIds=[];this.remoteWindow=1;this.config.push("remoteWindow");this.remoteAutoPlay=false;this.config.push("remoteAutoPlay");this.remoteAutoPlayDelay=3000;this.config.push("remoteAutoPlayDelay");this.remoteUpdating=false;this.remoteUpdate=false;this.config.push("remoteUpdate");this.remoteUpdateDelay=10000;this.config.push("remoteUpdateDelay");this.skipConfigurableProperties=true;this.config.push("skipConfigurableProperties");this.nodesProperties=[];this.config.push("nodesProperties");this.edgesProperties=[];this.config.push("edgesProperties");this.featuresProperties=[];this.config.push("featuresProperties");this.filterType="and";this.config.push("filterType");this.filterSkipNullKeys=false;this.config.push("filterSkipNullKeys");this.filterSkipNullValues=false;this.config.push("filterSkipNullValues");this.showDataTable=false;this.config.push("showDataTable");this.dataTableTransposed=true;this.config.push("dataTableTransposed");this.maxRows=10;this.config.push("maxRows");this.maxCols=6;this.config.push("maxCols");this.colWidth=100;this.config.push("colWidth");this.rowHeight=18;this.config.push("rowHeight");this.freezeColLeft=0;this.config.push("freezeColLeft");this.freezeColRight=0;this.config.push("freezeColRight");this.freezeRowTop=0;this.config.push("freezeRowTop");this.freezeRowBottom=0;this.config.push("freezeRowBottom");this.refresehDataTableOnDraw=false;this.config.push("refresehDataTableOnDraw");this.showDataTableOnSelect=false;this.config.push("showDataTableOnSelect");this.networkShowDataTable="nodes";this.config.push("networkShowDataTable");this.startCol=0;this.startRow=0;this.dataTableColumnWidth=[];this.dataTableRowHeight=[]};this.setInitialConfig=function(){if(this.userConfig){for(var b in this.userConfig){this[b]=this.userConfig[b]}}};this.resetConfig=function(b){var d={};if(b){for(var c=0;c<b.length;c++){d[b[c]]=this[b[c]]}}this.setConfigDefaults();for(var c in d){this[c]=d[c]}};this.updateConfig=function(c){if(c){this.userConfig=c;for(var b in c){this[b]=c[b]}}};this.getConfig=function(){var g={};var e={colors:true,images:true,xAxisValues:true,xAxisMinorValues:true,yAxisValues:true,yAxisMinorValues:true,zAxisValues:true,zAxisMinorValues:true,stockIndicators:true,nodeConfigurableProperties:true,edgeConfigurableProperties:true,trackConfigurableProperties:true,featureConfigurableProperties:true};if(this.isTransformedData){g.isTransformedData=this.isTransformedData}for(var c=0;c<this.config.length;c++){var b=this.config[c];if(CanvasXpress.doc.P[b]&&CanvasXpress.doc.P[b].hasOwnProperty("D")){var f=CanvasXpress.doc.P[b].D;if(e[b]){continue}if(typeof(this[b])=="object"){if(f=="[]"){f=[]}if(f=="{}"){f={}}if(this[b]===null){if(f!="null"){g[b]=this[b]}}else{if(!this.isSameObject(this[b],f)){g[b]=this[b]}}}else{if(f.match(/false|true|null/)){if(this[b].toString()!=f){g[b]=this[b]}}else{if(this[b]!=f){g[b]=this[b]}}}}}return g};this.getUserConfig=function(){return this.userConfig};this.setSkin=function(c){if(!c){c=this.skin}for(var b=0;b<this.skinProperties.length;b++){if(c=="blue"){this[this.skinProperties[b]]=this.skinPropertiesBlue[b]}else{this[this.skinProperties[b]]=this.skinPropertiesGrey[b]}}if(c=="blue"){this.skinHighlight="rgb(250,250,250)"}else{this.skinHighlight="rgb(223,232,246)"}};this.setPath=function(){var d=document.getElementsByTagName("script");if(d){for(var c=0;c<d.length;c++){if(!d[c].src){continue}var e=d[c].src;var b=e.lastIndexOf("/");var h=e.substring(0,b+1);var g=e.substring(b+1);if(g.match(/canvasXpress/)){this.path=h}}}};this.setImageDirectory=function(){var d=this;var b=this.imageDir?this.imageDir:this.path.substring(0,this.path.lastIndexOf("/js/")+1)+"images/";if(!this.imageDir){this.imageDir=b}var c=this.$cX("img",{id:"canvasXpressTestImageDirectory",src:b+"canvasXpress.gif",onerror:function(){alert("Couldn't find image directory: imageDir\nCanvasXpress will not display")},onload:function(){d.removeTarget("canvasXpressTestImageDirectory")}});document.body.appendChild(c)};this.getNewCanvasContext=function(d){var b=this.$(d);if(b&&b.tagName.toLowerCase()=="canvas"){}else{b=this.$cX("canvas",{id:d});document.body.appendChild(b)}if(this.browser=="Explorer"&&(this.browserVersion<9&&navigator.userAgent.toLowerCase().indexOf("chromeframe")<0)){if(this.useFlashIE){if(typeof FlashCanvas!="undefined"){FlashCanvas.initElement(b)}}else{window.G_vmlCanvasManager.initElement(b)}}return b.getContext("2d")};this.setCanvas=function(){var f=this.$(this.target);if(f){if(this.browser=="Explorer"&&(this.browserVersion<9&&navigator.userAgent.toLowerCase().indexOf("chromeframe")<0)){if(this.useFlashIE){this.isVML=false;if(typeof FlashCanvas!="undefined"){FlashCanvas.setOptions({disableContextMenu:true,swfPath:"http://www.canvasxpress.org/js/"});this.canvas=FlashCanvas.initElement(f)}}else{this.isVML=true;this.canvas=window.G_vmlCanvasManager.initElement(f)}}else{this.isVML=false;this.canvas=f}if(this.debug){this.ctx=new CanvasWrapper(this.canvas.getContext("2d"))}else{this.ctx=this.canvas.getContext("2d")}if((this.backgroundType=="video"||this.graphType=="Video")&&this.backgroundVideo){if(this.graphType=="Video"){this.backgroundType="video"}this.isVideo=true;var e=this.$cX("script",{type:"text/javascript",src:"http://vjs.zencdn.net/c/video.js"});var d=this.$cX("link",{type:"text/css",rel:"stylesheet",href:"http://vjs.zencdn.net/c/video-js.css"});var b=document.getElementsByTagName("head")[0];b.appendChild(d);b.appendChild(e);this.background="rgba(255,255,255,0)";this.legendBackgroundColor="rgba(255,255,255,0)";this.disableToolbar=true}else{this.isVideo=false}}};this.inititalizeConfig=function(){this.setConfigDefaults();if(a){if(a.graphType=="Network"){if(!a.backgroundType){this.backgroundType="gradient";this.nodeFontColor=this.background}}for(var b=0;b<this.config.length;b++){var c=this.config[b];if(a.hasOwnProperty(c)){this[c]=a[c]}}}if(this.isVML){this.showAnimation=false}this.setSkin();this.setPath();this.setImageDirectory();this.setCanvas()};this.inititalizeConfig()};CanvasXpress.prototype.initColor=function(){this.validateColor=function(b,a){b=b.toString();if(b.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i)){if(RegExp.$2){b="rgba("+RegExp.$1+","+RegExp.$2+")"}else{b="rgb("+RegExp.$1+")"}}else{if(b.match(/^#?[0-9abcdef]/i)){b=this.hexToRgb(b)}else{b=false}}return b&&a!=null?this.addColorTransparency(b,a):b};this.darkenLightenColor=function(j,e){j=this.rgbToHex(j).substring(1,7);var i=parseInt(j,16);var h=(i>>16)+e;h=h>255?255:h<0?0:h;var f=((i>>8)&255)+e;f=f>255?255:f<0?0:f;var d=(i&255)+e;d=d>255?255:d<0?0:d;j=d|(f<<8)|(h<<16);return this.hexToRgb(j.toString(16))};this.rgbToHex=function(b){var a=function(c){c=parseInt(c,10);if(isNaN(c)){return"00"}c=Math.max(0,Math.min(c,255));return"0123456789ABCDEF".charAt((c-c%16)/16)+"0123456789ABCDEF".charAt(c%16)};if(b&&b.substr(0,1)==="#"){return b}if(b&&b.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return"#"+a(RegExp.$1)+a(RegExp.$2)+a(RegExp.$3)}else{return b}};this.complementaryColor=function(j,e){var d=this.validateColor(j.toString());if(d.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){var i=parseInt(255-RegExp.$1);var f=parseInt(255-RegExp.$2);var a=parseInt(255-RegExp.$3);if(i==f&&f==a){if(i>=127){d="rgb(255,255,255)"}else{d="rgb(0,0,0)"}}else{d="rgb("+i+","+f+","+a+")"}return e?this.rgbToHex(d):d}else{return j}};this.hexToRgb=function(c){var b=function(){return parseInt(c.substring(0,2),16)};var a=function(){return parseInt(c.substring(2,4),16)};var d=function(){return parseInt(c.substring(4,6),16)};c=c.charAt(0)=="#"?c.substring(1,7):c;return"rgb("+b()+","+a()+","+d()+")"};this.addColorTransparency=function(b,a){if(b&&b.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i)){if(RegExp.$2){return"rgba("+RegExp.$1+","+a+")"}else{return"rgba("+RegExp.$1+","+a+")"}}else{return false}};this.disableGradientTransparencyShadow=function(){this.gradientTemp=this.gradient;this.transparencyTemp=this.transparency;this.showShadowTemp=this.showShadow;this.gradient=false;this.transparency=null;this.showShadow=false};this.enableGradientTransparencyShadow=function(){this.gradient=this.gradientTemp;this.transparency=this.transparencyTemp;this.showShadow=this.showShadowTemp};this.getGradientColor=function(h){if(h.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){var f=Math.floor(parseInt(RegExp.$1)/this.gradientRatio);var e=Math.floor(parseInt(RegExp.$2)/this.gradientRatio);var a=Math.floor(parseInt(RegExp.$3)/this.gradientRatio);var d=RegExp.$4?parseFloat(RegExp.$4):false;if(d){return"rgba("+f+","+e+","+a+","+d+")"}else{return"rgb("+f+","+e+","+a+")"}}else{return false}};this.getGradient=function(e,d,c,b,a){if(this.gradientType=="radial"){return this.getRadialGradient(e,d,c,b,false,false,true)}else{return this.getLinearGradient(e,d,c,b,a,false,true)}};this.getLinearGradient=function(c,i,a,f,e,b,d){if(!d){this.ctx.save()}var h=this.ctx.createLinearGradient(c,i,a,f);if(!e){e=this.foreground}if(!b){b=this.getGradientColor(e);h.addColorStop(0,b);h.addColorStop(0.6,e);h.addColorStop(1,e)}else{h.addColorStop(0,e);h.addColorStop(1,b)}return h};this.getRadialGradient=function(j,h,a,e,d,c,i){if(!i){this.ctx.save()}var b=a/5.5;var f=this.ctx.createRadialGradient(j-b,h-b,1,j,h,a);if(!e){e=this.foreground}if(!d){if(this.transparency!=null){d="rgba(0,0,0,"+this.transparency+")"}else{d="rgb(0,0,0)"}}if(!c){c="rgba(0,0,0,0)"}f.addColorStop(0,e);f.addColorStop(1,d);f.addColorStop(1,c);return f};this.colorRGBfromString=function(b){var a=b.match(/^\W*([0-9A-F]{3}([0-9A-F]{3})?)\W*$/i);if(a){if(a[1].length===6){this.colorFromRgb(parseInt(a[1].substr(0,2),16)/255,parseInt(a[1].substr(2,2),16)/255,parseInt(a[1].substr(4,2),16)/255)}else{this.colorFromRgb(parseInt(a[1].charAt(0)+a[1].charAt(0),16)/255,parseInt(a[1].charAt(1)+a[1].charAt(1),16)/255,parseInt(a[1].charAt(2)+a[1].charAt(2),16)/255)}}};this.colorFromRgb=function(e,d,a){if(this.colorRGB){if(e!=null){this.colorRGB[0]=Math.min(Math.max(0,e),1)}if(d!=null){this.colorRGB[1]=Math.min(Math.max(0,d),1)}if(a!=null){this.colorRGB[2]=Math.min(Math.max(0,a),1)}var c=this.rgbFromHsv(this.colorRGB[0],this.colorRGB[1],this.colorRGB[2]);if(c[0]!=null){this.colorHSV[0]=c[0]}if(c[2]!=0){this.colorHSV[1]=c[1]}this.colorHSV[2]=c[2]}};this.rgbFromHsv=function(i,f,c){var j=Math.min(Math.min(i,f),c);var d=Math.max(Math.max(i,f),c);var a=d-j;if(a==0){return[null,0,d]}else{var e=i==j?3+(c-f)/a:(f==j?5+(i-c)/a:1+(f-i)/a);return[e==6?0:e,a/d,d]}};this.colorFromHsv=function(c,b,a){if(c!=null){this.colorHSV[0]=Math.min(Math.max(0,c),6)}if(b!=null){this.colorHSV[1]=Math.min(Math.max(0,b),1)}if(a!=null){this.colorHSV[2]=Math.min(Math.max(0,a),1)}this.colorRGB=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],this.colorHSV[2])};this.hsvFromRgb=function(e,d,b){if(e==null){return[b,b,b]}var c=Math.floor(e);var g=c%2?e-c:1-(e-c);var a=b*(1-d);var j=b*(1-d*g);switch(c){case 0:return[b,j,a];case 1:return[j,b,a];case 2:return[a,b,j];case 3:return[a,j,b];case 4:return[j,a,b];case 5:return[b,a,j];case 6:return[b,a,j]}};this.colorRGBToString=function(){if(this.colorRGB){return(256|Math.round(255*this.colorRGB[0])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[1])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[2])).toString(16).substr(1)}}};CanvasXpress.prototype.initText=function(){this.setTextShadow=function(a){if(this.showTextShadow){if(a){this.ctx.shadowOffsetX=this.shadowOffsetX;this.ctx.shadowOffsetY=this.shadowOffsetY;this.ctx.shadowBlur=this.shadowBlur;this.ctx.shadowColor=this.shadowColor}else{this.ctx.shadowOffsetX=0;this.ctx.shadowOffsetY=0;this.ctx.shadowBlur=0;this.ctx.shadowColor=this.background}}};this.drawTextMultiple=function(v,u,p,n,o,r,q,d,e,w){var h=v.split(/\n/);if(!n){n=this.font}var k=this.getFontPt(n)+4;if(h.length%2){p-=(parseInt(h.length/2)*k)+(k/2)}else{p=(p-parseInt(h.length/2)*k)}for(var j=0;j<h.length;j++){this.drawText(h[j],u,p,n,o,r,q,d,e,w);p+=k}};this.drawArcText=function(C,B,z,d,D,u,p,v,k,w,g,j){var q=[];if(C==null){return}if(!this.ctx){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(B)||isNaN(z)){if(this.debug){alert("Not a valid coordinate ("+B+", "+z+") to draw "+C)}return}if(!j&&!isNaN(C)){C=this.formatNumber(C)}if(!B){B=0}if(!z){z=0}if(!p){p=this.font}if(!v){v=this.foreground}if(!k){k=this.align}if(!w){w=this.baseline}this.ctx.save();this.ctx.strokeStyle=v;this.ctx.fillStyle=v;this.ctx.font=p;this.ctx.textAlign=k;this.ctx.textBaseline=w;this.setTextShadow(true);var o=u/(C.length*this.circularLetterSeparationFactor);var A=D+(u/2)+(o/2)-(o*(C.length/2));this.ctx.translate(B,z);this.ctx.rotate(A);for(var n=0;n<C.length;n++){this.ctx.save();this.ctx.rotate((n*o)+(Math.PI/2));this.ctx.fillText(C[n],0,-d);this.ctx.restore()}this.ctx.restore();this.setTextShadow(false);return q};this.drawText=function(o,l,k,z,B,D,C,g,q,p,j){var i=0;var r=function(c){c.shift();var f=[];var m=(Math.PI/2)+g==0?-Math.PI/2:g-Math.PI/2;var b=["poly"];var t=c.shift()-l;var h=c.shift()-k;var a=c.shift()-l;var s=c.shift()-k;f.push((h*Math.sin(m))-(t*Math.cos(m)));f.push((h*Math.cos(m))+(t*Math.sin(m)));f.push((s*Math.sin(m))-(t*Math.cos(m)));f.push((s*Math.cos(m))+(t*Math.sin(m)));f.push((s*Math.sin(m))-(a*Math.cos(m)));f.push((s*Math.cos(m))+(a*Math.sin(m)));f.push((h*Math.sin(m))-(a*Math.cos(m)));f.push((h*Math.cos(m))+(a*Math.sin(m)));while(f.length>1){b.push(f.shift()+l);b.push(f.shift()+k)}return b};var E=[];if(o==null){return}if(this.isMultipleLines(o)){return this.drawTextMultiple(o,l,k,z,B,D,C,g,q,p)}if(!this.ctx){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(l)||isNaN(k)){if(this.debug){alert("Not a valid coordinate ("+l+", "+k+") to draw "+o)}return}if(j){if(l<this.marginLeft+this.offsetX+this.left||l>this.marginLeft+this.offsetX+this.left+this.x){return}if(k<this.marginTop+this.offsetY+this.top||k>this.marginTop+this.offsetY+this.top+this.y){return}}if(g<(Math.PI/-2)||g>(Math.PI/2)){if(this.debug){alert("Dude, you can only rotate between -PI/2 and PI/2")}return}if(!l){l=0}if(!k){k=0}if(!z){z=this.font}if(!B){B=this.foreground}if(!D){D=this.align}if(!C){C=this.baseline}var n=this.measureText(o,z);var u=this.getFontPt(z);if(q){while(n>q&&i<10){o=o.substring(0,o.length-1);n=this.measureText(o,z);i++}}var A,e,v,d;if(D=="left"){A=l;v=A+n}else{if(D=="right"){A=l-n;v=l}else{A=l-(n/2);v=l+(n/2)}}if(C=="top"){e=k;d=e+u}else{if(C=="bottom"){e=k-u;d=k}else{e=k-(u/2);d=k+(u/2)}}E=["rect",A,e,v,d];if(g){E=r(E)}this.ctx.save();this.ctx.strokeStyle=B;this.ctx.fillStyle=B;this.ctx.font=z;this.ctx.save();this.ctx.translate(l,k);this.ctx.textAlign=D;this.ctx.textBaseline=C;this.setTextShadow(true);if(g){this.ctx.rotate(g)}if(p){this.ctx.strokeText(o,0,0)}else{this.ctx.fillText(o,0,0)}this.ctx.restore();this.setTextShadow(false);return E};this.isMultipleLines=function(b){var a=b.toString().split(/\n/);return a.length-1};this.capitalize=function(a){if(a){return a.charAt(0).toUpperCase()+a.slice(1)}};this.measureTextMultiple=function(d,e){var b=d.split(/\n/);var a=0;if(!this.ctx){return 0}if(!e){e=this.font}this.ctx.font=e;for(var c=0;c<b.length;c++){a=Math.max(a,this.ctx.measureText(b[c]).width)}return a};this.measureText=function(a,b){if(!a||!this.ctx){return 0}a=a.toString();if(!b){b=this.font}if(!CanvasXpress.cacheText[b]){CanvasXpress.cacheText[b]={}}if(!CanvasXpress.cacheText[b][a]){this.ctx.font=b;if(this.isMultipleLines(a)){CanvasXpress.cacheText[b][a]=this.measureTextMultiple(a,b)}else{CanvasXpress.cacheText[b][a]=this.ctx.measureText(a).width}}return CanvasXpress.cacheText[b][a]};this.scaleTextToFont=function(b,d,a){var c=this.fontStyle+" "+d+"px "+this.fontName;if(b){while(this.measureText(b,c)>a&&d>=this.minTextSize){d-=2;c=this.fontStyle+" "+d+"px "+this.fontName}}return c};this.getFontPt=function(a){return Math.max(1,parseInt(a.match(/[\-\d]+/)[0]))};this.scaleTextToSize=function(a){var d=this.scaleTextConstantMult;if(!a){a=1}return Math.ceil(1/Math.sqrt(a)*d)};this.formatNumber=function(g,c){if(!c){c=2}if(g.toString().length>=7){var b=sprintf("%."+c+"e",Number(g));var a=sprintf("%."+c+"f",Number(g));if(a.toString().length>b.toString().length){return b.toString()}else{return a.toString()}}else{return g.toString()}};this.bestFormatNumber=function(b,a){if(typeof b==="number"&&b%1==0){return b}else{if(a!=null&&a<1){return sprintf("%.0f",Number(b))}else{if(Math.abs(b)<0.001){return sprintf("%.2e",Number(b))}else{return sprintf("%.3f",Number(b))}}}};this.getMaxtTextBySampling=function(b,h){var c={};var f=[];var g=[];for(var e=0;e<b.length;e++){var d=b[e]!=null?b[e].toString():"";if(!c.hasOwnProperty(d)){c[d]=true;f.push([d,d.length])}}f.sort(function(j,i){return j[1]<i[1]?-1:j[1]>i[1]?1:0});if(!h){h=10}if(f.length<h){h=f.length}for(var e=0;e<h;e++){g.push(f[e][0])}return this.getMaxText(g)};this.getMaxText=function(d){var f="";var b=0;for(var e=0;e<d.length;e++){var g=this.measureText(d[e].toString(),this.font);if(g>b){f=d[e].toString();b=g}}return f};this.shortenText=function(c,b,a){if(!c){return""}c=c.toString();if(a&&c.length>b){return c.substring(0,Math.max(parseInt(a/b)-2,1))+".."}else{if(c.length<=b){return c}else{return c.substring(0,b-3)+"..."}}};this.convertToNumber=function(a){if(!isNaN(a)){return parseFloat(a)}else{return a}}};CanvasXpress.prototype.initTime=function(){Date.prototype.getWeek=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((((this-a)/86400000)+a.getDay()+1)/7)};Date.prototype.getDayYear=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((this-a)/86400000)};this.getMillisecond=function(a){return a.getMilliseconds()};this.getSecond=function(a){return a.getSeconds()};this.getMinuteSecond=function(a){return a.getMinutes()+":"+a.getSeconds()};this.getMinute=function(a){return a.getMinutes()};this.getHourMinute=function(a){return a.getHours()+":"+a.getMinutes()};this.getHour=function(a){return a.getHours()};this.getYearWeek=function(a){return a.getFullYear()+"-"+a.getWeek()};this.getYearMonth=function(a){return a.getFullYear()+"-"+a.getMonth()};this.getYear=function(a){return a.getFullYear()};this.times={second:1000,minute:60000,hour:3600000,day:86400000,week:604800000,month:2592000000,year:31556952000};this.parseDate=function(j){var f=0;var c=0;var e=0;var k=parseInt(j.toString().substring(0,4));var a=parseInt(j.toString().substring(4,6).replace(/^0/,""));var g=parseInt(j.toString().substring(6,8).replace(/^0/,""));var b=j.toString().match(/\:/)?j.toString().substring(10).split(":"):false;if(b){f=b[0]?parseInt(b[0].replace(/^0/,"")):0;c=b[1]?parseInt(b[1].replace(/^0/,"")):0;e=b[2]?parseInt(b[2].replace(/^0/,"")):0}return new Date(k,a-1,g,f,c,e)};this.setTimeAxis=function(){var h=this.validateTimeAxis();if(h){var g=Date.parse(h[h.length-1])-Date.parse(h[0]);var d;var b={};var c=[];this.timeValues=[];this.timeValueIndices=[];if(g>this.times.year*2){d="getYear"}else{if(g>this.times.month*2){d="getYearMonth"}else{if(g>this.times.week*2){d="getYearWeek"}else{if(g<this.times.second){d="getMillisecond"}else{if(g<this.times.minute){d="getSecond"}else{if(g<this.times.hour/4){d="getMinuteSecond"}else{if(g<this.times.hour){d="getMinute"}else{if(g<this.times.day/4){d="getHourMinute"}else{if(g<this.times.day){d="getHour"}else{d=false}}}}}}}}}if(d){if(this.timeTicksFirst){for(var a=0;a<h.length;a++){var e=this[d](h[a]);if(!b.hasOwnProperty(e)){c.push(h[a]);this.timeValueIndices.push(a);b[e]=true}}}else{for(var a=h.length-1;a>=0;a--){var e=this[d](h[a]);if(!b.hasOwnProperty(e)){c.unshift(h[a]);this.timeValueIndices.unshift(a);b[e]=true}}}}else{for(var a=0;a<h.length;a++){this.timeValues.push(dateFormat(h[a],this.timeFormat));this.timeValueIndices.push(a)}}var g=Date.parse(c[c.length-1])-Date.parse(c[c.length-2]);if(d=="getYear"&&g<this.times.month*3){this.timeValues.pop();this.timeValueIndices.pop()}else{if(d=="getYearMonth"&&g<this.times.week*4){this.timeValues.pop();this.timeValueIndices.pop()}else{if(d=="getYearWeek"&&g<this.times.day*7){this.timeValues.pop();this.timeValueIndices.pop()}}}for(var a=0;a<c.length;a++){this.timeValues.push(dateFormat(c[a],this.timeFormat))}}};this.createRandomTimes=function(b){var e;var g=new Date();var a=g.getTime();var f=[new Date(a)];var h=this.isGroupedData?this.data.w:this.data.y;if(!b||!this.times[b]){b="day"}for(var c=0;c<h.smps.length;c++){e=Date.parse(h.smps[c]);if(!isNaN(e)){a=e}else{a-=this.times[b]}f.unshift(new Date(a))}return f};this.validateTimeAxis=function(){var f=this.isGroupedData?this.data.w:this.data.y;var a=false;var e=[];for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices.length!=f.smps.length?Date.parse(f.smps[this.smpIndices[b]]):Date.parse(f.smps[b]);if(isNaN(c)){if(this.isExample){e=this.createRandomTimes();return e}else{a=true;break}}else{e.push(new Date(c))}}return a?false:e}};CanvasXpress.prototype.initAttributes=function(){this.setStyle=function(c,b,d){var a=this.ctx;if(this.transparency!=null){this.addColorTransparency(c,this.transparency)}a.fillStyle=c;a.strokeStyle=c;a.lineWidth=b?b:this.outlineWidth;a.lineCap=d?d:this.capType;this.setShadow(true)};this.resetStyle=function(){this.setShadow(false)};this.drawArrowHead=function(D,e,B,c,C,p,d,b,l,j){var x=this.ctx;var z=function(F,I,f,J){var w=[];for(var G=0;G<F.length;G++){w.push([(F[G][0]*Math.cos(I))-(F[G][1]*Math.sin(I)),(F[G][0]*Math.sin(I))+(F[G][1]*Math.cos(I))])}var H=[];for(var G=0;G<w.length;G++){H.push([w[G][0]+f,w[G][1]+J])}return H};var t=this.arrowPointSize;var g=Math.max((t/2)-1,1);var r=p?p/2:this.outlineWidth/2;var s=l?[[0,-t],[0,t]]:[[Math.floor((t/2.5)),0],[-t,-g*p],[-t,g*p]];var q=B-D;var o=c-e;if(d){if(d=="Y"){if(Math.abs(o)>Math.abs(q)){q=0}else{q=B>D?this.arrowPointSize:-this.arrowPointSize}}else{if(Math.abs(q)>Math.abs(o)){o=0}else{o=c>e?this.arrowPointSize:-this.arrowPointSize}}}else{if(b){var n=this.lineLength(D,e,B,c);var E=this.shortenLine(D,e,B,c,0,n/2,"line");var m=E[2];var A=E[3];var v=n/2;var h=b/v;var u=B>D?Math.asin((A-e)/v):Math.asin(-(A-e)/v);var a=j?u+(Math.PI/20):u-(Math.PI/20);if(B>D){D=m+v*Math.cos(a-h);e=A+v*Math.sin(a-h);B=m+v*Math.cos(u-h);c=A+v*Math.sin(u-h)}else{D=m+v*Math.cos((a-h)+Math.PI);e=A+v*Math.sin((a-h)+Math.PI);B=m+v*Math.cos((u-h)+Math.PI);c=A+v*Math.sin((u-h)+Math.PI)}q=B-D;o=c-e}}var k=z(s,Math.atan2(o,q),B,c);this.setStyle(C,p);x.beginPath();x.moveTo(k[0][0],k[0][1]);for(var y=1;y<k.length;y++){if(!isNaN(k[y][0])&&!isNaN(k[y][1])){x.lineTo(k[y][0],k[y][1])}}if(!l){if(!isNaN(k[0][0])&&!isNaN(k[0][1])){x.lineTo(k[0][0],k[0][1])}x.closePath();x.fill()}else{x.closePath();x.stroke()}this.resetStyle()};this.setShadow=function(a){if(this.showShadow){if(a){this.ctx.shadowOffsetX=this.shadowOffsetX;this.ctx.shadowOffsetY=this.shadowOffsetY;this.ctx.shadowBlur=this.shadowBlur;this.ctx.shadowColor=this.shadowColor}else{this.ctx.shadowOffsetX=0;this.ctx.shadowOffsetY=0;this.ctx.shadowBlur=0;this.ctx.shadowColor=this.background}}};this.validateNumbers=function(b){for(var c=0;c<b.length;c++){if(isNaN(b[c])){return false}}return true};this.lineTo=function(b,d,a,c){if(b==a){b=(((b+0.5)<<1)>>1)+0.5;a=b}else{if(d==c){d=(((d+0.5)<<1)>>1)+0.5;c=d}}this.ctx.moveTo(b,d);this.ctx.lineTo(a,c);this.ctx.stroke()};this.clip=function(v,f,k){var d,c,p,n,j,o,v;var q,e,a,m;var u=[];if(k&&k.length==4){e=k[0];q=k[1];a=e+k[2];m=q+k[3]}else{e=this.marginLeft+this.offsetX+this.left;q=this.marginTop+this.offsetY+this.top;a=e+this.x;m=q+this.y}switch(v){case"path":u[0]=[];u[1]=[];for(var g=0;g<f[0].length;g++){c=f[0][g];n=f[1][g];if(c<e||c>a){c=null}if(n<q||n>m){n=null}u[0].push(c);u[1].push(n)}break;case"box":case"rect":case"rectangle":case"rect2":case"rect3":case"roundrect":d=this.parseInt(f[0]-(f[2]/2));p=this.parseInt(f[1]-(f[3]/2));c=this.parseInt(d+f[2]);n=this.parseInt(p+f[3]);if(c>d){if(n>p){if(d>a+this.outlineWidth||p>m+this.outlineWidth||c<e||n<q){return false}if(d<e){d=e}if(c>a){c=a}if(p<q){p=q}if(n>m){n=m}}else{if(d>a+this.outlineWidth||n>m+this.outlineWidth||c<e||p<q){return false}if(d<e){d=e}if(c>a){c=a}if(p>m){p=m}if(n<q){n=q}}}else{if(n>p){if(c>a+this.outlineWidth||p>m+this.outlineWidth||d<e||n<q){return false}if(d>a){d=a}if(c<e){c=e}if(p<q){p=q}if(n>m){n=m}}else{if(c>a+this.outlineWidth||n>m+this.outlineWidth||d<e||p<q){return false}if(d>a){d=a}if(c<e){c=e}if(p>m){p=m}if(n<q){n=q}}}u=[d,p,c-d,n-p];break;case"poly":break;case"circle":case"sphere":case"square":case"triangle":case"triangle2":case"equilateral":case"equilateral2":case"diamond":case"rhombus":case"hexagon":case"octagon":case"oval":case"oval2":case"oval3":case"arc":case"arc2":case"arc3":case"ellipse":case"ellipse2":case"ellipse3":case"plus":case"minus":case"mdavid":case"star":case"pie":case"pie0":case"pie1":case"pie2":case"pie3":case"pie4":case"pie5":case"pie6":case"pie7":case"pie8":case"pie9":case"pacman":case"pacman2":d=parseInt(f[0]);p=parseInt(f[1]);if(d>a||d<e||p<q||p>m){return false}u=[d,p];break;case"line":d=parseFloat(f[0]);p=parseFloat(f[1]);c=parseFloat(f[2]);n=parseFloat(f[3]);if(d==c){if(d<e||d>a){return false}else{if(p>n){if(p<q){return false}else{if(p>m){p=m}}if(n>m){return false}else{if(n<q){n=q}}}else{if(p>m){return false}else{if(p<q){p=q}}if(n<q){return false}else{if(n>m){n=m}}}}}else{if(p==n){if(p<q||p>m){return false}else{if(d>c){if(d<e){return false}else{if(d>a){d=a}}if(c>a){return false}else{if(c<e){c=e}}}else{if(d>a){return false}else{if(d<e){d=e}}if(c<e){return false}else{if(c>a){c=a}}}}}else{if(d>c){if(d<e||c>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=d-c;if(d>a){p-=(d-a)*j/o;d=a}if(p>m){d-=(p-m)*o/j;p=m}if(c<e){n+=(e-c)*j/o;c=e}if(n<q){c+=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=d-c;if(d>a){p+=(d-a)*j/o;d=a}if(p<q){d-=(q-p)*o/j;p=q}if(c<e){n-=(e-c)*j/o;c=e}if(n>m){c+=(n-m)*o/j;n=m}}}}}else{if(c<e||d>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=c-d;if(d<e){p-=(e-d)*j/o;d=e}if(p>m){d+=(p-m)*o/j;p=m}if(c>a){n+=(c-a)*j/o;c=a}if(n<q){c-=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=c-d;if(d<e){p+=(e-d)*j/o;d=e}if(p<q){d+=(q-p)*o/j;p=q}if(c>a){n-=(c-a)*j/o;c=a}if(n>m){c-=(n-m)*o/j;n=m}}}}}}}u=[d,p,c,n];break;default:return false}return u};this.lineLength=function(b,d,a,c){return Math.sqrt(Math.pow(a-b,2)+Math.pow(c-d,2))};this.shortenLine=function(b,j,a,i,k,f,l){if(this.validateNumbers([b,j,a,i,k,f])){if(l.match(/bezier/i)){if(l.match(/beziery/i)){return i>j?[b,j+k,a,i-f]:[b,j-k,a,i+f]}else{return a>b?[b+k,j,a-f,i]:[b-k,j,a+f,i]}}else{if(l.match(/curved/i)){return[b,j,a,i]}else{var c=Math.atan2(i-j,a-b);var d=Math.cos(c);var h=Math.sin(c);var g=this.lineLength(b,j,a,i);if(g){while(g<(k+f)){k/=1.1;f/=1.1}b+=d*k;j+=h*k;a-=d*f;i-=h*f}}}return[b,j,a,i]}};this.errorBar=function(e,g,d,f,a,h){if(!this.isGroupedData&&this.isRawData){}if(this.showErrorBars&&this.validateNumbers([a])){var b=this.drawLine("line",e,g,d,f,h,false,false,false,false,true);if(Math.abs(a)>this.showErrorBarsWidth){if(a>0){this.drawLine("line",d,f-a/2,d,f+a/2,h,false,false,false,false,true)}else{this.drawLine("line",d-a/2,f,d+a/2,f,h,false,false,false,false,true)}}return b}};this.splineControlPoint=function(e,m,d,l,c,k){var n=Math.sqrt(Math.pow(d-e,2)+Math.pow(l-m,2));var h=Math.sqrt(Math.pow(c-d,2)+Math.pow(k-l,2));var g=this.tension*n/(n+h);var f=this.tension-g;var b=d+g*(e-c);var a=l+g*(m-k);var j=d-f*(e-c);var i=l-f*(m-k);return[b,a,j,i]};this.drawLine=function(W,G,a,D,ap,aj,V,aa,Y,al,am,ao){var H=this.ctx;var ad;var M=[];var R=false;var z=false;var v=false;var ae=this.lineWidthEvent;var h=function(){var b;b=G;G=D;D=b;b=a;a=ap;ap=b};if(W=="spline"){if(G.length<3){return G.length<2?false:this.drawLine("line",G[0],a[0],G[1],a[1],aj,V,aa,Y,al,am,ao)}var X=[];var an=[];var Z=[];var ac=0;M=["poly"];for(var ah=0;ah<G.length;ah++){if(this.validateNumbers([G[ah],a[ah]])){an.push(G[ah],a[ah]);M.push(G[ah],a[ah]-2);Z.push(a[ah]+2,G[ah]);ac+=2}else{return false}}M=M.concat(Z.reverse());this.setStyle(aj,V,aa);for(var ah=0;ah<ac-4;ah+=2){X=X.concat(this.splineControlPoint(an[ah],an[ah+1],an[ah+2],an[ah+3],an[ah+4],an[ah+5]))}H.beginPath();H.moveTo(an[0],an[1]);H.quadraticCurveTo(X[0],X[1],an[2],an[3]);for(var ah=2;ah<ac-5;ah+=2){H.bezierCurveTo(X[2*ah-2],X[2*ah-1],X[2*ah],X[2*ah+1],an[ah+2],an[ah+3])}H.moveTo(an[ac-2],an[ac-1]);H.quadraticCurveTo(X[2*ac-10],X[2*ac-9],an[ac-4],an[ac-3]);H.stroke();this.resetStyle();return M}else{if(W=="arch"){if(G.length!=3||a.length!=3){return false}for(var ah=0;ah<G.length;ah++){if(!this.validateNumbers([G[ah],a[ah]])){return false}}M=["poly"];this.setStyle(aj,V,aa);H.beginPath();H.moveTo(G[0],a[0]);H.quadraticCurveTo(G[1],a[1],G[2],a[2]);H.stroke();this.resetStyle()}else{if(this.validateNumbers([G,a,D,ap])){if(!Y){Y=0}if(!al){al=0}if(W.match(/bezier/i)){if(W.match(/beziery/i)){ad="bezierLine";z="Y";R="Y";if(Y||al){if(ap>a){if(a+Y>ap-al){W=W.replace(/beziery/i,"");ad="line";z=false;R=false}}else{if(a-Y<ap+al){W=W.replace(/beziery/i,"");ad="line";z=false;R=false}}}}else{ad="bezierLine";z="X";R="X";if(Y||al){if(D>G){if(G+Y>D-al){W=W.replace(/bezier[x]?/i,"");ad="line";z=false;R=false}}else{if(G-Y<D+al){W=W.replace(/bezier[x]?/i,"");ad="line";z=false;R=false}}}}}else{if(W.match(/curved/i)){if(W.match(/curvedc/i)){ad="curvedLine";v=true;R=true}else{ad="curvedLine";v=true;R=false}}else{if(W.match(/dashed/i)){ad="dashedLine"}else{if(W.match(/dotted/i)){ad="dottedLine"}else{ad="line"}}}}if((Y||al)){var ab=this.shortenLine(G,a,D,ap,Y,al,W);G=ab[0];a=ab[1];D=ab[2];ap=ab[3]}if(am){var K=this.clip("line",[G,a,D,ap],ao);if(K){G=K[0];a=K[1];D=K[2];ap=K[3]}else{return false}}switch(ad){case"dashedLine":case"dottedLine":var l=Math.atan2(ap-a,D-G);var Q=Math.cos(l);var I=Math.sin(l);var L=this.lineLength(G,a,D,ap);var q=ad=="dashedLine"?this.dashLength:this.dotLength;var ag=Math.floor(L/(q*2))-1;if(ag){var T=Q*q;var S=I*q;var g=G;var ak=a;var d=D;var ai=ap;d=g+T;ai=ak+S;for(var ah=0;ah<ag;ah++){this.drawLine("line",g,ak,d,ai,aj,V,aa);g+=(T*2);ak+=(S*2);d=g+T;ai=ak+S}this.drawLine("line",g,ak,d,ai,aj,V,aa);M=["poly",G+ae,a,D+ae,ap,D-ae,ap,G-ae,a]}else{return false}break;case"bezierLine":if(G==D||a==ap){return this.drawLine("line",G,a,D,ap,aj,V,aa,Y,al,am,ao)}G=parseInt(G)+0.5;a=parseInt(a)+0.5;D=parseInt(D)+0.5;ap=parseInt(ap)+0.5;R=R=="Y"?"Y":"X";var O=D>G?true:false;var o=(G+D)/2;var m=(a+ap)/2;if(O){if(R=="X"){M=["poly",G,a-2,o+2,a-2,o+2,ap-2,D,ap-2,D,ap+2,o-2,ap+2,o-2,a+2,G,a+2]}else{M=["poly",G-2,a,G-2,m+2,D-2,m+2,D-2,ap,D+2,ap,D+2,m-2,G+2,m-2,G+2,a]}}else{if(R=="X"){M=["poly",G,a-2,o-2,a-2,o-2,ap-2,D,ap-2,D,ap+2,o+2,ap+2,o+2,a+2,G,a+2]}else{M=["poly",G-2,a,G-2,m-2,D-2,m-2,D-2,ap,D+2,ap,D+2,m+2,G+2,m+2,G+2,a]}}this.setStyle(aj,V,aa);H.moveTo(G,a);if(R=="Y"){H.bezierCurveTo(G,ap,D,a,D,ap)}else{H.bezierCurveTo(D,a,G,ap,D,ap)}H.stroke();this.resetStyle();break;case"curvedLine":var o=12;var u=1;var L=this.lineLength(G,a,D,ap);var F=this.shortenLine(G,a,D,ap,0,L/2,"line");var P=F[2];var E=F[3];var U=L/2;var N=Y/U;var J=al/U;var k=(P-G);var j=(E-a);var C=R&&G>D?false:!R&&D>=G?true:R;var r=D>=G?Math.asin(j/U):Math.asin(-j/U);var af=r+Math.PI;var B=Math.PI/o;var A=D>=G?0:Math.PI;M=["poly"];for(var ah=u;ah<=o-u;ah++){M.push(P-(U+2)*Math.cos(r+((B*ah))-A));M.push(E-(U+2)*Math.sin(r+((B*ah))-A))}for(var ah=o-u;ah>=u;ah--){M.push(P-(U-2)*Math.cos(r+((B*ah))-A));M.push(E-(U-2)*Math.sin(r+((B*ah))-A))}this.setStyle(aj,V,aa);H.beginPath();if(D>=G){H.arc(P,E,U,r-J,af+N,C)}else{H.arc(P,E,U,r+N,af-J,C)}H.stroke();this.resetStyle();break;case"line":M=["poly",G+ae,a,D+ae,ap,D-ae,ap,G-ae,a];this.setStyle(aj,V,aa);H.beginPath();this.lineTo(G,a,D,ap);this.resetStyle();break}if(W.match(/arrowheadsquaretail|squaretailarrowhead/i)){v=v?al:false;this.drawArrowHead(G,a,D,ap,aj,V,z,v);h();if(W.match(/curve/i)){v=-Y}this.drawArrowHead(G,a,D,ap,aj,V,z,v,true)}else{if(W.match(/arrowtailsquarehead|squareheadarrowtail/i)){v=v?al:false;this.drawArrowHead(G,a,D,ap,aj,V,z,v,true);h();if(W.match(/curve/i)){v=-Y}this.drawArrowHead(G,a,D,ap,aj,V,z,v,false,true)}else{if(W.match(/arrowhead/i)){v=v?al:false;this.drawArrowHead(G,a,D,ap,aj,V,z,v)}else{if(W.match(/squarehead/i)){v=v?al:false;this.drawArrowHead(G,a,D,ap,aj,V,z,v,true)}else{if(W.match(/arrowtail/i)){h();if(W.match(/curve/i)){v=-Y}this.drawArrowHead(G,a,D,ap,aj,V,z,v,false,true)}else{if(W.match(/squaretail/i)){h();if(W.match(/curve/i)){v=-Y}this.drawArrowHead(G,a,D,ap,aj,V,z,v,true,true)}else{if(W.match(/arrow/i)){v=v?al:false;this.drawArrowHead(G,a,D,ap,aj,V,z,v);h();if(W.match(/curve/i)){v=-Y}this.drawArrowHead(G,a,D,ap,aj,V,z,v,false,true)}else{if(W.match(/square/i)){v=v?al:false;this.drawArrowHead(G,a,D,ap,aj,V,z,v,true);h();if(W.match(/curve/i)){v=-Y}this.drawArrowHead(G,a,D,ap,aj,V,z,v,true,true)}}}}}}}}return M}else{return false}}}};this.polygon=function(l,k,g,e,d,a,i,h,j){return this.drawShape("polygon",l,k,false,false,g,e,d,a,i,h,j)};this.circle=function(n,m,q,g,i,e,d,a,k,j,l){return this.drawShape("circle",n,m,q,g,i,e,d,a,k,j,l)};this.rectangle=function(n,m,q,g,i,e,d,a,k,j,l){return this.drawShape("rectangle",n+(q/2),m+(g/2),q,g,i,e,d,a,k,j,l)};this.roundRectangle=function(n,m,q,g,i,e,d,a,k,j,l){return this.drawShape("roundrect",n+(q/2),m+(g/2),q,g,i,e,d,a,k,j,l)};this.drawShape=function(W,Q,P,S,al,am,ad,ac,Y,O,au,aw,X,ap,T,ar){var K,av,L,j,ax,Z,ag;var N=this;var G=this.ctx;var aa=function(){G.translate(Q,P);if(Y){G.rotate(Y)}if(N.transparency!=null){N.addColorTransparency(am,N.transparency)}if(N.gradient){if(N.gradientType=="radial"){G.fillStyle=N.getGradient(0,0,Math.max(Math.abs(S),Math.abs(al)),am)}else{G.fillStyle=N.getGradient(0,0,S,al,am)}}else{if(ac){switch(ac){case"closed":case"solid":G.fillStyle=am;break;case"open":break;default:if(!CanvasXpress.cachePatterns[ac]){var b=U();if(b){CanvasXpress.cachePatterns[ac]=N.ctx.createPattern(b,"repeat")}else{CanvasXpress.cachePatterns[ac]=am}}G.fillStyle=CanvasXpress.cachePatterns[ac];break}}else{G.fillStyle=am}}G.strokeStyle=ad?ad:N.foreground;G.lineWidth=O?O:N.outlineWidth;G.lineJoin=N.joinType;N.setShadow(true)};var at=function(c){if(K&&K.length>1){var b=K.shift();while(b[0]==null||b[1]==null){b=K.shift()}G.beginPath();G.moveTo(b[0]+0.5,b[1]+0.5);while(K.length>0){b=K.shift();while(b[0]==null||b[1]==null){b=K.shift()}G.lineTo(b[0]+0.5,b[1]+0.5)}if(!c){G.closePath()}}};var M=function(){if(ac&&ac=="open"){G.stroke()}else{if(am==ad||(N.patternBy&&N.graphType=="Heatmap"&&au)){G.fill()}else{G.stroke();G.fill()}}};var H=function(){N.setShadow(false);if(Y){G.rotate(-Y)}G.translate(-Q,-P)};var an=function(){var o=Math.sin(Y);var r=Math.cos(Y);if(L){if(L[0]=="circle"){return L}var e=L.shift();var i=[];if(e=="rect"){var n=L.shift()-Q;var p=L.shift()-P;var d=L.shift()-Q;var h=L.shift()-P;i.push((p*o)-(n*r));i.push((p*r)+(n*o));i.push((h*o)-(n*r));i.push((h*r)+(n*o));i.push((h*o)-(d*r));i.push((h*r)+(d*o));i.push((p*o)-(d*r));i.push((p*r)+(d*o))}else{while(L.length>1){var f=L.shift()-Q;var b=L.shift()-P;i.push((b*o)-(f*r));i.push((b*r)+(f*o))}}var c=["poly"];while(i.length>1){c.push(i.shift()+Q);c.push(i.shift()+P)}return c}};var U=function(){for(var b=0;b<N.patternImages.length;b++){if(N.patternNames[b]==ac){return CanvasXpress.cacheImages[N.getFileName(N.patternImages[b])]}}return false};if(ac){switch(ac){case"closed":case"solid":case"open":break;default:var ay=ac;ac="closed";this.drawShape(W,Q,P,S,al,am,am,ac,Y,O,au,aw,X,ap,T,ar);ac=ay;break}}switch(W){case"polygon":case"path":case"spline":case"arch":var ai=Number.MAX_VALUE;var J=Number.MAX_VALUE*-1;var ah=Number.MAX_VALUE;var I=Number.MAX_VALUE*-1;var ab=[];av=[];K=[];L=["poly"];if(Q.length==P.length){if(W=="spline"&&Q.length<5){return false}if(W=="arch"&&(Q.length!=6||P.length!=6||S.length!=4||al==null)){return false}if(W=="path"&&au){var F=N.clip(W,[Q,P],aw);Q=F[0];P=F[1]}for(var ak=0;ak<Q.length;ak++){if(Q[ak]&&P[ak]&&this.validateNumbers([Q[ak],P[ak]])){ai=Math.min(ai,Q[ak]);J=Math.max(J,Q[ak]);ah=Math.min(ah,P[ak]);I=Math.max(I,P[ak]);K.push([Q[ak],P[ak]]);if(W=="spline"){L.push(Q[ak],P[ak]-2);ab.push(P[ak]+2,Q[ak])}else{L.push(Q[ak],P[ak])}}}Q=W=="arch"?Q[1]:(ai+J)/2;P=W=="arch"?P[1]:(ah+I)/2;for(var ak=0;ak<K.length;ak++){K[ak][0]-=Q;K[ak][1]-=P;av.push(K[ak][0],K[ak][1])}if(W=="spline"){L=L.concat(ab.reverse())}}else{return false}break;default:if(this.validateNumbers([Q,P,S,al])){if(au){K=this.clip(W,[Q,P,S,al],aw);if(K){if(K.length==4){S=Math.max(1,K[2]);al=Math.max(1,K[3]);Q=K[0]+(S/2);P=K[1]+(al/2)}else{if(K.length==2){Q=K[0];P=K[1]}}}else{return false}}else{S=Math.max(1,S);al=Math.max(1,al)}j=S/2;ax=al/2;Z=al/S;ag=1.5;L=["rect",Q-j,P-ax,Q+j,P+ax]}else{return false}break}switch(W){case"image":if(T&&CanvasXpress.cacheImages[this.getFileName(T)]){L=["rect",Q-(j*this.zoom),P-(ax*this.zoom),Q+(j*this.zoom),P+(ax*this.zoom)];aa();this.drawImage(CanvasXpress.cacheImages[this.getFileName(T)],-j*this.zoom,-ax*this.zoom,S*this.zoom,al*this.zoom)}else{return this.drawShape("rectangle",Q,P,S,al,am,ad,ac,Y,O,au,aw,X,ap,T,ar)}break;case"circle":case"sphere":L=["circle",Q,P,S/2];aa();G.beginPath();G.arc(0,0,S/2,0,Math.PI*2,true);G.closePath();M();break;case"box":case"rect":case"rectangle":K=[[-j,-ax],[j,-ax],[j,ax],[-j,ax]];aa();at();M();break;case"rect2":return this.drawShape("rectangle",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,X,ap,T,ar);break;case"rect3":return this.drawShape("rectangle",Q,P,S,S/3,am,ad,ac,Y,O,au,aw,X,ap,T,ar);break;case"roundrect":var R=S>al?al/4:S/4;aa();G.beginPath();G.moveTo(-j,-ax+R);G.lineTo(-j,ax-R);G.quadraticCurveTo(-j,ax,-j+R,ax);G.lineTo(j-R,ax);G.quadraticCurveTo(j,ax,j,ax-R);G.lineTo(j,-ax+R);G.quadraticCurveTo(j,-ax,j-R,-ax);G.lineTo(-j+R,-ax);G.quadraticCurveTo(-j,-ax,-j,-ax+R);G.closePath();M();break;case"square":K=[[-j,-j],[j,-j],[j,j],[-j,j]];aa();at();M();break;case"triangle":if(S==al){return this.drawShape("equilateral",Q,P,S,al,am,ad,ac,Y,O,au,aw,X,ap,T,ar)}L=["poly",Q,P-ax,Q+j,P+ax,Q-j,P+ax];K=[[0,-ax],[j,ax],[-j,ax]];aa();at();M();break;case"triangle2":if(S==al){return this.drawShape("equilateral2",Q,P,S,al,am,ad,ac,Y,O,au,aw,X,ap,T,ar)}L=["poly",Q,P+ax,Q+j,P-ax,Q-j,P-ax];K=[[0,ax],[j,-ax],[-j,-ax]];aa();at();M();break;case"equilateral":var R=S*Math.sqrt(3)/6;var g=R/2;var A=Math.sqrt((R*R)-(g*g));L=["poly",Q,P-R,Q+A,P+g,Q-A,P+g];K=[[0,-ax],[j,ax],[-j,ax]];aa();at();M();break;case"equilateral2":var R=S*Math.sqrt(3)/6;var g=R/2;var A=Math.sqrt((R*R)-(g*g));L=["poly",Q,P+R,Q+A,P-g,Q-A,P-g];K=[[0,ax],[j,-ax],[-j,-ax]];aa();at();M();break;case"diamond":case"rhombus":L=["poly",Q,P-ax,Q+j,P,Q,P+ax,Q-j,P];K=[[0,-ax],[j,0],[0,ax],[-j,0]];aa();at();M();break;case"hexagon":var aq=S/3;var l=aq-j;K=[[l,-ax],[-l,-ax],[j,0],[-l,ax],[l,ax],[-j,0]];aa();at();M();break;case"octagon":var az=S/4;var aj=al/4;K=[[-az,-ax],[az,-ax],[j,-aj],[j,aj],[az,ax],[-az,ax],[-j,aj],[-j,-aj]];aa();at();M();break;case"oval":aa();G.save();G.scale(1,Z);G.beginPath();G.arc(0,0,S/2,0,Math.PI*2,true);G.closePath();G.restore();M();break;case"oval2":return this.drawShape("oval",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,X,ap,T,ar);break;case"oval3":return this.drawShape("oval",Q,P,S,S/3,am,ad,ac,Y,O,au,aw,X,ap,T,ar);break;case"arc":aa();G.save();G.scale(1,Z);G.beginPath();G.arc(0,0,S/2,0,Math.PI,true);if(ac!="open"){G.closePath()}G.restore();M();break;case"arc2":var C=al*Math.cos(X);var aB=al*Math.sin(X);var B=al*Math.cos(ap);var aA=al*Math.sin(ap);var v=this.shortenLine(0,0,C,aB,0,S,"line");var m=this.shortenLine(0,0,B,aA,0,S,"line");aa();G.beginPath();G.moveTo(v[2],v[3]);G.lineTo(C,aB);G.arc(0,0,al,X,ap,false);G.lineTo(m[2],m[3]);G.arc(0,0,al-S,ap,X,true);G.closePath();M();break;case"arc3":ac="open";aa();G.beginPath();G.arc(0,0,S/2,X,ap,false);M();break;case"arch":aa();G.beginPath();G.moveTo(K[0][0],K[0][1]);G.quadraticCurveTo(K[1][0],K[1][1],K[2][0],K[2][1]);G.arc(0,0,al,S[3],S[2],true);G.quadraticCurveTo(K[4][0],K[4][1],K[5][0],K[5][1]);G.arc(0,0,al,S[1],S[0],true);G.closePath();M();break;case"path":aa();at(open);M();break;case"polygon":aa();at();M();break;case"spline":var V=[];var af=[];var D=[];af.push(av.shift());af.push(av.shift());D.push(av.pop());D.unshift(av.pop());var ae=av.length;for(var ak=0;ak<ae-4;ak+=2){V=V.concat(N.splineControlPoint(av[ak],av[ak+1],av[ak+2],av[ak+3],av[ak+4],av[ak+5]))}aa();G.beginPath();G.moveTo(af[0],af[1]);G.lineTo(av[0],av[1]);G.quadraticCurveTo(V[0],V[1],av[2],av[3]);for(var ak=2;ak<ae-5;ak+=2){G.bezierCurveTo(V[2*ak-2],V[2*ak-1],V[2*ak],V[2*ak+1],av[ak+2],av[ak+3])}G.quadraticCurveTo(V[2*ae-10],V[2*ae-9],av[ae-2],av[ae-1]);G.lineTo(D[0],D[1]);G.lineTo(af[0],af[1]);M();break;case"ellipse":var a=j*0.5522848;var ao=ax*0.5522848;aa();G.beginPath();G.moveTo(0,ax);G.bezierCurveTo(0,ax-ao,j-a,0,j,0);G.bezierCurveTo(j+a,0,S,ax-ao,S,ax);G.bezierCurveTo(S,ax+ao,j+a,al,j,al);G.bezierCurveTo(j-a,al,0,ax+ao,0,ax);G.closePath();M();break;case"ellipse2":return this.drawShape("ellipse",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,X,ap,T,ar);break;case"ellipse3":return this.drawShape("ellipse",Q,P,S,S/3,am,ad,ac,Y,O,au,aw,X,ap,T,ar);break;case"plus":K=[[-ag,-ax],[ag,-ax],[ag,-ag],[j,-ag],[j,ag],[ag,ag],[ag,ax],[-ag,ax],[-ag,ag],[-j,ag],[-j,-ag],[-ag,-ag],[-ag,-ax]];aa();at();M();break;case"minus":K=[[-j,-ag],[j,-ag],[j,ag],[-j,ag],[-j,-ag]];aa();at();M();break;case"mdavid":var aq=S/3;var q=Math.PI/6;L=["circle",Q,P,S/2];aa();G.save();G.scale(0.8,0.8);G.rotate(E*0.45);G.beginPath();G.moveTo(aq,0);for(var ak=0;ak<11;ak++){G.rotate(q);if(ak%2==0){G.lineTo((aq/0.55),0)}else{G.lineTo(aq,0)}}G.closePath();G.restore();M();break;case"star":var k=(S/4);var E=Math.PI/5;L=["circle",Q,P,S/2];aa();G.save();G.scale(0.7,0.7);G.rotate(E*0.45);G.beginPath();G.moveTo(k,0);for(var ak=0;ak<9;ak++){G.rotate(E);if(ak%2==0){G.lineTo((k/0.35),0)}else{G.lineTo(k,0)}}G.closePath();G.restore();M();break;case"pie":if(typeof(X)=="undefined"){X=0}if(typeof(ap)=="undefined"){ap=Math.PI*2}aa();G.beginPath();G.arc(0,0,S/2,X,ap,false);G.lineTo(0,0);G.closePath();M();break;case"pie0":return this.drawShape("pie",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,0,Math.PI/5,T,ar);break;case"pie1":return this.drawShape("pie",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,0,Math.PI/3.5,T,ar);break;case"pie2":return this.drawShape("pie",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,0,Math.PI/2,T,ar);break;case"pie3":return this.drawShape("pie",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,0,Math.PI/1.5,T,ar);break;case"pie4":return this.drawShape("pie",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,0,Math.PI,T,ar);break;case"pie5":return this.drawShape("pie",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,0,Math.PI*1.2,T,ar);break;case"pie6":return this.drawShape("pie",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,0,Math.PI*1.4,T,ar);break;case"pie7":return this.drawShape("pie",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,0,Math.PI*1.6,T,ar);break;case"pie8":return this.drawShape("pie",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,0,Math.PI*1.8,T,ar);break;case"pie9":return this.drawShape("pie",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,0,Math.PI*2,T,ar);break;case"pacman":return this.drawShape("pie",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,Math.PI*1/4,Math.PI*7/4,T,ar);break;case"pacman2":return this.drawShape("pie",Q,P,S,S/2,am,ad,ac,Y,O,au,aw,Math.PI*5/4,Math.PI*3/4,T,ar);break}H();return L};this.drawImage=function(b,a,m,k,c,n){if(this.isIE&&this.useFlashIE&&this.browserVersion<9&&b==1){var g=this;var d=function(){g.drawImage(CanvasXpress.cacheImages[g.getFileName(n)],a,m,k,c)};CanvasXpress.cacheImages[this.getFileName(n)].onload=d;CanvasXpress.cacheImages[this.getFileName(n)].src=n}else{try{this.ctx.drawImage(b,a,m,k,c)}catch(j){var g=this;setTimeout(function(){g.draw()},100)}}};this.drawVideo=function(c,b,d){var e=this;var a=this.ctx;if(c.paused||c.ended){return false}a.drawImage(c,0,0,b,d);this.videoUpdate();setTimeout(function(){e.drawVideo(c,b,d)},50)};this.setGlobalCompositionOperation=function(a){if(!this.isIE&&a){this.ctx.globalCompositeOperation=a}};this.rectangleClear=function(a,d,b,c){this.ctx.clearRect(a,d,b,c)};this.translateCanvas=function(a,b){this.ctx.translate(a,b)};this.rotateCanvas=function(a){this.ctx.rotate(a)};this.scaleCanvas=function(a,b){this.ctx.scale(a,b)};this.saveCanvas=function(){this.ctx.save()};this.restoreCanvas=function(){this.ctx.restore()};this.setRGB=function(){this.reds=[];this.greens=[];this.blues=[];this.yellows=[];this.cyans=[];this.purples=[];this.greys=[];this.indicatorBins=this.scatterPlotMatrix?Math.min(this.x,this.y)/(this.layoutRows*2):Math.min(this.x,this.y)/4;this.indicatorBins=this.indicatorBins>512?1:this.indicatorBins>256?2:this.indicatorBins>128?4:8;var e=this.indicatorBins;var c=parseInt(256/e);var d;var b=255;for(var a=0;a<c;a++){this.greys.push("rgb("+b+","+b+","+b+")");b-=e}if(this.indicatorCenter=="rainbow-green"){d=e-1;b=255;for(var a=0;a<c;a++){this.greens.push("rgb(0,255,"+d+")");this.cyans.push("rgb(0,"+b+",255)");this.blues.push("rgb("+d+",0,255)");this.purples.push("rgb(255,0,"+b+")");this.reds.push("rgb(255,"+d+",0)");this.yellows.push("rgb("+b+",255,0)");d+=e;b-=e}}else{if(this.indicatorCenter.match("rainbow")){d=e-1;b=255;for(var a=0;a<c;a++){this.reds.push("rgb(255,0,"+d+")");this.purples.push("rgb("+b+",0,255)");this.blues.push("rgb(0,"+d+",255)");this.cyans.push("rgb(0,255,"+b+")");this.greens.push("rgb("+d+",255,0)");this.yellows.push("rgb(255,"+b+",0)");d+=e;b-=e}}else{if(this.indicatorCenter=="black"){d=255;for(var a=0;a<c;a++){this.reds.push("rgb("+d+",0,0)");this.purples.push("rgb("+d+",0,"+d+")");this.blues.push("rgb(0,0,"+d+")");this.cyans.push("rgb(0,"+d+","+d+")");this.greens.push("rgb(0,"+d+",0)");this.yellows.push("rgb("+d+","+d+",0)");d-=e}}else{this.reds.push("rgb(255,0,0)");this.purples.push("rgb(255,0,255)");this.blues.push("rgb(0,0,255)");this.cyans.push("rgb(0,255,255)");this.greens.push("rgb(0,255,0)");this.yellows.push("rgb(255,255,0)");d=e-1;for(var a=0;a<c-1;a++){this.reds.push("rgb(255,"+d+","+d+")");this.purples.push("rgb(255,"+d+",255)");this.blues.push("rgb("+d+","+d+",255)");this.cyans.push("rgb("+d+",255,255)");this.greens.push("rgb("+d+",255,"+d+")");this.yellows.push("rgb(255,255,"+d+")");d+=e}}}}};this.setLineTypes=function(){this.lines=this.getLineTypes()};this.setAmbiguityCodes=function(){this.ambiguityCodes={"-":["-"],A:["A"],C:["C"],G:["G"],T:["T"],M:["A","C"],R:["A","G"],W:["A","T"],S:["C","G"],Y:["C","T"],K:["G","T"],V:["A","C","G"],H:["A","C","T"],D:["A","G","T"],B:["C","G","T"],N:["A","C","G","T"],X:["A","C","G","T"]}};this.setCodonTable=function(){this.codon={TTT:["F","Phe","Phenylalanine"],TCT:["S","Ser","Serine"],TAT:["Y","Tyr","Tyrosine"],TGT:["C","Cys","Cysteine"],TTC:["F","Phe","Phenylalanine"],TCC:["S","Ser","Serine"],TAC:["Y","Tyr","Tyrosine"],TGC:["C","Cys","Cysteine"],TTA:["L","Leu","Leucine"],TCA:["S","Ser","Serine"],TAA:["*","Stop","Ochre"],TGA:["*","Stop","Opal"],TTG:["L","Leu","Leucine"],TCG:["S","Ser","Serine"],TAG:["*","Stop","Amber"],TGG:["W","Trp","Tryptophan"],CTT:["L","Leu","Leucine"],CCT:["P","Pro","Proline"],CAT:["H","His","Histidine"],CGT:["R","Arg","Arginine"],CTC:["L","Leu","Leucine"],CCC:["P","Pro","Proline"],CAC:["H","His","Histidine"],CGC:["R","Arg","Arginine"],CTA:["L","Leu","Leucine"],CCA:["P","Pro","Proline"],CAA:["Q","Gln","Glutamine"],CGA:["R","Arg","Arginine"],CTG:["L","Leu","Leucine"],CCG:["P","Pro","Proline"],CAG:["Q","Gln","Glutamine"],CGG:["R","Arg","Arginine"],ATT:["I","Ile","Isoleucine"],ACT:["T","Thr","Threonine"],AAT:["N","Asn","Asparagine"],AGT:["S","Ser","Serine"],ATC:["I","Ile","Isoleucine"],ACC:["T","Thr","Threonine"],AAC:["N","Asn","Asparagine"],AGC:["S","Ser","Serine"],ATA:["I","Ile","Isoleucine"],ACA:["T","Thr","Threonine"],AAA:["K","Lys","Lysine"],AGA:["R","Arg","Arginine"],ATG:["M","Met","Methionine"],ACG:["T","Thr","Threonine"],AAG:["K","Lys","Lysine"],AGG:["R","Arg","Arginine"],GTT:["V","Val","Valine"],GCT:["A","Ala","Alanine"],GAT:["D","Asp","Aspartic acid"],GGT:["G","Gly","Glycine"],GTC:["V","Val","Valine"],GCC:["A","Ala","Alanine"],GAC:["D","Asp","Aspartic acid"],GGC:["G","Gly","Glycine"],GTA:["V","Val","Valine"],GCA:["A","Ala","Alanine"],GAA:["E","Glu","Glutamic acid"],GGA:["G","Gly","Glycine"],GTG:["V","Val","Valine"],GCG:["A","Ala","Alanine"],GAG:["E","Glu","Glutamic acid"],GGG:["G","Gly","Glycine"]}};this.setReverseComplement=function(){this.reverseComplement={A:"T",C:"G",G:"C",T:"A",U:"A",Y:"R",R:"Y",W:"W",S:"S",K:"M",M:"K",B:"V",V:"B",D:"H",H:"D",X:"X",N:"N",a:"t",c:"g",g:"c",t:"a",u:"a",y:"r",r:"y",w:"w",s:"s",k:"m",m:"k",b:"v",v:"b",d:"h",h:"d",x:"x",n:"n"," ":" ","-":"-","/":"/","[":"[","]":"]"}};this.initializeAttributes=function(){this.setLineTypes();this.setRGB();this.setCodonTable();this.setReverseComplement()};this.initializeAttributes()};CanvasXpress.prototype.initPrimitives=function(){this.initText();this.initTime();this.initColor();this.initAttributes()};CanvasXpress.prototype.initDimensions=function(){this.resizeCanvas=function(d,a,b){this.disableGradientTransparencyShadow();if(d||a||b){if(a||b){if(a){this.width=a;this.originalWidth=a}if(b){this.height=b;this.originalHeight=b}}else{if(d){this.width=this.originalWidth;this.height=this.originalHeight}}this.top=this.margin;if(this.title){this.top+=this.titleHeight+this.margin;if(this.subtitle){this.top+=this.subtitleHeight+this.margin}}this.left=this.margin;this.right=this.margin;this.bottom=this.margin;this.dataEvent=[]}if(this.isIE&&this.useFlashIE&&this.browserVersion<9){this.canvas.style.width=this.width+"px";this.canvas.style.height=this.height+"px";this.canvas.firstChild.width=this.width;this.canvas.firstChild.height=this.height}else{this.canvas.width=this.width;this.canvas.height=this.height}if(this.backgroundType=="image"||this.backgroundType=="windowImage"){this.drawImage(CanvasXpress.cacheImages[this.getFileName(this.backgroundImage)],0,0,this.width,this.height)}else{if(this.backgroundType=="solid"||this.backgroundType=="window"||this.backgroundType=="windowSolidGradient"||this.backgroundType=="video"){this.rectangle(0,0,this.width,this.height,this.background,this.background)}else{var c=this.getLinearGradient(0,0,0,this.height,this.backgroundGradient1Color,this.backgroundGradient2Color);this.rectangle(0,0,this.width,this.height,c,c)}}this.enableGradientTransparencyShadow()};this.setWidth=function(a,b){if(!a){a=1000}this.setDimensions(a,this.height,b)};this.setHeight=function(b,a){if(!b){b=800}this.setDimensions(this.width,b,a)};this.setDimensions=function(a,c,b){if(!a){a=1000}if(!c){c=1000}this.clickLayoutNoAnimation(b);this.canvas.width=a;this.canvas.height=c;this.resetAxesResizer();this.draw(a,c);this.resizeAcknowledgmentDiv();this.updateRemoteNavigationWindow();this.resizeViewport()};this.initializeDimensions=function(){if(this.canvas.width){this.originalWidth=this.canvas.width;this.width=this.canvas.width}else{if(this.width){this.originalWidth=this.width;this.canvas.width=this.width}else{this.width=600;this.originalWidth=this.width;this.canvas.width=this.width}}if(this.canvas.height){this.originalHeight=this.canvas.height;this.height=this.canvas.height}else{if(this.height){this.originalHeight=this.height;this.canvas.height=this.height}else{this.height=600;this.originalHeight=this.height;this.canvas.height=this.height}}this.top=this.margin;if(this.title){this.top+=this.titleHeight+this.margin;if(this.subtitle){this.top+=this.subtitleHeight+this.margin}}this.left=this.margin;this.right=this.margin;this.bottom=this.margin;this.x=this.width-(this.leftMargin+this.left+this.rightMargin+this.right);this.y=this.height-(this.topMargin+this.top+this.bottomMargin+this.bottom)};this.initializeDimensions()};CanvasXpress.prototype.initPlotUtils=function(){this.setVideoControls=function(){if(this.isVideo){var b=this;if(typeof _V_=="undefined"||!_V_.autoSetupTimeout){setTimeout(function(){b.setVideoControls()},100)}else{var e=_V_(this.target+"-cX-Video");var a=this.$(this.target+"-cX-Video");if(e&&a){a.style.position="absolute";a.style.background="transparent";this.video=a.childNodes[0];this.video.style.display="none";this.video.style.zIndex=-1;this.video.playbackRate=this.videoPlaybackRate;b.addEvtListener(this.video,"loadeddata",function(){b.addEvtListener(b.video,"play",b.videoPlay,false)},false);if(this.videoAutoplay){e.play();var c=function(){this.play=function(){if(b.video.readyState==4){b.drawVideo(b.video,b.width,b.height);clearInterval(d)}};var d=setInterval(this.play,30)};c.call()}}}}};this.drawCanvasBox=function(a){if(this.canvasBox&&(this.graphType!="Network"||a)){this.disableGradientTransparencyShadow();this.rectangle(0,0,this.width-1,this.height-1,false,this.canvasBoxColor,"open");this.enableGradientTransparencyShadow()}};this.drawPlotWindow=function(){if(this.backgroundType.match("window")){this.disableGradientTransparencyShadow();var a=this.marginLeft+this.offsetX;var b=this.marginTop+this.offsetY;if(this.backgroundType=="windowGradient2"||this.backgroundType=="windowSolidGradient"){var c;if(this.backgroundWindowGradientOrientation=="horizontal"){c=this.getLinearGradient(a+this.left,b,a+this.left+this.x,b,this.backgroundWindowGradient1Color,this.backgroundWindowGradient2Color)}else{c=this.getLinearGradient(a,b+this.top,a,b+this.top+this.y,this.backgroundWindowGradient1Color,this.backgroundWindowGradient2Color)}this.rectangle(a+this.left,b+this.top,this.x,this.y,c,c)}else{this.rectangle(a+this.left,b+this.top,this.x,this.y,this.backgroundWindow,this.backgroundWindow)}this.enableGradientTransparencyShadow()}};this.setOverlayColors=function(){var k=0;var l=this.isGroupedData?this.grpIndices:this.smpIndices;if(this.smpOverlays.length>0){if(!this.smpOverlayColors){this.smpOverlayColors={}}for(var f=0;f<this.smpOverlays.length;f++){var e=this.smpOverlays[f];if(!this.smpOverlayColors[e]){this.smpOverlayColors[e]={}}if(this.smpOverlayRecycleColors){k=0}if(this.data.x.hasOwnProperty(e)){if(this.isNumeric(this.data.x[e],true)){var g=this.range(this.data.x[e],true);for(var d=0;d<l.length;d++){var h=l[d];var c=this.isGroupedData?this.data.w.factors[e][h]:this.data.x[e][h]?this.data.x[e][h]:"";var b=!isNaN(c)?this.getHeatmapColor(g[0],g[1],c):this.missingDataColor;this.smpOverlayColors[e][c.toString()]=b}}else{for(var d=0;d<l.length;d++){var h=l[d];var a=this.isGroupedData?this.data.w.factors[e][h]:this.data.x[e][h];if(!this.smpOverlayColors[e][a]){this.smpOverlayColors[e][a]=this.colors[k%this.colors.length];k++}}}}}}k=0;if(this.varOverlays.length>0&&this.graphType=="Heatmap"){if(!this.varOverlayColors){this.varOverlayColors={}}for(var f=0;f<this.varOverlays.length;f++){var e=this.varOverlays[f];if(!this.varOverlayColors[e]){this.varOverlayColors[e]={}}if(this.varOverlayRecycleColors){k=0}if(this.data.z.hasOwnProperty(e)){if(this.isNumeric(this.data.z[e],true)){var g=this.range(this.data.z[e],true);for(var d=0;d<this.varIndices.length;d++){var h=this.varIndices[d];var c=this.data.z[e][h]!=null?this.data.z[e][h]:"";var b=!isNaN(c)?this.getHeatmapColor(g[0],g[1],c):this.missingDataColor;this.varOverlayColors[e][c.toString()]=b}}else{for(var d=0;d<this.varIndices.length;d++){var h=this.varIndices[d];var a=this.data.z[e][h];if(!this.varOverlayColors[e][a]){this.varOverlayColors[e][a]=this.colors[k%this.colors.length];k++}}}}}}};this.setOverlayFont=function(){var a=Math.min(this.overlayScaleFontFactor*this.overlayFontSize,this.maxTextSize);a=parseInt(Math.max(a,this.minTextSize));this.overlayFont=this.overlayFontStyle+" "+a+"px "+this.fontName};this.setValidDataColorShapeSizePattern=function(){var b=["color","shape","size","pattern"];for(var a=0;a<b.length;a++){if(this[b[a]+"By"]){if(this.data.x&&!this.data.x[this[b[a]+"By"]]&&this.data.z&&!this.data.z[this[b[a]+"By"]]&&!this.isMultidimensionalData){if(this[b[a]+"By"]=="variable"||(this.graphType.match(/Boxplot|Dotplot/))){continue}else{this[b[a]+"By"]=false}}}}if((this.shapeBy||this.sizeBy||this.patternBy)&&!this.colorBy&&!this.isMultidimensionalData&&!this.graphType=="Heatmap"){this.colorBy="variable"}else{if(!this.shapeBy&&!this.sizeBy&&!this.patternBy&&this.colorBy=="variable"){this.colorBy=false}}}};CanvasXpress.prototype.initGeneralUtils=function(){this.modifyObjectArray=function(b,f,g,e,h){var d=this[g];if(e){var a={};if(this.isArray(b)){for(var c=0;c<b.length;c++){a[b[c]]=true}}else{a[b]=true}for(var c in a){if(this.isInArray(c,d)){d=this.removeFromArray(c,d);delete (a[c])}}for(var c in a){d.push(c)}this[g]=d}else{if(f){var a={};var j=[];if(this.isArray(b)){for(var c=0;c<b.length;c++){a[b[c]]=1}}else{a[b]=1}for(var c=0;c<d.length;c++){if(!a.hasOwnProperty(d[c])){j.push(d[c])}}this[g]=j}else{if(this.isArray(b)){for(var c=0;c<b.length;c++){d.push(b[c])}}else{d.push(b)}}}if(h){this.draw()}};this.getObjectArray=function(a){var b={};if(a&&this.isArray(a)){for(var c=0;c<a.length;c++){b[a[c]]=1}}return b};this.isInArray=function(d,b){if(b&&!(b.propertyIsEnumerable("length"))&&typeof b==="object"&&typeof b.length==="number"){for(var c=0;c<b.length;c++){if(b[c]==d){return true}}}return false};this.removeFromArray=function(e,b){if(b&&!(b.propertyIsEnumerable("length"))&&typeof b==="object"&&typeof b.length==="number"){var d=[];for(var c=0;c<b.length;c++){if(b[c]!=e){d.push(b[c])}}}return d};this.isArray=function(a){if(a&&!(a.propertyIsEnumerable("length"))&&typeof a==="object"&&typeof a.length==="number"){return true}else{return false}};this.isObject=function(a){return a instanceof Object};this.toArray=function(a){return this.isArray(a)?a:[a]};this.getKeys=function(c){var b=[];if(this.isObject(c)){for(var a in c){b.push(a)}}return b};this.getUniqueKeys=function(c){var b={};if(this.isArray(c)){c=this.getObjectArray(c)}if(this.isObject(c)){for(var a in c){b[a]=true}}return this.getKeys(b)};this.shuffleArray=function(b){for(var d=b.length;d>0;d--){var c=Math.floor(this.random()*d);var a=b[--d];b[d]=b[c];b[c]=a}return b};this.toNumber=function(b,e){var g=[];var c=this.isArray(b);b=this.toArray(b);for(var d=0;d<b.length;d++){if(e){g.push(parseFloat(b[d]))}else{g.push(parseInt(b[d]))}}return c?g:g[0]};this.cloneObject=function(c){if(c==null||typeof(c)!="object"){return c}var a=new c.constructor();for(var b in c){a[b]=this.cloneObject(c[b])}return a};this.isSameObject=function(d,c){if(d===c){return true}if(typeof(d)!="object"||typeof(c)!="object"){return false}for(var e in d){if(d[e]===c[e]){continue}if(c[e]===undefined||typeof(d[e])!=typeof(c[e])){return false}if(!this.isSameObject(d[e],c[e])){return false}}for(var e in c){if(d[e]===undefined){return false}}return true};this.isNumeric2DArray=function(a){for(var c=0;c<a.length;c++){for(var b=0;b<a[c].length;b++){if(a[c][b]&&isNaN(a[c][b])){return false}}}return true};this.isNumeric=function(a,e,d){if(e){for(var c=0;c<this.smpIndices.length;c++){var b=this.smpIndices[c];if(a[b]&&isNaN(a[b])){return false}}}else{if(d){for(var c=0;c<this.varIndices.length;c++){var b=this.varIndices[c];if(a[b]&&isNaN(a[b])){return false}}}else{for(var b=0;b<a.length;b++){if(a[b]&&isNaN(a[b])){return false}}}}return true};this.cleanArray=function(b,h,g){var e=[];if(h){for(var f=0;f<this.smpIndices.length;f++){var d=this.smpIndices[f];var c=b[d]!=null&&b[d]!=""&&!isNaN(b[d])?parseFloat(b[d]):false;if(c){e.push(c)}}}else{if(g){for(var f=0;f<this.varIndices.length;f++){var d=this.varIndices[f];var c=b[d]!=null&&b[d]!=""&&!isNaN(b[d])?parseFloat(b[d]):false;if(c){e.push(c)}}}else{for(var d=0;d<b.length;d++){var c=b[d]!=null&&b[d]!=""&&!isNaN(b[d])?parseFloat(b[d]):false;if(c){e.push(c)}}}}return e};this.cleanArrays=function(h,g,b,k){var e=[];var d=[];if(b){for(var j=0;j<this.smpIndices.length;j++){var f=this.smpIndices[j];var c=h[f]!=null&&h[f]!=""&&!isNaN(h[f])?parseFloat(h[f]):false;var a=g[f]!=null&&g[f]!=""&&!isNaN(g[f])?parseFloat(g[f]):false;if(c&&a){e.push(c);d.push(a)}}}else{if(k){for(var j=0;j<this.varIndices.length;j++){var f=this.varIndices[j];var c=h[f]!=null&&h[f]!=""&&!isNaN(h[f])?parseFloat(h[f]):false;var a=g[f]!=null&&g[f]!=""&&!isNaN(g[f])?parseFloat(g[f]):false;if(c&&a){e.push(c);d.push(a)}}}else{for(var f=0;f<h.length;f++){var c=h[f]!=null&&h[f]!=""&&!isNaN(h[f])?parseFloat(h[f]):false;var a=g[f]!=null&&g[f]!=""&&!isNaN(g[f])?parseFloat(g[f]):false;if(c&&a){e.push(c);d.push(a)}}}}return[e,d]};this.reverseArray=function(a){var d=[];var c=0;for(var b=a.length-1;b>=0;b--){d[c]=a[b];c++}return d};this.parseInt=function(a){return((a+0.5)<<1)>>1}};CanvasXpress.prototype.initConfigUtils=function(){this.getPixelImage=function(){if(navigator.onLine){return"http://www.canvasxpress.org/images/canvasXpress.gif"}else{if(this.path){return this.path+"canvasXpress.gif"}else{alert("Dude! I couldn't find canvasXpress.js")}}};this.getFileName=function(a){return a.substring(a.lastIndexOf("/")+1)};this.drawTitle=function(){var c;var b;var d;var a;if(this.title){b=this.titleHeight/2;c=this.scaleTextToFont(this.title,this.titleHeight-b,this.width);d=this.getFontPt(c);c=this.titleFontStyle+" "+d+"px "+this.fontName;this.drawText(this.title,this.width/2,this.marginTop+(this.titleHeight/2),c,this.titleColor,"center","middle");if(this.subtitle){a=this.subtitleHeight/4;c=this.scaleTextToFont(this.subtitle,this.subtitleHeight-a,this.x);d=this.getFontPt(c);c=this.subtitleFontStyle+" "+d+"px "+this.fontName;this.drawText(this.subtitle,this.width/2,(this.marginTop+this.titleHeight)+(this.subtitleHeight/2),c,this.subtitleColor,"center","middle")}}};this.drawCitation=function(a,d,b){if(this.citation){var c;if(!a){a=this.width-this.margin}if(!d){d=this.height-this.margin}if(b){c=this.citationFontStyle+" "+(this.citationFontSize*this.citationScaleFontFactor*b)+"px "+this.fontName}else{c=this.citationFontStyle+" "+(this.citationFontSize*this.citationScaleFontFactor)+"px "+this.fontName}this.drawText(this.citation,a,d,c,this.citationColor,"right","bottom")}};this.drawSelectedBackgroundLabel=function(b,c,a,d){if(this.selectDataMode=="name"&&this.isInSelectedDataPoints(b,c)){if(this.selectDataModeDescription&&this.data.z&&this.data.z[this.selectDataModeDescription]){lab=this.data.z[this.selectDataModeDescription][b]||this.data.y.vars[b]}else{lab=this.data.y.vars[b]}this.drawText(lab,a,d,this.varLabelFont,this.foreground,"center","middle")}};this.drawSelectedBackground=function(i,k,l,b,f,g,d,a,j,e,c){if(this.selectDataMode=="area"&&this.isInSelectedDataPoints(i,k)){this.drawShape(l,b,f,g+5,d+5,this.selectedBackgroundColor,this.foreground,"closed",a,1,j,false,e,c)}};this.isInSelectedDataPoints=function(a,b){if(this.isSelectDataPoints){if(this.graphType=="Scatter2D"&&this.isHistogram){a=this.data.y.histogram[a][b]&&this.data.y.histogram[a][b].length>0?this.data.y.histogram[a][b][0]:-1}if(this.selectDataPoint[a]){if(this.broadcastType=="var"){return true}else{if(this.selectDataPoint[a].hasOwnProperty(b)){return true}}}}return false};this.isVisibleSelectedDataPoint=function(a,b){if(this.isSelectDataPoints){if(this.hideDataPoint.length>0&&this.hideDataPoint[a]){if(this.broadcastType=="var"){return false}else{if(this.hideDataPoint[a].hasOwnProperty(b)){return false}}}}return true};this.getVarColor=function(a){if(this.isArray(this.highlightVar)){for(var b=0;b<this.highlightVar.length;b++){if(this.highlightVar[b]==a){return this.varHighlightColor}}}else{if(this.highlightVar==a){return this.varHighlightColor}}return this.varLabelFontColor};this.getSmpColor=function(b){if(this.isArray(this.highlightSmp)){for(var a=0;a<this.highlightSmp.length;a++){if(this.highlightSmp[a]==b){return this.smpHighlightColor}}}else{if(this.highlightSmp==b){return this.smpHighlightColor}}return this.smpLabelFontColor};this.getNodeColor=function(c,a){if(this.isArray(this.highlightNode)){for(var b=0;b<this.highlightNode.length;b++){if(this.highlightNode[b]==c){return this.nodeHighlightColor}}}else{if(this.highlightNode==c){return this.nodeHighlightColor}}return this.selectNode.hasOwnProperty(c)?this.nodeHighlightColor:a?a:this.nodeFontColor};this.getTechnicalIndicatorColor=function(a){return this[a.toLowerCase()+"Color"]?this[a.toLowerCase()+"Color"]:"rgb(255,255,0)"};this.getWorstAspectRatio=function(k,j){if(!k||k.length==0){return Number.MAX_VALUE}else{var e=0;var f=0;var b=Number.MAX_VALUE;for(var c=0;c<k.length;c++){var g=k[c].area;e+=g;b=(b<g)?b:g;f=(f>g)?f:g}var d=j*j;var h=e*e;return Math.max(d*f/h,h/(d*b))}};this.setTreemapRowVerticalLayout=function(j,g,f){var c=0;for(var b=0;b<j.length;b++){c+=j[b].area}var a=c/g;var e=0;for(var b=0;b<j.length;b++){var h=j[b].area/a;j[b].coords={width:a,height:h,left:f.left,top:f.top+e};e+=h}var d={width:f.width-a,height:f.height,left:f.left+a,top:f.top};d.orientation=Math.min(d.width,d.height);if(d.orientation!=d.height){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return d};this.setTreemapRowHorizontalLayout=function(k,h,g){var d=0;for(var c=0;c<k.length;c++){d+=k[c].area}var j=d/h;var f=g.top;var b=0;for(var c=0;c<k.length;c++){var a=k[c].area/j;k[c].coords={width:a,height:j,left:g.left+b,top:f};b+=a}var e={width:g.width,height:g.height-j,left:g.left,top:g.top+j};e.orientation=Math.min(e.width,e.height);if(e.orientation!=e.width){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return e};this.setTreemapRowLayout=function(a,b,c){if(this.treemapOrientation=="horizontal"){return this.setTreemapRowVerticalLayout(a,b,c)}else{return this.setTreemapRowHorizontalLayout(a,b,c)}};this.computeTreemapDimensions=function(a,c,b,f){if(a.length+c.length==1){var e=(a.length==1)?a:c;e[0].coords=f;return}if(a.length>=2&&c.length==0){c=[a.shift()]}if(a.length==0){if(c.length>0){this.setTreemapRowLayout(c,b,f)}return}var d=a[0];if(this.getWorstAspectRatio(c,b)>=this.getWorstAspectRatio([d].concat(c),b)){this.computeTreemapDimensions(a.slice(1),c.concat([d]),b,f)}else{var g=this.setTreemapRowLayout(c,b,f);this.computeTreemapDimensions(a,[],g.orientation,g)}};this.squarifyTreemap=function(a,g){var f=g.width*g.height;var e=0;var b=[];for(var d=0;d<a.length;d++){b[d]=parseFloat(a[d].area);e+=b[d]}for(var d=0;d<b.length;d++){a[d].area=f*b[d]/e}var c=this.treemapOrientation=="horizontal"?g.height:g.width;a.sort(function(i,h){return h.area-i.area});this.computeTreemapDimensions(a.slice(1),[a[0]],c,g)};this.processTreemap=function(b,d){if(!this.treemapOrientation){this.treemapOrientation="horizontal"}if(d.width>=d.height){this.treemapOrientation="horizontal"}else{this.treemapOrientation="vertical"}if(b.length){this.squarifyTreemap(b,d);for(var c=0;c<b.length;c++){var a=b[c].children?b[c].children:b[c];var d={width:b[c].coords.width,height:b[c].coords.height,left:b[c].coords.left,top:b[c].coords.top};this.processTreemap(a,d)}}return b};this.getCloudPointsAtRadius=function(a){if(this.tagCloudGridPoints[a]){return this.tagCloudGridPoints[a]}var b=a*8;var c=b;var d=[];if(a==0){d.push([this.tagCloudGridCenter[0],this.tagCloudGridCenter[1],0])}while(c--){d.push([this.tagCloudGridCenter[0]+a*Math.cos(-c/b*2*Math.PI),this.tagCloudGridCenter[1]+a*Math.sin(-c/b*2*Math.PI)*this.tagCloudTextEllipticity,c/b*2*Math.PI])}this.tagCloudGridPoints[a]=d;return d};this.getCloudRotateDeg=function(){if(this.tagCloudTextRotateRatio==0){return 0}if(this.random()>this.tagCloudTextRotateRatio){return 0}return(-Math.PI/2)+(this.random()*Math.PI)};this.getCloudTextInfo=function(z,n,o){var a=Math.min(500,Math.floor(this.tagCloudTextWeightFactor*n));var s=document.createElement("canvas");var A=s.getContext("2d",{willReadFrequently:true});var p=a+"px "+this.fontName;A.font=p;var b=this.measureText(z,p);var m=a;var i=b+m*2;var g=m*3;var B=Math.ceil(i/this.tagCloudTextGridSize);var c=Math.ceil(g/this.tagCloudTextGridSize);i=B*this.tagCloudTextGridSize;g=c*this.tagCloudTextGridSize;var t=-b*0.5;var q=-m*0.5;var u=Math.ceil((i*Math.abs(Math.sin(o))+g*Math.abs(Math.cos(o)))/this.tagCloudTextGridSize);var d=Math.ceil((i*Math.abs(Math.cos(o))+g*Math.abs(Math.sin(o)))/this.tagCloudTextGridSize);var v=d*this.tagCloudTextGridSize;var r=u*this.tagCloudTextGridSize;s.setAttribute("width",v);s.setAttribute("height",r);A.save();A.translate(v/2,r/2);A.rotate(-o);A.font=a+"px "+this.fontName;A.fillStyle="#000";A.textBaseline="middle";A.fillText(z,t,q+a*0.5);A.restore();var w=A.getImageData(0,0,v,r).data;var f=[];var l=d,k,j,h;var e=[u/2,d/2,u/2,d/2];while(l--){k=u;while(k--){h=this.tagCloudTextGridSize;singleGridLoop:{while(h--){j=this.tagCloudTextGridSize;while(j--){if(w[((k*this.tagCloudTextGridSize+h)*v+(l*this.tagCloudTextGridSize+j))*4+3]){f.push([l,k]);if(l<e[3]){e[3]=l}if(l>e[1]){e[1]=l}if(k<e[0]){e[0]=k}if(k>e[2]){e[2]=k}break singleGridLoop}}}}}}return{occupied:f,bounds:e,gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}};this.canFitCloudText=function(g,f,h,b,a){var e=a.length;while(e--){var d=g+a[e][0];var c=f+a[e][1];if(d>=this.tagCloudGridWidth||c>=this.tagCloudGridHeight||d<0||c<0||!this.tagCloudGrid[d][c]){return false}}return true};this.fillCloudGridAt=function(a,b){if(a>=this.tagCloudGridWidth||b>=this.tagCloudGridHeight||a<0||b<0){return}this.tagCloudGrid[a][b]=false};this.updateCloudGrid=function(e,c,d){var a=d.occupied;var b=a.length;while(b--){this.fillCloudGridAt(e+a[b][0],c+a[b][1])}};this.drawCloudTag=function(c,h,f,d){var i=this;var j=this.getCloudRotateDeg();var e=this.getCloudTextInfo(c,h,j);if(!e){return false}var b=e.bounds;if((b[1]-b[3]+1)>this.tagCloudGridWidth||(b[2]-b[0]+1)>this.tagCloudGridHeight){return false}var a=this.tagCloudGridMaxRadius+1;while(a--){var k=this.getCloudPointsAtRadius(this.tagCloudGridMaxRadius-a);k=[].concat(k);this.shuffleArray(k);var g=k.some(function l(o){var q=Math.floor(o[0]-e.gw/2);var p=Math.floor(o[1]-e.gh/2);var r=e.gw;var n=e.gh;var t=e.fontSize+"px "+i.fontName;if(!i.canFitCloudText(q,p,r,n,e.occupied)){return false}var m=((q+e.gw/2)*i.tagCloudTextGridSize);var s=((p+e.gh/2)*i.tagCloudTextGridSize);i.addArea(i.drawText(c,m,s,t,f,"center","middle",-j),d);i.updateCloudGrid(q,p,e);return true});if(g){return true}}return false};this.setTagCloud=function(b){this.tagCloudTextGridSize=Math.max(this.tagCloudTextGridSize,4);if(this.colorBy&&this.legendColorsN){this.tagCloudGridWidth=Math.floor(this.x/this.tagCloudTextGridSize);this.tagCloudGridHeight=Math.floor(this.y/this.tagCloudTextGridSize)}else{this.tagCloudGridWidth=Math.floor(this.width/this.tagCloudTextGridSize);this.tagCloudGridHeight=Math.floor(this.height/this.tagCloudTextGridSize)}this.tagCloudGridCenter=[this.tagCloudGridWidth/2,this.tagCloudGridHeight/2];this.tagCloudGridMaxRadius=Math.floor(Math.sqrt(this.tagCloudGridWidth*this.tagCloudGridWidth+this.tagCloudGridHeight*this.tagCloudGridHeight));this.tagCloudGridPoints=[];if(!b){this.setTagCloudTextWeightFactor()}else{this.tagCloudTextWeightFactor*=b}this.tagCloudGrid=[];var c=this.tagCloudGridWidth;var a;while(c--){this.tagCloudGrid[c]=[];a=this.tagCloudGridHeight;while(a--){this.tagCloudGrid[c][a]=true}}};this.setTagCloudTextWeightFactor=function(){var h=0;var b=0;var k=this.varIndices[0];for(var g=0;g<this.smpIndices.length;g++){var f=this.smpIndices[g];var j=this.getDataAtPos(k,f);var e=this.data.y.smps[f].length;var c=e*j*0.5*j;b=Math.max(c,b);h+=c}this.tagCloudTextWeightFactor=(this.width*this.height)/(h*3)};this.getColor=function(a){for(var b=0;b<this.data.y.vars.length;b++){if(this.data.y.vars[b]==a){return this.colors[b%this.colors.length]}}return this.colors[0]};this.getPattern=function(a){if(this.patterns.length>0){for(var b=0;b<this.data.y.vars.length;b++){if(this.data.y.vars[b]==a){return this.patterns[b%this.patterns.length]}}}return"closed"};this.setPieData=function(g,a){var f={no:0,idso:[],ids:[],data:{},raw:{},oprc:0,tot:this.sum(g)};for(var c=0;c<g.length;c++){var b=a?this.varIndices[c]:c;var e=g[b]/f.tot;if(!isNaN(e)){f.data[b]=e;f.raw[b]=g[b];if(c>=this.maxPieSectors-1){f.oprc+=e;f.idso.push(b);f.no++}else{f.ids.push(b)}}}if(f.no){f.ids.push(-1)}return f};this.drawPie=function(u,h,g,t,K,w){var q=function(){for(var a=0;a<u.ids.length;a++){if(isNaN(u.data[a])){return false}}return true};if(q()){var z,e;var o=this.startPieSectors!=null?(this.startPieSectors*Math.PI/180)%360:0;var A=this.pieSegmentLabels=="inside"?t-(t/3):t+(t/6);var I=0;var D=this.layoutComb?this.smpIndices[0]:this.xAxisIndices?this.xAxisIndices[0]:0;for(var F=0;F<u.ids.length;F++){var m=u.ids[F];var v=m>-1?u.data[m]:u.oprc;var f=this.pieColors[F%this.pieColors.length]?F%this.pieColors.length:F%this.colors.length;z=e!=null?parseFloat(e):parseFloat((Math.PI*(2*I))-o);e=parseFloat(z+(Math.PI*(2*(v))));var J=(z+e)/2;var C=(e-z)/32;var H=this.transparency!=null?this.validateColor(this.pieColors[f]||this.colors[f],this.transparency):this.pieColors[f]||this.colors[f];var E=this.pieType=="separated"?this.background:this.pieType=="solid"?this.foreground:this.foreground;this.drawSelectedBackground(m>-1?m:u.idso[0],D,"pie",h,g,(t*2)+10,t+10,false,true,z,e);this.drawShape("pie",h,g,(t*2),t,H,H,"closed",false,1,false,false,z,e);var G=u.ids.length>1?h-Math.sin(J-(Math.PI/2))*A:h;var d=u.ids.length>1?g+Math.cos(J-(Math.PI/2))*A:g;if(this.graphType!="Network"&&this.showPieValues&&(e-z)>0.05){if(this.pieLabelType=="value"){this.drawText(u.raw[m],G,d,this.axisTickFont,this.axisTickColor,"center","middle")}else{this.drawText(sprintf("%."+this.pieSegmentPrecision+"f",v*100)+"%",G,d,this.axisTickFont,this.axisTickColor,"center","middle")}}if(K){G=h+t*Math.cos(z);d=g+t*Math.sin(z);var b=["poly",h,g,G,d];var o=z;for(var B=0;B<32;B++){o+=C;G=h+t*Math.cos(o);d=g+t*Math.sin(o);b.push(G);b.push(d)}b.push(h);b.push(g);if(this.graphType=="Network"){this.addAreaNetwork(b,K[F],w)}else{if(m>-1){this.addArea(b,[m,D])}else{u.idso.unshift(D);this.addArea(b,u.idso)}}}I+=v}I=0;e=null;if(u.ids.length>1){for(var F=0;F<u.ids.length;F++){var m=u.ids[F];var v=m>-1?u.data[m]:u.oprc;z=e!=null?parseFloat(e):parseFloat((Math.PI*(2*I))-o);e=parseFloat(z+(Math.PI*(2*(v))));var E=this.pieType=="separated"?this.background:this.pieType=="solid"?this.foreground:this.foreground;this.drawShape("pie",h,g,(t*2),t,false,E,"open",false,this.pieSegmentSeparation,false,false,z,e);I+=v}}if(this.pieInnerRadius>0&&this.pieInnerRadius<1){this.drawShape("circle",h,g,t*this.pieInnerRadius*2,t*this.pieInnerRadius*2,this.background,this.background,"closed")}}};this.drawBarPlot=function(O,N,J,B,k,E,A,g,I,G,Q,F,S,H){var x,j,M,D;var R=this.backgroundType.match(/window/i)?this.foregroundWindow:this.foreground;var C=this.variableSeparationFactor/2;var L=k/2;if(G=="vertical"){for(var K=0;K<O.length;K++){x=((O[K]-I)*A)-g;if(!isNaN(x)){if(this.graphType=="Network"){var P;if(x<0){P=this.rectangle(J+C,B,k-this.variableSeparationFactor,-x,Q[K],Q[K],F[K])}else{P=this.rectangle(J+C,B-x,k-this.variableSeparationFactor,x,Q[K],Q[K],F[K])}this.addAreaNetwork(P,S[K],H)}else{if(x<0){this.addArea(this.rectangle(J+C,B,k-this.variableSeparationFactor,-x,Q[K],Q[K],F[K],false,false,true),S[K])}else{this.addArea(this.rectangle(J+C,B-x,k-this.variableSeparationFactor,x,Q[K],Q[K],F[K],false,false,true),S[K])}}M=B-x;D=J+L;if(N[K]&&!isNaN(N[K])){j=(N[K]/2)*A;this.errorBar(D,M,D,M+j,-L,R);this.errorBar(D,M,D,M-j,-L,R)}if(this.showDataValues){this.drawText(O[K],D,B-(x+this.overlayFontSize),this.overlayFont,Q[K],"center","bottom")}}J+=E}}else{for(var K=0;K<O.length;K++){x=((O[K]-I)*A)-g;if(!isNaN(x)){if(x<0){this.addArea(this.rectangle(J+x,B+C,-x,k-this.variableSeparationFactor,Q[K],Q[K],F[K],false,false,true),S[K])}else{this.addArea(this.rectangle(J,B+C,x,k-this.variableSeparationFactor,Q[K],Q[K],F[K],false,false,true),S[K])}M=J+x;D=B+L;if(N[K]&&!isNaN(N[K])){j=(N[K]/2)*A;this.errorBar(M,D,M+j,D,L,R);this.errorBar(M,D,M-j,D,L,R)}if(this.showDataValues){this.drawText(O[K],M+this.overlayFontSize,D,this.overlayFont,Q[K],"left","middle")}}B+=E}}};this.drawLinePlot=function(O,N,H,A,x,J,y,G,E,P,C,B,R){var D,M,L,K,j,g,f;var v=x/2;var r=x/3;var Q=C=="open"?P:this.backgroundType.match(/window/i)?this.foregroundWindow:this.foreground;var F=O.length-1;var k=[[],[]];if(E=="vertical"){M=H;L=H+J;for(var I=1;I<O.length;I++){D=I-1;j=A-((O[D]-G)*y);g=A-((O[I]-G)*y);if(!isNaN(j)){if(this.lineDecoration&&B){this.addArea(this.drawShape(B,M,j,r,r,P,Q,C[D],false,false,true),R[D])}if(N[D]&&!isNaN(N[D])){f=(N[D]/2)*y;this.errorBar(M,j,M,j+f,-v,P);this.errorBar(M,j,M,j-f,-v,P)}if(this.lineType=="spline"){k[0].push(M);k[1].push(j)}}if((this.lineType!="spline"&&!isNaN(j)&&!isNaN(g))||O.length<3){this.drawLine("line",M,j,L,g,P,this.lineThickness,"butt",false,false,true)}else{if(this.lineType=="spline"&&isNaN(g)){this.drawLine("spline",k[0],k[1],false,false,P,this.lineThickness);k=[[],[]]}}M+=J;L+=J}if(!isNaN(g)){if(this.lineDecoration&&B){this.addArea(this.drawShape(B,M,g,r,r,P,Q,C[F],false,false,true),R[F])}if(N[F]&&!isNaN(N[F])){f=(N[F]/2)*y;this.errorBar(M,g,M,g+f,-v,P);this.errorBar(M,g,M,g-f,-v,P)}if(this.lineType=="spline"){k[0].push(M);k[1].push(g)}}if(this.lineType=="spline"){this.drawLine("spline",k[0],k[1],false,false,P,this.lineThickness)}}else{j=A;g=A+J;for(var I=1;I<O.length;I++){D=I-1;M=H+((O[D]-G)*y);L=H+((O[I]-G)*y);if(!isNaN(M)){if(this.lineDecoration&&B){this.addArea(this.drawShape(B,M,j,r,r,P,Q,C[D],false,false,true),R[D])}if(N[D]&&!isNaN(N[D])){K=(N[D]/2)*y;this.errorBar(M,j,M+K,j,v,P);this.errorBar(M,j,M-K,j,v,P)}if(this.lineType=="spline"){k[0].push(M);k[1].push(j)}}if((this.lineType!="spline"&&!isNaN(M)&&!isNaN(L))||O.length<3){this.drawLine("line",L,g,M,j,P,this.lineThickness,"butt",false,false,true)}else{if(this.lineType=="spline"&&isNaN(L)){this.drawLine("spline",k[0],k[1],false,false,P,this.lineThickness);k=[[],[]]}}j+=J;g+=J}if(!isNaN(L)){if(this.lineDecoration&&B){this.addArea(this.drawShape(B,L,j,r,r,P,Q,C[F],false,false,true),R[F])}if(N[F]&&!isNaN(N[F])){K=(N[F]/2)*y;this.errorBar(L,j,L+K,j,-v,P);this.errorBar(L,j,L-K,j,-v,P)}if(this.lineType=="spline"){k[0].push(L);k[1].push(j)}}if(this.lineType=="spline"){this.drawLine("spline",k[0],k[1],false,false,P,this.lineThickness)}}};this.drawStackedPlot=function(r,j,B,y,e,m,A,f,s,b,x,h){if(f=="vertical"){for(var k=0;k<r.length;k++){if(r[k]>0){var z=e?(r[k]*100/m)*A:r[k]*A;if(this.graphType=="Network"){this.addAreaNetwork(this.rectangle(j,B-z,y,z,s[k],this.foreground,b[k]),x[k],h)}else{this.addArea(this.rectangle(j,B-z,y,z,s[k],this.foreground,b[k]),x[k])}B-=z}}}else{for(var k=0;k<r.length;k++){if(r[k]>0){var z=e?(r[k]*100/m)*A:r[k]*A;if(this.graphType=="Network"){this.addAreaNetwork(this.rectangle(j,B,z,y,s[k],this.foreground,b[k]),x[k],h)}else{this.addArea(this.rectangle(j,B,z,y,s[k],this.foreground,b[k]),x[k])}j+=z}}}};this.drawAreaPlot=function(T,M,E,B,Q,F,D,L,J,S,U,I,V){var K=T.length-1;var N=S&&this.lineType=="rect"?"path":this.lineType=="rect"?"polygon":"spline";var R=[];var G=[];if(this.graphOrientation=="vertical"){for(var P=0;P<T[0].length;P++){R[P]=E}for(var P=0;P<T.length;P++){var H=M;var A=S?[]:[M];var e=S?[]:[E];for(var O=0;O<T[0].length;O++){if(isNaN(T[P][O])){if(!S){A.push(H-F);e.push(E)}if(S&&this.lineType=="spline"){this.addArea(this.drawLine(N,A,e,false,false,U[P],this.lineThickness),V[P])}else{this.addArea(this.drawShape(N,A,e,this.width,this.height,U[P],U[P],I[P]),V[P])}A=S?[]:[H+F];e=S?[]:[E]}else{var C=(T[P][O]-L)*D;A.push(H);if(this.areaIsCumulative){e.push(R[O]-C);R[O]-=C}else{e.push(E-C)}}H+=F}if(!S){A.push(M+B);e.push(E)}G.push([A,e])}}else{for(var P=0;P<T[0].length;P++){R[P]=M}for(var P=0;P<T.length;P++){var H=E;var A=S?[]:[M];var e=S?[]:[E];for(var O=0;O<T[0].length;O++){if(isNaN(T[P][O])){if(!S){A.push(M);e.push(H-F)}if(S&&this.lineType=="spline"){this.addArea(this.drawLine(N,A,e,false,false,U[P],this.lineThickness),V[P])}else{this.addArea(this.drawShape(N,A,e,this.width,this.height,U[P],U[P],I[P]),V[P])}A=S?[]:[M];e=S?[]:[H+F]}else{var C=(T[P][O]-L)*D;e.push(H);if(this.areaIsCumulative){A.push(R[O]+C);R[O]+=C}else{A.push(M+C)}}H+=F}if(!S){A.push(M);e.push(E+Q)}G.push([A,e])}}while(K>=0){var b=G.pop();if(S&&this.lineType=="spline"){this.addArea(this.drawLine(N,b[0],b[1],false,false,U[K],this.lineThickness),V[K])}else{this.addArea(this.drawShape(N,b[0],b[1],this.width,this.height,U[K],U[K],I[K]),V[K])}K--}};this.drawBoxPlot=function(K,F,x,g,B,n,E,D,L,C,N){var e=function(a){return D=="vertical"?x-((a-E)*n):F+((a-E)*n)};var M=this.backgroundType.match(/window/i)?this.foregroundWindow:this.foreground;var y=this.variableSeparationFactor/2;var I=g/2;var J=g/this.boxPlotOutliersRatio;if(D=="vertical"){for(var H=0;H<K.length;H++){var A=F+I;var k=[];for(var G=0;G<5;G++){k.push(e(K[H][G]))}this.addArea(this.rectangle(F+y,k[3],g-this.variableSeparationFactor,k[2]-k[3],L[H],L[H],C[H],false,false,true),N[H]);this.drawLine("line",F+y,k[4],F+(g-y),k[4],M,false,"butt",false,false,true);this.errorBar(A,k[2],A,k[0],-I,M);this.errorBar(A,k[3],A,k[1],-I,M);if(K[H][5]){for(var G=0;G<K[H][5].length;G++){this.drawShape("sphere",A,e(K[H][5][G]),J,J,L[H],M,C[H],false,false,true)}}F+=B}}else{for(var H=0;H<K.length;H++){var A=x+I;var k=[];for(var G=0;G<5;G++){k.push(e(K[H][G]))}this.addArea(this.rectangle(k[2],x+y,k[3]-k[2],g-this.variableSeparationFactor,L[H],L[H],C[H],false,false,true),N[H]);this.drawLine("line",k[4],x+y,k[4],x+(g-y),M,false,"butt",false,false,true);this.errorBar(k[2],A,k[0],A,I,M);this.errorBar(k[3],A,k[1],A,I,M);if(K[H][5]){for(var G=0;G<K[H][5].length;G++){this.drawShape("sphere",e(K[H][5][G]),A,J,J,L[H],M,C[H],false,false,true)}}x+=B}}};this.drawCandlestickPlot=function(G,B,q,f,F,n,A,x,y,H,J){var e=function(a){return y=="vertical"?q-((a-A)*n):B+((a-A)*n)};var I=this.backgroundType.match(/window/i)?this.foregroundWindow:this.foreground;var E=f/2;if(y=="vertical"){for(var D=0;D<G.length;D++){var s=B+E;var k=[];for(var C=0;C<G[D].length;C++){k.push(e(G[D][C]))}if(x){if(k[0]>k[1]){this.addArea(this.rectangle(B,k[1],f,k[0]-k[1],false,H,"open",false,false,true),J[D]);this.drawLine("line",s,k[1],s,k[2],H,false,"butt",false,false,true);this.drawLine("line",s,k[3],s,k[0],H,false,"butt",false,false,true)}else{this.addArea(this.rectangle(B,k[0],f,k[1]-k[0],H,H,"closed",false,false,true),J[D]);this.drawLine("line",s,k[3],s,k[1],H,false,"butt",false,false,true);this.drawLine("line",s,k[0],s,k[2],H,false,"butt",false,false,true)}}else{this.addArea(this.rectangle(B,k[0],f,q-k[0],H,H,"closed",false,false,true),J[D])}B+=F}}else{for(var D=0;D<G.length;D++){var s=q+E;var k=[];for(var C=0;C<G[D].length;C++){k.push(e(G[D][C]))}if(x){if(k[1]>k[0]){this.addArea(this.rectangle(k[0],q,k[1]-k[0],f,false,H,"open",false,false,true),J[D]);this.drawLine("line",k[1],s,k[2],s,H,false,"butt",false,false,true);this.drawLine("line",k[3],s,k[0],s,H,false,"butt",false,false,true)}else{this.addArea(this.rectangle(k[1],q,k[0]-k[1],f,H,H,"closed",false,false,true),J[D]);this.drawLine("line",k[3],s,k[1],s,H,false,"butt",false,false,true);this.drawLine("line",k[0],s,k[2],s,H,false,"butt",false,false,true)}}else{this.addArea(this.rectangle(B,q,k[0]-B,f,H,H,"closed",false,false,true),J[D])}q+=F}}};this.drawDotPlot=function(R,Q,J,C,y,N,E,B,I,D,G,S,K,F,P,U){var A,r;var x=this.jitter?Math.ceil(Math.log(this.varIndices.length*25)/Math.LN10):1;var O=this.jitter?P/x:0;var T=this.backgroundType.match(/window/i)?this.foregroundWindow:this.foreground;if(G=="vertical"){if(this.jitter){J-=P/2}for(var M=0;M<R.length;M++){var H=0;for(var L=0;L<R[M].length;L++){A=C-((R[M][L]-I)*B);if(!isNaN(A)){this.addArea(this.drawShape(F[M][L],J+H,A,D[M][L],D[M][L],S[M][L],T,K[M][L],false,false,true),U[M][L]);if(Q[M]&&!isNaN(Q[M])){r=(Q[M]/2)*B;this.errorBar(J+H,A,J+H,A+r,-N,S[M][L]);this.errorBar(J+H,A,J+H,A-r,-N,S[M][L])}H=this.jitter&&(L+1)%(x+1)?H+O:0}}J+=E}}else{if(this.jitter){C-=P/2}for(var M=0;M<R.length;M++){var H=0;for(var L=0;L<R[M].length;L++){A=J+((R[M][L]-I)*B);if(!isNaN(A)){this.addArea(this.drawShape(F[M][L],A,C+H,D[M][L],D[M][L],S[M][L],T,K[M][L],false,false,true),U[M][L]);if(Q[M]&&!isNaN(Q[M])){r=(Q[M]/2)*B;this.errorBar(A,C+H,A+r,C+H,N,S[M][L]);this.errorBar(A,C+H,A-r,C+H,N,S[M][L])}H=this.jitter&&(L+1)%(x+1)?H+O:0}}C+=E}}};this.drawHeatmap=function(y,k,G,E,r,j,D,u,C,s,b){var g=this.backgroundType.match(/window/i)?this.foregroundWindow:this.foreground;var B=this.graphType=="Network"?false:true;for(var q=0;q<y.length;q++){var F=y[q];var A=!isNaN(F)?this.getHeatmapColor(j,D,F):this.missingDataColor;g=u?A:g;if(this.graphType=="Network"){var m;if(this.shapeByShape){m=this.drawShape(this.shapeByShape,k+(E/2),G+(r/2),E/2,r/2,A,g,b[q],false,false,B)}else{m=this.rectangle(k,G,E,r,A,g,b[q],false,false,B)}this.addAreaNetwork(m,C[q],s)}else{if(this.shapeByShape){this.addArea(this.drawShape(this.shapeByShape,k+(E/2),G+(r/2),E/2,r/2,A,g,b?b[q]:false,false,false,B),C[q],s)}else{this.addArea(this.rectangle(k,G,E,r,A,g,b?b[q]:false,false,false,B),C[q],s)}}if(this.showDataValues){this.drawText(F,(k+E)-2,(G+r)-2,this.overlayFont,this.foreground,"right","bottom")}k+=E}};this.drawTreemap=function(h,b,n,j,k){var g=this;var m=function(c){g.addArea(g.rectangle(c.coords.left+b,c.coords.top+n,c.coords.width,c.coords.height,c.color,false,"closed"),c.index);if(c.label){var a=g.measureText(c.label,g.smpLabelFont);if(a+g.margin<c.coords.width){g.drawText(c.label,c.coords.left+b+2,c.coords.top+n,g.smpLabelFont,this.foreground,"left","top")}else{if(a+g.margin<c.coords.height){g.drawText(c.label,c.coords.left+b,c.coords.top+n+2,g.smpLabelFont,this.foreground,"right","top",-Math.PI/2)}}}};var f=function(c){for(var a=0;a<c.length;a++){if(c[a].children){f(c[a].children)}else{m(c[a])}}};for(var e=0;e<h.length;e++){if(h[e].children){f(h[e].children)}else{m(h[e])}}};this.checkMultidimensional=function(){var c=this.graphType=="Heatmap"?["outline","shape","size","pattern"]:["color","outline","shape","size","pattern"];for(var b=0;b<c.length;b++){var a=c[b]+"ByData";if(this[a]&&this.data.y[this[a]]&&this.isArray(this.data.y[this[a]])){this.isMultidimensionalData=true}}};this.zoomOncoprintVariables=function(c){var b=[];this.setOriginalIndices(0,this.varIndices,this.smpIndices);this.varIndicesStart=0;for(var a=0;a<Math.min(c,this.varIndices.length);a++){b.push(this.varIndices[a])}this.varIndices=b;this.draw()}};CanvasXpress.prototype.init3dUtils=function(){this.set3DRotation=function(){var a;var c=0;var b=0;if(this.graphType=="Network"){c=this.maxRotate!=null?this.maxRotate:360;b=this.minRotate!=null?this.minRotate:360}else{if(this.graphType=="Scatter3D"||this.is3DPlot){c=this.maxRotate!=null?this.maxRotate:90;b=this.minRotate!=null?this.minRotate:0}}if(this.xRotate>c){this.xRotate=c}if(this.xRotate<0){this.xRotate=b}if(this.yRotate>c){this.yRotate=c}if(this.yRotate<0){this.yRotate=b}if(this.zRotate>c){this.zRotate=c}if(this.zRotate<0){this.zRotate=b}if(this.xRotate>0){a=180/this.xRotate;this.ry=Math.PI/a}else{this.ry=0}if(this.yRotate>0){a=180/this.yRotate;this.rx=Math.PI/a}else{this.rx=0}if(this.zRotate>0){a=180/this.zRotate;this.rz=Math.PI/a}else{this.rz=0}this.trigonometry={cosX:Math.cos(this.rx),sinX:Math.sin(this.rx),cosY:Math.cos(this.ry),sinY:Math.sin(this.ry),cosZ:Math.cos(this.rz),sinZ:Math.sin(this.rz)}};this.set3DParams=function(){this.perspective=this.x*this.perspectiveFactor;this.lenX=this.x/4*this.zoom*this.x3DRatio;this.lenY=this.x/4*this.zoom*this.y3DRatio;this.lenZ=this.x/4*this.zoom*this.z3DRatio;if(this.padX==null||!this.padX){this.padX=this.x/2}if(this.padY==null||!this.padY){this.padY=this.y/2}if(this.padZ==null||!this.padZ){this.padZ=this.y/2}};this.get3DTransfrom=function(e,f,g){var d,c,b;var a=[];c=f;b=g;f=c*this.trigonometry.cosX-b*this.trigonometry.sinX;g=c*this.trigonometry.sinX+b*this.trigonometry.cosX;d=e;b=g;e=b*this.trigonometry.sinY+d*this.trigonometry.cosY;g=b*this.trigonometry.cosY-d*this.trigonometry.sinY;d=e;c=f;e=d*this.trigonometry.cosZ-c*this.trigonometry.sinZ;f=d*this.trigonometry.sinZ+c*this.trigonometry.cosZ;if(this.perspective){e=e*(this.perspective/(g+this.perspective));f=f*(this.perspective/(g+this.perspective));g=g*(this.perspective/(g+this.perspective))}a.push(e+this.padX);a.push(f+this.padY);a.push(g+this.padZ);return a}};CanvasXpress.prototype.initApi=function(){this.getValidGraphTypes=function(){return this.validGraphTypes};this.setHeatmapScheme=function(){this.initializeAttributes()};this.hasIndicator=function(){if(this.graphType.match(/Scatter/)||this.graphType=="Bar"){return true}else{return false}};this.hasLegend=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"){return true}else{return false}};this.hasLegendProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"&&this.graphType!="Pie"){return true}else{return false}};this.hasData=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){return true}else{return false}};this.hasDataSamples=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}return true}else{return false}};this.hasDataGroups=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}if(this.data.x){return true}else{return false}}else{return false}};this.hasDataVariables=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){if(this.graphType=="Correlation"&&this.correlationAxis!="variables"){return false}return true}else{return false}};this.hasDataProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Heatmap"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"){return true}else{return false}};this.hasOrientation=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&this.graphType!="Circular"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasOverlays=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasDendrograms=function(){if(this.graphType!="Heatmap"&&(this.data.t.smps||this.data.t.vars)){return true}else{return false}};this.hasDecorations=function(){return this.data.d&&(this.data.d.nlfit||this.data.d.line||this.data.d.reg||this.data.d.nor||this.data.d.area)?true:false};this.isSegregable=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.getLineTypes=function(){var e=["line"];var c=["","dashed","dotted","bezierY","bezierX","curved"];var a=["arrow","arrowHead","arrowTail","arrowHeadSquareTail","arrowTailSquareHead","square","squareHead","squareTail","squareHeadArrowTail","squareTailArrowHead"];for(var d=0;d<a.length;d++){e.push(a[d]+"Line")}for(var d=1;d<c.length;d++){for(var b=0;b<a.length;b++){e.push(c[d]+this.capitalize(a[b])+"Line")}}return e};this.isValidShape=function(b){for(var a=0;a<this.shapes.length;a++){if(this.shapes[a]==b){return true}}return false};this.isCompatibleGraphType=function(b,a){if(b.match(/^Bar$|^Line$|Boxplot|Dotplot/)){return a.match(/^Bar$|^Line$|Boxplot|Dotplot/)?true:false}else{return false}};this.isOneDimensionalGraph=function(){if(this.graphType.match(/Scatter|Network|Venn|Genome|Circular|Correlation/)){return false}else{return true}};this.modifyHighlights=function(c,b,d){var a=d?"highlightVar":"highlightSmp";this.modifyObjectArray(c,b,a)};this.getHighlights=function(b){var a=b?this.highlightVar:this.highlightSmp;return this.getObjectArray(a)};this.modifySmpOverlays=function(b,a){this.modifyObjectArray(b,a,"smpOverlays")};this.modifyVarOverlays=function(b,a){this.modifyObjectArray(b,a,"varOverlays")};this.getSmpOverlays=function(){return this.getObjectArray(this.smpOverlays)};this.getVarOverlays=function(){return this.getObjectArray(this.varOverlays)};this.getXData=function(){var b=[];if(this.data.x){for(var a in this.data.x){b.push(a)}}return b};this.getZData=function(){var b=[];if(this.data.z){for(var a in this.data.z){b.push(a)}}return b};this.getXZData=function(){return this.graphType.match(/Scatter/)?this.getZData():this.getXData()};this.getSamplesAsArray=function(){var d=this.getSamples();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.getVariablesAsArray=function(){var d=this.getVariables();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.getNodeData=function(a){return this.getNetworkData("nodes",a)};this.getEdgeData=function(a){return this.getNetworkData("edges",a)};this.getSampleData=function(a){if(!this.samplesData){this.samplesData={smps:{o:this.getObjectArray(this.data.y.smps),t:"string"}};if(this.data.x){for(att in this.data.x){this.samplesData[att]={o:this.getObjectArray(this.getUniqueKeys(this.data.x[att])),t:this.isNumeric(this.data.x[att])?"numeric":"string"}}}}return a?this.samplesData:this.getKeys(this.samplesData)};this.getVariableData=function(a){if(!this.variablesData){this.variablesData={vars:{o:this.getObjectArray(this.data.y.vars),t:"string"}};if(this.data.z){for(att in this.data.z){this.variablesData[att]={o:this.getObjectArray(this.getUniqueKeys(this.data.z[att])),t:this.isNumeric(this.data.z[att])?"numeric":"string"}}}}return a?this.variablesData:this.getKeys(this.variableData)};this.getNetworkData=function(d,a){if(this.graphType=="Network"&&!this[d+"Data"]){this[d+"Data"]={};var f=this.skipConfigurableProperties?this.getObjectArray(this[d.replace("s","")+"ConfigurableProperties"]):{};for(var c=0;c<this.data[d].length;c++){var e=this.data[d][c];for(var b in e){if(!f[b]){if(typeof(e[b])!="object"){if(this[d+"Data"].hasOwnProperty(b)){if(this[d+"Data"][b]["o"].hasOwnProperty(e[b])){this[d+"Data"][b]["o"][e[b]]++}else{this[d+"Data"][b]["o"][e[b]]=1}if(isNaN(e[b])){this[d+"Data"][b]["t"]="string"}}else{this[d+"Data"][b]={o:{},t:isNaN(e[b])?"string":"numeric"};this[d+"Data"][b]["o"][e[b]]=1}}else{if(e[b]&&e[b].constructor==(new Date).constructor){}}}}if(this[d+"Properties"].length>0){this.getAdditionalData(e,this[d+"Data"],this[d+"Properties"])}}}if(this.graphType=="Network"){return a?this[d+"Data"]:this.getKeys(this[d+"Data"])}else{return false}};this.getFeatureData=function(b){if(!this.featuresData){this.featuresData={};var h=this.skipConfigurableProperties?this.getObjectArray(this.featureConfigurableProperties):{};for(var f=0;f<this.data.tracks.length;f++){var a=this.data.tracks[f];var g=a.data;for(var d=0;d<g.length;d++){var e=g[d];for(var c in e){if(!h[c]){if(typeof(e[c])!="object"){if(this.featuresData.hasOwnProperty(c)){if(this.featuresData[c]["o"].hasOwnProperty(e[c])){this.featuresData[c]["o"][e[c]]++}else{this.featuresData[c]["o"][e[c]]=1}if(isNaN(e[c])){this.featuresData[c]["t"]="string"}}else{this.featuresData[c]={o:{},t:isNaN(e[c])?"string":"numeric"};this.featuresData[c]["o"][e[c]]=1}}else{if(e[c].constructor==(new Date).constructor){}}}}}if(this.featuresProperties.length>0){this.getAdditionalData(g,this.featuresData,this.featuresProperties)}}}return b?this.featuresData:this.getKeys(this.featuresData)};this.getAdditionalData=function(d,e,h){for(var f=0;f<h.length;f++){var b=d;var k=false;if(h[f].length>0){for(var c=0;c<h[f].length;c++){var a=h[f][c];if(b[a]){b=b[a]}else{k=true;break}}if(!k){for(var g in b){if(typeof(b[g])!="object"){if(e.hasOwnProperty(g)){if(e[g]["o"].hasOwnProperty(b[g])){e[g]["o"][b[g]]++}else{e[g]["o"][b[g]]=1}if(isNaN(b[g])){e[g]["t"]="string"}}else{e[g]={o:{},t:isNaN(b[g])?"string":"numeric",r:f};e[g]["o"][b[g]]=1}}else{if(b[g].constructor==(new Date).constructor){}}}}}}};this.getOperators=function(){return["","like","not like",">",">=","<","<=","==","null","not null"]};this.zoonIn=function(a){this.handleWheelEvent(a,1)};this.zoonOut=function(a){this.handleWheelEvent(a,-1)};this.clusterSamples=function(){this.clusterAxis="samples";this.showSmpDendrogram=true;if(!this.data.t){this.data.t={}}this.data.t.smps=this.cluster();this.draw()};this.clusterVariables=function(){this.clusterAxis="variables";this.showVarDendrogram=true;if(!this.data.t){this.data.t={}}this.data.t.vars=this.cluster();this.draw()};this.kmeansSamples=function(){this.clusterAxis="samples";this.showOverlays=true;if(!this.data.x){this.data.x={}}this.data.x["k-Means"]=this.kmeans();if(!this.isInArray("k-Means",this.smpOverlays)){this.smpOverlays.push("k-Means")}this.draw()};this.kmeansVariables=function(){this.clusterAxis="variables";this.showOverlays=true;if(!this.data.z){this.data.z={}}this.data.z["k-Means"]=this.kmeans();if(!this.isInArray("k-Means",this.varOverlays)){this.varOverlays.push("k-Means")}this.draw()};this.setFunctions=function(){this.functions.push("clusterSamples");this.functions.push("clusterVariables");this.functions.push("transpose");this.functions.push("transform");this.functions.push("sortSamplesByCategory");this.functions.push("sortSamplesByVariable");this.functions.push("sortVariablesByCategory");this.functions.push("sortVariablesBySample");this.functions.push("hideUnhideSmps");this.functions.push("hideUnhideVars");this.functions.push("desegregateSamples");this.functions.push("segregateSamples");this.functions.push("groupSamples");this.functions.push("ungroupSamples");this.functions.push("desegregateVariables");this.functions.push("segregateVariables");this.functions.push("kmeansSamples");this.functions.push("kmeansVariables");this.functions.push("showCodeDiv");this.functions.push("hideCodeDiv");this.functions.push("showInfoDiv");this.functions.push("hideInfoDiv");this.functions.push("updateCodeDiv");this.functions.push("createHistogram");this.functions.push("removeHistogram");this.functions.push("addRegressionLine");this.functions.push("addNormalDistributionLine");this.functions.push("recalculateLayout");this.functions.push("setSkin");this.functions.push("createRandomData");this.functions.push("draw");this.functions.push("reset");this.functions.push("print");this.functions.push("saveRemoteParameters")};this.initializeApi=function(){this.setFunctions()};this.initializeApi()};CanvasXpress.prototype.initUtils=function(){this.initDimensions();this.initGeneralUtils();this.initPlotUtils();this.initConfigUtils();this.init3dUtils();this.initApi()};CanvasXpress.prototype.initLegendUtils=function(){this.drawDecorationData=function(){var ac=this.marginLeft+this.offsetX+this.left;var R=this.marginTop+this.offsetY+this.top;var aj=this.data.d;if(this.showDecorations&&aj){if(aj.nlfit){var ag,D,ai;var m=this.varIndices;var A,a;for(var af=0;af<aj.nlfit.length;af++){var K=[];var J=[];var n=af%this.colors.length;var ab=this.transformValue(this.yAxisTransform,aj.nlfit[af].param[0]);var Y=this.transformValue(this.yAxisTransform,aj.nlfit[af].param[1]);var U=aj.nlfit[af].param[2];var S=aj.nlfit[af].param[3];var L=this.xAxisIndices.length==1?this.xAxisIndices[0]:this.xAxisIndices[af];var M=this.getDataForSmpGrpAtIndex(L);if(this.xAxisTransform=="percentile"){ag=this.range(M);ai=ag[0];D=ag[1]}m.sort(function(i,d){return M[i]-M[d]});n=aj.nlfit[af].color?aj.nlfit[af].color:this.colors[n];for(var ae=0;ae<m.length;ae++){var s=m[ae];var P=this.getDataAtPos(s,L);var O;var v=[];if(P>0){if(ae>0){var b=m[ae-1];var N=this.getDataAtPos(b,L);if(N>0){var c=(P-N)/this.functionIntervals;for(var ad=0;ad<this.functionIntervals;ad++){v.push(N);N+=c}}}else{v=[P]}for(var ad=0;ad<v.length;ad++){if(aj.nlfit[af].type=="reg"){O=ab+((Y-ab)/(1+U/(Math.pow(v[ad],S))))}else{O=ab+((Y-ab)/(1+(Math.pow((v[ad]/U),S))))}if(this.xAxisTransform){v[ad]=this.xAxisTransform=="percentile"?this.percentile(ai,D,v[ad]):this.transformValue(this.xAxisTransform,v[ad])}A=ac+((v[ad]-this.xAxisMin)*this.xAxisUnit);a=(R+this.y)-((O-this.yAxisMin)*this.yAxisUnit);K.push(A);J.push(a)}}}if(K.length>0){this.drawShape("path",K,J,false,false,n,n,"open",false,false,true);if(aj.nlfit[af].type=="reg"){O=ab+((Y-ab)/(1+U/(Math.pow(U,S))))}else{O=ab+((Y-ab)/(1+(Math.pow((U/U),S))))}if(this.xAxisTransform){U=this.xAxisTransform=="percentile"?this.percentile(ai,D,U):this.transformValue(this.xAxisTransform,U)}A=ac+((U-this.xAxisMin)*this.xAxisUnit);a=(R+this.y)-((O-this.yAxisMin)*this.yAxisUnit);this.drawLine("dottedLine",ac,a,A,a,n);this.drawLine("dottedLine",A,a,A,(R+this.y),n)}}}if(aj.line){for(var af=0;af<aj.line.length;af++){if(aj.line[af].x||aj.line[af].y){var n=aj.line[af].color?aj.line[af].color:this.colors[af%this.colors.length];var am=aj.line[af].type?aj.line[af].type:"line";var P=aj.line[af].x?aj.line[af].x:false;var O=aj.line[af].y?aj.line[af].y:false;var A,a,w,an;if(P){A=ac+((P-this.xAxisMin)*this.xAxisUnit);a=R;w=A;an=a+this.y;this.drawLine(am,A,a,w,an,n)}if(O){A=ac;a=R+this.y-((O-this.yAxisMin)*this.yAxisUnit);w=A+this.x;an=a;this.drawLine(am,A,a,w,an,n)}}}}if(aj.lines){for(var af=0;af<aj.lines.length;af++){var A,a,w,an;var ak=true;var am=aj.lines[af].type||"line";var H=aj.lines[af].color;var Q=aj.lines[af].value||0;var V=aj.lines[af].label||false;if(this.graphOrientation=="vertical"){A=this.marginLeft+this.offsetX+this.left;w=A+this.x;a=this.marginTop+this.offsetY+this.top+this.y-((Q-this.xAxisMin)*this.xAxisUnit);an=a;ak=a<=this.marginTop+this.offsetY+this.top+this.y&&a>=this.marginTop+this.offsetY+this.top?true:false}else{A=this.marginLeft+this.offsetX+this.left+((Q-this.xAxisMin)*this.xAxisUnit);w=A;a=this.marginTop+this.offsetY+this.top;an=a+this.y;ak=A<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(ak){if(V){if(this.graphOrientation=="vertical"){this.drawText(V,w-this.margin,an-this.margin,this.decorationFont,this.decorationColor,"right","bottom")}else{this.drawText(V,w+this.margin,an-this.margin,this.decorationFont,this.decorationColor,"left","bottom")}}this.drawLine(am,A,a,w,an,H)}}}if(aj.reg){for(var af=0;af<aj.reg.length;af++){if(aj.reg[af].slope&&aj.reg[af].intercept){var n=af%this.colors.length;var am=aj.reg[af].type?aj.reg[af].type:"line";var C=aj.reg[af].slope;var X=aj.reg[af].intercept;var g=aj.reg[af].cor;var A=aj.reg[af].start?aj.reg[af].start:this.xAxisMin;var a=(C*A)+X;var w=aj.reg[af].end?aj.reg[af].end:this.xAxisMax;var an=(C*w)+X;A=ac+(A*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);a=(R+this.y)-(a*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);w=ac+(w*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);an=(R+this.y)-(an*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);n=aj.reg[af].color?aj.reg[af].color:this.colors[n];this.drawLine(am,A,a,w,an,n,false,false,false,false,true)}}}if(aj.nor){for(var af=0;af<aj.nor.length;af++){if(aj.nor[af].mu&&aj.nor[af].sigma){var aa=[];var W=[];var I=[];var A,a;var n=af%this.colors.length;var o=aj.nor[af].mu;var f=aj.nor[af].sigma;var F=aj.nor[af].start?aj.nor[af].start:aj.nor[af].yAxis?this.yAxisMin:this.xAxisMin;var B=aj.nor[af].end?aj.nor[af].end:aj.nor[af].yAxis?this.yAxisMax:this.xAxisMax;var h=120;if(F<o&&o<B){var N,z,E,ah;var c=(o-F)/h;var al=f*f;var T=al*2;var G=1/Math.sqrt(2*Math.PI*al);if(aj.nor[af].yAxis){E=aj.nor[af].max?aj.nor[af].max*this.xAxisUnit:this.x-(this.x*this.axisExtension);ah=E/G;N=F;for(var ae=0;ae<h-1;ae++){z=(G*Math.pow(Math.E,-Math.pow(N-o,2)/al));I.push([N,z]);A=ac+(z*ah);a=(R+this.y)-(N*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aa.push(A);W.push(a);N+=c}c=(B-o)/h;N=o;for(var ae=0;ae<h;ae++){z=(G*Math.pow(Math.E,-Math.pow(N-o,2)/al));I.push([N,z]);A=ac+(z*ah);a=(R+this.y)-(N*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aa.push(A);W.push(a);N+=c}n=aj.nor[af].color?aj.nor[af].color:this.colors[n];this.drawShape("path",aa,W,false,false,n,n,"open",false,false,true)}else{E=aj.nor[af].max?aj.nor[af].max*this.yAxisUnit:this.y-(this.y*this.axisExtension);ah=E/G;N=F;for(var ae=0;ae<h-1;ae++){z=(G*Math.pow(Math.E,-Math.pow(N-o,2)/al));I.push([N,z]);A=ac+(N*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);a=(R+this.y)-(z*ah);aa.push(A);W.push(a);N+=c}c=(B-o)/h;N=o;for(var ae=0;ae<h;ae++){z=(G*Math.pow(Math.E,-Math.pow(N-o,2)/al));I.push([N,z]);A=ac+(N*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);a=(R+this.y)-(z*ah);aa.push(A);W.push(a);N+=c}n=aj.nor[af].color?aj.nor[af].color:this.colors[n];this.drawShape("path",aa,W,false,false,n,n,"open",false,false,true)}}}}}if(aj.area){for(var af=0;af<aj.area.length;af++){if(aj.area[af].type&&aj.area[af].x&&aj.area[af].y&&aj.area[af].width&&aj.area[af].height){if(this.isValidShape(aj.area[af].type)){var A=ac+(aj.area[af].x*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);var a=(R+this.y)-(aj.area[af].y*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var n=aj.area[af].color?aj.area[af].color:this.colors[af%this.colors.length];var e=aj.area[af].width*this.xAxisUnit;var Z=aj.area[af].height*this.yAxisUnit;this.drawShape(aj.area[af].type,A,a,e,Z,n,aj.area[af].outline,aj.area[af].pattern,aj.area[af].rotate)}}}}if(aj.kaplanMeyer){var A,a,w,an,u,r,q,p,n;for(var af=0;af<aj.kaplanMeyer.length;af++){n=aj.kaplanMeyer[af].color;A=ac;a=(R+this.y)-(this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);w=ac+(aj.kaplanMeyer[af].data.times[0]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);an=(R+this.y)-(aj.kaplanMeyer[af].data.data[0][3]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);r=(R+this.y)-(aj.kaplanMeyer[af].data.data[0][4]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);p=(R+this.y)-(aj.kaplanMeyer[af].data.data[0][5]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);this.drawLine("line",A,a,w,a,n);this.drawLine("line",w,a,w,an,n);if(this.showDecorationsKaplanMeyerConfidence){this.drawLine("dottedLine",A,a,w,a,n,0.5);this.drawLine("dottedLine",w,a,w,r,n,0.5);this.drawLine("dottedLine",A,a,w,a,n,0.5);this.drawLine("dottedLine",w,a,w,p,n,0.5)}for(var ae=1;ae<aj.kaplanMeyer[af].data.times.length;ae++){A=ac+(aj.kaplanMeyer[af].data.times[ae-1]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);a=(R+this.y)-(aj.kaplanMeyer[af].data.data[ae-1][3]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);u=(R+this.y)-(aj.kaplanMeyer[af].data.data[ae-1][4]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);q=(R+this.y)-(aj.kaplanMeyer[af].data.data[ae-1][5]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);w=ac+(aj.kaplanMeyer[af].data.times[ae]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);an=(R+this.y)-(aj.kaplanMeyer[af].data.data[ae][3]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);r=(R+this.y)-(aj.kaplanMeyer[af].data.data[ae][4]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);p=(R+this.y)-(aj.kaplanMeyer[af].data.data[ae][5]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);this.drawLine("line",A,a,w,a,n);this.drawLine("line",w,a,w,an,n);if(this.showDecorationsKaplanMeyerConfidence){this.drawLine("dottedLine",A,u,w,u,n,0.5);this.drawLine("dottedLine",w,u,w,r,n,0.5);this.drawLine("dottedLine",A,q,w,q,n,0.5);this.drawLine("dottedLine",w,q,w,p,n,0.5)}}}}}};this.setDecorationLegendDimension=function(){this.legendDecorationWidth=0;this.legendDecorationHeight=0;var f=this.data.d;if(this.showDecorations&&f){var k=this.getFontPt(this.decorationFont);var j=0;var g=0;var j=0;var b=0;if(f.nlfit){var a=this.measureText(sprintf("%90s","X"),this.decorationFont)+(this.margin*5);var h=0;for(var e=0;e<f.nlfit.length;e++){var c=this.measureText(f.nlfit[e].label,this.decorationFont);h=Math.max(c,h)}j=this.margin+h+this.margin+a+this.margin;this.legendDecorationHeight=(f.nlfit.length*k*2)+k+this.margin}if(f.line){var h=0;for(var e=0;e<f.line.length;e++){var c=this.measureText(f.line[e].label,this.decorationFont);h=Math.max(c,h)}b=this.margin+h+this.margin;this.legendDecorationHeight+=(f.line.length*k*2)+this.margin}if(f.reg){var a=this.measureText(sprintf("%45s","X"),this.decorationFont)+(this.margin*2);var h=0;for(var e=0;e<f.reg.length;e++){var c=this.measureText(f.reg[e].label,this.decorationFont);h=Math.max(c,h)}g=this.margin+h+this.margin+a+this.margin;this.legendDecorationHeight+=(f.reg.length*k*2)+k+this.margin}if(f.nor){var a=this.measureText(sprintf("%30s","X"),this.decorationFont)+(this.margin*1);var h=0;for(var e=0;e<f.nor.length;e++){var c=this.measureText(f.nor[e].label,this.decorationFont);h=Math.max(c,h)}j=this.margin+h+this.margin+a+this.margin;this.legendDecorationHeight+=(f.nor.length*k*2)+k+this.margin}if(f.area){var h=0;for(var e=0;e<f.area.length;e++){var c=this.measureText(f.area[e].label,this.decorationFont);h=Math.max(c,h)}b=this.margin+h+this.margin;this.legendDecorationHeight+=(f.area.length*k*2)+this.margin}if(f.kaplanMeyer){var h=0;for(var e=0;e<f.kaplanMeyer.length;e++){var c=this.measureText(f.kaplanMeyer[e].label,this.decorationFont);h=Math.max(c,h)}b=this.margin+h+this.margin;this.legendDecorationHeight+=(f.kaplanMeyer.length*k*2)+this.margin}this.legendDecorationWidth=Math.max(Math.max(Math.max(j,g),j),b)}};this.drawDecorationLegend=function(){var e=this.marginLeft+this.offsetX+this.left;var p=this.marginTop+this.offsetY+this.top;var k=this.data.d;if(this.showDecorations&&k){var q=this.getFontPt(this.decorationFont);var c=this.measureText(sprintf("%15s","X"),this.decorationFont);var a,o,m,n;if(this.decorationsPosition=="right"){o=p+(q/2)+((this.y-this.legendDecorationHeight)/2)}else{o=(p+this.y+this.bottom)-this.legendDecorationHeight}if(k.nlfit){n=(this.margin*6)+(6*c);if(this.decorationsPosition=="right"){m=(e+this.x+this.right+c)-n}else{m=e+((this.x-this.legendDecorationWidth)/2)+(this.legendDecorationWidth-n)+c}a=m;this.drawText("Min",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("Max",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("EC50",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("Slope",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("p-Val",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("F-Chg",a,o,this.decorationFont,this.decorationsColor,"right","middle");o+=q+q;for(var h=0;h<k.nlfit.length;h++){var f=h%this.colors.length;f=k.nlfit[h].color?k.nlfit[h].color:this.colors[f];a=(m+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.drawText(k.nlfit[h].label,a,o,this.decorationFont,f,"right","middle");a=m;for(var g=0;g<6;g++){var b=k.nlfit[h].param[g];if(g<2){b=this.transformValue(this.yAxisTransform,b)}else{if(g==2){b=this.transformValue(this.xAxisTransform,b)}}this.drawText(this.formatNumber(b),a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin}o+=q+q}}if(k.line){for(var h=0;h<k.line.length;h++){if(k.line[h].label){if(this.decorationsPosition=="right"){a=e+this.x+this.margin}else{a=e+((this.x-this.legendDecorationWidth)/2)+this.margin}for(var h=0;h<k.line.length;h++){var f=k.line[h].color?k.line[h].color:this.colors[h%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.drawText(k.line[h].label,a,o,this.decorationFont,f,"left","middle");o+=q+q}}}}if(k.reg){n=(this.margin*3)+(3*c);if(this.decorationsPosition=="right"){m=(e+this.x+this.right+c)-n}else{m=e+((this.x-this.legendDecorationWidth)/2)+(this.legendDecorationWidth-n)+c}a=m;this.drawText("Slope",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("Int",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("Cor",a,o,this.decorationFont,this.decorationsColor,"right","middle");o+=q+q;for(var h=0;h<k.reg.length;h++){var f=h%this.colors.length;f=k.reg[h].color?k.reg[h].color:this.colors[f];a=(m+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.drawText(k.reg[h].label,a,o,this.decorationFont,f,"right","middle");a=m;this.drawText(this.formatNumber(k.reg[h].slope),a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText(this.formatNumber(k.reg[h].intercept),a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText(this.formatNumber(k.reg[h].cor),a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;o+=q+q}}if(k.nor){n=(this.margin*2)+(2*c);if(this.decorationsPosition=="right"){m=(e+this.x+this.right+c)-n}else{m=e+((this.x-this.legendDecorationWidth)/2)+(this.legendDecorationWidth-n)+c}a=m;this.drawText("Mu",a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText("Sigma",a,o,this.decorationFont,this.decorationsColor,"right","middle");o+=q+q;for(var h=0;h<k.nor.length;h++){var f=h%this.colors.length;f=k.nor[h].color?k.nor[h].color:this.colors[f];a=(m+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.drawText(k.nor[h].label,a,o,this.decorationFont,f,"right","middle");a=m;this.drawText(this.formatNumber(k.nor[h].mu),a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;this.drawText(this.formatNumber(k.nor[h].sigma),a,o,this.decorationFont,this.decorationsColor,"right","middle");a+=c+this.margin;o+=q+q}}if(k.area){for(var h=0;h<k.area.length;h++){if(k.area[h].label){if(this.decorationsPosition=="right"){a=e+this.x+this.margin}else{a=e+((this.x-this.legendDecorationWidth)/2)+this.margin}var f=k.area[h].color?k.area[h].color:this.colors[h%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.drawText(k.area[h].label,a,o,this.decorationFont,f,"left","middle");o+=q+q}}}if(k.kaplanMeyer){for(var h=0;h<k.kaplanMeyer.length;h++){if(k.kaplanMeyer[h].label){if(this.decorationsPosition=="right"){a=e+this.x+this.margin}else{a=e+((this.x-this.legendDecorationWidth)/2)+this.margin}var f=k.kaplanMeyer[h].color?k.kaplanMeyer[h].color:this.colors[h%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.drawText(k.kaplanMeyer[h].label,a,o,this.decorationFont,f,"left","middle");o+=q+q}}}}};this.setLegendFont=function(){if(this.autoScaleFont){if(this.layoutComb){this.legendFont=(parseInt(Math.max(this.minTextSize,this.legendFontSize-Math.min(this.layoutRows,this.layoutCols))*this.legendScaleFontFactor))}else{var a=this.graphType=="Circular"?1.3:1;this.legendFont=(parseInt(this.legendFontSize*this.legendScaleFontFactor/a))}this.legendFont=this.legendFontStyle+" "+this.legendFont+"px "+this.fontName}else{this.legendFont=this.legendFontStyle+" "+parseInt(this.legendFontSize)+"px "+this.fontName}};this.setSampleLegendDimension=function(){this.legendSampleWidth=0;this.legendSampleHeight=0;var d=this.getFontPt(this.legendFont);var b=0;if(this.xAxisIndices.length!=this.yAxisIndices.length||this.xAxisIndices.length>1){if(this.xAxisIndices.length==this.yAxisIndices.length&&this.xAxisIndices.length>1){for(var c=0;c<this.xAxisIndices.length;c++){var a;if(this.isHistogram){a=this.measureText(this.shortenText(this.xAxis[c],this.maxSmpStringLen),this.legendFont)}else{a=this.measureText(this.shortenText(this.xAxis[c],this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[c],this.maxSmpStringLen),this.legendFont)}b=Math.max(a,b)}}else{if(this.xAxisIndices.length>this.yAxisIndices.length){b=this.measureText(this.shortenText(this.getMaxText(this.xAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[0],this.maxSmpStringLen),this.legendFont)}else{if(this.yAxisIndices.length>this.xAxisIndices.length){if(this.isHistogram){b=this.measureText(this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen),this.legendFont)}else{b=this.measureText(this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.xAxis[0],this.maxSmpStringLen),this.legendFont)}}}}this.legendSampleWidth=(d-1)+b+(this.margin*3);this.legendSampleHeight=(Math.max(this.xAxisIndices.length,this.yAxisIndices.length)*(d+this.margin))+this.margin}else{if(this.isHistogram){b=this.measureText(this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen),this.legendFont);this.legendSampleWidth=(d-1)+b+(this.margin*3);this.legendSampleHeight=(Math.max(this.xAxisIndices.length,this.yAxisIndices.length)*(d+this.margin))+this.margin}}};this.drawSampleLegend=function(b,k){var j=b;var d=k;var p=this.getFontPt(this.legendFont);var o=(p-1)/2;k+=this.margin+o;if(this.legendBox&&this.legendBackgroundColor){this.disableGradientTransparencyShadow();this.rectangle(j,d,this.legendSampleWidth,this.legendSampleHeight,this.legendBackgroundColor,this.legendBoxColor);this.enableGradientTransparencyShadow()}var m=Math.max(this.xAxisIndices.length,this.yAxisIndices.length);for(var f=0;f<m;f++){var c=f%this.colors.length;var n=0;var g=this.xAxisIndices.length==this.yAxisIndices.length?this.yAxis[f]:this.xAxisIndices.length>this.yAxisIndices.length?this.yAxis[this.yAxisCurrent]:this.yAxis[f];var h=this.xAxisIndices.length==this.yAxisIndices.length?this.xAxis[f]:this.xAxisIndices.length>this.yAxisIndices.length?this.xAxis[f]:this.xAxis[this.xAxisCurrent];var l=this.isHistogram?this.shortenText(g,this.maxSmpStringLen):this.shortenText(g,this.maxSmpStringLen)+" vs "+this.shortenText(h,this.maxSmpStringLen);var e=b+o+this.margin;var a=k+o+this.margin;if(this.colorBy){this.drawShape(this.shapes[n],e,k,p-1,p-1,this.background,this.colors[c],"open")}else{this.drawShape(this.shapes[n],e,k,p-1,p-1,this.colors[c],this.foreground,"closed")}this.drawText(l,e+o+this.margin,k,this.legendFont,this.legendColor,"left","middle");k+=p+this.margin}if(this.legendBox){this.disableGradientTransparencyShadow();this.rectangle(j,d,this.legendSampleWidth,this.legendSampleHeight,false,this.legendBoxColor,"open");this.enableGradientTransparencyShadow()}this.addArea(["rect",j,d,j+this.legendSampleWidth,d+this.legendSampleHeight],[-1],"-legend-sample")};this.setVariableLegendDimension=function(){this.legendVariableWidth=0;this.legendVariableHeight=0;if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){var a=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],this.getFontPt(this.legendFont)):this.getFontPt(this.legendFont);var b=this.shortenText(this.maxVarNameStr,this.maxVarStringLen);this.legendVariableWidth=(a-1)+this.measureText(b,this.legendFont)+(this.margin*3);this.legendVariableHeight=(this.varIndices.length*(a+this.margin))+this.margin}};this.drawVariableLegend=function(c,m){if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){var k=c;var e=m;var q=this.getFontPt(this.legendFont);var l=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],q):q;m+=this.margin+(l/2);if(this.legendBox&&this.legendBackgroundColor){this.disableGradientTransparencyShadow();this.rectangle(k,e,this.legendVariableWidth,this.legendVariableHeight,this.legendBackgroundColor,this.legendBoxColor);this.enableGradientTransparencyShadow()}for(var g=0;g<this.varIndices.length;g++){var n=this.varIndices[g];var d=this.graphType=="Circular"||(this.colorBy&&this.colorBy=="variable")?g%this.colors.length:0;var p=this.shapeBy&&this.shapeBy=="variable"?g%this.shapes.length:0;var b=this.sizeBy&&this.sizeBy=="variable"?this.sizes[g%this.sizes.length]:l;var j=this.patternBy&&this.patternBy=="variable"?g%this.patterns.length:0;var o=l/2;var f=c+o+this.margin;var a=m+o+this.margin;var h=this.shortenText(this.data.y.vars[n],this.maxVarStringLen);if(this.colorBy&&this.colorBy!="variable"){this.drawShape(this.shapes[p],f,m,b,b,this.background,this.foreground,this.patterns[j])}else{this.drawShape(this.shapes[p],f,m,b,b,this.colors[d],this.foreground,"closed")}this.drawText(h,f+o+this.margin,m,this.legendFont,this.legendColor,"left","middle");m+=l+this.margin}if(this.legendBox){this.disableGradientTransparencyShadow();this.rectangle(k,e,this.legendVariableWidth,this.legendVariableHeight,false,this.legendBoxColor,"open");this.enableGradientTransparencyShadow()}this.addArea(["rect",k,e,k+this.legendVariableWidth,e+this.legendVariableHeight],[-1],"-legend-variable")}};this.setColorLegendIndicatorDimensions=function(){if(this.colorBy||this.outlineBy){var a=this.heatmapType.split("-");if(this.heatmapType.split("-").length>1){this.legendColorIndicatorWidth=parseInt(2*256*this.indicatorWidth/this.indicatorBins)+(this.margin*4)+1}else{this.legendColorIndicatorWidth=parseInt(1*256*this.indicatorWidth/this.indicatorBins)+(this.margin*4)+1}this.legendColorIndicatorHeight=this.indicatorHeight+(this.margin*3)+this.getFontPt(this.legendFont);this.legendColorIndicatorHeight+=this.getFontPt(this.legendFont)+this.margin}};this.getHeatmapColor=function(d,c,e){var b=Math.abs(d);d+=b;c+=b;e+=b;var a=((e-d)*this.heatmapColors.length/(c-d)).toFixed()-1;return this.heatmapColors[Math.max(0,Math.min(this.heatmapColors.length-1,a))]};this.drawColorIndicator=function(d,n,f,l,h,b){if(this.colorBy||this.outlineBy||b){var k=d;var e=n;var a=this.indicatorHeight;var m=this.indicatorHeight;if(this.indicatorsPosition=="bottom"){for(var g=0;g<this.heatmapColors.length;g++){var j=this.transparency!=null?this.addColorTransparency(this.heatmapColors[g],this.transparency):this.heatmapColors[g];this.drawLine("line",d,n,d,n+m,j,this.indicatorWidth+0.5);d+=this.indicatorWidth}d=k-(this.indicatorWidth/2);n+=m+this.margin;this.drawText(sprintf("%."+h+"f",f),d,n,this.legendFont,this.legendColor,"center","top");d+=(this.heatmapColors.length*this.indicatorWidth/2)-(this.indicatorWidth/2);if(this.heatmapColors.length>=10){this.drawText(sprintf("%."+h+"f",(f+l)/2),d,n,this.legendFont,this.legendColor,"center","top")}if(!b){this.drawText(this.colorBy||this.outlineBy,d,n+this.margin+this.getFontPt(this.legendFont),this.legendFont,this.legendColor,"center","top")}d+=(this.heatmapColors.length*this.indicatorWidth/2)-(this.indicatorWidth/2);this.drawText(sprintf("%."+h+"f",l),d,n,this.legendFont,this.legendColor,"center","top");this.addArea(["rect",k-(this.margin*2),e-this.margin,d+(this.margin*2),n+this.getFontPt(this.legendFont)+this.margin],[-1],"-legend-indicator-color")}else{for(var g=0;g<this.heatmapColors.length;g++){var j=this.transparency!=null?this.addColorTransparency(this.heatmapColors[g],this.transparency):this.heatmapColors[g];this.drawLine("line",d,n,d+a,n,j,this.indicatorWidth+0.5);n-=this.indicatorWidth}d+=a+this.margin;n=e-(this.indicatorWidth/2);this.drawText(sprintf("%."+h+"f",f),d,n,this.legendFont,this.legendColor,"center","top",-Math.PI/2);n-=(this.heatmapColors.length*this.indicatorWidth/2)-(this.indicatorWidth/2);if(this.heatmapColors.length>=10){this.drawText(sprintf("%."+h+"f",(f+l)/2),d,n,this.legendFont,this.legendColor,"center","top",-Math.PI/2)}if(!b){this.drawText(this.colorBy||this.outlineBy,d+this.margin+this.getFontPt(this.legendFont),n,this.legendFont,this.legendColor,"center","top",-Math.PI/2)}n-=(this.heatmapColors.length*this.indicatorWidth/2)-(this.indicatorWidth/2);this.drawText(sprintf("%."+h+"f",l),d,n,this.legendFont,this.legendColor,"center","top",-Math.PI/2);this.addArea(["rect",k-this.margin,n-(this.margin*2),d+this.margin+this.getFontPt(this.legendFont),e+(this.margin*2)],[-1],"-legend-indicator-color")}}};this.setShapeLegendIndicatorDimensions=function(){if(this.shapeBy){this.legendShapeIndicatorWidth=(10*(this.indicatorHeight+this.margin))+(this.margin*2);this.legendShapeIndicatorHeight=this.indicatorHeight+(this.margin*3)+this.getFontPt(this.legendFont);this.legendShapeIndicatorHeight+=this.getFontPt(this.legendFont)+this.margin}};this.drawShapeIndicator=function(b,m,e,l,g){if(this.shapeBy){var k=b;var c=m;var j=this.indicatorHeight/2;var d=b;var a=m;if(this.indicatorsPosition=="bottom"){for(var f=0;f<10;f++){this.drawShape("pie"+f,d,a+this.margin,this.indicatorHeight,this.indicatorHeight,this.background,this.foreground,"open");d+=this.indicatorHeight+j}b=k;m+=this.indicatorHeight+this.margin;this.drawText(sprintf("%."+g+"f",e),b,m,this.legendFont,this.legendColor,"center","top");b+=this.indicatorHeight*7;this.drawText(sprintf("%."+g+"f",(e+l)/2),b,m,this.legendFont,this.legendColor,"center","top");this.drawText(this.shapeBy||shapeBy,b,m+this.margin+this.getFontPt(this.legendFont),this.legendFont,this.legendColor,"center","top");b+=this.indicatorHeight*7;this.drawText(sprintf("%."+g+"f",l),b,m,this.legendFont,this.legendColor,"center","top");this.addArea(["rect",k-(this.margin*2),c-this.margin,b+(this.margin*2),m+this.getFontPt(this.legendFont)+this.margin],[-1],"-legend-indicator-shape")}else{for(var f=0;f<10;f++){this.drawShape("pie"+f,d+this.margin,a,this.indicatorHeight,this.indicatorHeight,this.background,this.foreground,"open");a-=this.indicatorHeight+j}b+=this.indicatorHeight+this.margin;m=c;this.drawText(sprintf("%."+g+"f",e),b,m,this.legendFont,this.legendColor,"center","top",-Math.PI/2);m-=this.indicatorHeight*7;if(this.heatmapColors.length>=10){this.drawText(sprintf("%."+g+"f",(e+l)/2),b,m,this.legendFont,this.legendColor,"center","top",-Math.PI/2)}this.drawText(this.shapeBy||shapeBy,b+this.margin+this.getFontPt(this.legendFont),m,this.legendFont,this.legendColor,"center","top",-Math.PI/2);m-=this.indicatorHeight*7;this.drawText(sprintf("%."+g+"f",l),b,m,this.legendFont,this.legendColor,"center","top",-Math.PI/2);this.addArea(["rect",k-this.margin,m-(this.margin*2),b+this.margin+this.getFontPt(this.legendFont),c+(this.margin*2)],[-1],"-legend-indicator-shape")}}};this.setSizeLegendIndicatorDimensions=function(){if(this.sizeBy){var a=0;var c=this.indicatorHeight/2;for(var b=0;b<10;b++){a+=this.sizes[b]+c}this.legendSizeIndicatorWidth=(a-(this.sizes[0]+this.sizes[9]))+(this.margin*4);this.legendSizeIndicatorHeight=this.sizes[9]+(this.margin*3)+this.getFontPt(this.legendFont);this.legendSizeIndicatorHeight+=this.getFontPt(this.legendFont)+this.margin}};this.drawSizeIndicator=function(d,p,g,o,k){if(this.sizeBy){var n=d;var e=p;var l=this.indicatorHeight/2;var q=this.sizes[9];var f=d;var a=p;var m=d;var c=p;if(this.indicatorsPosition=="bottom"){for(var j=0;j<10;j++){var b=this.sizes[j];this.drawShape("sphere",f,a+(q/2),b,b,this.background,this.foreground,"open");f+=b+l;if(j<4){m+=b+l}else{if(j==5){m+=(b+l)/2}}}p+=q+this.margin;this.drawText(sprintf("%."+k+"f",g),n,p,this.legendFont,this.legendColor,"center","top");this.drawText(sprintf("%."+k+"f",(g+o)/2),m,p,this.legendFont,this.legendColor,"center","top");this.drawText(this.sizeBy,n+(this.legendSizeIndicatorWidth/2),p+this.margin+this.getFontPt(this.legendFont),this.legendFont,this.legendColor,"center","top");this.drawText(sprintf("%."+k+"f",o),f-(q+l),p,this.legendFont,this.legendColor,"center","top");this.addArea(["rect",n-(this.margin*2),e-this.margin,(f-q)+(this.margin*2),p+this.getFontPt(this.legendFont)+this.margin],[-1],"-legend-indicator-size")}else{for(var j=0;j<10;j++){var b=this.sizes[j];this.drawShape("sphere",f+(q/2),a,b,b,this.background,this.foreground,"open");a-=(b+l);if(j<4){c-=(b+l)}else{if(j==5){c-=((b+l)/2)}}}d+=q+this.margin;this.drawText(sprintf("%."+k+"f",g),d,p,this.legendFont,this.legendColor,"center","top",-Math.PI/2);this.drawText(sprintf("%."+k+"f",(g+o)/2),d,c,this.legendFont,this.legendColor,"center","top",-Math.PI/2);this.drawText(this.sizeBy,d+this.margin+this.getFontPt(this.legendFont),e-(this.legendSizeIndicatorWidth/2),this.legendFont,this.legendColor,"center","top",-Math.PI/2);this.drawText(sprintf("%."+k+"f",o),d,a+(q+l),this.legendFont,this.legendColor,"center","top",-Math.PI/2);this.addArea(["rect",n-this.margin,(a+(q+l))-(this.margin*2),d+this.margin+this.getFontPt(this.legendFont),e+(this.margin*2)],[-1],"-legend-indicator-size")}}};this.setDataColorShapeSizeIndicatorDimensions=function(){this.setColorLegendIndicatorDimensions();this.setShapeLegendIndicatorDimensions();this.setSizeLegendIndicatorDimensions()};this.getDiameterLegend=function(){return this.x>=600?10:this.x>=400?8:this.x>=200?6:4};this.setColorLegendDimensions=function(h){this.legendColorWidth=0;this.legendColorHeight=0;if(this.colorBy||this.outlineBy){var b,c,i,f;var g=this.getDiameterLegend();if(h){b=this.colorBy||this.outlineBy;c=h}else{if(this.data.x&&this.data.x.hasOwnProperty(this.colorBy)){b=this.setMaxSmpStringAnnt(this.colorBy);c=this.legendColorsMax}else{if(this.data.z&&this.data.z.hasOwnProperty(this.colorBy)){b=this.setMaxVarStringAnnt(this.colorBy);c=this.setMaxVarStringLabel(this.colorBy)}else{b=0;c=0}}}var a=this.measureText(b,this.legendFont);var e=this.measureText(c,this.legendFont)+g+this.margin;this.legendColorWidth=Math.max(a,e)+(this.margin*2);var k=this.getFontPt(this.legendFont);var j=Math.max(g,k);this.legendColorHeight=(this.legendColorsN*(j+this.margin))+k+(this.margin*3)}};this.drawColorLegend=function(a,k){if((this.outlineBy&&this.isMultidimensionalData)||(this.colorBy&&((this.data.x&&this.data.x.hasOwnProperty(this.colorBy))||(this.data.z&&this.data.z.hasOwnProperty(this.colorBy))))){var g=this.getDiameterLegend();var m=this.getFontPt(this.legendFont);var f=m/2;var l=k+this.margin+f;var h=Math.max(g,m);this.disableGradientTransparencyShadow();if(this.legendBox&&this.legendBackgroundColor){this.rectangle(a,k,this.legendColorWidth,this.legendColorHeight,this.legendBackgroundColor,this.legendBoxColor)}else{if(this.legendBox){this.rectangle(a,k,this.legendColorWidth,this.legendColorHeight,false,this.legendBoxColor,"open")}}this.enableGradientTransparencyShadow();this.drawText(this.colorBy||this.outlineBy,a+(this.legendColorWidth/2),l,this.legendFont,this.colorLegend,"center","middle");l+=f+this.margin;this.disableGradientTransparencyShadow();this.drawLine("line",a,l,a+this.legendColorWidth,l,this.legendBoxColor);this.enableGradientTransparencyShadow();l+=this.margin+(h/2);if(this.colorByType=="x"){var e=[];var j=this.isGroupedData?this.grpIndices:this.smpIndices;for(var b in this.legendColors){if(this.cacheColors&&this.cacheColors[this.colorBy]&&this.cacheColors[this.colorBy][b]){e.push([b,this.colors[this.cacheColors[this.colorBy][b]]])}else{e.push([b,this.legendColors[b]])}}if(j.length>e.length){for(var b in this.legendColors){if(this.outlineBy){this.drawShape("circle",a+this.margin+(g/2),l,g,g,false,this.legendColors[b],"open",false,2)}else{this.drawShape("circle",a+this.margin+(g/2),l,g,g,this.legendColors[b],this.foreground,"closed")}this.drawText(b,a+(this.margin*2)+g,l,this.legendFont,this.colorLegend,"left","middle");l+=this.margin+h}}else{for(var c=0;c<e.length;c++){if(this.outlineBy){this.drawShape("circle",a+this.margin+(g/2),l,g,g,false,e[c][1],"open",false,2)}else{this.drawShape("circle",a+this.margin+(g/2),l,g,g,e[c][1],this.foreground,"closed")}this.drawText(e[c][0],a+(this.margin*2)+g,l,this.legendFont,this.colorLegend,"left","middle");l+=this.margin+h}}}else{for(var b in this.legendColors){if(this.outlineBy){this.drawShape("circle",a+this.margin+(g/2),l,g,g,false,this.legendColors[b],"open",false,2)}else{this.drawShape("circle",a+this.margin+(g/2),l,g,g,this.legendColors[b],this.foreground,"closed")}this.drawText(b,a+(this.margin*2)+g,l,this.legendFont,this.colorLegend,"left","middle");l+=this.margin+h}}this.addArea(["rect",a,k,a+this.legendColorWidth,k+this.legendColorHeight],[-1],"-legend-color")}};this.setShapeLegendDimensions=function(a){this.legendShapeWidth=0;this.legendShapeHeight=0;if(this.shapeBy){var f,e;var i=this.getDiameterLegend();if(a){f=this.shapeBy;e=a}else{if(this.data.x&&this.data.x.hasOwnProperty(this.shapeBy)){f=this.setMaxSmpStringAnnt(this.shapeBy);e=this.legendShapesMax}else{if(this.data.z&&this.data.z.hasOwnProperty(this.shapeBy)){f=this.setMaxVarStringAnnt(this.shapeBy);e=this.setMaxVarStringLabel(this.shapeBy)}else{f=0;e=0}}}var b=this.measureText(f,this.legendFont);var c=this.measureText(e,this.legendFont)+i+this.margin;this.legendShapeWidth=Math.max(b,c)+(this.margin*2);var h=this.getFontPt(this.legendFont);var g=Math.max(i,h);this.legendShapeHeight=(this.legendShapesN*(g+this.margin))+h+(this.margin*3)}};this.drawShapeLegend=function(b,c){if((this.shapeBy&&this.isMultidimensionalData)||(this.shapeBy&&((this.data.x&&this.data.x.hasOwnProperty(this.shapeBy))||(this.data.z&&this.data.z.hasOwnProperty(this.shapeBy))))){var h=this.getDiameterLegend();var e=this.getFontPt(this.legendFont);var i=e/2;var g=c+this.margin+i;var a=Math.max(h,e);this.disableGradientTransparencyShadow();if(this.legendBackgroundColor&&this.legendBackgroundColor){this.rectangle(b,c,this.legendShapeWidth,this.legendShapeHeight,this.legendBackgroundColor,this.legendBoxColor)}else{if(this.legendBox){this.rectangle(b,c,this.legendShapeWidth,this.legendShapeHeight,false,this.legendBoxColor,"open")}}this.enableGradientTransparencyShadow();this.drawText(this.shapeBy,b+(this.legendShapeWidth/2),g,this.legendFont,this.colorLegend,"center","middle");g+=i+this.margin;this.disableGradientTransparencyShadow();this.drawLine("line",b,g,b+this.legendShapeWidth,g,this.legendBoxColor);this.enableGradientTransparencyShadow();g+=this.margin+(a/2);for(var f in this.legendShapes){this.drawShape(this.legendShapes[f],b+this.margin+(h/2),g,h,h,this.background,this.foreground,"closed");this.drawText(f,b+(this.margin*2)+h,g,this.legendFont,this.colorLegend,"left","middle");g+=this.margin+a}this.addArea(["rect",b,c,b+this.legendShapeWidth,c+this.legendShapeHeight],[-1],"-legend-shape")}};this.setSizeLegendDimensions=function(a){this.legendSizeWidth=0;this.legendSizeHeight=0;if(this.sizeBy){var f,e;var i=this.sizes[this.legendSizesN-1];if(a){f=this.sizeBy;e=a}else{if(this.data.x&&this.data.x.hasOwnProperty(this.sizeBy)){f=this.setMaxSmpStringAnnt(this.sizeBy);e=this.legendSizesMax}else{if(this.data.z&&this.data.z.hasOwnProperty(this.sizeBy)){f=this.setMaxVarStringAnnt(this.sizeBy);e=this.setMaxVarStringLabel(this.sizeBy)}else{f=0;e=0}}}var b=this.measureText(f,this.legendFont);var c=this.measureText(e,this.legendFont)+i+this.margin;this.legendSizeWidth=Math.max(b,c)+(this.margin*2);var h=this.getFontPt(this.legendFont);var g=Math.max(i,h);this.legendSizeHeight=(this.legendSizesN*(g+this.margin))+h+(this.margin*3)}};this.drawSizeLegend=function(c,e){if((this.sizeBy&&this.isMultidimensionalData)||(this.sizeBy&&((this.data.x&&this.data.x.hasOwnProperty(this.sizeBy))||(this.data.z&&this.data.z.hasOwnProperty(this.sizeBy))))){var h=this.sizes[this.legendSizesN-1];var f=this.getFontPt(this.legendFont);var i=f/2;var g=e+this.margin+i;var a=Math.max(h,f);this.disableGradientTransparencyShadow();if(this.legendBackgroundColor&&this.legendBackgroundColor){this.rectangle(c,e,this.legendSizeWidth,this.legendSizeHeight,this.legendBackgroundColor,this.legendBoxColor)}else{if(this.legendBox){this.rectangle(c,e,this.legendSizeWidth,this.legendSizeHeight,false,this.legendBoxColor,"open")}}this.enableGradientTransparencyShadow();this.drawText(this.sizeBy,c+(this.legendSizeWidth/2),g,this.legendFont,this.colorLegend,"center","middle");g+=i+this.margin;this.disableGradientTransparencyShadow();this.drawLine("line",c,g,c+this.legendSizeWidth,g,this.legendBoxColor);this.enableGradientTransparencyShadow();g+=this.margin+(a/2);for(var b in this.legendSizes){this.drawShape("circle",c+this.margin+(h/2),g,this.legendSizes[b],this.legendSizes[b],this.background,this.foreground,"closed");this.drawText(b,c+(this.margin*2)+h,g,this.legendFont,this.colorLegend,"left","middle");g+=this.margin+a}this.addArea(["rect",c,e,c+this.legendSizeWidth,e+this.legendSizeHeight],[-1],"-legend-size")}};this.setPatternLegendDimensions=function(a){this.legendPatternWidth=0;this.legendPatternHeight=0;if(this.patternBy){var f,e;var i=this.getDiameterLegend();if(a){f=this.patternBy;e=a}else{if(this.data.x&&this.data.x.hasOwnProperty(this.patternBy)){f=this.setMaxSmpStringAnnt(this.patternBy);e=this.legendPatternsMax}else{if(this.data.z&&this.data.z.hasOwnProperty(this.patternBy)){f=this.setMaxVarStringAnnt(this.patternBy);e=this.setMaxVarStringLabel(this.patternBy)}else{f=0;e=0}}}var b=this.measureText(f,this.legendFont);var c=this.measureText(e,this.legendFont)+i+this.margin;this.legendPatternWidth=Math.max(b,c)+(this.margin*2);var h=this.getFontPt(this.legendFont);var g=Math.max(i,h);this.legendPatternHeight=(this.legendPatternsN*(g+this.margin))+h+(this.margin*3)}};this.drawPatternLegend=function(c,e){if((this.patternBy&&this.isMultidimensionalData)||(this.patternBy&&((this.data.x&&this.data.x.hasOwnProperty(this.patternBy))||(this.data.z&&this.data.z.hasOwnProperty(this.patternBy))))){var h=this.getDiameterLegend();var f=this.getFontPt(this.legendFont);var i=f/2;var g=e+this.margin+i;var a=Math.max(h,f);this.disableGradientTransparencyShadow();if(this.legendBox&&this.legendBackgroundColor){this.rectangle(c,e,this.legendPatternWidth,this.legendPatternHeight,this.legendBackgroundColor,this.legendBoxColor)}else{if(this.legendBox){this.rectangle(c,e,this.legendPatternWidth,this.legendPatternHeight,false,this.legendBoxColor,"open")}}this.enableGradientTransparencyShadow();this.drawText(this.patternBy,c+(this.legendPatternWidth/2),g,this.legendFont,this.colorLegend,"center","middle");g+=i+this.margin;this.disableGradientTransparencyShadow();this.drawLine("line",c,g,c+this.legendPatternWidth,g,this.legendBoxColor);this.enableGradientTransparencyShadow();g+=this.margin+(a/2);for(var b in this.legendPatterns){this.drawShape("square",c+this.margin+(h/2),g,h,h,this.background,this.foreground,this.legendPatterns[b]);this.drawText(b,c+(this.margin*2)+h,g,this.legendFont,this.colorLegend,"left","middle");g+=this.margin+a}this.addArea(["rect",c,e,c+this.legendPatternWidth,e+this.legendPatternHeight],[-1],"-legend-pattern")}};this.setDataColorShapeSizeDimensions=function(){this.setColorLegendDimensions();this.setShapeLegendDimensions();this.setSizeLegendDimensions();this.setPatternLegendDimensions()};this.setDataColor=function(d){this.colorByType=false;var a={};if(!this.cacheColors){this.cacheColors={}}if(d&&this.isMultidimensionalData){var l=0;this.dataColors=[];this.legendColors={};this.legendColorsN=0;if(this.isNumeric2DArray(d)){var g=this.setRangeDataObject(d);for(var f=0;f<this.varIndices.length;f++){for(var e=0;e<this.smpIndices.length;e++){var b=d[this.varIndices[f]][this.smpIndices[e]];var c=!isNaN(b)?this.getHeatmapColor(g[0],g[1],b):this.missingDataColor;this.dataColors.push(c)}}this.legendColorsN=-1;this.legendColorRange=g;this.legendColorDecs=this.getAxisDecimals(this.getAxisIncrements(g[0],g[1],this.heatmapColors.length));this.setColorLegendIndicatorDimensions()}else{var k=0;for(var f=0;f<this.varIndices.length;f++){for(var e=0;e<this.smpIndices.length;e++){var c=d[this.varIndices[f]][this.smpIndices[e]];if(!a.hasOwnProperty(c)){var h=this.measureText(c,this.legendFont);if(h>k){k=h;this.legendColorsMax=c}a[c]=this.cacheColors[this.colorBy]&&this.cacheColors[this.colorBy][c]!=null?this.cacheColors[this.colorBy][c]:l%this.colors.length;this.legendColors[c]=this.colors[a[c]];l++}this.dataColors.push(this.colors[a[c]])}}this.legendColorsN=l;this.setColorLegendDimensions(this.legendColorsMax)}}else{if(this.colorBy){var l=0;this.dataColors=[];this.legendColors={};this.legendColorsN=0;if(this.data.x&&this.data.x.hasOwnProperty(this.colorBy)){this.colorByType="x";var n=this.isGroupedData?this.grpIndices:this.smpIndices;if(this.isNumeric(this.data.x[this.colorBy],true)){var g=this.range(this.data.x[this.colorBy],true);for(var f=0;f<n.length;f++){var m=n[f];if(this.isGroupedData&&(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData))){for(var e=0;e<this.data.w.grps[m].length;e++){var b=this.data.x[this.colorBy][this.data.w.grps[m][e]];var c=!isNaN(b)?this.getHeatmapColor(g[0],g[1],b):this.missingDataColor;this.dataColors.push(c)}}else{var b=this.isGroupedData?this.mean(this.getSmpAnnotations(this.colorBy,this.data.w.grps[f],false,true)):this.data.x[this.colorBy][m];var c=!isNaN(b)?this.getHeatmapColor(g[0],g[1],b):this.missingDataColor;this.dataColors.push(c)}}this.legendColorsN=-1;this.legendColorRange=g;this.legendColorDecs=this.getAxisDecimals(this.getAxisIncrements(g[0],g[1],this.heatmapColors.length));this.setColorLegendIndicatorDimensions()}else{var k=0;for(var f=0;f<n.length;f++){var m=n[f];if(this.isGroupedData&&(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData))){for(var e=0;e<this.data.w.grps[m].length;e++){var c=this.data.x[this.colorBy][this.data.w.grps[m][e]];if(!a.hasOwnProperty(c)){var h=this.measureText(c,this.legendFont);if(h>k){k=h;this.legendColorsMax=c}a[c]=this.cacheColors[this.colorBy]&&this.cacheColors[this.colorBy][c]!=null?this.cacheColors[this.colorBy][c]:l%this.colors.length;this.legendColors[c]=this.colors[a[c]];l++}this.dataColors.push(this.colors[a[c]])}}else{var c=this.isGroupedData?this.getSmpAnnotations(this.colorBy,this.data.w.grps[f],true):this.data.x[this.colorBy][m];if(!a.hasOwnProperty(c)){var h=this.measureText(c,this.legendFont);if(h>k){k=h;this.legendColorsMax=c}a[c]=this.cacheColors[this.colorBy]&&this.cacheColors[this.colorBy][c]!=null?this.cacheColors[this.colorBy][c]:l%this.colors.length;this.legendColors[c]=this.colors[a[c]];l++}this.dataColors.push(this.colors[a[c]])}}this.legendColorsN=l;this.setColorLegendDimensions()}}else{if(this.data.z&&this.data.z.hasOwnProperty(this.colorBy)){this.colorByType="z";if(this.isNumeric(this.data.z[this.colorBy],false,true)){var g=this.range(this.data.z[this.colorBy],false,true);for(var f=0;f<this.varIndices.length;f++){var m=this.varIndices[f];var b=this.data.z[this.colorBy][m];if(!isNaN(b)){this.dataColors.push(this.getHeatmapColor(g[0],g[1],b))}else{this.dataColors.push(this.missingDataColor)}}this.legendColorRange=g;this.legendColorDecs=this.getAxisDecimals(this.getAxisIncrements(g[0],g[1],this.heatmapColors.length));this.setColorLegendIndicatorDimensions()}else{for(var f=0;f<this.varIndices.length;f++){var m=this.varIndices[f];var c=this.data.z[this.colorBy][m];if(!a.hasOwnProperty(c)){a[c]=this.cacheColors[this.colorBy]&&this.cacheColors[this.colorBy][c]!=null?this.cacheColors[this.colorBy][c]:l%this.colors.length;this.legendColors[c]=this.colors[a[c]];l++}this.dataColors.push(this.colors[a[c]])}this.legendColorsN=l;this.setColorLegendDimensions()}}else{if(this.getSampleIndices(this.colorBy)>-1){var l=this.getSampleIndices(this.colorBy);var g=this.getAxisRangeBySample(l);if(!this.scatterType||this.scatterType!="function"){for(var f=0;f<this.varIndices.length;f++){var m=this.varIndices[f];var b=this.getDataAtPos(m,l);if(!isNaN(b)){this.dataColors.push(this.getHeatmapColor(g[0],g[1],b))}else{this.dataColors.push(this.missingDataColor)}}}this.legendColorRange=g;this.legendColorDecs=this.getAxisDecimals(this.getAxisIncrements(g[0],g[1],this.heatmapColors.length));this.setColorLegendIndicatorDimensions()}else{if(this.colorBy=="variable"){for(var f=0;f<this.varIndices.length;f++){var c=f%this.colors.length;this.dataColors.push(this.colors[c])}this.legendColorsN=this.dataColors.length;this.setVariableLegendDimension()}else{for(var f=0;f<this.varIndices.length;f++){this.dataColors.push(this.colors[0])}}}}}}}if(!this.cacheColors[this.colorBy]){this.cacheColors[this.colorBy]=a}else{for(var f in a){if(!this.cacheColors[this.colorBy].hasOwnProperty(f)){this.cacheColors[this.colorBy][f]=a[f]}}}};this.setDataShape=function(c){this.shapeByType=false;if(c&&this.isMultidimensionalData){var l=0;var a={};var p="square";this.dataShapes=[];this.legendShapes={};this.legendShapesN=0;if(this.isNumeric2DArray(c)){var g=this.setRangeDataObject(c);for(var f=0;f<this.varIndices.length;f++){for(var e=0;e<this.smpIndices.length;e++){var b=c[this.varIndices[f]][this.smpIndices[e]];if(!isNaN(b)){var d=this.percentile(g[0],g[1],b);var o=parseInt(d/10);if(o>0){o--}this.dataShapes.push("pie"+o)}else{this.dataShapes.push(p)}}}this.legendShapeRange=g;this.legendShapeDecs=this.getAxisDecimals(this.getAxisIncrements(g[0],g[1],10));this.setShapeLegendIndicatorDimensions()}else{var k=0;for(var f=0;f<this.varIndices.length;f++){for(var e=0;e<this.smpIndices.length;e++){var o=c[this.varIndices[f]][this.smpIndices[e]];if(!a.hasOwnProperty(o)){var h=this.measureText(o,this.legendFont);if(h>k){k=h;this.legendShapesMax=o}a[o]=l%this.shapes.length;this.legendShapes[o]=this.shapes[a[o]];l++}this.dataShapes.push(this.shapes[a[o]])}}this.legendShapesN=l;this.setShapeLegendDimensions(this.legendShapesMax)}}else{if(this.shapeBy){var l=0;var a={};var p="square";this.dataShapes=[];this.legendShapes={};this.legendShapesN=0;if(this.data.x&&this.data.x.hasOwnProperty(this.shapeBy)){this.shapeByType="x";var n=this.isGroupedData?this.grpIndices:this.smpIndices;if(this.isNumeric(this.data.x[this.shapeBy],true)){var g=this.range(this.data.x[this.shapeBy],true);for(var f=0;f<n.length;f++){var m=n[f];if(this.isGroupedData){for(var e=0;e<this.data.w.grps[m].length;e++){var b=this.data.x[this.shapeBy][this.data.w.grps[m][e]];if(!isNaN(b)){var d=this.percentile(g[0],g[1],b);var o=parseInt(d/10);if(o>0){o--}this.dataShapes.push("pie"+o)}else{this.dataShapes.push(p)}}}else{var b=this.data.x[this.shapeBy][m];if(!isNaN(b)){var d=this.percentile(g[0],g[1],b);var o=parseInt(d/10);if(o>0){o--}this.dataShapes.push("pie"+o)}else{this.dataShapes.push(p)}}}this.legendShapeRange=g;this.legendShapeDecs=this.getAxisDecimals(this.getAxisIncrements(g[0],g[1],10));this.setShapeLegendIndicatorDimensions()}else{var k=0;for(var f=0;f<n.length;f++){var m=n[f];if(this.isGroupedData){for(var e=0;e<this.data.w.grps[m].length;e++){var o=this.data.x[this.shapeBy][this.data.w.grps[m][e]];if(!a.hasOwnProperty(o)){var h=this.measureText(o,this.legendFont);if(h>k){k=h;this.legendShapesMax=o}a[o]=l%this.shapes.length;this.legendShapes[o]=this.shapes[a[o]];l++}this.dataShapes.push(this.shapes[a[o]])}}else{var o=this.data.x[this.shapeBy][m];if(!a.hasOwnProperty(o)){var h=this.measureText(o,this.legendFont);if(h>k){k=h;this.legendShapesMax=o}a[o]=l%this.shapes.length;this.legendShapes[o]=this.shapes[a[o]];l++}this.dataShapes.push(this.shapes[a[o]])}}this.legendShapesN=l;this.setShapeLegendDimensions()}}else{if(this.data.z&&this.data.z.hasOwnProperty(this.shapeBy)){this.shapeByType="z";if(this.isNumeric(this.data.z[this.shapeBy],false,true)){var g=this.range(this.data.z[this.shapeBy],false,true);for(var f=0;f<this.varIndices.length;f++){var m=this.varIndices[f];var b=this.data.z[this.shapeBy][m];if(!isNaN(b)){var d=this.percentile(g[0],g[1],b);var o=parseInt(d/10);if(o>0){o--}this.dataShapes.push("pie"+o)}else{this.dataShapes.push(p)}}this.legendShapeRange=g;this.legendShapeDecs=this.getAxisDecimals(this.getAxisIncrements(g[0],g[1],10));this.setShapeLegendIndicatorDimensions()}else{for(var f=0;f<this.varIndices.length;f++){var m=this.varIndices[f];var o=this.data.z[this.shapeBy][m];if(!a.hasOwnProperty(o)){a[o]=l%this.shapes.length;this.legendShapes[o]=this.shapes[a[o]];l++}this.dataShapes.push(this.shapes[a[o]])}this.legendShapesN=l;this.setShapeLegendDimensions()}}else{if(this.getSampleIndices(this.shapeBy)>-1){l=this.getSampleIndices(this.shapeBy);var g=this.getAxisRangeBySample(l);for(var f=0;f<this.varIndices.length;f++){var m=this.varIndices[f];var b=this.getDataAtPos(m,l);if(!isNaN(b)){var d=this.percentile(g[0],g[1],b);var o=parseInt(d/10);if(o>0){o--}this.dataShapes.push("pie"+o)}else{this.dataShapes.push(p)}}this.legendShapeRange=g;this.legendShapeDecs=this.getAxisDecimals(this.getAxisIncrements(g[0],g[1],10));this.setShapeLegendIndicatorDimensions()}else{if(this.shapeBy=="variable"){for(var f=0;f<this.varIndices.length;f++){var o=f%this.shapes.length;this.dataShapes.push(this.shapes[o])}this.legendShapesN=this.dataShapes.length;this.setVariableLegendDimension()}else{for(var f=0;f<this.varIndices.length;f++){this.dataShapes.push(this.shapes[0])}}}}}}}};this.setDataSize=function(d){this.sizeByType=false;if(d&&this.isMultidimensionalData){var m=0;var b={};this.dataSizes=[];this.legendSizes={};this.legendSizesN=0;if(this.isNumeric2DArray(d)){var h=this.setRangeDataObject(d);for(var g=0;g<this.varIndices.length;g++){for(var f=0;f<this.smpIndices.length;f++){var c=d[this.varIndices[g]][this.smpIndices[f]];if(!isNaN(c)){var e=this.percentile(h[0],h[1],c);var a=parseInt(e/10);if(a>0){a--}this.dataSizes.push(this.sizes[a])}else{this.dataSizes.push(0)}}}this.legendSizeRange=h;this.legendSizeDecs=this.getAxisDecimals(this.getAxisIncrements(h[0],h[1],10));this.setSizeLegendIndicatorDimensions()}else{var l=0;for(var g=0;g<this.varIndices.length;g++){for(var f=0;f<this.smpIndices.length;f++){var a=d[this.varIndices[g]][this.smpIndices[f]];if(!b.hasOwnProperty(a)){var k=this.measureText(a,this.legendFont);if(k>l){l=k;this.legendSizesMax=a}b[a]=(m%this.sizes.length)+3;this.legendSizes[a]=this.sizes[b[a]];m++}this.dataSizes.push(this.sizes[b[a]])}}this.legendSizesN=m;this.setSizeLegendDimensions(this.legendSizesMax)}}else{if(this.sizeBy){var m=0;var b={};this.dataSizes=[];this.legendSizes={};this.legendSizesN=0;if(this.data.x&&this.data.x.hasOwnProperty(this.sizeBy)){this.sizeByType="x";var o=this.isGroupedData?this.grpIndices:this.smpIndices;if(this.isNumeric(this.data.x[this.sizeBy],true)){var h=this.range(this.data.x[this.sizeBy],true);for(var g=0;g<o.length;g++){var n=o[g];if(this.isGroupedData){for(var f=0;f<this.data.w.grps[n].length;f++){var c=this.data.x[this.sizeBy][this.data.w.grps[n][f]];if(!isNaN(c)){var e=this.percentile(h[0],h[1],c);var a=parseInt(e/10);if(a>0){a--}this.dataSizes.push(this.sizes[a])}else{this.dataSizes.push(0)}}}else{var c=this.data.x[this.sizeBy][n];if(!isNaN(c)){var e=this.percentile(h[0],h[1],c);var a=parseInt(e/10);if(a>0){a--}this.dataSizes.push(this.sizes[a])}else{this.dataSizes.push(0)}}}this.legendSizeRange=h;this.legendSizeDecs=this.getAxisDecimals(this.getAxisIncrements(h[0],h[1],10));this.setSizeLegendIndicatorDimensions()}else{var l=0;for(var g=0;g<o.length;g++){var n=o[g];if(this.isGroupedData){for(var f=0;f<this.data.w.grps[n].length;f++){var a=this.data.x[this.sizeBy][this.data.w.grps[n][f]];if(!b.hasOwnProperty(a)){var k=this.measureText(a,this.legendFont);if(k>l){l=k;this.legendSizesMax=a}b[a]=(m%this.sizes.length)+3;this.legendSizes[a]=this.sizes[b[a]];m++}this.dataSizes.push(this.sizes[b[a]])}}else{var a=this.isGroupedData?this.getSmpAnnotations(this.sizeBy,this.data.w.grps[g],true):this.data.x[this.sizeBy][n];if(!b.hasOwnProperty(a)){var k=this.measureText(a,this.legendFont);if(k>l){l=k;this.legendSizesMax=a}b[a]=(m%this.sizes.length)+3;this.legendSizes[a]=this.sizes[b[a]];m++}this.dataSizes.push(this.sizes[b[a]])}}this.legendSizesN=m;this.setSizeLegendDimensions()}}else{if(this.data.z&&this.data.z.hasOwnProperty(this.sizeBy)){this.sizeByType="z";if(this.isNumeric(this.data.z[this.sizeBy],false,true)){var h=this.range(this.data.z[this.sizeBy],false,true);for(var g=0;g<this.varIndices.length;g++){var n=this.varIndices[g];var c=this.data.z[this.sizeBy][n];if(!isNaN(c)){var e=this.percentile(h[0],h[1],c);var a=parseInt(e/10);if(a>0){a--}this.dataSizes.push(this.sizes[a])}else{this.dataSizes.push(0)}}this.legendSizeRange=h;this.legendSizeDecs=this.getAxisDecimals(this.getAxisIncrements(h[0],h[1],10));this.setSizeLegendIndicatorDimensions()}else{for(var g=0;g<this.varIndices.length;g++){var n=this.varIndices[g];var a=this.data.z[this.sizeBy][n];if(!b.hasOwnProperty(a)){b[a]=m%this.sizes.length;this.legendSizes[a]=this.sizes[b[a]];m++}this.dataSizes.push(this.sizes[b[a]])}this.legendSizesN=m;this.setSizeLegendDimensions()}}else{if(this.getSampleIndices(this.sizeBy)>-1){m=this.getSampleIndices(this.sizeBy);var h=this.getAxisRangeBySample(m);for(var g=0;g<this.varIndices.length;g++){var n=this.varIndices[g];var c=this.getDataAtPos(n,m);if(!isNaN(c)){var e=this.percentile(h[0],h[1],c);var a=parseInt(e/10);if(a>0){a--}this.dataSizes.push(this.sizes[a])}else{this.dataSizes.push(0)}}this.legendSizeRange=h;this.legendSizeDecs=this.getAxisDecimals(this.getAxisIncrements(h[0],h[1],10));this.setSizeLegendIndicatorDimensions()}else{if(this.sizeBy=="variable"){for(var g=0;g<this.varIndices.length;g++){var a=g%this.sizes.length;this.dataSizes.push(this.sizes[a])}this.legendSizesN=this.dataSizes.length;this.setVariableLegendDimension()}else{for(var g=0;g<this.varIndices.length;g++){this.dataSizes.push(this.scatterPointSize)}}}}}}}};this.setDataPattern=function(b){this.patternByType=false;if(b&&this.isMultidimensionalData){var h=0;var a={};this.dataPatterns=[];this.legendPatterns={};this.legendPatternsN=0;var g=0;for(var d=0;d<this.varIndices.length;d++){for(var c=0;c<this.smpIndices.length;c++){var e=b[this.varIndices[d]][this.smpIndices[c]];if(!a.hasOwnProperty(e)){var f=this.measureText(e,this.legendFont);if(f>g){g=f;this.legendPatternsMax=e}a[e]=h%this.patterns.length;this.legendPatterns[e]=this.patterns[a[e]];h++}this.dataPatterns.push(this.patterns[a[e]])}}this.legendPatternsN=h;this.setPatternLegendDimensions(this.legendPatternsMax)}else{if(this.patternBy){var h=0;var a={};this.dataPatterns=[];this.legendPatterns={};this.legendPatternsN=0;if(this.data.x&&this.data.x.hasOwnProperty(this.patternBy)){this.patternByType="x";var l=this.isGroupedData?this.grpIndices:this.smpIndices;var g=0;for(var d=0;d<l.length;d++){var k=l[d];if(this.isGroupedData&&(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData))){for(var c=0;c<this.data.w.grps[k].length;c++){var e=this.data.x[this.patternBy][this.data.w.grps[k][c]];if(!a.hasOwnProperty(e)){var f=this.measureText(e,this.legendFont);if(f>g){g=f;this.legendPatternsMax=e}a[e]=h%this.patterns.length;this.legendPatterns[e]=this.patterns[a[e]];h++}this.dataPatterns.push(this.patterns[a[e]])}}else{var e=this.isGroupedData?this.getSmpAnnotations(this.patternBy,this.data.w.grps[d],true):this.data.x[this.patternBy][k];if(!a.hasOwnProperty(e)){var f=this.measureText(e,this.legendFont);if(f>g){g=f;this.legendPatternsMax=e}a[e]=h%this.patterns.length;this.legendPatterns[e]=this.patterns[a[e]];h++}this.dataPatterns.push(this.patterns[a[e]])}}this.legendPatternsN=h;this.setPatternLegendDimensions()}else{if(this.data.z&&this.data.z.hasOwnProperty(this.patternBy)){this.patternByType="z";for(var d=0;d<this.varIndices.length;d++){var k=this.varIndices[d];var e=this.data.z[this.patternBy][k];if(!a.hasOwnProperty(e)){a[e]=h%this.patterns.length;this.legendPatterns[e]=this.patterns[a[e]];h++}this.dataPatterns.push(this.patterns[a[e]])}this.legendPatternsN=h;this.setPatternLegendDimensions()}else{if(this.patternBy=="variable"){for(var d=0;d<this.varIndices.length;d++){var e=d%this.patterns.length;this.dataPatterns.push(this.patterns[e])}this.legendPatternsN=this.dataPatterns.length;this.setVariableLegendDimension()}else{for(var d=0;d<this.varIndices.length;d++){this.dataPatterns.push(this.patterns[0])}}}}}}};this.setDataColorShapeSizePattern=function(){this.resetLegends();this.setLegendFont();if(this.isMultidimensionalData){if(this.outlineByData&&this.data.y[this.outlineByData]){this.setDataColor(this.data.y[this.outlineByData])}if(this.shapeByData&&this.data.y[this.shapeByData]){this.setDataShape(this.data.y[this.shapeByData])}if(this.sizeByData&&this.data.y[this.sizeByData]){this.setDataSize(this.data.y[this.sizeByData])}if(this.patternByData&&this.data.y[this.patternByData]){this.setDataPattern(this.data.y[this.patternByData])}}else{this.setDataColor();this.setDataShape();this.setDataSize();this.setDataPattern()}if(!this.scatterPlotMatrix&&(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2d")){this.setSampleLegendDimension()}};this.resetLegends=function(){var a=["Color","Shape","Size"];for(var c=0;c<a.length;c++){this["legend"+a[c]+"IndicatorWidth"]=0;this["legend"+a[c]+"IndicatorHeight"]=0;this["data"+a[c]+"s"]=[];this["legend"+a[c]+"s"]={};this["legend"+a[c]+"s"]=0}var b=this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:["Color","Shape","Size","Pattern","Variable","Sample"];for(var c=0;c<b.length;c++){this["legend"+b[c]+"Width"]=0;this["legend"+b[c]+"Height"]=0}};this.setLegendDimensions=function(){this.legendLayout=[];var a=this.margin;var l=this.margin;if(this.showIndicators){var f=["Color","Shape","Size"];for(var c=0;c<f.length;c++){var j=this["legend"+f[c]+"IndicatorWidth"];var d=this["legend"+f[c]+"IndicatorHeight"];if(j){if(this.indicatorsPosition=="bottom"){l+=this.margin+d}else{a+=this.margin+d}}}}var b=0;var k=0;var g=0;if(this.showLegend){var e=this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:["Color","Shape","Size","Pattern","Variable","Sample"];for(var c=0;c<e.length;c++){var j=this["legend"+e[c]+"Width"];var d=this["legend"+e[c]+"Height"];if(j>0){if(this.legendPosition=="right"){if(k+this.margin+d>this.height){a+=this.margin+j;b=j;k=d;g++;this.legendLayout[g]=[e[c]]}else{if(j>b){a+=(j-b);b=j}k+=d;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(e[c])}}else{if(b+this.margin+j>this.width){l+=this.margin+d;b=j;k=d;g++;this.legendLayout[c]=[e[c]]}else{if(d>k){l+=(d-k);k=d}b+=j;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(e[c])}}}}}this.legendWidth=a+this.margin;this.legendHeight=l+this.margin};this.getXYLegendCoords=function(o,a,q){var n,e,m,g;var k=0;var c=0;var p=-1;var f=-1;if(this.legendLayout){for(var d=0;d<this.legendLayout.length;d++){n=0;e=0;if(this.legendLayout[d]){for(var b=0;b<this.legendLayout[d].length;b++){if(this.legendLayout[d][b]==o){f=b}n+=this["legend"+this.legendLayout[d][b]+"Width"]+this.margin;e+=this["legend"+this.legendLayout[d][b]+"Height"]+this.margin;k=Math.max(k,n);c=Math.max(c,e)}if(f>-1){p=d;break}}}if(this.legendPosition=="right"){q=f==0&&this.scatterPlotMatrix?this.marginTop+this.layoutTop:f==0?this.marginTop+this.offsetY+this.top:q;m=a;g=f==0&&this.scatterPlotMatrix?(this.height-c)/2:f==0?this.marginTop+this.offsetY+this.top+((this.y-c)/2):q;a=f==this.legendLayout[p].length-1?a+k:a;q=g+this["legend"+this.legendLayout[p][f]+"Height"]+this.margin}else{a=f==0&&this.scatterPlotMatrix?this.marginLeft+this.layoutLeft:f==0?this.marginLeft+this.offsetX+this.left:a;m=f==0&&this.scatterPlotMatrix?(this.width-k)/2:f==0?this.marginLeft+this.offsetX+this.left+((this.x-k)/2)+this.margin:a+this.margin;g=q;a=m+this["legend"+this.legendLayout[p][f]+"Width"]+this.margin;q=f==this.legendLayout[p].length-1?q+c:q}}return[m,g,a,q]};this.drawScatterLegend=function(d,r){var c=this.scatterPlotMatrix?this.width-(this.marginRight+this.layoutRight):this.marginLeft+this.offsetX+this.left+this.x;var n=this.scatterPlotMatrix?this.height-(this.marginBottom+this.layoutBottom):this.marginTop+this.offsetY+this.top+this.y;if(d){c+=d}if(r){n+=r}if(this.showIndicators){var q,j;var a,p;if(!this.scatterPlotMatrix&&(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D")){c+=(this.margin*2);n+=this.get2DXAxisHeight()+this.margin;if(this.graphType=="ScatterBubble2D"&&this.zAxisShow){c+=this.getFontPt(this.axisTitleFont)+(this.margin*2)}}else{c+=(this.margin*1);n+=(this.margin*1)}var m=["Color","Shape","Size"];for(var f=0;f<m.length;f++){q=this["legend"+m[f]+"IndicatorWidth"];j=this["legend"+m[f]+"IndicatorHeight"];if(q){var b="draw"+m[f]+"Indicator";var g=this["legend"+m[f]+"Range"];var e=this["legend"+m[f]+"Decs"];if(this.indicatorsPosition=="bottom"){a=this.scatterPlotMatrix?(this.width-q)/2:this.marginLeft+this.offsetX+this.left+((this.x-q)/2);p=n;this[b](a,p,g[0],g[1],e);n+=j+this.margin}else{a=c;p=this.scatterPlotMatrix?(this.height-j)/2:this.marginTop+this.offsetY+this.top+(this.y-((this.y-q)/2));this[b](a,p,g[0],g[1],e);c+=j+this.margin}}}}if(this.showLegend){var k=this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:["Color","Shape","Size","Pattern","Variable","Sample"];for(var f=0;f<k.length;f++){q=this["legend"+k[f]+"Width"];j=this["legend"+k[f]+"Height"];if(q>0){var b="draw"+k[f]+"Legend";var o=this.getXYLegendCoords(k[f],c,n);this[b](o[0],o[1]);if(this.legendPosition=="right"){n=o[3]+this.margin}else{c=o[2]+this.margin}}}}}};CanvasXpress.prototype.initFilterUtils=function(){this.filterData=function(noGroup){var or={};var and={};var edgs={};var re=false;var that=this;var getValue=function(p,o,a){if(o.hasOwnProperty(p)){return o[p]}else{if(p.match(":::")){var arr=p.split(":::");if(a[arr[1]]){arr[1]=parseInt(arr[1]);for(var i=0;i<a[arr[1]].length;i++){var j=a[arr[1]][i];if(o.hasOwnProperty(j)){o=o[j]}else{return false}}if(o.hasOwnProperty(arr[0])){return o[arr[0]]}}}return false}};var evaluate=function(ts,op,vl,cs){if(!op){return true}if(that.filterSkipNullValues&&(ts==null||ts=="")){return true}if(op.match(/[\>\<\=]/)){return eval(parseFloat(ts)+" "+op+" "+parseFloat(vl))}else{if(op.match("null")){return op=="not null"&&ts!=null?true:op=="null"&&ts==null?true:false}else{var r=cs?new RegExp(vl):new RegExp(vl,"i");return op=="like"?r.test(ts):r.test(ts)?false:true}}return false};var addEdge=function(nd){if(!edgs[nd]){edgs[nd]=0}edgs[nd]++};if(this.graphType=="Genome"&&this.filterFeatureBy.length>0){for(var i=0;i<this.filterFeatureBy.length;i++){if(this.filterFeatureBy[i]){for(var j=0;j<this.data.tracks.length;j++){var track=this.data.tracks[j];var features=track.data;for(var k=0;k<features.length;k++){var feature=features[k];if(this.filterSkipNullKeys&&!feature.hasOwnProperty(this.filterFeatureBy[i])){continue}var v=getValue(this.filterFeatureBy[i],feature,this.featuresProperties);if(!evaluate(v,this.filterFeatureByOp[i],this.filterFeatureByValue[i],this.filterFeatureByCase[i])){feature.hide=this.filterType=="and"?true:or[j+":"+k]?false:true;and[j+":"+k]=true}else{or[j+":"+k]=true;if(this.filterType=="or"&&and[j+":"+k]){feature.hide=false}}}}}}}else{if(this.graphType=="Network"&&(this.filterNodeBy.length>0||this.filterEdgeBy.length)){for(var i=0;i<this.filterNodeBy.length;i++){if(this.filterNodeBy[i]){for(var j=0;j<this.data.nodes.length;j++){if(this.filterSkipNullKeys&&!this.data.nodes[j].hasOwnProperty(this.filterNodeBy[i])){continue}if(this.data.nodes[j].hide){continue}var v=getValue(this.filterNodeBy[i],this.data.nodes[j],this.nodesProperties);if(!evaluate(v,this.filterNodeByOp[i],this.filterNodeByValue[i],this.filterNodeByCase[i])){this.data.nodes[j].hide=this.filterType=="and"?true:or[this.data.nodes[j].id]?false:true;and[this.data.nodes[j].id]=true}else{or[this.data.nodes[j].id]=true;if(this.filterType=="or"&&and[this.data.nodes[j].id]){this.data.nodes[j].hide=false}}}}}for(var i=0;i<this.filterEdgeBy.length;i++){if(this.filterEdgeBy[i]){for(var j=0;j<this.data.edges.length;j++){var n1=this.data.nodes[this.data.nodeIndices[this.data.edges[j].id1]];var n2=this.data.nodes[this.data.nodeIndices[this.data.edges[j].id2]];var id=n1.id+":"+n2.id;if(this.filterSkipNullKeys&&!this.data.edges[j].hasOwnProperty(this.filterEdgeBy[i])){continue}var v=getValue(this.filterEdgeBy[i],this.data.edges[j],this.edgesProperties);if(!evaluate(v,this.filterEdgeByOp[i],this.filterEdgeByValue[i],this.filterEdgeByCase[i])){this.data.edges[j].hide=this.filterType=="and"?true:or[id]?false:true;and[id]=true}else{or[id]=true;if(this.filterType=="or"&&and[id]){this.data.edges[j].hide=false}}if(!this.data.edges[j].hide){addEdge(n1.id);addEdge(n2.id)}}}}if(this.filterEdgeBy.length>0){for(var i=0;i<this.data.nodes.length;i++){var nd=this.data.nodes[i];if(!edgs[nd.id]){nd.hide=true}else{nd.hide=false}}}}else{if(this.filterSmpBy.length>0){for(var i=0;i<this.filterSmpBy.length;i++){if(this.filterSmpBy[i]){re=true;if(this.isGroupedData&&!noGroup){for(var j=0;j<this.grpIndices.length;j++){var jj=this.grpIndices[j];var tr;if(this.filterSmpBy[i]=="smps"){var found=false;for(var k=0;k<this.data.w.grps[jj].length;k++){tr=this.data.y.smps[this.data.w.grps[jj][k]];if(evaluate(tr,this.filterSmpByOp[i],this.filterSmpByValue[i],this.filterSmpByCase[i])){found=true;break}}if(!found){this.hiddenGrps[jj]=this.filterType=="and"?true:or[jj]?false:true;and[jj]=true}else{or[jj]=true;if(this.filterType=="or"&&and[jj]){this.hiddenGrps[jj]=false}}}else{tr=this.data.w.factors[this.filterSmpBy[i]][jj];if(!evaluate(tr,this.filterSmpByOp[i],this.filterSmpByValue[i],this.filterSmpByCase[i])){this.hiddenGrps[jj]=this.filterType=="and"?true:or[jj]?false:true;and[jj]=true}else{or[jj]=true;if(this.filterType=="or"&&and[jj]){this.hiddenGrps[jj]=false}}}}}else{for(var j=0;j<this.smpIndices.length;j++){var jj=this.smpIndices[j];var tr=this.filterSmpBy[i]=="smps"?this.data.y.smps[jj]:this.data.x[this.filterSmpBy[i]][jj];if(!evaluate(tr,this.filterSmpByOp[i],this.filterSmpByValue[i],this.filterSmpByCase[i])){this.hiddenSmps[jj]=this.filterType=="and"?true:or[jj]?false:true;and[jj]=true}else{or[jj]=true;if(this.filterType=="or"&&and[jj]){this.hiddenSmps[jj]=false}}}}}}if(re){var arr=[];if(this.isGroupedData&&!noGroup){for(var i=0;i<this.grpIndices.length;i++){var ii=this.grpIndices[i];if(!this.hiddenGrps[ii]){arr.push(ii)}}this.grpIndices=arr}else{for(var i=0;i<this.smpIndices.length;i++){var ii=this.smpIndices[i];if(!this.hiddenSmps[ii]){arr.push(ii)}}this.smpIndices=arr}}}if(this.filterVarBy.length>0){for(var i=0;i<this.filterVarBy.length;i++){if(this.filterVarBy[i]){re=true;for(var j=0;j<this.varIndices.length;j++){var jj=this.varIndices[j];var tr=this.filterVarBy[i]=="vars"?this.data.y.vars[jj]:this.data.z[this.filterVarBy[i]][jj];if(!evaluate(tr,this.filterVarByOp[i],this.filterVarByValue[i],this.filterVarByCase[i])){this.hiddenVars[jj]=this.filterType=="and"?true:or[jj]?false:true;and[jj]=true}else{or[jj]=true;if(this.filterType=="or"&&and[jj]){this.hiddenVars[jj]=false}}}}}if(re){var arr=[];for(var i=0;i<this.varIndices.length;i++){var ii=this.varIndices[i];if(!this.hiddenVars[ii]){arr.push(ii)}}this.varIndices=arr}}}}};this.resetSmpFilters=function(idx){if(idx!=null&&this.filterSmpBy.length>0){this.filterSmpBy.splice(idx,1);this.filterSmpByOp.splice(idx,1);this.filterSmpByValue.splice(idx,1);this.filterSmpByCase.splice(idx,1);this.filteredSmpIndices.splice(idx,1)}else{this.filterSmpBy=[];this.filterSmpByOp=[];this.filterSmpByValue=[];this.filterSmpByCase=[];this.filteredSmpIndices=[]}};this.resetVarFilters=function(idx){if(idx!=null&&this.filterVarBy.length>0){this.filterVarBy.splice(idx,1);this.filterVarByOp.splice(idx,1);this.filterVarByValue.splice(idx,1);this.filterVarByCase.splice(idx,1);this.filteredVarIndices.splice(idx,1)}else{this.filterVarBy=[];this.filterVarByOp=[];this.filterVarByValue=[];this.filterVarByCase=[];this.filteredVarIndices=[]}};this.resetNodeFilters=function(idx){if(idx!=null&&this.filterNodeBy.length>0){this.filterNodeBy.splice(idx,1);this.filterNodeByOp.splice(idx,1);this.filterNodeByValue.splice(idx,1);this.filterNodeByCase.splice(idx,1)}else{this.filterNodeBy=[];this.filterNodeByOp=[];this.filterNodeByValue=[];this.filterNodeByCase=[]}};this.resetEdgeFilters=function(idx){if(idx!=null&&this.filterEdgeBy.length>0){this.filterEdgeBy.splice(idx,1);this.filterEdgeByOp.splice(idx,1);this.filterEdgeByValue.splice(idx,1);this.filterEdgeByCase.splice(idx,1)}else{this.filterEdgeBy=[];this.filterEdgeByOp=[];this.filterEdgeByValue=[];this.filterEdgeByCase=[]}};this.resetFeatureFilters=function(idx){if(idx!=null&&this.filterFeatureBy.length>0){this.filterFeatureBy.splice(idx,1);this.filterFeatureByOp.splice(idx,1);this.filterFeatureByValue.splice(idx,1);this.filterFeatureByCase.splice(idx,1)}else{this.filterFeatureBy=[];this.filterFeatureByOp=[];this.filterFeatureByValue=[];this.filterFeatureByCase=[]}};this.resetFilters=function(f,i){var fs=[];if(!f){fs=["filterSmpBy","filterVarBy","filterNodeBy","filterEdgeBy","filterFeatureBy"]}else{fs=[f]}for(var j=0;j<fs.length;j++){c=fs[j];if(c=="filterSmpBy"){this.resetSmpFilters(i)}else{if(c=="filterVarBy"){this.resetVarFilters(i)}else{if(c=="filterNodeBy"){this.resetNodeFilters(i)}else{if(c=="filterEdgeBy"){this.resetEdgeFilters(i)}else{if(c=="filterFeatureBy"){this.resetFeatureFilters(i)}}}}}}}};CanvasXpress.prototype.initClusterUtils=function(){this.setTrees=function(){if(this.showSmpDendrogram&&this.data.t&&this.data.t.smps){this.smpDendrogram={};this.smpDendrogram.data=[];this.smpDendrogram.nodes=[];this.smpDendrogram.idxs=[];this.smpDendrogram.heights=[];this.parseNewick(this.data.t.smps,"smpDendrogram")}if(this.showVarDendrogram&&this.data.t&&this.data.t.vars){this.varDendrogram={};this.varDendrogram.data=[];this.varDendrogram.nodes=[];this.varDendrogram.idxs=[];this.varDendrogram.heights=[];this.parseNewick(this.data.t.vars,"varDendrogram")}};this.parseNewick=function(b,e){var p=b.split(/,/);var v=0;var f=0;var g=0;var m=1;var l=0;var u=0;var a=0;var k=0;for(var s=0;s<p.length;s++){var q=p[s];var h=q.split(/:(?=[0-9\.]+)/);var w=h.shift().replace(/[\(\)]/g,"");var c=e=="smpDendrogram"?this.getSampleIndices(w):this.getVariableIndices(w);if(c==-1){c=parseInt(w);this[e].nodes.push(e=="smpDendrogram"?this.data.y.smps[w]:this.data.y.vars[w]);this[e].idxs.push(w)}else{this[e].nodes.push(w);this[e].idxs.push(c)}for(var r=0;r<h.length;r++){var d=h[r].replace(/[\(\)]/g,"");u=Math.max(u,d);this[e].heights.push(d)}this[e].max=u;var t=p[s].split("");f=0;for(var r=0;r<t.length;r++){if(t[r]=="("){v++;f++}if(t[r]==")"){v--;f--}}k+=f;if(g>v){this[e].data.push([m,g,f,k])}else{this[e].data.push([m,v,f,k])}g=v;a=Math.max(a,g);l+=f;m++}this[e].unit=u>0?(a*this.dendrogramSpace)/u:0;this[e].depth=a;if(l>0){alert("Dude! Malformed newick tree. There are "+l+" additional right parenthesis!")}else{if(l<0){alert("Dude! Malformed newick tree. There are "+Math.abs(l)+" additional left parenthesis!")}}if(e=="varDendrogram"){if(this.varIndicesStart<0){if(this[e].nodes.length!=this.data.y.vars.length){alert("Dude! The length of the variable nodes in the dendrogram ("+this[e].nodes.length+") is different to that one in the data ("+this.data.y.vars.length+"). This ain't gonna work!");this.showVarDendrogram=false}else{if(this[e].nodes.length!=this.varIndices.length){alert("Ooops! Cannot show dendrogram with "+this[e].nodes.length+" nodes when only "+this.varIndices.length+" variables are visible.");this.showVarDendrogram=false}else{this.varIndices=this[e].idxs}}}else{var o=this.varIndicesStart+this.varIndices.length;this.varIndices=[];for(var s=this.varIndicesStart;s<o;s++){this.varIndices.push(this[e].idxs[s])}}}else{if(this.smpIndicesStart<0){if(this[e].nodes.length!=this.data.y.smps.length){alert("Dude! The length of the sample nodes in the dendrogram ("+this[e].nodes.length+") is different to that one in the data ("+this.data.y.smps.length+"). This ain't gonna work!");this.showSmpDendrogram=false}else{if(this[e].nodes.length!=this.smpIndices.length){alert("Ooops! Cannot show dendrogram with "+this[e].nodes.length+" nodes when only "+this.smpIndices.length+" samples visible.");this.showSmpDendrogram=false}else{this.smpIndices=this[e].idxs}}}else{var o=this.smpIndicesStart+this.smpIndices.length;this.smpIndices=[];for(var s=this.smpIndicesStart;s<o;s++){this.smpIndices.push(this[e].idxs[s])}}}};this.euclidianDistance=function(b,a,h,g){var e=this.cleanArrays(b,a,h,g);b=e[0];a=e[1];var f=0;if(b.length==a.length){for(var c=0;c<b.length;c++){f+=Math.pow(b[c]-a[c],2)}f=Math.sqrt(f)}return f};this.manhattanDistance=function(b,a,h,g){var e=this.cleanArrays(b,a,h,g);b=e[0];a=e[1];var f=0;if(b.length==a.length){for(var c=0;c<b.length;c++){f+=Math.abs(b[c]-a[c])}}return f};this.maxDistance=function(b,a,h,g){var e=this.cleanArrays(b,a,h,g);b=e[0];a=e[1];var f=0;if(b.length==a.length){for(var c=0;c<b.length;c++){f=Math.max(f,Math.abs(b[c]-a[c]))}}return f};this.addVectors=function(c,b,g,f){var e=this.cleanArrays(c,b,g,f);c=e[0];b=e[1];var a=[];if(c.length==b.length){for(var d=0;d<c.length;d++){a.push(c[d]+b[d])}}return a};this.compareVectors=function(b,a){if(this.isArray(b)&&this.isArray(a)){if(b.length!=a.length){return false}for(var c=0;c<b.length;c++){if(this.isArray(b[c])&&this.isArray(a[c])){if(!this.compareArrays(b[c],a[c])){return false}}if(b[c]!==a[c]){return false}}return true}};this.vectorDotProduct=function(b,a,g,f){var d=this.cleanArrays(b,a,g,f);b=d[0];a=d[1];var e=0;if(b.length==a.length){for(var c=0;c<b.length;c++){e+=b[c]*a[c]}}return e};this.multiplyVectorByValue=function(a,d,e,c){a=this.cleanArray(a,e,c);for(var b=0;b<a.length;b++){a[b]*=d}return a};this.getCentroid=function(d,g,f,a){var h=[];if(g.length==a.length){var e=d+f;for(var b=0;b<g.length;b++){h.push((d*g[b]+f*a[b])/e)}}return h};this.createClusterNode=function(i,b,e,f,h,a){var g={id:i,left:b,right:e,dist:f,centroid:h};if(a){g.mid=a}if(b==null&&e==null){g.size=1;g.depth=0}else{g.size=b.size+e.size;g.depth=1+Math.max(b.depth,e.depth)}return g};this.createRandomVectors=function(d,g){var c=g.length;if(d>c){return null}var l=[];var f=[];var a={};var m=0;var o=0;var j,b;while(o<d){if(m==c){return null}var h=Math.floor(Math.random()*c);if(h in a){continue}a[h]=1;m++;j=g[h];b=true;for(var e=0;e<o;e++){if(this.compareVectors(j,l[e])){b=false;break}}if(b){l[o]=j;f[o]=h;o++}}return{vectors:l,indices:f}};this.imputeDatum=function(a){var d=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];d.push(this.data.y.data[c][a])}}else{for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];d.push(this.data.y.data[a][c])}}return this[this.imputeMethod](d)};this.getIdsForClustering=function(){var e=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];var a=this.getSampleIndices(c);e[b]=a==-1?c:this.data.y.smps[c]}}else{for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];var a=this.getVariableIndices(c);e[b]=a==-1?c:this.data.y.smps[c]}}return e};this.getDataForClustering=function(){var h=[];var a=[];if(this.clusterAxis=="samples"){for(var c=0;c<this.smpIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[b]){a[b]=this.imputeDatum(f)}g=a[b]}h[b][c]=g}}}else{for(var c=0;c<this.varIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[c]){a[c]=this.imputeDatum(e)}g=a[c]}h[c][b]=g}}}if(this.centerData){h=this.normalize(h)}return h};this.cluster=function(){var u;var n=this.getDataForClustering();var f=this.getIdsForClustering();var e=[];var c=[];var o=[];var t=[];for(var m=0;m<n.length;m++){e[m]=[]}for(var m=0;m<n.length;m++){e[m][m]=Number.POSITIVE_INFINITY;for(var h=m+1;h<n.length;h++){e[m][h]=this[this.distance+"Distance"](n[m],n[h]);e[h][m]=e[m][h]}}for(var m=0;m<n.length;m++){c[m]=0;for(var h=0;h<n.length;h++){if(e[m][c[m]]>e[m][h]){c[m]=h}}}for(var m=0;m<n.length;m++){t[m]=[];t[m][0]=this.createClusterNode(f[m],null,null,0,n[m]);o[m]=1}for(var a=0;a<n.length-1;a++){var k=0;for(var m=0;m<n.length;m++){if(e[m][c[m]]<e[k][c[k]]){k=m}}var g=c[k];var b=t[k][0];var q=t[g][0];var s=this.getCentroid(b.size,b.centroid,q.size,q.centroid);var r=this.createClusterNode(-1,b,q,e[k][g],s);t[k].splice(0,0,r);o[k]+=o[g];for(var h=0;h<n.length;h++){if(this.linkage=="single"){if(e[k][h]>e[g][h]){e[h][k]=e[k][h]=e[g][h]}}else{if(this.linkage=="complete"){if(e[k][h]<e[g][h]){e[h][k]=e[k][h]=e[g][h]}}else{if(this.linkage=="average"){e[h][k]=e[k][h]=(o[k]*e[k][h]+o[g]*e[g][h])/(o[k]+o[h])}}}}e[k][k]=Number.POSITIVE_INFINITY;for(var m=0;m<n.length;m++){e[m][g]=e[g][m]=Number.POSITIVE_INFINITY}for(var h=0;h<n.length;h++){if(c[h]==g){c[h]=k}if(e[k][h]<e[k][c[k]]){c[k]=h}}u=r}return this.writeNewick(u)};this.isLeafNode=function(a){if(a.left==null&&a.right==null){return true}else{return false}};this.writeNewick=function(b,h){var g="";var f="";if(this.isLeafNode(b)){if(isNaN(b.id)){g=this.clusterAxis=="variables"?this.getVariableIndices(b.id):this.getSampleIndices(b.id)}else{g=b.id}}else{var a;var c=this.writeNewick(b.left,h);var e=this.writeNewick(b.right,h);if(b.mid){for(var d=0;d<b.mid.length;d++){if(h&&b.mid[d].dist){f+=","+b.mid[d].id+":"+b.mid[d].dist}else{f+=","+b.mid[d].id}f+=b.mid[d].id}}g="("+c+f+","+e+")"}if(h&&b.dist){g+=":"+b.dist}return g};this.kmeans=function(){var k;var n=this.getDataForClustering();var b=this.getIdsForClustering();var m=[];var o=[];var q=true;var p=0;var g=null;var u=this.createRandomVectors(this.kmeansClusters,n);if(u==null){return null}else{g=u.vectors}while(q){for(var h=0;h<this.kmeansClusters;h++){o[h]=0}for(var h=0;h<n.length;h++){var r=n[h];var f=Number.MAX_VALUE;var c;for(var e=0;e<this.kmeansClusters;e++){var a=this.euclidianDistance(g[e],r);if(a<f){f=a;c=e}}o[c]++;m[h]=c}var s=[];for(var h=0;h<this.kmeansClusters;h++){s[h]=null}for(var h=0;h<n.length;h++){if(s[m[h]]==null){s[m[h]]=n[h]}else{s[m[h]]=this.addVectors(s[m[h]],n[h])}}for(var h=0;h<this.kmeansClusters;h++){s[h]=this.multiplyVectorByValue(s[h],1/o[h])}q=false;for(var h=0;h<this.kmeansClusters;h++){if(!this.compareVectors(s[h],g[h])){q=true;break}}g=s;p++;if(p>this.maxIterations){q=false}}for(var h=0;h<m.length;h++){m[h]="K-"+(m[h]+1)}return m}};CanvasXpress.prototype.initSortUtils=function(){this.sortNetworkIndices=function(h){var g=this.data[this.networkShowDataTable];var c=[h]?h:this.networkShowDataTable=="nodes"?"id":"id1";var b=[];var f=[];for(var e=0;e<g.length;e++){b.push(e);f.push(g[e][c]?g[e][c]:null)}if(this.isNumeric(f)){var a=Number.MAX_VALUE*-1;b.sort(function(j,i){return(f[j]||a)-(f[i]||a)})}else{b.sort(function(j,i){return f[j]>f[i]?1:f[j]<f[i]?-1:0})}var d=[];for(var e=0;e<g.length;e++){d.push(g[b[e]])}if(this.sortDir=="ascending"){d.reverse()}this.data[this.networkShowDataTable]=d;if(this.networkShowDataTable=="nodes"){this.setNodeIndices()}this.draw()};this.sortIndices=function(g,b,j,a,l,h,m){var f=this;this.tmpAsciiArray=[];this.tmpAsciiArray1=[];this.tmpAsciiArray2=[];this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.tmpAsciiArrayAscii2=false;if(j){j=this.toArray(j)}if(a){a=this.toArray(a)}if(l){l=this.toArray(l)}if(!b){b=this.sortDir}if(j&&g=="vars"){if(j.length==1&&this.data.z&&this.data.z[j[0]]){this.tmpAsciiArray=this.data.z[j[0]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray)}else{if(j.length==2&&this.data.z&&this.data.z[j[0]]&&this.data.z[j[1]]){this.tmpAsciiArray=this.data.z[j[0]];this.tmpAsciiArray1=this.data.z[j[1]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1)}else{if(j.length==3&&this.data.z&&this.data.z[j[0]]&&this.data.z[j[1]]&&this.data.z[j[2]]){this.tmpAsciiArray=this.data.z[j[0]];this.tmpAsciiArray1=this.data.z[j[1]];this.tmpAsciiArray2=this.data.z[j[2]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1);this.tmpAsciiArrayAscii2=this.isAsciiArray(this.tmpAsciiArray2)}}}this.smpSort=-1;this.varSort=j}else{if(j&&g=="smps"){if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(g,b,j,a,l,h,m);this.isGroupedData=true}if(j.length==1&&this.data.x&&this.data.x[j[0]]){this.tmpAsciiArray=this.isGroupedData?this.data.w.factors[j[0]]:this.data.x[j[0]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray)}else{if(j.length==2&&this.data.x&&this.data.x[j[0]]&&this.data.x[j[1]]){this.tmpAsciiArray=this.isGroupedData?this.data.w.factors[j[0]]:this.data.x[j[0]];this.tmpAsciiArray1=this.isGroupedData?this.data.w.factors[j[1]]:this.data.x[j[1]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1)}else{if(j.length==3&&this.data.x&&this.data.x[j[0]]&&this.data.x[j[1]]&&this.data.x[j[2]]){this.tmpAsciiArray=this.isGroupedData?this.data.w.factors[j[0]]:this.data.x[j[0]];this.tmpAsciiArray1=this.isGroupedData?this.data.w.factors[j[1]]:this.data.x[j[1]];this.tmpAsciiArray2=this.isGroupedData?this.data.w.factors[j[2]]:this.data.x[j[2]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1);this.tmpAsciiArrayAscii2=this.isAsciiArray(this.tmpAsciiArray2)}}}this.varSort=-1;this.smpSort=j}else{if(h&&m){var e=a?parseInt(this.getVariableIndices(a[0])):parseInt(this.getSampleIndices(l[0]));this.tmpAsciiArray=this.data.y[h][e];this.tmpAsciiArrayAscii=false;this.smpSort=[e]}else{if(a){var c=[];for(var e=0;e<this.varIndices.length;e++){c.push(e)}if(a.length==1){this.tmpAsciiArray=this.getDataForSmpGrpAtIndex(a[0]-1,c,h);this.tmpAsciiArrayAscii=false;this.smpSort=[a[0]-1]}else{if(a.length==2){this.tmpAsciiArray=this.getDataForSmpGrpAtIndex(a[0]-1,c,h);this.tmpAsciiArray1=this.getDataForSmpGrpAtIndex(a[1]-1,c,h);this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.smpSort=[a[0]-1,a[1]-1]}else{if(a.length==3){this.tmpAsciiArray=this.getDataForSmpGrpAtIndex(a[0]-1,c,h);this.tmpAsciiArray1=this.getDataForSmpGrpAtIndex(a[1]-1,c,h);this.tmpAsciiArray2=this.getDataForSmpGrpAtIndex(a[2]-1,c,h);this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.tmpAsciiArrayAscii2=false;this.smpSort=[a[0]-1,a[1]-1,a[2]-1]}}}}else{if(l){if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(g,b,j,a,l,h,m);this.isGroupedData=true}var d=this.isGroupedData&&this.summaryType=="iqr"?this.data.w.median:this.isGroupedData?this.data.w[this.summaryType]:h?this.data.y[h]:this.data.y.data;if(l.length==1){this.tmpAsciiArray=d[l[0]-1];this.tmpAsciiArrayAscii=false;this.smpSort=[l[0]-1]}else{if(l.length==2){this.tmpAsciiArray=d[l[0]-1];this.tmpAsciiArray1=d[l[1]-1];this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.smpSort=[l[0]-1,l[1]-1]}else{if(a.length==3){this.tmpAsciiArray=d[l[0]-1];this.tmpAsciiArray1=d[l[1]-1];this.tmpAsciiArray2=d[l[2]-1];this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.tmpAsciiArrayAscii2=false;this.smpSort=[l[0]-1,l[1]-1,l[2]-1]}}}}else{if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(g,b,j,a,l,h,m);this.isGroupedData=true}this.tmpAsciiArray=this.isGroupedData?this.data.w.smps:g=="vars"?this.data.y.vars:this.data.y.smps;this.tmpAsciiArrayAscii=true;if(g=="vars"){this.varSort=false}else{this.smpSort=false}}}}}}var k=this.isGroupedData?this.grpIndices:g=="vars"?this.varIndices:this.smpIndices;if(this.tmpAsciiArrayAscii){k.sort(function(n,i){return f.sortAsciibetically(n,i)})}else{k.sort(function(n,i){return f.sortNumerically(n,i)})}if(b!="ascending"){k.reverse()}this.tmpAsciiArray=[];this.tmpAsciiArray1=[];this.tmpAsciiArray2=[];this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.tmpAsciiArrayAscii2=false};this.isAsciiArray=function(a){for(var b=0;b<a.length;b++){if(a[b]!=null&&isNaN(a[b])){return true}}return false};this.sortAsciibetically=function(d,c){var e=this;if(this.tmpAsciiArray[d]==this.tmpAsciiArray[c]&&this.tmpAsciiArray1.length>0){if(this.tmpAsciiArrayAscii1){return e.sortAsciibetically1(d,c)}else{return e.sortNumerically1(d,c)}}else{return((this.tmpAsciiArray[d]>this.tmpAsciiArray[c])?1:(this.tmpAsciiArray[d]<this.tmpAsciiArray[c])?-1:0)}};this.sortAsciibetically1=function(d,c){var e=this;if(this.tmpAsciiArray1[d]==this.tmpAsciiArray1[c]&&this.tmpAsciiArray2.length>0){if(this.tmpAsciiArrayAscii2){return e.sortAsciibetically2(d,c)}else{return e.sortNumerically2(d,c)}}else{return((this.tmpAsciiArray1[d]>this.tmpAsciiArray1[c])?1:(this.tmpAsciiArray1[d]<this.tmpAsciiArray1[c])?-1:0)}};this.sortAsciibetically2=function(d,c){return((this.tmpAsciiArray2[d]>this.tmpAsciiArray2[c])?1:(this.tmpAsciiArray2[d]<this.tmpAsciiArray2[c])?-1:0)};this.sortNumerically=function(e,d){var f=this;var c=Number.MAX_VALUE*-1;if((this.tmpAsciiArray[e]||c)-(this.tmpAsciiArray[d]||c)==0&&this.tmpAsciiArray1.length>0){if(this.tmpAsciiArrayAscii1){return f.sortAsciibetically1(e,d)}else{return f.sortNumerically1(e,d)}}else{return(this.tmpAsciiArray[e]||c)-(this.tmpAsciiArray[d]||c)}};this.sortNumerically1=function(e,d){var f=this;var c=Number.MAX_VALUE*-1;if((this.tmpAsciiArray1[e]||c)-(this.tmpAsciiArray1[d]||c)==0&&this.tmpAsciiArray2.length>0){if(this.tmpAsciiArrayAscii2){return f.sortAsciibetically2(e,d)}else{return f.sortNumerically2(e,d)}}else{return(this.tmpAsciiArray1[e]||c)-(this.tmpAsciiArray1[d]||c)}};this.sortNumerically2=function(e,d){var c=Number.MAX_VALUE*-1;return(this.tmpAsciiArray2[e]||c)-(this.tmpAsciiArray2[d]||c)};this.sortArray=function(a,b){var d=[];if(a.length!=b.length){return a}for(var c=0;c<a.length;c++){if(a[b[c]]){d[c]=a[b[c]]}else{return a}}return d};this.radixSort=function(n){var h=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];var e=new Int32Array(n.length);var f=[].concat(h);var g=[].concat(h);var j=[].concat(h);var l=[].concat(h);var a=0;var i;var b=0;var k;var c=0;var m;var d=0;var o;var p;for(p=0;p<n.length;p++){i=n[p]&255;k=(n[p]>>8)&255;m=(n[p]>>16)&255;o=(n[p]>>24)&255^128;f[i]++;g[k]++;j[m]++;l[o]++}for(p=0;p<256;p++){i=a+f[p];k=b+g[p];m=c+j[p];o=d+l[p];f[p]=a;g[p]=b;j[p]=c;l[p]=d;a=i;b=k;c=m;d=o}for(p=0;p<n.length;p++){i=n[p]&255;e[f[i]]=n[p];f[i]++}for(p=0;p<n.length;p++){k=(e[p]>>8)&255;n[g[k]]=e[p];g[k]++}for(p=0;p<n.length;p++){m=(n[p]>>16)&255;e[j[m]]=n[p];j[m]++}for(p=0;p<n.length;p++){o=(e[p]>>24)&255^128;n[l[o]]=e[p];l[o]++}return n}};CanvasXpress.prototype.initMathUtils=function(){this.degreesToArcLength=function(b,a){return b*a};this.radiansToArcLength=function(a,b){return(a*Math.PI*b)/180};this.arcLengthToDegrees=function(b,a){return(a*180)/(b*Math.PI)};this.arcLengthToRadians=function(b,a){return a/b};this.percentile=function(d,a,e){var b=a-d;if(b==0){return 50}var c=e-d;return c*100/b};this.rank=function(a){var c=[];for(var b=0;b<a.length;b++){c.push(b)}c.sort(function(e,d){return a[e]-a[d]});return c};this.min=function(a,e,d){if(this.isArray(a)){a=this.cleanArray(a,e,d);var c=Number.MAX_VALUE;for(var b=0;b<a.length;b++){c=Math.min(c,a[b])}return c}else{return this.Min(a,e)}};this.max=function(b,e,d){if(this.isArray(b)){b=this.cleanArray(b,e,d);var a=Number.MIN_VALUE;for(var c=0;c<b.length;c++){a=Math.max(a,b[c])}return a}else{return this.Max(b,e)}};this.sum=function(a,f,e,d){a=this.cleanArray(a,f,e);var c=0;for(var b=0;b<a.length;b++){if(d){if(a[b]>0){c+=a[b]}}else{c+=a[b]}}return c};this.mean=function(a,f,d){a=this.cleanArray(a,f,d);var b=0;var e=0;for(var c=0;c<a.length;c++){if(!isNaN(a[c])){b+=a[c];e++}}if(e>0){b/=e}return b};this.range=function(b,f,e){b=this.cleanArray(b,f,e);var d=Number.MAX_VALUE;var a=Number.MAX_VALUE*-1;for(var c=0;c<b.length;c++){d=Math.min(b[c],d);a=Math.max(b[c],a)}return d==a&&d==0?[0,0.1]:d==a?[d,a*2]:[d,a];return[d,a]};this.median=function(a,g,e){a=this.cleanArray(a,g,e);var d=[];var c=[];var f=0;d[0]=Number.NaN;d[1]=Number.NaN;for(var b=0;b<a.length;b++){c.push(a[b]);f++}if(f>0){d[1]=f;c.sort(function(i,h){return i-h});if(f%2){d[0]=c[parseInt(f/2)]}else{d[0]=(c[parseInt((f-1)/2)]+c[f/2])/2}}return d};this.random=function(){if(this.pseudoRandom){this.randomSeed=(this.randomSeed*9301+49297)%233280;return this.randomSeed/233280}else{return Math.random()}};this.meanStandardDeviationN=function(a,h,f){a=this.cleanArray(a,h,f);var e=[];var c=0;var b=0;var g=0;for(var d=0;d<a.length;d++){b+=a[d];c+=a[d]*a[d];g++}if(g>0){b/=g;c=Math.sqrt(c/g-b*b);e.push(b);e.push(c);e.push(g)}else{e.push("");e.push("");e.push("")}return e};this.quantiles=function(k,c,r){k=this.cleanArray(k,c,r);var m=[];var g=[];var d=k.length;if(d>2){var o=Math.floor(d*0.25);var j=Math.floor(d*0.5);var b=Math.floor(d*0.75);k.sort(function(n,i){return n-i});var a;var q;var p;if(d%2){q=k[j]}else{q=this.mean([k[j-1],k[j]])}if((d/2)%2){a=k[o];p=k[b]}else{a=this.mean([k[o-1],k[o]]);p=this.mean([k[b-1],k[b]])}var l=(p-a)*1.5;var f;var e;for(var h=0;h<=o;h++){if(k[h]<a-l){g.push(k[h])}else{f=k[h];break}}for(var h=d-1;h>=b;h--){if(k[h]>p+l){g.push(k[h])}else{e=k[h];break}}m.push(a);m.push(q);m.push(p);m.push(f);m.push(e);m.push(g);m.push(d)}else{if(d>1){m.push(k[0]);m.push(k[1]);m.push(k[1]);m.push(k[0]);m.push(k[1]);m.push(g);m.push(d)}else{if(d>0){m.push(k[0]);m.push(k[0]);m.push(k[0]);m.push(k[0]);m.push(k[0]);m.push(g);m.push(d)}else{m.push(NaN);m.push(NaN);m.push(NaN);m.push(NaN);m.push(NaN);m.push(NaN)}}}return m};this.quants=function(b,e,c){b=this.cleanArray(b,e,c);b=b.slice().sort(function(g,f){return g-f});var d=b.length-1;var a=[0.25,0.5,0.75];return a.map(function(k){if(k===0){return b[0]}else{if(k===1){return b[d]}else{var g=1+k*d;var j=Math.floor(g);var i=g-j;var f=b[j-1];return i===0?f:f+i*(b[j]-f)}}})};this.iqr=function(a,d,c){var b=this.quants(a,d,c);return b[2]-b[0]};this.variance=function(a,h,f){a=this.cleanArray(a,h,f);var g=a.length;if(g<1){return NaN}if(g===1){return 0}var b=this.mean(a);var d=-1;var e=0;while(++d<g){var c=a[d]-b;e+=c*c}return e/(g-1)};this.covariance=function(f,e,a,k){var d=this.cleanArrays(f,e,a,k);f=d[0];e=d[1];var j=0;var b=0;var h=this.mean(f);var g=this.mean(e);for(var c=0;c<f.length;c++){j+=f[c]*e[c];b++}if(b>0){j/=b;return j-(h*g)}return j};this.correlation=function(g,f,b,o){var e=this.cleanArrays(g,f,b,o);g=e[0];f=e[1];var c=0;var l=0;var j=0;var a=0;var h=0;var k=this.covariance(g,f);var m=0;for(var d=0;d<g.length;d++){l+=g[d];j+=f[d];a+=g[d]*g[d];h+=f[d]*f[d];c++}if(c>0){m=(c*c)*k/Math.sqrt(((c*a)-(l*l))*((c*h)-(j*j)))}return m};this.regression=function(j,h,b,r){var g=this.cleanArrays(j,h,b,r);j=g[0];h=g[1];var c=0;var o=0;var l=0;var q=0;var a=0;var k=0;var m=this.covariance(j,h);var p=0;var f=0;var d=0;for(var e=0;e<j.length;e++){if(!isNaN(j[e])&&!isNaN(h[e])){o+=j[e];l+=h[e];q+=j[e]*h[e];a+=j[e]*j[e];k+=h[e]*h[e];c++}}if(c>2){f=(c*q-o*l)/(c*a-o*o);d=(l-f*o)/c;p=(c*c)*m/Math.sqrt(((c*a)-(o*o))*((c*k)-(l*l)))}return[f,d,p]};this.slope=function(b,d,a,c){return d!=c?(a-b)/(c-d):0};this.intercept=function(a,c,b){return c-(a*b)};this.slopeIntercept=function(b,e,a,d){var c=this.slope(b,e,a,d);return[c,this.intercept(b,e,c)]};this.normalize=function(e){for(var c=0;c<e.length;c++){var a=this.meanStandardDeviationN(e[c]);for(var b=0;b<e[c].length;b++){e[c][b]=(e[c][b]-a[0])/a[1]}}return e};this.epanechnikovKernel=function(a){return function(b){return Math.abs(b/=a)<=1?0.75*(1-b*b)/a:0}};this.uniformKernel=function(a){return function(b){if(b/a<=1&&b/a>=-1){return 0.5}return 0}};this.triangularKernel=function(a){return function(b){if(b/a<=1&&b/a>=-1){return 1-Math.abs(b/a)}return 0}};this.quarticKernel=function(a){return function(b){if(b/a<=1&&b/a>=-1){var c=(1-b*b)/a;return(15/16)*c*c}return 0}};this.triweightKernel=function(a){return function(b){if(b/a<=1&&b/a>=-1){var c=(1-b*b)/a;return(35/32)*c*c*c}return 0}};this.gaussianKernel=function(a){return function(b){return 1/Math.sqrt(2*Math.PI)*Math.exp(-0.5*b*b/a)}};this.cosineKernel=function(a){return function(b){if(b/a<=1&&b>=-1/a){return Math.PI/4*Math.cos((Math.PI/2*b)/a)}return 0}};this.getBandwidthEstimate=function(e,a){var b=Math.sqrt(this.variance(e));var f=this.iqr(e)/1.34;var d=Math.pow(e.length,-0.2);var c=Math.min(b,f);return !a?1.06*c*d:0.9*c*d};this.kernelDensityEstimator=function(d,b){var c=function(e){return null!=e&&!isNaN(e)};var a=function(j,l){var k,g=j.length,h=0,m=-1,f=0;for(;++m<g;){c(k=l.call(j,j[m],m))&&(h+=(k-h)/++f)}return f?h:void 0};return function(e){return b.map(function(f){return[f,a(e,function(g){return d(f-g)})]})}};this.kde=function(d,b,f,h,e){var g=f[0];var c=f[1];var i=[];for(var j=g;j<=c;j+=h){i.push(j)}if(!b){b=this.getBandwidthEstimate(e)}var a=this.kernelDensityEstimator(this[d](b),i);return a(e)}};CanvasXpress.prototype.initLayout=function(){this.isValidLayout=function(){var a=this.layout.split(/X/i);if(this.adjustAspectRatio&&!this.plotByVariable){if(a.length==2){this.layoutRows=a[0];this.layoutCols=a[1]}else{this.layoutRows=1;this.layoutCols=1;this.layoutValid=false}if(!this.graphType.match(/Scatter/)&&this.layoutComb&&this.data.l&&(this.data.l.vars||this.data.l.smps)&&this.data.l.weight&&this.data.l.type){this.data.l.comp=[];if(this.data.l.vars&&this.data.l.smps){var f=0;for(var d=0;d<this.data.l.smps.length;d++){for(var b=0;b<this.data.l.vars.length;b++){this.data.l.comp[f]=[this.getVariableIndices(this.data.l.vars[b]),this.getSampleIndices(this.data.l.smps[d])];f++}}this.layoutRows=this.data.l.smps.length;this.layoutCols=this.data.l.vars.length}else{if(this.isDOE){this.layoutRows=a[0];this.layoutCols=a[1]}else{if(this.data.l.vars){for(var d=0;d<this.data.l.vars.length;d++){this.data.l.comp[d]=this.getVariableIndices(this.data.l.vars[d])}}else{for(var d=0;d<this.data.l.smps.length;d++){this.data.l.comp[d]=this.getSampleIndices(this.data.l.smps[d])}}if(this.graphType!="Pie"){if(this.graphOrientation=="vertical"){this.layoutRows=this.data.l.comp.length}else{this.layoutCols=this.data.l.comp.length}}}}this.layoutValid=true;this.layoutAdjust=true}else{if(this.layoutComb&&this.data.l&&this.data.l.smps&&this.data.l.weight&&this.data.l.type){this.data.l.comp=[];var e=this.getVariableIndices(this.data.y.vars);for(var d=0;d<this.data.l.type.length;d++){this.data.l.comp[d]=e}this.layoutValid=true}else{if(this.data.l&&this.data.l.comp){if(this.data.l.comp.length<=(this.layoutRows*this.layoutCols)){this.layoutValid=true}else{this.layoutValid=false}}else{this.layoutValid=false}}}}else{this.layoutRows=1;this.layoutCols=1;this.layoutValid=false}};this.setLayout=function(a){};this.addLayoutResizer=function(b){var a=0;if(this.resizerType&&this.resizerPosition==b){a+=this.resizerWidth+(this.margin*2);if(this.resizerType=="samples"){a+=14+this.margin}}return a};this.getLayoutResizerDimensions=function(){if(this.resizerType){var u,j,e,d;var f=this.data.l.comp.length-1;var k=this.resizerWidth;var z=this.resizerWidth;var B=this.marginTop+this.layoutTop;var c=this.marginRight+this.layoutRight;var q=this.marginBottom+this.layoutBottom;var g=this.marginLeft+this.layoutLeft;var A=this.getAxesVals(0);var s=0;var m=0;switch(this.resizerPosition){case"right":u="xAxis";j="y";e="v";d="r";B+=this["subGraphTop"+0];g=this.resizerType=="samples"?this.width-((this.margin*2)+this.resizerWidth+14):this.width-(this.margin+this.resizerWidth);k=this.height-(B+q+this["subGraphBottom"+f]);break;case"left":u="xAxis";j="y";e="v";d="l";B+=this["subGraphTop"+0];g=this.resizerType=="samples"&&this.graphOrientation=="horizontal"?(this.margin*2):this.margin;k=this.height-(B+q+this["subGraphBottom"+f]);break;case"top":u="xAxis";j="x";e="h";d="t";B=this.resizerType=="samples"?(this.margin*2)+14:this.margin;g+=this["subGraphLeft"+0];z=this.width-(g+c+this["subGraphRight"+f]);m+=this.resizerWidth;break;case"bottom":u="xAxis";j="x";e="h";d="b";B=this.resizerType=="samples"&&this.graphOrientation=="vertical"?this.height-((this.margin*2)+this.resizerWidth+14):this.width-(this.margin+this.resizerWidth);g+=this["subGraphLeft"+0];z=this.width-(g+c+this["subGraphRight"+f]);m+=this.resizerWidth;break}if(e=="v"){return([u,g+s,g+s+z,B+m,B+m+k,j,e,d,A,g+14,B,z,k])}else{return([u,g+s,g+s+z,B+m,B+m+k,j,e,d,A,g,B,z,k])}}};this.drawLayoutResizer=function(){if(this.resizerType){var a=this.getLayoutResizerDimensions();this.showAxesResizer(a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],"",0,0,0);this.drawAxesResizerBackgroundData(a[9],a[10],a[11],a[12]);this.drawAxesResizerMasks()}};this.getLayoutMaxLegend=function(){if(this.data.l.vars){var a=0;if(this.data.l.comp){for(var b=0;b<this.data.l.comp.length;b++){a=Math.max(a,this.data.l.comp[b].length)}}return a}else{return this.varIndices.length}};this.setLayoutLeft=function(){var a=0;if(this.isDOE){return a}else{if(this.graphOrientation!="vertical"&&this.segregateSamplesBy&&this.segregateVariablesBy){this.set1DVarSmpLabelFont();a=this.fontSize+(this.margin*4)+this.measureText(this.maxSmpNameStr,this.smpLabelFont)+this.getSmpOverlaysLength()}else{if(this.graphOrientation!="vertical"&&this.segregateVariablesBy){this.set1DVarSmpLabelFont();a=(this.margin*2)+this.measureText(this.maxSmpNameStr,this.smpLabelFont)+this.getSmpOverlaysLength()}else{if((this.segregateSamplesBy||this.segregateVariablesBy)&&this.graphOrientation=="vertical"){a=this.fontSize+(this.margin*2)}else{if(this.graphType=="Candlestick"&&this.graphOrientation!="vertical"){this.setTimeAxis();this.set1DVarSmpLabelFont();a=this.getSampleLabelLength()+this.getSmpOverlaysLength()}else{if(this.graphType=="Pie"){a=(this.margin*2)+this.measureText("XX",this.smpLabelFont)}}}}}}return a+this.addLayoutResizer("left")};this.setLayoutRight=function(){var a=0;if(this.isDOE){return a}else{if(this.graphType=="Pie"&&this.showLegend&&this.legendPosition=="right"){var b=this.getPieLegendDimensions();a=b[0]}else{if(this.graphType.match(/Scatter/)&&(this.showLegend||this.showIndicators)){if(this.xAxis&&this.yAxis){this.setDataColorShapeSizePattern()}this.setLegendDimensions();a=this.legendWidth}}}return a+this.addLayoutResizer("right")};this.setLayoutTop=function(){var a=0;if(this.isDOE){return a}else{if(this.title){a+=this.titleHeight+this.margin;if(this.subtitle){a+=this.subtitleHeight+this.margin}}}if(((this.segregateSamplesBy||this.segregateVariablesBy)&&this.graphOrientation!="vertical")||(this.segregateSamplesBy&&this.segregateVariablesBy)||(this.graphType=="Pie")){a+=this.fontSize+(this.margin*2)}return a+this.addLayoutResizer("top")};this.setLayoutBottom=function(){var a=0;if(this.isDOE){return a}else{if(this.graphType=="Pie"&&this.showLegend&&this.legendPosition=="bottom"){var c=this.getPieLegendDimensions();a=c[1]}else{if(this.segregateSamplesBy&&this.segregateVariablesBy){a=this.getLegendHeight()}else{if(this.segregateVariablesBy&&this.graphOrientation=="vertical"){this.set1DVarSmpLabelFont();a=(this.margin*2)+this.measureText(this.maxSmpNameStr,this.smpLabelFont)+this.getSmpOverlaysLength()}else{if(this.graphType=="Candlestick"&&this.graphOrientation=="vertical"){this.setTimeAxis();this.set1DVarSmpLabelFont();a=this.getSampleLabelLength()+this.getSmpOverlaysLength()}else{if(this.graphType.match(/Scatter/)&&(this.showLegend||this.showIndicators)){if(this.xAxis&&this.yAxis){this.setDataColorShapeSizePattern()}this.setLegendDimensions();a=this.legendHeight}}}}}}return a+this.addLayoutResizer("bottom")};this.drawLayoutSampleOverlays=function(b){var a=this.smpIndices;this.smpIndices=b;this.set1DVarSmpLabelFont();this.smpIndices=a;this.showSampleNames=true;this.showOverlays=true;this.draw1DYLayout()};this.drawLayoutVariableLegend=function(){this.showLegend=true;if(this.graphType=="Pie"){this.drawPieLegend()}else{this.draw1DLegend()}this.showLegend=false};this.setLayoutDimensions=function(){this.offsetX=0;this.offsetY=0;this.layoutLeft=this.setLayoutLeft();this.layoutRight=this.setLayoutRight();this.layoutTop=this.setLayoutTop();this.layoutBottom=this.setLayoutBottom()};this.drawLabelsLayout=function(){var q=0;var p=0;var o=0;var f=0;var k=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var d=this.height-(this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom);if(this.resizerType){if(this.resizerPosition=="top"){p=this.resizerType=="samples"?(this.margin*2)+this.resizerWidth+14:this.margin+this.resizerWidth;f=p}else{if(this.resizerPosition=="left"){q=this.resizerType=="samples"?(this.margin*2)+this.resizerWidth+14:this.margin+this.resizerWidth;o=q}}}if(this.segregateSamplesBy&&this.segregateVariablesBy){p=this.marginTop+this.layoutTop-this.margin;q=this.marginLeft+this.layoutLeft;for(var s=0;s<this.data.l.vars.length;s++){var l=s*this.data.l.smps.length;var r=k*this["subGraphWeight"+l][0];q+=(r/2);this.drawText(this.data.l.name[l][0],q,p,this.font,this.foreground,"center","middle");q+=(r/2)}if(this.graphOrientation=="vertical"){p-=(this.margin*6)}q=o+this.fontSize+(this.margin*4);for(var l=0;l<this.data.l.smps.length;l++){var m=d*this["subGraphWeight"+l][1];p+=(m/2);this.drawText(this.data.l.name[l][1],q,p,this.font,this.foreground,"center","middle",-Math.PI/2);p+=(m/2)}}else{if((this.segregateSamplesBy||this.segregateVariablesBy)&&this.graphOrientation=="vertical"&&this.data.l.name){q+=this.fontSize+(this.margin*4);p+=this.marginTop+this.layoutTop;if(this.segregateSamplesBy){p-=(this.margin*8)}for(var l=0;l<this.data.l.name.length;l++){var m=d*this["subGraphWeight"+l];p+=(m/2);this.drawText(this.data.l.name[l],q,p,this.font,this.foreground,"center","middle",-Math.PI/2);p+=(m/2)}}else{if((this.segregateSamplesBy||this.segregateVariablesBy)&&this.graphOrientation=="horizontal"&&this.data.l.name){p+=this.fontSize+(this.margin*4);q+=this.marginLeft+this.layoutLeft;for(var l=0;l<this.data.l.name.length;l++){var r=k*this["subGraphWeight"+l];q+=(r/2);this.drawText(this.data.l.name[l],q,p,this.font,this.foreground,"center","middle");q+=(r/2)}}else{if(this.graphType=="Pie"&&(this.showPieGrid||this.showPieSampleLabel)){var m,r;var n=0;var t=this.getFontPt(this.font);var b=this.marginTop+this.layoutTop;var e=this.marginLeft+this.layoutLeft;var a=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];for(var l=0;l<this.layoutRows;l++){m=d*this["subGraphWeight"+n][1];q=(this.marginLeft+this.layoutLeft)-this.margin;b+=m;if(this.showPieGrid){this.drawText(a[l],q,(b+(t/2))-(m/2),this.font,this.foreground,"right","middle")}for(var g=0;g<this.layoutCols;g++){if(this.xAxis.length<=n){break}r=k*this["subGraphWeight"+n][0];e+=r;p=(this.marginTop+this.layoutTop)-this.margin;if(l==0){if(this.showPieGrid){this.drawText(g+1,(e+(t/2))-(r/2),p,this.font,this.foreground,"center","bottom")}}if(this.showPieSampleLabel){this.drawText(this.xAxis[n],e-(r/1.1),b-(m/5),this.legendFont,this.foreground,"center","middle")}n++}e=this.marginLeft+this.layoutLeft}}}}}};this.drawDOELabelsLayout=function(j){var e=this.measureText(j,this.font);var b=this.getFontPt(this.font)/2;var i=this.layoutWidth;var d=this.layoutHeight;var g=this.marginLeft+this.offsetX;var f=this.marginTop+this.offsetY;var a=g+i-5;var c=f+d-5;this.drawText(j,g+20,f,this.font,this.foreground,"left","top");this.drawLine("line",g+b,f+b,g+15,f+b,this.foreground);this.drawLine("line",g+e+25,f+b,a,f+b,this.foreground);this.drawLine("line",a,f+b,a,c,this.foreground);this.drawLine("line",g+b,c,a,c,this.foreground);this.drawLine("line",g+b,f+b,g+b,c,this.foreground)};this.setLayoutGraphAttributes=function(){var g=0;for(var d=0;d<this.layoutRows;d++){for(var b=0;b<this.layoutCols;b++){var e="subGraphType"+g;if(!this[e]){if(this.data.l.type&&this.data.l.type[g]){this[e]=this.data.l.type[g]}else{this[e]=this.graphType}}var f="subSummaryType"+g;if(this[e]=="Boxplot"||this.summaryType=="iqr"){this[f]="iqr"}else{if(this.summaryType=="median"){this[f]="median"}else{if(this.summaryType=="sum"){this[f]="sum"}else{if(this[e]=="Correlation"){this[f]="cor"}else{if(this[e]=="Candlestick"){if((this.graphOrientation=="vertical"&&d>0)||(this.graphOrientation=="horizontal"&&b==0)){this[f]="volume"}else{this[f]="candle"}}else{this[f]="mean"}}}}}var a="subTransformType"+g;if(!this[a]){if(this.data.l.transform&&this.data.l.transform[g]){this[a]=this.data.l.transform[g]}else{this[a]=this.subTransformType}}g++}}};this.setLayoutWeights=function(){if(this.data.l.weight){var d=0;var e=0;var a;var b;if(this.isDOE){for(var c=0;c<this.data.l.weight.length;c++){a="subGraphWeight"+c;this[a]=this.data.l.weight[c]}}else{if(this.scatterPlotMatrix){for(var c=0;c<this.layoutRows;c++){a="subGraphWeight"+c;b=this[a]?this[a]:this.data.l.weight[c];d+=b}for(var c=0;c<this.data.l.weight.length;c++){a="subGraphWeight"+c;b=this[a]?this[a]:this.data.l.weight[c];this.data.l.weight[c]=b/d;this[a]=this.data.l.weight[c]}}else{if(this.data.l.vars&&this.data.l.smps){for(var c=0;c<this.data.l.weight.length;c++){a="subGraphWeight"+c;b=this[a]?this[a]:this.data.l.weight[c];d+=b[0];e+=b[1]}for(var c=0;c<this.data.l.weight.length;c++){a="subGraphWeight"+c;b=this[a]?this[a]:this.data.l.weight[c];this.data.l.weight[c][0]=b[0]/d*this.data.l.smps.length;this.data.l.weight[c][1]=b[1]/e*this.data.l.vars.length;this[a]=this.data.l.weight[c]}}else{if(this.graphType=="Pie"){for(var c=0;c<this.data.l.comp.length;c++){a="subGraphWeight"+c;this[a]=this.data.l.weight[c]}}else{for(var c=0;c<this.data.l.weight.length;c++){a="subGraphWeight"+c;b=this[a]?this[a]:this.data.l.weight[c];d+=b}for(var c=0;c<this.data.l.weight.length;c++){a="subGraphWeight"+c;b=this[a]?this[a]:this.data.l.weight[c];this.data.l.weight[c]=b/d;this[a]=this.data.l.weight[c]}}}}}}else{if(this.data.l.comp){this.data.l.weight=[];for(var c=0;c<this.data.l.comp.length;c++){a="subGraphWeight"+c;this.data.l.weight[c]=this.data.l.comp.length;this[a]=this.data.l.weight[c]}}else{alert("Wuz going on dude? This aint't gonna work!")}}};this.setMinimumLayoutAxisFonts=function(){var h=0;var e=Number.MAX_VALUE;for(var d=0;d<this.layoutRows;d++){for(var b=0;b<this.layoutCols;b++){var g,f,a;if(this.data.l.desc&&this.data.l.desc[h]){g=this.data.l.desc[h]}else{g="NA"}a=this.graphOrientation=="vertical"?this.height*this["subGraphWeight"+h]:this.width*this["subGraphWeight"+h];this.setAxisFont(g,a);f=this.getFontPt(this.axisTitleFont);if(f<e){e=f;this.minLayoutAxis=e;this.minLayoutAxisTitle=g}h++}}};this.getLayoutSummaryTypes=function(){var g=0;var a={};var e=[];for(var d=0;d<this.layoutRows;d++){for(var b=0;b<this.layoutCols;b++){var f="subSummaryType"+g;if(!a.hasOwnProperty(this[f])){e.push(this[f]);a[this[f]]=true}g++}}return e};this.validateLayoutSummaryGrouping=function(){if(this.isGroupedData){var b=this.getLayoutSummaryTypes();for(var a=0;a<b.length;a++){if(!this.isValidPlotData(b[a])){this.groupSamples(this.groupingFactors,b);break}}}};this.resetLayout=function(){delete (this.data.l);delete (this.layoutParams);this.offsetX=0;this.offsetY=0;this.layoutValidN=false;this.layoutValidR=false;this.layoutValidC=false;this.layoutComb=false;this.layout="1X1"};this.setDOE=function(){this.oneDPlot(true);this.Scatter2D(true);this.Scatter3D(true);this.Pie(true)};this.drawLayoutCompartments=function(h){var a=[];var B=0;var u=0;var G=this.title;var n=this.subtitle;var z=this.varIndices;var w=this.smpIndices;var t=this.showSampleNames;var q=this.showOverlays;var l=this.showLegend;var y=this.showIndicators;var d=this.getObjectArray(z);var g=this.getObjectArray(w);var E=false;var D=["left","right","top","bottom","x","y","width","height","weight","offsetX","offsetY","varIndices","smpIndices","grpIndices","graphType","summaryType","transformType","varIndicesStart","smpIndicesStart","minData","maxData","xAxisMin","xAxisMax","xAxis2Min","xAxis2Max","yAxisMin","yAxisMax","zAxisMin","zAxisMax","xAxisAbsMin","xAxisAbsMax","xAxis2AbsMin","xAxis2AbsMax","yAxisAbsMin","yAxisAbsMax","zAxisAbsMin","zAxisAbsMax","xAxisUnit","xAxis2Unit","yAxisUnit","zAxisUnit","setMin","setMax","setMin2","setMax2","setMinX","setMaxX","setMinY","setMaxY","setMinZ","setMaxZ"];var p=["graphType","transformType","varIndicesStart","smpIndicesStart","setMin","setMax","setMin2","setMax2","setMinX","setMaxX","setMinY","setMaxY","setMinZ","setMaxZ"];var s;if(this.layoutComb){if(this.isDOE){D.push("data");this.setDOE()}if(!this.graphType.match(/Scatter/)&&!this.isDOE){this.layoutMaxVarLegend=this.getLayoutMaxLegend()}if(this.graphType.match(/Scatter/)){this.xAxis=this.data.y.smps;this.yAxis=this.data.y.smps;this.initAxes(true)}else{this.initAxes(false,true)}this.setLayoutDimensions();var F=this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight;var f=this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom;this.title="";this.subtitle="";if(this.graphType.match(/Scatter/)&&!this.isDOE){this.draw2DLegend()}if(this.layoutParams&&this.layoutValidN>-1){s=this.layoutParams;if(s[this.layoutValidN]){for(var A=0;A<D.length;A++){s[this.layoutValidN][D[A]]=this[D[A]]}}}this.offsetX=this.layoutLeft;this.offsetY=this.layoutTop;this.layoutMaxVarLegendLabel=this.isDOE?"":this.data.l.vars?this.maxVarNameStr:this.maxSmpNameStr;this.layoutParams=[];if(!this.graphType.match(/Scatter/)){if(this.data.l.vars&&this.data.l.smps){this.layoutRows=this.data.l.smps.length;this.layoutCols=this.data.l.vars.length;this.layoutMaxSamples=this.smpIndices.length*this.layoutCols/this.layoutRows;this.legendPosition="bottom"}else{B=Math.max(this.layoutRows,this.layoutCols);if(this.isDOE){this.legendPosition="right";this.graphOrientation="vertical";this.layoutMaxSamples=this.smpIndices.length}else{if(this.graphType!="Pie"){if(this.graphOrientation=="vertical"){this.layoutRows=B;this.layoutCols=1;this.legendPosition="right"}else{this.layoutRows=1;this.layoutCols=B;this.legendPosition="bottom"}}}}}this.setLayoutWeights();this.setMinimumLayoutAxisFonts();this.setLayoutGraphAttributes();this.validateLayoutSummaryGrouping();var C=0;for(var A=0;A<this.layoutRows;A++){var e=false;for(var x=0;x<this.layoutCols;x++){this.layoutCurrent=C;if(this.graphType=="Pie"||this.isDOE){if(this.isDOE){if(this.dataStndBy.l.smps.length<=C){break}}else{if(this.data.l.smps.length<=C){break}}}if(s){for(var v=0;v<p.length;v++){this[p[v]]=s[C][p[v]]}}if(this.isDOE){this.layoutWidth=(this.width-F)*this["subGraphWeight"+C][0];this.layoutHeight=(this.height-f)*this["subGraphWeight"+C][1];if(A==0&&x==0){if(this.graphType.match(/Scatter/i)){this.isHistogram=false;this.xAxis=this.configStndBy.xAxis;this.yAxis=this.configStndBy.yAxis;this.xAxisTitle=this.configStndBy.xAxisTitle;this.yAxisTitle=this.configStndBy.yAxisTitle;this.initAxes(true);this.initializeData(this.dataStndBy);this.varIndices=this.dataStndBy.l.doe}else{this.initializeData(this.dataStndBy);this.smpIndices=this.dataStndBy.l.doe}this.showLegend=false;this.showIndicators=false;if(this.graphType=="Scatter3D"){this.draw3DPlot()}else{if(this.graphType.match(/Scatter/i)){this.draw2DPlot()}else{this.draw1DPlot()}}this.showLegend=true}else{this.drawDOELabelsLayout(this.dataStndBy.l.smps[C][0]);this.top=5;this.bottom=5;this.right=5;this.left=5;if(this.dataStndBy.l.type[C]=="Pie"){this.createPie(this.dataStndBy.l.smps[C][0]);this.legendBox=false;this.drawPiePlot()}else{if(this.dataStndBy.l.type[C]=="Scatter2D"){this.createHistogram(false,false,this.dataStndBy.l.smps[C][0]);this.initAxes(true);this.showLegend=false;this.xAxisTitle="";this.yAxisTitle="";this.draw2DPlot()}}}}else{this.weight=this["subGraphWeight"+C];this.graphType=this["subGraphType"+C];this.summaryType=this["subSummaryType"+C];this.transformType=this["subTransformType"+C];if(this["subTransformType"+C]){this.isTransformedData=true}if(this.data.l.log&&this.data.l.log[C]){this.isLogData=this.data.l.log[C]}if(this.graphType.match(/Scatter/)){if(this.data.l.smps[C].xAxis&&this.data.l.smps[C].yAxis){this.xAxis=this.data.l.smps[C].xAxis;this.yAxis=this.data.l.smps[C].yAxis;this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis)}else{this.xAxis=false;this.yAxis=false;this.xAxisIndices=false;this.yAxisIndices=false}this.layoutWidth=(this.width-F)*this["subGraphWeight"+C];this.layoutHeight=(this.height-f)*this["subGraphWeight"+C];this.varIndices=this.data.l.comp[C];if(this.graphType.match(/Scatter/)&&this.layoutAdjust&&this.xAxis&&this.yAxis){this.initAxes(true);this.layoutAxis=3}else{if(this.graphType.match(/Scatter/)){this.layoutAxis=x==0?2:0;this.layoutAxis=A==this.layoutRows&&this.layoutAxis?3:A==this.layoutRows?1:0}}this.showLegend=false;this.showIndicators=false}else{if(this.data.l.vars&&this.data.l.smps){E=this.graphOrientation=="vertical"?true:false;this.showLegend=false}else{if(this.graphType=="Pie"){E=false;this.showLegend=false}else{E=this.data.l.smps?true:false}}this.showSampleNames=E;this.showOverlays=E;this.xAxisTitle=this.data.l.desc&&this.data.l.desc[C]?this.data.l.desc[C]:false;if(this.data.l.vars&&this.data.l.smps){this.layoutHeight=(this.height-f)*this["subGraphWeight"+C][1];this.layoutWidth=(this.width-F)*this["subGraphWeight"+C][0];a=[];for(var v=0;v<this.data.l.comp[C][0].length;v++){if(d.hasOwnProperty(this.data.l.comp[C][0][v])){a.push(this.data.l.comp[C][0][v])}}this.varIndices=a;a=[];for(var v=0;v<this.data.l.comp[C][1].length;v++){if(g.hasOwnProperty(this.data.l.comp[C][1][v])){a.push(this.data.l.comp[C][1][v])}}this.smpIndices=a}else{if(this.graphType=="Pie"){this.layoutWidth=(this.width-F)*this["subGraphWeight"+C][0];this.layoutHeight=(this.height-f)*this["subGraphWeight"+C][1]}else{if(this.graphOrientation=="vertical"){this.layoutHeight=(this.height-f)*this["subGraphWeight"+C];this.layoutWidth=this.width-F}else{this.layoutWidth=(this.width-F)*this["subGraphWeight"+C];this.layoutHeight=this.height-f}}a=[];if(this.data.l.vars){for(var v=0;v<this.data.l.comp[C].length;v++){if(d.hasOwnProperty(this.data.l.comp[C][v])){a.push(this.data.l.comp[C][v])}}this.varIndices=a}else{for(var v=0;v<this.data.l.comp[C].length;v++){if(g.hasOwnProperty(this.data.l.comp[C][v])){a.push(this.data.l.comp[C][v])}}this.smpIndices=a}}if(this.layoutAdjust){this.layoutAxis=3;if(this.varIndices.length>0&&this.smpIndices.length>0){this.initAxes(true)}}}if(this.varIndices.length>0&&this.smpIndices.length>0){h.call(this)}}this["subGraphTop"+C]=this.top;this["subGraphBottom"+C]=this.bottom;this["subGraphRight"+C]=this.right;this["subGraphLeft"+C]=this.left;this["subGraphX"+C]=this.x;this["subGraphY"+C]=this.y;var o=["rect",this.marginLeft+this.offsetX+this.left,this.marginTop+this.offsetY+this.top,this.marginLeft+this.offsetX+this.left+this.x,this.marginTop+this.offsetY+this.top+this.y];if(this.isDOE){}else{if(this.graphType.match(/Scatter/)){if(A==x){var r=this.scaleTextToFont(this.maxSmpNameStr,this.maxTextSize,(this.width-F)*0.8/this.layoutCols);this.drawText(this.data.y.smps[A],this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),r,this.foreground,"center","middle")}}else{if(!E){if(this.data.l.vars&&this.data.l.smps){if(this.varIndices.length>0&&this.smpIndices.length>0){if(this.graphOrientation!="vertical"&&(C%this.data.l.vars.length==0||!e)){e=true;this.drawLayoutSampleOverlays(w)}if(C>=this.data.l.vars.length*(this.data.l.smps.length-1)){this.drawLayoutVariableLegend()}}}else{if(this.graphType!="Pie"){if((this.graphOrientation=="vertical"&&(C+1)==B)||(this.graphOrientation!="vertical"&&C==0)){this.drawLayoutSampleOverlays(w)}}else{if(this.graphType=="Pie"&&C==0){if(l){this.drawLayoutVariableLegend()}}}}}else{if(this.data.l.vars&&this.data.l.smps){if(C>=this.data.l.vars.length*(this.data.l.smps.length-1)){this.drawLayoutVariableLegend()}}}}}var b={};for(var v=0;v<D.length;v++){b[D[v]]=this[D[v]]}b.width=this.layoutWidth;b.height=this.layoutHeight;b.subGraphType=this.graphType;b.subSummaryType=this.SummaryType;b.subTransformType=this.transformType;this.layoutParams.push(b);if(this.isDOE||this.graphType.match(/Scatter/)||(this.data.l.vars&&this.data.l.smps)){this.offsetX+=this.layoutWidth}else{if(this.graphOrientation=="vertical"){this.offsetY+=this.layoutHeight}else{this.offsetX+=this.layoutWidth}}C++}if(this.isDOE||this.graphType.match(/Scatter|Pie/)||(this.data.l.vars&&this.data.l.smps)){this.offsetX=this.layoutLeft;this.offsetY+=this.layoutHeight}}if(!this.isDOE){this.title=G;this.subtitle=n;this.drawTitle();this.drawLabelsLayout();this.drawLayoutResizer()}this.varIndices=z;this.smpIndices=w;this.showSampleNames=t;this.showOverlays=q;this.showLegend=l;this.showIndicators=y;if(this.isDOE){this.data=this.dataStndBy;this.graphType=this.data.l.type[0]}}};this.initializeLayout=function(){this.isValidLayout()};this.initializeLayout()};CanvasXpress.prototype.initViewport=function(a){this.setViewport=function(){var d=this.$("container-"+this.target);var q=this.toolbarPermanent&&this.canvas.height>400?20:this.toolbarPermanent&&this.canvas.height<=400?13:0;if(!d){var y=this.$(this.target);y.className="CanvasXpress";var d=this.$cX("div",{id:"container-"+this.target,className:"CanvasXpressContainer"});if(a){d.style.display="none"}var k=this.$cX("div",{id:"north-container-"+this.target,className:"CanvasXpressContainer"},{width:(y.width+14)+"px",height:(q+7)+"px",clear:"left"});var g=this.$cX("div",{id:"north-handler-"+this.target,className:"CanvasXpressHandler",state:"open",open:"url('"+this.imageDir+"tbottom.png')",close:"url('"+this.imageDir+"ttop.png')",skipWidth:true},{width:(y.width+14)+"px",height:"7px",display:"none",backgroundImage:"url('"+this.imageDir+"ttop.png')"});var z=this.$cX("div",{id:"north-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:(y.width+14)+"px",height:q+"px"});var C=this.$cX("div",{id:"middle-container-"+this.target,className:"CanvasXpressContainer"},{width:(y.width+14)+"px",height:y.height+"px",clear:"left"});if(this.isIE&&this.useFlashIE&&this.browserVersion<9){C.style.zIndex=-1}var l=this.$cX("div",{id:"west-container-"+this.target,className:"CanvasXpressContainer"},{width:"7px",height:y.height+"px"});var j=this.$cX("div",{id:"west-handler-"+this.target,className:"CanvasXpressHandler",state:"open",open:"url('"+this.imageDir+"tright.png')",close:"url('"+this.imageDir+"tleft.png')",skipHeight:true},{width:"7px",height:y.height+"px",display:"none",backgroundImage:"url('"+this.imageDir+"tleft.png')"});var B=this.$cX("div",{id:"west-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:"0px",height:y.height+"px"});var e=this.$cX("div",{id:"center-wrapper-"+this.target,className:"CanvasXpressWrapper"});var h=this.$cX("div",{id:"east-container-"+this.target,className:"CanvasXpressContainer"},{width:"7px",height:y.height+"px"});var f=this.$cX("div",{id:"east-handler-"+this.target,className:"CanvasXpressHandler",state:"open",open:"url('"+this.imageDir+"tright.png')",close:"url('"+this.imageDir+"tleft.png')",skipHeight:true},{width:"7px",height:y.height+"px",display:"none",backgroundImage:"url('"+this.imageDir+"tleft.png')"});var x=this.$cX("div",{id:"east-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:"0px",height:y.height+"px"});var b=this.$cX("div",{id:"south-container-"+this.target,className:"CanvasXpressContainer"},{width:(y.width+14)+"px",height:"7px",clear:"left"});var A=this.$cX("div",{id:"south-handler-"+this.target,className:"CanvasXpressHandler",open:"url('"+this.imageDir+"tbottom.png')",close:"url('"+this.imageDir+"ttop.png')",skipWidth:true},{width:(y.width+14)+"px",height:"7px",display:"none",backgroundImage:"url('"+this.imageDir+"ttop.png')"});var r=this.$cX("div",{id:"south-wrapper-"+this.target,className:"CanvasXpressWrapper",state:"open"},{width:(y.width+14)+"px",height:"0px"});k.appendChild(g);k.appendChild(z);l.appendChild(B);l.appendChild(j);h.appendChild(f);h.appendChild(x);b.appendChild(A);b.appendChild(r);C.appendChild(l);C.appendChild(e);C.appendChild(h);d.appendChild(k);d.appendChild(C);d.appendChild(b);if(this.isVideo){var m=this.$(this.target+"-cX-Video");if(!m){m=this.$cX("video",{id:this.target+"-cX-Video",autoplay:false,controls:this.videoControls,loop:this.videoLoop,preload:this.videoPreload,poster:this.videoPoster,dataSet:this.videoData,width:this.canvas.width,height:this.canvas.height,className:this.videoClassName});var n=[];var u=this.backgroundVideo;if(u&&!(u.propertyIsEnumerable("length"))&&typeof u==="object"&&typeof u.length==="number"){n=u}else{n.push(this.backgroundVideo)}for(var w=0;w<n.length;w++){var p=this.$cX("source",{src:n[w],type:n[w].match(/mp4$/)?"video/mp4":n[w].match(/webm$/)?"video/webm":"video/ogv"});m.appendChild(p)}}y.parentNode.insertBefore(d,y);e.appendChild(y.parentNode.appendChild(y));y.parentNode.insertBefore(m,y)}else{y.parentNode.insertBefore(d,y);e.appendChild(y.parentNode.appendChild(y))}this.addRemoveViewportListeners("addEvtListener")}};this.addRemoveViewportListeners=function(b){this.addRemoveEvtListener(b,this.$("north-handler-"+this.target),"click",this.clickViewport,false);this.addRemoveEvtListener(b,this.$("west-handler-"+this.target),"click",this.clickViewport,false);this.addRemoveEvtListener(b,this.$("east-handler-"+this.target),"click",this.clickViewport,false);this.addRemoveEvtListener(b,this.$("south-handler-"+this.target),"click",this.clickViewport,false)};this.clickViewport=function(b){return function(o,d){if(!o){o=window.event}if(!d){d=b.getTargetEvent(o)}var r,m;var g=d.parentNode;var j=d.nextSibling||d.previousSibling;var f=b.$(this.remoteParentId+"-canvasXpressRemoteWindow");var c=b.$("west-handler-"+b.target);var k=b.$("north-container-"+b.target);var p=b.$("south-container-"+b.target);var q=b.$("middle-container-"+b.target);var n=b.$("east-container-"+b.target);var i=b.$("west-container-"+b.target);var l=b.showFadeResizeMoveAnimation?500:0;if(g&&j&&c&&k&&p&&q&&n&&i){if(d.state=="closed"){d.state="open";d.style.backgroundImage=d.close;if(f){r=d.lastRemoteWidth;m=d.lastRemoteHeight+7;b.resizeMove(f,0,0,d.lastRemoteWidth,d.lastRemoteHeight)}if(d.id.match(/north|south/)){b.resizeMove(g,0,0,d.lastWidth,d.lastHeight+7);b.resizeMove(j,0,0,d.lastWidth,d.lastHeight)}else{b.resizeMove(q,0,0,d.lastWidth+q.clientWidth,b.canvas.height);b.resizeMove(g,0,0,d.lastWidth+7,b.canvas.height);b.resizeMove(j,0,0,d.lastWidth,b.canvas.height)}setTimeout(function(){j.style.overflow="visible"},l*2)}else{j.style.overflow="hidden";d.state="closed";d.lastLeft=parseInt(j.style.left);d.lastTop=parseInt(j.style.top);d.lastWidth=parseInt(j.style.width);d.lastHeight=parseInt(j.style.height);d.lastRemoteWidth=f?parseInt(f.clientWidth):0;d.lastRemoteHeight=f?parseInt(f.clientHeight):0;d.style.backgroundImage=d.open;if(d.id.match(/north|south/)){r=parseInt(i.clientWidth)+b.canvas.width+parseInt(n.clientWidth);m=b.canvas.height+14;if(f){b.resizeMove(f,0,0,r,m)}b.resizeMove(j,0,0,r,0);b.resizeMove(g,0,0,r,7)}else{m=parseInt(k.clientHeight)+b.canvas.height+parseInt(p.clientHeight);if(d.id.match(/west/)){r=Math.max(parseInt(p.clientHeight),parseInt(n.clientWidth)+b.canvas.width+7);if(f){b.resizeMove(f,0,0,r+48,m+54)}b.resizeMove(j,0,0,0,b.canvas.height);b.resizeMove(g,0,0,7,b.canvas.height);b.resizeMove(q,0,0,parseInt(n.clientWidth)+b.canvas.width+7,b.canvas.height)}else{r=Math.max(parseInt(p.clientHeight),parseInt(i.clientWidth)+b.canvas.width+7);if(f){b.resizeMove(f,0,0,r+48,m+54)}b.resizeMove(j,0,0,0,b.canvas.height);b.resizeMove(g,0,0,7,b.canvas.height);b.resizeMove(q,0,0,parseInt(i.clientWidth)+b.canvas.width+7,b.canvas.height)}}}if(f){setTimeout(function(){b.resizeExtContainer()},l)}}return false}}(this);this.resizeViewportNorth=function(){var e=this.$("west-container-"+this.target);var c=this.$("east-container-"+this.target);var g=this.$("north-container-"+this.target);var d=this.$("north-handler-"+this.target);var b=this.$("north-wrapper-"+this.target);var f=this.toolbarPermanent&&this.canvas.height>400?"20px":this.toolbarPermanent&&this.canvas.height<=400?"13px":0;if(e&&c&&g&&d&&b){if(d.style.display=="block"&&d.state=="open"){g.style.width=(parseInt(e.style.width)+this.canvas.width+parseInt(c.style.width))+"px";b.style.width=(parseInt(e.style.width)+this.canvas.width+parseInt(c.style.width))+"px"}else{g.style.width=(parseInt(e.style.width)+this.canvas.width+parseInt(c.style.width))+"px";b.style.width=(parseInt(e.style.width)+this.canvas.width+parseInt(c.style.width))+"px";g.style.height=(f+7)+"px";b.style.height=f+"px"}d.style.left=parseInt(e.style.width)+"px";d.style.width=this.canvas.width+"px"}};this.resizeViewportWest=function(){var f=this.$(this.target+"-cX-Configurator");var d=this.$("west-container-"+this.target);var b=this.$("west-handler-"+this.target);var e=this.$("west-wrapper-"+this.target);if(d&&b&&e){if(b.style.display=="block"&&b.state=="open"){d.style.width=(this.configuratorWidth+7+22)+"px";e.style.width=(this.configuratorWidth+22)+"px";d.style.height=this.canvas.height+"px";e.style.height=this.canvas.height+"px"}else{d.style.width="7px";e.style.width="0px"}d.style.height=this.canvas.height+"px";b.style.height=this.canvas.height+"px";e.style.height=this.canvas.height+"px"}};this.resizeViewportEast=function(){var d=this.$(this.target+"-cX-DataFilter");var b=this.$("east-container-"+this.target);var e=this.$("east-handler-"+this.target);var c=this.$("east-wrapper-"+this.target);if(b&&e&&c){if(e.style.display=="block"&&e.state=="open"){b.style.width=(this.dataFilterWidth+7+6)+"px";c.style.width=(this.dataFilterWidth+6)+"px";b.style.height=this.canvas.height+"px";c.style.height=this.canvas.height+"px"}else{b.style.width="7px";c.style.width="0px"}b.style.height=this.canvas.height+"px";e.style.height=this.canvas.height+"px";c.style.height=this.canvas.height+"px"}};this.resizeViewportSouth=function(e){var h=this.$(this.target+"-cX-DataTable");var b=this.$("west-handler-"+this.target);var c=this.$("west-container-"+this.target);var g=this.$("east-container-"+this.target);var j=this.$("south-container-"+this.target);var f=this.$("south-handler-"+this.target);var l=this.$("south-wrapper-"+this.target);if(h&&b&&c&&g&&j&&f&&l){var i=b&&b.style.display=="none"?7:0;if((f.style.display=="block"&&f.state=="open")||e){j.style.height=(parseInt(h.style.height)+7+2)+"px";l.style.height=(parseInt(h.style.height)+2)+"px";j.style.width=(parseInt(h.style.width)+2+i)+"px";l.style.width=j.style.width}else{j.style.width=(parseInt(c.style.width)+this.canvas.width+parseInt(g.style.width))+"px";l.style.width=(parseInt(c.style.width)+this.canvas.width+parseInt(g.style.width))+"px";j.style.height="7px";l.style.height="0px"}f.style.left=parseInt(c.style.width)+"px";f.style.width=this.canvas.width+"px"}};this.resizeViewport=function(j){if(j){var b=this.getTargetEvent(j);if(b.className=="CanvasXpressHandler"){return}if(this.Ext){for(var d=0;d<CanvasXpress.references.length;d++){CanvasXpress.references[d].resizeViewport()}}if(b.className&&b.className.match(/x-tab-strip-text/)){return}}var h=this.$("middle-container-"+this.target);var c=this.$("east-container-"+this.target);var g=this.$("west-container-"+this.target);if(h&&c&&g){this.resizeViewportWest();this.resizeViewportEast();this.resizeViewportNorth();this.resizeViewportSouth();var f=(parseInt(g.style.width)+this.canvas.width+parseInt(c.style.width)+1);h.style.width=(f+2)+"px";h.style.height=(this.canvas.height+2)+"px"}};this.hideViewport=function(){if(this.configuratorLastState&&this.configuratorLastState=="docked"){var b=this.$("west-handler-"+this.target);if(b&&b.state=="open"){this.clickViewport(false,b)}}if(this.dataFilterLastState&&this.dataFilterLastState=="docked"){var d=this.$("east-handler-"+this.target);if(d&&d.state=="open"){this.clickViewport(false,d)}}if(this.dataTableLastState&&this.dataTableLastState=="docked"){var c=this.$("south-handler-"+this.target);if(c&&c.state=="open"){this.clickViewport(false,c)}}};this.resetViewportOverflow=function(c){if(c){var b=this.$(c+"-wrapper-"+this.target);if(b){b.style.overflow="visible"}}};this.initializeViewport=function(){this.setViewport()};this.initializeViewport()};CanvasXpress.prototype.initMenuLinks=function(){this.addLinkDiv=function(){if(this.$(this.target+"-cX-Link")){this.resetLinkDiv();return}var b=this.$cX("div",{id:this.target+"-cX-Link",className:"CanvasXpressLink"},{zIndex:10002,display:"none"});var a=this.$cX("ul",{id:this.target+"-cX-Link-Content",className:"CanvasXpressList"});var c=this.$("north-wrapper-"+this.target);if(c){b.appendChild(a);c.appendChild(b)}};this.showLinkDiv=function(J,b,D){var K=this.$(this.target+"-cX-Link-Content");var k=this.$("west-container-"+this.target);var M=false;if(K){this.resetLinkDiv();var L=this.adjustedCoordinates(J);if(L){var h=L.x+k.offsetWidth;var f=L.y;for(var H=0;H<b.length;H++){var o=b[H].url;var C=b[H].name;var r=b[H].title;var E=b[H].icon;var v=b[H].source;var B=b[H].params;if(o){M=true}else{if(v&&this.data.links&&this.data.links[v]){o=this.data.links[v].url;M=true;if(B){for(var G in B){o=o.replace("$"+G+"$",B[G])}}}}var F=this.$cX("li",{className:"CanvasXpressListItem"});var c=r?r:this.data.links&&v&&this.data.links[v]&&this.data.links[v].title?this.data.links[v].title:"";var N=this.$cX("a",{className:"CanvasXpressListItemA",href:o,alt:c,title:c,target:"_blank"});var I=this.$cX("img",{className:"CanvasXpressListIcon",src:E?E:this.data.links&&v&&this.data.links[v]&&this.data.links[v].icon?this.data.links[v].icon:this.getPixelImage()});var A=this.$cX("span",{className:"CanvasXpressListItemText",innerHTML:C?C:this.data.links&&v&&this.data.links[v]&&this.data.links[v].name?this.data.links[v].name:H});N.appendChild(I);N.appendChild(A);F.appendChild(N);this.addRemoveLinkListeners("addEvtListener",F);K.appendChild(F)}K.parentNode.style.left=h+"px";K.parentNode.style.top=f+"px";K.parentNode.style.display=M?"block":"none"}}};this.addRemoveLinkListeners=function(b,a){if(a){this.addRemoveEvtListener(b,a,"click",this.clickLink,false);this.addRemoveEvtListener(b,a,"mouseover",this.mouseoverLink,false);this.addRemoveEvtListener(b,a,"mouseout",this.mouseoutLink,false)}};this.clickLink=function(a){return function(b){if(!b){b=window.event}a.resetLinkDiv();return false}}(this);this.mouseoverLink=function(a){return function(c){if(!c){c=window.event}var b=a.getMenuItemComp(c);b[0].className="CanvasXpressListItemActive";b[1].className="CanvasXpressListItemAActive";return false}}(this);this.mouseoutLink=function(a){return function(c){if(!c){c=window.event}var b=a.getMenuItemComp(c);b[0].className="CanvasXpressListItem";b[1].className="CanvasXpressListItemA";return false}}(this);this.resetLinkDiv=function(){var a=this.$(this.target+"-cX-Link-Content");if(a&&a.childNodes){while(a.childNodes.length>0){this.addRemoveLinkListeners("removeEvtListener",a.childNodes[0]);a.removeChild(a.childNodes[0])}a.parentNode.style.display="none"}};this.addMenu=function(o,c,p,n,s,r,k){if(this.disableMenu){return}var d;var b;var t=this.$("north-wrapper-"+this.target);var g=this.$("west-container-"+this.target);this.resetLinkDiv();if(t&&g){if(c){b=this.newId("-cX-Menu-");d=this.$cX("div",{id:b,className:"CanvasXpressMenu",par:p},{left:"0px",top:"0px",zIndex:this.menuIndex++,display:"none"})}else{this.removeMenus();if(n){c=n;s+=g.offsetWidth}else{c=this.setMenu();var a=this.getTargetEvent(o);var z=this.adjustedCoordinates(o,a);s=z.x+g.offsetWidth;r=z.y}b=this.newId("-cX-Menu-");d=this.$cX("div",{id:b,className:"CanvasXpressMenu"},{left:s+"px",top:r+"px",zIndex:this.menuIndex++})}var v=this.$cX("ul",{id:this.newId("-cX-List-"),className:"CanvasXpressList",header:k});d.appendChild(v);t.appendChild(d);var q=this.maxSubMenus;var f=c.length>q?q:c.length;if(c.length>q){v.rawMenu=c;v.rawMenuIndex=0;this.addMenuItemScroller(v,"Top")}for(var j=0;j<f;j++){if(c[j][0]=="-"){this.addMenuItemSep(v)}else{if(c[j][0]=="-text-"){this.addMenuItemText(c[j],v)}else{if(c[j][0]=="-color-"){this.addMenuItemColor(c[j],v)}else{this.addMenuItem(c[j],v)}}}}if(c.length>q){this.addMenuItemScroller(v,"Bottom")}}return b};this.pageMenuItem=function(e,f){var g,j,a,h;var d=e.childNodes.length-2;if(f=="Top"&&e.rawMenuIndex>0){g=e.childNodes[e.childNodes.length-2];j=e.rawMenu[e.rawMenuIndex-1];a=e.childNodes[1];h=true;e.rawMenuIndex--}else{if(f=="Bottom"&&e.rawMenu.length>(e.rawMenuIndex+d)){g=e.childNodes[1];j=e.rawMenu[e.rawMenuIndex+d];a=e.childNodes[e.childNodes.length-1];h=true;e.rawMenuIndex++}}if(h){this.addRemoveItemListeners("removeEvtListener",g);g.parentNode.removeChild(g);if(j[0]=="-"){this.addMenuItemSep(e,a)}else{if(j[0]=="-text-"){this.addMenuItemText(j,e,a)}else{if(j[0]=="-color-"){this.addMenuItemColor(j,e,a)}else{this.addMenuItem(j,e,a)}}}}};this.addMenuItemSep=function(d,a){var c=this.$cX("li",{id:this.newId("-cX-List-Item-Sep-"),className:"CanvasXpressListItemSep"});var e=this.$cX("span",{id:this.newId("-cX-List-Item-Text-Sep-"),className:"CanvasXpressListItemTextSep",innerHTML:"&nbsp;"});c.appendChild(e);if(a){a.parentNode.insertBefore(c,a)}else{d.appendChild(c)}};this.addMenuItemScroller=function(b,c){var a=this.$cX("li",{id:this.newId("-cX-List-Item-Scroll-"+c),className:"CanvasXpressListItemScroll"+c});var d=this.$cX("span",{id:this.newId("-cX-List-Item-Text-Scroll-"+c),className:"CanvasXpressListItemTextScroll"+c,innerHTML:"&nbsp;"});a.appendChild(d);b.appendChild(a);this.addRemoveItemListeners("addEvtListener",a)};this.addMenuItem=function(d,n,j){var h=this.newId("-cX-List-Item-");var f=this.$cX("li",{id:h,className:"CanvasXpressListItem",click:d[2],params:d[3]||[]});var k;if(d[5]){var e=this.addMenu(false,d[5],h);k=this.$cX("a",{id:this.newId("-cX-List-Item-A-"),className:"CanvasXpressListItemAArrow",hidefocus:"true",unselectable:"on",href:"#",menu:e})}else{k=this.$cX("a",{id:this.newId("-cX-List-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"})}var g=this.$cX("img",{id:this.newId("-cX-List-Icon-"),className:"CanvasXpressListIcon",src:this.imageDir+(d[1]||"canvasXpress.gif")});var p=this.$cX("span",{id:this.newId("-cX-List-Item-Text-"),className:"CanvasXpressListItemText",innerHTML:d[0]||""});var c=this.$cX("span",{className:"CanvasXpressListItemTextShort",innerHTML:d[4]||""});k.appendChild(g);k.appendChild(p);k.appendChild(c);f.appendChild(k);if(j){j.parentNode.insertBefore(f,j)}else{n.appendChild(f)}this.addRemoveItemListeners("addEvtListener",f)};this.addMenuItemText=function(c,m,j){var h=this.newId("-cX-List-Item-");var f=this.newId("-cX-List-Item-Input-");var d=this[c[2][0]]||"";var e=this.$cX("li",{id:h,className:"CanvasXpressListItem",click:c[1],params:[c[2],f]});var n=this.$cX("input",{id:f,className:"CanvasXpressList",type:"text",value:d});var k=this.$cX("a",{id:this.newId("-cX-List-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"});var g=this.$cX("img",{id:this.newId("-cX-List-Icon-"),className:"CanvasXpressListIcon",src:this.imageDir+"refresh_form.png"},{marginTop:"4px"});k.appendChild(g);k.appendChild(n);e.appendChild(k);if(j){j.parentNode.insertBefore(e,j)}else{m.appendChild(e)}this.addRemoveItemListeners("addEvtListener",e)};this.addMenuItemColor=function(E,v,L){var m=this.newId("-cX-List-Item-");var n=this.newId("-cX-List-Item-Color-Container-");var g=this.newId("-cX-List-Item-Color-Current-");var B=this.newId("-cX-List-Item-Color-Palete-");var f=this.newId("-cX-List-Item-Color-Palete-Current-");var k=this.newId("-cX-List-Item-Color-Saturation-");var w=this.newId("-cX-List-Item-Color-Saturation-Current-");var N=this[E[2][0]]||"";var G=this.$cX("li",{id:m,className:"CanvasXpressListItem",click:E[1],params:[E[2],g],palete:B,paleteCurrent:f,colorCurrent:g,saturation:k,saturationCurrent:w});var M=this.$cX("a",{id:this.newId("-cX-List-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"},{height:"126px"});var I=this.$cX("img",{id:this.newId("-cX-List-Icon-"),className:"CanvasXpressListIcon",src:this.imageDir+"refresh_form.png"},{marginTop:"2px"});var J=N?this.rgbToHex(this.validateColor(N.replace(/[\'\"]/g,""))):this.foreground;this.colorRGBfromString(J);var t=Math.round(this.colorHSV[0]/6*180);var r=Math.round((1-this.colorHSV[1])*100);var q=Math.round((1-this.colorHSV[2])*100);var K=this.$cX("div",{id:n},{width:"188px",height:"130px",cssFloat:"left"});var C=this.$cX("div",{id:g,parentItem:m,className:"CanvasXpressConfiguratorColor",value:N},{width:"203px",height:"16px",cssFloat:"left",marginBottom:"5px",cursor:"default"});var D=this.$cX("div",{id:B,parentItem:m,className:"CanvasXpressConfiguratorColor"},{position:"relative",left:"0px",top:"0px",width:"181px",height:"101px",backgroundImage:"url('"+this.imageDir+"color.png')",backgroundRepeat:"no-repeat",cssFloat:"left",cursor:"crosshair"});var d=this.$cX("div",{id:f,parentItem:m},{position:"relative",left:(t-7)+"px",top:(r-7)+"px",width:"195px",height:"115px",cursor:"crosshair",backgroundImage:"url('"+this.imageDir+"cross.gif')",backgroundRepeat:"no-repeat"});D.appendChild(d);var A=this.$cX("div",{id:k,parentItem:m,className:"CanvasXpressConfiguratorColor"},{position:"relative",left:"188px",top:"-102px",width:"15px",height:"100px",border:"1px solid "+this.skinBorderColor,clear:"left",cursor:"crosshair"});for(var H=0;H<100;H+=4){var F=this.$cX("div",false,{height:"4px",position:"relative",left:"0px",cursor:"crosshair"});A.appendChild(F)}var e=this.$cX("div",{id:w,parentItem:m},{position:"relative",left:"0px",top:(q-108)+"px",width:"29px",height:"115px",cursor:"crosshair",backgroundImage:"url('"+this.imageDir+"cross.gif')",backgroundRepeat:"no-repeat",overflow:"hidden"});A.appendChild(e);K.appendChild(C);K.appendChild(D);K.appendChild(A);M.appendChild(I);M.appendChild(K);G.appendChild(M);if(L){L.parentNode.insertBefore(G,L)}else{v.appendChild(G)}this.colorizeCurrentItemColor(G);this.colorizeSaturationItemColor(G);this.addRemoveItemListeners("addEvtListener",G)};this.colorizeCurrentItemColor=function(a){var e=this.$(a.colorCurrent);if(e){var d=this.colorRGBToString();var b=this.hexToRgb("#"+d);e.style.backgroundColor="#"+d;e.innerHTML="&nbsp;&nbsp;"+b;e.style.color=this.complementaryColor(b,true);e.value=b}};this.colorizeSaturationItemColor=function(a){var d=function(m,k,c,j,h){return"rgb("+(m*(1-j/h)*100)+"%,"+(k*(1-j/h)*100)+"%,"+(c*(1-j/h)*100)+"%)"};var f=this.$(a.saturation);if(f&&this.colorHSV){var g=f.childNodes;var b=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],1);if(b){for(var e=0;e<g.length-1;e++){g[e].style.backgroundColor=d(b[0],b[1],b[2],e,g.length-1)}}}};this.updateColorItemValue=function(b,c){if(!b){var g=this.getMenuItemComp(c);b=g[0]}if(this.changingColorItemOn){if(this.changingColorItemOn=="palette"){var a=this.$(b.palete);var h=this.$(b.paleteCurrent);if(a&&h){var k=this.adjustedCoordinates(c,a);if(k){var j=Math.min(Math.max(0,k.x),181);var f=Math.min(Math.max(0,k.y-25),101);h.style.left=(j-7)+"px";h.style.top=(f-7)+"px";this.colorFromHsv(j*6/180,1-f/100,null);this.colorizeCurrentItemColor(b);this.colorizeSaturationItemColor(b)}}}else{var m=this.$(b.saturation);var d=this.$(b.saturationCurrent);if(m&&d){var k=this.adjustedCoordinates(c,m);if(k){var f=Math.min(Math.max(0,k.y-25),101);d.style.top=(f-108)+"px";this.colorFromHsv(null,null,1-f/100);this.colorizeCurrentItemColor(b)}}}}return false};this.endColorItemChange=function(a){this.changingColorItemOn=false};this.addRemoveItemListeners=function(b,a){if(!a){return this.removeMenus()}this[b](a,"click",this.clickMenuItem,false);this[b](a,"mouseover",this.mouseoverMenuItem,false);this[b](a,"mouseout",this.mouseoutMenuItem,false);this[b](a,"mousewheel",this.mousewheelMenuItem,false);if(a.className.match(/Scroll/)){this[b](a,"mousedown",this.mousedownMenuItem,false);this[b](a,"mouseup",this.mouseupMenuItem,false)}if(a.paleteCurrent&&a.saturation){this[b](a,"mousedown",this.mousedownMenuItemColor,false)}};this.clickMenuItem=function(a){return function(g){if(!g){g=window.event}a.cancelEvent(g);var b=a.getTargetEvent(g);var j=a.getMenuItemComp(g);if(!/input|textarea|select/i.test(b.tagName)){if(j[0].className.match(/Scroll/)||j[1].className.match(/Scroll/)){var c=j[0].className.match(/Scroll/)?j[0]:j[1];var k=c.parentNode;var h=c.className.match(/ScrollTop/)?"Top":"Bottom";a.pageMenuItem(k,h)}else{var d=[];if(j[0].params){for(var f=0;f<j[0].params.length;f++){if(j[0].params[f]=="event"){d.push(g)}else{if(j[0].params[f]=="component"){d.push(j)}else{d.push(j[0].params[f])}}}}if(a[j[0].click]){a[j[0].click].apply(a,d);var m=j[1].firstChild.src;if(m.match("unchecked.png")){j[1].firstChild.src=m.replace("unchecked.png","checked.png")}else{if(m.match("checked.png")){j[1].firstChild.src=m.replace("checked.png","unchecked.png")}else{if(m.match("eye-minus-icon.png")){j[1].firstChild.src=m.replace("eye-minus-icon.png","eye-plus-icon.png")}else{if(m.match("eye-plus-icon.png")){j[1].firstChild.src=m.replace("eye-plus-icon.png","eye-minus-icon.png")}else{if(m.match("radio_on.png")){a.resetRadioMenuItem(j[2].firstChild.childNodes);if(d[1]&&d[1].match(/xAxis|yAxis|zAxis/)){j[1].firstChild.src=m.replace("radio_off.png","radio_on.png")}else{j[1].firstChild.src=m.replace("radio_on.png","radio_off.png")}}else{if(m.match("radio_off.png")){a.resetRadioMenuItem(j[2].firstChild.childNodes);j[1].firstChild.src=m.replace("radio_off.png","radio_on.png")}}}}}}}}return false}else{return false}}}(this);this.resetRadioMenuItem=function(b){for(var c=0;c<b.length;c++){var a=b[c].firstChild.firstChild;a.src=this.imageDir+"radio_off.png"}};this.adjustMenuItemPosition=function(a,k,j){var b,q;var n=this.remoteParentId?this.$(this.remoteParentId):this.$("container-"+this.target);var o=n.clientWidth;var f=n.clientHeight;var p=a.clientWidth;var g=a.clientHeight;if(k){b=k.offsetLeft+k.offsetWidth-5;if(b>o-p){b=k.offsetLeft-p+5}q=k.offsetTop+j.offsetTop}else{b=a.offsetLeft;q=a.offsetTop}a.style.left=Math.min(o-p,b)+"px";a.style.top=Math.min(f-g,q)+"px"};this.mouseoverMenuItem=function(a){return function(g){if(!g){g=window.event}var f=a.getMenuItemComp(g);if(f[0].className.match(/Scroll/)||f[1].className.match(/Scroll/)){var j=f[0].className.match(/Scroll/)?f[0]:f[1];j.className+="Active";return false}a.hideMenusRecursively(f[2].firstChild.childNodes);f[0].className="CanvasXpressListItemActive";if(f[1].menu){var b=a.$(f[1].menu);var h=f[2];b.style.left="0px";b.style.top="0px";b.style.display="block";a.adjustMenuItemPosition(b,h,f[1]);f[1].className="CanvasXpressListItemAArrowActive"}else{f[1].className="CanvasXpressListItemAActive"}return false}}(this);this.mouseoutMenuItem=function(a){return function(j){if(!j){j=window.event}if(a.fastScrollMenuOn){a.fastScrollMenuOn=false;clearInterval(a.fastScrollMenu)}var d,c,b,r,p,o,l,k;var q=a.adjustedCoordinates(j);if(q){var h=a.$("north-container-"+a.target);var g=a.$("west-container-"+a.target);q.x+=g.offsetWidth;q.y+=h.offsetHeight;var n=a.getMenuItemComp(j);if(n[1]&&n[1].menu){var f=a.$(n[1].menu);d=f.offsetLeft;p=f.offsetTop;c=d+f.offsetWidth;o=p+f.offsetHeight;if(q.x>=d&&q.x<=c&&q.y>=p&&q.y<=o){return false}a.hideMenu(n,f)}else{a.hideMenu(n)}}return false}}(this);this.mousedownMenuItemColor=function(a){return function(d){if(!d){d=window.event}var b=a.getTargetEvent(d);var c=a.getMenuItemComp(d);if(b.id&&b.id.match(/-cX-List-Item-Color-Palete-/)){a.changingColorItemOn="palette";if(a.colorHSV[2]==0){a.colorFromHsv(null,null,1);a.colorizeCurrentItemColor(c[0]);var f=a.$(c[0].saturationCurrent);if(f){f.style.top="-108px"}}a.updateColorItemValue(c[0],d);a.colorizeSaturationItemColor(c[0])}else{if(b.parentNode.id&&b.parentNode.id.match(/-cX-List-Item-Color-Saturation-/)){a.changingColorItemOn="saturation";a.updateColorItemValue(c[0],d)}}a.cancelEvent(d);return false}}(this);this.mousedownMenuItem=function(a){return function(b){if(!b){b=window.event}a.fastScrollMenuOn=true;a.fastScrollMenu=setInterval(function(){a.clickMenuItem(b)},100);return false}}(this);this.mouseupMenuItem=function(a){return function(b){if(!b){b=window.event}if(a.fastScrollMenuOn){a.fastScrollMenuOn=false;clearInterval(a.fastScrollMenu)}}}(this);this.mousewheelMenuItem=function(a){return function(g){if(!g){g=window.event}a.cancelEvent(g);var h=0;if(g.wheelDelta){h=g.wheelDelta;if(window.opera){h=-h}}else{if(g.detail){h=-g.detail}}if(h){var b=a.getTargetEvent(g);var f=a.getMenuItemComp(g);var c=f[0].parentNode;if(h>0){a.pageMenuItem(c,"Top")}else{a.pageMenuItem(c,"Bottom")}}return false}}(this);this.getMenuItemComp=function(b){var a=this.getTargetEvent(b);while(a&&a.tagName&&!a.tagName.match(/li/i)){a=a.parentNode}return[a,a.firstChild,a.parentNode.parentNode]};this.hideMenu=function(a,b){if(a){if(a[0].className.match(/Scroll/)||a[1].className.match(/Scroll/)){var d=a[0].className.match(/Scroll/)?a[0]:a[1];d.className=d.className.replace("Active","")}else{if(a[1].menu){a[1].className="CanvasXpressListItemAArrow"}else{a[1].className="CanvasXpressListItemA"}a[0].className="CanvasXpressListItem"}}if(b){b.style.display="none"}};this.hideMenusRecursively=function(e){for(var f=0;f<e.length;f++){var c=e[f];if(!c.className.match(/Scroll|ItemSep/)){var d=c.firstChild;var b=d.menu?this.$(d.menu):false;if(b){this.hideMenusRecursively(b.firstChild.childNodes)}this.hideMenu([c,d],b)}}};this.removeMenus=function(k){var f=[];if(this.skipHeaderMouseout){this.skipHeaderMouseout.className="CanvasXpressTableCellHead";this.skipHeaderMouseout.firstChild.firstChild.className="CanvasXpressTableCellHead";this.skipHeaderMouseout=false}if(!k){var c=this.$("north-wrapper-"+this.target);if(c){var h=c.getElementsByTagName("div");for(var g=0;g<h.length;g++){if(h[g].className=="CanvasXpressMenu"){f.unshift(this.$(h[g].id))}}}this.menuIndex=10000}else{f.push(this.$(this.target+"-cX-Menu-"+k))}if(f.length>0){for(var g=0;g<f.length;g++){var a=f[g];var b=a.getElementsByTagName("li");for(var e=0;e<b.length;e++){if(b[e].className!="CanvasXpressListItemSep"){this.addRemoveItemListeners("removeEvtListener",b[e])}}a.parentNode.removeChild(a)}}};this.getAxesMenu=function(){if(this.graphType=="Scatter2D"){var n=[];var m=[];var c=this.getObjectArray(this.xAxis);var b=this.getObjectArray(this.yAxis);for(var r=0;r<this.data.y.smps.length;r++){n.push([this.data.y.smps[r],c[this.data.y.smps[r]]?"checked.png":"unchecked.png","changeSampleInAxis",[this.data.y.smps[r],"xAxis"]]);m.push([this.data.y.smps[r],b[this.data.y.smps[r]]?"checked.png":"unchecked.png","changeSampleInAxis",[this.data.y.smps[r],"yAxis"]])}var h=[];h.push([this.xAxisShow?"Hide Axis":"Show Axis",this.xAxisShow?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["xAxisShow"]]);h.push(["Set Min","minimum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMinX"]]]]);h.push(["Set Max","maximum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMaxX"]]]]);h.push(["Exact Range","exact_value.png","toggleAttribute",["xAxisExact"]]);h.push(["Format","format.png",false,false,false,[["-text-","changeTextColorAttribute",["xAxisTickFormat"]]]]);h.push(["Samples","samples.png",false,false,false,n]);var g=[];g.push([this.yAxisShow?"Hide Axis":"Show Axis",this.yAxisShow?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["yAxisShow"]]);g.push(["Set Min","minimum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMinY"]]]]);g.push(["Set Max","maximum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMaxY"]]]]);g.push(["Exact Range","exact_value.png","toggleAttribute",["yAxisExact"]]);g.push(["Format","format.png",false,false,false,[["-text-","changeTextColorAttribute",["yAxisTickFormat"]]]]);g.push(["Samples","samples.png",false,false,false,m]);var j=[];j.push(["X-Axis","x_axis.png",false,false,false,h]);j.push(["Y-Axis","y_axis.png",false,false,false,g]);j.push(["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["axisTickColor"]]]]);j.push(["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("axisTick")]);return j}else{if(this.graphType=="Scatter3D"||this.graphType=="ScatterBubble2D"||this.is3DPlot){var n=[];var m=[];var l=[];var c=this.getObjectArray(this.xAxis);var b=this.getObjectArray(this.yAxis);var a=this.getObjectArray(this.zAxis);for(var r=0;r<this.data.y.smps.length;r++){n.push([this.data.y.smps[r],c[this.data.y.smps[r]]?"radio_on.png":"radio_off.png","changeSampleInAxis",[this.data.y.smps[r],"xAxis"]]);m.push([this.data.y.smps[r],b[this.data.y.smps[r]]?"radio_on.png":"radio_off.png","changeSampleInAxis",[this.data.y.smps[r],"yAxis"]]);l.push([this.data.y.smps[r],a[this.data.y.smps[r]]?"radio_on.png":"radio_off.png","changeSampleInAxis",[this.data.y.smps[r],"zAxis"]])}var h=[];h.push([this.xAxisShow?"Hide Axis":"Show Axis",this.xAxisShow?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["xAxisShow"]]);h.push(["Set Min","minimum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMinX"]]]]);h.push(["Set Max","maximum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMaxX"]]]]);h.push(["Exact Range","exact_value.png","toggleAttribute",["xAxisExact"]]);h.push(["Format","format.png",false,false,false,[["-text-","changeTextColorAttribute",["xAxisTickFormat"]]]]);h.push(["Samples","samples.png",false,false,false,n]);var g=[];g.push([this.yAxisShow?"Hide Axis":"Show Axis",this.yAxisShow?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["yAxisShow"]]);g.push(["Set Min","minimum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMinY"]]]]);g.push(["Set Max","maximum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMaxY"]]]]);g.push(["Exact Range","exact_value.png","toggleAttribute",["yAxisExact"]]);g.push(["Format","format.png",false,false,false,[["-text-","changeTextColorAttribute",["yAxisTickFormat"]]]]);g.push(["Samples","samples.png",false,false,false,m]);var e=[];e.push([this.zAxisShow?"Hide Axis":"Show Axis",this.zAxisShow?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["zAxisShow"]]);e.push(["Set Min","minimum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMinZ"]]]]);e.push(["Set Max","maximum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMaxZ"]]]]);e.push(["Exact Range","exact_value.png","toggleAttribute",["zAxisExact"]]);e.push(["Format","format.png",false,false,false,[["-text-","changeTextColorAttribute",["zAxisTickFormat"]]]]);e.push(["Samples","samples.png",false,false,false,l]);var j=[];j.push(["X-Axis","x_axis.png",false,false,false,h]);j.push(["Y-Axis","y_axis.png",false,false,false,g]);j.push(["Z-Axis","z_axis.png",false,false,false,e]);j.push(["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["axisTickColor"]]]]);j.push(["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("axisTick")]);return j}else{if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)){var u=[];var q=[];var o=this.getObjectArray(this.data.a.xAxis);var d=this.getObjectArray(this.data.a.xAxis2);for(var r=0;r<this.data.y.vars.length;r++){u.push([this.data.y.vars[r],o[this.data.y.vars[r]]?"checked.png":"unchecked.png","changeVariableInAxis",[this.data.y.vars[r],"xAxis"]]);q.push([this.data.y.vars[r],d[this.data.y.vars[r]]?"checked.png":"unchecked.png","changeVariableInAxis",[this.data.y.vars[r],"xAxis2"]])}var t=[];t.push([this.xAxisShow?"Hide Axis":"Show Axis",this.xAxisShow?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["xAxisShow"]]);t.push(["Set Min","minimum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMinX"]]]]);t.push(["Set Max","maximum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMaxX"]]]]);t.push(["Exact Range","exact_value.png","toggleAttribute",["xAxisExact"]]);t.push(["Format","format.png",false,false,false,[["-text-","changeTextColorAttribute",["xAxisTickFormat"]]]]);t.push(["Variables","variables.png",false,false,false,u]);var k=[];k.push([this.xAxis2Show?"Hide Axis":"Show Axis",this.xAxis2Show?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["xAxis2Show"]]);k.push(["Set Min","minimum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMinX2"]]]]);k.push(["Set Max","maximum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMaxX2"]]]]);k.push(["Exact Range","exact_value.png","toggleAttribute",["xAxis2Exact"]]);k.push(["Format","format.png",false,false,false,[["-text-","changeTextColorAttribute",["xAxis2TickFormat"]]]]);k.push(["Variables","variables.png",false,false,false,q]);var j=[];j.push(["First Axis","first_axis.png",false,false,false,t]);j.push(["Second Axis","second_axis.png",false,false,false,k]);j.push(["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["axisTickColor"]]]]);j.push(["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("axisTick")]);return j}else{var t=[[this.xAxisShow?"Hide Axis":"Show Axis",this.xAxisShow?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["xAxisShow"]]];var k=[[this.xAxis2Show?"Hide Axis":"Show Axis",this.xAxis2Show?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["xAxis2Show"]]];var p=[["Set Min","minimum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMinX"]]]],["Set Max","maximum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMaxX"]]]],["Exact Range","exact_value.png","toggleAttribute",["xAxisExact"]]];return[["First Axis","first_axis.png",false,false,false,t],["Second Axis","second_axis.png",false,false,false,k],["Range","range.png",false,false,false,p],["Format","format.png",false,false,false,[["-text-","changeTextColorAttribute",["xAxisTickFormat"]]]],["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["axisTickColor"]]]],["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("axisTick")]]}}}};this.getPlotAreaOneMenu=function(){var h=[];h.push(["Solid","axes_tick_type_solid.png","changeAttribute",["xAxisTickStyle","solid"]]);h.push(["Dotted","axes_tick_type_dotted.png","changeAttribute",["xAxisTickStyle","dotted"]]);var b=[[this.xAxisMinorTicks?"Hide Minor Ticks":"Show Minor Ticks",this.xAxisMinorTicks?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["xAxisMinorTicks"]]];var f=[];f.push(["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["xAxisTickColor"]]]]);f.push(["Minor Ticks","axes_minor_ticks.png",false,false,false,b]);f.push(["Number","edit-number.png",false,false,false,[["-text-","changeTextColorAttribute",["xAxisTicks"]]]]);f.push(["Style","axes_tick_type.png",false,false,false,h]);var d=[];d.push(["Wider","width_space_wider.png","setFontAttributeSize",["widthFactor","increase"]]);d.push(["Thinner","width_space_thinner.png","setFontAttributeSize",["widthFactor","decrease"]]);var e=[];e.push(["Farther","space_farther.png","setFontAttributeSize",["variableSeparationFactor","increase"]]);e.push(["Closer","space_closer.png","setFontAttributeSize",["variableSeparationFactor","decrease"]]);var c=[];c.push(["Grid","grid.png",false,false,false,f]);if(this.graphType.match(/Dot|Boxplot/)){c.push(["Jitter","jitter.png","toggleAttribute",["jitter"]])}if(this.graphType=="Boxplot"){c.push(["Plot Data","bpdata.png","toggleAttribute",["showBoxplotOriginalData"]])}c.push(["Space","space_width.png",false,false,false,e]);c.push(["Width","width_space.png",false,false,false,d]);return c};this.getGridMenu=function(){var a,d,g,j,c,e,h,b,f;if(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D"){d=[["Solid","axes_tick_type_solid.png","changeAttribute",["xAxisTickStyle","solid"]],["Dotted","axes_tick_type_dotted.png","changeAttribute",["xAxisTickStyle","dotted"]]];g=[[this.xAxisMinorTicks?"Hide Minor Ticks":"Show Minor Ticks",this.xAxisMinorTicks?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["xAxisMinorTicks"]]];j=[["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["xAxisTickColor"]]]],["Minor Ticks","axes_minor_ticks.png",false,false,false,g],["Number","edit-number.png",false,false,false,[["-text-","changeTextColorAttribute",["xAxisTicks"]]]],["Style","axes_tick_type.png",false,false,false,d]];c=[["Solid","axes_tick_type_solid.png","changeAttribute",["yAxisTickStyle","solid"]],["Dotted","axes_tick_type_dotted.png","changeAttribute",["yAxisTickStyle","dotted"]]];e=[[this.yAxisMinorTicks?"Hide Minor Ticks":"Show Minor Ticks",this.yAxisMinorTicks?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["yAxisMinorTicks"]]];h=[["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["yAxisTickColor"]]]],["Minor Ticks","axes_minor_ticks.png",false,false,false,e],["Number","edit-number.png",false,false,false,[["-text-","changeTextColorAttribute",["yAxisTicks"]]]],["Style","axes_tick_type.png",false,false,false,c]];a=[["X-Axis","x_grid_s.png",false,false,false,j],["Y-Axis","y_grid_s.png",false,false,false,h]]}else{if(this.graphType=="Scatter3D"||this.is3DPlot){d=[["Solid","axes_tick_type_solid.png","changeAttribute",["xAxisTickStyle","solid"]],["Dotted","axes_tick_type_dotted.png","changeAttribute",["xAxisTickStyle","dotted"]]];j=[["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["xAxisTickColor"]]]],["Style","axes_tick_type.png",false,false,false,d]];c=[["Solid","axes_tick_type_solid.png","changeAttribute",["yAxisTickStyle","solid"]],["Dotted","axes_tick_type_dotted.png","changeAttribute",["yAxisTickStyle","dotted"]]];h=[["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["yAxisTickColor"]]]],["Style","axes_tick_type.png",false,false,false,c]];b=[["Solid","axes_tick_type_solid.png","changeAttribute",["zAxisTickStyle","solid"]],["Dotted","axes_tick_type_dotted.png","changeAttribute",["zAxisTickStyle","dotted"]]];f=[["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["zAxisTickColor"]]]],["Style","axes_tick_type.png",false,false,false,b]];a=[["X-Axis","x_grid_s.png",false,false,false,j],["Y-Axis","y_grid_s.png",false,false,false,h],["Z-Axis","z_grid_s.png",false,false,false,f]]}}return a};this.getAxesTitleMenu=function(){var b=[["Text","normal_font.png",false,false,false,[["-text-","changeTextColorAttribute",["xAxisTitle"]]]]];var a=[["Text","normal_font.png",false,false,false,[["-text-","changeTextColorAttribute",["xAxis2Title"]]]]];var d=[["Text","normal_font.png",false,false,false,[["-text-","changeTextColorAttribute",["yAxisTitle"]]]]];var c=[["Text","normal_font.png",false,false,false,[["-text-","changeTextColorAttribute",["zAxisTitle"]]]]];if(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D"){return[["X-Axis","x_axis_title_s.png",false,false,false,b],["Y-Axis","y_axis_title_s.png",false,false,false,d],["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["axisTitleColor"]]]],["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("axisTitle")]]}else{if(this.graphType=="Scatter3D"||this.is3DPlot){return[["X-Axis","x_axis_title_s.png",false,false,false,b],["Y-Axis","y_axis_title_s.png",false,false,false,d],["Z-Axis","z_axis_title_s.png",false,false,false,c],["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["axisTitleColor"]]]],["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("axisTitle")]]}else{if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)){return[["First Axis","first_axis_title.png",false,false,false,b],["Second Axis","second_axis_title.png",false,false,false,a],["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["axisTitleColor"]]]],["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("axisTitle")]]}else{return[["Text","normal_font.png",false,false,false,[["-text-","changeTextColorAttribute",["xAxisTitle"]]]],["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["axisTitleColor"]]]],["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("axisTitle")]]}}}};this.getTitleSubtitleMenu=function(){var a=[["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["titleColor"]]]],["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("title",true)],["Text","normal_font.png",false,false,false,[["-text-","changeTextColorAttribute",["title"]]]]];var b=[["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["subtitleColor"]]]],["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("subtitle",true)],["Text","normal_font.png",false,false,false,[["-text-","changeTextColorAttribute",["subtitle"]]]]];if(this.graphType.match(/scatter/i)||this.is3DPlot){return[["Title","title_s.png",false,false,false,a],["Subtitle","subtitle_s.png",false,false,false,b]]}else{return[["Title",this.graphType=="Heatmap"?"title_h.png":"title.png",false,false,false,a],["Subtitle",this.graphType=="Heatmap"?"subtitle_h.png":"subtitle.png",false,false,false,b]]}};this.getLegendMenu=function(){var c=[["Bottom","bottom.png","changeAttribute",["legendPosition","bottom"]],["Right","right.png","changeAttribute",["legendPosition","right"]]];var a=[["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["legendBoxColor"]]]],[this.legendBox?"Hide Border":"Show Border",this.legendBox?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["legendBox"]]];return[["Border","border.png",false,false,false,a],["Background","background.png",false,false,false,[["-color-","changeTextColorAttribute",["legendBackgroundColor"]]]],["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["legendColor"]]]],["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("legend")],["Position","position_right_bottom.png",false,false,false,c],[this.showLegend?"Hide Legend":"Show Legend",this.showLegend?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["showLegend"]]]};this.getIndicatorMenu=function(){};this.getOverlaysMenu=function(){var g=[];var f=[];var e=[];var d={};var b={};var a=false;if(this.graphType=="Heatmap"&&this.data.z){for(var c=0;c<this.varOverlays.length;c++){b[this.varOverlays[c]]=true;a=true}for(var c in this.data.z){e.push([c,b[c]?"checked.png":"unchecked.png","showVariableOverlays",[c]])}g.push(["Variable Overlays","overlays_variables.png",false,false,false,e]);g.push(["-"])}if(this.data.x){for(var c=0;c<this.smpOverlays.length;c++){d[this.smpOverlays[c]]=true;a=true}for(var c in this.data.x){f.push([c,d[c]?"checked.png":"unchecked.png","showSampleOverlays",[c]])}g.push(["Sample Overlays",this.graphType=="Heatmap"?"overlays_samples_h.png":"overlays_samples_1.png",false,false,false,f]);g.push(["-"])}g.push(["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["overlayFontColor"]]]]);g.push(["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("overlay")]);g.push(["Width","width_space.png",false,false,false,[["-text-","changeTextColorAttribute",["overlaysWidth"]]]]);if(this.data.x||this.data.z){g.push([this.showOverlays?"Hide Overlays":"Show Overlays",this.showOverlays?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["showOverlays"]])}g.push(["More","more.png","showConfiguratorCategory",["event","Overlays"]]);return g};this.getGroupSamplesMenu=function(){if(this.data.x){var c=[];var a={};for(var b=0;b<this.groupingFactors.length;b++){a[this.groupingFactors[b]]=true}for(b in this.data.x){c.push([b,a[b]?"checked.png":"unchecked.png","showSampleGroups",[b]])}return c}else{return false}};this.getSmpLabelMenu=function(e){var d={};var c=[];var f=this.isGroupedData?this.data.w:this.data.y;for(var b=0;b<this.highlightSmp.length;b++){d[this.highlightSmp[b]]=true}for(var b=0;b<f.smps.length;b++){c.push([f.smps[b],d[f.smps[b]]?"checked.png":"unchecked.png","modifyObjectArray",[f.smps[b],false,"highlightSmp",true,true]])}var a=[["Samples","samples.png",false,false,false,c],["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["smpHighlightColor"]]]]];return[["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["smpLabelFontColor"]]]],["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("smpLabel")],["Highlight",this.graphType=="Heatmap"?"highlight_sample_labels_h.png":"highlight_sample_labels_1.png",false,false,false,a],["Interval","edit-number.png",false,false,false,[["-text-","changeTextColorAttribute",["smpLabelInterval"]]]],["Rotate","rotate_clockwise.png",false,false,false,[["-text-","changeTextColorAttribute",["smpLabelRotate"]]]],[this.showSampleNames?"Hide Labels":"Show Labels",this.showSampleNames?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["showSampleNames"]]]};this.getVarLabelMenu=function(f){var e={};var d=[];var b=this.data.y.vars;for(var c=0;c<this.highlightVar.length;c++){e[this.highlightVar[c]]=true}for(var c=0;c<b.length;c++){d.push([b[c],e[b[c]]?"checked.png":"unchecked.png","modifyObjectArray",[b[c],false,"highlightVar",true,true]])}var a=[["Variable","variables.png",false,false,false,d],["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["varHighlightColor"]]]]];return[["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["varLabelFontColor"]]]],["Font","font_size_style.png",false,false,false,this.getFontStyleMenu("varLabel")],["Highlight","highlight_variable_labels_h.png",false,false,false,a],["Interval","edit-number.png",false,false,false,[["-text-","changeTextColorAttribute",["varLabelInterval"]]]],["Rotate","rotate_clockwise.png",false,false,false,[["-text-","changeTextColorAttribute",["varLabelRotate"]]]],[this.showVariableNames?"Hide Labels":"Show Labels",this.showVariableNames?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["showVariableNames"]]]};this.getGraphPartMenu=function(b,a){return[["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",[b+(a?"FontColor":"Color")]]]],["Font","font_size_style.png",false,false,false,this.getFontStyleMenu(b)],["Text","normal_font.png",false,false,false,[["-text-","changeTextColorAttribute",[b]]]]]};this.getFontStyleMenu=function(b,a){if(a){return[["Bigger","bigger_font.png","setFontAttributeSize",[b+"Height","increase"]],["Smaller","smaller_font.png","setFontAttributeSize",[b+"Height","decrease"]],["Normal","normal_font.png","setFontAttributeStyle",[b+"FontStyle","normal"]],["Bold","bold_font.png","setFontAttributeStyle",[b+"FontStyle","bold"]],["Italic","italic_font.png","setFontAttributeStyle",[b+"FontStyle","italic"]]]}else{return[["Bigger","bigger_font.png","setFontAttributeSize",[b+"ScaleFontFactor","increase"]],["Smaller","smaller_font.png","setFontAttributeSize",[b+"ScaleFontFactor","decrease"]],["Normal","normal_font.png","setFontAttributeStyle",[b+"FontStyle","normal"]],["Bold","bold_font.png","setFontAttributeStyle",[b+"FontStyle","bold"]],["Italic","italic_font.png","setFontAttributeStyle",[b+"FontStyle","italic"]]]}};this.getDataPointAttributesMenu=function(){var g=[];var d=[];var b=[];var a=[];var c=[];var f=this.graphType.match(/scatter/i)?this.data.z:this.data.x;for(e in f){g.push([e,e==this.shapeBy?"radio_on.png":"radio_off.png","changeAttribute",["shapeBy",e]]);d.push([e,e==this.colorBy?"radio_on.png":"radio_off.png","changeAttribute",["colorBy",e]]);b.push([e,e==this.sizeBy?"radio_on.png":"radio_off.png","changeAttribute",["sizeBy",e]]);c.push([e,e==this.patternBy?"radio_on.png":"radio_off.png","changeAttribute",["patternBy",e]])}g.push(["-"]);d.push(["-"]);b.push(["-"]);c.push(["-"]);var e="variable";g.push(["Variable",e==this.shapeBy?"radio_on.png":"radio_off.png","changeAttribute",["shapeBy",e]]);d.push(["Variable",e==this.colorBy?"radio_on.png":"radio_off.png","changeAttribute",["colorBy",e]]);b.push(["Variable",e==this.sizeBy?"radio_on.png":"radio_off.png","changeAttribute",["sizeBy",e]]);c.push(["Variable",e==this.patternBy?"radio_on.png":"radio_off.png","changeAttribute",["patternBy",e]]);if(!this.graphType.match(/scatter/i)&&this.data.z){g.push(["-"]);d.push(["-"]);b.push(["-"]);c.push(["-"]);for(e in this.data.z){g.push([e,e==this.shapeBy?"radio_on.png":"radio_off.png","changeAttribute",["shapeBy",e]]);d.push([e,e==this.colorBy?"radio_on.png":"radio_off.png","changeAttribute",["colorBy",e]]);b.push([e,e==this.sizeBy?"radio_on.png":"radio_off.png","changeAttribute",["sizeBy",e]]);c.push([e,e==this.patternBy?"radio_on.png":"radio_off.png","changeAttribute",["patternBy",e]])}}if(this.graphType.match(/scatter/i)||this.is3DPlot){return[["Color By","colors.png",false,false,false,d],["Shape By","shapes.png",false,false,false,g],["Size By","sizes.png",false,false,false,b],["Pattern By","patterns.png",false,false,false,c],["Connect By","connects.png",false,false,false,a]]}else{if(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){return[["Color By","colors.png",false,false,false,d],["Shape By","shapes.png",false,false,false,g],["Size By","sizes.png",false,false,false,b],["Pattern By","patterns.png",false,false,false,c]]}else{if(this.graphType=="Bar"){return[["Color By","colors.png",false,false,false,d],["Pattern By","patterns.png",false,false,false,c]]}else{return[["Pattern By","patterns.png",false,false,false,c]]}}}};this.getDendrogramsMenu=function(){var a=[];if(this.graphType=="Heatmap"){a.push(["Cluster Variable","cluster_variables.png","clusterVariables"]);a.push(["K-Means Variable","kmeans_variables.png","kmeansVariables"]);if(this.varDendrogram){if(this.showVarDendrogram){a.push(["Hide Dendrogram","eye-minus-icon.png","showHideDendrogram",["showVarDendrogram"]])}else{a.push(["Show Dendrogram","eye-plus-icon.png","showHideDendrogram",["showVarDendrogram"]])}}a.push(["-"])}a.push(["Cluster Samples","cluster_samples.png","clusterSamples"]);a.push(["K-Means Samples","kmeans_samples.png","kmeansSamples"]);if(this.smpDendrogram){if(this.showSmpDendrogram){a.push(["Hide Dendrogram","eye-minus-icon.png","showHideDendrogram",["showSmpDendrogram"]])}else{a.push(["Show Dendrogram","eye-plus-icon.png","showHideDendrogram",["showSmpDendrogram"]])}}a.push(["-"]);a.push(["More","more.png","showConfiguratorCategory",["event","Clustering"]]);return a};this.getGeneralMenu=function(){var c=[];c.push(["Area","area.png","changeAttribute",["graphType","Area"],"Shit + Alt + A"]);c.push(["Area Line","area_line.png","changeAttribute",["graphType","AreaLine"],"Shit + Alt + F"]);c.push(["Bar","bar.png","changeAttribute",["graphType","Bar"],"Shit + Alt + B"]);c.push(["Bar Line","bar_line.png","changeAttribute",["graphType","BarLine"],"Shit + Alt + C"]);c.push(["Boxplot","boxplot.png","changeAttribute",["graphType","Boxplot"],"Shit + Alt + I"]);c.push(["Correlation","correlation.png","changeAttribute",["graphType","Correlation"],"Shit + Alt + X"]);c.push(["Dot Line","dotplot_line.png","changeAttribute",["graphType","DotLine"],"Shit + Alt + E"]);c.push(["Dotplot","dotplot.png","changeAttribute",["graphType","Dotplot"],"Shit + Alt + D"]);c.push(["Heatmap","heatmap.png","changeAttribute",["graphType","Heatmap"],"Shit + Alt + H"]);c.push(["Line","line.png","changeAttribute",["graphType","Line"],"Shit + Alt + L"]);c.push(["Pie Chart","pie.png","changeAttribute",["graphType","Pie"],"Shit + Alt + P"]);if(this.data.y.smps.length>1){c.push(["Scatter 2D","scatter2d.png","changeAttribute",["graphType","Scatter2D"],"Shit + Alt + 2"])}if(this.data.y.smps.length>2){c.push(["Scatter Bubble 2D","scatter_bubble2d.png","changeAttribute",["graphType","ScatterBubble2D"],"Shit + Alt + 4"]);c.push(["Scatter 3D","scatter3d.png","changeAttribute",["graphType","Scatter3D"],"Shit + Alt + 3"])}c.push(["Stacked","stacked.png","changeAttribute",["graphType","Stacked"],"Shit + Alt + S"]);c.push(["Stacked Line","stacked_line.png","changeAttribute",["graphType","StackedLine"],"Shit + Alt + U"]);c.push(["Stacked Percent","stacked_percent.png","changeAttribute",["graphType","StackedPercent"],"Shit + Alt + T"]);c.push(["Stacked Percent Line","stacked_percent_line.png","changeAttribute",["graphType","StackedPercentLine"],"Shit + Alt + W"]);var o=[];o.push(["Horizontal","graph_orientation_horizontal.png","changeAttribute",["graphOrientation","horizontal"]]);o.push(["Vertical","graph_orientation_vertical.png","changeAttribute",["graphOrientation","vertical"]]);var k=[];k.push(["General","margin.png",false,false,false,[["-text-","changeTextColorAttribute",["margin"]]]]);k.push(["-"]);k.push(["Bottom","margin_bottom.png",false,false,false,[["-text-","changeTextColorAttribute",["marginBottom"]]]]);k.push(["Left","margin_left.png",false,false,false,[["-text-","changeTextColorAttribute",["marginLeft"]]]]);k.push(["Top","margin_top.png",false,false,false,[["-text-","changeTextColorAttribute",["marginTop"]]]]);k.push(["Right","margin_right.png",false,false,false,[["-text-","changeTextColorAttribute",["marginRight"]]]]);var h=[];h.push(["Objects","shadow.png","toggleAttribute",["showShadow"]]);h.push(["Text","text_shadow.png","toggleAttribute",["showTextShadow"]]);h.push(["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["shadowColor"]]]]);h.push(["More","more.png","showConfiguratorCategory",["event","Shadows"]]);var d=[];d.push(["Color","colors.png",false,false,false,[["-color-","changeTextColorAttribute",["canvasBoxColor"]]]]);d.push([this.canvasBox?"Hide Border":"Show Border",this.canvasBox?"eye-minus-icon.png":"eye-plus-icon.png","toggleAttribute",["canvasBox"]]);var l=[];l.push(["Linear","gradient_vertical.png","changeAttribute",["gradientType","linear"]]);l.push(["Radial","gradient_radial.png","changeAttribute",["gradientType","radial"]]);var p=[];p.push(["Horizontal","gradient_horizontal.png","changeAttribute",["gradientOrientation","horizontal"]]);p.push(["Vertical","gradient_vertical.png","changeAttribute",["gradientOrientation","vertical"]]);var g=[];g.push(["Gradient","gradient_toggle.png","toggleAttribute",["gradient"]]);g.push(["Orientation","gradient_orientation.png",false,false,false,p]);g.push(["Type","gradient_type.png",false,false,false,l]);g.push(["-"]);g.push(["More","more.png","showConfiguratorCategory",["event","Gradients"]]);var m=[];m.push(["Solid","background.png","changeAttribute",["backgroundType","solid","solid"]]);m.push(["Gradient","background_gradient.png","changeAttribute",["backgroundType","gradient","gradient"]]);m.push(["Solid Window","background_window.png","changeAttribute",["backgroundType","window","window"]]);m.push(["Solid Window on Gradient","background_window_gradient.png","changeAttribute",["backgroundType","windowGradient","windowGradient"]]);m.push(["Gradient Window on Solid","background_gradient_window.png","changeAttribute",["backgroundType","windowSolidGradient","windowSolidGradient"]]);var j=[];j.push(["Type","background_type.png",false,false,false,m]);j.push(["-"]);j.push(["Area Solid","background.png",false,false,false,[["-color-","changeTextColorAttribute",["background"]]]]);j.push(["Area Gradient Start Color","background_gradient.png",false,false,false,[["-color-","changeTextColorAttribute",["backgroundGradient1Color"]]]]);j.push(["Area Gradient End Color","background_gradient.png",false,false,false,[["-color-","changeTextColorAttribute",["backgroundGradient2Color"]]]]);j.push(["-"]);j.push(["Window Solid","background_window.png",false,false,false,[["-color-","changeTextColorAttribute",["backgroundWindow"]]]]);j.push(["Window Gradient Start Color","background_gradient_window.png",false,false,false,[["-color-","changeTextColorAttribute",["backgroundWindowGradient1Color"]]]]);j.push(["Window Gradient End Color","background_gradient_window.png",false,false,false,[["-color-","changeTextColorAttribute",["backgroundWindowGradient2Color"]]]]);j.push(["-"]);j.push(["More","more.png","showConfiguratorCategory",["event","Background"]]);var n=[];n.push(["Courier",false,"changeAttribute",["fontName","Courier","Courier"]]);n.push(["Arial",false,"changeAttribute",["fontName","Arial","Arial"]]);n.push(["Verdana",false,"changeAttribute",["fontName","Verdana","Verdana"]]);n.push(["-"]);n.push(["More","more.png","showConfiguratorCategory",["event","Text"]]);var b=[];if(this.data.z){for(i in this.data.z){b.push([i,i==this.segregateVariablesBy?"radio_on.png":"radio_off.png","segregateVariables",[i,false,true]])}}var f=[];if(this.data.x){for(i in this.data.x){f.push([i,i==this.segregateSamplesBy?"radio_on.png":"radio_off.png","segregateSamples",[i,false,true]])}}var e=[];if(!this.graphType.match(/Scatter/)&&!this.is3DPlot){if(this.data.x){e.push(["Segregate Samples By","samples.png",false,false,false,f])}if(this.data.z){e.push(["Segregate Variables By","variables.png",false,false,false,b])}}var a=[];a.push(["Background","background.png",false,false,false,j]);a.push(["Border","border.png",false,false,false,d]);a.push(["Font","font_size_style.png",false,false,false,n]);a.push(["Gradients","gradient_diagonal.png",false,false,false,g]);if(!this.graphType.match(/Scatter/)&&!this.is3DPlot){a.push(["Graph Orientation","graph_orientation.png",false,false,false,o])}a.push(["Graph Type","graph_type.png",false,false,false,c]);if(!this.graphType.match(/Scatter/)&&!this.is3DPlot){a.push(["Layout","segregate.png",false,false,false,e])}a.push(["Margins","margin.png",false,false,false,k]);a.push(["Shadows","shadow.png",false,false,false,h]);a.push(["Transparency","transparency.png",false,false,false,[["-text-","changeTextColorAttribute",["transparency"]]]]);return a};this.getDataMenu=function(){var e=[];var l=[];var j=[];var p=[];var k=[];var a={};var c=[];var d=[];var o=[];if(this.graphType.match(/Scatter/i)){for(var f=0;f<this.data.y.smps.length;f++){d.push([this.data.y.smps[f],"radio_off.png","switchSmpToAnnotation",[this.data.y.smps[f]]])}for(var m in this.data.z){if(this.zAnntType[m]=="Numeric"){o.push([m,"radio_off.png","switchAnnotationToSmp",[m]])}}l.push(["Sample to Annotation","switchb.png",false,false,false,d]);if(o.length>0){l.push(["Annotation to Sample","switchu.png",false,false,false,o])}}else{for(var f=0;f<this.data.y.vars.length;f++){d.push([this.data.y.vars[f],"radio_off.png","switchVarToAnnotation",[this.data.y.vars[f]]])}for(var m in this.data.x){if(this.xAnntType[m]=="Numeric"){o.push([m,"radio_off.png","switchAnnotationToVar",[m]])}}l.push(["Variable to Annotation","switchb.png",false,false,false,d]);if(o.length>0){l.push(["Annotation to Variable","switchu.png",false,false,false,o])}}if(this.graphType.match(/Scatter/i)){}c.push([2,this.transformBase=="2"?"radio_on.png":"radio_off.png","changeAttribute",["transformBase","2",2]]);c.push([10,this.transformBase=="10"?"radio_on.png":"radio_off.png","changeAttribute",["transformBase","10",2]]);for(var f=0;f<this.data.y.smps.length;f++){j.push([this.data.y.smps[f],this.ratioSampleReference==this.data.y.smps[f]?"radio_on.png":"radio_off.png","changeTransformRatio",["sample",this.data.y.smps[f]]])}e.push(["To Sample","samples.png",false,false,false,j]);if(this.data.x&&this.isGroupedData){for(f in this.data.x){p.push([f,this.ratioGroupReference==f?"radio_on.png":"radio_off.png","changeTransformRatio",["group",f]])}e.push(["To Group","groups.png",false,false,false,p]);if(this.ratioGroupReference&&this.data.x.hasOwnProperty(this.ratioGroupReference)){for(var f=0;f<this.data.x[this.ratioGroupReference].length;f++){if(this.data.x[this.ratioGroupReference][f]!=null&&!a.hasOwnProperty(this.data.x[this.ratioGroupReference][f])){k.push([this.data.x[this.ratioGroupReference][f],this.ratioLevelReference==this.data.x[this.ratioGroupReference][f]?"radio_on.png":"radio_off.png","changeTransformRatio",["level",this.data.x[this.ratioGroupReference][f]]]);a[this.data.x[this.ratioGroupReference][f]]=true}}e.push(["To Level","levels.png",false,false,false,k])}}e.push(["-"]);e.push(["Log Base",this.transformBase=="2"?"log2.png":"log10.png",false,false,false,c]);var b=[["By Sample","samples.png","transform",["percentile","samples"]],["By Variable","variables.png","transform",["percentile","variables"]]];var g=[["By Sample","samples.png","transform",["zscore","samples"]],["By Variable","variables.png","transform",["zscore","variables"]]];var h=[];h.push(["Log Base 2","log2.png","transform",["log2"]]);h.push(["Log Base 10","log10.png","transform",["log10"]]);h.push(["Exp Base 2","exp2.png","transform",["exp2"]]);h.push(["Exp Base 10","exp10.png","transform",["exp10"]]);h.push(["Percentile","percent2.png",false,false,false,b]);h.push(["Z-Score","z_score.png",false,false,false,g]);h.push(["Ratio","ratio.png",false,false,false,e]);h.push(["-"]);h.push(["Reset","refresh_form.png","transform",["reset"]]);var n=[["Set Min","minimum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMinX"]]]],["Set Max","maximum_value.png",false,false,false,[["-text-","changeTextColorAttribute",["setMaxX"]]]],["Exact Range","exact_value.png","toggleAttribute",["xAxisExact"]]];if(this.graphType=="Heatmap"){return[["Range","range.png",false,false,false,n],["Transform","transform.png",false,false,false,h],["Transpose","transpose_data.png","transpose"],["Switch Data","switch.png",false,false,false,l]]}else{if(this.graphType.match(/Scatter/i)){return[["Transform","transform.png",false,false,false,h],["Transpose","transpose_data.png","transpose"],["Switch Data","switch.png",false,false,false,l]]}else{return[["Transform","transform.png",false,false,false,h],["Transpose","transpose_data.png","transpose"],["Switch Data","switch.png",false,false,false,l]]}}};this.getHistogramMenu=function(){var a=[];a.push(["Bin Number","edit-number.png",false,false,false,[["-text-","changeTextColorAttribute",["histogramBins","modifyHistogram"]]]]);a.push(["Remove Histogram","remove_histogram.png","removeHistogram"]);a.push(["Stagger Histograms","histogram_stagger.png","toggleAttribute",["histogramStagger","modifyHistogram"]]);a.push(["More","more.png","showConfiguratorCategory",["event","Histograms"]]);return a};this.getDOEMenu=function(){var d=[];var c=this.getKeys(this.dataStndBy.x);var a=this.getObjectArray(this.includeDOE);for(var b=0;b<c.length;b++){d.push([c[b],a[c[b]]?"checked.png":"unchecked.png","modifyDOE",[c[b]]])}return d};this.getCorrelationMenu=function(){var d=[];var a=[];var c=[];if(this.data.y.vars.length>3){d.push(["Samples","samples.png","correlateData"]);if(this.data.z){for(var b in this.data.z){if(this.isNumeric(this.data.z[b])){c.push([b,"radio_off.png","correlateData",[false,b]])}}d.push(["Variable Annotation","variables.png",false,false,false,c])}}if(this.data.y.smps.length>3){d.push(["Variables","variables.png","correlateData",[true]]);if(this.data.x){for(var b in this.data.x){if(this.isNumeric(this.data.x[b])){a.push([b,"radio_off.png","correlateData",[true,b]])}}d.push(["Sample Annotation","samples.png",false,false,false,a])}}return d};this.getConfigurationMenu=function(){var b={Bar:true,Line:true,Area:true,AreaLine:true,BarLine:true,Boxplot:true,Dotplot:true,DotLine:true,Heatmap:true,Treemap:true,TagCloud:true,Stacked:true,StackedLine:true,StackedPercent:true,StackedPercentLine:true,Candlestick:true};var a=[];if(b[this.graphType]&&!this.is3DPlot){if(this.graphType!="Heatmap"){a.push(["Axes","axis_1.png",false,false,false,this.getAxesMenu()]);a.push(["Axes Titles","axis_title_1.png",false,false,false,this.getAxesTitleMenu()])}a.push(["Citation",this.graphType=="Heatmap"?"citation_h.png":"citation_1.png",false,false,false,this.getGraphPartMenu("citation")]);a.push(["General",this.graphType=="Heatmap"?"general_h.png":"general_1.png",false,false,false,this.getGeneralMenu()]);if(this.graphType!="Heatmap"){a.push(["Legend","legends.png",false,false,false,this.getLegendMenu()])}if(this.graphType=="Heatmap"){if(this.data.x||this.data.z){a.push(["Overlays","overlays_samples_h.png",false,false,false,this.getOverlaysMenu()])}}else{if(this.data.x){a.push(["Overlays","overlays_samples_1.png",false,false,false,this.getOverlaysMenu()])}}if(this.graphType!="Heatmap"){a.push(["Plot Area","plot_area.png",false,false,false,this.getPlotAreaOneMenu()])}a.push(["Sample Labels",this.graphType=="Heatmap"?"sample_labels_h.png":"sample_labels_1.png",false,false,false,this.getSmpLabelMenu()]);a.push(["Samples Title",this.graphType=="Heatmap"?"sample_title_h.png":"sample_title_1.png",false,false,false,this.getGraphPartMenu("smpTitle",true)]);if(this.graphType=="Heatmap"){a.push(["Variable Labels","variable_labels_h.png",false,false,false,this.getVarLabelMenu()]);a.push(["Variables Title","variable_title_h.png",false,false,false,this.getGraphPartMenu("varTitle",true)])}a.push(["Title / Subtitle",this.graphType=="Heatmap"?"title_subtitle_h.png":"title_subtitle.png",false,false,false,this.getTitleSubtitleMenu()])}else{if(this.graphType.match(/scatter/i)||this.is3DPlot){a.push(["Axes","axes_s.png",false,false,false,this.getAxesMenu()]);a.push(["Axes Titles","axes_titles_s.png",false,false,false,this.getAxesTitleMenu()]);a.push(["Citation","citation_s.png",false,false,false,this.getGraphPartMenu("citation")]);a.push(["General","general_s.png",false,false,false,this.getGeneralMenu()]);a.push(["Grid","grid_s.png",false,false,false,this.getGridMenu()]);a.push(["Legend","legend_s.png",false,false,false,this.getLegendMenu()]);a.push(["Title / Subtitle","title_subtitle_s.png",false,false,false,this.getTitleSubtitleMenu()]);if(this.isSelectDataPoints){a.push(["Show hidden data points","show_selected.png","showHideSelectedDataPoint",[false,45],"Ctrl + Insert"]);a.push(["Hide data points","hide_selected.png","showHideSelectedDataPoint",[false,46],"Ctrl + Delete"])}}}return a};this.setMenu=function(){this.menu={};var c=["Bar","Line","Area","AreaLine","BarLine","Boxplot","Dotplot","DotLine","Heatmap","Treemap","TagCloud","Stacked","StackedLine","StackedPercent","StackedPercentLine","Candlestick","Pie","Correlation","Circular","Scatter2D","ScatterBubble2D","Scatter3D","Scatter2D","Venn","Network","Genome"];var e={Bar:true,Line:true,Area:true,AreaLine:true,BarLine:true,Boxplot:true,Dotplot:true,DotLine:true,Heatmap:true,Treemap:true,TagCloud:true,Stacked:true,StackedLine:true,StackedPercent:true,StackedPercentLine:true,Candlestick:true};for(var d=0;d<c.length;d++){this.menu[this.validGraphTypes[d]]=[]}if(this.graphType=="Network"){var b=[];b.push(["Clockwise","rotate_clockwise.png","arrowMove",[34]]);b.push(["Clockwise - Animate","rotate_clockwise_cont.png","arrowMove",[39,true]]);b.push(["Anticlockwise","rotate_anticlockwise.png","arrowMove",[33]]);b.push(["Anticlockwise - Animate","rotate_anticlockwise_cont.png","arrowMove",[37,true]]);var h=[];h.push(["Top","align_top.png","alignDistributeSelectedNodes",[false,84]]);h.push(["Right","align_right.png","alignDistributeSelectedNodes",[false,82]]);h.push(["Bottom","align_bottom.png","alignDistributeSelectedNodes",[false,66]]);h.push(["Left","align_left.png","alignDistributeSelectedNodes",[false,76]]);var f=[];f.push(["Vertically","distribute_vertical.png","alignDistributeSelectedNodes",[false,86]]);f.push(["Horozontally","distribute_horizontal.png","alignDistributeSelectedNodes",[false,72]]);var g=[];g.push(["Send to back","move_back.png","orderNodes",["sendNodeToBack"]]);g.push(["Send backward","move_backwards.png","orderNodes",["sendNodeBackward"]]);g.push(["Bring to front","move_front.png","orderNodes",["bringNodeToFront"]]);g.push(["Bring forward","move_forwards.png","orderNodes",["bringNodeForward"]]);if(this.isSelectNodes){this.menu.Network.push(["Align","align_bottom.png",false,false,false,h]);this.menu.Network.push(["Distribute","distribute_vertical.png",false,false,false,f]);this.menu.Network.push(["Rotate","rotate_anticlockwise.png",false,false,false,b]);this.menu.Network.push(["Order","move_front.png",false,false,false,g]);this.menu.Network.push(["-"]);this.menu.Network.push(["Show conections","connections.png","showHideSelectedDataPoint",[false,36],"Ctrl + Home"]);this.menu.Network.push(["-"]);this.menu.Network.push(["Show hidden nodes","show_selected.png","showHideSelectedDataPoint",[false,45],"Ctrl + Insert"]);this.menu.Network.push(["Hide nodes","hide_selected.png","showHideSelectedDataPoint",[false,46],"Ctrl + Delete"]);this.menu.Network.push(["-"]);this.menu.Network.push(["Undo","undo.png","alignDistributeSelectedNodes",[false,90],"Ctrl + z"]);this.menu.Network.push(["Redo","redo.png","alignDistributeSelectedNodes",[false,90,true],"Ctrl + y"]);this.menu.Network.push(["-"])}else{this.menu.Network.push(["Rotate","rotate_anticlockwise.png",false,false,false,b])}}for(var d=0;d<c.length;d++){if(this.isDOE){this.menu[this.validGraphTypes[d]].push(["Modify DOE","doe.png",false,false,false,this.getDOEMenu()]);this.menu[this.validGraphTypes[d]].push(["Remove DOE","remove_doe.png","removeDOE"]);this.menu[this.validGraphTypes[d]].push(["-"])}else{if(e[this.graphType]&&!this.is3DPlot){this.menu[this.validGraphTypes[d]].push(["Customize","cog.png",false,false,false,this.getConfigurationMenu()]);this.menu[this.validGraphTypes[d]].push(["-"]);this.menu[this.validGraphTypes[d]].push(["Data","data.png",false,false,false,this.getDataMenu()]);this.menu[this.validGraphTypes[d]].push(["-"]);if(this.data.x){this.menu[this.validGraphTypes[d]].push(["Data Point Attributes","color_shape_size.png",false,false,false,this.getDataPointAttributesMenu()]);this.menu[this.validGraphTypes[d]].push(["-"])}if(this.data.x){this.menu[this.validGraphTypes[d]].push(["Group Samples","group_samples.png",false,false,false,this.getGroupSamplesMenu()]);this.menu[this.validGraphTypes[d]].push(["-"])}this.menu[this.validGraphTypes[d]].push(["Cluster","cluster.png",false,false,false,this.getDendrogramsMenu()]);this.menu[this.validGraphTypes[d]].push(["-"]);if(this.isHistogram){this.menu[this.validGraphTypes[d]].push(["Histogram","histogram.png",false,false,false,this.getHistogramMenu()])}else{if(!this.isCorrelate){this.menu[this.validGraphTypes[d]].push(["Correlate","regression_line.png",false,false,false,this.getCorrelationMenu()]);if(this.data.x){this.menu[this.validGraphTypes[d]].push(["Explore DOE","doe.png","createDOE"])}this.menu[this.validGraphTypes[d]].push(["Histogram","histogram.png","createHistogramTr"])}}this.menu[this.validGraphTypes[d]].push(["-"])}else{if(this.graphType.match(/scatter/i)||this.is3DPlot){this.menu[this.validGraphTypes[d]].push(["Customize","cog.png",false,false,false,this.getConfigurationMenu()]);this.menu[this.validGraphTypes[d]].push(["-"]);this.menu[this.validGraphTypes[d]].push(["Data","data.png",false,false,false,this.getDataMenu()]);this.menu[this.validGraphTypes[d]].push(["-"]);if(this.graphType=="Scatter2D"){if(this.isHistogram){this.menu[this.validGraphTypes[d]].push(["Histogram","histogram.png",false,false,false,this.getHistogramMenu()])}else{if(this.isCorrelate){this.menu[this.validGraphTypes[d]].push(["Remove Correlation","remove_regression_line.png","removeCorrelation"])}else{if(this.data.d&&this.data.d.reg){this.menu[this.validGraphTypes[d]].push(["Remove Correlation","remove_regression_line.png","removeCorrelation"])}else{this.menu[this.validGraphTypes[d]].push(["Correlate","regression_line.png","correlateData"])}if(this.data.z){this.menu[this.validGraphTypes[d]].push(["Explore DOE","doe.png","createDOE"])}this.menu[this.validGraphTypes[d]].push(["Create Histogram","histogram.png","createHistogram"])}}this.menu[this.validGraphTypes[d]].push(["-"])}if(this.data.z){this.menu[this.validGraphTypes[d]].push(["Data Point Attributes","color_shape_size.png",false,false,false,this.getDataPointAttributesMenu()]);this.menu[this.validGraphTypes[d]].push(["-"])}}}}this.menu[this.validGraphTypes[d]].push(["Reset","refresh_form.png","masterReset",[],"ESC"]);this.menu[this.validGraphTypes[d]].push(["Print","camera.png","print",[],"Ctrl + P"]);if(this.remoteService&&!this.isDOE){var a=[];a.push(["Save visualization","disk.png","save",["event","update"]]);a.push(["Save visualization as","save-as.png","save",["event","save"]]);a.push(["Save / Overwrite params","disk_code.png","save",["event","params"]]);a.push(["Delete data","delete-saved.png","save",["event","delete"]]);a.push(["Recover data","recover.png","save",["event","recover"]]);this.menu[this.validGraphTypes[d]].push(["Server save","disk.png",false,false,false,a])}}return this.menu[this.graphType]};this.resetMenuLinks=function(){this.resetLinkDiv();this.removeMenus()};this.initializeMenuLinks=function(){if(!this.disableEvents){this.addLinkDiv()}};this.initializeMenuLinks()};CanvasXpress.prototype.initToolbarTooltip=function(){this.addToolbarDiv=function(){if(this.$(this.target+"-cX-Toolbar")){return}var s=this.canvas.height>=500?"16px":this.canvas.height>=400?"12px":this.canvas.height>=300?"10px":"8px";var j=this.$cX("div",{id:this.target+"-cX-Toolbar"},{position:"absolute",overflow:this.toolbarPermanent?"visible":"hidden",width:this.width+"px",height:"0px",left:7+"px",top:this.toolbarPermanent?"0px":"12px",zIndex:9000});var b=this.$cX("img",{src:this.getPixelImage()+"?"+new Date().getDayYear()+":"+this.userId});var l=this.$cX("img",{id:this.target+"-cX-ToolbarHelp",className:"CanvasXpressToolbarImage",src:this.imageDir+"help1.png",alt:"Help",title:"Help"},{width:s,height:s});var g=this.$cX("img",{id:this.target+"-cX-ToolbarCode",className:"CanvasXpressToolbarImage",src:this.imageDir+"purple_code.png",alt:"Show Code",title:"Show Code"},{width:s,height:s});var e=this.$cX("img",{id:this.target+"-cX-ToolbarSave",className:"CanvasXpressToolbarImage",src:this.imageDir+"camera.png",alt:"Save as png",title:"Save as png"},{width:s,height:s});var r=this.$cX("img",{id:this.target+"-cX-ToolbarLayout",className:"CanvasXpressToolbarImage",src:this.appLayout?this.imageDir+"configure_hide.png":this.isLayoutConfigurator?this.imageDir+"configure_show.png":this.imageDir+"configure_simple_show.png",alt:this.appLayout?"Basic layout":"Application layout",title:this.appLayout?"Basic layout":"Application layout"},{width:s,height:s,display:this.disableDataFilters||this.disableDataTable||this.disableConfigurator?"none":"block"});var m=this.$cX("img",{id:this.target+"-cX-ToolbarFilter",className:"CanvasXpressToolbarImage",src:this.imageDir+"funnel.png",alt:"Filter data",title:"Filter data"},{width:s,height:s,display:this.disableDataFilters?"none":"block"});var o=this.$cX("img",{id:this.target+"-cX-ToolbarData",className:"CanvasXpressToolbarImage",src:this.imageDir+"table.png",alt:"Show data",title:"Show data"},{width:s,height:s,display:this.disableDataTable?"none":"block"});if(this.isVML||this.disableConfigurator){o.style.marginRight="4px"}var t=this.$cX("img",{id:this.target+"-cX-ToolbarConfigurator",className:"CanvasXpressToolbarImage",src:this.imageDir+"cog.png",alt:"Configure plot",title:"Configure plot"},{width:s,height:s,marginRight:"4px",display:this.isVML||this.disableConfigurator?"none":"block"});var u=this.$cX("div",{id:this.target+"-cX-ToolbarHelpDescription",className:"CanvasXpressToolbarHelp draggable"},{cursor:"move",display:"none",padding:"10px",position:"absolute"});var k=this.$cX("img",{id:this.target+"-cX-ToolbarHelpClose",className:"CanvasXpressToolbarHelp",src:this.imageDir+"cancel1.png",alt:"Close",title:"Close"});u.appendChild(document.createTextNode("Help"));u.appendChild(k);u.appendChild(this.$cX("br"));this.addHelp(u);j.appendChild(b);j.appendChild(t);j.appendChild(o);j.appendChild(m);j.appendChild(r);j.appendChild(e);j.appendChild(g);j.appendChild(l);j.appendChild(u);var u=this.$("north-wrapper-"+this.target);if(u){u.appendChild(j);this.addRemoveToolbarListeners("addEvtListener")}};this.addRemoveToolbarListeners=function(a){this.addRemoveEvtListener(a,this.$(this.target+"-cX-ToolbarHelp"),"click",this.clickHelp,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-ToolbarCode"),"click",this.clickShowCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-ToolbarSave"),"click",this.print,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-ToolbarLayout"),"click",this.clickLayout,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-ToolbarFilter"),"click",this.clickDataFilters,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-ToolbarData"),"click",this.clickDataTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-ToolbarConfigurator"),"click",this.clickGraphConfigurator,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-ToolbarHelpClose"),"click",this.closeHelp,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-ToolbarHelpDescription"),"mousedown",this.registerMousemove,false)};this.clickHelp=function(a){return function(f){if(!f){f=window.event}var c=a.$(a.target+"-cX-Toolbar");var d=a.$(a.target+"-cX-ToolbarHelpDescription");if(c&&d){c.style.overflow="visible";d.style.display="block";d.style.left=((f.layerX||f.x)-400)+"px";d.style.top=(f.layerY||f.y)+"px"}return false}}(this);this.clickShowCode=function(a){return function(b){if(!b){b=window.event}a.showCodeDiv();return false}}(this);this.closeHelp=function(a){return function(f){if(!f){f=window.event}var c=a.$(a.target+"-cX-Toolbar");var d=a.$(a.target+"-cX-ToolbarHelpDescription");if(c&&d){d.style.display="none";setTimeout(function(){c.style.overflow=a.toolbarPermanent?"visible":"hidden"},300)}return false}}(this);this.clickLayoutNoAnimation=function(c){if(this.appLayout&&!c){var b=this.showFadeResizeMoveAnimation;this.showFadeResizeMoveAnimation=false;this.hideTable();this.hideDataFilter();var a=this.$(this.target+"-cX-ToolbarLayout");a.src=this.imageDir+"configure_show.png";a.alt="Application layout";a.title="Application layout";this.appLayout=false;this.activeAccordion=false;this.showFadeResizeMoveAnimation=b;return false}};this.clickLayout=function(a){return function(j,c){if(!j){j=window.event}var f=a.showFadeResizeMoveAnimation?500:0;var k=function(){a.showDataFilter();if(!a.dataFilterLastState||(a.dataFilterLastState&&a.dataFilterLastState!="docked")){a.moveDataFilter();if(!a.activeAccordion){setTimeout(function(){if(a.graphType=="Genome"){a.activateAccordion(false,a.$(a.target+"-cX-DataFilterGenomeHeader"))}else{if(a.graphType=="Network"){a.activateAccordion(false,a.$(a.target+"-cX-DataFilterNodeHeader"))}else{a.activateAccordion(false,a.$(a.target+"-cX-DataFilterVariableHeader"))}}},f)}}};var g=function(){a.updateDataTable();if(!a.dataTableLastState||(a.dataTableLastState&&a.dataTableLastState!="docked")){a.moveDataTableDiv("dock")}setTimeout(function(){var e=a.$("middle-container-"+a.target);a.dataTableTarget=a.$(a.target+"-cX-DataTable");a.updateDataTableResizerDiv(false,parseInt(e.style.width)-9,parseInt(a.dataTableTarget.style.height));a.endDataTableResizerDiv();a.hideToolbar()},f)};if(!c){c=j.target||j.srcElement}a.appLayout=a.appLayout?false:true;c.src=a.appLayout?a.imageDir+"configure_hide.png":a.imageDir+"configure_show.png";c.alt=a.appLayout?"Basic layout":"Application layout";c.title=a.appLayout?"Basic layout":"Application layout";if(a.resizeHeightOnLayout){a.setDataTableDimensions()}var b=a.isLayoutConfigurator?a.configuratorWidth+a.dataFilterWidth+36:a.dataFilterWidth+18;var d=a.dataTableLastHeight?a.dataTableRowsHeight+9:a.dataTableRowsHeight+53;if(a.appLayout){if(a.resizeWidthOnLayout&&a.width-b>=b*1.3){if(a.resizeHeightOnLayout&&a.height-d>=d*1){a.setDimensions(a.width-b,a.height-d,true);a.resizeWidthOnLayoutActive=true;a.resizeHeightOnLayoutActive=true}else{a.setDimensions(a.width-b,a.height,true);a.resizeWidthOnLayoutActive=true}a.resizeViewport()}else{if(a.resizeHeightOnLayout&&a.height-d>=d*1){a.setDimensions(a.width,a.height-d,true);a.resizeHeightOnLayoutActive=true;a.resizeViewport()}}var i=a.isLayoutConfigurator?500:1;if(a.isLayoutConfigurator){a.addConfigurator();a.selectConfig(false,true);if(!a.configuratorLastState||(a.configuratorLastState&&a.configuratorLastState!="docked")){a.clickDockUndockConfigurator()}}a.dataFilterHeight=a.canvas.height-(a.graphType=="Genome"?60:81);setTimeout(function(){k();setTimeout(function(){g()},f)},i)}else{if(a.isLayoutConfigurator){a.closeConfigurator()}setTimeout(function(){if(a.activeAccordion){a.activateAccordion(false,a.activeAccordion.previousSibling)}a.hideDataFilter();setTimeout(function(){a.hideTable();a.hideToolbar();setTimeout(function(){if(a.resizeWidthOnLayoutActive){if(a.resizeHeightOnLayoutActive){a.setDimensions(a.width+b,a.height+d,true)}else{a.setDimensions(a.width+b,a.height,true)}}else{if(a.resizeHeightOnLayoutActive){a.setDimensions(a.width,a.height+d,true)}}a.resizeWidthOnLayoutActive=false;a.resizeHeightOnLayoutActive=false;setTimeout(function(){a.updateRemoteNavigationWindow()},f*0.2)},f)},f)},f)}return false}}(this);this.clickDataTable=function(a){return function(b){if(!b){b=window.event}a.updateDataTable();return false}}(this);this.clickDataFilters=function(a){return function(b){if(!b){b=window.event}a.showDataFilter();return false}}(this);this.clickGraphConfigurator=function(a){return function(b){if(!b){b=window.event}a.addConfigurator();return false}}(this);this.addHelp=function(l){var i=this.$cX("div",false,{width:"400px"});i.appendChild(this.$cX("br"));var A=this.$cX("img",{src:this.imageDir+"help1.png"});i.appendChild(A);i.appendChild(document.createTextNode(" Show this help"));i.appendChild(this.$cX("br"));var s=this.$cX("img",{src:this.imageDir+"camera.png"});i.appendChild(s);i.appendChild(document.createTextNode(" Print"));i.appendChild(this.$cX("br"));var g=this.$cX("p",{className:"CanvasXpressToolbarHelp",innerHTML:"Save the image as a 'png' file."});i.appendChild(g);var r=this.$cX("img",{src:this.imageDir+"disk.png"});i.appendChild(r);i.appendChild(document.createTextNode(" Save"));i.appendChild(this.$cX("br"));var E=this.$cX("p",{className:"CanvasXpressToolbarHelp",innerHTML:"Save save the data as a tab delimited file."});i.appendChild(E);var B=this.$cX("img",{src:this.imageDir+"funnel.png"});i.appendChild(B);i.appendChild(document.createTextNode(" Filters"));i.appendChild(this.$cX("br"));var F=this.$cX("p",{className:"CanvasXpressToolbarHelp",innerHTML:"Widget used to filter the data and metadata. Metadata will be automatically assigned as text, numeric or date."});i.appendChild(F);var B=this.$cX("img",{src:this.imageDir+"table.png"});i.appendChild(B);i.appendChild(document.createTextNode(" Show data"));i.appendChild(this.$cX("br"));var b=this.$cX("p",{className:"CanvasXpressToolbarHelp",innerHTML:"Show the data used for this visualization in an HTML table."});i.appendChild(b);var o=this.$cX("img",{src:this.imageDir+"transpose.png"});i.appendChild(o);i.appendChild(document.createTextNode(" Transpose data table"));i.appendChild(this.$cX("br"));var A=this.$cX("img",{src:this.imageDir+"cog.png"});i.appendChild(A);i.appendChild(document.createTextNode(" Show the configurator"));i.appendChild(this.$cX("br"));var f=this.$cX("p",{className:"CanvasXpressToolbarHelp",innerHTML:"This widget allows you to customize this graph. You may enter the name of the property you wish to customize in the text box (which filters as you type) or browse through a number of categories.<br>You will find a short description for the property you select along with its category and links to other relevant properties.<br>You will also see the current value for the seleced property along with a link to an additional widget to help you specifying the new value."});i.appendChild(f);var D=this.$cX("img",{src:this.imageDir+"configure_show.png"});i.appendChild(D);i.appendChild(document.createTextNode(" Application mode (Filter and Table)"));i.appendChild(this.$cX("br"));var e=this.$cX("p",{className:"CanvasXpressToolbarHelp",innerHTML:"Show both the data table and the data filters."});i.appendChild(e);var y=this.$cX("img",{src:this.imageDir+"pin.png"});i.appendChild(y);i.appendChild(document.createTextNode(" Dock widget to the side"));i.appendChild(this.$cX("br"));var m=this.$cX("img",{src:this.imageDir+"unpin.png"});i.appendChild(m);i.appendChild(document.createTextNode(" Undock widget from the side"));i.appendChild(this.$cX("br"));var v=this.$cX("img",{src:this.imageDir+"purple_code.png"});i.appendChild(v);i.appendChild(document.createTextNode(" Show visualization code"));i.appendChild(this.$cX("br"));var C=this.$cX("img",{src:this.imageDir+"cancel1.png"});i.appendChild(C);i.appendChild(document.createTextNode(" Close widget"));i.appendChild(this.$cX("br"));i.appendChild(this.$cX("br"));var j=this.$cX("a",{href:"http://canvasxpress.org",target:"_blank",innerHTML:"canvasXpress"});i.appendChild(document.createTextNode("Additional documentation at "));i.appendChild(j);i.appendChild(this.$cX("br"));l.appendChild(i)};this.showToolbar=function(e){if(!this.toolbarPermanent){var a=this.$(this.target+"-cX-Toolbar");var d=this.$("west-container-"+this.target);if(a&&parseInt(a.style.height)==0&&d){var c=this;var b=parseInt(d.style.width);this.resizeMove(a,0,12,this.width+b,20,250);if(e){setTimeout(function(){c.hideToolbar()},5000)}}}};this.hideToolbar=function(){if(!this.toolbarPermanent){var a=this.$(this.target+"-cX-Toolbar");var c=this.$("west-container-"+this.target);if(a&&parseInt(a.style.height)==20&&c){var b=parseInt(c.style.width);this.resizeMove(a,0,12,this.width+b,0)}}};this.isToolbar=function(c){if(!c){c=window.event}var b=this.adjustedCoordinates(c);if(b){var a=b.x;var d=b.y;if(d>0&&d<24&&a>0&&a<this.width){this.showToolbar()}else{if(d>24&&d<this.height&&a>0&&a<this.width){this.hideToolbar()}}}};this.addTooltipDiv=function(l,k,j){var a=0;var b=this.target+"-cX-TooltipDiv"+a;var o=this.$(this.target+"-cX-Info");if(o&&o.style.display!="none"){k=parseInt(o.style.left);j=parseInt(o.style.top)}var f=this.$(b);while(f){a++;b=this.target+"-cX-TooltipDiv"+a;f=this.$(b)}var g=this.$cX("div",{id:b,className:"CanvasXpressTooltip draggable"},{left:k+"px",top:j+"px",zIndex:29010});var h=this.$cX("img",{id:b+"Close",className:"CanvasXpressTooltip",src:this.imageDir+"cancel1.png",alt:"Close",title:"Close"});var m=this.$cX("div",{id:b+"HTML",innerHTML:l||""},{clear:"both"});g.appendChild(h);g.appendChild(m);document.body.appendChild(g);this.resetInfoSpan();return g};this.addRemoveTooltipDivsListeners=function(a,b){this.addRemoveEvtListener(a,b,"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(a,b,"touchstart",this.registerMousemove,false);this.addRemoveEvtListener(a,b.firstChild,"click",this.closeTooltipDiv,false)};this.closeTooltipDiv=function(a){return function(c){if(!c){c=window.event}var b=c.target||c.srcElement;if(b){var f=b.parentNode;a.addRemoveTooltipDivsListeners("removeEvtListener",f);f.parentNode.removeChild(f)}return false}}(this);this.showTooltipDiv=function(f,h,b){var c=b?this.regularCoordinates(f,b):this.adjustedCoordinates(f);if(c){var a=c.x;var i=f?c.y:c.y+25;var g=this.addTooltipDiv(h,a,i);this.addRemoveTooltipDivsListeners("addEvtListener",g)}};this.resetTooltipDivs=function(){var c=0;var a=this.target+"-cX-TooltipDiv"+c;var b=this.$(a);while(b){this.addRemoveTooltipDivsListeners("removeEvtListener",b);b.parentNode.removeChild(b);c++;a=this.target+"-cX-TooltipDiv"+c;b=this.$(a)}};this.addInfoSpan=function(){if(this.$(this.target+"-cX-Info")){this.resetInfoSpan();return}var a=this.$cX("span",{id:this.target+"-cX-Info",className:"CanvasXpressTooltip"},{display:"none",zIndex:29010});document.body.appendChild(a)};this.resetInfoSpan=function(d,c){var b=this.$(this.target+"-cX-Info");if(b){var a=new Date().getTime()-this.infoStartTime;if(a>this.infoTimeIn||c){b.style.left="0px";b.style.top="0px";b.style.display="none";b.innerHTML=""}}};this.showInfoSpan=function(d,k,a){if(this.draggingOn||this.remoteUpdating){return}var m=new Date().getTime()-this.infoStartTime;var n=this.$(this.target+"-cX-Info");if(n&&k&&k!=""&&m>this.infoTimeIn){var l=a?this.regularCoordinates(d,a):this.adjustedCoordinates(d,n);if(l){var g=l.x;var f=d?l.y:l.y+25;if(this.isIE){g+=document.body.scrollLeft;f+=document.body.scrollTop}if(!isNaN(k)){k=k.toString()}if(k.match(/\w/)){n.innerHTML=k;n.style.left=(g+10)+"px";n.style.top=(f-20)+"px";n.style.display="inline";n.style.zIndex=parseInt(n.style.zIndex);var j=parseInt(n.clientWidth);var b=parseInt(n.clientHeight);if(j<window.innerWidth&&j>(window.innerWidth+window.pageXOffset)-g&&(j+20)<(g-window.pageXOffset)){n.style.left=(g-(j+20))+"px";n.style.left=(g-(parseInt(n.clientWidth)+20))+"px"}if(b<window.innerHeight&&b>(window.innerHeight+window.pageYOffset)-f&&(b-15)<(f-window.pageYOffset)){n.style.top=(f-(b-15))+"px";n.style.top=(f-(parseInt(n.clientHeight)-15))+"px"}this.infoStartTime=new Date().getTime();var c=this;var i=function(){this.update=function(){var h=new Date().getTime();if(h-c.infoStartTime>c.infoTimeOut){c.resetInfoSpan();clearInterval(e)}};var e=setInterval(this.update,100)};i.call()}}}};this.initializeToolbarTooltip=function(){if(!this.disableEvents){if(!this.disableToolbar){this.addToolbarDiv()}this.addInfoSpan()}};this.initializeToolbarTooltip()};CanvasXpress.prototype.initConfigurator=function(){this.addConfigurator=function(a){return function(af,E,N,M){var A=false;if(!af){af=window.event}if(a.isVML||a.disableConfigurator){return}var ah=a.$(a.target+"-cX-Configurator");if(ah){A=true;if(a.activeTarget){a.activeTarget.style.zIndex=10000}a.activeTarget=ah;a.activeTarget.style.zIndex=10001;if(a.configuratorLastState&&a.configuratorLastState=="docked"){var h=a.$("west-handler-"+a.target);a.clickViewport(af,h);return}}var G="Search property or function";a.configuringOn=true;if(E){if(a.isArray(E)){E=E[0]}if(a.graphType=="Network"){a.configuringNetwork=E;if(a.data.nodes.length>E){G="Configure "+(a.data.nodes[E].label||a.data.nodes[E].name||a.data.nodes[E].id)}else{var B=a.data.edges[E-a.data.nodes.length];var J=a.data.nodes[a.data.nodeIndices[B.id1]];var I=a.data.nodes[a.data.nodeIndices[B.id2]];G="Configure "+(J.label||J.name||J.id)+" - "+(I.label||J.name||I.id)}}else{if(a.graphType=="Genome"){a.configuringGenome=E;G="Configure track "+E}}}var C=N!=null&&M!=null?{x:N,y:M}:a.adjustedCoordinates(af);if(C){N=a.applicationLook||a.configuratorLastState=="docked"?0:C.x;M=a.applicationLook||a.configuratorLastState=="docked"?0:C.y;if(A){ah.style.left=N+"px";ah.style.top=M+"px";return}else{ah=a.$cX("div",{id:a.target+"-cX-Configurator",className:a.applicationLook?"CanvasXpressConfigurator fixed":"CanvasXpressConfigurator draggable"},{cursor:"move",left:N+"px",top:M+"px",padding:"10px",position:"absolute",zIndex:10001})}var ab=a.$cX("div",{id:a.target+"-cX-ConfiguratorKeyText"},{display:"block",marginBottom:"5px",width:a.configuratorWidth+"px"});var ac=a.$cX("span",{id:a.target+"-cX-ConfiguratorKeyTextSpan",className:"CanvasXpressConfigurator",innerHTML:G});var ad=a.$cX("img",{id:a.target+"-cX-ConfiguratorKeySearch",className:"CanvasXpressConfigurator",src:a.imageDir+"find.png",alt:"Browse properties by category",title:"Browse properties by category"});var D=a.$cX("img",{id:a.target+"-cX-ConfiguratorKeyDock",className:"CanvasXpressConfigurator",src:a.applicationLook?a.imageDir+"unpin.png":a.imageDir+"pin.png",alt:a.applicationLook?"Undock":"Dock",title:a.applicationLook?"Undock":"Dock",state:a.applicationLook?"docked":"free"});var Z=a.$cX("img",{id:a.target+"-cX-ConfiguratorKeyClose",className:"CanvasXpressConfigurator",src:a.imageDir+"cancel1.png",alt:"Close",title:"Close"});var aa=a.$cX("input",{id:a.target+"-cX-ConfiguratorKey",className:"CanvasXpressConfigurator",type:"text"},{display:"block",width:a.configuratorWidth+"px"});var Y=a.$cX("select",{id:a.target+"-cX-ConfiguratorCategories",className:"CanvasXpressConfigurator",size:5},{display:"none",width:a.configuratorWidth+"px"});var S=a.$cX("div",{id:a.target+"-cX-ConfiguratorSugestionsText",innerHTML:"Select property"},{display:"none",margin:"5px 0px 5px 0px",width:a.configuratorWidth+"px"});var R=a.$cX("select",{id:a.target+"-cX-ConfiguratorSugestions",className:"CanvasXpressConfigurator",size:a.mobileApp?5:10},{display:"none",width:a.configuratorWidth+"px"});var ag=a.$cX("div",{id:a.target+"-cX-ConfiguratorSugestionsDescription"},{display:"none",margin:"5px 0px 5px 0px",width:a.configuratorWidth+"px",minHeight:"56px",overflow:"auto"});var P=a.$cX("div",{id:a.target+"-cX-ConfiguratorValueText",innerHTML:"Current value"},{display:"none",margin:"5px 0px 5px 0px",width:a.configuratorWidth+"px"});var aj=a.$cX("div",{id:a.target+"-cX-ConfiguratorSeeAlso"},{display:"none",width:a.configuratorWidth+"px",minHeight:"20px",overflow:"auto"});var O=a.$cX("input",{id:a.target+"-cX-ConfiguratorValue",className:"CanvasXpressConfigurator",type:"text"},{display:"none",width:a.configuratorWidth+"px"});var F=a.$cX("input",{id:a.target+"-cX-ConfiguratorApply",value:"Apply",type:"button"},{display:"none",cssFloat:"left",borderRadius:"5px",top:"4px",position:"relative",width:(a.configuratorWidth/2)+"px"});var ai=a.$cX("input",{id:a.target+"-cX-ConfiguratorButton",value:"Draw",type:"button"},{display:"none",cssFloat:"left",borderRadius:"5px",top:"4px",position:"relative",width:(a.configuratorWidth/2)+"px"});var T=a.$cX("img",{id:a.target+"-cX-ConfiguratorOptionsClose",className:"CanvasXpressConfigurator",src:a.imageDir+"cancel1.png",alt:"Close",title:"Close"});var L=a.$cX("div",{id:a.target+"-cX-ConfiguratorOptions",className:"CanvasXpressConfigurator draggable"},{cursor:"move",display:"none",padding:"10px",position:"absolute"});var V=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorCurrent",className:"CanvasXpressConfiguratorColor"},{width:"181px",height:"16px",cssFloat:"left",cursor:"default"});var U=a.$cX("img",{id:a.target+"-cX-ConfiguratorColorClose",className:"CanvasXpressConfigurator",src:a.imageDir+"cancel1.png",alt:"Close",title:"Close"});var X=a.$cX("div",{id:a.target+"-cX-ConfiguratorColor",className:"CanvasXpressConfigurator draggable"},{width:"204px",cursor:"move",display:"none",padding:"10px",position:"absolute"});var H=a.$cX("div",{id:a.target+"-cX-ConfiguratorFilter",className:"CanvasXpressConfiguratorFilter draggable",innerHTML:'Build filter ("+" to set "-" to remove)'},{cursor:"move",display:"none",padding:"10px",position:"absolute"});var K=a.$cX("img",{id:a.target+"-cX-ConfiguratorFilterClose",className:"CanvasXpressConfigurator",src:a.imageDir+"cancel1.png",alt:"Close",title:"Close"});var Q=a.$cX("div",{id:a.target+"-cX-ConfiguratorExample",className:"CanvasXpressConfiguratorExample draggable"},{width:(a.configuratorExamplesSize+35)+"px",maxHeight:(a.configuratorExamplesSize)+"px",cursor:"move",display:"none",padding:"10px",position:"absolute",overflow:"hidden",paddingBottom:"35px"});var ae=a.$cX("span",{id:a.target+"-cX-ConfiguratorExampleSpan",className:"CanvasXpressConfiguratorExample",innerHTML:""});var w=a.$cX("img",{id:a.target+"-cX-ConfiguratorExampleClose",className:"CanvasXpressConfigurator",src:a.imageDir+"cancel1.png",alt:"Close",title:"Close"});var t=a.$cX("div",{id:a.target+"-cX-ConfiguratorExampleContent",className:"CanvasXpressConfiguratorExampleContent"},{maxWidth:(a.configuratorExamplesSize+35)+"px",maxHeight:(a.configuratorExamplesSize)+"px",overflow:"auto"});ab.appendChild(ac);ab.appendChild(Z);ab.appendChild(D);ab.appendChild(ad);L.appendChild(document.createTextNode("Select option ..."));L.appendChild(T);L.appendChild(a.$cX("br"));X.appendChild(V);X.appendChild(U);X.appendChild(a.$cX("br"));H.appendChild(K);H.appendChild(a.$cX("br"));Q.appendChild(ae);Q.appendChild(w);Q.appendChild(a.$cX("br"));Q.appendChild(t);ah.appendChild(ab);ah.appendChild(aa);ah.appendChild(Y);ah.appendChild(S);ah.appendChild(R);ah.appendChild(ag);ah.appendChild(aj);ah.appendChild(P);ah.appendChild(O);ah.appendChild(F);ah.appendChild(ai);ah.appendChild(L);ah.appendChild(X);ah.appendChild(H);ah.appendChild(Q);var W=a.$("west-wrapper-"+a.target);if(W){W.appendChild(ah);if(a.activeTarget){a.activeTarget.style.zIndex=10000}a.activeTarget=ah;a.addRemoveConfiguratorListeners("addEvtListener");if(a.configuringNetwork||a.configuringGenome){a.selectConfig(false,true)}setTimeout(function(){aa.focus()},300)}}}}(this);this.addRemoveConfiguratorListeners=function(B){var u=this.$(this.target+"-cX-Configurator");var h=this.$(this.target+"-cX-ConfiguratorCategories");var C=this.$(this.target+"-cX-ConfiguratorSugestions");var w=this.$(this.target+"-cX-ConfiguratorApply");var v=this.$(this.target+"-cX-ConfiguratorButton");var j=this.$(this.target+"-cX-ConfiguratorKeyClose");var A=this.$(this.target+"-cX-ConfiguratorKeyDock");var k=this.$(this.target+"-cX-ConfiguratorKeySearch");var r=this.$(this.target+"-cX-ConfiguratorOptions");var a=this.$(this.target+"-cX-ConfiguratorOptionsClose");var g=this.$(this.target+"-cX-ConfiguratorColor");var d=this.$(this.target+"-cX-ConfiguratorColorClose");var x=this.$(this.target+"-cX-ConfiguratorFilter");var e=this.$(this.target+"-cX-ConfiguratorFilterClose");var o=this.$(this.target+"-cX-ConfiguratorExample");var y=this.$(this.target+"-cX-ConfiguratorExampleClose");if(u&&h&&C&&v&&w&&j&&A&&k&&r&&a&&g&&d&&x&&e&&o&&y){this[B](u,"mousedown",this.registerMousemove,false);this[B](h,"change",this.changeCategory,false);this[B](h,"click",this.changeCategory,false);this[B](C,"change",this.clickSuggestions,false);this[B](C,"click",this.clickSuggestions,false);this[B](w,"click",this.clickApplyConfigurator,false);this[B](v,"click",this.clickConfigurator,false);this[B](k,"click",this.clickSearch,false);this[B](A,"click",this.clickDockUndockConfigurator,false);this[B](j,"click",this.closeConfigurator,false);this[B](r,"mousedown",this.registerMousemove,false);this[B](a,"click",this.closePropertyOptions,false);this[B](g,"mousedown",this.registerMousemove,false);this[B](d,"click",this.closePropertyColor,false);this[B](x,"mousedown",this.registerMousemove,false);this[B](e,"click",this.closePropertyFilter,false);this[B](o,"mousedown",this.registerMousemove,false);this[B](y,"click",this.closePropertyExample,false)}};this.getConfigurableProperties=function(){if(this.configuringNetwork){if(this.data.nodes.length>this.configuringNetwork){return this.getNodeConfigurableProperties(this.configuringNetwork)}else{return this.getEdgeConfigurableProperties(this.configuringNetwork-this.data.nodes.length)}}else{if(this.configuringGenome){if(!isNaN(this.configuringGenome)||this.configuringGenome.match(/:/)){return this.featureConfigurableProperties}else{if(this.configuringGenome.match(/track/)){return this.trackConfigurableProperties}else{this.configuringGenome=false}}}}var d=[];for(var c in CanvasXpress.doc.P){if(!CanvasXpress.doc.P[c].Z){var a=CanvasXpress.doc.P[c].M;var b=CanvasXpress.doc.P[c].U;if(CanvasXpress.doc.M[a].U){if(CanvasXpress.doc.M[a].U.hasOwnProperty(this.graphType)){d.push(c)}}else{if(b){if(b.hasOwnProperty(this.graphType)){d.push(c)}}else{d.push(c)}}}}return d};this.getConfigurableObjectDoc=function(a){if(this.configuringNetwork){if(this.data.nodes.length>this.configuringNetwork){return CanvasXpress.doc.N[a]?CanvasXpress.doc.N[a]:false}else{return CanvasXpress.doc.E[a]?CanvasXpress.doc.E[a]:false}}else{if(this.configuringGenome){if(!isNaN(this.configuringGenome)||this.configuringGenome.match(/:/)){return CanvasXpress.doc.F[a]?CanvasXpress.doc.F[a]:false}else{if(this.configuringGenome.match(/track/)){return CanvasXpress.doc.G[a]?CanvasXpress.doc.G[a]:false}else{this.configuringGenome=false;return CanvasXpress.doc.P[a]?CanvasXpress.doc.P[a]:false}}}else{return CanvasXpress.doc.P[a]?CanvasXpress.doc.P[a]:false}}};this.selectConfig=function(D,F){var z=this.$(this.target+"-cX-ConfiguratorKey");var q=this.$(this.target+"-cX-ConfiguratorSugestionsText");var n=this.$(this.target+"-cX-ConfiguratorSugestions");var E=this.$(this.target+"-cX-ConfiguratorSugestionsDescription");var l=this.$(this.target+"-cX-ConfiguratorValueText");var H=this.$(this.target+"-cX-ConfiguratorSeeAlso");var j=this.$(this.target+"-cX-ConfiguratorValue");var f=this.$(this.target+"-cX-ConfiguratorApply");var G=this.$(this.target+"-cX-ConfiguratorButton");var B=this.$(this.target+"-cX-ConfiguratorValueHREF");var m=document.activeElement;var y=this.getConfigurableProperties();var w=[];if(this.getKeyCode(D)==13){this.resetOptionColorFiltersExamples();if(this.editingDescriptionOn){this.submitEditPropertyDescription()}else{if(n&&j&&j.value){var g=false;for(var A=0;A<y.length;A++){if(n.value==y[A]){g=true;break}}if(g){this.clickConfigurator(D,n,j)}else{this.resetConfigurator()}}}}else{if(m.id.match(/canvasXpressConfiguratorFilterValue/)){return}else{if(z&&m.id==z.id||F){this.resetOptionColorFiltersExamples();this.resetEditPropertyDescription();for(var A=0;A<y.length;A++){if(y[A].toLowerCase().indexOf(z.value.toLowerCase())>=0){w.push(y[A])}}if(w.length>0&&q&&n&&E&&l&&H&&j&&G&&f){this.resetSugestions();if(!this.configuringNetwork&&!this.configuringGenome){w.sort(function(d,c){return CanvasXpress.doc.P[d].M>CanvasXpress.doc.P[c].M?1:CanvasXpress.doc.P[c].M>CanvasXpress.doc.P[d].M?-1:d>c?1:c>d?-1:0});for(var A=0;A<w.length;A++){var y=this.$cX("option",{text:CanvasXpress.doc.P[w[A]].M?CanvasXpress.doc.P[w[A]].M+" : "+w[A]:"NA : "+w[A],value:w[A]});try{n.add(y,null)}catch(C){n.add(y)}}}else{w.sort();for(var A=0;A<w.length;A++){var y=this.$cX("option",{text:w[A],value:w[A]});try{n.add(y,null)}catch(C){n.add(y)}}}n.options[0].selected=true;this.setConfiguratorPropertyValue(n,E,l,H,j);q.innerHTML="Select property ("+w.length+")";q.style.display="block";n.style.display="block";E.style.display="block";l.style.display="block";H.style.display="block";j.style.display="block";G.style.display="block";f.style.display="block"}else{z.value=z.value.slice(0,z.value.length-1)}}else{if(j&&m.id==j.id){this.resetOptionColorFiltersExamples();this.resetEditPropertyDescription();if(B&&B.innerHTML=="color"){B.style.color=j.value?this.rgbToHex(this.validateColor(j.value.replace(/[\'\"]/g,""))):this.foreground}}else{if(this.remoteService){this.resetOptionColorFiltersExamples();this.selectDataSet(D)}}}}}return false};this.clickSearch=function(a){return function(G){if(!G){G=window.event}a.configuringNetwork=false;a.configuringGenome=false;a.resetEditOptionColorFiltersExamples();var E=a.$(a.target+"-cX-ConfiguratorKeyTextSpan");var C=a.$(a.target+"-cX-ConfiguratorKey");var A=a.$(a.target+"-cX-ConfiguratorCategories");var w=a.$(a.target+"-cX-ConfiguratorSugestionsText");var t=a.$(a.target+"-cX-ConfiguratorSugestions");var H=a.$(a.target+"-cX-ConfiguratorSugestionsDescription");var q=a.$(a.target+"-cX-ConfiguratorValueText");var J=a.$(a.target+"-cX-ConfiguratorSeeAlso");var p=a.$(a.target+"-cX-ConfiguratorValue");var I=a.$(a.target+"-cX-ConfiguratorButton");var c=a.$(a.target+"-cX-ConfiguratorApply");var f=a.$(a.target+"-cX-ConfiguratorOptions");var y=a.$(a.target+"-cX-ConfiguratorColor");var h=a.$(a.target+"-cX-ConfiguratorFilter");var B=a.getKeys(CanvasXpress.doc.M).sort();var j=[];if(C&&C.style.display=="none"){if(E){E.innerText="Search property or function"}if(A){A.style.display="none"}C.value="";C.style.display="block"}else{if(E){for(var D=0;D<B.length;D++){if(CanvasXpress.doc.M[B[D]].U){if(CanvasXpress.doc.M[B[D]].U.hasOwnProperty(a.graphType)){j.push(B[D])}}else{j.push(B[D])}E.innerText="Select category ("+j.length+")"}}if(C){C.style.display="none"}if(A){a.resetCategories();for(var D=0;D<j.length;D++){var x=a.$cX("option",{text:j[D],value:j[D]});try{A.add(x,null)}catch(F){A.add(x)}}A.style.display="block"}}if(w&&t&&H&&q&&J&&p&&I&&c&&f&&y&&h){w.style.display="none";t.style.display="none";H.style.display="none";q.style.display="none";J.style.display="none";p.style.display="none";I.style.display="none";c.style.display="none";f.style.display="none";y.style.dysplay="none";h.style.dysplay="none"}return false}}(this);this.clickDockUndockConfigurator=function(a){return function(n,f){if(!n){n=window.event}var q=a.$(a.target+"-cX-Configurator");var o=a.$(a.target+"-cX-ConfiguratorKeyDock");var s=a.$(a.target+"-cX-ConfiguratorButton");var u=a.$(a.target+"-cX-ConfiguratorApply");var t=a.$("middle-container-"+a.target);var j=a.$("west-container-"+a.target);var g=a.$("west-handler-"+a.target);var m=a.$("east-container-"+a.target);var l=this.showFadeResizeMoveAnimation?500:0;if(q&&o&&t&&j&&g&&m){if(o.state=="free"&&!f){var p=(parseInt(q.style.padding)*2)+2;var k=q.clientHeight-p;a.configuringOn="docked";a.resizeViewportWest();q.className="CanvasXpressConfigurator fixed";q.style.cursor="default";o.src=a.imageDir+"unpin.png";o.alt="Undock";o.title="Undock";o.state="docked";a.configuratorLastState="docked";t.style.width=q.clientWidth+7+a.canvas.width+m.clientWidth+2;a.resizeMove(j,0,0,q.clientWidth+7,a.canvas.height,l,null);a.resizeMove(q,0,0,a.configuratorWidth,a.canvas.height-p,l,null);s.style.left=((a.configuratorWidth/2)+10)+"px";u.style.left="10px";s.style.position="absolute";u.style.position="absolute";g.style.display="block";setTimeout(function(){a.resizeViewportWest();s.style.top=(a.canvas.height-(p+10))+"px";u.style.top=(a.canvas.height-(p+10))+"px";s.style.position="absolute";u.style.position="absolute"},l)}else{a.configuringOn="free";q.className="CanvasXpressConfigurator draggable";q.style.cursor="move";s.style.left="0px";u.style.left="0px";s.style.top="4px";u.style.top="4px";s.style.position="relative";u.style.position="relative";o.src=a.imageDir+"pin.png";o.alt="Dock";o.title="Dock";o.state="free";a.configuratorLastState="free";a.resizeMove(j,0,0,7,a.canvas.height,l,function(){t.style.width=7+a.canvas.width+m.clientWidth});a.resizeViewportWest();g.style.display="none";setTimeout(function(){q.style.height=""},l)}}return false}}(this);this.closeConfigurator=function(a){return function(b){if(!b){b=window.event}a.resetViewportOverflow("west");a.clickDockUndockConfigurator(b,true);a.resetConfigurator();return false}}(this);this.changeCategory=function(a){return function(G,D,I){if(!G){G=window.event}a.resetEditOptionColorFiltersExamples();var C=a.$(a.target+"-cX-ConfiguratorCategories");var w=a.$(a.target+"-cX-ConfiguratorSugestionsText");var t=a.$(a.target+"-cX-ConfiguratorSugestions");var H=a.$(a.target+"-cX-ConfiguratorSugestionsDescription");var q=a.$(a.target+"-cX-ConfiguratorValueText");var K=a.$(a.target+"-cX-ConfiguratorSeeAlso");var l=a.$(a.target+"-cX-ConfiguratorValue");var f=a.$(a.target+"-cX-ConfiguratorApply");var J=a.$(a.target+"-cX-ConfiguratorButton");var g=a.$(a.target+"-cX-ConfiguratorOptions");var B=a.$(a.target+"-cX-ConfiguratorColor");var h=a.$(a.target+"-cX-ConfiguratorFilter");var k=CanvasXpress.doc.M;if(I){C.value=I}if(C&&C.value&&w&&t&&H&&q&&K&&l&&J&&g&&B&&h){var y=k[C.value].P.sort();a.resetSugestions();for(var E=0;E<y.length;E++){if(I&&y[E]==I){D=E}var A=a.$cX("option",{text:y[E],value:y[E]});try{t.add(A,null)}catch(F){t.add(A)}}t.options[D||0].selected=true;w.innerHTML="Select property ("+y.length+")";a.setConfiguratorPropertyValue(t,H,q,K,l);w.style.display="block";t.style.display="block";H.style.display="block";q.style.display="block";K.style.display="block";l.style.display="block";f.style.display="block";J.style.display="block";g.style.display="none";B.style.display="none";h.style.display="none"}return false}}(this);this.hideCategories=function(){var a=this.$(this.target+"-cX-ConfiguratorCategories");var b=this.$(this.target+"-cX-ConfiguratorKeyTextSpan");var c=this.$(this.target+"-cX-ConfiguratorKeySearch");var e=this.$(this.target+"-cX-ConfiguratorKeyDock");if(a&&b&&c&&e){a.style.display="none";b.innerHTML="";c.style.display="none";e.style.display="none"}};this.resetCategories=function(){var a=this.$(this.target+"-cX-ConfiguratorCategories");if(a){if(a.hasChildNodes()){while(a.childNodes.length>=1){a.removeChild(a.firstChild)}}a.style.display="none"}};this.clickSuggestions=function(a){return function(b){if(!b){b=window.event}a.resetEditOptionColorFiltersExamples();a.setConfiguratorPropertyValue();return false}}(this);this.setConfiguratorPropertyValue=function(l,e,j,g,h){if(!l){l=this.$(this.target+"-cX-ConfiguratorSugestions")}if(!e){e=this.$(this.target+"-cX-ConfiguratorSugestionsDescription")}if(!j){j=this.$(this.target+"-cX-ConfiguratorValueText")}if(!g){g=this.$(this.target+"-cX-ConfiguratorSeeAlso")}if(!h){h=this.$(this.target+"-cX-ConfiguratorValue")}var k;var f=this.$(this.target+"-cX-ConfiguratorOptions");var c=this.getConfigurableObjectDoc(l.value);h.value="";h.style.readonly=false;if(this.configuringNetwork){if(typeof(this[l.value])=="function"){h.style.disabled="disabled";h.style.readonly=false}else{if(this.configuringNetwork<this.data.nodes.length){k=this.data.nodes[this.configuringNetwork][l.value]}else{k=this.data.edges[this.configuringNetwork-this.data.nodes.length][l.value]}}}else{if(this.configuringGenome){var b=this.subtracksInfo;if(!isNaN(this.configuringGenome)){k=this.data.tracks[b[this.configuringGenome].track].data[b[this.configuringGenome].index][l.value]}else{if(this.configuringGenome.match(/:/)){k=parseInt(this.configuringGenome.split(":")[1]);k=this.data.tracks[b[k].track].data[b[k].index][l.value]}else{k=parseInt(this.configuringGenome.replace("track-",""));k=this.data.tracks[b[k].track][l.value]}}}else{if(typeof(this[l.value])=="function"){j.innerHTML="Current&nbsp;value&nbsp;[&nbsp;<i>function</i>&nbsp;]&nbsp;"+this[l.value].length+"&nbsp;parameter(s)";if(this[l.value].length==0){h.style.disabled="disabled";h.style.readonly=false}}else{k=this[l.value]}}}h.value=k?JSON.stringify(k):"";this.addPropertyDescription(e,c,l.value);this.addPropertySeeAlsoLinks(g,c);this.addPropertyOptions(j,f,c,l.value,k);if(this.showConfiguratorExamplesOnSelect){this.resetPropertyExample();this.clickExamplePropertyDescription(false,l.value)}};this.resetSugestions=function(){var a=this.$(this.target+"-cX-ConfiguratorSugestions");if(a){if(a.hasChildNodes()){while(a.childNodes.length>=1){a.removeChild(a.firstChild)}}a.style.display="none"}};this.addPropertyDescription=function(r,g,f){var t=g&&g.C?g.C:"";var j=g&&g.M?g.M:"";var v=g&&g.H?true:false;this.resetPropertyDescription(r);var n=this.$cX("img",{id:this.target+"-cX-ConfiguratorSugestionsDescriptionEdit",src:this.imageDir+"pencil.png",alt:"Edit description",title:"Edit description"},{cursor:"default",margin:"2px",width:"10px",height:"10px"});var a=this.$cX("i",{innerHTML:f});var w=this.$cX("span",{id:this.target+"-cX-ConfiguratorSugestionsDescriptionEditSpan",className:"CanvasXpressConfigurator",prop:f,innerHTML:" : "+t});var k=this.$cX("i",{innerHTML:j});var l=this.$cX("a",{id:this.target+"-cX-ConfiguratorSugestionsDescriptionExample",href:"javascript:void(0)",alt:"Show examples",title:"Show examples"});var u=this.$cX("span",false,{className:"CanvasXpressConfigurator"});l.appendChild(a);u.appendChild(document.createTextNode("Description [ "));u.appendChild(k);u.appendChild(document.createTextNode(" ]"));r.appendChild(u);r.appendChild(this.$cX("br"));r.appendChild(v?l:a);r.appendChild(w);r.appendChild(n);this.addEvtListener(l,"click",this.clickExamplePropertyDescription,false);this.addEvtListener(n,"click",this.clickEditPropertyDescription,false)};this.resetPropertyDescription=function(f,b,a){if(!f){f=this.$(this.target+"-cX-ConfiguratorSugestionsDescription")}if(!b){b=this.$(this.target+"-cX-ConfiguratorSugestionsDescriptionEdit")}if(f&&b){this.removeEvtListener(b,"click",this.clickEditPropertyDescription,false);if(!a){a=this.$(this.target+"-cX-ConfiguratorSugestionsDescriptionExample")}if(a){this.removeEvtListener(a,"click",this.clickExamplePropertyDescription,false)}while(f.childNodes.length>0){var g=f.childNodes[0];f.removeChild(g)}}};this.getExamplesDocObject=function(l,z){var c=[];if(l){var n=this.getConfigurableObjectDoc(l);var e=n.U?this.getKeys(n.U):CanvasXpress.doc.M[n.M]["U"]?this.getKeys(CanvasXpress.doc.M[n.M]["U"]):["Bar"];for(var t=0;t<n.H.length;t++){if(n.H[t].match(/\*/)){var a=[];var r=n.H[t]=="{*}"?{}:JSON.parse(String(n.H[t].replace("*,","")));var h=r.data?this.getDataSet(r.data):false;var y=r.skipExample?this.getObjectArray(r.skipExample):{};var b=r.functions?r.functions:false;var g=r.conditional?r.conditional:false;if(h){delete (r.data)}if(y){delete (r.skipExample)}if(b){delete (r.functions)}if(g){delete (r.conditional)}if(n.T=="option"){a=n.O}else{if(n.T=="boolean"){a=[true,false]}else{if(n.T=="color"){a=["rgb(255,125,51)","rgb(51,255,125)","rgb(125,51,255)"];a.unshift(n.D)}else{if(n.T=="float"){a=n.D=="null"?[null,0.5]:[parseFloat(n.D),Math.max(parseFloat(n.D)*1.5,1)]}else{if(n.T=="integer"){a=n.D==0?[0,1]:[parseInt(n.D),parseInt((parseInt(n.D)*1.5)+0.5)]}}}}}for(var s=0;s<a.length;s++){if(y.hasOwnProperty(a[s])){continue}var m=(z?l:this.target)+"-cX-ConfiguratorExample-"+l+"-"+String(a[s]).replace(/\s/m,"-")+"-"+t;var v=this.cloneObject(r);v[l]=a[s];if(v[l]=="false"){v[l]=false}else{if(v[l]=="true"){v[l]=true}else{if(v[l]=="null"){v[l]=null}}}if(!v.graphType){v.graphType=e[0]}if(g){for(var k in g){v[k]=g[k][s%g[k].length]}}if(b&&s==0){c.push([m,h,v,b])}else{c.push([m,h,v])}}}else{var s=JSON.parse(String(n.H[t]));var x=s.data?this.getDataSet(s.data):false;var w=s.functions?s.functions:false;if(x){delete (s.data)}if(w){delete (s.functions)}var m=(z?l:this.target)+"-cX-ConfiguratorExample-"+l+"-"+t;if(!s.graphType){s.graphType=e[0]}if(w){c.push([m,x,s,w])}else{c.push([m,x,s])}}}}return c};this.clickExamplePropertyDescription=function(a){return function(u,n,y){a.resetPropertyExample();var t=y?a.$(n+"-cX-API-Example"):a.$(a.target+"-cX-ConfiguratorExample");var d=y?a.$(n+"-cX-API-ExampleSpan"):a.$(a.target+"-cX-ConfiguratorExampleSpan");var m=y?a.$(n+"-cX-API-ExampleContent"):a.$(a.target+"-cX-ConfiguratorExampleContent");if(t&&d&&m){t.style.display="block";if(!n){n=this.firstChild.innerHTML}var f=a.getExamplesDocObject(n);d.innerHTML=n;for(var r=0;r<f.length;r++){var o=f[r][0];var l=f[r][1];var s=f[r][2];var g=f[r][3];var w=a.$cX("canvas",{id:o,width:y?500:a.configuratorExamplesSize,height:y?500:a.configuratorExamplesSize});m.appendChild(w);var h=new CanvasXpress(o,l,s);if(g){for(var q=0;q<g.length;q++){if(g[q].match(/:/)){var b=g[q].split(":");h[b.shift()].apply(h,b)}else{h[g[q]]()}}}}if(!y){if(a.alignConfiguratorExamples||a.configuratorLastState=="docked"){var k=a.$(a.target+"-cX-Configurator");t.style.left=k.offsetWidth+"px";t.style.top="-1px";t.style.height=(k.clientHeight-45)+"px";m.style.maxHeight=(k.clientHeight-45)+"px";a.removeClass(t,"draggable")}else{var x=a.adjustedCoordinates(u,t);t.style.left=x.x+"px";t.style.top=x.y+"px";delete (t.style.height);m.style.Maxheight="500px";a.addClass(t,"draggable")}}}}}(this);this.clickEditPropertyDescription=function(a){return function(h){if(!h){h=window.event}a.resetPropertyColor();a.resetPropertyFilter();a.resetPropertyExample();var f=a.$(a.target+"-cX-Configurator");var g=a.$(a.target+"-cX-ConfiguratorSugestions");var u=a.$(a.target+"-cX-ConfiguratorSugestionsDescriptionEditSpan");var m=a.$(a.target+"-cX-ConfiguratorOptions");if(f&&g&&u&&m){m.style.display="none";var t=a.adjustedCoordinates(h,g);if(t){a.editingDescriptionOn=true;var r=t.x;var o=t.y;var j=a.$cX("div",{id:a.target+"-cX-ConfiguratorEditForm",className:"CanvasXpressConfigurator draggable"},{cursor:"move",left:r+"px",top:o+"px",padding:"10px",position:"absolute",width:(a.configuratorWidth*0.8)+"px"});var l=a.$cX("img",{id:a.target+"-cX-ConfiguratorEditFormClose",className:"CanvasXpressConfigurator",src:a.imageDir+"cancel1.png",alt:"Close",title:"Close"});var q=a.$cX("textarea",{id:a.target+"-cX-ConfiguratorEditFormValue",className:"CanvasXpressConfigurator",value:u.prop+u.innerHTML,rows:10},{width:"100%",maxWidth:(a.configuratorWidth*0.8)+"px"});var n=a.$cX("input",{id:a.target+"-cX-ConfiguratorEditFormButton",value:"Submit",type:"button"},{width:"100%",borderRadius:"5px",maxWidth:(a.configuratorWidth*0.8)+"px"});j.appendChild(document.createTextNode("Editing "+g.value));j.appendChild(l);j.appendChild(a.$cX("br"));j.appendChild(q);j.appendChild(n);a.addEvtListener(l,"click",a.closeEditPropertyDescription,false);a.addEvtListener(n,"click",a.submitEditPropertyDescription,false);f.appendChild(j)}}}}(this);this.submitEditPropertyDescription=function(a){return function(f){if(!f){f=window.event}var c=a.$(a.target+"-cX-ConfiguratorSugestions");var b=a.$(a.target+"-cX-ConfiguratorEditFormValue");var d=a.$(a.target+"-cX-ConfiguratorSugestionsDescriptionEditSpan");if(c&&b&&d){b.value=b.value.replace(/\n/g,"");CanvasXpress.doc.P[c.value].C=b.value;d.innerHTML=b.value;alert("New description for:\n - "+c.value+" -\nwas submitted and may apppear\nin new versions of CanvasXpress\nThank you for your contribution")}a.resetEditPropertyDescription()}}(this);this.closeEditPropertyDescription=function(a){return function(b){if(!b){b=window.event}a.resetEditPropertyDescription()}}(this);this.resetEditPropertyDescription=function(){var e=this.$(this.target+"-cX-ConfiguratorEditForm");var f=this.$(this.target+"-cX-ConfiguratorEditFormClose");var a=this.$(this.target+"-cX-ConfiguratorEditFormButton");if(e&&f&&a){this.addEvtListener(f,"click",this.closeEditPropertyDescription,false);this.addEvtListener(a,"click",this.submitEditPropertyDescription,false);e.parentNode.removeChild(e)}this.editingDescriptionOn=false};this.addPropertySeeAlsoLinks=function(e,g){this.resetPropertySeeAlsoLinks(e);var d=this.$cX("span",false,{className:"CanvasXpressConfigurator"});d.appendChild(document.createTextNode("See Also: "));e.appendChild(d);if(g&&g.S){for(var f=0;f<g.S.length;f++){var h=this.$cX("a",{href:"javascript:void(0)",innerHTML:g.S[f]});this.addEvtListener(h,"click",this.clickPropertySeeAlsoLinks,false);e.appendChild(h);if(f<g.S.length-1){e.appendChild(document.createTextNode(", "))}}}};this.clickPropertySeeAlsoLinks=function(a){return function(h){if(!h){h=window.event}var f=a.$(a.target+"-cX-ConfiguratorKey");var b=a.$(a.target+"-cX-ConfiguratorCategories");var g=a.$(a.target+"-cX-ConfiguratorSugestions");var c=h.target||h.srcElement;if(b&&b.style.display=="block"){var l=CanvasXpress.doc.P[c.innerHTML];var j=CanvasXpress.doc.M[l.M].P.sort();b.value=l.M;for(i=0;i<j.length;i++){if(j[i]==c.innerHTML){a.changeCategory(h,i);return false}}a.changeCategory(h)}else{if(f){f.value=c.innerHTML;a.selectConfig(h,true)}}return false}}(this);this.resetPropertySeeAlsoLinks=function(b){if(!b){b=this.$(this.target+"-cX-ConfiguratorSeeAlso")}if(b&&b.childNodes){while(b.childNodes.length>0){var d=b.childNodes[0];if(d.nodeName.toLowerCase()=="a"){this.removeEvtListener(d,"click",this.clickPropertySeeAlsoLinks,false)}b.removeChild(d)}}};this.addPropertyOptions=function(w,p,f,g,s){this.resetPropertyOptions(w,p);var q=this.$cX("span",false,{className:"CanvasXpressConfigurator"});var l=this.$cX("i");q.appendChild(document.createTextNode("Current value"));if(f&&f.T&&(f.T=="option"||f.T=="array"||f.T=="boolean")){var x=this.$cX("div",{id:this.target+"-cX-ConfiguratorOptionsContainer",className:"CanvasXpressConfiguratorOptions"});var r=this.$cX("a",{href:"javascript:void(0)",innerHTML:f.T,alt:"Modify property",title:"Modify property"});this.addEvtListener(r,"click",this.clickPropertyOptions,false);q.appendChild(document.createTextNode(" ["));l.appendChild(r);q.appendChild(document.createTextNode(" "));q.appendChild(l);q.appendChild(document.createTextNode(" ]"));if(f.T=="array"){var n=f.X?this[f.X]():f.O?f.O:[];var m=this.getObjectArray(s);if(n.length>0){for(var h=0;h<n.length;h++){var g=this.$cX("input",{type:"checkbox",value:n[h],checked:m.hasOwnProperty(n[h])?true:false},{marginLeft:"0px"});this.addEvtListener(g,"change",this.updatePropertyValue,false);x.appendChild(document.createTextNode((h+1)+". "));x.appendChild(g);x.appendChild(document.createTextNode(n[h]));x.appendChild(this.$cX("br"))}}else{x.appendChild(this.$cX("br"));x.appendChild(document.createTextNode("This array is user defined"));x.appendChild(this.$cX("br"))}}else{var n=f.T=="boolean"?["true","false"]:f.X?this[f.X]():f.O?f.O:[];if(f.X&&f.O){n=n.concat(f.O)}for(var h=0;h<n.length;h++){var g=this.$cX("a",{href:"javascript:void(0)",innerHTML:n[h],alt:"Modify property",title:"Modify property"},{padding:"2px"});this.addEvtListener(g,"click",this.updatePropertyValue,false);x.appendChild(document.createTextNode((h+1)+". "));x.appendChild(g);x.appendChild(this.$cX("br"))}}p.appendChild(x)}else{if(f&&f.T){q.appendChild(document.createTextNode(" ["));if(f.T=="color"){var n;if(this.configuringNetwork){if(this.configuringNetwork<this.data.nodes.length){n=this.data.nodes[this.configuringNetwork][g]}else{n=this.data.edges[this.configuringNetwork-this.data.nodes.length][g]}}else{if(this.configuringGenome){var e=this.subtracksInfo;if(!isNaN(this.configuringGenome)){n=this.data.tracks[e[this.configuringGenome].track].data[e[this.configuringGenome].index]}else{if(this.configuringGenome.match(/:/)){n=parseInt(this.configuringGenome.split(":")[1]);n=this.data.tracks[e[n].track].data[e[n].index]}else{n=parseInt(this.configuringGenome.replace("track-",""));n=this.data.tracks[e[n].track]}}}else{n=this[g]}}var r=this.$cX("a",{id:this.target+"-cX-ConfiguratorValueHREF",href:"javascript:void(0)",innerHTML:f.T,alt:"Modify color",title:"Modify color"},{color:n?this.rgbToHex(this.validateColor(n)):this.foreground});this.addEvtListener(r,"click",this.addPropertyColor,false);l.appendChild(r)}else{if(f&&f.T=="filter"){var r=this.$cX("a",{id:this.target+"-cX-ConfiguratorValueFilter",href:"javascript:void(0)",innerHTML:f.T,name:g});r.opts=f.X?this[f.X]():f.O?f.O:[];r.opts.unshift("");this.addEvtListener(r,"click",this.addPropertyFilter,false);l.appendChild(r)}else{l.appendChild(document.createTextNode(f.T))}}q.appendChild(document.createTextNode(" "));q.appendChild(l);q.appendChild(document.createTextNode(" ]"))}}w.appendChild(q)};this.clickPropertyOptions=function(a){return function(b){if(!b){b=window.event}a.resetEditPropertyDescription();var c=a.$(a.target+"-cX-ConfiguratorOptions");if(c){c.style.display="block";c.style.left=b.layerX+"px";c.style.top=b.layerY+"px"}return false}}(this);this.closePropertyOptions=function(a){return function(b){if(!b){b=window.event}a.handleHideDiv(a.target+"-cX-ConfiguratorOptions")}}(this);this.resetPropertyOptions=function(a,e,b){if(!a){a=this.$(this.target+"-cX-ConfiguratorValueText")}if(!e){e=this.$(this.target+"-cX-ConfiguratorOptions")}if(a&&a.childNodes&&!b){while(a.childNodes.length>0){var f=a.childNodes[0];if(f.nodeName.toLowerCase()=="a"){this.removeEvtListener(f,"click",this.clickPropertyOptions,false)}a.removeChild(f)}}if(e){var d=this.$(this.target+"-cX-ConfiguratorOptionsContainer");if(d){while(d.childNodes.length>0){var f=d.childNodes[0];if(f.nodeName.toLowerCase()=="a"){this.removeEvtListener(f,"click",this.updatePropertyValue,false)}else{if(f.nodeName.toLowerCase()=="input"&&f.type=="checkbox"){this.removeEvtListener(f,"change",this.updatePropertyValue,false)}}d.removeChild(f)}e.removeChild(d)}e.style.display="none"}};this.addPropertyFilter=function(a){return function(d){if(!d){d=window.event}a.resetEditPropertyDescription();var b=d.target||d.srcElement;var c=a.$(a.target+"-cX-ConfiguratorFilter");a.addAllPropertyFilters(b.name,b.opts);c.style.display="block";c.opts=b.opts;c.style.left=d.layerX+"px";c.style.top=d.layerY+"px"}}(this);this.addAllPropertyFilters=function(c,d){var b=this.$(this.target+"-cX-ConfiguratorFilter");for(var a=0;a<this[c].length;a++){this.insertPropertyFilterRow(b,a,c,d)}this.insertPropertyFilterRow(b,this[c].length,c,d)};this.insertPropertyFilterRow=function(F,B,r,y){if(!F){F=this.$(this.target+"-cX-ConfiguratorFilter")}if(F){var e=this.configuratorWidth*0.25;var G=this.$cX("div",{id:this.target+"-cX-ConfiguratorFilterContainer"+B},{width:(this.configuratorWidth*1.05)+"px"});var q=this.$cX("select",{id:this.target+"-cX-ConfiguratorFilterSelect"+B,className:"CanvasXpressConfiguratorFilter",param:r,idx:B},{marginRight:"2px",marginLeft:"1px",width:e+"px"});if(!y){y=F.opts}y.sort();for(var A=0;A<y.length;A++){var d=this.$cX("option",{text:y[A],value:y[A]});try{q.add(d,null)}catch(E){q.add(d)}if(this[r][B]&&y[A]==this[r][B]){d.selected=true}}this.addEvtListener(q,"change",this.unsetPropertyFilterRow,false);var t=this.$cX("select",{id:this.target+"-cX-ConfiguratorFilterOp"+B,className:"CanvasXpressConfiguratorFilter",param:r,idx:B},{marginRight:"2px",width:e+"px"});var x=this.getOperators();for(var A=0;A<x.length;A++){var d=this.$cX("option",{text:x[A],value:x[A]});try{t.add(d,null)}catch(E){t.add(d)}if(this[r+"Op"][B]&&x[A]==this[r+"Op"][B]){d.selected=true}}this.addEvtListener(t,"change",this.unsetPropertyFilterRow,false);var I=this.$cX("img",{src:this.imageDir+"case_sensitive.png"},{width:"10px"});var H=this.$cX("input",{id:this.target+"-cX-ConfiguratorFilterCase"+B,type:"checkbox",param:r,idx:B,alt:"Check for case sensitive",title:"Check for case sensitive"},{width:"10px"});if(this[r+"Case"][B]){H.checked=true}this.addEvtListener(H,"change",this.unsetPropertyFilterRow,false);var n=this.$cX("input",{id:this.target+"-cX-ConfiguratorFilterValue"+B,param:r,idx:B,type:"text"},{width:e+"px"});if(this[r+"Value"][B]){n.value=this[r+"Value"][B]}this.addEvtListener(n,"change",this.unsetPropertyFilterRow,false);var u=this.$cX("img",{id:this.target+"-cX-ConfiguratorFilterMinus"+B,src:this.imageDir+"minus.png",alt:"Remove Filter",title:"Remove Filter",param:r,idx:B},{padding:"9px 2px 2px 2px",cssFloat:"left",cursor:"default",width:"10px"});this.addEvtListener(u,"click",this.removePropertyFilterRow,false);var e=this.$cX("img",{id:this.target+"-cX-ConfiguratorFilterPlus"+B,src:this.imageDir+"add1.png",alt:"Set Filter",title:"Set Filter",param:r,idx:B},{padding:"7px 2px 2px 2px",cssFloat:"right",cursor:"default",width:"10px"});this.addEvtListener(e,"click",this.addPropertyFilterRow,false);var D=this.$cX("img",{id:this.target+"-cX-ConfiguratorFilterCheck"+B,src:this.imageDir+"accept.png",alt:"Filter added",title:"Filter added"},{padding:"7px 2px 2px 2px",cssFloat:"right",cursor:"default",width:"10px",display:this[r][B]?"block":"none"});var C=this.$cX("div",{id:this.target+"-cX-ConfiguratorFilterCheckEmpty"+B},{cssFloat:"right",cursor:"default",width:"10px",display:this[r][B]?"none":"block"});G.appendChild(u);G.appendChild(q);G.appendChild(t);G.appendChild(I);G.appendChild(H);G.appendChild(n);G.appendChild(C);G.appendChild(D);G.appendChild(e);F.appendChild(G)}};this.addPropertyFilterRow=function(a){return function(q){if(!q){q=window.event}var b=q.target||q.srcElement;var d=b.parentNode;var r=b.param;var l=b.idx;var t=a.$(a.target+"-cX-ConfiguratorValue");var n=a.$(a.target+"-cX-ConfiguratorFilterCheck"+l);var m=a.$(a.target+"-cX-ConfiguratorFilterCheckEmpty"+l);if(d&&r&&l!=null&&t&&n&&m){var j=d.childNodes[1].value;var f=d.childNodes[2].value;var s=d.childNodes[4].checked;var u=d.childNodes[5].value;if(j!=""&&((f!=""&&u!="")||f.match("null"))){if(a[r].length>0&&a[r][l]!=null){a[r][l]=j;a[r+"Op"][l]=f;a[r+"Value"][l]=u;a[r+"Case"][l]=s}else{a[r].push(j);a[r+"Op"].push(f);a[r+"Value"].push(u);a[r+"Case"].push(s);a.insertPropertyFilterRow(false,l+1,r)}t.value='["'+a[r].join('", "')+'"]';n.style.display="block";m.style.display="none"}}}}(this);this.removePropertyFilterRow=function(a){return function(k){if(!k){k=window.event}var d=k.target||k.srcElement;var j=d.parentNode;var h=j.parentNode;var l=d.param;var f=d.idx;var b=a.$(a.target+"-cX-ConfiguratorValue");if(j&&l&&f!=null&&b){a.resetFilters(l,f);a.resetPropertyFilter(true);a.addAllPropertyFilters(l,h.opts);b.value=a[l].length>0?'["'+a[l].join('", "')+'"]':"[]"}}}(this);this.unsetPropertyFilterRow=function(a){return function(m){if(!m){m=window.event}var p=[];var b=m.target||m.srcElement;var n=b.param;var f=b.idx;if(n&&f!=null){if(a[n].length>0&&a[n][f]){a[n][f]=false;a[n+"Op"][f]=false;a[n+"Value"][f]=false;a[n+"Case"][f]=false;for(var d=0;d<a[n].length;d++){if(d!=f){p.push(a[n][d])}}var l=a.$(a.target+"-cX-ConfiguratorFilterCheck"+f);var k=a.$(a.target+"-cX-ConfiguratorFilterCheckEmpty"+f);var o=a.$(a.target+"-cX-ConfiguratorValue");if(l&&k&&o){l.style.display="none";k.style.display="block";o.value=p.length>0?'["'+p.join('", "')+'"]':"[]"}}}}}(this);this.closePropertyFilter=function(a){return function(b){if(!b){b=window.event}a.handleHideDiv(a.target+"-cX-ConfiguratorFilter");a.resetPropertyFilter()}}(this);this.closePropertyExample=function(a){return function(b){if(!b){b=window.event}a.handleHideDiv(a.target+"-cX-ConfiguratorExample");a.resetPropertyExample()}}(this);this.resetPropertyFilter=function(a){var b=this.$(this.target+"-cX-ConfiguratorFilter");if(b){if(b&&b.childNodes){while(b.childNodes.length>3){var c=b.childNodes[3];this.removeEvtListener(c.childNodes[0],"click",this.removePropertyFilterRow,false);this.removeEvtListener(c.childNodes[1],"change",this.unsetPropertyFilterRow,false);this.removeEvtListener(c.childNodes[2],"change",this.unsetPropertyFilterRow,false);this.removeEvtListener(c.childNodes[4],"change",this.unsetPropertyFilterRow,false);this.removeEvtListener(c.childNodes[5],"change",this.unsetPropertyFilterRow,false);this.removeEvtListener(c.childNodes[8],"click",this.addPropertyFilterRow,false);b.removeChild(b.childNodes[3])}}if(!a){b.style.display="none"}}};this.resetPropertyExample=function(a){var b=this.$(this.target+"-cX-ConfiguratorExample");if(b){var c=b.getElementsByTagName("canvas");while(c.length>0){this.destroy(c[0].id)}if(!a){b.style.display="none"}}};this.addPropertyColor=function(a){return function(j){if(!j){j=window.event}a.resetEditPropertyDescription();var d=a.$(a.target+"-cX-ConfiguratorColor");var t=a.$(a.target+"-cX-ConfiguratorValue");if(d&&t){var g=t.value?a.rgbToHex(a.validateColor(t.value.replace(/[\'\"]/g,""))):a.foreground;a.colorRGBfromString(g);var r=Math.round(a.colorHSV[0]/6*180);var q=Math.round((1-a.colorHSV[1])*100);var m=Math.round((1-a.colorHSV[2])*100);var l=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorContainer"},{width:"210px",height:"101px",marginTop:"7px"});var b=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorPalette",className:"CanvasXpressConfiguratorColor"},{position:"relative",left:"0px",top:"0px",width:"181px",height:"101px",backgroundImage:"url('"+a.imageDir+"color.png')",backgroundRepeat:"no-repeat",cursor:"crosshair"});var o=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorPaletteCurrent"},{position:"relative",left:(r-7)+"px",top:(q-7)+"px",width:"195px",height:"115px",cursor:"crosshair",backgroundImage:"url('"+a.imageDir+"cross.gif')",backgroundRepeat:"no-repeat"});b.appendChild(o);var w=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorSaturation",className:"CanvasXpressConfiguratorColor"},{position:"relative",left:"188px",top:"-102px",width:"15px",height:"100px",border:"1px solid "+a.skinBorderColor,cursor:"crosshair"});for(var f=0;f<100;f+=4){var u=a.$cX("div",false,{height:"4px",position:"relative",left:"0px",cursor:"crosshair"});w.appendChild(u)}var k=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorSaturationCurrent"},{position:"relative",left:"0px",top:(m-108)+"px",width:"29px",height:"115px",cursor:"crosshair",backgroundImage:"url('"+a.imageDir+"cross.gif')",backgroundRepeat:"no-repeat",overflow:"hidden"});w.appendChild(k);l.appendChild(b);l.appendChild(w);d.appendChild(l);a.colorizeCurrentColorDiv();a.colorizeSaturationColorDiv();a.addEvtListener(b,"mousedown",a.registerPalette,false);a.addEvtListener(w,"mousedown",a.registerSaturation,false);d.style.display="block";d.style.left=j.layerX+"px";d.style.top=j.layerY+"px"}return false}}(this);this.registerPalette=function(a){return function(b){if(!b){b=window.event}a.changingColorOn="palette";if(a.colorHSV[2]==0){a.colorFromHsv(null,null,1);a.colorizeCurrentColorDiv();var c=a.$(a.target+"-cX-ConfiguratorColorSaturationCurrent");if(c){c.style.top="-108px"}}a.updateColorValue(b);a.colorizeSaturationColorDiv();return false}}(this);this.registerSaturation=function(a){return function(b){if(!b){b=window.event}a.changingColorOn="saturation";a.updateColorValue(b);return false}}(this);this.updateColorValue=function(g){if(this.changingColorOn){if(this.changingColorOn=="palette"){var f=this.$(this.target+"-cX-ConfiguratorColorPalette");var b=this.$(this.target+"-cX-ConfiguratorColorPaletteCurrent");if(f&&b){var d=this.adjustedCoordinates(g,f);if(d){var a=Math.min(Math.max(0,d.x),181);var j=Math.min(Math.max(0,d.y),101);b.style.left=(a-7)+"px";b.style.top=(j-7)+"px";this.colorFromHsv(a*6/180,1-j/100,null);this.colorizeCurrentColorDiv();this.colorizeSaturationColorDiv()}}}else{var c=this.$(this.target+"-cX-ConfiguratorColorSaturation");var h=this.$(this.target+"-cX-ConfiguratorColorSaturationCurrent");if(c&&h){var d=this.adjustedCoordinates(g,c);if(d){var j=Math.min(Math.max(0,d.y),101);h.style.top=(j-108)+"px";this.colorFromHsv(null,null,1-j/100);this.colorizeCurrentColorDiv()}}}}};this.colorizeCurrentColorDiv=function(){var f=this.$(this.target+"-cX-ConfiguratorColorCurrent");var a=this.$(this.target+"-cX-ConfiguratorValue");var d=this.$(this.target+"-cX-ConfiguratorValueHREF");if(f&&a&&d){var e=this.colorRGBToString();var b=this.hexToRgb("#"+e);f.style.backgroundColor="#"+e;f.innerHTML="&nbsp;&nbsp;"+b;f.style.color=this.complementaryColor(b,true);a.value='"'+b+'"';d.style.color="#"+e}};this.colorizeSaturationColorDiv=function(){var b=function(m,k,c,j,h){return"rgb("+(m*(1-j/h)*100)+"%,"+(k*(1-j/h)*100)+"%,"+(c*(1-j/h)*100)+"%)"};var e=this.$(this.target+"-cX-ConfiguratorColorSaturation");if(e&&this.colorHSV){var f=e.childNodes;var a=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],1);if(a){for(var d=0;d<f.length-1;d++){f[d].style.backgroundColor=b(a[0],a[1],a[2],d,f.length-1)}}}};this.endColorChange=function(a){this.changingColorOn=false};this.closePropertyColor=function(a){return function(b){if(!b){b=window.event}a.handleHideDiv(a.target+"-cX-ConfiguratorColor");a.resetPropertyColor()}}(this);this.resetPropertyColor=function(){var c=this.$(this.target+"-cX-ConfiguratorColor");var b=this.$(this.target+"-cX-ConfiguratorColorPalette");var a=this.$(this.target+"-cX-ConfiguratorColorSaturation");if(c&&b&&a){if(c&&c.childNodes){while(c.childNodes.length>3){c.removeChild(c.childNodes[3])}this.removeEvtListener(b,"mousedown",this.registerPalette,false);this.removeEvtListener(a,"mousedown",this.registerSaturation,false)}c.style.display="none"}};this.updatePropertyValue=function(a){return function(h){if(!h){h=window.event}a.resetEditPropertyDescription();var f=a.$(a.target+"-cX-ConfiguratorValue");var j=a.$(a.target+"-cX-ConfiguratorOptions");var d=h.target||h.srcElement;if(d.nodeName.toLowerCase()=="input"){var b=[];for(var g=0;g<d.parentNode.childNodes.length;g++){var k=d.parentNode.childNodes[g];if(k.checked){b.push(k.value)}}f.value=b.length>0?'["'+b.join('", "')+'"]':"[]"}else{if(f&&j){if(d.innerHTML=="true"){f.value=d.innerHTML}else{if(d.innerHTML=="false"){f.value=d.innerHTML}else{if(d.innerHTML=="null"){f.value=d.innerHTML}else{f.value='"'+d.innerHTML+'"'}}}j.style.display="none"}}return false}}(this);this.clickApplyConfigurator=function(a){return function(b){return a.clickConfigurator(b,false,false,true)}}(this);this.clickConfigurator=function(a){return function(g,m,l,j){if(!g){g=window.event}if(!m){m=a.$(a.target+"-cX-ConfiguratorSugestions")}if(!l){l=a.$(a.target+"-cX-ConfiguratorValue")}if(m&&l){var k=a.getConfigurableObjectDoc(m.value);if(l.value){var b=JSON.parse(l.value);if(k.T=="color"&&!a.validateColor(b)){alert('"'+b+'" is NOT a valid color');return false}}if(a.configuringNetwork){if(a.configuringNetwork<a.data.nodes.length){if(typeof(a[m.value])=="function"){a[m.value](a.data.nodes[a.configuringNetwork])}else{a.data.nodes[a.configuringNetwork][m.value]=JSON.parse(l.value)}}else{if(typeof(a[m.value])=="function"){a[m.value](a.data.edges[a.configuringNetwork-a.data.nodes.length])}else{a.data.edges[a.configuringNetwork-a.data.nodes.length][m.value]=JSON.parse(l.value)}}}else{if(a.configuringGenome){var c=a.subtracksInfo;if(!isNaN(a.configuringGenome)){a.data.tracks[c[a.configuringGenome].track].data[c[a.configuringGenome].index][m.value]=JSON.parse(l.value)}else{if(a.configuringGenome.match(/:/)){var h=parseInt(a.configuringGenome.split(":")[1]);a.data.tracks[c[h].track].data[c[h].index][m.value]=JSON.parse(l.value)}else{var h=parseInt(a.configuringGenome.replace("track-",""));a.data.tracks[h][m.value]=JSON.parse(l.value)}}}else{if(typeof(a[m.value])=="function"){if(a[m.value].length>0&&l&&l.value){var j=JSON.parse(l.value);a[m.value](j)}else{a[m.value]()}a.resetConfigurator();return false}else{a[m.value]=JSON.parse(l.value);a.userConfig[m.value]=a[m.value]}}}if(!j){a.resetConfigurator()}var d=m.value.match(/filter(.+)By/);if(d){a.reset();a.filterData()}a.resetPropertyExample();a.draw()}return false}}(this);this.handleHideDiv=function(a){var b=this.$(a);if(b){b.style.display="none"}return false};this.resetOptionColorFiltersExamples=function(){this.resetPropertyOptions(false,false,true);this.resetPropertyColor();this.resetPropertyFilter();this.resetPropertyExample()};this.resetEditOptionColorFiltersExamples=function(){this.resetEditPropertyDescription();this.resetPropertyOptions(false,false,true);this.resetPropertyFilter();this.resetPropertyExample()};this.resetConfigurator=function(){if(this.configuringOn&&this.configuringOn!="docked"){this.resetEditOptionColorFiltersExamples();this.resetPropertyDescription();this.resetPropertySeeAlsoLinks();this.editingDescriptionOn=false;this.configuratorLastState=false;this.configuringOn=false;this.configuringNetwork=false;this.configuringGenome=false;this.addRemoveConfiguratorListeners("removeEvtListener");this.removeTarget(this.target+"-cX-Configurator")}}};CanvasXpress.prototype.initAcknowlegments=function(){this.addAcknowledgmentDiv=function(){if(this.$(this.target+"canvasXpressAcknowledgmentDiv")){this.setAcknowledgmentVisibility();return}var f=document.createElement("div");f.id=this.target+"canvasXpressAcknowledgmentDiv";f.style.display=this.acknowledgment?"block":"none";f.style.width=this.width+"px";f.style.cssFloat="left";f.style.position="relative";f.style.zIndex=9999;this.setAcknowledgmentPosition(f);var c=document.createElement("img");c.src=this.imageDir+this.acknowledgmentIcon;c.style.margin="2px";c.alt="Graphs powered by canvasXpress";c.title="Graphs powered by canvasXpress";c.style.cssFloat="right";var b=document.createElement("a");b.href="http://canvasxpress.org";b.target="_blank";b.style.cssFloat="right";b.appendChild(c);f.appendChild(b);var e=this.$("south-wrapper-"+this.target);if(e){e.appendChild(f)}};this.resizeAcknowledgmentDiv=function(){var b=this.$(this.target+"canvasXpressAcknowledgmentDiv");if(b){b.style.width=this.width+"px"}};this.setAcknowledgmentVisibility=function(){var b=this.$(this.target+"canvasXpressAcknowledgmentDiv");if(b){b.style.display=this.acknowledgment?"block":"none";this.setAcknowledgmentPosition(b)}};this.setAcknowledgmentPosition=function(b){if(b){if(this.acknowledgmentIconPosition=="inside"){b.style.top=this.citation?(((this.citationFontSize*this.citationScaleFontFactor)+36)*-1)+"px":"-31px";b.style.right="3px"}else{b.style.top="0px";b.style.right="0px"}}};this.addAcknowledgmentDiv()};CanvasXpress.prototype.initCodeInfo=function(){this.addInfoCodeDiv=function(){if(this.$(this.target+"-cX-Code")){return}var g=this.$cX("div",{id:this.target+"-cX-Info",className:"CanvasXpressInfo"},{display:"none"});var h=this.$cX("div",{id:this.target+"-cX-Code",className:"CanvasXpressCode draggable"},{left:"50px",top:"-200px",display:"none"});var j=this.$cX("img",{id:this.target+"-cX-CodeCloseImage",className:"CanvasXpressCode",src:this.imageDir+"cancel1.png",alt:"Close Code",title:"Close Code"});var f=this.$cX("img",{id:this.target+"-cX-CodePrettyImage",className:"CanvasXpressCode",src:this.imageDir+"blue_code.png",alt:"Pretty Code",title:"Pretty Code"});var e=this.$cX("img",{id:this.target+"-cX-CodeCompactImage",className:"CanvasXpressCode",src:this.imageDir+"green_code.png",alt:"Compact Code",title:"Compact Code"});var d=this.$cX("img",{id:this.target+"-cX-CodeTabImage",className:"CanvasXpressCode",src:this.imageDir+"yellow_code.png",alt:"Tab Code",title:"Tab Code"});var b=this.$cX("img",{id:this.target+"-cX-CodeParamsImage",className:"CanvasXpressCode",src:this.imageDir+"red_code.png",alt:"Params Code",title:"Params Code"});var g=this.$cX("div",{id:this.target+"-cX-CodeContainer",className:"CanvasXpressCodeContainer"});var a=this.$("north-wrapper-"+this.target);var k=this.$("south-wrapper-"+this.target);if(a){a.appendChild(g)}if(k){h.appendChild(j);h.appendChild(f);h.appendChild(e);h.appendChild(d);h.appendChild(b);h.appendChild(g);k.appendChild(h);this.addRemoveCodeListeners("addEvtListener")}};this.addRemoveCodeListeners=function(a){this.addRemoveEvtListener(a,this.$(this.target+"-cX-Code"),"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeCloseImage"),"click",this.clickCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodePrettyImage"),"click",this.clickChangeCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeCompactImage"),"click",this.clickChangeCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeTabImage"),"click",this.clickChangeCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeParamsImage"),"click",this.clickChangeCode,false)};this.clickCode=function(a){return function(b){if(!b){b=window.event}a.hideCodeDiv();return false}}(this);this.clickChangeCode=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);switch(b.id){case a.target+"-cX-CodePrettyImage":a.codeType="pretty";break;case a.target+"-cX-CodeCompactImage":a.codeType="compact";break;case a.target+"-cX-CodeTabImage":a.codeType="tab";break;case a.target+"-cX-CodeParamsImage":a.codeType="params";break;default:break}a.updateCodeDiv();return false}}(this);this.clearCodeDiv=function(){var b=this.$(this.target+"-cX-Code");var a=this.$(this.target+"-cX-CodeContent");if(b&&a){a.parentNode.removeChild(a);b.style.display="none"}};this.updateCodeDiv=function(i){var j=this.$(this.target+"-cX-Code");var d=this.$(this.target+"-cX-CodeContainer");var g=this.cloneObject(this.data);var e=this.codeType=="pretty"?this.prettyJSON(g):this.codeType=="params"?"{\n  ...\n}":JSON.stringify(g);var f=this.codeType=="pretty"||this.codeType=="params"?this.prettyJSON(this.getConfig()):JSON.stringify(this.getConfig());if(j&&d){this.clearCodeDiv();var a=this.codeType=="tab"||this.codeType=="compact"?"span":"pre";var b=this.codeType=="tab"?"canvasID\t"+e+"\t"+f+"\n":'new CanvasXpress("canvasID", '+e+", "+f+")\n";d.appendChild(this.$cX(a,{id:this.target+"-cX-CodeContent",className:"CanvasXpressCodeContent",innerHTML:b}));j.style.display="block";if(i){j.style.zIndex=i}}};this.updateInfoDiv=function(a){var b=this.$(this.target+"-cX-Info");if(b&&a){b.innerHTML=a}};this.showDiv=function(a){var b=this.$(this.target+"-cX-"+a);if(b){b.style.display="block"}};this.hideDiv=function(a){var b=this.$(this.target+"-cX-"+a);if(b){b.style.display="none"}};this.showCodeDiv=function(){this.updateCodeDiv();this.showDiv("Code")};this.hideCodeDiv=function(){this.hideDiv("Code")};this.showInfoDiv=function(){this.showDiv("Info")};this.hideInfoDiv=function(){this.hideDiv("Info")};this.initializeCodeInfo=function(){this.addInfoCodeDiv()};this.initializeCodeInfo()};CanvasXpress.prototype.initDataFilter=function(){this.addDataFilterDiv=function(){if(this.$(this.target+"-cX-DataFilter")){return}var j=this.dataFilterLastX!=null?parseInt(this.dataFilterLastX):-this.canvas.width*0.5;var h=this.dataFilterLastY!=null?parseInt(this.dataFilterLastY):this.canvas.height*0.5;var u=this.graphType=="Genome"?60:81;this.dataFilterHeight=this.canvas.height-u;this.activeAccordion=null;var B=this.$cX("div",{id:this.target+"-cX-DataFilter",className:this.applicationLook?"CanvasXpressDataFilter fixed":"CanvasXpressDataFilter draggable-container"},{top:h+"px",left:j+"px",display:"none",zIndex:10000});var o=this.$cX("div",{id:this.target+"-cX-DataFilterToolbar",className:this.applicationLook?"CanvasXpressDataFilterToolbar fixed":"CanvasXpressDataFilterToolbar draggable"},{width:this.dataFilterWidth+"px"});var b=this.$cX("span",{innerHTML:"Filters",className:"CanvasXpressDataFilterToolbarText"});var s=this.$cX("img",{id:this.target+"-cX-DataFilterKeyFlash",className:"CanvasXpressDataFilterToolbarImage",src:this.filterFlashingOn?this.imageDir+"lightbulb.png":this.imageDir+"lightbulb_off.png",alt:this.filterFlashingOn?"Turn off Flashing":"Turn on Flashing",title:this.filterFlashingOn?"Turn off Flashing":"Turn on Flashing"},{display:this.graphType=="Network"?"block":"none"});if(this.isIE){s.style.marginTop="-10px"}var g=this.$cX("img",{id:this.target+"-cX-DataFilterKeyReset",className:"CanvasXpressDataFilterToolbarImage",src:this.imageDir+"funnel_cross.png",alt:"Reset filters",title:"Reset filters"});if(this.isIE){g.style.marginTop="-10px"}var v=this.$cX("img",{id:this.target+"-cX-DataFilterKeyDock",className:"CanvasXpressDataFilterToolbarImage",src:this.applicationLook?this.imageDir+"unpin.png":this.imageDir+"pin.png",alt:this.applicationLook?"Undock":"Dock",title:this.applicationLook?"Undock":"Dock",state:this.applicationLook?"docked":"free"});if(this.isIE){v.style.marginTop="-10px"}var x=this.$cX("img",{id:this.target+"-cX-DataFilterKeyClose",className:"CanvasXpressDataFilterToolbarImage",src:this.imageDir+"cancel1.png",alt:"Close",title:"Close"});if(this.isIE){x.style.marginTop="-10px"}var C=this.$cX("div",{id:this.target+"-cX-DataFilterContainer",className:"CanvasXpressDataFilterContainer"},{width:this.dataFilterWidth+"px"});var m=this.$cX("div",{id:this.target+"-cX-DataFilterVariableHeader",className:"CanvasXpressDataFilterHead"},{width:this.dataFilterWidth+"px",display:this.graphType.match(/Genome|Network/)?"none":"block"});var r=this.$cX("div",{id:this.target+"-cX-DataFilterVariableContent",className:"CanvasXpressDataFilterContent"},{width:this.dataFilterWidth+"px",height:"0px",display:"none"});var e=this.$cX("span",{innerHTML:"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Variables",className:"CanvasXpressDataFilterText"});var k=this.$cX("div",{id:this.target+"-cX-DataFilterSampleHeader",className:"CanvasXpressDataFilterHead"},{width:this.dataFilterWidth+"px",display:this.graphType.match(/Genome|Network/)?"none":"block"});var q=this.$cX("div",{id:this.target+"-cX-DataFilterSampleContent",className:"CanvasXpressDataFilterContent"},{width:this.dataFilterWidth+"px",height:"0px",display:"none"});var c=this.$cX("span",{innerHTML:"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Samples",className:"CanvasXpressDataFilterText"});var y=this.$cX("div",{id:this.target+"-cX-DataFilterNodeHeader",className:"CanvasXpressDataFilterHead"},{width:this.dataFilterWidth+"px",display:this.graphType=="Network"?"block":"none"});var A=this.$cX("div",{id:this.target+"-cX-DataFilterNodeContent",className:"CanvasXpressDataFilterContent"},{width:this.dataFilterWidth+"px",height:"0px",display:"none"});var n=this.$cX("span",{innerHTML:"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Nodes",className:"CanvasXpressDataFilterText"});var t=this.$cX("div",{id:this.target+"-cX-DataFilterEdgeHeader",className:"CanvasXpressDataFilterHead"},{width:this.dataFilterWidth+"px",display:this.graphType=="Network"?"block":"none"});var z=this.$cX("div",{id:this.target+"-cX-DataFilterEdgeContent",className:"CanvasXpressDataFilterContent"},{width:this.dataFilterWidth+"px",height:"0px",display:"none"});var i=this.$cX("span",{innerHTML:"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Edges",className:"CanvasXpressDataFilterText"});var f=this.$cX("div",{id:this.target+"-cX-DataFilterGenomeHeader",className:"CanvasXpressDataFilterHead"},{width:this.dataFilterWidth+"px",display:this.graphType=="Genome"?"block":"none"});var l=this.$cX("div",{id:this.target+"-cX-DataFilterGenomeContent",className:"CanvasXpressDataFilterContent"},{width:this.dataFilterWidth+"px",height:"0px",display:"none"});var a=this.$cX("span",{innerHTML:"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Features",className:"CanvasXpressDataFilterText"});o.appendChild(b);o.appendChild(x);o.appendChild(v);o.appendChild(g);o.appendChild(s);m.appendChild(e);k.appendChild(c);y.appendChild(n);t.appendChild(i);f.appendChild(a);C.appendChild(m);C.appendChild(r);C.appendChild(k);C.appendChild(q);C.appendChild(y);C.appendChild(A);C.appendChild(t);C.appendChild(z);C.appendChild(f);C.appendChild(l);B.appendChild(o);B.appendChild(C);var p=this.$("east-wrapper-"+this.target);if(p){p.appendChild(B);this.addRemoveDataFilterListeners("addEvtListener")}};this.addRemoveDataFilterListeners=function(k){var e=this.$(this.target+"-cX-DataFilterToolbar");var a=this.$(this.target+"-cX-DataFilterKeyFlash");var g=this.$(this.target+"-cX-DataFilterKeyReset");var b=this.$(this.target+"-cX-DataFilterKeyDock");var c=this.$(this.target+"-cX-DataFilterKeyClose");var h=this.$(this.target+"-cX-DataFilterVariableHeader");var i=this.$(this.target+"-cX-DataFilterSampleHeader");var d=this.$(this.target+"-cX-DataFilterNodeHeader");var f=this.$(this.target+"-cX-DataFilterEdgeHeader");var j=this.$(this.target+"-cX-DataFilterGenomeHeader");if(e&&a&&g&&b&&c&&h&&i&&d&&f&&j){this[k](e,"mousedown",this.registerMousemove,false);this[k](a,"click",this.flashDataFilter,false);this[k](g,"click",this.resetDataFilter,false);this[k](b,"click",this.dockUndockDataFilter,false);this[k](c,"click",this.hideDataFilter,false);this[k](h,"click",this.activateAccordion,false);this[k](i,"click",this.activateAccordion,false);this[k](d,"click",this.activateAccordion,false);this[k](f,"click",this.activateAccordion,false);this[k](j,"click",this.activateAccordion,false)}};this.flashDataFilter=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);if(a.filterFlashingOn){a.filterFlashingOn=false;b.src=a.imageDir+"lightbulb_off.png";b.alt="Turn on Flashing";b.title="Turn on Flashing"}else{a.filterFlashingOn=true;b.src=a.imageDir+"lightbulb.png";b.alt="Turn off Flashing";b.title="Turn off Flashing"}return false}}(this);this.activateAccordion=function(a){return function(f,b){if(!f){f=window.event}var d=a;if(!b){b=a.getTargetEvent(f)}if(b){if(b.tagName.toLowerCase()=="span"){b=b.parentNode}b.className="CanvasXpressDataFilterHeadActive";b.firstChild.className="CanvasXpressDataFilterTextActive";var c=b.nextSibling;if(c){setTimeout(function(){if(d.activeAccordion&&c.id==d.activeAccordion.id){c=false}d.transitionAccordion(new Date().getTime(),250,c,d.activeAccordion);if(d.activeAccordion){var e=d.activeAccordion.previousSibling;e.className="CanvasXpressDataFilterHead";e.firstChild.className="CanvasXpressDataFilterText"}d.activeAccordion=c},33)}}return false}}(this);this.resizeDataFilterForScroller=function(p){var l=this.$(this.target+"-cX-DataFilter");var c=this.$(this.target+"-cX-DataFilterToolbar");var q=this.$(this.target+"-cX-DataFilterContainer");var h=this.$(this.target+"-cX-DataFilterVariableHeader");var n=this.$(this.target+"-cX-DataFilterVariableContent");var j=this.$(this.target+"-cX-DataFilterSampleHeader");var o=this.$(this.target+"-cX-DataFilterSampleContent");var b=this.$(this.target+"-cX-DataFilterNodeHeader");var g=this.$(this.target+"-cX-DataFilterNodeContent");var f=this.$(this.target+"-cX-DataFilterEdgeHeader");var k=this.$(this.target+"-cX-DataFilterEdgeContent");var m=this.$(this.target+"-cX-DataFilterGenomeHeader");var a=this.$(this.target+"-cX-DataFilterGenomeContent");if(l&&c&&q&&h&&n&&j&&o&&b&&g&&f&&k&&m&&a){this.dataFilterScroller==p?true:false;var e=[l,c,q,h,n,j,o,b,g,f,k,m,a];for(var d=0;d<e.length;d++){if(e[d].style.width!=""){if(p){e[d].style.width=(parseInt(e[d].style.width)+18)+"px"}else{e[d].style.width=(parseInt(e[d].style.width)-18)+"px"}}}}};this.moveDataFilter=function(m){var l,n;var p=this.$(this.target+"-cX-DataFilter");var j=this.$(this.target+"-cX-DataFilterToolbar");var f=this.$(this.target+"-cX-DataFilterKeyDock");var e=this.$(this.remoteParentId+"-canvasXpressRemoteWindow");var g=this.$("north-container-"+this.target);var a=this.$("south-container-"+this.target);var k=this.$("west-container-"+this.target);var t=this.$("middle-container-"+this.target);var d=this.$("east-container-"+this.target);var b=this.$("east-handler-"+this.target);var o=this.$("east-wrapper-"+this.target);var c=64;var r=0;var q=this.showFadeResizeMoveAnimation?500:0;var i=this;if(p&&j&&f&&g&&a&&k&&t&&d&&b&&o){var s=(j.clientWidth-this.dataFilterWidth)+2;n=parseInt(g.clientHeight)+this.canvas.height+parseInt(a.clientHeight);if(f.state=="free"&&!m){j.className="CanvasXpressDataFilterToolbar fixed";f.src=this.imageDir+"unpin.png";f.alt="Undock";f.title="Undock";f.setAttribute("state","docked");this.dataFilterLastState="docked";this.dataFilterLastX=p.style.left;this.dataFilterLastY=p.style.top;b.style.display="block";var l=parseInt(k.style.width)+this.canvas.width+j.clientWidth+7+2;if(e){this.resizeMove(e,0,0,Math.max(l,parseInt(a.clientWidth))+r,n+c)}this.resizeMove(t,0,0,l,this.canvas.height);this.resizeMove(d,0,0,this.dataFilterWidth+s+7,this.canvas.height);this.resizeMove(o,0,0,this.dataFilterWidth+s,this.canvas.height);this.resizeMove(p,0,0,this.dataFilterWidth,this.canvas.height)}else{j.className="CanvasXpressDataFilterToolbar draggable";f.src=this.imageDir+"pin.png";f.alt="Dock";f.title="Dock";f.setAttribute("state","free");this.dataFilterLastState="free";if(m){delete (this.dataFilterLastState);this.dataFilterLastX=null;this.dataFilterLastY=null;this.fade(p,500,function(){i.resetFade(p);p.style.display="none";p.style.width=i.dataFilterWidth+"px";p.style.height=i.canvas.height+"px"})}b.style.display="none";l=parseInt(k.style.width)+this.canvas.width;if(e){this.resizeMove(e,0,0,Math.max(l+7,parseInt(a.clientWidth))+r,n+c)}this.resizeMove(t,0,0,l+7,this.canvas.height);this.resizeMove(d,0,0,7,this.canvas.height);this.resizeMove(o,0,0,0,this.canvas.height);if(!m){this.resizeMove(p,0,0,0,this.canvas.height)}}}};this.updateDataFilter=function(){var h=this;var a=function(n,k,p,i,m){var l={min:">=",max:"<=",like:"like"};h[n].push(m!=null?i+":::"+m:i);h[n+"Op"].push(l[p]);h[n+"Case"].push(false);if(p=="like"){h[n+"Value"].push("^"+h.toDoFilter[k][i][p].join("$|^")+"$")}else{h[n+"Value"].push(h.toDoFilter[k][i][p])}};if(this.filteringStringOn||this.filteringNumericOn){this.resetFilters();var j=false;for(var f in this.toDoFilter){for(var b in this.toDoFilter[f]){for(var g in this.toDoFilter[f][b]){var c=this.toDoFilter[f][b]["ref"];if(g!="ref"){if(f=="sample"){a("filterSmpBy",f,g,b,c)}else{if(f=="variable"){a("filterVarBy",f,g,b,c)}else{if(f=="node"){a("filterNodeBy",f,g,b,c)}else{if(f=="edge"){a("filterEdgeBy",f,g,b,c)}else{if(f=="feature"){a("filterFeatureBy",f,g,b,c)}}}}}}}}}this.reset(true);this.filterData(true);if(this.validateAxesOnFilterData()){if(this.graphType=="Network"&&this.filterFlashingOn){var d=[];for(var e=0;e<this.data.nodes.length;e++){if(!this.data.nodes[e].hide){d.push(this.data.nodes[e].id)}}this.flashNode(d,false,5)}else{if(this.isGroupedData&&this.smpIndices.length>0){this.groupSamples(this.groupingFactors,false,false,true)}else{this.draw()}}}else{this.reset(true);this.draw()}}};this.validateAxesOnFilterData=function(){if(!this.startingXAxisIndices){this.startingXAxis=this.xAxis;this.startingXAxisIndices=this.xAxisIndices}if(!this.startingXAxis2Indices){this.startingXAxis2=this.xAxis2;this.startingXAxis2Indices=this.xAxis2Indices}if(!this.startingYAxisIndices){this.startingYAxis=this.yAxis;this.startingYAxisIndices=this.yAxisIndices}if(!this.startingZAxisIndices){this.startingZAxis=this.zAxis;this.startingZAxisIndices=this.zAxisIndices}if(this.graphType.match(/Scatter/i)){var a=this.getObjectArray(this.smpIndices);this.xAxis=[];this.xAxisIndices=[];for(var b=0;b<this.startingXAxisIndices.length;b++){if(a.hasOwnProperty(this.startingXAxisIndices[b])){this.xAxis.push(this.data.y.smps[this.startingXAxisIndices[b]]);this.xAxisIndices.push(this.startingXAxisIndices[b])}}if(this.xAxisIndices.length<1){this.xAxis=this.startingXAxis;this.xAxisIndices=this.startingXAxisIndices;alert("Cannot filter since there are no samples left in X-Axis");return false}this.yAxis=[];this.yAxisIndices=[];for(var b=0;b<this.startingYAxisIndices.length;b++){if(a.hasOwnProperty(this.startingYAxisIndices[b])){this.yAxis.push(this.data.y.smps[this.startingYAxisIndices[b]]);this.yAxisIndices.push(this.startingYAxisIndices[b])}}if(this.yAxisIndices.length<1){this.yAxis=this.startingYAxis;this.yAxisIndices=this.startingYAxisIndices;alert("Cannot filter since there are no samples left in Y-Axis");return false}if(this.graphType=="Scatter3D"||this.graphType=="ScatterBubble2D"){this.zAxis=[];this.zAxisIndices=[];for(var b=0;b<this.startingZAxisIndices.length;b++){if(a.hasOwnProperty(this.startingZAxisIndices[b])){this.zAxis.push(this.data.y.smps[this.startingZAxisIndices[b]]);this.zAxisIndices.push(this.startingZAxisIndices[b])}}if(this.zAxisIndices.length<1){this.zAxis=this.startingZAxis;this.zAxisIndices=this.startingZAxisIndices;alert("Cannot filter since there are no samples left in Z-Axis");return false}}}else{if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)){var a=this.getObjectArray(this.varIndices);this.xAxis=[];this.xAxisIndices=[];for(var b=0;b<this.startingXAxisIndices.length;b++){if(a.hasOwnProperty(this.startingXAxisIndices[b])){this.xAxis.push(this.data.y.vars[this.startingXAxisIndices[b]]);this.xAxisIndices.push(this.startingXAxisIndices[b])}}if(this.xAxisIndices.length<1){this.xAxis=this.startingXAxis;this.xAxisIndices=this.startingXAxisIndices;alert("Cannot filter since there are no variables left in X-Axis");return false}this.xAxis2=[];this.xAxis2Indices=[];for(var b=0;b<this.startingXAxis2Indices.length;b++){if(a.hasOwnProperty(this.startingXAxis2Indices[b])){this.xAxis2.push(this.data.y.vars[this.startingXAxis2Indices[b]]);this.xAxis2Indices.push(this.startingXAxis2Indices[b])}}if(this.xAxis2Indices.length<1){this.xAxis2=this.startingXAxis2;this.xAxisIndices2=this.startingXAxis2Indices;alert("Cannot filter since there are no variables left in X-Axis2");return false}}}return true};this.showDataFilter=function(a){return function(d){if(!d){d=window.event}var g=a.$(a.target+"-cX-DataFilter");if(g){if(a.dataFilterLastState&&a.dataFilterLastState=="docked"){var f=a.$("east-handler-"+a.target);a.clickViewport(d,f)}if(g.style.left=="0px"&&g.style.top=="0px"){var b=a.$("west-container-"+a.target);var c=a.$("middle-container-"+a.target);if(b&&c){c.style.width=(parseInt(b.clientWidth)+a.canvas.width+a.dataFilterWidth+7)+"px"}}if(a.activeTarget){a.activeTarget.style.zIndex=10000}a.activeTarget=g;g.style.display="block";a.loadDataFilter();g.style.zIndex=10001}return false}}(this);this.removeGenericDataFilterListenersOrReset=function(y){var x=[];var v=[];switch(this.graphType){case"Bar":case"Line":case"BarLine":case"Area":case"AreaLine":case"Dotplot":case"DotLine":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Boxplot":case"Correlation":case"Pie":case"Scatter2D":case"ScatterBubble2D":case"Scatter3D":case"Candlestick":case"Circular":var k=this.$(this.target+"-cX-DataFilterSampleContent");var l=this.$(this.target+"-cX-DataFilterVariableContent");if(k&&l){x.push(k,l);v.push(this.getSampleData(true));v.push(this.getVariableData(true))}break;case"Venn":return;case"Network":var s=this.$(this.target+"-cX-DataFilterNodeContent");var o=this.$(this.target+"-cX-DataFilterEdgeContent");if(s&&o){x.push(s,o);v.push(this.getNodeData(true));v.push(this.getEdgeData(true))}break;case"Genome":var g=this.$(this.target+"-cX-DataFilterGenomeContent");if(g){x.push(g);v.push(this.getFeatureData(true))}break}for(var t=0;t<v.length;t++){var f=x[t];var m=v[t];var A=this.getKeys(m);A.sort();for(var q=0;q<A.length;q++){var z=m[A[q]]["t"];var w=A[q].replace(/\W/g,"_");if(z=="string"){var a=this.$(this.target+":"+w+":cX-DataFilterInput");var p=this.$(this.target+":"+w+":cX-DataFilterScroll");if(p&&a){if(y){a.value="";this.resetSelectStringFilter(p)}else{this.addRemoveNumericDataFilterListeners("removeEvtListener",p)}}}else{var n=this.$(this.target+":"+w+":cX-DataFilterMin");var h=this.$(this.target+":"+w+":cX-DataFilterMinLabel");var e=this.$(this.target+":"+w+":cX-DataFilterRange");var r=this.$(this.target+":"+w+":cX-DataFilterMax");var u=this.$(this.target+":"+w+":cX-DataFilterMaxLabel");var b=this.isIE?44:42;if(n&&h&&e&&r&&u){if(y){n.style.left="0px";h.innerHTML=this.bestFormatNumber(e.min,e.decis);e.style.left="0px";e.style.width=(this.dataFilterWidth-b)+"px";r.style.left="0px";u.innerHTML=this.bestFormatNumber(e.max,e.decis)}else{this.addRemoveNumericDataFilterListeners("removeEvtListener",n,r)}}}}}};this.loadDataFilter=function(){if(!this.toDoFilter){this.toDoFilter={}}switch(this.graphType){case"Bar":case"Line":case"BarLine":case"Area":case"AreaLine":case"Dotplot":case"DotLine":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Boxplot":case"Correlation":case"Pie":case"Scatter2D":case"ScatterBubble2D":case"Scatter3D":case"Candlestick":case"Circular":return this.loadDataFilterSmpVar();case"Venn":return;case"Network":return this.loadDataFilterNetwork();case"Genome":return this.loadDataFilterGenome()}};this.loadDataFilterGeneric=function(b,q,h){var n=this.graphType=="Genome"?95:116;var o=this.getKeys(h);o.sort();if(!q.loaded){q.loaded={}}var a=q.id+"Search";if(!this.$(a)){var j=this.$cX("div",{id:a,className:"CanvasXpressDataFilterContainerHoverable"},{width:"97%"});var p=this.$cX("input",{id:a+"Input",type:"text",placeholder:"Search filters"},{cursor:"default",width:"97%",marginLeft:"3px"});var l=this.$cX("div",{id:a+"Items"},{overflow:"auto"});j.appendChild(p);q.appendChild(j);q.appendChild(l)}var g=this.$(a+"Items");if(g){g.style.height=this.canvas.height-n}for(var f=0;f<o.length;f++){var m=this.getKeys(h[o[f]]["o"]);var k=h[o[f]]["t"];var e=h[o[f]]["r"];if(m.length>0){if(k=="string"){if(!q.loaded[o[f]]){l.appendChild(this.createStringFilter(b,o[f],m,e));q.loaded[o[f]]=true}}else{if(!q.loaded[o[f]]){l.appendChild(this.createNumericFilter(b,o[f],m,e));q.loaded[o[f]]=true}}}}};this.loadDataFilterSmpVar=function(){var b=this.$(this.target+"-cX-DataFilterSampleContent");var a=this.$(this.target+"-cX-DataFilterVariableContent");if(b&&a){this.loadDataFilterGeneric("sample",b,this.getSampleData(true));this.loadDataFilterGeneric("variable",a,this.getVariableData(true))}};this.loadDataFilterNetwork=function(){var b=this.$(this.target+"-cX-DataFilterNodeContent");var a=this.$(this.target+"-cX-DataFilterEdgeContent");if(b&&a){this.loadDataFilterGeneric("node",b,this.getNodeData(true));this.loadDataFilterGeneric("edge",a,this.getEdgeData(true))}};this.loadDataFilterGenome=function(){var a=this.$(this.target+"-cX-DataFilterGenomeContent");if(a){this.loadDataFilterGeneric("feature",a,this.getFeatureData(true))}};this.createNumericFilter=function(g,w,f,n){var a=function(d){var b=1000000;return(((d*b)-(parseInt(d)*b))/b).toString().replace(/\./,"").length-1};var c=this.isIE?44:42;var p=[];for(var x=0;x<f.length;x++){if(f[x]!=null&&f[x]!=""){p.push(f[x])}}f=p;f.sort(function(e,d){return e-d});var B=w.replace(/\W/g,"_");var D=this.$cX("div",{id:this.target+":"+B+":cX-DataFilterContainer",className:"CanvasXpressDataFilterContainerHoverable"});var u=this.$cX("div",{id:this.target+":"+B+":cX-DataFilterScale",innerHTML:w},{width:(this.dataFilterWidth-12)+"px",margin:"5px",backgroundImage:f[0]<0?"url('"+this.imageDir+"canvasXpress.gif')":"url('"+this.imageDir+"linear_log.png')",backgroundRepeat:"no-repeat",backgroundPosition:"98% 50%"});var m=this.$cX("div",false,{width:(this.dataFilterWidth-12)+"px",height:"14px",margin:"2px"});var z=parseFloat(f[0])<0?false:parseFloat(f[0])==0?0:Math.log(parseFloat(f[0]));var C=parseFloat(f[f.length-1])<0?false:parseFloat(f[f.length-1])==0?0:Math.log(parseFloat(f[f.length-1]));var F=z!=null&&C!=null?(C-z)/(this.dataFilterWidth-c):false;var j=this.$cX("div",{id:this.target+":"+B+":cX-DataFilterRange",className:"CanvasXpressDataFilterContainerRange",min:parseFloat(f[0]),max:parseFloat(f[f.length-1]),range:f[f.length-1]-f[0],units:(f[f.length-1]-f[0])/(this.dataFilterWidth-c),decis:a(f[f.length-1]-f[0]),lmin:z,lmax:C,lunits:F,scale:F?"linear":false,filter:g,ref:n,uvalue:w},{width:(this.dataFilterWidth-c)+"px"});var y=this.$cX("div",{id:this.target+":"+B+":cX-DataFilterMinLabel",innerHTML:this.bestFormatNumber(f[0],j.decis)},{marginLeft:"2px",cssFloat:"left"});var h=this.$cX("div",{id:this.target+":"+B+":cX-DataFilterMaxLabel",innerHTML:this.bestFormatNumber(f[f.length-1],j.decis)},{marginRight:"2px",cssFloat:"right"});var E=this.$cX("div",{className:"CanvasXpressDataFilterContainerNumeric"},{width:(this.dataFilterWidth-14)+"px"});var A=this.$cX("div",{id:this.target+":"+B+":cX-DataFilterMin",className:"CanvasXpressDataFilterContainerMin"},{left:"0px"});var o=this.$cX("div",{id:this.target+":"+B+":cX-DataFilterMax",className:"CanvasXpressDataFilterContainerMax"},{left:"0px"});m.appendChild(y);m.appendChild(h);E.appendChild(A);E.appendChild(j);E.appendChild(o);D.appendChild(u);D.appendChild(m);D.appendChild(E);this.addRemoveNumericDataFilterListeners("addEvtListener",A,o,u);return D};this.addRemoveNumericDataFilterListeners=function(d,c,a,b){if(d&&c&&a){this[d](c,"mousedown",this.mousedownNumericFilter,false);this[d](a,"mousedown",this.mousedownNumericFilter,false);this[d](b,"click",this.clickNumericFilter,false)}};this.mousedownNumericFilter=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);if(b){a.filteringNumericOn=b;a.xMouseDown=c.clientX;a.yMouseDown=c.clientY}return false}}(this);this.clickNumericFilter=function(a){return function(g){if(!g){g=window.event}var d=a.getTargetEvent(g);if(d){var c=a.$(d.id.replace("cX-DataFilterScale","cX-DataFilterRange"));var f=a.adjustedCoordinates(g,d);if(c&&f&&c.scale){var b=parseInt(a.dataFilterWidth*0.98);if(f.x>b-13){d.style.backgroundImage="url('"+a.imageDir+"log_linear.png')";c.scale="log"}else{if(f.x>b-26){d.style.backgroundImage="url('"+a.imageDir+"linear_log.png')";c.scale="linear"}}}}return false}}(this);this.updateNumericFilter=function(o){if(this.filteringNumericOn){this.cancelEvent(o);var m=this.filteringNumericOn;var q,k,l,d,f,p;if(m.id.match(/cX-DataFilterMin/)){q=true;k=m.id;l=m.id.replace("cX-DataFilterMin","cX-DataFilterMax");d=m.id.replace("cX-DataFilterMin","cX-DataFilterRange");f=m.id.replace("cX-DataFilterMin","cX-DataFilterMinLabel");p=m.id.replace("cX-DataFilterMin","cX-DataFilterMaxLabel")}else{q=false;l=m.id;k=m.id.replace("cX-DataFilterMax","cX-DataFilterMin");d=m.id.replace("cX-DataFilterMax","cX-DataFilterRange");f=m.id.replace("cX-DataFilterMax","cX-DataFilterMinLabel");p=m.id.replace("cX-DataFilterMax","cX-DataFilterMaxLabel")}k=this.$(k);l=this.$(l);d=this.$(d);f=this.$(f);p=this.$(p);if(k&&l&&d&&f&&p){var h=o.clientX-this.xMouseDown;var b=this.isIE?44:42;var i=this.dataFilterWidth-b;var a=q?parseInt(d.style.width)-h:parseInt(d.style.width)+h;var n=parseInt(k.style.left)+h;var j=this.absoluteCoordinates(k);var g=this.absoluteCoordinates(l);if(q){if(n>0&&a>0){this.xMouseDown=o.clientX;n=Math.max(0,Math.min(i,n));a=Math.max(0,Math.min(i,a))}else{if(n>0){n-=h;a=(g.x-j.x)-14}else{a+=n;n=0}}k.style.left=n+"px";d.style.left=n+"px";d.style.width=a+"px";l.style.left=n+"px";var s;if(d.scale=="log"){s=n!=0?Math.exp((d.lunits*n)+d.lmin):0}else{s=(d.units*n)+d.min}s=Math.min(Math.max(s,d.min),parseFloat(p.innerHTML));f.innerHTML=this.bestFormatNumber(s,d.decis)}else{if(n+a<=i&&a>=0){this.xMouseDown=o.clientX;n=Math.max(0,Math.min(i,n));a=Math.max(0,Math.min(i-n,a))}else{if(n+a>i){n-=h;a=i-n}}d.style.width=Math.max(0,a)+"px";var t;if(d.scale=="log"){t=a!=i?Math.exp((d.lunits*(n+a))+d.lmin):d.max}else{t=(d.units*(n+a))+d.min}t=Math.max(Math.min(t,d.max),parseFloat(f.innerHTML));p.innerHTML=this.bestFormatNumber(t,d.decis)}var r=d.uvalue;var c=d.filter;if(!this.toDoFilter[c]){this.toDoFilter[c]={}}if(!this.toDoFilter[c][r]){this.toDoFilter[c][r]={}}if(s!=null){this.toDoFilter[c][r]["min"]=s}if(t!=null){this.toDoFilter[c][r]["max"]=t}if(d.ref!=null){this.toDoFilter[c][r]["ref"]=d.ref}this.updateDataFilter()}}return false};this.endNumericFilter=function(a){if(this.filteringNumericOn){this.filteringNumericOn=false}};this.createStringFilter=function(A,n,z,c){z.sort();z.unshift("(All) "+z.length+" values");z.push("");var w=n.replace(/\W/g,"_");var x=this.$cX("div",{id:this.target+":"+w+":cX-DataFilterContainer",className:"CanvasXpressDataFilterContainerHoverable"});var h=this.$cX("div",{innerHTML:n},{width:"98%",margin:"5px"});var u=this.$cX("input",{id:this.target+":"+w+":cX-DataFilterInput",type:"text",placeholder:"Search values"},{cursor:"default",width:"97%",marginLeft:"3px"});var g=this.$cX("div",{id:this.target+":"+w+":cX-DataFilterMask",className:"CanvasXpressDataFilterContainerMask"},{width:"96%",height:"80px"});var B=this.$cX("div",{id:this.target+":"+w+":cX-DataFilterScroll",filter:A,uvalue:n,values:z,selected:{0:true},ref:c,skey:w,last:0},{width:"96%",height:((z.length+1)*16)+"px"});var f=this.$cX("div",{id:this.target+":"+w+":cX-DataFilterOptions"},{width:"110%",margin:"2px",position:"relative"});for(var p=0;p<Math.min(5,z.length);p++){var b=z[p].length>30?z[p].substr(0,30)+" ...":z[p];var y=this.$cX("div",{id:this.target+":"+w+":cX-DataFilterItem-"+p,className:p==0?"CanvasXpressDataFilterContainerItemSelected":"CanvasXpressDataFilterContainerItem",innerHTML:b,alt:z[p],title:z[p],index:p});f.appendChild(y)}B.appendChild(f);g.appendChild(B);x.appendChild(h);x.appendChild(u);x.appendChild(g);this.addRemoveStringDataFilterListeners("addEvtListener",g);return x};this.addRemoveStringDataFilterListeners=function(b,a){if(b&&a){this[b](a,"scroll",this.scrollStringFilter,false);this[b](a,"mousedown",this.registerStringFilter,false);this[b](a,"mouseup",this.endStringFilter,false)}};this.scrollStringFilter=function(a){return function(l,j){if(!l){l=window.event}if(!j){j=a.getTargetEvent(l)}var h=j.firstChild;var n=h.firstChild;var f=h.skey;var c=Math.max(0,Math.min(Math.floor(j.scrollTop/16),h.values.length-5));n.style.top=j.scrollTop+"px";for(var g=0;g<Math.min(5,h.values.length);g++){var m=a.$(a.target+":"+f+":cX-DataFilterItem-"+g);if(m){var j=h.values[c+g].length>30?h.values[c+g].substr(0,30)+" ...":h.values[c+g];m.className=h.selected[c+g]?"CanvasXpressDataFilterContainerItemSelected":"CanvasXpressDataFilterContainerItem";m.innerHTML=j;m.alt=h.values[c+g];m.title=h.values[c+g];m.index=c+g}}if(a.filteringStringOn){a.updateSelectStringFilter(false,a.$(a.target+":"+f+":cX-DataFilterItem-4"),true)}return false}}(this);this.registerStringFilter=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);if(!b.id.match(/cX-DataFilterMask/)){a.$(b.parentNode.id.replace("cX-DataFilterOptions","cX-DataFilterInput")).value="";a.updateSelectStringFilter(false,b,c.shiftKey,c.ctrlKey);a.filteringStringOn=b}return false}}(this);this.endStringFilter=function(a){return function(h,c){if(!h){h=window.event}if(!c&&a.filteringStringOn){c=a.filteringStringOn.parentNode.parentNode}if(!c){return}var m=c.selected;var g=c.filter;var l=c.uvalue;var b=c.ref;var k=c.values;var j;if(!m[0]){if(!a.toDoFilter[g]){a.toDoFilter[g]={}}if(!a.toDoFilter[g][l]){a.toDoFilter[g][l]={like:[]}}a.toDoFilter[g][l]["like"]=[];for(var d in m){j=k[d].replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&");a.toDoFilter[g][l]["like"].push(j)}if(b!=null){a.toDoFilter[g][l]["ref"]=b}}else{if(a.toDoFilter[g]&&a.toDoFilter[g][l]){delete (a.toDoFilter[g][l])}}a.filteringStringOn=true;a.updateDataFilter();a.filteringStringOn=false;return false}}(this);this.updateStringFilter=function(b){var a=this.getTargetEvent(b);var c=this.filteringStringOn?this.filteringStringOn.id.replace(/-\d$/,""):"";if(a.id.match(c)&&!b.ctrlKey){this.updateSelectStringFilter(false,a,true)}};this.updateSelectStringFilter=function(A,C,g,a){if(A){var t=this.$(A);var d=this.$(A.replace("cX-DataFilterInput","cX-DataFilterScroll"));if(t.value){var j=0;var c=d.firstChild;var w=c.childNodes[0].index;var r=null;var D=0;d.selected={};for(var m=1;m<d.values.length-1;m++){if(d.values[m].toLowerCase().match(t.value.toLowerCase())){if(!r){r=m;D=m*16}d.selected[m]=true;j++}}if(j+2==d.values.length){d.selected={0:true};r=0}if(r!=null){d.parentNode.scrollTop=D;this.scrollStringFilter(false,d.parentNode)}this.endStringFilter(false,d)}else{this.resetSelectStringFilter(d);this.endStringFilter(false,d)}}else{if(C){var y=C.index;var c=C.parentNode;var D=C.parentNode.parentNode;var k=D.last;var q=D.selected;var B=D.values;var w=c.childNodes[0].index;var j=0;var u=a&&D.selected[y];D.selected={};if(!u){D.selected[y]=true}if(g){if(y>k){for(var m=k;m<=y;m++){D.selected[m]=true;if(m){j++}}}else{for(var m=y;m<=k;m++){D.selected[m]=true;if(m){j++}}}}else{if(a){if(!u){D.last=y}for(var m in q){if(m==y&&u){continue}D.selected[m]=true;if(m){j++}}}else{D.last=y}}if(j>0){delete (D.selected[0])}delete (D.selected[B.length-1]);for(var m=0;m<c.childNodes.length;m++){c.childNodes[m].className=D.selected[m+w]?"CanvasXpressDataFilterContainerItemSelected":"CanvasXpressDataFilterContainerItem"}}}};this.resetSelectStringFilter=function(a){if(a){a.selected={0:true};var b=a.parentNode;b.scrollTop=0;this.scrollStringFilter(false,b)}};this.updateSearchFilters=function(e){var g=this.$(e).parentNode.parentNode;if(g){var h=g.childNodes;var b=new RegExp(h[0].firstChild.value,"i");for(var d=0;d<h[1].childNodes.length;d++){var a=h[1].childNodes[d].id.split(":");if(a[1].match(b)){h[1].childNodes[d].style.display="block"}else{h[1].childNodes[d].style.display="none"}}}};this.hideDataFilterNoAnimation=function(){var a=this.showFadeResizeMoveAnimation;this.showFadeResizeMoveAnimation=false;this.hideDataFilter();this.showFadeResizeMoveAnimation=a;return false};this.hideDataFilter=function(a){return function(b){if(!b){b=window.event}a.moveDataFilter(true);return false}}(this);this.dockUndockDataFilter=function(a){return function(c){if(!c){c=window.event}var b=a.$(a.target+"-cX-DataFilter");if(b){a.moveDataFilter()}return false}}(this);this.resizeDataFilter=function(){var a=this.graphType=="Genome"?60:81;this.dataFilterHeight=this.canvas.height-a;if(this.activeAccordion){this.activeAccordion.style.height=this.dataFilterHeight+"px"}};this.resetDataFilter=function(a){return function(d,g,b){a.resetFilters();a.toDoFilter={};a.reset();if(b){var c=a.$(a.target+"-cX-DataFilter");if(c){a.removeGenericDataFilterListenersOrReset();c.parentNode.removeChild(c);a.addDataFilterDiv()}}else{a.removeGenericDataFilterListenersOrReset(true)}if(!g){if(a.isGroupedData){a.groupSamples(a.groupingFactors)}else{a.draw()}}return false}}(this);this.initializeDataFilterEvents=function(){this.addDataFilterDiv()};this.initializeDataFilterEvents()};CanvasXpress.prototype.initDataTable=function(){this.addDataTableDiv=function(E,F){if(this.$(this.target+"-cX-DataTable")){return}var p=this;var O=function(n,d,b){var o=p.$cX(d==0||b==0?"th":"td",{id:p.target+"-cX-DataTableCell."+d+"."+b,className:d==0||b==0?"CanvasXpressTableCellHead":"CanvasXpressTableCell"},{width:p.colWidth+"px",height:p.rowHeight+"px"});n.appendChild(o)};if(!F){this.setDataTableDimensions(E)}var C=20;var f=44;var m=this.dataTableLastX!=null?parseInt(this.dataTableLastX):this.canvas.width*0.1;var k=this.dataTableLastY!=null?parseInt(this.dataTableLastY):-this.canvas.height*0.9;var q=this.dataTableLastWidth||this.dataTableColsWidth+C;var G=this.dataTableLastHeight||this.dataTableRowsHeight+f;var v=((this.colWidth+8)*3)+6;var M=((this.rowHeight+4)*3)+8;var L=this.$cX("div",{id:this.target+"-cX-DataTable",className:"CanvasXpressDataTable draggable-container"},{top:k+"px",left:m+"px",width:q+"px",height:G+"px",minWidth:(v+C)+"px",minHeight:(M+f+20)+"px",zIndex:10000,display:"none"});var l=this.$cX("div",{id:this.target+"-cX-DataTableToolbar",className:"CanvasXpressDataTableToolbar draggable"},{width:q+"px",minWidth:(v+C)+"px"});var h=this.$cX("img",{id:this.target+"-cX-DataTableSaveImage",className:"CanvasXpressDataTableToolbarImage",src:this.imageDir+"disk.png",alt:"Save data",title:"Save data"});var c=this.$cX("img",{id:this.target+"-cX-DataTableTransposeImage",className:"CanvasXpressDataTableToolbarImage",src:this.imageDir+"transpose.png",alt:"Transpose data",title:"Transpose data"});var g=this.$cX("img",{id:this.target+"-cX-DataTableNetworkImage",className:"CanvasXpressDataTableToolbarImage",src:this.networkShowDataTable=="nodes"?this.imageDir+"edges.png":this.imageDir+"nodes.png",alt:this.networkShowDataTable=="nodes"?"Show edge data":"Show node data",title:this.networkShowDataTable=="nodes"?"Show edge data":"Show node data"},{display:this.graphType=="Network"?"block":"none"});var x=this.$cX("img",{id:this.target+"-cX-DataTableDockImage",className:"CanvasXpressDataTableToolbarImage",src:this.dataTableLastState&&this.dataTableLastState=="docked"?this.imageDir+"unpin.png":this.imageDir+"pin.png",alt:this.dataTableLastState&&this.dataTableLastState=="docked"?"Undock":"Dock",title:this.dataTableLastState&&this.dataTableLastState=="docked"?"Undock":"Dock"});var D=this.$cX("img",{id:this.target+"-cX-DataTableCloseImage",className:"CanvasXpressDataTableToolbarImage",src:this.imageDir+"cancel1.png",alt:"Close table",title:"Close table"});var H=this.$cX("div",{id:this.target+"-cX-DataTableContainer",className:"CanvasXpressDataTableContainer"},{width:q+"px",height:(G-20)+"px",minWidth:(v+C)+"px",minHeight:(M+f)+"px"});var a=this.$cX("div",{id:this.target+"-cX-DataTableTableMask",className:"CanvasXpressDataTableMask"},{width:(q-C)+"px",height:(G-f)+"px",minWidth:v+"px",minHeight:(M+20)+"px"});var A=this.$cX("table",{id:this.target+"-cX-DataTableTable",className:"CanvasXpressDataTable"});var N=this.$cX("tbody");for(var J=0;J<this.maxRows;J++){var B=this.$cX("tr");for(var I=0;I<this.maxCols;I++){O(B,J,I)}N.appendChild(B)}var z=this.$cX("div",{id:this.target+"-cX-DataTableVer",className:"CanvasXpressDataTableVertical"},{height:(G-f)+"px",minHeight:(M+20)+"px"});var e=this.$cX("img",{id:this.target+"-cX-DataTableVerImage",src:this.getPixelImage(),width:1,height:this.dataTableTotalHeight});z.appendChild(e);var K=this.$cX("div",{id:this.target+"-cX-DataTableHor",className:"CanvasXpressDataTableHorizontal"},{width:(q-C)+"px",minWidth:v+"px"});var y=this.$cX("img",{id:this.target+"-cX-DataTableHorImage",src:this.getPixelImage(),width:this.dataTableTotalWidth,height:1});K.appendChild(y);var s=this.$cX("div",{id:this.target+"-cX-DataTableResizer",className:"CanvasXpressDataTableResizer resizable"});l.appendChild(D);l.appendChild(x);l.appendChild(c);l.appendChild(h);l.appendChild(g);A.appendChild(N);a.appendChild(A);H.appendChild(a);H.appendChild(z);H.appendChild(K);H.appendChild(s);L.appendChild(l);L.appendChild(H);var u=this.$("south-wrapper-"+this.target);if(u){u.appendChild(L);this.addRemoveDataTableListeners("addEvtListener")}};this.addRemoveDataTableListeners=function(a,f){this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableHor"),"scroll",this.scrollTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableVer"),"scroll",this.scrollTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableToolbar"),"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableSaveImage"),"click",this.saveTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableNetworkImage"),"click",this.networkUpdateTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableTransposeImage"),"click",this.transposeDataTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableDockImage"),"click",this.dockUndockTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCloseImage"),"click",this.hideTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableResizer"),"mousedown",this.mousedownDataTableResizer,false);var e=f?f[0]:this.maxRows;var g=f?f[1]:this.maxCols;for(var d=0;d<g;d++){this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell.0."+d),"click",this.clickDataTableHeader,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell.0."+d),"mousemove",this.mousemoveDataTableHeader,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell.0."+d),"mousedown",this.mousedownDataTableHeader,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell.0."+d),"mouseover",this.mouseoverDataTableHeader,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell.0."+d),"mouseout",this.mouseoutDataTableHeader,false)}for(var d=0;d<e;d++){this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell."+d+".0"),"mouseover",this.mouseoverDataTableHeader,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell."+d+".0"),"mouseout",this.mouseoutDataTableHeader,false)}for(var d=1;d<e;d++){for(var b=1;b<g;b++){this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell."+d+"."+b),"mouseover",this.mouseoverDataTableCell,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell."+d+"."+b),"mouseout",this.mouseoutDataTableCell,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell."+d+"."+b),"click",this.clickDataTableCell,false)}}};this.scrollTable=function(a){return function(g){if(!g){g=window.event}a.removeMenus();var j=a.$(a.target+"-cX-DataTable");var b=a.$(a.target+"-cX-DataTableVer");var f=a.$(a.target+"-cX-DataTableHor");if(j&&b&&f&&!a.resizingDataTableOn){var i=Math.ceil(f.scrollLeft/(f.scrollWidth/a.totalCols));var c=Math.ceil(b.scrollTop/(b.scrollHeight/a.totalRows));a.dataTableLastScrollLeft=f.scrollLeft;a.dataTableLastScrollTop=b.scrollTop;a.dataTableLastScrollWidth=f.scrollWidth;a.dataTableLastScrollHeight=b.scrollHeight;if(i!=a.startCol||c!=a.startRow){a.startCol=i;a.startRow=c;a.updateDataTable(false,false,false,true)}}return false}}(this);this.saveTable=function(a){return function(g){if(!g){g=window.event}a.removeMenus();var b=a.maxCols;var f=a.maxRows;var c=a.startCol;var i=a.startRow;a.maxCols=a.totalCols;a.maxRows=a.totalRows;a.startCol=0;a.startRow=0;var h=a.updateDataTable(false,false,true);a.exportToExcel(h);a.maxCols=b;a.maxRows=f;a.startCol=c;a.startRow=i;return false}}(this);this.dockUndockTable=function(a){return function(d){if(!d){d=window.event}a.removeMenus();var c=a.dataTableLastState&&a.dataTableLastState=="docked"?"undock":"dock";var b=a.getTargetEvent(d);if(c=="dock"){b.src=a.imageDir+"unpin.png";b.alt="Undock";b.title="Undock"}else{b.src=a.imageDir+"pin.png";b.alt="Dock";b.title="Dock"}a.moveDataTableDiv(c);return false}}(this);this.transposeDataTable=function(a){return function(b){if(!b){b=window.event}a.removeMenus();a.startRow=0;a.startCol=0;a.dataTableTransposed=a.dataTableTransposed?false:true;a.sortDataTableHead=false;a.updateDataTable(false,true,false,false,true);a.resizeDataTable();return false}}(this);this.minimizeTable=function(a){return function(b){if(!b){b=window.event}a.moveDataTableDiv("min");return false}}(this);this.maximizeTable=function(a){return function(b){if(!b){b=window.event}a.moveDataTableDiv("max");return false}}(this);this.hideTableNoAnimation=function(){var a=this.showFadeResizeMoveAnimation;this.showFadeResizeMoveAnimation=false;this.hideTable();this.showFadeResizeMoveAnimation=a;return false};this.hideTable=function(a){return function(b){if(!b){b=window.event}a.removeMenus();var c=a.$(a.target+"-cX-DataTable");if(c){a.showDataTable=false;a.moveDataTableDiv("hide");setTimeout(function(){a.hideUnhideDataTable(true);a.resetFade(c);a.resetDataTable(true)},500)}return false}}(this);this.networkUpdateTable=function(a){return function(c){if(!c){c=window.event}a.removeMenus();var b=a.getTargetEvent(c);a.networkShowDataTable=a.networkShowDataTable=="nodes"?"edges":"nodes";a.updateDataTable(false,true,false,true);return false}}(this);this.mousedownDataTableResizer=function(a){return function(d){if(!d){d=window.event}a.removeMenus();var b=d.target||d.srcElement;if(a.hasClass(b,"resizable")){var f=a.$(a.target+"-cX-DataTable");if(f){a.dataTableTarget=f;a.xMouseDown=d.clientX;a.yMouseDown=d.clientY;a.dataTableWidth=parseInt(a.dataTableTarget.style.width);a.dataTableHeight=parseInt(a.dataTableTarget.style.height);a.resizingDataTableOn=true}}return false}}(this);this.mousemoveDataTableHeader=function(a){return function(j){if(!j){j=window.event}var c=a.resizingDataTableColumnOn?a.dataTableColumnTarget:a.getTargetEvent(j);var n=a.adjustedCoordinates(j,c);var l=a.$(a.target+"-cX-DataTableHorImage");if(n&&l){if(a.resizingDataTableColumnOn){var b=a.dataTableColumnTarget.id.split(".");var g=parseInt(b[2]);var k=n.x-a.xMouseDown;var m=Math.max(a.colWidth,(a.dataTableColumnWidth[a.startCol+g]||a.colWidth)+k);a.dataTableColumnTarget.firstChild.style.width=m+"px";l.width+=k;for(var h=a.startRow;h<a.startRow+a.totalRows;h++){var d=a.$(a.target+"-cX-DataTableCell."+h+"."+g);if(d){d.style.width=m+"px";d.firstChild.style.width=m+"px"}}a.dataTableColumnWidth[a.startCol+g]=m;a.xMouseDown=n.x;a.yMouseDown=n.y;document.body.style.cursor="ew-resize"}else{var f=(c.offsetLeft+c.clientWidth)-n.x;if(f<5&&c.nodeName.toLowerCase()=="th"){c.style.cursor="ew-resize"}else{c.style.cursor="default"}}}return false}}(this);this.mousedownDataTableHeader=function(a){return function(d){if(!d){d=window.event}var b=d.target||d.srcElement;var c=a.adjustedCoordinates(d,b);if(c){var f=(b.offsetLeft+b.clientWidth)-c.x;if(f<5&&b.nodeName.toLowerCase()=="th"){a.dataTableColumnTarget=b;a.xMouseDown=c.x;a.yMouseDown=c.y;a.resizingDataTableColumnOn=true;document.body.style.cursor="ew-resize"}}return false}}(this);this.clickDataTableHeader=function(a){return function(l,f){if(!l){l=window.event}if(!f){a.cancelEvent(l);f=a.getTargetEvent(l)}var b=a.target+"-cX-DataTableCell.0.0";if(f.tagName.match(/th/i)){f=f.firstChild}if(f.tagName.match(/^a$/i)){if(a.skipHeaderMouseout&&a.skipHeaderMouseout.id==this.id){a.removeMenus();return false}var o=a.maxCols;var w=a.maxRows;var j=a.startCol;var q=a.startRow;var u=a.dataTableColumnHide;a.maxCols=a.totalCols;a.maxRows=0;a.startCol=0;a.startRow=0;a.dataTableColumnHide={};var n=a.updateDataTable(false,false,true);a.maxCols=o;a.maxRows=w;a.startCol=j;a.startRow=q;a.dataTableColumnHide=u;var p=[];for(var k=1;k<n[0].length;k++){p.push([n[0][k],a.dataTableColumnHide[n[0][k]]?"unchecked.png":"checked.png","hideUnhideDataTableColumn",[n[0][k]]])}var h=[];h.push(["Sort Ascending","sort_ascii_asc.png","sortDataTableByColumn",["asc",f.parentNode]]);h.push(["Sort Descending","sort_ascii_desc.png","sortDataTableByColumn",["desc",f.parentNode]]);h.push(["-"]);h.push(["Columns","table.png",false,false,false,p]);var g=a.absoluteCoordinates(f);var r=a.absoluteCoordinates(a.$(a.target+"-cX-DataTable"));var t=a.absoluteCoordinates(a.$(a.target));a.addMenu(l,false,false,h,(g.x-r.x)+(r.x-t.x),g.y-(t.y-28),this);a.skipHeaderMouseout=this}else{if(f.className=="CanvasXpressTableCellSortDesc"){f.className="CanvasXpressTableCellSortAsc"}else{f.className="CanvasXpressTableCellSortDesc"}if(a.sortDataTableHead){if(a.sortDataTableHead.id!=f.id){var v=a.$(a.sortDataTableHead.id);if(v){if(f.parentNode.id==b){a.sortDataTableHead.id=a.target+"-cX-DataTableCellContent.0.0"}v.className="CanvasXpressTableCell"}}}a.removeMenus();a.sortDataTableHead=f;a.sortDataTable()}return false}}(this);this.mouseoverDataTableHeader=function(a){return function(b){if(!b){b=window.event}this.className="CanvasXpressTableCellHeadActive";this.firstChild.firstChild.className="CanvasXpressTableCellHeadActive";return false}}(this);this.mouseoutDataTableHeader=function(a){return function(b){if(!b){b=window.event}if(a.skipHeaderMouseout&&a.skipHeaderMouseout.id==this.id){return false}else{this.className="CanvasXpressTableCellHead";this.firstChild.firstChild.className="CanvasXpressTableCellHead"}return false}}(this);this.mouseoverDataTableCell=function(a){return function(b){if(!b){b=window.event}this.className="CanvasXpressTableCellActive";return false}}(this);this.mouseoutDataTableCell=function(a){return function(b){if(!b){b=window.event}this.className="CanvasXpressTableCell";return false}}(this);this.clickDataTableCell=function(a){return function(b){if(!b){b=window.event}a.removeMenus();return false}}(this);this.hideUnhideDataTableColumn=function(a){if(this.dataTableColumnHide[a]){delete (this.dataTableColumnHide[a])}else{this.dataTableColumnHide[a]=true}this.updateDataTable(false,false,false,true)};this.sortDataTableByColumn=function(b,a){if(b=="asc"){a.className="CanvasXpressTableCellSortDesc"}else{a.className="CanvasXpressTableCellSortAsc"}this.sortDataTableHead=a;this.clickDataTableHeader(false,a)};this.setDataTableDimensions=function(d,k){var b=0;var p=0;var e=0;var l=false;var j=function(){for(var a=0;a<d.w.grps.length;a++){e+=d.w.grps[a].length}return e};if(!d){d=this.data}if(!this.dataTableColumnHide){this.dataTableColumnHide={}}var s=0;if(d.x){for(var h in d.x){if(!this.dataTableColumnHide[h]){s++}}}var m=0;if(d.z){for(var h in d.z){if(!this.dataTableColumnHide[h]){m++}}}var w=this.getDataTableDimensions();if(w[0]!=this.maxRows||w[1]!=this.maxCols){this.initialMaxRows=this.maxRows;this.initialMaxCols=this.maxCols}if(this.graphType=="Network"){var q=this.getAllNetworkAttributes(d);b=this.dataTableTransposed?1+d[this.networkShowDataTable].length:1+q[1];p=this.dataTableTransposed?1+q[1]:1+d[this.networkShowDataTable].length}else{if(this.graphType=="Genome"){b=1;p=1}else{if(this.graphType=="Venn"){var u=this.getVennCompartments(d);b=this.dataTableTransposed?1+u[1]:2;p=this.dataTableTransposed?2:1+u[1]}else{if(this.graphType=="Correlation"){b=this.correlationAxis=="samples"?1+d.y.smps.length:1+d.y.vars.length;p=b}else{if(this.graphType=="Candlestick"){if(d.y){b=this.dataTableTransposed?1+(d.y.smps.length*d.y.vars.length):6;p=this.dataTableTransposed?6:1+(d.y.smps.length*d.y.vars.length)}else{if(d.market){b=this.dataTableTransposed?1+(d.market.smps.length*d.market.vars.length):6;p=this.dataTableTransposed?6:1+(d.market.smps.length*d.market.vars.length)}}}else{if(d.y&&d.y.vars&&d.y.smps){b=this.dataTableTransposed?1+m+d.y.smps.length:1+s+d.y.vars.length;p=this.dataTableTransposed?1+s+d.y.vars.length:1+m+d.y.smps.length}else{if(d.w&&d.w.vars&&d.w.grps){e=j();b=this.dataTableTransposed?1+m+e:1+s+d.w.vars.length;p=this.dataTableTransposed?1+s+d.w.vars.length:1+m+e}}}}}}}if(this.maxRows>b){this.initialMaxRows=this.maxRows;this.maxRows=b}if(this.maxCols>p){this.initialMaxCols=this.maxCols;this.maxCols=p}if(this.totalRows==null||this.totalCols==null){this.totalRows=b;this.totalCols=p}else{if(k||b!=this.totalRows||p!=this.totalCols||w[0]!=this.maxRows||w[1]!=this.maxCols||w[2]!=this.rowHeight||w[3]!=this.colWidth){this.totalRows=b;this.totalCols=p;l=true}else{this.totalRows=b;this.totalCols=p;if(this.showDataTable){this.hideUnhideDataTable()}}}this.dataTableTotalHeight=10;for(var h=0;h<this.totalRows;h++){this.dataTableTotalHeight+=this.setDataTableRowHeight(h)}this.dataTableTotalHeight+=this.totalRows*4;this.dataTableTotalWidth=10;for(var h=0;h<this.totalCols;h++){this.dataTableTotalWidth+=this.setDataTableColumnWidth(h)}this.dataTableTotalWidth+=this.totalCols*8;this.dataTableRowsHeight=10;for(var h=this.startRow;h<this.startRow+this.maxRows;h++){this.dataTableRowsHeight+=this.setDataTableRowHeight(h)}this.dataTableRowsHeight+=this.maxRows*4;this.dataTableColsWidth=10;for(var h=this.startCol;h<this.startCol+this.maxCols;h++){this.dataTableColsWidth+=this.setDataTableColumnWidth(h)}this.dataTableColsWidth+=this.maxCols*8;if(l){this.resetDataTable(true,w)}};this.setDataTableColumnWidth=function(b,a){if(!this.dataTableColumnWidth[b]){this.dataTableColumnWidth[b]=this.colWidth}else{if(a){this.dataTableColumnWidth[b]=Math.max(a,this.colWidth)}}return this.dataTableColumnWidth[b]};this.setDataTableRowHeight=function(a,b){if(!this.dataTableRowHeight[a]){this.dataTableRowHeight[a]=this.rowHeight}else{if(b){this.dataTableRowHeight[a]=Math.max(b,this.rowHeight)}}return this.dataTableRowHeight[a]};this.getAllNetworkAttributes=function(c){var b=this.getNetworkData(this.networkShowDataTable,true);var d=this.getKeys(b).length;return[b,d]};this.getVennCompartments=function(c){var b={};var d=0;if(c.venn&&c.venn.data){for(var a in c.venn.data){b[a]=1;d++}}return[b,d]};this.getDataTableDimensions=function(){var f=0;var i=0;var e=0;var b=0;var d=this.$(this.target+"-cX-DataTableTable");var g=this.$(this.target+"-cX-DataTableCell.0.0");if(d){var a=d.childNodes[0].rows;if(a){f=a.length;i=a[0].cells.length;e=g&&g.firstChild&&g.firstChild.style?parseInt(g.firstChild.style.height):0;b=g&&g.firstChild&&g.firstChild.style?parseInt(g.firstChild.style.width):0}}return[f,i,e,b]};this.resetDataTable=function(b,a){this.addRemoveDataTableListeners("removeEvtListener",a);this.removeTarget(this.target+"-cX-DataTable");this.addDataTableDiv(false,b)};this.hideUnhideDataTable=function(a){if(this.initialMaxRows){this.maxRows=this.initialMaxRows}if(this.initialMaxCols){this.maxCols=this.initialMaxCols}var b=this.$(this.target+"-cX-DataTable");if(b){if(a==true){b.style.display="none"}else{b.style.display="block"}}};this.resizeDataTable=function(){var g=this.$(this.target+"-cX-DataTableContainer");var d=this.$(this.target+"-cX-DataTableVer");var f=this.$(this.target+"-cX-DataTableHor");if(g&&d&&f){var b=0;this.maxCols=0;for(var e=this.startCol;e<this.totalCols;e++){b+=this.dataTableColumnWidth[e]+8;if(parseInt(g.style.width)<b){this.maxCols++;break}else{this.maxCols++}}if(b<parseInt(g.style.width)&&this.startCol>0){for(var e=this.startCol;e>=0;e--){if(b+this.dataTableColumnWidth[e]+8<parseInt(g.style.width)){b+=this.dataTableColumnWidth[e]+8;this.maxCols++;this.startCol--}else{break}}}if(parseInt(g.style.width)>this.dataTableTotalWidth){this.maxCols=(this.totalCols-this.startCol)}this.maxCols=Math.max(3,Math.min(this.maxCols,(this.totalCols-this.startCol)));var a=0;this.maxRows=0;for(var e=this.startRow;e<this.totalRows;e++){a+=this.dataTableRowHeight[e]+4;if(parseInt(g.style.height)<a){this.maxRows++;break}else{this.maxRows++}}if(a<parseInt(g.style.height)&&this.startRow>0){for(var e=this.startRow;e>=0;e--){if(a+this.dataTableRowHeight[e]+4<parseInt(g.style.height)){a+=this.dataTableRowHeight[e]+4;this.maxRows++;this.startRow--}else{break}}}if(parseInt(g.style.height)>this.dataTableTotalHeight){this.totalRows=(this.totalRows-this.startRow)}this.maxRows=Math.max(3,Math.min(this.maxRows,(this.totalRows-this.startRow)));this.updateDataTable(false,true,false,true);d=this.$(this.target+"-cX-DataTableVer");f=this.$(this.target+"-cX-DataTableHor");if(d&&f){if(!this.isIE){d.scrollHeight=this.dataTableLastScrollHeight}d.scrollTop=this.dataTableLastScrollTop?this.dataTableLastScrollTop:d.scrollTop;if(!this.isIE){f.scrollWidth=this.dataTableLastScrollWidth}f.scrollLeft=this.dataTableLastScrollLeft?this.dataTableLastScrollLeft:f.scrollLeft}if(this.dataTableLastState=="docked"){this.resizeViewportSouth(true)}}};this.sortDataTable=function(){this.sortDir=this.sortDataTableHead.className=="CanvasXpressTableCellSortDesc"?"descending":"ascending";var a=this.sortDataTableHead.innerText?this.sortDataTableHead.innerText:this.sortDataTableHead.textContent;if(this.graphType=="Network"){if(this.dataTableTransposed){if(this.sortDataTableHead.type=="cxb"){this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false;return}else{this.sortNetworkIndices(a)}}else{this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false;return}}else{if(this.graphType=="Genome"){this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false;return}else{if(this.graphType=="Venn"){this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false;return}else{if(this.graphType=="Correlation"){if(this.correlationAxis=="samples"){if(this.sortDataTableHead.type=="cxb"){this.sortSamples()}else{this.sortSamples(false,false,a,"cor",true);this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false}}else{if(this.sortDataTableHead.type=="cxb"){this.sortVariables()}else{this.sortVariables(false,false,a,"cor",true);this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false}}}else{if(this.graphType=="Candlestick"){this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false;return}else{if(this.data.y.vars&&this.data.y.smps){if(this.dataTableTransposed){if(this.sortDataTableHead.type=="cxx"){this.sortSamplesByCategory([a])}else{if(this.sortDataTableHead.type=="cxv"){this.sortSamplesByVariable(a)}else{if(this.sortDataTableHead.type=="cxb"){this.sortSamples()}}}}else{if(this.sortDataTableHead.type=="cxz"){this.sortVariablesByCategory([a])}else{if(this.sortDataTableHead.type=="cxs"){this.sortVariablesBySample(a)}else{if(this.sortDataTableHead.type=="cxb"){this.sortVariables()}}}}}}}}}}this.updateDataTable(false,true,false,false,true)};this.getDataClassAsArray=function(y,b,K,C,z,e){var m=0;var h=0;var x=0;var t=0;var H=[];var I=[];var w=[];var u=[];var f=function(r,s,d,L){if(s.hasOwnProperty(r)){return s[r]!=null?s[r]:""}else{if(d[0][r]&&d[0][r].hasOwnProperty("r")){var v=d[0][r]["r"];for(var l=0;l<L[v].length;l++){var k=L[v][l];if(s.hasOwnProperty(k)){s=s[k]}else{return""}}if(s.hasOwnProperty(r)){return s[r]!=null?s[r]:""}}return""}};if(b==null){b=0}if(K==null){K=99}if(C==null){C=0}if(z==null){z=99}if(this.graphType=="Network"){var J=this.getAllNetworkAttributes(y);w.push("");u.push("cxb");if(this.dataTableTransposed){for(var E in J[0]){if(h<K&&t>=b&&!this.dataTableColumnHide[E]){w.push(E);u.push("cxx");h++}t++}H.push(w);I.push(u);for(var E=0;E<y[this.networkShowDataTable].length;E++){if(m<z&&x>=C){h=0;t=0;w=[E+1];u=["cxz"];for(var D in J[0]){if(h<K&&t>=b&&!this.dataTableColumnHide[D]){var q=f(D,y[this.networkShowDataTable][E],J,this[this.networkShowDataTable+"Properties"]);w.push(q);u.push("cxy");h++}t++}H.push(w);I.push(u);m++}x++}}else{for(var E=0;E<y[this.networkShowDataTable].length;E++){if(h<K&&t>=b&&!this.dataTableColumnHide[E+1]){w.push(E+1);u.push("cxz");h++}t++}H.push(w);I.push(u);for(var E in J[0]){if(m<z&&x>=C){h=0;t=0;w=[E];u=["cxx"];for(var D=0;D<y[this.networkShowDataTable].length;D++){if(h<K&&t>=b&&!this.dataTableColumnHide[E+1]){var q=f(E,y[this.networkShowDataTable][D],J,this[this.networkShowDataTable+"Properties"]);w.push(q);u.push("cxy");h++}t++}H.push(w);I.push(u);m++}x++}}}else{if(this.graphType=="Genome"){H=[["Not implemented"]];I=[["cxb"]]}else{if(this.graphType=="Venn"){var q=this.getVennCompartments(y);w.push("");u.push("cxb");if(this.dataTableTransposed){w.push("No");u.push("cxz");H.push(w);I.push(u);for(var E in q[0]){if(m<z&&x>=C){h=0;t=0;w=[E];u=["cxx"];if(h<K&&t>=b){w.push(y.venn.data[E]);u.push("cxy");h++}t++;H.push(w);I.push(u);m++}x++}}else{for(var E in q[0]){if(h<K&&t>=b){w.push(E);u.push("cxx");h++}t++}H.push(w);I.push(u);if(m<z&&x>=C){h=0;t=0;w=["No"];u=["cxz"];for(var E in q[0]){if(h<K&&t>=b){w.push(y.venn.data[E]);u.push("cxy");h++}t++}H.push(w);I.push(u)}}}else{if(this.graphType=="Correlation"){var p=this.correlationAxis=="samples"?y.y.smps:y.y.vars;var g=this.correlationAxis=="samples"?this.smpIndices:this.varIndices;var n=this.correlationAxis=="samples"?"cxs":"cxv";w.push("");u.push("cxb");for(var E=0;E<p.length;E++){if(h<K&&t>=b&&!this.dataTableColumnHide[e?p[g[E]]:p[E]]){w.push(e?p[g[E]]:p[E]);u.push(n);h++}t++}H.push(w);I.push(u);for(var E=0;E<p.length;E++){if(m<z&&x>=C){h=0;t=0;w=[e?p[g[E]]:p[E]];u=[n];for(var D=0;D<p.length;D++){if(h<K&&t>=b&&!this.dataTableColumnHide[e?p[g[D]]:p[D]]){if(y.y.cor){w.push(e?y.y.cor[g[E]][g[D]]:y.y.cor[E][D])}else{w.push(E==D?1:y.y.data)}u.push("cxy");h++}t++}H.push(w);I.push(u);m++}x++}}else{if(this.graphType=="Candlestick"){var J=["open","low","high","close","volume"];w.push("");u.push("cxb");if(this.dataTableTransposed){for(var E=0;E<y.y.vars.length;E++){for(var D=0;D<J.length;D++){var A=y.y.vars.length>1?y.y.vars[E]+":"+J[D]:J[D];if(h<K&&t>=b&&!this.dataTableColumnHide[A]){w.push(A);u.push("cxv");h++}t++}}H.push(w);I.push(u);for(var E=0;E<y.y.smps.length;E++){if(m<z&&x>=C){h=0;t=0;w=[y.y.smps[E]];u=["cxs"];for(var D=0;D<y.y.vars.length;D++){for(var B=0;B<J.length;B++){var A=y.y.vars.length>1?y.y.vars[D]+":"+J[B]:J[B];if(h<K&&t>=b&&!this.dataTableColumnHide[A]){w.push(y.y[J[B]][D][E]!=null?y.y[J[B]][D][E]:y.y[J[B]][E]);u.push("cxy");h++}t++}}H.push(w);I.push(u);m++}x++}}else{for(var E=0;E<y.y.smps.length;E++){if(h<K&&t>=b&&!this.dataTableColumnHide[y.y.smps[E]]){w.push(y.y.smps[E]);u.push("cxs");h++}t++}H.push(w);I.push(u);for(var E=0;E<y.y.vars.length;E++){for(var D=0;D<J.length;D++){if(m<z&&x>=C){h=0;t=0;var A=y.y.vars.length>1?y.y.vars[E]+":"+J[D]:J[D];w=[A];u=["cxv"];for(var B=0;B<y.y.smps.length;B++){if(h<K&&t>=b&&!this.dataTableColumnHide[y.y.smps[B]]){w.push(y.y[J[D]][E][B]!=null?y.y[J[D]][E][B]:y.y[J[D]][B]);u.push("cxy");h++}t++}H.push(w);I.push(u);m++}x++}}}}else{if(y.y.vars&&y.y.smps){var G=e?this.varIndices.length:y.y.vars.length;var F=e?this.smpIndices.length:y.y.smps.length;w.push("");u.push("cxb");if(this.dataTableTransposed){if(y.x){for(var E in y.x){if(h<K&&t>=b&&!this.dataTableColumnHide[E]){w.push(E);u.push("cxx");h++}t++}}for(var E=0;E<G;E++){if(h<K&&t>=b&&!this.dataTableColumnHide[e?y.y.vars[this.varIndices[E]]:y.y.vars[E]]){w.push(e?y.y.vars[this.varIndices[E]]:y.y.vars[E]);u.push("cxv");h++}t++}H.push(w);I.push(u);if(y.z){for(var E in y.z){if(m<z&&x>=C){h=0;t=0;w=[E];u=["cxz"];if(y.x){for(var D in y.x){if(h<K&&t>=b&&!this.dataTableColumnHide[D]){w.push("");u.push("cxb");h++}t++}}for(var D=0;D<G;D++){if(h<K&&t>=b&&!this.dataTableColumnHide[e?y.y.vars[this.varIndices[D]]:y.y.vars[D]]){w.push(e?y.z[E][this.varIndices[D]]:y.z[E][D]);u.push("cxz");h++}t++}H.push(w);I.push(u);m++}x++}}for(var E=0;E<F;E++){if(m<z&&x>=C){h=0;t=0;w=[e?y.y.smps[this.smpIndices[E]]:y.y.smps[E]];u=["cxs"];if(y.x){for(var D in y.x){if(h<K&&t>=b&&!this.dataTableColumnHide[D]){w.push(e?y.x[D][this.smpIndices[E]]:y.x[D][E]);u.push("cxx");h++}t++}}for(var D=0;D<G;D++){if(h<K&&t>=b&&!this.dataTableColumnHide[e?y.y.vars[this.varIndices[D]]:y.y.vars[D]]){if(e){w.push(y.y.data[this.varIndices[D]][this.smpIndices[E]]!=null?y.y.data[this.varIndices[D]][this.smpIndices[E]]:y.y.data[this.smpIndices[E]])}else{w.push(y.y.data[D][E]!=null?y.y.data[D][E]:y.y.data[E])}u.push("cxy");h++}t++}H.push(w);I.push(u);m++}x++}}else{if(y.z){for(var E in y.z){if(h<K&&t>=b&&!this.dataTableColumnHide[E]){w.push(E);u.push("cxz");h++}t++}}for(var E=0;E<F;E++){if(h<K&&t>=b&&!this.dataTableColumnHide[e?y.y.smps[this.smpIndices[E]]:y.y.smps[E]]){w.push(e?y.y.smps[this.smpIndices[E]]:y.y.smps[E]);u.push("cxs");h++}t++}H.push(w);I.push(u);if(y.x){for(var E in y.x){if(m<z&&x>=C){h=0;t=0;w=[E];u=["cxx"];if(y.z){for(var D in y.z){if(h<K&&t>=b&&!this.dataTableColumnHide[D]){w.push("");u.push("cxb");h++}t++}}for(var D=0;D<F;D++){if(h<K&&t>=b&&!this.dataTableColumnHide[e?y.y.smps[this.smpIndices[D]]:y.y.smps[D]]){w.push(e?y.x[E][this.smpIndices[D]]:y.x[E][D]);u.push("cxx");h++}t++}H.push(w);I.push(u);m++}x++}}for(var E=0;E<G;E++){if(m<z&&x>=C){h=0;t=0;w=[e?y.y.vars[this.varIndices[E]]:y.y.vars[E]];u=["cxv"];if(y.z){for(var D in y.z){if(h<K&&t>=b&&!this.dataTableColumnHide[D]){w.push(e?y.z[D][this.varIndices[E]]:y.z[D][E]);u.push("cxz");h++}t++}}for(var D=0;D<F;D++){if(h<K&&t>=b&&!this.dataTableColumnHide[e?y.y.smps[this.smpIndices[D]]:y.y.smps[D]]){if(e){w.push(y.y.data[this.varIndices[E]][this.smpIndices[D]]!=null?y.y.data[this.varIndices[E]][this.smpIndices[D]]:y.y.data[this.smpIndices[D]])}else{w.push(y.y.data[E][D]!=null?y.y.data[E][D]:y.y.data[D])}u.push("cxy");h++}t++}H.push(w);I.push(u);m++}x++}}}}}}}}return[H,I]};this.updateDataTable=function(g,c,d,h,b){if(this.dataTableLastState&&this.dataTableLastState=="docked"&&h){this.dataTableLastX=this.configuringOn&&this.configuringOn=="docked"?0:7;this.dataTableLastY=0}if(!g){g=this.data}else{g=this.getUngroupedDataObject(g)}if(!d){this.setDataTableDimensions(g,c)}var a=this.getDataClassAsArray(g,this.startCol,this.maxCols,this.startRow,this.maxRows,true);if(d){return a[0]}else{this.loadDataTableValues(a[0],a[1],h,b)}};this.loadDataTableValues=function(B,C,u,p){var m=this.$(this.target+"-cX-DataTable");if(m){var l=this.startRow;for(var x=0;x<B.length;x++){var y=this.startCol;for(var v=0;v<B[x].length+this.startCol;v++){var r=this.target+"-cX-DataTableCell."+x+"."+v;var E=this.target+"-cX-DataTableCellContent."+l+"."+y;var g=this.target+"-cX-DataTableCellContentA."+l+"."+y;var A=this.$(r);if(A){if(A.hasChildNodes()){while(A.childNodes.length>=1){A.removeChild(A.firstChild)}}var G=B[x][v]!=null?B[x][v]:"";var b=C[x][v]!=null?C[x][v]:"";if(!isNaN(G)&&b=="cxy"){G=this.bestFormatNumber(G)}var f=this.$cX("div",{id:E,className:"CanvasXpressTableCell ",title:G,alt:G,type:b});if(x==0){var F=this.$cX("a",{id:g,className:"CanvasXpressTableCellHead ",href:"#"});f.appendChild(F)}f.appendChild(document.createTextNode(G));if(x!=0){f.style.height=this.setDataTableRowHeight(l)+"px";A.style.height=this.setDataTableRowHeight(l)+"px"}else{f.style.height=this.setDataTableRowHeight(0)+"px";A.style.height=this.setDataTableRowHeight(0)+"px"}if(v!=0){f.style.width=this.setDataTableColumnWidth(y)+"px";A.style.width=this.setDataTableColumnWidth(y)+"px"}else{f.style.width=this.setDataTableColumnWidth(0)+"px";A.style.width=this.setDataTableColumnWidth(0)+"px"}A.appendChild(f);y++}}l++}if(this.activeTarget){this.activeTarget.style.zIndex=9990}if(this.sortDataTableHead){var o=this.$(this.sortDataTableHead.id);var h=this.$(this.target+"-cX-DataTableCell.0.0").firstChild;var k=this.target+"-cX-DataTableCellContent.0.0";if(o){o.className=this.sortDataTableHead.className}if(h){h.className=this.sortDataTableHead.id==k?this.sortDataTableHead.className:"CanvasXpressTableCell"}}this.activeTarget=m;m.style.display="block";m.style.zIndex=9991;if(this.dataTableLastState&&this.dataTableLastState=="docked"&&!u&&!p){var D=this.$("south-handler-"+this.target);this.clickViewport(false,D);return}}};this.moveDataTableDiv=function(f){var p=this.$(this.target+"-cX-DataTable");if(p){var r,t,m;var b=this.$(this.remoteParentId+"-canvasXpressRemoteWindow");var a=this.$("west-handler-"+this.target);var i=this.$("north-container-"+this.target);var e=this.$("west-container-"+this.target);var o=this.$("east-container-"+this.target);var q=this.$("south-container-"+this.target);var k=this.$("south-handler-"+this.target);var s=this.$("south-wrapper-"+this.target);var c=64;var g=0;var j=this.showFadeResizeMoveAnimation?500:0;var n=this;if(a&&e&&o&&q&&k&&s){if(f&&f=="dock"){this.dataTableLastState="docked";this.dataTableLastHeight=p.clientHeight;this.dataTableLastX=p.offsetLeft;this.dataTableLastY=p.offsetTop;k.style.display="block";r=a.style.display=="none"?7:0;t=Math.max(p.clientWidth+r,parseInt(e.style.width)+parseInt(o.style.width)+this.canvas.width)+2;m=parseInt(i.style.height)+this.canvas.height+p.clientHeight+7+2;if(b){this.resizeMove(b,0,0,t+g,m+c)}this.resizeMove(q,0,0,t,p.clientHeight+7+2);this.resizeMove(s,0,0,t,p.clientHeight+2);this.resizeMove(p,r,0,p.clientWidth,p.clientHeight)}else{if(f&&f=="hide"){delete (this.dataTableLastState);delete (this.dataTableLastX);delete (this.dataTableLastY);k.style.display="none";t=parseInt(e.style.width)+parseInt(o.style.width)+this.canvas.width;m=parseInt(i.style.height)+this.canvas.height+7;if(b){this.resizeMove(b,0,0,t+g,m+c)}this.fade(p);this.resizeMove(s,0,0,t,0);this.resizeMove(q,0,0,t,7)}else{if(f&&(f=="max"||f=="release"||f=="undock")){this.dataTableLastState="free";k.style.display="none";t=parseInt(e.style.width)+parseInt(o.style.width)+this.canvas.width;m=parseInt(i.style.height)+this.canvas.height+7;if(b){this.resizeMove(b,0,0,t+t,m+c)}if(f=="max"||f=="undock"){this.resizeMove(p,parseInt(this.dataTableLastX),parseInt(this.dataTableLastY),p.clientWidth,parseInt(this.dataTableLastHeight)||(this.dataTableRowsHeight+42))}this.resizeMove(s,0,0,t,0);this.resizeMove(q,0,0,t,7)}else{this.dataTableLastX=p.offsetLeft;this.dataTableLastY=p.offsetTop;return}}}}}};this.updateDataTableResizerDiv=function(f,k,j){if(!f){f=window.event}if(f&&(k==null||j==null)){k=Math.abs(this.dataTableWidth)-(this.xMouseDown-f.clientX);j=Math.abs(this.dataTableHeight)-(this.yMouseDown-f.clientY)}if(this.dataTableTarget&&this.dataTableTarget.style){var g=this.$(this.target+"-cX-DataTable");var i=this.$(this.target+"-cX-DataTableContainer");var a=this.$(this.target+"-cX-DataTableTableMask");var l=this.$(this.target+"-cX-DataTableVer");var b=this.$(this.target+"-cX-DataTableHor");var n=this.$(this.target+"-cX-DataTableToolbar");if(g&&i&&a&&l&&b&&n){this.dataTableTarget.style.width=this.isIE?Math.max(0,k)+"px":k+"px";i.style.width=this.isIE?Math.max(0,k)+"px":k+"px";a.style.width=this.isIE?Math.max(0,(k-20))+"px":(k-20)+"px";b.style.width=this.isIE?Math.max(0,(k-20))+"px":(k-20)+"px";n.style.width=this.isIE?Math.max(0,k)+"px":k+"px";this.dataTableTarget.style.height=this.isIE?Math.max(0,j)+"px":j+"px";i.style.height=this.isIE?Math.max(0,(j-20))+"px":(j-20)+"px";a.style.height=this.isIE?Math.max(0,(j-44))+"px":(j-44)+"px";l.style.height=this.isIE?Math.max(0,(j-44))+"px":(j-44)+"px";this.dataTableLastWidth=k;this.dataTableLastHeight=j}}};this.endDataTableResizerDiv=function(a){if(this.dataTableTarget!=null){this.resizeDataTable();this.xMouseDown=null;this.yMouseDown=null;this.dataTableWidth=null;this.dataTableHeight=null;this.dataTableTarget=false;this.resizingDataTableOn=false}};this.endDataTableColumnResize=function(a){this.xMouseDown=null;this.yMouseDown=null;this.resizingDataTableColumnOn=false;this.dataTableColumnTarget=false;document.body.style.cursor="default"};this.initializeDataTableEvents=function(){this.addDataTableDiv()};this.initializeDataTableEvents()};CanvasXpress.prototype.initCanvasResizerEvents=function(){this.addCanvasResizerDiv=function(a){if(a){if(document.getElementById("canvasXpressCanvasResize")){return}}else{if(document.getElementById(this.target+"canvasXpressCanvasResize")){return}}var b=document.createElement("div");b.id=a?"canvasXpressCanvasResize":this.target+"canvasXpressCanvasResize";b.style.left="0px";b.style.top="0px";b.style.width="0.5px";b.style.height="0.5px";if(a){b.style.opacity=0.5;b.style.filter="alpha(opacity = 50)";b.style.backgroundColor=this.resizerBackgroundColor}b.style.position="absolute";b.style.display="none";b.style.zIndex=100001;b.style.backgroundImage="url("+this.imageDir+"processing.gif)";b.style.backgroundPosition="50% 50%";b.style.backgroundRepeat="no-repeat";if(a){document.body.appendChild(b);return b}else{this.canvas.parentNode.appendChild(b)}};this.isCanvasResize=function(c){if(this.resizable){if(!c){c=window.event}var b=this.adjustedCoordinates(c);if(b){var a=b.x;var d=b.y;if(a>this.width-18&&d>this.height-18){this.resizeCanvasCursorShow="se-resize";return true}else{if(a>this.width-18&&d>20){this.resizeCanvasCursorShow="e-resize";return true}else{if(d>this.height-18){this.resizeCanvasCursorShow="s-resize";return true}else{this.resizeCanvasCursorShow=false;return false}}}}}};this.updateCanvasResizerCursor=function(d){if(this.resizable){if(!d){d=window.event}var b=document.getElementById(this.target);if(b){var c=this.adjustedCoordinates(d);if(c){var a=c.x;var f=c.y;if(a>this.width-18&&f>this.height-18){b.style.cursor="se-resize";this.resizeCanvasCursorShow="se-resize"}else{if(a>this.width-18&&f>20){b.style.cursor="e-resize";this.resizeCanvasCursorShow="e-resize"}else{if(f>this.height-18){b.style.cursor="s-resize";this.resizeCanvasCursorShow="s-resize"}else{if(!this.movingOn){b.style.cursor="default";this.resizeCanvasCursorShow=false}}}}}}}};this.updateCanvasResizer=function(f){if(this.resizingCanvasOn&&this.resizeCanvasCursorShow){document.body.style.cursor=this.resizeCanvasCursorShow;var c=document.getElementById(this.target+"canvasXpressCanvasResize");var a=document.getElementById("canvasXpressCanvasResize");var b=this.adjustedCoordinates(f);var d=this.relativeCoordinates(this.canvas);if(c&&b&&d){if(this.resizeCanvasCursorShow=="se-resize"){w=b.x;h=b.y}else{if(this.resizeCanvasCursorShow=="e-resize"){w=b.x;h=this.height}else{if(this.resizeCanvasCursorShow=="s-resize"){w=this.width;h=b.y}}}if(!a){a=this.addCanvasResizerDiv(true)}this.preventSelection();dx=b.x-this.canvas.width;dy=b.y-this.canvas.height;c.style.width=w+"px";c.style.height=h+"px";c.style.display="block";a.style.left=d.x+"px";a.style.top=d.y+"px";a.style.width=w+"px";a.style.height=h+"px";a.style.display="block";CanvasXpress.resizing=true}}};this.showMask=function(){var a=document.getElementById(this.target+"canvasXpressCanvasResize");if(a){a.style.backgroundImage="url("+this.imageDir+this.loadingImage+")";a.style.width=this.canvas.width+"px";a.style.height=this.canvas.height+"px";a.style.display="block"}};this.hideMask=function(){var a=document.getElementById(this.target+"canvasXpressCanvasResize");if(a){a.style.backgroundImage="url("+this.imageDir+"processing.gif)";a.style.width="0.5px";a.style.height="0.5px";a.style.display="none"}};this.endCanvasResizer=function(g){if(this.resizingCanvasOn){var d=document.getElementById(this.target);var a=document.getElementById(this.target+"canvasXpressCanvasResize");var o=document.getElementById("canvasXpressCanvasResize");var k=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowBuffer");var c=this.$("west-container-"+this.target);var n=this.$("middle-container-"+this.target);var f=this.$("east-container-"+this.target);if(d&&a&&o){this.tmpHeight=false;this.tmpWidth=false;this.clickLayoutNoAnimation();var m=parseInt(a.style.width);var j=parseInt(a.style.height);n.style.width=(parseInt(c.style.width)+parseInt(a.style.width)+parseInt(f.style.width))+"px";n.style.height=a.style.height;this.resetAxesResizer();this.draw(m,j);this.resizeAcknowledgmentDiv();a.style.width="0.5px";a.style.height="0.5px";a.style.display="none";d.style.cursor="default";this.updateRemoteNavigationWindow();document.body.removeChild(o);this.resizeCanvasCursorShow=false;this.resizingCanvasOn=false;CanvasXpress.resizing=false}}};this.initializeCanvasResizerEvents=function(){if(!this.disableEvents){this.addCanvasResizerDiv();this.showMask()}};this.initializeCanvasResizerEvents()};CanvasXpress.prototype.initAxisResizerEvents=function(){this.addAxesResizeDiv=function(){if(document.getElementById(this.target+"canvasXpressAxesResize")){return}var c=["Previous","Next","Current","Middle","Min","Max","Close"];var b=9001;var e=document.createElement("div");e.id=this.target+"canvasXpressAxesResize";if(this.resizerTransparency){e.style.opacity=0.85;e.style.filter="alpha(opacity = 85)"}e.style.position="absolute";e.style.display="none";e.style.zIndex=b;for(var a=0;a<c.length;a++){b++;var f=document.createElement("div");f.id=this.target+"canvasXpressAxesResize"+c[a];if(this.resizerTransparency){f.style.opacity=0.85;f.style.filter="alpha(opacity = 85)"}f.style.position="absolute";f.style.zIndex=b;e.appendChild(f)}this.canvas.parentNode.appendChild(e)};this.clickAxesResizeClose=function(a){return function(b){if(!b){b=window.event}a.stopEvent(b);a.resetAxesResizer(b);a.resetFlags(b)}}(this);this.mousemoveActiveAxesResize=function(a){return function(b){if(!b){b=window.event}a.activateDeactivateAxesResizer(b)}}(this);this.mousedownAxesResize=function(a){return function(b){if(!b){b=window.event}a.cancelEvent(b);a.registerAxesResizer(b);return false}}(this);this.mousemoveAxesResize=function(a){return function(b){if(!b){b=window.event}a.cancelEvent(b);a.updateAxesResizer(b);return false}}(this);this.addRemoveAxesResizerListeners=function(p){var a=document.getElementById(this.target+"canvasXpressAxesResize");var d=document.getElementById(this.target+"canvasXpressAxesResizeMin");var k=document.getElementById(this.target+"canvasXpressAxesResizeMax");var e=document.getElementById(this.target+"canvasXpressAxesResizeMiddle");var i=document.getElementById(this.target+"canvasXpressAxesResizeCurrent");var g=document.getElementById(this.target+"canvasXpressAxesResizeClose");var b=[a,d,k,e,i];if(a){this[p](a,"mousemove",this.mousemoveActiveAxesResize,false);this[p](a,"mouseout",this.mousemoveActiveAxesResize,false)}if(g){this[p](g,"click",this.clickAxesResizeClose,false)}for(var f=0;f<b.length;f++){if(b[f]){this[p](b[f],"mousedown",this.mousedownAxesResize,false)}}};this.showAxesResizer=function(f,e,c,q,o,m,b,g,t,u,n,j,i){if(!this.axesResizerShow){var a=document.getElementById(this.target+"canvasXpressAxesResize");var k=document.getElementById(this.target+"canvasXpressAxesResizeClose");if(a&&k){this.updateResizerEventData(null,null,f,e,c,q,o,m,b,g,t,u,n,j,i);this.refreshAxesResizer();a.style.display="block";if(this.resizerType&&this.layoutValid){k.style.display="none"}this.addRemoveAxesResizerListeners("addEvtListener");if(this.layoutValid){this.layoutValidR=j;this.layoutValidC=i;this.layoutValidN=n}this.axesResizerShow=true}}};this.refreshAxesResizer=function(){if(this.resizerEventData){var b=document.getElementById(this.target+"canvasXpressAxesResize");var e=document.getElementById(this.target+"canvasXpressAxesResizeMin");var o=document.getElementById(this.target+"canvasXpressAxesResizeMax");var f=document.getElementById(this.target+"canvasXpressAxesResizeMiddle");var i=document.getElementById(this.target+"canvasXpressAxesResizeCurrent");var g=document.getElementById(this.target+"canvasXpressAxesResizeClose");var k=document.getElementById(this.target+"canvasXpressAxesResizePrevious");var j=document.getElementById(this.target+"canvasXpressAxesResizeNext");if(b&&e&&o&&i&&g&&k&&j){var s=this.resizerEventData.areas.org[1]-this.resizerEventData.areas.org[0];var p=this.resizerEventData.areas.org[3]-this.resizerEventData.areas.org[2];var d=14;var a=9;var q=parseInt(a/2);if(this.resizerEventData.pos=="h"){l=this.resizerEventData.l.match(/^t/)?"top":"bottom";b.style.left=(this.resizerEventData.areas.org[0]-q)+"px";b.style.top=this.resizerEventData.areas.org[2]+"px";b.style.width=((s+a)-1)+"px";b.style.height=d+"px";b.style.backgroundImage="url('"+this.imageDir+"scroller_empty_hor_"+l+".png')";b.style.backgroundRepeat="repeat-x";k.style.left="0px";k.style.top="0px";k.style.width=a+"px";k.style.height=d+"px";k.style.backgroundImage="url('"+this.imageDir+"prev_"+l+".png')";e.style.left=this.resizerEventData.areas.min[0]+"px";e.style.top="0px";e.style.width=a+"px";e.style.height=d+"px";e.style.cursor="e-resize";e.style.backgroundImage="url('"+this.imageDir+"handle_left_"+l+".png')";i.style.left=this.resizerEventData.areas.cur[0]+"px";i.style.top="0px";i.style.width=this.resizerEventData.areas.cur[1]+"px";i.style.height=d+"px";i.style.cursor="move";i.style.backgroundImage="url('"+this.imageDir+"scroller_body_hor_"+l+".png')";i.style.backgroundRepeat="repeat-x";o.style.left=this.resizerEventData.areas.max[0]+"px";o.style.top="0px";o.style.width=a+"px";o.style.height=d+"px";o.style.cursor="e-resize";o.style.backgroundImage="url('"+this.imageDir+"handle_right_"+l+".png')";o.style.backgroundRepeat="no-repeat";f.style.left=(this.resizerEventData.areas.min[0]+((this.resizerEventData.areas.cur[1]-1)/2))+"px";f.style.top="0px";f.style.width="8px";f.style.height=d+"px";f.style.cursor="move";f.style.backgroundImage="url('"+this.imageDir+"scroller_handle_hor_"+l+".png')";j.style.left=(s-1)+"px";j.style.top="0px";j.style.width=a+"px";j.style.height=d+"px";j.style.backgroundImage="url('"+this.imageDir+"next_"+l+".png')";g.style.left=(s+a)+"px";g.style.top="0px";g.style.width=a+"px";g.style.height=d+"px";g.style.backgroundImage="url('"+this.imageDir+"close.png')"}else{l=this.resizerEventData.l.match(/^l/)?"left":"right";b.style.left=this.resizerEventData.areas.org[0]+"px";b.style.top=(this.resizerEventData.areas.org[2]-q)+"px";b.style.width=d+"px";b.style.height=(p+a)+"px";b.style.backgroundImage="url('"+this.imageDir+"scroller_empty_ver_"+l+".png')";b.style.backgroundRepeat="repeat-y";k.style.left="0px";k.style.top=p+"px";k.style.width=d+"px";k.style.height=a+"px";k.style.backgroundImage="url('"+this.imageDir+"prev_"+l+".png')";e.style.left="0px";e.style.top=this.resizerEventData.areas.min[2]+"px";e.style.width=d+"px";e.style.height=a+"px";e.style.cursor="n-resize";e.style.backgroundImage="url('"+this.imageDir+"handle_bottom_"+l+".png')";e.style.backgroundRepeat="no-repeat";i.style.left="0px";i.style.top=this.resizerEventData.areas.cur[2]+"px";i.style.width=d+"px";i.style.height=this.resizerEventData.areas.cur[3]+"px";i.style.cursor="move";i.style.backgroundImage="url('"+this.imageDir+"scroller_body_ver_"+l+".png')";i.style.backgroundRepeat="repeat-y";o.style.left="0px";o.style.top=this.resizerEventData.areas.max[2]+"px";o.style.width=d+"px";o.style.height=a+"px";o.style.cursor="n-resize";o.style.backgroundImage="url('"+this.imageDir+"handle_top_"+l+".png')";o.style.backgroundRepeat="no-repeat";f.style.left="0px";f.style.top=(this.resizerEventData.areas.max[2]+(this.resizerEventData.areas.cur[3]/2))+"px";f.style.width=d+"px";f.style.height=d+"px";f.style.cursor="move";f.style.backgroundImage="url('"+this.imageDir+"scroller_handle_ver_"+l+".png')";f.style.backgroundRepeat="no-repeat";j.style.left="0px";j.style.top="0px";j.style.width=d+"px";j.style.height=a+"px";j.style.backgroundImage="url('"+this.imageDir+"next_"+l+".png')";g.style.left=(d+1)+"px";g.style.top=-a+"px";g.style.width=a+"px";g.style.height=d+"px";g.style.backgroundImage="url('"+this.imageDir+"close.png')"}this.drawAxesResizerMasks()}}};this.updateResizerEventData=function(i,H,B,q,o,a,X,U,K,O,I,J,z,t,r){var j,G,F,m,k,A,y,f,c,Q,P,E,D,n,W;B=B?B:this.resizerEventData.axis;q=q?q:this.resizerEventData.areas.org[0];o=o?o:this.resizerEventData.areas.org[1];a=a?a:this.resizerEventData.areas.org[2];X=X?X:this.resizerEventData.areas.org[3];U=U?U:this.resizerEventData.dim;K=K?K:this.resizerEventData.pos;O=O?O:this.resizerEventData.l;I=I?I:this.resizerEventData.vals;J=J?J:this.resizerEventData.set?this.resizerEventData.set:"";z=z?z:this.resizerEventData.c;t=t?t:this.resizerEventData.i;r=r?r:this.resizerEventData.j;var S=I.graphType;var e=o-q;var b=X-a;if(S=="Heatmap"){if(U=="y"){j=this.isGroupedData?this.data.w.smps.length:this.data.y?this.data.y.smps.length:0}else{j=this.data.y?this.data.y.vars.length:0}}else{j=this.isGroupedData?this.data.w.smps.length-1:this.data.y?this.data.y.smps.length-1:0}var V=this.resizerType=="samples"||S=="Heatmap"?0:I[B+"AbsMin"];var C=this.resizerType=="samples"||S=="Heatmap"?j:I[B+"AbsMax"];var u=K=="h"?e:b;var R=u/(C-V);if(i==null||isNaN(i)){if(this.resizerType=="samples"){i=this.isGroupedData?this.grpIndices[0]:this.smpIndices[0]}else{if(S=="Heatmap"){i=U=="y"?Math.max(0,I.smpIndicesStart):Math.max(0,I.varIndicesStart)}else{i=S.match(/Scatter/)?I["setMin"+U.toUpperCase()]:(S=="BarLine"||S=="DotLine")&&O.match(/b|r/)?I.setMin2:I.setMin}if(i==null||isNaN(i)){i=V}}}i=Math.max(i,V);if(H==null||isNaN(H)){if(this.resizerType=="samples"){H=this.isGroupedData?this.grpIndices[this.grpIndices.length-1]:this.smpIndices[this.smpIndices.length-1]}else{if(S=="Heatmap"){H=U=="x"?I.varIndices.length:this.isGroupedData?I.grpIndices.length:I.smpIndices.length;H+=i}else{H=S.match(/Scatter/)?I["setMax"+U.toUpperCase()]:(S=="BarLine"||S=="DotLine")&&O.match(/b|r/)?I.setMax2:I.setMax}if(H==null||isNaN(H)){H=C}}}H=Math.min(H,C);var x=(i-V)*R;var T=(H-V)*R;var N=14;var M=9;var L=parseInt(M/2);if(K=="h"){G=parseInt(x);F=M;m=0;k=N;Q=parseInt(x+L+1);P=parseInt(T-(x+1));E=0;D=N;A=parseInt(T-1);y=M;f=0;c=N;n=o+(M-1);W=X}else{G=0;F=N;m=this.resizerType=="samples"||S=="Heatmap"?parseInt(T):parseInt(b-(x+1));k=M;Q=0;P=N;E=this.resizerType=="samples"||S=="Heatmap"?parseInt(x+L):parseInt((b-T)+L);D=parseInt(T-x);A=0;y=N;f=this.resizerType=="samples"||S=="Heatmap"?parseInt(x+1):parseInt(b-T);c=M;n=o;W=X+(M-1)}this.resizerEventData={g:S,axis:B,dim:U,pos:K,l:O,vals:I,min:V,max:C,smin:i,smax:H,len:u,unit:R,width:N,set:J,c:z,i:t,j:r,areas:{org:[q,o,a,X],lim:[q,n,a,W],min:[G,F,m,k],max:[A,y,f,c],cur:[Q,P,E,D]}}};this.updateAxesResizer=function(v){if(this.axesResizingOn){if(!v){v=window.event}var q=this.resizerEventData.areas;var A=this.adjustedCoordinates(v);if(A){var n,B,b,c,a;var f=this.xMouseDown-A.x;var d=this.yMouseDown-A.y;var j,i;var s=null;var u=null;var z="";var F=14;var E=9-1;var C=parseInt(E/2);if(this.resizerEventData.g=="Heatmap"){if(this.resizerEventData.dim=="y"){n=this.isGroupedData?this.data.w.smps.length:this.data.y?this.data.y.smps.length:0;b=this.resizerEventData.lastMax!=null?this.resizerEventData.lastMax:this.resizerEventData.smax!=null?this.resizerEventData.smax:this.isGroupedData?this.data.w.smps.length:this.data.y.smps.length}else{n=this.data.y?this.data.y.vars.length:0;b=this.resizerEventData.lastMax!=null?this.resizerEventData.lastMax:this.resizerEventData.smax!=null?this.resizerEventData.smax:this.data.y.vars.length}B=this.resizerEventData.lastMin!=null?this.resizerEventData.lastMin:this.resizerEventData.smin!=null?this.resizerEventData.smin:0;a=this.resizerEventData.pos=="h"?(q.org[1]-q.org[0])/n:(q.org[3]-q.org[2])/n}else{n=this.isGroupedData?this.data.w.smps.length-1:this.data.y?this.data.y.smps.length-1:0;B=this.resizerEventData.lastMin!=null?this.resizerEventData.lastMin:this.resizerEventData.smin!=null?this.resizerEventData.smin:0;b=this.resizerEventData.lastMax!=null?this.resizerEventData.lastMax:this.resizerEventData.smax!=null?this.resizerEventData.smax:this.isGroupedData?this.data.w.smps.length-1:this.data.y.smps.length-1;a=this.resizerEventData.pos=="h"?(q.org[1]-q.org[0])/n:(q.org[3]-q.org[2])/n}if(this.resizerEventData.active=="min"){j=f>q.min[0]?this.xMouseDown-q.min[0]:f<(q.min[0]+q.min[1])-q.max[0]?this.xMouseDown-((q.min[0]+q.min[1])-q.max[0]):A.x;i=d>q.min[2]-(q.max[2]+q.max[3])?this.yMouseDown-(q.min[2]-(q.max[2]+q.max[3])):d<(q.lim[2]+q.min[2]+q.min[3])-q.lim[3]?(q.lim[3]-(q.lim[2]+q.min[2]+q.min[3]))+this.yMouseDown:A.y}else{if(this.resizerEventData.active=="max"){j=f>q.max[0]-(q.min[0]+q.min[1])?this.xMouseDown-(q.max[0]-(q.min[0]+q.min[1])):f<(q.lim[0]+q.max[0]+q.max[1])-q.lim[1]?(q.lim[1]-(q.lim[0]+q.max[0]+q.max[1]))+this.xMouseDown:A.x;i=d>q.max[2]?this.yMouseDown-q.max[2]:d<(q.lim[2]+q.max[2]+q.max[3])-(q.lim[2]+q.min[2])?((q.lim[2]+q.min[2])-(q.lim[2]+q.max[2]+q.max[3]))+this.yMouseDown:A.y}else{if(this.resizerEventData.active=="cur"){j=f>q.min[0]?this.xMouseDown-q.min[0]:f<(q.lim[0]+q.max[0]+q.max[1])-q.lim[1]?(q.lim[1]-(q.lim[0]+q.max[0]+q.max[1]))+this.xMouseDown:A.x;i=d>q.max[2]?this.yMouseDown-q.max[2]:d<(q.lim[2]+q.min[2]+q.min[3])-q.lim[3]?(q.lim[3]-(q.lim[2]+q.min[2]+q.min[3]))+this.yMouseDown:A.y}else{return}}}var m=j-this.xMouseDown;var k=i-this.yMouseDown;if(this.resizerType=="samples"||this.resizerEventData.g=="Heatmap"){m-=m%a;k-=k%a}var r=m/this.resizerEventData.unit;var p=k/this.resizerEventData.unit;var t=document.getElementById(this.target+"canvasXpressAxesResizeMin");var o=document.getElementById(this.target+"canvasXpressAxesResizeMax");var D=document.getElementById(this.target+"canvasXpressAxesResizeMiddle");var g=document.getElementById(this.target+"canvasXpressAxesResizeCurrent");if(t&&o&&D&&g){if(this.resizerEventData.active=="min"){if(this.resizerEventData.pos=="h"){t.style.left=(q.min[0]+m)+"px";D.style.left=((q.min[0]+m)+((q.cur[1]-m)/2))+"px";g.style.left=(q.min[0]+m+C+1)+"px";g.style.width=(q.cur[1]-m)+"px";B=parseInt((q.min[0]+E+m)/a);if(this.resizerType=="samples"){s=dateFormat(this.data.y.smps[B],this.timeFormat)}else{if(this.resizerEventData.g=="Heatmap"){s=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[B]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[B]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[B]]}else{s=this.formatNumber(this.resizerEventData.smin+r)}}}else{t.style.top=(q.min[2]+k)+"px";D.style.top=((q.min[2]+k)-((q.cur[3]+k)/2))+"px";g.style.height=((q.cur[3]+k))+"px";b=parseInt((q.min[2]+E+k)/a);if(this.resizerType=="samples"){s=dateFormat(this.data.y.smps[b],this.timeFormat)}else{if(this.resizerEventData.g=="Heatmap"){s=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[b]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[b]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[b]]}else{s=this.formatNumber(this.resizerEventData.smin-p)}}}this.showInfoSpan(v,s)}else{if(this.resizerEventData.active=="max"){if(this.resizerEventData.pos=="h"){o.style.left=(q.max[0]+m)+"px";D.style.left=((q.min[0]+m)+((q.cur[1]-m)/2))+"px";g.style.width=(q.cur[1]+m)+"px";b=parseInt((q.max[0]+E+m)/a);if(this.resizerType=="samples"){u=dateFormat(this.data.y.smps[b],this.timeFormat)}else{if(this.resizerEventData.g=="Heatmap"){u=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[b]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[b]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[b]]}else{u=this.formatNumber(this.resizerEventData.smax+r)}}}else{o.style.top=(q.max[2]+k)+"px";D.style.top=((q.max[2]+k)+((q.cur[3]-k)/2))+"px";g.style.top=(q.max[2]+k+C)+"px";g.style.height=(q.cur[3]-k)+"px";B=parseInt((q.max[2]+E+k)/a);if(this.resizerType=="samples"){u=dateFormat(this.data.y.smps[B],this.timeFormat)}else{if(this.resizerEventData.g=="Heatmap"){u=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[B]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[B]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[B]]}else{u=this.formatNumber(this.resizerEventData.smax-p)}}}this.showInfoSpan(v,u)}else{if(this.resizerEventData.active=="cur"){if(this.resizerEventData.pos=="h"){t.style.left=(q.min[0]+m)+"px";D.style.left=((q.min[0]+m)+(q.cur[1]/2))+"px";o.style.left=(q.max[0]+m)+"px";g.style.left=(q.min[0]+m+C+1)+"px";B=parseInt((q.min[0]+E+m)/a);b=parseInt((q.max[0]+E+m)/a);if(this.resizerType=="samples"){s=dateFormat(this.data.y.smps[B],this.timeFormat);u=dateFormat(this.data.y.smps[b],this.timeFormat)}else{if(this.resizerEventData.g=="Heatmap"){s=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[B]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[B]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[B]];u=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[b]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[b]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[b]]}else{s=this.formatNumber(this.resizerEventData.smin+r);u=this.formatNumber(this.resizerEventData.smax+r)}}this.showInfoSpan(v,s+"--"+u)}else{t.style.top=(q.min[2]+k)+"px";D.style.top=((q.max[2]+k)+(q.cur[3]/2))+"px";o.style.top=(q.max[2]+k)+"px";g.style.top=(q.max[2]+k+C)+"px";b=parseInt((q.min[2]+E+k)/a);B=parseInt((q.max[2]+E+k)/a);if(this.resizerType=="samples"){s=dateFormat(this.data.y.smps[b],this.timeFormat);u=dateFormat(this.data.y.smps[B],this.timeFormat);this.showInfoSpan(v,u+"--"+s)}else{if(this.resizerEventData.g=="Heatmap"){s=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[b]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[b]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[b]];u=this.resizerEventData.dim=="x"?this.data.y.vars[this.resizerEventData.vals.varIndices[B]]:this.isGroupedData?this.data.w.smps[this.resizerEventData.vals.grpIndices[B]]:this.data.y.smps[this.resizerEventData.vals.smpIndices[B]];this.showInfoSpan(v,u+"--"+s)}else{s=this.formatNumber(this.resizerEventData.smin-p);u=this.formatNumber(this.resizerEventData.smax-p);this.showInfoSpan(v,s+"--"+u)}}}}}}this.resizerEventData.lastMin=this.resizerType=="samples"||this.resizerEventData.g=="Heatmap"?B:s;this.resizerEventData.lastMax=this.resizerType=="samples"||this.resizerEventData.g=="Heatmap"?b:u;if(this.resizerDraw){this.drawAxesResizerUpdate()}}}}};this.drawAxesResizerUpdate=function(n){var d=this.resizerEventData.lastMin!=null?parseFloat(this.resizerEventData.lastMin):parseFloat(this.resizerEventData.smin);var k=this.resizerEventData.lastMax!=null?parseFloat(this.resizerEventData.lastMax):parseFloat(this.resizerEventData.smax);var j=this.resizerEventData.c||0;if(this.resizerType=="samples"){var m=this.isGroupedData?this.data.w.smps.length-1:this.data.y.smps.length-1;var a=[];var g=[];for(var f=0;f<d;f++){g.push(true)}for(var f=d;f<=k;f++){a.push(f);g.push(false)}for(var f=k+1;f<m;f++){g.push(true)}if(this.isGroupedData){this.grpIndices=a;this.hiddenGrps=g}else{this.smpIndices=a;this.hiddenSmps=g}}else{if(this.resizerEventData.g=="Heatmap"){if(!this.startingVarIndices||!this.startingSmpIndices){this.setOriginalIndices(j)}var b=this.startingVarIndices[j];var e=this.startingSmpIndices[j];if(this.resizerEventData.dim=="y"){if(this.isGroupedData){if(this.layoutComb){this.layoutParams[j]["grpIndices"]=[];for(var f=d;f<k;f++){this.layoutParams[j]["grpIndices"].push(e[f])}this.layoutParams[j]["smpIndicesStart"]=d}else{this.grpIndices=[];for(var f=d;f<k;f++){this.grpIndices.push(e[f])}this.smpIndicesStart=d}}else{if(this.layoutComb){this.layoutParams[j]["smpIndices"]=[];for(var f=d;f<k;f++){this.layoutParams[j]["smpIndices"].push(e[f])}this.layoutParams[j]["smpIndicesStart"]=d}else{this.smpIndices=[];for(var f=d;f<k;f++){this.smpIndices.push(e[f])}this.smpIndicesStart=d}}}else{if(this.layoutComb){this.layoutParams[j]["varIndices"]=[];for(var f=d;f<k;f++){this.layoutParams[j]["varIndices"].push(b[f])}this.layoutParams[j]["varIndicesStart"]=d}else{this.varIndices=[];for(var f=d;f<k;f++){this.varIndices.push(b[f])}this.varIndicesStart=d}}}else{if(this.resizerEventData.lastMin){this["setMin"+this.resizerEventData.set]=d}if(this.resizerEventData.lastMax){this["setMax"+this.resizerEventData.set]=k}}}if(n){this.updateResizerEventData(d,k)}this.draw()};this.drawAxesResizerBackgroundData=function(d,p,b,o){if(this.resizerType&&this.resizerDataIndex>-1){this.setAllSamplesVisible();var a,k,c,n;var m=this.graphType=="Candlestick"?"close":false;var g=[];var e=[];var q=[];for(var f=0;f<this.smpIndices.length;f++){g.push(this.getDataAtPos(this.resizerDataIndex,f,m))}var j=this.range(g);if(this.resizerPosition.match(/top|bottom/)){a=b/(this.smpIndices.length-1);k=o/((j[1]-j[0])*1.2);c=(j[1]-j[0])*0.1*k;n=p+o;e.push(d);q.push(n);for(var f=0;f<g.length;f++){e.push(d);q.push(n-(((g[f]-j[0])*k)+c));d+=a}d-=a;e.push(d);q.push(n)}else{a=o/(this.smpIndices.length-1);k=b/((j[1]-j[0])*1.2);c=(j[1]-j[0])*0.1*k;e.push(d);q.push(p);for(var f=0;f<g.length;f++){e.push(d+((g[f]-j[0])*k)+c);q.push(p);p+=a}p-=a;e.push(d);q.push(p)}this.drawShape("polygon",e,q,false,false,this.resizerBackgroundColorCurrent,this.resizerBackgroundColorOutlineCurrent,"closed")}};this.drawAxesResizerMasks=function(){if(this.resizerType){var e,i,d,f;var c=this.resizerEventData.areas;var b=this.isGroupedData?this.data.w.grps.length-1:this.data.y.smps.length-1;var a=this.resizerEventData.pos=="h"?(c.org[1]-c.org[0])/b:(c.org[3]-c.org[2])/b;var g=9-1;if(this.resizerEventData.pos=="h"){if(this.resizerEventData.smin>0){e=c.org[0]-1;i=c.org[2]-this.resizerWidth;d=a*this.resizerEventData.smin;f=this.resizerWidth;this.rectangle(e,i,d,f,this.resizerBackgroundColor,this.resizerBackgroundColor);this.drawLine("line",e,i,e+d+1,i,this.foreground);this.drawLine("line",e+d,i,e+d,i+f,this.foreground)}if(this.resizerEventData.smax<b){e=c.org[0]+c.max[0]+1;i=c.org[2]-this.resizerWidth;d=(a*(b-this.resizerEventData.smax))+1;f=this.resizerWidth;this.rectangle(e,i,d,f,this.resizerBackgroundColor,this.resizerBackgroundColor);this.drawLine("line",e-1,i,e+d+2,i,this.foreground);this.drawLine("line",e-1,i,e-1,i+f,this.foreground)}e=c.org[0]+c.max[0];i=c.org[2]-1;d=c.org[0]+a*this.resizerEventData.smin;this.drawLine("line",e,i,d,i,this.foreground)}else{if(this.resizerEventData.smin>0){e=c.org[0]+14;i=c.org[2];d=this.resizerWidth;f=a*this.resizerEventData.smin;this.rectangle(e,i,d,f,this.resizerBackgroundColor,this.resizerBackgroundColor);this.drawLine("line",e,i+f,e+d,i+f,this.foreground);this.drawLine("line",e+d,i,e+d,i+f,this.foreground)}if(this.resizerEventData.smax<b){e=c.org[0]+14;i=c.org[2]+c.min[2];d=this.resizerWidth;f=(b-this.resizerEventData.smax)*a;this.rectangle(e,i,d,f,this.resizerBackgroundColor,this.resizerBackgroundColor);this.drawLine("line",e,i,e+d,i,this.foreground);this.drawLine("line",e+d,i,e+d,i+f,this.foreground)}e=c.org[0]+14;i=c.org[2]+c.min[2];f=c.org[2]+(a*this.resizerEventData.smin);this.drawLine("line",e,i,e,f,this.foreground)}}};this.registerAxesResizer=function(d){if(!d){d=window.event}var i=this.adjustedCoordinates(d);if(i){var g=i.x;var f=i.y;var c=this.resizerEventData.areas;var k=c.lim[1]-c.lim[0];var j=c.lim[3]-c.lim[2];var a=5;var b=k>j?"h":"v";if(g>=c.min[0]+c.lim[0]&&g<=c.min[0]+c.min[1]+c.lim[0]&&f>=c.min[2]+c.lim[2]&&f<=c.min[2]+c.min[3]+c.lim[2]){this.resizerEventData.active="min";this.axesResizingOn=true}else{if(g>=c.max[0]+c.lim[0]&&g<=c.max[0]+c.max[1]+c.lim[0]&&f>=c.max[2]+c.lim[2]&&f<=c.max[2]+c.max[3]+c.lim[2]){this.resizerEventData.active="max";this.axesResizingOn=true}else{if(g>=c.cur[0]+c.lim[0]&&g<=c.cur[0]+c.cur[1]+c.lim[0]&&f>=c.cur[2]+c.lim[2]&&f<=c.cur[2]+c.cur[3]+c.lim[2]){this.resizerEventData.active="cur";this.axesResizingOn=true}else{if(b=="h"){if(g>=c.lim[0]&&g<c.min[0]+c.lim[0]){this.resizerEventData.active="prev";this.axesResizingOn=true}else{if(g>c.lim[0]+c.max[0]+c.max[1]&&g<=c.lim[1]-a){this.resizerEventData.active="next";this.axesResizingOn=true}}}else{if(f>=c.lim[2]+c.min[2]+c.min[3]&&f<=c.lim[2]+c.lim[3]){this.resizerEventData.active="prev";this.axesResizingOn=true}else{if(f>=c.lim[2]&&f<=c.lim[2]+c.max[2]){this.resizerEventData.active="next";this.axesResizingOn=true}}}}}}this.xMouseDown=g;this.yMouseDown=f}};this.activateDeactivateAxesResizer=function(j){if(!j){j=window.event}var s=this.adjustedCoordinates(j);if(s){var q;var r=s.x;var m=s.y;var i=this.resizerEventData.areas;var u=i.lim[1]-i.lim[0];var t=i.lim[3]-i.lim[2];var c=5;var f=u>t?"h":"v";if(f=="h"){if(r>=i.lim[0]&&r<=i.lim[0]+i.min[0]){q="prev"}else{if(r>=i.lim[0]+i.max[0]+i.max[1]&&r<=i.lim[1]-c){q="next"}}}else{if(m>=i.lim[2]+i.min[2]+i.min[3]&&m<=i.lim[2]+i.lim[3]){q="prev"}else{if(m>=i.lim[2]&&m<=i.lim[2]+i.max[2]){q="next"}}}var d=document.getElementById(this.target+"canvasXpressAxesResizePrevious");var g=document.getElementById(this.target+"canvasXpressAxesResizeNext");if(d&&g){if(q=="prev"){var k=d.style.backgroundImage;if(j.type.match(/mouseout|touchcancel/i)){if(k.match(/_active.png/)){d.style.backgroundImage=k.replace("_active.png",".png")}}else{if(!k.match(/_active.png/)){d.style.backgroundImage=k.replace(".png","_active.png")}}}else{if(q=="next"){var k=g.style.backgroundImage;if(j.type.match(/mouseout|touchcancel/i)){if(k.match(/_active.png/)){g.style.backgroundImage=k.replace("_active.png",".png")}}else{if(!k.match(/_active.png/)){g.style.backgroundImage=k.replace(".png","_active.png")}}}else{var k=d.style.backgroundImage;if(k.match(/_active.png/)){d.style.backgroundImage=k.replace("_active.png",".png")}k=g.style.backgroundImage;if(k.match(/_active.png/)){g.style.backgroundImage=k.replace("_active.png",".png")}}}}return false}};this.moveAxesResizer=function(k){var g=this.resizerEventData.smin;var m=this.resizerEventData.smax;var c=this.resizerType=="samples"||this.resizerEventData.g=="Heatmap"?1:(m-g)/10;if((this.resizerType=="samples"||this.resizerEventData.g=="Heatmap")&&this.resizerEventData.pos=="v"){if(this.resizerEventData.active=="prev"){if(g+c<this.resizerEventData.min){c=g-this.resizerEventData.min;this.resizerEventData.lastMin=this.resizerEventData.min;this.resizerEventData.lastMax=m+c}else{this.resizerEventData.lastMin=g+c;this.resizerEventData.lastMax=m+c}}else{if(m-c>this.resizerEventData.max){c=this.resizerEventData.max-m;this.resizerEventData.lastMin=g-c;this.resizerEventData.lastMax=this.resizerEventData.max}else{this.resizerEventData.lastMin=g-c;this.resizerEventData.lastMax=m-c}}}else{if(this.resizerEventData.active=="prev"){if(g-c<this.resizerEventData.min){c=g-this.resizerEventData.min;this.resizerEventData.lastMin=this.resizerEventData.min;this.resizerEventData.lastMax=m-c}else{this.resizerEventData.lastMin=g-c;this.resizerEventData.lastMax=m-c}}else{if(m+c>this.resizerEventData.max){c=this.resizerEventData.max-m;this.resizerEventData.lastMin=g+c;this.resizerEventData.lastMax=this.resizerEventData.max}else{this.resizerEventData.lastMin=g+c;this.resizerEventData.lastMax=m+c}}}var f=this.resizerEventData.areas;var d=document.getElementById(this.target+"canvasXpressAxesResizeMin");var o=document.getElementById(this.target+"canvasXpressAxesResizeMax");var n=document.getElementById(this.target+"canvasXpressAxesResizeMiddle");var j=document.getElementById(this.target+"canvasXpressAxesResizeCurrent");var b=14;var a=9-1;var p=parseInt(a/2);var i=c*this.resizerEventData.unit;if((this.resizerEventData.pos=="h"&&this.resizerEventData.active=="prev")||(this.resizerEventData.pos=="v"&&this.resizerEventData.active=="next")){i*=-1}if(this.resizerEventData.pos=="h"){d.style.left=(f.min[0]+i+1)+"px";n.style.left=((f.min[0]+i)+(f.cur[1]/2))+"px";o.style.left=(f.max[0]+i)+"px";j.style.left=(f.min[0]+i+p+1)+"px"}else{d.style.top=(f.min[2]+i+1)+"px";n.style.top=((f.max[2]+i)+(f.cur[3]/2))+"px";o.style.top=(f.max[2]+i)+"px";j.style.top=(f.max[2]+i+p+1)+"px"}};this.getAxesVals=function(e){var d=["minData","maxData","xAxisMin","xAxisMax","xAxis2Min","xAxis2Max","yAxisMin","yAxisMax","zAxisMin","zAxisMax","xAxisUnit","xAxis2Unit","yAxisUnit","zAxisUnit","setMin","setMax","setMin2","setMax2","setMinX","setMaxX","setMinY","setMaxY","setMinZ","setMaxZ","xAxisAbsMin","xAxisAbsMax","xAxis2AbsMin","xAxis2AbsMax","yAxisAbsMin","yAxisAbsMax","zAxisAbsMin","zAxisAbsMax","graphType","x","y","varIndices","smpIndices","grpIndices","varIndicesStart","smpIndicesStart"];var b={};if(this.layoutComb){for(var a=0;a<d.length;a++){b[d[a]]=this.layoutParams[e][d[a]]}}else{for(var a=0;a<d.length;a++){b[d[a]]=this[d[a]]}}return b};this.isAxis=function(k){if(!k){k=window.event}if((this.resizerType&&this.layoutValid)||this.disableAxisResizer){return false}var t=this.adjustedCoordinates(k);if(t){var r=t.x;var p=t.y;var n=0;var s=(this.margin*1);var q=(this.margin*2);var a=18;for(var d=0;d<this.layoutRows;d++){for(var b=0;b<this.layoutCols;b++){var f=this.layoutComb?this.layoutParams[n].graphType:this.graphType;if(f.match(/Network|Pie|Venn|Stacked|Area|Correlation|Circular/)){return false}var m=this.getBoundsXY(n);if(f.match(/Scatter/)){if(r>=m[0]&&r<=m[1]&&p>=m[3]&&p<=m[3]+a){var o=this.getAxesVals(n);this.showAxesResizer("xAxis",m[0],m[1],m[3]+s,m[3]+this.getAxisFont(o.x)+q,"x","h","b",o,"X",n,d,b);return true}else{if(r>=m[0]-a&&r<=m[0]&&p>=m[2]&&p<=m[3]){var o=this.getAxesVals(n);this.showAxesResizer("yAxis",m[0]-(this.getAxisFont(o.y)+q),m[0]-s,m[2],m[3],"y","v","l",o,"Y",n,d,b);return true}}}else{if(f.match(/Heatmap/)){if(r>=m[0]-a&&r<=m[0]&&p>=m[2]&&p<=m[3]){var o=this.getAxesVals(n);this.showAxesResizer("xAxis",m[0]-(this.getAxisFont(o.y)+q),m[0]-s,m[2],m[3],"y","v","l",o,"",n,d,b);return true}else{if(r>=m[1]&&r<=m[1]+a&&p>=m[2]&&p<=m[3]){var o=this.getAxesVals(n);this.showAxesResizer("xAxis",m[1]+s,m[1]+this.getAxisFont(o.y)+q,m[2],m[3],"y","v","r",o,"",n,d,b);return true}else{if(r>=m[0]&&r<=m[1]&&p>=m[2]-a&&p<=m[2]){var o=this.getAxesVals(n);this.showAxesResizer("xAxis",m[0],m[1],m[2]-(this.getAxisFont(o.x)+q),m[2]-s,"x","h","t",o,"",n,d,b);return true}else{if(r>=m[0]&&r<=m[1]&&p>=m[3]&&p<=m[3]+a){var o=this.getAxesVals(n);this.showAxesResizer("xAxis",m[0],m[1],m[3]+s,m[3]+this.getAxisFont(o.x)+q,"x","h","b",o,"",n,d,b);return true}}}}}else{if(this.graphOrientation=="vertical"){if(r>=m[0]-a&&r<=m[0]&&p>=m[2]&&p<=m[3]){var o=this.getAxesVals(n);this.showAxesResizer("xAxis",m[0]-(this.getAxisFont(o.y)+q),m[0]-s,m[2],m[3],"y","v","l",o,"",n,d,b);return true}else{if(r>=m[1]&&r<=m[1]+a&&p>=m[2]&&p<=m[3]){var o=this.getAxesVals(n);if(f=="BarLine"||f=="DotLine"){this.showAxesResizer("xAxis2",m[1]+s,m[1]+this.getAxisFont(o.y)+q,m[2],m[3],"y","v","r",o,"2",n,d,b)}else{this.showAxesResizer("xAxis",m[1]+s,m[1]+this.getAxisFont(o.y)+q,m[2],m[3],"y","v","r",o,"",n,d,b)}return true}}}else{if(r>=m[0]&&r<=m[1]&&p>=m[2]-a&&p<=m[2]){var o=this.getAxesVals(n);this.showAxesResizer("xAxis",m[0],m[1],m[2]-(this.getAxisFont(o.x)+q),m[2]-s,"x","h","t",o,"",n,d,b);return true}else{if(r>=m[0]&&r<=m[1]&&p>=m[3]&&p<=m[3]+a){var o=this.getAxesVals(n);if(f=="BarLine"||f=="DotLine"){this.showAxesResizer("xAxis2",m[0],m[1],m[3]+s,m[3]+this.getAxisFont(o.x)+q,"x","h","b",o,"2",n,d,b)}else{this.showAxesResizer("xAxis",m[0],m[1],m[3]+s,m[3]+this.getAxisFont(o.x)+q,"x","h","b",o,"",n,d,b)}return true}}}}}n++}}}return false};this.endAxesResizer=function(a){if(this.axesResizingOn){this.resetInfoSpan(a);if(this.resizerEventData.active=="prev"||this.resizerEventData.active=="next"){this.moveAxesResizer(a)}this.drawAxesResizerUpdate(true);this.axesResizingOn=false}else{if(this.resizerType){this.updateResizerEventData();this.refreshAxesResizer()}}};this.resetAxesResizer=function(b){if(this.axesResizerShow){var a=document.getElementById(this.target+"canvasXpressAxesResize");if(a){this.addRemoveAxesResizerListeners("removeEvtListener");a.style.display="none";this.resizerEventData={};this.resetInfoSpan(b);this.axesResizerShow=false}}};this.initializeAxisResizerEvents=function(){if(!this.disableEvents&&!this.disableAxisResizer){this.addAxesResizeDiv()}};this.initializeAxisResizerEvents()};CanvasXpress.prototype.initDraggingEvents=function(){this.addDragDiv=function(){if(this.$(this.target+"-cX-Drag")){return}var a=this.$cX("div",{id:this.target+"-cX-Drag",className:"CanvasXpressDrag"},{width:"0px",height:"0px",zIndex:9000});this.canvas.parentNode.appendChild(a)};this.registerDragNetwork=function(l){var c,j,f;var k=this.isEvent(l,true);var b=this.getTargetEvent(l);var a=k[1];if(a&&a.match(/-legend-/)){if(a.match(/-legend-Nodes/)){this.moveLegend="Nodes"}else{if(a.match(/-legend-Edges/)){this.moveLegend="Edges"}else{if(a.match(/-legend-Decorations/)){this.moveLegend="Decorations"}else{this.moveLegend=a.split(/-legend-/)[1]}}}}else{if(a&&a.match(/-lab$/)){if(l.shiftKey){j=true}c=k[0][0]}else{if(a&&a.match(/-dec$/)){if(l.shiftKey){c=k[0][0].split("-")[0];f=true}else{this.resetDrag(l);this.resetFlags(l)}}else{c=k?k[0][0]:"NaN"}}if(!isNaN(c)&&c<this.data.nodes.length){b.style.cursor="move";this.moveNode=true;this.moveNodeIndex=c;if(j){this.moveNodeLab=true}else{if(f){this.moveNodeDec=true}}var d=this.data.nodes[this.moveNodeIndex];this.moveNodeW=d.width?d.width:d.size?(this.nodeSize*d.size):this.nodeSize;this.moveNodeH=d.height?d.height:d.size?(this.nodeSize*d.size):this.nodeSize;if(this.moveNodeLab){this.moveNodeX=d.labelX!=null?d.labelX-((this.xMouseDown/this.scaleFactor)-this.offsetX):0;this.moveNodeY=d.labelY!=null?d.labelY-((this.yMouseDown/this.scaleFactor)-this.offsetY):0}else{if(this.moveNodeDec){this.moveNodeX=d.decorationsX?d.decorationsX-((this.xMouseDown/this.scaleFactor)-this.offsetX):0;this.moveNodeY=d.decorationsY?d.decorationsY-((this.yMouseDown/this.scaleFactor)-this.offsetY):0}else{if(this.is3DNetwork){this.moveNodeX=d.x3d-((this.xMouseDown/this.scaleFactor)-this.offsetX);this.moveNodeY=d.y3d-((this.yMouseDown/this.scaleFactor)-this.offsetY)}else{this.moveNodeX=d.x-((this.xMouseDown/this.scaleFactor)-this.offsetX);this.moveNodeY=d.y-((this.yMouseDown/this.scaleFactor)-this.offsetY)}}}}}if(this.networkStack.length<1||this.networkStack.length-1!=this.networkStackIndex){var h=this.cloneObject(this.networkStack);var m=this.networkStackIndex;this.clearNetworkStack();for(var g=0;g<m;g++){this.networkStack.push(this.cloneObject(h[g]))}this.addToNetworkStack();h=false}};this.registerDragGenome=function(b){var a=this.isEvent(b,true);if(a&&isNaN(a[0][0])){this.moveGenome=a[0][0]}else{this.moveGenome=false}};this.registerDrag=function(n){if(!n){n=window.event}if(this.isCanvasResize(n)){this.resizingCanvasOn=true;this.hideViewport()}else{if(this.isDOE){return false}else{if(!n){return false}if(!this.touches){this.touches=[]}var a=this.getTargetEvent(n);var s=this.adjustedCoordinates(n);if(s){CanvasXpress.current=a.id;var f=s.x;var u=s.y;var r=0;for(var k=0;k<this.layoutRows;k++){for(var h=0;h<this.layoutCols;h++){var m=this.layoutComb?this.layoutParams[r].graphType:this.graphType;var q=this.getBoundsXY(r);if(m.match(/Pie|Venn|Stacked|Area|Circular|Treemap|TagCloud/)){if(this.mobileApp){if(f>=q[0]&&f<=q[1]&&u>=q[2]&&u<=q[3]||this.moveGenome){this.skipClick=false;this.draggingOn=true;this.xMouseDown=f;this.yMouseDown=u;this.touches.push([f,u,new Date().getTime()]);return false}}else{return false}}else{if(m=="Genome"){this.registerDragGenome(n)}}if(f>=q[0]&&f<=q[1]&&u>=q[2]&&u<=q[3]||this.moveGenome){this.skipClick=false;this.draggingOn=true;this.xMouseDown=f;this.yMouseDown=u;this.touches.push([f,u,new Date().getTime()]);if(m=="Correlation"){return false}var p=this.$(this.target+"-cX-Drag");if(m=="Network"){this.registerDragNetwork(n)}if((!m.match(/Scatter|Heatmap|Network|Genome|Circular/)&&this.graphOrientation=="vertical"&&!n.shiftKey)||(!m.match(/Scatter|Heatmap|Network|Genome|Circular/)&&this.graphOrientation!="vertical"&&n.shiftKey)){p.style.left=q[0]+"px"}else{p.style.left=this.xMouseDown+"px"}if((!m.match(/Scatter|Heatmap|Network|Genome|Circular/)&&this.graphOrientation!="vertical"&&!n.shiftKey)||(!m.match(/Scatter|Heatmap|Network|Genome|Circular/)&&this.graphOrientation=="vertical"&&n.shiftKey)||m=="Genome"){p.style.top=q[2]+"px"}else{p.style.top=this.yMouseDown+"px"}if(this.layoutValid){this.layoutValidR=k;this.layoutValidC=h;this.layoutValidN=r}return false}else{if(f>=q[4]&&f<=q[5]&&u>=q[6]&&u<=q[7]){var b=this.isEvent(n);if(b){this.skipClick=false;this.draggingOn=true;this.xMouseDown=f;this.yMouseDown=u;this.touches.push([f,u,new Date().getTime()]);if(m=="Correlation"){return false}var p=this.$(this.target+"-cX-Drag");if(b[0].match("Smp")){this.moveSmp=b[0];if(m.match(/Heatmap/)||this.graphOrientation=="horizontal"){p.style.left=q[4]+"px";p.style.width=(q[5]-q[4])+"px";p.style.height="3px"}else{p.style.width="3px";p.style.top=q[6]+"px";p.style.height=(q[7]-q[6])+"px"}}else{if(b[0].match("Var")){this.moveVar=b[0];p.style.width="3px";p.style.top=q[6]+"px";p.style.height=(q[7]-q[6])+"px"}}return false}}}r++}}return false}}}};this.updateDragScatter3D=function(b,f,e,d,k){if(this.mobileApp&&this.touches&&this.touches.length>1){return}var g=this;var h=this.mobileApp?100:1;var a=function(){clearTimeout(a);var i=g.xMouseDown;var n=g.yMouseDown;var c=b;var m=f;var j=g.lineLength(i,n,c,m);var p=g.layoutComb?g.layoutParams[k].x:g.x;var l=g.layoutComb?g.layoutParams[k].y:g.y;var r=((c-i)*g.rotationSensitivity)/p;var q=((m-n)*g.rotationSensitivity)/l;var o=(j*g.rotationSensitivity)/p;g.xRotate-=r;g.yRotate+=q;g.zRotate-=o;g.draw();g.skipClick=true};setTimeout(a,h)};this.updateDragNetwork=function(D,r,n,z,v,E){if(this.mobileApp&&this.touches&&this.touches.length>1){return}this.movingOn=true;var d=r;var b=n;var q,m,f,o,s,u;var B=this.getTargetEvent(D);var p={};if(this.moveNode||this.moveLegend){if(this.moveLegend){if(this.moveLegend=="Nodes"){m=this.data.legend.pos.nodes.x-((d/this.scaleFactor)-this.offsetX);f=this.data.legend.pos.nodes.y-((b/this.scaleFactor)-this.offsetY);this.data.legend.pos.nodes.x-=m;this.data.legend.pos.nodes.y-=f}else{if(this.moveLegend=="Edges"){m=this.data.legend.pos.edges.x-((d/this.scaleFactor)-this.offsetX);f=this.data.legend.pos.edges.y-((b/this.scaleFactor)-this.offsetY);this.data.legend.pos.edges.x-=m;this.data.legend.pos.edges.y-=f}else{if(this.moveLegend=="Decorations"){m=this.data.legend.pos.decorations.x-((d/this.scaleFactor)-this.offsetX);f=this.data.legend.pos.decorations.y-((b/this.scaleFactor)-this.offsetY);this.data.legend.pos.decorations.x-=m;this.data.legend.pos.decorations.y-=f}else{o=parseInt(this.moveLegend.replace("Text",""));m=this.data.legend.text[o].x-((d/this.scaleFactor)-this.offsetX);f=this.data.legend.text[o].y-((b/this.scaleFactor)-this.offsetY);this.data.legend.text[o].x-=m;this.data.legend.text[o].y-=f}}}}else{if(this.data.nodes[this.moveNodeIndex]){q=this.data.nodes[this.moveNodeIndex];if(this.is3DNetwork){m=(q.x3d-((d/this.scaleFactor)-this.offsetX))-this.moveNodeX;f=(q.y3d-((b/this.scaleFactor)-this.offsetY))-this.moveNodeY}else{m=(q.x-((d/this.scaleFactor)-this.offsetX))-this.moveNodeX;f=(q.y-((b/this.scaleFactor)-this.offsetY))-this.moveNodeY}if(this.moveNodeLab){m=q.labelX!=null?(q.labelX-((d/this.scaleFactor)-this.offsetX))-this.moveNodeX:m;f=q.labelY!=null?(q.labelY-((b/this.scaleFactor)-this.offsetY))-this.moveNodeY:f;this.modifyXYNodeLab(q.id,m,f)}else{if(this.moveNodeDec){m=q.decorationsX?(q.decorationsX-((d/this.scaleFactor)-this.offsetX))-this.moveNodeX:m;f=q.decorationsY?(q.decorationsY-((b/this.scaleFactor)-this.offsetY))-this.moveNodeY:f;this.modifyXYNodeDec(q.id,m,f)}else{if(D.shiftKey&&!D.ctrlKey){var g=(this.moveNodeW-m)+((r-this.xMouseDown)/this.scaleFactor);var A=(this.moveNodeH-f)+((n-this.yMouseDown)/this.scaleFactor);this.modifyNodeSize(q.id,Math.abs(g),Math.abs(A));for(var o in this.selectNode){if(o!=q.id){this.modifyNodeSize(o,g,A)}}}else{u=this.findParentNodes(q.id);if(this.networkLayoutType!="radial"&&((this.moveParentsWithChildren&&!D.shiftKey&&!D.ctrlKey)||(!this.moveParentsWithChildren&&D.shiftKey&&D.ctrlKey))&&u){q=this.data.nodes[this.data.nodeIndices[u[0]]]}this.modifyXYNode(q.id,m,f);if(this.selectNode&&(this.selectNode.hasOwnProperty(q.id)||D.ctrlKey)){if(D.ctrlKey&&!this.selectNode.hasOwnProperty(q.id)){this.addRemoveToSelectedDataPoints([this.moveNodeIndex])}p[q.id]=true;u=this.findChildrenNodeIndices(q.id);if(u){for(var s=0;s<u.length;s++){p[this.data.nodes[u[s]].id]=true}}for(var o in this.selectNode){if(!p.hasOwnProperty(o)){var C=this.data.nodes[this.data.nodeIndices[o]];u=this.findParentNodes(C.id);if(this.networkLayoutType!="radial"&&((this.moveParentsWithChildren&&!D.shiftKey&&!D.ctrlKey)||(!this.moveParentsWithChildren&&D.shiftKey&&D.ctrlKey))&&u){C=this.data.nodes[this.data.nodeIndices[u[0]]]}this.modifyXYNode(C.id,m,f);p[C.id]=true;u=this.findChildrenNodeIndices(C.id);if(u){for(var s=0;s<u.length;s++){p[this.data.nodes[u[s]].id]=true}}}}}else{this.resetSelectedNodes()}}}}}}}else{this.panningX=((r-this.xMouseDown)/this.scaleFactor);this.panningY=((n-this.yMouseDown)/this.scaleFactor)}this.skipClick=m!=null||f!=null?true:false;this.draw(false,false,false,true);if(this.is3DNetwork&&q){this.moveNodeIndex=this.data.nodeIndices[q.id]}var a=this.$(B.id);if(a){a.style.cursor=D.shiftKey?"se-resize":"move"}};this.updateDragGenome=function(h,a,g,f,b,m){if(this.mobileApp&&this.touches&&this.touches.length>1){return}if(this.moveGenome){this.movingOn=true;var k=this.$(this.target+"-cX-Drag");k.style.left="0px";k.style.width=this.width+"px";k.style.top=g+"px";k.style.height="3px"}else{var k=(a-this.xMouseDown)/this.xAxisUnit;if(this.setMinX==null){this.setMinX=this.xAxisMin}if(this.setMaxX==null){this.setMaxX=this.xAxisMax}this.setMinX-=k;this.setMaxX-=k;this.draw();this.xMouseDown=a}};this.updateDrag=function(k){if(this.draggingOn){if(!k){k=window.event}var u=this.adjustedCoordinates(k);if(this.resetOn){this.resetOn=false;this.stopEvent(k);return}if(u){this.touchEvent="drag";var a=u.x;var v=u.y;var f=this.layoutValidR;var b=this.layoutValidC;var o=this.layoutValidN||0;var h=this.layoutComb?this.layoutParams[o].graphType:this.graphType;var q=this.layoutComb?this.layoutParams[o].varIndices:this.varIndices;var s;if(this.isGroupedData){s=this.layoutComb?this.layoutParams[o].grpIndices:this.grpIndices}else{s=this.layoutComb?this.layoutParams[o].smpIndices:this.smpIndices}if(h.match(/Pie|Venn|Stacked|Area|Circular|Treemap|TagCloud/)){if(this.mobileApp){this.movingOn=true;this.resetOn=false}return false}if((h=="Scatter3D"&&!k.shiftKey)||this.is3DPlot){this.updateDragScatter3D(a,v,f,b,o)}else{if(h=="Network"&&((this.moveNode||this.moveLegend)||(!k.ctrlKey&&!k.shiftKey&&!k.altKey))){this.updateDragNetwork(k,a,v,f,b,o)}else{if(h=="Genome"&&(this.moveGenome||!k.shiftKey)){this.updateDragGenome(k,a,v,f,b,o)}else{if(this.moveVar||this.moveSmp){var n=this.getBoundsXY(o);var m=this.$(this.target+"-cX-Drag");this.skipClick=true;if(a>=n[4]&&a<=n[5]&&v>=n[6]&&v<=n[7]){if(this.moveSmp){if(h.match(/Heatmap/)||this.graphOrientation=="horizontal"){m.style.top=v+"px"}else{m.style.left=a+"px"}}else{m.style.left=a+"px"}}}else{if(this.mobileApp&&this.touches&&this.touches.length>1){return}var p;if(this.varIndicesStart>0||this.smpIndicesStart>0){p=true}else{if(this.varIndicesStart==0&&this.startingVarIndices&&this.startingVarIndices[o]){if(this.varIndicesStart+q.length<this.startingVarIndices[o].length){p=true}else{p=false}}else{if(this.smpIndicesStart==0&&this.startingSmpIndices&&this.startingSmpIndices[o]){if(this.smpIndicesStart+s.length<this.startingSmpIndices[o].length){p=true}else{p=false}}else{p=false}}}if(h.match(/Heatmap|Bar|Line|Dotplot|Boxplot|Correlation/)&&p){this.panningOn=true;var w=Math.abs(this.xMouseDown-a);var r=Math.abs(this.yMouseDown-v);var m=false;if(w>r){if(w>this.x/10){m=this.xMouseDown>a?39:37;this.xMouseDown=a;this.yMouseDown=v}}else{if(r>this.y/10){m=this.yMouseDown>v?40:38;this.xMouseDown=a;this.yMouseDown=v}}if(m){this.handlePanning(k,m)}this.movingOn=true;this.resetOn=false;return false}if(h.match(/Correlation/)){return false}var n=this.getBoundsXY(o);var m=this.$(this.target+"-cX-Drag");this.skipClick=true;if((!h.match(/Scatter|Heatmap|Network|Genome|Circular/)&&this.graphOrientation=="vertical"&&!k.shiftKey)||(!h.match(/Scatter|Heatmap|Network|Genome|Circular/)&&this.graphOrientation!="vertical"&&k.shiftKey)){m.style.width=(n[1]-n[0])+"px"}else{if(a>this.xMouseDown){if(a>n[1]){m.style.width=(n[1]-this.xMouseDown)+"px"}else{m.style.width=(a-this.xMouseDown)+"px"}}else{if(a<n[0]){m.style.left=n[0]+"px";m.style.width=(this.xMouseDown-n[0])+"px"}else{m.style.left=a+"px";m.style.width=(this.xMouseDown-a)+"px"}}}if((!h.match(/Scatter|Heatmap|Network|Genome|Circular/)&&this.graphOrientation!="vertical"&&!k.shiftKey)||(!h.match(/Scatter|Heatmap|Network|Genome|Circular/)&&this.graphOrientation=="vertical"&&k.shiftKey)||h=="Genome"){m.style.height=(n[3]-n[2])+"px"}else{if(v>this.yMouseDown){if(v>n[3]){m.style.height=(n[3]-this.yMouseDown)+"px"}else{m.style.height=(v-this.yMouseDown)+"px"}}else{if(v<n[2]){m.style.top=n[2]+"px";m.style.height=(this.yMouseDown-n[2])+"px"}else{m.style.top=v+"px";m.style.height=(this.yMouseDown-v)+"px"}}}}}}}}this.movingOn=true;this.resetOn=false}};this.endDrag=function(z){if(this.draggingOn){var b=this.layoutComb?this.layoutParams[this.layoutValidN].graphType:this.graphType;if(b.match(/Pie|Venn|Stacked|Area|Circular|Treemap|TagCloud/)){return false}if(!z){z=window.event}var j=this.$(this.target);if(j){j.style.cursor="default";var w=this.getTargetEvent(z);if(w&&w.style){w.style.cursor="default"}}this.panningGlobalX+=this.panningX;this.panningGlobalY+=this.panningY;this.panningX=0;this.panningY=0;if((b=="Scatter3D"&&!z.shiftKey)||this.is3DPlot){this.resetDrag(z)}else{if(b=="Network"&&(this.moveNode||this.moveLegend)){if(j){if(this.isSelectNodes&&this.movingOn){this.resetSelectedNodes();this.draw()}if(this.userEvents.enddragnode&&this.movingOn){var m;if(this.moveLegend){m={legend:this.moveLegend}}else{var p=this.moveNodeIndex;var k=this.findChildrenNodeIndices(this.data.nodes[p].id);if(k){k.push(p)}else{k=[p]}m=this.extractDataObject(k)}this.resetDrag(z);this.userEvents.enddragnode.call(this,m)}else{this.resetDrag(z)}this.addToNetworkStack()}}else{if(b=="Genome"&&(this.moveGenome||!z.shiftKey)){if(this.movingOn&&this.moveGenome){var B=this.adjustedCoordinates(z);var C=[];if(B){var n=B.y;if(n!=this.yMouseDown){var A=this.moveGenome.replace("track-","").split(":");var a=parseInt(A[0]);var u=A.length>1?parseInt(A[1]):null;for(var v=0;v<this.subtracksInfo.length;v++){if(this.subtracksInfo[v]){var q=this.subtracksInfo[v].start;var h=this.subtracksInfo[v].track;var g=this.subtracksInfo[v].index;if(q>n){if(a!=h&&a!=h-1){if(h>a){h--}var o=this.data.tracks.splice(a,1)[0];this.data.tracks.splice(h,0,o);this.draw()}else{if(u!=null){if(a==h-1){g=this.subtracksInfo[v-1].index;g++}u=this.subtracksInfo[u].index;if(u!=g){if(g>u){g--}var o=this.data.tracks[a].data.splice(u,1)[0];this.data.tracks[a].data.splice(g,0,o);this.draw()}}}break}}}}}}this.resetDrag(z)}else{if(this.movingOn&&!this.panningOn){var B=this.adjustedCoordinates(z);if(B){var r=B.x;var n=B.y;if(r!=this.xMouseDown||n!=this.yMouseDown){var A=this.$(this.target+"-cX-Drag");var y=parseInt(A.style.left);var f=parseInt(A.style.top);var x=y+parseInt(A.style.width);var c=f+parseInt(A.style.height);this.handleDragEvent(z,y,f,x,c);this.resetDrag(z)}}}else{this.resetDrag(z)}}}}}else{this.resetDrag(z)}};this.validateMinMax=function(c,a,d,b){if(!isNaN(c)&&!isNaN(a)){if(c>a||d>c||b<a){return false}return true}else{return false}};this.handleDragEventNetwork=function(m,c,r,b,p){var f={};var k=[];var v=[];var u=[];var o=[];var q={};for(var j=0;j<this.dataEvent.length;j++){var g=this.dataEvent[j][0];var a=this.dataEvent[j][1];var l=this.dataEvent[j][2];if(this.isObjectInsideArea(a,l,c,r,b,p)){if(g<this.data.nodes.length){f[g]=1}}}for(var j=0;j<this.data.nodes.length;j++){if(!f[j]){k.push(this.data.nodes[j].id)}else{v.push(this.data.nodes[j].id);u.push(j)}}if(k.length<this.data.nodes.length){if(m.shiftKey){this.setSelectNodes(v);this.isSelectNodes=v.length;this.draw();this.draggingOn=false;this.showInfoSpan(m,"While mouse-over nodes:<br>1. Press Shift and drag mouse to resize nodes<br>2. Drag mouse to move nodes")}else{this.resetZoomPan();this.hideUnhideNodes(k,true);this.translateCanvas(-this.offsetX,-this.offsetY);this.scaleCanvas(1/this.scaleFactor,1/this.scaleFactor);this.draw(false,false,false,true)}if(this.showDataTableOnSelect){if(this.networkShowDataTable=="edges"){for(var j=0;j<v.length;j++){q[v[j]]=1}for(var j=0;j<this.data.edges.length;j++){if(q[this.data.edges[j].id1]||q[this.data.edges[j].id2]){o.push(this.data.nodes.length+j)}}this.updateDataTable(this.extractDataObject(o))}else{this.updateDataTable(this.extractDataObject(u))}}}};this.setOriginalIndices=function(f,e,a,d){if(f==null){f=0}if(!e){e=this.layoutComb?this.layoutParams[f].varIndices:this.varIndices}if(!a){if(this.isGroupedData){a=this.layoutComb?this.layoutParams[f].grpIndices:this.grpIndices}else{a=this.layoutComb?this.layoutParams[f].smpIndices:this.smpIndices}}if(d){this.startingVarIndices=[];this.startingSmpIndices=[]}if(!this.startingVarIndices){this.startingVarIndices=[]}if(!this.startingSmpIndices){this.startingSmpIndices=[]}if(!this.startingVarIndices[f]){this.startingVarIndices[f]=[];for(var b=0;b<e.length;b++){this.startingVarIndices[f][b]=e[b]}}if(!this.startingSmpIndices[f]){this.startingSmpIndices[f]=[];for(var b=0;b<a.length;b++){this.startingSmpIndices[f][b]=a[b]}}};this.reorderOriginalIndices=function(k,l,m){var a=[];var f=[];var b=l=="varDendrogram"?this.startingVarIndices[k]:this.startingSmpIndices[k];var h=false;if(k==null){k=0}while(b.length>0){var g=b.shift();if(g==m[1]){f.push(g);while(!h){var e=b.shift();if(e==m[0]){h=true}f.push(e)}f=f.reverse();a=a.concat(f)}else{a.push(g)}}if(l=="varDendrogram"){this.startingVarIndices[k]=a}else{this.startingSmpIndices[k]=a}};this.handleDragEventHeatmap=function(t,q,e,p,d){var h=[];var j=[];var l;this.resetAxesResizer();var b=this.varIndices;var a=this.smpIndices;var w=this.grpIndices;var u=this.varIndicesStart;var r=this.smpIndicesStart;var m=this.layoutComb?this.layoutParams[t].varIndices:this.varIndices;if(this.isGroupedData){l=this.layoutComb?this.layoutParams[t].grpIndices:this.grpIndices}else{l=this.layoutComb?this.layoutParams[t].smpIndices:this.smpIndices}this.setOriginalIndices(t,m,l);if(this.layoutComb){this.varIndicesStart=this.layoutParams[t].varIndicesStart<0?0:this.layoutParams[t].varIndicesStart;this.smpIndicesStart=this.layoutParams[t].smpIndicesStart<0?0:this.layoutParams[t].smpIndicesStart}else{this.varIndicesStart=this.varIndicesStart<0?0:this.varIndicesStart;this.smpIndicesStart=this.smpIndicesStart<0?0:this.smpIndicesStart}this.varIndices=[];if(this.isGroupedData){this.grpIndices=[]}else{this.smpIndices=[]}for(var n=0;n<this.dataEvent.length;n++){var g=this.dataEvent[n][0];var f=this.dataEvent[n][2];if((q<f[0]||q<f[2])&&p>f[0]&&(e<f[1]||e<f[3])&&d>f[1]){if(!h[g[0]]){this.varIndices.push(g[0]);h[g[0]]=1}if(!j[g[1]]){if(this.isGroupedData){this.grpIndices.push(g[1])}else{this.smpIndices.push(g[1])}j[g[1]]=1}}}if(this.varIndices.length>0&&this.smpIndices.length>0){for(var n=0;n<m.length;n++){if(m[n]==this.varIndices[0]){this.varIndicesStart+=n}}for(var n=0;n<l.length;n++){if(this.isGroupedData){if(l[n]==this.grpIndices[0]){this.smpIndicesStart+=n}}else{if(l[n]==this.smpIndices[0]){this.smpIndicesStart+=n}}}this.draw();if(this.showDataTableOnSelect){var k=this.extractDataObject(this.smpIndices,this.varIndices);this.updateDataTable(k)}this.skipClick=false}else{this.varIndices=b;this.smpIndices=a;this.grpIndices=w;this.varIndicesStart=u;this.smpIndicesStart=r}};this.handleDragEventCorrelation=function(c,h,a,g){var j=[];var m=[];var l=this.smpIndices;var k=this.varIndices;this.setOriginalIndices(0,k,l);this.varIndicesStart=this.varIndicesStart<0?0:this.varIndicesStart;this.smpIndicesStart=this.smpIndicesStart<0?0:this.smpIndicesStart;this.varIndices=[];this.smpIndices=[];for(var e=0;e<this.dataEvent.length;e++){var d=this.dataEvent[e][0];var f=this.dataEvent[e][2];if((c<f[0]||c<f[2])&&a>f[0]&&(h<f[1]||h<f[3])&&g>f[1]){if(!j[d[0]]){this.varIndices.push(d[0]);j[d[0]]=1}if(!m[d[1]]){this.smpIndices.push(d[1]);m[d[1]]=1}}}for(var e=0;e<k.length;e++){if(k[e]==this.varIndices[0]){this.varIndicesStart+=e}}for(var e=0;e<l.length;e++){if(l[e]==this.smpIndices[0]){this.smpIndicesStart+=e}}this.draw();if(this.showDataTableOnSelect){var b=this.extractDataObject(this.smpIndices,this.varIndices);this.updateDataTable(b)}this.skipClick=false};this.handleDragEventScatter=function(A,B,z,k,x,h){this.selectDataPoint=[];var a={v:{},s:{}};var q=0;if(A.shiftKey){for(var v=0;v<this.dataEvent.length;v++){var m=this.dataEvent[v][0];var w=this.dataEvent[v][1];var l=this.dataEvent[v][2];if(this.isObjectInsideArea(w,l,z,k,x,h)){this.addRemoveToSelectedDataPoints(m);a.v[m.shift()]=1;for(var u=0;u<m.length;u++){a.s[m[u]]=1}q++}}if(q>0){this.isSelectDataPoints=q;this.handleUserSelectEvent();this.draw();if(this.showDataTableOnSelect){var t=[];var y=[];for(v in a.v){t.push(parseInt(v))}for(v in a.s){y.push(parseInt(v))}t.sort(function(e,c){return(e-c)});y.sort(function(e,c){return(e-c)});var r=this.extractDataObject(y,t);this.updateDataTable(r)}}}else{var n=this;var p=function(e,c){if(n[e+"Transform"]){if(n[e+"Transform"]=="log2"){n["setMin"+c]=Math.pow(2,n["setMin"+c]);n["setMax"+c]=Math.pow(2,n["setMax"+c])}else{if(n[e+"Transform"]=="log10"){n["setMin"+c]=Math.pow(10,n["setMin"+c]);n["setMax"+c]=Math.pow(10,n["setMax"+c])}else{if(n[e+"Transform"]=="exp2"){n["setMin"+c]=Math.log(n["setMin"+c])/Math.LN2;n["setMax"+c]=Math.log(n["setMax"+c])/Math.LN2}else{if(n[e+"Transform"]=="exp10"){n["setMin"+c]=Math.log(n["setMin"+c])/Math.LN10;n["setMax"+c]=Math.log(n["setMax"+c])/Math.LN10}}}}}};var r=this.layoutComb?this.layoutParams[B]:this;var g=r.xAxisMin+((z-(this.marginLeft+r.offsetX+r.left))/r.xAxisUnit);var f=r.xAxisMin+((x-(this.marginLeft+r.offsetX+r.left))/r.xAxisUnit);var b=r.yAxisMax-((k-(this.marginTop+r.offsetY+r.top))/r.yAxisUnit);var d=r.yAxisMax-((h-(this.marginTop+r.offsetY+r.top))/r.yAxisUnit);if(this.validateMinMax(g,f,this.xAxisMin,this.xAxisMax)&&this.validateMinMax(d,b),this.yAxisMin,this.yAxisMax){this.setMinX=g;this.setMaxX=f;this.setMaxY=b;this.setMinY=d;p("xAxis","X");p("yAxis","Y");this.draw()}}};this.handleDragEventGenome=function(i,d,f,b,e){var a,h;var g=this.layoutComb?this.layoutParams[i]:this;var a=g.xAxisMin+((d-(this.marginLeft+g.offsetX+g.left))/g.xAxisUnit);var h=g.xAxisMin+((b-(this.marginLeft+g.offsetX+g.left))/g.xAxisUnit);if(this.validateMinMax(a,h,this.xAxisMin,this.xAxisMax)){this.setMinX=a;this.setMaxX=h;this.draw()}};this.handleDragEventOneDimension=function(D,H,B,d,A,b,K){var a=this.graphType;if(this.moveVar){var l=this.moveVar.split("-")[1];if(this.showVarDendrogram&&this.varDendrogram){alert("Ooops. Cannot change order when showing the dendrogram");return false}var u=this.layoutComb?this.layoutParams[H].varIndices:this.varIndices;var p;for(var y=0;y<u.length;y++){if(u[y]==l){p=y;break}}l=u.splice(p,1);this.varInfo.splice(p,1);var I=[];p=u.length;for(var y=0;y<u.length;y++){if(this.varInfo[y]>B){p=y;break}}u.splice(p,0,l[0]);this.draw();this.skipClick=false}else{if(this.moveSmp){var l=this.moveSmp.split("-")[1];var r;var j=this.isGroupedData?this.grpIndices:this.smpIndices;if(this.isGroupedData){r=this.layoutComb?this.layoutParams[H].grpIndices:this.grpIndices}else{r=this.layoutComb?this.layoutParams[H].smpIndices:this.smpIndices;if(this.showSmpDendrogram&&this.smpDendrogram){alert("Ooops. Cannot change order when showing the dendrogram");return false}}var p;for(var y=0;y<r.length;y++){if(r[y]==l){p=y;break}}l=r.splice(p,1);this.smpInfo.splice(p,1);var I=[];p=r.length;var x=a.match(/Heatmap/)||this.graphOrientation=="horizontal"?d:B;for(var y=0;y<r.length;y++){if(this.smpInfo[y]>x){p=y;break}}r.splice(p,0,l[0]);this.draw();this.skipClick=false}else{if(D.shiftKey||K){var n={};var J=[];var r;var u=this.layoutComb?this.layoutParams[H].varIndices:this.varIndices;var j=this.isGroupedData?this.grpIndices:this.smpIndices;var h=false;if(this.isGroupedData){r=this.layoutComb?this.layoutParams[H].grpIndices:this.grpIndices}else{r=this.layoutComb?this.layoutParams[H].smpIndices:this.smpIndices}this.setOriginalIndices(H,u,r);for(var y=0;y<this.dataEvent.length;y++){var g=this.dataEvent[y][0];var w=this.dataEvent[y][1];var f=this.dataEvent[y][2];if(this.isObjectInsideArea(w,f,B,d,A,b)){n[g[1]]=true}}for(var y=0;y<j.length;y++){if(n.hasOwnProperty(j[y])){J.push(j[y]);if(!h){this.smpIndicesStart=y;h=true}}}this.setSamplesVisible(J,true);this.draw();if(this.showDataTableOnSelect){var q=this.extractDataObject(J,this.varIndices);this.updateDataTable(q)}}else{var q=this.layoutComb?this.layoutParams[H]:this;var m=a=="Candlestick"&&H>0&&this.showVolume;var k=this.layoutComb&&this.layoutCurrent!=H;var v=m&&k?q.xAxis2Min:q.xAxisMin;var z=m&&k?q.xAxis2Max:q.xAxisMax;var G=this.marginLeft+q.offsetX+q.left;var F=G+q.x;var E=this.marginTop+q.offsetY+q.top;var C=E+q.y;if(this.graphOrientation=="vertical"){v=m?v+(Math.max(C-b,0)/q.xAxis2Unit):v+(Math.max(C-b,0)/q.xAxisUnit);z=m?z-(Math.max(d-E,0)/q.xAxis2Unit):z-(Math.max(d-E,0)/q.xAxisUnit)}else{v=m?v+(Math.max(B-G,0)/q.xAxis2Unit):v+(Math.max(B-G,0)/q.xAxisUnit);z=m?z-(Math.max(F-A,0)/q.xAxis2Unit):z-(Math.max(F-A,0)/q.xAxisUnit)}if(this.validateMinMax(v,z,this.xAxisMin,this.xAxisMax)){if(m){this.setMinX2=v;this.setMaxX2=z}else{this.setMinX=v;this.setMaxX=z}this.draw()}}}}};this.handleDragEvent=function(h,b,f,a,d){var i=this.layoutComb?this.layoutValidN:0;var g=this.layoutComb?this.layoutParams[i].graphType:this.graphType;if(g=="Correlation"){this.handleDragEventCorrelation(b,f,a,d)}else{if(g=="Network"){this.handleDragEventNetwork(h,b,f,a,d)}else{if(g=="Heatmap"&&!this.moveVar&&!this.moveSmp){this.handleDragEventHeatmap(i,b,f,a,d)}else{if(g.match(/Scatter/)){this.handleDragEventScatter(h,i,b,f,a,d)}else{if(g=="Genome"){this.handleDragEventGenome(i,b,f,a,d)}else{this.handleDragEventOneDimension(h,i,b,f,a,d)}}}}}};this.resetDrag=function(a){var b=this.$(this.target+"-cX-Drag");if(b){b.style.left="0px";b.style.top="0px";b.style.width="0px";b.style.height="0px"}};this.initializeDraggingEvents=function(){if(!this.disableEvents){this.addDragDiv()}};this.initializeDraggingEvents()};CanvasXpress.prototype.initKeyEvents=function(){this.getKeyCode=function(a){if(a){if((a.charCode)&&(a.keyCode==0)){return a.charCode}else{return a.keyCode}}};this.registerKey=function(b){if(!b){b=window.event}var a=this.getTargetEvent(b);var d=this.getKeyCode(b);if(this.eventKeys||(b.ctrlKey&&b.altKey&&d==107)){if(d==27){if(this.animationOn){this.animationOn=false;return false}this.masterReset(b)}else{if(this.configuringOn){return}else{if(d==16&&this.helpKeyEvents){if(b.ctrlKey&&b.altKey){this.showCtrlShiftAltShorts()}else{if(b.ctrlKey){this.showCtrlShiftShorts()}else{if(b.altKey){this.showShiftAltShorts()}else{this.showShiftShorts()}}}}else{if(d==17&&this.helpKeyEvents){if(b.shiftKey&&b.altKey){this.showCtrlShiftAltShorts()}else{if(b.shiftKey){this.showCtrlShiftShorts()}else{if(b.altKey){this.showCtrlAltShorts()}else{this.showCtrlShorts()}}}}else{if((d==18||d==224)&&this.helpKeyEvents){if(b.ctrlKey&&b.shiftKey){this.showCtrlShiftAltShorts()}else{if(b.ctrlKey){this.showCtrlAltShorts()}else{if(b.shiftKey){this.showShiftAltShorts()}else{this.showAltShorts()}}}}else{if(b.ctrlKey&&b.shiftKey){if(d>=33&&d<=40){this.arrowMove(d,true)}else{if(d==80&&!this.keyOn){this.keyOn=true;this.print()}else{if(d==88&&!this.keyOn){this.keyOn=true;this.clearNetworkStack()}else{if(d==90&&this.graphType=="Network"&&!this.keyOn){this.keyOn=true;this.alignDistributeSelectedNodes(b,d)}}}}document.defaultAction=true}else{if(b.ctrlKey&&b.altKey){if(d==80&&!this.keyOn){this.keyOn=true;this.print()}document.defaultAction=true}else{if(b.shiftKey&&b.altKey){if(d>=50&&d<90&&!this.keyOn){this.keyOn=true;this.setGraphType(d)}document.defaultAction=true}else{if(b.ctrlKey){if(d>=33&&d<=40){if(d==36&&this.isSelectDataPoints&&this.graphType=="Scatter3D"){this.showHideSelectedDataPoint(b,d)}else{if(d==36&&this.isSelectNodes&&this.graphType=="Network"){this.showHideSelectedDataPoint(b,d)}else{this.arrowMove(d)}}}else{if((d==45||d==46)&&!this.keyOn){this.keyOn=true;this.showHideSelectedDataPoint(b,d)}else{if((d>=48&&d<58)&&!this.keyOn){this.keyOn=true;this.setLayout(d-48)}else{if(d>=65&&d<=90){if(d==80&&!this.keyOn){this.keyOn=true;this.print()}if(this.graphType=="Network"&&!this.keyOn&&!/input|textarea|select/i.test(a.tagName)){this.keyOn=true;this.alignDistributeSelectedNodes(b,d)}}}}}document.defaultAction=true}else{if(d==107||d==109||d==61||d==187||d==189){if(this.eventPlusMinusKeys&&!/input|textarea|select/i.test(a.tagName)){if(d==109||d==189){this.handleWheelEvent(b,-1)}else{this.handleWheelEvent(b,1)}}}else{if(b.shiftKey&&d>=33&&d<=40){if(this.eventArrowKeys&&!/input|textarea|select/i.test(a.tagName)){this.handlePanning(b,d)}else{document.defaultAction=true}}else{if(d>=36&&d<=40){if(this.eventArrowKeys&&!/input|textarea|select/i.test(a.tagName)){this.handlePanning(b,d)}}else{if(b.shiftKey){document.defaultAction=true}else{if(b.altKey){document.defaultAction=true}}}}}}}}}}}}}}}};this.handlePanning=function(f,j){if(this.graphType=="Correlation"){this.cancelEvent(f);var p=this.smpIndices;var n=this.varIndices;this.setOriginalIndices(0,this.varIndices,this.smpIndices);if(j==33||j==34||j==35||j==36||j==38||j==40){return false}else{if(j==37){if(this.varIndicesStart>0){this.varIndices.unshift(this.startingVarIndices[0][this.varIndicesStart-1]);this.varIndices.pop();this.varIndicesStart--;this.draw()}if(this.smpIndicesStart>0){this.smpIndices.unshift(this.startingSmpIndices[0][this.smpIndicesStart-1]);this.smpIndices.pop();this.smpIndicesStart--;this.draw()}}else{if(j==39){if(this.varIndicesStart>-1&&this.varIndicesStart+n.length<this.startingVarIndices[0].length){this.varIndices.push(this.startingVarIndices[0][this.varIndicesStart+this.varIndices.length]);this.varIndices.shift();this.varIndicesStart++;this.draw()}if(this.smpIndicesStart>-1&&this.smpIndicesStart+p.length<this.startingSmpIndices[0].length){this.smpIndices.push(this.startingSmpIndices[0][this.smpIndicesStart+this.smpIndices.length]);this.smpIndices.shift();this.smpIndicesStart++;this.draw()}}}}}else{if(this.graphType=="Network"){this.cancelEvent(f);var m=Math.abs(this.x*this.panningStep);var k=Math.abs(this.y*this.panningStep);if(j==33){this.panningY-=k*5}else{if(j==34){this.panningY+=k*5}else{if(j==35){this.panningX=m*20;this.panningY=k*20}else{if(j==36){this.panningX=0;this.panningY=0}else{if(j==37){this.panningX-=m}else{if(j==38){this.panningY-=k}else{if(j==39){this.panningX+=m}else{if(j==40){this.panningY+=k}}}}}}}}this.draw(false,false,false,true)}else{if(this.graphType=="Genome"){var q=this.genomeResolution=="high"?1:this.xAxisRange*this.panningStep;if(this.setMinX==null){this.setMinX=this.xAxisMin}if(this.setMaxX==null){this.setMaxX=this.xAxisMax}this.cancelEvent(f);if(j==37||j==38){this.setMinX-=q;this.setMaxX-=q}else{if(j==39||j==40){this.setMinX+=q;this.setMaxX+=q}else{if(j==33){this.setMinX+=this.xAxisRange*0.95;this.setMaxX+=this.xAxisRange*0.95}else{if(j==34){this.setMinX-=this.xAxisRange*0.95;this.setMaxX-=this.xAxisRange*0.95}else{if(j==35){this.setMaxX=null}else{if(j==36){this.setMinX=null}}}}}}this.draw()}else{if(this.graphType=="Heatmap"){this.cancelEvent(f);this.resetAxesResizer(f);var g=this.layoutComb?this.layoutValidN:0;var p;var n=this.layoutComb?this.layoutParams[g].varIndices:this.varIndices;if(this.isGroupedData){p=this.layoutComb?this.layoutParams[g].grpIndices:this.grpIndices}else{p=this.layoutComb?this.layoutParams[g].smpIndices:this.smpIndices}this.setOriginalIndices(j,n,p);if(j==35){return false}else{if(j==36){this.varIndicesStart=-1;this.smpIndicesStart=-1;this.varIndices=this.startingVarIndices[g];if(this.isGroupedData){this.grpIndices=this.startingSmpIndices[g]}else{this.smpIndices=this.startingSmpIndices[g]}this.draw()}else{if(j==37){if(this.varIndicesStart>0){this.varIndices.unshift(this.startingVarIndices[g][this.varIndicesStart-1]);this.varIndices.pop();this.varIndicesStart--;this.draw()}}else{if(j==38||j==33){var o=j==33?5:1;var h=false;var a=this.isGroupedData?this.grpIndices:this.smpIndices;for(var b=0;b<o;b++){if(this.smpIndicesStart>0){a.unshift(this.startingSmpIndices[g][this.smpIndicesStart-1]);a.pop();this.smpIndicesStart--;h=true}}if(h){this.draw()}}else{if(j==39){if(this.varIndicesStart>-1&&this.varIndicesStart+n.length<this.startingVarIndices[g].length){this.varIndices.push(this.startingVarIndices[g][this.varIndicesStart+this.varIndices.length]);this.varIndices.shift();this.varIndicesStart++;this.draw()}}else{if(j==40||j==34){var o=j==34?5:1;var h=false;var a=this.isGroupedData?this.grpIndices:this.smpIndices;for(var b=0;b<o;b++){if(this.smpIndicesStart>-1&&this.smpIndicesStart+p.length<this.startingSmpIndices[g].length){a.push(this.startingSmpIndices[g][this.smpIndicesStart+a.length]);a.shift();this.smpIndicesStart++;h=true}}if(h){this.draw()}}}}}}}}else{if(this.graphType.match(/Bar|Line|Dotplot|Boxplot|Area|Stacked/)){this.cancelEvent(f);this.resetAxesResizer(f);var g=this.layoutComb?this.layoutValidN:0;var p;var h=false;var n=this.layoutComb?this.layoutParams[g].varIndices:this.varIndices;if(this.isGroupedData){p=this.layoutComb?this.layoutParams[g].grpIndices:this.grpIndices}else{p=this.layoutComb?this.layoutParams[g].smpIndices:this.smpIndices}this.setOriginalIndices(g,n,p);if(j==35||j==36){return false}else{if(j==37||j==38||j==33){var o=j==33?5:1;for(var b=0;b<o;b++){if(this.smpIndicesStart>0){this.smpIndicesStart--;p.unshift(this.startingSmpIndices[g][this.smpIndicesStart]);p.pop();h=true}}}else{if(j==39||j==40||j==34){var o=j==34?5:1;for(var b=0;b<o;b++){if(this.smpIndicesStart+p.length<this.startingSmpIndices[g].length){p.push(this.startingSmpIndices[g][this.smpIndicesStart+p.length]);p.shift();this.smpIndicesStart++;h=true}}}}}if(h){this.draw()}}}}}}return false};this.showCtrlShiftAltShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Ctrl + Shift + Alt</th></tr>";a+="<tr><td class=k>&nbsp;</td><td class=d>&nbsp;</td></tr>";a+="</table>";this.showInfoSpan(false,a)};this.showCtrlShiftShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Shift + Ctrl</th></tr>";if(this.graphType=="Network"){if(this.is3DNetwork){a+="<tr><td class=k>&rarr;</td><td class=d>Rotate clockwise "+(this.rotationStep*1)+"&deg; continuously</td></tr>";a+="<tr><td class=k>&larr;</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*1)+"&deg; continuously</td></tr>";a+="<tr><td class=k>&darr;</td><td class=d>Rotate forward "+(this.rotationStep*1)+"&deg; continuously</td></tr>";a+="<tr><td class=k>&uarr;</td><td class=d>Rotate backward "+(this.rotationStep*1)+"&deg; continuously</td></tr>";a+="<tr><td class=k>PgUp</td><td class=d>Rotate anti-clockwise and backward "+(this.rotationStep*3)+"&deg; continuously</td></tr>";a+="<tr><td class=k>PgDn</td><td class=d>Rotate clockwise and forward "+(this.rotationStep*3)+"&deg; continuously</td></tr>"}else{a+="<tr><td class=k>&rarr; or &darr;</td><td class=d>Rotate clockwise "+(this.rotationStep*1)+"&deg; continuously</td></tr>";a+="<tr><td class=k>&larr; or &uarr;</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*1)+"&deg; continuously</td></tr>";a+="<tr><td class=k>PgUp</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*3)+"&deg; continuously</td></tr>";a+="<tr><td class=k>PgDn</td><td class=d>Rotate clockwise "+(this.rotationStep*3)+"&deg; continuously</td></tr>"}}else{if(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D"){if(this.type2D=="XYZ"){if(this.xAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update samples in X, Y and Z axes continuously (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update samples in X, Y and Z axes continuously (2x)</td></tr>"}}else{if(this.type2D=="XY"){if(this.zAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update sample in Z axis continuously (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update sample in Z axis continuously (2x)</td></tr>"}}else{if(this.type2D=="X"){if(this.yAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update samples in Y and Z axes continuously (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update samples in Y and Z axes continuously (2x)</td></tr>"}}else{if(this.xAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update samples in X and Z axes continuously (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update samples in X and Z axes continuously (2x)</td></tr>"}}}}}else{if(this.graphType=="Scatter3D"){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Rotate continuously</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Rotate continuously</td></tr>"}}}a+="<tr><td class=k>P</td><td class=d>Print</td></tr>";a+="</table>";this.showInfoSpan(false,a)};this.showCtrlAltShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Ctrl + Alt</th></tr>";a+="<tr><td class=k>P</td><td class=d>Print</td></tr>";a+="</table>";this.showInfoSpan(false,a)};this.showShiftAltShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Shift + Alt</th></tr>";a+="<tr><td class=k>2</td><td class=d>Scatter2D</td></tr>";a+="<tr><td class=k>3</td><td class=d>Scatter3D</td></tr>";a+="<tr><td class=k>4</td><td class=d>ScatterBubble2D</td></tr>";a+="<tr><td class=k>A</td><td class=d>Area</td></tr>";a+="<tr><td class=k>B</td><td class=d>Bar</td></tr>";a+="<tr><td class=k>C</td><td class=d>BarLine</td></tr>";a+="<tr><td class=k>D</td><td class=d>Dotplot</td></tr>";a+="<tr><td class=k>E</td><td class=d>DotLine</td></tr>";a+="<tr><td class=k>F</td><td class=d>AreaLine</td></tr>";a+="<tr><td class=k>G</td><td class=d>Genome</td></tr>";a+="<tr><td class=k>H</td><td class=d>Heatmap</td></tr>";a+="<tr><td class=k>I</td><td class=d>Boxplot</td></tr>";a+="<tr><td class=k>L</td><td class=d>Line</td></tr>";a+="<tr><td class=k>M</td><td class=d>Candlestick</td></tr>";a+="<tr><td class=k>N</td><td class=d>Network</td></tr>";a+="<tr><td class=k>P</td><td class=d>Pie</td></tr>";a+="<tr><td class=k>R</td><td class=d>Circular</td></tr>";a+="<tr><td class=k>S</td><td class=d>Stacked</td></tr>";a+="<tr><td class=k>T</td><td class=d>StackedPercent</td></tr>";a+="<tr><td class=k>U</td><td class=d>StackedLine</td></tr>";a+="<tr><td class=k>W</td><td class=d>StackedPercentLine</td></tr>";a+="<tr><td class=k>V</td><td class=d>Venn</td></tr>";a+="<tr><td class=k>X</td><td class=d>Correlation</td></tr>";a+="<tr><td class=k>Y</td><td class=d>Treemap</td></tr>";a+="<tr><td class=k>Z</td><td class=d>TagCloud</td></tr>";a+="</table>";this.showInfoSpan(false,a)};this.showCtrlShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Ctrl</th></tr>";if(this.graphType=="Network"){if(this.is3DNetwork){a+="<tr><td class=k>&rarr;</td><td class=d>Rotate clockwise "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&larr;</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&darr;</td><td class=d>Rotate forward "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&uarr;</td><td class=d>Rotate backward "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>PgUp</td><td class=d>Rotate anti-clockwise and backward "+(this.rotationStep*3)+"&deg;</td></tr>";a+="<tr><td class=k>PgDn</td><td class=d>Rotate clockwise and forward "+(this.rotationStep*3)+"&deg;</td></tr>"}else{a+="<tr><td class=k>&rarr; or &darr;</td><td class=d>Rotate clockwise "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&larr; or &uarr;</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>PgUp</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*3)+"&deg;</td></tr>";a+="<tr><td class=k>PgDn</td><td class=d>Rotate clockwise "+(this.rotationStep*3)+"&deg;</td></tr>"}a+="<tr><td class=k>click</td><td class=d>Select/Unselect node</td></tr>";if(this.isSelectNodes){a+="<tr><td class=k>Delete</td><td class=d>Hide selected nodes</td></tr>";a+="<tr><td class=k>Insert</td><td class=d>Show selected-hidden nodes</td></tr>";a+="<tr><td class=k>Home</td><td class=d>Show connected nodes to slected nodes</td></tr>";a+="<tr><td class=k>t</td><td class=d>Align top</td></tr>";a+="<tr><td class=k>r</td><td class=d>Align right</td></tr>";a+="<tr><td class=k>b</td><td class=d>Align bottom</td></tr>";a+="<tr><td class=k>l</td><td class=d>Align left</td></tr>";a+="<tr><td class=k>v</td><td class=d>Distribute verticaly</td></tr>";a+="<tr><td class=k>h</td><td class=d>Distribute Horizontaly</td></tr>";a+="<tr><td class=k>z</td><td class=d>Undo</td></tr>";a+="<tr><td class=k>y</td><td class=d>Redo</td></tr>"}}else{if(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D"){if(this.type2D=="XYZ"){if(this.xAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update samples in X, Y and Z axes (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update samples in X, Y and Z axes (2x)</td></tr>"}}else{if(this.type2D=="XY"){if(this.zAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update sample in Z axis (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update sample in Z axis (2x)</td></tr>"}}else{if(this.type2D=="X"){if(this.yAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update samples in Y and Z axes (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update samples in Y and Z axes (2x)</td></tr>"}}else{if(this.xAxis.length>1){a+="<tr><td class=k>&rarr; or &darr; or &larr; or &uarr;</td><td class=d>Update samples in X and Z axes (1x)</td></tr>";a+="<tr><td class=k>PgUp or PgDn</td><td class=d>Update samples in X and Z axes (2x)</td></tr>"}}}}if(this.isSelectDataPoints){a+="<tr><td class=k>Delete</td><td class=d>Hide selected nodes</td></tr>";a+="<tr><td class=k>Insert</td><td class=d>Show selected-hidden nodes</td></tr>"}}else{if(this.graphType=="Scatter3D"){a+="<tr><td class=k>&rarr;</td><td class=d>Rotate clockwise "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&larr;</td><td class=d>Rotate anti-clockwise "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&darr;</td><td class=d>Rotate forward "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>&uarr;</td><td class=d>Rotate backward "+(this.rotationStep*1)+"&deg;</td></tr>";a+="<tr><td class=k>PgUp</td><td class=d>Rotate anti-clockwise and backward "+(this.rotationStep*3)+"&deg;</td></tr>";a+="<tr><td class=k>PgDn</td><td class=d>Rotate clockwise and forward "+(this.rotationStep*3)+"&deg;</td></tr>";a+="<tr><td class=k>click</td><td class=d>Select/Unselect data points</td></tr>";if(this.isSelectDataPoints){a+="<tr><td class=k>Delete</td><td class=d>Hide selected nodes</td></tr>";a+="<tr><td class=k>Insert</td><td class=d>Show selected-hidden nodes</td></tr>";a+="<tr><td class=k>Home</td><td class=d>Zoom to selected nodes</td></tr>"}}else{if(this.isSegregable()){}}}}a+="<tr><td class=k>P</td><td class=d>Print</td></tr>";a+="</table>";this.showInfoSpan(false,a)};this.showShiftShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Shift</th></tr>";if(this.isSegregable()){a+="<tr><td class=k>Click and Drag</td><td class=d>Select Samples</td></tr>"}else{a+="<tr><td class=k>&nbsp;</td><td class=d>&nbsp;</td></tr>"}a+="</table>";this.showInfoSpan(false,a)};this.showAltShorts=function(){var a="<table class=shorts>";a+="<tr><th colspan=2>Alt</th></tr>";a+="<tr><td class=k>&nbsp;</td><td class=d>&nbsp;</td></tr>";a+="</table>";this.showInfoSpan(false,a)};this.arrowMove=function(j,b){var e=this.graphType;if(this.is3DPlot){e="Scatter3D;"}switch(e){case"Network":if(this.is3DNetwork){if(j==33){this.xRotate+=(this.rotationStep*3);this.yRotate-=(this.rotationStep*3)}else{if(j==34){this.xRotate-=(this.rotationStep*3);this.yRotate+=(this.rotationStep*3)}else{if(j==37){this.xRotate+=this.rotationStep}else{if(j==38){this.yRotate-=this.rotationStep}else{if(j==39){this.xRotate-=this.rotationStep}else{if(j==40){this.yRotate+=this.rotationStep}}}}}}}else{if(j==33){this.network2DRotate-=(this.rotationStep*3)}else{if(j==34){this.network2DRotate+=(this.rotationStep*3)}else{if(j==37||j==38){this.network2DRotate-=this.rotationStep}else{if(j==39||j==40){this.network2DRotate+=this.rotationStep}}}}}break;case"Scatter2D":case"ScatterBubble2D":var f;var h;if(this.type2D=="XYZ"){f=["xAxisCurrent","yAxisCurrent","zAxisCurrent"];h=["xAxis","yAxis","zAxis"]}else{if(this.type2D=="XY"){f=["zAxisCurrent"];h=["zAxis"]}else{if(this.type2D=="X"){f=["yAxisCurrent","zAxisCurrent"];h=["yAxis","zAxis"]}else{f=["xAxisCurrent","zAxisCurrent"];h=["xAxis","zAxis"]}}}if(j==33){for(var d=0;d<f.length;d++){this[f[d]]+=2}}else{if(j==34){for(var d=0;d<f.length;d++){this[f[d]]-=2}}else{if(j==35){for(var d=0;d<f.length;d++){this[f[d]]=this[h[d]].length-1}}else{if(j==36){for(var d=0;d<f.length;d++){this[f[d]]=0}}else{if(j==37||j==40){for(var d=0;d<f.length;d++){this[f[d]]--}}else{if(j==38||j==39){for(var d=0;d<f.length;d++){this[f[d]]++}}}}}}}this.xAxisCurrent=this.xAxisCurrent<0?this.xAxis.length-1:this.xAxisCurrent>this.xAxis.length-1?0:this.xAxisCurrent;this.yAxisCurrent=this.yAxisCurrent<0?this.xAxis.length-1:this.yAxisCurrent>this.yAxis.length-1?0:this.yAxisCurrent;this.zAxisCurrent=this.zAxisCurrent<0?this.xAxis.length-1:this.zAxisCurrent>this.zAxis.length-1?0:this.zAxisCurrent;break;case"Scatter3D":if(j==33){this.xRotate+=(this.rotationStep*3);this.yRotate-=(this.rotationStep*3)}else{if(j==34){this.xRotate-=(this.rotationStep*3);this.yRotate+=(this.rotationStep*3)}else{if(j==35){this.xRotate=0;this.yRotate=0;this.zRotate=45}else{if(j==36){this.xRotate=45;this.yRotate=0;this.zRotate=0}else{if(j==37){this.xRotate+=this.rotationStep}else{if(j==38){this.yRotate-=this.rotationStep}else{if(j==39){this.xRotate-=this.rotationStep}else{if(j==40){this.yRotate+=this.rotationStep}}}}}}}}break}if(b&&!this.animationOn){this.animationOn=true;this.animate(j)}else{this.draw(false,false,false,true)}};this.animate=function(d){var a=this;var b=function(){this.update=function(){if(!a.animationOn){clearInterval(c)}a.arrowMove(d);var e=a.graphType;if(a.is3DPlot){e="Scatter3D"}switch(e){case"Network":if(this.is3DNetwork){if(d==33){this.xRotate+=(this.rotationStep*3);this.yRotate-=(this.rotationStep*3)}else{if(d==34){this.xRotate-=(this.rotationStep*3);this.yRotate+=(this.rotationStep*3)}else{if(d==37){this.xRotate-=this.rotationStep}else{if(d==38){this.yRotate-=this.rotationStep}else{if(d==39){this.xRotate+=this.rotationStep}else{if(d==40){this.yRotate+=this.rotationStep}}}}}}}else{if(d==33){this.network2DRotate+=(this.rotationStep*3)}else{if(d==34){this.network2DRotate-=(this.rotationStep*3)}else{if(d==37||d==38){this.network2DRotate-=this.rotationStep}else{if(d==39||d==40){this.network2DRotate+=this.rotationStep}}}}}break;case"Scatter2D":case"ScatterBubble2D":if(d!=37){if(a.graphType=="ScatterBubble2D"&&a.xAxisIndices.length>1&&a.xAxisIndices.length==a.yAxisIndices.length&&a.xAxisIndices.length==a.zAxisIndices.length){if(a.xAxisCurrent>=a.xAxis.length-1){a.xAxisCurrent=a.xAxis.length-1;a.yAxisCurrent=a.yAxis.length-1;a.zAxisCurrent=a.zAxis.length-1;d=37}}else{if(a.xAxisIndices.length>1&&a.xAxisIndices.length==a.yAxisIndices.length){if(a.zAxisCurrent>=a.zAxis.length-1){a.zAxisCurrent=a.zAxis.length-1;d=37}}else{if(a.xAxisIndices.length>a.yAxisIndices.length){if(a.yAxisCurrent>=a.yAxis.length-1){a.yAxisCurrent=a.yAxis.length-1}if(a.zAxisCurrent>=a.zAxis.length-1){a.zAxisCurrent=a.zAxis.length-1}if(a.yAxisCurrent>=a.yAxis.length-1&&a.zAxisCurrent>=a.zAxis.length-1){d=37}}else{if(a.xAxisCurrent>=a.xAxis.length-1){a.xAxisCurrent=a.xAxis.length-1}if(a.zAxisCurrent>=a.zAxis.length-1){a.zAxisCurrent=a.zAxis.length-1}if(a.xAxisCurrent>=a.xAxis.length-1&&a.zAxisCurrent>=a.zAxis.length-1){d=37}}}}}else{if(d!=39){if(a.graphType=="ScatterBubble2D"&&a.xAxisIndices.length>1&&a.xAxisIndices.length==a.yAxisIndices.length&&a.xAxisIndices.length==a.zAxisIndices.length){if(a.xAxisCurrent<=0){a.xAxisCurrent=0;a.yAxisCurrent=0;a.zAxisCurrent=0;d=39}}else{if(a.xAxisIndices.length>1&&a.xAxisIndices.length==a.yAxisIndices.length){if(a.zAxisCurrent<=0){a.zAxisCurrent=0;d=39}}else{if(a.xAxisIndices.length>a.yAxisIndices.length){if(a.yAxisCurrent<=0){a.yAxisCurrent=0}if(a.zAxisCurrent<=0){a.zAxisCurrent=0}if(a.yAxisCurrent<=0&&a.zAxisCurrent<=0){d=39}}else{if(a.xAxisCurrent<=0){a.xAxisCurrent=0}if(a.zAxisCurrent<=0){a.zAxisCurrent=0}if(a.xAxisCurrent<=0&&a.zAxisCurrent<=0){d=39}}}}}}break;case"Scatter3D":if(a.xRotate<=0&&(d==39||d<37)){a.xRotate=0;a.yRotate=0;d=40}else{if(a.xRotate>=90&&(d==37||d<37)){a.xRotate=90;a.yRotate=90;d=38}else{if(a.yRotate<=0&&(d==38||d<37)){a.yRotate=0;a.xRotate=90;d=39}else{if(a.yRotate>=90&&(d==40||d<37)){a.yRotate=90;a.xRotate=0;d=37}}}}break}};var c=setInterval(this.update,a.animationTime)};b.call()};this.setGraphType=function(b){var a;if(b==66){a="Bar"}else{if(b==76){a="Line"}else{if(b==65){a="Area"}else{if(b==70){a="AreaLine"}else{if(b==67){a="BarLine"}else{if(b==73){a="Boxplot"}else{if(b==68){a="Dotplot"}else{if(b==69){a="DotLine"}else{if(b==72){a="Heatmap"}else{if(b==83){a="Stacked"}else{if(b==85){a="StackedLine"}else{if(b==84){a="StackedPercent"}else{if(b==87){a="StackedPercentLine"}else{if(b==50){a="Scatter2D"}else{if(b==52){a="ScatterBubble2D"}else{if(b==51){a="Scatter3D"}else{if(b==88){a="Correlation"}else{if(b==86){a="Venn"}else{if(b==80){a="Pie"}else{if(b==78){a="Network"}else{if(b==71){a="Genome"}else{if(b==77){a="Candlestick"}else{if(b==82){a="Circular"}else{if(b==89){a="Treemap"}else{if(b==90){a="TagCloud"}}}}}}}}}}}}}}}}}}}}}}}}}if(a&&this.isValidGraphType(a)){this.graphType=a;this.draw()}else{alert("Dude! You cannot plot this data in a "+a+" graph")}};this.reset=function(a){this.varIndicesStart=-1;this.smpIndicesStart=-1;switch(this.graphType){case"Area":case"AreaLine":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Heatmap":case"Correlation":case"Venn":case"Pie":case"Bar":case"Line":case"BarLine":case"Boxplot":case"Dotplot":case"DotLine":case"Candlestick":case"Circular":case"Treemap":case"TagCloud":this.setAllVariablesVisible(false,a);this.setAllSamplesVisible(false,a);break;case"Scatter2D":case"ScatterBubble2D":case"Scatter3D":this.resetSelectedDataPoints();this.setAllVariablesVisible(false,a);this.setAllSamplesVisible(false,a);break;case"Network":this.resetSelectedNodes();this.setAllNodesVisible();this.translateCanvas(-this.offsetX,-this.offsetY);this.scaleCanvas(1/this.scaleFactor,1/this.scaleFactor);break;case"Genome":this.setAllFeaturesVisible(a);break}};this.redraw=function(){this.varIndicesStart=-1;this.smpIndicesStart=-1;switch(this.graphType){case"Area":case"AreaLine":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Correlation":case"Venn":case"Pie":case"Circular":case"Treemap":case"TagCloud":this.setAllVariablesVisible();this.setAllSamplesVisible();break;case"Bar":case"Line":case"BarLine":case"Boxplot":case"Dotplot":case"DotLine":case"Genome":case"Candlestick":this.setAllVariablesVisible();this.setAllSamplesVisible();this.setMinX=null;this.setMaxX=null;this.setMinX2=null;this.setMaxX2=null;this.xRotate=45;this.yRotate=0;break;case"Scatter2D":case"ScatterBubble2D":this.resetSelectedDataPoints();this.setAllVariablesVisible();this.setAllSamplesVisible();this.setMinX=null;this.setMaxX=null;this.setMinY=null;this.setMaxY=null;break;case"Scatter3D":this.resetSelectedDataPoints();this.setAllVariablesVisible();this.setAllSamplesVisible();this.xRotate=45;this.yRotate=0;break;case"Heatmap":this.setAllVariablesVisible();this.setAllSamplesVisible();break;case"Network":this.resetSelectedNodes();this.setAllNodesVisible();this.network2DRotate=0;if(this.randomData){this.layoutDone=true}this.translateCanvas(-this.offsetX,-this.offsetY);this.scaleCanvas(1/this.scaleFactor,1/this.scaleFactor);break}this.setInitialConfig();this.draw();return true};this.resetZoomPan=function(){this.zoom=1;this.panningX=0;this.panningY=0;this.panningGlobalX=0;this.panningGlobalY=0;this.padX=this.x/2;this.padY=this.y/2;this.padZ=this.y/2};this.resetSelectedObjects=function(){if(this.isSelectDataPoints||this.isSelectNodes){this.resetSelectedDataPoints();this.resetSelectedNodes();this.draw()}};this.masterReset=function(a){if(this.isDOE){this.resetDOE()}else{this.resetTooltipDivs();this.resetDrag(a);this.resetSelectedDataPoints();this.resetSelectedNodes();if(this.dataTableLastState&&this.dataTableLastState!="docked"){this.hideUnhideDataTable(true)}this.resetConfigurator();this.resetAxesResizer(a);this.resetFlags(a);this.resetZoomPan();this.redraw();if(this.isOncoprint){this.zoomOncoprintVariables(18)}}}};CanvasXpress.prototype.initSelectEvents=function(){this.showHideSelectedDataPoint=function(j,l){if(j){this.stopEvent(j)}var o=this.layoutComb?this.layoutValidN:0;var r=this.layoutComb?this.layoutParams[o].graphType:this.graphType;var q=[];if(l==45||l==46){if(r=="Network"){var a=[];var k=l==45?false:true;for(var d in this.selectNode){a.push(d)}if(a.length>0){this.hideUnhideNodes(a,k)}}else{if(r.match(/Scatter/)){if(l==45){this.selectDataPoint=this.hideDataPoint;this.hideDataPoint=[]}else{if(l==46){this.hideDataPoint=this.selectDataPoint;this.selectDataPoint=[]}}if(r=="Scatter3D"){var m=this.xAxisIndex+":"+this.yAxisIndex+":"+this.zAxisIndex;for(var g=0;g<this.data.y.vars.length;g++){if(this.isVisibleSelectedDataPoint(g,m)){q.push(g)}}this.varIndices=q}}}this.draw()}else{if(l==36){if(r=="Network"){var b={};var h=[];var a=this.data.nodes;var f=this.data.edges;for(var g=0;g<f.length;g++){if(this.selectNode.hasOwnProperty(f[g].id1)||this.selectNode.hasOwnProperty(f[g].id2)){b[f[g].id1]=true;b[f[g].id2]=true}}for(var g=0;g<a.length;g++){if(!b.hasOwnProperty(a[g].id)||a[g].hide){h.push(a[g].id)}}this.resetSelectedNodes();if(h.length>0){this.hideUnhideNodes(h,true);this.draw()}}else{if(r=="Scatter3D"){if(this.isSelectDataPoints){for(var g in this.selectDataPoint){var p=parseInt(g);if(!isNaN(p)){q.push(this.varIndices[p])}}this.isSelectDataPoints=0;this.selectDataPoint=[];this.varIndices=q;this.draw()}}}}}};this.addRemoveToSelectedDataPoints=function(a){var l=this.broadcast?CanvasXpress.references:[this];for(var g=0;g<l.length;g++){var d=l[g];var j=d.layoutComb?d.layoutValidN:0;if(j!=null){var n=d.layoutComb?d.layoutParams[j].graphType:d.graphType;if(n=="Network"){var b=parseInt(a.join(", "));if(b<d.data.nodes.length){var m=d.data.nodes[b].id;if(d.selectNode.hasOwnProperty(m)){d.isSelectNodes--;delete (d.selectNode[m])}else{d.isSelectNodes++;d.selectNode[m]=true}}}else{if(n=="Pie"){var p,h,f;if(a.length>2){p=1;h=a.length;f=a[0]}else{p=0;h=1;f=a[1]}for(var g=p;g<h;g++){if(this.broadcastType=="var"){if(d.selectDataPoint[a[g]]){delete (d.selectDataPoint[a[g]]);d.isSelectDataPoints--}else{d.selectDataPoint[a[g]]=true;d.isSelectDataPoints++}}else{if(!d.selectDataPoint[a[g]]){d.selectDataPoint[a[g]]={}}if(d.selectDataPoint[a[g]].hasOwnProperty(f)){d.isSelectDataPoints--;delete (d.selectDataPoint[a[g]][f])}else{d.isSelectDataPoints++;d.selectDataPoint[a[g]][f]=true}}}d.draw()}else{if(n=="Circular"){}else{if(n=="Venn"){}else{if(n=="Genome"){}else{if(n=="Correlation"){}else{if(n=="Scatter2D"&&this.isHistogram){var m=a[1]-1;var o=this.data.y.histogram[a[0]][m];for(var g=0;g<o.length;g++){if(this.broadcastType=="var"){if(d.selectDataPoint[o[g]]){delete (d.selectDataPoint[o[g]]);d.isSelectDataPoints--}else{d.selectDataPoint[o[g]]=true;d.isSelectDataPoints++}}else{if(!d.selectDataPoint[o[g]]){d.selectDataPoint[o[g]]={}}if(d.selectDataPoint[o[g]].hasOwnProperty(m)){d.isSelectDataPoints--;delete (d.selectDataPoint[o[g]][m])}else{d.isSelectDataPoints++;d.selectDataPoint[o[g]][m]=true}}}d.draw()}else{var m;if(!d.selectDataPoint[a[0]]){d.selectDataPoint[a[0]]={}}if(n.match(/Scatter/)){if(n=="Scatter3D"){m=a[1]+":"+a[2]+":"+a[3]}else{m=a[1]+":"+a[2]}}else{m=a[1]}if(d.selectDataPoint[a[0]].hasOwnProperty(m)){d.isSelectDataPoints--;if(this.broadcastType=="var"){delete (d.selectDataPoint[a[0]])}else{delete (d.selectDataPoint[a[0]][m])}}else{d.isSelectDataPoints++;if(this.broadcastType=="var"){d.selectDataPoint[a[0]]=true}else{d.selectDataPoint[a[0]][m]=true}}d.draw()}}}}}}}}}};this.handleUserSelectEvent=function(){if(this.userEvents.select){var a=this.broadcast?CanvasXpress.references:[this];for(var b=0;b<a.length;b++){var c=a[b];if(c.graphType=="Network"){this.userEvents.select.call(c,c.selectNode)}else{this.userEvents.select.call(c,c.selectDataPoint)}}}};this.resetSelectedDataPoints=function(){if(this.isSelectDataPoints){this.selectDataPoint=[];this.hideDataPoint=[];this.isSelectDataPoints=0}};this.resetSelectedNodes=function(){if(this.isSelectNodes){this.selectNode={};this.isSelectNodes=0}}};CanvasXpress.prototype.initDendrogramEvents=function(){this.modifyDendrogram=function(g){this.setOriginalIndices();this.clusterAxis=g.t.t=="varDendrogram"?"variables":"samples";var c=g.t.t.replace("Dendrogram","s");var f=this[g.t.t].object;var h=g.t.d+"-"+g.t.o;var e=this.findDendrogramBranch(f,h);var b=this.reverseDendrogramBranch(e);var d=this.findDendrogramIndices(g.t.t,e);var a=this.writeNewick(f,true);this.data.t[c]=a;this.reorderOriginalIndices(g.t.c||0,g.t.t,d);this.draw()};this.findDendrogramBranch=function(b,c,a){if(b.id==c){a=b}if(!a){if(b.left){a=this.findDendrogramBranch(b.left,c,a)}if(b.right){a=this.findDendrogramBranch(b.right,c,a)}}else{return a}return a};this.findDendrogramIndices=function(c,f){var b,d;var e=f.left;var a=f.right;while(e.left){b=e.id;e=e.left}b=e.id;while(a.right){d=a.id;a=a.right}d=a.id;if(c=="varDendrogram"){b=this.getVariableIndices(b);d=this.getVariableIndices(d)}else{b=this.getSampleIndices(b);d=this.getSampleIndices(d)}return[b,d]};this.reverseDendrogramBranch=function(b){if(b&&b.right&&b.left){b.right=this.reverseDendrogramBranch(b.right);b.left=this.reverseDendrogramBranch(b.left);var a=b.left;b.left=b.right;b.right=a;if(b.mid){b.mid=b.mid.reverse()}}return b};this.zoomDendrogram=function(e){this.setOriginalIndices();var d=false;var k=e.t.c||0;var j=this[e.t.t].object;var b=e.t.d+"-"+e.t.o;var m=this.findDendrogramBranch(j,b);var f=this.findDendrogramIndices(e.t.t,m);var g=f[0];var a=f[1];if(e.t.t=="varDendrogram"){this.varIndices=[];for(var h=0;h<this.startingVarIndices[k].length;h++){if(this.startingVarIndices[k][h]==g){this.varIndicesStart=h;d=true}else{if(this.startingVarIndices[k][h]==a){this.varIndices.push(this.startingVarIndices[k][h]);break}}if(d){this.varIndices.push(this.startingVarIndices[k][h])}}}else{this.smpIndices=[];for(var h=0;h<this.startingSmpIndices[k].length;h++){if(this.startingSmpIndices[k][h]==g){this.smpIndicesStart=h;d=true}else{if(this.startingSmpIndices[k][h]==a){this.smpIndices.push(this.startingSmpIndices[k][h]);break}}if(d){this.smpIndices.push(this.startingSmpIndices[k][h])}}}this.draw()}};CanvasXpress.prototype.initCanvasEvents=function(){this.contextmenuCanvas=function(a){return function(c){if(!c){c=window.event}if(c){if(a.Ext&&a.Ext.contextmenu){return}else{a.cancelEvent(c);var b=a.getEventDataId(c);a.handleMouseEvents("contextmenu",c,b)}}return false}}(this);this.mousedownCanvas=function(a){return function(c){if(!c){c=window.event}if(c&&c.which?c.which!=3:c.button!=2){if(!a.configuringOn||(a.configuratorLastState&&a.configuratorLastState=="docked")){a.touchEvent="hold";a.registerDrag(c);if(a.mobileApp){var b=function(){clearTimeout(b);if(a.touches&&a.touches.length==1&&a.touchEvent=="hold"){a.masterReset(c)}};setTimeout(b,500)}}}return false}}(this);this.clickCanvas=function(a){return function(b){if(!b){b=window.event}if(a.isIE){b=a.copyEvent(b)}a.resetMenuLinks();a.closeHelp();a.clickBuffer=function(){if(!a.doubleClick){if(!a.configuringOn||(a.configuratorLastState&&a.configuratorLastState=="docked")){if(!a.skipClick&&(a.lastCanvasEvent!="drag")){if(a.isHelp(b)){a.stopEvent(b);a.showInfoSpan(b,'Modify "helpKeyEvents"<br>&nbsp;&nbsp;&nbsp;to show or hide help<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;on key events"')}else{if(a.isAxis(b)){a.stopEvent(b)}else{if(a.axesResizerShow&&!a.resizerType){a.stopEvent(b);a.resetAxesResizer(b)}else{if(a.mobileApp){a.stopEvent(b);a.addConfigurator(b)}else{var c=a.getEventDataId(b);if(c){a.handleMouseEvents("click",b,c)}else{if(!b.ctrlKey){a.resetSelectedObjects()}}}}}}}}else{a.resetConfigurator()}a.lastCanvasEvent="click"}};setTimeout(a.clickBuffer,250);setTimeout(function(){a.doubleClick=false},500)}}(this);this.dblclickCanvas=function(a){return function(c){if(!c){c=window.event}a.doubleClick=true;if(a.clickBuffer){clearTimeout(a.clickBuffer);a.clickBuffer=null}if(!a.skipClick){var b=a.getEventDataId(c);if(b){a.handleMouseEvents("dblclick",c,b)}else{a.cancelEvent(c);a.addConfigurator(c)}a.lastCanvasEvent="dblclick"}return false}}(this);this.wheelCanvas=function(a){return function(b){if(!b){b=window.event}if(a.lastWheel){if(new Date().getTime()-a.lastWheel<20){a.cancelEvent(b);return false}}a.lastWheel=new Date().getTime();var c=0;if(!b){b=window.event}if(b.wheelDelta){c=b.wheelDelta/120;if(window.opera){c=-c}}else{if(b.detail){c=-b.detail/3}}if(c){a.handleWheelEvent(b,c)}}}(this);this.addRemoveCanvasListeners=function(a){this[a](this.canvas,"contextmenu",this.contextmenuCanvas,false);this[a](this.canvas,"mousedown",this.mousedownCanvas,false);this[a](this.canvas,"touchstart",this.mousedownCanvas,false);this[a](this.canvas,"click",this.clickCanvas,false);this[a](this.canvas,"dblclick",this.dblclickCanvas,false);this[a](this.canvas,"mousewheel",this.wheelCanvas,false)};this.isVersion=function(b){if(this.showVersion){var a=this.adjustedCoordinates(b);return a&&a.x>0&&a.x<=10&&a.y>0&&a.y<=10?true:false}};this.isHelp=function(b){var a=this.adjustedCoordinates(b);return a&&a.x>0&&a.x<=10&&a.y>0&&a.y<=10?true:false};this.handleWheelEvent=function(F,H,k){var j=this.getTargetEvent(F);if(/CanvasXpress/.test(j.className)){CanvasXpress.current=j.id}if(this.graphType=="Correlation"){this.cancelEvent(F);var E=this.varIndices;var B=this.smpIndices;var q=this.correlationAxis=="variables"?E:B;this.setOriginalIndices(0,this.varIndices,this.smpIndices);if(!k){k=this.adjustedCoordinates(F)}if(k){if(F.type=="keydown"){k.x=this.width/2;k.y=this.height/2}k.x-=(this.marginLeft+this.left);k.y-=(this.marginTop+this.top);var g=Math.min(Math.max(k.x,0),this.x)/this.x;var r=Math.ceil(q.length/10)*2;var p=Math.round(g*r);var l=r-p;var I=false;if(H>0){if(this.correlationAxis=="variables"&&E.length>3){if(this.varIndicesStart<0){this.varIndicesStart++}for(var z=0;z<p;z++){this.varIndices.shift();this.varIndicesStart++}for(var z=0;z<l;z++){this.varIndices.pop()}I=true}if(this.correlationAxis=="samples"&&B.length>3){if(this.smpIndicesStart<0){this.smpIndicesStart++}for(var z=0;z<p;z++){this.smpIndices.shift();this.smpIndicesStart++}for(var z=0;z<l;z++){this.smpIndices.pop()}I=true}}else{if(this.correlationAxis=="variables"){for(var z=0;z<p;z++){if(this.varIndicesStart>=0&&this.varIndicesStart+E.length<this.startingVarIndices[0].length){this.varIndices.push(this.startingVarIndices[0][this.varIndicesStart+E.length]);I=true}else{if(this.varIndicesStart>0){this.varIndicesStart--;this.varIndices.unshift(this.startingVarIndices[0][this.varIndicesStart]);I=true}}}for(var z=0;z<l;z++){if(this.varIndicesStart>0){this.varIndicesStart--;this.varIndices.unshift(this.startingVarIndices[0][this.varIndicesStart]);I=true}else{if(this.varIndicesStart>=0&&this.varIndicesStart+E.length<this.startingVarIndices[0].length){this.varIndices.push(this.startingVarIndices[0][this.varIndicesStart+E.length]);I=true}}}}if(this.correlationAxis=="samples"){for(var z=0;z<p;z++){if(this.smpIndicesStart>=0&&this.smpIndicesStart+B.length<this.startingSmpIndices[0].length){this.smpIndices.push(this.startingSmpIndices[0][this.smpIndicesStart+B.length]);I=true}else{if(this.smpIndicesStart>0){this.smpIndicesStart--;this.smpIndices.unshift(this.startingSmpIndices[0][this.smpIndicesStart]);I=true}}}for(var z=0;z<l;z++){if(this.smpIndicesStart>0){this.smpIndicesStart--;this.smpIndices.unshift(this.startingSmpIndices[0][this.smpIndicesStart]);I=true}else{if(this.smpIndicesStart>=0&&this.smpIndicesStart+B.length<this.startingSmpIndices[0].length){this.smpIndices.push(this.startingSmpIndices[0][this.smpIndicesStart+B.length]);I=true}}}}}if(I){this.draw()}}}else{if(this.graphType=="Network"){this.cancelEvent(F);if(!k){k=this.adjustedCoordinates(F)}if(k){if(F.type=="keydown"){k.x=this.width/2;k.y=this.height/2}var b=this.scaleFactor*this.zoomStep;var o=(this.widthBounds/2)-(k.x/this.scaleFactor);var n=(this.heightBounds/2)-(k.y/this.scaleFactor);this.scaleFactor=H>0?this.scaleFactor+b:this.scaleFactor-b;this.widthBounds=this.x/this.scaleFactor;this.heightBounds=this.y/this.scaleFactor;var M=(this.widthBounds/2)-(k.x/this.scaleFactor);var x=(this.heightBounds/2)-(k.y/this.scaleFactor);this.panningX=o-M;this.panningY=n-x;if(!this.networkFreeze){b=this.zoom*this.zoomStep;this.zoom=H>0?this.zoom+b:this.zoom-b}this.draw(false,false,false,true);this.panningGlobalX+=this.panningX;this.panningGlobalY+=this.panningY}}else{if(this.graphType=="Genome"){this.cancelEvent(F);if(this.xAxisUnit>100&&H>0){return}if(!k){k=this.adjustedCoordinates(F)}if(k){var f=(k.x-(this.marginLeft+this.left))/this.x;var K=1-f;var h=this.xAxisRange*this.zoomStep;if(H>0){this.setMinX=this.setMinX!=null?this.setMinX+(h*f):this.xAxisMin+(h*f);this.setMaxX=this.setMaxX!=null?this.setMaxX-(h*K):this.xAxisMax-(h*K)}else{this.setMinX=this.setMinX!=null?this.setMinX-(h*f):this.xAxisMin-(h*f);this.setMaxX=this.setMaxX!=null?this.setMaxX+(h*K):this.xAxisMax+(h*K)}this.draw()}}else{if(this.graphType=="Heatmap"){this.cancelEvent(F);this.resetAxesResizer(F);var J=this.layoutComb?this.layoutValidN:0;var B;var E=this.layoutComb?this.layoutParams[J].varIndices:this.varIndices;var A=this.isGroupedData?this.grpIndices:this.smpIndices;if(this.isGroupedData){B=this.layoutComb?this.layoutParams[J].grpIndices:this.grpIndices}else{B=this.layoutComb?this.layoutParams[J].smpIndices:this.smpIndices}this.setOriginalIndices(J,E,B);if(!k){k=this.adjustedCoordinates(F)}if(k){if(F.type=="keydown"){k.x=this.width/2;k.y=this.height/2}k.x-=(this.marginLeft+this.left);k.y-=(this.marginTop+this.top);var G=Math.min(Math.max(k.x,0),this.x)/this.x;var N=Math.ceil(E.length/10)*2;var s=Math.round(G*N);var w=N-s;var L=Math.min(Math.max(k.y,0),this.y)/this.y;var a=Math.ceil(B.length/10)*2;var v=Math.round(L*a);var y=a-v;var I=false;if(H>0){if(!this.zoomVariablesDisable&&E.length>3){if(this.varIndicesStart<0){this.varIndicesStart++}for(var z=0;z<s;z++){this.varIndices.shift();this.varIndicesStart++}for(var z=0;z<w;z++){this.varIndices.pop()}I=true}if(!this.zoomSamplesDisable&&B.length>3){if(this.smpIndicesStart<0){this.smpIndicesStart++}for(var z=0;z<v;z++){this.smpIndices.shift();this.smpIndicesStart++}for(var z=0;z<y;z++){this.smpIndices.pop()}I=true}}else{if(!this.zoomVariablesDisable){for(var z=0;z<s;z++){if(this.varIndicesStart>=0&&this.varIndicesStart+E.length<this.startingVarIndices[J].length){this.varIndices.push(this.startingVarIndices[J][this.varIndicesStart+E.length]);I=true}else{if(this.varIndicesStart>0){this.varIndicesStart--;this.varIndices.unshift(this.startingVarIndices[J][this.varIndicesStart]);I=true}}}for(var z=0;z<w;z++){if(this.varIndicesStart>0){this.varIndicesStart--;this.varIndices.unshift(this.startingVarIndices[J][this.varIndicesStart]);I=true}else{if(this.varIndicesStart>=0&&this.varIndicesStart+E.length<this.startingVarIndices[J].length){this.varIndices.push(this.startingVarIndices[J][this.varIndicesStart+E.length]);I=true}}}}if(!this.zoomSamplesDisable){for(var z=0;z<v;z++){if(this.smpIndicesStart>=0&&this.smpIndicesStart+B.length<this.startingSmpIndices[J].length){this.smpIndices.push(this.startingSmpIndices[J][this.smpIndicesStart+B.length]);I=true}else{if(this.smpIndicesStart>0){this.smpIndicesStart--;this.smpIndices.unshift(this.startingSmpIndices[J][this.smpIndicesStart]);I=true}}}for(var z=0;z<y;z++){if(this.smpIndicesStart>0){this.smpIndicesStart--;this.smpIndices.unshift(this.startingSmpIndices[J][this.smpIndicesStart]);I=true}else{if(this.smpIndicesStart>=0&&this.smpIndicesStart+B.length<this.startingSmpIndices[J].length){this.smpIndices.push(this.startingSmpIndices[J][this.smpIndicesStart+B.length]);I=true}}}}}if(I){this.draw()}}}else{if(this.graphType.match(/Bar|Line|Dotplot|Boxplot|Area|Stacked/)&&!this.is3DPlot){this.cancelEvent(F);this.resetAxesResizer(F);var J=this.layoutComb?this.layoutValidN:0;var B;var E=this.layoutComb?this.layoutParams[J].varIndices:this.varIndices;var A=this.isGroupedData?this.grpIndices:this.smpIndices;if(this.isGroupedData){B=this.layoutComb?this.layoutParams[J].grpIndices:this.grpIndices}else{B=this.layoutComb?this.layoutParams[J].smpIndices:this.smpIndices}this.setOriginalIndices(J,E,B);if(!k){k=this.adjustedCoordinates(F)}if(k){if(F.type=="keydown"){k.x=this.width/2;k.y=this.height/2}k.x-=(this.marginLeft+this.left);k.y-=(this.marginTop+this.top);var g=this.graphOrientation=="vertical"?Math.min(Math.max(k.x,0),this.x)/this.x:Math.min(Math.max(k.y,0),this.y)/this.y;var r=Math.ceil(B.length/10)*2;var p=Math.round(g*r);var l=r-p;var m=[];if(H>0){if(B.length>3){if(this.smpIndicesStart<0){this.smpIndicesStart++}this.smpIndicesStart+=p;for(var z=p;z<B.length-l;z++){m.push(B[z])}this.setSamplesVisible(m,true);this.draw()}}else{if(this.startingSmpIndices[J].length>B.length){m=B;for(var z=0;z<l;z++){if(this.startingSmpIndices[J].length>this.smpIndicesStart+B.length){m.push(this.startingSmpIndices[J][this.smpIndicesStart+B.length])}else{if(this.smpIndicesStart>0){this.smpIndicesStart--;m.unshift(this.startingSmpIndices[J][this.smpIndicesStart])}}}for(var z=0;z<p;z++){if(this.smpIndicesStart>0){this.smpIndicesStart--;m.unshift(this.startingSmpIndices[J][this.smpIndicesStart])}else{if(this.startingSmpIndices[J].length>this.smpIndicesStart+B.length){m.push(this.startingSmpIndices[J][this.smpIndicesStart+B.length])}}}this.setSamplesVisible(m,true);this.draw()}}}}else{if(this.graphType=="Scatter3D"||this.is3DPlot){this.cancelEvent(F);if(!k){k=this.adjustedCoordinates(F)}if(k){k.x-=(this.marginLeft+this.left);k.y-=(this.marginTop+this.top);var D=(Math.min(Math.max(k.x,0),this.x)/this.x)-0.5;var C=(Math.min(Math.max(k.y,0),this.y)/this.y)-0.5}if(H>0){if(this.zoom>=4){return}this.zoom*=1.1;this.padX-=D*this.padX/4;this.padY-=C*this.padY/4}else{if(this.zoom<=0.5){return}this.zoom*=0.9;this.padX+=D*this.padX/4;this.padY+=C*this.padY/4}this.draw()}else{if(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D"){this.cancelEvent(F);return;if(!k){k=this.adjustedCoordinates(F)}if(k){k.x-=(this.marginLeft+this.left);k.y-=(this.marginTop+this.top);var D=Math.min(Math.max(k.x,0),this.x)/this.x;var C=Math.min(Math.max(k.y,0),this.y)/this.y;var u=this.xAxisMin+(D*this.xAxisRange);var t=this.yAxisMax-(C*this.yAxisRange)}}}}}}}}return false};this.setLayoutValidIndices=function(k){if(this.layoutComb){this.layoutValidR=0;this.layoutValidC=0;this.layoutValidN=0;var h=this.adjustedCoordinates(k);if(h){var a=h.x;var g=h.y;var m=0;for(var f=0;f<this.layoutRows;f++){for(var d=0;d<this.layoutCols;d++){if(this.layoutParams[m]){var b=this.getBoundsXY(m);if(a>=b[0]&&a<=b[1]&&g>=b[2]&&g<=b[3]){if(this.layoutValid){this.layoutValidR=f;this.layoutValidC=d;this.layoutValidN=m}}m++}}}}}};this.getNetworkEventDataId=function(c){var a=this.isEvent(c,true);var d=a[0];var b=a[1];if(d){return b&&b.match(/-legend-/)?false:d}else{return false}};this.getEventDataId=function(a){return this.graphType=="Network"?this.getNetworkEventDataId(a):this.isEvent(a)};this.getEventAreaData=function(a){return this.extractDataObject(this.getEventDataId(a))};this.handleMouseEvents=function(b,c,a){if(a[0]==-1){this.showInfoSpan(c,"CanvasXpress ("+this.version+")")}else{if(this.layoutComb&&(!this.layoutValidN||this.isDOE)){this.setLayoutValidIndices(c)}var d;if(a){d=this.extractDataObject(a)}if(this.isDOE&&a&&b=="click"){if(d.y.pie){this.dataStndBy.l.doe=d.y.pie}else{if(d.y.histogram){this.dataStndBy.l.doe=d.y.histogram[0]}}this.draw();return false}if(this.userEvents[b]){if(typeof(this.userEvents[b])=="object"&&this.userEvents[b].handler&&this.userEvents[b].scope){if(c.ctrlKey&&b=="click"){if(c.altKey&&b=="click"){alert(this.prettyJSON(d))}else{if(c.shiftKey&&b=="click"){this.addRemoveToSelectedDataPoints(this.getEventDataId(c));this.handleUserSelectEvent();this.draw()}else{this.addRemoveToSelectedDataPoints(this.getEventDataId(c));this.handleUserSelectEvent();this.draw()}}}else{if(c.shiftKey&&b=="click"&&this.graphType=="Network"&&this.networkLayoutType=="radial"){this.reRootRadialNetwork(this.getEventDataId(c))}else{if(c.shiftKey&&b=="click"){}else{if(c.altKey&&b=="click"){}else{if(b=="click"){if(a!=null&&this.isSelectDataPoints&&!this.isHistogram&&this.selectDataPoint.hasOwnProperty(a[0])){}else{if(a!=null&&this.isSelectDataPoints&&this.isHistogram&&this.selectDataPoint.hasOwnProperty(this.data.y.histogram[a[0]][0])){}else{this.resetSelectedObjects()}}this.addRemoveToSelectedDataPoints(this.getEventDataId(c))}this.userEvents[b].handler.apply(this.userEvents[b].scope,[d,c,this,a])}}}}}else{if(typeof(this.userEvents[b])=="object"&&this.userEvents[b].handler){if(c.ctrlKey&&b=="click"){if(c.altKey&&b=="click"){alert(this.prettyJSON(d))}else{if(c.shiftKey&&b=="click"){this.addRemoveToSelectedDataPoints(this.getEventDataId(c));this.handleUserSelectEvent();this.draw()}else{this.addRemoveToSelectedDataPoints(this.getEventDataId(c));this.handleUserSelectEvent();this.draw()}}}else{if(c.shiftKey&&b=="click"&&this.graphType=="Network"&&this.networkLayoutType=="radial"){this.reRootRadialNetwork(this.getEventDataId(c))}else{if(c.shiftKey&&b=="click"){}else{if(c.altKey&&b=="click"){}else{if(b=="click"){if(a!=null&&this.isSelectDataPoints&&!this.isHistogram&&this.selectDataPoint.hasOwnProperty(a[0])){}else{if(a!=null&&this.isSelectDataPoints&&this.isHistogram&&this.selectDataPoint.hasOwnProperty(this.data.y.histogram[a[0]][0])){}else{this.resetSelectedObjects()}}this.addRemoveToSelectedDataPoints(this.getEventDataId(c))}this.userEvents[b].handler(d,c,this,a)}}}}}else{if(c.ctrlKey&&b=="click"){if(c.altKey&&b=="click"){alert(this.prettyJSON(d))}else{if(c.shiftKey&&b=="click"){this.addRemoveToSelectedDataPoints(this.getEventDataId(c));this.handleUserSelectEvent();this.draw()}else{this.addRemoveToSelectedDataPoints(this.getEventDataId(c));this.handleUserSelectEvent();this.draw()}}}else{if(c.shiftKey&&b=="click"&&this.graphType=="Network"&&this.networkLayoutType=="radial"){this.reRootRadialNetwork(this.getEventDataId(c))}else{if(c.shiftKey&&b=="click"){}else{if(c.altKey&&b=="click"){}else{if(b=="click"){if(a!=null&&this.isSelectDataPoints&&!this.isHistogram&&this.selectDataPoint.hasOwnProperty(a[0])){}else{if(a!=null&&this.isSelectDataPoints&&this.isHistogram&&this.selectDataPoint.hasOwnProperty(this.data.y.histogram[a[0]][0])){}else{this.resetSelectedObjects()}}this.addRemoveToSelectedDataPoints(this.getEventDataId(c))}this.userEvents[b](d,c,this,a)}}}}}}}}};this.formatCoords=function(j,k){var f=[];if(this.graphType!="Network"){for(var e=0;e<k.length;e++){if(e%2){f.push(sprintf("%.0f",(k[e]+this.translateY)*this.scaleY))}else{if(this.layoutValid&&j=="circle"&&e==2){f.push(sprintf("%.0f",k[e]*((this.scaleX+this.scaleY)/2)))}else{f.push(sprintf("%.0f",(k[e]+this.translateX)*this.scaleX))}}}}else{for(var e=0;e<k.length;e++){f.push(sprintf("%.0f",parseInt(k[e])))}}if(j=="rect"){var b=Math.min(f[0],f[2]);var d=Math.min(f[1],f[3]);var a=Math.max(f[0],f[2]);var g=Math.max(f[1],f[3]);f=[b,d,a,g]}return f.join(",")};this.addArea=function(e,a,d){if(!e||!a){return}var b=e.shift();if(b&&e){switch(b){case"rect":e[0]-=this.outlineWidth;e[1]-=this.outlineWidth;e[2]+=(this.outlineWidth*2);e[3]+=(this.outlineWidth*2);break;case"circle":e[2]+=(this.outlineWidth*2);break;case"poly":break}this.dataEvent.push([a,b,e,d])}};this.addAreaNetwork=function(d,a,b){if(this.preScaleNetwork&&!this.isAnimation){this.addArea(d,a,b)}else{this.addArea(this.adjustNetworkObjects(d),a,b)}};this.adjustNetworkObjects=function(b){if(b){if(b[0]=="circle"){b[1]=(this.offsetX+b[1])*this.scaleFactor;b[2]=(this.offsetY+b[2])*this.scaleFactor;b[3]=b[3]*this.scaleFactor}else{for(var a=1;a<b.length;a++){if(a%2){b[a]=(this.offsetX+b[a])*this.scaleFactor}else{b[a]=(this.offsetY+b[a])*this.scaleFactor}}}}else{return false}return b};this.flash=function(b,p,m,f,k,a){var j=this.$cX("div",{id:this.target+"canvasXpressFlash"+new Date().getTime()},{left:(b-(m/2))+"px",top:(p-(f/2))+"px",width:m+"px",height:f+"px",borderRadius:"999px",WebkitBorderRadius:"999px",MozBorderRadius:"999px",opacity:0.6,filter:"alpha(opacity = 60)",position:"absolute",zIndex:100000,display:"block",backgroundColor:k?k:this.resizerBackgroundColor});this.canvas.parentNode.appendChild(j);if(!a){a=3}var g=this;var e=1;var o=function(){this.update=function(){if(e%2){j.style.display="none"}else{j.style.display="block"}if(e>=(a*2)){g.canvas.parentNode.removeChild(j);clearInterval(c)}e++};var c=setInterval(this.update,300)};o.call()};this.initializeCanvasEvents=function(){if(!this.disableEvents){this.addRemoveCanvasListeners("addEvtListener")}};this.initializeCanvasEvents()};CanvasXpress.prototype.initCleanupEvents=function(){this.destroy=function(a){if(a){if(CanvasXpress.references.length==1&&CanvasXpress.references[0].target==a){return this.destroy()}else{this.removeReference(a)}}else{while(CanvasXpress.references.length>0){a=CanvasXpress.references[0];this.removeReference(a.target)}CanvasXpress.cacheImages={};CanvasXpress.cacheText={};CanvasXpress.stack={};CanvasXpress.current=false}};this.monitorReference=function(){var b=[];for(var a=0;a<CanvasXpress.references.length;a++){var d=this.$(CanvasXpress.references[a].target);if(!d){b.push(CanvasXpress.references[a].target)}}for(var a=0;a<b.length;a++){this.destroy(b[a])}};this.removeReference=function(e,b){var d=CanvasXpress.references;CanvasXpress.references=[];for(var c=0;c<d.length;c++){if(d[c].target!=e){CanvasXpress.references.push(d[c])}else{var f=d[c];f.resetTooltipDivs();f.cleanEvtListeners(b);f.removeTarget("container-"+f.target);f.removeTarget(f.target+"-cX-Info")}}};this.cleanEvtListeners=function(b){this.addRemoveLinkListeners("removeEvtListener");this.addRemoveViewportListeners("removeEvtListener");this.addRemoveToolbarListeners("removeEvtListener");this.addRemoveCodeListeners("removeEvtListener");this.addRemoveItemListeners("removeEvtListener");this.addRemoveConfiguratorListeners("removeEvtListener");this.addRemoveDataTableListeners("removeEvtListener");this.removeGenericDataFilterListenersOrReset();this.addRemoveDataFilterListeners("removeEvtListener");this.addRemoveCanvasListeners("removeEvtListener");this.addRemoveAxesResizerListeners("removeEvtListener");this.addRemoveNavigationTopListeners("removeEvtListener");this.addRemoveNavigationLeftRightListeners("removeEvtListener");this.removeEvtListener(document,"mousemove",this.mousemoveDoc,false);this.removeEvtListener(document,"touchmove",this.mousemoveDoc,false);this.removeEvtListener(document,"mouseup",this.mouseupDoc,false);this.removeEvtListener(document,"touchend",this.mouseupDoc,false);this.removeEvtListener(document,"keydown",this.keydownDoc,false);this.removeEvtListener(document,"keyup",this.keyupDoc,false);this.removeEvtListener(window,"resize",this.resizeWindow,false)};this.initializeCleanupEvents=function(){if(this.destroyCanvasXpressZombies){var b=this;var a=function(){this.monitor=function(){if(CanvasXpress.references.length<1){clearInterval(c)}b.monitorReference()};var c=setInterval(this.monitor,b.monitorCanvasXpressZombiesTime)};a.call()}};this.initializeCleanupEvents()};CanvasXpress.prototype.initEvents=function(){this.regularCoordinates=function(i,g){var k={};if(i.pageX==null&&g.clientX!=null){var h=i.target.ownerDocument||document;var j=h.documentElement;var a=h.body;k.x=g.clientX+(j&&j.scrollLeft||a&&a.scrollLeft||0)-(j&&j.clientLeft||a&&a.clientLeft||0);k.y=g.clientY+(j&&j.scrollTop||a&&a.scrollTop||0)-(j&&j.clientTop||a&&a.clientTop||0)}else{k.x=i.pageX;k.y=i.pageY}return k};this.relativeCoordinates=function(a){var b={x:0,y:0};while(a&&!isNaN(a.offsetLeft)&&!isNaN(a.offsetTop)){b.x+=a.offsetLeft;b.y+=a.offsetTop;a=a.offsetParent}return b};this.absoluteCoordinates=function(a){var b={x:0,y:0};while(a&&!isNaN(a.offsetLeft)&&!isNaN(a.offsetTop)){b.x+=a.offsetLeft-a.scrollLeft;b.y+=a.offsetTop-a.scrollTop;a=a.offsetParent}return b};this.adjustedCoordinates=function(g,b){if(!g){g=window.event}if(!b){b=this.$(this.target)}if(b){var h={};var a=b.parentNode.getClientRects();var d=g&&g.changedTouches?g.changedTouches[0]:false;if(a&&a[0]){var f=a[0].left;var k=a[0].top;var j=g&&g.clientX?g.clientX:d?d.clientX:g&&g[0]?g[0]:f;var i=g&&g.clientY?g.clientY:d?d.clientY:g&&g[1]?g[1]:k;h.x=document.body.scrollLeft>Math.abs(f)+j&&j>document.body.scrollLeft-f?Math.abs(f)+j:j-f;h.y=document.body.scrollTop>Math.abs(k)+i&&i>document.body.scrollTop-k?Math.abs(k)+i:(i-k)}else{h.x=0;h.y=0}return h}};this.isObjectInsideArea=function(b,g,d,l,c,j){var k,h;switch(b){case"rect":k=(g[0]+g[2])/2;h=(g[1]+g[3])/2;break;case"circle":k=g[0];h=g[1];break;case"poly":var e=[];var a=[];for(var f=0;f<g.length;f++){if(f%2){a.push(g[f])}else{e.push(g[f])}}e.sort(function(m,i){return(m-i)});a.sort(function(m,i){return(m-i)});k=(e[0]+e[e.length-1])/2;h=(a[0]+a[a.length-1])/2;break}return this.isPointInsideArea("rect",k,h,[d,l,c,j])};this.isPointInsideArea=function(n,m,l,k){switch(n){case"rect":if(k[0]>k[2]){k[4]=k[0];k[0]=k[2];k[2]=k[4]}if(k[1]>k[3]){k[4]=k[1];k[1]=k[3];k[3]=k[4]}if(m>=k[0]&&m<=k[2]&&l>=k[1]&&l<=k[3]){return true}else{return false}case"circle":var f=k[2]/2;if(m>=k[0]-f&&m<=k[0]+f&&l>=k[1]-f&&l<=k[1]+f){return true}else{return false}case"poly":var d=[];var a=[];var g=false;for(var e=0;e<k.length;e++){if(e%2){a.push(k[e])}else{d.push(k[e])}}if(a[0]<a[1]){a=a.reverse();d=d.reverse()}for(var e=0,b=d.length-1;e<d.length;b=e++){if(((a[e]<=l&&l<a[b])||(a[b]<=l&&l<a[e]))&&(m<(d[b]-d[e])*(l-a[e])/(a[b]-a[e])+d[e])){g=!g}}return g}};this.isEvent=function(o,h,j){var u=this.adjustedCoordinates(o);if(u){var d=this.getTargetEvent(o);if(d&&d.id&&d.id.match(this.target)){var t=u.x;var q=u.y;var r=this.dataEvent;var b=[];for(var k=r.length-1;k>=0;k--){var g=r[k][0];var v=r[k][1];var p=r[k][2];var l=r[k][3];if(this.isPointInsideArea(v,t,q,p)){if(l){l=g[0]+l}if(j){if(l){b.push(l)}else{b.push(g[0])}}else{return h?[g,l]:l?[l]:g}}}if(b.length>0){return b}}}return false};this.getBoundsXY=function(e){var d=this.layoutComb?this.layoutParams[e]:this;var a=this.graphType=="Network"?0:this.marginLeft+d.offsetX;var b=this.graphType=="Network"?0:this.marginTop+d.offsetY;return[a+d.left,a+d.left+d.x,b+d.top,b+d.top+d.y,a,a+d.left+d.x+d.right,b,b+d.top+d.y+d.bottom]};this.getUngroupedDataObject=function(a){if(this.isGroupedData){this.isGroupedData=false;a=this.extractDataObject(a.w.grps[0],this.getVariableIndices(a.w.vars));this.isGroupedData=true}return a};this.extractDataObject=function(h,b){var l=this;var I=this.layoutComb&&this.layoutValidN>-1?this.layoutParams[this.layoutValidN].graphType:this.graphType;var O=[];var M=[];var L=[];var z=function(d){var k={};for(var j in l.data.x){k[j]=[];for(var g=0;g<d.length;g++){k[j].push(l.data.x[j][d[g]])}}return k};var y=function(d){var k={};for(var j in l.data.z){k[j]=[];for(var g=0;g<d.length;g++){k[j].push(l.data.z[j][d[g]])}}return k};var J=function(d){var j=[];if(l.isDOE){j.push(l.layoutParams[l.layoutValidN].data.y.vars[d[0]])}else{for(var g=0;g<d.length;g++){j.push(l.data.y.vars[d[g]])}}return j};var m=function(j,n){var d=n?l.data.w.smps:l.data.y.smps;var p=[];if(l.isDOE){p.push(l.layoutParams[l.layoutValidN].data.y.smps[j[0]])}else{for(var k=0;k<j.length;k++){p.push(d[j[k]])}}return p};var f=function(d){var j=[];for(var g=0;g<d.length;g++){j.push(l.data.w.grps[d[g]])}return j};var e=function(g,d,s){var p=[];if(l.isDOE){p[0]=[];p[0].push(l.layoutParams[l.layoutValidN].data.y.data[g[0]][d[0]])}else{if(!s){s="data"}if(d){for(var n=0;n<g.length;n++){p[n]=[];for(var k=0;k<d.length;k++){p[n].push(l.data.y[s][g[n]][d[k]])}}}else{for(var n=0;n<g.length;n++){p.push(l.data.y[s][g[n]])}}}return p};switch(I){case"Area":case"AreaLine":case"Bar":case"Line":case"BarLine":case"Boxplot":case"Dotplot":case"DotLine":case"Heatmap":case"Pie":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Scatter2D":case"ScatterBubble2D":case"Scatter3D":case"Candlestick":case"Circular":case"Treemap":case"TagCloud":if(!h||h.length==0||h[0]==null){return}else{if(isNaN(h[0])){if(h[0]&&h[0].match(/Dendrogram/)){var B={t:{}};var A=h[0].split("-");B.t.d=parseInt(A[1]);B.t.o=parseInt(A[2]);B.t.t=A[3];B.objectType="Dendrogram";return B}else{if(h[0]&&h[0].match(/Var/)){var A=h[0].split("-");var H=parseInt(A[1]);var N=[H];N=N.concat(this.smpIndices);var B=this.extractDataObject(N);if(h[0].match(/VarOvr/)){B.display=this.data.y.vars[H]+" : "+this.varOverlays[A[2]]+" : "+this.data.z[this.varOverlays[A[2]]][H]}else{B.display=this.data.y.vars[H]}B.objectType="Var";return B}else{if(h[0]&&h[0].match(/Smp/)){var A=h[0].split("-");var H=parseInt(A[1]);var B=this.extractDataObject([H],this.varIndices);if(h[0].match(/SmpOvr/)){B.display=this.isGroupedData?this.data.w.smps[H]+" : "+this.smpOverlays[A[2]]+" : "+this.data.w.factors[this.smpOverlays[A[2]]][H]:this.data.y.smps[H]+" : "+this.smpOverlays[A[2]]+" : "+this.data.x[this.smpOverlays[A[2]]][H]}else{B.display=this.isGroupedData?this.data.w.smps[H]:this.data.y.smps[H]}B.objectType="Smp";return B}else{if(h[0]&&h[0].match(/Cat/)){var B={};var A=h[0].split("-");B.display=A[1];B.objectType="Cat";return B}else{if(h[0]&&h[0].match(/Onc/)){var B={};var A=h[0].split("-");B.display=A[1];B.objectType="Onc";return B}else{return}}}}}}else{if(I=="Pie"&&h.length>2){M=[h[0]];for(var H=1;H<h.length;H++){O.push(h[H])}}else{if(b){O=b;M=h}else{O=[h[0]];M=[];for(var H=1;H<h.length;H++){M.push(h[H])}}}if(I.match(/Scatter/)){if(this.colorBy&&this.getSampleIndices(this.colorBy)>-1){M.push(this.getSampleIndices(this.colorBy))}if(this.shapeBy&&this.getSampleIndices(this.shapeBy)>-1){M.push(this.getSampleIndices(this.shapeBy))}if(this.sizeBy&&this.getSampleIndices(this.sizeBy)>-1){M.push(this.getSampleIndices(this.sizeBy))}}}}if(I.match(/Area/)){return{x:this.data.x,y:{vars:J(O),smps:this.data.y.smps,data:e(O)},z:y(O)}}else{if(this.isGroupedData){var B={x:{},w:{},z:y(O)};if(I.match(/Boxplot|Dotplot|DotLine/)&&M[1]!=null){B.y={data:this.data.y.data[O[0]][M[1]],vars:this.data.y.vars[O[0]],smps:this.data.y.smps[M[1]]};M.pop()}for(var A in this.data.w){if(A=="smps"){B.w[A]=m(M,true)}else{if(A=="grps"){B.w[A]=f(M)}else{if(A=="vars"){B.w[A]=J(O)}else{if(this.data.w[A].length>O[0]&&this.data.w[A][O[0]].length>M[0]){B.w[A]=[];B.w[A].push(this.data.w[A][O[0]][M[0]])}}}}}for(var A in this.data.x){var q=[];for(var H=0;H<B.w.grps[0].length;H++){q.push(this.data.x[A][B.w.grps[0][H]])}B.x[A]=q}}else{var B={x:z(M),y:{vars:J(O),smps:m(M)},z:y(O)};if(this.isHistogram&&!this.isDOE){B.y.histogram=this.data.y.histogram[O]}if(this.isDOE){if(this.layoutParams[this.layoutValidN].data.y.pie){B.y.pie=this.layoutParams[this.layoutValidN].data.y.pie[O]}else{if(this.layoutParams[this.layoutValidN].data.y.histogram){B.y.histogram=this.layoutParams[this.layoutValidN].data.y.histogram[O]}}}if(I=="Candlestick"){for(var A in this.data.y){if(A&&A!="vars"&&A!="smps"&&A!="desc"){B.y[A]=[];for(var H=0;H<O.length;H++){B.y[A][H]=[];for(var G=0;G<M.length;G++){B.y[A][H].push(this.data.y[A][O[H]][M[G]])}}}}}else{B.y.data=e(O,M);if(this.isMultidimensionalData){var D=["outline","shape","size"];for(var H=0;H<D.length;H++){var E=D[H]+"ByData";if(this.data.y[this[E]]){B.y[this[E]]=e(O,M,this[E])}}}}}}return B;case"Correlation":if(!h||(isNaN(h[0])&&!h[0].match(/^\d/))){return}else{var K=this.isGroupedData?this.data.w.cor:this.data.y.cor}if(this.correlationAxis=="samples"){var B={x:{},y:{}};for(var A in this.data.x){var q=[];for(var H=0;H<h.length;H++){q.push(this.data.x[A][h[H]])}B.x[A]=q}B.y.smps=[this.data.y.smps[h[0]],this.data.y.smps[h[1]]]}else{var B={y:{},z:{}};for(var A in this.data.y){var c=[];for(var H=0;H<h.length;H++){c.push(this.data.y[A][h[H]])}B.z[A]=c}B.y.vars=[this.data.y.vars[h[0]],this.data.y.vars[h[1]]]}B.y.data=K[h[0]][h[1]];return B;case"Venn":var B={venn:{data:{}}};B.venn.data[this.vennCompartments[h[0]]]=this.data.venn.data[this.vennCompartments[h[0]]];return B;case"Network":var B={};if(!h||h.length==0){return}if(isNaN(h[0])){h[0]=h[0].toString();if(h[0].match(/legend/)){if(h[0].match(/Nodes/)){B={nodeLegend:this.data.legend.nodes}}else{if(h[0].match(/Edges/)){B={edgeLegend:this.data.legend.edges}}else{if(h[0].match(/Decorations/)){B={decorationLegend:this.data.legend.decorations}}else{var u=parseInt(h[0].replace("-1-legend-Text",""));B={textLegend:this.data.legend.text[u]}}}}}else{if(h[0].match(/-dec/)){var H=h[0].split("-");var C=this.data.nodes[H[0]];var K=this.decorations[H[1]];var r=C[K]?C[K]:C.decorations&&C.decorations[K]?C.decorations[K]:false;var F=H[3]?H[2]:false;if(F){if(r){if(r[F]!=null){B.display=K+" : "+F+" : "+r[F]}else{B.display=K+" : "+F+" : NA"}}else{B.display=K+" : NA"}}else{B.display=K+" : "+r}}}}else{for(var H=0;H<h.length;H++){if(h[H]>=this.data.nodes.length){if(!B.edges){B.edges=[]}B.edges.push(this.data.edges[h[H]-this.data.nodes.length])}else{if(!B.nodes){B.nodes=[]}B.nodes.push(this.data.nodes[h[H]])}}}return B;case"Genome":var I;var B=[];B[0]={data:[]};var u=0;var w=isNaN(h[0])&&h[0].match(":")?h[0].match(/:(\d+)/)[1]:false;for(var H=0;H<this.data.tracks.length;H++){var C=this.data.tracks[H].data.length;u+=C;if(isNaN(h[0])){if(h[0]=="track-"+H){return{name:this.data.tracks[H].name}}else{if(h[0]=="track-"+H+":"+w){var x=parseInt(w)-(u-C);for(var A in this.data.tracks[H]){if(A=="data"){B[0][A].push(this.data.tracks[H][A][x])}else{B[0][A]=this.data.tracks[H][A]}}return B}}continue}if(h[h.length-1]<u){for(var G=0;G<h.length;G++){var x=h[G]-(u-C);for(var A in this.data.tracks[H]){if(A=="data"){B[0][A].push(this.data.tracks[H][A][x])}else{B[0][A]=this.data.tracks[H][A]}}}return B}}}};this.getSummaryDataObject=function(b){if(b){switch(this.graphType){case"Bar":case"Line":case"Area":case"AreaLine":case"BarLine":case"Boxplot":case"Dotplot":case"DotLine":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Scatter2D":case"ScatterBubble2D":case"Scatter3D":case"Circular":case"Treemap":case"TagCloud":var i="";if(b.display){return"<b>"+b.display+"</b><br>"}else{if(this.isGroupedData&&b.w){i="<b>"+b.w.vars[0]+"</b><br>";if(this.summaryType=="mean"){i+="<b>"+b.w.smps[0]+"</b>: "+this.bestFormatNumber(b.w.mean[0]);if(b.w.stdev&&b.w.stdev[0]!=null){i+=" <i>&plusmn;"+this.bestFormatNumber(b.w.stdev[0])+"</i>"}if(b.w.n&&b.w.n[0]!=null){i+=" ("+b.w.n+")"}i+="<br>"}else{if(this.summaryType=="median"||this.summaryType=="iqr"){i+="<b>"+b.w.smps[0]+"</b>: "+this.bestFormatNumber(b.w.median[0]);if(b.w.stdev&&b.w.stdev[0]!=null){i+=" <i>&plusmn;"+this.bestFormatNumber(b.w.stdev[0])+"</i>"}if(b.w.n&&b.w.n[0]!=null){i+=" ("+b.w.n+")"}i+="<br>"}else{if(this.summaryType=="sum"){i+="<b>"+b.w.smps[0]+"</b>: "+this.bestFormatNumber(b.w.sum[0]);if(b.w.stdev&&b.w.stdev[0]!=null){i+=" <i>&plusmn;"+this.bestFormatNumber(b.w.stdev[0])+"</i>"}if(b.w.n&&b.w.n[0]!=null){i+=" ("+b.w.n+")"}i+="<br>"}}}if(this.graphType.match(/Boxplot|Dotplot|DotLine/)&&b.y&&b.y.smps){i+="<b>"+b.y.smps+"</b>: "+this.bestFormatNumber(b.y.data)+"<br>"}}else{if(b.y){i="<b>"+b.y.vars[0]+"</b><br>";for(var d=0;d<b.y.smps.length;d++){if(this.isMultidimensionalData){var l=[b.y.data[0][d]];var g=["outline","shape","size"];for(var c=0;c<g.length;c++){var m=g[c]+"ByData";if(b.y[this[m]]&&b.y[this[m]][0][d]){l.push(b.y[this[m]][0][d])}}i+="<b>"+b.y.smps[d]+"</b>: "+l.join(", ")+"<br>"}else{i+="<b>"+b.y.smps[d]+"</b>: "+b.y.data[0][d]+"<br>"}}}else{if(b.t){i="<b>"+b.t.t+"</b><br>Depth: "+b.t.d+"<br>"}}}}return i;case"Pie":var n="<b>"+b.y.smps[0]+"</b><br>";for(var d=0;d<b.y.vars.length;d++){var a=sprintf("%."+this.pieSegmentPrecision+"f",(b.y.data[d]/this.varPie.tot)*100);n+="<b>"+b.y.vars[d]+"</b>: "+b.y.data[d]+" ("+a+"%)<br>"}return n;case"Candlestick":return dateFormat(b.y.smps[0],this.timeFormat)+", "+b.y.close[0];case"Correlation":var n;if(this.correlationAxis=="samples"){n=b.y.smps[0]+" vs "+b.y.smps[1]}else{n=b.y.vars[0]+" vs "+b.y.vars[1]}return n;case"Venn":for(var e in b.venn.data){return e+" = "+b.venn.data[e]}case"Network":var n;if(b.display){return"<b>"+b.display+"</b><br>"}else{if(b&&b.nodes){if(b.nodes[0]){n=b.nodes[0].hideTooltip?"":b.nodes[0].tooltip||b.nodes[0].name||b.nodes[0].label||b.nodes[0].id}}else{if(b&&b.edges){var h=this.nodes[b.edges[0].id1];var f=this.nodes[b.edges[0].id2];n=(h.label||h.id)+" - "+(f.label||f.id);n=b.edges[0].hideTooltip?"":b.edges[0].tooltip||b.edges[0].name||b.edges[0].label||n}}}return n;case"Genome":return b.name||b[0].data[0].id}}else{return""}};this.setUserEvents=function(){this.userEvents={};if(this.disableEvents){return}var b=this;if(this.events&&this.events.enddragnode){this.userEvents.enddragnode=this.events.enddragnode}if(this.events&&this.events.stackchange){this.userEvents.stackchange=this.events.stackchange}if(this.events&&this.events.select){this.userEvents.select=this.events.select}if(this.events&&this.events.enddraw){this.userEvents.enddraw=this.events.enddraw}if(this.events&&this.events.remoteupdate){this.userEvents.remoteupdate=this.events.remoteupdate}if(this.events&&this.events.mouseout){this.userEvents.mouseout=this.events.mouseout}else{this.userEvents.mouseout=function(h,g,f,d){f.resetInfoSpan(g)}}if(this.events&&this.events.mouseup){this.userEvents.mouseup=this.events.mouseup}if(this.events&&this.events.contextmenu){this.userEvents.contextmenu=this.events.contextmenu}else{this.userEvents.contextmenu=function(h,g,f,d){if(f.graphType=="Network"){if(h&&h.nodes&&h.nodes.length==1){if(f.selectNode&&!f.selectNode[h.nodes[0].id]){f.resetSelectedObjects();f.addRemoveToSelectedDataPoints(d);f.handleUserSelectEvent()}}else{if(h&&h.edges&&h.edges.length==1){}}}f.addMenu(g)}}if(this.events&&this.events.click){this.userEvents.click=this.events.click}else{this.userEvents.click=function(h,g,f,d){if(h&&h.t){f.modifyDendrogram(h)}else{if(h&&h.objectType){alert("Click on "+h.display)}else{if(h.nodes&&h.nodes.length==1&&h.nodes[0].links){f.showLinkDiv(g,h.nodes[0].links,h.nodes[0].label!=null?h.nodes[0].label:h.nodes[0].name?h.nodes[0].name:h.nodes[0].id)}else{if(h.edges&&h.edges.length==1&&h.edges[0].links){f.showLinkDiv(g,h.edges[0].links,h.edges[0].label!=null?h.edges[0].label:h.edges[0].name?h.edges[0].name:h.edges[0].id1+"-"+h.edges[0].id2)}else{}}}}return false}}if(this.events&&this.events.dblclick){this.userEvents.dblclick=this.events.dblclick}else{this.userEvents.dblclick=function(h,g,f,d){if(h&&h.t){f.zoomDendrogram(h)}else{if(h&&h.objectType){alert("Double Click on "+h.display)}else{if(f.graphType=="Network"||f.graphType=="Genome"){f.addConfigurator(g,d)}else{if(h){f.showTooltipDiv(g,f.arrayToHTML(f.getDataClassAsArray(f.getUngroupedDataObject(h))))}}}}return false}}var c=["mouseover","mousemove"];for(var a=0;a<c.length;a++){if(this.events&&this.events[c[a]]){this.userEvents[c[a]]=this.events[c[a]]}else{this.userEvents[c[a]]=function(g,d){var f=b.getSummaryDataObject(g);if(f&&f!=""){b.showInfoSpan(d,f)}}}}};this.resetFlags=function(a){this.resetOn=true;this.animationOn=false;this.draggingOn=false;this.movingOn=false;this.panningOn=false;this.changingColorOn=false;this.changingColorItemOn=false;this.keyOn=false;this.xMouseDown=false;this.yMouseDown=false;this.touches=false;this.toucheEvent=false;this.moveNode=false;this.moveNodeIndex=false;this.moveNodeLab=false;this.moveNodeDec=false;this.moveLegend=false;this.moveNodeX=false;this.moveNodeY=false;this.moveNodeW=false;this.moveNodeH=false;this.moveGenome=false;this.moveVar=false;this.moveSmp=false;if(a){this.stopEvent(a)}document.defaultAction=true;document.body.style.cursor="default"};this.mousemoveDoc=function(a){return function(f){if(!f){f=window.event}if(a.lastMousemove){if(new Date().getTime()-a.lastMousemove<20){return}}a.lastMousemove=new Date().getTime();var b=a.getTargetEvent(f);if(b.className=="CanvasXpress"&&!CanvasXpress.resizing){CanvasXpress.current=b.id}if((CanvasXpress.current&&CanvasXpress.current==a.target)||CanvasXpress.resizing||b.id.match(/-cX-API-Example/)){if(!this.toolbarPermanent){a.isToolbar(f)}if(a.isVersion(f)){var g=a.$(a.target);g.style.cursor="help";a.showInfoSpan([f.clientX,f.clientY+50],"CanvasXpress ("+a.version+")")}else{if(a.filteringNumericOn){a.preventSelection();a.updateNumericFilter(f)}else{if(a.filteringStringOn){a.preventSelection();a.updateStringFilter(f)}else{if(a.draggingTargetOn){a.preventSelection();a.updateMousemove(f)}else{if(a.resizingDataTableOn){a.preventSelection();a.updateDataTableResizerDiv(f)}else{if(a.axesResizingOn){a.preventSelection();a.mousemoveAxesResize(f)}else{if(a.resizingDataTableColumnOn){a.preventSelection();a.mousemoveDataTableHeader(f)}else{if(a.changingColorOn){a.preventSelection();a.updateColorValue(f)}else{if(a.changingColorItemOn){a.preventSelection();a.updateColorItemValue(false,f)}else{if(!a.configuringOn||(a.configuratorLastState&&a.configuratorLastState=="docked")){if(a.draggingOn){a.preventSelection();a.cancelEvent(f);a.updateDrag(f);a.lastCanvasEvent="drag"}else{if(a.resizingCanvasOn&&a.resizeCanvasCursorShow){a.preventSelection();a.cancelEvent(f);a.updateCanvasResizer(f);a.lastCanvasEvent="resize"}else{if(a.mobileApp){}else{a.cancelEvent(f);a.updateCanvasResizerCursor(f)}}}var d=a.graphType=="Genome"?a.isEvent(f,false,true):a.isEvent(f);if(d){if(b.className=="CanvasXpress"){a.handleMouseEvents("mousemove",f,d)}}else{a.resetInfoSpan(f,true)}}}}}}}}}}}}else{a.cancelEvent(f)}return false}}(this);this.registerMousemove=function(a){return function(c){if(!c){c=window.event}var b=c.target||c.srcElement;if((c.button==1&&window.event!=null||c.button==0)&&a.hasClass(b,"draggable")){if(a.activeTarget){a.activeTarget.style.zIndex=10000}a.draggableTarget=b.parentNode&&a.hasClass(b.parentNode,"draggable-container")?b.parentNode:b;a.activeTarget=a.draggableTarget;a.activeTarget.style.zIndex=10001;a.xMouseDown=c.clientX;a.yMouseDown=c.clientY;a.draggableXoffset=parseInt(a.draggableTarget.style.left)||0;a.draggableYoffset=parseInt(a.draggableTarget.style.top)||0;a.draggingTargetOn=true;a.removeMenus()}}}(this);this.updateMousemove=function(b){if(!b){b=window.event}if(this.draggableTarget&&this.draggableTarget.style){var a=this.draggableXoffset+b.clientX-this.xMouseDown;var c=this.draggableYoffset+b.clientY-this.yMouseDown;this.draggableTarget.style.left=a+"px";this.draggableTarget.style.top=c+"px";this.draggableLastX=a;this.draggableLastY=c;if(this.draggableTarget.id==this.target+"-cX-DataTable"&&this.dataTableLastState=="docked"){this.moveDataTableDiv("release")}}};this.endMousemove=function(a){if(this.draggableTarget!=null){this.moveDataTableDiv();document.onselectstart=null;this.xMouseDown=null;this.yMouseDown=null;this.draggableXoffset=null;this.draggableYoffset=null;this.draggableTarget.ondragstart=null;this.draggableTarget=false;this.draggingTargetOn=false}};this.mouseupDoc=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);if((CanvasXpress.current&&CanvasXpress.current==a.target)||b.id.match(/-cX-API-Example/)){if(a.draggingTargetOn){a.endMousemove(c)}else{if(a.resizingDataTableOn){a.endDataTableResizerDiv(c)}else{if(a.resizingDataTableColumnOn){a.endDataTableColumnResize(c)}else{if(a.changingColorOn){a.endColorChange(c)}else{if(a.changingColorItemOn){a.endColorItemChange(c)}else{if(!a.configuringOn||(a.configuratorLastState&&a.configuratorLastState=="docked")){a.stopEvent(c);a.endDrag(c);a.endCanvasResizer(c);a.endAxesResizer(c);a.endNumericFilter(c);a.endStringFilter(c);a.resetFlags(c)}}}}}}if(a.userEvents[c.type]){a.handleMouseEvents(c.type,c)}}}}(this);this.touchendDoc=function(a){return function(g){if(CanvasXpress.current&&CanvasXpress.current==a.target){if(!a.touchEvent||!a.mobileApp||!a.touches){return a.mouseupDoc(g)}var f=a.layoutComb?a.layoutParams[a.layoutValidN].graphType:a.graphType;var d=a;var b=function(){clearTimeout(b);if(d.touches.length>1){var k=d.touches[0];var j=d.touches[1];var r=Math.abs(j[0]-k[0]);var q=Math.abs(j[1]-k[1]);var n=Math.atan2(j[1]-k[1],j[0]-k[0])*180/Math.PI;if(r<20&&q<20){d.touchEvent="dbltap"}else{d.touchEvent="pinch"}}else{if(d.touchEvent!="drag"){if(d.touchEvent=="dbltap"||d.touchEvent=="pinch"){return false}d.touchEvent="tap"}}if(d.touchEvent=="pinch"&&d.touchesEnd.length>1){if(d.graphType.match(/Network|Genome|Heatmap|Bar|Line|Dotplot|Boxplot|Area|Stacked|Scatter3D|Circular/)){var o=d.euclidianDistance([d.touches[0][0],d.touches[1][0]],[d.touches[0][1],d.touches[1][1]]);var e=d.euclidianDistance([d.touchesEnd[0][0],d.touchesEnd[1][0]],[d.touchesEnd[0][1],d.touchesEnd[1][1]]);var p=(d.touchesEnd[0][0]+d.touchesEnd[1][0])/2;var m=(d.touchesEnd[0][1]+d.touchesEnd[1][1])/2;var l=d.zoomStep;d.zoomStep*=3;d.resetFlags(g);d.handleWheelEvent(g,e-o,{x:p,y:m});d.zoomStep=l}d.touchesEnd=false;return false}else{if(d.touchEvent=="dbltap"){d.stopEvent(g);d.addConfigurator(g,false,3,3);d.resetFlags(g);return false}else{if(d.touchEvent=="tap"){var h=d.getEventDataId(g);if(h){d.handleMouseEvents("click",g,h)}else{d.resetSelectedObjects()}d.resetFlags(g);return false}}}d.stopEvent(g);d.endDrag(g);d.endCanvasResizer(g);d.endAxesResizer(g);d.resetFlags(g)};var c=a.adjustedCoordinates(g);if(c){if(!a.touchesEnd){a.touchesEnd=[]}a.touchesEnd.push([c.x,c.y,new Date().getTime()]);setTimeout(b,250)}}}}(this);this.keydownDoc=function(a){return function(b){if(!b){b=window.event}if(CanvasXpress.current&&CanvasXpress.current==a.target){a.registerKey(b)}}}(this);this.keyupDoc=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);if(CanvasXpress.current&&CanvasXpress.current==a.target){a.keyOn=false;if(b.id.match(/cX-DataFilter.+ContentSearch/)){a.updateSearchFilters(b.id)}else{if(b.id.match(/cX-DataFilterInput/)){a.updateSelectStringFilter(b.id)}else{if(a.configuringOn){a.selectConfig(c)}else{if(a.remoteService){a.selectDataSet(c)}}}}}}}(this);this.resizeWindow=function(a){return function(b){if(!b){b=window.event}if(a.resizeImage){a.resizeImage(true)}return false}}(this);this.initDocEvents=function(){this.addEvtListener(document,"mousemove",this.mousemoveDoc,false);this.addEvtListener(document,"touchmove",this.mousemoveDoc,false);this.addEvtListener(document,"mouseup",this.mouseupDoc,false);this.addEvtListener(document,"touchend",this.touchendDoc,false);this.addEvtListener(document,"keydown",this.keydownDoc,false);this.addEvtListener(document,"keyup",this.keyupDoc,false);this.addEvtListener(window,"resize",this.resizeWindow,false)};this.initializeEvents=function(){this.setUserEvents();this.initViewport();this.initToolbarTooltip();this.initMenuLinks();this.initConfigurator();this.initDataFilter();this.initDataTable();this.initDraggingEvents();this.initCanvasResizerEvents();this.initAxisResizerEvents();this.initKeyEvents();this.initSelectEvents();this.initDendrogramEvents();this.initCanvasEvents();this.initAcknowlegments();this.initCodeInfo();this.initDocEvents();this.initCleanupEvents()};this.initializeEvents()};CanvasXpress.prototype.initAnimation=function(){this.saveSnapshot=function(){var a=this.cloneVisualData(this.data);if(a){this.snapshots.push(a)}};this.playSnapshot=function(b,d,c){if(this.snapshots.length<1){return}this.stopSnapshotPlay();var a=this;this.snapshotPlay={idx:0,time:b,task:setTimeout(function(){a.nextSnapshot(c)},0),callback:d,oldData:this.data};this.snapshotPaused=false};this.nextSnapshot=function(c){if(this.snapshotPlay.idx>=this.snapshots.length){if(this.snapshotPlay.callback){this.snapshotPlay.callback.call(this,c)}else{this.snapshotPlay.idx=0}}if(this.snapshotPlay){var b=this.snapshotPlay.time||this.snapshots[this.snapshotPlay.idx].time||50;this.loadData(this.snapshots[this.snapshotPlay.idx++],true);var a=this;this.snapshotPlay.task=setTimeout(function(){a.nextSnapshot(c)},b);this.snapshotPaused=false}};this.stopSnapshotPlay=function(a){if(!this.snapshotPlay){return}clearTimeout(this.snapshotPlay.task);this.loadData(this.snapshotPlay.oldData,a);delete (this.snapshotPlay);this.snapshotPaused=false};this.clearSnapshot=function(){this.stopSnapshotPlay(true);this.snapshots=[];this.snapshotPaused=false};this.duplicateSnapshot=function(){if(this.snapshots.length<1){return}var a=(this.snapshotPlay?this.snapshotPlay.idx:this.snapshots.length)-1;var b=this.cloneVisualData(this.snapshots[a]);if(this.snapshotPlay){this.snapshots.splice(a+1,0,b);this.snapshotPlay.idx++}else{this.snapshots.push(b)}};this.makeSnapshotPlay=function(){if(!this.snapshotPlay){this.snapshotPlay={idx:this.snapshots.length,oldData:this.data}}else{this.pauseSnapshot()}};this.moveSnapshot=function(c){if(this.snapshots.length<1){return}this.makeSnapshotPlay();var b=this.snapshotPlay.idx-1,a=b+c;if(a>=0&&a<=this.snapshots.length){this.snapshots.splice(a,0,(this.snapshots.splice(b,1))[0])}this.snapshotPlay.idx=a+1};this.prevSnapshotOnce=function(){if(this.snapshots.length<2){return}this.makeSnapshotPlay();this.snapshotPlay.idx-=2;if(this.snapshotPlay.idx<0){this.snapshotPlay.idx=0}this.loadData(this.snapshots[this.snapshotPlay.idx++],true);this.snapshotPaused=true};this.nextSnapshotOnce=function(){if(!this.snapshotPlay){return}if(this.snapshotPlay.idx<this.snapshots.length){this.loadData(this.snapshots[this.snapshotPlay.idx++],true)}this.snapshotPaused=true};this.hasNextSnapshot=function(){return this.snapshots.length>1&&this.snapshotPlay&&this.snapshotPaused&&this.snapshotPlay.idx<this.snapshots.length};this.hasPrevSnapshot=function(){return this.snapshots.length>1&&(!this.snapshotPlay||(this.snapshotPlay.idx>1&&this.snapshotPaused))};this.updateSnapshot=function(){if(this.snapshotPlay){this.snapshots[this.snapshotPlay.idx-1]=this.cloneVisualData(this.data)}};this.pauseSnapshot=function(){if(!this.snapshotPlay){return}if(this.snapshotPlay.task){clearTimeout(this.snapshotPlay.task)}this.snapshotPaused=true};this.setSnapshotTime=function(a){if(a>0){this.snapshots[this.snapshotPlay.idx-1].time=a}};this.getSnapshotTime=function(){return this.snapshots[this.snapshotPlay.idx-1].time||50};this.assembleObj=function(b,k,m){var e=[];if(!k[m]){return b[m]}if(!k[m].indices){k[m].indices={}}for(var h=0;h<b[m].length;h++){var f=b[m][h],a=f.id||f.id1+"-"+f.id2;if(!k[m].deleted[a]){var l=k[m].changed[a];if(l){for(var g in l){f[g]=l[g]}}var p=k[m].indices[a]!=null?k[m].indices[a]:m=="nodes"?b.nodeIndices[a]:b.edgeIndices[a];e[p]=f;k[m].indices[a]=p}}for(var a in k[m].added){e[k[m].indices[a]]=k[m].added[a]}return e};this.assembleData=function(b,c){var a={};a.nodes=this.assembleObj(b,c,"nodes");a.nodeIndices=c.nodes&&c.nodes.indices?c.nodes.indices:b.nodeIndices;a.edges=this.assembleObj(b,c,"edges");a.legend=c.legend||b.legend;return a};this.loadData=function(d,e){this.data=d;switch(this.graphType){case"Bar":case"Line":case"BarLine":case"Dotplot":case"DotLine":case"Scatter2D":case"ScatterBubble2D":case"Circular":break;case"Scatter3D":case"Area":case"AreaLine":case"Boxplot":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Candlestick":case"Correlation":case"Venn":case"Pie":case"Genome":return false;break;case"Network":if(this.data.type=="changedData"){this.data=this.assembleData(this.cloneObject(this.snapshotsBase),this.cloneObject(this.data))}this.edges=this.data.edges;var b={};for(var c=0;c<this.data.nodes.length;c++){var a=this.data.nodes[c];b[a.id]=a}this.nodes=b;break}if(e){this.draw(false,false,true)}};this.changedNodeData=function(c,g){var i={deleted:{},changed:{},added:{}};for(var b in c.nodeIndices){var j=g.nodeIndices[b];if(j==null){i.deleted[b]=1}else{var h=c.nodes[c.nodeIndices[b]],e=g.nodes[j],k={id:b},f=false;for(var a in e){if(!this.isSameObject(e[a],h[a])){k[a]=e[a];f=true}}if(f){i.changed[b]=k}}}for(var b in g.nodeIndices){if(c.nodeIndices[b]==null){i.added[b]=g.nodes[g.nodeIndices[b]]}}i.indices=this.changedIndices(c.nodeIndices,g.nodeIndices);return i};this.getEdgeIndices=function(f){var b={};if(f.edges.length){for(var a=0;a<f.edges.length;a++){var c=f.edges[a];b[c.id1+"-"+c.id2]=a}}return b};this.changedEdgeData=function(f,g){var c={deleted:{},changed:{},added:{}};if(!f.edgeIndices){f.edgeIndices=this.getEdgeIndices(f)}var e=this.getEdgeIndices(g);for(var h in f.edgeIndices){var a=e[h];if(a==null){c.deleted[h]=1}else{var b=g.edges[a];if(!this.isSameObject(f.edges[f.edgeIndices[h]],b)){c.changed[h]=b}}}for(var h in e){if(f.edgeIndices[h]==null){c.added[h]=g.edges[e[h]]}}c.indices=this.changedIndices(f.edgeIndices,e);return c};this.changedIndices=function(b,c){var a={};for(var e in c){if(b[e]==null||b[e]!=c[e]){a[e]=c[e]}}return a};this.getSnapshotChanged=function(b){var a=this.snapshotsBase;return{type:"changedData",nodes:this.changedNodeData(a,b),edges:this.changedEdgeData(a,b),legend:this.isSameObject(a.legend,b.legend)?null:b.legend}};this.cloneVisualData=function(f){switch(this.graphType){case"Bar":case"Line":case"BarLine":case"Dotplot":case"DotLine":case"Scatter2D":case"ScatterBubble2D":case"Circular":return this.cloneObject(f);break;case"Scatter3D":case"Area":case"AreaLine":case"Boxplot":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Candlestick":case"Correlation":case"Venn":case"Pie":case"Genome":return false;break;case"Network":if(this.snapshotCopyChangeOnly){if(this.snapshots.length){return f.type=="changedData"?this.cloneObject(f):this.getSnapshotChanged(f)}else{this.snapshotsBase=this.cloneObject(f);return{type:"changedData"}}}if(!this.snapshotNoCopyData){return this.cloneObject(f)}var c={nodes:[],edges:[]};if(f.nodes&&f.nodes.length){for(var b=0;b<f.nodes.length;b++){var g={};var e=f.nodes[b];var h=["outline","width","height","pattern","rotate","color","shape","size","x","y","id","hideLabel","hideChildren","hideParent","label","labelX","labelY","labelSize","name","hide","anchor","parentNode","imagePath"];for(var a=0;a<h.length;a++){g[h[a]]=e[h[a]]}c.nodes.push(g)}}if(f.edges&&f.edges.length){for(var b=0;b<f.edges.length;b++){var g={};var e=f.edges[b];var h=["color","width","type","id1","id2","anchor"];for(var a=0;a<h.length;a++){g[h[a]]=e[h[a]]}c.edges.push(g)}}return c;break}};this.isValidAnimation=function(){switch(this.graphType){case"Bar":case"Line":case"BarLine":case"Dotplot":case"DotLine":case"Scatter2D":case"ScatterBubble2D":return true;case"Scatter3D":case"Area":case"AreaLine":case"Boxplot":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Candlestick":case"Correlation":case"Venn":case"Pie":case"Genome":case"Network":case"Circular":return false}};this.createAnimation=function(e){switch(this.graphType){case"Bar":case"Line":case"BarLine":case"Dotplot":case"DotLine":case"Scatter2D":case"ScatterBubble2D":this.isAnimation=true;var f=this.cloneVisualData(this.data);if(e.match(/grow|spring|random/)&&this.data.y.data){var d=this.animationCycles;for(var c=0;c<d;c++){for(var b=0;b<this.data.y.data.length;b++){for(var a=0;a<this.data.y.data[b].length;a++){if(!isNaN(this.data.y.data[b][a])){var g=this.data.y.data[b][a];if(e=="grow"){this.data.y.data[b][a]=g/d*c}else{if(e=="spring"){this.data.y.data[b][a]=g/(d-1.5)*(c+1)}else{this.data.y.data[b][a]=g/d*Math.floor(Math.random()*c)}}}}}this.saveSnapshot();this.data=this.cloneVisualData(f)}}this.data=f;this.saveSnapshot();this.playSnapshot(this.animationTime,this.stopAnimation);break;case"Scatter3D":case"Area":case"AreaLine":case"Boxplot":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Candlestick":case"Correlation":case"Venn":case"Pie":case"Genome":case"Network":case"Circular":return;break}};this.stopAnimation=function(){this.stopSnapshotPlay();this.snapshots=[];this.isAnimation=false};this.setSnapshotsData=function(a){this.snapshots=a.ss||a;this.snapshotsBase=a.base};this.getSnapshotsData=function(){return{base:this.snapshotsBase,ss:this.snapshots}};this.createDemoNetworkAnimation=function(h){var p=[],e={},q=[];for(var u=0;u<h;u++){var n=u+1;p.push({size:0.5,x:Math.floor(Math.random()*h*5),y:Math.floor(Math.random()*h*5),outline:"rgb(255,255,255)",color:"rgb(255,0,0)",id:n,label:n,hideLabel:true,labelSize:0.7,name:"Node "+n,pattern:"closed",shape:"star"});e[n]=u}var d={nodes:p,nodeIndices:e,edges:[],edgeIndices:{}};q.push({type:"changedData"});var s=10;var b=5;var o=255/b;var a=0.5/b;var k=5;for(var t=0;t<s;t++){var m=Math.floor(Math.random()*p.length);for(var u=0;u<b;u++){var g=Math.floor(255-(u+1)*o);var l=Math.floor((u+1)*o),v=[g,l,l];var f={};f[p[m].id]={size:0.5+a*(u+1),color:"rgb("+v.join(",")+")"};q.push({type:"changedData",nodes:{deleted:{},added:{},changed:f},time:5})}}this.setSnapshotsData({base:d,ss:q})};this.createDemoNetworkAnimation1=function(){var b=[];var l={};var o=[];var n=10;var m=200;var a="ball";var f={width:n,x:100,y:0,color:"rgb(0,255,0)",id:a,label:a,hideLabel:true,labelSize:0.7,name:a,pattern:"closed",shape:"sphere"};a="plank";var g={width:200,height:5,x:100,y:m,color:"rgb(255,255,0)",id:a,label:a,hideLabel:true,labelSize:0.7,name:a,pattern:"closed",shape:"rectangle"};a="ref";var d={width:10,x:80,y:0,color:"rgb(0,0,255)",id:a,label:a,hideLabel:true,labelSize:0.7,name:a,pattern:"closed",shape:"sphere"};var c={nodes:[f,g,d],nodeIndices:{ball:0,plank:1,ref:2},edges:[],edgeIndices:{}};o.push({type:"changedData"});for(var k=1,h=0;h<m-n/2;h+=n/2,k+=0.1){var e=k*k;o.push({type:"changedData",nodes:{deleted:{},added:{},changed:{ball:{y:h,time:25*n>h?50-h*2/n:5}}},time:100/e})}this.setSnapshotsData({base:c,ss:o})};this.fade=function(e,a,f,d){if(e){if(this.showFadeResizeMoveAnimation){if(!a){a=1000}if(e.fadeState==null){if(e.style.opacity==null||e.style.opacity==""||e.style.opacity=="1"){e.fadeState=2}else{e.fadeState=-2}}if(e.fadeState==1||e.fadeState==-1){e.fadeState=e.fadeState==1?-1:1;e.fadeleft=a-e.fadeleft}else{var b=this;e.fadeState=e.fadeState==2?-1:1;e.fadeleft=a;setTimeout(function(){b.animateFade(new Date().getTime(),e,f,d)},33)}}else{e.style.opacity=0;e.style.filter="alpha(opacity = 0)";if(f!=null){f()}}}};this.animateFade=function(a,h,j,d){var b=this;var g=new Date().getTime();var f=g-a;if(h.fadeleft<=f){h.style.opacity=h.fadeState==1?"1":"0";h.style.filter="alpha(opacity = "+(h.fadeState==1?"100":"0")+")";h.fadeState=h.fadeState==1?2:-2;if(j!=null){j()}if(d){setTimeout(function(){b.resetFade(h);for(var c=0;c<d.length;c++){delete (h.style[d[c]])}},500)}return}h.fadeleft-=f;var i=h.fadeleft/1000;if(h.fadeState==1){i=1-i}h.style.opacity=i;h.style.filter="alpha(opacity = "+(i*100)+")";setTimeout(function(){b.animateFade(g,h,j)},33)};this.resetFade=function(a){if(a){a.style.opacity=1;a.style.filter="alpha(opacity = 100)";if(!this.isIE){delete (a.fadeState);delete (a.fadeleft)}}};this.resizeMove=function(d,b,m,k,e,q,l){if(d){if(this.showFadeResizeMoveAnimation){if(!q){q=500}var p=parseInt(d.style.left)||0;var i=parseInt(d.style.top)||0;var g=parseInt(d.style.width)||0;var a=parseInt(d.style.height)||0;var j=1;if(q>0){j=q/40}var n=b-p;if(n!=0){n/=j}var h=m-i;if(h!=0){h/=j}var f=k-g;if(f!=0){f/=j}var r=e-a;if(r!=0){r/=j}this.updateResizeMove(d,p,b,n,i,m,h,g,k,f,a,e,r,l)}else{d.style.left=Math.round(b)+"px";d.style.top=Math.round(m)+"px";d.style.width=Math.round(k)+"px";d.style.height=Math.round(e)+"px";if(l!=null){l()}}}};this.updateResizeMove=function(d,n,b,m,i,l,h,g,j,f,a,e,q,k){if(d){var p=this;n=this.stepResizeMove(n,b,m);i=this.stepResizeMove(i,l,h);g=this.stepResizeMove(g,j,f);a=this.stepResizeMove(a,e,q);d.style.left=Math.round(n)+"px";d.style.top=Math.round(i)+"px";d.style.width=Math.round(g)+"px";d.style.height=Math.round(a)+"px";if(n==b&&i==l&&a==e&&g==j){if(k!=null){k()}return}setTimeout(function(){p.updateResizeMove(d,n,b,m,i,l,h,g,j,f,a,e,q,k)},40)}};this.stepResizeMove=function(d,b,a){if(a==0||d==b){return b}d+=a;if((a>0&&d>=b)||(a<0&&d<=b)){return b}return d};this.transitionAccordion=function(a,d,h,j){var f=this;var b=new Date().getTime();var g=b-a;if(d<=g){if(h){h.style.height=this.dataFilterHeight+"px"}if(j){j.style.height="0px";j.style.display="none"}if(h){if(h.clientWidth-h.scrollWidth){this.resizeDataFilterForScroller(true)}else{if(h.clientHeight<this.canvas.height&&this.dataFilterScroller){this.resizeDataFilterForScroller()}}}return}d-=g;var i=Math.round((d/250)*this.dataFilterHeight);if(h){if(h.style.display!="block"){h.style.display="block"}h.style.height=(this.dataFilterHeight-i)+"px"}if(j){j.style.height=i+"px"}setTimeout(function(){f.transitionAccordion(b,d,h,j)},33)}};CanvasXpress.prototype.initExample=function(){this.dataSetGeneric={z:{Annt1:["Desc:1","Desc:2","Desc:3","Desc:4"],Annt2:["Desc:A","Desc:B","Desc:A","Desc:B"],Annt3:["Desc:X","Desc:X","Desc:Y","Desc:Y"]},x:{Factor1:["Lev:1","Lev:2","Lev:3","Lev:1","Lev:2","Lev:3"],Factor2:["Lev:A","Lev:B","Lev:A","Lev:B","Lev:A","Lev:B"],Factor3:["Lev:X","Lev:X","Lev:Y","Lev:Y","Lev:Z","Lev:Z"]},y:{vars:["Variable1","Variable2","Variable3","Variable4"],smps:["Sample1","Sample2","Sample3","Sample4","Sample5","Sample6"],data:[[5,10,25,40,45,50],[95,80,75,70,55,40],[25,30,45,60,65,70],[55,40,35,30,15,1]],desc:["Magnitude1","Magnitude2"]},a:{xAxis:["Variable1","Variable2"],xAxis2:["Variable3","Variable4"]},t:{vars:"(((Variable1,Variable3),Variable4),Variable2)",smps:"(((((Sample1,Sample2),Sample3),Sample4),Sample5),Sample6)"}};this.dataSetCircular={z:{Ring:["1","2","2","3"]},x:{Segment:["Seg1","Seg1","Seg1","Seg1","Seg1","Seg2","Seg2","Seg2","Seg2","Seg2","Seg3","Seg3","Seg3","Seg3","Seg3"],Factor1:["L1","L2","L3","L4","L5","L1","L2","L3","L4","L5","L1","L2","L3","L4","L5"]},y:{vars:["Variable1","Variable2","Variable3","Variable4"],smps:["Sample1","Sample2","Sample3","Sample4","Sample5","Sample6","Sample7","Sample8","Sample9","Sample10","Sample11","Sample12","Sample13","Sample14","Sample15"],data:[[5,15,25,35,45,55,65,75,85,75,65,55,45,35,25],[95,85,75,65,55,45,35,25,15,5,15,25,35,45,55],[25,35,45,55,65,75,85,95,85,75,65,55,45,35,25],[55,45,35,25,15,5,15,25,35,45,55,65,75,85,95]],desc:["Magnitude1"]},c:[["rgb(51,125,255)","Sample1","Sample10"],["rgb(125,255,51)","Sample8","Sample11"],["rgb(255,51,125)","Sample12","Sample4"],["rgb(125,255,51)","Sample9","Sample2"],["rgb(51,125,255)","Sample3","Sample6"]]};this.dataSetCircular2={z:{Ring:["-1","1","2","2","3"]},x:{Segment:["Seg1","Seg1","Seg1","Seg1","Seg1","Seg2","Seg2","Seg2","Seg2","Seg2","Seg3","Seg3","Seg3","Seg3","Seg3"],Factor1:["L1","L2","L3","L4","L5","L1","L2","L3","L4","L5","L1","L2","L3","L4","L5"]},y:{vars:["Number","Variable1","Variable2","Variable3","Variable4"],smps:["Sample1","Sample2","Sample3","Sample4","Sample5","Sample6","Sample7","Sample8","Sample9","Sample10","Sample11","Sample12","Sample13","Sample14","Sample15"],data:[[1,2,3,4,5,1,2,3,4,5,1,2,3,4,5],[5,15,25,35,45,55,65,75,85,75,65,55,45,35,25],[95,85,75,65,55,45,35,25,15,5,15,25,35,45,55],[25,35,45,55,65,75,85,95,85,75,65,55,45,35,25],[55,45,35,25,15,5,15,25,35,45,55,65,75,85,95]],desc:["Magnitude1"]},c:[["rgb(51,125,255)","Seg1",1,"Seg2",5,1,1],["rgb(125,255,51)","Seg2",3,"Seg3",1,1,2],["rgb(255,51,125)","Seg3",2,"Seg1",4,2,1],["rgb(125,255,51)","Seg2",4,"Seg1",2,1,1],["rgb(51,125,255)","Seg1",3,"Seg3",4,1,1]]};this.dataSetBoxplot={x:{Factor1:["Lev1","Lev1","Lev1","Lev1","Lev1","Lev1","Lev2","Lev2","Lev2","Lev2","Lev2","Lev2"]},y:{vars:["Variable1","Variable2"],smps:["Sample1","Sample2","Sample3","Sample4","Sample5","Sample6","Sample7","Sample8","Sample9","Sample10","Sample11","Sample12"],data:[[5,8,10,6,8,20,25,27,30,27,6,29],[49,18,14,16,18,15,65,67,60,72,76,9]],desc:["Magnitude1"]}};this.dataSetMultidimensionalHeatmap={y:{vars:["Variable1","Variable2","Variable3","Variable4","Variable5"],smps:["Sample1","Sample2","Sample3","Sample4","Sample5","Sample6","Sample7","Sample8","Sample9","Sample10"],data:[[1,2,3,4,5,6,7,8,9,10],[10,9,8,7,6,5,4,3,2,1],[1,2,3,4,5,6,7,8,9,10],[10,9,8,7,6,5,4,3,2,1],[1,2,3,4,5,6,7,8,9,10]],data2:[[1,1,2,2,3,3,4,4,5,5],[6,6,7,7,8,8,9,9,10,10],[10,10,9,9,8,8,7,7,6,6],[5,5,4,4,3,3,2,2,1,1],[3,3,4,4,5,5,6,6,7,7]],data3:[["A","A","B","B","C","C","D","D","E","E"],["E","E","D","D","C","C","B","B","A","A"],["A","A","B","B","C","C","D","D","E","E"],["E","E","D","D","C","C","B","B","A","A"],["A","A","B","B","C","C","D","D","E","E"]],data4:[["A","A","B","B","A","A","B","B","A","A"],["B","B","A","A","B","B","A","A","B","B"],["A","A","B","B","A","A","B","B","A","A"],["B","B","A","A","B","B","A","A","B","B"],["A","A","B","B","A","A","B","B","A","A"]]},x:{Factor:["Lev:1","Lev:2","Lev:1","Lev:2","Lev:1","Lev:2","Lev:1","Lev:2","Lev:1","Lev:2"]},z:{Annt:["Desc:1","Desc:2","Desc:1","Desc:2","Desc:1","Desc:2","Desc:1","Desc:2","Desc:1","Desc:2"]}};this.dataSet3DScatter={y:{vars:["Variable1","Variable2","Variable3","Variable4","Variable5","Variable6","Variable7","Variable8","Variable9","Variable10","Variable11","Variable12","Variable13","Variable14","Variable15","Variable16","Variable17","Variable18","Variable19","Variable20","Variable21","Variable22","Variable23","Variable24","Variable25","Variable26","Variable27","Variable28","Variable29","Variable30","Variable31","Variable32","Variable33","Variable34","Variable35","Variable36","Variable37","Variable38","Variable39","Variable40","Variable41","Variable42","Variable43","Variable44","Variable45","Variable46","Variable47","Variable48","Variable49","Variable50","Variable51","Variable52","Variable53","Variable54","Variable55","Variable56","Variable57","Variable58","Variable59","Variable60","Variable61","Variable62","Variable63","Variable64","Variable65","Variable66","Variable67","Variable68","Variable69","Variable70","Variable71","Variable72","Variable73","Variable74","Variable75","Variable76","Variable77","Variable78","Variable79","Variable80","Variable81"],smps:["Sample1","Sample2","Sample3"],data:[[-5,5,5],[-5,15,15],[-5,25,25],[-5,35,35],[-5,45,45],[-5,35,55],[-5,25,65],[-5,15,75],[-5,5,85],[-15,15,5],[-15,25,15],[-15,35,25],[-15,45,35],[-15,55,45],[-15,45,55],[-15,35,65],[-15,25,75],[-15,15,85],[-25,25,5],[-25,35,15],[-25,45,25],[-25,55,35],[-25,65,45],[-25,55,55],[-25,45,65],[-25,35,75],[-25,25,85],[-35,35,5],[-35,45,15],[-35,55,25],[-35,65,35],[-35,75,45],[-35,65,55],[-35,55,65],[-35,45,75],[-35,35,85],[-45,45,5],[-45,55,15],[-45,65,25],[-45,75,35],[-45,85,45],[-45,75,55],[-45,65,65],[-45,55,75],[-45,45,85],[-55,35,5],[-55,45,15],[-55,55,25],[-55,65,35],[-55,75,45],[-55,65,55],[-55,55,65],[-55,45,75],[-55,35,85],[-65,25,5],[-65,35,15],[-65,45,25],[-65,55,35],[-65,65,45],[-65,55,55],[-65,45,65],[-65,35,75],[-65,25,85],[-75,15,5],[-75,25,15],[-75,35,25],[-75,45,35],[-75,55,45],[-75,45,55],[-75,35,65],[-75,25,75],[-75,15,85],[-85,5,5],[-85,15,15],[-85,25,25],[-85,35,35],[-85,45,45],[-85,35,55],[-85,25,65],[-85,15,75],[-85,5,85]]}};this.dataSetFunction={fx:"sin(2y) * cos(3x) / sec(xy)"};this.dataSetNonLinearFit={y:{vars:["Sample1","Sample2","Sample3","Sample4","Sample5","Sample6","Sample7","Sample8","Sample9","Sample10","Sample11","Sample12"],smps:["Concentration","Variable1"],data:[[0.0009,172],[0.0018,177],[0.0037,160],[0.0073,166],[0.0146,211],[0.0293,248],[0.0586,269],[0.117,283],[0.234,298],[0.469,314],[0.938,328],[1.88,316]]},d:{nlfit:[{param:[164,313,0.031,-1.5,0.0000012,1.9],label:"Custom Fit",type:"cst"},{param:[164,313,0.031,1.5,0.0000012,1.9],label:"Regular Fit",type:"reg"}]}};this.dataSetDecorationLine={y:{vars:["Sample1","Sample2","Sample3","Sample4","Sample5","Sample6","Sample7","Sample8","Sample9","Sample10","Sample11","Sample12"],smps:["Concentration","Variable1"],data:[[0.0009,172],[0.0018,177],[0.0037,160],[0.0073,166],[0.0146,211],[0.0293,248],[0.0586,269],[0.117,283],[0.234,298],[0.469,314],[0.938,328],[1.88,316]]},d:{line:[{x:0.4,y:200,color:"rgb(255,125,51)",type:"dashedLine"},{x:0.15,color:"rgb(51,255,125)",type:"line"}]}};this.dataSetDecorationLines={y:{vars:["Concentration"],smps:["Sample1","Sample2","Sample3","Sample4","Sample5","Sample6","Sample7","Sample8","Sample9","Sample10","Sample11","Sample12"],data:[[0.0009,0.0018,0.0037,0.0073,0.0146,0.0293,0.0586,0.117,0.234,0.469,0.938,1.88]]},d:{lines:[{value:0.25,label:"Background",color:"rgb(255,125,51)",type:"dashedLine"}]}};this.dataSetDecorationArea={y:{vars:["Sample1","Sample2","Sample3","Sample4","Sample5","Sample6","Sample7","Sample8","Sample9","Sample10","Sample11","Sample12"],smps:["Concentration","Variable1"],data:[[0.0009,172],[0.0018,177],[0.0037,160],[0.0073,166],[0.0146,211],[0.0293,248],[0.0586,269],[0.117,283],[0.234,298],[0.469,314],[0.938,328],[1.88,316]]},d:{area:[{x:1.42,y:322,label:"Area",width:1.2,height:30,color:"rgb(255,125,51,0.5)",ouline:"rgb(255,125,51,0.5)",pattern:"closed",rotate:0.1,type:"oval"}]}};this.dataSetKaplanMeyer={y:{vars:["p1","p2","p3","p4","p5","p6","p7","p8","p9","p10","p11","p12","p13","p14","p15","p16","p17","p18","p19","p20"],smps:["Time","Censored-1","Censored-2"],data:[[1,0,1],[2,0,1],[3,0,1],[3,0,1],[1,1,1],[2,1,1],[2,1,2],[3,1,1],[3,1,1],[4,0,0],[5,0,0],[6,0,0],[6,0,0],[7,1,0],[8,0,1],[9,0,0],[9,0],[9,0],[10,1],[11,1]]}};this.dataSetDashDot={nodes:[{id:"Id1",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:0},{id:"Id2",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:0},{id:"Id3",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:50},{id:"Id4",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:50},{id:"Id5",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:100},{id:"Id6",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:100}],edges:[{id1:"Id1",id2:"Id2",color:"rgb(0,255,0)",type:"line"},{id1:"Id3",id2:"Id4",color:"rgb(0,255,0)",type:"dashedLine"},{id1:"Id5",id2:"Id6",color:"rgb(0,255,0)",type:"dottedLine"}]};this.dataSetLines={nodes:[{id:"Id1",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:0},{id:"Id2",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:0},{id:"Id3",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:0},{id:"Id4",color:"rgb(255,0,0)",shape:"sphere",size:1,x:600,y:0},{id:"Id5",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:100},{id:"Id6",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:100},{id:"Id7",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:100},{id:"Id8",color:"rgb(255,0,0)",shape:"sphere",size:1,x:600,y:100},{id:"Id9",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:200},{id:"Id10",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:200},{id:"Id11",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:200},{id:"Id12",color:"rgb(255,0,0)",shape:"sphere",size:1,x:600,y:200},{id:"Id13",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:300},{id:"Id14",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:300},{id:"Id15",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:300},{id:"Id16",color:"rgb(255,0,0)",shape:"sphere",size:1,x:600,y:300},{id:"Id17",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:400},{id:"Id18",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:400},{id:"Id19",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:400},{id:"Id20",color:"rgb(255,0,0)",shape:"sphere",size:1,x:600,y:400},{id:"Id21",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:500},{id:"Id22",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:500},{id:"Id23",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:500},{id:"Id24",color:"rgb(255,0,0)",shape:"sphere",size:1,x:600,y:500},{id:"Id25",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:600},{id:"Id26",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:600},{id:"Id27",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:600},{id:"Id28",color:"rgb(255,0,0)",shape:"sphere",size:1,x:600,y:600},{id:"Id29",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:700},{id:"Id30",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:700},{id:"Id31",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:700},{id:"Id32",color:"rgb(255,0,0)",shape:"sphere",size:1,x:600,y:700},{id:"Id33",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:800},{id:"Id34",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:800},{id:"Id35",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:800},{id:"Id36",color:"rgb(255,0,0)",shape:"sphere",size:1,x:600,y:800},{id:"Id37",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:900},{id:"Id39",color:"rgb(255,0,0)",shape:"sphere",size:1,x:600,y:900},{id:"Id40",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:1000},{id:"Id41",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:1100},{id:"Id42",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:1000},{id:"Id43",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:1100},{id:"Id44",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:1000},{id:"Id45",color:"rgb(255,0,0)",shape:"sphere",size:1,x:600,y:1100},{id:"Id46",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:1200},{id:"Id47",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:1300},{id:"Id48",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:1200},{id:"Id49",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:1300},{id:"Id50",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:1200},{id:"Id51",color:"rgb(255,0,0)",shape:"sphere",size:1,x:600,y:1300},{id:"Id52",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:1400},{id:"Id54",color:"rgb(255,0,0)",shape:"sphere",size:1,x:200,y:1400},{id:"Id56",color:"rgb(255,0,0)",shape:"sphere",size:1,x:400,y:1400},{id:"Id57",color:"rgb(255,0,0)",shape:"sphere",size:1,x:600,y:1400}],edges:[{id1:"Id1",id2:"Id2",color:"rgb(0,255,0)",type:"line"},{id1:"Id2",id2:"Id3",color:"rgb(0,255,0)",type:"dashedLine"},{id1:"Id3",id2:"Id4",color:"rgb(0,255,0)",type:"dottedLine"},{id1:"Id5",id2:"Id6",color:"rgb(0,255,0)",type:"arrowHeadLine"},{id1:"Id6",id2:"Id7",color:"rgb(0,255,0)",type:"arrowLine"},{id1:"Id7",id2:"Id8",color:"rgb(0,255,0)",type:"arrowTailLine"},{id1:"Id9",id2:"Id10",color:"rgb(0,255,0)",type:"arrowHeadDashedLine"},{id1:"Id10",id2:"Id11",color:"rgb(0,255,0)",type:"arrowDashedLine"},{id1:"Id11",id2:"Id12",color:"rgb(0,255,0)",type:"arrowTailDashedLine"},{id1:"Id13",id2:"Id14",color:"rgb(0,255,0)",type:"arrowHeadDottedLine"},{id1:"Id14",id2:"Id15",color:"rgb(0,255,0)",type:"arrowDottedLine"},{id1:"Id15",id2:"Id16",color:"rgb(0,255,0)",type:"arrowTailDottedLine"},{id1:"Id17",id2:"Id18",color:"rgb(0,255,0)",type:"squareHeadLine"},{id1:"Id18",id2:"Id19",color:"rgb(0,255,0)",type:"squareLine"},{id1:"Id19",id2:"Id20",color:"rgb(0,255,0)",type:"squareTailLine"},{id1:"Id21",id2:"Id22",color:"rgb(0,255,0)",type:"squareHeadDashedLine"},{id1:"Id22",id2:"Id23",color:"rgb(0,255,0)",type:"squareDashedLine"},{id1:"Id23",id2:"Id24",color:"rgb(0,255,0)",type:"squareTailDashedLine"},{id1:"Id25",id2:"Id26",color:"rgb(0,255,0)",type:"squareHeadDottedLine"},{id1:"Id26",id2:"Id27",color:"rgb(0,255,0)",type:"squareDottedLine"},{id1:"Id27",id2:"Id28",color:"rgb(0,255,0)",type:"squareTailDottedLine"},{id1:"Id29",id2:"Id30",color:"rgb(0,255,0)",type:"squareHeadArrowTailLine"},{id1:"Id30",id2:"Id31",color:"rgb(0,255,0)",type:"squareHeadArrowTailDashedLine"},{id1:"Id31",id2:"Id32",color:"rgb(0,255,0)",type:"squareHeadArrowTailDottedLine"},{id1:"Id33",id2:"Id34",color:"rgb(0,255,0)",type:"arrowHeadSquareTailLine"},{id1:"Id34",id2:"Id35",color:"rgb(0,255,0)",type:"arrowHeadSquareTailDashedLine"},{id1:"Id35",id2:"Id36",color:"rgb(0,255,0)",type:"arrowHeadSquareTailDottedLine"},{id1:"Id37",id2:"Id42",color:"rgb(0,255,0)",type:"bezierLine"},{id1:"Id44",id2:"Id39",color:"rgb(0,255,0)",type:"bezierYLine"},{id1:"Id40",id2:"Id41",color:"rgb(0,255,0)",type:"arrowBezierLine"},{id1:"Id42",id2:"Id43",color:"rgb(0,255,0)",type:"arrowTailBezierLine"},{id1:"Id44",id2:"Id45",color:"rgb(0,255,0)",type:"arrowHeadBezierLine"},{id1:"Id46",id2:"Id47",color:"rgb(0,255,0)",type:"squareBezierLine"},{id1:"Id48",id2:"Id49",color:"rgb(0,255,0)",type:"squareTailBezierLine"},{id1:"Id50",id2:"Id51",color:"rgb(0,255,0)",type:"squareHeadBezierLine"},{id1:"Id49",id2:"Id57",color:"rgb(0,255,0)",type:"arrowBezierYLine"},{id1:"Id47",id2:"Id56",color:"rgb(0,255,0)",type:"arrowTailBezierYLine"},{id1:"Id35",id2:"Id42",color:"rgb(0,255,0)",type:"arrowHeadBezierYLine"},{id1:"Id46",id2:"Id41",color:"rgb(0,255,0)",type:"squareBezierYLine"},{id1:"Id48",id2:"Id43",color:"rgb(0,255,0)",type:"squareTailBezierYLine"},{id1:"Id50",id2:"Id45",color:"rgb(0,255,0)",type:"squareHeadBezierYLine"},{id1:"Id9",id2:"Id1",color:"rgb(0,255,0)",type:"curvedLine"},{id1:"Id13",id2:"Id5",color:"rgb(0,255,0)",type:"squareCurvedLine"},{id1:"Id25",id2:"Id17",color:"rgb(0,255,0)",type:"squareHeadCurvedLine"},{id1:"Id29",id2:"Id21",color:"rgb(0,255,0)",type:"squareTailCurvedLine"},{id1:"Id40",id2:"Id33",color:"rgb(0,255,0)",type:"arrowCurvedLine"},{id1:"Id52",id2:"Id46",color:"rgb(0,255,0)",type:"arrowHeadCurvedLine"},{id1:"Id4",id2:"Id12",color:"rgb(0,255,0)",type:"arrowTailCurvedLine"},{id1:"Id8",id2:"Id16",color:"rgb(0,255,0)",type:"arrowHeadSquareTailCurvedLine"},{id1:"Id20",id2:"Id28",color:"rgb(0,255,0)",type:"squareTailArrowHeadCurvedLine"},{id1:"Id24",id2:"Id32",color:"rgb(0,255,0)",type:"squareHeadArrowTailCurvedLine"},{id1:"Id39",id2:"Id45",color:"rgb(0,255,0)",type:"arrowTailSquareHeadCurvedLine"}]};this.dataSetShapes={nodes:[{id:"Id1",color:"rgb(255,0,0)",shape:"sphere",size:1,x:0,y:0},{id:"Id2",color:"rgb(255,0,0)",shape:"square",size:1,x:200,y:0},{id:"Id3",color:"rgb(255,0,0)",shape:"triangle",size:1,x:400,y:0},{id:"Id4",color:"rgb(255,0,0)",shape:"star",size:1,x:600,y:0},{id:"Id5",color:"rgb(255,0,0)",shape:"rhombus",size:1,x:0,y:100},{id:"Id6",color:"rgb(255,0,0)",shape:"octagon",size:1,x:200,y:100},{id:"Id7",color:"rgb(255,0,0)",shape:"oval",size:1,x:400,y:100},{id:"Id8",color:"rgb(255,0,0)",shape:"plus",size:1,x:600,y:100},{id:"Id9",color:"rgb(255,0,0)",shape:"minus",size:1,x:0,y:200},{id:"Id10",color:"rgb(255,0,0)",shape:"pacman",size:1,x:200,y:200},{id:"Id11",color:"rgb(255,0,0)",shape:"pacman2",size:1,x:400,y:200},{id:"Id12",color:"rgb(255,0,0)",shape:"mdavid",size:1,x:600,y:200},{id:"Id13",color:"rgb(255,0,0)",shape:"rect2",size:1,x:0,y:300},{id:"Id14",color:"rgb(255,0,0)",shape:"rect3",size:1,x:200,y:300},{id:"Id15",color:"rgb(255,0,0)",shape:"arc",size:1,x:400,y:300},{id:"Id16",color:"rgb(255,0,0)",shape:"rectangle",size:1,x:600,y:300},{id:"Id17",color:"rgb(255,0,0)",shape:"image",imagePath:"cx.png",size:1,x:0,y:400},{id:"Id18",color:"rgb(255,0,0)",shape:"pie0",size:1,x:200,y:400},{id:"Id19",color:"rgb(255,0,0)",shape:"pie1",size:1,x:400,y:400},{id:"Id20",color:"rgb(255,0,0)",shape:"pie2",size:1,x:600,y:400},{id:"Id21",color:"rgb(255,0,0)",shape:"pie3",size:1,x:0,y:500},{id:"Id22",color:"rgb(255,0,0)",shape:"pie4",size:1,x:200,y:500},{id:"Id23",color:"rgb(255,0,0)",shape:"pie5",size:1,x:400,y:500},{id:"Id24",color:"rgb(255,0,0)",shape:"pie6",size:1,x:600,y:500},{id:"Id25",color:"rgb(255,0,0)",shape:"pie7",size:1,x:0,y:600},{id:"Id26",color:"rgb(255,0,0)",shape:"pie8",size:1,x:200,y:600},{id:"Id27",color:"rgb(255,0,0)",shape:"pie9",size:1,x:400,y:600},{id:"Id28",color:"rgb(255,0,0)",shape:"circle",size:1,x:600,y:600},{id:"Id29",color:"rgb(255,0,0)",shape:"box",size:1,x:0,y:700},{id:"Id30",color:"rgb(255,0,0)",shape:"rect",size:1,x:200,y:700},{id:"Id31",color:"rgb(255,0,0)",shape:"rect2",size:1,x:400,y:700},{id:"Id32",color:"rgb(255,0,0)",shape:"rect3",size:1,x:600,y:700},{id:"Id33",color:"rgb(255,0,0)",shape:"roundrect",size:1,x:0,y:800},{id:"Id34",color:"rgb(255,0,0)",shape:"triangle2",size:1,x:200,y:800},{id:"Id35",color:"rgb(255,0,0)",shape:"equilateral",size:1,x:400,y:800},{id:"Id36",color:"rgb(255,0,0)",shape:"equilateral2",size:1,x:600,y:800},{id:"Id37",color:"rgb(255,0,0)",shape:"hexagon",size:1,x:0,y:900},{id:"Id38",color:"rgb(255,0,0)",shape:"oval2",size:1,x:200,y:900},{id:"Id39",color:"rgb(255,0,0)",shape:"oval3",size:1,x:400,y:900},{id:"Id40",color:"rgb(255,0,0)",shape:"ellipse",size:1,x:600,y:900},{id:"Id41",color:"rgb(255,0,0)",shape:"ellipse2",size:1,x:0,y:1000},{id:"Id42",color:"rgb(255,0,0)",shape:"ellipse3",size:1,x:200,y:1000}],edges:[]};this.dataSetNetworkDecorations={nodes:[{id:"Gene1",exp1:1,exp2:2,exp3:4,exp4:{cl1:2,cl2:4,cl3:3},exp5:{cl1:12,cl2:1,cl3:5},color:"rgb(255,0,0)",shape:"sphere",size:1,x:155,y:160},{id:"Gene2",exp1:2,exp2:4,exp3:1,exp4:{cl1:7,cl2:1,cl3:8},exp5:{cl1:1,cl2:11,cl3:8},color:"rgb(255,0,0)",shape:"sphere",size:1,x:155,y:340},{id:"Gene3",exp1:1,exp2:5,exp3:1,exp4:{cl1:12,cl2:4,cl3:8},exp5:{cl1:3,cl2:7,cl3:5},color:"rgb(255,0,0)",shape:"sphere",size:1,x:355,y:160},{id:"Gene4",exp1:4,exp2:2,exp3:1,exp4:{cl1:1,cl2:14,cl3:7},exp5:{cl1:2,cl2:1,cl3:15},color:"rgb(255,0,0)",shape:"sphere",size:1,x:355,y:340},{id:"Gene5",exp1:1,exp2:3,exp3:2,exp4:{cl1:4,cl2:4,cl3:8},exp5:{cl1:6,cl2:7,cl3:2},color:"rgb(255,0,0)",shape:"sphere",size:1,x:255,y:100},{id:"Gene6",color:"rgb(255,0,0)",shape:"sphere",size:1,x:255,y:400},{id:"Gene7",exp1:3,exp2:3,exp3:4,exp4:{cl1:2,cl2:14,cl3:1},exp5:{cl1:9,cl2:3,cl3:5},color:"rgb(255,0,0)",shape:"sphere",size:1,x:50,y:250},{id:"Gene8",color:"rgb(255,0,0)",shape:"sphere",size:1,x:450,y:250}],edges:[{id1:"Gene1",id2:"Gene2",color:"rgb(51,12,255)",width:"3",type:"curvedArrowHeadLine"},{id1:"Gene4",id2:"Gene3",color:"rgb(51,12,255)",width:"3",type:"curvedArrowHeadLine"},{id1:"Gene5",id2:"Gene6",color:"rgb(51,12,255)",width:"3",type:"arrowHeadLine"},{id1:"Gene3",id2:"Gene8",color:"rgb(51,12,255)",width:"3",type:"bezierArrowHeadLine"},{id1:"Gene7",id2:"Gene1",color:"rgb(51,12,255)",width:"3",type:"bezierArrowHeadLine"}]};this.dataSetNetworkRadial={nodes:[{id:"Gene1",color:"rgb(255,0,0)",shape:"square"},{id:"Gene2",color:"rgb(255,0,0)",shape:"square"},{id:"Gene3",color:"rgb(255,0,0)",shape:"square"},{id:"Gene4",color:"rgb(255,0,0)",shape:"square"},{id:"Gene5",color:"rgb(255,0,0)",shape:"square"},{id:"Gene6",color:"rgb(255,0,0)",shape:"square"},{id:"Gene7",color:"rgb(255,0,0)",shape:"square"},{id:"Gene8",color:"rgb(255,0,0)",shape:"square"},{id:"SNP1",color:"rgb(0,255,0)",shape:"sphere"},{id:"SNP2",color:"rgb(0,255,0)",shape:"sphere"},{id:"SNP3",color:"rgb(0,255,0)",shape:"sphere"},{id:"SNP4",color:"rgb(0,255,0)",shape:"sphere"},{id:"SNP5",color:"rgb(0,255,0)",shape:"sphere"},{id:"SNP6",color:"rgb(0,255,0)",shape:"sphere"},{id:"SNP7",color:"rgb(0,255,0)",shape:"sphere"},{id:"SNP8",color:"rgb(0,255,0)",shape:"sphere"},{id:"PH1",color:"rgb(0,255,255)",shape:"star"},{id:"PH1a",color:"rgb(0,255,255)",shape:"star",parentNode:"PH1"},{id:"PH1b",color:"rgb(0,255,255)",shape:"star",parentNode:"PH1"},{id:"PH2",color:"rgb(0,255,255)",shape:"star"},{id:"PH2a",color:"rgb(0,255,255)",shape:"star",parentNode:"PH2"},{id:"PH2b",color:"rgb(0,255,255)",shape:"star",parentNode:"PH2"},{id:"PH2ba",color:"rgb(0,255,255)",shape:"star",parentNode:"PH2b"},{id:"PH3",color:"rgb(0,255,255)",shape:"star"},{id:"PH4",color:"rgb(0,255,255)",shape:"star"}],edges:[{id1:"Gene1",id2:"Gene2",color:"rgb(51,12,255)",type:"line"},{id1:"SNP1",id2:"PH1",color:"rgb(51,12,152)",type:"line"},{id1:"Gene2",id2:"Gene7",color:"rgb(51,12,255)",type:"line"},{id1:"Gene2",id2:"Gene8",color:"rgb(51,12,255)",type:"line"},{id1:"Gene1",id2:"Gene3",color:"rgb(51,12,255)",type:"line"},{id1:"SNP4",id2:"PH4",color:"rgb(51,12,152)",type:"line"},{id1:"PH1",id2:"PH1a",color:"rgb(102,12,152)",type:"line"},{id1:"PH1",id2:"PH1b",color:"rgb(102,12,152)",type:"line"},{id1:"Gene4",id2:"SNP3",color:"rgb(51,12,255)",type:"line"},{id1:"Gene6",id2:"SNP4",color:"rgb(51,12,255)",type:"line"},{id1:"PH2",id2:"PH2a",color:"rgb(51,12,152)",type:"line"},{id1:"PH2",id2:"PH2b",color:"rgb(102,12,152)",type:"line"},{id1:"Gene6",id2:"SNP5",color:"rgb(51,12,255)",type:"line"},{id1:"Gene7",id2:"SNP6",color:"rgb(51,12,255)",type:"line"},{id1:"SNP6",id2:"SNP7",color:"rgb(51,12,255)",type:"line"},{id1:"Gene1",id2:"Gene4",color:"rgb(51,12,255)",type:"line"},{id1:"Gene1",id2:"Gene5",color:"rgb(51,12,255)",type:"line"},{id1:"SNP7",id2:"Gene6",color:"rgb(51,12,255)",type:"line"},{id1:"SNP6",id2:"SNP8",color:"rgb(153,12,255)",type:"line"},{id1:"Gene3",id2:"SNP1",color:"rgb(51,12,255)",type:"line"},{id1:"Gene3",id2:"SNP2",color:"rgb(51,12,255)",type:"line"},{id1:"SNP2",id2:"PH2",color:"rgb(153,12,255)",type:"line"},{id1:"SNP3",id2:"PH3",color:"rgb(51,12,152)",type:"line"},{id1:"PH2b",id2:"PH2ba",color:"rgb(102,12,152)",type:"line"}]};this.dataSetNetworkBasic={nodes:[{id:"Cell",shape:"image",eventless:true,width:525,height:400,imagePath:"cell.png",x:250,y:250,hideLabel:true},{id:"Gene1",exp1:1,exp2:2,exp3:4,exp4:{cl1:2,cl2:4,cl3:3},exp5:{cl1:12,cl2:1,cl3:5},shape:"image",width:40,height:40,imagePath:"prot.png",x:155,y:160},{id:"Gene2",exp1:2,exp2:4,exp3:1,exp4:{cl1:7,cl2:1,cl3:8},exp5:{cl1:1,cl2:11,cl3:8},color:"rgb(255,0,0)",shape:"sphere",size:1,x:155,y:340},{id:"Gene3",exp1:1,exp2:5,exp3:1,exp4:{cl1:12,cl2:4,cl3:8},exp5:{cl1:3,cl2:7,cl3:5},color:"rgb(255,0,0)",shape:"sphere",size:1,x:355,y:160},{id:"Gene4",label:"Receptor\nGene4",exp1:4,exp2:2,exp3:1,exp4:{cl1:1,cl2:14,cl3:7},exp5:{cl1:2,cl2:1,cl3:15},color:"rgb(255,0,0)",shape:"sphere",size:1,x:355,y:340},{id:"Gene5",exp1:1,exp2:3,exp3:2,exp4:{cl1:4,cl2:4,cl3:8},exp5:{cl1:6,cl2:7,cl3:2},color:"rgb(255,0,0)",shape:"sphere",width:20,height:20,x:255,y:100},{id:"Met",shape:"image",width:40,height:40,imagePath:"met.png",x:255,y:400,hideLabel:true},{id:"Gene7",exp1:3,exp2:3,exp3:4,exp4:{cl1:2,cl2:14,cl3:1},exp5:{cl1:9,cl2:3,cl3:5},shape:"image",width:40,height:40,imagePath:"prot7.png",x:50,y:250},{id:"DNA",shape:"image",width:40,height:40,imagePath:"dna1.png",x:450,y:250,hideLabel:true}],edges:[{id1:"Gene1",id2:"Gene2",color:"rgb(51,12,255)",width:"3",type:"curvedArrowHeadLine"},{id1:"Gene4",id2:"Gene3",color:"rgb(51,12,255)",width:"3",type:"curvedArrowHeadLine"},{id1:"Gene5",id2:"Met",color:"rgb(51,12,255)",width:"3",type:"arrowHeadLine"},{id1:"Gene3",id2:"DNA",color:"rgb(51,12,255)",width:"3",type:"bezierArrowHeadLine"},{id1:"Gene7",id2:"Gene1",color:"rgb(51,12,255)",width:"3",type:"bezierArrowHeadLine"}],legend:{nodes:[{shape:"sphere",color:"rgb(255,0,0)",text:"Gene",id:"nodesLegendId0"}],edges:[{type:"arrowHeadLine",text:"Activate",id:"edgesLegendId0"}],text:[{text:"Cool Pathway",x:150,y:460,id:"textLegendId0"}],pos:{nodes:{x:-5,y:-5},edges:{x:360,y:-5},decorations:{x:20,y:80}}}};this.dataSetVenn={venn:{data:{A:340,B:562,C:620,D:592,AB:639,AC:456,AD:257,BC:915,BD:354,CD:143,ABC:552,ABD:578,ACD:298,BCD:613,ABCD:148},legend:{A:"List 1",B:"List 2",C:"List 3",D:"List 4"}}};this.dataSetMarket={market:[{symbol:"BMY",data:[[20100824,26.26,26.37,25.95,26.02,11625900,26.02],[20100823,26.48,26.76,26.38,26.48,12146600,26.48],[20100820,26.31,26.54,26.08,26.44,18140100,26.44],[20100819,26.2,26.29,25.81,26.06,8218000,26.06],[20100818,26.53,26.57,26.23,26.28,12235800,26.28],[20100817,26.4,26.79,26.26,26.59,12325700,26.59],[20100816,26.24,26.34,26.04,26.28,10377700,26.28],[20100813,26.24,26.46,26.1,26.32,5760100,26.32],[20100812,26.01,26.39,26,26.33,7350500,26.33],[20100811,26.32,26.5,26.15,26.25,8808100,26.25],[20100810,26.32,26.78,26.3,26.66,7009500,26.66],[20100809,26.37,26.54,26.3,26.51,6825300,26.51],[20100806,26.29,26.45,26.05,26.37,8774900,26.37],[20100805,25.83,26.38,25.8,26.38,12264600,26.38],[20100804,25.7,26.13,25.61,26.03,10233700,26.03],[20100803,25.65,25.85,25.58,25.68,6842900,25.68],[20100802,25.33,25.61,25.29,25.53,9770900,25.53],[20100730,24.98,25.13,24.78,24.92,11435700,24.92],[20100729,25.37,25.5,24.85,25.08,9463800,25.08],[20100728,25.25,25.36,25.02,25.12,8072400,25.12],[20100727,25.09,25.35,24.84,25.32,14152600,25.32],[20100726,24.57,25.03,24.57,24.97,8817400,24.97],[20100723,24.94,24.95,24.26,24.65,13043700,24.65],[20100722,24.96,25.22,24.75,24.93,10385300,24.93],[20100721,24.92,25.11,24.59,24.75,9830000,24.75],[20100720,24.65,25.09,24.46,25.02,10655500,25.02],[20100719,25.27,25.27,24.78,24.84,11804800,24.84],[20100716,25.44,25.47,25.1,25.17,13136300,25.17]]}]};this.dataSetGenomeTranslate={tracks:[{subtype:"DNA",type:"sequence",data:[{id:"Sequence",fill:"rgb(51,255,255)",outline:"rgb(0,0,0)",dir:"right",offset:1,sequence:"TACGTACGTACGTACGTACG",translate:[-3,-2,-1,1,2,3]}]}]};this.dataSetGenomeSimple={tracks:[{subtype:"DNA",type:"sequence",data:[{id:"Reference Sequence",fill:"rgb(51,255,255)",outline:"rgb(0,0,0)",dir:"right",offset:1,sequence:"TACGTACGTACGTACGTACGTACGTACGT",index:0,counter:0,measureText:108},{id:"R1-0000-1234",fill:"rgb(255,255,51)",outline:"rgb(0,0,0)",dir:"right",offset:1,gaps:[[4,2],[8,1]],sequence:"TACGCGTAGTACGT",index:1,counter:1,measureText:74},{id:"R1-0000-2345",fill:"rgb(255,255,102)",outline:"rgb(0,0,0)",dir:"right",offset:6,gaps:[[3,1],[10,1]],sequence:"ACGACGTACGACG",index:2,counter:2,measureText:74},{id:"R1-0000-3456",fill:"rgb(255,51,255)",outline:"rgb(0,0,0)",dir:"left",offsetLeft:"23",gaps:[[7,2]],sequence:"GTACGTATAC",index:3,counter:3,offset:12,measureText:74},{id:"R1-0000-4567",fill:"rgb(255,102,255)",outline:"rgb(0,0,0)",dir:"right",offset:15,gaps:[[5,1]],sequence:"CGTACTACGTA",index:4,counter:4,measureText:74},{id:"R1-0000-5678",fill:"rgb(51,255,255)",outline:"rgb(0,0,0)",dir:"right",offset:18,gaps:[[7,1]],sequence:"ACGTACGACGT",index:5,counter:5,measureText:74}]}]};this.dataSetGenomeIntermediate={tracks:[{subtype:"DNA",highlight:[{offset:8,width:1,color:"rgb(120,120,180)"},{offset:22,width:1,color:"rgb(180,20,180)"}],type:"sequence",data:[{id:"Reference Sequence",fill:"rgb(51,255,255)",outline:"rgb(0,0,0)",dir:"right",offset:1,sequence:"TACGTACGTACGTACGTACGTACGTACGT",translate:[-3,-2,-1,1,2,3],index:0,counter:0,measureText:108},{id:"R1-0000-1234",fill:"rgb(255,255,51)",outline:"rgb(0,0,0)",dir:"right",offset:1,gaps:[[4,2],[8,1]],sequence:"TACGCGTAGTACGT",coordinate:50,trace:{A:[15,27,47,72,93,101,93,72,47,27,15,54,120,224,350,459,502,459,350,224,120,54,3,4,6,12,24,43,67,86,94,86,67,43,24,12,6,4,3,13,26,45,69,89,97,89,69,45,26,13,13,26,46,70,92,100,92,70,46,26,13,5,12,26,48,75,99,108,99,75,48,26,12,5,2,4,10,22,41,64,83,91,83,64,41,22,10,4,2,22,55,122,226,353,462,505,462,353,226,122,55,22,4,11,24,45,70,92,100,92,70,45,24,11,4,2,3,6,13,28,50,78,102,111,102,78,50,28,13,6,3,2,6,11,26,62,135,249,388,506,553,506,388,249,135,62,26,11,6,6,8,14,26,45,68,87,95,87,68,45,26,14,8,6,11,23,43,67,88,96,88,67,43,23,11,5,6,8,15,28,48,73,94,102,94,73,48,28,15,8,6,5],C:[10,16,26,39,50,54,50,39,26,16,10,7,14,26,40,51,56,51,40,26,14,7,4,8,20,50,109,203,317,414,453,414,317,203,109,50,20,8,4,9,16,26,39,51,55,51,39,26,16,9,56,123,229,357,467,511,467,357,229,123,56,2,6,12,22,35,45,49,45,35,22,12,6,2,1,3,6,13,25,39,50,55,50,39,25,13,6,3,1,5,8,15,26,39,50,55,50,39,26,15,8,5,2,5,11,21,32,42,46,42,32,21,11,5,2,2,2,3,6,12,22,33,43,47,43,33,22,12,6,3,2,2,5,5,6,9,16,25,37,47,51,47,37,25,16,9,6,5,5,10,24,56,121,223,347,453,495,453,347,223,121,56,24,10,6,13,24,37,48,52,48,37,24,13,6,5,5,6,9,15,25,36,46,50,46,36,25,15,9,6,5,5],G:[7,10,15,20,25,27,25,20,15,10,7,4,7,13,19,25,27,25,19,13,7,4,3,3,3,5,8,14,20,25,27,25,20,14,8,5,3,3,3,56,122,226,353,461,504,461,353,226,122,56,5,8,13,19,24,26,24,19,13,8,5,22,58,130,245,383,502,549,502,383,245,130,58,22,1,1,3,7,12,18,24,26,24,18,12,7,3,1,1,3,5,8,13,19,24,26,24,19,13,8,5,3,19,51,114,213,334,437,478,437,334,213,114,51,19,2,2,3,4,8,14,21,26,29,26,21,14,8,4,3,2,2,5,5,5,7,10,15,20,25,27,25,20,15,10,7,5,5,5,5,5,7,10,15,20,25,27,25,20,15,10,7,5,5,53,119,223,349,457,500,457,349,223,119,53,5,5,5,7,10,15,21,26,28,26,21,15,10,7,5,5,5],T:[62,135,249,388,507,554,507,388,249,135,62,2,4,6,8,10,11,10,8,6,4,2,3,3,3,4,5,7,9,12,12,12,9,7,5,4,3,3,3,5,6,8,11,13,14,13,11,8,6,5,4,5,7,10,12,13,12,10,7,5,4,1,2,3,5,8,10,11,10,8,5,3,2,1,7,22,58,130,244,383,501,548,501,383,244,130,58,22,7,3,4,5,7,10,12,13,12,10,7,5,4,3,1,2,3,5,8,10,11,10,8,5,3,2,1,3,8,21,54,119,222,347,454,497,454,347,222,119,54,21,8,3,5,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,5,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,2,3,5,7,9,10,9,7,5,3,2,6,11,25,61,131,242,377,492,538,492,377,242,131,61,25,11,6],peak:[5,16,30,44,55,67,81,95,108,123,140,156,169,183],max:507},index:1,counter:1,measureText:74},{id:"R1-0000-2345",fill:"rgb(255,255,102)",outline:"rgb(0,0,0)",dir:"right",offset:6,gaps:[[3,1],[10,1]],sequence:"ACGACGTACGACG",coordinate:80,trace:{A:[49,110,206,323,424,463,424,323,206,110,49,3,5,12,24,45,69,90,98,90,69,45,24,12,5,3,5,7,14,28,49,75,97,105,97,75,49,28,14,7,5,5,10,25,61,132,245,382,499,545,499,382,245,132,61,25,10,5,7,13,27,48,74,96,105,96,74,48,27,13,7,4,6,13,25,46,70,91,100,91,70,46,25,13,6,4,4,7,14,27,49,76,99,108,99,76,49,27,14,7,4,3,8,22,57,125,234,366,479,524,479,366,234,125,57,22,8,3,5,8,15,30,52,80,104,113,104,80,52,30,15,8,5,7,13,25,44,66,86,94,86,66,44,25,13,7,23,58,127,236,368,482,527,482,368,236,127,58,23,3,4,6,13,26,47,73,95,104,95,73,47,26,13,6,4,3,5,6,9,16,30,52,79,102,111,102,79,52,30,16,9,6,5],C:[5,12,21,33,43,47,43,33,21,12,5,7,21,53,117,218,341,447,488,447,341,218,117,53,21,7,4,5,9,15,26,38,49,53,49,38,26,15,9,5,4,4,4,6,9,16,27,40,51,56,51,40,27,16,9,6,4,4,20,50,109,203,317,415,453,415,317,203,109,50,20,3,4,8,14,25,37,48,52,48,37,25,14,8,4,3,3,4,8,14,24,36,46,50,46,36,24,14,8,4,3,2,2,3,6,13,22,34,44,48,44,34,22,13,6,3,2,2,9,23,55,118,219,342,447,489,447,342,219,118,55,23,9,5,9,16,26,39,50,54,50,39,26,16,9,5,4,8,14,25,37,48,52,48,37,25,14,8,4,4,9,22,55,120,224,349,457,500,457,349,224,120,55,22,9,4,5,5,7,10,17,27,40,51,56,51,40,27,17,10,7,5,5],G:[3,6,11,17,22,24,22,17,11,6,3,2,2,4,7,12,17,22,24,22,17,12,7,4,2,2,10,24,59,129,239,373,487,533,487,373,239,129,59,24,10,4,4,4,6,9,14,20,25,27,25,20,14,9,6,4,4,4,3,5,8,13,19,24,26,24,19,13,8,5,3,9,23,59,129,239,374,489,534,489,374,239,129,59,23,9,3,3,5,8,13,18,23,25,23,18,13,8,5,3,3,2,2,2,4,7,12,17,22,24,22,17,12,7,4,2,2,2,4,4,6,9,14,19,24,26,24,19,14,9,6,4,4,22,52,113,209,325,425,465,425,325,209,113,52,22,3,5,8,13,19,24,26,24,19,13,8,5,3,3,3,3,5,8,14,20,26,28,26,20,14,8,5,3,3,3,6,11,26,62,133,246,383,501,547,501,383,246,133,62,26,11,6],T:[2,3,5,7,10,10,10,7,5,3,2,2,2,2,4,6,8,10,11,10,8,6,4,2,2,2,4,4,4,6,8,10,12,13,12,10,8,6,4,4,4,4,4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,4,3,4,5,7,10,12,13,12,10,7,5,4,3,3,3,3,5,7,9,11,12,11,9,7,5,3,3,3,8,21,52,115,213,333,436,476,436,333,213,115,52,21,8,2,2,2,3,4,6,8,10,11,10,8,6,4,3,2,2,2,4,4,4,6,8,10,12,13,12,10,8,6,4,4,4,4,4,6,8,10,12,13,12,10,8,6,4,4,3,4,5,7,9,11,12,11,9,7,5,4,3,3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,3,5,5,5,6,7,9,11,14,14,14,11,9,7,6,5,5,5],peak:[5,18,33,49,64,78,93,109,125,139,152,167,184],max:501},index:2,counter:2,measureText:74},{id:"R1-0000-3456",fill:"rgb(255,51,255)",outline:"rgb(0,0,0)",dir:"left",offsetLeft:"23",gaps:[[7,2]],sequence:"GTACGTATAC",coordinate:150,trace:{A:[4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,2,2,3,4,6,8,10,11,10,8,6,4,3,2,2,8,20,50,110,205,320,418,457,418,320,205,110,50,20,8,5,5,5,7,9,11,13,14,13,11,9,7,5,5,5,8,23,59,130,243,380,498,545,498,380,243,130,59,23,8,1,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,1,4,5,7,10,12,13,12,10,7,5,4,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,10,23,57,124,230,358,468,512,468,358,230,124,57,23,10,1,1,3,5,7,9,10,9,7,5,3,1,1],C:[4,4,6,10,15,21,27,29,27,21,15,10,6,4,4,2,3,4,8,14,21,26,29,26,21,14,8,4,3,2,3,3,5,8,13,19,24,26,24,19,13,8,5,3,3,5,6,7,11,17,24,30,32,30,24,17,11,7,6,5,2,2,4,7,13,19,24,26,24,19,13,7,4,2,2,2,7,21,56,126,236,370,485,531,485,370,236,126,56,21,7,2,5,8,13,19,24,26,24,19,13,8,5,5,6,7,11,16,23,29,31,29,23,16,11,7,6,5,4,4,6,9,14,21,26,28,26,21,14,9,6,4,4,21,54,122,228,357,467,511,467,357,228,122,54,21],G:[10,24,57,125,231,360,470,514,470,360,231,125,57,24,10,2,3,7,13,23,35,46,50,46,35,23,13,7,3,2,3,5,8,15,26,39,51,55,51,39,26,15,8,5,3,5,6,9,15,25,36,46,50,46,36,25,15,9,6,5,2,3,6,13,22,34,44,48,44,34,22,13,6,3,2,1,1,2,6,12,22,34,44,48,44,34,22,12,6,2,1,1,59,130,242,377,494,540,494,377,242,130,59,5,7,10,17,28,41,53,57,53,41,28,17,10,7,5,4,5,8,14,24,35,45,49,45,35,24,14,8,5,4,2,6,13,23,36,47,51,47,36,23,13,6,2],T:[5,8,15,28,50,76,99,108,99,76,50,28,15,8,5,7,19,50,110,206,322,421,460,421,322,206,110,50,19,7,4,7,13,27,49,75,98,107,98,75,49,27,13,7,4,11,24,58,124,228,355,464,507,464,355,228,124,58,24,11,3,6,13,26,48,75,98,107,98,75,48,26,13,6,3,1,2,4,11,24,44,69,90,99,90,69,44,24,11,4,2,1,13,25,45,69,89,97,89,69,45,25,13,11,24,58,124,228,356,465,508,465,356,228,124,58,24,11,5,8,15,29,51,79,102,111,102,79,51,29,15,8,5,4,10,22,41,64,84,92,84,64,41,22,10,4],peak:[8,23,38,53,68,84,98,111,126,140],reversed:true,max:511},index:3,counter:3,offset:12,measureText:74},{id:"R1-0000-4567",fill:"rgb(255,102,255)",outline:"rgb(0,0,0)",dir:"right",offset:15,gaps:[[5,1]],sequence:"CGTACTACGTA",coordinate:20,trace:{A:[9,16,29,51,78,100,110,100,78,51,29,16,9,15,28,50,77,100,109,100,77,50,28,15,4,5,7,13,25,44,67,86,94,86,67,44,25,13,7,5,4,4,8,21,53,115,214,335,438,479,438,335,214,115,53,21,8,4,2,3,5,11,23,42,65,85,93,85,65,42,23,11,5,3,2,8,15,29,52,80,103,113,103,80,52,29,15,8,4,9,23,57,126,233,365,477,522,477,365,233,126,57,23,9,4,2,4,10,23,42,66,87,95,87,66,42,23,10,4,2,3,5,12,25,46,71,93,101,93,71,46,25,12,5,3,4,5,8,14,28,50,76,99,108,99,76,50,28,14,8,5,4,19,49,108,202,316,413,452,413,316,202,108,49,19],C:[24,56,121,223,348,454,496,454,348,223,121,56,24,8,14,24,36,46,50,46,36,24,14,8,4,4,5,8,15,24,36,46,50,46,36,24,15,8,5,4,4,3,3,4,8,14,25,38,48,53,48,38,25,14,8,4,3,3,3,8,21,54,119,222,348,455,498,455,348,222,119,54,21,8,3,5,9,15,25,38,48,52,48,38,25,15,9,5,3,3,5,8,15,26,39,51,55,51,39,26,15,8,5,3,3,6,18,48,107,201,315,412,451,412,315,201,107,48,18,6,2,3,6,12,22,33,43,47,43,33,22,12,6,3,2,4,4,6,9,16,28,42,54,58,54,42,28,16,9,6,4,4,3,7,13,24,37,47,52,47,37,24,13,7,3],G:[6,7,11,16,23,29,31,29,23,16,11,7,6,56,121,223,348,455,498,455,348,223,121,56,4,4,5,6,10,16,23,28,31,28,23,16,10,6,5,4,4,3,3,4,5,9,14,21,26,29,26,21,14,9,5,4,3,3,2,2,2,4,7,12,18,24,26,24,18,12,7,4,2,2,2,4,6,9,14,19,24,26,24,19,14,9,6,4,3,3,3,5,8,13,19,24,26,24,19,13,8,5,3,3,3,1,2,3,7,12,19,24,27,24,19,12,7,3,2,1,7,20,51,113,211,330,432,473,432,330,211,113,51,20,7,4,4,4,6,9,15,21,26,29,26,21,15,9,6,4,4,4,3,4,8,13,20,26,28,26,20,13,8,4,3],T:[5,6,7,9,11,13,14,13,11,9,7,6,5,4,6,8,10,12,13,12,10,8,6,4,5,10,24,60,130,241,376,492,538,492,376,241,130,60,24,10,5,3,3,3,3,5,7,9,11,12,11,9,7,5,3,3,3,3,2,2,2,2,4,6,8,10,11,10,8,6,4,2,2,2,2,22,53,114,211,328,429,469,429,328,211,114,53,22,3,3,3,3,5,7,9,11,12,11,9,7,5,3,3,3,3,1,1,2,3,5,7,9,10,9,7,5,3,2,1,1,2,2,2,4,6,8,10,11,10,8,6,4,2,2,2,5,10,24,58,127,235,366,479,524,479,366,235,127,58,24,10,5,2,3,4,6,8,10,11,10,8,6,4,3,2],peak:[6,18,32,49,66,81,96,112,127,143,158],max:492},index:4,counter:4,measureText:74},{id:"R1-0000-5678",fill:"rgb(51,255,255)",outline:"rgb(0,0,0)",dir:"right",offset:18,gaps:[[7,1]],sequence:"ACGTACGACGT",coordinate:120,trace:{A:[10,25,60,131,244,380,497,544,497,380,244,131,60,25,10,5,6,8,15,28,48,73,95,103,95,73,48,28,15,8,6,5,4,6,13,26,47,72,94,102,94,72,47,26,13,6,4,6,8,15,28,49,74,95,104,95,74,49,28,15,8,6,2,7,22,58,129,243,380,498,545,498,380,243,129,58,22,7,2,11,23,43,66,86,94,86,66,43,23,11,5,8,15,28,50,77,100,109,100,77,50,28,15,8,5,6,11,24,58,125,232,361,471,515,471,361,232,125,58,24,11,6,12,24,43,66,85,93,85,66,43,24,12,14,28,50,76,99,108,99,76,50,28,14,5,7,14,27,47,72,93,101,93,72,47,27,14,7,5],C:[4,5,8,15,24,36,46,50,46,36,24,15,8,5,4,6,11,26,62,135,249,388,506,554,506,388,249,135,62,26,11,6,3,5,8,15,25,38,49,54,49,38,25,15,8,5,3,5,6,9,15,25,36,46,50,46,36,25,15,9,6,5,1,1,3,6,13,24,37,49,53,49,37,24,13,6,3,1,1,53,117,219,342,447,489,447,342,219,117,53,4,5,8,15,25,36,47,51,47,36,25,15,8,5,4,5,5,7,10,17,28,41,53,57,53,41,28,17,10,7,5,5,57,124,231,360,471,516,471,360,231,124,57,9,16,27,40,51,55,51,40,27,16,9,4,6,9,16,27,41,52,57,52,41,27,16,9,6,4],G:[4,5,6,10,16,22,28,31,28,22,16,10,6,5,4,5,5,5,7,10,15,21,26,28,26,21,15,10,7,5,5,5,8,21,53,116,216,337,440,482,440,337,216,116,53,21,8,5,6,7,11,17,23,29,32,29,23,17,11,7,6,5,1,1,1,3,6,11,17,22,24,22,17,11,6,3,1,1,1,4,8,13,20,25,27,25,20,13,8,4,9,21,52,111,206,321,420,459,420,321,206,111,52,21,9,5,5,5,7,10,16,22,27,30,27,22,16,10,7,5,5,5,5,8,14,20,25,27,25,20,14,8,5,57,124,230,358,468,512,468,358,230,124,57,4,4,6,9,14,20,25,28,25,20,14,9,6,4,4],T:[4,4,5,6,8,11,14,14,14,11,8,6,5,4,4,5,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,5,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,11,24,57,122,224,349,456,498,456,349,224,122,57,24,11,1,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,1,3,4,6,8,11,11,11,8,6,4,3,4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,5,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,5,4,5,7,10,12,13,12,10,7,5,4,4,6,8,10,12,13,12,10,8,6,4,10,25,60,131,242,378,494,540,494,378,242,131,60,25,10],peak:[7,23,39,54,70,84,97,113,127,138,151],max:512},index:5,counter:5,measureText:74}]}]};this.dataSetGenomeAdvanced={tracks:[{name:"Affymetrix Probes",type:"box",connect:true,data:[{id:"123456_at",fill:"rgb(255,255,51)",outline:"rgb(0,0,0)",dir:"right",data:[[10,20],[30,40],[50,60],[70,80],[90,100],[110,120]],sequences:["GTTTTACGTAC","TACGTACGTAC","GGTTTACGTAC","GGTTTACGTAC","GGTTTACGTAC","GGTTTACGTAC"],index:0,counter:0,start:10,end:120,measureText:56},{id:"234567_at",fill:"rgb(255,255,51)",outline:"rgb(0,0,0)",dir:"left",data:[[50,60],[70,80],[90,100],[110,120],[130,140],[150,160]],index:1,counter:1,start:50,end:160,measureText:56},{id:"345678_at",fill:"rgb(255,255,51)",outline:"rgb(0,0,0)",dir:"right",data:[[100,110],[120,130],[140,150],[160,170],[180,190]],index:2,counter:2,start:100,end:190,measureText:56}],startY:50,endY:82,displayedFeatures:3,totalFeatures:3},{name:"Sanger Sequencing (Multiple sequeneces)",highlight:[{offset:80,width:1,color:"rgb(120,120,180)"},{offset:185,width:1,color:"rgb(180,20,180)"}],subtype:"DNA",type:"sequence",data:[{id:"Reference Sequence",fill:"rgb(51,255,255)",outline:"rgb(0,0,0)",dir:"right",offset:1,sequence:"AAAACCCGGGTTTTACGTACGTACGTACGTACGTACGTACGTAAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAAACCCGGGTTTAAACC",translate:[-3,-2,-1,1,2,3],index:0,counter:3,measureText:108},{id:"R1-0000-1234",fill:"rgb(255,255,51)",outline:"rgb(0,0,0)",dir:"right",offset:1,gaps:[[18,1],[22,1]],sequence:"AAAACCCGGGTTTTACGTCGTAGTACGTACGTACGTACGTAAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAA",coordinate:50,trace:{A:[57,127,237,371,486,531,486,371,237,127,57,54,117,217,339,442,484,442,339,217,117,54,10,24,60,130,240,375,490,535,490,375,240,130,60,24,10,56,121,222,346,452,494,452,346,222,121,56,7,14,27,48,74,95,104,95,74,48,27,14,7,6,8,14,27,46,69,90,98,90,69,46,27,14,8,6,4,5,7,14,27,47,72,93,101,93,72,47,27,14,7,5,4,5,11,23,42,65,85,92,85,65,42,23,11,5,7,14,27,48,74,95,104,95,74,48,27,14,7,1,2,4,10,22,42,65,85,93,85,65,42,22,10,4,2,1,5,12,24,44,68,88,97,88,68,44,24,12,5,4,5,7,14,27,47,72,94,102,94,72,47,27,14,7,5,4,2,4,10,22,41,64,83,91,83,64,41,22,10,4,2,12,24,43,67,87,95,87,67,43,24,12,21,52,113,210,328,429,469,429,328,210,113,52,21,4,6,13,26,47,72,93,102,93,72,47,26,13,6,4,4,6,13,26,46,71,92,100,92,71,46,26,13,6,4,6,8,14,27,46,69,89,97,89,69,46,27,14,8,6,4,5,8,14,28,49,76,98,107,98,76,49,28,14,8,5,4,7,13,25,45,68,88,96,88,68,45,25,13,7,5,11,24,43,67,88,96,88,67,43,24,11,5,22,54,118,219,342,447,489,447,342,219,118,54,22,5,12,25,46,71,93,102,93,71,46,25,12,5,5,12,24,44,68,89,97,89,68,44,24,12,5,20,54,121,226,355,465,508,465,355,226,121,54,20,3,4,6,13,25,45,70,91,99,91,70,45,25,13,6,4,3,6,8,15,27,47,71,91,99,91,71,47,27,15,8,6,1,2,4,11,24,44,69,90,98,90,69,44,24,11,4,2,1,6,11,25,60,128,237,369,482,527,482,369,237,128,60,25,11,6,2,5,12,25,47,74,97,106,97,74,47,25,12,5,2,5,8,15,29,51,78,101,110,101,78,51,29,15,8,5,5,12,26,48,75,98,107,98,75,48,26,12,5,6,18,48,107,201,315,412,451,412,315,201,107,48,18,6,9,16,31,53,81,105,114,105,81,53,31,16,9,6,8,15,28,48,73,94,103,94,73,48,28,15,8,6,11,23,42,65,85,92,85,65,42,23,11,19,51,113,212,332,434,475,434,332,212,113,51,19,8,15,28,49,74,95,104,95,74,49,28,15,8,12,26,49,76,99,109,99,76,49,26,12,12,24,43,67,86,94,86,67,43,24,12,22,54,118,218,341,445,487,445,341,218,118,54,22,21,52,112,208,324,423,462,423,324,208,112,52,21,10,23,54,115,212,330,430,471,430,330,212,115,54,23,10,2,3,5,12,25,45,69,91,99,91,69,45,25,12,5,3,2,2,3,5,12,24,44,68,88,97,88,68,44,24,12,5,3,2,8,15,28,50,77,100,109,100,77,50,28,15,8,12,26,48,74,96,105,96,74,48,26,12,13,27,48,74,96,105,96,74,48,27,13,13,25,45,70,91,99,91,70,45,25,13,7,14,28,49,75,97,105,97,75,49,28,14,7,2,5,12,26,48,74,97,106,97,74,48,26,12,5,2,16,30,53,80,103,113,103,80,53,30,16,25,61,133,246,384,501,548,501,384,246,133,61,25,6,13,25,45,69,90,98,90,69,45,25,13,6,5,6,9,15,29,50,77,99,108,99,77,50,29,15,9,6,5,10,23,42,65,86,94,86,65,42,23,10,9,23,55,120,223,348,454,497,454,348,223,120,55,23,9,2,4,11,23,43,67,88,96,88,67,43,23,11,4,2,2,3,6,12,26,48,74,96,105,96,74,48,26,12,6,3,2,15,28,49,74,96,104,96,74,49,28,15,22,55,120,223,348,455,498,455,348,223,120,55,22,22,53,115,213,332,434,474,434,332,213,115,53,22,7,20,53,118,221,346,454,496,454,346,221,118,53,20,7,2,3,5,11,24,44,67,88,96,88,67,44,24,11,5,3,2,15,28,50,75,97,106,97,75,50,28,15,1,2,5,12,25,47,74,96,105,96,74,47,25,12,5,2,1,6,8,15,28,49,74,96,104,96,74,49,28,15,8,6,5,12,26,47,72,94,103,94,72,47,26,12,5,8,15,27,47,71,92,100,92,71,47,27,15,8,3,5,11,23,42,65,84,92,84,65,42,23,11,5,3,5,12,25,45,70,91,100,91,70,45,25,12,5,1,2,4,10,22,41,64,84,92,84,64,41,22,10,4,2,1,7,20,51,113,212,331,433,474,433,331,212,113,51,20,7,2,3,5,12,25,46,72,94,102,94,72,46,25,12,5,3,2,2,4,11,25,46,72,94,102,94,72,46,25,11,4,2,2,3,6,12,26,48,74,97,106,97,74,48,26,12,6,3,2,10,25,61,133,247,386,504,551,504,386,247,133,61,25,10,15,27,47,71,92,100,92,71,47,27,15,5,8,15,28,50,76,99,108,99,76,50,28,15,8,5,2,3,6,13,26,48,75,98,107,98,75,48,26,13,6,3,2,8,22,57,127,238,372,487,532,487,372,238,127,57,22,8,60,129,237,370,483,528,483,370,237,129,60],C:[6,13,23,34,45,49,45,34,23,13,6,9,16,28,41,53,58,53,41,28,16,9,4,5,9,15,26,39,49,54,49,39,26,15,9,5,4,10,17,28,41,52,57,52,41,28,17,10,21,51,111,206,321,419,459,419,321,206,111,51,21,11,26,62,134,248,387,505,552,505,387,248,134,62,26,11,5,10,24,58,126,233,364,475,520,475,364,233,126,58,24,10,5,3,7,13,23,35,46,50,46,35,23,13,7,3,6,9,16,27,41,52,57,52,41,27,16,9,6,1,1,3,6,13,24,38,49,54,49,38,24,13,6,3,1,1,3,6,13,22,34,45,49,45,34,22,13,6,3,4,4,5,8,14,24,36,46,50,46,36,24,14,8,5,4,4,1,2,6,12,23,36,47,51,47,36,23,12,6,2,1,7,13,23,34,44,48,44,34,23,13,7,5,8,15,27,41,52,57,52,41,27,15,8,5,8,21,52,113,211,329,431,471,431,329,211,113,52,21,8,3,4,8,14,24,37,47,51,47,37,24,14,8,4,3,5,6,10,16,27,39,50,54,50,39,27,16,10,6,5,5,9,22,52,114,210,328,428,468,428,328,210,114,52,22,9,5,6,9,16,27,41,53,57,53,41,27,16,9,6,3,7,13,24,36,47,51,47,36,24,13,7,3,4,8,15,25,38,49,54,49,38,25,15,8,4,4,7,14,25,38,49,54,49,38,25,14,7,4,3,7,14,24,37,48,52,48,37,24,14,7,3,2,6,13,23,36,47,51,47,36,23,13,6,2,4,8,21,52,114,212,331,433,474,433,331,212,114,52,21,8,4,5,6,10,16,27,39,50,54,50,39,27,16,10,6,5,1,1,3,6,13,24,38,49,54,49,38,24,13,6,3,1,1,5,5,7,10,17,29,43,54,59,54,43,29,17,10,7,5,5,6,18,49,109,203,319,417,457,417,319,203,109,49,18,6,4,6,9,16,27,41,52,57,52,41,27,16,9,6,4,2,5,12,21,33,43,47,43,33,21,12,5,2,1,2,6,12,22,34,45,49,45,34,22,12,6,2,1,25,61,131,242,376,492,538,492,376,242,131,61,25,5,6,9,15,25,36,46,50,46,36,25,15,9,6,5,7,14,26,39,51,56,51,39,26,14,7,3,6,13,24,38,50,54,50,38,24,13,6,3,24,56,121,224,348,454,497,454,348,224,121,56,24,6,12,22,35,45,49,45,35,22,12,6,8,14,24,36,47,51,47,36,24,14,8,5,9,15,25,38,48,53,48,38,25,15,9,5,5,9,15,25,37,47,51,47,37,25,15,9,5,5,7,10,17,29,42,54,59,54,42,29,17,10,7,5,3,7,20,52,116,217,339,443,485,443,339,217,116,52,20,7,3,3,8,22,55,123,229,358,469,513,469,358,229,123,55,22,8,3,22,52,114,210,328,428,468,428,328,210,114,52,22,7,14,25,38,49,54,49,38,25,14,7,7,13,23,35,45,49,45,35,23,13,7,8,14,24,36,47,51,47,36,24,14,8,6,9,16,27,41,52,57,52,41,27,16,9,6,1,2,6,12,22,34,45,49,45,34,22,12,6,2,1,10,16,26,39,49,54,49,39,26,16,10,5,8,14,24,36,46,49,46,36,24,14,8,5,22,54,119,222,346,453,495,453,346,222,119,54,22,5,5,6,10,16,26,38,49,53,49,38,26,16,10,6,5,5,6,13,24,37,48,53,48,37,24,13,6,4,5,9,15,26,38,49,53,49,38,26,15,9,5,4,7,20,53,119,223,349,457,500,457,349,223,119,53,20,7,2,2,4,7,14,25,38,50,54,50,38,25,14,7,4,2,2,10,16,27,39,50,55,50,39,27,16,10,5,8,15,27,41,52,57,52,41,27,15,8,5,6,9,16,27,40,51,56,51,40,27,16,9,6,1,2,6,12,22,35,45,49,45,35,22,12,6,2,1,3,8,22,56,124,232,362,474,519,474,362,232,124,56,22,8,3,56,120,221,345,450,492,450,345,221,120,56,2,7,21,55,122,229,358,469,513,469,358,229,122,55,21,7,2,5,7,10,17,27,40,51,56,51,40,27,17,10,7,5,3,7,13,23,35,45,50,45,35,23,13,7,3,6,9,15,25,36,46,50,46,36,25,15,9,6,2,3,7,13,24,37,48,52,48,37,24,13,7,3,2,4,7,14,25,39,50,55,50,39,25,14,7,4,1,1,2,6,12,22,34,44,49,44,34,22,12,6,2,1,1,2,3,7,13,23,35,46,50,46,35,23,13,7,3,2,3,8,23,58,129,240,376,492,539,492,376,240,129,58,23,8,3,1,2,6,13,23,36,47,51,47,36,23,13,6,2,1,2,2,3,6,12,22,34,44,48,44,34,22,12,6,3,2,2,4,5,8,14,24,36,46,50,46,36,24,14,8,5,4,57,122,225,350,457,500,457,350,225,122,57,4,6,9,16,27,41,52,57,52,41,27,16,9,6,4,2,2,3,6,13,22,34,45,49,45,34,22,13,6,3,2,2,2,3,7,13,24,36,47,51,47,36,24,13,7,3,2,10,16,26,38,48,52,48,38,26,16,10],G:[4,8,14,20,26,29,26,20,14,8,4,6,9,14,20,26,28,26,20,14,9,6,4,5,6,10,15,22,27,29,27,22,15,10,6,5,4,7,10,15,20,25,27,25,20,15,10,7,4,6,9,14,20,25,27,25,20,14,9,6,4,5,5,7,10,16,22,27,30,27,22,16,10,7,5,5,4,4,5,6,10,15,22,28,30,28,22,15,10,6,5,4,4,22,57,127,237,370,485,530,485,370,237,127,57,22,24,60,130,242,377,493,539,493,377,242,130,60,24,2,7,21,55,123,230,361,472,517,472,361,230,123,55,21,7,2,2,4,7,12,18,23,25,23,18,12,7,4,2,4,4,4,6,9,14,20,25,27,25,20,14,9,6,4,4,4,1,2,3,7,12,19,25,27,25,19,12,7,3,2,1,5,8,13,19,24,26,24,19,13,8,5,3,5,8,13,19,24,26,24,19,13,8,5,3,3,3,5,8,14,20,25,28,25,20,14,8,5,3,3,9,22,55,120,224,349,457,499,457,349,224,120,55,22,9,5,6,7,11,17,24,30,32,30,24,17,11,7,6,5,4,4,4,6,9,14,20,25,27,25,20,14,9,6,4,4,4,22,54,116,215,335,438,479,438,335,215,116,54,22,2,4,7,12,18,23,25,23,18,12,7,4,2,3,5,8,14,20,25,27,25,20,14,8,5,3,22,57,127,237,371,485,530,485,371,237,127,57,22,3,4,8,13,20,26,28,26,20,13,8,4,3,2,3,7,12,18,24,26,24,18,12,7,3,2,3,3,3,5,8,13,20,25,27,25,20,13,8,5,3,3,3,11,25,59,127,234,364,476,520,476,364,234,127,59,25,11,1,1,1,3,6,11,17,22,24,22,17,11,6,3,1,1,1,5,5,5,7,11,16,22,28,30,28,22,16,11,7,5,5,5,1,1,3,6,11,17,22,24,22,17,11,6,3,1,1,10,23,56,121,223,348,455,498,455,348,223,121,56,23,10,1,3,6,12,18,23,25,23,18,12,6,3,1,1,1,3,6,11,16,21,23,21,16,11,6,3,1,1,5,7,10,15,21,26,28,26,21,15,10,7,5,11,25,61,131,243,378,494,540,494,378,243,131,61,25,11,4,8,14,20,26,29,26,20,14,8,4,1,3,6,11,16,21,23,21,16,11,6,3,1,5,7,10,15,20,25,27,25,20,15,10,7,5,50,112,211,330,432,473,432,330,211,112,50,5,8,13,20,25,27,25,20,13,8,5,5,6,10,16,22,28,31,28,22,16,10,6,5,4,6,9,14,19,24,26,24,19,14,9,6,4,5,5,7,11,16,22,28,30,28,22,16,11,7,5,5,2,2,2,4,7,12,17,22,24,22,17,12,7,4,2,2,2,2,2,3,4,8,13,20,25,27,25,20,13,8,4,3,2,2,5,6,10,15,22,28,30,28,22,15,10,6,5,59,130,243,381,498,545,498,381,243,130,59,54,118,218,341,446,488,446,341,218,118,54,57,126,234,365,477,522,477,365,234,126,57,4,6,9,14,21,26,28,26,21,14,9,6,4,1,1,3,6,11,17,22,24,22,17,11,6,3,1,1,7,10,15,21,26,28,26,21,15,10,7,4,6,10,15,21,27,29,27,21,15,10,6,4,4,5,9,14,21,27,29,27,21,14,9,5,4,6,10,24,56,121,223,347,453,495,453,347,223,121,56,24,10,6,3,6,12,18,23,25,23,18,12,6,3,4,4,6,9,14,20,25,27,25,20,14,9,6,4,4,1,2,3,7,12,18,24,26,24,18,12,7,3,2,1,3,8,23,59,131,244,382,500,547,500,382,244,131,59,23,8,3,7,11,16,22,28,30,28,22,16,11,7,3,5,8,13,19,24,27,24,19,13,8,5,3,5,6,10,15,21,27,29,27,21,15,10,6,5,1,2,3,7,13,20,25,28,25,20,13,7,3,2,1,2,2,2,4,7,12,18,23,25,23,18,12,7,4,2,2,2,7,10,16,22,27,30,27,22,16,10,7,1,1,1,3,6,11,17,22,24,22,17,11,6,3,1,1,1,11,24,57,122,225,350,457,500,457,350,225,122,57,24,11,23,58,129,241,377,494,540,494,377,241,129,58,23,26,62,133,246,384,501,548,501,384,246,133,62,26,2,2,4,7,12,18,23,25,23,18,12,7,4,2,2,2,4,7,12,18,23,25,23,18,12,7,4,2,1,1,1,3,6,11,17,22,24,22,17,11,6,3,1,1,1,2,2,4,7,12,18,23,25,23,18,12,7,4,2,2,2,2,2,4,8,13,19,25,27,25,19,13,8,4,2,2,2,7,20,54,120,224,351,460,503,460,351,224,120,54,20,7,2,2,3,4,8,13,20,26,28,26,20,13,8,4,3,2,2,4,5,6,10,16,22,28,31,28,22,16,10,6,5,4,7,10,16,22,27,29,27,22,16,10,7,10,23,57,124,230,359,469,513,469,359,230,124,57,23,10,2,2,3,4,8,14,21,27,29,27,21,14,8,4,3,2,2,2,2,4,7,12,19,24,26,24,19,12,7,4,2,2,7,11,17,24,29,32,29,24,17,11,7],T:[3,4,6,8,10,11,10,8,6,4,3,5,6,8,11,13,14,13,11,8,6,5,4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,5,7,9,11,13,14,13,11,9,7,5,4,5,6,8,11,13,14,13,11,8,6,5,4,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,4,4,4,5,6,8,10,13,14,13,10,8,6,5,4,4,4,2,3,4,6,8,11,11,11,8,6,4,3,2,4,5,6,8,10,12,13,12,10,8,6,5,4,1,1,1,2,3,5,7,9,10,9,7,5,3,2,1,1,1,23,59,131,244,382,501,548,501,382,244,131,59,23,5,10,24,59,129,239,373,488,534,488,373,239,129,59,24,10,5,6,19,50,112,210,329,431,472,431,329,210,112,50,19,6,54,118,219,342,447,488,447,342,219,118,54,3,4,5,7,9,11,12,11,9,7,5,4,3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,10,23,54,115,213,331,433,473,433,331,213,115,54,23,10,4,4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,4,4,4,6,8,10,12,13,12,10,8,6,4,4,21,54,119,223,348,456,498,456,348,223,119,54,21,3,3,5,7,9,11,12,11,9,7,5,3,3,2,3,4,6,8,11,12,11,8,6,4,3,2,23,58,129,242,378,495,541,495,378,242,129,58,23,1,2,3,5,8,10,11,10,8,5,3,2,1,3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,3,5,5,5,7,9,11,13,14,13,11,9,7,5,5,5,2,6,19,51,113,212,332,435,476,435,332,212,113,51,19,6,2,5,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,5,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,4,4,4,6,8,10,12,13,12,10,8,6,4,4,4,20,53,119,222,349,456,499,456,349,222,119,53,20,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,5,6,7,9,12,15,15,15,12,9,7,6,5,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,57,126,235,367,481,526,481,367,235,126,57,1,2,3,5,8,10,11,10,8,5,3,2,1,5,6,7,9,12,14,15,14,12,9,7,6,5,2,3,5,7,9,10,9,7,5,3,2,58,128,237,371,485,530,485,371,237,128,58,4,4,6,8,10,12,13,12,10,8,6,4,4,4,4,6,8,10,12,13,12,10,8,6,4,4,5,5,6,7,9,11,14,15,14,11,9,7,6,5,5,2,2,2,2,4,6,8,10,11,10,8,6,4,2,2,2,2,2,2,2,3,4,6,9,11,12,11,9,6,4,3,2,2,2,4,5,6,8,11,13,14,13,11,8,6,5,4,2,4,6,8,10,11,10,8,6,4,2,4,5,7,9,12,12,12,9,7,5,4,4,5,7,10,12,13,12,10,7,5,4,23,55,119,221,345,451,493,451,345,221,119,55,23,7,22,58,130,243,381,499,546,499,381,243,130,58,22,7,61,133,245,381,498,545,498,381,245,133,61,4,4,6,8,10,12,13,12,10,8,6,4,4,3,4,5,7,10,12,13,12,10,7,5,4,3,5,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,5,50,111,207,325,426,466,426,325,207,111,50,4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,2,2,2,2,4,6,8,10,11,10,8,6,4,2,2,2,2,56,119,220,342,447,489,447,342,220,119,56,3,4,5,7,9,11,12,11,9,7,5,4,3,4,5,6,8,11,14,14,14,11,8,6,5,4,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,2,2,2,3,4,6,8,10,11,10,8,6,4,3,2,2,2,5,7,9,11,13,14,13,11,9,7,5,1,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,1,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,2,2,4,6,8,10,11,10,8,6,4,2,2,5,6,7,9,12,14,15,14,12,9,7,6,5,7,21,53,117,219,343,449,491,449,343,219,117,53,21,7,21,55,122,228,356,466,510,466,356,228,122,55,21,2,6,18,48,108,202,316,414,452,414,316,202,108,48,18,6,2,2,2,2,4,6,8,10,11,10,8,6,4,2,2,2,2,2,2,3,4,6,8,10,11,10,8,6,4,3,2,2,2,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,3,8,23,59,132,246,385,504,551,504,385,246,132,59,23,8,3,4,4,5,6,8,10,12,13,12,10,8,6,5,4,4,6,7,9,11,13,14,13,11,9,7,6,4,4,5,6,8,10,12,13,12,10,8,6,5,4,4,3,7,21,53,117,219,343,448,491,448,343,219,117,53,21,7,3,2,2,2,4,6,8,10,11,10,8,6,4,2,2,2,5,7,9,11,13,14,13,11,9,7,5],peak:[5,16,29,42,54,68,84,99,112,127,142,157,173,186,198,212,227,242,258,273,286,299,312,325,338,353,369,385,402,418,433,447,461,475,489,502,514,527,539,550,562,575,589,605,622,637,649,660,671,683,697,710,722,735,750,764,777,792,808,822,834,847,861,877,891,905,921,935,948,962,976,991,1007,1023,1039,1055,1071,1084,1097,1113,1129,1142]},index:1,counter:4,measureText:74},{id:"R1-0000-2345",fill:"rgb(255,255,102)",outline:"rgb(0,0,0)",dir:"right",offset:31,gaps:[[9,1],[58,1]],sequence:"ACGTACGTAGTAAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAAACCCGGTTTACGTACGTAAACCCGGGTTTACGTAC",coordinate:10,trace:{A:[4,9,22,56,123,228,357,467,510,467,357,228,123,56,22,9,4,5,12,25,45,70,91,100,91,70,45,25,12,5,11,24,43,67,87,95,87,67,43,24,11,3,4,7,14,27,49,76,99,108,99,76,49,27,14,7,4,3,57,125,233,364,475,520,475,364,233,125,57,16,30,51,78,101,110,101,78,51,30,16,4,6,12,25,44,68,88,96,88,68,44,25,12,6,4,6,12,26,47,73,95,104,95,73,47,26,12,6,55,117,216,337,440,481,440,337,216,117,55,5,11,24,43,67,87,95,87,67,43,24,11,5,4,5,8,14,28,50,76,98,107,98,76,50,28,14,8,5,4,22,57,127,236,370,484,529,484,370,236,127,57,22,50,111,208,325,426,466,426,325,208,111,50,24,57,122,225,350,457,500,457,350,225,122,57,24,2,4,11,24,45,70,92,100,92,70,45,24,11,4,2,1,2,5,11,25,47,73,96,105,96,73,47,25,11,5,2,1,14,28,50,76,99,108,99,76,50,28,14,8,14,28,50,76,99,108,99,76,50,28,14,8,3,5,11,23,42,65,84,92,84,65,42,23,11,5,3,7,14,28,50,76,99,108,99,76,50,28,14,7,4,6,13,26,46,70,91,100,91,70,46,26,13,6,4,2,4,10,22,41,64,84,92,84,64,41,22,10,4,2,11,23,43,67,88,96,88,67,43,23,11,24,60,131,244,381,498,544,498,381,244,131,60,24,1,2,5,12,26,49,77,101,110,101,77,49,26,12,5,2,1,6,12,26,47,73,95,104,95,73,47,26,12,6,2,4,10,22,41,64,84,92,84,64,41,22,10,4,2,53,117,217,339,443,485,443,339,217,117,53,1,2,5,12,26,49,76,100,109,100,76,49,26,12,5,2,1,5,12,26,49,76,100,109,100,76,49,26,12,5,5,8,15,28,50,77,99,108,99,77,50,28,15,8,5,51,112,207,324,423,463,423,324,207,112,51,18,48,108,203,318,416,455,416,318,203,108,48,18,10,23,53,114,209,326,426,465,426,326,209,114,53,23,10,2,4,10,22,41,64,83,91,83,64,41,22,10,4,2,1,2,5,12,27,49,77,101,110,101,77,49,27,12,5,2,1,12,24,43,67,87,95,87,67,43,24,12,8,15,29,51,78,101,110,101,78,51,29,15,8,1,2,4,11,24,44,69,90,98,90,69,44,24,11,4,2,1,15,28,50,77,100,109,100,77,50,28,15,1,2,4,11,24,44,69,90,99,90,69,44,24,11,4,2,1,4,7,14,28,51,79,102,112,102,79,51,28,14,7,4,4,7,13,27,48,74,97,105,97,74,48,27,13,7,4,4,9,24,60,131,244,381,498,545,498,381,244,131,60,24,9,4,15,27,47,71,92,100,92,71,47,27,15,15,28,50,76,99,108,99,76,50,28,15,6,9,16,30,52,79,102,111,102,79,52,30,16,9,6,6,18,48,108,202,317,415,454,415,317,202,108,48,18,6,2,3,6,13,27,49,76,99,108,99,76,49,27,13,6,3,2,9,16,30,53,81,104,114,104,81,53,30,16,9,3,6,12,26,47,73,95,104,95,73,47,26,12,6,3,2,6,19,51,115,215,336,440,482,440,336,215,115,51,19,6,2,11,25,59,128,236,368,481,526,481,368,236,128,59,25,11,8,22,55,123,229,358,469,513,469,358,229,123,55,22,8,6,13,27,49,76,98,108,98,76,49,27,13,6,5,12,26,49,76,99,108,99,76,49,26,12,5,3,6,13,27,50,77,100,110,100,77,50,27,13,6,3,12,25,45,70,91,99,91,70,45,25,12,3,5,12,25,45,69,90,99,90,69,45,25,12,5,3,12,24,44,69,90,98,90,69,44,24,12,3,4,7,13,27,49,75,97,106,97,75,49,27,13,7,4,3,5,8,14,28,50,76,99,108,99,76,50,28,14,8,5,55,122,227,356,466,509,466,356,227,122,55,3,6,12,26,48,74,97,106,97,74,48,26,12,6,3,13,27,48,73,95,104,95,73,48,27,13,3,4,7,14,27,49,76,99,108,99,76,49,27,14,7,4,3,6,11,26,61,132,243,379,495,541,495,379,243,132,61,26,11,6,14,27,46,69,89,97,89,69,46,27,14,4,11,24,45,71,93,101,93,71,45,24,11,4,2,3,6,13,27,50,77,100,110,100,77,50,27,13,6,3,2,2,7,20,53,118,222,348,456,499,456,348,222,118,53,20,7,2,3,8,22,58,128,240,375,491,537,491,375,240,128,58,22,8,3,6,18,49,109,204,320,420,459,420,320,204,109,49,18,6,4,10,22,41,64,83,91,83,64,41,22,10,4,3,6,13,28,50,78,102,111,102,78,50,28,13,6,3,5,12,25,45,70,91,100,91,70,45,25,12,5,6,8,15,28,49,74,95,103,95,74,49,28,15,8,6,12,25,45,70,91,100,91,70,45,25,12,6,13,26,48,75,97,106,97,75,48,26,13,6,5,12,26,48,75,98,107,98,75,48,26,12,5,3,4,6,12,24,43,67,86,94,86,67,43,24,12,6,4,3,9,15,29,50,76,98,107,98,76,50,29,15,9,6,11,26,61,132,243,379,495,541,495,379,243,132,61,26,11,6,2,5,12,25,47,73,96,105,96,73,47,25,12,5,2,8,15,29,52,79,103,112,103,79,52,29,15,8,3,6,12,26,47,73,95,104,95,73,47,26,12,6,3,9,22,56,122,227,354,463,506,463,354,227,122,56,22,9,4,6,13,26,46,70,91,100,91,70,46,26,13,6,4],C:[3,3,5,8,15,26,40,51,56,51,40,26,15,8,5,3,3,22,57,126,234,367,480,525,480,367,234,126,57,22,6,12,22,33,43,47,43,33,22,12,6,3,3,4,8,14,24,36,46,50,46,36,24,14,8,4,3,3,7,13,23,34,44,48,44,34,23,13,7,52,112,206,321,419,458,419,321,206,112,52,3,4,8,14,24,37,47,52,47,37,24,14,8,4,3,3,7,14,24,37,48,52,48,37,24,14,7,3,10,17,29,42,54,58,54,42,29,17,10,3,7,13,23,35,45,49,45,35,23,13,7,3,4,4,5,9,16,26,39,50,54,50,39,26,16,9,5,4,4,4,7,14,25,38,49,53,49,38,25,14,7,4,7,14,25,39,51,55,51,39,25,14,7,7,10,17,27,41,52,56,52,41,27,17,10,7,6,19,50,112,210,329,430,471,430,329,210,112,50,19,6,2,6,18,49,109,204,320,419,459,419,320,204,109,49,18,6,2,55,121,224,351,458,501,458,351,224,121,55,5,9,15,25,37,48,52,48,37,25,15,9,5,2,3,7,13,23,36,47,51,47,36,23,13,7,3,2,4,7,13,23,34,44,48,44,34,23,13,7,4,3,5,8,15,27,41,53,57,53,41,27,15,8,5,3,1,2,6,12,23,35,46,50,46,35,23,12,6,2,1,6,12,23,35,46,50,46,35,23,12,6,4,8,14,24,37,47,51,47,37,24,14,8,4,2,7,21,55,124,232,363,475,520,475,363,232,124,55,21,7,2,4,7,14,25,38,50,54,50,38,25,14,7,4,1,2,6,12,23,35,46,51,46,35,23,12,6,2,1,7,13,23,35,45,49,45,35,23,13,7,2,7,22,57,128,239,375,491,537,491,375,239,128,57,22,7,2,3,6,13,25,38,50,55,50,38,25,13,6,3,4,5,9,15,26,38,49,53,49,38,26,15,9,5,4,8,14,25,37,48,52,48,37,25,14,8,2,6,12,22,35,45,50,45,35,22,12,6,2,5,7,10,17,29,42,54,59,54,42,29,17,10,7,5,6,19,50,111,209,327,428,469,428,327,209,111,50,19,6,2,7,21,56,126,236,370,484,530,484,370,236,126,56,21,7,2,55,120,223,349,456,499,456,349,223,120,55,5,9,15,25,38,49,53,49,38,25,15,9,5,1,1,2,5,12,22,34,44,48,44,34,22,12,5,2,1,1,9,15,25,37,47,51,47,37,25,15,9,1,1,3,6,13,25,39,51,55,51,39,25,13,6,3,1,1,3,5,8,15,27,41,53,57,53,41,27,15,8,5,3,3,4,8,14,24,37,47,52,47,37,24,14,8,4,3,3,3,4,7,14,24,35,46,50,46,35,24,14,7,4,3,3,61,131,241,376,491,537,491,376,241,131,61,9,15,25,38,48,52,48,38,25,15,9,5,7,10,17,28,41,53,58,53,41,28,17,10,7,5,1,2,5,12,21,33,43,47,43,33,21,12,5,2,1,3,7,20,50,112,208,326,426,466,426,326,208,112,50,20,7,3,7,10,17,29,42,54,59,54,42,29,17,10,7,2,3,7,13,23,35,45,49,45,35,23,13,7,3,2,1,1,3,6,13,24,37,48,53,48,37,24,13,6,3,1,1,5,6,9,16,25,37,47,51,47,37,25,16,9,6,5,2,3,7,13,24,36,47,52,47,36,24,13,7,3,2,23,59,130,243,380,498,544,498,380,243,130,59,23,22,58,131,245,384,503,550,503,384,245,131,58,22,7,20,52,114,213,333,435,476,435,333,213,114,52,20,7,6,12,22,33,43,47,43,33,22,12,6,2,4,7,14,25,38,49,53,49,38,25,14,7,4,2,7,14,25,39,50,55,50,39,25,14,7,3,3,4,8,14,24,36,46,50,46,36,24,14,8,4,3,3,4,5,9,15,26,38,49,53,49,38,26,15,9,5,4,7,14,26,39,51,56,51,39,26,14,7,7,19,49,108,202,316,413,452,413,316,202,108,49,19,7,8,15,25,38,49,53,49,38,25,15,8,3,3,5,8,15,26,40,52,56,52,40,26,15,8,5,3,3,5,5,6,10,16,26,38,49,53,49,38,26,16,10,6,5,5,58,124,229,356,465,509,465,356,229,124,58,3,6,13,25,38,50,55,50,38,25,13,6,3,2,2,4,7,14,24,37,48,53,48,37,24,14,7,4,2,2,1,1,3,6,13,24,37,48,53,48,37,24,13,6,3,1,1,2,2,3,7,13,24,36,47,51,47,36,24,13,7,3,2,2,1,2,5,11,21,33,43,47,43,33,21,11,5,2,1,21,55,123,231,361,473,518,473,361,231,123,55,21,7,19,50,109,204,319,418,457,418,319,204,109,50,19,7,22,57,125,234,366,479,524,479,366,234,125,57,22,5,7,10,17,28,41,52,57,52,41,28,17,10,7,5,6,13,22,34,45,49,45,34,22,13,6,3,7,13,23,35,46,50,46,35,23,13,7,3,2,5,12,21,33,43,47,43,33,21,12,5,2,3,3,4,8,14,24,37,47,51,47,37,24,14,8,4,3,3,6,9,15,25,37,46,50,46,37,25,15,9,6,5,5,6,9,15,25,37,47,51,47,37,25,15,9,6,5,5,6,18,49,109,204,320,419,458,419,320,204,109,49,18,6,5,8,15,24,36,47,51,47,36,24,15,8,5,2,3,7,13,24,37,48,52,48,37,24,13,7,3,2,3,4,8,14,24,37,47,51,47,37,24,14,8,4,3,8,22,54,119,222,346,453,495,453,346,222,119,54,22,8],G:[3,3,4,5,9,14,20,26,28,26,20,14,9,5,4,3,3,3,4,8,13,20,25,28,25,20,13,8,4,3,58,129,241,378,494,541,494,378,241,129,58,3,3,3,5,8,14,20,25,27,25,20,14,8,5,3,3,3,5,8,14,20,25,27,25,20,14,8,5,7,11,16,23,29,31,29,23,16,11,7,8,22,54,118,219,342,447,489,447,342,219,118,54,22,8,3,4,8,13,20,26,28,26,20,13,8,4,3,7,11,16,22,28,30,28,22,16,11,7,19,50,110,205,321,420,459,420,321,205,110,50,19,4,4,5,6,10,16,22,28,31,28,22,16,10,6,5,4,4,2,4,7,12,18,24,26,24,18,12,7,4,2,4,8,13,20,26,28,26,20,13,8,4,5,7,10,15,21,27,29,27,21,15,10,7,5,1,1,3,6,11,17,22,24,22,17,11,6,3,1,1,1,1,2,3,7,12,19,25,27,25,19,12,7,3,2,1,1,5,9,15,22,27,30,27,22,15,9,5,21,51,110,204,318,416,454,416,318,204,110,51,21,8,22,58,128,239,374,489,535,489,374,239,128,58,22,8,22,55,122,226,353,462,505,462,353,226,122,55,22,3,4,5,9,15,22,27,30,27,22,15,9,5,4,3,1,2,3,7,12,19,25,27,25,19,12,7,3,2,1,3,6,11,17,22,24,22,17,11,6,3,4,5,9,15,22,28,30,28,22,15,9,5,4,1,1,2,3,7,13,20,26,28,26,20,13,7,3,2,1,1,21,54,120,224,350,458,501,458,350,224,120,54,21,1,2,3,7,12,19,25,27,25,19,12,7,3,2,1,5,9,14,21,27,29,27,21,14,9,5,1,1,1,3,6,11,17,22,24,22,17,11,6,3,1,1,1,21,55,124,232,364,476,521,476,364,232,124,55,21,4,4,6,9,14,21,26,28,26,21,14,9,6,4,4,5,8,14,20,25,27,25,20,14,8,5,1,3,7,12,18,24,26,24,18,12,7,3,1,5,5,7,10,16,22,27,30,27,22,16,10,7,5,5,1,1,3,6,12,18,24,26,24,18,12,6,3,1,1,1,1,1,3,6,11,16,21,23,21,16,11,6,3,1,1,1,5,8,13,19,24,26,24,19,13,8,5,24,57,125,231,361,472,516,472,361,231,125,57,24,2,6,19,49,110,207,324,424,464,424,324,207,110,49,19,6,2,57,124,229,358,467,511,467,358,229,124,57,1,1,2,3,7,13,19,25,28,25,19,13,7,3,2,1,1,3,4,5,9,14,20,26,28,26,20,14,9,5,4,3,3,3,5,8,13,18,23,25,23,18,13,8,5,3,3,3,3,3,5,8,13,18,23,25,23,18,13,8,5,3,3,3,7,11,17,23,29,32,29,23,17,11,7,55,120,223,347,454,496,454,347,223,120,55,5,5,7,10,15,20,25,27,25,20,15,10,7,5,5,1,1,3,6,11,18,23,25,23,18,11,6,3,1,1,2,2,2,4,7,13,19,25,27,25,19,13,7,4,2,2,2,24,58,125,230,359,469,512,469,359,230,125,58,24,2,2,4,7,12,18,23,25,23,18,12,7,4,2,2,1,1,1,3,6,11,17,23,25,23,17,11,6,3,1,1,1,5,5,7,11,16,22,28,30,28,22,16,11,7,5,5,2,2,4,8,13,19,25,27,25,19,13,8,4,2,2,2,4,7,12,18,23,25,23,18,12,7,4,2,1,3,6,12,18,23,25,23,18,12,6,3,1,2,3,4,8,13,20,26,28,26,20,13,8,4,3,2,53,118,221,346,452,495,452,346,221,118,53,8,22,55,123,229,359,470,514,470,359,229,123,55,22,8,4,8,13,20,26,28,26,20,13,8,4,3,3,4,5,9,15,22,28,30,28,22,15,9,5,4,3,3,4,5,6,10,15,22,28,30,28,22,15,10,6,5,4,4,8,13,20,25,28,25,20,13,8,4,2,2,4,7,13,19,24,27,24,19,13,7,4,2,2,56,123,229,358,469,513,469,358,229,123,56,3,3,4,5,9,14,21,27,29,27,21,14,9,5,4,3,3,5,5,5,7,10,15,21,26,28,26,21,15,10,7,5,5,5,7,11,17,24,30,32,30,24,17,11,7,19,49,109,205,321,421,460,421,321,205,109,49,19,2,2,3,4,8,14,20,26,29,26,20,14,8,4,3,2,2,1,1,2,3,7,13,20,26,28,26,20,13,7,3,2,1,1,2,2,3,4,8,14,21,26,29,26,21,14,8,4,3,2,2,1,2,3,7,12,18,24,26,24,18,12,7,3,2,1,1,3,6,11,17,22,24,22,17,11,6,3,1,2,2,4,7,13,19,24,26,24,19,13,7,4,2,2,2,4,7,12,18,23,25,23,18,12,7,4,2,11,24,58,124,228,355,464,508,464,355,228,124,58,24,11,59,131,244,382,500,547,500,382,244,131,59,21,55,121,226,354,463,507,463,354,226,121,55,21,1,3,6,11,16,21,23,21,16,11,6,3,1,3,3,3,5,8,13,19,24,26,24,19,13,8,5,3,3,3,6,7,11,17,24,30,32,30,24,17,11,7,6,5,5,5,7,10,15,20,25,27,25,20,15,10,7,5,5,5,1,1,3,6,11,16,21,23,21,16,11,6,3,1,1,22,53,114,211,329,431,471,431,329,211,114,53,22,2,2,4,7,13,19,25,27,25,19,13,7,4,2,2,3,3,5,8,13,19,24,26,24,19,13,8,5,3,3,3,4,5,9,14,21,27,29,27,21,14,9,5,4,3],T:[3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,3,2,3,4,6,8,10,11,10,8,6,4,3,2,3,4,6,9,11,12,11,9,6,4,3,4,9,22,56,122,226,353,462,506,462,353,226,122,56,22,9,4,3,5,7,9,11,12,11,9,7,5,3,6,7,9,12,14,15,14,12,9,7,6,3,3,4,5,7,9,11,12,11,9,7,5,4,3,3,22,58,128,238,373,488,534,488,373,238,128,58,22,5,7,9,11,13,14,13,11,9,7,5,2,3,4,6,8,10,11,10,8,6,4,3,2,5,10,23,56,121,223,348,455,498,455,348,223,121,56,23,10,5,2,3,4,6,9,11,12,11,9,6,4,3,2,3,4,6,8,11,11,11,8,6,4,3,5,6,7,9,11,14,14,14,11,9,7,6,5,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,1,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,1,4,5,7,10,12,13,12,10,7,5,4,4,5,6,8,11,13,14,13,11,8,6,5,4,2,2,3,4,6,9,11,12,11,9,6,4,3,2,2,3,4,5,7,9,11,12,11,9,7,5,4,3,8,21,52,115,213,332,435,475,435,332,213,115,52,21,8,7,21,56,125,235,367,481,527,481,367,235,125,56,21,7,56,125,234,366,480,525,480,366,234,125,56,3,4,5,7,9,11,12,11,9,7,5,4,3,1,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,1,2,3,4,6,9,12,12,12,9,6,4,3,2,6,19,51,114,214,336,440,481,440,336,214,114,51,19,6,4,5,7,10,12,13,12,10,7,5,4,1,1,1,2,3,5,7,9,10,9,7,5,3,2,1,1,1,1,1,3,5,7,9,10,9,7,5,3,1,1,9,23,55,120,223,347,454,496,454,347,223,120,55,23,9,4,5,7,10,12,13,12,10,7,5,4,1,2,3,5,8,10,11,10,8,5,3,2,1,5,5,6,7,9,11,14,14,14,11,9,7,6,5,5,1,1,2,3,5,7,10,10,10,7,5,3,2,1,1,1,1,1,2,3,5,7,9,10,9,7,5,3,2,1,1,1,4,5,7,10,13,13,13,10,7,5,4,4,4,6,8,10,12,13,12,10,8,6,4,4,1,1,1,2,3,5,7,9,10,9,7,5,3,2,1,1,1,5,6,8,11,13,14,13,11,8,6,5,2,7,21,57,126,237,371,486,532,486,371,237,126,57,21,7,2,8,21,52,115,213,333,436,477,436,333,213,115,52,21,8,9,23,59,129,240,375,490,536,490,375,240,129,59,23,9,3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,3,6,7,9,12,14,15,14,12,9,7,6,5,6,8,10,12,13,12,10,8,6,5,10,23,55,118,217,337,440,482,440,337,217,118,55,23,10,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,2,2,2,3,4,6,8,10,11,10,8,6,4,3,2,2,2,5,6,7,9,12,14,15,14,12,9,7,6,5,7,20,52,115,215,336,439,480,439,336,215,115,52,20,7,1,1,1,2,3,5,7,10,10,10,7,5,3,2,1,1,1,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,2,2,3,4,6,8,10,11,10,8,6,4,3,2,2,2,3,4,6,9,11,12,11,9,6,4,3,2,1,2,3,5,7,9,10,9,7,5,3,2,1,2,2,3,4,6,9,11,12,11,9,6,4,3,2,2,2,4,6,8,10,11,10,8,6,4,2,2,2,3,4,6,8,10,11,10,8,6,4,3,2,2,51,113,211,330,432,472,432,330,211,113,51,4,9,22,55,122,226,353,462,505,462,353,226,122,55,22,9,4,10,23,56,121,225,351,459,501,459,351,225,121,56,23,10,2,4,6,8,10,11,10,8,6,4,2,2,2,3,4,6,9,11,12,11,9,6,4,3,2,2,3,5,7,9,11,12,11,9,7,5,3,4,8,21,54,117,218,341,446,488,446,341,218,117,54,21,8,4,5,5,5,6,7,9,11,14,14,14,11,9,7,6,5,5,5,5,7,9,11,13,14,13,11,9,7,5,1,1,3,5,7,9,10,9,7,5,3,1,1,3,8,22,56,124,231,361,473,517,473,361,231,124,56,22,8,3,1,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,1,2,2,2,3,4,6,8,10,11,10,8,6,4,3,2,2,2,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,1,1,3,5,7,9,10,9,7,5,3,1,1,2,2,3,4,6,8,10,11,10,8,6,4,3,2,2,2,3,4,6,9,11,12,11,9,6,4,3,2,5,5,5,7,9,11,13,14,13,11,9,7,5,5,5,3,4,6,9,11,12,11,9,6,4,3,2,3,4,6,9,11,12,11,9,6,4,3,2,21,55,124,232,364,477,522,477,364,232,124,55,21,4,9,22,55,121,226,353,461,505,461,353,226,121,55,22,9,4,25,60,128,237,369,482,527,482,369,237,128,60,25,5,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,5,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,4,5,6,8,10,12,13,12,10,8,6,5,4,8,21,55,121,225,353,462,505,462,353,225,121,55,21,8,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3],peak:[8,23,35,49,63,74,87,101,113,125,140,155,167,179,193,209,223,235,249,263,277,292,305,317,332,347,361,374,388,403,417,430,442,456,471,487,501,513,528,542,556,572,587,603,617,628,641,656,672,687,701,717,733,748,762,775,789,802,815,828,842,858,871,884,897,911,928,942,954,969,986,1003,1019,1033,1047,1061,1075,1088,1100,1113,1128,1143,1158,1174,1188,1202,1217,1232]},index:2,counter:5,measureText:74},{id:"R1-0000-3456",fill:"rgb(255,51,255)",outline:"rgb(0,0,0)",dir:"left",offsetLeft:"134",sequence:"AAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAAAC",coordinate:230,trace:{A:[6,18,49,109,203,319,417,457,417,319,203,109,49,18,6,2,6,19,50,112,210,330,432,472,432,330,210,112,50,19,6,2,5,10,23,57,124,230,359,469,513,469,359,230,124,57,23,10,5,13,27,48,74,96,105,96,74,48,27,13,5,11,23,42,65,85,93,85,65,42,23,11,5,2,4,11,24,45,70,91,100,91,70,45,24,11,4,2,11,24,44,69,90,98,90,69,44,24,11,6,13,28,50,78,102,111,102,78,50,28,13,6,12,26,49,76,100,109,100,76,49,26,12,2,4,11,24,45,70,91,100,91,70,45,24,11,4,2,2,4,10,23,42,66,86,94,86,66,42,23,10,4,2,1,2,4,11,24,46,71,93,102,93,71,46,24,11,4,2,1,3,8,21,55,122,228,357,468,512,468,357,228,122,55,21,8,3,15,28,49,75,96,105,96,75,49,28,15,1,2,5,11,25,46,72,95,104,95,72,46,25,11,5,2,1,6,13,26,48,75,98,107,98,75,48,26,13,6,7,22,58,130,243,381,499,546,499,381,243,130,58,22,7,4,6,12,24,43,65,85,93,85,65,43,24,12,6,4,5,12,26,48,75,98,107,98,75,48,26,12,5,2,4,11,24,44,68,89,98,89,68,44,24,11,4,2,24,58,125,230,358,468,512,468,358,230,125,58,24,50,109,203,317,414,453,414,317,203,109,50,8,22,54,119,220,344,450,492,450,344,220,119,54,22,8,4,10,23,42,65,86,94,86,65,42,23,10,4,5,12,26,48,75,99,108,99,75,48,26,12,5,9,16,29,51,78,100,109,100,78,51,29,16,9,3,4,6,13,25,45,69,90,98,90,69,45,25,13,6,4,3,1,2,5,12,26,48,74,97,106,97,74,48,26,12,5,2,1,3,5,11,23,42,65,84,92,84,65,42,23,11,5,3,4,5,7,14,27,48,73,95,103,95,73,48,27,14,7,5,4,15,28,49,74,95,104,95,74,49,28,15,15,28,48,73,94,103,94,73,48,28,15,5,9,22,54,116,215,336,439,480,439,336,215,116,54,22,9,5,11,24,45,70,91,99,91,70,45,24,11,7,14,27,48,73,95,103,95,73,48,27,14,7,2,3,5,12,25,45,70,91,100,91,70,45,25,12,5,3,2,23,59,132,246,385,504,551,504,385,246,132,59,23,11,23,43,66,86,94,86,66,43,23,11,7,14,27,49,76,99,108,99,76,49,27,14,7,1,2,5,12,26,49,76,100,109,100,76,49,26,12,5,2,1,50,113,211,331,433,474,433,331,211,113,50,2,7,20,54,120,225,352,461,505,461,352,225,120,54,20,7,2,7,21,56,125,234,366,480,525,480,366,234,125,56,21,7,9,15,29,50,76,99,108,99,76,50,29,15,9,16,30,52,79,103,112,103,79,52,30,16,13,25,44,67,87,95,87,67,44,25,13,7,14,28,51,78,102,111,102,78,51,28,14,7,2,4,10,22,41,64,84,92,84,64,41,22,10,4,2,2,4,11,23,43,67,88,96,88,67,43,23,11,4,2,5,7,13,25,45,68,88,96,88,68,45,25,13,7,5,4,5,8,15,28,50,76,99,108,99,76,50,28,15,8,5,4,15,27,47,71,92,100,92,71,47,27,15,7,21,56,125,235,368,482,528,482,368,235,125,56,21,7,6,12,25,44,68,88,96,88,68,44,25,12,6,2,3,5,11,23,42,66,85,93,85,66,42,23,11,5,3,2,2,4,10,22,41,65,85,93,85,65,41,22,10,4,2,4,8,22,54,118,220,343,448,490,448,343,220,118,54,22,8,4,13,26,45,69,90,98,90,69,45,26,13,4,5,8,15,30,52,80,104,113,104,80,52,30,15,8,5,4,2,3,6,13,27,49,76,99,108,99,76,49,27,13,6,3,2,9,23,55,120,222,347,453,496,453,347,222,120,55,23,9,60,131,243,380,496,543,496,380,243,131,60,11,26,61,132,244,380,496,542,496,380,244,132,61,26,11,2,4,11,24,44,69,90,98,90,69,44,24,11,4,2,4,11,24,45,70,91,100,91,70,45,24,11,4,8,15,28,48,73,94,103,94,73,48,28,15,8,12,26,47,74,96,105,96,74,47,26,12,5,6,9,15,29,51,77,99,108,99,77,51,29,15,9,6,5,3,5,11,23,42,66,86,94,86,66,42,23,11,5,3,4,5,7,14,26,47,71,92,100,92,71,47,26,14,7,5,4,5,8,15,29,52,79,102,112,102,79,52,29,15,8,5,5,6,9,16,30,53,80,104,113,104,80,53,30,16,9,6,5,20,50,110,204,318,416,455,416,318,204,110,50,20,11,25,46,72,94,103,94,72,46,25,11,3,4,6,13,26,46,71,93,101,93,71,46,26,13,6,4,3,13,27,50,77,101,110,101,77,50,27,13,60,132,245,383,501,548,501,383,245,132,60,13,27,50,77,101,110,101,77,50,27,13,10,23,42,66,86,95,86,66,42,23,10,4,6,12,25,44,67,87,95,87,67,44,25,12,6,4,58,129,242,380,498,544,498,380,242,129,58,6,18,49,109,204,320,419,458,419,320,204,109,49,18,6,23,57,125,232,362,474,518,474,362,232,125,57,23,4,5,8,15,29,52,80,103,112,103,80,52,29,15,8,5,4],C:[1,3,6,13,24,37,48,53,48,37,24,13,6,3,1,1,1,2,6,12,22,35,45,49,45,35,22,12,6,2,1,1,4,4,5,8,15,24,36,46,50,46,36,24,15,8,5,4,4,60,132,246,385,504,551,504,385,246,132,60,19,50,110,206,322,421,460,421,322,206,110,50,19,7,21,56,124,233,365,478,523,478,365,233,124,56,21,7,6,13,25,38,50,55,50,38,25,13,6,3,6,12,22,33,43,47,43,33,22,12,6,3,6,13,23,36,47,52,47,36,23,13,6,1,2,5,11,21,33,43,47,43,33,21,11,5,2,1,1,2,5,11,21,33,42,46,42,33,21,11,5,2,1,1,1,3,6,13,24,38,50,54,50,38,24,13,6,3,1,1,2,2,4,7,14,25,38,50,54,50,38,25,14,7,4,2,2,56,120,221,344,449,491,449,344,221,120,56,1,1,3,6,13,24,37,48,52,48,37,24,13,6,3,1,1,4,7,14,26,39,51,56,51,39,26,14,7,4,1,2,6,12,22,35,45,50,45,35,22,12,6,2,1,8,21,53,116,216,337,441,482,441,337,216,116,53,21,8,2,5,12,21,33,43,47,43,33,21,12,5,2,1,3,6,13,24,37,48,53,48,37,24,13,6,3,1,6,10,16,26,38,48,53,48,38,26,16,10,6,8,15,26,39,50,55,50,39,26,15,8,3,4,8,14,24,36,46,50,46,36,24,14,8,4,3,20,53,119,224,350,459,502,459,350,224,119,53,20,19,50,112,211,330,432,473,432,330,211,112,50,19,23,55,118,218,340,444,485,444,340,218,118,55,23,3,3,5,8,15,26,40,51,56,51,40,26,15,8,5,3,3,1,1,3,6,13,24,37,48,52,48,37,24,13,6,3,1,1,2,3,6,13,22,34,44,48,44,34,22,13,6,3,2,4,4,5,8,14,24,36,45,49,45,36,24,14,8,5,4,4,10,17,29,43,55,59,55,43,29,17,10,10,17,28,42,53,58,53,42,28,17,10,4,4,5,8,14,24,36,46,50,46,36,24,14,8,5,4,4,54,121,226,354,464,508,464,354,226,121,54,5,8,14,24,36,46,50,46,36,24,14,8,5,2,2,3,7,13,23,36,47,51,47,36,23,13,7,3,2,2,4,7,14,25,39,51,55,51,39,25,14,7,4,51,113,210,329,430,471,430,329,210,113,51,4,8,14,24,37,47,51,47,37,24,14,8,4,1,1,2,6,13,23,36,47,51,47,36,23,13,6,2,1,1,6,13,23,36,47,51,47,36,23,13,6,1,1,2,5,12,21,33,43,47,43,33,21,12,5,2,1,1,1,3,6,13,24,38,49,54,49,38,24,13,6,3,1,22,52,112,206,321,419,458,419,321,206,112,52,22,55,117,216,337,440,481,440,337,216,117,55,53,115,212,331,432,472,432,331,212,115,53,5,8,15,26,39,51,55,51,39,26,15,8,5,1,2,6,12,22,35,46,50,46,35,22,12,6,2,1,1,2,5,11,21,32,42,46,42,32,21,11,5,2,1,4,6,9,16,28,41,53,58,53,41,28,16,9,6,4,4,4,5,9,16,26,39,50,54,50,39,26,16,9,5,4,4,10,17,28,41,52,57,52,41,28,17,10,1,2,6,12,22,35,45,49,45,35,22,12,6,2,1,23,57,125,233,364,476,521,476,364,233,125,57,23,2,2,3,6,13,22,34,44,48,44,34,22,13,6,3,2,2,1,3,6,13,24,38,49,54,49,38,24,13,6,3,1,3,3,5,8,15,27,41,52,57,52,41,27,15,8,5,3,3,54,116,215,335,437,478,437,335,215,116,54,4,4,6,9,16,26,39,50,55,50,39,26,16,9,6,4,4,2,2,4,7,14,24,37,49,53,49,37,24,14,7,4,2,2,4,6,9,16,26,39,51,55,51,39,26,16,9,6,4,8,14,24,35,45,49,45,35,24,14,8,5,6,9,16,25,37,47,51,47,37,25,16,9,6,5,7,22,57,128,239,375,491,537,491,375,239,128,57,22,7,22,58,130,244,383,501,548,501,383,244,130,58,22,22,53,113,208,324,423,463,423,324,208,113,53,22,6,13,22,34,44,48,44,34,22,13,6,5,5,7,10,17,28,41,52,57,52,41,28,17,10,7,5,5,2,4,7,14,26,40,52,56,52,40,26,14,7,4,2,4,4,5,8,14,24,35,45,49,45,35,24,14,8,5,4,4,4,6,9,16,27,41,52,57,52,41,27,16,9,6,4,5,5,6,9,16,25,37,48,52,48,37,25,16,9,6,5,5,4,7,14,24,35,46,50,46,35,24,14,7,4,51,113,212,332,435,476,435,332,212,113,51,3,3,5,8,15,26,39,50,55,50,39,26,15,8,5,3,3,6,12,22,34,43,47,43,34,22,12,6,8,14,24,37,47,52,47,37,24,14,8,56,123,230,360,471,515,471,360,230,123,56,6,13,23,36,47,52,47,36,23,13,6,3,5,8,15,26,39,51,55,51,39,26,15,8,5,3,5,11,21,33,43,46,43,33,21,11,5,1,2,6,12,23,36,47,51,47,36,23,12,6,2,1,4,7,13,23,34,44,48,44,34,23,13,7,4,5,10,23,57,123,228,355,465,508,465,355,228,123,57,23,10,5],G:[1,1,3,6,11,16,21,23,21,16,11,6,3,1,1,1,1,1,3,6,11,17,22,25,22,17,11,6,3,1,1,1,4,4,4,6,9,14,20,25,27,25,20,14,9,6,4,4,4,5,8,14,20,26,28,26,20,14,8,5,2,4,7,12,18,23,25,23,18,12,7,4,2,1,1,3,7,12,18,24,26,24,18,12,7,3,1,1,58,129,242,379,497,543,497,379,242,129,58,21,55,122,228,356,466,510,466,356,228,122,55,21,51,114,214,335,438,480,438,335,214,114,51,1,1,3,6,11,17,22,24,22,17,11,6,3,1,1,1,1,3,6,11,18,23,25,23,18,11,6,3,1,1,1,1,2,3,7,12,19,25,27,25,19,12,7,3,2,1,1,2,2,2,4,7,12,18,23,25,23,18,12,7,4,2,2,2,7,10,15,20,25,27,25,20,15,10,7,2,6,18,49,109,204,319,418,457,418,319,204,109,49,18,6,2,3,4,8,13,20,26,28,26,20,13,8,4,3,1,1,3,6,11,16,21,23,21,16,11,6,3,1,1,3,3,5,8,13,20,25,27,25,20,13,8,5,3,3,20,53,118,222,348,456,498,456,348,222,118,53,20,1,2,3,7,12,19,24,26,24,19,12,7,3,2,1,6,7,11,16,23,29,31,29,23,16,11,7,6,5,8,13,19,24,25,24,19,13,8,5,3,3,5,8,14,20,25,27,25,20,14,8,5,3,3,2,3,7,12,19,25,27,25,19,12,7,3,2,1,3,6,11,18,23,25,23,18,11,6,3,1,6,7,11,16,23,28,31,28,23,16,11,7,6,4,9,24,59,130,242,378,494,540,494,378,242,130,59,24,9,4,2,7,22,58,130,244,382,500,547,500,382,244,130,58,22,7,2,7,20,51,113,210,329,431,471,431,329,210,113,51,20,7,4,4,4,6,9,15,21,26,29,26,21,15,9,6,4,4,4,7,11,16,23,29,31,29,23,16,11,7,7,10,15,21,26,28,26,21,15,10,7,4,4,4,6,9,14,20,26,28,26,20,14,9,6,4,4,4,3,6,11,17,22,24,22,17,11,6,3,25,61,134,248,387,506,553,506,387,248,134,61,25,2,2,2,4,7,12,19,24,26,24,19,12,7,4,2,2,2,2,4,7,12,18,24,26,24,18,12,7,4,2,4,7,12,18,23,26,23,18,12,7,4,24,60,132,246,384,502,549,502,384,246,132,60,24,1,1,2,3,7,12,19,25,27,25,19,12,7,3,2,1,1,3,6,12,18,23,26,23,18,12,6,3,1,1,1,3,6,11,18,23,25,23,18,11,6,3,1,1,1,1,2,3,7,12,19,25,27,25,19,12,7,3,2,1,6,7,11,16,23,29,31,29,23,16,11,7,6,7,11,17,23,29,31,29,23,17,11,7,6,9,15,21,27,29,27,21,15,9,6,21,52,114,211,330,431,471,431,330,211,114,52,21,6,18,49,109,205,321,420,459,420,321,205,109,49,18,6,7,21,55,124,232,363,476,521,476,363,232,124,55,21,7,4,4,6,9,14,19,24,26,24,19,14,9,6,4,4,4,4,4,6,9,14,21,26,28,26,21,14,9,6,4,4,4,7,10,16,22,27,29,27,22,16,10,7,1,2,3,7,13,19,25,28,25,19,13,7,3,2,1,3,5,8,14,20,25,27,25,20,14,8,5,3,3,7,20,52,114,213,333,436,477,436,333,213,114,52,20,7,3,1,1,3,6,11,18,23,25,23,18,11,6,3,1,1,3,3,4,5,9,14,21,26,28,26,21,14,9,5,4,3,3,6,9,14,21,26,28,26,21,14,9,6,5,10,24,58,126,234,365,477,521,477,365,234,126,58,24,10,5,2,2,2,4,7,12,18,23,25,23,18,12,7,4,2,2,2,4,4,6,9,15,21,26,28,26,21,15,9,6,4,4,6,9,14,19,24,26,24,19,14,9,6,5,5,7,10,15,21,26,28,26,21,15,10,7,5,5,1,2,3,7,12,18,24,26,24,18,12,7,3,2,1,1,3,6,12,18,23,26,23,18,12,6,3,1,5,7,10,16,22,27,29,27,22,16,10,7,5,56,124,232,364,476,521,476,364,232,124,56,6,11,25,60,129,239,372,486,531,486,372,239,129,60,25,11,6,8,22,56,123,230,360,471,515,471,360,230,123,56,22,8,4,4,4,6,9,14,20,25,27,25,20,14,9,6,4,4,4,4,4,6,9,14,20,25,27,25,20,14,9,6,4,4,5,5,5,7,10,15,22,27,29,27,22,15,10,7,5,5,5,3,5,8,13,19,24,27,24,19,13,8,5,3,3,6,11,17,23,25,23,17,11,6,3,4,8,21,52,114,212,331,433,474,433,331,212,114,52,21,8,4,4,7,13,19,25,27,25,19,13,7,4,5,9,14,20,26,28,26,20,14,9,5,4,7,12,18,23,25,23,18,12,7,4,56,126,236,370,485,530,485,370,236,126,56,3,4,5,9,14,21,27,29,27,21,14,9,5,4,3,3,7,12,19,25,27,25,19,12,7,3,1,1,3,6,12,18,23,26,23,18,12,6,3,1,1,4,5,9,15,22,27,30,27,22,15,9,5,4,4,4,5,6,10,16,22,28,31,28,22,16,10,6,5,4,4],T:[1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,1,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,1,4,4,4,5,6,8,10,13,14,13,10,8,6,5,4,4,4,3,5,7,9,11,12,11,9,7,5,3,2,3,4,6,8,10,11,10,8,6,4,3,2,1,1,2,3,5,7,10,10,10,7,5,3,2,1,1,2,3,5,8,10,11,10,8,5,3,2,2,2,4,6,8,10,11,10,8,6,4,2,2,1,3,5,7,9,10,9,7,5,3,1,6,19,51,114,213,334,438,479,438,334,213,114,51,19,6,6,19,51,115,215,336,440,482,440,336,215,115,51,19,6,2,6,19,51,115,215,337,441,482,441,337,215,115,51,19,6,2,2,2,2,3,4,6,9,11,12,11,9,6,4,3,2,2,2,6,7,9,12,14,15,14,12,9,7,6,1,1,1,2,3,5,7,10,10,10,7,5,3,2,1,1,1,21,54,120,224,351,459,503,459,351,224,120,54,21,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,3,3,3,5,7,9,11,12,11,9,7,5,3,3,3,1,2,3,5,7,9,10,9,7,5,3,2,1,6,19,50,111,209,327,429,469,429,327,209,111,50,19,6,5,6,7,9,12,15,15,15,12,9,7,6,5,4,5,7,10,12,13,12,10,7,5,4,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,1,2,3,5,8,10,11,10,8,5,3,2,1,1,1,3,5,7,9,10,9,7,5,3,1,1,5,5,7,9,11,13,14,13,11,9,7,5,5,3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,3,1,1,1,2,3,5,7,10,10,10,7,5,3,2,1,1,1,2,2,3,4,6,8,11,11,11,8,6,4,3,2,2,5,9,22,52,113,210,327,427,467,427,327,210,113,52,22,9,5,57,123,227,354,462,505,462,354,227,123,57,58,125,230,359,469,512,469,359,230,125,58,4,4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,4,1,3,5,7,9,10,9,7,5,3,1,4,4,6,8,10,12,13,12,10,8,6,4,4,3,7,20,52,114,213,333,436,477,436,333,213,114,52,20,7,3,2,3,4,6,9,11,12,11,9,6,4,3,2,3,4,6,9,11,12,11,9,6,4,3,3,4,5,7,10,12,13,12,10,7,5,4,3,2,7,21,56,125,235,368,482,527,482,368,235,125,56,21,7,2,2,3,5,8,10,11,10,8,5,3,2,1,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,1,1,1,2,3,5,7,10,10,10,7,5,3,2,1,1,5,6,7,9,12,14,15,14,12,9,7,6,5,6,7,9,11,14,14,14,11,9,7,6,5,6,8,11,13,14,13,11,8,6,5,3,4,5,7,10,13,13,13,10,7,5,4,3,1,1,2,3,5,7,10,10,10,7,5,3,2,1,1,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,9,22,53,115,214,333,435,476,435,333,214,115,53,22,9,5,10,24,59,128,238,371,485,531,485,371,238,128,59,24,10,5,56,120,221,344,450,492,450,344,221,120,56,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,3,4,5,7,9,11,12,11,9,7,5,4,3,2,2,2,3,4,6,8,10,11,10,8,6,4,3,2,2,2,7,21,55,122,229,359,470,514,470,359,229,122,55,21,7,3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,3,5,6,8,11,13,14,13,11,8,6,5,4,4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,4,3,8,22,56,125,232,364,476,521,476,364,232,125,56,22,8,3,4,4,5,6,8,10,12,13,12,10,8,6,5,4,4,5,6,8,10,12,13,12,10,8,6,5,5,5,6,7,9,11,14,14,14,11,9,7,6,5,5,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,1,2,3,5,7,10,11,10,7,5,3,2,1,5,5,7,9,11,13,14,13,11,9,7,5,5,3,4,6,8,10,11,10,8,6,4,3,5,5,5,5,7,9,11,13,14,13,11,9,7,5,5,5,5,2,2,2,4,6,8,10,11,10,8,6,4,2,2,2,5,9,21,52,112,207,323,422,461,422,323,207,112,52,21,9,5,9,22,54,118,218,340,445,486,445,340,218,118,54,22,9,6,10,23,53,113,209,325,425,464,425,325,209,113,53,23,10,6,3,4,5,7,9,11,12,11,9,7,5,4,3,2,3,5,7,10,10,10,7,5,3,2,3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,3,51,113,212,331,433,474,433,331,212,113,51,3,5,7,9,11,12,11,9,7,5,3,3,4,6,9,11,12,11,9,6,4,3,2,3,5,8,10,11,10,8,5,3,2,8,21,53,116,216,338,441,483,441,338,216,116,53,21,8,2,3,5,7,9,10,9,7,5,3,2,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,3,4,5,7,10,13,13,13,10,7,5,4,3,4,4,4,5,6,8,11,14,14,14,11,8,6,5,4,4,4],peak:[7,23,40,54,66,80,93,105,117,130,145,161,178,192,206,221,235,250,264,278,292,304,317,331,344,357,372,389,405,421,435,446,460,474,486,501,516,528,540,555,569,583,599,613,625,636,648,662,677,692,708,722,735,749,764,780,796,810,824,841,857,870,883,898,912,925,937,951,967,983,999,1015,1030,1042,1056,1070,1081,1092,1103,1116,1129,1142,1156,1171]},index:3,counter:6,offset:51,measureText:74},{id:"R1-0000-4567",fill:"rgb(255,102,255)",outline:"rgb(0,0,0)",dir:"right",offset:82,gaps:[[65,1],[84,1]],sequence:"TAAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAAACCGGGTTTACGTACGTAAACCG",coordinate:80,trace:{A:[3,5,12,25,45,70,92,100,92,70,45,25,12,5,3,4,9,23,59,129,240,374,489,535,489,374,240,129,59,23,9,4,8,21,51,112,209,326,427,467,427,326,209,112,51,21,8,21,55,123,231,363,475,519,475,363,231,123,55,21,12,26,48,74,97,106,97,74,48,26,12,1,2,5,11,25,46,73,95,104,95,73,46,25,11,5,2,1,5,12,26,49,77,100,109,100,77,49,26,12,5,12,26,48,75,98,107,98,75,48,26,12,2,4,10,22,42,65,85,93,85,65,42,22,10,4,2,14,26,45,68,87,95,87,68,45,26,14,15,28,48,73,95,103,95,73,48,28,15,1,2,5,12,26,48,75,98,107,98,75,48,26,12,5,2,1,16,29,51,78,101,110,101,78,51,29,16,2,7,20,53,119,223,349,457,500,457,349,223,119,53,20,7,2,12,25,47,74,96,105,96,74,47,25,12,6,13,25,46,70,91,99,91,70,46,25,13,6,4,7,14,28,49,76,99,108,99,76,49,28,14,7,4,20,52,117,220,345,451,494,451,345,220,117,52,20,7,14,27,48,74,95,104,95,74,48,27,14,7,8,15,29,52,79,102,112,102,79,52,29,15,8,12,25,44,68,88,96,88,68,44,25,12,7,21,54,122,228,358,469,513,469,358,228,122,54,21,7,54,117,218,340,445,487,445,340,218,117,54,49,109,204,319,417,456,417,319,204,109,49,5,7,14,27,48,73,94,103,94,73,48,27,14,7,5,15,27,47,71,92,100,92,71,47,27,15,1,2,4,10,22,41,65,85,93,85,65,41,22,10,4,2,1,6,13,27,50,78,102,111,102,78,50,27,13,6,11,24,45,70,91,100,91,70,45,24,11,5,11,24,43,67,87,95,87,67,43,24,11,5,8,14,26,45,68,88,96,88,68,45,26,14,8,12,26,47,72,94,103,94,72,47,26,12,7,13,26,45,69,89,97,89,69,45,26,13,7,4,9,24,59,130,243,379,496,543,496,379,243,130,59,24,9,4,15,29,52,80,103,113,103,80,52,29,15,4,7,14,28,51,78,102,111,102,78,51,28,14,7,4,12,26,48,75,98,107,98,75,48,26,12,23,57,123,228,356,466,509,466,356,228,123,57,23,12,26,48,74,97,105,97,74,48,26,12,8,15,27,47,71,92,100,92,71,47,27,15,8,14,28,49,75,98,106,98,75,49,28,14,56,121,224,350,458,500,458,350,224,121,56,9,21,52,112,208,324,423,463,423,324,208,112,52,21,9,2,7,20,54,120,225,353,463,506,463,353,225,120,54,20,7,2,3,4,6,13,26,46,71,92,100,92,71,46,26,13,6,4,3,4,5,7,13,25,44,68,88,95,88,68,44,25,13,7,5,4,4,6,12,25,45,69,89,97,89,69,45,25,12,6,4,1,2,4,10,22,42,65,85,93,85,65,42,22,10,4,2,1,11,24,43,67,87,95,87,67,43,24,11,4,11,23,43,68,89,97,89,68,43,23,11,4,5,6,9,16,30,53,81,104,114,104,81,53,30,16,9,6,5,12,25,44,68,88,97,88,68,44,25,12,14,29,51,79,103,112,103,79,51,29,14,10,24,59,128,237,370,483,528,483,370,237,128,59,24,10,8,15,29,51,77,100,109,100,77,51,29,15,8,15,29,51,77,99,108,99,77,51,29,15,4,6,12,24,43,66,85,93,85,66,43,24,12,6,4,23,56,119,220,343,447,489,447,343,220,119,56,23,7,13,25,45,68,88,96,88,68,45,25,13,7,8,15,28,48,73,94,102,94,73,48,28,15,8,8,14,26,45,68,87,95,87,68,45,26,14,8,4,8,21,52,114,211,330,431,472,431,330,211,114,52,21,8,4,23,58,128,239,373,488,534,488,373,239,128,58,23,11,25,59,127,234,365,476,521,476,365,234,127,59,25,11,3,6,13,27,50,78,101,111,101,78,50,27,13,6,3,5,7,14,28,49,74,96,105,96,74,49,28,14,7,5,11,23,42,65,84,92,84,65,42,23,11,6,13,27,48,75,98,107,98,75,48,27,13,6,4,5,7,14,27,48,74,96,104,96,74,48,27,14,7,5,4,5,7,13,25,44,68,87,95,87,68,44,25,13,7,5,6,8,15,28,49,75,96,105,96,75,49,28,15,8,6,1,2,4,11,23,44,68,89,97,89,68,44,23,11,4,2,1,5,10,25,61,133,246,384,502,548,502,384,246,133,61,25,10,5,2,3,5,11,24,43,67,87,95,87,67,43,24,11,5,3,2,4,5,7,13,25,44,68,88,95,88,68,44,25,13,7,5,4,4,11,24,45,71,93,101,93,71,45,24,11,4,57,124,231,361,472,517,472,361,231,124,57,3,4,7,13,27,49,75,97,106,97,75,49,27,13,7,4,3,1,2,5,11,25,46,72,94,103,94,72,46,25,11,5,2,1,5,12,25,46,72,94,102,94,72,46,25,12,5,51,112,208,326,427,467,427,326,208,112,51,58,126,233,363,475,519,475,363,233,126,58,53,113,208,324,423,462,423,324,208,113,53,11,25,46,73,95,104,95,73,46,25,11,2,4,10,22,42,65,85,93,85,65,42,22,10,4,2,12,25,46,71,93,101,93,71,46,25,12],C:[2,4,7,14,26,39,51,56,51,39,26,14,7,4,2,3,3,5,8,15,27,41,52,57,52,41,27,15,8,5,3,3,3,5,8,15,26,39,51,55,51,39,26,15,8,5,3,2,5,11,21,33,43,47,43,33,21,11,5,2,51,112,209,326,427,467,427,326,209,112,51,2,7,22,57,129,241,378,495,541,495,378,241,129,57,22,7,2,22,58,129,242,380,497,544,497,380,242,129,58,22,6,12,22,34,44,48,44,34,22,12,6,1,2,6,12,23,35,46,50,46,35,23,12,6,2,1,10,17,28,42,53,58,53,42,28,17,10,9,15,25,36,46,50,46,36,25,15,9,1,1,3,6,13,23,36,48,52,48,36,23,13,6,3,1,1,10,16,26,38,48,52,48,38,26,16,10,1,1,3,6,13,24,38,50,54,50,38,24,13,6,3,1,1,54,121,226,355,464,508,464,355,226,121,54,5,8,15,27,41,53,57,53,41,27,15,8,5,3,4,8,14,24,36,46,50,46,36,24,14,8,4,3,2,5,12,21,33,44,48,44,33,21,12,5,2,23,57,124,230,358,468,512,468,358,230,124,57,23,5,9,15,25,38,48,52,48,38,25,15,9,5,7,13,23,35,45,49,45,35,23,13,7,1,2,6,12,22,34,45,49,45,34,22,12,6,2,1,8,15,26,40,52,56,52,40,26,15,8,7,15,26,40,52,56,52,40,26,15,7,9,22,53,116,214,334,436,477,436,334,214,116,53,22,9,53,114,210,327,427,467,427,327,210,114,53,2,7,21,57,127,238,373,488,534,488,373,238,127,57,21,7,2,4,7,14,24,37,48,53,48,37,24,14,7,4,6,13,24,37,49,53,49,37,24,13,6,3,7,13,23,35,46,50,46,35,23,13,7,3,6,10,17,27,40,51,55,51,40,27,17,10,6,7,14,26,39,51,56,51,39,26,14,7,5,8,14,24,35,45,49,45,35,24,14,8,5,3,3,4,8,15,25,38,49,53,49,38,25,15,8,4,3,3,52,112,207,323,422,462,422,323,207,112,52,3,4,8,14,25,37,48,52,48,37,25,14,8,4,3,6,13,23,36,47,52,47,36,23,13,6,5,9,15,26,39,50,54,50,39,26,15,9,5,56,123,230,359,470,515,470,359,230,123,56,6,10,16,26,38,49,53,49,38,26,16,10,6,9,16,28,42,54,58,54,42,28,16,9,8,14,24,36,46,50,46,36,24,14,8,4,5,8,14,24,35,45,49,45,35,24,14,8,5,4,1,1,3,6,13,24,37,49,53,49,37,24,13,6,3,1,1,4,9,22,56,123,229,358,468,512,468,358,229,123,56,22,9,4,5,10,23,56,121,224,350,457,500,457,350,224,121,56,23,10,5,8,21,51,112,208,325,425,465,425,325,208,112,51,21,8,1,1,3,6,13,25,38,50,55,50,38,25,13,6,3,1,1,6,13,23,35,45,49,45,35,23,13,6,2,5,12,21,33,43,47,43,33,21,12,5,2,5,5,6,10,16,27,40,50,55,50,40,27,16,10,6,5,5,7,14,23,35,46,50,46,35,23,14,7,8,15,25,38,49,54,49,38,25,15,8,4,5,8,15,24,36,46,50,46,36,24,15,8,5,4,22,52,113,210,327,428,468,428,327,210,113,52,22,10,16,27,39,50,55,50,39,27,16,10,3,4,8,14,25,38,49,53,49,38,25,14,8,4,3,7,10,18,29,43,55,59,55,43,29,18,10,7,25,61,133,246,384,502,549,502,384,246,133,61,25,7,10,17,28,41,53,57,53,41,28,17,10,7,6,9,16,25,37,47,52,47,37,25,16,9,6,3,3,4,8,14,25,37,48,52,48,37,25,14,8,4,3,3,4,7,13,23,34,44,48,44,34,23,13,7,4,5,7,10,17,28,41,53,57,53,41,28,17,10,7,5,8,23,59,131,244,382,500,547,500,382,244,131,59,23,8,10,24,60,130,241,376,492,538,492,376,241,130,60,24,10,7,13,23,35,45,49,45,35,23,13,7,3,6,13,23,35,45,49,45,35,23,13,6,3,4,4,5,9,15,25,38,48,52,48,38,25,15,9,5,4,4,4,6,9,16,27,40,52,56,52,40,27,16,9,6,4,5,7,10,17,28,42,53,58,53,42,28,17,10,7,5,1,1,3,6,13,25,39,51,55,51,39,25,13,6,3,1,1,4,4,6,9,16,27,41,52,57,52,41,27,16,9,6,4,4,3,7,20,50,111,207,324,424,463,424,324,207,111,50,20,7,3,4,4,6,9,16,28,41,53,58,53,41,28,16,9,6,4,4,2,6,12,22,34,45,49,45,34,22,12,6,2,8,15,27,40,52,57,52,40,27,15,8,4,9,24,59,130,242,378,495,541,495,378,242,130,59,24,9,4,1,1,2,5,12,22,33,44,48,44,33,22,12,5,2,1,1,4,7,14,26,39,51,56,51,39,26,14,7,4,6,12,22,34,44,48,44,34,22,12,6,8,14,24,35,45,49,45,35,24,14,8,10,16,26,38,49,53,49,38,26,16,10,54,120,225,353,462,506,462,353,225,120,54,7,21,56,125,234,367,481,526,481,367,234,125,56,21,7,7,13,24,36,47,51,47,36,24,13,7],G:[2,2,4,7,12,18,24,26,24,18,12,7,4,2,2,3,3,3,5,8,13,19,24,26,24,19,13,8,5,3,3,3,3,3,5,8,13,19,24,26,24,19,13,8,5,3,3,1,3,6,12,18,23,26,23,18,12,6,3,1,4,8,14,20,26,29,26,20,14,8,4,1,1,2,3,7,12,19,24,27,24,19,12,7,3,2,1,1,1,3,6,11,16,21,23,21,16,11,6,3,1,49,109,203,319,417,456,417,319,203,109,49,6,19,50,113,211,330,433,473,433,330,211,113,50,19,6,56,120,221,344,449,491,449,344,221,120,56,7,11,16,22,28,30,28,22,16,11,7,1,1,1,3,6,12,18,23,25,23,18,12,6,3,1,1,1,7,10,15,21,27,29,27,21,15,10,7,1,1,2,3,7,13,20,25,28,25,20,13,7,3,2,1,1,3,6,11,18,23,25,23,18,11,6,3,21,53,117,218,340,444,486,444,340,218,117,53,21,3,4,5,9,14,21,27,29,27,21,14,9,5,4,3,1,3,6,12,18,24,26,24,18,12,6,3,1,4,6,9,14,20,25,27,25,20,14,9,6,4,21,52,112,207,323,422,461,422,323,207,112,52,21,5,9,15,22,27,30,27,22,15,9,5,1,2,3,7,12,18,24,26,24,18,12,7,3,2,1,5,8,13,19,24,26,24,19,13,8,5,4,8,13,20,26,28,26,20,13,8,4,4,4,6,9,15,21,27,29,27,21,15,9,6,4,4,7,10,15,20,25,27,25,20,15,10,7,1,1,2,3,7,13,20,26,28,26,20,13,7,3,2,1,1,19,50,110,205,321,420,460,420,321,205,110,50,19,49,109,204,320,420,459,420,320,204,109,49,20,50,111,208,325,425,465,425,325,208,111,50,20,5,7,10,15,21,26,28,26,21,15,10,7,5,4,7,12,18,23,25,23,18,12,7,4,4,6,9,15,21,27,29,27,21,15,9,6,4,3,3,3,5,8,13,18,23,25,23,18,13,8,5,3,3,3,6,10,15,22,28,30,28,22,15,10,6,8,21,52,114,211,330,432,472,432,330,211,114,52,21,8,3,7,12,19,25,27,25,19,12,7,3,4,6,10,15,21,27,29,27,21,15,10,6,4,4,8,14,20,26,29,26,20,14,8,4,24,57,122,225,350,457,499,457,350,225,122,57,24,6,10,16,22,28,30,28,22,16,10,6,6,9,15,21,27,29,27,21,15,9,6,4,4,6,9,14,20,25,27,25,20,14,9,6,4,4,1,1,2,3,7,12,19,24,27,24,19,12,7,3,2,1,1,3,3,3,5,8,14,20,25,28,25,20,14,8,5,3,3,3,4,4,5,6,10,15,22,28,30,28,22,15,10,6,5,4,4,3,3,5,8,13,19,24,26,24,19,13,8,5,3,3,2,7,22,58,129,242,379,496,543,496,379,242,129,58,22,7,2,53,117,219,342,448,490,448,342,219,117,53,20,54,121,226,355,465,508,465,355,226,121,54,20,5,5,5,7,10,15,21,26,28,26,21,15,10,7,5,5,5,5,8,14,20,25,27,25,20,14,8,5,5,9,15,21,27,30,27,21,15,9,5,4,4,6,10,15,21,27,29,27,21,15,10,6,4,4,4,6,9,14,20,25,27,25,20,14,9,6,4,53,114,210,327,426,466,426,327,210,114,53,3,4,5,9,14,21,26,29,26,21,14,9,5,4,3,5,7,10,15,21,26,28,26,21,15,10,7,5,4,6,9,15,21,26,29,26,21,15,9,6,4,26,62,134,248,386,505,552,505,386,248,134,62,26,5,7,10,15,22,27,29,27,22,15,10,7,5,3,3,3,5,8,13,19,24,26,24,19,13,8,5,3,3,3,3,5,8,13,19,24,26,24,19,13,8,5,3,5,6,7,11,16,23,29,31,29,23,16,11,7,6,5,2,3,4,8,14,20,26,29,26,20,14,8,4,3,2,4,5,6,10,16,22,28,31,28,22,16,10,6,5,4,51,112,210,328,429,469,429,328,210,112,51,23,59,130,243,380,498,545,498,380,243,130,59,23,5,9,21,51,111,206,321,419,458,419,321,206,111,51,21,9,5,4,5,6,10,16,22,28,31,28,22,16,10,6,5,4,5,5,7,10,15,20,25,27,25,20,15,10,7,5,5,1,1,1,3,6,11,18,23,25,23,18,11,6,3,1,1,1,4,4,4,6,9,14,20,26,28,26,20,14,9,6,4,4,4,2,2,2,4,7,12,18,24,26,24,18,12,7,4,2,2,2,5,9,22,54,117,217,339,443,485,443,339,217,117,54,22,9,5,2,3,7,12,19,25,27,25,19,12,7,3,2,5,9,14,21,26,29,26,21,14,9,5,3,3,3,5,8,14,20,26,28,26,20,14,8,5,3,3,3,2,7,20,54,121,226,354,464,507,464,354,226,121,54,20,7,2,2,4,7,13,19,24,27,24,19,13,7,4,2,4,7,12,18,23,25,23,18,12,7,4,6,9,15,21,26,29,26,21,15,9,6,7,11,16,22,28,30,28,22,16,11,7,3,6,11,16,21,23,21,16,11,6,3,1,2,3,7,12,19,25,27,25,19,12,7,3,2,1,50,110,206,322,422,461,422,322,206,110,50],T:[7,20,51,113,212,331,433,474,433,331,212,113,51,20,7,3,3,3,4,5,7,9,12,12,12,9,7,5,4,3,3,3,3,3,3,5,7,9,11,12,11,9,7,5,3,3,3,1,2,3,5,8,10,11,10,8,5,3,2,1,3,4,6,9,11,12,11,9,6,4,3,1,1,1,2,3,5,8,11,11,11,8,5,3,2,1,1,1,1,1,3,5,7,9,10,9,7,5,3,1,1,2,3,5,7,10,11,10,7,5,3,2,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,5,7,9,11,13,14,13,11,9,7,5,56,120,221,343,448,490,448,343,221,120,56,2,7,21,57,127,239,374,490,536,490,374,239,127,57,21,7,2,58,125,231,360,470,514,470,360,231,125,58,1,1,1,2,3,5,7,9,10,9,7,5,3,2,1,1,1,2,3,5,7,9,10,9,7,5,3,2,3,4,5,7,10,12,13,12,10,7,5,4,3,8,21,52,113,211,329,431,471,431,329,211,113,52,21,8,1,1,3,5,7,9,10,9,7,5,3,1,1,4,5,6,8,10,13,13,13,10,8,6,5,4,4,5,6,8,11,13,14,13,11,8,6,5,4,60,131,244,381,499,545,499,381,244,131,60,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,4,5,7,9,12,13,12,9,7,5,4,3,4,6,8,11,11,11,8,6,4,3,4,4,4,6,8,10,12,13,12,10,8,6,4,4,4,5,7,9,11,13,14,13,11,9,7,5,1,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,1,2,3,4,6,9,11,12,11,9,6,4,3,2,2,3,5,8,10,11,10,8,5,3,2,2,2,4,6,8,10,11,10,8,6,4,2,2,24,57,123,228,355,463,506,463,355,228,123,57,24,57,126,236,369,483,528,483,369,236,126,57,24,60,130,242,377,493,539,493,377,242,130,60,24,3,3,3,4,5,7,9,12,13,12,9,7,5,4,3,3,3,5,6,8,10,12,13,12,10,8,6,5,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,53,119,222,348,456,499,456,348,222,119,53,4,5,6,8,10,13,13,13,10,8,6,5,4,2,4,6,8,10,11,10,8,6,4,2,5,6,7,9,11,14,14,14,11,9,7,6,5,56,121,224,350,457,500,457,350,224,121,56,5,6,8,10,12,13,12,10,8,6,5,4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,1,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,1,3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,3,4,4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,4,3,3,3,5,7,9,11,12,11,9,7,5,3,3,3,1,1,1,2,3,5,7,10,10,10,7,5,3,2,1,1,1,3,4,6,8,10,11,10,8,6,4,3,1,2,3,5,8,10,11,10,8,5,3,2,1,6,11,25,59,127,235,366,478,522,478,366,235,127,59,25,11,6,59,128,239,373,488,534,488,373,239,128,59,55,121,225,351,459,502,459,351,225,121,55,4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,4,5,6,8,11,13,14,13,11,8,6,5,4,6,7,9,11,14,14,14,11,9,7,6,9,22,56,123,229,358,468,512,468,358,229,123,56,22,9,5,5,7,9,11,13,14,13,11,9,7,5,5,4,5,6,8,10,13,13,13,10,8,6,5,4,5,6,7,9,11,14,14,14,11,9,7,6,5,22,53,113,208,323,422,461,422,323,208,113,53,22,3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,2,2,3,4,6,8,11,11,11,8,6,4,3,2,2,4,4,5,6,8,10,12,13,12,10,8,6,5,4,4,3,4,6,9,11,12,11,9,6,4,3,2,3,4,6,9,11,12,11,9,6,4,3,2,4,4,4,4,6,8,10,12,13,12,10,8,6,4,4,4,4,10,25,61,133,247,385,504,551,504,385,247,133,61,25,10,11,24,57,123,228,354,463,506,463,354,228,123,57,24,11,2,6,20,52,116,218,341,447,489,447,341,218,116,52,20,6,2,4,4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,4,2,2,2,3,4,6,9,11,12,11,9,6,4,3,2,2,2,4,4,4,5,6,8,11,14,14,14,11,8,6,5,4,4,4,21,54,122,228,358,469,513,469,358,228,122,54,21,4,5,7,9,12,12,12,9,7,5,4,3,3,3,4,5,7,9,12,12,12,9,7,5,4,3,3,3,1,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,1,19,49,108,202,316,414,453,414,316,202,108,49,19,3,4,6,8,11,11,11,8,6,4,3,5,6,8,11,13,14,13,11,8,6,5,6,7,9,12,14,15,14,12,9,7,6,2,3,5,7,9,10,9,7,5,3,2,1,1,2,3,5,7,9,10,9,7,5,3,2,1,1,3,4,6,8,11,11,11,8,6,4,3],peak:[7,23,39,53,65,79,94,106,119,132,143,157,171,185,199,211,225,239,252,265,277,290,303,314,327,340,354,369,381,393,406,418,430,445,459,472,485,497,509,521,533,544,557,573,590,607,623,639,653,665,680,694,705,718,732,744,757,771,784,797,810,825,840,854,869,884,897,909,924,940,955,971,988,1005,1022,1037,1049,1063,1080,1095,1107,1118,1129,1140,1153,1166]},index:4,counter:7,measureText:74},{id:"R1-0000-5678",fill:"rgb(51,255,255)",outline:"rgb(0,0,0)",dir:"right",offset:126,gaps:[[5,1],[58,1]],sequence:"CCCGGTTTACGTACGTAAACCCGGGTTTACGTACGTAAACCCGGGTTTACGTACGTAACCCGGGTTTAAACC",coordinate:150,trace:{A:[14,26,46,70,91,99,91,70,46,26,14,6,12,26,47,74,96,105,96,74,47,26,12,6,4,10,23,43,67,87,95,87,67,43,23,10,4,4,10,22,42,65,85,93,85,65,42,22,10,4,13,26,48,73,95,104,95,73,48,26,13,6,9,16,30,52,78,101,111,101,78,52,30,16,9,6,13,26,46,71,92,101,92,71,46,26,13,1,2,4,11,24,45,70,92,100,92,70,45,24,11,4,2,1,52,115,213,332,435,475,435,332,213,115,52,4,5,7,13,25,44,67,87,95,87,67,44,25,13,7,5,4,13,27,49,77,100,109,100,77,49,27,13,6,12,25,44,68,88,96,88,68,44,25,12,6,24,60,130,242,377,493,539,493,377,242,130,60,24,12,25,44,68,89,97,89,68,44,25,12,4,7,13,27,48,74,96,105,96,74,48,27,13,7,4,4,6,13,25,45,69,90,98,90,69,45,25,13,6,4,3,7,21,53,117,218,341,446,488,446,341,218,117,53,21,7,3,9,23,58,127,237,370,483,529,483,370,237,127,58,23,9,57,123,228,355,464,508,464,355,228,123,57,3,5,12,26,47,73,95,103,95,73,47,26,12,5,3,4,10,22,41,64,84,92,84,64,41,22,10,4,10,22,41,63,83,91,83,63,41,22,10,1,2,4,10,22,41,64,83,91,83,64,41,22,10,4,2,1,4,5,8,14,28,50,76,99,108,99,76,50,28,14,8,5,4,4,6,13,25,45,70,90,99,90,70,45,25,13,6,4,10,22,41,64,84,92,84,64,41,22,10,4,11,24,44,69,90,99,90,69,44,24,11,4,3,6,12,26,48,74,97,105,97,74,48,26,12,6,3,52,116,216,338,443,484,443,338,216,116,52,5,6,8,15,29,50,76,98,107,98,76,50,29,15,8,6,5,5,11,25,46,72,94,103,94,72,46,25,11,5,11,25,46,72,94,103,94,72,46,25,11,10,23,56,121,223,348,455,498,455,348,223,121,56,23,10,2,3,6,13,27,50,77,100,109,100,77,50,27,13,6,3,2,3,6,13,26,48,75,98,107,98,75,48,26,13,6,3,1,2,5,11,25,46,72,95,104,95,72,46,25,11,5,2,1,11,24,58,124,229,357,466,509,466,357,229,124,58,24,11,21,54,119,223,349,457,500,457,349,223,119,54,21,19,49,109,202,317,414,453,414,317,202,109,49,19,2,3,6,13,27,50,78,101,110,101,78,50,27,13,6,3,2,1,2,4,10,22,41,64,84,92,84,64,41,22,10,4,2,1,4,5,7,13,25,44,67,87,95,87,67,44,25,13,7,5,4,6,8,15,28,48,73,94,102,94,73,48,28,15,8,6,10,23,42,66,86,94,86,66,42,23,10,5,11,23,42,65,85,93,85,65,42,23,11,5,4,6,12,25,44,68,88,96,88,68,44,25,12,6,4,7,13,27,48,75,97,106,97,75,48,27,13,7,3,6,13,27,50,77,101,110,101,77,50,27,13,6,3,58,129,241,377,494,540,494,377,241,129,58,5,12,26,48,75,99,108,99,75,48,26,12,5,5,12,25,45,70,92,100,92,70,45,25,12,5,5,6,8,15,28,49,74,96,104,96,74,49,28,15,8,6,5,59,129,241,376,492,538,492,376,241,129,59,1,2,4,11,24,44,69,91,99,91,69,44,24,11,4,2,1,6,8,14,27,46,69,90,98,90,69,46,27,14,8,6,16,29,51,78,100,109,100,78,51,29,16,5,10,24,58,126,233,363,475,519,475,363,233,126,58,24,10,5,58,129,243,380,498,545,498,380,243,129,58,12,24,45,69,90,98,90,69,45,24,12,8,15,28,48,73,94,102,94,73,48,28,15,8,2,5,12,25,47,73,96,105,96,73,47,25,12,5,2,15,29,51,78,101,110,101,78,51,29,15,8,15,29,51,78,102,111,102,78,51,29,15,8,11,24,44,67,88,96,88,67,44,24,11,10,23,42,66,86,94,86,66,42,23,10,5,6,8,15,28,48,73,94,103,94,73,48,28,15,8,6,5,8,14,27,46,70,90,98,90,70,46,27,14,8,25,60,129,239,372,486,532,486,372,239,129,60,25,9,21,51,110,204,319,416,455,416,319,204,110,51,21,9,56,119,220,343,448,489,448,343,220,119,56,3,4,7,14,28,50,78,101,110,101,78,50,28,14,7,4,3,14,28,51,79,103,112,103,79,51,28,14],C:[53,114,212,330,431,472,431,330,212,114,53,20,52,115,215,336,440,481,440,336,215,115,52,20,19,49,110,206,323,423,463,423,323,206,110,49,19,2,6,12,23,35,46,51,46,35,23,12,6,2,8,14,25,37,48,52,48,37,25,14,8,5,7,10,17,28,42,53,58,53,42,28,17,10,7,5,8,14,25,38,49,53,49,38,25,14,8,1,1,2,5,11,21,32,42,46,42,32,21,11,5,2,1,1,8,14,25,37,48,52,48,37,25,14,8,5,9,22,52,113,209,326,426,465,426,326,209,113,52,22,9,5,6,12,22,33,43,47,43,33,22,12,6,4,7,13,23,35,44,48,44,35,23,13,7,4,6,9,16,27,40,52,56,52,40,27,16,9,6,50,110,204,319,417,455,417,319,204,110,50,3,5,8,15,26,40,51,56,51,40,26,15,8,5,3,3,4,8,14,24,37,48,52,48,37,24,14,8,4,3,2,2,3,6,12,22,33,43,47,43,33,22,12,6,3,2,2,3,4,8,14,25,38,49,53,49,38,25,14,8,4,3,8,14,24,35,45,49,45,35,24,14,8,7,21,53,118,221,345,452,494,452,345,221,118,53,21,7,19,49,110,205,322,421,461,421,322,205,110,49,19,57,127,238,373,489,535,489,373,238,127,57,1,1,3,6,13,24,38,49,54,49,38,24,13,6,3,1,1,4,4,6,9,16,27,40,51,56,51,40,27,16,9,6,4,4,3,5,8,15,26,40,51,56,51,40,26,15,8,5,3,6,13,24,38,50,54,50,38,24,13,6,3,6,13,24,37,48,53,48,37,24,13,6,3,2,4,7,14,25,38,50,54,50,38,25,14,7,4,2,7,13,23,36,46,50,46,36,23,13,7,6,11,26,62,134,248,387,505,553,505,387,248,134,62,26,11,6,2,6,12,22,34,45,49,45,34,22,12,6,2,6,12,23,35,46,50,46,35,23,12,6,4,5,9,15,26,38,49,54,49,38,26,15,9,5,4,3,8,22,58,128,239,374,489,535,489,374,239,128,58,22,8,3,2,3,7,14,24,37,48,52,48,37,24,14,7,3,2,1,1,3,6,13,24,38,49,54,49,38,24,13,6,3,1,1,5,7,10,17,28,41,53,57,53,41,28,17,10,7,5,3,7,13,24,37,48,52,48,37,24,13,7,3,3,6,12,22,33,43,47,43,33,22,12,6,3,3,7,21,53,118,221,345,452,494,452,345,221,118,53,21,7,3,2,6,18,49,109,204,320,419,458,419,320,204,109,49,18,6,2,5,9,21,52,111,206,321,420,459,420,321,206,111,52,21,9,5,5,7,10,17,28,41,52,57,52,41,28,17,10,7,5,6,13,25,38,50,55,50,38,25,13,6,3,6,12,22,34,44,48,44,34,22,12,6,3,3,5,8,15,25,38,50,54,50,38,25,15,8,5,3,4,8,14,25,37,48,52,48,37,25,14,8,4,2,4,7,14,24,37,48,53,48,37,24,14,7,4,2,6,12,22,33,43,47,43,33,22,12,6,22,57,128,240,376,492,538,492,376,240,128,57,22,3,6,12,22,33,43,47,43,33,22,12,6,3,5,5,6,9,15,25,36,46,50,46,36,25,15,9,6,5,5,8,14,24,36,47,51,47,36,24,14,8,2,6,20,52,116,217,341,446,488,446,341,217,116,52,20,6,2,5,6,10,16,26,39,49,53,49,39,26,16,10,6,5,9,15,25,37,47,51,47,37,25,15,9,4,4,5,9,15,25,38,49,53,49,38,25,15,9,5,4,4,6,12,22,34,45,49,45,34,22,12,6,54,119,221,346,453,496,453,346,221,119,54,25,61,131,242,376,492,538,492,376,242,131,61,25,7,21,55,123,230,361,473,517,473,361,230,123,55,21,7,9,16,27,41,52,57,52,41,27,16,9,5,8,14,24,35,45,49,45,35,24,14,8,5,7,13,24,36,47,51,47,36,24,13,7,6,12,23,35,46,50,46,35,23,12,6,5,5,6,10,16,27,39,50,54,50,39,27,16,10,6,5,5,6,10,16,26,39,49,53,49,39,26,16,10,6,6,9,15,25,37,46,50,46,37,25,15,9,6,4,5,9,15,25,37,47,51,47,37,25,15,9,5,4,10,16,27,40,50,55,50,40,27,16,10,4,9,23,58,128,238,371,485,531,485,371,238,128,58,23,9,4,58,128,237,371,485,530,485,371,237,128,58],G:[6,9,14,21,26,28,26,21,14,9,6,2,4,7,12,18,23,25,23,18,12,7,4,2,2,3,7,13,20,26,28,26,20,13,7,3,2,20,53,119,222,349,457,499,457,349,222,119,53,20,58,126,235,367,480,525,480,367,235,126,58,5,6,7,11,16,23,28,30,28,23,16,11,7,6,5,5,8,13,20,25,27,25,20,13,8,5,1,1,2,3,7,12,18,24,26,24,18,12,7,3,2,1,1,5,8,14,20,25,27,25,20,14,8,5,4,4,5,6,10,15,22,27,29,27,22,15,10,6,5,4,4,51,113,211,331,433,473,433,331,211,113,51,3,5,8,14,20,25,27,25,20,14,8,5,3,4,6,9,14,20,25,27,25,20,14,9,6,4,5,8,13,20,25,27,25,20,13,8,5,9,22,56,123,228,356,466,510,466,356,228,123,56,22,9,3,4,5,9,14,21,27,29,27,21,14,9,5,4,3,2,2,2,4,7,12,19,24,26,24,19,12,7,4,2,2,2,3,4,5,9,14,21,27,29,27,21,14,9,5,4,3,6,10,15,22,27,29,27,22,15,10,6,2,2,4,7,12,18,23,25,23,18,12,7,4,2,2,2,3,7,12,19,24,26,24,19,12,7,3,2,3,7,13,20,25,28,25,20,13,7,3,2,7,20,53,119,223,350,459,502,459,350,223,119,53,20,7,2,5,9,21,51,111,205,319,417,456,417,319,205,111,51,21,9,5,8,21,53,116,215,336,439,480,439,336,215,116,53,21,8,3,6,11,17,23,25,23,17,11,6,3,2,3,7,12,18,24,26,24,18,12,7,3,2,2,2,4,7,13,19,25,27,25,19,13,7,4,2,2,4,7,12,19,24,26,24,19,12,7,4,5,5,6,7,11,17,24,30,32,30,24,17,11,7,6,5,5,21,56,124,233,365,478,523,478,365,233,124,56,21,3,7,12,19,24,26,24,19,12,7,3,4,4,6,9,14,20,25,27,25,20,14,9,6,4,4,2,2,2,4,7,13,19,24,27,24,19,13,7,4,2,2,2,7,19,50,110,205,321,420,459,420,321,205,110,50,19,7,1,1,1,3,6,11,18,23,25,23,18,11,6,3,1,1,1,5,6,7,11,16,23,28,30,28,23,16,11,7,6,5,2,4,7,12,19,24,26,24,19,12,7,4,2,3,4,8,14,21,27,29,27,21,14,8,4,3,2,2,2,4,7,13,19,24,26,24,19,13,7,4,2,2,2,1,1,2,3,7,13,19,25,28,25,19,13,7,3,2,1,1,4,4,5,6,10,15,21,27,29,27,21,15,10,6,5,4,4,10,22,52,112,206,321,419,458,419,321,206,112,52,22,10,57,127,238,373,488,534,488,373,238,127,57,20,51,112,209,327,428,468,428,327,209,112,51,20,3,4,5,9,14,21,26,28,26,21,14,9,5,4,3,3,5,8,13,19,25,27,25,19,13,8,5,3,2,2,4,7,12,19,24,26,24,19,12,7,4,2,2,4,8,13,20,25,28,25,20,13,8,4,2,3,7,12,18,24,26,24,18,12,7,3,2,21,54,119,222,347,454,496,454,347,222,119,54,21,5,5,5,7,10,15,22,27,29,27,22,15,10,7,5,5,5,5,9,15,21,27,30,27,21,15,9,5,1,1,2,3,7,12,18,24,26,24,18,12,7,3,2,1,1,11,24,57,123,227,354,463,506,463,354,227,123,57,24,11,7,10,16,22,27,30,27,22,16,10,7,4,4,4,6,9,15,21,26,29,26,21,15,9,6,4,4,4,3,7,12,19,24,26,24,19,12,7,3,4,7,12,17,22,24,22,17,12,7,4,6,7,11,17,23,29,32,29,23,17,11,7,6,1,2,3,7,12,19,25,27,25,19,12,7,3,2,1,55,120,222,346,452,494,452,346,222,120,55,23,57,123,229,357,466,510,466,357,229,123,57,23,53,118,220,344,450,492,450,344,220,118,53,3,6,12,18,24,26,24,18,12,6,3,5,5,5,7,11,16,22,28,30,28,22,16,11,7,5,5,5,5,7,10,16,22,27,30,27,22,16,10,7,5,6,7,11,17,24,30,32,30,24,17,11,7,6,4,4,6,9,14,19,24,26,24,19,14,9,6,4,4,7,10,15,22,27,29,27,22,15,10,7,3,3,3,5,9,14,20,26,28,26,20,14,9,5,3,3,3,5,8,14,20,25,28,25,20,14,8,5],T:[5,6,8,11,13,14,13,11,8,6,5,2,2,4,6,8,10,11,10,8,6,4,2,2,1,2,3,5,8,10,11,10,8,5,3,2,1,1,1,3,5,7,9,10,9,7,5,3,1,1,4,5,7,10,12,13,12,10,7,5,4,10,24,56,121,223,347,453,495,453,347,223,121,56,24,10,51,112,208,324,424,463,424,324,208,112,51,2,6,19,49,109,205,321,421,460,421,321,205,109,49,19,6,2,4,5,7,9,11,12,11,9,7,5,4,4,4,4,4,6,8,10,12,13,12,10,8,6,4,4,4,4,3,4,6,9,11,12,11,9,6,4,3,22,56,122,227,355,464,508,464,355,227,122,56,22,4,5,6,8,11,13,14,13,11,8,6,5,4,4,5,7,9,11,12,11,9,7,5,4,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,8,21,52,113,210,328,429,469,429,328,210,113,52,21,8,2,2,2,3,4,6,8,10,11,10,8,6,4,3,2,2,2,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,5,6,8,11,13,14,13,11,8,6,5,2,2,3,4,6,9,11,12,11,9,6,4,3,2,2,1,1,3,5,7,9,10,9,7,5,3,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,1,2,3,5,8,10,11,10,8,5,3,2,1,1,1,4,4,4,4,6,8,10,12,13,12,10,8,6,4,4,4,4,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,48,108,202,316,414,453,414,316,202,108,48,20,52,116,218,341,446,488,446,341,218,116,52,20,7,20,51,112,209,327,428,468,428,327,209,112,51,20,7,3,4,6,9,12,12,12,9,6,4,3,5,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,5,1,2,3,5,8,10,11,10,8,5,3,2,1,56,126,237,371,486,531,486,371,237,126,56,4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,2,2,2,2,4,6,8,10,11,10,8,6,4,2,2,2,2,2,2,3,4,6,9,11,12,11,9,6,4,3,2,2,2,6,19,49,110,205,322,422,461,422,322,205,110,49,19,6,2,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,2,3,4,6,8,10,11,10,8,6,4,3,2,2,2,4,6,8,10,11,10,8,6,4,2,2,2,2,2,3,4,6,9,11,12,11,9,6,4,3,2,2,2,1,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,1,4,4,4,5,6,8,11,13,14,13,11,8,6,5,4,4,4,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,2,3,5,8,10,11,10,8,5,3,2,2,3,4,6,9,11,12,11,9,6,4,3,2,9,22,55,120,223,348,455,497,455,348,223,120,55,22,9,23,57,126,234,365,477,522,477,365,234,126,57,23,8,22,58,128,239,374,490,536,490,374,239,128,58,22,8,3,4,6,9,11,12,11,9,6,4,3,1,2,3,5,8,10,11,10,8,5,3,2,1,2,3,4,6,9,11,12,11,9,6,4,3,2,6,10,22,52,111,205,320,417,456,417,320,205,111,52,22,10,6,4,5,7,9,12,12,12,9,7,5,4,1,1,1,1,3,5,7,9,10,9,7,5,3,1,1,1,1,5,5,6,7,9,12,14,15,14,12,9,7,6,5,5,54,117,215,335,437,478,437,335,215,117,54,4,4,4,4,6,8,10,12,13,12,10,8,6,4,4,4,4,2,3,5,8,11,11,11,8,5,3,2,3,4,6,9,11,12,11,9,6,4,3,5,5,7,9,11,13,14,13,11,9,7,5,5,1,1,2,3,5,7,10,10,10,7,5,3,2,1,1,5,6,8,11,13,14,13,11,8,6,5,4,4,6,8,10,12,13,12,10,8,6,4,4,3,4,6,9,11,12,11,9,6,4,3,55,123,231,363,475,520,475,363,231,123,55,6,10,24,56,121,223,347,453,495,453,347,223,121,56,24,10,6,23,54,115,213,331,432,472,432,331,213,115,54,23,5,6,7,9,11,14,14,14,11,9,7,6,5,4,4,5,6,8,10,12,13,12,10,8,6,5,4,4,6,7,9,12,14,15,14,12,9,7,6,3,3,3,4,5,7,10,12,13,12,10,7,5,4,3,3,3,4,5,7,10,12,13,12,10,7,5,4],peak:[5,17,30,43,55,68,81,95,109,123,137,149,162,174,187,202,218,234,247,260,274,286,300,317,333,346,358,372,385,399,414,426,439,455,471,487,503,517,530,545,562,579,595,608,620,634,648,662,675,687,700,715,729,743,759,772,786,800,811,823,837,850,862,874,885,899,914,927,941,954,968,982]},index:5,counter:8,measureText:74}],startY:137,endY:226,displayedFeatures:6,totalFeatures:6},{name:"Copy Number Variation",type:"heatmap",autowidth:true,height:20,data:[{id:"Cell Line-123",offset:10,data:[7,5,5,5,6,7,9,8,8,8,8,5,7,9,15,15,16,9,9,7,8,10,9,21,22,22,24,20,24,26,24,25,24,31,29,33,33,33,33,33,20,17,19,18,18,18,27,23,31,26,31,31,31,34,32,31,30,30,30,30,30,24,24,20,21,17,17,27,29,25,31,31,31],index:0,counter:9,measureText:67}],startY:281,endY:281,displayedFeatures:1,totalFeatures:1},{name:"Tissue Distribution (Heart, Liver, Kidney)",type:"heatmap",height:20,data:[{id:"123456_at",offset:100,data:[25,35,46],index:0,counter:10,measureText:56},{id:"234567_at",offset:151,data:[80,45,10],index:1,counter:11,measureText:56},{id:"345678_at",offset:181,data:[65,46,29],index:2,counter:12,measureText:56}],startY:336,endY:386,displayedFeatures:3,totalFeatures:3},{name:"Another CNV",type:"line",autowidth:true,height:20,fill:["rgb(255,0,0)","rgb(0,255,0)"],outline:["rgb(255,0,0)","rgb(0,255,0)"],data:[{id:"Cell Line-124",offset:10,data:[30,31,31,33,29,29,30,31,32,33,33,31,31,29,30,30,27,32,31,31,28,31,31,29,31,31,31,26,25,29,26,26,21,26,21,31,31,28,28,23,25,28,28,31,33,33,32,31,31,31,24,28,28,28,31,32,32,31,31,28,24,28,24,29,31,29,31],index:0,counter:13,measureText:67},{id:"Cell Line-125",offset:10,data:[29,31,31,31,26,25,29,26,26,21,26,21,31,31,28,28,23,25,28,28,31,33,33,32,31,31,31,24,28,28,28,31,32,32,31,31,28,24,28,24,29,31,29,31,30,31,31,33,29,29,30,31,32,33,33,31,31,29,30,30,27,32,31,31,28,31,31],index:1,counter:14,measureText:67}],startY:441,endY:466,displayedFeatures:2,totalFeatures:2},{type:"bar",height:20,fill:["rgb(255,0,0)","rgb(0,0,255)","rgb(255,255,0)"],outline:["rgb(255,0,0)","rgb(0,0,255)","rgb(255,255,0)"],data:[{id:"123456_at",offset:100,data:[25,35,46],index:0,counter:15,measureText:56},{id:"234567_at",offset:151,data:[80,45,10],index:1,counter:16,measureText:56},{id:"345678_at",offset:181,data:[65,46,29],index:2,counter:17,measureText:56}],startY:501,endY:551,displayedFeatures:3,totalFeatures:3},{name:"Clones",type:"box",data:[{id:"clone-1234567",fill:"rgb(255,255,51)",outline:"rgb(0,0,0)",dir:"left",data:[[121,196]],index:0,counter:18,start:121,end:196,measureText:77},{id:"clone-2345678",fill:"rgb(255,255,51)",outline:"rgb(0,0,0)",dir:"right",data:[[371,400]],landmarks:[{offset:157,text:"Gap "},{offset:137,text:"Insertion "}],index:1,counter:19,start:371,end:400,measureText:77}],startY:606,endY:619,displayedFeatures:2,totalFeatures:2},{name:"SNP Location",type:"triangle",data:[{id:"SNP123",fill:"rgb(100,0,0)",outline:"rgb(0,0,0)",offset:23,index:0,counter:20,measureText:43},{id:"SNP234",fill:"rgb(100,0,0)",outline:"rgb(0,0,0)",offset:45,index:1,counter:21,measureText:43},{id:"SNP345",fill:"rgb(100,0,0)",outline:"rgb(0,0,0)",offset:135,index:2,counter:22,measureText:43},{id:"SNP456",fill:"rgb(100,0,0)",outline:"rgb(0,0,0)",offset:172,index:3,counter:23,measureText:43},{id:"SNP567",fill:"rgb(100,0,0)",outline:"rgb(0,0,0)",offset:180,index:4,counter:24,measureText:43},{id:"SNP678",fill:"rgb(100,0,0)",outline:"rgb(0,0,0)",offset:190,index:5,counter:25,measureText:43},{id:"SNP789",fill:"rgb(100,0,0)",outline:"rgb(0,0,0)",offset:195,index:6,counter:26,measureText:43}],startY:674,endY:782,displayedFeatures:7,totalFeatures:7},{name:"SNP Sequences",type:"sequence",subtype:"DNA",data:[{id:"SNP123",offset:19,sequence:"CACA[AT]GCACCTTGTA",index:0,counter:27,measureText:43},{id:"SNP234",offset:41,sequence:"ATCG[TG]AATA",index:1,counter:28,measureText:43},{id:"SNP789",offset:116,sequence:"GCCC[CT]AGGG",index:2,counter:29,measureText:43}]}]};this.dataSetIris={x:{Species:["setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","setosa","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","versicolor","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica","virginica"]},y:{vars:["Sepal.Length","Sepal.Width","Petal.Length","Petal.Width"],smps:["s1","s2","s3","s4","s5","s6","s7","s8","s9","s10","s11","s12","s13","s14","s15","s16","s17","s18","s19","s20","s21","s22","s23","s24","s25","s26","s27","s28","s29","s30","s31","s32","s33","s34","s35","s36","s37","s38","s39","s40","s41","s42","s43","s44","s45","s46","s47","s48","s49","s50","s51","s52","s53","s54","s55","s56","s57","s58","s59","s60","s61","s62","s63","s64","s65","s66","s67","s68","s69","s70","s71","s72","s73","s74","s75","s76","s77","s78","s79","s80","s81","s82","s83","s84","s85","s86","s87","s88","s89","s90","s91","s92","s93","s94","s95","s96","s97","s98","s99","s100","s101","s102","s103","s104","s105","s106","s107","s108","s109","s110","s111","s112","s113","s114","s115","s116","s117","s118","s119","s120","s121","s122","s123","s124","s125","s126","s127","s128","s129","s130","s131","s132","s133","s134","s135","s136","s137","s138","s139","s140","s141","s142","s143","s144","s145","s146","s147","s148","s149","s150"],data:[[5.1,4.9,4.7,4.6,5,5.4,4.6,5,4.4,4.9,5.4,4.8,4.8,4.3,5.8,5.7,5.4,5.1,5.7,5.1,5.4,5.1,4.6,5.1,4.8,5,5,5.2,5.2,4.7,4.8,5.4,5.2,5.5,4.9,5,5.5,4.9,4.4,5.1,5,4.5,4.4,5,5.1,4.8,5.1,4.6,5.3,5,7,6.4,6.9,5.5,6.5,5.7,6.3,4.9,6.6,5.2,5,5.9,6,6.1,5.6,6.7,5.6,5.8,6.2,5.6,5.9,6.1,6.3,6.1,6.4,6.6,6.8,6.7,6,5.7,5.5,5.5,5.8,6,5.4,6,6.7,6.3,5.6,5.5,5.5,6.1,5.8,5,5.6,5.7,5.7,6.2,5.1,5.7,6.3,5.8,7.1,6.3,6.5,7.6,4.9,7.3,6.7,7.2,6.5,6.4,6.8,5.7,5.8,6.4,6.5,7.7,7.7,6,6.9,5.6,7.7,6.3,6.7,7.2,6.2,6.1,6.4,7.2,7.4,7.9,6.4,6.3,6.1,7.7,6.3,6.4,6,6.9,6.7,6.9,5.8,6.8,6.7,6.7,6.3,6.5,6.2,5.9],[3.5,3,3.2,3.1,3.6,3.9,3.4,3.4,2.9,3.1,3.7,3.4,3,3,4,4.4,3.9,3.5,3.8,3.8,3.4,3.7,3.6,3.3,3.4,3,3.4,3.5,3.4,3.2,3.1,3.4,4.1,4.2,3.1,3.2,3.5,3.6,3,3.4,3.5,2.3,3.2,3.5,3.8,3,3.8,3.2,3.7,3.3,3.2,3.2,3.1,2.3,2.8,2.8,3.3,2.4,2.9,2.7,2,3,2.2,2.9,2.9,3.1,3,2.7,2.2,2.5,3.2,2.8,2.5,2.8,2.9,3,2.8,3,2.9,2.6,2.4,2.4,2.7,2.7,3,3.4,3.1,2.3,3,2.5,2.6,3,2.6,2.3,2.7,3,2.9,2.9,2.5,2.8,3.3,2.7,3,2.9,3,3,2.5,2.9,2.5,3.6,3.2,2.7,3,2.5,2.8,3.2,3,3.8,2.6,2.2,3.2,2.8,2.8,2.7,3.3,3.2,2.8,3,2.8,3,2.8,3.8,2.8,2.8,2.6,3,3.4,3.1,3,3.1,3.1,3.1,2.7,3.2,3.3,3,2.5,3,3.4,3],[1.4,1.4,1.3,1.5,1.4,1.7,1.4,1.5,1.4,1.5,1.5,1.6,1.4,1.1,1.2,1.5,1.3,1.4,1.7,1.5,1.7,1.5,1,1.7,1.9,1.6,1.6,1.5,1.4,1.6,1.6,1.5,1.5,1.4,1.5,1.2,1.3,1.4,1.3,1.5,1.3,1.3,1.3,1.6,1.9,1.4,1.6,1.4,1.5,1.4,4.7,4.5,4.9,4,4.6,4.5,4.7,3.3,4.6,3.9,3.5,4.2,4,4.7,3.6,4.4,4.5,4.1,4.5,3.9,4.8,4,4.9,4.7,4.3,4.4,4.8,5,4.5,3.5,3.8,3.7,3.9,5.1,4.5,4.5,4.7,4.4,4.1,4,4.4,4.6,4,3.3,4.2,4.2,4.2,4.3,3,4.1,6,5.1,5.9,5.6,5.8,6.6,4.5,6.3,5.8,6.1,5.1,5.3,5.5,5,5.1,5.3,5.5,6.7,6.9,5,5.7,4.9,6.7,4.9,5.7,6,4.8,4.9,5.6,5.8,6.1,6.4,5.6,5.1,5.6,6.1,5.6,5.5,4.8,5.4,5.6,5.1,5.1,5.9,5.7,5.2,5,5.2,5.4,5.1],[0.2,0.2,0.2,0.2,0.2,0.4,0.3,0.2,0.2,0.1,0.2,0.2,0.1,0.1,0.2,0.4,0.4,0.3,0.3,0.3,0.2,0.4,0.2,0.5,0.2,0.2,0.4,0.2,0.2,0.2,0.2,0.4,0.1,0.2,0.2,0.2,0.2,0.1,0.2,0.2,0.3,0.3,0.2,0.6,0.4,0.3,0.2,0.2,0.2,0.2,1.4,1.5,1.5,1.3,1.5,1.3,1.6,1,1.3,1.4,1,1.5,1,1.4,1.3,1.4,1.5,1,1.5,1.1,1.8,1.3,1.5,1.2,1.3,1.4,1.4,1.7,1.5,1,1.1,1,1.2,1.6,1.5,1.6,1.5,1.3,1.3,1.3,1.2,1.4,1.2,1,1.3,1.2,1.3,1.3,1.1,1.3,2.5,1.9,2.1,1.8,2.2,2.1,1.7,1.8,1.8,2.5,2,1.9,2.1,2,2.4,2.3,1.8,2.2,2.3,1.5,2.3,2,2,1.8,2.1,1.8,1.8,1.8,2.1,1.6,1.9,2,2.2,1.5,1.4,2.3,2.4,1.8,1.8,2.1,2.4,2.3,1.9,2.3,2.5,2.3,1.9,2,2.3,1.8]],desc:["centimeters"]},m:{Name:"Anderson's Iris data set",Description:"The data set consists of 50 samples from each of three species of Iris (Iris setosa, Iris virginica and Iris versicolor). Four features were measured from each sample: the length and the width of the sepals and petals, in centimetres.",Reference:"R. A. Fisher (1936). The use of multiple measurements in taxonomic problems. Annals of Eugenics 7 (2): 179–188."}};this.dataSetScents={x:{Sex:["M","F","M","M","M","F","F","F","M","F","F","F","F","M","M","M","M","M","F","F","M"],Smoker:["N","Y","N","N","N","Y","N","N","N","N","Y","Y","Y","Y","N","N","Y","N","Y","N","N"],Opinion:["pos","neg","pos","neg","neg","pos","pos","pos","pos","indiff","pos","indiff","pos","indiff","indiff","pos","neg","neg","pos","neg","neg"],Age:[23,43,43,32,15,37,26,35,26,31,35,55,25,39,25,26,33,62,54,38,65],Order:["1","2","1","2","1","2","1","2","1","2","1","2","1","2","1","2","1","2","1","2","1"]},y:{vars:["U-Trial 1","U-Trial 2","U-Trial 3","S-Trial 1","S-Trial 2","S-Trial 3"],smps:["s1","s2","s3","s4","s5","s6","s7","s8","s9","s10","s11","s12","s13","s14","s15","s16","s17","s18","s19","s20","s21"],data:[[38.4,46.2,72.5,38,82.8,33.9,50.4,35,32.8,60.1,75.1,57.6,55.5,49.5,40.9,44.3,93.8,47.9,75.2,46.2,56.3],[27.7,57.2,57.9,38,57.9,32,40.6,33.1,26.8,53.2,63.1,57.7,63.3,45.8,35.7,46.8,91.9,59.9,54.1,39.3,45.8],[25.7,41.9,51.9,32.2,64.7,31.4,40.1,43.2,33.9,40.4,58,61.5,44.6,35.3,37.2,39.4,77.4,52.8,63.6,56.6,58.9],[53.1,54.7,74.2,49.6,53.6,51.3,44.1,34,34.5,59.1,67.3,75.5,41.1,52.2,28.3,74.9,77.5,50.9,70.1,60.3,59.9],[30.6,43.3,53.4,37.4,48.6,35.5,46.9,26.4,25.1,87.1,43.8,126.6,41.8,53.8,26,45.3,55.8,58.6,44,47.8,36.8],[30.2,56.7,42.4,34.4,44.8,42.9,42.7,24.8,25.1,59.2,42.2,48.4,32,48.1,33.7,42.6,54.9,64.5,43.1,52.8,44.3]],desc:["time in seconds"]},m:{Name:"Scents",Description:"Data on the time subjects required to complete a pencil and paper maze when they were smelling a floral scent and when they were not.",Reference:"Hirsch, A. R., and Johnston, L. H. Odors and Learning, Smell & Taste Treatment and Research Foundation, Chicago."}};this.dataSetCancerSurvival={z:{Description:["Survival time in days"]},x:{Organ:["Stomach","Stomach","Stomach","Stomach","Stomach","Stomach","Stomach","Stomach","Stomach","Stomach","Stomach","Stomach","Stomach","Bronchus","Bronchus","Bronchus","Bronchus","Bronchus","Bronchus","Bronchus","Bronchus","Bronchus","Bronchus","Bronchus","Bronchus","Bronchus","Bronchus","Bronchus","Bronchus","Bronchus","Colon","Colon","Colon","Colon","Colon","Colon","Colon","Colon","Colon","Colon","Colon","Colon","Colon","Colon","Colon","Colon","Colon","Ovary","Ovary","Ovary","Ovary","Ovary","Ovary","Breast","Breast","Breast","Breast","Breast","Breast","Breast","Breast","Breast","Breast","Breast"]},y:{vars:["Survival"],smps:["s1","s2","s3","s4","s5","s6","s7","s8","s9","s10","s11","s12","s13","s14","s15","s16","s17","s18","s19","s20","s21","s22","s23","s24","s25","s26","s27","s28","s29","s30","s31","s32","s33","s34","s35","s36","s37","s38","s39","s40","s41","s42","s43","s44","s45","s46","s47","s48","s49","s50","s51","s52","s53","s54","s55","s56","s57","s58","s59","s60","s61","s62","s63","s64"],data:[[124,42,25,45,412,51,1112,46,103,876,146,340,396,81,461,20,450,246,166,63,64,155,859,151,166,37,223,138,72,245,248,377,189,1843,180,537,519,455,406,365,942,776,372,163,101,20,283,1234,89,201,356,2970,456,1235,24,1581,1166,40,727,3808,791,1804,3460,719]],desc:["days"]},m:{Name:"Cancer Survival",Description:"Patients with advanced cancers of the stomach, bronchus, colon, ovary or breast were treated with ascorbate. The purpose of the study was to determine if the survival times differ with respect to the organ affected by the cancer.",Reference:"Cameron, E. and Pauling, L. (1978) Supplemental ascorbate in the supportive treatment of cancer: re-evaluation of prolongation of survival times in terminal human cancer. Proceedings of the National Academy of Science USA, 75. Also found in: Manly, B.F.J. (1986) Multivariate Statistical Methods: A Primer, New York: Chapman & Hall, 11. Also found in: Hand, D.J., et al. (1994) A Handbook of Small Data Sets, London: Chapman & Hall, 255."}};this.dataSetAgeHeight={z:{Description:["Age in months","Mean height in centimeters for children at this age"]},y:{smps:["s1","s2","s3","s4","s5","s6","s7","s8","s9","s10","s11","s12"],vars:["Age","Height"],data:[[18,19,20,21,22,23,24,25,26,27,28,29],[76.1,77,78.1,78.2,78.8,79.7,79.9,81.1,81.2,81.8,82.8,83.5]]},m:{Name:"Age Height",Description:"Mean heights of a group of children in Kalama, an Egyptian village that is the site of a study of nutrition in developing countries. The data were obtained by measuring the heights of all 161 children in the village each month over several years.",Reference:"Moore, David S., and George P. McCabe (1989). Introduction to the Practice of Statistics, p. 118"}};this.dataSetAlcoholTobacco={z:{Description:["Average weekly household spending on alcoholic beverages in pounds","Average weekly household spending on tobacco products in pounds"]},y:{smps:["North","Yorkshire","Northeast","East Midlands","West Midlands","East Anglia","Southeast","Southwest","Wales","Scotland","Northern Ireland"],vars:["Alcohol","Tobacco"],data:[[6.47,6.13,6.19,4.89,5.63,4.52,5.89,4.79,3.53,6.08,4.02],[4.03,3.76,3.77,3.34,3.47,2.92,3.2,2.71,3.53,4.51,4.56]]},m:{Name:"Alcohol Tobacco",Description:"Average weekly household spending, in British pounds, on tobacco products and alcoholic beverages for each of the 11 regions of Great Britain.",Reference:"Moore, David S., and George P. McCabe (1989). Introduction to the Practice of Statistics, p. 179. Original source: Family Expenditure Survey, Department of Employment, 1981 (British official statistics)"}};this.dataSetBreastCancer={z:{Description:["Mortality index for neoplasms of the female breast","Mean annual temperature (in degrees F)"]},y:{smps:["s1","s2","s3","s4","s5","s6","s7","s8","s9","s10","s11","s12","s13","s14","s15","s16"],vars:["Mortality","Temperature"],data:[[102.5,104.5,100.4,95.9,87,95,88.6,89.2,78.9,84.6,81.7,72.2,65.1,68.1,67.3,52.5],[51.3,49.9,50,49.2,48.5,47.8,47.3,45.1,46.3,42.1,44.2,43.5,42.3,40.2,31.8,34]]},m:{Name:"Breast Cancer",Description:"Data contains the mean annual temperature (in degrees F) and Mortality Index for neoplasms of the female breast. Data were taken from certain regions of Great Britain, Norway, and Sweden.",Reference:"Velleman, P. F. and Hoaglin, D. C. (1981). Applications, Basics, and Computing of Exploratory Data Analysis. Belmont. CA: Wadsworth, Inc., pp. 127-134."}};this.dataSetCars={z:{Description:["Miles per gallon, a measure of gas mileage","Weight of vehicle","Drive ratio of the automobile","Horsepower","Displacement of the car (in cubic inches)","Number of cylinders"]},x:{Country:["U.S.","U.S.","U.S.","U.S.","U.S.","Japan","Japan","U.S.","Germany","Sweden","Sweden","France","U.S.","U.S.","U.S.","U.S.","U.S.","U.S.","U.S.","U.S.","U.S.","U.S.","Japan","Japan","U.S.","Germany","Japan","U.S.","U.S.","U.S.","U.S.","U.S.","Japan","Italy","Germany","Japan","Germany","Germany"]},y:{smps:["Buick Estate Wagon","Ford Country Squire Wagon","Chevy Malibu Wagon","Chrysler LeBaron Wagon","Chevette","Toyota Corona","Datsun 510","Dodge Omni","Audi 5000","Volvo 240 GL","Saab 99 GLE","Peugeot 694 SL","Buick Century Special","Mercury Zephyr","Dodge Aspen","AMC Concord D/L","Chevy Caprice Classic","Ford LTD","Mercury Grand Marquis","Dodge St Regis","Ford Mustang 4","Ford Mustang Ghia","Mazda GLC","Dodge Colt","AMC Spirit","VW Scirocco","Honda Accord LX","Buick Skylark","Chevy Citation","Olds Omega","Pontiac Phoenix","Plymouth Horizon","Datsun 210","Fiat Strada","VW Dasher","Datsun 810","BMW 320i","VW Rabbit"],vars:["MPG","Weight","Drive_Ratio","Horsepower","Displacement","Cylinders"],data:[[16.9,15.5,19.2,18.5,30,27.5,27.2,30.9,20.3,17,21.6,16.2,20.6,20.8,18.6,18.1,17,17.6,16.5,18.2,26.5,21.9,34.1,35.1,27.4,31.5,29.5,28.4,28.8,26.8,33.5,34.2,31.8,37.3,30.5,22,21.5,31.9],[4.36,4.054,3.605,3.94,2.155,2.56,2.3,2.23,2.83,3.14,2.795,3.41,3.38,3.07,3.62,3.41,3.84,3.725,3.955,3.83,2.585,2.91,1.975,1.915,2.67,1.99,2.135,2.67,2.595,2.7,2.556,2.2,2.02,2.13,2.19,2.815,2.6,1.925],[2.73,2.26,2.56,2.45,3.7,3.05,3.54,3.37,3.9,3.5,3.77,3.58,2.73,3.08,2.71,2.73,2.41,2.26,2.26,2.45,3.08,3.08,3.73,2.97,3.08,3.78,3.05,2.53,2.69,2.84,2.69,3.37,3.7,3.1,3.7,3.7,3.64,3.78],[155,142,125,150,68,95,97,75,103,125,115,133,105,85,110,120,130,129,138,135,88,109,65,80,80,71,68,90,115,115,90,70,65,69,78,97,110,71],[350,351,267,360,98,134,119,105,131,163,121,163,231,200,225,258,305,302,351,318,140,171,86,98,121,89,98,151,173,173,151,105,85,91,97,146,121,89],[8,8,8,8,4,4,4,4,5,6,4,6,6,6,6,6,8,8,8,8,4,6,4,4,4,4,4,4,6,6,4,4,4,4,4,6,4,4]]},m:{Name:"Cars",Description:"Measurements on 38 1978-79 model automobiles. The gas mileage in miles per gallon as measured by Consumers Union on a test track. Other values as reported by automobile manufacturer.",Reference:"Henderson, H. V. and Velleman, P. F. (1981), Building Regression Models Interactively. Biometrics, 37, 391-411. Data originally collected from Consumer Reports."}};this.dataSetPopularKids={z:{Description:["Rank of make good grades (1=most important for popularity, 4=least important)","Rank of being good at sports (1=most important for popularity, 4=least important)","Rank of being handsome or pretty (1=most important for popularity, 4=least important)","Rank of having lots of money (1=most important for popularity, 4=least important)"]},x:{Gender:["boy","boy","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","boy","boy","boy","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","boy","boy","boy","boy","boy","boy","boy","boy","boy","girl","girl","girl","girl","girl","girl","girl","girl","boy","boy","boy","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","girl","girl","boy","boy","boy","girl","girl","girl","girl","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","boy","boy","boy","boy","boy","boy","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","boy","boy","boy","boy","girl","girl","girl","girl","girl","boy","boy","boy","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","girl","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy","boy"],Grade:["5","5","5","5","5","5","5","5","5","5","5","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","5","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","4","4","4","4","4","4","4","4","4","4","4","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","4","4","4","4","4","4","4","4","4","4","4","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","5","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],Age:["11","10","11","11","10","11","10","10","10","10","11","10","9","9","9","9","9","9","9","9","9","9","9","9","7","9","10","9","10","10","10","9","9","10","11","9","10","10","10","9","9","10","9","11","11","11","11","11","11","11","10","11","11","10","10","10","11","11","10","11","10","10","11","10","10","10","10","11","10","10","10","9","11","12","10","11","11","10","10","12","11","11","10","10","10","10","10","11","11","11","11","11","11","11","11","13","11","11","11","12","11","11","11","11","11","11","11","11","12","11","12","11","11","11","11","11","11","11","12","11","11","11","12","12","11","11","12","11","11","12","12","11","12","12","12","12","11","11","11","12","11","11","12","11","11","11","12","12","11","12","11","12","11","12","11","11","11","11","11","11","12","11","12","11","12","12","12","12","13","11","12","12","9","9","9","9","9","9","9","9","9","9","9","9","10","9","10","9","9","10","9","9","9","9","9","10","10","10","11","10","11","11","10","10","10","11","10","10","10","10","10","10","11","10","11","11","10","10","11","10","12","10","10","10","10","10","11","10","10","10","10","10","11","10","10","10","10","9","10","10","9","9","9","10","9","9","9","9","12","11","11","11","11","12","12","11","11","12","11","11","11","11","11","11","12","11","11","11","11","12","11","12","11","11","12","13","11","11","12","11","12","11","12","11","12","11","11","12","11","11","12","12","11","12","11","13","11","11","11","11","9","9","9","9","9","9","10","10","9","9","9","9","9","9","9","9","9","9","9","9","9","9","9","9","10","9","10","10","11","10","10","10","11","10","10","11","10","10","10","10","10","10","10","10","10","10","10","10","11","10","11","10","10","10","10","11","9","10","10","10","10","11","11","11","9","11","10","10","9","9","9","9","9","10","9","9","9","9","9","10","11","10","11","10","10","11","10","10","10","10","10","10","11","10","10","10","10","10","11","10","10","11","10","10","11","10","11","11","11","10","10","11","10","9","9","9","9","9","9","9","9","9","9","9","9","9","9","9","9","11","11","11","11","11","11","11","11","11","11","11","11","11","11","12","11","11","11","11","12","11","11","11","11","11","11","11","11","11","11","11","11","11","11","12","11","11","11","12","11","11","12","11","11","11","11","11","11","11"],Race:["White","White","White","White","White","White","White","White","White","White","White","White","White","White","Other","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","Other","White","White","White","Other","White","White","White","White","White","Other","White","White","White","White","White","White","White","White","Other","White","White","White","White","White","White","White","White","White","White","Other","White","White","White","White","White","White","White","White","White","White","White","White","White","White","Other","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","Other","White","White","White","Other","Other","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","Other","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","Other","White","White","White","White","White","Other","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","Other","White","White","White","White","White","White","White","White","White","Other","White","White","Other","White","Other","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","Other","White","White","White","White","White","White","White","Other","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","Other","Other","White","White","White","White","White","Other","White","Other","White","White","White","White","White","Other","White","White","White","White","White","Other","White","White","White","White","Other","White","White","White","White","White","Other","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","Other","White","White","White","White","Other","White","Other","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","White","Other","White","White","White","White","White","White","White","White","White","Other","White","White","White","Other","White","White","White","White","Other","White","White","White","White","White","White","Other","White","White","White","White","Other","White","White","White","White","White","White","White","White","White","White","White","White","White"],"Urban/Rural":["Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Suburban","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Rural","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban","Urban"],School:["Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Elm","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Elementary","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Brentwood Middle","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Ridge","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Sand","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Brown Middle","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Main","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Portage","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle","Westdale Middle"],Goals:["Sports","Popular","Popular","Popular","Popular","Popular","Popular","Grades","Sports","Sports","Sports","Grades","Popular","Popular","Popular","Grades","Sports","Popular","Grades","Sports","Popular","Grades","Popular","Grades","Grades","Popular","Popular","Grades","Popular","Grades","Grades","Grades","Grades","Grades","Sports","Sports","Popular","Sports","Grades","Sports","Grades","Grades","Popular","Grades","Popular","Grades","Popular","Sports","Grades","Popular","Grades","Sports","Sports","Popular","Sports","Sports","Grades","Grades","Grades","Grades","Grades","Popular","Grades","Grades","Grades","Grades","Grades","Popular","Grades","Grades","Popular","Popular","Grades","Grades","Grades","Grades","Grades","Grades","Grades","Popular","Grades","Grades","Grades","Grades","Popular","Popular","Grades","Sports","Popular","Popular","Popular","Grades","Sports","Grades","Popular","Grades","Popular","Popular","Popular","Grades","Grades","Popular","Grades","Grades","Grades","Sports","Grades","Popular","Grades","Popular","Popular","Popular","Grades","Popular","Grades","Grades","Grades","Grades","Sports","Popular","Grades","Grades","Grades","Grades","Grades","Popular","Grades","Popular","Popular","Grades","Grades","Popular","Grades","Grades","Popular","Grades","Sports","Grades","Sports","Grades","Grades","Grades","Grades","Grades","Sports","Popular","Grades","Popular","Grades","Popular","Grades","Grades","Grades","Sports","Sports","Grades","Popular","Grades","Popular","Grades","Sports","Grades","Grades","Grades","Popular","Grades","Grades","Sports","Sports","Grades","Sports","Grades","Grades","Grades","Popular","Popular","Sports","Popular","Sports","Grades","Sports","Sports","Popular","Popular","Grades","Grades","Grades","Grades","Popular","Sports","Popular","Sports","Popular","Popular","Grades","Grades","Sports","Sports","Sports","Popular","Grades","Popular","Sports","Sports","Sports","Popular","Grades","Popular","Sports","Grades","Popular","Popular","Sports","Grades","Popular","Grades","Popular","Popular","Grades","Grades","Sports","Popular","Popular","Sports","Sports","Sports","Grades","Grades","Grades","Popular","Popular","Popular","Grades","Grades","Grades","Popular","Grades","Grades","Grades","Grades","Grades","Grades","Grades","Popular","Grades","Sports","Sports","Grades","Popular","Popular","Grades","Grades","Grades","Grades","Grades","Popular","Sports","Grades","Popular","Popular","Grades","Popular","Popular","Popular","Grades","Grades","Grades","Grades","Popular","Grades","Grades","Sports","Sports","Grades","Sports","Sports","Sports","Sports","Popular","Sports","Sports","Grades","Grades","Sports","Popular","Grades","Grades","Sports","Grades","Grades","Popular","Sports","Grades","Sports","Popular","Sports","Grades","Sports","Popular","Sports","Grades","Popular","Grades","Sports","Grades","Grades","Grades","Grades","Grades","Popular","Sports","Grades","Grades","Grades","Grades","Grades","Popular","Grades","Sports","Grades","Sports","Sports","Grades","Grades","Grades","Grades","Grades","Grades","Grades","Grades","Popular","Popular","Grades","Grades","Popular","Sports","Grades","Grades","Popular","Grades","Popular","Popular","Popular","Grades","Grades","Grades","Grades","Grades","Sports","Grades","Grades","Grades","Grades","Grades","Sports","Grades","Grades","Grades","Grades","Grades","Sports","Popular","Grades","Popular","Grades","Sports","Sports","Grades","Sports","Sports","Grades","Grades","Grades","Grades","Grades","Popular","Popular","Popular","Grades","Grades","Grades","Grades","Popular","Grades","Grades","Grades","Grades","Popular","Grades","Popular","Popular","Grades","Popular","Popular","Grades","Grades","Grades","Sports","Sports","Grades","Sports","Grades","Popular","Grades","Popular","Popular","Sports","Popular","Grades","Popular","Sports","Popular","Popular","Sports","Sports","Grades","Grades","Sports","Grades","Sports","Popular","Grades","Grades","Grades","Popular","Grades","Popular","Grades","Popular","Popular","Popular","Popular","Popular","Grades","Popular","Popular","Grades","Grades","Grades","Grades","Popular","Grades","Popular","Popular","Grades","Grades","Popular","Popular","Grades","Grades","Grades","Grades","Sports","Grades","Grades","Popular","Popular","Grades","Grades","Grades","Popular","Sports","Grades","Grades","Sports","Grades","Grades","Grades","Grades","Popular","Grades","Grades","Grades","Grades","Sports","Grades","Popular","Popular"]},y:{smps:["s1","s2","s3","s4","s5","s6","s7","s8","s9","s10","s11","s12","s13","s14","s15","s16","s17","s18","s19","s20","s21","s22","s23","s24","s25","s26","s27","s28","s29","s30","s31","s32","s33","s34","s35","s36","s37","s38","s39","s40","s41","s42","s43","s44","s45","s46","s47","s48","s49","s50","s51","s52","s53","s54","s55","s56","s57","s58","s59","s60","s61","s62","s63","s64","s65","s66","s67","s68","s69","s70","s71","s72","s73","s74","s75","s76","s77","s78","s79","s80","s81","s82","s83","s84","s85","s86","s87","s88","s89","s90","s91","s92","s93","s94","s95","s96","s97","s98","s99","s100","s101","s102","s103","s104","s105","s106","s107","s108","s109","s110","s111","s112","s113","s114","s115","s116","s117","s118","s119","s120","s121","s122","s123","s124","s125","s126","s127","s128","s129","s130","s131","s132","s133","s134","s135","s136","s137","s138","s139","s140","s141","s142","s143","s144","s145","s146","s147","s148","s149","s150","s151","s152","s153","s154","s155","s156","s157","s158","s159","s160","s161","s162","s163","s164","s165","s166","s167","s168","s169","s170","s171","s172","s173","s174","s175","s176","s177","s178","s179","s180","s181","s182","s183","s184","s185","s186","s187","s188","s189","s190","s191","s192","s193","s194","s195","s196","s197","s198","s199","s200","s201","s202","s203","s204","s205","s206","s207","s208","s209","s210","s211","s212","s213","s214","s215","s216","s217","s218","s219","s220","s221","s222","s223","s224","s225","s226","s227","s228","s229","s230","s231","s232","s233","s234","s235","s236","s237","s238","s239","s240","s241","s242","s243","s244","s245","s246","s247","s248","s249","s250","s251","s252","s253","s254","s255","s256","s257","s258","s259","s260","s261","s262","s263","s264","s265","s266","s267","s268","s269","s270","s271","s272","s273","s274","s275","s276","s277","s278","s279","s280","s281","s282","s283","s284","s285","s286","s287","s288","s289","s290","s291","s292","s293","s294","s295","s296","s297","s298","s299","s300","s301","s302","s303","s304","s305","s306","s307","s308","s309","s310","s311","s312","s313","s314","s315","s316","s317","s318","s319","s320","s321","s322","s323","s324","s325","s326","s327","s328","s329","s330","s331","s332","s333","s334","s335","s336","s337","s338","s339","s340","s341","s342","s343","s344","s345","s346","s347","s348","s349","s350","s351","s352","s353","s354","s355","s356","s357","s358","s359","s360","s361","s362","s363","s364","s365","s366","s367","s368","s369","s370","s371","s372","s373","s374","s375","s376","s377","s378","s379","s380","s381","s382","s383","s384","s385","s386","s387","s388","s389","s390","s391","s392","s393","s394","s395","s396","s397","s398","s399","s400","s401","s402","s403","s404","s405","s406","s407","s408","s409","s410","s411","s412","s413","s414","s415","s416","s417","s418","s419","s420","s421","s422","s423","s424","s425","s426","s427","s428","s429","s430","s431","s432","s433","s434","s435","s436","s437","s438","s439","s440","s441","s442","s443","s444","s445","s446","s447","s448","s449","s450","s451","s452","s453","s454","s455","s456","s457","s458","s459","s460","s461","s462","s463","s464","s465","s466","s467","s468","s469","s470","s471","s472","s473","s474","s475","s476","s477","s478"],vars:["Grades","Sports","Looks","Money"],data:[[1,2,4,2,4,4,3,3,3,4,2,2,2,4,4,1,3,3,2,3,4,1,4,4,1,2,2,4,2,1,2,1,3,2,3,4,3,3,2,4,2,2,3,2,2,4,4,4,2,3,2,4,3,3,4,4,2,1,2,2,2,4,3,3,2,2,3,4,1,2,4,2,3,2,3,2,2,2,1,3,1,3,3,2,2,3,1,1,2,1,1,4,1,3,1,2,4,4,3,2,4,4,3,4,4,3,4,1,3,4,2,2,2,4,3,4,3,4,4,1,4,4,3,4,4,3,3,3,4,4,1,3,1,2,4,4,3,4,2,2,2,4,4,4,2,3,3,3,3,2,1,2,1,2,2,4,3,3,3,1,2,1,2,4,4,4,4,1,1,2,3,1,1,1,1,2,1,3,2,1,3,2,2,4,1,3,2,1,2,4,1,2,4,3,1,1,3,4,2,1,1,3,1,2,3,4,3,4,3,3,2,3,4,1,4,1,4,1,1,1,2,4,2,4,2,3,4,2,1,2,3,1,2,1,2,3,2,3,3,1,2,1,3,2,1,3,3,2,4,3,4,4,1,4,3,1,4,4,2,3,1,3,1,4,4,2,2,1,4,3,4,2,2,4,4,4,3,4,4,2,3,4,4,4,2,3,2,3,3,4,4,3,1,4,4,4,4,3,4,3,1,4,1,4,2,2,3,3,1,2,1,1,1,4,1,3,1,3,1,3,2,2,2,4,2,2,4,1,2,4,3,2,1,1,4,2,1,4,1,4,2,4,2,1,1,2,1,1,3,2,1,2,1,2,2,2,2,3,1,2,2,3,1,3,3,2,2,3,4,3,4,1,1,3,1,2,4,3,1,1,1,2,3,2,3,1,1,3,1,2,3,1,3,2,3,1,2,3,3,3,3,4,4,2,2,3,3,2,2,3,3,4,3,3,3,4,1,2,2,1,4,3,2,1,3,4,4,3,3,3,4,3,4,4,4,4,3,2,4,3,3,4,3,2,4,2,3,2,2,4,3,2,4,4,3,4,3,3,3,3,4,3,4,3,3,3,1,3,2,3,3,4,3,4,4,4,4,4],[2,1,3,3,2,2,4,4,2,3,3,3,3,2,3,3,1,4,3,2,3,4,2,3,2,3,3,2,3,2,4,2,1,1,1,3,2,1,3,1,1,1,2,1,1,1,3,2,1,2,1,1,1,2,1,1,1,2,3,1,1,1,1,4,1,1,1,2,3,1,2,3,2,3,4,4,1,3,2,4,4,4,1,1,3,2,3,3,3,3,3,1,2,4,2,4,2,3,4,3,3,3,2,3,1,1,3,2,1,3,3,1,3,3,2,2,4,3,3,3,2,3,2,2,2,1,1,2,2,1,3,1,2,1,3,1,1,1,1,1,1,1,1,1,3,1,1,1,1,1,2,1,2,1,1,1,2,2,1,2,3,2,1,3,1,1,3,2,2,1,1,2,3,3,4,4,2,4,3,4,2,1,3,2,2,4,1,2,3,1,2,1,3,4,3,3,1,2,3,4,2,2,2,1,1,1,1,2,1,2,3,2,2,2,2,3,3,2,3,2,1,3,1,1,1,1,2,1,2,3,2,3,4,2,4,2,4,1,1,3,1,3,4,1,3,2,2,1,2,4,2,2,3,3,2,2,1,3,1,2,3,1,2,2,2,3,3,4,2,1,2,1,4,2,3,1,1,2,2,1,1,1,2,1,3,2,1,1,1,1,3,1,2,1,2,2,3,1,2,1,2,3,3,1,1,4,2,2,2,1,3,2,2,3,2,1,3,1,2,1,1,3,1,1,1,1,2,2,1,3,2,4,2,2,1,1,2,3,4,1,3,3,1,2,3,4,2,2,1,1,4,1,2,1,1,1,1,4,2,1,1,1,2,1,1,1,1,2,3,2,3,2,2,1,3,3,1,1,3,2,3,1,2,4,1,2,3,2,2,4,1,2,1,3,1,3,1,1,1,2,1,1,3,1,4,2,2,4,4,2,2,3,2,2,2,3,4,4,4,3,3,2,1,2,1,3,2,2,2,2,3,1,2,2,2,1,2,3,3,2,2,2,1,4,3,3,2,3,1,2,2,3,1,3,4,2,4,4,2,2,3,2,2,1,2,1,2,1,1,1,1,2,2,1,1,2,1,1],[4,4,1,4,1,1,1,2,1,2,1,4,4,3,2,2,2,1,1,1,1,2,1,2,3,1,1,1,4,4,3,4,2,3,2,2,1,4,1,3,3,4,4,3,4,2,1,1,3,1,3,2,2,1,3,3,3,4,1,3,3,2,2,1,3,4,2,1,2,4,1,1,1,1,1,1,4,1,3,1,2,1,2,4,1,1,2,2,1,2,4,2,3,1,3,1,1,1,1,1,1,1,1,1,2,2,2,3,2,1,1,3,1,1,1,1,1,1,2,2,1,1,1,1,1,2,2,1,1,2,4,2,3,3,1,2,2,2,4,4,4,2,2,2,1,2,2,2,2,4,3,4,3,3,3,3,1,1,4,3,1,3,3,2,2,2,1,3,4,3,2,3,2,2,3,1,3,1,1,2,1,3,1,1,3,2,3,3,1,2,4,4,1,1,2,2,2,1,4,3,4,1,4,3,2,2,2,1,2,1,1,1,1,4,1,4,1,3,2,3,3,1,3,2,4,4,3,3,4,1,1,2,1,3,3,1,1,2,4,2,3,2,1,3,2,1,1,3,1,1,1,1,2,1,1,3,3,1,3,1,4,2,3,1,1,1,1,2,1,2,1,3,1,1,1,2,2,1,3,3,2,2,1,2,4,1,3,2,4,2,2,2,3,2,1,1,1,4,1,4,3,1,2,2,3,1,1,1,3,3,2,3,3,1,4,2,2,4,4,2,4,1,4,3,4,3,1,3,4,1,1,1,3,3,2,4,4,2,2,2,1,2,3,4,2,3,3,3,2,4,2,4,4,3,3,4,3,2,3,3,4,2,3,2,4,3,3,1,1,1,1,3,3,2,2,1,2,2,2,4,2,3,1,1,4,3,2,1,3,1,2,3,2,1,2,2,3,4,2,1,2,3,1,3,1,1,1,1,1,1,1,1,1,4,4,2,3,1,1,4,1,1,4,3,2,2,3,1,1,1,2,2,1,1,1,2,1,1,1,1,1,1,2,3,1,1,1,4,3,1,1,1,2,1,1,1,1,1,1,1,1,1,1,2,1,2,3,2,3,2,2,1,1,2,2,1,3,2],[3,3,2,1,3,3,2,1,4,1,4,1,1,1,1,4,4,2,4,4,2,3,3,1,4,4,4,3,1,3,1,3,4,4,4,1,4,2,4,2,4,3,1,4,3,3,2,3,4,4,4,3,4,4,2,2,4,3,4,4,4,3,4,2,4,3,4,3,4,3,3,4,4,4,2,3,3,4,4,2,3,2,4,3,4,4,4,4,4,4,2,3,4,2,4,3,3,2,2,4,2,2,4,2,3,4,1,4,4,2,4,4,4,2,4,3,2,2,1,4,3,2,4,3,3,4,4,4,3,3,2,4,4,4,2,3,4,3,3,3,3,3,3,3,4,4,4,4,4,3,4,3,4,4,4,2,4,4,2,4,4,4,4,1,3,3,2,4,3,4,4,4,4,4,2,3,4,2,4,3,4,4,4,3,4,1,4,4,4,3,3,3,2,2,4,4,4,3,1,2,3,4,3,4,4,3,4,3,4,4,4,4,3,3,3,2,2,4,4,4,4,2,4,3,3,2,1,4,3,4,4,4,3,4,1,4,3,4,2,4,4,4,2,4,4,4,4,4,3,2,3,3,4,2,4,4,2,2,4,4,2,4,4,3,3,4,4,3,3,4,3,4,3,3,2,3,4,3,1,4,4,3,3,3,1,4,4,4,2,3,1,4,4,3,3,3,2,2,3,2,4,2,4,3,4,3,4,4,4,4,4,4,4,2,3,4,4,2,3,4,3,4,3,2,3,4,3,4,3,2,4,3,4,4,3,3,3,1,3,3,4,1,4,3,4,1,4,4,4,3,3,3,3,4,4,3,4,1,4,4,3,4,4,4,2,4,4,4,2,4,2,4,4,4,4,4,3,4,4,3,4,4,4,3,2,4,4,4,4,3,4,4,4,4,4,4,4,2,4,4,4,2,2,4,3,4,4,3,3,4,4,2,4,1,1,1,2,3,3,2,2,4,3,4,4,1,1,4,4,4,1,4,3,3,3,3,4,4,2,4,4,3,4,1,2,4,4,1,4,3,4,4,3,2,2,3,2,2,4,4,2,4,3,4,4,4,4,4,4,4,4,3,4,3,3,3,2,3]]},m:{Name:"Popular Kids",Description:"Subjects were students in grades 4-6 from three school districts in Ingham and Clinton Counties, Michigan. Chase and Dummer stratified their sample, selecting students from urban, suburban, and rural school districts with approximately 1/3 of their sample coming from each district. Students indicated whether good grades, athletic ability, or popularity was most important to them. They also ranked four factors: grades, sports, looks, and money, in order of their importance for popularity. The questionnaire also asked for gender, grade level, and other demographic information.",Reference:"Chase, M. A., and Dummer, G. M. (1992), The Role of Sports as a Social Determinant for Children, Research Quarterly for Exercise and Sport, 63, 418-424"}};this.dataSetLesMiserables={nodes:[{id:"Id0",name:"Myriel",group:1},{id:"Id1",name:"Napoleon",group:1},{id:"Id2",name:"Mlle. Baptistine",group:1},{id:"Id3",name:"Mme. Magloire",group:1},{id:"Id4",name:"Countess de Lo",group:1},{id:"Id5",name:"Geborand",group:1},{id:"Id6",name:"Champtercier",group:1},{id:"Id7",name:"Cravatte",group:1},{id:"Id8",name:"Count",group:1},{id:"Id9",name:"Old Man",group:1},{id:"Id10",name:"Labarre",group:2},{id:"Id11",name:"Valjean",group:2},{id:"Id12",name:"Marguerite",group:3},{id:"Id13",name:"Mme. de R",group:2},{id:"Id14",name:"Isabeau",group:2},{id:"Id15",name:"Gervais",group:2},{id:"Id16",name:"Tholomyes",group:3},{id:"Id17",name:"Listolier",group:3},{id:"Id18",name:"Fameuil",group:3},{id:"Id19",name:"Blacheville",group:3},{id:"Id20",name:"Favourite",group:3},{id:"Id21",name:"Dahlia",group:3},{id:"Id22",name:"Zephine",group:3},{id:"Id23",name:"Fantine",group:3},{id:"Id24",name:"Mme. Thenardier",group:4},{id:"Id25",name:"Thenardier",group:4},{id:"Id26",name:"Cosette",group:5},{id:"Id27",name:"Javert",group:4},{id:"Id28",name:"Fauchelevent",group:0},{id:"Id29",name:"Bamatabois",group:2},{id:"Id30",name:"Perpetue",group:3},{id:"Id31",name:"Simplice",group:2},{id:"Id32",name:"Scaufflaire",group:2},{id:"Id33",name:"Woman 1",group:2},{id:"Id34",name:"Judge",group:2},{id:"Id35",name:"Champmathieu",group:2},{id:"Id36",name:"Brevet",group:2},{id:"Id37",name:"Chenildieu",group:2},{id:"Id38",name:"Cochepaille",group:2},{id:"Id39",name:"Pontmercy",group:4},{id:"Id40",name:"Boulatruelle",group:6},{id:"Id41",name:"Eponine",group:4},{id:"Id42",name:"Anzelma",group:4},{id:"Id43",name:"Woman 2",group:5},{id:"Id44",name:"Mother Innocent",group:0},{id:"Id45",name:"Gribier",group:0},{id:"Id46",name:"Jondrette",group:7},{id:"Id47",name:"Mme. Burgon",group:7},{id:"Id48",name:"Gavroche",group:8},{id:"Id49",name:"Gillenormand",group:5},{id:"Id50",name:"Magnon",group:5},{id:"Id51",name:"Mlle. Gillenormand",group:5},{id:"Id52",name:"Mme. Pontmercy",group:5},{id:"Id53",name:"Mlle. Vaubois",group:5},{id:"Id54",name:"Lt. Gillenormand",group:5},{id:"Id55",name:"Marius",group:8},{id:"Id56",name:"Baroness T",group:5},{id:"Id57",name:"Mabeuf",group:8},{id:"Id58",name:"Enjolras",group:8},{id:"Id59",name:"Combeferre",group:8},{id:"Id60",name:"Prouvaire",group:8},{id:"Id61",name:"Feuilly",group:8},{id:"Id62",name:"Courfeyrac",group:8},{id:"Id63",name:"Bahorel",group:8},{id:"Id64",name:"Bossuet",group:8},{id:"Id65",name:"Joly",group:8},{id:"Id66",name:"Grantaire",group:8},{id:"Id67",name:"Mother Plutarch",group:9},{id:"Id68",name:"Gueulemer",group:4},{id:"Id69",name:"Babet",group:4},{id:"Id70",name:"Claquesous",group:4},{id:"Id71",name:"Montparnasse",group:4},{id:"Id72",name:"Toussaint",group:5},{id:"Id73",name:"Child 1",group:10},{id:"Id74",name:"Child 2",group:10},{id:"Id75",name:"Brujon",group:4},{id:"Id76",name:"Mme. Hucheloup",group:8}],edges:[{id1:"Id1",id2:"Id0",value:1},{id1:"Id2",id2:"Id0",value:8},{id1:"Id3",id2:"Id0",value:10},{id1:"Id3",id2:"Id2",value:6},{id1:"Id4",id2:"Id0",value:1},{id1:"Id5",id2:"Id0",value:1},{id1:"Id6",id2:"Id0",value:1},{id1:"Id7",id2:"Id0",value:1},{id1:"Id8",id2:"Id0",value:2},{id1:"Id9",id2:"Id0",value:1},{id1:"Id11",id2:"Id10",value:1},{id1:"Id11",id2:"Id3",value:3},{id1:"Id11",id2:"Id2",value:3},{id1:"Id11",id2:"Id0",value:5},{id1:"Id12",id2:"Id11",value:1},{id1:"Id13",id2:"Id11",value:1},{id1:"Id14",id2:"Id11",value:1},{id1:"Id15",id2:"Id11",value:1},{id1:"Id17",id2:"Id16",value:4},{id1:"Id18",id2:"Id16",value:4},{id1:"Id18",id2:"Id17",value:4},{id1:"Id19",id2:"Id16",value:4},{id1:"Id19",id2:"Id17",value:4},{id1:"Id19",id2:"Id18",value:4},{id1:"Id20",id2:"Id16",value:3},{id1:"Id20",id2:"Id17",value:3},{id1:"Id20",id2:"Id18",value:3},{id1:"Id20",id2:"Id19",value:4},{id1:"Id21",id2:"Id16",value:3},{id1:"Id21",id2:"Id17",value:3},{id1:"Id21",id2:"Id18",value:3},{id1:"Id21",id2:"Id19",value:3},{id1:"Id21",id2:"Id20",value:5},{id1:"Id22",id2:"Id16",value:3},{id1:"Id22",id2:"Id17",value:3},{id1:"Id22",id2:"Id18",value:3},{id1:"Id22",id2:"Id19",value:3},{id1:"Id22",id2:"Id20",value:4},{id1:"Id22",id2:"Id21",value:4},{id1:"Id23",id2:"Id16",value:3},{id1:"Id23",id2:"Id17",value:3},{id1:"Id23",id2:"Id18",value:3},{id1:"Id23",id2:"Id19",value:3},{id1:"Id23",id2:"Id20",value:4},{id1:"Id23",id2:"Id21",value:4},{id1:"Id23",id2:"Id22",value:4},{id1:"Id23",id2:"Id12",value:2},{id1:"Id23",id2:"Id11",value:9},{id1:"Id24",id2:"Id23",value:2},{id1:"Id24",id2:"Id11",value:7},{id1:"Id25",id2:"Id24",value:13},{id1:"Id25",id2:"Id23",value:1},{id1:"Id25",id2:"Id11",value:12},{id1:"Id26",id2:"Id24",value:4},{id1:"Id26",id2:"Id11",value:31},{id1:"Id26",id2:"Id16",value:1},{id1:"Id26",id2:"Id25",value:1},{id1:"Id27",id2:"Id11",value:17},{id1:"Id27",id2:"Id23",value:5},{id1:"Id27",id2:"Id25",value:5},{id1:"Id27",id2:"Id24",value:1},{id1:"Id27",id2:"Id26",value:1},{id1:"Id28",id2:"Id11",value:8},{id1:"Id28",id2:"Id27",value:1},{id1:"Id29",id2:"Id23",value:1},{id1:"Id29",id2:"Id27",value:1},{id1:"Id29",id2:"Id11",value:2},{id1:"Id30",id2:"Id23",value:1},{id1:"Id31",id2:"Id30",value:2},{id1:"Id31",id2:"Id11",value:3},{id1:"Id31",id2:"Id23",value:2},{id1:"Id31",id2:"Id27",value:1},{id1:"Id32",id2:"Id11",value:1},{id1:"Id33",id2:"Id11",value:2},{id1:"Id33",id2:"Id27",value:1},{id1:"Id34",id2:"Id11",value:3},{id1:"Id34",id2:"Id29",value:2},{id1:"Id35",id2:"Id11",value:3},{id1:"Id35",id2:"Id34",value:3},{id1:"Id35",id2:"Id29",value:2},{id1:"Id36",id2:"Id34",value:2},{id1:"Id36",id2:"Id35",value:2},{id1:"Id36",id2:"Id11",value:2},{id1:"Id36",id2:"Id29",value:1},{id1:"Id37",id2:"Id34",value:2},{id1:"Id37",id2:"Id35",value:2},{id1:"Id37",id2:"Id36",value:2},{id1:"Id37",id2:"Id11",value:2},{id1:"Id37",id2:"Id29",value:1},{id1:"Id38",id2:"Id34",value:2},{id1:"Id38",id2:"Id35",value:2},{id1:"Id38",id2:"Id36",value:2},{id1:"Id38",id2:"Id37",value:2},{id1:"Id38",id2:"Id11",value:2},{id1:"Id38",id2:"Id29",value:1},{id1:"Id39",id2:"Id25",value:1},{id1:"Id40",id2:"Id25",value:1},{id1:"Id41",id2:"Id24",value:2},{id1:"Id41",id2:"Id25",value:3},{id1:"Id42",id2:"Id41",value:2},{id1:"Id42",id2:"Id25",value:2},{id1:"Id42",id2:"Id24",value:1},{id1:"Id43",id2:"Id11",value:3},{id1:"Id43",id2:"Id26",value:1},{id1:"Id43",id2:"Id27",value:1},{id1:"Id44",id2:"Id28",value:3},{id1:"Id44",id2:"Id11",value:1},{id1:"Id45",id2:"Id28",value:2},{id1:"Id47",id2:"Id46",value:1},{id1:"Id48",id2:"Id47",value:2},{id1:"Id48",id2:"Id25",value:1},{id1:"Id48",id2:"Id27",value:1},{id1:"Id48",id2:"Id11",value:1},{id1:"Id49",id2:"Id26",value:3},{id1:"Id49",id2:"Id11",value:2},{id1:"Id50",id2:"Id49",value:1},{id1:"Id50",id2:"Id24",value:1},{id1:"Id51",id2:"Id49",value:9},{id1:"Id51",id2:"Id26",value:2},{id1:"Id51",id2:"Id11",value:2},{id1:"Id52",id2:"Id51",value:1},{id1:"Id52",id2:"Id39",value:1},{id1:"Id53",id2:"Id51",value:1},{id1:"Id54",id2:"Id51",value:2},{id1:"Id54",id2:"Id49",value:1},{id1:"Id54",id2:"Id26",value:1},{id1:"Id55",id2:"Id51",value:6},{id1:"Id55",id2:"Id49",value:12},{id1:"Id55",id2:"Id39",value:1},{id1:"Id55",id2:"Id54",value:1},{id1:"Id55",id2:"Id26",value:21},{id1:"Id55",id2:"Id11",value:19},{id1:"Id55",id2:"Id16",value:1},{id1:"Id55",id2:"Id25",value:2},{id1:"Id55",id2:"Id41",value:5},{id1:"Id55",id2:"Id48",value:4},{id1:"Id56",id2:"Id49",value:1},{id1:"Id56",id2:"Id55",value:1},{id1:"Id57",id2:"Id55",value:1},{id1:"Id57",id2:"Id41",value:1},{id1:"Id57",id2:"Id48",value:1},{id1:"Id58",id2:"Id55",value:7},{id1:"Id58",id2:"Id48",value:7},{id1:"Id58",id2:"Id27",value:6},{id1:"Id58",id2:"Id57",value:1},{id1:"Id58",id2:"Id11",value:4},{id1:"Id59",id2:"Id58",value:15},{id1:"Id59",id2:"Id55",value:5},{id1:"Id59",id2:"Id48",value:6},{id1:"Id59",id2:"Id57",value:2},{id1:"Id60",id2:"Id48",value:1},{id1:"Id60",id2:"Id58",value:4},{id1:"Id60",id2:"Id59",value:2},{id1:"Id61",id2:"Id48",value:2},{id1:"Id61",id2:"Id58",value:6},{id1:"Id61",id2:"Id60",value:2},{id1:"Id61",id2:"Id59",value:5},{id1:"Id61",id2:"Id57",value:1},{id1:"Id61",id2:"Id55",value:1},{id1:"Id62",id2:"Id55",value:9},{id1:"Id62",id2:"Id58",value:17},{id1:"Id62",id2:"Id59",value:13},{id1:"Id62",id2:"Id48",value:7},{id1:"Id62",id2:"Id57",value:2},{id1:"Id62",id2:"Id41",value:1},{id1:"Id62",id2:"Id61",value:6},{id1:"Id62",id2:"Id60",value:3},{id1:"Id63",id2:"Id59",value:5},{id1:"Id63",id2:"Id48",value:5},{id1:"Id63",id2:"Id62",value:6},{id1:"Id63",id2:"Id57",value:2},{id1:"Id63",id2:"Id58",value:4},{id1:"Id63",id2:"Id61",value:3},{id1:"Id63",id2:"Id60",value:2},{id1:"Id63",id2:"Id55",value:1},{id1:"Id64",id2:"Id55",value:5},{id1:"Id64",id2:"Id62",value:12},{id1:"Id64",id2:"Id48",value:5},{id1:"Id64",id2:"Id63",value:4},{id1:"Id64",id2:"Id58",value:10},{id1:"Id64",id2:"Id61",value:6},{id1:"Id64",id2:"Id60",value:2},{id1:"Id64",id2:"Id59",value:9},{id1:"Id64",id2:"Id57",value:1},{id1:"Id64",id2:"Id11",value:1},{id1:"Id65",id2:"Id63",value:5},{id1:"Id65",id2:"Id64",value:7},{id1:"Id65",id2:"Id48",value:3},{id1:"Id65",id2:"Id62",value:5},{id1:"Id65",id2:"Id58",value:5},{id1:"Id65",id2:"Id61",value:5},{id1:"Id65",id2:"Id60",value:2},{id1:"Id65",id2:"Id59",value:5},{id1:"Id65",id2:"Id57",value:1},{id1:"Id65",id2:"Id55",value:2},{id1:"Id66",id2:"Id64",value:3},{id1:"Id66",id2:"Id58",value:3},{id1:"Id66",id2:"Id59",value:1},{id1:"Id66",id2:"Id62",value:2},{id1:"Id66",id2:"Id65",value:2},{id1:"Id66",id2:"Id48",value:1},{id1:"Id66",id2:"Id63",value:1},{id1:"Id66",id2:"Id61",value:1},{id1:"Id66",id2:"Id60",value:1},{id1:"Id67",id2:"Id57",value:3},{id1:"Id68",id2:"Id25",value:5},{id1:"Id68",id2:"Id11",value:1},{id1:"Id68",id2:"Id24",value:1},{id1:"Id68",id2:"Id27",value:1},{id1:"Id68",id2:"Id48",value:1},{id1:"Id68",id2:"Id41",value:1},{id1:"Id69",id2:"Id25",value:6},{id1:"Id69",id2:"Id68",value:6},{id1:"Id69",id2:"Id11",value:1},{id1:"Id69",id2:"Id24",value:1},{id1:"Id69",id2:"Id27",value:2},{id1:"Id69",id2:"Id48",value:1},{id1:"Id69",id2:"Id41",value:1},{id1:"Id70",id2:"Id25",value:4},{id1:"Id70",id2:"Id69",value:4},{id1:"Id70",id2:"Id68",value:4},{id1:"Id70",id2:"Id11",value:1},{id1:"Id70",id2:"Id24",value:1},{id1:"Id70",id2:"Id27",value:1},{id1:"Id70",id2:"Id41",value:1},{id1:"Id70",id2:"Id58",value:1},{id1:"Id71",id2:"Id27",value:1},{id1:"Id71",id2:"Id69",value:2},{id1:"Id71",id2:"Id68",value:2},{id1:"Id71",id2:"Id70",value:2},{id1:"Id71",id2:"Id11",value:1},{id1:"Id71",id2:"Id48",value:1},{id1:"Id71",id2:"Id41",value:1},{id1:"Id71",id2:"Id25",value:1},{id1:"Id72",id2:"Id26",value:2},{id1:"Id72",id2:"Id27",value:1},{id1:"Id72",id2:"Id11",value:1},{id1:"Id73",id2:"Id48",value:2},{id1:"Id74",id2:"Id48",value:2},{id1:"Id74",id2:"Id73",value:3},{id1:"Id75",id2:"Id69",value:3},{id1:"Id75",id2:"Id68",value:3},{id1:"Id75",id2:"Id25",value:3},{id1:"Id75",id2:"Id48",value:1},{id1:"Id75",id2:"Id41",value:1},{id1:"Id75",id2:"Id70",value:1},{id1:"Id75",id2:"Id71",value:1},{id1:"Id76",id2:"Id64",value:1},{id1:"Id76",id2:"Id65",value:1},{id1:"Id76",id2:"Id66",value:1},{id1:"Id76",id2:"Id63",value:1},{id1:"Id76",id2:"Id62",value:1},{id1:"Id76",id2:"Id48",value:1},{id1:"Id76",id2:"Id58",value:1}],m:{Name:"Les Miserables",Description:"Coappearance network of characters in the novel Les Miserables",Reference:"D. E. Knuth, The Stanford GraphBase: A Platform for Combinatorial Computing, Addison-Wesley, Reading, MA (1993)."}};this.getDataSet=function(e){if(e&&this["dataSet"+e]){return this["dataSet"+e]}else{if(e&&e.match(/Random/)){var c;var b=e.split(":");var a={randomDataVariables:this.randomDataVariables,randomDataSamples:this.randomDataSamples,randomDataVariableAnnotations:this.randomDataVariableAnnotations,randomDataSampleAnnotations:this.randomDataSampleAnnotations,randomDataUniform:this.randomDataUniform,randomDataSymmetrical:this.randomDataSymmetrical,randomDataGraphTime:this.isGraphTime,randomMissingDataPercentage:this.randomMissingDataPercentage};if(b.length>0){if(b[1]!=null){this.randomDataVariables=Number(b[1])}if(b[2]!=null){this.randomDataSamples=Number(b[2])}if(b[3]!=null){this.randomDataVariableAnnotations=Number(b[3])}if(b[4]!=null){this.randomDataSampleAnnotations=Number(b[4])}if(b[5]!=null&&Number(b[5])>0){this.randomDataUniform=true}else{this.randomDataUniform=false}if(b[6]!=null&&Number(b[6])>0){this.randomDataSymmetrical=true}else{this.randomDataSymmetrical=false}if(b[7]!=null&&Number(b[7])>0){this.isGraphTime=true}else{this.isGraphTime=false}if(b[8]!=null){this.randomMissingDataPercentage=Number(b[8])}}c=this.createRandomData(true);this.randomDataVariables=a.randomDataVariables;this.randomDataSamples=a.randomDataSamples;this.randomDataVariableAnnotations=a.randomDataVariableAnnotations;this.randomDataSampleAnnotations=a.randomDataSampleAnnotations;this.randomDataUniform=a.randomDataUniform;this.randomDataSymmetrical=a.randomDataSymmetrical;this.isGraphTime=a.randomDataGraphTime;this.randomMissingDataPercentage=a.randomMissingDataPercentage;return c}else{return this.dataSetExample}}};this.getGenericDataSet=function(){return{x:this.dataSetGeneric.x,y:this.dataSetGeneric.y,z:this.dataSetGeneric.z,a:this.dataSetGeneric.a,venn:this.dataSetVenn.venn,market:this.dataSetMarket.market,nodes:this.dataSetNetworkRadial.nodes,edges:this.dataSetNetworkRadial.edges,tracks:this.dataSetGenomeAdvanced.tracks}};this.initializeExample=function(){this.dataSetExample={x:this.dataSetGeneric.x,y:this.dataSetGeneric.y,z:this.dataSetGeneric.z,a:this.dataSetGeneric.a,venn:this.dataSetVenn.venn,market:this.dataSetMarket.market,nodes:this.dataSetNetworkRadial.nodes,edges:this.dataSetNetworkRadial.edges,tracks:this.dataSetGenomeAdvanced.tracks};this.dataSetSummaryExample={x:this.dataSetGeneric.x,y:{vars:this.dataSetGeneric.y["vars"],smps:this.dataSetGeneric.y["smps"],mean:this.dataSetGeneric.y["data"],stdev:[[1,2,3,1,2,3],[1,2,3,1,2,3],[1,2,3,1,2,3],[1,2,3,1,2,3]],n:[[4,5,4,5,4,5],[4,5,4,5,4,5],[4,5,4,5,4,5],[4,5,4,5,4,5]],desc:this.dataSetGeneric.y["desc"]},z:this.dataSetGeneric.z,a:this.dataSetGeneric.a}};this.initializeExample()};CanvasXpress.prototype.initData=function(b,a){this.isValidPlotData=function(c){var d=this.isGroupedData?this.data.w:this.data.y;if(c=="cor"&&d.cor){return true}else{if(c=="venn"&&this.data.venn){return true}else{if(c=="network"&&this.data.nodes){return true}else{if(c=="genome"&&this.data.tracks){return true}else{if(c=="sum"&&d.sum&&d.sum[0].length>0){return true}else{if(c=="mean"&&d.mean&&d.mean[0].length>0){return true}else{if(c=="median"&&d.median&&d.median[0].length>0){return true}else{if(c=="iqr"&&d.iqr1&&d.qtl1&&d.median&&d.qtl3&&d.iqr3&&d.median[0].length>0){return true}else{if(c=="candle"&&d.close&&d.open&&d.high&&d.low&&d.close[0].length>0){return true}else{if(c=="volume"&&d.volume&&d.volume[0].length>0){return true}else{if(c=="raw"&&this.isRawData){return true}else{if(c=="video"&&this.data.video){return true}else{return false}}}}}}}}}}}}};this.setAllNodesVisible=function(c){this.nodes={};this.data.nodeIndices={};var e=this.data.nodes;for(var f=0;f<e.length;f++){var g=this.data.nodes[f];g.hide=false;this.nodes[g.id]=g;this.data.nodeIndices[g.id]=f}var d=this.data.edges;for(var f=0;f<d.length;f++){this.data.edges[f].hide=false}if(!c){this.filterData()}};this.setNodeIndices=function(){this.nodes={};this.data.nodeIndices={};for(var c=0;c<this.data.nodes.length;c++){var d=this.data.nodes[c];this.nodes[d.id]=d;this.data.nodeIndices[d.id]=c}};this.setNodes=function(){if(this.data.nodeIndices){this.nodes={};for(var c=0;c<this.data.nodes.length;c++){var d=this.data.nodes[c];this.nodes[d.id]=d}this.data.nodes=[];for(var e in this.data.nodeIndices){this.data.nodes[this.data.nodeIndices[e]]=this.nodes[e]}}else{this.setNodeIndices()}};this.hideUnhideNodes=function(e,d){d=d?true:false;if(e){if(this.isArray(e)){for(var c=0;c<e.length;c++){var g=e[c];var f=this.data.nodes[this.data.nodeIndices[g]];f.hide=d;if(this.nodes&&this.nodes[g]){this.nodes[g].hide=d}}}}else{for(var c=0;c<this.data.nodes.length;c++){var f=this.data.nodes[c];f.hide=d;f.hideChildren=d;if(this.nodes&&this.nodes[f.id]){this.nodes[f.id].hide=d;this.nodes[f.id].hideChildren=d}}}};this.hideUnhideChildrenNodes=function(f,d){d=d?true:false;if(this.nodeParentHood[f]&&this.nodeParentHood[f].children){for(var c=0;c<this.nodeParentHood[f].children.length;c++){var e=this.nodeParentHood[f].children[c];this.data.nodes[this.data.nodeIndices[e]].hiddenParent=d;this.hideUnhideChildrenNodes(e,d)}}};this.setSelectNodes=function(d){this.selectNode={};this.isSelectNodes=0;for(var c=0;c<d.length;c++){this.selectNode[d[c]]=true;this.isSelectNodes++}};this.getNetworkImages=function(){var c=[];if(this.graphType=="Network"){for(var d=0;d<this.data.nodes.length;d++){var e=this.data.nodes[d];if(e.imagePath){if(!e.imagePath.match(/^http:\/\//)&&!e.imagePath.match(/^file:\/\//)){e.imagePath=this.imageDir+e.imagePath}c.push(e.imagePath)}}}return c};this.setAllFeaturesVisible=function(){for(var e=0;e<this.data.tracks.length;e++){var c=this.data.tracks[e];c.hide=false;var f=c.data;for(var d=0;d<f.length;d++){f[d].hide=false}}};this.setAllVariablesVisible=function(h,d){var f=this.data;if(f.y){var g=this.data.y.vars;if(!g&&f.y.data){f.y.vars=[];g=[];for(var e=0;e<f.y.data.length;e++){g.push("var"+(e+1))}f.y.vars=g}this.varIndices=[];this.hiddenVars=[];if(h){for(var e=0;e<h.length;e++){this.varIndices.push(h[e]);this.hiddenVars.push(false)}}else{for(var e=0;e<g.length;e++){this.varIndices.push(e);this.hiddenVars.push(false)}}if(!d&&this.smpIndices){this.filterData()}var k=this.layoutComb?this.layoutCurrent:0;if(this.startingVarIndices){if(this.startingVarIndices[k]&&this.startingVarIndices[k].length==this.varIndices.length){this.varIndices=this.startingVarIndices[k]}else{this.startingVarIndices[k]=[]}}}if(f.y&&this.data.a){this.xAxisVarIndices=[];this.xAxis2VarIndices=[];if(f.a.xAxis){this.xAxisVarIndices=this.getVariableIndices(f.a.xAxis)}if(f.a.xAxis2){this.xAxis2VarIndices=this.getVariableIndices(f.a.xAxis2)}}};this.resetVariablesVisibleByAxis=function(c){if(this.data.a){this.setVariablesVisibleByAxis(c,this.getVariableIndices(this.data.a[c]))}};this.setVariablesVisibleByAxis=function(f,c){var d=f+"VarIndices";this[d]=[];for(var e=0;e<c.length;e++){this[d].push(c[e])}};this.getVariablesVisibleByAxis=function(c){return this[c+"VarIndices"]};this.getVariablesByAxis=function(c){if(this.data.a&&this.data.a[c]){return this.data.a[c]}return[]};this.getVariablesByAnnotationLevel=function(g,d){var c=[];if(g&&this.data.z[g]){if(d){for(var e=0;e<this.varIndices.length;e++){var f=this.varIndices[e];if(this.data.z[g][f]==d&&!this.hiddenVars[f]){c.push(f)}}}else{for(var e=0;e<this.varIndices.length;e++){var f=this.varIndices[e];if(!this.data.z[g][f]&&!this.hiddenVars[f]){c.push(f)}}}}return c};this.getVariableLevelsByAnnotation=function(h){var c=[];var g={};if(h&&this.data.z[h]){for(var e=0;e<this.varIndices.length;e++){var f=this.varIndices[e];var d=this.data.z[h][f]||"";if(!g.hasOwnProperty(d)){c.push(d)}g[d]=true}}return c};this.setVariablesVisible=function(c){this.varIndices=[];for(var d=0;d<c.length;d++){this.varIndices.push(c[d])}};this.getVariableIndices=function(c){var f=this.data.y.vars;var h=f.length;if(c!=null&&f){var g=[];if(this.isArray(c)){if(c.length>0){for(var e=0;e<c.length;e++){for(var d=0;d<h;d++){if(f[d]==c[e]){g.push(d);break}}}return g}}else{for(var e=0;e<h;e++){if(f[e]==c){return e}}return -1}}};this.hideUnhideVars=function(h){if(h){if(this.isArray(h)){for(var e=0;e<h.length;e++){for(var d=0;d<this.data.y.vars.length;d++){if(this.data.y.vars[d]==h[e]){if(this.hiddenVars[d]){this.hiddenVars[d]=false}else{this.hiddenVars[d]=true}break}}}}else{for(var e=0;e<this.data.y.vars.length;e++){if(this.data.y.vars[e]==h){if(this.hiddenVars[e]){this.hiddenVars[e]=false}else{this.hiddenVars[e]=true}break}}}var c=[];for(var e=0;e<this.data.y.vars.length;e++){if(!this.hiddenVars[e]){c.push(e)}}this.setVariablesVisible(c);var g=["xAxis","xAxis2"];if(this.data.a){for(var e=0;e<g.length;e++){var k=this.getVariableIndices(this.data.a[g[e]]);if(k.length>0){var c=[];for(var d=0;d<k.length;d++){var f=k[d];if(!this.hiddenVars[f]){c.push(f)}}this.setVariablesVisibleByAxis(g[e],c)}}}this.draw()}};this.getVariables=function(){var f=[];for(var e=0;e<this.data.y.vars.length;e++){var c=-1;for(var d=0;d<this.varIndices.length;d++){if(this.varIndices[d]==e){c=d;break}}f.push({name:this.data.y.vars[e],hidden:this.hiddenVars[e],index:c})}return f};this.setMaxVarStringAttr=function(d,c){this.setMaxVarStringAnnt(d,c);this.setMaxVarStringLabel(d,c);this.setMaxVarStringDesc(c);this.setMaxVarStringName(c)};this.setMaxVarStringAnnt=function(f,e){if(!e){e=this.varLabelFont}var d=0;this.maxVarAnnt=0;this.maxVarAnntStr="";if(this.data.z){if(f&&this.data.z[f]){return f}else{for(var g in this.data.z){var c=this.measureText(g,e);if(c>d){d=c;this.maxVarAnnt=g.length;this.maxVarAnntStr=g}}}}};this.setMaxVarStringLabel=function(k,d){if(!d){d=this.varLabelFont}var l=0;var c={};this.maxVarLabel=0;this.maxVarLabelStr="";if(this.data.z){if(k&&this.data.z[k]){return this.getMaxtTextBySampling(this.data.z[k],10);var f="";for(var g=0;g<this.varIndices.length;g++){var m=this.data.z[k][this.varIndices[g]];if(!c.hasOwnProperty(m)){var h=this.measureText(m,d);if(h>l){l=h;f=m}c[m]=true}}return f}else{for(var e in this.data.z){var m=this.getMaxtTextBySampling(this.data.z[e],10);var h=this.measureText(m,d);if(h>l){l=h;this.maxVarLabel=m.length;this.maxVarLabelStr=m}}return;for(var e in this.data.z){for(var g=0;g<this.varIndices.length;g++){var m=this.data.z[e][this.varIndices[g]];if(m&&!c.hasOwnProperty(m)){var h=this.measureText(m,d);if(h>l){l=h;this.maxVarLabel=m.length;this.maxVarLabelStr=m}c[m]=true}}}}}};this.setMaxVarStringDesc=function(f){if(!f){f=this.varLabelFont}var d=0;var e={};this.maxVarLabelDesc=0;this.maxVarLabelDescStr="";if(this.data.z&&this.varLabelDescription&&this.data.z[this.varLabelDescription]){for(var g=0;g<this.varIndices.length;g++){var h=this.data.z[this.varLabelDescription][this.varIndices[g]];if(h&&!e.hasOwnProperty(h)){var c=this.measureText(h,f);if(c>d){d=c;this.maxVarLabelDesc=h.length;this.maxVarLabelDescStr=h}e[h]=true}}}};this.setMaxVarStringName=function(e){if(!e){e=this.varLabelFont}if(this.data.y||this.data.w){var h=this.graphType.match(/BarLine|DotLine|StackedLine|StackedPercentLine/)?this.data.y:this.isGroupedData?this.data.w:this.data.y;var d=0;this.maxVarName=0;this.maxVarNameStr="";if(h.vars){for(var f=0;f<this.varIndices.length;f++){var g=h.vars[this.varIndices[f]];var c=this.measureText(g,e);if(c>d){d=c;this.maxVarName=g.length;this.maxVarNameStr=g}}}}};this.getVarAnnotations=function(d,m,k,f){var c={};var g=[];var h=false;if(this.data.z.hasOwnProperty(d)){for(var e=0;e<m.length;e++){var l=m[e];if(this.data.z[d][l]!=null){c[this.data.z[d][l]]=true;g.push(this.data.z[d][l])}else{h=true}}if(h){g.push("")}if(f){return k?g.join("+"):g}else{g=[]}for(var e in c){g.push(e)}if(h){g.push("")}return k?g.join("+"):g}};this.switchAnnotationToVar=function(d){if(this.data.x.hasOwnProperty(d)&&this.isNumeric(this.data.x[d])){var c=this.groupingFactors;if(c){this.ungroupSamples(true)}this.data.y.vars.push(d);this.data.y.data.push(this.data.x[d]);delete (this.data.x[d]);var f=this.getKeys(this.data.x);if(f.length<1){delete (this.data.x)}delete (this.xAnntType[d]);if(this.data.z){var f=this.getKeys(this.data.z);for(var e=0;e<f.length;e++){this.data.z[f[e]].push("")}}this.updateData(this.data,true);if(c){this.groupSamples(c)}this.removeMenus()}};this.switchVarToAnnotation=function(d){var c=this.groupingFactors;var f=this.getVariableIndices(d);if(f>=0){if(c){this.ungroupSamples(true)}if(!this.data.x){this.data.x={}}this.data.x[d]=this.data.y.data[f];this.data.y.vars.splice(f,1);this.data.y.data.splice(f,1);if(this.data.z){var g=this.getKeys(this.data.z);for(var e=0;e<g.length;e++){this.data.z[g[e]].splice(f,1)}}this.xAnntType[d]="Numeric";this.updateData(this.data,true);if(c){this.groupSamples(c)}this.removeMenus()}};this.setAllSamplesVisible=function(f,d){if(this.data.y&&this.data.y.data){if(!this.data.y.smps&&this.data.y.vars){this.data.y.smps=[];for(var e=0;e<this.data.y.data[0].length;e++){this.data.y.smps.push("smp"+(e+1))}}this.smpIndices=[];this.hiddenSmps=[];if(f){for(var e=0;e<f.length;e++){this.smpIndices.push(f[e]);this.hiddenSmps.push(false)}}else{for(var e=0;e<this.data.y.smps.length;e++){this.smpIndices.push(e);this.hiddenSmps.push(false)}}if(!d&&this.varIndices){this.filterData()}}if(this.data.w&&this.data.w.smps){this.grpIndices=[];this.hiddenGrps=[];for(var e=0;e<this.data.w.smps.length;e++){this.grpIndices.push(e);this.hiddenGrps.push(false)}}var g=this.layoutComb?this.layoutCurrent:0;if(this.isGroupedData){if(this.startingSmpIndices){if(this.startingSmpIndices[g]&&this.startingSmpIndices[g].length==this.grpIndices.length){this.grpIndices=this.startingSmpIndices[g]}else{this.startingSmpIndices[g]=[]}}}else{if(this.startingSmpIndices){if(this.startingSmpIndices[g]&&this.startingSmpIndices[g].length==this.smpIndices.length){this.smpIndices=this.startingSmpIndices[g]}else{this.startingSmpIndices[g]=[]}}}};this.getSamplesByAxis=function(c){if(this[c]){return this[c]}return[]};this.getSamplesByAnnotationLevel=function(g,c){var f=[];if(g&&this.data.x[g]){if(c){for(var d=0;d<this.smpIndices.length;d++){var e=this.smpIndices[d];if(this.data.x[g][e]==c&&!this.hiddenSmps[e]){f.push(e)}}}else{for(var d=0;d<this.smpIndices.length;d++){var e=this.smpIndices[d];if(!this.data.x[g][e]&&!this.hiddenSmps[e]){f.push(e)}}}}return f};this.getSampleLevelsByAnnotation=function(h){var c=[];var g={};if(h&&this.data.x[h]){for(var e=0;e<this.smpIndices.length;e++){var f=this.smpIndices[e];var d=this.data.x[h][f]||"";if(!g.hasOwnProperty(d)){c.push(d)}g[d]=true}}return c};this.setSamplesVisible=function(c,d){if(this.isGroupedData){this.grpIndices=[];for(var f=0;f<c.length;f++){this.grpIndices.push(c[f])}}else{this.smpIndices=[];for(var f=0;f<c.length;f++){this.smpIndices.push(c[f])}}if(d){var e=this.getObjectArray(c);var h=this.isGroupedData?this.data.w:this.data.y;var g=this.isGroupedData?this.hiddenGrps:this.hiddenSmps;for(var f=0;f<h.smps.length;f++){if(e.hasOwnProperty(f)){g[f]=false}else{g[f]=true}}}};this.getSampleIndices=function(c){var g=this.isGroupedData?this.data.w:this.data.y;if(c!=null&&g.smps){var f=[];if(this.isArray(c)){if(c.length>0){for(var e=0;e<c.length;e++){for(var d=0;d<g.smps.length;d++){if(g.smps[d]==c[e]){f.push(d);break}}}return f}}else{for(var e=0;e<g.smps.length;e++){if(g.smps[e]==c){return e}}return -1}}};this.hideUnhideSmps=function(h){if(h){var k=this.isGroupedData?this.data.w:this.data.y;var f=this.isGroupedData?this.hiddenGrps:this.hiddenSmps;var g=[];if(this.isArray(h)){for(var e=0;e<h.length;e++){for(var d=0;d<k.smps.length;d++){if(k.smps[d]==h[e]){if(f[d]){f[d]=false}else{f[d]=true}break}}}}else{for(var e=0;e<k.smps.length;e++){if(k.smps[e]==h){if(f[e]){f[e]=false}else{f[e]=true}break}}}var c=[];for(var e=0;e<k.smps.length;e++){if(!f[e]){c.push(e)}}this.setSamplesVisible(c);this.draw()}};this.getSamples=function(){var e=[];var k=this.isGroupedData?this.data.w.smps:this.data.y.smps;var l=this.isGroupedData?this.data.w:this.data.y;var g=this.isGroupedData?this.hiddenGrps:this.hiddenSmps;var h=this.isGroupedData?this.grpIndices:this.smpIndices;for(var f=0;f<k.length;f++){var c=-1;for(var d=0;d<h.length;d++){if(h[d]==f){c=d;break}}e.push({name:k[f],hidden:g[f],index:c})}return e};this.setMaxSmpStringAttr=function(d,c){this.setMaxSmpStringAnnt(d,c);this.setMaxSmpStringLabel(d,c);this.setMaxSmpStringDesc(c);this.setMaxSmpStringName(c)};this.setMaxSmpStringAnnt=function(f,e){if(!e){e=this.smpLabelFont}var d=0;this.maxSmpAnnt=0;this.maxSmpAnntStr="";if(this.data.x){if(f&&this.data.x[f]){return f}else{for(var g in this.data.x){var c=this.measureText(g,e);if(c>d){d=c;this.maxSmpAnnt=g.length;this.maxSmpAnntStr=g}}}}};this.setMaxSmpStringLabel=function(k,d){if(!d){d=this.smpLabelFont}var l=0;var c={};this.maxSmpLabel=0;this.maxSmpLabelStr="";if(this.data.x){if(k&&this.data.x[k]){var f="";for(var g=0;g<this.smpIndices.length;g++){var m=this.data.x[k][this.smpIndices[g]];if(!c.hasOwnProperty(m)){var h=this.measureText(m,d);if(h>l){l=h;f=m}c[m]=true}}return f}else{for(var e in this.data.x){for(var g=0;g<this.smpIndices.length;g++){var m=this.data.x[e][this.smpIndices[g]];if(m&&!c.hasOwnProperty(m)){var h=this.measureText(m,d);if(h>l){l=h;this.maxSmpLabel=this.data.x[e][this.smpIndices[g]].length;this.maxSmpLabelStr=this.data.x[e][this.smpIndices[g]]}c[m]=true}}}}}};this.setMaxSmpStringDesc=function(f){if(!f){f=this.smpLabelFont}var d=0;var e={};this.maxSmpLabelDesc=0;this.maxSmpLabelDescStr="";if(this.data.x&&this.smpLabelDescription&&this.data.x[this.smpLabelDescription]){for(var g=0;g<this.smpIndices.length;g++){var h=this.data.x[this.smpLabelDescription][this.smpIndices[g]];if(h&&!e.hasOwnProperty(h)){var c=this.measureText(h,f);if(c>d){d=c;this.maxSmpLabelDesc=h.length;this.maxSmpLabelDescStr=h}}}}};this.setMaxSmpStringName=function(e){if(!e){e=this.smpLabelFont}if(this.data.y||this.data.w){var h=this.isGroupedData?this.data.w:this.data.y;var d=0;this.maxSmpName=0;this.maxSmpNameStr="";if(this.isGroupedData){for(var f=0;f<h.smps.length;f++){var c=this.measureText(h.smps[f],e);if(c>d){d=c;this.maxSmpName=h.smps[f].length;this.maxSmpNameStr=h.smps[f]}}}else{for(var f=0;f<this.smpIndices.length;f++){var g=h.smps[this.smpIndices[f]];var c=this.measureText(g,e);if(c>d){d=c;this.maxSmpName=g.length;this.maxSmpNameStr=g}}}}};this.getSmpAnnotations=function(d,m,k,f){var c={};var g=[];var h=false;if(this.data.x.hasOwnProperty(d)){for(var e=0;e<m.length;e++){var l=m[e];if(this.data.x[d][l]!=null){c[this.data.x[d][l]]=true;g.push(this.data.x[d][l])}else{h=true}}if(h){g.push("")}if(f){return k?g.join("+"):g}else{g=[]}for(var e in c){g.push(e)}if(h){g.push("")}return k?g.join("+"):g}};this.switchAnnotationToSmp=function(d){if(this.data.z.hasOwnProperty(d)&&this.isNumeric(this.data.z[d])){var c=this.groupingFactors;if(c){this.ungroupSamples(true)}this.data.y.smps.push(d);for(var e=0;e<this.data.y.vars.length;e++){this.data.y.data[e].push(this.data.z[d][e])}delete (this.data.z[d]);var f=this.getKeys(this.data.z);if(f.length<1){delete (this.data.z)}delete (this.zAnntType[d]);this.updateData(this.data,true);if(c){this.groupSamples(c)}this.removeMenus()}};this.switchSmpToAnnotation=function(f){var c=this.groupingFactors;var e=this.getSampleIndices(f);if(e>=0){if(c){this.ungroupSamples(true)}if(!this.data.z){this.data.z={}}this.data.y.smps.splice(e,1);this.data.z[f]=[];for(var d=0;d<this.data.y.vars.length;d++){this.data.z[f].push(this.data.y.data[d].splice(e,1))}this.zAnntType[f]="Numeric";this.updateData(this.data,true);if(c){this.groupSamples(c)}this.removeMenus()}};this.setRangeData=function(e,f,c,y,F){var d=this.isGroupedData&&!f?this.data.w:this.data.y;var r=Number.MAX_VALUE;var v=Number.MAX_VALUE*-1;if(this.setMin!=null&&this.setMax!=null){this.minData=this.setMin;this.maxData=this.setMax;return}if(this.isGroupedData&&!e){e=this.summaryType}if(e=="genome"){for(var w=0;w<this.data.tracks.length;w++){for(var t=0;t<this.data.tracks[w].data.length;t++){if(this.data.tracks[w].type=="box"){for(var s=0;s<this.data.tracks[w].data[t].data.length;s++){p=this.data.tracks[w].data[t].data[s];v=Math.max(v,Math.max(p[0],p[1]));r=Math.min(r,Math.min(p[0],p[1]))}}else{if(this.data.tracks[w].type=="sequence"){p=this.data.tracks[w].data[t].offset;v=Math.max(v,p+this.data.tracks[w].data[t].sequence.length);r=Math.min(r,p)}else{if(this.data.tracks[w].type.match(/bar|heatmap|line|stacked/)){p=this.data.tracks[w].data[t].offset;v=this.data.tracks[w].autowidth?Math.max(v,p+this.data.tracks[w].data[t].data.length):Math.max(v,p);r=Math.min(r,p)}else{p=this.data.tracks[w].data[t].offset;v=Math.max(v,p);r=Math.min(r,p)}}}}}}else{if(e=="circular"){var q=this.getVariableIndices(this.rAxis);if(q>=0){var h=this.range(this.data.y.data[q]);r=h[0];v=h[1]}else{r=0;v=1}}else{if(e=="km"&&!f){r=0;v=1}else{if(e=="video"){r=0;v=1}else{if(e=="percentile"&&!f){r=0;v=100}else{if((e=="mean"||e=="median"||e=="sum")&&(!f)){if(y){var g=this.isGroupedData?this.grpIndices:this.smpIndices;var C=this.isTransformedData?d.trans:d[this.summaryType];for(var w=0;w<g.length;w++){var o=g[w];var n=0;for(var t=0;t<this.varIndices.length;t++){var x=this.varIndices[t];var E=C[x][o];if(!isNaN(E)&&E>0){n+=E}}v=Math.max(n,v)}r=0}else{for(var w=0;w<this.varIndices.length;w++){var o=this.varIndices[w];var p;var m;if(this.isTransformedData){p=d.trans[o];m=d.tstdev?d.tstdev[o]:false}else{if(this.summaryType=="mean"){p=d.mean[o]}else{if(this.summaryType=="median"){p=d.median[o]}else{if(this.summaryType=="sum"){p=d.sum[o]}}}m=d.stdev?d.stdev[o]:false}for(var t=0;t<p.length;t++){var B;var E=p[t];if(m){B=m[t]}else{B=Number.NaN}if(!isNaN(E)){if(!isNaN(B)){if(c){if(E>0){r=Math.min(E,r);v=Math.max(E+B,v)}}else{r=Math.min(E,r);v=Math.max(E+B,v)}}else{if(c){if(E>0){r=Math.min(E,r);v=Math.max(E,v)}}else{r=Math.min(E,r);v=Math.max(E,v)}}}}}}}else{if(e=="iqr"&&!f){if(this.isTransformedData){this.isTransformedData=false}for(var w=0;w<this.varIndices.length;w++){var o=this.varIndices[w];for(var t=0;t<d.iqr1[o].length;t++){var A=d.iqr1[o][t];var z=d.iqr3[o][t];var u=d.out[o][t];if(!isNaN(A)&&!isNaN(z)){if(c){if(A>0&&z>0){r=Math.min(A,r);v=Math.max(z,v)}}else{r=Math.min(A,r);v=Math.max(z,v)}}if(u){for(var s=0;s<u.length;s++){if(!isNaN(u[s])){if(c){if(u[s]>0){r=Math.min(u[s],r);v=Math.max(u[s],v)}}else{r=Math.min(u[s],r);v=Math.max(u[s],v)}}}}}}}else{if(e=="candle"){if(this.isTransformedData){alert("Transformation not allowed");this.isTransformedData=false}var g=this.isGroupedData?this.grpIndices:this.smpIndices;for(var w=0;w<this.varIndices.length;w++){var o=this.varIndices[w];for(var t=0;t<g.length;t++){var x=g[t];var l=d.high[o][x];var D=d.low[o][x];if(!isNaN(l)&&!isNaN(D)){r=Math.min(D,r);v=Math.max(l,v)}}}}else{if(e=="volume"){var g=this.isGroupedData?this.grpIndices:this.smpIndices;for(var w=0;w<this.varIndices.length;w++){var o=this.varIndices[w];for(var t=0;t<g.length;t++){var x=g[t];if(!isNaN(d.volume[o][x])){r=Math.min(d.volume[o][x],r);v=Math.max(d.volume[o][x],v)}}}}else{if(e=="cor"){var g=this.correlationAxis=="variables"?this.varIndices:this.isGroupedData?this.grpIndices:this.smpIndices;for(var w=0;w<g.length;w++){for(var t=0;t<g.length;t++){var E=this.isTransformedData?d.trans[w][t]:d.cor[w][t];if(!isNaN(E)){if(c){if(E>0){r=Math.min(E,r);v=Math.max(E,v)}}else{r=Math.min(E,r);v=Math.max(E,v)}}}}}else{var C=this.isTransformedData?d.trans:d.data;if(y){for(var w=0;w<this.smpIndices.length;w++){var n=0;for(var t=0;t<this.varIndices.length;t++){var E=C[this.varIndices[t]][this.smpIndices[w]];if(!isNaN(E)&&E>0){n+=E}}v=Math.max(n,v)}r=0}else{for(var w=0;w<this.varIndices.length;w++){for(var t=0;t<this.smpIndices.length;t++){var E=C[this.varIndices[w]][this.smpIndices[t]];if(!isNaN(E)){if(c){if(E>0){r=Math.min(E,r);v=Math.max(E,v)}}else{r=Math.min(E,r);v=Math.max(E,v)}}}}}}}}}}}}}}}this.minData=this.setMin!=null?this.setMin:r;this.maxData=this.setMax!=null?this.setMax:v};this.setRangeDataObject=function(g){var f=Number.MAX_VALUE;var c=Number.MAX_VALUE*-1;for(var e=0;e<this.varIndices.length;e++){for(var d=0;d<this.smpIndices.length;d++){var h=g[this.varIndices[e]][this.smpIndices[d]];if(!isNaN(h)){f=Math.min(h,f);c=Math.max(h,c)}}}return[f,c]};this.transpose=function(g,e){if(g){var l=[];for(var h=0;h<g.length;h++){for(var f=0;f<g[h].length;f++){if(!l[f]){l[f]=[]}l[f][h]=g[h][f]}}return l}else{this.ungroupSamples(e);this.transform("reset",false,false,e);if(this.data.l){delete (this.data.l)}if(this.data.d){delete (this.data.d)}if(this.data.a){delete (this.data.a)}if(this.data.t){var o=this.data.t.vars;var p=this.data.t.smps;if(o){this.data.t.smps=o}if(p){this.data.t.vars=p}}var n=this.data.x;var m=this.data.z;var c=this.xAnntType;var k=this.zAnntType;this.xAnntType=k;this.zAnntType=c;if(n){this.data.z=n}else{delete (this.data.z)}if(m){this.data.x=m}else{delete (this.data.x)}var p=this.data.y.smps;this.data.y.smps=this.data.y.vars;this.data.y.vars=p;var l=this.data.y.data;this.data.y.data=[];for(var h=0;h<this.data.y.vars.length;h++){this.data.y.data[h]=[];for(var f=0;f<this.data.y.smps.length;f++){this.data.y.data[h][f]=l[f][h]}}this.initializeData(this.data);this.resetObject();if(!e){this.draw()}}};this.checkObject=function(){var e=this.data.y;if(this.isGroupedData){this.data.w={};e=this.data.w}var d=["vars","smps","desc","data","mean","median","stdev","n","qtl1","qtl3","iqr1","iqr3","out","trans","tstdev","cor","sum","grps","close","open","high","low","volume","factors"];for(var c=0;c<d.length;c++){if(!e[d[c]]){if(d[c]=="factors"){e[d[c]]={}}else{e[d[c]]=[]}}}};this.resetObject=function(c){var e=["mean","median","stdev","n","qtl1","qtl3","iqr1","iqr3","out","cor","sum","grps","close","open","high","low","volume","factors"];if(this.isGroupedData){if(!this.isTransformedData){e.push("trans");e.push("tstdev")}for(var d=0;d<e.length;d++){delete (this.data.y[e[d]])}delete (this.data.w)}else{if(!this.isTransformedData){e.push("trans");e.push("tstdev")}if(this.isRawData){for(var d=0;d<e.length;d++){delete (this.data.y[e[d]])}}else{delete (this.data.y.data)}}if(c){this.checkObject()}};this.getDataAtPos=function(h,g,l,e,f,m,k){var d=Number.NaN;var c=this.isGroupedData?this.data.w:this.data.y;if(k){d=this.data.y[this.isOncoprint][h][g]}else{if(this.isGroupedData||!this.isRawData){if(this.isTransformedData){d=l=="stdev"?c.tstdev[h][g]:c.trans[h][g]}else{l=l?l:this.summaryType;if(c.hasOwnProperty(l)){d=c[l][h][g]}else{d=0}}}else{if(l){if(c[l]&&c[l][h]){d=c[l][h][g]}}else{if(this.isTransformedData){d=c.trans[h][g]}else{d=c.data[h][g]}}}}if(e){if(!isNaN(d)){if(e=="log2"){d=Math.log(d)/Math.LN2}else{if(e=="log10"){d=Math.log(d)/Math.LN10}else{if(e=="exp2"){d=Math.pow(2,d)}else{if(e=="exp10"){d=Math.pow(10,d)}else{if(e=="percentile"){d=this.percentile(f,m,d)}}}}}}}return d};this.getDataForSmpGrpAtIndex=function(d,k,e){var c=[];if(!k){k=this.varIndices}if(this.isGroupedData||!this.isRawData){var l=this.isGroupedData?this.data.w:this.data.y;if(this.isTransformedData){c.push(l.trans[g][d])}else{e=this.summaryType;if(l.hasOwnProperty(e)){for(var f=0;f<k.length;f++){var g=k[f];c.push(l[e][g][d])}}}}else{var h=e?this.data.y[e]:this.data.y.data;if(this.isTransformedData){for(var f=0;f<k.length;f++){var g=k[f];c.push(this.data.y.trans[g][d])}}else{for(var f=0;f<k.length;f++){var g=k[f];c.push(h[g][d])}}}return c};this.getDataForVariableAtIndex=function(d){var c=[];if(this.isTransformedData){for(var e=0;e<this.smpIndices.length;e++){var f=this.smpIndices[e];c.push(this.data.y.trans[d][f])}}else{for(var e=0;e<this.smpIndices.length;e++){var f=this.smpIndices[e];c.push(this.data.y.data[d][f])}}return c};this.getMetaDataForVariableAtIndex=function(c){var e={};if(this.data.z){for(var d in this.data.z){e[d]=this.data.z[d][c]}}e[name]=this.data.y.vars[c];return e};this.getMetaDataForSampleAtIndex=function(c){if(this.isGroupedData){return this.getMetaDataForGrpAtIndex(c)}else{return this.getMetaDataForSmpAtIndex(c)}};this.getMetaDataForSmpAtIndex=function(c){var e={};if(this.data.x){for(var d in this.data.x){e[d]=this.data.x[d][c]}}e[name]=this.data.y.vars[c];return e};this.getMetaDataForGrpAtIndex=function(c){var f=[];for(var d=0;d<this.data.w.grps[c].length;d++){var e=this.data.w.grps[c][d];f.push(this.getMetaDataForSmpAtIndex[e])}return f};this.summarize=function(m,p){var c=this.isGroupedData?this.data.w:this.data.y;var d=this.isGroupedData?false:true;if(!this.isGroupedData){this.checkObject()}if(m=="cor"){this.isBoxPlotCalc=false;if(this.correlationAxis=="samples"){var q=this.isGroupedData?this.grpIndices:this.smpIndices;for(var f=0;f<q.length;f++){var r=q[f];var n=this.getDataForSmpGrpAtIndex(r);if(!c.cor[r]){c.cor[r]=[]}for(var e=f;e<q.length;e++){var h=q[e];if(!c.cor[h]){c.cor[h]=[]}var l=this.getDataForSmpGrpAtIndex(h);if(f==e){if(this.isTransformedData){c.trans[r][h]=1}c.cor[r][h]=1}else{c.cor[r][h]=this.correlation(n,l);c.cor[h][r]=c.cor[r][h];if(this.isTransformedData){c.trans[r][h]=c.cor[r][h];c.trans[h][r]=c.cor[h][r]}}}}}else{for(var f=0;f<this.varIndices.length;f++){var r=this.varIndices[f];if(!c.cor[r]){c.cor[r]=[]}for(var e=f;e<this.varIndices.length;e++){var h=this.varIndices[e];if(!c.cor[h]){c.cor[h]=[]}if(f==e){c.cor[r][h]=1;if(this.isTransformedData){c.trans[r][h]=1}}else{c.cor[r][h]=this.correlation(c.data[r],c.data[h],d);c.cor[h][r]=c.cor[r][h];if(this.isTransformedData){c.trans[r][h]=c.cor[r][h];c.trans[h][r]=c.cor[h][r]}}}}}}else{this.isBoxPlotCalc=m=="iqr"?true:false;for(var f=0;f<this.varIndices.length;f++){var g;var r=this.varIndices[f];if(!c.mean[r]){c.trans[r]=[];c.tstdev[r]=[];c.mean[r]=[];c.median[r]=[];c.stdev[r]=[];c.qtl1[r]=[];c.qtl3[r]=[];c.iqr1[r]=[];c.iqr3[r]=[];c.out[r]=[];c.n[r]=[];c.sum[r]=[]}if(this.isGroupedData){g=p[r]}else{c.grps=[];g=[];for(var e=0;e<this.smpIndices.length;e++){var h=this.smpIndices[e];c.grps[e]=[];c.grps[e].push(h);g[e]=[c.data[r][h]]}}if(m=="iqr"){this.summaryType="iqr";for(var e=0;e<g.length;e++){var o=this.quantiles(g[e],d);if(this.isTransformedData){c.trans[r][e]=o[1]}c.median[r][e]=o[1];c.qtl1[r][e]=o[0];c.qtl3[r][e]=o[2];c.iqr1[r][e]=o[3];c.iqr3[r][e]=o[4];c.out[r][e]=o[5];c.n[r][e]=o[6]}}else{if(m=="median"){this.summaryType="median";for(var e=0;e<g.length;e++){var o=this.median(g[e],d);if(this.isTransformedData){c.trans[r][e]=o[1]}c.median[r][e]=o[0];c.n[r][e]=o[1]}}else{if(m=="mean"){this.summaryType="mean";for(var e=0;e<g.length;e++){var o=this.meanStandardDeviationN(g[e],d);if(this.isTransformedData){c.trans[r][e]=o[0];c.tstdev[r][e]=o[1]}c.mean[r][e]=o[0];c.stdev[r][e]=o[1];c.n[r][e]=o[2]}}else{if(m=="sum"){this.summaryType="sum";for(var e=0;e<g.length;e++){var k=this.sum(g[e],d);if(this.isTransformedData){c.trans[r][e]=k}c.sum[r][e]=k;c.n[r][e]=g[e].length}}}}}}}};this.copySummarizedData=function(){var g=this.isGroupedData?this.data.w:this.data.y;var f;for(var d=0;d<this.varIndices.length;d++){var e=this.varIndices[d];g.data[e]=[];g.trans[e]=[];if(this.summaryType=="mean"){for(var c=0;c<g.mean[e].length;c++){g.data[e][c]=g.mean[e][c]}}else{if(this.summaryType=="median"||this.summaryType=="iqr"){for(var c=0;c<g.median[e].length;c++){g.data[e][c]=g.median[e][c]}}else{if(this.summaryType=="candle"){for(var c=0;c<g.close[e].length;c++){g.data[e][c]=g.close[e][c]}}else{if(this.summaryType=="volume"){for(var c=0;c<g.volume[e].length;c++){g.data[e][c]=g.volume[e][c]}}else{if(this.summaryType=="sum"){for(var c=0;c<g.volume[e].length;c++){g.data[e][c]=g.sum[e][c]}}}}}}if(!f){f=e}}return f};this.transformValue=function(d,e,c){switch(d){case"log2":return c?Math.pow(2,e):Math.log(e)/Math.LN2;case"log10":return c?Math.pow(10,e):Math.log(e)/Math.LN10;case"exp2":return c?Math.log(e)/Math.LN2:Math.pow(2,e);case"exp10":return c?Math.log(e)/Math.LN10:Math.pow(10,e);default:return e}};this.transform=function(f,e,c,d){var g=0;if(!this.isGroupedData){this.checkObject()}if(!this.isRawData||this.isGroupedData){g=this.copySummarizedData()}this.transformType=f;this.xAxisMaxStrLength=false;this.xAxis2MaxStrLength=false;this.yAxisMaxStrLength=false;this.zAxisMaxStrLength=false;if(f=="reset"||f=="undo"){this.transformReset();this.transformType=false;this.isTransformedData=false;this.isLogData=false;if(this.tempIndices){if(this.isGroupedData){this.grpIndices=this.tempIndices}else{this.spIndices=this.tempIndices}this.tempIndices=false}}else{if(f=="save"){this.transformSave();this.transformType=false;this.isTransformedData=false;this.isLogData=false}else{if(f=="log2"||f=="log10"||f=="exp2"||f=="exp10"){if(this.transformLogExp(f)){this.isTransformedData=f}else{return}}else{if(f=="ratio"||f=="ratio2"||f=="ratio10"){this.transformRatio(f,c);this.isTransformedData=f}else{this.transformRelative(f,e,g);this.isTransformedData=f}}}}if(!d){this.draw()}};this.transformReset=function(){var f=this.data.y;for(var d=0;d<this.varIndices.length;d++){var e=this.varIndices[d];for(var c=0;c<f.data[e].length;c++){if(f.trans&&f.trans[e]&&!isNaN(f.data[e][c])){f.trans[e][c]=f.data[e][c]}}}if(this.isGroupedData){this.isTransformedData=false;this.groupSamples(this.groupingFactors,false,false,false,true)}};this.transformSave=function(){var f=this.data.y;for(var d=0;d<this.varIndices.length;d++){var e=this.varIndices[d];for(var c=0;c<f.data[e].length;c++){if(!isNaN(f.data[e][c])){f.data[e][c]=f.trans[e][c]}}}if(this.isGroupedData){this.isTransformedData=false;this.groupSamples(this.groupingFactors,false,false,false,true)}};this.transformLogExp=function(f){var g=this.data.y;if(f=="log"){if(this.minData<=0){alert("Cannot log transform values < 0");return false}f=this.transformBase==2?"type2":"type10"}else{if(f=="exp"){f=this.transformBase==2?"exp2":"exp10"}}if(!g.trans){g.trans=[]}if(!g.tstdev){g.tstdev=[]}for(var d=0;d<this.varIndices.length;d++){var e=this.varIndices[d];if(!g.trans[e]){g.trans[e]=[]}if(!g.tstdev[e]){g.tstdev[e]=[]}for(var c=0;c<g.data[e].length;c++){if(!isNaN(g.data[e][c])){if(f=="log2"){this.isLogData=true;this.transformBase=2;g.trans[e][c]=Math.log(g.data[e][c])/Math.LN2}else{if(f=="log10"){this.isLogData=true;this.transformBase=10;g.trans[e][c]=Math.log(g.data[e][c])/Math.LN10}else{if(f=="exp2"){this.isLogData=false;this.transformBase=2;g.trans[e][c]=Math.pow(2,g.data[e][c])}else{if(f=="exp10"){this.isLogData=false;this.transformBase=10;g.trans[e][c]=Math.pow(10,g.data[e][c])}}}}}}}if(this.isGroupedData){this.isTransformedData=f;this.groupSamples(this.groupingFactors,false,false,false,true)}return true};this.transformRatio=function(){var n=[];var d=this.isGroupedData&&!this.graphType.match(/dotplot/i)?this.data.w:this.data.y;if(this.isGroupedData&&this.ratioGroupReference&&this.data.x.hasOwnProperty(this.ratioGroupReference)){if(!this.ratioLevelReference){for(var v=0;v<this.data.x[this.ratioGroupReference].length;v++){if(this.data.x[this.ratioGroupReference][v]!=null){this.ratioLevelReference=this.data.x[this.ratioGroupReference][v];break}}}if(this.groupingFactors.length==1){this.ratioReference=this.getSampleIndices(this.ratioLevelReference);if(this.ratioReference<0){this.ratioLevelReference=this.data.w.smps[0];this.ratioReference=0}n=[this.ratioReference]}else{var h=[];for(var v=0;v<this.groupingFactors.length;v++){if(this.groupingFactors[v]!=this.ratioGroupReference){h.push(this.groupingFactors[v])}}var e={};var x=[];var u=0;for(var v=0;v<this.smpIndices.length;v++){var p=this.smpIndices[v];var q=[];var A;for(var t=0;t<h.length;t++){var w=h[t];A=this.data.x[w][p];if(!A){A="NA"}q.push(A)}A=q.join(" - ");if(!e.hasOwnProperty(A)){this.data.w.smps.push(A);x[u]=A;e[A]=[];e[A].push(p);u++}else{e[A].push(p)}}n=this.getSamplesByAnnotationLevel(this.ratioGroupReference,this.ratioLevelReference);this.ratioReference=[];for(var v=0;v<this.data.w.grps.length;v++){var m=this.data.w.grps[v][0];var r=false;for(var s in e){for(var t=0;t<e[s].length;t++){if(m==e[s][t]){r=this.getObjectArray(e[s]);break}}if(r){break}}for(var t=0;t<n.length;t++){if(r.hasOwnProperty(n[t])){this.ratioReference.push(n[t]);break}}}}}else{if(this.ratioSampleReference){var y=this.isGroupedData&&this.graphType.match(/dotplot/i);if(y){this.isGroupedData=false;this.ratioReference=this.getSampleIndices(this.ratioSampleReference);this.isGroupedData=true}else{this.ratioReference=this.getSampleIndices(this.ratioSampleReference)}}if(this.ratioReference<0){this.ratioSampleReference=this.data.y.smps[0];this.ratioReference=0}n=[this.ratioReference]}for(var v=0;v<this.varIndices.length;v++){var p=this.varIndices[v];if(!d.trans){d.trans=[]}if(!d.trans[p]){d.trans[p]=[]}for(var t=0;t<d.data[p].length;t++){var k;if(this.isGroupedData&&this.ratioGroupReference&&this.data.x.hasOwnProperty(this.ratioGroupReference)){if(this.groupingFactors.length==1){k=this.data.w.data[p][this.ratioReference]}else{k=this.data.w.data[p][this.ratioReference[t]]}}else{k=d.data[p][this.ratioReference]}if(!isNaN(d.data[p][t])&&!isNaN(k)&&k>0){var f=this.transformBase==2?"ratio2":"ratio10";var z=d.data[p][t]/k;if(f=="ratio2"){d.trans[p][t]=Math.log(z)/Math.LN2}else{if(f=="ratio10"){d.trans[p][t]=Math.log(z)/Math.LN10}}}}}var g=[];var o=this.isGroupedData?this.grpIndices:this.smpIndices;var c=this.getObjectArray(n);for(var v=0;v<o.length;v++){if(!c.hasOwnProperty(o[v])){g.push(o[v])}}if(this.isGroupedData){this.tempIndices=this.grpIndices;this.grpIndices=g}else{this.tempIndices=this.smpIndices;this.smpIndices=g}};this.transformRelative=function(m,e,f){var c=this.isGroupedData&&!this.graphType.match(/dotplot/i)?this.data.w:this.data.y;var d=this.isGroupedData?false:true;e=e?e:this.zscoreAxis?this.zscoreAxis:"samples";if(e=="samples"){for(var h=0;h<c.data[f].length;h++){var k=[];for(var g=0;g<this.varIndices.length;g++){var l=this.varIndices[g];k.push(c.data[l][h])}if(m=="percentile"){var n=this.range(k,d)}else{if(m=="zscore"){var n=this.meanStandardDeviationN(k,d)}}for(var g=0;g<this.varIndices.length;g++){var l=this.varIndices[g];if(!c.trans){c.trans=[]}if(!c.trans[l]){c.trans[l]=[]}if(!isNaN(c.data[l][h])){if(m=="percentile"){c.trans[l][h]=this.percentile(n[0],n[1],c.data[l][h])}else{if(m=="zscore"){c.trans[l][h]=(c.data[l][h]-n[0])/n[1]}}}}}}else{for(var h=0;h<this.varIndices.length;h++){var o=this.varIndices[h];if(!c.trans){c.trans=[]}if(!c.trans[o]){c.trans[o]=[]}var k=c.data[o];if(m=="percentile"){var n=this.range(k,d)}else{if(m=="zscore"){var n=this.meanStandardDeviationN(k,d)}}for(var g=0;g<k.length;g++){if(!isNaN(c.data[o][g])){if(m=="percentile"){c.trans[o][g]=this.percentile(n[0],n[1],c.data[o][g])}else{if(m=="zscore"){c.trans[o][g]=(c.data[o][g]-n[0])/n[1]}}}}}}};this.sortSamples=function(h,k,f,e,g){this.sortIndices("smps",h,k,false,f,e,g);this.setOriginalIndices(0,false,false,true);this.draw()};this.sortSamplesByCategory=function(d){this.sortIndices("smps",false,d);this.setOriginalIndices(0,false,false,true);this.draw()};this.sortSamplesByVariable=function(d,c){var e=parseInt(this.getVariableIndices(d));this.sortIndices("smps",false,false,false,e+1,c);this.setOriginalIndices(0,false,false,true);this.draw()};this.sortVariables=function(h,k,f,e,g){this.sortIndices("vars",h,k,f,false,e,g);this.setOriginalIndices(0,false,false,true);this.draw()};this.sortVariablesByCategory=function(d){this.sortIndices("vars",false,d);this.setOriginalIndices(0,false,false,true);this.draw()};this.sortVariablesBySample=function(c){var d=parseInt(this.getSampleIndices(c));this.sortIndices("vars",false,false,d+1);this.setOriginalIndices(0,false,false,true);this.draw()};this.getGroupingFactors=function(c){if(c){return this.groupingFactors}else{return this.getObjectArray(this.groupingFactors)}};this.modifyGroupingFactors=function(d,c){this.modifyObjectArray(d,c,"groupingFactors")};this.segregateSamplesVariables=function(m,l,h,n,d){delete (this.data.l);this.deleteSubGraphAttributes();this.data.l={};this.data.l.smps=m;this.data.l.vars=l;this.data.l.weight=[];this.data.l.type=[];this.data.l.name=[];this.data.l.desc=[];var k=1/m.length;var f=1/l.length;var g=this.data.y.desc[0]?this.data.y.desc[0]:"";for(var e=0;e<l.length;e++){for(var c=0;c<m.length;c++){this.data.l.weight.push([f,k]);this.data.l.type.push(this.graphType);this.data.l.name.push([n[e],h[c]]);this.data.l.desc.push(g)}}this.layoutComb=true;this.layout=m.length+"X"+l.length;this.isValidLayout();if(!d){this.draw()}};this.desegregateSamples=function(c){this.segregateSamplesBy=false;this.showAnimation=this.showAnimationTemp;this.resetLayout();if(this.segregateVariablesBy){this.segregateVariables(this.segregateVariablesBy,c)}else{this.isValidLayout()}if(this.ungroupSamplesTemp){this.groupSamples(this.ungroupSamplesTemp,false,false,false,true);this.ungroupSamplesTemp=false}if(!c){this.draw()}};this.segregateSamples=function(d,f,h){if(h&&this.segregateSamplesBy==d){this.desegregateSamples(f);return}if(this.isGroupedData){this.ungroupSamplesTemp=this.groupingFactors;this.ungroupSamples()}if(this.data.x&&this.data.x[d]){delete (this.layoutParams);var e={};var c=0;var k=[];var m=[];for(var g=0;g<this.data.x[d].length;g++){var p=this.data.x[d][g];if(!e.hasOwnProperty(p)){e[p]=[];c++}e[p].push(this.data.y.smps[g])}var o=1/c;if(this.segregateVariablesBy){vars=this.data.l.vars;for(var p in e){k.push(p);m.push(e[p])}this.segregateSamplesBy=d;this.segregateSamplesVariables(m,this.data.l.vars,k,this.data.l.name,f)}else{delete (this.data.l);this.deleteSubGraphAttributes();this.data.l={};this.data.l.smps=[];this.data.l.weight=[];this.data.l.type=[];this.data.l.name=[];this.data.l.desc=[];for(var p in e){this.data.l.smps.push(e[p]);this.data.l.weight.push(o);this.data.l.type.push(this.graphType);this.data.l.name.push(p);this.data.l.desc.push(this.data.y.desc&&this.data.y.desc[0]?this.data.y.desc[0]:"")}this.segregateSamplesBy=d;this.layoutComb=true;this.showAnimationTemp=this.showAnimation;this.showAnimation=false;this.layout="1X"+this.data.l.smps.length;this.isValidLayout()}if(!f){this.draw()}}};this.desegregateVariables=function(c){this.segregateVariablesBy=false;this.showAnimation=this.showAnimationTemp;this.resetLayout();if(this.segregateSamplesBy){this.segregateSamples(this.segregateSamplesBy,c)}else{this.isValidLayout()}if(!c){this.draw()}};this.segregateVariables=function(p,e,h){if(h&&this.segregateVariablesBy==p){this.desegregateVariables(e);return}if(this.data.z&&this.data.z[p]){delete (this.layoutParams);var d={};var c=0;var m=[];var o=[];for(var f=0;f<this.data.z[p].length;f++){var k=this.data.z[p][f];if(!d.hasOwnProperty(k)){d[k]=[];c++}d[k].push(this.data.y.vars[f])}var q=1/c;if(this.segregateSamplesBy){for(var k in d){o.push(k);m.push(d[k])}this.segregateVariablesBy=p;this.segregateSamplesVariables(this.data.l.smps,m,this.data.l.name,o,e)}else{delete (this.data.l);this.deleteSubGraphAttributes();this.data.l={};this.data.l.vars=[];this.data.l.weight=[];this.data.l.type=[];this.data.l.name=[];this.data.l.desc=[];for(var k in d){this.data.l.vars.push(d[k]);this.data.l.weight.push(q);this.data.l.type.push(this.graphType);this.data.l.name.push(k);this.data.l.desc.push(this.data.y.desc&&this.data.y.desc[0]?this.data.y.desc[0]:"")}this.segregateVariablesBy=p;this.layoutComb=true;this.showAnimationTemp=this.showAnimation;this.showAnimation=false;this.layout="1X"+this.data.l.vars.length;this.isValidLayout()}if(!e){this.draw()}}};this.deleteSubGraphAttributes=function(){if(this.layoutRows&&this.layoutCols){var f=0;for(var e=0;e<this.layoutRows;e++){for(var d=0;d<this.layoutCols;d++){delete (this["subGraphWeight"+f]);delete (this["subGraphType"+f]);delete (this["subGraphSummaryType"+f]);delete (this["subGraphTransformType"+f]);f++}}}};this.unsetScatterPlotMatrix=function(){if(this.graphType.match(/Scatter/)){if(this.xAxisTemp&&this.xAxisTemp.length>0){this.xAxis=this.xAxisTemp;this.xAxisTmp=[]}if(this.yAxisTemp&&this.yAxisTemp.length>0){this.yAxis=this.yAxisTemp;this.yAxisTmp=[]}if(this.zAxisTemp&&this.zAxisTemp.length>0){this.zAxis=this.zAxisTemp;this.zAxisTmp=[]}if(!this.xAxis||!this.yAxis){this.xAxis=[];this.yAxis=[];this.xAxisIndices=[];this.yAxisIndices=[];this.xAxis=[this.data.y.smps[0]];for(var c=1;c<this.data.y.smps.length;c++){this.yAxis.push(this.data.y.smps[c])}this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis);this.initAxes(true)}this.scatterPlotMatrix=false;if(this.showAnimationTemp){this.showAnimation=this.showAnimationTemp}this.resetLayout();this.isValidLayout()}};this.setScatterPlotMatrix=function(){if(this.graphType.match(/Scatter/)){var f=this.data.y.data[0].length;var c=1/f;this.xAxisTemp=this.xAxisTemp||this.xAxis;this.xAxis=[];this.yAxisTemp=this.yAxisTemp||this.yAxis;this.yAxis=[];this.zAxisTemp=this.zAxisTemp||this.zAxis;this.zAxis=[];this.data.l={};this.data.l.smps=[];this.data.l.weight=[];this.data.l.type=[];this.data.l.desc=[];for(var e=0;e<f;e++){for(var d=0;d<f;d++){this.data.l.weight.push(c);this.data.l.desc.push(this.data.y.desc&&this.data.y.desc[0]?this.data.y.desc[0]:"");this.data.l.type.push(this.graphType);if(e==d){this.data.l.smps.push({})}else{if(this.scatterPlotMatrixType=="upper"){if(d>e){this.data.l.smps.push({xAxis:[this.data.y.smps[d]],yAxis:[this.data.y.smps[e]]})}else{this.data.l.smps.push({})}}else{if(this.scatterPlotMatrixType=="lower"){if(e>d){this.data.l.smps.push({xAxis:[this.data.y.smps[d]],yAxis:[this.data.y.smps[e]]})}else{this.data.l.smps.push({})}}else{this.data.l.smps.push({xAxis:[this.data.y.smps[d]],yAxis:[this.data.y.smps[e]]})}}}}}this.layoutComb=true;this.showAnimationTemp=this.showAnimation;this.showAnimation=false;this.layout=f+"X"+f;this.isValidLayout()}};this.setMultiplePies=function(){if(this.graphType.match(/Pie/)){var h,l;var k=this.xAxis.length;if(this.layout){var e=this.layout.split(/X/i);h=parseInt(e[0]);l=parseInt(e[1]);if(h*l<k){h=Math.ceil(Math.sqrt(k));l=Math.floor(Math.sqrt(k));this.layout=h+"X"+l}}else{h=Math.ceil(Math.sqrt(k));l=Math.floor(Math.sqrt(k));this.layout=h+"X"+l}var d=1/h;var g=1/l;delete (this.layoutParams);delete (this.data.l);this.deleteSubGraphAttributes();this.data.l={};this.data.l.smps=[];this.data.l.weight=[];this.data.l.type=[];this.data.l.desc=[];for(var f=0;f<k;f++){this.data.l.smps.push([this.xAxis[f]]);this.data.l.weight.push([g,d]);this.data.l.desc.push(this.data.y.desc&&this.data.y.desc[0]?this.data.y.desc[0]:"");this.data.l.type.push(this.graphType)}this.layoutComb=true;this.showAnimationTemp=this.showAnimation;this.showAnimation=false;this.isValidLayout()}};this.ungroupSamples=function(c){this.isGroupedData=false;this.groupingFactors=[];this.grpIndices=[];this.hiddenGrps=[];this.setMaxSmpStringName();this.setOriginalIndices(0,false,false,true);if(!c){this.draw()}return};this.createDOE=function(f){var l,k,h;var d=this.groupingFactors&&this.groupingFactors.length>0?this.groupingFactors:false;if(d){this.ungroupSamples(true)}this.resetFilters();if(this.graphType.match(/Scatter/i)){this.isDOE=2;l=this.varIndices;dat=this.data.z}else{this.isDOE=1;l=this.smpIndices;dat=this.data.x}h=this.getKeys(dat);if(this.includeDOE.length<1){for(var e=0;e<h.length;e++){if(e>=this.maxDOENumber){break}this.includeDOE.push(h[e])}}var g=Math.ceil(Math.sqrt(this.includeDOE.length+1));var m=g*(g-1)>=(this.includeDOE.length+1)?g-1:g;this.layout=g+"X"+m;delete (this.layoutParams);delete (this.data.l);this.deleteSubGraphAttributes();this.data.l={};this.data.l.smps=[[l]];this.data.l.weight=[[1/m,1/g]];this.data.l.type=[this.graphType];this.data.l.desc=[""];this.data.l.doe=l;for(var e=0;e<this.includeDOE.length;e++){this.data.l.smps.push([this.includeDOE[e]]);this.data.l.weight.push([1/m,1/g]);this.data.l.desc.push("");this.data.l.type.push(this.isNumeric(dat[this.includeDOE[e]])?"Scatter2D":"Pie")}this.layoutComb=true;this.isValidLayout();this.dataStndBy=this.data;this.configStndBy=this.getConfig();this.configStndBy.groupingFactors=d;this.showAnimation=false;this.title="";this.subtitle="";if(!f){this.removeMenus();this.draw()}};this.removeDOE=function(){var c=this.configStndBy?this.configStndBy.groupingFactors:false;this.isDOE=false;this.isPie=false;this.isPieGroup=false;this.isHistogram=false;this.isCreateHistogram=false;this.removeMenus();this.deleteSubGraphAttributes();this.switchData();delete (this.data.l);this.layoutComb=false;this.isValidLayout();if(c){this.groupSamples(c)}else{this.draw()}};this.resetDOE=function(){var c=[];var d=this.isDOE>1?this.dataStndBy.y.vars.length:this.dataStndBy.y.smps.length;for(var e=0;e<d;e++){c.push(e)}this.dataStndBy.l.doe=c;this.draw()};this.modifyDOE=function(g){var d=this.getObjectArray(this.includeDOE);if(d.hasOwnProperty(g)){var c=[];for(var e=0;e<this.includeDOE.length;e++){if(this.includeDOE[e]!=g){c.push(this.includeDOE[e])}}this.includeDOE=c}else{this.includeDOE.push(g)}while(this.includeDOE.length>this.maxDOENumber+1){this.includeDOE.shift()}this.createDOE(true);this.draw()};this.createPie=function(m){var f=this.groupingFactors&&this.groupingFactors.length>0?this.groupingFactors:false;var e={};e.data={};e.smps={};var k={};k.y={};k.y.data=[];k.y.vars=[];k.y.smps=[];k.y.pie=[];if(!CanvasXpress.cacheImagesReady){setTimeout(function(){that.createPie(m)},200)}else{if(f){this.ungroupSamples(true)}var d,h;if(this.isDOE){d=this.dataStndBy.l.doe;h=this.isDOE>1?this.dataStndBy.z[m]:this.dataStndBy.x[m]}else{d=this.smpIndices;h=this.data.x[m]}for(var g=0;g<d.length;g++){var l=h[d[g]];if(!e.data[l]){e.data[l]=0;e.smps[l]=[]}e.data[l]++;e.smps[l].push(d[g])}k.y.smps.push(m);for(var g in e.data){k.y.vars.push(g);k.y.data.push([e.data[g]]);k.y.pie.push(e.smps[g])}if(this.isDOE){this.graphType="Pie";this.initializeData(k)}else{this.dataStndBy=this.data;this.configStndBy=this.getConfig();this.configStndBy.isPie=false;this.data={};this.graphType="Pie";this.isPie=true;this.isPieGroup=f;this.initializeData(k);this.removeMenus();this.draw()}}};this.removePie=function(){var c=this.isPieGroup;this.isPie=false;this.isPieGroup=false;this.removeMenus();this.switchData();if(c){this.groupSamples(c)}else{this.draw()}};this.modifyHistogram=function(){if(this.isHistogram){var f=this.isCreateHistogram[2];var c=this.isCreateHistogram[3];var d=this.histogramBins;var e=this.histogramStagger;this.removeHistogram();this.histogramBins=d;this.histogramStagger=e;if(f){this.transpose()}this.createHistogram(f,c)}};this.createHistogramTr=function(){var c=this.groupingFactors;this.transpose();this.createHistogram(true,c)};this.createHistogram=function(e,f,l){var m=this;var d=[];var D=[];var h=[];var x=[];var F=[];var y,B,s,C,c,q,g,r,E,p,u;var G={};var w=this.histogramBins?this.histogramBins:Math.min(500,this.data.y.vars.length);G.y={};G.y.data=[];G.y.vars=[];G.y.smps=[];G.y.histogram=[];G.y.kde=[];G.y.stats=[];if(!CanvasXpress.cacheImagesReady||!this.getAxisIncrements){setTimeout(function(){m.createHistogram(e,f)},200)}else{if(this.isDOE&&l){r=this.dataStndBy.l.doe;E=this.isDOE>1?this.dataStndBy.z[l]:this.dataStndBy.x[l];for(var A=0;A<r.length;A++){d.push(E[r[A]])}q=this.range(d);y=q[0];B=q[1]}else{if(this.graphType.match(/Scatter/)){y=Math.min(this.xAxisMin,this.yAxisMin);B=Math.max(this.xAxisMax,this.yAxisMax)}else{y=this.minData;B=this.maxData}}p=this.heckbert(y,B,this.xAxisTicks);y=p[0];B=p[p.length-1];C=p[1]-p[0];c=this.getAxisDecimals(C);s=((B-y)/w);g=this.isDOE&&l?1:this.smpIndices.length;for(var A=0;A<=w;A++){G.y.vars.push("Bin"+(A+1)+" ("+this.formatNumber(y+(s*A),c)+" - "+this.formatNumber(y+(s*(A+1)),c)+")");G.y.data[A]=[];G.y.data[A][0]=s*(A+1);G.y.histogram[A]=[];for(var z=0;z<g;z++){G.y.histogram[A][z]=[]}}G.y.smps.push("Bin");D.push("Bin");if(this.isDOE&&l){d=[];G.y.smps.push(l);h.push(l);var k=[];for(var A=0;A<=w;A++){k[A]=0}for(var A=0;A<r.length;A++){var o=E[r[A]];if(o!=null&&o!=""&&!isNaN(o)){var t=Math.min(Math.floor((o-y)/s),w-1);d.push(parseFloat(E[r[A]]));if(!isNaN(t)){k[t]++;G.y.histogram[t][0].push(A)}}}x=[1];for(var z=0;z<w;z++){G.y.data[z][1]=k[z]}if(this.showHistogramDensity){G.y.kde.push(this.kde(this.histogramDensityKernel,false,[y,B],s/5,d));G.y.stats.push([d.length,s])}}else{for(var A=0;A<this.smpIndices.length;A++){u=0;d=[];G.y.smps.push(this.data.y.smps[this.smpIndices[A]]);h.push(this.data.y.smps[this.smpIndices[A]]);var k=[];for(var z=0;z<=w;z++){k[z]=0}for(var z=0;z<this.varIndices.length;z++){var o=this.data.y.data[this.varIndices[z]][this.smpIndices[A]];if(o!=null&&o!=""&&!isNaN(o)){var t=Math.min(Math.floor((o-y)/s),w-1);d.push(parseFloat(this.data.y.data[this.varIndices[z]][this.smpIndices[A]]));if(!isNaN(t)){k[t]++;G.y.histogram[t][A].push(this.varIndices[z])}u++}}x.push(u);for(var z=0;z<=w;z++){G.y.data[z][A+1]=k[z]}if(this.showHistogramDensity){G.y.kde.push(this.kde(this.histogramDensityKernel,false,[y,B],s/5,d));G.y.stats.push([d.length,s])}}}for(var A=0;A<x.length;A++){F.push(A)}F.sort(function(v,n){return x[n]-x[v]});if(!this.isDOE){this.dataStndBy=this.data;this.configStndBy=this.getConfig();this.configStndBy.isCreateHistogram=false;this.configStndBy.isHistogram=false}this.data={};this.graphType="Scatter2D";this.isHistogram=true;this.isCreateHistogram=[y,s,e,f,F];this.xAxis=D;this.yAxis=h;this.setMinX=null;this.setMaxX=null;this.setMinX2=null;this.setMaxX2=null;this.setMinY=null;this.setMaxY=null;this.setMinZ=null;this.setMaxZ=null;this.initializeData(G);if(!this.isDOE){this.removeMenus();this.draw()}}};this.removeHistogram=function(){var d=this.isCreateHistogram[2];var c=this.isCreateHistogram[3];this.removeMenus();this.switchData();if(d){this.transpose()}if(c){this.groupSamples(c)}else{this.draw()}};this.correlateData=function(f,e){if(this.graphType.match(/Scatter/i)){this.addRegressionLine()}else{this.dataStndBy=this.data;this.configStndBy=this.getConfig();var d=this.groupingFactors;if(e){if(f){this.switchAnnotationToVar(e)}else{this.switchAnnotationToSmp(e)}}var c=f?this.data.y.vars:this.data.y.smps;this.graphType="Scatter2D";this.type2D="XY";if(d){this.ungroupSamples(true)}if(f){this.transpose(false,true)}this.xAxis=[c[0]];this.xAxisTitle=c[0];this.xAxisIndices=[0];this.yAxis=[c[1]];this.yAxisTitle=c[1];this.yAxisIndices=[1];this.showAnimation=false;this.addRegressionLine(true);this.isCorrelate=true;this.isCorrelateTranspose=f;this.isCorrelateGroup=d;this.isCorrelateKey=e;this.draw(false,false,false,false,true)}this.removeMenus()};this.removeCorrelation=function(){if(this.isCorrelate){this.removeMenus();if(this.data.d&&this.data.d.reg){delete (this.data.d.reg)}this.switchData();if(this.isCorrelateTranspose){this.transpose()}if(this.isCorrelateKey){if(this.isCorrelateTranspose){this.switchVarToAnnotation(this.isCorrelateKey)}else{this.switchSmpToAnnotation(this.isCorrelateKey)}}if(this.isCorrelateGroup){this.groupSamples(this.isCorrelateGroup)}else{this.draw()}this.isCorrelate=false;this.isCorrelateTranspose=false;this.isCorrelateGroup=false;this.isCorrelateKey=false}else{delete (this.data.d.reg);this.draw()}};this.addRegressionLine=function(e){var k=this;var n,f,m,l,c,h,d;if(!CanvasXpress.cacheImagesReady){setTimeout(function(){k.addRegressionLine(e)},100)}else{if(this.graphType.match(/Scatter/)){if(this.type2D=="XYZ"){n=this.xAxisIndices[this.xAxisCurrent];f=this.yAxisIndices[this.yAxisCurrent];h=this.data.y.smps[n]+" vs "+this.data.y.smps[f];m=this.getDataForSmpGrpAtIndex(n);l=this.getDataForSmpGrpAtIndex(f);c=this.regression(m,l);this.addRegressionDecoration(c,h,this.foreground)}else{if(this.type2D=="XY"){for(var g=0;g<this.xAxisIndices.length;g++){d=g%this.colors.length;n=this.xAxisIndices[g];f=this.yAxisIndices[g];h=this.data.y.smps[n]+" vs "+this.data.y.smps[f];m=this.getDataForSmpGrpAtIndex(n);l=this.getDataForSmpGrpAtIndex(f);c=this.regression(m,l);this.addRegressionDecoration(c,h,this.colors[d])}}else{if(this.type2D=="X"){f=this.yAxisIndices[this.yAxisCurrent];l=this.getDataForSmpGrpAtIndex(f);for(var g=0;g<this.xAxisIndices.length;g++){d=g%this.colors.length;n=this.xAxisIndices[g];h=this.data.y.smps[n]+" vs "+this.data.y.smps[f];m=this.getDataForSmpGrpAtIndex(n);c=this.regression(m,l);this.addRegressionDecoration(c,h,this.colors[d])}}else{n=this.xAxisIndices[this.xAxisCurrent];m=this.getDataForSmpGrpAtIndex(n);for(var g=0;g<this.yAxisIndices.length;g++){d=g%this.colors.length;f=this.yAxisIndices[g];l=this.getDataForSmpGrpAtIndex(f);h=this.data.y.smps[n]+" vs "+this.data.y.smps[f];c=this.regression(m,l);this.addRegressionDecoration(c,h,this.colors[d])}}}}if(!e){this.draw()}}}};this.addRegressionDecoration=function(e,d,c){this.showDecorations=true;if(!this.data.d){this.data.d={}}if(!this.data.d.reg){this.data.d.reg=[]}this.data.d.reg.push({slope:e[0],intercept:e[1],cor:e[2],label:d,color:c})};this.addNormalDistributionLine=function(d){var m=this;var r,h,p,k,l,n,o,g,e,g,c,q;if(!CanvasXpress.cacheImagesReady){setTimeout(function(){m.addNormalDistributionLine(d)},100)}else{if(this.graphType.match(/Scatter/)){if(this.type2D=="XYZ"){p=d=="y"?this.yAxisIndices[this.yAxisCurrent]:this.xAxisIndices[this.xAxisCurrent];k=d=="y"?this.xAxisIndices[this.xAxisCurrent]:this.yAxisIndices[this.yAxisCurrent];l=this.getDataForSmpGrpAtIndex(p);n=this.getDataForSmpGrpAtIndex(k);o=this.max(n);g=this.data.y.smps[p];e=this.meanStandardDeviationN(l);this.addNormalDistributionDecoration(e,o,g,this.foreground,d)}else{r=d=="y"?this.yAxisIndices:this.xAxisIndices;h=d=="y"?this.xAxisIndices:this.yAxisIndices;q=d=="y"?this.xAxisCurrent:this.yAxisCurrent;for(var f=0;f<r.length;f++){c=f%this.colors.length;p=r[f];k=h[f]?h[f]:h[q];l=this.getDataForSmpGrpAtIndex(p);n=this.getDataForSmpGrpAtIndex(k);o=this.max(n);g=this.data.y.smps[p];e=this.meanStandardDeviationN(l);this.addNormalDistributionDecoration(e,o,g,this.colors[c],d)}}this.draw()}}};this.addNormalDistributionDecoration=function(g,c,e,d,f){this.showDecorations=true;if(!this.data.d){this.data.d={}}if(!this.data.d.nor){this.data.d.nor=[]}if(f&&f=="y"){this.data.d.nor.push({mu:g[0],sigma:g[1],yAxis:true,max:c,label:e,color:d})}else{this.data.d.nor.push({mu:g[0],sigma:g[1],max:c,label:e,color:d})}};this.addKaplanMeyerCurve=function(h,C,k,B){var f=false;var G={d:{},c:{}};var e={};var m=1.95996;var r=m*m;var x,w,y,E,s,A;if(h&&C){var g=this.getSampleIndices(h);var o=this.getSampleIndices(C);if(g!=null&&o!=null){for(var D=0;D<this.varIndices.length;D++){var v=this.data.y.data[D][g];var F=this.data.y.data[D][o];if(!isNaN(F)){if(!isNaN(F)&&F==0){G.d[v]=G.d[v]?G.d[v]+1:1;e[v]=true}else{G.c[v]=G.c[v]?G.c[v]+1:1;e[v]=true}}}e=this.getKeys(e);e.sort(function(d,c){return d-c});f={times:e,data:[]};for(var D=0;D<e.length;D++){f.data.push([G.c[e[D]]||0,G.d[e[D]]||0])}f.data[0].push(this.varIndices.length);for(var D=1;D<e.length;D++){f.data[D].push(f.data[D-1][2]-(f.data[D-1][0]+f.data[D-1][1]))}x=1;for(var D=0;D<e.length;D++){x=x*(1-(f.data[D][1]/f.data[D][2]));w=1-x;y=(2*x*this.varIndices.length)+r+1+(m*Math.sqrt(r+2-(1/this.varIndices.length)+4*x*((w*this.varIndices.length)-1)));E=2*(this.varIndices.length+r);s=y/E;if(x==1){s=1}y=(2*x*this.varIndices.length)+r-1-(m*Math.sqrt(r-2-(1/this.varIndices.length)+4*x*((w*this.varIndices.length)+1)));A=y/E;if(x==0){A=0}f.data[D].push(x,s,A)}this.addKaplanMeyerDecoration(h,f,k,B)}}};this.addKaplanMeyerDecoration=function(f,e,d,c){this.showDecorations=true;if(!this.data.d){this.data.d={}}if(!this.data.d.kaplanMeyer){this.data.d.kaplanMeyer=[]}this.data.d.kaplanMeyer.push({time:f,data:e,label:d||"Kaplan - Meyer "+(this.data.d.kaplanMeyer.length+1),color:c||this.colors[this.data.d.kaplanMeyer.length%this.colors.length]})};this.addLineDecoration=function(f,g,e,d){if(!this.graphType.match(/Scatter|Network|Genome|Correlation|Venn|Circular/)){if(!this.data.d){this.data.d={}}if(!this.data.d.lines){this.data.d.lines=[]}if(f&&f=="solid"){f="line"}this.data.d.lines.push({type:f||"line",color:g||this.foreground,value:e||0,label:d||false})}};this.showVariableOverlays=function(e){var c={};if(this.graphType=="Heatmap"&&this.data.z){for(var d=0;d<this.varOverlays.length;d++){c[this.varOverlays[d]]=true}if(c[e]){delete (c[e])}else{c[e]=true}this.varOverlays=this.getKeys(c);this.draw()}};this.showSampleOverlays=function(e){var d={};if(this.data.x){for(var c=0;c<this.smpOverlays.length;c++){d[this.smpOverlays[c]]=true}if(d[e]){delete (d[e])}else{d[e]=true}this.smpOverlays=this.getKeys(d);this.draw()}};this.showSampleGroups=function(e){var d={};if(this.data.x){for(var c=0;c<this.groupingFactors.length;c++){d[this.groupingFactors[c]]=true}if(d[e]){delete (d[e])}else{d[e]=true}this.groupSamples(this.getKeys(d))}};this.toggleAttribute=function(d,f,e){this[d]=this[d]?false:true;if(f){this[f](e)}else{this.draw()}};this.changeAttribute=function(e,c,f){if(typeof(c)=="boolean"||this.hasOwnProperty(e)){this[e]=this[e]&&this[e]==c&&!f?false:this[e]&&this[e]==c&&f?f:c}else{if(e&&c){this[e]=c}}this.draw()};this.changeTextColorAttribute=function(e,d){var d=this.$(d).value;var g=e[1];var f=e[2];e=e[0];if(CanvasXpress.doc.P[e].T=="integer"){this[e]=d!=""?parseInt(d):null}else{if(CanvasXpress.doc.P[e].T=="float"){this[e]=d!=""?parseFloat(d):null}else{this[e]=d}}if(g){this[g](f)}else{this.draw()}};this.changeVariableInAxis=function(d,f){if(this.data.a&&this.data.a.xAxis&&this.data.a.xAxis2){var e=this.getObjectArray(this.data.a.xAxis);var c=this.getObjectArray(this.data.a.xAxis2);if(f=="xAxis"){if(c[d]){if(this.data.a.xAxis2.length>1){this.removeVariablesFromAxis([d],"xAxis2")}else{alert("Cannot remove "+d+" from X-Axis 2");this.removeMenus();return}this.addVariablesToAxis([d],f)}else{if(e[d]){if(this.data.a.xAxis.length>1){this.removeVariablesFromAxis([d],f)}else{alert("Cannot remove "+d+" from X-Axis");this.removeMenus();return}}else{this.addVariablesToAxis([d],f)}}}else{if(f=="xAxis2"){if(e[d]){if(this.data.a.xAxis.length>1){this.removeVariablesFromAxis([d],"xAxis")}else{alert("Cannot remove "+d+" from X-Axis");this.removeMenus();return}this.addVariablesToAxis([d],f)}else{if(c[d]){if(this.data.a.xAxis2.length>1){this.removeVariablesFromAxis([d],f)}else{alert("Cannot remove "+d+" from X-Axis 2");this.removeMenus();return}}else{this.addVariablesToAxis([d],f)}}}}}this.draw()};this.changeTransformRatio=function(c,d){if(c=="sample"){if(this.ratioSampleReference==d){this.ratioSampleReference=false;this.transform("reset")}else{this.ratioSampleReference=d;this.transform("ratio")}}else{if(c=="group"){if(this.ratioGroupReference==d){this.ratioLevelReference=false;this.ratioGroupReference=false;this.transform("reset")}else{this.ratioGroupReference=d;this.ratioLevelReference=false;this.transform("ratio")}this.removeMenus()}else{if(c=="level"){this.transform("reset");if(this.ratioLevelReference==d){this.ratioLevelReference=false}else{this.ratioLevelReference=d}this.transform("ratio")}}}};this.changeSampleInAxis=function(f,g){if(this.graphType.match(/Scatter/)){var d,c,h,e;d=this.getObjectArray(this.xAxis);c=this.getObjectArray(this.yAxis);if(this.graphType=="ScatterBubble2D"||this.graphType=="Scatter3D"){h=this.getObjectArray(this.zAxis);e=true}if(g=="xAxis"){if(c[f]&&!e){if(this.yAxis.length>1){this.removeSamplesFromAxis([f],"yAxis")}else{alert("Cannot remove "+f+" from Y-Axis");this.removeMenus();return}this.addSamplesToAxis([f],g)}else{if(h&&h[f]&&!e){if(this.zAxis.length>1){this.removeSamplesFromAxis([f],"zAxis")}else{alert("Cannot remove "+f+" from Z-Axis");this.removeMenus();return}}else{if(d[f]&&!e){if(this.xAxis.length>1){this.removeSamplesFromAxis([f],g)}else{alert("Cannot remove "+f+" from X-Axis");this.removeMenus();return}}else{if(e){this[g]=[];this.addSamplesToAxis([f],g)}else{this.addSamplesToAxis([f],g)}}}}}else{if(g=="yAxis"){if(d[f]&&!e){if(this.xAxis.length>1){this.removeSamplesFromAxis([f],"xAxis")}else{alert("Cannot remove "+f+" from X-Axis");this.removeMenus();return}this.addSamplesToAxis([f],g)}else{if(h&&h[f]&&!e){if(this.zAxis.length>1){this.removeSamplesFromAxis([f],"zAxis")}else{alert("Cannot remove "+f+" from Z-Axis");this.removeMenus();return}}else{if(c[f]&&!e){if(this.yAxis.length>1){this.removeSamplesFromAxis([f],g)}else{alert("Cannot remove "+f+" from Y-Axis");this.removeMenus();return}}else{if(e){this[g]=[];this.addSamplesToAxis([f],g)}else{this.addSamplesToAxis([f],g)}}}}}else{if(g=="zAxis"){if(d[f]&&!e){if(this.xAxis.length>1){this.removeSamplesFromAxis([f],"xAxis")}else{alert("Cannot remove "+f+" from X-Axis");this.removeMenus();return}this.addSamplesToAxis([f],g)}else{if(c[f]&&!e){if(this.yAxis.length>1){this.removeSamplesFromAxis([f],"yAxis")}else{alert("Cannot remove "+f+" from Y-Axis");this.removeMenus();return}}else{if(h[f]&&!e){if(this.zAxis.length>1){this.removeSamplesFromAxis([f],g)}else{alert("Cannot remove "+f+" from Z-Axis");this.removeMenus();return}}else{if(e){this[g]=[];this.addSamplesToAxis([f],g)}else{this.addSamplesToAxis([f],g)}}}}}}}this.draw()}};this.showConfiguratorCategory=function(d,c){this.removeMenus();this.addConfigurator(d);this.clickSearch(d);this.changeCategory(d,false,c);this.hideCategories()};this.setFontAttributeStyle=function(d,c){var e=this[d];if(c=="bold"){if(this[d].match(c)){this[d]=this[d].replace("bold","")}else{if(e=="italic"){this[d]="bold italic"}else{this[d]="bold"}}}else{if(c=="italic"){if(this[d].match(c)){this[d]=this[d].replace("italic","")}else{if(e=="bold"){this[d]="bold italic"}else{this[d]="italic"}}}else{this[d]=this[d].replace("bold italic","");this[d]=this[d].replace("bold","");this[d]=this[d].replace("italic","")}}this.draw()};this.setFontAttributeSize=function(d,c){if(c=="increase"){this[d]=this[d]*1.1}else{this[d]=this[d]/1.1}this.draw()};this.showHideDendrogram=function(c){if(this[c]){this[c]=false}else{this[c]=true}this.draw()};this.changeDendrogramPosition=function(c){if(this[c]=="left"){this[c]="right"}else{if(this[c]=="right"){this[c]="left"}else{if(this[c]=="top"){this[c]="bottom"}else{if(this[c]=="bottom"){this[c]=="top"}}}}};this.createRandomData=function(k){var h={};if(this.graphType=="Network"){if(this.randomDataSymmetrical){h=this.createRandomNetwork();if(k){return h}this.calculateLayout=true;this.layoutDone=false}else{h=this.createRandomNetwork();if(k){return h}this.calculateLayout=true;this.layoutDone=false}}else{if(this.graphType=="Venn"||this.graphType=="Genome"||this.graphType=="Candlestick"){h=this.dataSetExample}else{h.y={};h.y.data=[];h.y.vars=[];h.y.smps=[];h.y.desc=["Magnitude 1","Magnitude 2"];for(var f=0;f<this.randomDataSamples;f++){if(this.isGraphTime){h.y.smps[f]=new Date(this.startTime+(f*this.times.day))}else{h.y.smps[f]="Sample"+(f+1)}}for(var f=0;f<this.randomDataVariables;f++){h.y.data[f]=[];h.y.vars[f]="Variable"+(f+1);for(var e=0;e<this.randomDataSamples;e++){if(this.randomDataUniform){h.y.data[f].push(100)}else{if(this.randomDataSymmetrical){h.y.data[f].push((f*10)+((e+1)*5))}else{h.y.data[f].push(Math.floor(((Math.random()*2-1)+(Math.random()*2-1)+(Math.random()*2-1))*this.randomDataSigma+this.randomDataMean))}}}}if(this.randomMissingDataPercentage>0&&this.randomMissingDataPercentage<1){var d=0;var c=this.randomDataVariables*this.randomDataSamples*this.randomMissingDataPercentage;while(d<c){var f=Math.floor(Math.random()*this.randomDataVariables);var e=Math.floor(Math.random()*this.randomDataSamples);if(h.y.data[f][e]){delete (h.y.data[f][e]);d++}}}h.x={};var g=Math.floor(this.randomDataSamples/this.randomDataSampleAnnotationRatio);for(var f=0;f<this.randomDataSampleAnnotations;f++){h.x["Factor"+(f+1)]=[];for(var e=0;e<this.randomDataSamples;e++){if(this.randomDataSymmetrical){h.x["Factor"+(f+1)][e]="Lev:"+(Math.floor(f/(e+1))+1)+":"+(f+1)}else{h.x["Factor"+(f+1)][e]="Lev:"+(Math.floor(Math.random()*g)+1)+":"+(f+1)}}}h.z={};var g=Math.floor(this.randomDataVariables/this.randomDataVariableAnnotationRatio);for(var f=0;f<this.randomDataVariableAnnotations;f++){h.z["Annt"+(f+1)]=[];for(var e=0;e<this.randomDataVariables;e++){if(this.randomDataSymmetrical){h.z["Annt"+(f+1)][e]="Desc:"+(Math.floor(f/(e+1))+1)+":"+(f+1)}else{h.z["Annt"+(f+1)][e]="Desc:"+(Math.floor(Math.random()*g)+1)+":"+(f+1)}}}h.a={xAxis:[],xAxis2:[]};for(var f=0;f<Math.floor(this.randomDataVariables/2);f++){h.a.xAxis.push("Variable"+(f+1))}for(var f=Math.floor(this.randomDataVariables/2);f<this.randomDataVariables;f++){h.a.xAxis2.push("Variable"+(f+1))}}}if(k){return h}this.randomData=true;if(this.data&&!this.dataStndBy){this.dataStndBy=this.data;this.configStndBy=this.getConfig();this.data={}}this.resetConfig(["graphType","imageDir"]);this.initializeData(h);this.draw()};this.restoreRandomData=function(){this.switchData()};this.groupSamples=function(h,r,A,g,s){if(!h||h.length<1){return this.ungroupSamples()}if(!this.isArray(h)){h=[h]}for(var x=0;x<h.length;x++){if(!h||!this.data.x[h[x]]){return this.ungroupSamples()}}if(this.layoutComb&&this.data.l.comp){this.varIndices=[];for(var x=0;x<this.data.l.comp.length;x++){for(var v=0;v<this.data.l.comp[x].length;v++){this.varIndices.push(this.data.l.comp[x][v])}}}var d={};var B=[];var w=0;var m=this.data.w&&this.data.w.smps?this.data.w.smps:false;if(!g){this.resetIndices()}this.isGroupedData=true;this.groupingFactors=h;this.resetObject(true);this.hiddenGrps=[];for(var x=0;x<this.smpIndices.length;x++){var o=this.smpIndices[x];var q=[];var D;for(var v=0;v<h.length;v++){var y=h[v];D=this.data.x[y][o];if(!D){D="NA"}q.push(D)}D=q.join(" - ");if(!d.hasOwnProperty(D)){this.data.w.smps.push(D);B[w]=D;d[D]=[];d[D].push(o);w++}else{d[D].push(o)}}if(B.length<1){this.data.w.smps=m;this.draw();return}for(var x=0;x<B.length;x++){var D=B[x];this.data.w.grps.push(d[D])}this.grpIndices=[];if(A){for(var x=0;x<A.length;x++){this.grpIndices.push(A[x]);this.hiddenGrps.push(false)}}else{for(var x=0;x<this.data.w.grps.length;x++){this.grpIndices.push(x);this.hiddenGrps.push(false)}}for(var x=0;x<this.varIndices.length;x++){this.data.w.vars.push(this.data.y.vars[this.varIndices[x]])}var n={};for(var D in this.data.x){n[D]=this.isNumeric(this.data.x[D])}for(var x=0;x<this.data.w.grps.length;x++){for(var D in this.data.x){if(!this.data.w.factors.hasOwnProperty(D)){this.data.w.factors[D]=[]}var l;if(n[D]){l=[];for(var v=0;v<this.data.w.grps[x].length;v++){var C=this.data.x[D][this.data.w.grps[x][v]];if(isNaN(C)){l.push(C)}}this.data.w.factors[D].push(this.mean(l))}else{l={};for(var v=0;v<this.data.w.grps[x].length;v++){var C=this.data.x[D][this.data.w.grps[x][v]];if(C!=null&&C!=""){l[this.data.x[D][this.data.w.grps[x][v]]]=true}}var c=this.getKeys(l);this.data.w.factors[D].push(c.join(" + "))}}}var n=[];if(r){if(this.isArray(r)){n=r}else{n.push(r)}}else{r=this.graphType=="Boxplot"?"iqr":"mean";n.push(r)}for(var p=0;p<n.length;p++){var z=[];var f=n[p];if(this.isTransformedData){b=this.data.y.trans}else{if(this.isRawData){b=this.data.y.data}else{if(this.summaryType=="median"||this.summaryType=="iqr"){b=this.data.y.median}else{if(this.summaryType=="mean"){b=this.data.y.mean}else{if(this.summaryType=="cor"){b=this.data.y.cor}else{if(this.summaryType=="sum"){b=this.data.y.sum}else{b=this.data.y[this.summaryType]}}}}}}for(var x=0;x<this.varIndices.length;x++){var o=this.varIndices[x];z[o]=[];for(var v=0;v<this.data.w.grps.length;v++){z[o][v]=[];for(var u=0;u<this.data.w.grps[v].length;u++){var e=this.data.w.grps[v][u];z[o][v].push(b[o][e])}}}this.summarize(f,z)}this.setMaxVarStringName();this.setMaxSmpStringName();this.xAxisValues=[];this.xAxis2Values=[];this.yAxisValues=[];this.zAxisValues=[];if(!this.layoutComb||!this.layoutAdjust){if(typeof(this.setAxes)=="function"){this.setAxes()}}this.setOriginalIndices(0,false,false,true);if(!s){this.draw()}};this.setIndices=function(c,d){if(this.graphType=="Network"){this.setNodes()}else{if(this.graphType!="Genome"&&this.graphType!="Venn"){this.setAllVariablesVisible(c);this.setAllSamplesVisible(d)}}};this.resetIndices=function(){if(this.isGroupedData){this.setIndices()}};this.setAnnotationsType=function(){if(!this.xAnntType){this.xAnntType={}}if(!this.zAnntType){this.zAnntType={}}if(this.data.x){for(var c in this.data.x){this.xAnntType[c]=this.isNumeric(this.data.x[c])?"Numeric":"String"}}if(this.data.z){for(var c in this.data.z){this.zAnntType[c]=this.isNumeric(this.data.z[c])?"Numeric":"String"}}};this.initializeDataAttributes=function(c,d){this.setIndices(c,d);if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){this.setMaxVarStringAttr();this.setMaxSmpStringAttr();this.setAnnotationsType()}};this.initializeData=function(c){if(b&&!c){this.isExample=false;this.data=b;delete (b)}else{if(c){this.isExample=false;this.data=c;delete (c)}else{if(!this.remoteService){this.isExample=true}this.data=this.dataSetExample}}this.samplesData=false;this.variablesData=false;this.nodesData=false;this.edgesData=false;this.featuresData=false;this.validGraphTypes=[];if(this.data&&(this.data.y||this.data.dataframe||this.data.venn||this.data.nodes||this.data.tracks||this.data.market||this.data.fx||this.data.video)){if(this.data.fx){this.FunctionData()}if(this.data.market){this.setMarketData();this.summaryType="candle";this.validGraphTypes.push("Candlestick")}if(this.data.dataframe){this.setFrameData()}if(this.data.venn){this.summaryType="venn";this.validGraphTypes.push("Venn")}if(this.data.video){this.summaryType="video";this.validGraphTypes.push("Video")}if(this.data.nodes){this.summaryType="network";this.validGraphTypes.push("Network")}if(this.data.tracks){this.summaryType="genome";this.validGraphTypes.push("Genome")}if(this.data.y){if(!this.data.y.data&&!this.data.y.mean&&!this.data.y.median&&!this.data.y.cor&&!this.data.y.sum&&!this.data.y.close){alert("Dude! there is not a valid data structure");return}else{if(this.data.y.data){this.isRawData=true;this.summaryType="raw"}else{this.isRawData=false;if(this.data.y.iqr1&&this.data.y.qtl1&&this.data.y.median&&this.data.y.qtl3&&this.data.y.iqr3){this.summaryType="iqr"}else{if(this.data.y.median){this.summaryType="median"}else{if(this.data.y.mean){this.summaryType="mean"}else{if(this.data.y.cor){this.summaryType="cor"}else{if(this.data.y.sum){this.summaryType="sum"}}}}}}}this.validGraphTypes.push("Bar");this.validGraphTypes.push("Line");this.validGraphTypes.push("Area");this.validGraphTypes.push("AreaLine");this.validGraphTypes.push("BarLine");this.validGraphTypes.push("Boxplot");this.validGraphTypes.push("Dotplot");this.validGraphTypes.push("DotLine");this.validGraphTypes.push("Heatmap");this.validGraphTypes.push("Stacked");this.validGraphTypes.push("StackedLine");this.validGraphTypes.push("StackedPercent");this.validGraphTypes.push("StackedPercentLine");this.validGraphTypes.push("Pie");this.validGraphTypes.push("Correlation");this.validGraphTypes.push("Circular");if(this.data.y.smps){if(this.data.y.smps.length>2){this.validGraphTypes.push("Scatter2D");this.validGraphTypes.push("ScatterBubble2D");this.validGraphTypes.push("Scatter3D")}else{if(this.data.y.smps.length>1){this.validGraphTypes.push("Scatter2D")}}}}this.validGraphTypes.sort()}this.initializeDataAttributes(this.data.initialVarIndices,this.data.initialSmpIndices);delete (this.data.initialVarIndices);delete (this.data.initialSmpIndices)};this.setMarketTechnicalData=function(){if(this.stockIndicators.length>0){var d={};var l=false;var m={Sma5:5,Sma10:10,Sma20:20,Sma25:25,Sma50:50};var c=[];for(var h=0;h<this.stockIndicators.length;h++){if(m.hasOwnProperty(this.stockIndicators[h])){c.push(this.stockIndicators[h])}}if(c.length>0){this.stockIndicators=c;var o={};for(var h=0;h<this.stockIndicators.length;h++){var p=this.stockIndicators[h];if(m.hasOwnProperty(p)&&!this.data.y.hasOwnProperty(p)){d[p]=true;l=true;o[p]=[];this.data.y[p]=[];for(var g=0;g<this.data.y.vars.length;g++){o[p][g]=[];this.data.y[p][g]=[]}}}if(l){for(var h=0;h<this.data.y.smps.length;h++){for(var g=0;g<this.data.y.vars.length;g++){for(var f=0;f<this.stockIndicators.length;f++){var p=this.stockIndicators[f];if(d.hasOwnProperty(p)){if(!isNaN(this.data.y.close[g][h])){o[p][g].push(this.data.y.close[g][h]);if(o[p][g].length==m[p]){if(p.match(/Sma/)){this.data.y[p][g][h]=this.mean(o[p][g]);o[p][g].shift()}}}}}}}}}}};this.setMarketData=function(){if(this.data.market&&!this.isMarketDataFormated){var e=this.data.market;this.data.market={};this.data.market.smps=[];this.data.market.vars=[];this.data.market.close=[];this.data.market.open=[];this.data.market.high=[];this.data.market.low=[];this.data.market.volume=[];this.data.market.desc=["Price","Vol"];var l={};var h=0;for(var g=0;g<e.length;g++){this.data.market.vars.push(e[g].symbol);this.data.market.close[g]=[];this.data.market.open[g]=[];this.data.market.high[g]=[];this.data.market.low[g]=[];this.data.market.volume[g]=[];var k=e[g].data;for(var f=k.length-1;f>=0;f--){var m=this.parseDate(k[f][0]);var c=0;if(!l.hasOwnProperty(m)){c=h;l[m]=h;this.data.market.smps.push(m);h++}else{c=l[m]}this.data.market.open[g][c]=k[f][1];this.data.market.high[g][c]=k[f][2];this.data.market.low[g][c]=k[f][3];this.data.market.close[g][c]=k[f][4];this.data.market.volume[g][c]=k[f][5]}}}this.isMarketDataFormated=true};this.switchToMarketData=function(){var c=this.data.market;this.dataStndBy=this.data;this.configStndBy=this.getConfig();this.data={};this.data.y=c;this.initializeDataAttributes();if(this.showVolume){this.deleteSubGraphAttributes();this.data.l={};this.data.l.vars=[this.data.y.vars,this.data.y.vars];this.data.l.weight=this.graphOrientation=="vertical"?[0.75,0.25]:[0.25,0.75];this.data.l.type=["Candlestick","Candlestick"];this.data.l.name=this.graphOrientation=="vertical"?["Price","Volume"]:["Volume","Price"];this.data.l.desc=this.graphOrientation=="vertical"?["Price","Volume"]:["Volume","Price"];this.segregateSamplesBy=false;this.segregateVariablesBy=false;this.layoutComb=true;this.layout="1X2";this.isValidLayout()}};this.switchFromMarketData=function(){this.switchData();if(this.showVolume){this.resetLayout();this.isValidLayout()}};this.switchData=function(){if(this.dataStndBy&&this.configStndBy){this.data=this.dataStndBy;this.resetConfig();this.updateConfig(this.configStndBy);this.initializeData(this.data)}};this.setFrameData=function(){var d=this.data.dataframe;var e=d.shift();this.data={};this.data.y={};this.data.y.vars=[];this.data.y.smps=[];this.data.y.data=[];for(i=0;i<d.length;i++){this.data.y.data[i]=[];this.data.y.vars.push("var"+(i+1))}for(i=0;i<e.length;i++){var c=[];for(j=0;j<d.length;j++){c.push(d[j][i])}if(this.isNumeric(c)){this.data.y.smps.push(e[i]);for(j=0;j<c.length;j++){this.data.y.data[j].push(c[j])}}else{if(!this.data.z){this.data.z={}}if(!this.data.z[e[i]]){this.data.z[e[i]]=[]}for(j=0;j<c.length;j++){this.data.z[e[i]].push(c[j])}}}};this.updateData=function(c,d){this.initializeData(c);this.initializeGraph(d)};this.initializeData()};CanvasXpress.prototype.FunctionData=function(){this.add=function(b,a){return new Number(a)+new Number(b)};this.sub=function(b,a){return a-b};this.mul=function(b,a){return a*b};this.div=function(b,a){return a/b};this.sin=function(a){return Math.sin(a)};this.cos=function(a){return Math.cos(a)};this.tan=function(a){return Math.tan(a)};this.sec=function(a){return 1/Math.cos(a)};this.csc=function(a){return 1/Math.sin(a)};this.cot=function(a){return 1/Math.tan(a)};this.asin=function(a){return Math.asin(a)};this.acos=function(a){return Math.acos(a)};this.atan=function(a){return Math.atan(a)};this.asec=function(a){return Math.acos(1/a)};this.acsc=function(a){return Math.asin(1/a)};this.acot=function(a){return Math.atan(1/a)};this.sinh=function(a){return(Math.exp(a)-Math.exp(-a))*0.5};this.cosh=function(a){return(Math.exp(a)+Math.exp(-a))*0.5};this.tanh=function(a){return(Math.exp(a)-Math.exp(-a))/(Math.exp(a)+Math.exp(-a))};this.sech=function(a){return 1/cosh(a)};this.csch=function(a){return 1/sinh(a)};this.coth=function(a){return 1/tanh(a)};this.asinh=function(a){return Math.log(a+Math.sqrt(a*a+1))};this.acosh=function(a){return Math.log(a+Math.sqrt(a*a-1))};this.atanh=function(a){return Math.log((1+a)/(1-a))*0.5};this.asech=function(a){return acosh(1/a)};this.acsch=function(a){return asinh(1/a)};this.acoth=function(a){return atanh(1/a)};this.exp=function(a){return Math.exp(a)};this.ln=function(a){return Math.log(a)};this.log=function(a){return Math.log(a)/Math.LN10};this.logb=function(b,a){return Math.log(a)/Math.log(b)};this.pow=function(b,a){return Math.pow(a,b)};this.pow10=function(a){return Math.pow(10,a)};this.sq=function(a){return a*a};this.sqrt=function(a){return Math.sqrt(a)};this.abs=function(a){return a>=0?a:-a};this.sgn=function(a){return a==0?0:(a>0?1:-1)};this.chs=function(a){return -a};this.neg=function(a){return -a};this.floor=function(a){return Math.floor(a)};this.ceil=function(a){return Math.ceil(a)};this.ip=function(a){return parseInt(a)};this.fp=function(a){return abs(a)-ip(abs(a))};this.inv=function(a){return 1/a};this.idiv=function(b,a){return parseInt(a/b)};this.mod=function(b,a){return a%b};this.and=function(b,a){return a&b};this.or=function(b,a){return a|b};this.xor=function(b,a){return a^b};this.not=function(a){return ~a};this.lt=function(b,a){return a<b?1:0};this.le=function(b,a){return a<=b?1:0};this.eq=function(b,a){return a==b?1:0};this.ne=function(b,a){return a!=b?1:0};this.ge=function(b,a){return a>=b?1:0};this.gt=function(b,a){return a>b?1:0};this.Min=function(b,a){return Math.min(a,b)};this.Max=function(b,a){return Math.max(a,b)};this.pc=function(b,a){return a*b/100};this.pcch=function(b,a){return 100*b/a};this.gammaLn=function(b){var a=new Array(76.18009172947146,-86.50532032941678,24.01409824083091,-1.231739572450155,0.001208650973866179,-0.000005395239384953);var f=new Number(b);var e=new Number(b+5.5);var c=new Number(1.000000000190015);e-=(b+0.5)*Math.log(e);for(var d in a){c+=a[d]/++f}return Math.log(2.5066282746310007*c/b)-e};this.gamma=function(a){return Math.exp(this.gammaLn(a))};this.fact=function(b){var a=new Number(b);if(b<=1){return 1}if(b>100||(b%1)){return Math.exp(this.gammaLn(b+1))}while(--b){a*=b}return a};this.comb=function(b,a){return Math.floor(0.5+Math.exp(this.gammaLn(a+1)-this.gammaLn(b+1)-this.gammaLn(a-b+1)))};this.perm=function(b,a){return Math.floor(0.5+Math.exp(this.gammaLn(a+1)-this.gammaLn(a-b+1)))};this.gcd=function(d,c){if(d==0){return(c||1)}return(c?this.gcd(c,d%c):d)};this.lcm=function(d,c){return(d/this.gcd(d,c))*c};this.prime=function(e){var c=new Number(5);var a=new Number(4);var b=parseInt(e/c);if(e==2||e==3||e==5){return 1}if(e<5||(e&1)==0||(e%3)==0){return 0}while(c*b<e&&c<b){b=parseInt(e/(c+=(a=6-a)))}return(c*b==e?0:1)};this.implied=function(a){if(a=="neg"){return false}return/^(\d+\.\d+|\d+\.?|\.\d+)(e[-+]?\d+)?|\w+$/.test(a)};this.tokenize=function(f){var b;var a=[];var d=new String("");var c=/(\d+\.\d+|\d+\.?|\.\d+)(e[-+]?\d+)?|[xy]|[a-z]+|[-+*\/(),^]|<=?|>=?|==|!=|&&|\|\|/g;f=f.toLowerCase();f=f.replace(/\s/g,"");f=f.replace(/\+\+/g,"+");f=f.replace(/\+-/g,"-");f=f.replace(/-\+/g,"-");f=f.replace(/--/g,"+");f=f.replace(/^\+/,"");f=f.replace(/([(*\/&\|<>=])\+/g,"$1");f=f.replace(/^-/,"neg ");f=f.replace(/([(*\/&\|<>=])-/g,"$1neg ");f=f.replace(/\)(\(|\w)/g,")*$1");f=f.replace(/(\d)\(/g,"$1*(");while(b=c.exec(f)){if(this.implied(d)&&this.implied(b[0].toString())){a.push("*")}a.push(d=b[0])}return a};this.isValidEnd=function(a){return/^(\d+\.\d+|\d+\.?|\.\d+)(e[-+]?\d+)?|[)xye]|pi|rand$/.test(a)};this.toPostFx=function(e){var b={sin:16,cos:16,tan:16,sec:16,csc:16,cot:16,asin:16,acos:16,atan:16,asec:16,acsc:16,acot:16,sinh:16,cosh:16,tanh:16,sech:16,csch:16,coth:16,asinh:16,acosh:16,atanh:16,asech:16,acsch:16,acoth:16,exp:16,ln:16,log:16,logb:16,pow:16,sq:16,sqrt:16,abs:16,sgn:16,chs:16,floor:16,ceil:16,ip:16,fp:16,inv:16,min:16,max:16,gamma:16,fact:16,comb:16,perm:16,rand:16,gcd:16,lcm:16,prime:16,and:16,or:16,xor:16,x:16,y:16,pi:16,e:16,neg:15,not:15,"^":14,"*":13,"/":13,mod:13,div:13,"+":12,"-":12,"<":10,"<=":10,"==":10,"!=":10,">=":10,">":10,"&&":5,"||":4,",":1};var c=new String();var d=new String("");var a=new Array();var f=new Array();while(c=e.shift()){if(c=="("){a.push(c)}else{if(b[c]){while(a.length&&a[a.length-1]!="("&&b[a[a.length-1]]>=b[c]){f.push(a.pop())}if(c==","&&!this.isValidEnd(d)){f.push("Unexpected: "+d)}if(c!=","){a.push(c)}}else{if(c==")"){if(!this.isValidEnd(d)){f.push("Unexpected: "+d)}while(a.length&&a[a.length-1]!="("){f.push(a.pop())}if(a.length==0){f.push("Unmatched: )")}a.pop()}else{if(/^[-+]?(\d+\.?|\d*\.\d+)(e[-+]?\d+)?$/.test(c)){f.push(c)}else{f.push("Unknown: "+c)}}}}d=c}if(!this.isValidEnd(d)){f.push("Unexpected: "+d)}while(c=a.pop()){if(c=="("){f.push("Unmatched: (")}f.push(c)}return f};this.syntaxCheck=function(e){var d={sin:1,cos:1,tan:1,sec:1,csc:1,cot:1,asin:1,acos:1,atan:1,asec:1,acsc:1,acot:1,sinh:1,cosh:1,tanh:1,sech:1,csch:1,coth:1,asinh:1,acosh:1,atanh:1,asech:1,acsch:1,acoth:1,exp:1,ln:1,log:1,logb:2,pow:2,sq:1,sqrt:1,abs:1,sgn:1,chs:1,floor:1,ceil:1,ip:1,fp:1,inv:1,min:2,max:2,gamma:1,fact:1,comb:2,perm:2,gcd:2,lcm:2,prime:1,and:2,or:2,xor:2,neg:1,not:1,"^":2,"*":2,"/":2,mod:2,div:2,"+":2,"-":2,"<":2,"<=":2,"==":2,"!=":2,">=":2,">":2,"&&":2,"||":2};var a=new Number(0);var c=new String();for(var b=0;b<e.length;b++,a++){if(/^Un(matched|known|expected).*/.test(c=e[b])){return c}if(d[c]){if(a<d[c]){return"Invalid use of: "+c}a-=d[c]}}return a==1?false:(e.length?"Unused arguments":"No function")};this.evaluate=function(e,b,f){alias={"+":"add","-":"sub","*":"mul","/":"div","!":"fact","x^y":"pow","^":"pow","10^":"pow10",div:"idiv","<":"lt","<=":"le","==":"eq","!=":"ne",">=":"ge",">":"gt","%":"pc","%ch":"pcch"};var a=new Array();var d=new String();for(var c=0;c<e.length;c++){d=e[c];if(d=="x"){a.push(b)}else{if(d=="y"){a.push(f)}else{if(d=="pi"){a.push(Math.PI)}else{if(d=="e"){a.push(Math.E)}else{if(d=="rand"){a.push(Math.random())}else{if(this[alias[d]||d]){a.push(this[alias[d]||d](a.pop(),this[alias[d]||d].length>1?a.pop():0))}else{a.push(d)}}}}}}if(isNaN(a[a.length-1])){return Number.NaN}}return parseFloat(a.pop())};this.set2DPlot=function(j,g){var k={vars:[],smps:["X","Y"],data:[]};var f=this.setMinX?this.setMinX:(0-1);var b=this.setMaxX?this.setMaxX:(1-0);var e=this.setMinY?this.setMinY:(0-1);var a=this.setMaxY?this.setMaxY:(1-0);var p=(b-f)/this.functionIntervals;var o=(a-e)/this.functionIntervals;var c=1;if(g==1){var m=f;for(var h=0;h<this.functionIntervals;h++){var l=this.evaluate(j,m,0);if(isNaN(l)){l=""}m+=p;k.vars.push("v"+c);k.data.push([m,l]);c++}}else{var l=e;for(var h=0;h<this.functionIntervals;h++){var m=this.evaluate(j,0,l);if(isNaN(m)){m=""}l+=o;k.vars.push("v"+c);k.data.push([m,l]);c++}}return k};this.set3DPlot=function(k){var l={vars:[],smps:["X","Y","Z"],data:[]};var f=this.setMinX?this.setMinX:-Math.PI/2;var b=this.setMaxX?this.setMaxX:Math.PI/2;var e=this.setMinY?this.setMinY:-Math.PI/2;var a=this.setMaxY?this.setMaxY:Math.PI/2;var c=1;for(var h=0;h<=this.functionIntervals;h++){var o=e+(a-e)*h/this.functionIntervals;for(var g=0;g<=this.functionIntervals;g++){var p=f+(b-f)*g/this.functionIntervals;var m=this.evaluate(k,p,o);if(!isFinite(m)){m=0}l.vars.push("v"+c);l.data.push([p,m,o]);c++}}return l};this.initializeFunctionData=function(){var e=this.toPostFx(this.tokenize(this.data.fx));var c=this.syntaxCheck(e);if(c){alert(c);return}var a=0;for(var b in e){if(e[b]=="x"){a|=1}else{if(e[b]=="y"){a|=2}}}var d;if(a==0){a=1}if(a==3){this.data.y=this.set3DPlot(e);this.graphType="Scatter3D";this.colorBy="Y"}else{this.data.y=this.set2DPlot(e,a);this.graphType="Scatter2D";this.lineType="spline"}this.scatterType="function"};this.initializeFunctionData()};CanvasXpress.prototype.initRemote=function(){this.ajaxRequest=function(url,params,callback,format,method){var http=false;var pars="";for(var p in params){pars+=p+"="+escape(params[p])+"&"}pars+="uid="+escape(params[p]);format=format=="json"?"json":"text";method=method=="POST"?"POST":"GET";if(window.XMLHttpRequest){try{http=new XMLHttpRequest()}catch(e){http=false}}else{if(typeof ActiveXObject!="undefined"){try{http=new ActiveXObject("Msxml2.XMLHTTP")}catch(e){try{http=new ActiveXObject("Microsoft.XMLHTTP")}catch(e){http=false}}}}if(http&&url){if(method=="GET"){url+="?"+pars;http.open(method,url,true);if(http.overrideMimeType){http.overrideMimeType("text/xml")}pars=null}else{http.open(method,url,true);http.setRequestHeader("Content-type","application/x-www-form-urlencoded")}http.onreadystatechange=function(){if(http.readyState==4){if(http.status==200){var result="";if(http.responseText){result=http.responseText}if(format=="json"){result=result.replace(/[\n\r]/g,"");result=eval("("+result+")")}if(callback){callback(result)}}else{alert(http.status)}}};http.send(pars)}};this.requestRemoteData=function(ini){this.hideViewport();var params=this.cloneObject(this.remoteParams);params.index=this.remoteDataIndex;params.dir=this.remoteDirection;if(ini){params.records=true}this.ajaxRequest(this.remoteService,params,this.updateRemoteData,"json","GET")};this.requestRemoteIds=function(d){if(this.remoteUpdate){var params=this.cloneObject(this.remoteParams);params.update=true;var that=this;var updater=function(){this.update=function(){clearInterval(cl);that.ajaxRequest(that.remoteService,params,that.updateRemoteIds,"json","GET")};var cl=setInterval(this.update,d/5||1)};updater.call()}};this.updateRemoteIds=function(t){return function(res){var that=t;var s=document.getElementById(t.remoteParentId+"-canvasXpressRemoteWindowTopBarSelect");if(s){if(res.ids){that.remoteIds=res.ids}var c=s.selectedIndex;var x=s.childNodes[c].text;var updater=function(){this.update=function(){if(s.childNodes.length>=that.remoteIds.length){that.remoteUpdate=false;clearInterval(cl)}else{that.resetSelectOptionsRemoteData(s,x);that.requestRemoteIds()}};var cl=setInterval(this.update,that.remoteUpdateDelay)};updater.call()}}}(this);this.saveRemote=function(type,name,object){var that=this;var params=this.cloneObject(this.remoteParams);params.index=this.remoteDataIndex;params.save=type;if(name){params.name=JSON.stringify(name)}var config=object?object:this.getConfig();if(this.graphType=="Network"){config.calculateLayout=false}params.params=JSON.stringify(config);params.cxdata=JSON.stringify(this.cloneObject(this.data));this.ajaxRequest(this.remoteService,params,function(){alert("CanvasXpress data "+type+"d in the server")},"json","POST")};this.castRemoteParameters=function(o){o.remoteParentId=this.remoteParentId;o.remoteService=this.remoteService;o.remoteDirection=this.remoteDirection;o.remoteDataIndex=this.remoteDataIndex;o.remoteWindow=this.remoteWindow;o.remoteAutoPlay=this.remoteAutoPlay;o.remoteAutoPlayDelay=this.remoteAutoPlayDelay;for(var p in this.remoteParams){o.remoteParams[p]=this.remoteParams[p]}o.addRemoveNavigationTopListeners("addEvtListener");o.addRemoveNavigationLeftRightListeners("addEvtListener")};this.maintainIndices=function(n){if(!this.graphType.match(/Network|Genome|Venn/)&&!n.config.graphType.match(/Network|Genome|Venn/)){if(this.data.y.vars.length==n.data.y.vars.length){n.data.initialVarIndices=this.varIndices}if(this.data.y.smps.length==n.data.y.smps.length){n.data.initialSmpIndices=this.smpIndices}}};this.maintainState=function(n,d){if(!this.graphType.match(/Network|Genome|Venn/)&&!n.graphType.match(/Network|Genome|Venn/)){if(n.groupingFactors.length>0){n.groupSamples(n.groupingFactors)}else{if(this.isGroupedData&&n.data.x){for(var i=0;i<this.groupingFactors.length;i++){if(!n.data.x[this.groupingFactors[i]]){return}}if(this.isCompatibleGraphType(this.graphType,n.graphType)){n.graphType=this.graphType}var gidxs=this.data.y.smps.length==n.data.y.smps.length?this.grpIndices:false;n.groupSamples(this.groupingFactors,false,gidxs)}}var tr=n.transformType?n.transformType:this.transformType?this.transformType:false;if(tr){n.transform(tr)}var rd=false;if(d){if(d.varIndices&&d.varIndices.length==n.varIndices.length){n.varIndices=d.varIndices;rd=true}if(d.smpIndices&&d.smpIndices.length==n.smpIndices.length){n.smpIndices=d.smpIndices;rd=true}if(d.grpIndices&&d.grpIndices.length==n.grpIndices.length){n.grpIndices=d.grpIndices;rd=true}if(rd){n.draw()}}}else{if(this.graphType=="Network"&&!n.calculateLayout){this.calculateLayout=n.calculateLayout}}};this.updateRemoteData=function(t){return function(res){if(res&&res.data){var d=t.appendUserConfig(res.data);var a=t.remoteDirection=="next"?true:false;var w=document.getElementById("container-"+t.target);if(w){var p=w.parentNode;var r=w.getClientRects();var o=document.getElementById(t.target);var l=t.target;t.insertTarget(d.renderTo,w,o.width,o.height,a);d.hidden=true;t.maintainIndices(d);var n=new CanvasXpress(d);n.target0=t.target0?t.target0:t.target;t.castRemoteParameters(n);t.maintainState(n,d.config);t.addSelectOptionsRemoteData(res.ids);t.resetInfoSpan(false,true);t.animateTransition(p,r[0],l);t.requestRemoteIds(t.remoteUpdateDelay);if(t.Ext){if(!n.Ext){n.Ext={canvasId:d.renderTo,canvas:n,extId:t.Ext.id||t.Ext.extId}}}if(res.postprocess){for(var i=0;i<res.postprocess.length;i++){var fn=res.postprocess[i].func;var pr=res.postprocess[i].param;if(fn){if(fn=="groupSamples"&&n.isGroupedData){continue}if(pr){n[fn].apply(n,pr)}else{n[fn]()}}}}if(n.userEvents.remoteupdate){n.userEvents.remoteupdate.call(this,n)}if(res.info){n.updateInfoDiv(res.info);n.showInfoDiv()}if(t.showCode){n.updateCodeDiv()}}}else{t.remoteDataIndex=t.remoteDirection=="next"?t.remoteDataIndex-1:t.remoteDataIndex+1;t.remoteUpdating=false}}}(this);this.appendUserConfig=function(d){for(var i in this.userConfig){if(!i.match(/decrease|remote|^calculateLayout$/)){if(!d.config[i]){d.config[i]=this.userConfig[i]}}}return d};this.updateCurrentRemoteData=function(s,c){if(!s){s=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBarSelect")}if(!c){c=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBarCurrent")}if(s&&c){s.selectedIndex=this.remoteDataIndex;if(this.remoteIds.length==0){for(var i=0;i<s.childNodes.length;i++){this.remoteIds.push(s.childNodes[i].text)}}if(s.childNodes[s.selectedIndex]){var v=s.childNodes[s.selectedIndex].text;c.value=v.length>40?v.substring(0,37)+"...":v}else{this.resetSelectOptionsRemoteData(s)}}};this.resetSelectOptionsRemoteData=function(s,t){if(!s){s=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBarSelect")}if(s){if(this.remoteIds.length==0){for(var i=0;i<s.childNodes.length;i++){this.remoteIds.push(s.childNodes[i].text)}}this.clearSelectOptionsRemoteData(s);this.addSelectOptionsRemoteData(this.remoteIds,s,t)}};this.clearSelectOptionsRemoteData=function(s){if(!s){s=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBarSelect")}if(s&&s.hasChildNodes()){while(s.childNodes.length>=1){s.removeChild(s.firstChild)}}};this.addSelectOptionsRemoteData=function(ids,s,t){if(ids){this.remoteIds=ids;if(!s){s=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBarSelect")}if(s){for(var i=0;i<this.remoteIds.length;i++){var opt=document.createElement("option");opt.text=this.remoteIds[i];opt.value=i;if(t){if(this.remoteIds[i]==t){opt.selected="selected";this.remoteDataIndex=i;s.selectedIndex=this.remoteDataIndex}}else{if(this.remoteDataIndex==i){opt.selected="selected";s.selectedIndex=this.remoteDataIndex}}try{s.add(opt,null)}catch(ex){s.add(opt)}}if(this.remoteIds.length==1){this.hideNavigation()}else{this.showNavigation()}}}};this.animateTransition=function(b,r,o){if(b&&r){var that=this;var step=15;var s=0;var c1=b.firstChild;var c2=b.lastChild;var w=r.width;var h=r.height;b.parentNode.style.overflow="hidden";if(this.isIE){if(this.remoteDirection=="next"){b.removeChild(c1)}else{b.removeChild(c2)}b.parentNode.style.overflow="visible";this.remoteUpdating=false}else{var updater=function(){this.update=function(){var n=Math.atan((s/step)*10-5)*0.5/Math.atan(5)+0.5;var l=w*n;if(s>=step){clearInterval(clearUpdateInt);that.destroy(o);if(that.remoteDirection=="next"){c2.style.left=0+"px"}else{c1.style.left=0+"px"}b.parentNode.style.overflow="visible";that.remoteUpdating=false;that.updateCurrentRemoteData()}else{if(that.remoteDirection=="next"){c1.style.left=(l*-1)+"px";c2.style.left=(l*-1)+"px"}else{c1.style.left=(-w+l)+"px";c2.style.left=(-w+l)+"px"}c1.style.display="block";c2.style.display="block"}s++};var clearUpdateInt=setInterval(this.update,100)};updater.call()}}};this.handleRemoteSelect=function(t){return function(e){var s=t.getTargetEvent(e);var i=s.children[s.selectedIndex].value;var c=document.getElementById(t.remoteParentId+"-canvasXpressRemoteWindowTopBarCurrent");t.remoteDirection=i>t.remoteDataIndex?"next":"previous";t.remoteDataIndex=i;var v=s.children[s.selectedIndex].text;if(c&&s){s.style.display="none";t.resetSelectOptionsRemoteData(s);c.value=v.length>40?v.substring(0,37)+"...":v}t.requestRemoteData()}}(this);this.handleRemoteClickStop=function(t){return function(e){t.remoteStop=true}}(this);this.handleRemoteClickPlay=function(t){return function(e){var r=t.getTargetEvent(e);t.remoteDirection="next";t.remoteStop=false;t.playRemoteData(r.parentNode.lastChild)}}(this);this.playRemoteData=function(s){var getRef=function(trg){for(var i=0;i<CanvasXpress.references.length;i++){if(trg==CanvasXpress.references[i].target0){return CanvasXpress.references[i];break}}for(var i=0;i<CanvasXpress.references.length;i++){if(trg==CanvasXpress.references[i].target){return CanvasXpress.references[i];break}}return CanvasXpress.references[0]};var id=this.target0||this.target;var updater=function(){var that=getRef(id);if(that){if(!that.remoteUpdating&&!that.remoteStop){that.remoteUpdating=true;that.showInfoSpan(false,"Updating ...",true);if(s&&s.tagName.match(/select/i)&&that.remoteDataIndex>=s.length-1){that.remoteDataIndex=0}else{that.remoteDataIndex++}that.requestRemoteData()}}this.update=function(){var that=getRef(id);if(that){if(!that.remoteUpdating&&!that.remoteStop){that.remoteUpdating=true;that.showInfoSpan(false,"Updating ...",true);if(s&&s.tagName.match(/select/i)&&that.remoteDataIndex>=s.length-1){that.remoteDataIndex=0}else{that.remoteDataIndex++}that.requestRemoteData()}if(that.remoteStop){clearInterval(cl)}}else{clearInterval(cl)}};var cl=setInterval(this.update,that.remoteAutoPlayDelay)};updater.call()};this.handleRemoteClickPrev=function(t){return function(e){if(!t.remoteUpdating){var r=t.getTargetEvent(e);var s=r.parentNode.lastChild;t.remoteUpdating=true;t.showInfoSpan(false,"Updating ...",true);t.remoteDirection="previous";if(s&&s.tagName.match(/select/i)&&t.remoteDataIndex<=0){t.remoteDataIndex=s.length-1}else{t.remoteDataIndex--}t.requestRemoteData()}}}(this);this.handleRemoteClickNext=function(t){return function(e){if(!t.remoteUpdating){var r=t.getTargetEvent(e);var s=r.parentNode.lastChild;t.remoteUpdating=true;t.showInfoSpan(false,"Updating ...",true);t.remoteDirection="next";if(s&&s.tagName.match(/select/i)&&t.remoteDataIndex>=s.length-1){t.remoteDataIndex=0}else{t.remoteDataIndex++}t.requestRemoteData()}}}(this);this.handleRemoteClickDown=function(t){return function(e){if(!t.remoteUpdating){var s=document.getElementById(t.remoteParentId+"-canvasXpressRemoteWindowTopBarSelect");if(s){if(s.style.display=="none"){s.style.display="block";s.options[s.selectedIndex].selected=true}else{s.style.display="none"}}}}}(this);this.addRemoteNavigationTop=function(w){var m="5px";var n=document.createElement("div");n.id=this.remoteParentId+"-canvasXpressRemoteWindowTopBar";n.style.padding="2px";n.style.color=this.skinColor;n.style.border="1px solid "+this.skinBorderColor;n.style.backgroundColor=this.skinBackgroundColor;n.style.boxShadow="2px 2px 2px "+this.skinShadowColor;n.style.MozBoxShadow="2px 2px 2px "+this.skinShadowColor;n.style.borderRadius="4px";n.style.width=(this.canvas.width-5)+"px";n.style.position="absolute";n.style.marginLeft=w+"px";n.style.display="none";var r=document.createElement("img");r.id=this.remoteParentId+"-canvasXpressRemoteWindowTopBarPrev";r.src=this.imageDir+this.previousButton;r.alt="Previous graph";r.title="Previous graph";r.style.margin=m;n.appendChild(r);var p=document.createElement("img");p.id=this.remoteParentId+"-canvasXpressRemoteWindowTopBarPlay";p.src=this.imageDir+this.playButton;p.alt="Iterate over graphs";p.title="Iterate over graphs";p.style.margin=m;n.appendChild(p);var e=document.createElement("img");e.id=this.remoteParentId+"-canvasXpressRemoteWindowTopBarStop";e.src=this.imageDir+this.stopButton;e.alt="Stop iteration";e.title="Stop iteration";e.style.margin=m;n.appendChild(e);var f=document.createElement("img");f.id=this.remoteParentId+"-canvasXpressRemoteWindowTopBarNext";f.src=this.imageDir+this.nextButton;f.alt="Next graph";f.title="Next graph";f.style.margin=m;n.appendChild(f);var c=document.createElement("input");c.id=this.remoteParentId+"-canvasXpressRemoteWindowTopBarCurrent";c.type="text";c.style.padding="1px 1px 2px 1px";c.style.position="absolute";c.style.cursor="default";c.style.display="block";c.style.left="102px";c.style.top="0px";c.style.margin="5px";c.style.width=(this.canvas.width-118)+"px";c.style.borderRadius="4px";c.style.MozBorderRadius="4px";n.appendChild(c);var d=document.createElement("img");d.id=this.remoteParentId+"-canvasXpressRemoteWindowTopBarDown";d.src=this.imageDir+this.dropdownButton;d.alt="Select graph";d.title="Select graph";d.style.margin=m;d.style.position="absolute";d.style.top="3px";d.style.right="4px";n.appendChild(d);var s=document.createElement("select");s.id=this.remoteParentId+"-canvasXpressRemoteWindowTopBarSelect";s.style.position="absolute";s.style.margin="5px";s.style.color=this.skinColor;s.style.backgroundColor=this.skinBackgroundColor;s.style.border="1px solid "+this.skinBorderColor;s.style.marginTop="1px";s.style.left="102px";s.style.top="26px";s.style.maxWidth="800px";s.style.display="none";s.size=10;s.style.zIndex=9500;n.appendChild(s);return n};this.addRemoveNavigationTopListeners=function(t){var r=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBarPrev");var p=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBarPlay");var e=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBarStop");var f=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBarNext");var d=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBarDown");var s=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBarSelect");if(r){this[t](r,"click",this.handleRemoteClickPrev,false)}if(p){this[t](p,"click",this.handleRemoteClickPlay,false)}if(e){this[t](e,"click",this.handleRemoteClickStop,false)}if(f){this[t](f,"click",this.handleRemoteClickNext,false)}if(d){this[t](d,"click",this.handleRemoteClickDown,false)}if(s){this[t](s,"change",this.handleRemoteSelect,false)}};this.selectDataSet=function(e){var t=document.activeElement;if(t.id==this.remoteParentId+"-canvasXpressRemoteWindowTopBarCurrent"){var s=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBarSelect");var p=[];if(s&&t.value.length>0){if(this.remoteIds.length==0){for(var i=0;i<s.childNodes.length;i++){this.remoteIds.push(s.childNodes[i].text)}}this.clearSelectOptionsRemoteData(s);for(var i=0;i<this.remoteIds.length;i++){if(this.remoteIds[i].toLowerCase().indexOf(t.value.toLowerCase())>=0){p.push(i)}}for(var i=0;i<p.length;i++){var o=document.createElement("option");o.text=this.remoteIds[p[i]];o.value=p[i];try{s.add(o,null)}catch(ex){s.add(o)}}s.style.display="block"}}};this.addRemoteNavigationBottom=function(w){var n=document.createElement("div");n.id=this.remoteParentId+"-canvasXpressRemoteWindowBottomBar";n.style.position="absolute";n.style.marginLeft=w+"px";n.style.display="none";n.style.height="18px";return n};this.addRemoteNavigationLeftRight=function(d,w,h,m,q){var n=document.createElement("div");var i=document.createElement("img");n.style.height=(h+q)+"px";n.style.width=m+"px";n.style.marginLeft="3px";n.style.marginRight="3px";n.style.top="0px";i.style.position="absolute";i.style.top=(h/2)+"px";i.style.left="1px";if(d=="l"){n.style.position="relative";n.id=this.remoteParentId+"-canvasXpressRemoteWindowPrevBar";n.style.left="0px";n.style.display="none";i.src=this.imageDir+this.previousButton}else{n.style.position="absolute";n.id=this.remoteParentId+"-canvasXpressRemoteWindowNextBar";n.style.left=(m+w+14)+"px";n.style.display="none";i.src=this.imageDir+this.nextButton}i.style.margin="auto";n.appendChild(i);return n};this.addRemoveNavigationLeftRightListeners=function(t){var p=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowPrevBar");var n=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowNextBar");if(p){this[t](p,"click",this.handleRemoteClickPrev,false)}if(n){this[t](n,"click",this.handleRemoteClickNext,false)}};this.updateRemoteNavigationWindow=function(){var c=document.getElementById(this.target);var x=24;var y=36;var l=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowPrevBar");var r=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowNextBar");var w=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindow");var b=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowBuffer");if(c&&l&&r&&w&&b){var il=l.childNodes[0];l.style.left="7px";l.style.height=(c.height+y+7)+"px";il.style.top=(c.height/2)+"px";var ir=r.childNodes[0];r.style.left=(c.width+x+7)+"px";r.style.height=(c.height+y+7)+"px";ir.style.top=(c.height/2)+"px";w.style.height=((y*2)+c.height)+"px";w.style.width=((x*2)+c.width)+"px";b.style.width=(parseInt(c.parentNode.parentNode.clientWidth)*2)+"px";b.style.left=(x+7)+"px";b.style.top=(y+7)+"px";this.resizeExtContainer()}};this.addRemoteWindow=function(){var w=document.getElementById("container-"+this.target);var c=document.getElementById(this.target);var p=w.parentNode;var x=24;var y=36;if(p.id&&!p.id.match(/canvasXpressRemoteWindow/)){this.remoteParentId=p.id;var d=document.createElement("div");var t=this.addRemoteNavigationTop(x+7);var l=this.addRemoteNavigationLeftRight("l",c.width,c.height,x,y+14);var v=document.createElement("div");var r=this.addRemoteNavigationLeftRight("r",c.width,c.height,x,y+14);var b=this.addRemoteNavigationBottom(x+7);d.id=this.remoteParentId+"-canvasXpressRemoteWindow";d.style.marginTop="3px";d.style.height=(y+18+c.height+14)+"px";d.style.width=((x*2)+c.width+14)+"px";d.style.position="relative";v.id=this.remoteParentId+"-canvasXpressRemoteWindowBuffer";v.style.width=((parseInt(c.parentNode.parentNode.clientWidth)+7)*2)+"px";v.style.position="absolute";v.style.left=x+"px";v.style.top=y+"px";v.style.overflow="hidden";d.appendChild(t);d.appendChild(l);d.appendChild(v);d.appendChild(r);d.appendChild(b);p.insertBefore(d,w);v.appendChild(w.parentNode.appendChild(w));this.addRemoveNavigationTopListeners("addEvtListener");this.addRemoveNavigationLeftRightListeners("addEvtListener");this.requestRemoteData(true);this.initialRemoteDataRequest=true;if(this.remoteAutoPlay){this.remoteUpdating=true;this.remoteDirection="next";this.remoteStop=false;this.playRemoteData(t.lastChild)}}else{this.initialRemoteDataRequest=false}};this.resizeExtContainer=function(over){if(this.Ext&&this.Ext.extId&&Ext){var cnt=Ext.getCmp(this.Ext.extId);if(cnt){var par=cnt.ownerCt;if(par){var grp=par.ownerCt;if(grp){grp.doLayout()}else{par.doLayout()}}else{con.doLayout()}}}};this.hideNavigation=function(){var t=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBar");var p=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowPrevBar");var n=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowNextBar");var b=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowBottomBar");if(t){t.style.display="none"}if(p){p.style.display="none"}if(n){n.style.display="none"}if(b){b.style.display="none"}};this.showNavigation=function(){var t=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowTopBar");var p=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowPrevBar");var n=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowNextBar");var b=document.getElementById(this.remoteParentId+"-canvasXpressRemoteWindowBottomBar");if(t){t.style.display="block"}if(p){p.style.display="block"}if(n){n.style.display="block"}if(b){b.style.display="block"}};this.initializeRemote=function(){if(this.remoteService){this.addRemoteWindow()}};this.addRemoteDataSaveForm=function(c){var sd=this.$(this.target+"-cX-SaveForm");if(sd){this.cancelRemoteSave(true)}var d=this.$cX("div",{id:this.target+"-cX-SaveForm",className:"CanvasXpressForm draggable"},{left:c.x+"px",top:c.y+"px",zIndex:10001});var n=this.$cX("input",{id:this.target+"-cX-SaveFormInput",className:"CanvasXpressFormText",type:"text"},{display:"block",margin:"8px",width:"300px"});var s=this.$cX("input",{id:this.target+"-cX-SaveFormSaveButton",className:"CanvasXpressFormButton",value:"Save",type:"button"},{width:"100px",marginLeft:"40px"});var x=this.$cX("input",{id:this.target+"-cX-SaveFormCancelButton",className:"CanvasXpressFormButton",value:"Cancel",type:"button"},{width:"100px",marginLeft:"40px"});d.appendChild(document.createTextNode("Save current view as:"));d.appendChild(this.$cX("br"));d.appendChild(n);d.appendChild(s);d.appendChild(x);document.body.appendChild(d);this.addRemoveRemoteSaveListeners("addEvtListener")};this.addRemoveRemoteSaveListeners=function(t){var c=this.$(this.target+"-cX-SaveForm");var s=this.$(this.target+"-cX-SaveFormSaveButton");var x=this.$(this.target+"-cX-SaveFormCancelButton");if(s&&x){this[t](c,"mousedown",this.registerMousemove,false);this[t](s,"click",this.submitRemoteSave,false);this[t](x,"click",this.cancelRemoteSave,false)}};this.submitRemoteSave=function(t){return function(e){if(!e){e=window.event}var d=t.$(t.target+"-cX-SaveForm");var n=t.$(t.target+"-cX-SaveFormInput");var f=t.$(t.target+"-cX-SaveFormForm");var x=["Smp","Var","Node","Edge","Feature"];if(d&&n){t.saveRemote("save",n.value);t.addRemoveRemoteSaveListeners("removeEvtListener");document.body.removeChild(d)}else{if(d&&f){var c=f.getElementsByTagName("input");var o={};if(c){for(var i=0;i<c.length;i++){if(c[i].checked){o[c[i].value]=t[c[i].value]}}for(var i=0;i<x.length;i++){if(o.hasOwnProperty("filter"+x[i]+"By")){o["filter"+x[i]+"ByOp"]=t["filter"+x[i]+"ByOp"];o["filter"+x[i]+"ByValue"]=t["filter"+x[i]+"ByValue"];o["filter"+x[i]+"ByCase"]=t["filter"+x[i]+"ByCase"]}}o.varIndices=t.varIndices;o.smpIndices=t.smpIndices;o.grpIndices=t.grpIndices;t.saveRemote("params",false,o)}t.addRemoveRemoteSaveListeners("removeEvtListener");document.body.removeChild(d)}}}}(this);this.cancelRemoteSave=function(t){return function(e){if(!e){e=window.event}var d=t.$(t.target+"-cX-SaveForm");if(d){t.addRemoveRemoteSaveListeners("removeEvtListener");document.body.removeChild(d)}}}(this);this.addRemoteParamsSaveForm=function(c){var sd=this.$(this.target+"-cX-SaveForm");if(sd){this.cancelRemoteSave(true)}var params=this.getConfig();var d=this.$cX("div",{id:this.target+"-cX-SaveForm",className:"CanvasXpressForm draggable"},{left:c.x+"px",top:c.y+"px",zIndex:10001});var s=this.$cX("input",{id:this.target+"-cX-SaveFormSaveButton",className:"CanvasXpressFormButton",value:"Save",type:"button"},{width:"100px",marginLeft:"40px"});var x=this.$cX("input",{id:this.target+"-cX-SaveFormCancelButton",className:"CanvasXpressFormButton",value:"Cancel",type:"button"},{width:"100px",marginLeft:"40px"});d.appendChild(document.createTextNode("Save selected parameters:"));d.appendChild(this.$cX("br"));var pd=this.$cX("form",{id:this.target+"-cX-SaveFormForm",className:"CanvasXpressFormForm"},{height:"200px",width:"300px"});for(var p in params){var c=this.$cX("input",{name:"parameters",value:p,type:"checkbox",checked:true},{margin:"5px"});pd.appendChild(c);var sc=this.$cX("span",{innerHTML:p},{margin:"5px"});pd.appendChild(sc);pd.appendChild(this.$cX("br"))}d.appendChild(pd);d.appendChild(s);d.appendChild(x);document.body.appendChild(d);this.addRemoveRemoteSaveListeners("addEvtListener")};this.initializeRemote()};CanvasXpress.prototype.initGraph=function(){this.draw=function(b,e,a,d,c){this.setUserEvents();this.initializeGraph(true,b,e,a,d,c);if(this.userEvents.enddraw){this.userEvents.enddraw.call(this)}};this.isValidGraphType=function(a){switch(a){case"Bar":case"Line":case"Area":case"AreaLine":case"Dotplot":case"Heatmap":case"Stacked":case"StackedPercent":case"Boxplot":case"Correlation":case"Treemap":case"TagCloud":case"Pie":case"Circular":if(this.data.y){return true}else{return false}case"BarLine":case"DotLine":case"StackedLine":case"StackedPercentLine":if(this.data.y&&this.data.a&&this.data.a.xAxis&&this.data.a.xAxis2){return true}else{return false}case"Scatter2D":if(this.data.y&&this.data.y.smps&&this.data.y.smps.length>1){return true}else{return false}case"ScatterBubble2D":case"Scatter3D":if(this.data.y&&this.data.y.smps&&this.data.y.smps.length>2){return true}else{return false}case"Candlestick":if(this.data.market){return true}else{return false}case"Venn":if(this.data.venn){return true}else{return false}case"Network":if(this.data.nodes){return true}else{return false}case"Genome":if(this.data.tracks){return true}else{return false}case"Video":if(this.data.video){return true}else{return false}}return false};this.setColorScheme=function(){switch(this.colorScheme){case"reset":this.colors=this.colors0;break;case"basic":this.colors=this.colors1;break;case"dark":this.colors=this.colors2;break;case"strong":this.colors=this.colors3;break;case"light":this.colors=this.colors4;break;case"pastel":this.colors=this.colors5;break;case"balanced":this.colors=this.colors6;break;case"user":this.colors=this.colors;break}};this.reinitializeGraph=function(){if(this.graphType=="Candlestick"){this.isGraphTime=true;if(!this.isMarketSwitched){this.switchToMarketData();this.initAxes();this.summaryType="candle";this.initializeDataAttributes();this.isMarketSwitched=true}this.setMarketTechnicalData()}else{if(this.isExample&&this.isMarketSwitched){this.switchFromMarketData();this.isMarketSwitched=false;this.summaryType=this.data.y.data?"raw":"mean";this.initializeDataAttributes();this.isGraphTime=false;if(this.showVolume){this.layoutComb=false}}else{if(this.graphType.match(/Scatter/)&&this.scatterPlotMatrix){this.setScatterPlotMatrix()}else{if(this.graphType.match(/Pie/)&&this.xAxis.length>1){this.setMultiplePies()}}}}};this.initializeGraph=function(o,a,n,k,c,d){var f=this;var b=0;var h=[];var l=[];var g=function(i){var p=f.getFileName(i);return CanvasXpress.cacheImages.hasOwnProperty(p)&&typeof(CanvasXpress.cacheImages[p])=="object"};var m=function(){for(var p=0;p<h.length;p++){if(!g(h[p])){return false}}return true};if(this.patternImages){if(this.patternImages.length!=this.patternNames.length){alert("Length of arrays patternImages and patternNames are different. Funny things may happen")}for(var e=0;e<this.patternImages.length;e++){h.push(this.imageDir+this.patternImages[e])}}if(this.graphType=="Network"){h=this.getNetworkImages()}if(this.graphType.match(/scatter/i)){for(var e=0;e<this.images.length;e++){if(!this.images[e].match(/^(http|file):\/\//)){this.images[e]=this.imageDir+this.images[e]}h.push(this.images[e])}}if(this.backgroundImage){if(!this.backgroundImage.match(/^(http|file):\/\//)){this.backgroundImage=this.imageDir+this.backgroundImage}h.push(this.backgroundImage)}if(h.length>0){if(this.graphType=="Network"){this.Network(true)}else{if(this.graphType=="Scatter3D"){this.Scatter3D(true)}else{if(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D"){this.Scatter2D(true)}}}}if(h.length>0&&!m()&&!d){for(var e=0;e<h.length;e++){if(!g(h[e])){l.push(h[e])}}for(var e=0;e<h.length;e++){if(!g(h[e])){var j=new Image;j.onload=function(){CanvasXpress.cacheImages[f.getFileName(this.src)]=this;b++;CanvasXpress.cacheImagesReady=b==l.length;if(CanvasXpress.cacheImagesReady){f.renderGraph(o,a,n,k,c)}};j.src=h[e]}}}else{this.renderGraph(o,a,n,k,c)}};this.renderGraph=function(g,d,a,c,f){if(this.initialRemoteDataRequest){return}this.setColorScheme();this.reinitializeGraph();if((!this.layoutComb||!this.layoutAdjust)&&!c){if(this.graphType!="Candlestick"||(this.graphType=="Candlestick"&&!this.showVolume)){this.initAxes(g)}}if(g){this.resizeCanvas(true,d,a)}else{this.resizeCanvas(false,d,a)}if(this.isVML){this.showShadow=false}if(this.isValidAnimation()&&this.showAnimation&&!this.isAnimation){this.createAnimation(this.animationType)}else{var e=this.layoutComb?true:false;switch(this.graphType){case"Bar":case"Dotplot":if(this.isBoxPlotCalc&&this.isGroupedData){this.groupSamples(this.getGroupingFactors(true))}if(this.is3DPlot){this.Scatter3D()}else{this.oneDPlot()}break;case"Line":case"Area":case"AreaLine":case"BarLine":case"DotLine":case"Heatmap":case"Treemap":case"TagCloud":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Candlestick":if(this.isBoxPlotCalc&&this.isGroupedData){this.groupSamples(this.getGroupingFactors(true))}this.oneDPlot();break;case"Boxplot":if(!this.isBoxPlotCalc&&this.isGroupedData){this.groupSamples(this.getGroupingFactors(true))}this.oneDPlot();break;case"Scatter2D":case"ScatterBubble2D":this.Scatter2D();break;case"Scatter3D":this.Scatter3D();break;case"Correlation":this.Correlation();break;case"Venn":this.Venn();break;case"Pie":this.Pie();break;case"Circular":this.Circular();break;case"Network":if(f){var b=this.calculateLayout;var e=this.randomNetwork;this.calculateLayout=false;this.randomNetwork=false;this.Network();this.calculateLayout=b;this.randomNetwork=e}else{this.Network()}break;case"Genome":this.Genome();break;case"Video":this.Video();break}this.drawCanvasBox();if(this.showCode){this.updateCodeDiv()}if(this.showDataTable){this.updateDataTable()}else{if(this.dataTableLastState&&this.dataTableLastState!="docked"){this.hideUnhideDataTable(true)}}this.setAcknowledgmentVisibility();if(this.graphType!="Network"){this.drawCitation()}this.setVideoControls();this.hideMask()}};this.initializeGraph()};CanvasXpress.prototype.initAxes=function(b,a){this.getValidAxes=function(c){var d=[];if(this.graphType=="Scatter2D"){d.push("xAxis");d.push("yAxis")}else{if(this.graphType=="ScatterBubble2D"||this.graphType=="Scatter3D"){d.push("xAxis");d.push("yAxis");d.push("zAxis")}else{if(this.graphType.match(/Network|Genome|Correlation|Venn|Heatmap|Pie|Video/)){if(c){d.push("xAxis")}else{return false}}else{if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)||(this.graphType=="Candlestick"&&this.showVolume)){d.push("xAxis");d.push("xAxis2")}else{if(this.graphType=="Circular"){d.push("xAxis");d.push("rAxis")}else{d.push("xAxis")}}}}}return d};this.addRemoveSamplesInAxis=function(e,d,c){if(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D"){if(c){return this.removeSamplesFromAxis(e,d)}else{return this.addSamplesToAxis(e,d)}}else{if(this.graphType=="Scatter3D"||this.graphType=="Pie"){return this.switchSampleInAxis(e,d)}}};this.addSamplesToAxis=function(e,d){if(this[d]){if(this.isArray(e)){for(var c=0;c<e.length;c++){this[d].push(e[c])}}else{this[d].push(e)}return false}else{return"Not a valid axis"}};this.removeSamplesFromAxis=function(g,f){if(this[f]){if(this[f].length>1){var d={};var c=[];if(this.isArray(g)){for(var e=0;e<g.length;e++){d[g[e]]=1}}else{d[g]=1}for(var e=0;e<this[f].length;e++){if(!d.hasOwnProperty(this[f][e])){c.push(this[f][e])}}this[f]=c;return false}else{return f+" cannot be null"}}else{return"Not a valid axis"}};this.switchSampleInAxis=function(d,c){if(this[c]){this[c][0]=d;return false}else{return"Not a valid axis"}};this.addRemoveVariablesInAxis=function(e,d,c){if(c){return this.removeVariablesFromAxis(e,d)}else{return this.addVariablesToAxis(e,d)}};this.addVariablesToAxis=function(e,d){if(!this.data.a){this.data.a={}}if(!this.data.a[d]){this.data.a[d]=[]}if(this.isArray(e)){for(var c=0;c<e.length;c++){this.data.a[d].push(e[c])}}else{this.data.a[d].push(e)}this.resetVariablesVisibleByAxis(d);return false};this.removeVariablesFromAxis=function(g,f){if(this.data.a&&this.data.a[f]){var d={};var c=[];if(this.isArray(g)){for(var e=0;e<g.length;e++){d[g[e]]=1}}else{d[g]=1}for(var e=0;e<this.data.a[f].length;e++){if(!d.hasOwnProperty(this.data.a[f][e])){c.push(this.data.a[f][e])}}this.data.a[f]=c}this.resetVariablesVisibleByAxis(f);return false};this.formatAxisValue=function(d,c){if(this[c+"TickFormat"]){if(this.graphType=="Candlestick"&&this.summaryType=="volume"){if(this.xAxis2TickFormat){return sprintf(this.xAxis2TickFormat,d)}else{return sprintf(this[c+"TickFormat"],d)}}else{return sprintf(this[c+"TickFormat"],d)}}else{if(this.graphType=="Candlestick"&&this.summaryType=="volume"){return sprintf("%."+this.xAxis2Decs+"f",d)}else{if(d%1===0){if(d.toString().match("e")){return d.toString()}else{return parseInt(d).toString()}}else{d=sprintf("%."+this[c+"Decs"]+"f",d);var e=d.length;while(d.substring(e-1,e)=="0"){d=d.substring(0,e-1);e=d.length}return d}}}};this.getAxisRangeBySample=function(c){var g=[];if(this.isArray(c)){for(var e=0;e<this.varIndices.length;e++){var f=this.varIndices[e];for(var d=0;d<c.length;d++){g.push(this.getDataAtPos(f,d))}}}else{for(var e=0;e<this.varIndices.length;e++){var f=this.varIndices[e];g.push(this.getDataAtPos(f,c))}}return this.range(g)};this.getAxisIncrements=function(f,n,o,j,p){if(j){return parseFloat(this.formatNumber((n-f)/o,g))}else{if(n-f<=Number.MIN_VALUE){return 0.1}var l;var m=((p||n)-f)*this.axisExtension;var d=f-m;var h=(p||n)+m;var i=h-d;var k=-Math.floor(Math.log(i/o)/Math.LN10);var e=Math.pow(10,-k);var g=this.getAxisDecimals(e);var c=((i/o)/e);if(c<1.5){l=e}else{if(c<2){l=e*2}else{if(c<2.5){l=e*2.5}else{if(c<5){l=e*5}else{if(c<7.5){l=e*7.5}else{l=e*10}}}}}if(this.getAxisMin(f,l)+(l*o)<n){return this.getAxisIncrements(f,n,o,j,(p||n)+l)}else{return l}}};this.getAxisMin=function(c,d){var e=d*Math.floor(c/d);return isNaN(e)?0:e<0&&this.minData>=0?0:e};this.getAxisDecimals=function(d){var c=1000000;var e=(((d*c)-(parseInt(d)*c))/c).toString().replace(/\./,"").length-1;return e};this.setAxis=function(d){var e=this.isGroupedData?this.data.w:this.data.y;var c=this.getSampleIndices(this[d]);if((this.isArray(c)&&c.length==0)||(!this.isArray(c)&&c==-1)){this[d]=[]}if(this[d].length==0){if(d=="xAxis"){this[d].push(e.smps[this.smpIndices[0]])}else{if(d=="yAxis"){if(e.smps.length>1){this[d].push(e.smps[this.smpIndices[1]])}else{this[d].push(e.smps[this.smpIndices[0]])}}else{if(d=="zAxis"){if(e.smps.length>2){this[d].push(e.smps[this.smpIndices[2]])}else{if(e.smps.length>1){this[d].push(e.smps[this.smpIndices[1]])}else{this[d].push(e.smps[this.smpIndices[0]])}}}}}}else{if(this.graphType=="Scatter3D"&&this[d].length>1){this[d]=[this[d][0]]}}};this.setAxisValues=function(e){var B,r,o,p,q,z,m,f,g;var d={};var l=e+"MinorValues";var n=e+"Values";var x=e+"Ticks";var y=e+"TickFormat";var w=e+"Incr";var c=e+"Decs";var s=e+"Min";var v=e+"Max";var k=e+"Transform";var h=e+"MaxStrLength";if(this[k]=="percentile"){this[c]=0;this[n]=[];this[l]=[];var A=[0,25,50,75,100];for(var u=0;u<A.length;u++){this[n].push(A[u])}for(var u=5;u<100;u+=5){this[l].push(u)}}else{if(this[n].length==0||b){if(b){this[n]=[];this[l]=[]}B=this[s];q=this[w]/this[x];for(var u=0;u<=this[x]+1;u++){for(var t=0;t<this[x];t++){g=B+(q*t);this[l].push(g)}if(this[c]==0&&B.toString().match(/\.5$/)){this[c]=1}if(this[y]){r=sprintf(this[y],B)}else{r=this.formatNumber(sprintf("%."+this[c]+"f",B),this[c])}if(d.hasOwnProperty(r)&&!this[y]){m=true}else{d[r]=1}this[n].push(r);B+=this[w]}}else{o=this[n];this[n]=[];for(var u=0;u<o.length;u++){B=o[u];p=parseFloat(B);if(this[y]){r=sprintf(this[y],p)}else{r=this.formatNumber(sprintf("%."+this[c]+"f",p),this[c])}if(d.hasOwnProperty(r)&&!this[y]){m=true}else{d[r]=1}this[n].push(r)}}}if(m){this[c]++;this[n]=[];this[l]=[];this.setAxisValues(e)}else{f=this.getMaxText(this[n]);if(!this[h]){this[h]=f}else{this[h]=this.getMaxText([this[h],f])}}};this.setAxisAttributes=function(e,g,i,l,t,n){var c=l&&l.match(/log/)?true:false;var s=e+"Ticks";var r=e+"Incr";var o=e+"Exact";var f=e+"AbsMin";var h=e+"AbsMax";var p=e+"Min";var q=e+"Max";var v=e+"Range";var d=e+"Decs";var j=e+"Transform";this.setRangeData(g,i,c,t);if(n==null){n=0}if(l){if(l=="log2"){this.minData=Math.log(this.minData)/Math.LN2;this.maxData=Math.log(this.maxData)/Math.LN2}else{if(l=="log10"){this.minData=Math.log(this.minData)/Math.LN10;this.maxData=Math.log(this.maxData)/Math.LN10}else{if(l=="exp2"){this.minData=Math.pow(2,this.minData);this.maxData=Math.pow(2,this.maxData)}else{if(l=="exp10"){this.minData=Math.pow(10,this.minData);this.maxData=Math.pow(10,this.maxData)}else{if(l=="percentile"){this.minData=0;this.maxData=100}}}}}}this[f]=this.setMin==null?this.minData:this[f];this[h]=this.setMax==null?this.maxData:this[h];if(this.axisAlgorithm=="default"||this[o]||t||(l&&l=="percentile")){this[r]=this.getAxisIncrements(this.minData,this.maxData+n,this[s],this[o]);this[d]=this.getAxisDecimals(this[r]);if(t){this[p]=0;if(this.graphType.match(/Percent/)){this[q]=100;this[s]=5;this[o]=true;this[r]=20;this[d]=0}else{this[q]=this[p]+(this[r]*this[s])}}else{if(this[o]||(l&&l=="percentile")){this[p]=this.minData;this[q]=this.maxData}else{this[p]=this.getAxisMin(this.minData,this[r]);this[q]=this[p]+(this[r]*this[s]);if(this[q]-(this[r]*2)>this.maxData){if(this[p]-this[r]>0){this[p]-=this[r];this[q]-=this[r]}if(this.minData>0&&this[p]<0){this[p]+=this[r];this[q]+=this[r]}}}}if(this[p]>this.minData||this[q]<this.maxData){this.setAxisAttributes(e,g,i,l,t,this[r])}this[v]=this[q]-this[p];this.setAxisValues(e)}else{var m=this[this.axisAlgorithm](this.minData,this.maxData,this[s],this.axisWilkinsonLoose);var k=(this.maxData-this.minData)*this.axisExtension/2;var u=this[s];this[r]=m[1]-m[0];this[d]=this.getAxisDecimals(this[r]);this[p]=m[0];this[q]=m[m.length-1];this[s]=m.length;this.setAxisValues(e);if(m[0]<this.minData){this[p]=m[0]}else{this[p]=this.minData-k}if(m[m.length-1]>this.maxData){this[q]=m[m.length-1]}else{this[q]=this.maxData+k}this[v]=this[q]-this[p];this[s]=u}};this.setAxes=function(d){if(this.smpIndices&&this.smpIndices.length<1){return}if(this.graphType.match(/Correlation/)){var f=this.isGroupedData?this.data.w:this.data.y;this.setMin=null;this.setMax=null;if(this.correlationAnchorLegend){this.setAxisAttributes("xAxis")}if(!f.cor||f.cor.length==0){this.summarize("cor");this.setRangeData("cor")}if(!this.yAxisTitle){this.yAxisTitle="Correlation"}}else{if(this.graphType.match(/Scatter|Pie/)){var t=this.smpIndices;var p=["xAxis"];var c=["X"];if(this.graphType.match(/Scatter/)){p.push("yAxis");c.push("Y")}if(this.graphType.match(/ScatterBubble2D|Scatter3D/)){p.push("zAxis");c.push("Z")}if(this.graphType=="Scatter3D"){this.xAxisTicks=10;this.yAxisTicks=10;this.zAxisTicks=10}for(var k=0;k<p.length;k++){var l=p[k]+"Indices";var j="setMin"+c[k];var r="setMax"+c[k];this.setMin=null;this.setMax=null;this.setAxis(p[k]);this[l]=this.getSampleIndices(this[p[k]]);this.setSamplesVisible(this[l]);if(this[j]!=null){this.setMin=this[j]}if(this[r]!=null){this.setMax=this[r]}this.setAxisAttributes(p[k],k>0?d:false,false,this[p[k]+"Transform"]);this.setSamplesVisible(t)}if(!this.xAxisTitle){this.xAxisTitle=this.xAxis.length==1?this.xAxis[0]:" "}if(this.graphType.match(/Scatter/)){if(!this.yAxisTitle){this.yAxisTitle=this.yAxis.length==1?this.yAxis[0]:" "}if(this.graphType.match(/ScatterBubble2D|Scatter3D/)){if(!this.zAxisTitle){this.zAxisTitle=this.zAxis.length==1?this.zAxis[0]:" "}}}}else{if(this.graphType.match(/Genome/)){this.setMax=this.setMaxX!=null?this.setMaxX:null;this.setMin=this.setMinX!=null?this.setMinX:null;this.setRangeData("genome");this.xAxisExact=true;this.xAxisTransform=false;this.xAxisAbsMin=this.minData;this.xAxisAbsMax=this.maxData;this.xAxisMin=this.minData-1;this.xAxisMax=this.maxData+1;this.xAxisDecs=0;this.xAxisRange=this.xAxisMax-this.xAxisMin;this.xAxisTicks=this.genomeTicks;this.xAxisIncr=this.xAxisRange/this.xAxisTicks;this.setAxisValues("xAxis")}else{var o=this.smpIndices;var e=this.varIndices;var h=this.grpIndices;var m=this.varIndices;var s=(this.graphType=="Dotplot"||this.graphType=="DotLine")&&this.isGroupedData?true:false;var g=this.graphType.match(/Percent/)?"percentile":this.xAxisTransform;var n=this.graphType.match(/Stacked/)||(this.graphType.match(/Area/)&&this.areaIsCumulative)?true:false;var q=this.graphType=="Candlestick"?"candle":g?g:false;if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)&&!this.data.a){this.data.a={xAxis:[],xAxis2:[]};this.xAxisVarIndices=[];this.xAxis2VarIndices=[];for(var k=0;k<this.varIndices.length-1;k++){this.data.a.xAxis.push(this.data.y.vars[this.varIndices[k]]);this.xAxisVarIndices.push(this.varIndices[k])}this.data.a.xAxis2.push(this.data.y.vars[this.varIndices.length-1]);this.xAxis2VarIndices.push(this.varIndices[this.varIndices.length-1])}if(this.varIndicesStart>-1||this.smpIndicesStart>-1){this.setAllVariablesVisible();this.setAllSamplesVisible();if(this.graphType=="Heatmap"){this.graphOrientation="horizontal"}}else{if(this.graphType=="StackedPercent"||this.graphType=="StackedPercentLine"){this.setMinX=null;this.setMaxX=null;this.xAxisExact=true}else{if(this.graphType=="Boxplot"&&!this.isGroupedData){if(!this.data.y.median){this.summarize("iqr")}}}}this.xAxis2Ticks=this.xAxisTicks;if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)&&this.data.a){this.setVariablesVisible(this.getVariablesVisibleByAxis("xAxis"))}this.setMax=this.setMaxX!=null?this.setMaxX:null;this.setMin=this.setMinX!=null?this.setMinX:null;this.setAxisAttributes("xAxis",q,s,g,n);this.xAxisTitle=this.xAxisTitle?this.xAxisTitle:this.data.y.desc&&this.data.y.desc[0]?this.data.y.desc[0]:"";if((this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)&&this.data.a)||(this.graphType=="Candlestick"&&this.showVolume)){q=this.graphType=="Candlestick"?"volume":false;if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)){this.setVariablesVisible(m);this.setVariablesVisible(this.getVariablesVisibleByAxis("xAxis2"))}this.setMax=this.setMaxX2!=null?this.setMaxX2:null;this.setMin=this.setMinX2!=null?this.setMinX2:null;this.setAxisAttributes("xAxis2",q,s);this.xAxis2Title=this.xAxis2Title?this.xAxis2Title:this.data.y.desc&&this.data.y.desc[1]?this.data.y.desc[1]:""}this.setMax=this.setMaxR!=null?this.setMaxR:null;this.setMin=this.setMinR!=null?this.setMinR:null;if(this.graphType=="Circular"&&this.rAxis){this.setAxisAttributes("rAxis","circular",s,g,false,true)}this.setVariablesVisible(m);this.smpIndices=o;this.varIndices=e;this.grpIndices=h}}}};this.setScatterPointSize=function(){this.scatterPointSize=this.varIndices.length>50?this.sizes[1]:this.varIndices.length>20?this.sizes[2]:this.sizes[3];if(this.layoutComb){this.scatterPointSize=Math.ceil(this.scatterPointSize/this.layoutRows)}};this.setAxisUnits=function(e,g){var f=e+"Unit";var d=e+"Range";var c=g?g:e.substring(0,1);this[f]=this[c]/this[d]};this.setAxisFont=function(h,g){var f=this.graphType=="Venn"?16:12;if(this.autoScaleFont||!this.axisTickFont||!this.decorationFont||!this.axisTitleFont){var c,e,d;if(g>=600){c=12*this.axisTickScaleFontFactor;d=10*this.decorationScaleFontFactor;e=this.getFontPt(this.scaleTextToFont(h,f,g-2))*this.axisTitleScaleFontFactor}else{if(g>=400){c=10*this.axisTickScaleFontFactor;d=8*this.decorationScaleFontFactor;e=this.getFontPt(this.scaleTextToFont(h,f,g-2))*this.axisTitleScaleFontFactor}else{if(g>=200){c=8*this.axisTickScaleFontFactor;d=6*this.decorationScaleFontFactor;e=8*this.axisTitleScaleFontFactor}else{if(g>=100){c=6*this.axisTickScaleFontFactor;d=4*this.decorationScaleFontFactor;e=6*this.axisTitleScaleFontFactor}else{c=4*this.axisTickScaleFontFactor;d=2*this.decorationScaleFontFactor;e=4*this.axisTitleScaleFontFactor}}}}this.axisTickFont=this.axisTickFontStyle+" "+(parseInt(c))+"px "+this.fontName;this.decorationFont=this.decorationFontStyle+" "+(parseInt(d))+"px "+this.fontName;this.axisTitleFont=this.axisTitleFontStyle+" "+(parseInt(e))+"px "+this.fontName}else{this.axisTickFont=this.axisTickFontStyle+" "+parseInt(this.axisTickFontSize)+"px "+this.fontName;this.decorationFont=this.decorationFontStyle+" "+parseInt(this.decorationFontSize)+"px "+this.fontName;this.axisTitleFont=this.axisTitleFontStyle+" "+parseInt(this.axisTitleFontSize)+"px "+this.fontName}};this.getAxisFont=function(c){if(c>=600){return 12}else{if(c>=400){return 10}else{if(c>=200){return 8}else{return 6}}}};this.heckbert=function(f,l,c){var e=function(i,n){var p;var q=Math.floor(Math.log(i)/Math.LN10);var o=i/Math.pow(10,q);if(n){if(o<1.5){p=1}else{if(o<3){p=2}else{if(o<7){p=5}else{p=10}}}}else{if(o<1){p=1}else{if(o<2){p=2}else{if(o<5){p=5}else{p=10}}}}return p*Math.pow(10,q)};var k=[];var h=e(l-f,false);var m=e(h/(c-1),true);var d=Math.floor(f/m)*m;var j=Math.ceil(l/m)*m;for(var g=d;g<=j;g+=m){k.push(g)}return k};this.wilkinson=function(e,j,c){var d=function(A,C,B,z){var v=[10,1,5,2,2.5,3,4,1.5,7,6,8,9];var x=C-A;var s=B-1;var p=1-Math.abs(B-z)/z;var E=x/s;var u=Math.floor(Math.log(E)/Math.LN10);var F=Math.pow(10,u);var q=null;for(var D=0;D<v.length;D++){var t=v[D]*F;var G=Math.floor(A/t)*t;var n=G+s*t;if(G<=A&&n>=C){var w=1-(D-(G<=0&&n>=0?1:0))/v.length;var r=(C-A)/(n-G);if(r>0.8){var y=p+w+r;if(q==null||y>q.score){q={lmin:G,lmax:n,lstep:t,score:y}}}}}return q};var l=[];var g=null;var m=[];for(var h=Math.max(Math.floor(c/2),2);h<=Math.ceil(6*c);h++){m.push(h)}for(var h=0;h<m.length;h++){var f=m[h];var o=d(e,j,f,c);if((o!=null&&g==null)||(o&&g&&o.score>g.score)){g=o}}for(var h=g.lmin;h<=g.lmax;h+=g.lstep){l.push(h)}return l};this.wilkinsonExtended=function(d,B,T,E){var C=2.22e-14;var l=function(j,g){for(var c=0;c<g.length;c++){if(j==g[c]){return c}}};var L=function(c,w,m,g,z,aa){var k=w.length;var s=l(c,w);var ab=(g%aa<C||aa-(g%aa)<C)&&g<=0&&z>=0?1:0;return 1-s/(k-1)-m+ab};var M=function(s,m,g){var w=m.length;var k=l(s,m);var c=1;return 1-k/(w-1)-g+c};var o=function(c,i,j,g){return 1-0.5*(Math.pow(i-g,2)+Math.pow(c-j,2))/Math.pow(0.1*(i-c),2)};var u=function(c,k,i){var g=k-c;if(i>g){var j=(i-g)/2;return 1-0.5*(Math.pow(j,2)+Math.pow(j,2))/Math.pow(0.1*g,2)}else{return 1}};var r=function(j,c,i,s,w,q){var n=(j-1)/(q-w);var g=(c-1)/(Math.max(q,s)-Math.min(i,w));return 2-Math.max(n/g,g/n)};var Z=function(g,c){return g>=c?2-(g-1)/(c-1):1};var h=[1,5,2,2.5,4,3];var I=[0.25,0.2,0.5,0.05];var S=h.length;var N={score:-2};var J=[];if(d>B){var p=d;d=B;B=p}if(B-d<C){for(var W=0;W<=T;W++){J.push(d)}return J}var V=1;while(V<Number.POSITIVE_INFINITY){for(var W=0;W<S;W++){var P=h[W];var x=M(P,h,V);if((I[0]*x+I[1]+I[2]+I[3]<N.score)){V=Number.POSITIVE_INFINITY;break}var U=2;while(U<Number.POSITIVE_INFINITY){var t=Z(U,T);if((I[0]*x+I[1]+I[2]*t+I[3]<N.score)){break}var G=(B-d)/(U+1)/V/P;var H=Math.ceil(Math.log(G)/Math.LN10);while(H<Number.POSITIVE_INFINITY){var F=V*P*Math.pow(10,H);var D=u(d,B,F*(U-1));if((I[0]*x+I[1]*D+I[2]*t+I[3]<N.score)){break}var y=Math.floor(B/F)*V-(U-1)*V;var R=Math.ceil(d/F)*V;if(y>R){H++;continue}for(var A=y;A<=R;A++){var v=A*(F/V);var O=v+F*(U-1);var f=F;var K=L(P,h,V,v,O,f);var Y=o(d,B,v,O);var X=r(U,T,d,B,v,O);var e=I[0]*K+I[1]*Y+I[2]*X+I[3];if(e>N.score&&(!E||(v<=d&&O>=B))){N={lmin:v,lmax:O,lstep:f,score:e}}}H++}U++}}V++}for(var W=N.lmin;W<=N.lmax;W+=N.lstep){J.push(W)}return J};this.rPretty=function(q,r,t){var c,g,d;var p=[];var s=Math.floor(t)-1;var u=Math.floor(s%3);var l=0.75;var x=1.5;var f=0.5+1.5*x;var j=r-q;if(j==0&&r==0){c=1;g=true;d=1}else{c=Math.max(Math.abs(q),Math.abs(r));d=1+f>=1.5*x+0.5?1/(1+x):1.5/1+f;g=j<(c*d*Math.max(1,s)*1e-7*3)}if(g){if(c>10){c=9+c/10}c=c*l;if(u>1){c/=u}}else{c=j;if(s>1){c/=s}}if(c<20*1e-7){c=20*1e-7}var e=Math.pow(10,Math.floor(Math.log(c)/Math.LN10));var o=e;if((2*e)-c<x*(c-o)){o=2*e;if((5*e)-c<f*(c-o)){o=5*e;if((10*e)-c<x*(c-o)){o=10*e}}}var z=Math.floor(q/o+1e-7);var y=Math.ceil(r/o-1e-7);while(z*o>q+(1e-7*o)){z--}while(y*o<r-(1e-7*o)){y++}var v=Math.floor(0.5+y-z);if(v<u){v=u-v;if(z>=0){y+=v/2;z=z-v/2+v%2}else{z-=v/2;y=y+v/2+v%2}s=u}else{s=v}for(var w=z*o;w<=y*o;w+=o){p.push(w)}return p};this.getHeatmapShades=function(d,c){switch(d){case"white":case"black":if(c&&c!="white"&&c!="black"){return this.getHeatmapShades(c)}else{return this.greys}case"grey":return this.greys;case"green":return this.greens;case"red":return this.reds;case"blue":return this.blues;case"yellow":return this.yellows;case"cyan":return this.cyans;case"purple":return this.purples}};this.setHeatmapColors=function(c){this.setRGB();var k=c?c:this.maxData-this.minData;var d=this.heatmapType.split("-");var m=256/this.indicatorBins;var l=this.getHeatmapShades(d[0],d[1]);this.heatmapColors=[];this.heatmapBin=(k?k:1)/this.indicatorBins;if(this.indicatorCenter.match("rainbow")&&d.length>1){var e=["red","purple","blue","cyan","green","yellow"];if(this.indicatorCenter=="rainbow-green"){e.reverse()}var n=null;for(var h=0;h<e.length;h++){if(e[h]==d[0]){n=h}}if(n==null){alert("Dude! "+d[0]+" ain't a valid color ... This is not looking good ...");this.heatmapColors=this.blues;return}var f=[e[n]];n++;while(f.length<6){if(n>5){n=0}f.push(e[n]);n++}n=null;for(var h=0;h<f.length;h++){if(f[h]==d[1]){n=h}}if(n==null){alert("Dude! "+d[1]+" ain't a valid color ... This is not looking good ...");this.heatmapColors=this.blues;return}for(var h=0;h<n;h++){l=this.getHeatmapShades(f[h]);for(var g=0;g<m;g++){this.heatmapColors.push(l[g])}}}else{if(d.length>1){if((d[0]=="white"&&d[1]!="black")||(d[0]=="black"&&d[1]!="white")){this.heatmapType=d[1];this.setHeatmapColors(c)}else{if(d[1]=="white"){if(d[0]=="black"){this.heatmapColors.push("rgb(0,0,0)");for(var h=m-1;h>=0;h--){this.heatmapColors.push(l[h]);this.heatmapColors.push(l[h])}}else{for(var h=0;h<m;h++){this.heatmapColors.push(l[h]);this.heatmapColors.push(l[h])}this.heatmapColors.push("rgb(255,255,255)")}}else{if(d[1]=="black"){if(d[0]=="white"){this.heatmapColors.push("rgb(255,255,255)");for(var h=0;h<m;h++){this.heatmapColors.push(l[h]);this.heatmapColors.push(l[h])}}else{for(var h=0;h<m;h++){this.heatmapColors.push(l[h]);this.heatmapColors.push(l[h])}this.heatmapColors.push("rgb(0,0,0)")}}else{for(var h=0;h<m;h++){this.heatmapColors.push(l[h])}if(this.indicatorCenter=="black"){this.heatmapColors.push("rgb(0,0,0)")}else{this.heatmapColors.push("rgb(255,255,255)")}l=this.getHeatmapShades(d[1]);for(var h=m-1;h>=0;h--){this.heatmapColors.push(l[h])}}}}}else{if(this.indicatorCenter=="black"&&color[0]!="grey"){this.heatmapColors.push("rgb(0,0,0)")}else{this.heatmapColors.push("rgb(255,255,255)")}for(var h=m-1;h>=0;h--){this.heatmapColors.push(l[h]);this.heatmapColors.push(l[h])}}}};this.initializeAxis=function(){if(!this.graphType.match(/Venn|Network|Video/)){if(!a){this.setAxes();this.setHeatmapColors()}}};this.initializeAxis()};CanvasXpress.prototype.Pie=function(a){this.setVarPie=function(){var g=[];var b=this.smpIndices[0];if(this.varIndices.length>=this.maxPieSectors-1){var f=this;this.varIndices.sort(function(h,d){return f.data.y.data[d][b]-f.data.y.data[h][b]})}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];g.push(this.getDataAtPos(e,b))}this.varPie=this.setPieData(g,true)};this.getPieLegendDimensions=function(){this.setLegendFont();var f=this.getFontPt(this.legendFont);var e=this.shortenText(this.maxVarNameStr,this.maxVarStringLen);var c=this.measureText(e,this.legendFont);if(c>this.width/2){this.legendFont=this.scaleTextToFont(c,f,this.width/2)}var d=f+this.measureText(e,this.legendFont)+(this.margin*5);var g=this.varIndices.length>this.maxPieSectors?this.maxPieSectors:this.varIndices.length;var b=(g*(f+this.margin))-(this.margin*2);return([d,b])};this.setPieXYDimensions=function(){var b=this.getPieLegendDimensions();if(this.showLegend){if(this.legendPosition=="right"){this.right=this.layoutComb&&!this.isDOE?this.layoutRight:b[0]}else{this.bottom=this.layoutComb&&!this.isDOE?this.layoutBottom:b[1]}}this.x=this.layoutComb&&!this.isDOE?this.layoutWidth:this.layoutComb?this.layoutWidth-(this.left+this.right):this.width-(this.marginLeft+this.left+this.right+this.marginRight);this.y=this.layoutComb&&!this.isDOE?this.layoutHeight:this.layoutComb?this.layoutHeight-(this.top+this.bottom):this.height-(this.marginTop+this.top+this.bottom+this.marginBottom);this.setAxisFont("Pie",this.x)};this.drawPieDataPoints=function(){var c=Math.min(this.x,this.y);var d=(c-(c/5))/2;var b=this.marginLeft+this.offsetX+this.left+(this.x/2);var e=this.marginTop+this.offsetY+this.top+(this.y/2);this.setVarPie();this.drawPie(this.varPie,b,e,d,true)};this.drawPieLegend=function(){if(this.showLegend){var c,h;var l=this.getPieLegendDimensions();var m=this.getFontPt(this.legendFont);var k=m/2;if(this.legendPosition=="right"){if(this.isDOE){c=this.marginLeft+this.offsetX+this.left+this.x+this.margin;h=this.marginTop+this.offsetY+this.top+(this.y/2)-(l[1]/2)}else{c=this.layoutComb?(this.width-(this.marginRight+l[0]))+this.marginLeft+this.left:this.marginLeft+this.left+this.x+(this.margin*2)+k;h=this.layoutComb?(this.layoutTop+(this.margin*3)+((this.height-(this.layoutTop+this.layoutBottom))/2))-(l[1]/2):this.marginTop+this.top+((this.y/2)-(l[1]/2))+this.margin}}else{c=this.layoutComb?(this.layoutLeft+(this.margin*3)+((this.width-(this.layoutLeft+this.layoutRight))/2))-(l[0]/2):this.marginLeft+this.left+((this.x/2)-(l[0]/2))+this.margin;h=this.layoutComb?(this.height-(this.marginBottom+l[1]))+this.marginTop+this.top:this.marginTop+this.top+this.y+(this.margin*2)+k}var b=c+k+this.margin;var g=h;for(var e=0;e<this.varPie.ids.length;e++){var j=this.varPie.ids[e];var d=this.pieColors[e%this.pieColors.length]?e%this.pieColors.length:e%this.colors.length;var f=j>-1?this.shortenText(this.data.y.vars[j],this.maxVarStringLen):"Other";this.drawShape("square",c,g,m,m,this.pieColors[d]||this.colors[d],this.foreground,"closed");this.drawText(f,b,g,this.legendFont,this.legendColor,"left","middle");g+=m+this.margin}if(this.legendBox){this.rectangle(c-(this.margin*2),h-(this.margin*2),l[0]-m,l[1]-m,false,this.legendBoxColor,"open")}}};this.drawPiePlot=function(){this.setPieXYDimensions();this.drawTitle();this.drawPieDataPoints();this.drawPieLegend()};this.initializePiePlot=function(){if(this.xAxisMin<0){alert("Dude you can't draw a pie chart with negative numbers!");return}if(this.layoutValid&&!this.isDOE){this.drawLayoutCompartments(this.drawPiePlot)}else{this.drawPiePlot()}};if(!a){this.initializePiePlot()}};CanvasXpress.prototype.Venn=function(){this.setVennXYDimensions=function(){var a;this.vennMarginLeft=0;this.vennMarginTop=0;this.setLegendFont();this.setAxisFont("Venn",this.width);if(this.showLegend){this.bottom=this.margin+((this.getFontPt(this.legendFont)+this.margin)*this.vennGroups)}if(this.width<=this.height){this.x=this.width-(this.marginLeft+this.left+this.right+this.marginRight)}else{this.x=this.height-(this.marginTop+this.top+this.bottom+this.marginBottom)}this.y=this.vennGroups==4?this.x*0.8:this.vennGroups==3?this.x*0.95:this.vennGroups==2?this.x*0.65:this.x;this.vennMarginTop=(this.height-(this.marginTop+this.top+this.y+this.bottom+this.marginBottom))/2;this.vennMarginLeft=(this.width-(this.marginLeft+this.left+this.x+this.right+this.marginRight))/2;if(this.x<400){var b=this.getFontPt(this.axisTickFont)-2;if(this.x<200){b-=1}this.axisTickFont=b+"px "+this.fontName}this.resizeCanvas()};this.drawVennBubble=function(d,e,f,b,c,a){if(this.isIE&&!this.useFlashIE){c=c.replace("rgb","rgba");c=c.replace(")",",0.5)");this.drawShape(f,d,e,b,b,c,this.foreground,"closed",a)}else{this.drawShape(f,d,e,b,b,c,this.foreground,"closed",a)}};this.drawVennLayout=function(){var g,h,b,e;var a=["A","B","C","D"];this.rectangleClear(0,0,this.width,this.height);this.setGlobalCompositionOperation("lighter");if(this.vennGroups==4){g=this.vennMarginLeft+this.marginLeft+this.margin;h=this.vennMarginTop+this.marginTop+this.top;this.drawVennBubble(g+(this.x/4.94),h+(this.x/13),"ellipse2",this.x/1.4,this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)",Math.PI/4);this.drawVennBubble(g+(this.x/2.72),h+(this.x/-40.31),"ellipse2",this.x/1.4,this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,153,51)",Math.PI/4);this.drawVennBubble(g+(this.x/3.43),h+(this.x/1.72),"ellipse2",this.x/1.4,this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)",-Math.PI/4);this.drawVennBubble(g+(this.x/7.96),h+(this.x/2.07),"ellipse2",this.x/1.4,this.vennColors.length>3&&this.validateColor(this.vennColors[3])?this.validateColor(this.vennColors[3]):"rgb(153,204,0)",-Math.PI/4);b=[11.2,3.05,1.46,1.08];e=[7,42,42,7]}else{if(this.vennGroups==3){g=this.vennMarginLeft+this.marginLeft+this.left+(this.x/2);h=this.vennMarginTop+this.marginTop+this.top+(this.x/2.86);this.drawVennBubble(g,h,"circle",this.x/2,this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h+=(this.x/3.33);g=this.vennMarginLeft+this.marginLeft+this.left+(this.x/3);this.drawVennBubble(g,h,"circle",this.x/2,this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,255,0)");g=this.vennMarginLeft+this.marginLeft+this.left+(this.x/1.5);this.drawVennBubble(g,h,"circle",this.x/2,this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)");b=[2,8.66,1.13];e=[20,2.3,2.3]}else{if(this.vennGroups==2){g=this.vennMarginLeft+this.marginLeft+this.left+(this.x/3);h=this.vennMarginTop+this.marginTop+this.top+(this.x/2.67);this.drawVennBubble(g,h,"circle",this.x/2,this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(0,0,255)");g=this.vennMarginLeft+this.marginLeft+this.left+(this.x/1.5);h=this.vennMarginTop+this.marginTop+this.top+(this.x/2.67);this.drawVennBubble(g,h,"circle",this.x/2,this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(255,0,0)");b=[3,1.5];e=[16,16]}else{if(this.vennGroups==1){g=this.vennMarginLeft+this.marginLeft+this.left+(this.x/2);h=this.vennMarginTop+this.marginTop+this.top+(this.x/2);this.drawShape("circle",g,h,this.x,this.x,this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)",this.foreground,"closed");b=[100];e=[100]}}}}this.setGlobalCompositionOperation("source-over");if(!this.vennLegendColors){for(var d=0;d<this.vennGroups;d++){var c=this.vennMarginLeft+this.marginLeft+this.left+(this.x/b[d]);var f=this.vennMarginTop+this.marginTop+this.top+(this.x/e[d]);this.drawText(a[d],c,f,this.axisTickFont,this.axisTickColor,"center","middle")}}};this.drawVennDataPoints=function(){var a,e;if(this.vennGroups==4){a=[5.6,2.94,3.5,1.54,3.29,2,2.59,1.212,2,1.442,1.4,1.757,2.31,1.624,2];e=[2.94,7,3.92,7,1.89,4.06,2.66,2.94,1.54,1.89,3.92,1.729,1.729,2.66,2.03];this.y=(this.x*1.1)/1.4}else{if(this.vennGroups==3){a=[2,3.5,2.55,1.4,1.6,2,2];e=[3.6,1.54,2.07,1.54,2.07,1.54,1.83];this.y=this.x*0.95}else{if(this.vennGroups==2){a=[3.5,1.4,2];e=[2.66,2.66,2.66];this.y=this.x*0.65}else{if(this.vennGroups==1){a=[2];e=[2]}}}}for(var d=0;d<a.length;d++){var c=this.vennMarginLeft+this.marginLeft+this.left+(this.x/a[d]);var f=this.vennMarginTop+this.marginTop+this.top+(this.x/e[d]);var b=this.getFontPt(this.axisTickFont);var g=this.data.venn.data[this.vennCompartments[d]]?this.data.venn.data[this.vennCompartments[d]]:0;this.drawText(g,c,f,this.axisTickFont,this.axisTickColor,"center","middle");this.addArea(["circle",c,f,b],[d])}};this.drawVennLegend=function(){if(this.showLegend){var a=["A","B","C","D"];var j=this.getFontPt(this.legendFont);var d=this.vennMarginLeft+this.marginLeft+this.left;var c=d+(j*2);var g=this.vennMarginTop+this.marginTop+this.top+this.y+this.margin+(j/2);var h=[];if(this.vennGroups==4){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,153,51)");h.push(this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[3]):"rgb(153,204,0)");h.push(this.vennColors.length>3&&this.validateColor(this.vennColors[3])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==3){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,255,0)");h.push(this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==2){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(0,0,255)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(255,0,0)")}else{h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)")}}}for(var f=0;f<this.vennGroups;f++){if(!this.vennLegendColors){this.drawText(a[f]+": ",d,g,this.legendFont,this.legendColor,"left","middle")}var b=this.data.venn.legend&&this.data.venn.legend[a[f]]?this.data.venn.legend[a[f]]:"N/A";var e=(this.measureText(b,this.legendFont)>this.x)?this.scaleTextToFont(b,j,this.x-this.margin):this.legendFont;if(!this.vennLegendColors){this.drawText(b,c,g,e,this.legendColor,"left","middle")}else{this.drawText(b,d,g,e,h[f],"left","middle")}g+=this.margin+j}}};this.drawVennPlot=function(){this.setVennXYDimensions();this.drawTitle();this.showShadow=false;this.drawVennLayout();this.showShadow=this.tmpshowShadow;this.drawVennDataPoints();this.drawVennLegend()};this.initializeVennPlot=function(){this.transparency=null;this.tmpshowShadow=this.showShadow;this.background="rgb(255,255,255)";this.foreground="rgb(0,0,0)";this.drawVennPlot()};this.initializeVennPlot()};CanvasXpress.prototype.Correlation=function(){this.setCorrelationVarSmpLabelFont=function(b){var a=this.scaleTextToSize(b);a=this.correlationAxis=="samples"?a*this.smpLabelScaleFontFactor:a*this.varLabelScaleFontFactor;a=Math.min(a,this.maxTextSize);this.smpLabelFont=(a)+"px "+this.fontName;this.varLabelFont=(a)+"px "+this.fontName};this.getCorrelationLabelsHeight=function(){var a=0;if(this.correlationAxis=="samples"){if(this.maxSmpName>this.maxSmpStringLen){a+=this.measureText(this.maxSmpNameStr.substring(0,this.maxSmpStringLen),this.smpLabelFont)}else{a+=this.measureText(this.maxSmpNameStr,this.smpLabelFont)}}else{if(this.maxVarName>this.maxVarStringLen){a+=this.measureText(this.maxVarNameStr.substring(0,this.maxVarStringLen),this.varLabelFont)}else{a+=this.measureText(this.maxVarNameStr,this.varLabelFont)}}if(this.correlationAnchorLegend){a+=this.correlationAnchorLegendAlignWidth+this.margin}return a};this.setCorrelationXYDimensions=function(){this.corMarginLeft=0;this.corMarginTop=0;if(this.yAxisShow){this.setAxisFont(this.yAxisTitle,this.height);this.left=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}if(this.width<=this.height){this.x=this.width-(this.marginLeft+this.left+this.right+this.marginRight)}else{this.x=this.height-(this.marginTop+this.top+this.bottom+this.marginBottom)}var a=this.correlationAxis=="variables"?this.varIndices.length:this.isGroupedData?this.grpIndices.length:this.smpIndices.length;this.diamondSize=this.x/a;this.setCorrelationVarSmpLabelFont(a);this.y=this.x/2+(this.diamondSize/2);if(this.xAxisShow){this.top+=this.margin+this.getCorrelationLabelsHeight()+this.margin}if(this.autoAdjust){this.height=this.marginTop+this.top+this.y+this.bottom+this.marginBottom;this.width=this.marginLeft+this.left+this.x+this.right+this.marginRight}else{this.corMarginTop=(this.height-(this.marginTop+this.top+this.y+this.bottom+this.marginBottom))/2;this.corMarginLeft=(this.width-(this.marginLeft+this.left+this.x+this.right+this.marginRight))/2}this.resizeCanvas()};this.drawCorrelationLayout=function(){if(this.yAxisShow){this.drawText(this.yAxisTitle,this.corMarginLeft+this.marginLeft+this.left/2,this.marginTop+this.top+(this.y/2),this.axisTitleFont,this.axisTitleColor,"center","middle",-Math.PI/2)}if(