/*
 * CanvasXpress 4.3 - JavaScript Canvas Library
 *
 * Copyright (c) 2009-2010 Isaac Neuhaus
 *
 * imnphd@gmail.com
 *
 * Redistributions of this source code must retain this copyright
 * notice and the following disclaimer.
 *
 * CanvasXpress is licensed under the terms of the Open Source
 * LGPL 3.0 license.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Commercial use is permitted to the extent that this source code
 * do NOT become part of any other Open Source or Commercially licensed
 * development library or toolkit without explicit permission.
 *
 * Network graphs were implemented based on the HeyGraph by Tom Martin
 * <http://www.heychinaski.com>.
 *
 * Thanks to Mingyi Liu for his contributions in extending the Ext panel
 * and adding major capabilities to the network graphs and animations.
 *
 */

CanvasXpress.doc = {"M":{"Overlays":{"D":"Colored boxes to help in the visualization of samples and variables","P":["overlayFont","overlayFontColor","overlayFontSize","overlayScaleFontFactor","overlaysWidth","showOverlays","smpOverlays","varOverlays"]},"Axes":{"D":null,"P":["axisExact","axisExtension","setMax","setMax2","setMaxX","setMaxY","setMaxZ","setMin","setMin2","setMinX","setMinY","setMinZ","ticks","timeTicksFirst","timeValueIndices","timeValues","xAxis","xAxis2","xAxis2AbsMax","xAxis2AbsMin","xAxis2Exact","xAxis2MaxStrLength","xAxis2MinorTicks","xAxis2MinorValues","xAxis2TickFormat","xAxis2Ticks","xAxis2Values","xAxisAbsMax","xAxisAbsMin","xAxisCurrent","xAxisExact","xAxisMaxStrLength","xAxisMinorTicks","xAxisMinorValues","xAxisShow","xAxisTickColor","xAxisTickFormat","xAxisTickStyle","xAxisTicks","xAxisTitle","xAxisTransform","xAxisTransformTicks","xAxisValues","yAxis","yAxisAbsMax","yAxisAbsMin","yAxisCurrent","yAxisExact","yAxisMaxStrLength","yAxisMinorTicks","yAxisMinorValues","yAxisShow","yAxisTickColor","yAxisTickFormat","yAxisTickStyle","yAxisTicks","yAxisTitle","yAxisTransform","yAxisTransformTicks","yAxisValues","zAxis","zAxisAbsMax","zAxisAbsMin","zAxisCurrent","zAxisExact","zAxisMaxStrLength","zAxisMinorTicks","zAxisMinorValues","zAxisShow","zAxisTickColor","zAxisTickFormat","zAxisTickStyle","zAxisTicks","zAxisTitle","zAxisTransform","zAxisTransformTicks","zAxisValues"]},"Clustering":{"D":null,"P":["centerData","clusterAxis","distance","imputeMethod","kmeansClusters","linkage","maxIterations","useSmpVarIndexOnClustering"]},"Title, Subtitles and References":{"D":"Properties used to manipulate general title, subtitle and citation","P":["citation","citationColor","citationFont","smpTitleFontSize","subtitle","subtitleHeight","title","titleColor","titleHeight"]},"Correlation":{"D":null,"P":["correlationAnchorLegend","correlationAnchorLegendAlignWidth","correlationAxis"]},"Indicators":{"D":"Legends for color, shape and size in visualizations","P":["indicatorsPosition","showIndicators"]},"2D Scatter Plot":{"D":null,"P":["allVsAll","allVsAllType","functionIntervals","histogramBarWidth","histogramBins","isCreateHistogram","isHistogram"]},"Text":{"D":"Properties associated with text attributes","P":["align","autoScaleFont","baseline","font","fontName","fontSize","fontStyle","fonts","maxTextSize","minTextSize","scaleTextConstantAdd","scaleTextConstantMult"]},"Axis Resizer":{"D":null,"P":["resizerAreaColor","resizerAreaColorCurrent","resizerAreaColorOutlineCurrent","resizerBackgroundImage","resizerDraw","resizerPosition","resizerTransparency","resizerType","resizerWidth"]},"Variables":{"D":"Properties associated with variables","P":["maxVarStringLen","scaleVarTitleFontFactor","showVariableNames","varLabelColor","varLabelDescription","varLabelFont","varLabelFontSize","varLabelRotate","varLabelScaleFontFactor","varTitle","varTitleColor","varTitleFont","varTitleFontSize","varTitleLabelOverlayPosition"]},"Multiple graphs in a canvas":{"D":null,"P":["layout","layoutAdjust","layoutAxis","layoutComb","layoutCurrent","layoutHeight","layoutMaxVarLegend","layoutMulticolor","layoutWidth","offsetX","offsetY","scaleX","scaleY","translateX","translateY","weight"]},"Highlight":{"D":"Used in samples, variables and Nodes","P":["highlightNode","highlightSmp","highlightVar","isSelectNodes","nodeHighlightColor","selectNode","smpHighlightColor","varHighlightColor"]},"Venn Diagrams":{"D":null,"P":["vennColors","vennCompartments","vennGroups"]},"Bars":{"D":null,"P":["showDataValues"]},"Dendrograms":{"D":null,"P":["dendrogramHang","dendrogramHeight","dendrogramSpace","showSmpDendrogram","showVarDendrogram","smpDendrogramPosition","varDendrogramPosition"]},"Pie Charts":{"D":null,"P":["maxPieSectors","pieSegmentLabels","pieSegmentPrecision","pieSegmentSeparation","pieType","showPieGrid","showPieSampleLabel","showPieValues","startPieSectors"]},"General":{"D":"General properties used in most visualizations","P":["autoAdjust","background","backgroundGradient1Color","backgroundGradient2Color","backgroundImage","backgroundType","canvasBox","canvasBoxColor","foreground","functions","gradient","gradientOrientation","gradientRatio","gradientType","graphOrientation","graphType","margin","marginBottom","marginLeft","marginRight","marginTop","shadowBlur","shadowColor","shadowOffsetX","shadowOffsetY","showShadow","transparency"]},"Candlestick":{"D":null,"P":["showVolume","sma10Color","sma20Color","sma25Color","sma50Color","sma5Color","stockIndicators"]},"Attributes":{"D":"Lines, Colors, Shapes, Sizes and Time","P":["arrowPointSize","capType","colorScheme","colors","dashLength","dotLength","evenColor","images","lines","oddColor","outlineWidth","shapes","sizes","timeFormat"]},"Remote Procedures":{"D":null,"P":["remoteAutoPlay","remoteAutoPlayDelay","remoteDataIndex","remoteDirection","remoteParams","remoteService","remoteUpdating","remoteWindow"]},"Animation":{"D":null,"P":["animationCycles","animationTime","animationType","showAnimation","showAnimationFont","showAnimationFontColor","showAnimationFontSize","snapshotCopyChangeOnly"]},"Events":{"D":null,"P":["broadcast","broadcastType","configuratorWidth","dataEvent","destroyAllOnClose","disableConfigurator","disableEvents","dragAreaColor","eventArrowKeys","eventKeys","eventPlusMinusKeys","helpKeyEvents","infoAreaColor","infoTimeIn","infoTimeOut","modelEvent","selectedBackgroundColor","this"]},"Images":{"D":null,"P":["imageDir","nextButton","playButton","previousButton","stopButton"]},"Data table":{"D":null,"P":["colWidth","dataTableTransposed","freezeColLeft","freezeColRight","freezeRowBottom","freezeRowTop","maxCols","maxRows","networkShowDataTable","refresehDataTableOnDraw","rowHeight","showDataTable","showDataTableOnSelect","startCol","startRow"]},"Samples":{"D":"Properties associated with samples","P":["maxSmpStringLen","showSampleNames","smpLabelColor","smpLabelDescription","smpLabelFont","smpLabelFontSize","smpLabelRotate","smpLabelScaleFontFactor","smpTitle","smpTitleColor","smpTitleFont","smpTitleFontSize","smpTitleScaleFontFactor"]},"Zooming and Panning":{"D":null,"P":["panningGlobalX","panningGlobalY","panningStep","panningX","panningY","zoom","zoomGlobal","zoomStep"]},"Snapshots":{"D":null,"P":["isAnimation","snapshots"]},"Networks":{"D":null,"P":["approximateNodePositions","attractiveForceFunction","autoHideOnDecorationsCenter","calculateLayout","colorEdgeBy","colorNodeBy","edgeConfigurableProperties","edgeWidth","initialTemperature","is3DNetwork","layoutTime","network2DRotate","networkDepth","networkDivisions","networkForceConstant","networkFreeze","networkFreezeOnLoad","networkLayoutType","networkNodeMinDistance","networkNodesOnTop","networkRoot","networkStack","networkStackStates","nodeConfigurableProperties","nodeFont","nodeFontColor","nodeFontSize","nodeScaleFontFactor","nodeSize","overrideEventlessNodes","preScaleNetwork","randomNetwork","randomNetworkNodeEdgesMax","randomNetworkNodes","reduceRandomNetwork","repulsiveForceFunction","shapeEdgeBy","shapeNodeBy","showHiddenChildEdges","showNetworkDecorationsLegend","showNetworkEdgesLegend","showNetworkNodesLegend","showNetworkRadialLayout","showNetworkTextLegend","showNodeNameThreshold","sizeDecorationBy","sizeEdgeBy","sizeNodeBy","skipClick","subNetworks","temperature"]},"Debug":{"D":null,"P":["checkGoogleChromeFrame","codeType","debug","showCode","showVersion"]},"Lines":{"D":null,"P":["coordinateLineColor","lineDecoration","lineTickness","lineType","tension"]},"Legends":{"D":"Legends for variables and samples","P":["legendBackgroundColor","legendBox","legendBoxColor","legendColor","legendFont","legendFontSize","legendPosition","legendScaleFontFactor","showLegend"]},"Decorations":{"D":"Additional elements added to graphs to increase data understanding","P":["decorationFont","decorationFontSize","decorationScaleFontFactor","decorations","decorationsColor","decorationsColors","decorationsHeight","decorationsPosition","decorationsProperties","decorationsType","decorationsWidth","showDecorations"]},"Scatter Plots":{"D":null,"P":["colorBy","isSelectDataPoints","scatterType","selectDataPoint","shapeBy","sizeBy"]},"Genome":{"D":null,"P":["featrureCoordinateHeight","featrureQualityHeight","featrureSignalToNoiseHeight","featrureTranslateHeight","featureCoodinateShow","featureHeightDefault","featureNameFont","featureNameFontColor","featureNameFontSize","featureQualityShow","featureQualityValues","featureSignalToNoiseShow","featureSignalToNoiseValues","featureStaggered","featureTraceHeight","featureTraceTrim","featureTracesShow","featureTranslateShow","featureTypeDefault","featureWidthDefault","genomeResolution","maxFeatureStringLen","periodTicksLabels","sequenceAColor","sequenceCColor","sequenceEndColor","sequenceFont","sequenceFontSize","sequenceGColor","sequenceMColor","sequenceStartColor","sequenceTColor","showFeatureNameThereshold","trackNameFont","trackNameFontColor","trackNameFontSize","wireColor"]},"3D Scatter Plot and Networks":{"D":null,"P":["maxRotate","minRotate","rotationDelay","rotationSensitivity","rotationStep","show3DGrid","xRotate","yRotate","zRotate"]},"Area":{"D":null,"P":["areaIsCumulative"]},"Ticks and Titles":{"D":"Attributes for ticks and titles in axes in one and two dimensional plots","P":["axisTickColor","axisTickFont","axisTickFontSize","axisTitleColor","axisTitleFont","axisTitleFontSize","axisTitleScaleFontFactor","tickRotate","tickScaleFontFactor"]},"Heatmaps":{"D":null,"P":["smpIndicesStart","varIndicesStart"]},"One dimentional plots":{"D":"Bar, Line, Dot, Boxplot, Area, Stacked, Pie, etc","P":["blockContrast","blockFactor","blockSeparationFactor","seriesSeparationFactor","smpHairline","smpHairlineColor"]},"Heatmaps and Correlations":{"D":null,"P":["heatmapType","indicatorCenter","indicatorHeight","indicatorWidth"]},"Data":{"D":null,"P":["groupingFactors","isBoxPlotCalc","isGraphTime","isGroupedData","isLogData","isMarketDataFormated","isMarketSwitched","isTransformedData","missingDataColor","randomData","randomDataMean","randomDataSampleAnnotationRatio","randomDataSampleAnnotations","randomDataSamples","randomDataSigma","randomDataVariableAnnotationRatio","randomDataVariableAnnotations","randomDataVariables","randomMissingDataPercentage","ratioReference","segregateSamplesBy","segregateVariablesBy","showErrorBars","smpSort","sortDir","tmpAsciiArray","transformBase","transformType","varSort","zscoreAxis"]}},"N":{"zIndex":{"M":"Network","T":"integer","C":"Css property for the imagePath"},"x":{"M":"Network","T":"float","C":"X coordinate"},"outline":{"M":"Network","T":"color","C":"Color for the outline of the node"},"imagePath":{"M":"Network","T":"url","C":"Url for the node image"},"eventless":{"M":"Network","T":"boolean","C":"Flag to disable all events in the node"},"y":{"M":"Network","T":"float","C":"Y coordinate"},"color":{"M":"Network","T":"color","C":"Color for the node"},"pattern":{"O":"open, closed","M":"Network","T":"option","C":"Whether to draw a solid shape or just an outline"},"rotate":{"M":"Network","T":"integer","C":"Number of degrees to rotate the shape"},"shape":{"M":"Network","T":"string","C":"Shape for the node. One of the ones defined in shapes"},"z":{"M":"Network","T":"float","C":"Z coordinate"},"outlineWidth":{"M":"Network","T":"integer","C":"Pixels used to raw the outline of the node"}},"P":{"yAxisTransform":{"O":"false, log2, log10, exp2, exp10, percentile","M":"Axes","T":"option","C":" Tranformation for the values in the Y axis.","D":"false"},"vennCompartments":{"Z":"true","M":"Venn Diagrams","T":"array","C":" Name for the compartments in the the Venn diagrams"},"setMaxX":{"M":"Axes","T":"float","C":" Maximum value to set the data in the X axis","D":"null"},"broadcastType":{"O":"var, comb","M":"Events","T":"option","C":" Model for broadcasting to identify either variables or a combination of variable and samples","D":"var"},"pieSegmentLabels":{"O":"inside, outside","M":"Pie Charts","T":"option","C":" Location for the values in the pie charts","D":"inside"},"shapeBy":{"M":"Scatter Plots","T":"string","C":" Name of a variable annotation or a sample name or the string 'variable' to shape the variables.","D":"false"},"featrureQualityHeight":{"M":"Genome","T":"integer","C":" Default size in pixels of the quality height","D":"12"},"segregateSamplesBy":{"O":"false, string","M":"Data","T":"option","C":" String to indicate the annotation used to segregate the samples. It must be a category in the 'data.x' object","D":"false"},"backgroundType":{"S":"backgroundImage, gradientOrientation, backgroundGradient1Color, backgroundGradient2Color","O":"solid, gradient, window, windowGradient, windowGradient2, windowSolidGradient, image, windowImage","M":"General","T":"option","C":" Type of background for the canvas. The canvas may have a window for plotting the data which may be a gradient, a solid pattern or an image.","D":"solid"},"xAxis2Exact":{"M":"Axes","T":"boolean","C":" Flag to force exact values for the data in the 2nd X axis","D":"false"},"maxSmpStringLen":{"M":"Samples","T":"integer","C":" Maximum length in characters a sample label or description can have so anything above is truncated.","D":"50"},"showAnimationFontSize":{"M":"Animation","T":"integer","C":" Size in pixels for the font size of text involved in the animation","D":"10"},"sequenceFont":{"Z":"true","M":"Genome","T":"font","C":" Font for the text of the sequence in the genome browser"},"networkStack":{"Z":"true","M":"Networks","T":"array","C":" Array to keep state of the network after a drag or move"},"axisExtension":{"M":"Axes","T":"float","C":" Percentage to extend the values in the data","D":"0.1"},"is3DNetwork":{"M":"Networks","T":"boolean","C":" Flag to create or not a 3D network","D":"false"},"autoAdjust":{"M":"General","T":"boolean","C":" Flag to automaticaly adjust the size of the canvas in most visualizations.","D":"true"},"sequenceMColor":{"M":"Genome","T":"color","C":" Color for the degenerate nucleotide sequences in the genome browser","D":"rgb(255,0,255)"},"varDendrogramPosition":{"M":"Dendrograms","T":"option","C":" Position for the variable dendrogram in the plot. It could be top, bottom, right or left depending on the orientation of the graph.","D":"top"},"xAxis2AbsMin":{"Z":"true","M":"Axes","T":"float","C":" Minimum unfiltered value for the 2nd X axis"},"randomDataVariableAnnotations":{"M":"Data","T":"integer","C":" Default number of variable annotations when creating random data","D":"2"},"calculateLayout":{"M":"Networks","T":"boolean","C":" Flag to force or not to calculate the network layout.","D":"true"},"subNetworks":{"Z":"true","M":"Networks","T":"array","C":" Array to keep independent networks"},"shapes":{"Z":"true","O":"sphere, square, triangle, star, rhombus, octagon, oval, plus, minus, pacman, mdavid, rect2, rect3, arc, rectangle, image","M":"Attributes","T":"array","C":" Shapes used in network graphs"},"blockContrast":{"M":"One dimentional plots","T":"boolean","C":" A flag to creates a shade between the samples so there are two backgrounds, one for the odd samples and one for the even samples.","D":"false"},"yAxisAbsMin":{"Z":"true","M":"Axes","T":"float","C":" Minimum unfiltered value for the Y axis"},"yAxisMinorValues":{"M":"Axes","T":"array","C":" Values for the minor ticks in the Y axis","D":"empty"},"sequenceTColor":{"M":"Genome","T":"color","C":" Color for the thymidines in the genome browser","D":"rgb(255,0,0)"},"xAxisExact":{"M":"Axes","T":"boolean","C":" Flag to force exact values for the data in the X axis","D":"false"},"nodeFontColor":{"M":"Networks","T":"color","C":" Color for the network text","D":"background color"},"networkNodeMinDistance":{"M":"Networks","T":"integer","C":" Minimum distance between nodes in forceDirected and organic layouts","D":"2"},"title":{"S":"titleHeight, titleColor","M":"Title, Subtitles and References","T":"string","C":" Title of the graph.","D":"false"},"featrureTranslateHeight":{"M":"Genome","T":"integer","C":" Default size in pixels of the translation height","D":"12"},"featureCoodinateShow":{"M":"Genome","T":"boolean","C":" Flag use to show coordinates","D":"true"},"zAxisMaxStrLength":{"Z":"true","M":"Axes","T":"string","C":" Longest string for ticks in the Z axis"},"legendBox":{"S":"legendBoxColor, legendBackgroundColor","M":"Legends","T":"boolean","C":" Flag to create a box around the legend","D":"true"},"yAxisExact":{"M":"Axes","T":"boolean","C":" Flag to force exact values for the data in the Y axis","D":"false"},"showDataTable":{"M":"Data table","T":"boolean","C":" Flag to indicate to show the data table","D":"false"},"showShadow":{"S":"shadowOffsetX, shadowOffsetY, this.shadowBlur, shadowColor","M":"General","T":"boolean","C":" Flag used to add  shadows to all element in the canvas. It will be forced to false if the browser is IE.","D":"false"},"colorScheme":{"S":"colors","O":"user, basic, dark, strong, light, pastel","M":"Attributes","T":"option","C":" Color schemes can be user defined which will take the colors in the color property or one provided in canvasXpress. The order of the colors will be used to sequentially select when a different color is needed in a particular visualization.","D":"basic"},"remoteService":{"M":"Remote Procedures","T":"url","C":" Url used to obtain data remotely. It expects and array of canvasXpress objects","D":"false"},"remoteWindow":{"M":"Remote Procedures","T":"integer","C":" Number of plots to show  when requesting remote data","D":"1"},"randomDataVariables":{"M":"Data","T":"integer","C":" Default number of variables when creating random data","D":"50"},"gradientRatio":{"S":"gradientType","M":"General","T":"float","C":" Ratio used to generate the linear gradients applied to all elements in the visualizations","D":"1.3"},"decorationFont":{"Z":"true","M":"Decorations","T":"font","C":" Font for the decoration in scatter plots and network graphs"},"playButton":{"M":"Images","T":"image","C":" Relative path to an image file to the play button (not including the image directory)","D":"play.png"},"showNetworkDecorationsLegend":{"M":"Networks","T":"boolean","C":" Flag to show node legends in the networks","D":"true"},"zAxisTickFormat":{"M":"Axes","T":"string","C":" Format for the tick values in the Z axis","D":"false"},"xAxisMinorValues":{"M":"Axes","T":"array","C":" Values for the minor ticks in the X axis","D":"empty"},"isMarketDataFormated":{"Z":"true","M":"Data","T":"boolean","C":" Flag to indicate if the data has been formated to display Candlestick."},"zAxisShow":{"M":"Axes","T":"boolean","C":" Flag to show on not the values of the ticks in the Z axis","D":"true"},"smpOverlays":{"M":"Overlays","T":"array","C":" Sample annotations included in the 'data.x' object used in one dimensional plots","D":"empty"},"translateY":{"Z":"true","M":"Multiple graphs in a canvas","T":"float","C":" Amount to translate for the Y axis."},"isTransformedData":{"Z":"true","M":"Data","T":"boolean","C":" Flag to indicate if the data is transformed."},"axisTitleFontSize":{"S":"autoScaleFont, axisTitleScaleFontFactor","M":"Ticks and Titles","T":"integer","C":" Font size for the axis titles in one and two dimensional plots. Be aware that auto scaling font must be turned off for this property to take effect. A more convenient way to modify the size is to use the axis title scaling factor","D":"10"},"featureNameFontSize":{"M":"Genome","T":"integer","C":" Size in pixels for the font size of text of the features in the genome browser","D":"8"},"xAxisTickFormat":{"M":"Axes","T":"string","C":" Format for the tick values in the X axis","D":"false"},"background":{"M":"General","T":"color","C":" Background color for the canvas.","D":"rgb(255,255,255)"},"resizerTransparency":{"M":"Axis Resizer","T":"boolean","C":" Flag to make the axis resizers transparent","D":"true"},"varLabelColor":{"M":"Variables","T":"color","C":" Font color for the variable labels in one dimensional plots","D":"foreground color"},"periodTicksLabels":{"M":"Genome","T":"integer","C":" Number of ticks to skip between values in the genome browser","D":"5"},"nodeSize":{"M":"Networks","T":"integer","C":" Length in pixels for the size of the nodes in the network","D":"10 | 20"},"maxRows":{"M":"Data table","T":"integer","C":" Maximum number of rows to display in the data table","D":"10"},"colWidth":{"M":"Data table","T":"integer","C":" Mumber of pixels for the width of cells in the data table","D":"100"},"scaleY":{"Z":"true","M":"Multiple graphs in a canvas","T":"float","C":" Scale factor for the Y axis"},"seriesSeparationFactor":{"M":"One dimentional plots","T":"float","C":" Factor to adjust the spacing between the series in the bar graphs","D":"2"},"varLabelFont":{"Z":"true","M":"Variables","T":"font","C":" Font for the variable labels in one dimensional plots"},"yAxisShow":{"M":"Axes","T":"boolean","C":" Flag to show on not the values of the ticks in the Y axis","D":"true"},"startCol":{"Z":"true","M":"Data table","T":"boolean","C":" Starting column in the data table"},"zAxisMinorTicks":{"M":"Axes","T":"boolean","C":" A flag to show minor tick lines in the Z axis","D":"false"},"xAxisTransform":{"O":"false, log2, log10, exp2, exp10, percentile","M":"Axes","T":"option","C":" Tranformation for the values in the X axis.","D":"false"},"axisTickFont":{"Z":"true","M":"Ticks and Titles","T":"font","C":" Font for the axis ticks in one and two dimensional plots"},"ratioReference":{"M":"Data","T":"integer","C":" Default index of sample used in ratio transformation.","D":"0"},"citationColor":{"S":"citation","M":"Title, Subtitles and References","T":"color","C":" Color for a reference citation of the graph","D":"rgb(0,0,0)"},"baseline":{"O":"top, middle, bottom","M":"Text","T":"option","C":" Default vertical alignment for drawing text.","D":"right"},"smpDendrogramPosition":{"M":"Dendrograms","T":"option","C":" Position for the sample dendrogram in the plot. It could be top, bottom, right or left depending on the orientation of the graph.","D":"left"},"decorationsPosition":{"O":"bottom, right","M":"Decorations","T":"option","C":" Position for the decorations in scatter plots and network graphs","D":"bottom"},"destroyAllOnClose":{"M":"Events","T":"boolean","C":" Flag to destroy all canvasXpress objects when removing instances","D":"true"},"eventPlusMinusKeys":{"M":"Events","T":"boolean","C":" Flag to enable plus / minus key binding events.","D":"true"},"correlationAnchorLegend":{"M":"Correlation","T":"boolean","C":" Flag to show a region above the correlation plot that anchror a sample/variable to a position","D":"false"},"minRotate":{"M":"3D Scatter Plot and Networks","T":"float","C":" Minimum number of degrees to rotate graph arround axes","D":"false"},"yAxisMinorTicks":{"M":"Axes","T":"boolean","C":" A flag to show minor tick lines in the Y axis","D":"true"},"helpKeyEvents":{"M":"Events","T":"boolean","C":" Flag to enable help on key events.","D":"true"},"axisTitleColor":{"M":"Ticks and Titles","T":"color","C":" Color for the axis title in one and two dimensional plots","D":"foregroung color"},"shadowOffsetY":{"S":"showShadow","M":"General","T":"integer","C":" Length in pixels for the shadow offset in the Y axis.","D":"3"},"xAxis2AbsMax":{"Z":"true","M":"Axes","T":"float","C":" Maximum unfiltered value for the 2nd X axis"},"panningGlobalX":{"Z":"true","M":"Zooming and Panning","T":"float","C":" Cumulative number of unit to pan the network in the X dimension"},"varSort":{"Z":"true","M":"Data","T":"integer","C":" Variable index used in sorting the data."},"yAxisTicks":{"M":"Axes","T":"integer","C":" Number of ticks in the Y axis","D":"5"},"xAxis":{"M":"Axes","T":"array","C":" Indices for the samples groups or variables to be displayed in the X axis","D":"empty"},"featureNameFont":{"Z":"true","M":"Genome","T":"font","C":" Font for the text of the features in the genome browser"},"decorations":{"M":"Decorations","T":"array","C":" Name of the node properties to include in the network decorations in the 'data.nodes' object","D":"[]"},"offsetY":{"Z":"true","M":"Multiple graphs in a canvas","T":"float","C":" Additional amount to move for the Y axis."},"selectNode":{"Z":"true","M":"Highlight","T":"object","C":" Name of nodes (in the data object) to select.","D":"{}"},"showCode":{"M":"Debug","T":"boolean","C":" Flag to show code for the canvas.","D":"false"},"autoHideOnDecorationsCenter":{"M":"Networks","T":"boolean","C":" Flag to hide node when decorations are positioned on the center","D":"false"},"panningX":{"M":"Zooming and Panning","T":"float","C":" Number of unit to pan the network in the X dimension","D":"0"},"isGraphTime":{"M":"Data","T":"boolean","C":" Flag to indicate if the data is a time series so ther is no need to plot every time interval","D":"false"},"colors":{"S":"colorScheme","M":"Attributes","T":"array","C":" Colors.","D":"colors"},"showSampleNames":{"M":"Samples","T":"boolean","C":" Flag to show the sample names in one dimensional plots.","D":"true"},"featureTraceHeight":{"M":"Genome","T":"integer","C":" Default size in pixels of the trace height","D":"40"},"featureQualityShow":{"M":"Genome","T":"boolean","C":" Flag use to show quality","D":"true"},"yAxisCurrent":{"M":"Axes","T":"integer","C":" Index of the sample that is currently displayed displayed in the Y axis","D":"0"},"lineDecoration":{"O":"false, dot, symbol","M":"Lines","T":"option","C":" Lines decorations in the line graphs","D":"sybol"},"shadowColor":{"S":"showShadow","M":"General","T":"color","C":" Color for the shadow.","D":"rgba(0,0,0,0.5)"},"xAxisValues":{"M":"Axes","T":"array","C":" Values for the ticks in the X axis","D":"empty"},"clusterAxis":{"O":"samples, variables","M":"Clustering","T":"option","C":" Default axis to use when clustering data.","D":"samples"},"dendrogramSpace":{"M":"Dendrograms","T":"integer","C":" Length in pixels to space the branches in the dendrograms.","D":"6"},"rotationDelay":{"M":"3D Scatter Plot and Networks","T":"integer","C":" Time in milliseconds to wait between rendering the plot when dragging the mouse.","D":"100"},"varLabelScaleFontFactor":{"M":"Variables","T":"float","C":" Scaling factor used to increse or decrease variable font size in the canvas.","D":"1"},"maxVarStringLen":{"M":"Variables","T":"integer","C":" Maximum length in characters a variable label or description can have so anything above is truncated.","D":"30"},"varLabelRotate":{"M":"Variables","T":"integer","C":" Rotation for variable labels in degrees It could be positive or negative.","D":"0"},"eventArrowKeys":{"M":"Events","T":"boolean","C":" Flag to enable arrow key binding events.","D":"true"},"networkNodesOnTop":{"M":"Networks","T":"boolean","C":" Order to use when drawing nodes and edges in the networks","D":"true"},"maxTextSize":{"M":"Text","T":"integer","C":" Maximum size for any text in the canvas.","D":"14"},"functionIntervals":{"M":"2D Scatter Plot","T":"integer","C":" Number of intervals to use when drawing functions in the decorations","D":"20"},"xAxisTitle":{"M":"Axes","T":"string","C":" Title for the X axis","D":"false"},"setMaxZ":{"M":"Axes","T":"float","C":" Maximum value to set the data in the Z axis","D":"null"},"gradient":{"S":"gradientType","M":"General","T":"boolean","C":" Flag used to apply gradients to all elements ploted in the visualizations according to their corresponding color","D":"false"},"dendrogramHeight":{"M":"Dendrograms","T":"boolean","C":" Flag to size the branches of the dendrogram.","D":"false"},"genomeResolution":{"Z":"true","O":"low, medium, high","M":"Genome","T":"option","C":" Number to adjust the splines curvature"},"showFeatureNameThereshold":{"M":"Genome","T":"integer","C":" Threshehold used to set te limit when there are too many features in the genome browser","D":"20"},"zAxisAbsMin":{"Z":"true","M":"Axes","T":"float","C":" Minimum unfiltered value for the Z axis"},"setMinZ":{"M":"Axes","T":"float","C":" Minimum value to set the data in the Z axis","D":"null"},"maxCols":{"M":"Data table","T":"integer","C":" Maximum number of columns to display in the data table","D":"8"},"nodeFont":{"Z":"true","M":"Networks","T":"font","C":" Font for the text in networks"},"sma5Color":{"M":"Candlestick","T":"color","C":" The color for the 5 day single moving average","D":"rgb(255,0,0)"},"varTitleFontSize":{"M":"Variables","T":"integer","C":" Size for the variable title in one dimensional plots","D":"10"},"reduceRandomNetwork":{"M":"Networks","T":"boolean","C":" Flag to create or not a single random network for debug and demonstraion purposes","D":"false"},"edgeWidth":{"M":"Networks","T":"integer","C":" Default width for the edges in the networks","D":"1"},"disableConfigurator":{"M":"Events","T":"boolean","C":" Flag to disable configurator.","D":"false"},"maxIterations":{"M":"Clustering","T":"integer","C":" Number of maximum iterations when clustering data with kmeans for one dimensional graphs or maximum number of iterations when calculating force direct layout networks.","D":"10"},"sortDir":{"O":"ascending, descending","M":"Data","T":"option","C":" Default direction for data sorting.","D":"ascending"},"featrureSignalToNoiseHeight":{"M":"Genome","T":"integer","C":" Default size in pixels of the quality height","D":"12"},"smpTitleColor":{"M":"Samples","T":"color","C":" Font color for the sample title in one dimensional plots","D":"foreground color"},"showOverlays":{"M":"Overlays","T":"boolean","C":" Flag to indicate to show or not the overlays in one dimensional plots","D":"true"},"graphOrientation":{"O":"horizontal, vertical","M":"General","T":"option","C":" Orientation of the graph when plotting one dimensional graphs","D":"horizontal"},"outlineWidth":{"M":"Attributes","T":"integer","C":" Default width in pixels for the lines","D":"1"},"correlationAnchorLegendAlignWidth":{"M":"Correlation","T":"integer","C":" Length in pixels of the height of the correlation anchor legend","D":"40"},"randomDataVariableAnnotationRatio":{"M":"Data","T":"integer","C":" Approximate number of classes in each variable annotation when creating random data","D":"2"},"marginRight":{"M":"General","T":"integer","C":" Length in pixels for the right margin in the canvas","D":"0"},"smpTitle":{"M":"Samples","T":"string","C":" Title for the sample axis in one dimensional plots","D":"false"},"align":{"O":"right, center, left","M":"Text","T":"option","C":" Default horizontal alignment for drawing text.","D":"center"},"dataTableTransposed":{"M":"Data table","T":"boolean","C":" Flag to transpose the data in the data table","D":"true"},"showDataTableOnSelect":{"M":"Data table","T":"boolean","C":" Flag to indicate to show data after selecting data in the plot","D":"true"},"wireColor":{"M":"Genome","T":"color","C":" Color for the ticks in the genome browser","D":"rgba(220,220,220,0.1)"},"shapeEdgeBy":{"M":"Networks","T":"string","C":" Name of the attribute to shape the nods.","D":"false"},"marginTop":{"M":"General","T":"integer","C":" Length in pixels for the top margin in the canvas","D":"0"},"setMin":{"M":"Axes","T":"float","C":" Minimum value to set the data","D":"null"},"animationCycles":{"M":"Animation","T":"integer","C":" Number of cycles to plot the graph for the animations.","D":"20"},"xAxis2MaxStrLength":{"Z":"true","M":"Axes","T":"string","C":" Longest string for ticks in the 2nd X axis"},"randomNetworkNodes":{"M":"Networks","T":"integer","C":" Default number of nodes when creating random networks","D":"50"},"show3DGrid":{"M":"3D Scatter Plot and Networks","T":"boolean","C":" Flag to show the X,Y,Z grid in scatter 3D plots","D":"true"},"codeType":{"O":"pretty, compact, tab","M":"Debug","T":"option","C":" Output type for the JSON code","D":"pretty"},"shapeNodeBy":{"M":"Networks","T":"string","C":" Name of the attribute to shape the nods.","D":"false"},"xAxisShow":{"M":"Axes","T":"boolean","C":" Flag to show on not the values of the ticks in the X axis","D":"true"},"xAxis2MinorValues":{"M":"Axes","T":"array","C":" Values for the minor ticks in the 2nd X axis","D":"empty"},"infoAreaColor":{"M":"Events","T":"color","C":" Color for the div displayed when mouse over an element in the canvas","D":"rgb(208,222,240)"},"fontName":{"O":"Gentilis, Helvetiker, Optimer, Verdana, sans-serif","M":"Text","T":"font","C":" Font name. It will be set depending on the browser. It could be Optimer, Helvetiker, Gentilis or Verdana, sans-serif","D":"Verdana, sans-serif"},"canvasBoxColor":{"S":"canvasBox","M":"General","T":"color","C":" Color for the box around the canvas","D":"rgb(0,0,0)"},"subtitleHeight":{"S":"subtitle, subtitleColor","M":"Title, Subtitles and References","T":"integer","C":" Height for the subtitle of the graph. The font height will be adjusted automatically to fit in the canvas.","D":"16"},"indicatorsPosition":{"O":"bottom, right","M":"Indicators","T":"option","C":" Position for the color, shape and size indicators in several visualizations","D":"bottom"},"highlightSmp":{"M":"Highlight","T":"array","C":" Name of samples in the 'data.y' object to highlight.","D":"[]"},"decorationsHeight":{"M":"Decorations","T":"integer","C":" Length in pixels of the height for the decorations in the networks","D":"20"},"titleHeight":{"S":"title, titleColor","M":"Title, Subtitles and References","T":"integer","C":" Height for the title of the graph. The font height will be adjusted automatically to fit in the canvas.","D":"30"},"coordinateLineColor":{"M":"Lines","T":"boolean","C":" Flag to used same color in BarLine plots. If set to true the color of the bars and the lines will be the same","D":"true"},"sizes":{"Z":"true","O":"4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34","M":"Attributes","T":"array","C":" Sizes used invisualizations"},"infoTimeIn":{"M":"Events","T":"integer","C":" Time in milliseconds to start showing info after a mouse over","D":"3000"},"layoutHeight":{"Z":"true","M":"Multiple graphs in a canvas","T":"float","C":" Height of the current segment of the canvas when there are multiple graphs."},"layoutAxis":{"Z":"true","O":"1, 2, 3","M":"Multiple graphs in a canvas","T":"option","C":" Flag to indicated whether to print axes values when multiple graphs are displayed in the canvas. The possible values are: 1: horizontal, 2: vertical, 3: both"},"sizeEdgeBy":{"M":"Networks","T":"string","C":" Name of the attribute to size the edges.","D":"false"},"smpIndicesStart":{"Z":"true","M":"Heatmaps","T":"integer","C":" Number that indicates starting point for samples in heatmaps when the canvas is zoom in."},"zAxisCurrent":{"M":"Axes","T":"integer","C":" Index of the sample that is currently displayed displayed in the Z axis","D":"0"},"xAxisCurrent":{"M":"Axes","T":"integer","C":" Index of the sample that is currently displayed displayed in the X axis","D":"0"},"nodeScaleFontFactor":{"M":"Networks","T":"float","C":" Scaling factor used to increse or decrease network text font size in the canvas.","D":"1"},"colorBy":{"M":"Scatter Plots","T":"string","C":" Name of a variable annotation or a sample name or the string 'variable' to color the variables.","D":"false"},"evenColor":{"M":"Attributes","T":"color","C":" The color for the even numbers in samples or sequences","D":"rgb(240,240,240)"},"startPieSectors":{"M":"Pie Charts","T":"float","C":" Starting degrees for pie sectors. 0 is equivalent to 3:00 oclock","D":"0"},"randomNetworkNodeEdgesMax":{"M":"Networks","T":"integer","C":" Default number of maximum edges when creating random networks","D":"5"},"scaleTextConstantAdd":{"Z":"true","M":"Text","T":"float","C":" Constants to autoscale text (extra)","D":"2.5"},"legendBoxColor":{"S":"legendBox","M":"Legends","T":"color","C":" Color for the box around the legend","D":"rgb(0,0,0)"},"rotationSensitivity":{"M":"3D Scatter Plot and Networks","T":"integer","C":" Factor to adjust the sensitivity of the mouse when rotating the  graph","D":"45"},"skipClick":{"Z":"true","M":"Networks","T":"boolean","C":" Flag to skip click events after a mouse down event in the networks when the eventModel is global"},"transformBase":{"O":"2, 10","M":"Data","T":"integer","C":" Default log or exponential transformation.","D":"2"},"font":{"Z":"true","M":"Text","T":"font","C":" The combination of font name style and size.","D":"Verdana, sans-serif 12pt"},"trackNameFontColor":{"M":"Genome","T":"color","C":" Color for the text of the tracks in the genome browser","D":"background color"},"centerData":{"M":"Clustering","T":"boolean","C":" Flag to indicate whether to center data when clustering","D":"false"},"missingDataColor":{"M":"Data","T":"color","C":" Color for the missing data","D":"rgb(255,255,0)"},"scaleTextConstantMult":{"Z":"true","M":"Text","T":"integer","C":" Constants to autoscale text","D":"40"},"offsetX":{"Z":"true","M":"Multiple graphs in a canvas","T":"float","C":" Additional amount to move for the X axis"},"varLabelDescription":{"M":"Variables","T":"string","C":" Variable label description is a valid sample classification included in the 'data.z' object used in heatmaps","D":"false"},"linkage":{"O":"single, complete, average","M":"Clustering","T":"option","C":" Linkage type to use when clustering data.","D":"single"},"images":{"S":"scatterType","M":"Attributes","T":"array","C":" Array of urls of images used in scatter plots.","D":"[]"},"zAxisTickStyle":{"O":"solid, dotted","M":"Axes","T":"option","C":" Style for the tick lines in the Z axis","D":"solid"},"showNodeNameThreshold":{"M":"Networks","T":"integer","C":" Thereshold used to set the limit to hide or display the name of nodes in a network. If the number of nodes exceed this thereshold then the name will not be shown.","D":"50"},"sequenceStartColor":{"M":"Genome","T":"color","C":" Color for the start codon in the genome browser","D":"rgb(0,255,0)"},"smpLabelDescription":{"M":"Samples","T":"string","C":" Sample label description is a valid sample classification included in the 'data.x' object used in heatmaps","D":"false"},"backgroundGradient1Color":{"S":"backgroundType, backgroundGradient2Color","M":"General","T":"color","C":" The first color of the gradient if the background is a type of gradient.","D":"rgb(0,0,200)"},"smpLabelFont":{"Z":"true","M":"Samples","T":"font","C":" Font for the sample labels in one dimensional plots"},"isSelectDataPoints":{"Z":"true","M":"Scatter Plots","T":"integer","C":" Number of selected data points (in the data object).","D":"0"},"timeValueIndices":{"M":"Axes","T":"array","C":" Array containig the indices of the values when the the graph is a time series","D":"empty"},"randomDataSampleAnnotations":{"M":"Data","T":"integer","C":" Default number of sample annotations when creating random data","D":"3"},"smpLabelRotate":{"M":"Samples","T":"integer","C":" Rotation for sample labels in degrees. It could be positive or negative.","D":"0"},"resizerWidth":{"M":"Axis Resizer","T":"integer","C":" Length in pixels for the width of the visible axis resizer","D":"18"},"showNetworkRadialLayout":{"M":"Networks","T":"boolean","C":" Flag to show or not a radial layout wire.","D":"false"},"legendColor":{"M":"Legends","T":"color","C":" Color for the legends","D":"foregroung color"},"layoutAdjust":{"M":"Multiple graphs in a canvas","T":"boolean","C":" Flag to force recalculating the ranges in the axes when multiple graphs are displayed in the canvas.","D":"false"},"infoTimeOut":{"M":"Events","T":"integer","C":" Time in milliseconds to wait between updates for the mouse over info to show up","D":"3000"},"overlayFont":{"Z":"true","M":"Overlays","T":"font","C":" Font for the overlays in one dimensional plots"},"featureNameFontColor":{"M":"Genome","T":"color","C":" Color for the text of the features in the genome browser","D":"background color"},"isSelectNodes":{"Z":"true","M":"Highlight","T":"integer","C":" Number of selected nodes (in the data object).","D":"0"},"varHighlightColor":{"M":"Highlight","T":"color","C":" The color for the highlighted variables.","D":"rgb(255,0,0)"},"startRow":{"Z":"true","M":"Data table","T":"boolean","C":" Initialize general attributes, shapes, lines etc"},"remoteAutoPlayDelay":{"M":"Remote Procedures","T":"integer","C":" Time in milliseconds to wait between iterations over remote data sets","D":"1000"},"kmeansClusters":{"M":"Clustering","T":"integer","C":" Number of clusters when clustering data with kmeans.","D":"3"},"setMinY":{"M":"Axes","T":"float","C":" Minimum value to set the data in the Y axis","D":"null"},"showNetworkEdgesLegend":{"M":"Networks","T":"boolean","C":" Flag to show edge legends in the networks","D":"true"},"lines":{"Z":"true","O":", dashed, dotted, bezierY, bezierX, curved + arrow, arrowHead, arrowTail, arrowHeadSquareTail, arrowTailSquareHead, square, squareHead, squareTail, squareHeadArrowTail, squareTailArrowHead","M":"Attributes","T":"array","C":" Line types available network graphs The patterns can be: '', 'dashed', 'dotted', 'bezierY', 'bezierX' and 'curved'. The end could be: 'arrow', 'arrowHead', 'arrowTail', 'arrowHeadSquareTail', 'arrowTailSquareHead', 'square', 'squareHead', 'squareTail', 'squareHeadArrowTail' or 'squareTailArrowHead'."},"xAxis2MinorTicks":{"M":"Axes","T":"boolean","C":" A flag to show minor tick lines in the 2nd X axis","D":"true"},"showPieGrid":{"M":"Pie Charts","T":"float","C":" A flag to show the labels for the grid when plotting multiple pies","D":"true"},"panningGlobalY":{"Z":"true","M":"Zooming and Panning","T":"float","C":" Cumulative umber of unit to pan the network in the Y dimension"},"timeFormat":{"O":"default, shortDate, mediumDate, longDate, fullDate, shortTime, mediumTime, longTime, isoDate, isoTime, isoDateTime, isoUtcDateTime","M":"Attributes","T":"option","C":" Time Format according to date.format.js Steven Levithan <stevenlevithan.com>","D":"isoDate"},"featureHeightDefault":{"M":"Genome","T":"integer","C":" Default size in pixels of the feature height","D":"14"},"networkStackStates":{"M":"Networks","T":"integer","C":" Number of states to keep in the network stack after a drag or move","D":"5"},"zAxisTicks":{"M":"Axes","T":"integer","C":" Number of ticks in the Z axis","D":"5"},"freezeColLeft":{"M":"Data table","T":"integer","C":" Number of columns to freeze in the left side of the data table","D":"0"},"yAxisTickFormat":{"M":"Axes","T":"string","C":" Format for the tick values in the Y axis","D":"false"},"trackNameFontSize":{"M":"Genome","T":"integer","C":" Size in pixels for the font size of text of the tracks in the genome browser","D":"10"},"sequenceEndColor":{"M":"Genome","T":"color","C":" Color for the end codon in the genome browser","D":"rgb(255,0,0)"},"setMin2":{"M":"Axes","T":"float","C":" Minimum value to set the data in the 2nd axis","D":"null"},"isGroupedData":{"Z":"true","M":"Data","T":"boolean","C":" Flag to indicate if the data is grouped."},"resizerAreaColor":{"M":"Axis Resizer","T":"color","C":" Color for the div that shows up when resizing the axes in the canvas or the whole canvas","D":"rgb(220,220,220)"},"zoomGlobal":{"Z":"true","M":"Zooming and Panning","T":"float","C":" Cumulative zoom factor for the networks."},"legendFont":{"Z":"true","M":"Legends","T":"font","C":" Font for the legends"},"randomDataSampleAnnotationRatio":{"M":"Data","T":"integer","C":" Approximate number of classes in each sample annotation when creating random data","D":"2"},"xAxis2Values":{"M":"Axes","T":"array","C":" Values for the ticks in the 2nd X axis","D":"empty"},"freezeRowBottom":{"M":"Data table","T":"integer","C":" Number of rows to freeze at the bottom of the data table","D":"0"},"overrideEventlessNodes":{"M":"Networks","T":"boolean","C":" Flag to override nodes that do not take events to be able to edit them","D":"false"},"decorationsType":{"O":"pie, bar, heatmap, stacked, stackedpercent","M":"Decorations","T":"option","C":" Type for the decorations in the networks. The types stacked and stackedpercent must be two dimensional. Heatmap could be one or two dimensional","D":"bar"},"xAxisTransformTicks":{"M":"Axes","T":"boolean","C":" Flag to transform the values of the ticks in the X axis","D":"true"},"showVersion":{"M":"Debug","T":"boolean","C":" Flag to show version when mouse over top-left corner of the canvas.","D":"true"},"networkDepth":{"Z":"true","M":"Networks","T":"integer","C":" Depth of the radial network."},"legendScaleFontFactor":{"M":"Legends","T":"float","C":" Scaling factor used to increse or decrease legend font size in the canvas.","D":"1"},"showHiddenChildEdges":{"M":"Networks","T":"boolean","C":" Flag to show or not children nodes when the parent node is hidden.","D":"true"},"tmpAsciiArray":{"Z":"true","M":"Data","T":"array","C":" A temporary array to enable sorting data asciibetically."},"randomDataSigma":{"M":"Data","T":"integer","C":" Sigma value when creating random data","D":"100"},"nodeConfigurableProperties":{"M":"Networks","T":"array","C":" Node configurable properties","N":"x:[float];X coordinate;[],y:[float];Y coordinate;[],z:[float];Z coordinate;[],shape:[string];Shape for the node. One of the ones defined in shapes;[shapes],color:[color];Color for the node;[],outline:[color];Color for the outline of the node;[],pattern:[open|closed];Whether to draw a solid shape or just an outline;[],rotate:[integer];Number of degrees to rotate the shape;[],outlineWidth:[integer];Pixels used to raw the outline of the node;[],imagePath:[url];Url for the node image;[],zIndex:[integer];Css property for the imagePath;[],eventless:[boolean];Flag to disable all events in the node;[overrideEventlessNodes]","D":"['x','y','z','shape','color','outline','size','width','height','pattern','rotate','outlineWidth','imagePath','zIndex','eventless']"},"zoomStep":{"M":"Zooming and Panning","T":"float","C":" Percentage step for zooming networks and genome panel.","D":"0.2"},"axisTitleScaleFontFactor":{"M":"Ticks and Titles","T":"float","C":" Scaling factor used to increse or decrease title font size in the canvas in one and two dimensional plots","D":"1"},"sma50Color":{"M":"Candlestick","T":"color","C":" The color for the 50 day single moving average","D":"rgb(0,0,0)"},"areaIsCumulative":{"M":"Area","T":"boolean","C":" Flag to treat area graphs as cumulative values","D":"false"},"stopButton":{"M":"Images","T":"image","C":" Relative path to an image file to the stop button (not including the image directory)","D":"stop.png"},"trackNameFont":{"Z":"true","M":"Genome","T":"font","C":" Font for the text of the tracks in the genome browser"},"networkDivisions":{"Z":"true","M":"Networks","T":"integer","C":" Number of angular divisions in the radial network."},"randomData":{"M":"Data","T":"boolean","C":" Flag to create or not random data for debug and demonstraion purposes","D":"false"},"zAxisExact":{"M":"Axes","T":"boolean","C":" Flag to force exact values for the data in the Z axis","D":"false"},"resizerDraw":{"M":"Axis Resizer","T":"boolean","C":" Flag to make the axis resizers draw the canvas as they move","D":"true"},"featureSignalToNoiseValues":{"M":"Genome","T":"boolean","C":" Flag use to show values for the quality","D":"false"},"temperature":{"M":"Networks","T":"integer","C":" Temperature to limit displacement at later stages of forceDirected and organic layouts. A value based on the number of node and edges will be assigned if not specified","D":"0"},"indicatorWidth":{"M":"Heatmaps and Correlations","T":"integer","C":" Length in pixels for the heatmap indicator line width used for increase the size of the indicator","D":"1"},"tickScaleFontFactor":{"M":"Ticks and Titles","T":"float","C":" Scaling factor used to increse or decrease tick font size in the canvas in one and two dimensional plots","D":"1"},"sequenceFontSize":{"M":"Genome","T":"integer","C":" Size in pixels for the font size of text of the sequence in the genome browser","D":"10"},"featureTypeDefault":{"O":"box, bar, heatmap, sequence, triangle, line","M":"Genome","T":"option","C":" Default type for the feature in the genome browser","D":"line"},"showNetworkTextLegend":{"M":"Networks","T":"boolean","C":" Flag to show node legends in the networks","D":"true"},"panningStep":{"M":"Zooming and Panning","T":"float","C":" Percentage step for panning networks.","D":"0.2"},"zAxisValues":{"M":"Axes","T":"array","C":" Values for the ticks in the Z axis","D":"empty"},"showIndicators":{"M":"Indicators","T":"boolean","C":" Flag to show color, shape and size indicators in several visualizations","D":"true"},"sma20Color":{"M":"Candlestick","T":"color","C":" The color for the 25 day single moving average","D":"rgb(0,0,255)"},"smpHairlineColor":{"M":"One dimentional plots","T":"color","C":" The color for the thin line that appears in the middle of the bar graphs","D":"rgb(220,220,220)"},"allVsAllType":{"O":"both, upper, lower","M":"2D Scatter Plot","T":"option","C":" Type for the n-1 x n-1 matrix of 2D sccaterplots","D":"both"},"overlayFontSize":{"M":"Overlays","T":"integer","C":" Font size for the overlays in one dimensional plots","D":"6"},"axisTitleFont":{"Z":"true","M":"Ticks and Titles","T":"font","C":" Font for the axis titles in one and two dimensional plots"},"functions":{"Z":"true","M":"General","T":"array","C":" Functions exposed to the api"},"decorationsProperties":{"M":"Decorations","T":"object","C":" Object to assign properties like color for the network decorations","D":"{}"},"ticks":{"M":"Axes","T":"integer","C":" Number of ticks in the genome browser","D":"50"},"yAxisTransformTicks":{"M":"Axes","T":"boolean","C":" Flag to transform the values of the ticks in the Y axis","D":"true"},"isCreateHistogram":{"Z":"true","M":"2D Scatter Plot","T":"boolean","C":" Flag to indicate there is a histogram","D":"false"},"zAxisTransform":{"O":"false, log2, log10, exp2, exp10, percentile","M":"Axes","T":"option","C":" Tranformation for the values in the Z axis.","D":"false"},"showAnimationFont":{"Z":"true","M":"Animation","T":"font","C":" Font for the text in animations"},"varIndicesStart":{"Z":"true","M":"Heatmaps","T":"integer","C":" Number that indicates starting point for variables in heatmaps when the canvas is zoom in."},"autoScaleFont":{"S":"smpLabelFontSize, varLabelFontSize, legendFontSize, axisTickFontSize, axisTitleFontSize","M":"Text","T":"boolean","C":" Flag to automatically adjust the font size in many visualization. Please be aware that scaling factors can still modify the font size. This flag needs to be false for the text to accept the specified font size.","D":"true"},"nodeFontSize":{"M":"Networks","T":"integer","C":" Size in pixels for the font size of text in the networks","D":"node width"},"backgroundGradient2Color":{"S":"backgroundType, backgroundGradient1Color","M":"General","T":"color","C":" The second color of the gradient if the background is a type of gradient.","D":"rgb(0,0,36)"},"resizerBackgroundImage":{"Z":"true","M":"Axis Resizer","T":"url","C":" Object to store data when the canvas is zoomed with the axis resizer resizerEventData @type {object}","D":"-1"},"sizeDecorationBy":{"M":"Networks","T":"string","C":" Name of the attribute to size the network decoration.","D":"false"},"xAxisTickColor":{"M":"Axes","T":"color","C":" Color for the tick lines in the X axis","D":"rgb(220,220,220)"},"transparency":{"M":"General","T":"float","C":" Percentage of transparency applied to all elements in the visualiztionss","D":"null"},"useSmpVarIndexOnClustering":{"M":"Clustering","T":"boolean","C":" Flag to indicate to use variable or sample index rather than names when clustering. This allows to use '(', ')' and ':' in the variable or sample name","D":"false"},"yAxisTickColor":{"M":"Axes","T":"color","C":" Color for the tick lines in the Y axis","D":"rgb(220,220,220)"},"zAxisTickColor":{"M":"Axes","T":"color","C":" Color for the tick lines in the Z axis","D":"rgb(220,220,220)"},"isAnimation":{"Z":"true","M":"Snapshots","T":"boolean","C":" Flag to indicate if there is an active animation"},"pieSegmentPrecision":{"M":"Pie Charts","T":"integer","C":" Number of decimals for values in the Pie charts","D":"0"},"layoutMulticolor":{"M":"Multiple graphs in a canvas","T":"boolean","C":" Flag to cycle colors when displaying multiple graps in the canvas. If set to false the color will be reseted for every graph.","D":"true"},"transformType":{"O":"false, log2, log10, exp2, exp10, percentile, zscore, ratio, ratio2, ratio10, save, reset, undo","M":"Data","T":"option","C":" Default transformation type.","D":"false"},"decorationScaleFontFactor":{"M":"Decorations","T":"float","C":" Scaling factor used to increse or decrease decoration font size in the canvas.","D":"1"},"timeValues":{"M":"Axes","T":"array","C":" Array containig the tick values when the the graph is a time series","D":"empty"},"previousButton":{"M":"Images","T":"image","C":" Relative path to an image file to the previous button (not including the image directory)","D":"rewind.png"},"panningY":{"M":"Zooming and Panning","T":"float","C":" Number of unit to pan the network in the Y dimension","D":"0"},"maxFeatureStringLen":{"M":"Genome","T":"integer","C":" Maximum length in characters a feature label can have so anything above is truncated.","D":"50"},"varTitleColor":{"M":"Variables","T":"color","C":" Font color for the variable titles in one dimensional plots","D":"foreground color"},"yAxis":{"M":"Axes","T":"array","C":" Indices for the samples groups or variables to be displayed in the Y axis","D":"empty"},"sizeBy":{"M":"Scatter Plots","T":"string","C":" Name of a variable annotation or a sample name or the string 'variable' to size the variables.","D":"false"},"setMinX":{"M":"Axes","T":"float","C":" Minimum value to set the data in the X axis","D":"null"},"featureTranslateShow":{"M":"Genome","T":"boolean","C":" Flag use to show tranlation","D":"true"},"varTitleFont":{"Z":"true","M":"Variables","T":"font","C":" Font for the variable titles in one dimensional plots"},"preScaleNetwork":{"M":"Networks","T":"boolean","C":" Flag to prescale or not the network. This is a aesthetic parameter to make the graph look nicer... Sometimes...","D":"false"},"randomDataMean":{"M":"Data","T":"integer","C":" Mean value when creating random data","D":"100"},"isHistogram":{"M":"2D Scatter Plot","T":"boolean","C":" Flag to convert the 2D scatter plot into a histogram. That is, the points in the scatter plot are converted to bars that start at the bottom of the Y axis. It is useful to represent proteomics spectra or histograms.","D":"false"},"smpLabelScaleFontFactor":{"M":"Samples","T":"float","C":" Scaling factor used to increse or decrease sample label font size in the canvas.","D":"1"},"dragAreaColor":{"M":"Events","T":"color","C":" Color for the div displayed when mouse is dragged over the graph to zoom in the canvas","D":"rgb(208,222,240)"},"xRotate":{"M":"3D Scatter Plot and Networks","T":"float","C":" Number of degrees to rotate graph arround the X axis","D":"45"},"weight":{"Z":"true","M":"Multiple graphs in a canvas","T":"float","C":" Fraction of the canvas to be used (a value between 0 and 1). Used when multiple graphs are displayed in one canvas. Could be an number or an array of numbers."},"debug":{"M":"Debug","T":"boolean","C":" Flag to turn on alerts.","D":"true"},"indicatorCenter":{"O":"white, black, rainbow, rainbow-red, rainbow-green","M":"Heatmaps and Correlations","T":"option","C":" Color for the center of the heatmap indicator. If rainbow-red is specified the order of the colors to generate the gradient will be: red - blue - green. If rainbow-green is specified then the order of the colors to generate the gradient will be: green - blue - red. The option rainbow is an alias for rainbow-red.","D":"white"},"showLegend":{"M":"Legends","T":"boolean","C":" Flag to show or not the legend in the graphs","D":"true"},"histogramBins":{"M":"2D Scatter Plot","T":"integer","C":" Number of bins in histogram","D":"20"},"citation":{"S":"citationColor","M":"Title, Subtitles and References","T":"string","C":" A reference citation of the graph which is placed at the bottom right corner","D":"false"},"smpSort":{"Z":"true","M":"Data","T":"integer","C":" Sample index used in sorting the data."},"yAxisTickStyle":{"O":"solid, dotted","M":"Axes","T":"option","C":" Style for the tick lines in the Y axis","D":"solid"},"showAnimation":{"M":"Animation","T":"boolean","C":" Flag to show or not animation for the graphs","D":"false"},"networkFreeze":{"M":"Networks","T":"boolean","C":" Flag to prevent autoscaling for the network layout.","D":"false"},"varTitle":{"M":"Variables","T":"integer","C":" Title for the sample axis in one dimensional plots","D":"10"},"networkFreezeOnLoad":{"M":"Networks","T":"boolean","C":" Flag to prevent autoscaling for the network layout after loading.","D":"false"},"stockIndicators":{"O":"Sma5, Sma10, Sma20, Sma25, Sma50","M":"Candlestick","T":"array","C":" Stock technical indicators","D":"empty"},"layoutTime":{"M":"Networks","T":"integer","C":" Time in milliseconds used to calculate the layout for the network","D":"15"},"xAxisAbsMax":{"Z":"true","M":"Axes","T":"float","C":" Maximum unfiltered value for the X axis"},"colorNodeBy":{"M":"Networks","T":"string","C":" Name of the attribute to color the nodes.","D":"false"},"isLogData":{"M":"Data","T":"boolean","C":" Flag to indicate if the data is Log transformed.","D":"false"},"tension":{"M":"Lines","T":"float","C":" Curvature for the splines","D":"0.3"},"showPieSampleLabel":{"M":"Pie Charts","T":"float","C":" A flag to show the sample label when plotting mutliple pies","D":"true"},"backgroundImage":{"S":"backgroundType","M":"General","T":"url","C":" Url for the background image","D":"false"},"axisTickColor":{"M":"Ticks and Titles","T":"color","C":" Color for the axis ticks in one and two dimensional plots","D":"foregroung color"},"resizerAreaColorOutlineCurrent":{"M":"Axis Resizer","T":"color","C":" Color for the div that shows up the current area selected in the axes in the canvas","D":"rgb(153,187,232)"},"minTextSize":{"M":"Text","T":"integer","C":" Minimum size for any text in the canvas.","D":"4"},"zRotate":{"M":"3D Scatter Plot and Networks","T":"float","C":" Number of degrees to rotate graph arround the Z axis","D":"0"},"isBoxPlotCalc":{"Z":"true","M":"Data","T":"boolean","C":" Flag to indicate if the iqr has been calculated if the graph type is Boxplot."},"remoteDirection":{"O":"next, prev","M":"Remote Procedures","T":"option","C":" Direction parameter used to obtain data remotely.","D":"next"},"pieSegmentSeparation":{"M":"Pie Charts","T":"integer","C":" Length in pixels for the separation of the pieces of the pie charts","D":"3"},"blockFactor":{"M":"One dimentional plots","T":"float","C":" Factor to adjust the size of the bars or dots in the graphs. The default is 1. If you want to make the bars or dots wider then increse this parameter (2 is twice as big).","D":"1"},"featureWidthDefault":{"M":"Genome","T":"integer","C":" Default size in pixels of the feature width","D":"3"},"timeTicksFirst":{"M":"Axes","T":"boolean","C":" Flag to indicate whether to use the first date on a time graph or the last","D":"false"},"remoteParams":{"M":"Remote Procedures","T":"object","C":" Object to hold parameters used to obtain data remotely. The target property will be always added to the method as well as the direction [next|prev] (see below.","D":"{}"},"dotLength":{"M":"Attributes","T":"integer","C":" Size in pixels of the length between dots in the doted lines.","D":"5"},"zAxisMinorValues":{"M":"Axes","T":"array","C":" Values for the minor ticks in the Z axis","D":"empty"},"smpHighlightColor":{"M":"Highlight","T":"color","C":" The color for the higlighted samples.","D":"rgb(255,0,0)"},"network2DRotate":{"Z":"true","M":"Networks","T":"integer","C":" Number of degrees to rotate network arround the X axis"},"arrowPointSize":{"M":"Attributes","T":"integer","C":" Size in pixels of the arrow head in arrow lines.","D":"10"},"yAxisValues":{"M":"Axes","T":"array","C":" Values for the ticks in the Y axis","D":"empty"},"sma25Color":{"M":"Candlestick","T":"color","C":" The color for the 25 day single moving average","D":"rgb(255,0,255)"},"titleColor":{"S":"subtitle, subtitleHeight","M":"Title, Subtitles and References","T":"color","C":" Color for the subtitle","D":"rgb(0,0,0)"},"setMax2":{"M":"Axes","T":"float","C":" Maximum value to set the data in the 2nd axis","D":"null"},"setMax":{"M":"Axes","T":"float","C":" Maximum value to set the data","D":"null"},"showVariableNames":{"M":"Variables","T":"boolean","C":" Flag to show the variable names in one dimensional plots","D":"true"},"tickRotate":{"M":"Ticks and Titles","T":"integer","C":" Rotation for graph ticks in degrees. It could be positive or negative.","D":"0"},"lineTickness":{"M":"Lines","T":"float","C":" Thickness in pixels for line plots","D":"1"},"decorationFontSize":{"M":"Decorations","T":"font","C":" Font size for the decorations in scatter plots and network graphs","D":"10"},"networkLayoutType":{"O":"forceDirected, organic, radial","M":"Networks","T":"option","C":" Type of network layout.","D":"forceDirected"},"zoom":{"M":"Zooming and Panning","T":"float","C":" Zoom factor for the networks. A number greater than zero","D":"1"},"initialTemperature":{"M":"Networks","T":"integer","C":" Initial temperature to limit displacement at later stages of forceDirected and organic layouts. A value based on the number of node and edges will be assigned if not specified","D":"0"},"citationFont":{"Z":"true","M":"Title, Subtitles and References","T":"font","C":" Font for the reference citation"},"fontSize":{"M":"Text","T":"integer","C":" Font size for text in complex plot only. See other categories to modify specific font sizes.","D":"12"},"legendBackgroundColor":{"S":"legendBox","M":"Legends","T":"color","C":" Color for the legend background","D":"background color"},"overlayScaleFontFactor":{"M":"Overlays","T":"float","C":" Scaling factor used to increse or decrease overlays font size in the canvas in one dimensional plots","D":"1"},"imageDir":{"M":"Images","T":"url","C":" Relative path to a directory contaioning images","D":"http://canvasxpress.org/images/"},"showNetworkNodesLegend":{"M":"Networks","T":"boolean","C":" Flag to show node legends in the networks","D":"true"},"animationTime":{"M":"Animation","T":"integer","C":" Time in milliseconds to wait between rendering the plot when showing the animation.","D":"30"},"shadowBlur":{"S":"showShadow","M":"General","T":"integer","C":" Amount in blur for the shadow.","D":"2"},"varTitleLabelOverlayPosition":{"O":"botom, top","M":"Variables","T":"option","C":" Position for variable labels in heatmaps","D":"bottom"},"remoteAutoPlay":{"M":"Remote Procedures","T":"boolean","C":" Flag to iterate over remote data sets","D":"false"},"layoutMaxVarLegend":{"Z":"true","M":"Multiple graphs in a canvas","T":"integer","C":" Maximum length of legend when multiple graphs are displayed in the canvas."},"attractiveForceFunction":{"O":"Eades, FruchtermanReingold","M":"Networks","T":"option","C":" Type of function to apply when calculating attractive force in forceDirected network layouts","D":"FruchtermanReingold"},"rotationStep":{"M":"3D Scatter Plot and Networks","T":"integer","C":" Number of degrees used when the plot is automatically rotated","D":"2"},"xAxis2Ticks":{"M":"Axes","T":"integer","C":" Number of ticks in the 2nd X axis","D":"5"},"layoutCurrent":{"Z":"true","M":"Multiple graphs in a canvas","T":"integer","C":" Integer to identify the current graph being displayed in the canvas."},"sizeNodeBy":{"M":"Networks","T":"string","C":" Name of the attribute to size the nodes.","D":"false"},"overlayFontColor":{"M":"Overlays","T":"color","C":" Color for the overlays in one dimensional plots","D":"foregroung color"},"graphType":{"O":"Bar, Line, Area, AreaLine, BarLine, Boxplot, Dotplot, Heatmap, Candlestick, Stacked, StackedLine, StackedPercent, StackedPercentLine, Scatter2D, ScatterBubble2D, Scatter3D, Correlation, Pie, Venn, Network, Genome","M":"General","T":"option","C":" Type of graph","D":"Bar"},"snapshotCopyChangeOnly":{"M":"Animation","T":"boolean","C":" Flag to indicate whether to copy all or only the changed attributes in the network animation. This optimizes memory usage for snapshots.","D":"true"},"axisTickFontSize":{"S":"autoScaleFont, tickScaleFontFactor","M":"Ticks and Titles","T":"integer","C":" Font size for the axis ticks in one and two dimensional plots. Be aware that auto scaling font must be turned off for this property to take effect. A more convenient way to modify the size is to use the tick scaling factor","D":"10"},"distance":{"O":"euclidian, manhattan, max","M":"Clustering","T":"option","C":" Distance metric to use when clustering data.","D":"euclidian"},"sequenceGColor":{"M":"Genome","T":"color","C":" Color for the guanines in the genome browser","D":"rgb(0,255,0)"},"featureSignalToNoiseShow":{"M":"Genome","T":"boolean","C":" Flag use to show quality","D":"true"},"xAxisMinorTicks":{"M":"Axes","T":"boolean","C":" A flag to show minor tick lines in the X axis","D":"true"},"legendPosition":{"O":"right, bottom","M":"Legends","T":"option","C":" Position for the legend in the graphs","D":"right"},"dashLength":{"M":"Attributes","T":"integer","C":" Size in pixels of the length of the dashes and the separation between the dashes in the dashed lines.","D":"8"},"zAxisTitle":{"M":"Axes","T":"string","C":" Title for the Z axis","D":"false"},"layout":{"M":"Multiple graphs in a canvas","T":"string","C":" Topology of the canvas. Number of rows and columns.","D":"1X1"},"groupingFactors":{"M":"Data","T":"array","C":" An array that holds the group names used for grouping the data. It must be a category in the 'data.x' object","D":"[]"},"marginBottom":{"M":"General","T":"integer","C":" Length in pixels for the bottom margin in the canvas","D":"0"},"configuratorWidth":{"M":"Events","T":"integer","C":" Size in pixels for the configurator.","D":"300"},"showPieValues":{"M":"Pie Charts","T":"float","C":" A flag to show the values for the pie","D":"true"},"smpTitleFontSize":{"M":"Samples","T":"integer","C":" Size for the sample title in one dimensional plots","D":"10"},"edgeConfigurableProperties":{"M":"Networks","T":"array","C":" Edge configurable properties","D":"['width','cap','exact','type']","E":"width:[integer];Pixel width for the edges between nodes;[],cap:[butt|round|square];Type of cap for the edgeline;[capType],exact:[boolean];Flag to indicate to create the edge between nodes without substracting the size of the nodes;[],type:[string];Type of line use to join the nodes;[lines]"},"decorationsColor":{"M":"Decorations","T":"color","C":" Color for the decorations in scatter plots and network graphs","D":"foreground color"},"translateX":{"Z":"true","M":"Multiple graphs in a canvas","T":"float","C":" Amount to translate for the X axis."},"networkRoot":{"M":"Networks","T":"string","C":" Node Id of the network root.","D":"false"},"varOverlays":{"M":"Overlays","T":"array","C":" Variable annotations included in the 'data.z' object used in one dimensional plots","D":"empty"},"freezeRowTop":{"M":"Data table","T":"integer","C":" Number of rows to freeze at the top of the data table","D":"0"},"nodeHighlightColor":{"M":"Highlight","T":"color","C":" The color for the highlighted nodes.","D":"rgb(255,0,0)"},"oddColor":{"M":"Attributes","T":"color","C":" The color for the odd numbers in samples or sequences","D":"background color"},"capType":{"O":"butt, round, square","M":"Attributes","T":"option","C":" Default type of cap for lines.","D":"butt"},"remoteUpdating":{"Z":"true","M":"Remote Procedures","T":"boolean","C":" Flag to indicate that updating data is in progress"},"foreground":{"M":"General","T":"color","C":" Foreground color for the canvas","D":"rgb(0,0,0)"},"showAnimationFontColor":{"M":"Animation","T":"color","C":" Color for the animation text","D":"background color"},"rowHeight":{"M":"Data table","T":"integer","C":" Mumber of pixels for the height of cells in the data table","D":"100"},"blockSeparationFactor":{"M":"One dimentional plots","T":"float","C":" Factor to adjust the spacing between the bars or dots in the graphs. The default is 1. If you want to make the bars or dots wider apart then increse this parameter (2 is twice as much)","D":"1"},"canvasBox":{"S":"canvasBoxColor","M":"General","T":"boolean","C":" Flag to create a box around the canvas","D":"true"},"scatterType":{"O":"false, line, bar, image, lineImage","M":"Scatter Plots","T":"option","C":" Type of scatter plot","D":"false"},"randomNetwork":{"M":"Networks","T":"boolean","C":" Flag to create or not random network for debug and demonstraion purposes","D":"false"},"layoutWidth":{"Z":"true","M":"Multiple graphs in a canvas","T":"float","C":" Width of the current segment of the canvas when there are multiple graphs."},"featureQualityValues":{"M":"Genome","T":"boolean","C":" Flag use to show values for the quality","D":"false"},"dendrogramHang":{"M":"Dendrograms","T":"boolean","C":" Flag to show or not the nodes in the dendrogram as hanging or not similar to that one in R","D":"false"},"resizerPosition":{"O":"top, rigth, bottom, left","M":"Axis Resizer","T":"option","C":" Position for the axis resizer in complex plots","D":"bottom"},"repulsiveForceFunction":{"O":"square, log, pow, sqrt","M":"Networks","T":"option","C":" Type of function to apply when calculating repulsive force in forceDirected network layouts","D":"square"},"histogramBarWidth":{"M":"2D Scatter Plot","T":"float","C":" Length in pixels for half of the bar width in the 2D sccaterplot histogram","D":"0.5"},"vennGroups":{"M":"Venn Diagrams","T":"integer","C":" Number of groups in the Venn diagram","D":"4"},"zAxis":{"M":"Axes","T":"array","C":" Indices for the samples groups or variables to be displayed in the Z axis","D":"empty"},"correlationAxis":{"O":"samples, variables","M":"Correlation","T":"option","C":" Axis used for the correlation.","D":"samples"},"zAxisTransformTicks":{"M":"Axes","T":"boolean","C":" Flag to transform the values of the ticks in the Z axis","D":"true"},"lineType":{"O":"rect, spline","M":"Lines","T":"option","C":" Type of line used to join the points in line graphs","D":"rect"},"shadowOffsetX":{"S":"showShadow","M":"General","T":"integer","C":" Length in pixels for the shadow offset in the X axis.","D":"3"},"zscoreAxis":{"O":"samples, variables","M":"Data","T":"option","C":" Default axis to use to zsore the data.","D":"samples"},"featureStaggered":{"M":"Genome","T":"boolean","C":" Flag use to stagger the features in the genome panel","D":"false"},"decorationsWidth":{"M":"Decorations","T":"integer","C":" Length in pixels of the width for the decorations in the networks","D":"10"},"xAxisTicks":{"M":"Axes","T":"integer","C":" Number of ticks in the X axis","D":"5"},"setMaxY":{"M":"Axes","T":"float","C":" Maximum value to set the data in the Y axis","D":"null"},"maxPieSectors":{"M":"Pie Charts","T":"float","C":" Max pie sectors. After that number the sectors will be put in a sector named 'other'.","D":"20"},"yAxisAbsMax":{"Z":"true","M":"Axes","T":"float","C":" Maximum unfiltered value for the Y axis"},"xAxisAbsMin":{"Z":"true","M":"Axes","T":"float","C":" Minimum unfiltered value for the X axis"},"legendFontSize":{"S":"autoScaleFont, legendScaleFontFactor","M":"Legends","T":"integer","C":" Font size for the legends. Be aware that auto scaling font must be turned off for this property to take effect. A more convenient way to modify the size is to use the legend scaling factor","D":"10"},"randomDataSamples":{"M":"Data","T":"integer","C":" Default number of samples when creating random data","D":"50"},"indicatorHeight":{"M":"Heatmaps and Correlations","T":"integer","C":" Length in pixels for the heatmap indicator","D":"8"},"networkForceConstant":{"M":"Networks","T":"float","C":" Constant used for calculating attractive and repulsive forces in forcedDirected and organic layouts. A value based on the average area per node will be assigned if not specified","D":"0"},"marginLeft":{"M":"General","T":"integer","C":" Length in pixels for the left margin in the canvas","D":"0"},"xAxis2":{"M":"Axes","T":"array","C":" Indices for the samples groups or variables to be displayed in the 2nd X axis","D":"empty"},"layoutComb":{"M":"Multiple graphs in a canvas","T":"boolean","C":" Flag that identify that multiple graphs will be displayed in the canvas.","D":"false"},"selectedBackgroundColor":{"M":"Events","T":"color","C":" Color for the selected objects in the canvas","D":"rgb(208,222,240)"},"broadcast":{"M":"Events","T":"boolean","C":" Flag to enable broadcasting to other canvasXpress objects in the page","D":"true"},"yAxisTitle":{"M":"Axes","T":"string","C":" Title for the Y axis","D":"false"},"networkShowDataTable":{"O":"nodes, edges","M":"Data table","T":"option","C":" Show nodes or edges on data table","D":"nodes"},"vennColors":{"M":"Venn Diagrams","T":"array","C":" Colors for the Venn bubles.","D":"false"},"eventKeys":{"M":"Events","T":"boolean","C":" Flag to enable key binding events. This prevent some default browser shortcuts and it is system specific. Please see the Event section bellow.","D":"true"},"yRotate":{"M":"3D Scatter Plot and Networks","T":"float","C":" Number of degrees to rotate graph arround the Y axis","D":"0"},"scaleX":{"Z":"true","M":"Multiple graphs in a canvas","T":"float","C":" Scale factor for the X axis"},"featureTraceTrim":{"M":"Genome","T":"integer","C":" Default triming for nucleotide values in the traces (expressed in percent)","D":"1"},"overlaysWidth":{"M":"Overlays","T":"integer","C":" Length in pixels of the width for the colored boxes to clasify samples and or variables in one dimensional plots","D":"30"},"smpTitleFont":{"Z":"true","M":"Samples","T":"font","C":" Font for the sample title in one dimensional plots"},"this":{"Z":"true","M":"Events","T":"time","C":" Time in milliseconds to keep track of time"},"gradientType":{"S":"gradient","O":"linear, radial","M":"General","T":"option","C":" Type of patern used for the gradients applied to all elements in the visualizations","D":"radial"},"nextButton":{"M":"Images","T":"image","C":" Relative path to an image file to the next button (not including the image directory)","D":"fast_forward.png"},"resizerType":{"O":"false, samples, box","M":"Axis Resizer","T":"option","C":" String to indicate the type of axis resizer in complex plots","D":"false"},"sequenceCColor":{"M":"Genome","T":"color","C":" Color for the cytosines in the genome browser","D":"rgb(0,255,255)"},"allVsAll":{"M":"2D Scatter Plot","T":"boolean","C":" Flag to plot an n-1 x n-1 matrix of 2D sccaterplots","D":"false"},"showDataValues":{"M":"Bars","T":"boolean","C":" Flag to indicate whether to show data values in the one bar graphs.","D":"false"},"segregateVariablesBy":{"O":"false, string","M":"Data","T":"option","C":" String to indicate the annotation used to segregate the variables. It must be a category in the 'data.z' object","D":"false"},"scaleVarTitleFontFactor":{"M":"Variables","T":"float","C":" Scaling factor used to increse or decrease variable font size in the canvas.","D":"1"},"featureTracesShow":{"M":"Genome","T":"boolean","C":" Flag use to show traces","D":"true"},"decorationsColors":{"M":"Decorations","T":"array","C":" Array of colors used for selection in network decorations not to be confused by its singular form 'decorationsColor' above","D":"[]"},"zAxisAbsMax":{"Z":"true","M":"Axes","T":"float","C":" Maximum unfiltered value for the Z axis"},"isMarketSwitched":{"Z":"true","M":"Data","T":"boolean","C":" Flag to indicate if the data is a Candlestick."},"imputeMethod":{"O":"mean, median","M":"Clustering","T":"option","C":" Imputation method for missing data when clustering","D":"mean"},"randomMissingDataPercentage":{"M":"Data","T":"integer","C":" Default percentege of missing values when creating random data","D":"0"},"yAxisMaxStrLength":{"Z":"true","M":"Axes","T":"string","C":" Longest string for ticks in the Y axis"},"showSmpDendrogram":{"M":"Dendrograms","T":"boolean","C":" Flag to show or not the sample dendrogram","D":"false"},"smpHairline":{"O":"false, solid, dotted","M":"One dimentional plots","T":"option","C":" This is a thin line that appears in the middle of the bar graphs just for aesthetics.","D":"dotted"},"highlightVar":{"M":"Highlight","T":"array","C":" Name of variables in the 'data.y' object to highlight.","D":"[]"},"resizerAreaColorCurrent":{"M":"Axis Resizer","T":"color","C":" Color for the div that shows up the current area selected in the axes in the canvas","D":"rgb(153,187,232)"},"disableEvents":{"M":"Events","T":"boolean","C":" Flag to disable all events.","D":"false"},"fontStyle":{"O":"false, bold, italic","M":"Text","T":"option","C":" Font style. Not implemented yet.","D":"false"},"showVarDendrogram":{"M":"Dendrograms","T":"boolean","C":" Flag to show or not the variable dendrogram","D":"false"},"freezeColRight":{"M":"Data table","T":"integer","C":" Number of columns to freeze in the right side of the data table","D":"0"},"modelEvent":{"O":"global, local","M":"Events","T":"option","C":" Model to handle the events. Experimental","D":"global"},"featrureCoordinateHeight":{"M":"Genome","T":"integer","C":" Default size in pixels of the coordinates height","D":"12"},"showVolume":{"M":"Candlestick","T":"boolean","C":" Flag to show or not volume in the candlestick graphs","D":"true"},"pieType":{"O":"separated, solid","M":"Pie Charts","T":"option","C":" Position for the pices of the pie","D":"separated"},"fonts":{"Z":"true","M":"Text","T":"array","C":" Font name. It will be set depending on the browser. It could be Optimer, Helvetiker, Gentilis or Verdana, sans-serif"},"sma10Color":{"M":"Candlestick","T":"color","C":" The color for the 5 day single moving average","D":"rgb(0,255,0)"},"remoteDataIndex":{"Z":"true","M":"Remote Procedures","T":"integer","C":" Index of the canvasXpress object requested"},"smpLabelColor":{"M":"Samples","T":"color","C":" Font color for the sample labels in one dimensional plots","D":"foreground color"},"showDecorations":{"M":"Decorations","T":"boolean","C":" Flag to show or not extra decorations like (regression lines, splines, etc) in scatter plots and (heatmaps, pie charts or stacked bar graphs in) network graphs","D":"false"},"gradientOrientation":{"S":"backgroundType","O":"vertical, horizontal","M":"General","T":"option","C":" The orientation for the gradient if the background type is windowGradient or windowGradient2.","D":"vertical"},"refresehDataTableOnDraw":{"M":"Data table","T":"boolean","C":" Flag to indicate to refresh data after drawing the plot","D":"true"},"approximateNodePositions":{"M":"Networks","T":"boolean","C":" Flag to force approximate X, Y node positions.","D":"false"},"heatmapType":{"O":"blue, blue-green, blue-red, blue-yellow, blue-cyan, blue-purple, green, green-blue, green-red, green-yellow, green-cyan, green-purple, red, red-blue, red-green, red-yellow, red-cyan, red-purple, yellow, yellow-green, yellow-red, yellow-yellow, yellow-cyan, yellow-purple, cyan, cyan-green, cyan-red, cyan-cyan, cyan-cyan, cyan-purple, purple, purple-green, purple-red, purple-purple, purple-cyan, purple-purple","M":"Heatmaps and Correlations","T":"option","C":" Color shades for the heatmap. It could be red, blue, green, yellow, cyan, purple or any combination of two colors separated by a dash","D":"blue-red"},"smpTitleScaleFontFactor":{"M":"Samples","T":"integer","C":" Scaling factor used to increse or decrease sample title font size in the canvas","D":"1"},"xAxisTickStyle":{"O":"solid, dotted","M":"Axes","T":"option","C":" Style for the tick lines in the X axis","D":"solid"},"axisExact":{"M":"Axes","T":"boolean","C":" Flag to force exact values for the data","D":"false"},"varLabelFontSize":{"S":"autoScaleFont, varLabelScaleFontFactor","M":"Variables","T":"integer","C":" Size for the variable labels in one dimensional plots. Be aware that auto scaling font must be turned off for this property to take effect. A more convenient way to modify the size is to use the variable label scaling factor","D":"10"},"smpLabelFontSize":{"S":"autoScaleFont, smpLabelScaleFontFactor","M":"Samples","T":"integer","C":" Size for the sample labels in one dimensional plots. Be aware that auto scaling font must be turned off for this property to take effect. A more convenient way to modify the size is to use the sample label scaling factor","D":"10"},"maxRotate":{"M":"3D Scatter Plot and Networks","T":"float","C":" Maximum number of degrees to rotate graph arround axes","D":"false"},"selectDataPoint":{"Z":"true","M":"Scatter Plots","T":"array","C":" Ids of data points (in the data object) to select.","D":"[]"},"subtitle":{"S":"subtitleHeight, subtitleColor","M":"Title, Subtitles and References","T":"string","C":" Title of the graph.","D":"rgb(0,0,0)"},"animationType":{"O":"grow, spring, random","M":"Animation","T":"option","C":" Type of animation","D":"grow"},"sequenceAColor":{"M":"Genome","T":"color","C":" Color for the adenines in the genome browser","D":"rgb(255,255,0)"},"showErrorBars":{"M":"Data","T":"boolean","C":" Flag to indicate whether to show or not error bars in the graphs.","D":"true"},"xAxis2TickFormat":{"M":"Axes","T":"string","C":" Format for the tick values in the second X axis","D":"false"},"dataEvent":{"Z":"true","M":"Events","T":"array","C":" Array to store the areas that will trigger an event"},"highlightNode":{"M":"Highlight","T":"array","C":" Name of nodes in the 'data.nodes' object to highlight.","D":"[]"},"snapshots":{"Z":"true","M":"Snapshots","T":"array","C":" Array to hold the data used in the animation"},"colorEdgeBy":{"M":"Networks","T":"string","C":" Name of the attribute to color the edges.","D":"false"},"margin":{"M":"General","T":"integer","C":" Length in pixels for the distance between many areas in the graphs","D":"5"},"checkGoogleChromeFrame":{"M":"Debug","T":"boolean","C":" Flag to check for Google chrome frame if the browser is IE","D":"true"},"xAxisMaxStrLength":{"Z":"true","M":"Axes","T":"string","C":" Longest string for ticks in the X axis"}},"E":{"cap":{"O":"butt, round, square","M":"Network","T":"option","C":"Type of cap for the edgeline"},"width":{"M":"Network","T":"integer","C":"Pixel width for the edges between nodes"},"exact":{"M":"Network","T":"boolean","C":"Flag to indicate to create the edge between nodes without substracting the size of the nodes"},"type":{"M":"Network","T":"string","C":"Type of line use to join the nodes"}}}
