/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl.accessor;

import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import ognl.ClassResolver;
import ognl.MethodAccessor;
import ognl.MethodFailedException;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;

public class CompoundRootAccessor
implements PropertyAccessor,
MethodAccessor,
ClassResolver {
    private static final Logger LOG = LoggerFactory.getLogger(CompoundRootAccessor.class);
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static Map invalidMethods = new HashMap();
    static boolean devMode = false;

    public String getSourceAccessor(OgnlContext context, Object target, Object index) {
        return null;
    }

    public String getSourceSetter(OgnlContext context, Object target, Object index) {
        return null;
    }

    @Inject(value="devMode")
    public static void setDevMode(String mode) {
        devMode = "true".equals(mode);
    }

    public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
        CompoundRoot root = (CompoundRoot)target;
        OgnlContext ognlContext = (OgnlContext)context;
        for (Object o : root) {
            if (o == null) continue;
            try {
                if (OgnlRuntime.hasSetProperty(ognlContext, o, name)) {
                    OgnlRuntime.setProperty(ognlContext, o, name, value);
                    return;
                }
                if (!(o instanceof Map)) continue;
                Map map = (Map)o;
                try {
                    map.put(name, value);
                    return;
                }
                catch (UnsupportedOperationException e) {
                }
            }
            catch (IntrospectionException e) {}
        }
        Boolean reportError = (Boolean)context.get("com.opensymphony.xwork2.util.ValueStack.ReportErrorsOnNoProp");
        String msg = "No object in the CompoundRoot has a publicly accessible property named '" + name + "' (no setter could be found).";
        if (reportError != null && reportError.booleanValue()) {
            throw new XWorkException(msg);
        }
        if (devMode) {
            LOG.warn(msg, new String[0]);
        }
    }

    public Object getProperty(Map context, Object target, Object name) throws OgnlException {
        CompoundRoot root = (CompoundRoot)target;
        OgnlContext ognlContext = (OgnlContext)context;
        if (name instanceof Integer) {
            Integer index = (Integer)name;
            return root.cutStack(index);
        }
        if (name instanceof String) {
            if ("top".equals(name)) {
                if (root.size() > 0) {
                    return root.get(0);
                }
                return null;
            }
            for (Object o : root) {
                if (o == null) continue;
                try {
                    if (!OgnlRuntime.hasGetProperty(ognlContext, o, name) && (!(o instanceof Map) || !((Map)o).containsKey(name))) continue;
                    return OgnlRuntime.getProperty(ognlContext, o, name);
                }
                catch (OgnlException e) {
                    if (e.getReason() == null) continue;
                    String msg = "Caught an Ognl exception while getting property " + name;
                    throw new XWorkException(msg, e);
                }
                catch (IntrospectionException e) {
                }
            }
            return null;
        }
        return null;
    }

    public Object callMethod(Map context, Object target, String name, Object[] objects) throws MethodFailedException {
        CompoundRoot root = (CompoundRoot)target;
        if ("describe".equals(name)) {
            Object v = objects != null && objects.length == 1 ? objects[0] : root.get(0);
            if (v instanceof Collection || v instanceof Map || v.getClass().isArray()) {
                return v.toString();
            }
            try {
                Map descriptors = OgnlRuntime.getPropertyDescriptors(v.getClass());
                int maxSize = 0;
                for (String pdName : descriptors.keySet()) {
                    if (pdName.length() <= maxSize) continue;
                    maxSize = pdName.length();
                }
                TreeSet<String> set = new TreeSet<String>();
                StringBuffer sb = new StringBuffer();
                for (PropertyDescriptor pd : descriptors.values()) {
                    sb.append(pd.getName()).append(": ");
                    int padding = maxSize - pd.getName().length();
                    for (int i = 0; i < padding; ++i) {
                        sb.append(" ");
                    }
                    sb.append(pd.getPropertyType().getName());
                    set.add(sb.toString());
                    sb = new StringBuffer();
                }
                sb = new StringBuffer();
                Iterator<Object> i$ = set.iterator();
                while (i$.hasNext()) {
                    String aSet;
                    String s = aSet = (String)i$.next();
                    sb.append(s).append("\n");
                }
                return sb.toString();
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            catch (OgnlException e) {
                e.printStackTrace();
            }
            return null;
        }
        for (Object o : root) {
            if (o == null) continue;
            Class<?> clazz = o.getClass();
            Class[] argTypes = this.getArgTypes(objects);
            MethodCall mc = null;
            if (argTypes != null) {
                mc = new MethodCall(clazz, name, argTypes);
            }
            if (argTypes != null && invalidMethods.containsKey(mc)) continue;
            try {
                Object value = OgnlRuntime.callMethod((OgnlContext)context, o, name, name, objects);
                if (value == null) continue;
                return value;
            }
            catch (OgnlException e) {
                Throwable reason = e.getReason();
                if (mc != null && reason != null && reason.getClass() == NoSuchMethodException.class) {
                    invalidMethods.put(mc, Boolean.TRUE);
                    continue;
                }
                if (reason == null) continue;
                throw new MethodFailedException(o, name, e.getReason());
            }
        }
        return null;
    }

    public Object callStaticMethod(Map transientVars, Class aClass, String s, Object[] objects) throws MethodFailedException {
        return null;
    }

    public Class classForName(String className, Map context) throws ClassNotFoundException {
        Object root = Ognl.getRoot(context);
        try {
            if (root instanceof CompoundRoot && className.startsWith("vs")) {
                CompoundRoot compoundRoot = (CompoundRoot)root;
                if ("vs".equals(className)) {
                    return compoundRoot.peek().getClass();
                }
                int index = Integer.parseInt(className.substring(2));
                return compoundRoot.get(index - 1).getClass();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    private Class[] getArgTypes(Object[] args) {
        if (args == null) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] classes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            classes[i] = arg != null ? arg.getClass() : Object.class;
        }
        return classes;
    }

    static class MethodCall {
        Class clazz;
        String name;
        Class[] args;
        int hash;

        public MethodCall(Class clazz, String name, Class[] args) {
            this.clazz = clazz;
            this.name = name;
            this.args = args;
            this.hash = clazz.hashCode() + name.hashCode();
            for (Class arg : args) {
                this.hash += arg.hashCode();
            }
        }

        public boolean equals(Object obj) {
            MethodCall mc = (MethodCall)obj;
            return mc.clazz.equals(this.clazz) && mc.name.equals(this.name) && Arrays.equals(mc.args, this.args);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

