/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.jasper;

import com.opensymphony.xwork2.util.finder.ClassLoaderInterface;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.jasper.JasperException;
import org.apache.struts2.jasper.JspCompilationContext;
import org.apache.struts2.jasper.Options;
import org.apache.struts2.jasper.compiler.Compiler;
import org.apache.struts2.jasper.compiler.JspConfig;
import org.apache.struts2.jasper.compiler.JspRuntimeContext;
import org.apache.struts2.jasper.compiler.Localizer;
import org.apache.struts2.jasper.compiler.TagPluginManager;
import org.apache.struts2.jasper.compiler.TldLocationsCache;
import org.apache.struts2.jasper.servlet.JspCServletContext;
import org.apache.struts2.jasper.xmlparser.ParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspC
implements Options {
    public static final String DEFAULT_IE_CLASS_ID = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private Logger log;
    private static final String SWITCH_VERBOSE = "-v";
    private static final String SWITCH_HELP = "-help";
    private static final String SWITCH_QUIET = "-q";
    private static final String SWITCH_OUTPUT_DIR = "-d";
    private static final String SWITCH_IE_CLASS_ID = "-ieplugin";
    private static final String SWITCH_PACKAGE_NAME = "-p";
    private static final String SWITCH_CACHE = "-cache";
    private static final String SWITCH_CLASS_NAME = "-c";
    private static final String SWITCH_FULL_STOP = "--";
    private static final String SWITCH_COMPILE = "-compile";
    private static final String SWITCH_SOURCE = "-source";
    private static final String SWITCH_TARGET = "-target";
    private static final String SWITCH_URI_BASE = "-uribase";
    private static final String SWITCH_URI_ROOT = "-uriroot";
    private static final String SWITCH_FILE_WEBAPP = "-webapp";
    private static final String SWITCH_WEBAPP_INC = "-webinc";
    private static final String SWITCH_WEBAPP_XML = "-webxml";
    private static final String SWITCH_MAPPED = "-mapped";
    private static final String SWITCH_XPOWERED_BY = "-xpoweredBy";
    private static final String SWITCH_TRIM_SPACES = "-trimSpaces";
    private static final String SWITCH_CLASSPATH = "-classpath";
    private static final String SWITCH_DIE = "-die";
    private static final String SWITCH_POOLING = "-poolingEnabled";
    private static final String SWITCH_ENCODING = "-javaEncoding";
    private static final String SWITCH_SMAP = "-smap";
    private static final String SWITCH_DUMP_SMAP = "-dumpsmap";
    private static final String SHOW_SUCCESS = "-s";
    private static final String LIST_ERRORS = "-l";
    private static final int NO_WEBXML = 0;
    private static final int INC_WEBXML = 10;
    private static final int ALL_WEBXML = 20;
    private static final int DEFAULT_DIE_LEVEL = 1;
    private static final int NO_DIE_LEVEL = 0;
    private static final String[] insertBefore = new String[]{"</web-app>", "<servlet-mapping>", "<session-config>", "<mime-mapping>", "<welcome-file-list>", "<error-page>", "<taglib>", "<resource-env-ref>", "<resource-ref>", "<security-constraint>", "<login-config>", "<security-role>", "<env-entry>", "<ejb-ref>", "<ejb-local-ref>"};
    private static int die;
    private String classPath = null;
    private URLClassLoader loader = null;
    private boolean trimSpaces = false;
    private boolean genStringAsCharArray = false;
    private boolean xpoweredBy;
    private boolean mappedFile = false;
    private boolean poolingEnabled = true;
    private File scratchDir;
    private String ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private String targetPackage;
    private String targetClassName;
    private String uriBase;
    private int dieLevel;
    private boolean helpNeeded = false;
    private boolean compile = false;
    private boolean smapSuppressed = true;
    private boolean smapDumped = false;
    private boolean caching = true;
    private Map cache = new HashMap();
    private String compiler = null;
    private ClassLoaderInterface classLoaderInterface;
    private String compilerTargetVM = "1.4";
    private String compilerSourceVM = "1.4";
    private boolean classDebugInfo = true;
    private boolean failOnError = true;
    private List extensions;
    private List pages = new Vector();
    private boolean errorOnUseBeanInvalidClassAttribute = true;
    private String javaEncoding = "UTF-8";
    private String webxmlFile;
    private int webxmlLevel;
    private Writer mapout;
    private CharArrayWriter servletout;
    private CharArrayWriter mappingout;
    private JspCServletContext context;
    private JspRuntimeContext rctxt;
    private TldLocationsCache tldLocationsCache = null;
    private JspConfig jspConfig = null;
    private TagPluginManager tagPluginManager = null;
    private boolean verbose = false;
    private boolean listErrors = false;
    private boolean showSuccess = false;
    private int argPos;
    private boolean fullstop = false;
    private String[] args;
    private String sourceCode;

    public static void main(String[] arg) {
        block6: {
            if (arg.length == 0) {
                System.out.println(Localizer.getMessage("jspc.usage"));
            } else {
                try {
                    JspC jspc = new JspC();
                    jspc.setArgs(arg);
                    if (jspc.helpNeeded) {
                        System.out.println(Localizer.getMessage("jspc.usage"));
                    } else {
                        jspc.execute();
                    }
                }
                catch (JasperException je) {
                    System.err.println((Object)je);
                    if (die == 0) break block6;
                    System.exit(die);
                }
            }
        }
    }

    public JspC() {
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setClassLoaderInterface(ClassLoaderInterface classLoaderInterface) {
        this.classLoaderInterface = classLoaderInterface;
    }

    public void setArgs(String[] arg) throws JasperException {
        String file;
        String tok;
        this.args = arg;
        die = this.dieLevel = 0;
        while ((tok = this.nextArg()) != null) {
            if (tok.equals(SWITCH_VERBOSE)) {
                this.verbose = true;
                this.showSuccess = true;
                this.listErrors = true;
                continue;
            }
            if (tok.equals(SWITCH_OUTPUT_DIR)) {
                tok = this.nextArg();
                this.setOutputDir(tok);
                continue;
            }
            if (tok.equals(SWITCH_PACKAGE_NAME)) {
                this.targetPackage = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_COMPILE)) {
                this.compile = true;
                continue;
            }
            if (tok.equals(SWITCH_CLASS_NAME)) {
                this.targetClassName = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_BASE)) {
                this.uriBase = this.nextArg();
                continue;
            }
            if (tok.equals(SHOW_SUCCESS)) {
                this.showSuccess = true;
                continue;
            }
            if (tok.equals(LIST_ERRORS)) {
                this.listErrors = true;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_INC)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 10;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_XML)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 20;
                continue;
            }
            if (tok.equals(SWITCH_MAPPED)) {
                this.mappedFile = true;
                continue;
            }
            if (tok.equals(SWITCH_XPOWERED_BY)) {
                this.xpoweredBy = true;
                continue;
            }
            if (tok.equals(SWITCH_TRIM_SPACES)) {
                this.setTrimSpaces(true);
                continue;
            }
            if (tok.equals(SWITCH_CACHE)) {
                tok = this.nextArg();
                if ("false".equals(tok)) {
                    this.caching = false;
                    continue;
                }
                this.caching = true;
                continue;
            }
            if (tok.equals(SWITCH_CLASSPATH)) {
                this.setClassPath(this.nextArg());
                continue;
            }
            if (tok.startsWith(SWITCH_DIE)) {
                try {
                    this.dieLevel = Integer.parseInt(tok.substring(SWITCH_DIE.length()));
                }
                catch (NumberFormatException nfe) {
                    this.dieLevel = 1;
                }
                die = this.dieLevel;
                continue;
            }
            if (tok.equals(SWITCH_HELP)) {
                this.helpNeeded = true;
                continue;
            }
            if (tok.equals(SWITCH_POOLING)) {
                tok = this.nextArg();
                if ("false".equals(tok)) {
                    this.poolingEnabled = false;
                    continue;
                }
                this.poolingEnabled = true;
                continue;
            }
            if (tok.equals(SWITCH_ENCODING)) {
                this.setJavaEncoding(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_SOURCE)) {
                this.setCompilerSourceVM(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_TARGET)) {
                this.setCompilerTargetVM(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_SMAP)) {
                this.smapSuppressed = false;
                continue;
            }
            if (tok.equals(SWITCH_DUMP_SMAP)) {
                this.smapDumped = true;
                continue;
            }
            if (tok.startsWith("-")) {
                throw new JasperException("Unrecognized option: " + tok + ".  Use -help for help.");
            }
            if (this.fullstop) break;
            --this.argPos;
            break;
        }
        while ((file = this.nextFile()) != null) {
            this.pages.add(file);
        }
    }

    @Override
    public boolean getKeepGenerated() {
        return true;
    }

    @Override
    public boolean getTrimSpaces() {
        return this.trimSpaces;
    }

    public void setTrimSpaces(boolean ts) {
        this.trimSpaces = ts;
    }

    @Override
    public boolean isPoolingEnabled() {
        return this.poolingEnabled;
    }

    public void setPoolingEnabled(boolean poolingEnabled) {
        this.poolingEnabled = poolingEnabled;
    }

    @Override
    public boolean isXpoweredBy() {
        return this.xpoweredBy;
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.xpoweredBy = xpoweredBy;
    }

    @Override
    public boolean getErrorOnUseBeanInvalidClassAttribute() {
        return this.errorOnUseBeanInvalidClassAttribute;
    }

    public void setErrorOnUseBeanInvalidClassAttribute(boolean b) {
        this.errorOnUseBeanInvalidClassAttribute = b;
    }

    public int getTagPoolSize() {
        return 5;
    }

    @Override
    public boolean getMappedFile() {
        return this.mappedFile;
    }

    public Object getProtectionDomain() {
        return null;
    }

    @Override
    public boolean getSendErrorToClient() {
        return true;
    }

    public void setClassDebugInfo(boolean b) {
        this.classDebugInfo = b;
    }

    @Override
    public boolean getClassDebugInfo() {
        return this.classDebugInfo;
    }

    @Override
    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    @Override
    public Map getCache() {
        return this.cache;
    }

    @Override
    public int getCheckInterval() {
        return 0;
    }

    @Override
    public int getModificationTestInterval() {
        return 0;
    }

    @Override
    public boolean getDevelopment() {
        return false;
    }

    @Override
    public boolean isSmapSuppressed() {
        return this.smapSuppressed;
    }

    public void setSmapSuppressed(boolean smapSuppressed) {
        this.smapSuppressed = smapSuppressed;
    }

    @Override
    public boolean isSmapDumped() {
        return this.smapDumped;
    }

    public void setSmapDumped(boolean smapDumped) {
        this.smapDumped = smapDumped;
    }

    public void setGenStringAsCharArray(boolean genStringAsCharArray) {
        this.genStringAsCharArray = genStringAsCharArray;
    }

    @Override
    public boolean genStringAsCharArray() {
        return this.genStringAsCharArray;
    }

    public void setIeClassId(String ieClassId) {
        this.ieClassId = ieClassId;
    }

    @Override
    public String getIeClassId() {
        return this.ieClassId;
    }

    @Override
    public File getScratchDir() {
        return this.scratchDir;
    }

    public Class getJspCompilerPlugin() {
        return null;
    }

    public String getJspCompilerPath() {
        return null;
    }

    @Override
    public String getCompiler() {
        return this.compiler;
    }

    public void setCompiler(String c) {
        this.compiler = c;
    }

    @Override
    public String getCompilerTargetVM() {
        return this.compilerTargetVM;
    }

    public void setCompilerTargetVM(String vm) {
        this.compilerTargetVM = vm;
    }

    @Override
    public String getCompilerSourceVM() {
        return this.compilerSourceVM;
    }

    public void setCompilerSourceVM(String vm) {
        this.compilerSourceVM = vm;
    }

    @Override
    public TldLocationsCache getTldLocationsCache() {
        return this.tldLocationsCache;
    }

    @Override
    public String getJavaEncoding() {
        return this.javaEncoding;
    }

    public void setJavaEncoding(String encodingName) {
        this.javaEncoding = encodingName;
    }

    @Override
    public boolean getFork() {
        return false;
    }

    @Override
    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        return System.getProperty("java.class.path");
    }

    public void setClassPath(String s) {
        this.classPath = s;
    }

    public List getExtensions() {
        return this.extensions;
    }

    protected void addExtension(String extension) {
        if (extension != null) {
            if (this.extensions == null) {
                this.extensions = new Vector();
            }
            this.extensions.add(extension);
        }
    }

    public void setJspFiles(String jspFiles) {
        if (jspFiles == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(jspFiles, ",");
        while (tok.hasMoreTokens()) {
            this.pages.add(tok.nextToken());
        }
    }

    public void setCompile(boolean b) {
        this.compile = b;
    }

    public void setVerbose(int level) {
        if (level > 0) {
            this.verbose = true;
            this.showSuccess = true;
            this.listErrors = true;
        }
    }

    public void setValidateXml(boolean b) {
        ParserUtils.validating = b;
    }

    public void setListErrors(boolean b) {
        this.listErrors = b;
    }

    public void setOutputDir(String s) {
        this.scratchDir = s != null ? this.resolveFile(s).getAbsoluteFile() : null;
    }

    public void setPackage(String p) {
        this.targetPackage = p;
    }

    public void setClassName(String p) {
        this.targetClassName = p;
    }

    public void setWebXmlFragment(String s) {
        this.webxmlFile = this.resolveFile(s).getAbsolutePath();
        this.webxmlLevel = 10;
    }

    public void setWebXml(String s) {
        this.webxmlFile = this.resolveFile(s).getAbsolutePath();
        this.webxmlLevel = 20;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    @Override
    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    @Override
    public TagPluginManager getTagPluginManager() {
        return this.tagPluginManager;
    }

    public void generateWebMapping(String file, JspCompilationContext clctxt) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Generating web mapping for file " + file + " using compilation context " + clctxt, new String[0]);
        }
        String className = clctxt.getServletClassName();
        String packageName = clctxt.getServletPackageName();
        String thisServletName = "".equals(packageName) ? className : packageName + '.' + className;
        if (this.servletout != null) {
            this.servletout.write("\n    <servlet>\n        <servlet-name>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-name>\n        <servlet-class>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-class>\n    </servlet>\n");
        }
        if (this.mappingout != null) {
            this.mappingout.write("\n    <servlet-mapping>\n        <servlet-name>");
            this.mappingout.write(thisServletName);
            this.mappingout.write("</servlet-name>\n        <url-pattern>");
            this.mappingout.write(file.replace('\\', '/'));
            this.mappingout.write("</url-pattern>\n    </servlet-mapping>\n");
        }
    }

    private void processFile(String file) throws JasperException {
        block21: {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Processing file: " + file, new String[0]);
            }
            ClassLoader originalClassLoader = null;
            try {
                try {
                    if (this.scratchDir == null) {
                        String temp = System.getProperty("java.io.tmpdir");
                        if (temp == null) {
                            temp = "";
                        }
                        this.scratchDir = new File(new File(temp).getAbsolutePath());
                    }
                    String jspUri = file.replace('\\', '/');
                    JspCompilationContext clctxt = new JspCompilationContext(jspUri, false, (Options)this, (ServletContext)this.context, null, this.rctxt, this.classLoaderInterface);
                    if (this.targetClassName != null && this.targetClassName.length() > 0) {
                        clctxt.setServletClassName(this.targetClassName);
                        this.targetClassName = null;
                    }
                    if (this.targetPackage != null) {
                        clctxt.setServletPackageName(this.targetPackage);
                    }
                    originalClassLoader = Thread.currentThread().getContextClassLoader();
                    if (this.loader == null) {
                        this.initClassLoader(clctxt);
                    }
                    Thread.currentThread().setContextClassLoader(this.loader);
                    clctxt.setClassLoader(this.loader);
                    clctxt.setClassPath(this.classPath);
                    Compiler clc = clctxt.createCompiler();
                    if (clc.isOutDated(this.compile)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(jspUri + " is out dated, compiling...", new String[0]);
                        }
                        clc.compile(this.compile, true);
                    }
                    this.generateWebMapping(file, clctxt);
                    if (this.showSuccess) {
                        this.log.info("Built File: " + file, new String[0]);
                    }
                    this.sourceCode = clctxt.getSourceCode();
                }
                catch (JasperException je) {
                    Object rootCause = je;
                    while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                        rootCause = rootCause.getRootCause();
                    }
                    if (rootCause != je) {
                        this.log.error(Localizer.getMessage("jspc.error.generalException", file), (Throwable)rootCause, new String[0]);
                    }
                    if (this.getFailOnError()) {
                        throw je;
                    }
                    this.log.error(je.getMessage(), (Throwable)((Object)je), new String[0]);
                    Object var7_10 = null;
                    if (originalClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(originalClassLoader);
                    }
                    break block21;
                }
                catch (Exception e) {
                    if (e instanceof FileNotFoundException && this.log.isWarnEnabled()) {
                        this.log.warn(Localizer.getMessage("jspc.error.fileDoesNotExist", e.getMessage()), new String[0]);
                    }
                    throw new JasperException(e);
                }
                Object var7_9 = null;
                if (originalClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                if (originalClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
                throw throwable;
            }
        }
    }

    public Set<String> getTldAbsolutePaths() {
        return this.tldLocationsCache.getAbsolutePathsOfLocations();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws JasperException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("execute() starting for " + this.pages.size() + " pages.", new String[0]);
        }
        try {
            try {
                if (this.context == null) {
                    this.initServletContext();
                }
                this.initWebXml();
                Iterator iter = this.pages.iterator();
                while (iter.hasNext()) {
                    String string = iter.next().toString();
                    this.processFile(string);
                }
                this.completeWebXml();
            }
            catch (JasperException je) {
                void var2_5;
                JasperException jasperException = je;
                while (var2_5 instanceof JasperException && ((JasperException)var2_5).getRootCause() != null) {
                    Throwable throwable = ((JasperException)var2_5).getRootCause();
                }
                if (var2_5 == je) throw je;
                var2_5.printStackTrace();
                throw je;
            }
            Object var4_7 = null;
            if (this.loader == null) return;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (this.loader == null) throw throwable;
            LogFactory.release((ClassLoader)this.loader);
            throw throwable;
        }
        LogFactory.release((ClassLoader)this.loader);
    }

    private String nextArg() {
        if (this.argPos >= this.args.length || (this.fullstop = SWITCH_FULL_STOP.equals(this.args[this.argPos]))) {
            return null;
        }
        return this.args[this.argPos++];
    }

    private String nextFile() {
        if (this.fullstop) {
            ++this.argPos;
        }
        if (this.argPos >= this.args.length) {
            return null;
        }
        return this.args[this.argPos++];
    }

    private void initWebXml() {
        try {
            if (this.webxmlLevel >= 10) {
                File fmapings = new File(this.webxmlFile);
                this.mapout = new FileWriter(fmapings);
                this.servletout = new CharArrayWriter();
                this.mappingout = new CharArrayWriter();
            } else {
                this.mapout = null;
                this.servletout = null;
                this.mappingout = null;
            }
            if (this.webxmlLevel >= 20) {
                this.mapout.write(Localizer.getMessage("jspc.webxml.header"));
                this.mapout.flush();
            } else if (this.webxmlLevel >= 10) {
                this.mapout.write(Localizer.getMessage("jspc.webinc.header"));
                this.mapout.flush();
            }
        }
        catch (IOException ioe) {
            this.mapout = null;
            this.servletout = null;
            this.mappingout = null;
        }
    }

    private void completeWebXml() {
        if (this.mapout != null) {
            try {
                this.servletout.writeTo(this.mapout);
                this.mappingout.writeTo(this.mapout);
                if (this.webxmlLevel >= 20) {
                    this.mapout.write(Localizer.getMessage("jspc.webxml.footer"));
                } else if (this.webxmlLevel >= 10) {
                    this.mapout.write(Localizer.getMessage("jspc.webinc.footer"));
                }
                this.mapout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void initServletContext() {
        this.context = new JspCServletContext(new PrintWriter(System.out), this.classLoaderInterface);
        this.tldLocationsCache = new TldLocationsCache(this.context, true);
        this.rctxt = new JspRuntimeContext(this.context, this);
        this.jspConfig = new JspConfig(this.context);
        this.tagPluginManager = new TagPluginManager(this.context);
    }

    private void initClassLoader(JspCompilationContext clctxt) throws IOException {
        this.classPath = this.getClassPath();
        ClassLoader jspcLoader = this.getClass().getClassLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(this.classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            try {
                File libFile = new File(path);
                urls.add(libFile.toURL());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
        URL[] urlsA = new URL[urls.size()];
        urls.toArray(urlsA);
        this.loader = new URLClassLoader(urlsA, this.getClass().getClassLoader());
    }

    protected File resolveFile(String s) {
        return new File(s);
    }
}

