/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.io.IOException;
import org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.HexDump;

public final class HSSFObjectData {
    private ObjRecord record;
    private POIFSFileSystem poifs;

    public HSSFObjectData(ObjRecord record, POIFSFileSystem poifs) {
        this.record = record;
        this.poifs = poifs;
    }

    public String getOLE2ClassName() {
        return this.findObjectRecord().getOLEClassName();
    }

    public DirectoryEntry getDirectory() throws IOException {
        EmbeddedObjectRefSubRecord subRecord = this.findObjectRecord();
        int streamId = subRecord.getStreamId();
        String streamName = "MBD" + HexDump.toHex(streamId);
        Entry entry = this.poifs.getRoot().getEntry(streamName);
        if (entry instanceof DirectoryEntry) {
            return (DirectoryEntry)entry;
        }
        throw new IOException("Stream " + streamName + " was not an OLE2 directory");
    }

    public byte[] getObjectData() {
        return this.findObjectRecord().getObjectData();
    }

    public boolean hasDirectoryEntry() {
        EmbeddedObjectRefSubRecord subRecord = this.findObjectRecord();
        Integer streamId = subRecord.getStreamId();
        return streamId != null && streamId != 0;
    }

    protected EmbeddedObjectRefSubRecord findObjectRecord() {
        for (Object subRecord : this.record.getSubRecords()) {
            if (!(subRecord instanceof EmbeddedObjectRefSubRecord)) continue;
            return (EmbeddedObjectRefSubRecord)subRecord;
        }
        throw new IllegalStateException("Object data does not contain a reference to an embedded object OLE2 directory");
    }
}

