/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.ss.usermodel.Font;

public final class HSSFFont
implements Font {
    private FontRecord font;
    private short index;

    protected HSSFFont(short index, FontRecord rec) {
        this.font = rec;
        this.index = index;
    }

    public void setFontName(String name) {
        this.font.setFontName(name);
    }

    public String getFontName() {
        return this.font.getFontName();
    }

    public short getIndex() {
        return this.index;
    }

    public void setFontHeight(short height) {
        this.font.setFontHeight(height);
    }

    public void setFontHeightInPoints(short height) {
        this.font.setFontHeight((short)(height * 20));
    }

    public short getFontHeight() {
        return this.font.getFontHeight();
    }

    public short getFontHeightInPoints() {
        return (short)(this.font.getFontHeight() / 20);
    }

    public void setItalic(boolean italic) {
        this.font.setItalic(italic);
    }

    public boolean getItalic() {
        return this.font.isItalic();
    }

    public void setStrikeout(boolean strikeout) {
        this.font.setStrikeout(strikeout);
    }

    public boolean getStrikeout() {
        return this.font.isStruckout();
    }

    public void setColor(short color) {
        this.font.setColorPaletteIndex(color);
    }

    public short getColor() {
        return this.font.getColorPaletteIndex();
    }

    public void setBoldweight(short boldweight) {
        this.font.setBoldWeight(boldweight);
    }

    public short getBoldweight() {
        return this.font.getBoldWeight();
    }

    public void setTypeOffset(short offset) {
        this.font.setSuperSubScript(offset);
    }

    public short getTypeOffset() {
        return this.font.getSuperSubScript();
    }

    public void setUnderline(byte underline) {
        this.font.setUnderline(underline);
    }

    public byte getUnderline() {
        return this.font.getUnderline();
    }

    public byte getCharSet() {
        return this.font.getCharset();
    }

    public void setCharSet(byte charset) {
        this.font.setCharset(charset);
    }

    public String toString() {
        return "org.apache.poi.hssf.usermodel.HSSFFont{" + this.font + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof HSSFFont) {
            HSSFFont other = (HSSFFont)obj;
            if (this.font == null ? other.font != null : !this.font.equals(other.font)) {
                return false;
            }
            return this.index == other.index;
        }
        return false;
    }
}

