/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class UnicodeString
implements Comparable {
    private short field_1_charCount;
    private byte field_2_optionflags;
    private String field_3_string;
    private List field_4_format_runs;
    private byte[] field_5_ext_rst;
    private static final BitField highByte = BitFieldFactory.getInstance(1);
    private static final BitField extBit = BitFieldFactory.getInstance(4);
    private static final BitField richText = BitFieldFactory.getInstance(8);

    private UnicodeString() {
    }

    public UnicodeString(String str) {
        this.setString(str);
    }

    public int hashCode() {
        int stringHash = 0;
        if (this.field_3_string != null) {
            stringHash = this.field_3_string.hashCode();
        }
        return this.field_1_charCount + stringHash;
    }

    public boolean equals(Object o) {
        int i;
        boolean eq;
        if (!(o instanceof UnicodeString)) {
            return false;
        }
        UnicodeString other = (UnicodeString)o;
        boolean bl = eq = this.field_1_charCount == other.field_1_charCount && this.field_2_optionflags == other.field_2_optionflags && this.field_3_string.equals(other.field_3_string);
        if (!eq) {
            return false;
        }
        if (this.field_4_format_runs == null && other.field_4_format_runs == null) {
            return true;
        }
        if (this.field_4_format_runs == null && other.field_4_format_runs != null || this.field_4_format_runs != null && other.field_4_format_runs == null) {
            return false;
        }
        int size = this.field_4_format_runs.size();
        if (size != other.field_4_format_runs.size()) {
            return false;
        }
        for (i = 0; i < size; ++i) {
            FormatRun run2;
            FormatRun run1 = (FormatRun)this.field_4_format_runs.get(i);
            if (run1.equals(run2 = (FormatRun)other.field_4_format_runs.get(i))) continue;
            return false;
        }
        if (this.field_5_ext_rst == null && other.field_5_ext_rst == null) {
            return true;
        }
        if (this.field_5_ext_rst == null && other.field_5_ext_rst != null || this.field_5_ext_rst != null && other.field_5_ext_rst == null) {
            return false;
        }
        size = this.field_5_ext_rst.length;
        if (size != this.field_5_ext_rst.length) {
            return false;
        }
        for (i = 0; i < size; ++i) {
            if (this.field_5_ext_rst[i] == other.field_5_ext_rst[i]) continue;
            return false;
        }
        return true;
    }

    public UnicodeString(RecordInputStream in) {
        int i;
        this.field_1_charCount = in.readShort();
        this.field_2_optionflags = in.readByte();
        int runCount = 0;
        int extensionLength = 0;
        if (this.isRichText()) {
            runCount = in.readShort();
        }
        if (this.isExtendedText()) {
            extensionLength = in.readInt();
        }
        boolean isCompressed = (this.field_2_optionflags & 1) == 0;
        this.field_3_string = isCompressed ? in.readCompressedUnicode(this.field_1_charCount) : in.readUnicodeLEString(this.field_1_charCount);
        if (this.isRichText() && runCount > 0) {
            this.field_4_format_runs = new ArrayList(runCount);
            for (i = 0; i < runCount; ++i) {
                this.field_4_format_runs.add(new FormatRun(in));
            }
        }
        if (this.isExtendedText() && extensionLength > 0) {
            this.field_5_ext_rst = new byte[extensionLength];
            for (i = 0; i < extensionLength; ++i) {
                this.field_5_ext_rst[i] = in.readByte();
            }
        }
    }

    public short getCharCount() {
        return this.field_1_charCount;
    }

    public void setCharCount(short cc) {
        this.field_1_charCount = cc;
    }

    public byte getOptionFlags() {
        return this.field_2_optionflags;
    }

    public void setOptionFlags(byte of) {
        this.field_2_optionflags = of;
    }

    public String getString() {
        return this.field_3_string;
    }

    public void setString(String string) {
        this.field_3_string = string;
        this.setCharCount((short)this.field_3_string.length());
        boolean useUTF16 = false;
        int strlen = string.length();
        for (int j = 0; j < strlen; ++j) {
            if (string.charAt(j) <= '\u00ff') continue;
            useUTF16 = true;
            break;
        }
        this.field_2_optionflags = useUTF16 ? highByte.setByte(this.field_2_optionflags) : highByte.clearByte(this.field_2_optionflags);
    }

    public int getFormatRunCount() {
        if (this.field_4_format_runs == null) {
            return 0;
        }
        return this.field_4_format_runs.size();
    }

    public FormatRun getFormatRun(int index) {
        if (this.field_4_format_runs == null) {
            return null;
        }
        if (index < 0 || index >= this.field_4_format_runs.size()) {
            return null;
        }
        return (FormatRun)this.field_4_format_runs.get(index);
    }

    private int findFormatRunAt(int characterPos) {
        int size = this.field_4_format_runs.size();
        for (int i = 0; i < size; ++i) {
            FormatRun r = (FormatRun)this.field_4_format_runs.get(i);
            if (r.character == characterPos) {
                return i;
            }
            if (r.character <= characterPos) continue;
            return -1;
        }
        return -1;
    }

    public void addFormatRun(FormatRun r) {
        int index;
        if (this.field_4_format_runs == null) {
            this.field_4_format_runs = new ArrayList();
        }
        if ((index = this.findFormatRunAt(r.character)) != -1) {
            this.field_4_format_runs.remove(index);
        }
        this.field_4_format_runs.add(r);
        Collections.sort(this.field_4_format_runs);
        this.field_2_optionflags = richText.setByte(this.field_2_optionflags);
    }

    public Iterator formatIterator() {
        if (this.field_4_format_runs != null) {
            return this.field_4_format_runs.iterator();
        }
        return null;
    }

    public void removeFormatRun(FormatRun r) {
        this.field_4_format_runs.remove(r);
        if (this.field_4_format_runs.size() == 0) {
            this.field_4_format_runs = null;
            this.field_2_optionflags = richText.clearByte(this.field_2_optionflags);
        }
    }

    public void clearFormatting() {
        this.field_4_format_runs = null;
        this.field_2_optionflags = richText.clearByte(this.field_2_optionflags);
    }

    void setExtendedRst(byte[] ext_rst) {
        this.field_2_optionflags = ext_rst != null ? extBit.setByte(this.field_2_optionflags) : extBit.clearByte(this.field_2_optionflags);
        this.field_5_ext_rst = ext_rst;
    }

    public void swapFontUse(short oldFontIndex, short newFontIndex) {
        for (FormatRun run : this.field_4_format_runs) {
            if (run.fontIndex != oldFontIndex) continue;
            run.fontIndex = newFontIndex;
        }
    }

    public String toString() {
        return this.getString();
    }

    public String getDebugInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[UNICODESTRING]\n");
        buffer.append("    .charcount       = ").append(Integer.toHexString(this.getCharCount())).append("\n");
        buffer.append("    .optionflags     = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        buffer.append("    .string          = ").append(this.getString()).append("\n");
        if (this.field_4_format_runs != null) {
            for (int i = 0; i < this.field_4_format_runs.size(); ++i) {
                FormatRun r = (FormatRun)this.field_4_format_runs.get(i);
                buffer.append("      .format_run" + i + "          = ").append(r.toString()).append("\n");
            }
        }
        if (this.field_5_ext_rst != null) {
            buffer.append("    .field_5_ext_rst          = ").append("\n").append(HexDump.toHex(this.field_5_ext_rst)).append("\n");
        }
        buffer.append("[/UNICODESTRING]\n");
        return buffer.toString();
    }

    public void serialize(ContinuableRecordOutput out) {
        int numberOfRichTextRuns = 0;
        int extendedDataSize = 0;
        if (this.isRichText() && this.field_4_format_runs != null) {
            numberOfRichTextRuns = this.field_4_format_runs.size();
        }
        if (this.isExtendedText() && this.field_5_ext_rst != null) {
            extendedDataSize = this.field_5_ext_rst.length;
        }
        out.writeString(this.field_3_string, numberOfRichTextRuns, extendedDataSize);
        if (numberOfRichTextRuns > 0) {
            for (int i = 0; i < numberOfRichTextRuns; ++i) {
                if (out.getAvailableSpace() < 4) {
                    out.writeContinue();
                }
                FormatRun r = (FormatRun)this.field_4_format_runs.get(i);
                r.serialize(out);
            }
        }
        if (extendedDataSize > 0) {
            int extPos = 0;
            while (true) {
                int nBytesToWrite = Math.min(extendedDataSize - extPos, out.getAvailableSpace());
                out.write(this.field_5_ext_rst, extPos, nBytesToWrite);
                if ((extPos += nBytesToWrite) >= extendedDataSize) break;
                out.writeContinue();
            }
        }
    }

    public int compareTo(Object obj) {
        int i;
        UnicodeString str = (UnicodeString)obj;
        int result = this.getString().compareTo(str.getString());
        if (result != 0) {
            return result;
        }
        if (this.field_4_format_runs == null && str.field_4_format_runs == null) {
            return 0;
        }
        if (this.field_4_format_runs == null && str.field_4_format_runs != null) {
            return 1;
        }
        if (this.field_4_format_runs != null && str.field_4_format_runs == null) {
            return -1;
        }
        int size = this.field_4_format_runs.size();
        if (size != str.field_4_format_runs.size()) {
            return size - str.field_4_format_runs.size();
        }
        for (i = 0; i < size; ++i) {
            FormatRun run2;
            FormatRun run1 = (FormatRun)this.field_4_format_runs.get(i);
            result = run1.compareTo(run2 = (FormatRun)str.field_4_format_runs.get(i));
            if (result == 0) continue;
            return result;
        }
        if (this.field_5_ext_rst == null && str.field_5_ext_rst == null) {
            return 0;
        }
        if (this.field_5_ext_rst == null && str.field_5_ext_rst != null) {
            return 1;
        }
        if (this.field_5_ext_rst != null && str.field_5_ext_rst == null) {
            return -1;
        }
        size = this.field_5_ext_rst.length;
        if (size != this.field_5_ext_rst.length) {
            return size - this.field_5_ext_rst.length;
        }
        for (i = 0; i < size; ++i) {
            if (this.field_5_ext_rst[i] == str.field_5_ext_rst[i]) continue;
            return this.field_5_ext_rst[i] - str.field_5_ext_rst[i];
        }
        return 0;
    }

    private boolean isRichText() {
        return richText.isSet(this.getOptionFlags());
    }

    private boolean isExtendedText() {
        return extBit.isSet(this.getOptionFlags());
    }

    public Object clone() {
        UnicodeString str = new UnicodeString();
        str.field_1_charCount = this.field_1_charCount;
        str.field_2_optionflags = this.field_2_optionflags;
        str.field_3_string = this.field_3_string;
        if (this.field_4_format_runs != null) {
            str.field_4_format_runs = new ArrayList();
            int size = this.field_4_format_runs.size();
            for (int i = 0; i < size; ++i) {
                FormatRun r = (FormatRun)this.field_4_format_runs.get(i);
                str.field_4_format_runs.add(new FormatRun(r.character, r.fontIndex));
            }
        }
        if (this.field_5_ext_rst != null) {
            str.field_5_ext_rst = new byte[this.field_5_ext_rst.length];
            System.arraycopy(this.field_5_ext_rst, 0, str.field_5_ext_rst, 0, this.field_5_ext_rst.length);
        }
        return str;
    }

    public static class FormatRun
    implements Comparable {
        short character;
        short fontIndex;

        public FormatRun(short character, short fontIndex) {
            this.character = character;
            this.fontIndex = fontIndex;
        }

        public FormatRun(LittleEndianInput in) {
            this(in.readShort(), in.readShort());
        }

        public short getCharacterPos() {
            return this.character;
        }

        public short getFontIndex() {
            return this.fontIndex;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FormatRun)) {
                return false;
            }
            FormatRun other = (FormatRun)o;
            return this.character == other.character && this.fontIndex == other.fontIndex;
        }

        public int compareTo(Object obj) {
            FormatRun r = (FormatRun)obj;
            if (this.character == r.character && this.fontIndex == r.fontIndex) {
                return 0;
            }
            if (this.character == r.character) {
                return this.fontIndex - r.fontIndex;
            }
            return this.character - r.character;
        }

        public String toString() {
            return "character=" + this.character + ",fontIndex=" + this.fontIndex;
        }

        public void serialize(LittleEndianOutput out) {
            out.writeShort(this.character);
            out.writeShort(this.fontIndex);
        }
    }
}

