/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class RowRecord
extends StandardRecord {
    public static final short sid = 520;
    public static final int ENCODED_SIZE = 20;
    private static final int OPTION_BITS_ALWAYS_SET = 256;
    private static final int DEFAULT_HEIGHT_BIT = 32768;
    public static final int MAX_ROW_NUMBER = 65535;
    private int field_1_row_number;
    private short field_2_first_col;
    private short field_3_last_col;
    private short field_4_height;
    private short field_5_optimize;
    private short field_6_reserved;
    private int field_7_option_flags;
    private static final BitField outlineLevel = BitFieldFactory.getInstance(7);
    private static final BitField colapsed = BitFieldFactory.getInstance(16);
    private static final BitField zeroHeight = BitFieldFactory.getInstance(32);
    private static final BitField badFontHeight = BitFieldFactory.getInstance(64);
    private static final BitField formatted = BitFieldFactory.getInstance(128);
    private short field_8_xf_index;

    public RowRecord(int rowNumber) {
        this.field_1_row_number = rowNumber;
        this.field_2_first_col = (short)-1;
        this.field_3_last_col = (short)-1;
        this.field_4_height = (short)255;
        this.field_5_optimize = 0;
        this.field_6_reserved = 0;
        this.field_7_option_flags = 256;
        this.field_8_xf_index = (short)15;
    }

    public RowRecord(RecordInputStream in) {
        this.field_1_row_number = in.readUShort();
        this.field_2_first_col = in.readShort();
        this.field_3_last_col = in.readShort();
        this.field_4_height = in.readShort();
        this.field_5_optimize = in.readShort();
        this.field_6_reserved = in.readShort();
        this.field_7_option_flags = in.readShort();
        this.field_8_xf_index = in.readShort();
    }

    public void setRowNumber(int row) {
        this.field_1_row_number = row;
    }

    public void setFirstCol(short col) {
        this.field_2_first_col = col;
    }

    public void setLastCol(short col) {
        this.field_3_last_col = col;
    }

    public void setHeight(short height) {
        this.field_4_height = height;
    }

    public void setOptimize(short optimize) {
        this.field_5_optimize = optimize;
    }

    public void setOutlineLevel(short ol) {
        this.field_7_option_flags = outlineLevel.setValue(this.field_7_option_flags, ol);
    }

    public void setColapsed(boolean c) {
        this.field_7_option_flags = colapsed.setBoolean(this.field_7_option_flags, c);
    }

    public void setZeroHeight(boolean z) {
        this.field_7_option_flags = zeroHeight.setBoolean(this.field_7_option_flags, z);
    }

    public void setBadFontHeight(boolean f) {
        this.field_7_option_flags = badFontHeight.setBoolean(this.field_7_option_flags, f);
    }

    public void setFormatted(boolean f) {
        this.field_7_option_flags = formatted.setBoolean(this.field_7_option_flags, f);
    }

    public void setXFIndex(short index) {
        this.field_8_xf_index = index;
    }

    public int getRowNumber() {
        return this.field_1_row_number;
    }

    public short getFirstCol() {
        return this.field_2_first_col;
    }

    public short getLastCol() {
        return this.field_3_last_col;
    }

    public short getHeight() {
        return this.field_4_height;
    }

    public short getOptimize() {
        return this.field_5_optimize;
    }

    public short getOptionFlags() {
        return (short)this.field_7_option_flags;
    }

    public short getOutlineLevel() {
        return (short)outlineLevel.getValue(this.field_7_option_flags);
    }

    public boolean getColapsed() {
        return colapsed.isSet(this.field_7_option_flags);
    }

    public boolean getZeroHeight() {
        return zeroHeight.isSet(this.field_7_option_flags);
    }

    public boolean getBadFontHeight() {
        return badFontHeight.isSet(this.field_7_option_flags);
    }

    public boolean getFormatted() {
        return formatted.isSet(this.field_7_option_flags);
    }

    public short getXFIndex() {
        return this.field_8_xf_index;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ROW]\n");
        sb.append("    .rownumber      = ").append(Integer.toHexString(this.getRowNumber())).append("\n");
        sb.append("    .firstcol       = ").append(HexDump.shortToHex(this.getFirstCol())).append("\n");
        sb.append("    .lastcol        = ").append(HexDump.shortToHex(this.getLastCol())).append("\n");
        sb.append("    .height         = ").append(HexDump.shortToHex(this.getHeight())).append("\n");
        sb.append("    .optimize       = ").append(HexDump.shortToHex(this.getOptimize())).append("\n");
        sb.append("    .reserved       = ").append(HexDump.shortToHex(this.field_6_reserved)).append("\n");
        sb.append("    .optionflags    = ").append(HexDump.shortToHex(this.getOptionFlags())).append("\n");
        sb.append("        .outlinelvl = ").append(Integer.toHexString(this.getOutlineLevel())).append("\n");
        sb.append("        .colapsed   = ").append(this.getColapsed()).append("\n");
        sb.append("        .zeroheight = ").append(this.getZeroHeight()).append("\n");
        sb.append("        .badfontheig= ").append(this.getBadFontHeight()).append("\n");
        sb.append("        .formatted  = ").append(this.getFormatted()).append("\n");
        sb.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        sb.append("[/ROW]\n");
        return sb.toString();
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.getRowNumber());
        out.writeShort(this.getFirstCol() == -1 ? (short)0 : this.getFirstCol());
        out.writeShort(this.getLastCol() == -1 ? (short)0 : this.getLastCol());
        out.writeShort(this.getHeight());
        out.writeShort(this.getOptimize());
        out.writeShort(this.field_6_reserved);
        out.writeShort(this.getOptionFlags());
        out.writeShort(this.getXFIndex());
    }

    protected int getDataSize() {
        return 16;
    }

    public short getSid() {
        return 520;
    }

    public Object clone() {
        RowRecord rec = new RowRecord(this.field_1_row_number);
        rec.field_2_first_col = this.field_2_first_col;
        rec.field_3_last_col = this.field_3_last_col;
        rec.field_4_height = this.field_4_height;
        rec.field_5_optimize = this.field_5_optimize;
        rec.field_6_reserved = this.field_6_reserved;
        rec.field_7_option_flags = this.field_7_option_flags;
        rec.field_8_xf_index = this.field_8_xf_index;
        return rec;
    }
}

