/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.EndSubRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianByteArrayOutputStream;
import org.apache.poi.util.LittleEndianInputStream;

public final class ObjRecord
extends Record {
    public static final short sid = 93;
    private static final int NORMAL_PAD_ALIGNMENT = 2;
    private static int MAX_PAD_ALIGNMENT = 4;
    private List subrecords;
    private byte[] _uninterpretedData;
    private boolean _isPaddedToQuadByteMultiple;

    public ObjRecord() {
        this.subrecords = new ArrayList(2);
    }

    public ObjRecord(RecordInputStream in) {
        SubRecord subRecord;
        byte[] subRecordData = in.readRemainder();
        if (LittleEndian.getUShort(subRecordData, 0) != 21) {
            this._uninterpretedData = subRecordData;
            return;
        }
        if (subRecordData.length % 2 != 0) {
            String msg = "Unexpected length of subRecordData : " + HexDump.toHex(subRecordData);
            throw new RecordFormatException(msg);
        }
        this.subrecords = new ArrayList();
        ByteArrayInputStream bais = new ByteArrayInputStream(subRecordData);
        LittleEndianInputStream subRecStream = new LittleEndianInputStream(bais);
        do {
            subRecord = SubRecord.createSubRecord(subRecStream);
            this.subrecords.add(subRecord);
        } while (!(subRecord instanceof EndSubRecord));
        int nRemainingBytes = bais.available();
        if (nRemainingBytes > 0) {
            this._isPaddedToQuadByteMultiple = subRecordData.length % MAX_PAD_ALIGNMENT == 0;
            if (nRemainingBytes >= (this._isPaddedToQuadByteMultiple ? MAX_PAD_ALIGNMENT : 2)) {
                String msg = "Leftover " + nRemainingBytes + " bytes in subrecord data " + HexDump.toHex(subRecordData);
                throw new RecordFormatException(msg);
            }
        } else {
            this._isPaddedToQuadByteMultiple = false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[OBJ]\n");
        for (int i = 0; i < this.subrecords.size(); ++i) {
            SubRecord record = (SubRecord)this.subrecords.get(i);
            sb.append("SUBRECORD: ").append(record.toString());
        }
        sb.append("[/OBJ]\n");
        return sb.toString();
    }

    protected int getDataSize() {
        if (this._uninterpretedData != null) {
            return this._uninterpretedData.length;
        }
        int size = 0;
        for (int i = this.subrecords.size() - 1; i >= 0; --i) {
            SubRecord record = (SubRecord)this.subrecords.get(i);
            size += record.getDataSize() + 4;
        }
        if (this._isPaddedToQuadByteMultiple) {
            while (size % MAX_PAD_ALIGNMENT != 0) {
                ++size;
            }
        } else {
            while (size % 2 != 0) {
                ++size;
            }
        }
        return size;
    }

    public int serialize(int offset, byte[] data) {
        int dataSize = this.getDataSize();
        int recSize = 4 + dataSize;
        LittleEndianByteArrayOutputStream out = new LittleEndianByteArrayOutputStream(data, offset, recSize);
        out.writeShort(93);
        out.writeShort(dataSize);
        if (this._uninterpretedData == null) {
            for (int i = 0; i < this.subrecords.size(); ++i) {
                SubRecord record = (SubRecord)this.subrecords.get(i);
                record.serialize(out);
            }
            int expectedEndIx = offset + dataSize;
            while (out.getWriteIndex() < expectedEndIx) {
                out.writeByte(0);
            }
        } else {
            out.write(this._uninterpretedData);
        }
        return recSize;
    }

    public short getSid() {
        return 93;
    }

    public List getSubRecords() {
        return this.subrecords;
    }

    public void clearSubRecords() {
        this.subrecords.clear();
    }

    public void addSubRecord(int index, Object element) {
        this.subrecords.add(index, element);
    }

    public boolean addSubRecord(Object o) {
        return this.subrecords.add(o);
    }

    public Object clone() {
        ObjRecord rec = new ObjRecord();
        for (int i = 0; i < this.subrecords.size(); ++i) {
            SubRecord record = (SubRecord)this.subrecords.get(i);
            rec.addSubRecord(record.clone());
        }
        return rec;
    }
}

