/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class FormulaRecord
extends StandardRecord
implements CellValueRecordInterface {
    public static final short sid = 6;
    private static int FIXED_SIZE = 20;
    private static final BitField alwaysCalc = BitFieldFactory.getInstance(1);
    private static final BitField calcOnLoad = BitFieldFactory.getInstance(2);
    private static final BitField sharedFormula = BitFieldFactory.getInstance(8);
    private int field_1_row;
    private short field_2_column;
    private short field_3_xf;
    private double field_4_value;
    private short field_5_options;
    private int field_6_zero;
    private Formula field_8_parsed_expr;
    private SpecialCachedValue specialCachedValue;

    public FormulaRecord() {
        this.field_8_parsed_expr = Formula.create(Ptg.EMPTY_PTG_ARRAY);
    }

    public FormulaRecord(RecordInputStream ris) {
        RecordInputStream in = ris;
        this.field_1_row = in.readUShort();
        this.field_2_column = in.readShort();
        this.field_3_xf = in.readShort();
        long valueLongBits = in.readLong();
        this.field_5_options = in.readShort();
        this.specialCachedValue = SpecialCachedValue.create(valueLongBits);
        if (this.specialCachedValue == null) {
            this.field_4_value = Double.longBitsToDouble(valueLongBits);
        }
        this.field_6_zero = in.readInt();
        short field_7_expression_len = in.readShort();
        int nBytesAvailable = in.available();
        this.field_8_parsed_expr = Formula.read(field_7_expression_len, in, nBytesAvailable);
    }

    public void setRow(int row) {
        this.field_1_row = row;
    }

    public void setColumn(short column) {
        this.field_2_column = column;
    }

    public void setXFIndex(short xf) {
        this.field_3_xf = xf;
    }

    public void setValue(double value) {
        this.field_4_value = value;
        this.specialCachedValue = null;
    }

    public void setCachedResultTypeEmptyString() {
        this.specialCachedValue = SpecialCachedValue.createCachedEmptyValue();
    }

    public void setCachedResultTypeString() {
        this.specialCachedValue = SpecialCachedValue.createForString();
    }

    public void setCachedResultErrorCode(int errorCode) {
        this.specialCachedValue = SpecialCachedValue.createCachedErrorCode(errorCode);
    }

    public void setCachedResultBoolean(boolean value) {
        this.specialCachedValue = SpecialCachedValue.createCachedBoolean(value);
    }

    public boolean hasCachedResultString() {
        if (this.specialCachedValue == null) {
            return false;
        }
        return this.specialCachedValue.getTypeCode() == 0;
    }

    public int getCachedResultType() {
        if (this.specialCachedValue == null) {
            return 0;
        }
        return this.specialCachedValue.getValueType();
    }

    public boolean getCachedBooleanValue() {
        return this.specialCachedValue.getBooleanValue();
    }

    public int getCachedErrorValue() {
        return this.specialCachedValue.getErrorValue();
    }

    public void setOptions(short options) {
        this.field_5_options = options;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_column;
    }

    public short getXFIndex() {
        return this.field_3_xf;
    }

    public double getValue() {
        return this.field_4_value;
    }

    public short getOptions() {
        return this.field_5_options;
    }

    public boolean isSharedFormula() {
        return sharedFormula.isSet(this.field_5_options);
    }

    public void setSharedFormula(boolean flag) {
        this.field_5_options = sharedFormula.setShortBoolean(this.field_5_options, flag);
    }

    public boolean isAlwaysCalc() {
        return alwaysCalc.isSet(this.field_5_options);
    }

    public void setAlwaysCalc(boolean flag) {
        this.field_5_options = alwaysCalc.setShortBoolean(this.field_5_options, flag);
    }

    public boolean isCalcOnLoad() {
        return calcOnLoad.isSet(this.field_5_options);
    }

    public void setCalcOnLoad(boolean flag) {
        this.field_5_options = calcOnLoad.setShortBoolean(this.field_5_options, flag);
    }

    public Ptg[] getParsedExpression() {
        return this.field_8_parsed_expr.getTokens();
    }

    public Formula getFormula() {
        return this.field_8_parsed_expr;
    }

    public void setParsedExpression(Ptg[] ptgs) {
        this.field_8_parsed_expr = Formula.create(ptgs);
    }

    public short getSid() {
        return 6;
    }

    protected int getDataSize() {
        return FIXED_SIZE + this.field_8_parsed_expr.getEncodedSize();
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.getRow());
        out.writeShort(this.getColumn());
        out.writeShort(this.getXFIndex());
        if (this.specialCachedValue == null) {
            out.writeDouble(this.field_4_value);
        } else {
            this.specialCachedValue.serialize(out);
        }
        out.writeShort(this.getOptions());
        out.writeInt(this.field_6_zero);
        this.field_8_parsed_expr.serialize(out);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[FORMULA]\n");
        sb.append("  .row\t   = ").append(HexDump.shortToHex(this.getRow())).append("\n");
        sb.append("  .column\t= ").append(HexDump.shortToHex(this.getColumn())).append("\n");
        sb.append("  .xf\t\t= ").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        sb.append("  .value\t = ");
        if (this.specialCachedValue == null) {
            sb.append(this.field_4_value).append("\n");
        } else {
            sb.append(this.specialCachedValue.formatDebugString()).append("\n");
        }
        sb.append("  .options   = ").append(HexDump.shortToHex(this.getOptions())).append("\n");
        sb.append("    .alwaysCalc= ").append(this.isAlwaysCalc()).append("\n");
        sb.append("    .calcOnLoad= ").append(this.isCalcOnLoad()).append("\n");
        sb.append("    .shared    = ").append(this.isSharedFormula()).append("\n");
        sb.append("  .zero      = ").append(HexDump.intToHex(this.field_6_zero)).append("\n");
        Ptg[] ptgs = this.field_8_parsed_expr.getTokens();
        for (int k = 0; k < ptgs.length; ++k) {
            sb.append("    Ptg[").append(k).append("]=");
            Ptg ptg = ptgs[k];
            sb.append(ptg.toString()).append(ptg.getRVAType()).append("\n");
        }
        sb.append("[/FORMULA]\n");
        return sb.toString();
    }

    public Object clone() {
        FormulaRecord rec = new FormulaRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_column = this.field_2_column;
        rec.field_3_xf = this.field_3_xf;
        rec.field_4_value = this.field_4_value;
        rec.field_5_options = this.field_5_options;
        rec.field_6_zero = this.field_6_zero;
        rec.field_8_parsed_expr = this.field_8_parsed_expr;
        rec.specialCachedValue = this.specialCachedValue;
        return rec;
    }

    private static final class SpecialCachedValue {
        private static final long BIT_MARKER = -281474976710656L;
        private static final int VARIABLE_DATA_LENGTH = 6;
        private static final int DATA_INDEX = 2;
        public static final int STRING = 0;
        public static final int BOOLEAN = 1;
        public static final int ERROR_CODE = 2;
        public static final int EMPTY = 3;
        private final byte[] _variableData;

        private SpecialCachedValue(byte[] data) {
            this._variableData = data;
        }

        public int getTypeCode() {
            return this._variableData[0];
        }

        public static SpecialCachedValue create(long valueLongBits) {
            if ((0xFFFF000000000000L & valueLongBits) != -281474976710656L) {
                return null;
            }
            byte[] result = new byte[6];
            long x = valueLongBits;
            for (int i = 0; i < 6; ++i) {
                result[i] = (byte)x;
                x >>= 8;
            }
            switch (result[0]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new RecordFormatException("Bad special value code (" + result[0] + ")");
                }
            }
            return new SpecialCachedValue(result);
        }

        public void serialize(LittleEndianOutput out) {
            out.write(this._variableData);
            out.writeShort(65535);
        }

        public String formatDebugString() {
            return this.formatValue() + ' ' + HexDump.toHex(this._variableData);
        }

        private String formatValue() {
            int typeCode = this.getTypeCode();
            switch (typeCode) {
                case 0: {
                    return "<string>";
                }
                case 1: {
                    return this.getDataValue() == 0 ? "FALSE" : "TRUE";
                }
                case 2: {
                    return ErrorEval.getText(this.getDataValue());
                }
                case 3: {
                    return "<empty>";
                }
            }
            return "#error(type=" + typeCode + ")#";
        }

        private int getDataValue() {
            return this._variableData[2];
        }

        public static SpecialCachedValue createCachedEmptyValue() {
            return SpecialCachedValue.create(3, 0);
        }

        public static SpecialCachedValue createForString() {
            return SpecialCachedValue.create(0, 0);
        }

        public static SpecialCachedValue createCachedBoolean(boolean b) {
            return SpecialCachedValue.create(1, b ? 0 : 1);
        }

        public static SpecialCachedValue createCachedErrorCode(int errorCode) {
            return SpecialCachedValue.create(2, errorCode);
        }

        private static SpecialCachedValue create(int code, int data) {
            byte[] vd = new byte[]{(byte)code, 0, (byte)data, 0, 0, 0};
            return new SpecialCachedValue(vd);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName());
            sb.append('[').append(this.formatValue()).append(']');
            return sb.toString();
        }

        public int getValueType() {
            int typeCode = this.getTypeCode();
            switch (typeCode) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 5;
                }
                case 3: {
                    return 1;
                }
            }
            throw new IllegalStateException("Unexpected type id (" + typeCode + ")");
        }

        public boolean getBooleanValue() {
            if (this.getTypeCode() != 1) {
                throw new IllegalStateException("Not a boolean cached value - " + this.formatValue());
            }
            return this.getDataValue() != 0;
        }

        public int getErrorValue() {
            if (this.getTypeCode() != 2) {
                throw new IllegalStateException("Not an error cached value - " + this.formatValue());
            }
            return this.getDataValue();
        }
    }
}

