/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;

public final class BOFRecord
extends StandardRecord {
    public static final short sid = 2057;
    private short field_1_version;
    private short field_2_type;
    private short field_3_build;
    private short field_4_year;
    private int field_5_history;
    private int field_6_rversion;
    public static final short VERSION = 6;
    public static final short BUILD = 4307;
    public static final short BUILD_YEAR = 1996;
    public static final short HISTORY_MASK = 65;
    public static final short TYPE_WORKBOOK = 5;
    public static final short TYPE_VB_MODULE = 6;
    public static final short TYPE_WORKSHEET = 16;
    public static final short TYPE_CHART = 32;
    public static final short TYPE_EXCEL_4_MACRO = 64;
    public static final short TYPE_WORKSPACE_FILE = 256;

    public BOFRecord() {
    }

    public BOFRecord(RecordInputStream in) {
        this.field_1_version = in.readShort();
        this.field_2_type = in.readShort();
        if (in.remaining() >= 2) {
            this.field_3_build = in.readShort();
        }
        if (in.remaining() >= 2) {
            this.field_4_year = in.readShort();
        }
        if (in.remaining() >= 4) {
            this.field_5_history = in.readInt();
        }
        if (in.remaining() >= 4) {
            this.field_6_rversion = in.readInt();
        }
    }

    public void setVersion(short version) {
        this.field_1_version = version;
    }

    public void setType(short type) {
        this.field_2_type = type;
    }

    public void setBuild(short build) {
        this.field_3_build = build;
    }

    public void setBuildYear(short year) {
        this.field_4_year = year;
    }

    public void setHistoryBitMask(int bitmask) {
        this.field_5_history = bitmask;
    }

    public void setRequiredVersion(int version) {
        this.field_6_rversion = version;
    }

    public short getVersion() {
        return this.field_1_version;
    }

    public short getType() {
        return this.field_2_type;
    }

    public short getBuild() {
        return this.field_3_build;
    }

    public short getBuildYear() {
        return this.field_4_year;
    }

    public int getHistoryBitMask() {
        return this.field_5_history;
    }

    public int getRequiredVersion() {
        return this.field_6_rversion;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BOF RECORD]\n");
        buffer.append("    .version         = ").append(Integer.toHexString(this.getVersion())).append("\n");
        buffer.append("    .type            = ").append(Integer.toHexString(this.getType())).append("\n");
        buffer.append("    .build           = ").append(Integer.toHexString(this.getBuild())).append("\n");
        buffer.append("    .buildyear       = ").append(this.getBuildYear()).append("\n");
        buffer.append("    .history         = ").append(Integer.toHexString(this.getHistoryBitMask())).append("\n");
        buffer.append("    .requiredversion = ").append(Integer.toHexString(this.getRequiredVersion())).append("\n");
        buffer.append("[/BOF RECORD]\n");
        return buffer.toString();
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.getVersion());
        out.writeShort(this.getType());
        out.writeShort(this.getBuild());
        out.writeShort(this.getBuildYear());
        out.writeInt(this.getHistoryBitMask());
        out.writeInt(this.getRequiredVersion());
    }

    protected int getDataSize() {
        return 16;
    }

    public short getSid() {
        return 2057;
    }

    public Object clone() {
        BOFRecord rec = new BOFRecord();
        rec.field_1_version = this.field_1_version;
        rec.field_2_type = this.field_2_type;
        rec.field_3_build = this.field_3_build;
        rec.field_4_year = this.field_4_year;
        rec.field_5_history = this.field_5_history;
        rec.field_6_rversion = this.field_6_rversion;
        return rec;
    }
}

