/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.extractor;

import java.io.IOException;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.HeaderFooter;

public class ExcelExtractor
extends POIOLE2TextExtractor
implements org.apache.poi.ss.extractor.ExcelExtractor {
    private HSSFWorkbook wb;
    private boolean includeSheetNames = true;
    private boolean formulasNotResults = false;
    private boolean includeCellComments = false;
    private boolean includeBlankCells = false;

    public ExcelExtractor(HSSFWorkbook wb) {
        super(wb);
        this.wb = wb;
    }

    public ExcelExtractor(POIFSFileSystem fs) throws IOException {
        this(fs.getRoot(), fs);
    }

    public ExcelExtractor(DirectoryNode dir, POIFSFileSystem fs) throws IOException {
        this(new HSSFWorkbook(dir, fs, true));
    }

    public void setIncludeSheetNames(boolean includeSheetNames) {
        this.includeSheetNames = includeSheetNames;
    }

    public void setFormulasNotResults(boolean formulasNotResults) {
        this.formulasNotResults = formulasNotResults;
    }

    public void setIncludeCellComments(boolean includeCellComments) {
        this.includeCellComments = includeCellComments;
    }

    public void setIncludeBlankCells(boolean includeBlankCells) {
        this.includeBlankCells = includeBlankCells;
    }

    public String getText() {
        StringBuffer text = new StringBuffer();
        this.wb.setMissingCellPolicy(HSSFRow.RETURN_BLANK_AS_NULL);
        for (int i = 0; i < this.wb.getNumberOfSheets(); ++i) {
            String name;
            HSSFSheet sheet = this.wb.getSheetAt(i);
            if (sheet == null) continue;
            if (this.includeSheetNames && (name = this.wb.getSheetName(i)) != null) {
                text.append(name);
                text.append("\n");
            }
            if (sheet.getHeader() != null) {
                text.append(ExcelExtractor._extractHeaderFooter(sheet.getHeader()));
            }
            int firstRow = sheet.getFirstRowNum();
            int lastRow = sheet.getLastRowNum();
            for (int j = firstRow; j <= lastRow; ++j) {
                HSSFRow row = sheet.getRow(j);
                if (row == null) continue;
                int firstCell = row.getFirstCellNum();
                short lastCell = row.getLastCellNum();
                if (this.includeBlankCells) {
                    firstCell = 0;
                }
                for (int k = firstCell; k < lastCell; ++k) {
                    HSSFCell cell = row.getCell(k);
                    boolean outputContents = true;
                    if (cell == null) {
                        outputContents = this.includeBlankCells;
                    } else {
                        switch (cell.getCellType()) {
                            case 1: {
                                text.append(cell.getRichStringCellValue().getString());
                                break;
                            }
                            case 0: {
                                text.append(cell.getNumericCellValue());
                                break;
                            }
                            case 4: {
                                text.append(cell.getBooleanCellValue());
                                break;
                            }
                            case 5: {
                                text.append(ErrorEval.getText(cell.getErrorCellValue()));
                                break;
                            }
                            case 2: {
                                if (this.formulasNotResults) {
                                    text.append(cell.getCellFormula());
                                    break;
                                }
                                switch (cell.getCachedFormulaResultType()) {
                                    case 1: {
                                        HSSFRichTextString str = cell.getRichStringCellValue();
                                        if (str == null || str.length() <= 0) break;
                                        text.append(str.toString());
                                        break;
                                    }
                                    case 0: {
                                        text.append(cell.getNumericCellValue());
                                        break;
                                    }
                                    case 4: {
                                        text.append(cell.getBooleanCellValue());
                                        break;
                                    }
                                    case 5: {
                                        text.append(ErrorEval.getText(cell.getErrorCellValue()));
                                    }
                                }
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unexpected cell type (" + cell.getCellType() + ")");
                            }
                        }
                        HSSFComment comment = cell.getCellComment();
                        if (this.includeCellComments && comment != null) {
                            String commentText = ((HSSFRichTextString)comment.getString()).getString().replace('\n', ' ');
                            text.append(" Comment by " + comment.getAuthor() + ": " + commentText);
                        }
                    }
                    if (!outputContents || k >= lastCell - 1) continue;
                    text.append("\t");
                }
                text.append("\n");
            }
            if (sheet.getFooter() == null) continue;
            text.append(ExcelExtractor._extractHeaderFooter(sheet.getFooter()));
        }
        return text.toString();
    }

    public static String _extractHeaderFooter(HeaderFooter hf) {
        StringBuffer text = new StringBuffer();
        if (hf.getLeft() != null) {
            text.append(hf.getLeft());
        }
        if (hf.getCenter() != null) {
            if (text.length() > 0) {
                text.append("\t");
            }
            text.append(hf.getCenter());
        }
        if (hf.getRight() != null) {
            if (text.length() > 0) {
                text.append("\t");
            }
            text.append(hf.getRight());
        }
        if (text.length() > 0) {
            text.append("\n");
        }
        return text.toString();
    }
}

