#ifndef AC_CORE_PROCESSOR_HPP
#define AC_CORE_PROCESSOR_HPP

#include <memory>

#include "AC/Core/Image.hpp"

#include "ACExport.hpp" // Generated by CMake

namespace ac::core
{
    class Processor;
}

class ac::core::Processor
{
public:
    static constexpr int CPU = 0;
    static constexpr int OpenCL = 1;
    static constexpr int CUDA = 2;

public:
    AC_EXPORT Processor() noexcept;
    AC_EXPORT virtual ~Processor();

    AC_EXPORT Image process(const Image& src, double factor);
    // If `dst` is not empty, then we will assume that it has been correctly allocated,
    // and the data will be guaranteed to be stored in that preallocated buffer
    AC_EXPORT void process(const Image& src, Image& dst, double factor);

    AC_EXPORT virtual bool ok() noexcept;
    AC_EXPORT virtual const char* error() noexcept;
    AC_EXPORT virtual const char* name() const noexcept = 0;

private:
    AC_EXPORT virtual void process(const Image& src, Image& dst) = 0;

public:
    template<int type, typename Model> static std::shared_ptr<Processor> create(int idx, const Model& model);
    template<int type> static const char* info();

protected:
    int idx;
};

#endif
