<?php 

namespace Controllers; 

use MVC\Router;
use Classes\Email;
use Model\Usuario;

class LoginController {
    public static function login(Router $router) {

        // Verificar si el usuario ya está autenticado
        if (isset($_SESSION["login"]) && $_SESSION["login"] === true) {
            // Redirigir al usuario a otra página, por ejemplo, el dashboard
            header("Location: /");
            exit(); // Finalizar la ejecución del script después de redirigir
        }


        $alertas = [];

        $auth = new Usuario;

        if($_SERVER["REQUEST_METHOD"] === "POST") {
            //debug($_POST);
            $auth = new Usuario($_POST);

            $alertas = $auth->validarLogin();
            //debug($alertas);

            if(empty($alertas)) {
                // Comprobar que exista el usuario
                $usuario = Usuario::where("email", $auth->email);

                if($usuario) {
                    // Verificar el password
                    if( $usuario->comprobarPasswordAndVerificado($auth->password) ) {
                        // Autenticar el usuario
                        session_start();

                        $_SESSION["id"] = $usuario->id;
                        $_SESSION["nombre"] = $usuario->nombre;
                        $_SESSION["apellido"] = $usuario->apellido;
                        $_SESSION["email"] = $usuario->email;
                        $_SESSION["login"] = true;

                        // Redireccionamiento

                        if($usuario->admin === "1") {

                            $_SESSION["admin"] = $usuario->admin ?? null;
                            header("Location: /producto/admin");

                        } else {

                            header("Location: /");
                            
                        }
                    }
                } else {
                    Usuario::setAlerta("error", "Usuario no encontrado");
                }
            }
        }

        $alertas = Usuario::getAlertas();

        $router->render("auth/login", [
            "alertas" => $alertas, 
            "auth" => $auth, 
            "titulo" => "Iniciar Sesión"
        ]);
    }

    public static function logout() {
        session_start();

        $_SESSION = [];

        header("Location: /");
    }

    public static function olvide(Router $router) {

        $alertas = [];

        if($_SERVER["REQUEST_METHOD"] === "POST"); {
            $auth = new Usuario($_POST);
            $alertas = $auth->validarEmail();

            if(empty($alertas)) {
                $usuario = Usuario::where("email", $auth->email);

                if($usuario && $usuario->confirmado === "1") {
                    
                    // Generar un token de un solo uso
                    $usuario->crearToken();
                    $usuario->guardar();

                    //Enviar el email
                    $email = new Email($usuario->nombre, $usuario->email, $usuario->token);
                    $email->enviarInstrucciones();

                    // Alerta de exito
                    Usuario::setAlerta("exito", "Revisa tu Email");

                } else {
                    Usuario::setAlerta("error", "El Usuario no existe o no esta confirmado");
                    
                }
            }
        }
        
        $alertas = Usuario::getAlertas();
        
        $router->render("auth/olvide-password", [
            "alertas" => $alertas, 
            "titulo" => "Olvide mi Password"
        ]);
    }

    public static function recuperar(Router $router) {

        $alertas = [];
        $error = false;

        $token = s($_GET["token"]);

        // Buscar usuario por su token
        $usuario = Usuario::where("token", $token);

        if(empty($usuario)) {
            Usuario::setAlerta("error", "Token no Válido");
            $error = true;
        }

        if($_SERVER["REQUEST_METHOD"] === "POST") {
            // Leer el nuevo password y guardarlo

            $password = new Usuario($_POST);
            $alertas = $password->validarPassword();

            if(empty($alertas)) {
                $usuario->password = null;
                
                $usuario->password = $password->password;
                $usuario->hashPassword();
                $usuario->token = null;
                
                $resultado = $usuario->guardar();

                if($resultado) {
                    // Mostrar mensaje de éxito
                    Usuario::setAlerta("exito", "Password Actualizado Correctamente");

                    header("Refresh: 3, url=/");
                }
            }
        }

        $alertas = Usuario::getAlertas();

        $router->render("auth/recuperar-password", [
            "alertas" => $alertas, 
            "error" => $error, 
            "titulo" => "Recuperar Password"
        ]);
    }

    public static function registrar(Router $router) {

        // Verificar si el usuario ya está autenticado
        if (isset($_SESSION["login"]) && $_SESSION["login"] === true) {
            // Redirigir al usuario a otra página, por ejemplo, el dashboard
            header("Location: /");
            exit(); // Finalizar la ejecución del script después de redirigir
        }

        $usuario = new Usuario;

        // Alertas Vacías
        $alertas = [];
        if($_SERVER["REQUEST_METHOD"] === "POST") {
            
            $usuario->sincronizar($_POST);
            $alertas = $usuario->validarNuevaCuenta();

            // Revisar que alerta este vacío
            if(empty($alertas)) {
                // Verificar que el usuario no este registrado
                $resultado = $usuario->existeUsuario();

                if($resultado->num_rows) {
                    $alertas = Usuario::getAlertas();
                } else {
                    // Hashear el password
                    $usuario->hashPassword();

                    // Generar un Token único
                    $usuario->crearToken();

                    // Enviar el email
                    $email = new Email($usuario->nombre, $usuario->email, $usuario->token);
                    $email->enviarConfirmacion();

                    // Crear el usuario 
                    $resultado = $usuario->guardar();

                    if($resultado) {
                        header("Location: /mensaje");
                    }

                }
            }
        }

        $router->render("auth/crear-cuenta", [
            "usuario" => $usuario,
            "alertas" => $alertas, 
            "titulo" => "Crear Cuenta"
        ]);
    }

    public static function mensaje(Router $router) {

        $router->render("auth/mensaje");
    }

    public static function confirmar(Router $router) {

        $alertas = [];
        $token = s($_GET["token"]);

        // Consigue el token del usuario
        $usuario = Usuario::where("token", $token);

        if(empty($usuario)) {
            // Mostrar mensaje de error
            Usuario::setAlerta("error", "Token No Válido");
        } else {
            // Modificar a usuario confirmado
            $usuario->confirmado = "1";
            $usuario->token = null;
            
            $usuario->guardar();

            Usuario::setAlerta("exito", "Cuenta Comprobada Correctamente");
        }

        // Obtener alertas
        $alertas = Usuario::getAlertas();

        // Renderizar la vista
        $router->render("auth/confirmar-cuenta", [
            "alertas" => $alertas, 
            "titulo" => "Confirmar Cuenta"
        ]);
    }
}