# Ornamental Nursery Project

Welcome to the Ornamental Nursery Project, an online shop for an ornamental plant nursery located in Chile. This project is my first official venture into web development, featuring a dynamic, user-friendly website for a local nursery business.

## Project Overview

This project showcases an ornamental plant nursery in Chile, providing an online platform where customers can explore and purchase a variety of ornamental plants. The site is built using PHP for the backend, Vanilla JavaScript for interactivity, SCSS for styling, and Gulp for task automation. The architecture follows the Model-View-Controller (MVC) pattern to ensure a clean and organized codebase.

## Features

- **User Authentication:** Secure login and registration for customers.
- **Product Catalog:** Browse a wide range of ornamental plants with detailed descriptions and images.
- **Shopping Cart:** Add plants to a shopping cart and manage the cart before checkout.
- **Order Management:** Customers can view their order history and track current orders.
- **Responsive Design:** Optimized for desktop and mobile devices for a seamless user experience.

## Technologies Used

- **Backend:** PHP
- **Frontend:** Vanilla JavaScript
- **Styling:** SCSS
- **Task Runner:** Gulp
- **Architecture:** Model-View-Controller (MVC)

## Project Structure

- `controllers/` - Contains the controllers managing application logic.
- `models/` - Contains the models representing the data and business logic.
- `views/` - Contains the views responsible for displaying the user interface.
- `public/` - Contains publicly accessible files such as CSS, JavaScript, and images.
- `src/scss/` - Source files for SCSS styling.
- `gulpfile.js` - Configuration for Gulp tasks.

## Installation

To set up the project locally, follow these steps:

1. **Clone the Repository:**
    ```sh
    git clone https://github.com/yourusername/ornamental-nursery-project.git
    ```

2. **Navigate to the Project Directory:**
    ```sh
    cd ornamental-nursery-project
    ```

3. **Install Dependencies:**
    ```sh
    npm install
    ```

4. **Compile SCSS and Watch for Changes:**
    ```sh
    gulp
    ```

5. **Set Up the Database:**
    - Create a MySQL database and import the provided SQL file.
    - Configure the database connection in the `config.php` file.

6. **Start the Development Server:**
    - Use a local development server (e.g., XAMPP, WAMP, MAMP) to serve the project files.

## Usage

1. **Access the Site:**
    - Open your web browser and navigate to `http://localhost/ornamental-nursery-project`.

2. **Explore the Features:**
    - Browse the catalog, add items to your cart, and proceed to checkout.

3. **Manage Orders:**
    - Log in to view your order history and track current orders.

## Contributing

Contributions are welcome! If you have suggestions for improvements or new features, please feel free to open an issue or submit a pull request.

## License

This project is licensed under the MIT License. See the [LICENSE](LICENSE) file for details.

## Acknowledgments

- Special thanks to the local nursery for their collaboration on this project.
- Thanks to the open-source community for providing the tools and resources that made this project possible.chile 
