# Contributing to Tech Commute

Welcome to Tech Commute! We appreciate your interest in contributing. Whether you're fixing a bug, improving the documentation, or adding new features, your contributions are welcome.

Before you start contributing, please take a moment to read the following guidelines.

## Table of Contents

- [Code of Conduct](#code-of-conduct)
- [How to Contribute](#how-to-contribute)
- [Reporting Bugs](#reporting-bugs)
- [Suggesting Enhancements](#suggesting-enhancements)
- [Pull Requests](#pull-requests)
  <!-- - [Style Guide](#style-guide) -->
- [License](#license)

## Code of Conduct

This project and everyone participating in it is governed by our [Code of Conduct](CODE_OF_CONDUCT.md). By participating, you are expected to uphold this code. Please report unacceptable behavior to [twitter.com/TasonJorres](https://twitter.com/TasonJorres).

## How to Contribute

1. Fork the repository.
2. Clone your forked repository to your local machine:

   ```bash
   git clone https://github.com/TheTechCommute/techcommute.git
   ```

3. Create a new branch:

   ```bash
   git checkout -b feature/your-feature
   ```

4. Make your changes and commit them:

   ```bash
   git commit -m 'Add some feature'
   ```

5. Push to the branch:

   ```bash
   git push origin feature/your-feature
   ```

6. Open a pull request.

## Reporting Bugs

If you encounter a bug, please help us out by following these steps:

1. Check if the bug has already been reported by searching the [GitHub issues](https://github.com/jasonetorres/techcommute/issues).

2. If not, open a new issue. Be sure to include a clear description and, if possible, steps to reproduce the bug.

## Suggesting Enhancements

We welcome suggestions for new features or improvements. Please follow the same steps as reporting bugs but use the enhancement issue template.

## Pull Requests

- Fork the repository and create a new branch.
- Follow the style guide.
- Clearly describe your changes in the pull request.
- Make sure tests pass before submitting a pull request.
- Your pull request will be reviewed by the maintainers.

<!--
## Style Guide

Please follow our [style guide](STYLE_GUIDE.md) for code consistency.
-->

## License

By contributing, you agree that your contributions will be licensed under the [LICENSE](LICENSE) file of this repository.

**Happy coding!**
