# AgentChat with Llama 3.2 Model

This project implements an AI-powered chat agent using the Llama 3.2 model through the Phidata framework. The agent is capable of engaging in conversations, reasoning, and utilizing various tools to enhance its responses. It is designed to provide a highly interactive experience, making it versatile for different conversational AI needs.

## Features

- **Advanced AI-Powered Chat Agent**: Capable of understanding and responding to natural language input, providing meaningful and context-rich interactions.
- **Integration with Llama 3.2 Model**: Utilizes the Llama 3.2 model for enhanced conversational abilities.
- **Reasoning Capabilities**: Handles complex questions and delivers logical responses.
- **Tool Integration**: Includes access to DuckDuckGo for quick searches and a Calculator for basic arithmetic operations.
- **Asynchronous Processing**: Supports streaming responses for a more interactive user experience.
- **Structured Output Responses**: Ideal for applications that require organized data.
- **Interactive Playground Interface**: Provides an easy and user-friendly environment to interact with the AI agent.
- **Logging**: Comprehensive logging for debugging and monitoring.

## Prerequisites

- Python 3.7+
- pip (Python Package Manager)

## Installation

1. **Clone the Repository**

   ```sh
   git clone https://github.com/yourusername/agentchat-llama.git
   cd agentchat-llama
   ```

2. **Install Required Packages**

   ```sh
   pip install -r requirements.txt
   ```

## Usage

To run the AgentChat playground:

```python
python app.py
```

This command will start the playground interface, allowing you to interact with the AI agent in a hands-on environment.

## Customization

The `enhancements.md` file contains instructions for additional functionalities that can be implemented to expand the capabilities of the AgentChat.

## Phidata Framework Details

This project is built using the Phidata framework, which provides the essential tools and modules for seamless integration and interaction with the Llama 3.2 model. For more information about Phidata and its features, you can refer to the following link:

- [Phidata GitHub Repository](https://github.com/phidatahq/phidata)

## Contributing

Contributions are welcome! Please follow the guidelines in the `CONTRIBUTING.md` file (if available) for more details on the process.

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.
