# Productivity-Tracker


### README for Productivity Tracker

**Productivity Tracker** is a robust web application designed to help users maximize their efficiency and manage tasks effectively. The application provides multiple sections for tracking time, tasks, and progress in a structured, visually appealing interface. It includes sections like Clock, Checklist, Timer, Daily Log, Task Reports, Daily Learnings, and more.

---

## Features

### 1. **Clock**
- Displays the **current time in IST** with hours, minutes, and seconds, along with the **day, month, and year**.
- An animated digital clock with **minimalistic animations**.
- A section showing the **total seconds left in the day** and a motivational **editable quote** to inspire users.

### 2. **Checklist**
- **Task management** with options to mark tasks as Completed, Edit, or Delete.
- Optional **task categories** that can be added to organize tasks and create reports.
- **Dynamic task category management**: Dropdown to reuse existing task categories.
- **Mapping functionality**:
  - **Map All**: Automatically map all tasks to the Timer and Daily Log sections.
  - **Custom Map**: Allows users to select and map specific tasks to either the Timer or Daily Log.

### 3. **Timer**
- **Task timing** with Start, Pause, and Stop buttons. After stopping, the total time spent is displayed next to the task.
- **Task mapping** from the Checklist to the Timer for seamless tracking.
- **Pomodoro technique support**: Default 25-minute intervals with an editable option to change the timer.

### 4. **Daily Log**
- **Task mapping**: Import tasks from the Checklist to plan the day.
- Visual representation of the day split into **30-minute intervals** with tasks mapped into their respective time slots.
- Ability to **add, edit, or delete tasks** from the log.
- **Real-time task updates**: Display of ongoing tasks with a countdown.

### 5. **Links to Visit Daily**
- Manage **important links** with options to add, edit, or delete links.
- **Copying feature** to replicate links to future days, weeks, or custom periods.

### 6. **Daily Learnings**
- Capture and store **daily learnings** with a date stamp.
- Ability to view past learnings in a separate tab with advanced UI, text highlighting, and configurations.

### 7. **Task Reports**
- Multiple reports generated based on user inputs, including:
  - **Task completion reports**: Daily/weekly completion rates.
  - **Task category reports**: Displaying the distribution of tasks by category.
  - **Time management reports**: Visualizing time spent on tasks.
  - **Daily log visualization**: Task distribution across a 24-hour timeframe.

### 8. **Dark Mode**
- Toggle between **light and dark modes** for user comfort.
- Responsive design with color palettes tailored to both themes.

### 9. **Additional Features**
- **Snapshot generation**: Users can download or copy snapshots of their reports, graphs, or important task data. Snapshots are styled with advanced CSS and minimalistic design, featuring the website’s name in the corner.
- **User count display**: Display the number of users using the application, along with a motivational message. The number updates dynamically, and users can share the message on social media.
- **Try Our Other Applications**: A section at the bottom encouraging users to explore other apps.

---

## Installation

### Prerequisites
- A modern web browser (Chrome, Firefox, Safari, etc.)
- Internet connection if hosting the application online.

### Steps

1. **Clone the Repository**:
   ```
   git clone https://github.com/your-username/productivity-tracker.git
   cd productivity-tracker
   ```

2. **Open the Application**:
   Open `index.html` in your browser to start using the app.

3. **Enjoy the Features**:
   Begin by adding tasks, managing time, and reviewing your reports!

---

## Contributing

### How to Contribute

We welcome contributions to improve the application! Here’s how you can help:

1. **Star the Repository**:
   Star this Project to access directly and share it. 

2. **Fork the Repository**:
   Fork the project to your GitHub account.

3. **Create a Branch**:
   Create a new branch for your changes:
   ```
   git checkout -b feature-branch
   ```

4. **Make Changes**:
   Implement the desired improvements, ensuring code is well-documented and follows the existing style.

5. **Push the Changes**:
   Push your branch to GitHub:
   ```
   git push origin feature-branch
   ```

6. **Submit a Pull Request**:
   Create a pull request on the original repository, providing details on the changes you've made.

### Suggestions for Improvement
- **Enhanced User Interaction**: Add features like task reminders, notifications, and deeper calendar integrations.
- **Mobile Optimization**: Continue refining the mobile experience with better layouts for smaller screens.
- **API Integration**: Add backend support for real-time syncing and data sharing between users.

---
---

## License

This project is licensed under the MIT License. See the LICENSE file for more details.

---

## Contact

For any inquiries, suggestions, or feedback:
-
- **GitHub**: (https://github.com/TheOpenInnovator/Productivity-Tracker)

---

