require 'rails_helper'

RSpec.describe 'Editing a Project Submission' do
  let(:user) { create(:user) }
  let(:lesson) { create(:lesson, :project) }
  let(:edited_field_values) do
    {
      repo_url: 'https://github.com/edited-project-repo-url',
      live_preview_url: 'http://edited-live-preview-url.com'
    }
  end

  before do
    sign_in(user)
    visit lesson_path(lesson)
    Pages::ProjectSubmissions::Form.new.open.fill_in.submit
  end

  it 'successfully edits a submission' do
    within(:test_id, 'current-user-solution') do
      find(:test_id, 'submission-action-menu-btn').click
      find(:test_id, 'edit-submission').click
    end

    Pages::ProjectSubmissions::Form.new(**edited_field_values).tap do |form|
      form.fill_in
      form.submit
    end

    within(:test_id, 'current-user-solution') do
      expect(page).to have_content(lesson.title)
      expect(find(:test_id, 'view-code-btn')['href']).to eq('https://github.com/edited-project-repo-url')
      expect(find(:test_id, 'live-preview-btn')['href']).to eq('http://edited-live-preview-url.com/')
    end
  end
end
