def ruby_lessons
  {
    'How This Course Will Work' => {
      title: 'How This Course Will Work',
      description: "It's time to get acquainted with what this will look like from here on out.",
      is_project: false,
      github_path: '/ruby/introduction/how_this_course_will_work.md',
      identifier_uuid: '3645e7c7-2845-4d85-9e8a-b83294f6cb68',
    },
    'Installing Ruby' => {
      title: 'Installing Ruby',
      description: "Let's get started with installing Ruby!",
      is_project: false,
      github_path: '/ruby/introduction/installing_ruby.md',
      identifier_uuid: '99b7fe68-6673-4b51-9bea-4c1c0aad59d9',
      installation_lesson: true,
    },
    'Basic Data Types' => {
      title: 'Basic Data Types',
      description: 'In this lesson we will explore the basic data types at your disposal in Ruby.',
      is_project: false,
      github_path: '/ruby/basic_ruby/basic_data_types.md',
      identifier_uuid: '3cf9a92e-6781-4112-9e8e-d3135819806b',
    },
    'Variables' => {
      title: 'Variables',
      description: 'In this lesson we will explore how to use Variables in Ruby.',
      is_project: false,
      github_path: '/ruby/basic_ruby/variables.md',
      identifier_uuid: 'ca5132cc-fa76-4d66-bd12-5995739318c3',
    },
    'Input and Output' => {
      title: 'Input and Output',
      description: 'In this lesson we will explore how to input and output data in your Ruby programs.',
      is_project: false,
      github_path: '/ruby/basic_ruby/input_and_output.md',
      identifier_uuid: '06fbb445-8756-4906-ae42-86f261d45f22',
    },
    'Conditional Logic' => {
      title: 'Conditional Logic',
      description: 'In this lesson we will explore how to make decisions in Ruby so your programs can take different paths.',
      is_project: false,
      github_path: '/ruby/basic_ruby/conditional_logic.md',
      identifier_uuid: '1804825f-4b45-4989-93bd-8303bd75d222',
    },
    'Loops' => {
      title: 'Loops',
      description: "In this lesson we will explore how to utilize loops in Ruby so you don't have to repeat yourself quite as much.",
      is_project: false,
      github_path: '/ruby/basic_ruby/loops.md',
      identifier_uuid: 'cf049293-79c3-4b92-b2bd-f038d8e4fe65',
    },
    'Arrays' => {
      title: 'Arrays',
      description: 'In this lesson we will explore how to use arrays in Ruby and start using lists of data.',
      is_project: false,
      github_path: '/ruby/basic_ruby/arrays.md',
      identifier_uuid: '1a994fe7-6806-4e23-a902-8d64dcf6e9c9',
    },
    'Hashes' => {
      title: 'Hashes',
      description: 'In this lesson we will explore how to use hashes in Ruby and start using key, value pairs of data.',
      is_project: false,
      github_path: '/ruby/basic_ruby/hashes.md',
      identifier_uuid: '9d8d333c-d9c9-4512-8d15-764caaea4f30',
    },
    'Methods' => {
      title: 'Methods',
      description: 'In this lesson we will explore how to make your code more modular with methods.',
      is_project: false,
      github_path: '/ruby/basic_ruby/methods.md',
      identifier_uuid: '0fb26819-dee9-463b-85a9-b6d5765244f8',
    },
    'Basic Enumerable Methods' => {
      title: 'Basic Enumerable Methods',
      description: 'In this lesson we will explore Rubys secret weapon, its enumerable methods.',
      is_project: false,
      github_path: '/ruby/basic_ruby/basic_enumerable_methods.md',
      identifier_uuid: '9e7ed0df-8264-4e3f-bc71-c75a26bdf56a',
    },
    'Predicate Enumerable Methods' => {
      title: 'Predicate Enumerable Methods',
      description: 'In this lesson we will explore more enumerable methods that return true or false against a collection of data.',
      is_project: false,
      github_path: '/ruby/basic_ruby/predicate_enumerable_methods.md',
      identifier_uuid: 'a066340c-10aa-4260-abe7-995c0e32ea92',
    },
    'Debugging' => {
      title: 'Debugging',
      description: 'In this lesson we will explore how to debug your code when things go wrong.',
      is_project: false,
      github_path: '/ruby/basic_ruby/debugging.md',
      identifier_uuid: '468410df-be1d-414c-a939-dfc90962b03d',
    },
    'Caesar Cipher' => {
      title: 'Caesar Cipher',
      description: "In this project you will build you're very own message encryption program.",
      is_project: true,
      github_path: '/ruby/basic_ruby_projects/project_caesar_cipher.md',
      accepts_submission: true,
      previewable: false,
      identifier_uuid: '47e7c8ab-0dc8-4d6b-bc23-d9674b174007',
    },
    'Sub Strings' => {
      title: 'Sub Strings',
      description: 'In this project you will build a program which identifies all the sub-strings in a larger string.',
      is_project: true,
      github_path: '/ruby/basic_ruby_projects/project_sub_strings.md',
      accepts_submission: true,
      previewable: false,
      identifier_uuid: '9445341e-1907-4269-b866-446a3a08d3b9',
    },
    'Stock Picker' => {
      title: 'Stock Picker',
      description: 'In this project you will build a simple program that will tell its user the best day to buy stocks.',
      is_project: true,
      github_path: '/ruby/basic_ruby_projects/project_stock_picker.md',
      accepts_submission: true,
      previewable: false,
      identifier_uuid: '89096a08-7abf-481b-9464-a82a65872e8e',
    },
    'Bubble Sort' => {
      title: 'Bubble Sort',
      description: 'In this project you will build a simple sorting algorithm.',
      is_project: true,
      github_path: '/ruby/basic_ruby_projects/project_bubble_sort.md',
      accepts_submission: true,
      previewable: false,
      identifier_uuid: '5b332db6-e7f7-4232-9531-a35096d61c81',
    },
    'Object Oriented Programming' => {
      title: 'Object Oriented Programming',
      description: 'Fundamental concepts about object oriented programming that will help you with any programming language you learn from here on out.',
      is_project: false,
      github_path: '/ruby/object_oriented_programming_basics/object_oriented_programming.md',
      identifier_uuid: '15924a5e-c72d-44f9-8546-78b05b903274',
    },
    'Project Management' => {
      title: 'Project Management',
      description: 'This lesson goes over managing Ruby projects and installing Gems.',
      is_project: false,
      github_path: '/ruby/object_oriented_programming_basics/managing_ruby_projects.md',
      identifier_uuid: 'edfa2f6a-6534-41e9-bc2d-a1253bcc1c41',
    },
    'Linting and RuboCop' => {
      title: 'Linting and RuboCop',
      description: 'This lesson goes over importance of rules and how to follow them with the help of RuboCop.',
      is_project: false,
      github_path: '/ruby/object_oriented_programming_basics/linting_and_rubocop.md',
      identifier_uuid: 'd0fefa97-3201-474c-9636-3592fb9399d8',
    },
    'Tic Tac Toe' => {
      title: 'Tic Tac Toe',
      description: "It's time to flex those new muscles a bit by building Tic Tac Toe",
      is_project: true,
      github_path: '/ruby/object_oriented_programming_basics/project_tic_tac_toe.md',
      accepts_submission: true,
      previewable: true,
      identifier_uuid: '49bd96f3-f358-46f2-8e2a-c91d44c2cf85',
    },
    'Mastermind' => {
      title: 'Mastermind',
      description: 'In this project you will build the classic code breaking game Mastermind',
      is_project: true,
      github_path: '/ruby/object_oriented_programming_basics/project_mastermind.md',
      accepts_submission: true,
      previewable: true,
      identifier_uuid: '0333fa64-534c-4b31-9a3e-8c89d84f7618',
    },
    'Files and Serialization' => {
      title: 'Files and Serialization',
      description: 'What if you want to save the state of your program?  How about loading in a file?  Some basic operations like these will be covered here.',
      is_project: false,
      github_path: '/ruby/files_and_serialization/files_and_serialization.md',
      identifier_uuid: 'f68ab24d-a309-4a73-8fe1-1c03d889f514',
    },
    'Event Manager' => {
      title: 'Event Manager',
      description: 'Learn File I/O while becoming civically active',
      is_project: true,
      github_path: '/ruby/files_and_serialization/project_event_manager.md',
      accepts_submission: true,
      previewable: false,
      identifier_uuid: 'a47be9ab-7c78-44c2-b098-ec63d82af1cf',
    },
    'Hangman' => {
      title: 'Hangman',
      description: "You'll get a chance to scrub an existing dataset and then work with dictionaries by building Hangman.",
      is_project: true,
      github_path: '/ruby/files_and_serialization/project_hangman.md',
      accepts_submission: true,
      previewable: true,
      identifier_uuid: '8a5dda78-b387-4a4e-b2af-aed0561ed633',
    },
    'Blocks' => {
      title: 'Blocks',
      description: 'Dive into how Ruby uses blocks within methods.',
      is_project: false,
      github_path: '/ruby/advanced_ruby/blocks.md',
      identifier_uuid: '357b39e4-d7ad-4a97-97aa-6cfccb6a6574',
    },
    'Pattern Matching' => {
      title: 'Pattern Matching',
      description: 'Discover how Ruby has introduced pattern matching and how it can simplify extracting information from deeply nested data structures',
      is_project: false,
      github_path: '/ruby/advanced_ruby/pattern_matching.md',
      identifier_uuid: '2fba93a5-e759-4c17-8c6e-3ebc6da2048a',
    },
    'A Very Brief Intro to CS' => {
      title: 'A Very Brief Intro to CS',
      description: "Get a taste of what's coming up ahead and what the bigger world of CS looks like beyond the scope of this course.",
      is_project: false,
      github_path: '/ruby/computer_science/a_very_brief_intro_to_cs.md',
      identifier_uuid: '9325ba3d-2f93-4d94-b7ac-8bfa16f04780',
    },
    'Recursive Methods' => {
      title: 'Recursive Methods',
      description: 'Learn how making a function call itself can be helpful for making big problems into smaller problems',
      is_project: false,
      github_path: '/ruby/computer_science/recursive_methods.md',
      identifier_uuid: 'a8c01c2b-3421-4bdc-88c5-07b5ee1de9f9',
    },
    'Recursion' => {
      title: 'Recursion',
      description: 'Take your newfound knowledge and apply it to a couple of classic recursive problems',
      is_project: true,
      github_path: '/ruby/computer_science/project_recursion.md',
      accepts_submission: true,
      previewable: false,
      identifier_uuid: '062acc7a-b1b0-4c9d-a7e8-e08bae7a9c0d',
    },
    'Time Complexity' => {
      title: 'Time Complexity',
      description: 'Learn how to measure how time efficient your code is and how to make it more efficient',
      is_project: false,
      github_path: '/ruby/computer_science/time_complexity.md',
      identifier_uuid: '661275dd-dabf-4ce2-8172-fa71f84fab30',
    },
    'Space Complexity' => {
      title: 'Space Complexity',
      description: 'Learn how to measure how space efficient your code is and how to make it more efficient',
      is_project: false,
      github_path: '/ruby/computer_science/space_complexity.md',
      identifier_uuid: '8876d425-b190-4d80-a2ec-1c4937830f8b',
    },
    'Common Data Structures and Algorithms' => {
      title: 'Common Data Structures and Algorithms',
      description: 'Learn why we use different data structures to handle our data and some classic algorithms for searching through them to help solve problems',
      is_project: false,
      github_path: '/ruby/computer_science/common_data_structures_algorithms.md',
      identifier_uuid: '5aeae574-0b2a-4899-b3e6-c6230fd8b6f5',
    },
    'Linked Lists' => {
      title: 'Linked Lists',
      description: 'Build one of the most fundamental data structures.',
      is_project: true,
      github_path: '/ruby/computer_science/project_linked_lists.md',
      accepts_submission: true,
      previewable: false,
      identifier_uuid: '93a87bae-96c3-47af-a106-62ded20f12c3',
    },
    'Binary Search Trees' => {
      title: 'Binary Search Trees',
      description: "In this project you'll get your hands dirty with one of the most common computer science problems, searching binary trees.",
      is_project: true,
      github_path: '/ruby/computer_science/project_binary_search_trees.md',
      accepts_submission: true,
      previewable: false,
      identifier_uuid: '00c3096f-0ab0-49e2-9eef-54afc9182f80',
    },
    'Knights Travails' => {
      title: 'Knights Travails',
      description: 'Lets build Knights Travails',
      is_project: true,
      github_path: '/ruby/computer_science/project_knights_travails.md',
      accepts_submission: true,
      previewable: false,
      identifier_uuid: 'fb6c9850-7fc6-4cdb-bf62-804e706788de',
    },
    'Test Driven Development' => {
      title: 'Test Driven Development',
      description: "In this lesson you will learn about what TDD is and why it's important.",
      is_project: false,
      github_path: '/ruby/testing_ruby_with_rspec/test_driven_development.md',
      identifier_uuid: '59cf167a-d1b0-4fd9-a964-1174efb4fdf9',
    },
    'Introduction to RSpec' => {
      title: 'Introduction to RSpec',
      description: 'In this lesson you will learn the basics of RSpec, the most popular testing framework in the Ruby world.',
      is_project: false,
      github_path: '/ruby/testing_ruby_with_rspec/introduction_to_rspec.md',
      identifier_uuid: '34eb5b73-29a8-4d5b-8747-a2ccad75806e',
    },
    'Connect Four' => {
      title: 'Connect Four',
      description: "The real way to learn is by doing, so you'll jump in the time machine and write some tests for prior projects.",
      is_project: true,
      github_path: '/ruby/testing_ruby_with_rspec/project_connect_four.md',
      accepts_submission: true,
      previewable: true,
      identifier_uuid: '33440cca-8fbf-46fe-9265-67d938fe1d8c',
    },
    'Ruby Final Project' => {
      title: 'Ruby Final Project',
      description: 'Now would be a good time to refresh your memory on how to play Chess. Building it is actually more fun (and more rewarding)!',
      is_project: true,
      github_path: '/ruby/conclusion/project_ruby_final.md',
      accepts_submission: true,
      previewable: true,
      identifier_uuid: 'acf6c3f1-915a-4878-8224-2c5f12b1e43b',
    },
    'Conclusion' => {
      title: 'Conclusion',
      description: "Woah! You made it! Let's take a minute to look back and put things in context for the next step ahead.",
      is_project: false,
      github_path: '/ruby/conclusion/conclusion.md',
      identifier_uuid: '2f75b1ec-3b5f-4b21-9f97-acfe6578bfb1',
    },
    'Nested Collections' => {
      title: 'Nested Collections',
      description: 'In this lesson we will explore using nested arrays and nested hashes to store more complex data',
      is_project: false,
      github_path: '/ruby/basic_ruby/nested_collections.md',
      identifier_uuid: 'c871bb2d-c159-4fc8-93b4-3ee9a6c1818d',
    },
    'Custom Enumerables' => {
      title: 'Custom Enumerables',
      description: "In this project, you'll recreate the magic behind many Enumerable methods",
      is_project: true,
      github_path: '/ruby/advanced_ruby/project_custom_enumerables.md',
      accepts_submission: true,
      previewable: false,
      identifier_uuid: 'cea1b51e-b97e-11eb-8529-0242ac130003',
    },
    'HashMap Data Structure' => {
      title: 'HashMap Data Structure',
      description: 'Learn how a hash map works, to save and retrieve data',
      is_project: false,
      github_path: '/ruby/computer_science/hash_map_data_structure.md',
      identifier_uuid: 'cdd4796c-4eed-498c-91a1-a673ba2c4cb8'
    },
    'HashMap' => {
      title: 'HashMap',
      description: 'Build your very first hash map data structure from scratch',
      is_project: true,
      github_path: '/ruby/computer_science/project_hash_map.md',
      accepts_submission: true,
      previewable: false,
      identifier_uuid: '20b01618-5437-40c4-a362-8b5f51421b4d'
    },
  }
end
