def html_and_css_lessons
  {
    # Accessibility section
    'Introduction to Web Accessibility' => {
      title: 'Introduction to Web Accessibility',
      description: 'Learn what accessibility means to you as a web developer',
      is_project: false,
      github_path: '/advanced_html_css/accessibility/introduction_to_web_accessibility.md',
      identifier_uuid: '77a24bd6-4023-4901-8b4e-b9d7d12fa349',
    },
    'The Web Content Accessibility Guidelines' => {
      title: 'The Web Content Accessibility Guidelines (WCAG)',
      description: 'Learn where to find and how to use the official guidelines for web content accessibility',
      is_project: false,
      github_path: '/advanced_html_css/accessibility/the_web_content_accessibility_guidelines_wcag.md',
      identifier_uuid: 'b2e7a279-01cf-4926-b375-fedb5b7e9eed',
    },
    'Semantic HTML' => {
      title: 'Semantic HTML',
      description: 'Learn the importance of using the right elements in the right places.',
      is_project: false,
      github_path: '/advanced_html_css/accessibility/semantic_html.md',
      identifier_uuid: '44c955e2-43ae-4f07-a0a4-7efabee6515c',
    },
    'Accessible Colors' => {
      title: 'Accessible Colors',
      description: 'Learn how to measure color contrast to maintain readability on your websites.',
      is_project: false,
      github_path: '/advanced_html_css/accessibility/accessible_colors.md',
      identifier_uuid: 'cf510d74-cf6e-4394-a44a-958d921235a9',
    },
    'Keyboard Navigation' => {
      title: 'Keyboard Navigation',
      description: 'Learn how to ensure all users are able to access your site using only a keyboard.',
      is_project: false,
      github_path: '/advanced_html_css/accessibility/keyboard_navigation.md',
      identifier_uuid: 'cb8acac5-3334-4f88-8e8f-3542cfba84ab',
    },
    'Meaningful Text' => {
      title: 'Meaningful Text',
      description: 'Learn the importance of being clear when labeling items on your website.',
      is_project: false,
      github_path: '/advanced_html_css/accessibility/meaningful_text.md',
      identifier_uuid: '4d038307-3c21-47da-af3d-42e4be68ea8a',
    },
    'WAI-ARIA' => {
      title: 'WAI-ARIA',
      description: "Learn about ARIA, how to implement it, and when it's necessary.",
      is_project: false,
      github_path: '/advanced_html_css/accessibility/wai_aria.md',
      identifier_uuid: '40aeff0e-bf1d-46b7-830a-d5001e6c0b2e',
    },
    'Accessibility Auditing' => {
      title: 'Accessibility Auditing',
      description: 'Learn how to audit your own sites to check for and correct accessibility issues.',
      is_project: false,
      github_path: '/advanced_html_css/accessibility/accessibility_auditing.md',
      identifier_uuid: 'ccb3b2ef-d54c-4836-9c94-6081458bf37c',
    },
    # Intermediate HTML
    'Introduction' => {
      title: 'Introduction',
      description: 'Lets go deeper into the world of HTML and CSS!',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_html_concepts/introduction.md',
      identifier_uuid: 'c1209191-1c2b-4c26-a838-8c4d4c3d388b'
    },
    'Emmet' => {
      title: 'Emmet',
      description: 'Emmet is a useful tool for helping create and manipulate HTMl and CSS',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_html_concepts/emmet.md',
      identifier_uuid: '71254f29-7f01-47b3-b621-2a664d368675'
    },
    'SVG' => {
      title: 'SVG',
      description: 'SVG is neat!',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_html_concepts/svgs.md',
      identifier_uuid: '30c64bee-90ae-41c6-8880-1eec97c002e2'
    },
    'Tables' => {
      title: 'Tables',
      description: 'Tables are great when used appropriately!',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_html_concepts/tables.md',
      identifier_uuid: '92707e2c-5627-4de3-9fe8-04dac6a00482'
    },
    # Intermediate CSS
    'Default Styles' => {
      title: 'Default Styles',
      description: 'Learn about how browsers style your HTML.',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_css_concepts/default_styles.md',
      identifier_uuid: 'd490e207-39da-43da-afb0-6e37de0cefcf'
    },
    'CSS Units' => {
      title: 'CSS Units',
      description: 'Check out the various units you can use in your stylesheets',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_css_concepts/css_units.md',
      identifier_uuid: '2a114e3d-a2ff-4343-9b5f-25e13f78e5c5'
    },
    'More Text Styles' => {
      title: 'More Text Styles',
      description: 'Here we cover some more properties you can use to style text on your websites.',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_css_concepts/more_text_styles.md',
      identifier_uuid: 'b29df942-302a-4f25-8b4f-6220a49fa15f'
    },
    'More CSS Properties' => {
      title: 'More CSS Properties',
      description: 'CSS can do quite a lot! Here we cover some more properties you can use to make your sites pop!',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_css_concepts/more_css_properties.md',
      identifier_uuid: 'a5db6aab-f888-40c5-8f84-6867f2c88141'
    },
    'Advanced Selectors' => {
      title: 'Advanced Selectors',
      description: 'You can do a lot more than just target specific classes and ids in your CSS...',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_css_concepts/advanced_selectors.md',
      identifier_uuid: 'cc9598a9-3152-4470-ad65-f9334b908be6'
    },
    'Positioning' => {
      title: 'Positioning',
      description: 'Learn some new methods for moving items around on a webpage.',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_css_concepts/positioning.md',
      identifier_uuid: '68b722bd-251e-4994-83f5-c4a27f31eadc'
    },
    'CSS Functions' => {
      title: 'CSS Functions',
      description: 'Learn the function syntax, and some useful ways you can do calculations in CSS.',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_css_concepts/css_functions.md',
      identifier_uuid: '65a64b3a-43cd-45a9-819e-a22718fdfded'
    },
    'Custom Properties' => {
      title: 'Custom Properties',
      description: 'Learn how to use Variables in your CSS to avoid repeating common values like colors, and keep your styles consistent',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_css_concepts/custom_properties.md',
      identifier_uuid: 'b11ce418-a20f-4f2b-9993-f428d489b425'
    },
    'Browser Compatibility' => {
      title: 'Browser Compatibility',
      description: 'Brand new CSS features take a little time to make it into browsers. Learn how to know which features you can safely use in your projects.',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_css_concepts/browser_compatibility.md',
      identifier_uuid: 'cc398a00-9065-4979-a8cc-41d9863f0db1'
    },
    'Frameworks and Preprocessors' => {
      title: 'Frameworks and Preprocessors',
      description: 'Frameworks and Preprocessors are useful tools that you may want to investigate.',
      is_project: false,
      github_path: '/intermediate_html_css/intermediate_css_concepts/frameworks_and_preprocessors.md',
      identifier_uuid: '6bcc2cd9-8816-4481-bafb-7208fb1108a4'
    },
    # Animation
    'Transforms' => {
      title: 'Transforms',
      description: 'Before we get into animations, we need to learn about manipulating elements with CSS transforms.',
      is_project: false,
      github_path: '/advanced_html_css/animation/transforms.md',
      identifier_uuid: 'bdd2e3ef-da70-4aa3-88ab-e941f0714a9b'
    },
    'Transitions' => {
      title: 'Transitions',
      description: 'Our first kind of animation code is the transition',
      is_project: false,
      github_path: '/advanced_html_css/animation/transitions.md',
      identifier_uuid: 'aec495c8-24b9-4678-9216-9a92f1b118ed'
    },
    'Keyframes' => {
      title: 'Keyframes',
      description: 'More flexible than transitions are Keyframes',
      is_project: false,
      github_path: '/advanced_html_css/animation/keyframes.md',
      identifier_uuid: 'b57040da-48a4-4af6-9e0e-abc67deb3b07'
    },
    # Forms
    'Form Basics' => {
      title: 'Form Basics',
      description: 'Learn the basics of creating forms in HTML.',
      is_project: false,
      github_path: '/intermediate_html_css/forms/form_basics.md',
      identifier_uuid: '6029885a-94d7-4f8b-a558-f9b1d4f6beef'
    },
    'Form Validation' => {
      title: 'Form Validation',
      description: 'Learn the basics of validating forms in HTML.',
      is_project: false,
      github_path: '/intermediate_html_css/forms/form_validations.md',
      identifier_uuid: '969ae828-9847-416e-b978-64a75dc26a5c'
    },
    'Sign-up Form' => {
      title: 'Sign-up Form',
      description: 'Learn about how browsers style your HTML.',
      is_project: true,
      accepts_submission: true,
      previewable: true,
      github_path: '/intermediate_html_css/forms/project_sign_up_form.md',
      identifier_uuid: '91ab41f2-9c9d-449a-8461-329a5f7ecb1e'
    },
    # Grid
    'Introduction to Grid' => {
      title: 'Introduction to Grid',
      description: 'Introduction to CSS Grid',
      is_project: false,
      github_path: '/intermediate_html_css/grid/introduction_to_grid.md',
      identifier_uuid: '589f2842-3f7e-4b1d-8d1f-505136245368'
    },
    'Creating a Grid' => {
      title: 'Creating a Grid',
      description: "Let's get started by creating a Grid.",
      is_project: false,
      github_path: '/intermediate_html_css/grid/creating_a_grid.md',
      identifier_uuid: '5c95b05e-5e77-47ae-871a-400a0ce9684b'
    },
    'Positioning Grid Elements' => {
      title: 'Positioning Grid Elements',
      description: 'Learn how to manipulate elements within a grid.',
      is_project: false,
      github_path: '/intermediate_html_css/grid/positioning_grid_elements.md',
      identifier_uuid: '48813f31-ecc6-44c5-8f72-e7e24ae5e702'
    },
    'Advanced Grid Properties' => {
      title: 'Advanced Grid Properties',
      description: 'Learn some of the more useful, but advanced grid properties.',
      is_project: false,
      github_path: '/intermediate_html_css/grid/advanced_grid_properties.md',
      identifier_uuid: '4247602b-1246-43e8-9769-22a64812f75a'
    },
    'Using Flexbox and Grid' => {
      title: 'Using Flexbox and Grid',
      description: 'Finish our study of Grid by comparing it to Flexbox',
      is_project: false,
      github_path: '/intermediate_html_css/grid/using_flexbox_and_grid.md',
      identifier_uuid: 'eee5a7e7-bbcc-432b-bdfb-799276fc47c2'
    },
    'Admin Dashboard' => {
      title: 'Admin Dashboard',
      description: "Use what you've learned to Complete this project",
      is_project: true,
      accepts_submission: true,
      previewable: true,
      github_path: '/intermediate_html_css/grid/project_admin_dashboard.md',
      identifier_uuid: 'c35f0b7b-4d21-4d26-91e2-4af78519ae5f'
    },
    # Responsive Design
    'Introduction to Responsive Design' => {
      title: 'Introduction to Responsive Design',
      description: "Learn what responsive design is, and why it's important",
      is_project: false,
      github_path: '/advanced_html_css/responsive_design/introduction_to_responsive_design.md',
      identifier_uuid: '5af1f6bf-8719-4897-8efe-ff47e8bf5342'
    },
    'Natural Responsiveness' => {
      title: 'Natural Responsiveness',
      description: 'Learn the importance of making your sites naturally responsive.',
      is_project: false,
      github_path: '/advanced_html_css/responsive_design/natural_responsiveness.md',
      identifier_uuid: 'b86ae699-a4b3-4894-b438-6274b52fea27'
    },
    'Responsive Images' => {
      title: 'Responsive Images',
      description: 'Some tricks relating specifically to making Images responsive.',
      is_project: false,
      github_path: '/advanced_html_css/responsive_design/responsive_images.md',
      identifier_uuid: 'b34f989f-5f53-45dc-a457-4c2ca9a0e20a'
    },
    'Media Queries' => {
      title: 'Media Queries',
      description: "Finally, let's learn about media queries so you can change the layout of your site based on the size of the browser window.",
      is_project: false,
      github_path: '/advanced_html_css/responsive_design/media_queries.md',
      identifier_uuid: '61698363-3d2e-4f25-99d5-29ccdefdc856'
    },
    'Homepage' => {
      title: 'Homepage',
      description: 'Create a fully responsive homepage.',
      is_project: true,
      accepts_submission: true,
      previewable: true,
      github_path: '/advanced_html_css/responsive_design/project_homepage.md',
      identifier_uuid: 'd99b0c9d-cc6c-44e6-bab0-1c9a83edcfa3'
    },
  }
end
