
# The SaaS Factory

## The standard model for launching free, open source, SaaS products faster
  
Our vision is that a programmer with a regular job can, with this boilerplate, launch a side project in a weekend.

### Boilerplate architecture
![enter image description here](https://ik.imagekit.io/cluzstudio/01-cluzstudio/boilerplate_zpfPgAExv.png?updatedAt=1703706286400)
  
- Frontend App **(This repo)**:  Vite;  React; Tailwind CSS;  Apollo Client; Graphql; TypeScript 

- [Backend App](https://github.com/The-SaaS-Factory/backend-saas-boilerplate-node-apollo-graphql-TS) : Node; Express; [Apollo Server](https://www.apollographql.com/docs/apollo-server/); [Graphql](https://graphql.org/); [Prisma ](https://www.prisma.io/); TypeScript

- Integrations: Stripe, [Imagekit](https://imagekit.io/), [Loops So](https://loops.so/)

  ![enter image description here](https://ik.imagekit.io/cluzstudio/01-cluzstudio/browser%20mockup_awCrgH-4x.png?updatedAt=1703714967935)

  
## Demo
[https://demo.thesaasfactory.dev/](https://demo.thesaasfactory.dev/)

 **Super Admin Credentials**
   - email: thesaasfactory@gmail.com
   - pass: Demo@2023

  **Stripe test card number**
   - 4242 4242 4242 4242
   - 12/28
   - 123 

## Documentation 
[https://docs.thesaasfactory.dev/](https://docs.thesaasfactory.dev/)

## Top Features

1.  **GraphQL with Apollo :**  The GraphQL-based architecture makes data retrieval efficient, while Apollo Client simplifies application state management, enhancing user experience and reducing server load.
    
2.  **TypeScript:**  Leverage the power of TypeScript's static typing system to detect and prevent errors at compile time, providing increased confidence and productivity during development.
    
3.  **React:**  Build dynamic and responsive user interfaces with React, the leading JavaScript library for creating reusable and easily maintainable components.
    
4.  **Tailwind CSS:**  Streamline the design and styling of your application with Tailwind CSS, a utility-first framework that enables you to quickly customize your application's appearance without sacrificing code readability.
    
5.  **Prisma:**  Prisma is one of the best current ORMs to manage databases
    
6.  **Clerk:**  Powerful authentication manager allowing you to add social providers and manage organizations, permissions and roles What you avoid doing by using this boilerplate
    
7.  **Stripe:**  Stripe is the best payment gateway to manage subscriptions and payments

## Integrated modules

 - [x] Landing Page 
 - [x] Responsive 
 - [x] DarkTheme
 - [x] Dashboards for Admins and Super Admin
 - [x] Kpis Module
 - [x] Notifications Module
 - [x] Organization Switcher (Clerk)
 - [x] Organization Profile (Clerk)
 - [x] User Profile (Clerk)
 - [x] Ticket Support Module
 - [x] Settings Module for Super Admins
 - [x] Marketing Module
 - [x] Stripe Invoices and memberships Module
 - [x] Imagekit Integration for Media Storage
 - [x] Internal components to help you create cruds quickly
 - [x] User management
 - [x] Organization management
 - [x] Subscriptions management
 - [x]  Subscriptions plans management
 - [x] Membership plan capabilities support


## Road map
For January:
 - [ ] Improving TypeScript typing
 - [ ] Improve core components
 - [ ] Add translations to Spanish and Portuguese

 ## Screenshots
 ![enter image description here](https://ik.imagekit.io/cluzstudio/01-cluzstudio/screely-1703716752301_xVVckTVwk.png?updatedAt=1703716824119)![enter image description here](https://ik.imagekit.io/cluzstudio/01-cluzstudio/screely-1703720465815_uSi8i2AMI.png?updatedAt=1703720616191)
![enter image description here](https://ik.imagekit.io/cluzstudio/01-cluzstudio/screely-1703721109176_NE5QpcmxF.png?updatedAt=1703721147856)
***Start building your saas FASTER***