<div align="center">

# Tensorflow AI

This repository contains code for building a chatbot using TensorFlow and Keras. The chatbot is designed to respond to user queries and prompts with contextually relevant answers.

</div>

## Introduction

This chatbot project utilizes deep learning techniques implemented with TensorFlow and Keras to create a conversational agent capable of understanding and generating natural language responses. The model architecture follows a sequence-to-sequence framework with an encoder-decoder architecture using LSTM layers.

## Features

- **Natural Language Understanding**: The chatbot can interpret user queries and prompts using natural language processing techniques.
- **Contextual Responses**: The chatbot generates contextually relevant responses based on the input it receives.
- **Training and Inference**: The model can be trained on custom datasets and used for real-time inference to interact with users.

<div align="center">

## ☕ [Support my work on Ko-Fi](https://ko-fi.com/thatsinewave)

</div>

## Installation

To run the chatbot locally, follow these steps:

1. Clone this repository to your local machine.
2. Install the required dependencies by running `pip install -r requirements.txt`.
3. Run the `tensorflow-ai.py` script to train the model and start the chat interface.

<div align="center">

# [Join my discord server](https://discord.gg/2nHHHBWNDw)

</div>

## Usage

Once the chatbot is installed and running, you can interact with it by typing queries or prompts into the command line interface. The chatbot will respond with generated text based on the input it receives.

## Data

The `data.py` file contains a dataset of input-output pairs used for training the chatbot. Each pair consists of a user query and the corresponding response generated by the chatbot. The dataset covers a wide range of topics to ensure the chatbot's responses are diverse and contextually appropriate.

## Model

The model architecture consists of an encoder-decoder framework with LSTM layers. The encoder processes the input sequence, while the decoder generates the output sequence based on the encoded input. The model is trained using a sequence-to-sequence approach with teacher forcing and sparse categorical cross-entropy loss.

## Contributing

Contributions to this project are welcome! Feel free to open issues for bugs or feature requests, or submit pull requests with improvements to the codebase.

## License

This project is licensed under the [MIT License](LICENSE).
