Does It ARM
----

Lists of reported app support for macOS on ARM so far. 

Any comments, suggestions? [Let us know!](https://github.com/ThatGuySam/doesitarm/issues). PRs welcome :) 

[Search List](https://doesitarm.com/) | [Get Email Updates](https://doesitarm.com/embed-subscribe/) | [🧪 Apple Silicon App Test](https://doesitarm.com/apple-silicon-app-test/) | [Does It ARM on Twitter](https://twitter.com/DoesItARM)



[Do you want to help with Apple Silicon testing?](https://github.com/ThatGuySam/doesitarm/issues?q=is%3Aissue+is%3Aopen+label%3A%22Needs+M1+Testing%22+)


## Sponsors

Does It ARM is an open-source project with its ongoing development made possible by the support of Affiliate Partners such as Notion. If you'd like to join them, feel free to reach out on [Twitter](https://twitter.com/ThatGuySam). 
<br>
<br>
[Work Faster. Automate Tedious Tasks with Notion AI](https://affiliate.notion.so/ze5500b4ciby-4y5a7)



## Legend
* ✅ Yes, Native Apple Silicon Support
* ✳️ Yes, works via Translation or Virtualization
* ⏹ No, not working at all but support is in development
* 🚫 No, not yet supported only works on Intel-based Macs
* 🔶 Unknown, more info needed


## Categories
* [Developer Tools](#developer-tools)
* [Science and Research Software](#science-and-research-software)
* [Music and Audio Tools](#music-and-audio-tools)
* [Photo and Graphic Tools](#photo-and-graphic-tools)
* [Video and Motion Tools](#video-and-motion-tools)
* [Live Production and Performance](#live-production-and-performance)
* [3D and Architecture](#3d-and-architecture)
* [Productivity Tools](#productivity-tools)
* [Entertainment and Media Apps](#entertainment-and-media-apps)
* [Social and Communication](#social-and-communication)
* [VPNs, Security, and Privacy](#vpns-security-and-privacy)
* [System Tools](#system-tools)


## Additional Resources
* [More Apple Silicon and ARM Lists](#more-apple-silicon-and-arm-lists)
* [Apple Silicon Testing Tools](#apple-silicon-testing-tools)
* [Youtube Apple Silicon Playlists](#youtube-apple-silicon-playlists)


## The Apps
Apps are manually reported here and automatically reported from the internet via the Does It ARM Bot. 
<br>
These are the manually reported apps. You can search all apps on the website.  

[🔍 Search all apps](https://doesitarm.com/)

#### Developer Tools

* [.NET](https://dotnet.microsoft.com/download) - ⏹ .NET Core nightly builds available, ongoing work for other frameworks - [Project Board](https://github.com/orgs/dotnet/projects/18)
* [Adobe XD](https://www.adobe.com/products/xd.html) - ✅ Yes, Native Apple Silicon Support as of v42 - [Official Article](https://helpx.adobe.com/in/xd/kb/big-sur-apple-silicon-rosetta-emulation.html) [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [Alacritty](https://github.com/alacritty/alacritty/releases) - ✳️ Yes, works via Rosetta 2 Translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/600#issue-834311784)
* [Anaconda](https://www.anaconda.com/products/individual#Downloads) - ✅ Yes, Native Apple Silicon Support as of v2022.05 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/123#issuecomment-1149490298)
* [Android Studio](https://developer.android.com/studio) - ✳️ Yes, works via Rosetta 2 with native support in preview. - [Source](https://github.com/ThatGuySam/doesitarm/issues/48#issuecomment-732143252) [Native Preview](https://androidstudio.googleblog.com/2021/04/android-studio-arctic-fox-canary-15.html)
* [Apache Maven](https://maven.apache.org/download.cgi) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/215#issuecomment-742910724)
* [App Preview Video Converter](https://apps.apple.com/us/app/app-preview-video-converter/id1137451860) - ✅ Yes, full native support as of v1.7.4 - [Release Notes](https://www.bridgetech.io)
* [AppCode](https://www.jetbrains.com/objc/download/) - ✅ Yes, Native Apple Silicon Support as of v2020.3.1 - [Release Notes](https://blog.jetbrains.com/objc/2021/01/appcode-2020-3-1/) [Verification](https://github.com/ThatGuySam/doesitarm/issues/687#issue-913066017)
* [Apple Transporter](https://apps.apple.com/app/transporter/id1450874784?mt=12) - ✅ Yes, Full Native Apple Silicon Support as of v1.2.1
* [Aptakube](https://aptakube.com/) - ✅ Yes, Native Apple Silicon Support
* [Aptana Studio](https://github.com/aptana/studio3/releases) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/16#issuecomment-869452511)
* [Arduino IDE](https://www.arduino.cc/en/software) - ✳️ Reported working via Rosetta with native support currently in development - [Issue](https://github.com/arduino/Arduino/issues/10836)
* [Asset Catalog Creator](https://apps.apple.com/us/app/asset-catalog-creator-pro/id809625456) - ✅ Yes, full native support as of v3.7.4 - [Release Notes](https://www.bridgetech.io) [View on Setapp](https://setapp.sjv.io/c/2708043/905851/5114)
* [Atom](https://atom.io/) - ✳️ Yes, works via Rosetta 2 - [Source](https://github.com/ThatGuySam/doesitarm/issues/307#issue-748524692) [Github Issue](https://github.com/atom/atom/issues/21078). 
* [Attributed String Creator](https://apps.apple.com/us/app/attributed-string-creator-pro/id730928349) - ✅ Yes, full native support as of v1.9.6 - [Release Notes](https://www.bridgetech.io)
* [Bazel](https://bazel.build/) - ✅ Yes, Full Native Apple Silicon Support as of v4.1 - [Release Notes](https://blog.bazel.build/2021/05/21/bazel-4-1.html)
* [BBEdit](https://www.barebones.com/products/bbedit/download.html) - ✅ Yes, full native support as of v13.5 - [Release Notes](https://www.barebones.com/support/bbedit/notes-13.5.html)
* [Beyond Compare](https://www.scootersoftware.com/) - ✳️ Yes, works via Rosetta 2 - [Facebook Post](https://www.facebook.com/ScooterSoftware/posts/5178865142127412)
* [Caddy](https://caddyserver.com/download) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/577#issuecomment-783684858)
* [Charles Web Debugging Proxy](https://www.charlesproxy.com/download/) - ✅ Yes, Full Native Apple Silicon Support as of v5.0b7 - [Release Notes](https://www.charlesproxy.com/documentation/version-history/)
* [Chromium](https://www.chromium.org/getting-involved/download-chromium) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/732#issue-952269447)
* [CLion](https://www.jetbrains.com/clion/download/#section=mac) - ✅ Yes, full native support as of v2020.3.1
* [CocoaPods](https://cocoapods.org/) - ✳️ Yes, it works via Rosetta 2 - [Fully Native on Homebrew](https://doesitarm.com/formula/cocoapods/) [Issue](https://github.com/CocoaPods/CocoaPods/issues/9907)
* [Cocos Creator](https://www.cocos.com/en/creator/download) - ✳️ Yes, works via Rosetta 2 as of v2.4.5 - [Official Article](https://www.cocos.com/en/cocos-creator-2-4-5-supports-apples-new-m1-chip) [Release Notes](https://www.cocos.com/en/creator/download)
* [CodeKit](https://codekitapp.com/) - ✅ Yes, Native Apple Silicon Support as of v3.14.2 - [Release Notes](https://codekitapp.com/updates/#34018)
* [CodeRunner](https://coderunnerapp.com/) - ✳️ Yes, works via Rosetta 2 Translation with native support in beta - [Verification](https://github.com/ThatGuySam/doesitarm/issues/486#issuecomment-806065818)
* [Core Shell](https://coreshell.app/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/core-shell)
* [CotEditor](https://coteditor.com) - ✅ Yes, full native support as of 4.0.0 - [App Store](https://itunes.apple.com/app/coteditor/id1024640650)
* [Cyberduck](https://cyberduck.io/download/) - ✅ Yes, Native Apple Silicon Support as of v8.1.0 - [Release Notes](https://cyberduck.io/changelog/)
* [Dash for macOS](https://kapeli.com/dash) - ✅ Yes, Full Native Apple Silicon Support as of v6 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/575#issue-812547431) [Release Notes](https://blog.kapeli.com/dash-6)
* [DataGrip](https://www.jetbrains.com/datagrip/download/#section=mac) - ✅ Yes, full native support as of v2020.3.1
* [DBeaver](https://dbeaver.io/) - ✅ Yes, Native Apple Silicon Support as of v21.2.2 - [Release Notes](https://dbeaver.io/2021/10/03/dbeaver-21-2-2/)
* [Deno](https://deno.land/) - ✅ Yes, Full Native Apple Silicon Support - [Issue](https://github.com/denoland/deno/issues/8346)
* [Docker](https://hub.docker.com/editions/community/docker-ce-desktop-mac) - ✅ Yes, Native Apple Silicon Support as of v4.3.0 - [Release Notes](https://docs.docker.com/desktop/mac/release-notes/#docker-desktop-430)
* [Dreamweaver](https://www.adobe.com/products/dreamweaver.html) - ✅ Yes, Native Apple Silicon Support as of v21.2 - [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [Eclipse IDE](https://www.eclipse.org/downloads/) - ✳️ Yes, runs via Rosetta 2 translation and natively for SDK - [Release Details](https://download.eclipse.org/eclipse/downloads/drops4/R-4.20-202106111600/) [Verification](https://github.com/ThatGuySam/doesitarm/issues/626#issue-860190467)
* [eDEX-UI](https://github.com/GitSquared/edex-ui) - ✅ Yes, Full Native Apple Silicon Support reported as of v2.2.6 - [Release Notes](https://github.com/GitSquared/edex-ui/releases/tag/v2.2.6)
* [Electron Framework](https://www.electronjs.org/releases/stable) - ✅ Yes, full native support as of v11.0 - [Announcement](https://www.electronjs.org/blog/apple-silicon)
* [Emacs](https://www.gnu.org/software/emacs/) - ✅ Yes, Full Native Apple Silicon Support reported as of v27.2-1 - [Release Notes](https://emacsformacosx.com/download/emacs-builds/Emacs-27.2-2.changes)
* [Espresso for macOS](https://www.espressoapp.com/) - ✳️ Yes, works via Rosetta 2 translation - [Release Notes](https://www.espressoapp.com/updates/) [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/espresso)
* [FFmpeg](https://ffmpeg.org/download.html) - ✅ Yes, Full Native Apple Silicon Support via Homebrew - [Homebrew ARM Binary Available](https://formulae.brew.sh/formula/ffmpeg#default)
* [FileMaker](https://www.claris.com/filemaker/) - ✅ Yes, Native Apple Silicon Support as of v19.3.1 - [Release Notes](https://support.claris.com/s/answerview?anum=000035590&language=en_US)
* [Filezilla](https://filezilla-project.org/) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/17#issuecomment-729976000)
* [Flutter](https://flutter.dev/docs/get-started/install/macos) - ✅ Yes, Native Apple Silicon Support as of v3.0.0 - [Release Notes](https://docs.flutter.dev/release/whats-new#11-may-2022-google-io-2022-flutter-3-release)
* [Flycut](https://apps.apple.com/us/app/flycut-clipboard-manager/id442160987?mt=12) - ✅ Yes, Full Native Apple Silicon Support - [Release Notes](https://github.com/TermiT/Flycut/releases/tag/1.9.6)
* [Fork](https://git-fork.com/) - ✅ Yes, full native support as of v2.1.0 - [Release notes](https://git-fork.com/releasenotes)
* [ForkLift](https://binarynights.com/) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/455#issuecomment-1027795207)
* [GCC ARM Embedded](https://developer.arm.com/tools-and-software/open-source-software/developer-tools/gnu-toolchain/gnu-rm) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/105#issuecomment-841834514)
* [Genymotion](https://www.genymotion.com/download/) - 🚫 No, not yet supported only works on Intel-based Macs - [Official Article](https://support.genymotion.com/hc/en-us/articles/360017897157?input_string=genymotion+may+cannot+run+on+mac+m1+chips) 
* [Git Version Control](https://git-scm.com/download/mac) - ✅ Yes, Full Native Apple Silicon Support - [Source](https://github.com/ThatGuySam/doesitarm/issues/54#issuecomment-730568063)
* [Gitfox](https://www.gitfox.app/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.com/apps/gitfox)
* [GitHub Desktop](https://desktop.github.com/) - ✅ Yes, Native Apple Silicon Support as of v2.8.3 - [Release Notes](https://desktop.github.com/release-notes/)
* [GitKraken](https://www.gitkraken.com/download) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/244#issuecomment-736760318)
* [GNU Compiler Collection](https://gcc.gnu.org/) - ✳️ Yes, runs via Rosetta 2 - [Source](https://github.com/ThatGuySam/doesitarm/issues/105#issuecomment-732795155) [Bugzilla Issue](https://gcc.gnu.org/bugzilla/show_bug.cgi?id=96168)
* [Go (golang)](https://golang.org/) - ✅ Yes, full native support as of 1.16 - [Golang M1 Benchmark](https://docs.google.com/spreadsheets/d/1g4U7LAImfEcXRihJbySZcRr32tn6WSWAtslfXltds58/edit#gid=342445681) [Release Notes](https://tip.golang.org/doc/go1.16) [Go 1.16 is released](https://blog.golang.org/go1.16)
* [Godot Engine](https://godotengine.org/download/osx) - ✅ Yes, Full Native Apple Silicon Support as of v3.3 - [Release Notes](https://godotengine.org/article/godot-3-3-has-arrived#macos)
* [GoLand](https://www.jetbrains.com/go/download/#section=mac) - ✅ Yes, full native support as of v2020.3.1
* [Gradle Build Tool](https://gradle.org/) - ✅ Yes, Native Apple Silicon Support as of v6.9 - [Release Notes](https://docs.gradle.org/6.9/release-notes.html)
* [GraphiQL](https://www.electronjs.org/apps/graphiql) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/713#issue-932175350)
* [hadolint](https://github.com/hadolint/hadolint) - ✳️ Yes, works via Rosetta 2 - [Report #1](https://github.com/Homebrew/brew/issues/10744#issuecomment-787498421)
* [Haskell](https://www.haskell.org/platform/mac.html) - ✳️ Yes, runs via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/73#issuecomment-826065143)
* [Hex Fiend](https://github.com/HexFiend/HexFiend/releases) - ✅ Yes, full native support as of v2.14.0 - [Source](https://github.com/ThatGuySam/doesitarm/issues/429)
* [Homebrew](https://brew.sh/) - ✅ Yes, fully supported as of v3.0.0 - [Release Notes](https://brew.sh/2021/02/05/homebrew-3.0.0/). 
* [Hopper Disassembler](https://www.hopperapp.com/download.html) - ✅ Yes, Full Native Apple Silicon Support as of v4.6 - [Release Notes](https://www.hopperapp.com/blog/?p=263)
* [IDA Pro](https://www.hex-rays.com/products/ida/support/download_freeware/) - ✅ Yes, Native Apple Silicon Support as of v7.6 - [Release Notes](https://hex-rays.com/products/ida/news/7_6/)
* [Insomnia Core](https://insomnia.rest/download/) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/456#issuecomment-748260642)
* [Insomnia Designer](https://insomnia.rest/download/) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/456#issuecomment-748260642)
* [IntelliJ IDEA](https://www.jetbrains.com/idea/download/#section=mac) - ✅ Yes, fully supported as of v2020.3.1 - [Release Notes](https://confluence.jetbrains.com/display/IDEADEV/IntelliJ+IDEA+2020.3.1+%28203.6682.168+build%29+Release+Notes)
* [iTerm](https://iterm2.com/downloads.html) - ✅ Yes, fully supported as of v3.4.0 - [PR](https://github.com/gnachman/iTerm2/pull/421)
* [JetBrains MPS](https://www.jetbrains.com/mps/download/#section=mac) - ✅ Yes, Native Apple Silicon Support as of v2020.3.1 - [Release Notes](https://blog.jetbrains.com/mps/2021/02/apple-silicon-support-comes-to-jetbrains-mps-2020-3-1/) [Verification](https://github.com/ThatGuySam/doesitarm/issues/688#issue-913068416)
* [JetBrains Rider](https://www.jetbrains.com/rider/download/#section=mac) - ✅ Yes, Native Apple Silicon Support as of v2021.3 - [Release Notes](https://www.jetbrains.com/rider/whatsnew/) [Verification](https://www.jetbrains.com/rider/download/#section=mac)
* [Jetpack Compose for Desktop](https://www.jetbrains.com/lp/compose/) - ✅ Yes, Full Native Apple Silicon Support - [Changelog](https://github.com/JetBrains/compose-jb/blob/a4d59048f50c96970368e884925fd59b1a31ed12/CHANGELOG.md#m2-dec-2020)
* [Julia Language](https://julialang.org/downloads/) - ✅ Yes, Native Apple Silicon Support as of v1.7.0 Beta 3 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/734#issuecomment-891139715) [Github Issue](https://github.com/JuliaLang/julia/issues/36617)
* [Kaleidoscope](https://kaleidoscope.app/download) - ✅ Yes, Native Apple Silicon Support as of v3.0 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/785) [Release Notes](https://kaleidoscope.app/release-notes)
* [KiCad EDA](https://kicad.org/download/macos/) - ✅ Yes, Full Native Apple Silicon Support - [Release Notes](https://www.kicad.org/blog/2023/02/Version-7.0.0-Released/)
* [kitty](https://github.com/kovidgoyal/kitty/releases) - ✅ Yes, Full Native Apple Silicon Support - [Github Issue](https://github.com/kovidgoyal/kitty/issues/3238)
* [Lens Studio](https://lensstudio.snapchat.com/download/) - ✳️ Yes, works via Rosetta 2 translation - [Supported Hardware](https://lensstudio.snapchat.com/download/)
* [LLVM Clang](https://releases.llvm.org/download.html) - ✳️ Yes, it works via Rosetta 2 - [Apple Forums](https://developer.apple.com/forums/thread/649992)
* [LTspice](https://www.analog.com/en/design-center/design-tools-and-calculators/ltspice-simulator.html) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/421#issuecomment-1116859670)
* [MacDown](https://macdown.uranusjr.com/) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/382)
* [MacPorts](https://www.macports.org/install.php) - ✳️ Yes, some ports are native while others work via Rosetta 2. - [Discussion](https://github.com/ThatGuySam/doesitarm/issues/302). 
* [MAMP](https://www.mamp.info/en/mamp/mac/) - ✅ Yes, Native Apple Silicon Support as of v6.4 - [Release Notes](https://www.mamp.info/en/release-notes/mac/)
* [MongoDB](https://www.mongodb.com/try/download/community) - ✅ Yes, Native Apple Silicon Support as of v6.0.0 - [Issue](https://jira.mongodb.org/browse/SERVER-50115)
* [MongoKitten](https://apps.apple.com/us/app/id1484086700) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/502#issue-778010353)
* [Mono MDK](https://www.mono-project.com/download/stable/) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/722#issue-947000557)
* [Mutagen](https://mutagen.io/documentation/introduction/installation) - ✅ Yes, Native Apple Silicon Support as of v0.12.0 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/762#issuecomment-962439413)
* [MySQL Community Server](https://dev.mysql.com/downloads/) - ✅ Yes, Native Apple Silicon Support as of v8.0.26 - [Release Notes](https://dev.mysql.com/doc/relnotes/mysql/8.0/en/news-8-0-26.html) [Source](https://github.com/ThatGuySam/doesitarm/issues/173#issuecomment-730553003)
* [MySQL Workbench](https://dev.mysql.com/downloads/) - ✳️ Yes, works via Rosetta 2 for v8.0.21 with issues reported on newer versions - [Source](https://github.com/ThatGuySam/doesitarm/issues/173#issuecomment-730553003) [Issues](https://github.com/ThatGuySam/doesitarm/issues/173#issuecomment-763269306)
* [Navicat Premium](https://www.navicat.com/en/products/navicat-premium) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/161#issuecomment-759768321)
* [NixOS](https://nixos.org/download.html) - ✅ Yes, Native Apple Silicon Support - [Github Issue](https://github.com/NixOS/nixpkgs/issues/95903#issuecomment-914061347)
* [NodeJS](https://nodejs.org/en/) - ✅ Yes, Full Native Apple Silicon Support as of v16 - [M1 Benchmark](https://docs.google.com/spreadsheets/d/1g4U7LAImfEcXRihJbySZcRr32tn6WSWAtslfXltds58/edit#gid=607735373) [Version Support](https://github.com/ThatGuySam/doesitarm/issues/299#issuecomment-733210648) [Github Issue](https://github.com/nodejs/TSC/issues/886)
* [Nova](https://nova.app) - ✅ Yes, Full Native Apple Silicon Support as of v3 - [Official Tweet](https://twitter.com/panic/status/1326977997732134912?s=20)
* [OCaml](https://ocaml.org/) - ✅ Yes, Native Apple Silicon Support as of v4.12.0 - [Release Notes](https://github.com/ocaml/ocaml/releases/tag/4.12.0)
* [Onivim2](https://v2.onivim.io/early-access-portal) - ✳️ Yes, works via Rosetta 2 Translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/601#issue-834313049) [Github Issue](https://github.com/onivim/oni2/issues/2708)
* [OpenJDK](https://openjdk.java.net/install/) - ✅ Yes, Full Native Apple Silicon Support via Azul Zulu
Builds - [Java on M1 Benchmarks](https://docs.google.com/spreadsheets/d/1g4U7LAImfEcXRihJbySZcRr32tn6WSWAtslfXltds58/edit#gid=1469348209) [Azul Builds](https://www.azul.com/downloads/zulu-community/?os=macos&architecture=arm-64-bit&package=jdk) [Early Access Builds](https://github.com/microsoft/openjdk-aarch64/releases) [JEP Ticket](https://openjdk.java.net/jeps/391) [Discussion](https://bugs.openjdk.java.net/browse/JDK-8251280)
* [OpenOCD](https://openocd.org/) - ✅ Yes, Native Apple Silicon Support - [Homebrew Listing](https://formulae.brew.sh/formula/open-ocd#default)
* [Oracle JDK](https://www.oracle.com/java/technologies/downloads/) - ✅ Yes, Native Apple Silicon Support as of v17 - [Release Notes](https://www.oracle.com/java/technologies/javase/17all-relnotes.html)
* [Oracle SQL Developer](https://www.oracle.com/database/sqldeveloper/technologies/download/) - ✅ Yes, Native Apple Silicon Support as of v20.2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/1014#issue-1682073611)
* [Pants for Python](https://www.pantsbuild.org/) - ✅ Yes, Native Apple Silicon Support - [Official Article](https://blog.pantsbuild.org/how-we-added-apple-silicon-support-to-pants/)
* [Parallels Desktop](https://prf.hn/l/6qOdLPB) - ✅ Yes, Initial Native Apple Silicon Support for Windows 10 on ARM as of v16 - [Release Notes](https://prf.hn/l/7QA4VvN) [Blog Post](https://prf.hn/l/Kmo9gqd)
* [Paw](https://paw.cloud/) - ✅ Yes, Full Native Apple Silicon Support as of v3.2.1 - [Release Notes](https://paw.cloud/updates/3.2.1) [View on Setapp](https://setapp.sjv.io/c/2708043/385092/5114)
* [Pelemay](https://github.com/zeam-vm/pelemay/releases) - ✅ Yes, Full Native Apple Silicon Support as of v0.0.14 - [Release Notes](https://github.com/zeam-vm/pelemay/releases/tag/0.0.14)
* [PhpStorm](https://www.jetbrains.com/phpstorm/download/#section=mac) - ✅ Yes, full native Apple Silicon support as of v2020.3.1
* [pkgsrc](https://pkgsrc.joyent.com/install-on-osx/) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/743#issue-971743459)
* [Postico](https://eggerapps.at/postico/) - ✅ Yes, Native Apple Silicon Support as of v1.5.15 - [Release Notes](https://eggerapps.at/postico/docs/v1.5.15/changelist.html) - [Verification](https://github.com/ThatGuySam/doesitarm/issues/851)
* [Postman](https://www.postman.com/downloads/) - ✅ Yes, Native Apple Silicon Support as of v9.0.7 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/795#issue-1031318387) [Release Notes](https://www.postman.com/downloads/release-notes/)
* [PowerShell Core](https://github.com/PowerShell/PowerShell) - ✅ Yes, Native Apple Silicon Support as of v7.2.0 - [Release Notes](https://github.com/PowerShell/PowerShell/releases/tag/v7.2.0)
* [Processing IDE](https://processing.org/) - ✅ Yes, Native Apple Silicon Support as of v4.0.0 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/342#issuecomment-869373970)
* [Proxyman](https://proxyman.io) - ✅ Yes, fully supported ARM and Intel Chip - [Issue](https://github.com/ProxymanApp/Proxyman/issues/686) [View on Setapp](https://setapp.sjv.io/c/2708043/635279/5114)
* [psycopg2](https://www.psycopg.org/) - ✅ Yes, Native Apple Silicon Support as of v2.8.6 via 1 or more workarounds - [Workaround #1](https://github.com/psycopg/psycopg2/issues/1200#issuecomment-820571339) [Workaround #2](https://github.com/psycopg/psycopg2/issues/1216#issuecomment-767892042) [Workaround #3](https://github.com/ThatGuySam/doesitarm/issues/628#issue-862441710)
* [Pure Data](https://puredata.info/downloads/pure-data) - ✳️ Yes, works via Rosetta and builds as Apple Silicon - [Verification](https://github.com/ThatGuySam/doesitarm/issues/694#issue-916037556)
* [PyCharm](https://www.jetbrains.com/pycharm/download/#section=mac) - ✅ Yes, full native support as of v2020.3.1
* [PyPy3](https://www.pypy.org/download.html) - ✳️ Yes, works via Translation or Virtualization - [GitLab Issue](https://foss.heptapod.net/pypy/pypy/-/issues/3283) [Mac meets Arm64](https://www.pypy.org/posts/2020/12/mac-meets-arm64-940822335619099039.html) [Verification](https://github.com/ThatGuySam/doesitarm/issues/916)
* [Python](https://www.python.org/) - ✅ Yes, reported working for v2.7.16, v3.8.2, and v3.9 - [PyPerformance Benchmarks](https://docs.google.com/spreadsheets/d/1g4U7LAImfEcXRihJbySZcRr32tn6WSWAtslfXltds58/edit#gid=1795089557) [Python Tracker](https://bugs.python.org/issue41100) [Github Issue](https://github.com/python/cpython/pull/22855) [Github Issue #2](https://github.com/ThatGuySam/doesitarm/issues/111)
* [PyTorch](https://pytorch.org/) - ✅ Yes, Initial Native Apple Silicon Support for CPU only - [GPU Acceleration Status](https://github.com/pytorch/pytorch/issues/47702) [Report Update](https://github.com/ThatGuySam/doesitarm/issues/432)
* [Qt Creator](https://www.qt.io/product/development-tools) - ✅ Yes, Native Apple Silicon Support as of 6.0.0 - [Official Article](https://www.qt.io/blog/qt-creator-6-released) [Release Notes](https://code.qt.io/cgit/qt-creator/qt-creator.git/tree/dist/changes-6.0.0.md) [Verification](https://github.com/ThatGuySam/doesitarm/issues/836#issue-1070570518)
* [Qt Framework](https://www.qt.io/product/framework) - ✅ Yes, Native Apple Silicon Support as of 6.2.0 - [Official Article](https://www.qt.io/blog/qt-on-apple-silicon)
* [RapidWeaver](https://www.realmacsoftware.com/rapidweaver/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [Release Notes](https://www.realmacsoftware.com/rapidweaver/releasenotes/) [View on Setapp](https://setapp.sjv.io/rapidweaver)
* [React Native](https://reactnative.dev/) - ✳️ Yes, works on supported Node versions - [Check Node Support](https://doesitarm.com/app/nodejs/)
* [React Native Debugger](https://github.com/jhen0409/react-native-debugger) - ✅ Yes, Full Native Apple Silicon Support as of v0.12.1 - [Release Notes](https://github.com/jhen0409/react-native-debugger/releases/tag/v0.12.1)
* [Redis](https://redis.io/download) - ✅ Yes, full native Apple Silicon support as of v6 - [v6.0.9 Benchmark](https://docs.google.com/spreadsheets/d/1g4U7LAImfEcXRihJbySZcRr32tn6WSWAtslfXltds58/edit#gid=1002181585) [Verification](https://github.com/ThatGuySam/doesitarm/issues/298)
* [Reveal App](https://revealapp.com/free-trial/) - ✅ Yes, Native Apple Silicon Support as of v28 - [Release Notes](https://revealapp.com/updates/28/) [Verification](https://github.com/ThatGuySam/doesitarm/issues/682#issue-909119625)
* [Robo 3T (formerly Robomongo)](https://robomongo.org/download) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/175#issuecomment-782071460)
* [Royal TSX](https://www.royalapps.com/ts/mac/features) - ✅ Yes, Native Apple Silicon Support as of v5.0.0 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/523#issuecomment-869325607)
* [RubyMine](https://www.jetbrains.com/ruby/download/#section=mac) - ✅ Yes, full native support as of v2020.3.1
* [RunJS](https://runjs.app) - ✅ Yes, Native Apple Silicon Support as of v1.14.0
* [Rust](https://www.rust-lang.org/) - ✅ Yes, full native support (Tier 2) as of v1.49 - [Issue](https://github.com/rust-lang/rust/issues/73908#issue-648613557) [Official Blog Post](https://blog.rust-lang.org/2020/12/31/Rust-1.49.0.html)
* [Sequel Ace](https://github.com/Sequel-Ace/Sequel-Ace/releases) - ✅ Yes, Full Native Apple Silicon Support as of v3.0.1 - [Release Notes](https://github.com/Sequel-Ace/Sequel-Ace/releases/tag/production%2F3.0.1-3008)
* [ShellCheck](https://github.com/koalaman/shellcheck/releases) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/693#issue-916004182)
* [Simon for Mac](https://www.dejal.com/simon/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/simon)
* [Sketch](https://www.sketch.com/) - ✅ Yes, Full Native Apple Silicon Support as of v70 - [Release Notes](https://www.sketch.com/updates/#version-70)
* [SmartGit](https://www.syntevo.com/smartgit/) - ✳️ Yes, works via Rosetta 2 Translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/541#issuecomment-806068252)
* [SourceTree](https://www.sourcetreeapp.com/) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/200)
* [SubEthaEdit](https://subethaedit.net/) - ✅ Yes, full native Apple Silicon Support as of v5.1.5 - [Release Notes](https://github.com/subethaedit/SubEthaEdit/releases/tag/SubEthaEdit-MacFull-5.1.5)
* [Sublime Text](https://www.sublimetext.com/) - ✅ Yes, Native Apple Silicon Support as of Build 4107 - [Release Notes](https://gist.github.com/jfcherng/7bf4103ea486d1f67b7970e846b3a619#build-4100)
* [Surge](https://nssurge.com/) - ✅ Yes, full native Apple Silicon Support as of v4.0.0 - [Issue](https://github.com/ThatGuySam/doesitarm/issues/157)
* [TablePlus](https://tableplus.com/) - ✅ Yes, Full Native Apple Silicon Support as of Build 352 - [Release Notes](https://twitter.com/TablePlus/status/1327650704295489536) [View on Setapp](https://setapp.sjv.io/c/2708043/455094/5114)
* [TeaCode](https://www.apptorium.com/teacode) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/teacode)
* [TensorFlow](https://www.tensorflow.org/) - ✅ Yes, Initial Native Apple Silicon Support via Apple's Metal Plugin - [Metal Plugin](https://developer.apple.com/metal/tensorflow-plugin/) [Verification](https://github.com/ThatGuySam/doesitarm/issues/701#issue-920884970)
* [Termius](https://termius.com/) - ✅ Yes, Full Native Apple Silicon Support as of v7.4.1 - [Release Notes](https://docs.termius.com/changelog/desktop)
* [Textmate](https://macromates.com/) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/585#issue-817594010)
* [Tinkerwell](https://tinkerwell.app/) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/592#issue-824958336)
* [Tower](https://www.git-tower.com/mac) - ✅ Yes, Full Native Apple Silicon Support as of v6 - [Release Notes](https://www.git-tower.com/blog/tower-mac-6/)
* [Transmit](https://panic.com/transmit/) - ✅ Yes, Full Native Apple Silicon Support as of v5.7 - [Official Tweet](https://twitter.com/panic/status/1326978002576666624?s=20) [Release Notes](https://library.panic.com/releasenotes/transmit5/#57)
* [Typora](https://typora.io/#download) - ✅ Yes, fully supported as of v0.9.9.36 - [Release Notes](https://typora.io/dev_release.html)
* [Unity](https://store.unity.com/download) - ✳️ Runs via Rosetta with native support currently in development - [CNET Article](https://www.cnet.com/news/microsoft-365-and-adobe-creative-cloud-will-support-mac-arm-natively/#:~:text=At%20its%20annual%20Worldwide%20Developers,which%20it%20calls%20Apple%20silicon.&text=Adobe's%20Creative%20Cloud%20software%20includes,InDesign%2C%20Premiere%20Pro%20and%20Illustrator)
* [UTM](https://mac.getutm.app/) - ✅ Yes, Native Apple Silicon Support as of v3.0.0 - [Release Notes](https://github.com/utmapp/UTM/releases/tag/v3.0.0) [Verification](https://github.com/ThatGuySam/doesitarm/issues/880#issue-1130007382)
* [VirtualBox](https://www.virtualbox.org/wiki/Downloads) - 🚫 No, not yet supported only works on Intel-based Macs - [Discussion](https://forums.virtualbox.org/viewtopic.php?f=8&t=98742)
* [VirtualHostX](https://clickontyler.com/virtualhostx/) - 🚫 Not yet supported only works on Intel-based Macs - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/833643/5114)
* [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/) - ✳️ Yes, works via Rosetta 2 but debugging is not supported - [Verification](https://github.com/ThatGuySam/doesitarm/issues/401#issuecomment-748295469)
* [VisualDiffer](https://apps.apple.com/us/app/visualdiffer/id412386481?ls=1&mt=12) - ✅ Yes, Full Native Apple Silicon Support as of v1.8.0 - [Mantis issue](https://visualdiffer.com/mantis/view.php?id=334)
* [VS Code](https://code.visualstudio.com/) - ✅ Yes, Full Native Apple Silicon Support as of v1.54 - [Release Notes](https://code.visualstudio.com/updates/v1_54)
* [Vysor](https://www.vysor.io/download/) - ✳️ Yes, works via Rosetta 2 - [Tweet](https://twitter.com/vysorapp/status/1329298424278093825) [Source](https://github.com/ThatGuySam/doesitarm/issues/275#issuecomment-747208601)
* [Warp Terminal](https://www.warp.dev/) - ✅ Yes, Native Apple Silicon Support as of v0.2022.01.31.09.03.stable_00 - [Release Notes](https://docs.warp.dev/help/changelog) [Verification](https://github.com/ThatGuySam/doesitarm/issues/882#issue-1130192136)
* [Wave Terminal](https://www.waveterm.dev/) - ✅ Yes, Native Apple Silicon Support as of v0.1.0 - [Release Notes](https://docs.waveterm.dev/releasenotes)
* [WebStorm](https://www.jetbrains.com/webstorm/download/#section=mac) - ✅ Yes, full native support as of v2020.3.1 - [Official Download](https://www.jetbrains.com/webstorm/download/#section=mac)
* [Wechat Devtools](https://developers.weixin.qq.com/miniprogram/dev/devtools/download.html) - ✅ Yes, full native support as of v1.05.2108130 - [Release Notes](https://developers.weixin.qq.com/community/minihome/doc/000cea19598d10ff619c5c8565bc01)
* [Wireshark](https://www.wireshark.org/) - ✳️ Yes, works via Rosetta 2 - [Source](https://github.com/ThatGuySam/doesitarm/issues/336)
* [Xamarin](https://dotnet.microsoft.com/apps/xamarin) - ✳️ Yes, works via Rosetta 2 - [Source](https://github.com/xamarin/xamarin-macios/issues/10005#issue-732495019) [Video Demo](https://doesitarm.com/tv/xamarin-and-visual-studio-on-apple-macbook-pro-13-m1-in-4k-i-rwpspmmlos/)
* [XAMPP](https://www.apachefriends.org/download.html) - ✳️ Yes, works via Rosetta 2 - [Video Demonstration](https://doesitarm.com/tv/watch-this-before-buying-apple-m1-macbook-for-xampp-or-apple-silicon-tests-in-4k-i-ebwwewsis8s/)
* [Xcode](https://apps.apple.com/us/app/xcode/id497799835) - ✅ Yes, Full Native Apple Silicon Support as of v12.2 - [Release Notes](https://developer.apple.com/documentation/xcode-release-notes/xcode-12_2-release-notes)
* [XCOrganizer](https://xcorganizer.com/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/872077/5114)
* [Xojo](https://www.xojo.com/download/) - ✅ Yes, Native Apple Silicon Support as of v2020r2 - [Release Notes](https://docs.xojo.com/Resources:2020r2_Release_Notes)
* [XQuartz](https://www.xquartz.org/index.html) - ✅ Yes, Full Native Apple Silicon Support as of v2.8.0 - [Release Notes](https://www.xquartz.org/releases/index.html)



#### Science and Research Software

* [COMSOL Multiphysics](https://www.comsol.com/comsol-multiphysics) - ✳️ Yes, works via Rosetta 2 - [Report #1](https://www.comsol.com/forum/thread/272202/new-apple-m1-machines-and-rosetta-2-intel-emulator?last=2021-02-04T17:09:35Z) [Report #2](https://www.reddit.com/r/mac/comments/kfp8tg/comsol_with_m1/glvd947?utm_source=share&utm_medium=web2x&context=3)
* [CoppeliaSim](https://www.coppeliarobotics.com/downloads) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/808#issue-1045206608)
* [Dixer](https://dixer.stgo.do/) - ✅ Yes, Native Apple Silicon Support - [Release Notes](https://dixer.stgo.do/Changelog/#170-_-june-03-2021)
* [GeoGebra Classic 5](https://www.geogebra.org/download) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/418#issue-760869359)
* [Gephi](https://gephi.org/users/download/) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/311#issuecomment-869409099)
* [GNU Octave](https://www.gnu.org/software/octave/index.html) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/574#issue-812510611)
* [GraphPad Prism](https://www.graphpad.com/scientific-software/prism/) - ✅ Yes, Full Native Apple Silicon Support as of v9.0.1 - [Release Notes](https://www.graphpad.com/support/faq/prism-901-release-notes/) [Official Article](https://www.graphpad.com/support/faq/prism-mac-big-sur/)
* [IBM SPSS](https://www.ibm.com/analytics/spss-statistics-software) - ✳️ Yes, works via Rosetta 2 - [Official Post](https://community.ibm.com/community/user/datascience/blogs/todd-peterson1/2020/11/20/spss-statistics-on-macos-big-sur-110)
* [JabRef](https://www.jabref.org/) - ✅ Yes, Full Native Apple Silicon Support as of v5.8 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/1001)
* [JMP](https://www.jmp.com/en_us/software/data-analysis-software.html) - ✳️ Yes, works via Rosetta 2 as of v15.2 - [Developer Report](https://community.jmp.com/t5/Discussions/jmp-combatiblity-on-the-apple-M1-mac-book-air/m-p/339577#M58780)
* [LabVIEW](https://www.ni.com/en-us/shop/labview.html) - 🚫 No, not yet stable on under Rosetta 2 - [Official Apple Compatibility](https://www.ni.com/en-us/support/documentation/compatibility/18/labview-and-macos-compatibility.html) [Discussion](https://forums.ni.com/t5/LabVIEW/LabVIEW-on-Apple-Silicon-M1-and-beyond/td-p/4100430?profile.language=en)
* [MATLAB](https://www.mathworks.com/products/get-matlab.html?s_tid=gn_getml) - ✳️ Yes, works via Rosetta 2 as of v9.9.0.1495850 - [MATLAB Forums](https://www.mathworks.com/matlabcentral/answers/641925-is-matlab-supported-on-apple-silicon-macs)
* [Mendeley](https://www.mendeley.com/download-desktop-new/macOS) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/448#issuecomment-751869800)
* [NVivo](https://www.qsrinternational.com/nvivo-qualitative-data-analysis-software/try-nvivo) - ✳️ Yes, works via Rosetta 2 with compatibility patch as of v12.6.1 - [Official Status](https://www.qsrinternational.com/nvivo-qualitative-data-analysis-software/support-services/support-center/user-issues-trending-now)
* [ParaView](https://www.paraview.org/download/) - ✅ Yes, Native Apple Silicon Support as of v5.10 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/89#issuecomment-956451609)
* [QGIS](https://qgis.org/en/site/forusers/download.html) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/313#issuecomment-802492146)
* [RStudio](https://rstudio.com/products/rstudio/download/) - ✳️ Yes, runs via Rosetta 2 with native support in development - [Source](https://github.com/ThatGuySam/doesitarm/issues/36) [Benchmark Info](https://github.com/ThatGuySam/doesitarm/issues/36#issuecomment-735668887)
* [Stata](https://www.stata.com/) - ✅ Yes, Full Native Apple Silicon Support as of v16, update level 10 Nov 2020 - [Blog Post](https://blog.stata.com/2020/11/10/stata-for-mac-with-apple-silicon/)
* [Tableau Desktop](https://www.tableau.com/products/desktop) - ✳️ Yes, works via Rosetta 2 Translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/752#issuecomment-922340043) [Discussion](https://community.tableau.com/s/topic/0TO4T000000pcgPWAQ/apple-silicon-m1)
* [Tableau Prep](https://www.tableau.com/products/prep) - ✳️ Yes, works via Rosetta 2 Translation - [Discussion](https://community.tableau.com/s/topic/0TO4T000000pcgPWAQ/apple-silicon-m1)
* [Tableau Public](https://www.tableau.com/products/public) - ✳️ Yes, works via Rosetta 2 Translation - [Discussion](https://community.tableau.com/s/topic/0TO4T000000pcgPWAQ/apple-silicon-m1)
* [Tableau Reader](https://www.tableau.com/products/reader) - ✳️ Yes, works via Rosetta 2 Translation - [Discussion](https://community.tableau.com/s/topic/0TO4T000000pcgPWAQ/apple-silicon-m1)
* [TI Connect CE](https://education.ti.com/en/software/details/en/CA9C74CAD02440A69FDC7189D7E1B6C2/swticonnectcesoftware) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/733#issue-954040240)
* [Wolfram Mathematica](https://www.wolfram.com/mathematica/) - ✅ Yes, Native Apple Silicon Support as of v12.3.1 - [Release Notes](https://www.wolfram.com/mathematica/quick-revision-history.html) [Discussion](https://community.wolfram.com/groups/-/m/t/2118125#_19_message_2121051)



#### Music and Audio Tools

* [Adobe Audition](https://www.adobe.com/products/audition.html) - ✅ Yes, Full Native Apple Silicon Support - [Release Notes](https://helpx.adobe.com/audition/user-guide.html/audition/using/whats-new/2021-1.ug.html) [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [Airfoil](https://rogueamoeba.com/airfoil/mac/) - ✅ Yes, Initial Native Apple Silicon Support as of v5.10.0 - [Release Notes](https://rogueamoeba.com/airfoil/mac/releasenotes.php) [Official Post](https://weblog.rogueamoeba.com/2020/11/16/rogue-amoeba-software-updates-for-macos-11-big-sur-and-m1-chip-based-macs/) 
* [Ardour](https://community.ardour.org/download) - ✳️ Yes, it works via Rosetta 2 with native support in progress - [Apple Silicon Pre-release](https://discourse.ardour.org/t/ardour-for-apple-m1-arm-pre-release/105174)
* [Audacity](https://www.audacityteam.org/download/) - ✳️ Yes, it works via Rosetta 2, with Native support as of alpha v3.2 - [Github Issue Comment](https://github.com/audacity/audacity/issues/684#issuecomment-710726323) [Nighty (Alpha Version)](https://www.audacityteam.org/nightly)[(fix)](https://github.com/audacity/audacity/issues/2223)
* [Audio Hijack](https://rogueamoeba.com/audiohijack/) - ✅ Yes, Initial Native Apple Silicon Support as of v3.8.0 - [Release Notes](https://rogueamoeba.com/audiohijack/releasenotes.php) [Official Post](https://weblog.rogueamoeba.com/2020/11/16/rogue-amoeba-software-updates-for-macos-11-big-sur-and-m1-chip-based-macs/) 
* [Avid Pro Tools](https://www.avid.com/pro-tools) - ✅ Yes, Full Native Apple Silicon Support as of v2023.3 - [Release Notes](https://www.avid.com/resource-center/whats-new-in-pro-tools-20233)
* [Avid Sibelius](https://www.avid.com/sibelius) - ✅ Yes, Full Native Apple Silicon Support as of v2021.2 - [Official Article](https://avid.secure.force.com/pkb/articles/en_US/Compatibility/macOS-Big-Sur-Support)
* [Capo](https://supermegaultragroovy.com/products/capo/mac/) - ✅ Yes, Full Native Apple Silicon Support as of v4 - [Official Post](https://supermegaultragroovy.com/products/capo/press/pr/2020-11-17/)
* [Colibri](https://apps.apple.com/us/app/colibri/id1178295426?ls=1&mt=12) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/684#issue-912866711)
* [Colibri DAC DSD Test](https://apps.apple.com/us/app/colibri-dac-dsd-test/id1455508413?ls=1&mt=12) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/691#issue-913934536)
* [eqMac](https://eqmac.app) - ✅ Yes, Native Apple Silicon binary, works well as of v0.3.7, Rosetta 2 lacks performance - [Tracked Issue](https://github.com/bitgapp/eqMac/issues/413)
* [Finale Music](https://www.finalemusic.com/free-trial/) - ✳️ Yes, it works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/617#issuecomment-869333440) [System Requirements](https://makemusic.zendesk.com/hc/en-us/articles/216545087-System-Requirements-for-MakeMusic-Notation-Products)
* [Fission](https://rogueamoeba.com/fission/) - ✅ Yes, Initial Native Apple Silicon Support as of v2.7.0 - [Release Notes](https://rogueamoeba.com/fission/releasenotes.php) [Official Post](https://weblog.rogueamoeba.com/2020/11/16/rogue-amoeba-software-updates-for-macos-11-big-sur-and-m1-chip-based-macs/) 
* [FL Studio](https://www.image-line.com/fl-studio-download/) - ✅ Yes, Native Apple Silicon Support as of v20.8.4 - [Image Line Article](https://support.image-line.com/action/knowledgebase/?ans=668)
* [foobar2000](https://www.foobar2000.org/) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/586#issue-817790955) [Changelog](https://www.foobar2000.org/changelog-mac)
* [forScore](https://forscore.co/) - ✅ Yes, Full Native Apple Silicon Support as of v12 - [Official News](https://forscore.co/forscore-comes-to-the-mac/)
* [Fretello](https://apps.apple.com/us/app/fretello-guitar-lessons/id1107957482) - ✅ Yes, Full Native Apple Silicon Support as of v2.3.3 - [App Store Story](https://apps.apple.com/us/story/id1540024103)
* [Garageband](https://www.apple.com/mac/garageband/) - ✅ Yes, it was shown at the November 10th event - [Apple Nov 10 Event](https://youtu.be/5AwdkGKmZ0I?t=1033)
* [Ivory II](https://www.synthogy.com/index.php/buy) - 🚫 Not yet supported only works on Intel-based Macs - [Release Notes](https://www.synthogy.com/index.php/support/updates/mac)
* [Logic Pro](https://www.apple.com/logic-pro/) - ✅ Yes, it was shown at the November 10th event - [Apple Nov 10 Event](https://youtu.be/5AwdkGKmZ0I?t=1037)
* [n-Track Studio](https://ntrack.com/download.php) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/819#issue-1055635483) [View on Setapp](https://setapp.sjv.io/c/2708043/354737/5114)
* [Native Access](https://www.native-instruments.com/en/specials/native-access/) - ✳️ Yes, works via Rosetta 2 translation with the exception of MASSIVE X - [Official Status](https://support.native-instruments.com/hc/en-us/articles/360013515618-macOS-11-Big-Sur-Compatibility-News) [Official Post](https://support.native-instruments.com/hc/en-us/articles/360014683497)
* [ocenaudio](https://www.ocenaudio.com/) - ✅ Yes, Native Apple Silicon Support as of v3.10.3 - [Release Notes](https://www.ocenaudio.com/changelog) [Verification](https://github.com/ThatGuySam/doesitarm/issues/154#issuecomment-973309831)
* [Piezo](https://rogueamoeba.com/piezo/) - ✅ Yes, Initial Native Apple Silicon Support as of v1.7.0 - [Release Notes](https://rogueamoeba.com/piezo/releasenotes.php) [Official Post](https://weblog.rogueamoeba.com/2020/11/16/rogue-amoeba-software-updates-for-macos-11-big-sur-and-m1-chip-based-macs/) 
* [Plogue Bidule](https://plogue.com/downloads.html) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/480#issue-776226694)
* [REAPER](https://www.reaper.fm/download.php) - ✳️ Yes, works via Rosetta 2 with native support in beta - [Apple Silicon Discussion](https://forum.cockos.com/showthread.php?t=245263)
* [SoundSource](https://rogueamoeba.com/soundsource/) - ✅ Yes, Initial Native Apple Silicon Support as of v5.2.0 - [Release Notes](https://rogueamoeba.com/soundsource/releasenotes.php) [Official Post](https://weblog.rogueamoeba.com/2020/11/16/rogue-amoeba-software-updates-for-macos-11-big-sur-and-m1-chip-based-macs/)
* [Spectrasonics Keyscape](https://www.spectrasonics.net/products/keyscape/index.php) - ✅ Yes, Native Apple Silicon Support - [Knowledgebase Article](https://www.spectrasonics.net/support/knowledgebase_view_topic.php?id=243&categoryID=9) [Reddit Post](https://www.reddit.com/r/omnisphere/comments/o24iu7/all_spectrasonics_products_updated_with_vst3/) 
* [Spectrasonics Omnisphere](https://www.spectrasonics.net/products/omnisphere/index.php) - ✅ Yes, Native Apple Silicon Support - [Knowledgebase Article](https://www.spectrasonics.net/support/knowledgebase_view_topic.php?id=243&categoryID=9) [Reddit Post](https://www.reddit.com/r/omnisphere/comments/o24iu7/all_spectrasonics_products_updated_with_vst3/) 
* [Spectrasonics Stylus RMX](https://www.spectrasonics.net/products/stylusrmx.php) - ✅ Yes, Native Apple Silicon Support - [Knowledgebase Article](https://www.spectrasonics.net/support/knowledgebase_view_topic.php?id=243&categoryID=9) [Reddit Post](https://www.reddit.com/r/omnisphere/comments/o24iu7/all_spectrasonics_products_updated_with_vst3/) 
* [Spectrasonics Trilian](https://www.spectrasonics.net/products/trilian/index.php) - ✅ Yes, Native Apple Silicon Support - [Knowledgebase Article](https://www.spectrasonics.net/support/knowledgebase_view_topic.php?id=243&categoryID=9) [Reddit Post](https://www.reddit.com/r/omnisphere/comments/o24iu7/all_spectrasonics_products_updated_with_vst3/) 
* [Splice](https://splice.com/download) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/818#issue-1055624867)
* [TunesArt](https://www.jibapps.com/apps/tunesart/) - ✅ Yes, Full Native Apple Silicon Support as of v1.9.6 - [Source](https://twitter.com/jibapps/status/1334055652055003137)
* [TwistedWave](https://twistedwave.com/mac) - ✳️ Yes, works via Rosetta 2 with native support in beta - [Verification](https://github.com/ThatGuySam/doesitarm/issues/508#issue-781561446)
* [Universal Audio Software](https://www.uaudio.com/downloads) - ✳️ Yes, by setting the "Reduced Security option" security policy using macOS Recovery - [Knowledgebase Article](https://help.uaudio.com/hc/en-us/articles/360057137692-Apple-Silicon-M1-Compatibility-Info)
* [X Lossless Decoder (XLD)](https://sourceforge.net/projects/xld/) - ✅ Yes, Full Native Apple Silicon Support as of 2021/1/1 - [Scroll to version history here](https://tmkk.undo.jp/xld/index_e.html)



#### Photo and Graphic Tools

* [Affinity Designer](https://affinity.serif.com/en-us/designer/) - ✅ Yes, fully supported as of v1.8.6 - [Press Release](https://affinity.serif.com/en-us/press/newsroom/affinity-apps-accelerate-with-macos-big-sur-and-native-m1-support/) [Apple Nov 10 Event](https://youtu.be/5AwdkGKmZ0I?t=1219)
* [Affinity Photo](https://affinity.serif.com/en-us/publisher/) - ✅ Yes, fully supported as of v1.8.6 - [Press Release](https://affinity.serif.com/en-us/press/newsroom/affinity-apps-accelerate-with-macos-big-sur-and-native-m1-support/)
* [Affinity Publisher](https://affinity.serif.com/en-us/publisher/) - ✅ Yes, fully supported as of v1.8.6 - [Press Release](https://affinity.serif.com/en-us/press/newsroom/affinity-apps-accelerate-with-macos-big-sur-and-native-m1-support/) [Apple Nov 10 Event](https://youtu.be/5AwdkGKmZ0I?t=1286)
* [ArmorPaint](https://armorpaint.org/) - 🚫 No, not yet supported only works on Intel-based Macs
* [Aseprite](https://www.aseprite.org/download/) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/740#issue-962905091)
* [BiggerPicture](https://apps.apple.com/app/bigger-picture/id1406088493?mt=12) - ✅ Yes, Full Native Apple Silicon Support as of v1.3.0 - [Release Notes](https://basilsalad.com/kitchen/bigger-picture-big-sur/)
* [Blocs](https://blocsapp.com/) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Capture One](https://www.captureone.com/) - ✅ Yes, Native Apple Silicon Support as of v14.2.0 - [Release Notes](https://support.captureone.com/hc/en-us/articles/360020418257-Capture-One-21-14-2-0-release-notes)
* [CorelDRAW](https://www.coreldraw.com/en/product/coreldraw/) - ✅ Yes, Full Native Apple Silicon Support - [Press Release](https://www.globenewswire.com/news-release/2021/03/09/2189653/0/en/CorelDRAW-Graphics-Suite-2021-Powers-Collaboration-and-Productivity-in-Graphic-Design.html)
* [Darkroom](https://darkroom.co/) - ✅ Yes, it was shown at the November 10th event - [Apple Nov 10 Event](https://youtu.be/5AwdkGKmZ0I?t=1307)
* [Darktable](https://www.darktable.org/install/#macos) - ✳️ Yes, works via Rosetta 2 - [Source](https://github.com/ThatGuySam/doesitarm/issues/328#issuecomment-736769770) [Discussion](https://discuss.pixls.us/t/the-future-of-darktable-on-the-mac-with-arm/21290)
* [DxO PhotoLab](https://www.dxo.com/dxo-photolab/) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/162#issuecomment-869566486)
* [EXIF Sync](https://www.lemkesoft.de/en/products/exif-sync/download/) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Figma](https://www.figma.com/downloads/) - ✅ Yes, Native Apple Silicon Support - [Report #1](https://www.reddit.com/r/FigmaDesign/comments/k58d5h/figma_client_for_apple_silicon/gje6y83/?utm_source=reddit&utm_medium=web2x&context=3) [Report #2](https://twitter.com/joeyabanks/status/1330929000701710345)
* [FontBook](https://www.lemkesoft.de/en/products/fontbook/download/) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Gimp](https://www.gimp.org/downloads/) - ✳️ Yes, works via Rosetta 2 but with noticeable performance dip - [Verification](https://github.com/ThatGuySam/doesitarm/issues/304#issuecomment-748297707)
* [Goldie](https://goldieapp.com/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/618462/5114)
* [GraphicConverter](https://www.lemkesoft.de/en/products/graphicconverter/download/) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/483#issuecomment-752342847)
* [Graphite Sketchbook](https://www.digitalmasterpieces.com/graphite/) - ✅ Yes, it was shown at the November 10th event - [Apple Nov 10 Event](https://youtu.be/5AwdkGKmZ0I?t=1303)
* [iCalamus](https://www.lemkesoft.de/en/products/icalamus/download/) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Illustrator](https://www.adobe.com/products/illustrator.html) - ✅ Yes, Native Apple Silicon Support - [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [InCopy](https://www.adobe.com/products/incopy.html) - ✳️ Yes, works via Rosetta 2 - [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [InDesign](https://www.adobe.com/products/indesign.html) - ✅ Yes, Full Native Apple Silicon Support - [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [Inkscape](https://inkscape.org/) - ✅ Yes, Full Native Apple Silicon Support as of v1.2 - [Release Notes](https://wiki.inkscape.org/wiki/Release_notes) [Project on GitLab](https://gitlab.com/inkscape/inkscape) [Verification](https://github.com/ThatGuySam/doesitarm/issues/11#issuecomment-731507162)
* [Krita](https://krita.org/en/download/krita-desktop/) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/610#issuecomment-812640871)
* [Lightroom](https://www.adobe.com/products/photoshop-lightroom.html) - ✅ Yes, Full Native Apple Silicon Support - [Official Post](https://blog.adobe.com/en/2020/12/08/december-photography-updates.html) [Apple Nov 10 Event](https://youtu.be/5AwdkGKmZ0I?t=1092) [WWDC Preview](https://youtu.be/GEZhD3J89ZE?t=5783)
* [Lightroom Classic](https://www.adobe.com/products/photoshop-lightroom-classic.html) - ✅ Yes, Native Apple Silicon Support as of v10.3 - [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [Linearity Curve](https://www.linearity.io/curve/) - ✅ Yes, it was shown at the November 10th, 2021 event - [Apple Nov 10 Event](https://youtu.be/5AwdkGKmZ0I?t=1300)
* [Logoist 4](https://www.syniumsoftware.com/logoist) - ✅ Yes, Full Native Apple Silicon Support as of v4.1 - [Official News](https://www.syniumsoftware.com/synium-blog/apple-silicon-is-here-and-we-are-ready)
* [Luminar](https://skylum.com/luminar) - ✳️ Yes, works via Rosetta 2 - [Source](https://youtu.be/CKA1YW9l8j0?t=43)
* [MacTeX](https://www.tug.org/mactex/mactex-download.html) - ✅ Yes, Full Native Apple Silicon Support as of MacTeX-2021 - [Official FAQ](https://www.tug.org/mactex/faq/index.html#qm08)
* [Mail Designer 365](https://maildesigner365.com) - ✅ Yes, fully native support as of v2.0 - [Official page](https://www.maildesigner365.com/new-mail-designer-365-2-0-with-big-sur-optimization/)
* [Optimage](https://optimage.app/) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Photoshop](https://www.adobe.com/products/photoshop.html) - ✅ Yes, Initial Native Apple Silicon Support with some limitations - [Known Issues](https://helpx.adobe.com/photoshop/kb/photoshop-for-apple-silicon.html) [Official Adobe Status](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [Pika](https://superhighfives.com/pika) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Pixelmator Classic](https://apps.apple.com/cn/app/pixelmator-classic/id407963104?l=en&mt=12) - ✳️ Yes, works via Rosetta 2, no native upgrade planned - [Verification](https://github.com/ThatGuySam/doesitarm/issues/367)
* [Pixelmator Pro](https://pixelmator.com/pro) - ✅ Yes, full native support as of v2.0
* [Seashore](https://apps.apple.com/us/app/seashore/id1448648921?mt=12&app=apps&ign-mpt=uo%3D4) - ✅ Yes, Native Apple Silicon Support as of v3.01 - [Verification](https://github.com/robaho/seashore/issues/139#issuecomment-1172574250)
* [Simple Comic](https://github.com/arauchfuss/Simple-Comic) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/407)
* [Simple Comic (Community Fork)](https://github.com/MaddTheSane/Simple-Comic) - ✅ Yes, full native Apple Silicon support as of v1.9.1 - [App Store](https://apps.apple.com/us/app/simple-comic/id1497435571?l=en&mt=12) [Github Repo](https://github.com/MaddTheSane/Simple-Comic) [Verification](https://github.com/ThatGuySam/doesitarm/issues/407)
* [Sip for Mac](https://sipapp.io/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344463/5114)
* [Textify](https://apps.apple.com/app/id1522041836) - ✅ Yes, full native support as of v2.0.1 - [Macrumors Thread](https://forums.macrumors.com/threads/textify-text-recognition-ocr-made-easy-and-accurate-1-product-of-the-day-ph.2245225/page-2?post=29016938#post-29016938)
* [Typeface for Mac](https://typefaceapp.com/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/507348/5114)
* [waifu2x](https://github.com/nihui/waifu2x-ncnn-vulkan/releases) - ✅ Yes, Full Native Apple Silicon Support as of v20210102 - [Release Notes](https://github.com/nihui/waifu2x-ncnn-vulkan/releases/tag/20210102)
* [Wonderdraft](https://www.wonderdraft.net/) - ✳️ Yes, works via Rosetta 2 translation - [Report #1](https://community.folivora.ai/t/m1-mac-trackpad-disappearing-laggy-pointer/21069/9)



#### Video and Motion Tools

* [Adobe Animate](https://www.adobe.com/products/animate.html) - ✳️ Yes, works via Rosetta 2 - [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [Adobe Media Encoder](https://www.adobe.com/products/media-encoder.html) - ✳️ Yes, works via Rosetta 2 - [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [After Effects](https://www.adobe.com/products/aftereffects.html) - ✳️ Yes, works via Rosetta 2 - [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [Autodesk Fusion 360](https://www.autodesk.com/products/fusion-360/overview) - ✳️ Yes, it was shown at the November 10th event running via Rosetta 2 - [Apple Nov 10 Event](https://youtu.be/5AwdkGKmZ0I?t=1114)
* [Autodesk Maya](https://www.autodesk.com/products/maya/overview) - ✳️ Yes, it was shown at WWDC running via Rosetta 2 - [WWDC Preview](https://youtu.be/GEZhD3J89ZE?t=6036)
* [Autokroma AfterCodecs](https://www.autokroma.com/AfterCodecs/Download) - ✅ Yes, Native Apple Silicon Support as of v1.10.6 - [Official Article](https://www.autokroma.com/blog/Apple-Silicon-ARM-M1-Compatibility-with-Adobe-Creative-Cloud-Autokroma)
* [Autokroma BRAW (BRAW_Studio)](https://www.autokroma.com/BRAW_Studio/Download/) - ✅ Yes, Native Apple Silicon Support as of v2.5.1 - [Official Article](https://www.autokroma.com/blog/Apple-Silicon-ARM-M1-Compatibility-with-Adobe-Creative-Cloud-Autokroma)
* [Autokroma Influx](https://www.autokroma.com/Influx/) - 🚫 Not yet supported only works on Intel-based Macs - [Official Article](https://www.autokroma.com/blog/Apple-Silicon-ARM-M1-Compatibility-with-Adobe-Creative-Cloud-Autokroma)
* [Autokroma PlumePack](https://www.autokroma.com/PlumePack/) - ✳️ Yes, works via Rosetta 2 Translation - [Official Article](https://www.autokroma.com/blog/Apple-Silicon-ARM-M1-Compatibility-with-Adobe-Creative-Cloud-Autokroma)
* [Autokroma Vizual](https://www.autokroma.com/Vizual/) - 🚫 Not yet supported only works on Intel-based Macs - [Official Article](https://www.autokroma.com/blog/Apple-Silicon-ARM-M1-Compatibility-with-Adobe-Creative-Cloud-Autokroma)
* [Avid Media Composer](https://www.avid.com/media-composer) - 🚫 Not yet supported only works on Intel-based Macs - [Official Article](https://avid.secure.force.com/pkb/articles/en_US/Compatibility/macOS-Big-Sur-Support)
* [Blender](https://www.blender.org/download/) - ✅ Yes, Native Apple Silicon Support - [Platforms State of the Union Clip](https://twitter.com/blendertoday/status/1275417203303727104?lang=en)
* [Character Animator](https://www.adobe.com/products/character-animator.html) - ✅ Yes, Native Apple Silicon Support - [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [Cinebench](https://apps.apple.com/app/cinebench/id1438772273?l=en&mt=12) - ✅ Yes, Native Support as of v23.200 - [Source](https://github.com/ThatGuySam/doesitarm/issues/39#issuecomment-729965712)
* [Cinema 4D](https://www.maxon.net/en/downloads) - ✅ Yes, Native Apple Silicon Support - [Release Notes](https://www.maxon.net/en/article/cinema-4d-r23-sp1-now-available) [Apple Nov 10 Event](https://youtu.be/5AwdkGKmZ0I?t=924)
* [Claquette](https://www.peakstep.com/claquette/) - ✅ Yes, Full Native Apple Silicon Support as of v2.1 - [Release Notes](https://www.peakstep.com/claquette/releasenotes.html)
* [DaVinci Resolve](https://www.blackmagicdesign.com/products/davinciresolve) - ✅ Yes, it was shown at the November 10th event - [Apple Nov 10 Event](https://youtu.be/5AwdkGKmZ0I?t=950)
* [ffWorks](https://www.ffworks.net/download.html) - ✅ Yes, full native support as of v2.2.3
* [Filma](https://apps.apple.com/app/filma-best-video-editor/id1456095438) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Final Cut Library Manager](https://www.arcticwhiteness.com/finalcutlibrarymanager/download/) - ✅ Yes, Full Native Apple Silicon Support as of v3.9 - [Release Notes](https://www.arcticwhiteness.com/blog/fclm390-fcpx1052/)
* [Final Cut Pro](https://www.apple.com/final-cut-pro/) - ✅ Yes, it will available on Apple Silicon launch - [Apple Nov 10 Event](https://youtu.be/5AwdkGKmZ0I?t=1173) [WWDC Preview](https://youtu.be/GEZhD3J89ZE?t=5844)
* [FlexClip](https://www.flexclip.com/) - ✅ Yes, Native Apple Silicon Support via browser
* [GoPro Fusion Studio](https://gopro.com/en/us/news/fusion-end-of-life) - 🚫 No, not supported and no plans for support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/349#issuecomment-869347313) [Official Article](https://gopro.com/en/us/news/fusion-end-of-life)
* [GoPro VR Player](https://community.gopro.com/t5/en/GoPro-VR-Player-for-desktop-FAQ/ta-p/394345) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/349#issuecomment-869347313)
* [Handbrake](https://handbrake.fr/) - ✅ Yes, natively supported as of v1.4.0 - [Github Issue](https://github.com/HandBrake/HandBrake/issues/2951)
* [Houdini](https://www.sidefx.com/products/houdini/) - ✳️ Yes, works via Rosetta 2 - [Source](https://www.reddit.com/r/Houdini/comments/jzg1wj/houdini_running_on_apple_silicon_m1_macs_demo/)
* [Maxon Chromatic Displacement](https://www.maxon.net/en/red-giant-complete/vfx-suite/chromatic-displacement) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/chromatic-displacement-requirements)
* [Maxon Cosmo](https://www.maxon.net/en/red-giant-complete/magic-bullet-suite/cosmo) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/cosmo-requirements)
* [Maxon Denoiser](https://www.maxon.net/en/red-giant-complete/magic-bullet-suite/denoiser) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/denoiser-requirements)
* [Maxon Echospace](https://www.maxon.net/en/red-giant-complete/trapcode-suite/echospace) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/echospace-requirements)
* [Maxon Form](https://www.maxon.net/en/red-giant-complete/trapcode-suite/form) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/form-requirements)
* [Maxon Horizon](https://www.maxon.net/en/red-giant-complete/trapcode-suite/horizon) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/horizon-requirements)
* [Maxon Looks](https://www.maxon.net/en/red-giant-complete/magic-bullet-suite/looks) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/looks-requirements)
* [Maxon Optical Glow](https://www.maxon.net/en/red-giant-complete/vfx-suite/optical-glow) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/optical-glow-requirements)
* [Maxon Particular](https://www.maxon.net/en/red-giant-complete/trapcode-suite/particular) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/particular-requirements)
* [Maxon PluralEyes](https://www.maxon.net/en/red-giant-complete/pluraleyes) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/pluraleyes-requirements)
* [Maxon Redshift](https://www.maxon.net/en/redshift) - ✅ Yes, Native Apple Silicon Support - [Official Article](https://www.maxon.net/en/article/maxon-announces-redshift-for-macos-including-native-support-for-m1-powered-macs) [Requirements](https://www.maxon.net/en/requirements/redshift-requirements)
* [Maxon Shadow](https://www.maxon.net/en/red-giant-complete/vfx-suite/shadow) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/shadow-requirements)
* [Maxon Shine](https://www.maxon.net/en/red-giant-complete/trapcode-suite/shine) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/shine-requirements)
* [Maxon Sound Keys](https://www.maxon.net/en/red-giant-complete/trapcode-suite/sound-keys) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/sound-keys-requirements)
* [Maxon Starglow](https://www.maxon.net/en/red-giant-complete/trapcode-suite/starglow) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/starglow-requirements)
* [Maxon Supercomp](https://www.maxon.net/en/red-giant-complete/vfx-suite/supercomp) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/supercomp-requirements)
* [Maxon Universe](https://www.maxon.net/en/red-giant-complete/universe) - 🔶 App has not yet been reported to be native to Apple Silicon - [Requirements](https://www.maxon.net/en/requirements/universe-requirements)
* [MKVToolNix](https://mkvtoolnix.download/downloads.html#macosx) - ✳️ Yes, works via Rosetta 2 - [GitHub issue](https://github.com/ThatGuySam/doesitarm/issues/344)
* [OpenISS](https://github.com/OpenISS/OpenISS) - 🔶 Unknown, more info needed - [GitHub Issue](https://github.com/OpenISS/OpenISS/issues/72) [Contribute](https://github.com/ThatGuySam/doesitarm/issues/475)
* [Permute](https://software.charliemonroe.net/permute/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344448/5114)
* [Premiere Pro](https://www.adobe.com/products/premiere.html) - ✅ Yes, Native Apple Silicon Support as of v15.4 - [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [Premiere Rush](https://www.adobe.com/products/premiere-rush.html) - ✅ Yes, Full Native Apple Silicon Support as of v1.5.58 - [Release Notes](https://helpx.adobe.com/premiere-rush/user-guide.html/premiere-rush/help/whats-new/2021-3.ug.html) [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [Shotcut](https://shotcut.org/download/) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/662#issue-898865436)
* [Shutter Encoder](https://www.shutterencoder.com/en/#downloads) - ✅ Yes, Full Native Apple Silicon Support as of v15.0 - [Changelog](https://www.shutterencoder.com/changelog.html)
* [Subler](https://subler.org/) - ✅ Yes, Full Native Apple Silicon Support as of v1.6.6 - [Release Notes](https://bitbucket.org/galad87/subler/wiki/Release%20Notes)
* [Tumult Hype](https://tumult.com/hype/) - ✅ Yes, Full Native Apple Silicon Support as of v4.1 - [Blog Post](https://blog.tumult.com/2020/11/23/introducing-tumult-hype-v4-1-with-apple-silicon-and-big-sur-compatibility/) [View on Setapp](https://setapp.sjv.io/c/2708043/344385/5114)
* [Vuo](https://vuo.org/download) - ✅ Yes, Full Native Apple Silicon Support as of v2.3.0 - [Release Notes](https://vuo.org/release/2.3.0)
* [WebTorrent](https://webtorrent.io/desktop/) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/494#issuecomment-759525123)
* [Wondershare Filmora](https://apps.apple.com/us/app/filmora-video-editor/id1516822341?mt=12) - ✅ Yes, Full Native Apple Silicon Support - [Official Post](https://filmora.wondershare.com/filmora-supports-apple-arm.html)



#### Live Production and Performance
* [Ableton](https://www.ableton.com/en/live/) - ✅ Yes, Native Apple Silicon Support as of v11.1 - [Compatibility Notes](https://help.ableton.com/hc/en-us/articles/115001261150-Mac-Compatibility-with-Live)
* [AJA Control Room](https://www.aja.com/products/aja-control-room#support) - ✅ Yes, Native Apple Silicon Support as of v16.1 - [Release Notes](https://www.aja.com/pdf/2021/AJA-Software-Installer_macOS_v16.1_ReleaseNotes.pdf)
* [AJA ControlPanel](https://www.aja.com/products/aja-control-room#support) - ✅ Yes, Native Apple Silicon Support as of v16.1 - [Release Notes](https://www.aja.com/pdf/2021/AJA-Software-Installer_macOS_v16.1_ReleaseNotes.pdf)
* [AJA eMini-Setup](https://www.aja.com/family/software) - 🔶 App has not yet been reported to be native to Apple Silicon
* [AJA Mini-Config](https://www.aja.com/family/software) - 🔶 App has not yet been reported to be native to Apple Silicon
* [AJA Multi-Channel Config](https://www.aja.com/products/aja-control-room#support) - ✅ Yes, Native Apple Silicon Support as of v16.1 - [Release Notes](https://www.aja.com/pdf/2021/AJA-Software-Installer_macOS_v16.1_ReleaseNotes.pdf)
* [AJA NMOS](https://www.aja.com/products/aja-control-room#support) - ✅ Yes, Native Apple Silicon Support as of v16.1 - [Release Notes](https://www.aja.com/pdf/2021/AJA-Software-Installer_macOS_v16.1_ReleaseNotes.pdf)
* [AJA RovoControl](https://www.aja.com/products/rovocontrol#support) - 🔶 App has not yet been reported to be native to Apple Silicon
* [AJA System Test](https://www.aja.com/products/aja-system-test#support) - ✅ Yes, Native Apple Silicon Support as of v16.1 - [Release Notes](https://www.aja.com/pdf/2021/AJA-Software-Installer_macOS_v16.1_ReleaseNotes.pdf)
* [AJA U-TAP Updater](https://www.aja.com/products/u-tap-hdmi#support) - 🔶 App has not yet been reported to be native to Apple Silicon
* [Dante Controller](https://my.audinate.com/support/downloads/download-latest-dante-software) - 🚫 No, not yet supported only recommended for Intel-based Macs - [Official Article](https://www.audinate.com/learning/faqs/dante-software-on-macos-big-sur-and-apple-m1-based-computers)
* [Dante Via](https://my.audinate.com/support/downloads/download-latest-dante-software) - ✳️ Yes, works via Rosetta 2 translation but not yet recommended - [Official Article](https://www.audinate.com/learning/faqs/dante-software-on-macos-big-sur-and-apple-m1-based-computers)
* [Dante Virtual Soundcard](https://my.audinate.com/support/downloads/download-latest-dante-software) - ✳️ Yes, works via Rosetta 2 translation but can run natively via PKG hack - [PKG Hack](https://github.com/ThatGuySam/doesitarm/issues/918#issuecomment-1241591201)
* [djay](https://www.algoriddim.com/) - ✅ Yes, Full Native Apple Silicon Support as of v3.0 - [Release Notes](https://www.algoriddim.com/djay-pro-mac/releasenotes)
* [Ecamm Live](https://www.ecamm.com/mac/ecammlive/?fp_ref=lsp) - ✳️ Yes, works via Rosetta 2 - [Official Article](https://support.ecamm.com/en/articles/4616420-ecamm-live-on-macos-11-big-sur-and-apple-silicon-m1-macs)
* [Elgato Control Center](https://help.elgato.com/hc/en-us/articles/360028242091-Elgato-Control-Center-Release-Notes-macOS-) - 🚫 No, not yet supported, only works on Intel-based Macs - [Official Article](https://help.elgato.com/hc/en-us/articles/360052527791-Apple-Silicon-Compatibility-M1-Chip-)
* [Elgato EpocCam Driver](https://help.elgato.com/hc/en-us/articles/360052826852-EpocCam-Release-Notes-macOS) - ✅ Yes, Native Apple Silicon Support - [Official Article](https://help.elgato.com/hc/en-us/articles/360052527791-Apple-Silicon-Compatibility-M1-Chip-)
* [Elgato Game Capture](https://help.elgato.com/hc/en-us/articles/360027963512-Elgato-Game-Capture-HD-Software-Release-Notes-macOS-) - 🚫 No, not yet working, only works on Intel-based Macs - [Official Article](https://help.elgato.com/hc/en-us/articles/360052527791-Apple-Silicon-Compatibility-M1-Chip-)
* [Elgato OBS Link](https://help.elgato.com/hc/en-us/articles/360031314272-Elgato-OBS-Link-Software-Release-Notes) - 🚫 No, not yet supported only works on Intel-based Macs - [Official Article](https://help.elgato.com/hc/en-us/articles/360052527791-Apple-Silicon-Compatibility-M1-Chip-)
* [Elgato Stream Deck](https://help.elgato.com/hc/en-us/articles/360028242631-Elgato-Stream-Deck-Software-Release-Notes) - ✳️ Yes, works via Rosetta 2 translation - [Official Article](https://help.elgato.com/hc/en-us/articles/360052527791-Apple-Silicon-Compatibility-M1-Chip-)
* [Elgato Thunderbolt Dock](https://help.elgato.com/hc/en-us/articles/360035293992-Elgato-Thunderbolt-Dock-Utility-Software-Release-Notes) - 🚫 No, not yet supported only works on Intel-based Macs - [Official Article](https://help.elgato.com/hc/en-us/articles/360052527791-Apple-Silicon-Compatibility-M1-Chip-)
* [Elgato Video Capture](https://help.elgato.com/hc/en-us/articles/360028243991-Elgato-Video-Capture-Software-Release-Notes) - ✳️ Yes, works via Rosetta 2 translation - [Official Article](https://help.elgato.com/hc/en-us/articles/360052527791-Apple-Silicon-Compatibility-M1-Chip-)
* [Elgato Wave Link](https://help.elgato.com/hc/en-us/articles/360043289491-Elgato-Wave-Link-Release-Notes) - ✳️ Yes, works via Rosetta 2 translation - [Official Article](https://help.elgato.com/hc/en-us/articles/360052527791-Apple-Silicon-Compatibility-M1-Chip-)
* [Farrago](https://rogueamoeba.com/farrago/) - ✅ Yes, Initial Native Apple Silicon Support as of v1.6.0 - [Release Notes](https://rogueamoeba.com/farrago/releasenotes.php) [Official Post](https://weblog.rogueamoeba.com/2020/11/16/rogue-amoeba-software-updates-for-macos-11-big-sur-and-m1-chip-based-macs/) 
* [grandMA3 onPC](https://www.malighting.com/downloads/products/grandma3/) - 🚫 No, not yet supported only works on Intel-based Macs - [Report #1](https://forum.malighting.com/thread/4671-works-with-new-apple-m1/?postID=12236#post12236)
* [Loopback](https://rogueamoeba.com/loopback/) - ✅ Yes, Initial Native Apple Silicon Support as of v2.2.0 - [Release Notes](https://rogueamoeba.com/loopback/releasenotes.php) [Official Post](https://weblog.rogueamoeba.com/2020/11/16/rogue-amoeba-software-updates-for-macos-11-big-sur-and-m1-chip-based-macs/) 
* [MOTU Audio Tools](https://motu.com/proaudio/index.html) - ✅ Yes, Native Apple Silicon Support - [Official Article](https://motu.com/en-us/news/motu-and-macos-big-sur/)
* [MOTU ClockWorks](https://motu.com/techsupport/technotes/document.2004-04-08.7757361768) - ✅ Yes, Native Apple Silicon Support - [Official Article](https://motu.com/en-us/news/motu-and-macos-big-sur/)
* [MOTU CueMix](https://motu.com/techsupport/technotes/what-is-cuemix) - ✅ Yes, Native Apple Silicon Support as of v5 - [Official Article](https://motu.com/en-us/news/motu-and-macos-big-sur/)
* [MOTU Digital Performer](https://motu.com/en-us/products/software/dp/) - ✅ Yes, Native Apple Silicon Support as of v11 - [System Requirements](https://motu.com/en-us/products/software/dp/tech-specs/)
* [MOTU Discovery](https://motu.com/download) - ✅ Yes, Native Apple Silicon Support - [Official Article](https://motu.com/en-us/news/motu-and-macos-big-sur/)
* [MOTU Gen 5 System Extension](https://motu.com/en-us/products/gen5/ultralite-mk5/) - ✅ Yes, Native Apple Silicon Support - [Official Article](https://motu.com/en-us/news/motu-and-macos-big-sur/)
* [MOTU M Series System Extension](https://motu.com/en-us/products/m-series/) - ✅ Yes, Native Apple Silicon Support - [Official Article](https://motu.com/en-us/news/motu-and-macos-big-sur/)
* [MOTU Pro Audio System Extension](https://motu.com/proaudio/index.html) - ✅ Yes, Native Apple Silicon Support - [Official Article](https://motu.com/en-us/news/motu-and-macos-big-sur/)
* [MOTU USB MIDI System Extension](https://motu.com/en-us/products/midi-products/) - ✅ Yes, Native Apple Silicon Support - [Official Article](https://motu.com/en-us/news/motu-and-macos-big-sur/)
* [NewTek NDI Connect](https://www.newtek.com/ndi/applications/connect/) - 🚫 No, not yet supported only works on Intel-based Macs - [Discussion #1](https://forums.newtek.com/threads/mac-m1-chipset-ndi-tools-support.163871/) [OBS Issue](https://github.com/Palakis/obs-ndi/issues/590)
* [OBS](https://obsproject.com/) - ✳️ Yes, works via Rosetta 2 - [MacRumors Discussion](https://forums.macrumors.com/threads/so-hows-m1-for-streamers-obs-streamlabs-obs-etc.2269239/) [Mention in Issue](https://github.com/obsproject/obs-studio/pull/3444#issuecomment-690216403)
* [Pioneer CDJ/XDJ Aggregator tool](https://support.pioneerdj.com/hc/en-us/articles/900002589966-CDJ-XDJ-Aggregator-Tool-for-Mac) - ✳️ Yes, works via Rosetta 2 - [Report](https://forums.pioneerdj.com/hc/en-us/community/posts/900003069263-How-to-tell-which-software-and-products-are-Apple-Silicon-Native-vs-translated-with-Rosetta-2?page=1#community_comment_900001461686)
* [Pioneer DJS-1000 DJS-TSP Project Creator](https://support.pioneerdj.com/hc/en-us/articles/360038536691-DJS-1000-DJS-TSP-Project-Creator-For-MAC) - ✳️ Yes, works via Rosetta 2 - [Report](https://forums.pioneerdj.com/hc/en-us/community/posts/900003069263-How-to-tell-which-software-and-products-are-Apple-Silicon-Native-vs-translated-with-Rosetta-2?page=1#community_comment_900001461686)
* [Pioneer INTERFACE 2](https://support.pioneerdj.com/hc/en-us/sections/360007668331-INTERFACE-2) - ✳️ Yes, works via Rosetta 2 - [Report](https://forums.pioneerdj.com/hc/en-us/community/posts/900003069263-How-to-tell-which-software-and-products-are-Apple-Silicon-Native-vs-translated-with-Rosetta-2?page=1#community_comment_900001461686)
* [Pioneer PRO DJ LINK BRIDGE](https://www.pioneerdj.com/en-us/product/software/pro-dj-link-bridge/software/overview/) - ✳️ Yes, works via Rosetta 2 - [Report](https://forums.pioneerdj.com/hc/en-us/community/posts/900003069263-How-to-tell-which-software-and-products-are-Apple-Silicon-Native-vs-translated-with-Rosetta-2?page=1#community_comment_900001461686)
* [Pioneer RB-DMX1](https://www.pioneerdj.com/en-us/product/software/rb-dmx1/dmx-interface/overview/) - ✳️ Yes, works via Rosetta 2 - [Report](https://forums.pioneerdj.com/hc/en-us/community/posts/900003069263-How-to-tell-which-software-and-products-are-Apple-Silicon-Native-vs-translated-with-Rosetta-2?page=1#community_comment_900001461686)
* [Pioneer RMX-1000 REMIXBOX](https://www.pioneerdj.com/en/support/software/effector/rmx-1000/) - ✳️ Yes, works via Rosetta 2 - [Report](https://forums.pioneerdj.com/hc/en-us/community/posts/900003069263-How-to-tell-which-software-and-products-are-Apple-Silicon-Native-vs-translated-with-Rosetta-2?page=1#community_comment_900001461686)
* [Pioneer TORAIZ SP-16 DJS-TSP Project Creator](https://support.pioneerdj.com/hc/en-us/articles/360038537531-TORAIZ-SP-16-DJS-TSP-Project-Creator-For-MAC) - ✳️ Yes, works via Rosetta 2 - [Report](https://forums.pioneerdj.com/hc/en-us/community/posts/900003069263-How-to-tell-which-software-and-products-are-Apple-Silicon-Native-vs-translated-with-Rosetta-2?page=1#community_comment_900001461686)
* [Pioneer TORAIZ SQUID Manager](https://support.pioneerdj.com/hc/en-us/articles/360038537451-TORAIZ-SQUID-Manager-for-Mac) - ✳️ Yes, works via Rosetta 2 - [Report](https://forums.pioneerdj.com/hc/en-us/community/posts/900003069263-How-to-tell-which-software-and-products-are-Apple-Silicon-Native-vs-translated-with-Rosetta-2?page=1#community_comment_900001461686)
* [Pioneer USB Connection Driver](https://support.pioneerdj.com/hc/en-us/articles/360038536051-USB-Connection-Link-Export-driver-for-Mac) - ✳️ Yes, works via Rosetta 2 - [Report](https://forums.pioneerdj.com/hc/en-us/community/posts/900003069263-How-to-tell-which-software-and-products-are-Apple-Silicon-Native-vs-translated-with-Rosetta-2?page=1#community_comment_900001461686)
* [ProPresenter](https://renewedvision.com/propresenter/#download) - ✅ Yes, Full Native Apple Silicon Support as of v7.4 - [Official Compatibilty Notes](https://support.renewedvision.com/hc/en-us/articles/360057548273-Big-Sur-Apple-Silicon-Compatibility) [NDI Compatibility](https://support.renewedvision.com/hc/en-us/articles/1500000361482-NDI-Compatibility-for-Apple-Silicon-Processors)
* [rekordbox](https://rekordbox.com/en/download/) - ✳️ Yes, works via Rosetta 2 with native support currently in development - [Official Support List](https://www.pioneerdj.com/en-us/landing/support-for-macos-big-sur/) [Verification](https://github.com/ThatGuySam/doesitarm/issues/560#issue-805540415)
* [Serato DJ Pro](https://serato.com/dj/pro/downloads/mac) - ✳️ Yes, works via Rosetta 2 translation - [Beta Download](https://serato.com/forum/area/740)
* [Super 8 R2](https://www.native-instruments.com/en/products/komplete/synths/super-8/) - ⏹ No, not working at all but support is in development - [Official Status](https://support.native-instruments.com/hc/en-us/articles/360013515618-macOS-11-Big-Sur-Compatibility-News) [Official Post](https://support.native-instruments.com/hc/en-us/articles/360014683497)
* [Traktor DJ 2](https://www.native-instruments.com/en/products/traktor/dj-software/traktor-dj-2/) - ✳️ Yes, works via Rosetta 2 - [Official Apple Silicon Status](https://support.native-instruments.com/hc/en-us/articles/360014683497-) [Official Big Sur Status](https://support.native-instruments.com/hc/en-us/articles/360013515618-macOS-11-Big-Sur-Compatibility-News) [Official Post](https://support.native-instruments.com/hc/en-us/articles/360014683497)
* [Traktor Pro 3](https://www.native-instruments.com/en/products/traktor/dj-software/traktor-pro-3/) - ✳️ Yes, works via Rosetta 2 - [Official Apple Silicon Status](https://support.native-instruments.com/hc/en-us/articles/360014683497-) [Official Big Sur Status](https://support.native-instruments.com/hc/en-us/articles/360013515618-macOS-11-Big-Sur-Compatibility-News) [Official Post](https://support.native-instruments.com/hc/en-us/articles/360014683497)
* [Wirecast](https://www.telestream.net/wirecast/) - ✅ Yes, Native Apple Silicon Support as of v14.2 - [Release Notes](https://telestreamforum.forumbee.com/t/g9hfmdt/wirecast-14-2-released-april-28-2020)




#### 3D and Architecture

* [ArcGIS CityEngine](https://www.esri.com/en-us/arcgis/products/arcgis-cityengine/overview) - 🚫 No, not supported, and no plans for support - [Official Article](https://community.esri.com/t5/arcgis-cityengine-documents/announcement-deprecation-of-macos-version-of-arcgis-cityengine/ta-p/1038521)
* [Archicad](https://graphisoft.com/solutions/products/archicad) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/343#issuecomment-869564667) [Graphisoft support update](https://helpcenter.graphisoft.com/knowledgebase/130674/) [Graphisoft Thread](https://archicad-talk.graphisoft.com/viewtopic.php?p=312614) [Reddit thread](https://www.reddit.com/r/ArchiCAD/comments/hsjs6l/archicad_and_macos_armtransition/) [Tudy's feedback](https://github.com/ThatGuySam/doesitarm/pull/189#issuecomment-742729489)
* [AutoCAD](https://www.autodesk.com/products/autocad/overview?plc=ACDIST&term=1-YEAR&support=ADVANCED&quantity=1) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/499#issuecomment-754202196) [AutoDesk Forums](https://forums.autodesk.com/t5/autocad-for-mac-forum/apple-silicon/m-p/9652836)
* [CADintosh](https://www.lemkesoft.de/en/products/cadintosh/download/) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Electric by Static Free Software](https://www.staticfreesoft.com/productsFree.html) - 🚫 No, not yet supported only works on Intel-based Macs - [Verification](https://github.com/ThatGuySam/doesitarm/issues/712#issue-932173888)
* [FreeCAD](https://www.freecadweb.org/downloads.php) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/711#issue-931671408)
* [PrusaSlicer](https://www.prusa3d.com/prusaslicer/) - ✅ Yes, Full Native Apple Silicon Support as of v2.3.1 - [Release Notes](https://github.com/prusa3d/PrusaSlicer/releases/tag/version_2.3.1)
* [Redshift](https://www.redshift3d.com/demo) - ✅ Yes, Full Native Apple Silicon Support - [Press Release](https://www.businesswire.com/news/home/20210413005903/en/Maxon-Announces-Redshift-for-macOS-Including-Native-Support-for-M1-Powered-Macs)
* [Rhinoceros 3D](https://www.rhino3d.com/download/) - ✳️ Yes, works via Rosetta 2 translation - [Developer Article](https://discourse.mcneel.com/t/apple-silicon-and-rhino-for-mac-the-work-continues/113164) [Known Bugs](https://mcneel.myjetbrains.com/youtrack/issues?q=project:%20RH%20tag:%20%7BApple%20Silicon%7D%20%23unresolved)
* [Shaper3D](https://www.shapr3d.com/) - ✅ Yes, it was shown at the November 10th event - [Apple Nov 10 Event](https://youtu.be/5AwdkGKmZ0I?t=2211)
* [SketchUp](https://www.sketchup.com/) - ✳️ Yes, works via Rosetta 2 - [Discussion](https://forums.sketchup.com/t/the-new-m1-processor/141946)
* [SOLIDWORKS](https://www.solidworks.com/sw/support/downloads.htm) - ✳️ Yes, works via Parallels Virtualization - [Working on Parallels](https://www.parallels.com/blogs/solidworks-for-mac/)
* [Timebox 3D Collage Maker](https://timeboxapp.com/) - ✅ Yes, Full Native Apple Silicon Support as of v8.1 - [Release Notes](https://timeboxapp.com/whats-new-81)
* [Ultimaker Cura](https://ultimaker.com/software/ultimaker-cura) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/424#issue-761853484)
* [VRay for SketchUp](https://www.chaosgroup.com/vray/sketchup) - 🚫 No, not yet supported but support is in development - [Article on Support](https://architosh.com/2020/11/chaos-group-real-time-rendering-comes-to-v-ray-5-for-sketchup/) [Discussion](https://forums.sketchup.com/t/v-ray-5-is-now-included-in-a-studio-subscription/159878/38)
* [ZBrush](https://pixologic.com/zbrush/downloadcenter/#) - ✳️ Yes, works via Rosetta 2 - [Official Article](https://support.pixologic.com/article/447-support-for-apple-silicon)


#### Productivity Tools

* [ABBYY FineReader PDF](https://pdf.abbyy.com/finereader-pdf-for-mac/) - ✳️ Yes, works via Rosetta 2 as of v15.0.2 - [Official Article](https://support.abbyy.com/hc/articles/360021357240-FineReader-PDF-for-Mac-and-Apple-M1-chip) [Release Notes](https://support.abbyy.com/hc/articles/4403148990994)
* [AccountEdge Pro](https://www.myob.com/au/accounting-software/accountedge) - 🚫 No, not yet supported only works on Intel-based Macs
* [Acrobat Pro](https://acrobat.adobe.com/us/en/acrobat/acrobat-pro.html) - ✅ Yes, Native Apple Silicon Support as of v21.007.20091 - [Known Issues](https://helpx.adobe.com/acrobat/kb/mac-os11-big-sur-compatibility.html#KnownIssues) [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [Acrobat Reader](https://get.adobe.com/reader/) - ✅ Yes, Native Apple Silicon Support as of v21.007.20091 - [Official Article #1](https://helpx.adobe.com/acrobat/kb/mac-os11-big-sur-compatibility.html#WhendoesAdobeplantonativelysupportAppleSilicondevices) [Official Article #2](https://helpx.adobe.com/acrobat/kb/apple-silicon-m1-processor-support.html)
* [ActivityWatch](https://activitywatch.net/) - ✳️ Yes, works via Rosetta 2 for v0.10.0 with issues reported on newer versions - [Verification](https://github.com/ThatGuySam/doesitarm/issues/832) [GitHub Issue](https://github.com/ActivityWatch/activitywatch/issues/630)
* [AdBlock Pro for Safari](https://apps.apple.com/app/id1018301773) - ✅ Yes, full native support as of v8.1.0 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/237#issue-746743506)
* [Adobe Bridge](https://www.adobe.com/products/bridge.html) - ✳️ Yes, works via Rosetta 2 with known issues - [Known Issues](https://helpx.adobe.com/bridge/kb/bridge-and-macos-big-sur.html#apple-silicon-compatibility) [Official Adobe Status Page](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html)
* [Agenda](https://agenda.com/) - ✅ Yes, Full Native Apple Silicon Support - [App Store Story](https://apps.apple.com/us/story/id1540024103)
* [Airmail](https://airmailapp.com/) - ✅ Yes, Full Native Apple Silicon Support as of v4.5.1 - [Release History](https://apps.apple.com/app/apple-store/id918858936)
* [Alfred](https://www.alfredapp.com/universal/) - ✅ Yes, fully supported - [Official Announcement](https://www.alfredapp.com/blog/announcements/alfred-ready-for-apple-m1-chip/)
* [Anki](https://apps.ankiweb.net/) - ✳️ Yes, fully supported as of 2.1.52 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/495)
* [AnyDesk](https://anydesk.com/en/downloads/mac-os) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Avid Link](https://www.avid.com/products/avid-link#Downloads) - 🚫 Not yet supported only works on Intel-based Macs - [Official Article](https://avid.secure.force.com/pkb/articles/en_US/Compatibility/macOS-Big-Sur-Support)
* [Avid MediaCentral](https://www.avid.com/products/mediacentral) - 🚫 Not yet supported only works on Intel-based Macs - [Official Article](https://avid.secure.force.com/pkb/articles/en_US/Compatibility/macOS-Big-Sur-Support)
* [Axure RP 9](https://www.axure.com/download) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/38)
* [Bandizip](https://en.bandisoft.com/bandizip.mac/) - ✅ Yes, Full Native Apple Silicon Support as of v7.03 - [Release Notes](https://en.bandisoft.com/bandizip.mac/history/)
* [Bear](https://bear.app/) - ✅ Yes, fully supported as v1.8.2 - [Bear Blog Post](https://blog.bear.app/2020/11/bear-gets-new-widgets-and-ready-for-big-sur/)
* [BetterTouchTool](https://folivora.ai/) - ✅ Yes, fully supported as of v3.502 - [Issue Tracker](https://community.folivora.ai/) [View on Setapp](https://setapp.sjv.io/c/2708043/470268/5114)
* [Blackmagic Disk Speed Test](https://apps.apple.com/app/id425264550) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/359#issuecomment-736255914)
* [Box Drive](https://www.box.com/resources/downloads) - ⏹ Not yet, but it's currently in development. - [Official Post](https://support.box.com/hc/en-us/community/posts/360051323454-Box-Drive-s-system-extension-failed-to-load?page=1#community_comment_1500000009302)
* [Brave Browser](https://brave.com/#mac-options) - ✅ Yes, Full Native Apple Silicon Support
* [BusyCal](https://www.busymac.com/busycal/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/471907/5114)
* [BusyContacts](https://www.busymac.com/busycontacts/) - ✅ Yes, Full Native Apple Silicon Support as of v1.5.0 - [Release Notes](https://www.busymac.com/busycontacts/releasenotes.html) [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/679262/5114)
* [Calibre](https://calibre-ebook.com/download_osx) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/26#issuecomment-736778254)
* [Call Recorder for Skype](https://www.ecamm.com/mac/callrecorder/) - 🚫 No, not supported and no plans for support - [Official Post](https://ecamm.com/blog/call-recorder-for-skype-update/)
* [Chrome](https://www.google.com/chrome/) - ✅ Yes, fully supported as of v87 - [Article](https://9to5google.com/2020/11/17/chrome-mac-apple-silicon/)
* [ChronoSync Express](https://www.econtechnologies.com/chronosync-express/overview.html) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344307/5114)
* [Citrix Workspace](https://www.citrix.com/downloads/workspace-app/mac/workspace-app-for-mac-latest.html) - ✳️ Yes, works via Rosetta 2 - [Discussion](https://discussions.citrix.com/topic/411196-will-citrix-viewer-run-on-new-apple-hardware-with-apple-silicon-m1/)
* [ClickUp Desktop](https://clickup.com/apps) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Coherence X](https://www.bzgapps.com/coherence) - 🚫 Not yet supported only works on Intel-based Macs - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/704581/5114)
* [Coloban](https://www.coloban.com) - ⏹ Not yet, but it's currently in development. - [Coloban Forum Issue](https://forum.coloban.com/index.php?u=/topic/21/new-arm-based-apple-computers)
* [CrossOver](https://www.codeweavers.com/) - ✳️ Runs via Rosetta 2 - [Official Blog](https://www.codeweavers.com/blog/jwhite/2020/11/10/its-great-to-live-in-interesting-times)
* [Day One Journal](https://apps.apple.com/app/id1055511498) - ✅ Yes, Full Native Apple Silicon Support as of v5.8 - [Release Notes](https://help.dayoneapp.com/en/articles/469749-mac-release-notes)
* [DEVONthink](https://www.devontechnologies.com/download/) - ✅ Yes, Full Native Apple Silicon Support as of v3.5.2 - [Release Notes](https://www.devontechnologies.com/blog/20200814-devonthink-352)
* [Diagrams for Mac](https://diagrams.app/) - ✅ Yes, Full Native Apple Silicon Support - [Release Notes](https://diagrams.app/releases#2.0) [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/diagrams)
* [Diarly](https://apps.apple.com/app/id13s87167765) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/diarly)
* [Downie](https://software.charliemonroe.net/downie/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344361/5114)
* [Drafts](https://itunes.apple.com/app/id1236254471?ls=1&mt=8&at=11l4Cf&ct=site) - ✅ Yes, Full Native Apple Silicon Support - [Official Tweet](https://twitter.com/draftsapp/status/1326263191601618945)
* [draw.io](https://github.com/jgraph/drawio-desktop/releases/) - ✅ Yes, Full Native Apple Silicon Support as of v14.1.8 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/651#issue-894929786)
* [Dropbox](https://www.dropbox.com/) - ✳️ Yes, works via Rosetta 2 as of v110.4.458 with native support in beta - [Official Article](https://help.dropbox.com/installs-integrations/apple-silicon-support) [Release Notes](https://www.dropboxforum.com/t5/Dropbox-desktop-client-builds/Beta-Build-140-3-1903/td-p/570154)
* [Dropzone](https://aptonic.com/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/515891/5114)
* [Due for Mac](https://www.dueapp.com/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/due)
* [EasyConnect](https://lstratman.github.io/EasyConnect/) - ✳️ Yes, works via Rosetta 2 translation as of v7.6.7 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/219)
* [EndNote](https://endnote.com/product-details) - ✅ Yes, Native Apple Silicon Support as of v20.1.0 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/704#issue-925503816)
* [EndNote X9](https://support.clarivate.com/Endnote/s/article/EndNote-X9?language=en_US) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/704#issuecomment-867321265)
* [Eon Timer](https://software.charliemonroe.net/eon/) - ✅ Yes, Full Native Apple Silicon Support - [Developer Article](https://blog.charliemonroe.net/big-sur-and-apple-silicon/)
* [Euclid](https://euclid.pr1mer.tech/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/euclid)
* [Evernote](https://evernote.com/download) - ✅ Yes, Full Native Apple Silicon Support - [Official message](https://discussion.evernote.com/forums/topic/141189-evernote-for-mac-is-now-optimized-for-m1-apple-silicon/) [Verification](https://github.com/ThatGuySam/doesitarm/issues/411#issuecomment-748291114)
* [ExpanDrive](https://www.expandrive.com/desktop/) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/675#issue-899219758)
* [Fantastical](https://flexibits.com/fantastical) - ✅ Yes, Full Native Apple Silicon Support - [Media Post](https://www.macrumors.com/2020/11/12/fantastical-update-for-macos-big-sur-apple-silicon/)
* [Firefox](https://www.mozilla.org/en-US/firefox/new/) - ✅ Yes, Full Native Apple Silicon Support as of v84 - [Release Notes](https://www.mozilla.org/en-US/firefox/84.0/releasenotes/)
* [flickery](https://eternalstorms.at/flickery) - ✅ Yes, Full Native Apple Silicon Support as of v1.9.48 - [Blog Post](https://blog.eternalstorms.at/2020/11/09/app-update-galore/)
* [Focus for Mac](https://heyfocus.com/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/focus)
* [Folx](https://mac.eltima.com/download-manager.html) - ✳️ Runs via Rosetta 2 translation with native support not reported to be in development - [Verification](https://github.com/ThatGuySam/doesitarm/issues/665#issue-899016989)
* [Foxit Reader](https://apps.apple.com/lk/app/foxit-reader/id1032155965?mt=12) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/659#issue-898744558)
* [Free Download Manager](https://www.freedownloadmanager.org/download-fdm-for-mac.htm) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/765#issuecomment-1016405797) [Forum Discussion](https://www.freedownloadmanager.org/board/viewtopic.php?f=3&t=18394)
* [FSNotes](https://github.com/glushchenko/fsnotes/releases) - ✅ Yes, Full Native Apple Silicon Support as of v4.9.3 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/612#issue-840175974)
* [Geekbench](https://www.geekbench.com/download/mac/) - ✅ Yes, full native support as of v5.3 - [Release Notes](https://www.geekbench.com/blog/2020/11/geekbench-53/)
* [GEMS Connect](https://apps.apple.com/ae/app/gems-connect/id1462613346) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/668#issue-899019404)
* [GitHub Classroom Assistant](https://classroom.github.com/assistant) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/419#issue-760871225)
* [Glimpses](https://eternalstorms.at/glimpses) - ✅ Yes, Full Native Apple Silicon Support as of v2.2.3 - [Blog Post](https://blog.eternalstorms.at/2020/11/09/app-update-galore/)
* [GoodNotes](https://apps.apple.com/app/apple-store/id1444383602?pt=525432&ct=goodnotes.com&mt=8) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/972)
* [GoodTask](https://goodtaskapp.com/mac/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344377/5114)
* [Google Backup and Sync](https://www.google.com/drive/download/) - ✳️ Yes, works via Rosetta 2 as of v3.54 - [Release Notes](https://support.google.com/a/answer/7573023?hl=en) [Verification](https://github.com/ThatGuySam/doesitarm/issues/564#issue-807949490)
* [Google Drive for desktop](https://support.google.com/drive/answer/7329379#zippy=%2Cdownload-install-google-drive-for-desktop) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/589#issuecomment-896177858)
* [Grapefruit for Mac](https://haveagrapefruit.com/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/grapefruit)
* [Harvest for Mac](https://www.getharvest.com/apps/mac) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/604#issue-835321721)
* [HCL Notes](https://www.hcltechsw.com/products/nd) - 🔶 Unknown, more info needed - [Discussion](https://domino-ideas.hcltechsw.com/ideas/NTS-I-1496)
* [Highland 2](https://quoteunquoteapps.com/highland-2/) - ✅ Yes, Full Native Apple Silicon Support as of v2.9 - [App Store Story](https://apps.apple.com/us/story/id1540024103)
* [Highlights for Mac](https://highlightsapp.net/) - ✅ Yes, Full Native Apple Silicon Support as of v2020.3 - [Official Blog](https://highlightsapp.net/blog/2020/11/12/Time-for-change/)
* [HomeSafe View](https://support.swann.com/s/article/NcSSjCM8VF) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/657#issue-898687971)
* [IA Writer](https://apps.apple.com/us/app/ia-writer/id775737172) - ✅ Yes, Full Native Apple Silicon Support - [Official Twitter](https://twitter.com/iawriter/status/1326284671005696009?s=21)
* [IDrive](https://www.idrive.com/online-backup-download) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/542#issue-797628007)
* [iMazing 2](https://imazing.com/download) - ✳️ Yes, works via Rosetta 2 with native support in development - [Release notes](https://downloads.imazing.com/mac/iMazing/2.13.1.14452/release-notes.html)
* [InstaCal](https://apps.apple.com/us/app/instacal-menu-bar-calendar/id1247292524) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/instacal)
* [iStudiez Pro](https://istudentpro.com/) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/820#issue-1056741734)
* [Jira Cloud for Mac](https://www.atlassian.com/software/jira/mac) - ✅ Yes, Full Native Apple Silicon Support as of v136.0 - [Release Notes](https://support.atlassian.com/jira-cloud-macos/docs/whats-new-in-jira-cloud-for-macos/) [Verification](https://github.com/ThatGuySam/doesitarm/issues/775)
* [Jump Desktop](https://jumpdesktop.com/) - ✅ Yes, Full Native Apple Silicon Support as of v8.7.15 - [Changelog](https://changelog.jumpdesktop.com/jump-desktop-8.7.15-for-mac-3cSLeM)
* [Keep It](https://reinventedsoftware.com/keepit/) - ✅ Yes, Full Native Apple Silicon Support as of v1.9 - [Official News](https://reinventedsoftware.com/news/)
* [Key Codes](https://manytricks.com/keycodes/) - ✅ Yes, Full Native Apple Silicon Support as of v2.2 - [Official Tweet](https://twitter.com/manytricks/status/1333456606449774595)
* [Lacona](https://lacona.app/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344402/5114)
* [Later](https://getlater.app/) - ✅ Yes, Native Apple Silicon Support - [Verfication](https://github.com/ThatGuySam/doesitarm/issues/971)
* [LaunchBar](https://www.obdev.at/products/launchbar/download.html) - ✅ Yes, Full Native Apple Silicon Support - [Source](https://github.com/ThatGuySam/doesitarm/issues/320)
* [Ledger Live](https://www.ledger.com/ledger-live/download) - ✳️ Yes, works via Rosetta 2 with native support in development - [Source](https://github.com/ThatGuySam/doesitarm/pull/396)
* [LibreOffice](https://www.libreoffice.org/download/download/) - ✅ Yes, Native Apple Silicon Support as of v7.2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/730#issue-952018353) [Release Notes](https://www.libreoffice.org/download/release-notes/) [Official Post](https://www.collaboraoffice.com/desktop/update-on-libreoffice-support-for-arm-based-macs/)
* [MarsEdit](https://redsweater.com/marsedit/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/613035/5114)
* [MathFlash Fun Desktop Edition](https://apps.apple.com/us/app/mathflash-fun-desktop-edition/id1516195356) - ✅ Yes, Native Apple Silicon Support as of v1.1 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/264#issuecomment-869493153)
* [Merlin Project](https://www.projectwizards.net/en/merlin-project) - ✅ Yes, Full Native Apple Silicon Support as of v7.1.0 - [Official Post](https://www.projectwizards.net/en/blog/2020/11/merlin-project-v71_m1-mac)
* [Merlin Project Express](https://www.projectwizards.net/en/merlin-project-express) - ✅ Yes, Full Native Apple Silicon Support as of v7.1.0 - [Official Post](https://www.projectwizards.net/en/blog/2020/11/merlin-project-v71_m1-mac) [View on Setapp](https://setapp.sjv.io/c/2708043/368245/5114)
* [Microsoft Edge](https://www.microsoft.com/en-us/edge) - ✅ Yes, Full Native Apple Silicon Support as of v88.0.705.50 - [Release Notes](https://docs.microsoft.com/en-us/deployedge/microsoft-edge-relnote-stable-channel)
* [Microsoft Excel](https://apps.apple.com/cn/app/microsoft-excel/id462058435?l=en&mt=12) - ✅ Yes, Full Native Apple Silicon Support as of v16.44
* [Microsoft Office 365](https://www.microsoft.com/en-us/microsoft-365/office-365) - ✅ Yes, Full Native Apple Silicon Support as of v16.44 - [Official Post](https://www.microsoft.com/en-us/microsoft-365/blog/2020/12/15/4-ways-microsoft-365-is-improving-the-experience-for-mac-users/) [WWDC Preview](https://youtu.be/GEZhD3J89ZE?t=5681)
* [Microsoft OneNote](https://apps.apple.com/cn/app/microsoft-onenote/id784801555?l=en&mt=12) - ✅ Yes, Full Native Apple Silicon Support as of v16.44
* [Microsoft Outlook](https://apps.apple.com/app/microsoft-outlook/id985367838?l=en&mt=12) - ✅ Yes, Full Native Apple Silicon Support as of v16.44
* [Microsoft PowerPoint](https://apps.apple.com/cn/app/microsoft-powerpoint/id462062816?l=en&mt=12) - ✅ Yes, Full Native Apple Silicon Support as of v16.44
* [Microsoft Remote Desktop](https://apps.apple.com/au/app/microsoft-remote-desktop/id1295203466?mt=12) - ✅ Yes, Full Native Apple Silicon Support as of v10.6.0 - [App Store Version History](https://apps.apple.com/gb/app/microsoft-remote-desktop/id1295203466?mt=12)
* [Microsoft Word](https://apps.apple.com/cn/app/microsoft-word/id462054704?l=en&mt=12) - ✅ Yes, Full Native Apple Silicon Support as of v16.44
* [MindNode](https://mindnode.com/) - ✅ Yes, Full Native Apple Silicon Support - [App Store Story](https://apps.apple.com/us/story/id1540024103) [View on Setapp](https://setapp.sjv.io/c/2708043/557413/5114)
* [Moment for macOS](https://fireball.studio/moment) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/896739/5114)
* [Monero GUI Wallet](https://www.getmonero.org/downloads/) - ✳️ Yes, works via Rosetta 2 with a few minor bugs - [Source](https://github.com/ThatGuySam/doesitarm/issues/435)
* [MoneyWiz](https://apps.apple.com/us/app/moneywiz-3-personal-finance/id1004710719) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/) [View on Setapp](https://setapp.sjv.io/c/2708043/344415/5114)
* [Moon FM](https://apps.apple.com/us/app/moon-fm-premium-podcast-app/id1465712037?mt=12) - ✅ Yes, Full Native Apple Silicon Support as of v2.0.3
* [Newton Mail](https://newtonhq.com/#app) - ✅ Yes, Full Native Apple Silicon Support
* [Nisus Writer Express](https://nisus.com/Express/) - ✅ Yes, Full Native Apple Silicon Support as of v3.2 (some file conversion helpers run in Rosetta) - [Release notes](https://www.nisus.com/pro//whatsnew.php)
* [Nisus Writer Pro](https://nisus.com/pro/) - ✅ Yes, Full Native Apple Silicon Support as of v3.2 (some file conversion helpers run in Rosetta) - [Release notes](https://www.nisus.com/pro//whatsnew.php)
* [Notability](https://www.gingerlabs.com/) - ✅ Yes, Native Apple Silicon Support as of v10.4.4 - [App Store Version History](https://apps.apple.com/us/app/notability/id360593530?mt=8&ign-mpt=uo%3D4)
* [Noted for macOS](https://apps.apple.com/us/app/noted/id1541403993) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [NotePlan](https://noteplan.co/) - ✅ Yes, Full Native Apple Silicon Support as of v3.0.16 - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/noteplan)
* [Notion Desktop](https://www.notion.so) - ✅ Yes, Full Native Apple Silicon Support - [Official Tweet](https://twitter.com/NotionHQ/status/1333867094463582208?ref_src=twsrc%5Egoogle%7Ctwcamp%5Eserp%7Ctwgr%5Etweet) [Verification](https://github.com/ThatGuySam/doesitarm/issues/378#issue-755529762)
* [Noto](https://noto.ink/) - ✅ Yes, Full Native Apple Silicon Support - [App Store Story](https://apps.apple.com/us/story/id1540024103)
* [Obsidian](https://obsidian.md/download) - ✅ Yes, full native support as of v0.10.1
* [OmniFocus](https://www.omnigroup.com/omnifocus) - ✅ Yes, Full Native Apple Silicon Support as of v3.10 - [Release Notes](https://www.omnigroup.com/releasenotes/omnifocus)
* [OmniGraffle](https://www.omnigroup.com/omnigraffle) - ✅ Yes, Full Native Apple Silicon Support as of v7.18 - [Release Notes](https://www.omnigroup.com/releasenotes/omnigraffle)
* [OmniOutliner](https://www.omnigroup.com/omnioutliner) - ✅ Yes, Full Native Apple Silicon Support as of v5.8 - [Release Notes](https://www.omnigroup.com/releasenotes/omnioutliner)
* [OmniPlan](https://www.omnigroup.com/omniplan) - ✅ Yes, Full Native Apple Silicon Support as of v4.2 - [Release Notes](https://www.omnigroup.com/releasenotes/omniplan)
* [ONLYOFFICE](https://www.onlyoffice.com/download-desktop.aspx?from=desktop) - ✅ Yes, Full Native Apple Silicon Support as of v6.4 - [Release Notes](https://www.onlyoffice.com/blog/2021/10/onlyoffice-desktop-editors-v6-4-with-improved-arm-support-and-conditional-formatting/)
* [Opera Web Browser](https://www.opera.com/) - ✅ Yes, Full Native Apple Silicon Support as of v75.0.3969.149 - [Blog Post](https://blogs.opera.com/desktop/2021/04/opera-just-got-even-faster-with-m1-support-for-mac-fans-and-custom-shortcuts/)
* [Panopto](https://support.panopto.com/s/article/Install-Panopto-for-Mac) - ✅ Yes, Native Apple Silicon Support as of v10.2.0
* [Parcel](https://parcelapp.net/) - ✅ Yes, Full Native Apple Silicon Support as of 6.6 - [Tweet](https://twitter.com/parcel_app/status/1325751301322362880)
* [PDF Expert](https://pdfexpert.com/) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/103#issuecomment-846406822)
* [PDF Viewer](https://pdfviewer.io/) - ✅ Yes, Full Native Apple Silicon Support as of v5.1 - [Blog Post](https://pdfviewer.io/blog/2020/pdf-viewer-5-1-for-ipad-iphone-mac/)
* [PDFelement](https://pdf.wondershare.com/pdf-editor-mac/) - ✅ Yes, fully supported ARM and Intel Chip - [Official Post](https://pdf.wondershare.com/macos/pdfelement-ready-for-apple-m1-chip.html)
* [PDFpen](https://pdfpen.com/pdfpen/download/) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/672#issue-899209847)
* [PDFZone](https://apps.apple.com/app/pdfzone/id1215383084) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/471#issue-774767869)
* [Planny 4](https://www.kevinreutter.de/planny-4/) - ✅ Yes, Full Native Apple Silicon Support - [App Store Story](https://apps.apple.com/us/story/id1540024103)
* [Post-it®](https://apps.apple.com/app/post-it/id1475777828) - ✳️ Yes, runs via Rosetta 2, with native support coming soon - [Source](https://github.com/ThatGuySam/doesitarm/issues/197#issuecomment-732100064)
* [Presentify](https://presentify.compzets.com/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/849350/5114)
* [Prizmo](https://creaceed.com/prizmo) - ✅ Yes, Full Native Apple Silicon Support as of v4.1 - [Release Notes](https://creaceed.com/prizmo/history) [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/473005/5114)
* [ProtonMail Bridge](https://proton.me/mail/bridge) - ✳️ Yes, runs via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/738#issue-960386072)
* [qBittorrent](https://www.qbittorrent.org/) - ✳️ Yes, runs via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/595#issue-830367382) [Native Issue](https://github.com/qbittorrent/qBittorrent/issues/14379)
* [qpdf](https://github.com/qpdf/qpdf/releases) - ✅ Yes, Full Native Apple Silicon Support - [Release Notes](https://qpdf.readthedocs.io/en/stable/release-notes.html) [Project on sourceforge](https://sourceforge.net/projects/qpdf/files/) [Verification](https://github.com/ThatGuySam/doesitarm/issues/813)
* [QuickPresent App](https://www.quickpresent.app) - ✅ Yes, Full Native Apple Silicon Support 
* [Quiet](https://petercammeraat.net/projects/quiet/) - ✅ Yes, fully supported as of v2.6.7 - [Source](https://petercammeraat.net/journal/2020/apple-silicon-support/)
* [Receipts for Mac](https://www.receipts-app.com/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/635278/5114)
* [Reeder](https://reederapp.com/) - ✅ Yes, Native Apple Silicon Support - [Report #1](https://github.com/ThatGuySam/doesitarm/issues/674#issue-899215422)
* [Remotix](https://remotix.com/downloads-mac/) - ✅ Yes, fully supported as of v6.3 - [Release Notes](https://downloads.remotix.com/remotix-mac/release-notes.html?v=6.3)
* [RingCentral](https://apps.apple.com/us/app/id715886894) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/251#issuecomment-736105390)
* [Safari Web Browser](https://www.apple.com/safari/) - ✅ Yes, fully supported
* [Schedulist](https://www.schedulist.app/) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/993)
* [ScreenFloat](https://eternalstorms.at/ScreenFloat/) - ✅ Yes, Full Native Apple Silicon Support as of v1.5.18 - [Blog Post](https://blog.eternalstorms.at/2020/11/09/app-update-galore/)
* [Screens for macOS](https://edovia.com/en/screens-mac/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344456/5114)
* [SeaDrive](https://www.seafile.com/en/download/) - ✳️ Yes, works via Rosetta 2 as of v2.0.10 - [Source](https://forum.seafile.com/t/seadrive-2-0-8-is-released-support-for-macos-11/13199/25)
* [SeaFile](https://www.seafile.com/en/download/) - ✳️ Yes, works via Rosetta 2 as of v7.0.10 - [Source](https://forum.seafile.com/t/native-support-for-apple-silicon/13390)
* [Session for Mac](https://www.stayinsession.com/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/933407/5114)
* [Shadow for macOS](https://shadow.tech/shadow-apps/) - ✅ Yes, Native Apple Silicon Support as of v4.28.7 - [Release Notes](https://forum.shadow.tech/roadmap-release-notes-24/shadow-update-week-39-10-01-2021-3167)
* [SideNotes](https://www.apptorium.com/sidenotes) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/668340/5114)
* [Skim PDF Reader](https://skim-app.sourceforge.io/) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/468#issuecomment-751807890)
* [Skitch](https://evernote.com/products/skitch) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/821#issue-1059058802)
* [Slidepad](https://slidepad.app/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/slidepad)
* [SnagIt](https://www.techsmith.com/download/snagit/) - ✳️ Yes, works via Rosetta 2 but without video capture - [Source](https://github.com/ThatGuySam/doesitarm/issues/413) [Official documentation](https://support.techsmith.com/hc/en-us/articles/360052555611-Snagit-and-Apple-Silicon-Compatibility-Info)
* [Studies for Mac](https://www.studiesapp.com/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344468/5114)
* [Synology Drive Client](https://www.synology.com/en-us/support/download/DDSM#utilities) - ✅ Yes, Native Apple Silicon Support reported as of v3.2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/1015#issue-1698388317)
* [Tablecruncher](https://tablecruncher.com/download/) - ✅ Yes, Full Native Apple Silicon Support - [Official Post](https://tablecruncher.com/blog/2020/version-1.5.1-apple-silicon-ready/)
* [Taskheat](https://www.eyen.fr/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/taskheat)
* [TaskPaper](https://www.taskpaper.com/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344469/5114)
* [TeamViewer](https://www.teamviewer.com/en-us/) - ✅ Yes, Full Native Apple Silicon Support as of v15.12.4 - [Release Notes](https://community.teamviewer.com/t5/Change-Logs-EN/macOS-v15-12-4-Full-Change-Log/m-p/107706)
* [TextSniper](https://textsniper.app/) - ✅ Yes, Full Native Apple Silicon Support as of v1.3.1 - [Release Notes](https://textsniper.app/release-notes) [Verification](https://github.com/ThatGuySam/doesitarm/issues/571#issue-811238095)
* [Things](https://culturedcode.com/things/mac/appstore/) - ✅ Yes, fully supported as of 3.13.2 - [Official Announcement](https://culturedcode.com/things/blog/2020/11/new-things-for-macos-big-sur/)
* [Thunderbird](https://www.thunderbird.net/en-US/) - ✅ Yes, Full Native Apple Silicon Support as of v87 - [Bugzilla Tracker](https://bugzilla.mozilla.org/show_bug.cgi?id=1678775) [Verification](https://github.com/ThatGuySam/doesitarm/issues/591#issue-824609519)
* [Time Out for Mac](https://www.dejal.com/timeout/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/689682/5114)
* [Timing for Mac](https://timingapp.com/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344474/5114)
* [TP-Link Deco](https://apps.apple.com/ae/app/tp-link-deco/id1186159417) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/667#issue-899018925)
* [Transmission](https://transmissionbt.com/) - ✳️ Yes, works via Rosetta 2 with native support on nightly - [Source](https://github.com/ThatGuySam/doesitarm/issues/326)
* [Trello](https://apps.apple.com/de/app/trello/id1278508951?mt=12) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/581#issue-816735691)
* [Trezor Suite](https://suite.trezor.io/) - ✅ Yes, Native Apple Silicon Support as of 21.9.2 - [Release Notes](https://github.com/trezor/trezor-suite/releases/tag/v21.9.2) [Article](https://blog.trezor.io/trezor-suite-and-firmware-updates-september-2021-a490f2ea16c1)
* [Tuple](https://tuple.app/) - ✅ Yes, Full Native Apple Silicon Support - [Official Article](https://docs.tuple.app/article/60-supported-platforms)
* [TurboTax](https://turbotax.intuit.com/personal-taxes/cd-download/) - ✳️ Runs via Rosetta with no immediate plans for native support - [Discussion](https://ttlc.intuit.com/community/taxes/discussion/re-turbotax-deluxe-under-macos-bigsur-on-macbook-air-apple-m1-chip-turbotax-app-doesn-t-open/01/2273549#M815580)
* [UctoX](https://software.charliemonroe.net/uctox/) - ✅ Yes, Full Native Apple Silicon Support - [Developer Article](https://blog.charliemonroe.net/big-sur-and-apple-silicon/) [View on Setapp](https://setapp.sjv.io/uctox)
* [Ulysses](https://ulysses.app/) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/120#issuecomment-750041670) [MacRumors Article](https://www.macrumors.com/2020/11/13/apple-silicon-macs-universal-apps/) [View on Setapp](https://setapp.sjv.io/c/2708043/344477/5114)
* [Unibox](https://www.uniboxapp.com/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/368242/5114)
* [Usher](https://manytricks.com/usher/) - ✅ Yes, Full Native Apple Silicon Support as of v2.0 - [Official Tweet](https://twitter.com/manytricks/status/1333456606449774595)
* [Velja](https://apps.apple.com/us/app/velja/id1607635845?mt=12) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/970)
* [Vidrio](https://vidr.io/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/833645/5114)
* [VisualGrep](https://apps.apple.com/us/app/visualgrep/id597887722?mt=12) - ✅ Yes, Full Native Apple Silicon Support as of v1.3.30 - [GitHub issue](https://github.com/visualgrep/app/issues/46)
* [VMware Fusion](https://www.vmware.com/products/fusion.html) - ⏹ No, not working at all but with native support in beta - [Tech Preview Download](https://customerconnect.vmware.com/downloads/get-download?downloadGroup=FUS-PUBTP-2021H1) [Official Article](https://blogs.vmware.com/teamfusion/2021/09/fusion-for-m1-public-tech-preview-now-available.html)
* [VMWare Horizon Client](https://my.vmware.com/en/web/vmware/downloads/info/slug/desktop_end_user_computing/vmware_horizon_clients/horizon_8) - ✅ Yes, Native Apple Silicon Support as of v8.7.0 - [Release Notes](https://docs.vmware.com/en/VMware-Horizon-Client-for-Mac/2209/rn/vmware-horizon-client-for-mac-2209-release-notes/index.html)
* [VMWare Remote Console](https://apps.apple.com/app/vmware-remote-console/id1230249825) - ✅ Yes, Full Native Apple Silicon Support as of v12.0.0 - [Release Notes](https://docs.vmware.com/en/VMware-Remote-Console/12.0/rn/VMware-Remote-Console-120-Release-Notes.html)
* [VNC Viewer](https://www.realvnc.com/en/connect/download/viewer/macos/) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/643#issue-880713134)
* [WizNote](https://www.wiz.cn/) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/451#issuecomment-869375149)
* [Workspaces](https://www.apptorium.com/workspaces) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/389439/5114)
* [WPS Office](https://apps.apple.com/cn/app/wps-office/id1443749478?l=en&mt=12) - ✅ Yes, full native support as of v3.0.1 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/149)
* [WriteMapper](https://writemapper.com/) - ✅ Yes, Native Apple Silicon Support as of v3.0 - [Official Article](https://writemapper.com/support/is-the-apple-m1-silicone-chip-supported-on-mac-computers/)
* [XMind](https://apps.apple.com/us/app/xmind-mind-map/id1286983622) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/714#issue-932361182)
* [Yoink](https://eternalstorms.at/yoink/mac/) - ✅ Yes, Full Native Apple Silicon Support as of v3.5.11 - [Blog Post](https://blog.eternalstorms.at/2020/11/09/app-update-galore/)
* [Zettlr](https://www.zettlr.com/download) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/587#issue-817891514)



#### Entertainment and Media Apps

* [2048 Game](https://apps.apple.com/us/app/2048-game/id871033113?mt=12) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Amazon Music](https://music.amazon.com/NA/help/apps) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/634#issue-870540625)
* [Asphalt 9](https://apps.apple.com/us/app/asphalt-9-legends/id1491129197?mt=12) - ✅ Yes, Native Apple Silicon Support
* [BlueStacks](https://www.bluestacks.com/) - 🚫 No, not yet supported only works on Intel-based Macs - [Report #1](https://www.reddit.com/r/BlueStacks/comments/n9f9wn/apple_silicon/gxowg9g?utm_source=share&utm_medium=web2x&context=3) [Report #2](https://www.reddit.com/r/BlueStacks/comments/kea3uw/macos_bigsur_111_with_m1_issue/gg3xi2r?utm_source=share&utm_medium=web2x&context=3)
* [Celeste](https://mattmakesgames.itch.io/celeste?ac=QWRPsg4sVvG) - ✳️ Yes, works via Rosetta 2 translation as v1.4.0.0 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/1021#issue-1847811849) [View on Itch.io](https://mattmakesgames.itch.io/celeste?ac=QWRPsg4sVvG)
* [Citra Emulator](https://citra-emu.org/download/) - ✳️ Yes, works via Rosetta 2 translation - [Discussion](https://community.citra-emu.org/t/citra-on-apple-m1/327198/2) [Github Issue](https://github.com/citra-emu/citra/issues/5005)
* [Cog Player](https://cog.losno.co/download) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [DeSmuME](https://desmume.org/download/) - ✅ Yes, Native Apple Silicon Support as of v0.9.13 - [Verification](https://github.com/TASEmulators/desmume/issues/418#issuecomment-1086974738)
* [Dolphin](https://dolphin-emu.org/download/) - ✅ Yes, Native Apple Silicon Support as of v5.0-14295 - [Pull Request](https://github.com/dolphin-emu/dolphin/pull/9441)
* [DOSBox](https://sourceforge.net/projects/dosbox/) - ✳️ Yes, it works via Rosetta 2 - [Project Ticket 149](https://sourceforge.net/p/dosbox/feature-requests/149/)
* [DOSBox-X](https://dosbox-x.com) - ✅ Yes, Full Native Apple Silicon Support as of 0.83.8 - [Github Release](https://github.com/joncampbell123/dosbox-x/releases/tag/dosbox-x-v0.83.8)
* [Elmedia Player](https://www.elmedia-video-player.com/) - ✅ Yes, full native support as of 8.0 - [Release Notes](https://www.eltima.com/blog/2021/06/elmedia-8-0-is-out.html)
* [FS-UAE](https://fs-uae.net/) - ✅ Yes, Native Apple Silicon Support as of v3.1.17 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/706#issuecomment-865237294) [Apple Silicon Download](https://fs-uae.net/2021/06/09/builds-for-macos-arm64-m1-apple-silicon-have-arrived/comment-page-1?unapproved=1015254&moderation-hash=7ab3b3425385d84f331ec6d4faa54ff7)
* [Hatsune Miku: Project DIVA Mega Mix+](https://store.steampowered.com/app/1761390/Hatsune_Miku_Project_DIVA_Mega_Mix/) - ✳️ Yes, works via Parallels virtualization - [Verification](https://github.com/ThatGuySam/doesitarm/issues/959)
* [Hue Sync](https://www.philips-hue.com/en-us/explore-hue/propositions/entertainment/sync-with-pc#get_the_app) - ✳️ Yes, works via Rosetta 2 Translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/709#issue-930809920)
* [IINA](https://iina.io/download/) - ✅ Yes, Full Native Apple Silicon Support as of 1.2.0 - [Github Release](https://github.com/iina/iina/releases/tag/v1.2.0)
* [Infuse](https://apps.apple.com/app/infuse-7/id1136220934) - ✅ Yes, Native Apple Silicon Support as of v7 - [Discussion](https://github.com/ThatGuySam/doesitarm/issues/458)
* [JustStream](https://www.electronic.us/products/just-stream/) - ✅ Yes, Full Native Apple Silicon Support as of v2.0 - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/juststream)
* [Meta for Mac](https://www.nightbirdsevolve.com/meta/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/840201/5114)
* [Minecraft](https://www.minecraft.net/en-us/about-minecraft) - ✳️ Yes, works via Rosetta 2 - [Native Apple Silicon Workaround](https://github.com/yusefnapora/m1-multimc-hack)
* [Moonlight](https://github.com/moonlight-stream/moonlight-qt/releases) - ✅ Yes, Full Native Apple Silicon Support as of v3.1.0 - [Release Notes](https://github.com/moonlight-stream/moonlight-qt/releases/tag/v3.1.0)
* [Movist](https://movistprime.com/) - ✅ Yes, Full Native Apple Silicon Support as of v2.6 - [Changelog](https://movistprime.com/changelog.html) [View on Setapp](https://setapp.sjv.io/c/2708043/628489/5114)
* [NetEase Music](https://music.163.com/#/download) - ✅ Yes, Full Native Apple Silicon Support as of v2.3.4 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/528#issue-789094015)
* [News Explorer](https://betamagic.nl/products/newsexplorer.html) - ✅ Yes, Full Native Apple Silicon Support as of v1.9.11 - [Blog Post](https://betamagic.nl/news/2020/2020_09.html) [View on Setapp](https://setapp.sjv.io/c/2708043/368247/5114)
* [NVIDIA GeForce NOW](https://www.nvidia.com/en-us/geforce-now/download/) - ✅ Yes, Full Native Apple Silicon Support as of v2.0.27 - [Release Notes](https://www.nvidia.com/pt-br/geforce/release-notes/GFN/2_0_27/Rich/gfn-v2_0_27-rich-release-highlights/)
* [OpenRCT2](https://openrct2.io/) - ✅ Yes, Native Apple Silicon Support as of v0.3.5 - [Release Notes](https://raw.githubusercontent.com/OpenRCT2/OpenRCT2/develop/distribution/changelog.txt)
* [Parsec](https://parsec.app/downloads) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/513#issue-782309694)
* [PPSSPP](https://build.ppsspp.org/?page/downloads#osx) - ✅ Yes, Full Native Apple Silicon Support as of v1.11 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/347#issuecomment-776444965)
* [PS Remote Play](https://remoteplay.dl.playstation.net/remoteplay/lang/en/ps5_mac.html) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/441#issuecomment-748282150)
* [Q-emuLator](https://web.archive.org/web/http://www.terdina.net/ql/q-emulator.html) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/104#issuecomment-869404710)
* [QQ音乐(QQ Music)](https://apps.apple.com/cn/app/qq音乐-让生活充满音乐/id595615424?l=en&mt=12) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/368)
* [Remote Buddy](https://www.iospirit.com/products/remotebuddy/download/) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/556#issue-802733637)
* [RetroArch](https://www.retroarch.com/?page=platforms) - ✅ Yes, Native Apple Silicon Support - [Official Article](https://www.libretro.com/index.php/retroarch-for-apple-mac-m1-softlaunches-today/)
* [Roblox Player](https://www.roblox.com/download) - ✅ Yes, Native Apple Silicon Support as of v582 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/1019#issue-1803556097)
* [Rottenwood](https://software.charliemonroe.net/rottenwood/) - ✅ Yes, Full Native Apple Silicon Support - [Developer Article](https://blog.charliemonroe.net/big-sur-and-apple-silicon/)
* [Shazam](https://apps.apple.com/app/shazam/id897118787?mt=12) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/582#issue-816739441)
* [Snap Camera](https://snapcamera.snapchat.com/download/) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/627#issue-860435755) [Supported Hardware](https://snapcamera.snapchat.com/download/)
* [Spotify](https://www.spotify.com/download/mac/) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/768)
* [Steam](https://store.steampowered.com/about/) - ✳️ Yes, reported working via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/153)
* [Tidal](https://tidal.com/download) - ✅ Yes, Full Native Apple Silicon Support as of v2.30.0.465 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/915)
* [Twitch Studio](https://www.twitch.tv/downloads/) - ✅ Yes, works natively - [Verification](https://github.com/ThatGuySam/doesitarm/issues/387#issuecomment-1257204749)
* [UU Booster](https://uu.163.com/down/mac/) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/464#issue-771607189)
* [Vienna](https://github.com/ViennaRSS/vienna-rss/releases/latest) - ✅ Yes, Full Native Apple Silicon Support as of v3.6 - [Release Notes](https://github.com/ViennaRSS/vienna-rss/releases/tag/v/3.6.0)
* [VLC](https://www.videolan.org/vlc/download-macosx.html) - ✅ Yes, Full Native Apple Silicon Support as of v3.0.12 - [Release Notes](https://www.videolan.org/news.html#news-2021-01-12)
* [Xbox Game Pass for PC](https://www.xbox.com/en-US/xbox-game-pass/pc-games) - ✳️ Yes, works via Parallels virtualization - [Download Parallels](https://prf.hn/l/6qOdLPB)
* [Zwift](https://www.zwift.com/eu-de/download) - ✳️ Yes, works via Rosetta 2 as of v1.0 (25) - [Source](https://forums.zwift.com/t/m1-apple-silicon-compatibility/514491/81) [Verification](https://raw.githubusercontent.com/steve1878/images_does_it_arm/main/zwift_1.0_25.png)



#### Social and Communication

* [AirMessage](https://airmessage.org/install/) - ✅ Yes, Native Apple Silicon Support as of v3.2.1 - [Release Notes](https://github.com/airmessage/airmessage-server-legacy/releases/tag/rel-3.2.1) [Verification](https://github.com/ThatGuySam/doesitarm/issues/881#issue-1130176479)
* [AliWangWang](https://wangwang.taobao.com/) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/221#issuecomment-869537398)
* [Aviary Twitter Client](https://apps.apple.com/us/app/aviary/id1522043420) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Canary Mail](https://canarymail.io/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/482429/5114)
* [Cisco Webex Meetings](https://www.webex.com/downloads.html) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/530#issue-790322821)
* [Discord](https://discord.com/download) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/907#issue-1172957710)
* [Facebook Messenger Desktop](https://www.messenger.com/desktop) - ✅ Yes, Full Native Apple Silicon Support as of 158.0.0.25.216 (391336574) - [Verification](https://github.com/ThatGuySam/doesitarm/issues/520)
* [Guilded](https://www.guilded.gg/) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/781#issue-1014658498)
* [Keybase](https://keybase.io/) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/143#issuecomment-1015904302)
* [Krisp](https://krisp.ai/) - ✅ Yes, Native Apple Silicon Support as of v1.28.7 - [Release Notes](https://whatsnew.krisp.ai/announcements/mac-1-28-7-native-support-on-m1-chip)
* [LINE for macOS](https://apps.apple.com/app/line/id539883307) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/690#issue-913425598)
* [Mattermost](https://mattermost.com/download/) - ✅ Yes, Native Apple Silicon Support as of v4.7.0 - [Release Notes](https://docs.mattermost.com/install/desktop-app-changelog.html)
* [MeetInOne](https://meetinone.com/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/meet-in-one)
* [Microsoft Teams](https://www.microsoft.com/en-us/microsoft-365/microsoft-teams/group-chat-software) - ✅ Yes, Native Apple Silicon Support - [Source](https://github.com/ThatGuySam/doesitarm/issues/932#issuecomment-1263220103)
* [NetEase POPO](https://archive.fo/3hwrq) - ✅ Yes, Native Apple Silicon Support as of v3.25.8 - [Release Notes](https://archive.fo/0jMF4)
* [Postbox](https://www.postbox-inc.com) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/35)
* [QQ](https://im.qq.com/macqq/) - ✅ Yes, Full Native Apple Silicon Support as of v6.7.0.20110 - [Release Notes](https://im.qq.com/macqq/support.html)
* [QQ 体验版(MacCatalyst)](https://im.qq.com/macqq/) - ✳️ Runs via Rosetta 2 
* [Signal](https://signal.org/) - ✅ Yes, Native Apple Silicon Support as of v5.27.0 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/853) [Release Notes](https://github.com/signalapp/Signal-Desktop/releases)
* [Skype](https://www.skype.com/en/get-skype/) - ✳️ Yes, works via Rosetta 2 - [Video](https://doesitarm.com/tv/the-new-m1-macbook-running-microsoft-office-business-apps-teams-skype-excel-cpu-and-ram-usage-i-ibseaue3se8/)
* [Skype for Business](https://www.microsoft.com/en-us/microsoft-365/skype-for-business/download-app) - ✳️ Yes, works via Rosetta 2 - [Video](https://doesitarm.com/tv/the-new-m1-macbook-running-microsoft-office-business-apps-teams-skype-excel-cpu-and-ram-usage-i-ibseaue3se8/)
* [Slack](https://slack.com/) - ✅ Yes, Full Native Apple Silicon Support as of 4.13.0 - [Release Notes](https://slack.com/intl/en-au/release-notes/mac)
* [Spark Mail](https://apps.apple.com/app/apple-store/id1176895641) - ✅ Yes, Full Native Apple Silicon Support as of 2.10.0 - [Official Tweet](https://twitter.com/SparkMailApp/status/1410624085072175110)
* [Telegram](https://macos.telegram.org/) - ✅ Yes, Full Native Apple Silicon Support as of 7.2.4 - [GitHub issue](https://github.com/ThatGuySam/doesitarm/issues/52) [Changelog](https://macos.telegram.org/#v7-2-4-2020-11-29)
* [Twitter](https://apps.apple.com/app/twitter/id1482454543?mt=12) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/580#issue-816729668)
* [Unite for Mac](https://www.bzgapps.com/unite) - ✳️ Runs via Rosetta with native support currently in development - [Verification](https://github.com/ThatGuySam/doesitarm/issues/606#issuecomment-803009445) [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/unite)
* [Uplet](https://getuplet.com/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/uplet)
* [WeChat](https://mac.weixin.qq.com/?t=mac) - ✅ Yes, Full Native Apple Silicon Support as of v3.2.0 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/759)
* [Welly BBS](https://wellybbs.com/) - ✅ Yes, Full Native Apple Silicon Support as of Version 2020.9 - [App Store](https://apps.apple.com/us/app/id1521402269)
* [WhatsApp](https://www.whatsapp.com/download/) - ✳️ Yes, works via Rosetta 2 as of v2.2049.10 with native support currently in beta - [Verification](https://github.com/ThatGuySam/doesitarm/issues/956) [Native Apple Silicon TestFlight Download](https://faq.whatsapp.com/545358030455627/?locale=en_GB)
* [Zoom](https://zoom.us/download) - ✅ Yes, full native Apple Silicon support as of 5.4.7 (59780.1220) - [Discussion](https://github.com/ThatGuySam/doesitarm/issues/134)



#### VPNs, Security, and Privacy

* [1Password](https://1password.com/) - ✅ Yes, full native Apple Silicon support as of 7.8 - [Release Notes](https://app-updates.agilebits.com/product_history/OPM7#v70800000)
* [AdGuard](https://adguard.com/en/welcome.html) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/788) [View on Setapp](https://setapp.sjv.io/c/2708043/850840/5114)
* [AdLock](https://adlock.com/adlock-for-macos/) - ✅ Yes, Native Apple Silicon Support - [Official Article](https://adlock.com/blog/adlock-for-m1-chip/) [Verification](https://github.com/ThatGuySam/doesitarm/issues/680#issue-908198983)
* [Angry IP Scanner](https://angryip.org/download/#mac) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/809#issue-1045931393)
* [BaiduNetdisk](https://pan.baidu.com/download#pan) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/957#issue-1307524119)
* [BIG-IP Edge Client](https://techdocs.f5.com/kb/en-us/bigip-edge-apps.html) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/783#issue-1015073230)
* [Bitdefender Virus Scanner](https://www.bitdefender.com/solutions/virus-scanner-for-mac.html) - ✅ Yes, Native Apple Silicon Support as of v3.16
* [Bitwarden](https://bitwarden.com/) - ✅ Yes, Native Apple Silicon Support as of v1.27.1
* [Cisco AnyConnect Secure Mobility Client](https://www.cisco.com/c/en/us/products/security/anyconnect-secure-mobility-client/index.html) - ✅ Yes, Native Apple Silicon Support as of v4.10 - [Release Notes](https://www.cisco.com/c/en/us/td/docs/security/vpn_client/anyconnect/anyconnect410/release/notes/release-notes-anyconnect-4-10.html#ID-1454-00000002)
* [Cisco Packet Tracer](https://www.netacad.com/courses/packet-tracer) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/658#issue-898710471)
* [ClashX](https://github.com/yichengchen/clashX#install) - ✅ Yes, Full Native Apple Silicon Support as of v1.31.1.1 - [Release Notes](https://github.com/yichengchen/clashX/releases/tag/1.31.1)
* [ClearVPN](https://macpaw.com/clearvpn) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/clearvpn)
* [Cryptomator](https://cryptomator.org/) - 🚫 No, crashes under Rosetta 2 only recommended on Intel-based Macs - [Crashing Issue](https://github.com/cryptomator/cryptomator/issues/1419)
* [Dashlane](https://www.dashlane.com/) - ✅ Yes, Native Apple Silicon Support via Browser - [Verification](https://github.com/ThatGuySam/doesitarm/issues/676#issue-899250850)
* [Elpass](https://elpass.app/) - ✅ Yes, full native Apple Silicon Support as of v1.1.10 - [Issue](https://github.com/ThatGuySam/doesitarm/issues/176)
* [Enpass](https://www.enpass.io/) - ✳️ Runs via Rosetta 2 - [Forum Discussion](https://discussion.enpass.io/index.php?/topic/24222-enpass-on-m1-mac-arm-silicon/&tab=comments#comment-56371)
* [GPG Suite](https://gpgtools.org/) - ✅ Yes, Full Native Apple Silicon Support as of 2020.2 - [Release notes](https://gpgtools.org/releases/gpgsuite/2020.2/release-notes.html?ni=1)
* [HiddenApp](https://hiddenapp.com/en/) - ✳️ Yes, works via Rosetta 2 translation - [Release Notes](https://help.hiddenapp.com/collection/17-update-release-notes) [Report](https://github.com/ThatGuySam/doesitarm/issues/829#issue-1067135183)
* [Hoplite Key Manager](https://hoplitekeymanager.com/index.php?page=download) - ✅ Yes, full native Apple Silicon Support as of v1.3 - [Release Notes](https://hoplitekeymanager.com/download/archives/desktop-application/#platforms_compatibility) [Verification](https://github.com/ThatGuySam/doesitarm/issues/904)
* [IVPN](https://www.ivpn.net/apps-macos/) - ✅ Yes, Native Apple Silicon Support as of v3.4.0 - [Release Notes](https://github.com/ivpn/desktop-app/blob/master/CHANGELOG.md)
* [Jamf Protect](https://www.jamf.com/products/jamf-protect/) - ✅ Yes, Full Native Apple Silicon Support as of v1.2.0.217 - [Release Notes](https://docs.jamf.com/jamf-protect/administrator-guide/Release_History.html)
* [KeePassXC](https://keepassxc.org/download/#mac) - ✅ Yes, Full Native Apple Silicon Support as of v2.6.4 - [Release Notes](https://keepassxc.org/blog/2021-01-31-2.6.4-released/)
* [KeeWeb](https://keeweb.info/) - ✅ Yes, Full Native Apple Silicon Support - [Official Tweet](https://twitter.com/kee_web/status/1334885117584609295)
* [LastPass](https://www.lastpass.com/) - ✳️ Yes, works via Rosetta 2, but the Safari extension has issues - [Verification](https://github.com/ThatGuySam/doesitarm/issues/233#issuecomment-731506984) [Release Notes](https://lastpass.com/upgrade.php?fromwebsite=1&releasenotes=1) [Safari Issue](https://community.logmein.com/t5/Support-Discussions/macOS-Big-Sur-Safari-14-0-1-Official-Support/m-p/256549)
* [Little Snitch](https://www.obdev.at/products/littlesnitch/index.html) - ✅ Yes, Full Native Apple Silicon Support from 5.0 - [Release notes](https://www.obdev.at/products/littlesnitch/releasenotes.html)
* [Mullvad VPN](https://mullvad.net/en/download/macos/) - ✅ Yes, Native Apple Silicon Support as of v2021.4 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/727#issue-951319577) [Release Notes](https://github.com/mullvad/mullvadvpn-app/releases/tag/2021.4-beta1) 
* [NordVPN](https://nordvpn.com/download/nordvpn-site/) - ✅ Yes, Native Apple Silicon Support as of v6.6.1 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/736) [Release Notes](https://apps.apple.com/us/app/nordvpn-ike-unlimited-vpn/id1116599239)
* [OpenVPN Connect](https://openvpn.net/client/) - ✅ Yes, Native Apple Silicon Support as of v3.4.0 - [Release Note](https://openvpn.net/vpn-server-resources/openvpn-connect-for-macos-change-log/#release-notes-for-3-4-0-4506) [Verification](https://github.com/ThatGuySam/doesitarm/issues/984#issuecomment-1620749986)
* [Pareto Security](https://paretosecurity.com/) - ✅ Yes, Full Native Apple Silicon Support. - [Verification](https://github.com/ThatGuySam/doesitarm/issues/884#issue-1139052501)
* [ProtonVPN](https://protonvpn.com/download-macos) -  ✅ Yes, Native Apple Silicon Support as of v2.0.3 - [Report #1](https://forums.macrumors.com/threads/vpn-software.2270086/post-29435392) [Report #2](https://forums.macrumors.com/threads/vpn-software.2270086/post-29294735)
* [Secrets for Mac](https://apps.apple.com/app/secrets/id973049011?mt=12) - ✅ Yes, Full Native Apple Silicon Support as of v3.4.0 - [Official Post](https://outercorner.com/blog/2020/11/password-autofill-now-on-macos-big-sur/) [View on Setapp](https://setapp.sjv.io/c/2708043/442278/5114)
* [Shimo](https://www.shimovpn.com/en/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/shimo)
* [Sophos Home](https://my.sophos.com/download) - ✅ Yes, Full Native Apple Silicon Support as of v10.3.1 - [Release Notes](https://support.home.sophos.com/hc/en-us/articles/4423083274644) [Verification](https://github.com/ThatGuySam/doesitarm/issues/936#issue-1227524911)
* [Step Two for Mac](https://steptwo.app/) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/619#issue-849584485) [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/766955/5114)
* [Surfshark](https://surfshark.com/download/macos) - ✅ Yes, Native Apple Silicon Support as of v3.4.0 - [Press Release](https://surfshark.com/blog/m1-chip-compatibility)
* [Tor Browser](https://www.torproject.org/download/) - ✳️ Yes, works via Rosetta 2 translation - [Release Notes](https://blog.torproject.org/new-release-tor-browser-1008) [Source](https://github.com/ThatGuySam/doesitarm/issues/436) [Issue tracker for tab crashes](https://gitlab.torproject.org/tpo/applications/tor-browser/-/issues/40262)
* [Tunnelblick](https://tunnelblick.net/) - ✅ Yes, Native Apple Silicon Support reported as of v3.8.6 - [Official Website](https://tunnelblick.net/cAppleSilicon.html)
* [VeraCrypt](https://www.veracrypt.fr/en/Downloads.html) - ✅ Yes, Native Apple Silicon Support as of v1.25.4 - [Release Notes](https://github.com/veracrypt/VeraCrypt/releases/tag/VeraCrypt_1.25.4)
* [Vivaldi](https://vivaldi.com/download/) - ✅ Yes, native support as of v3.7 - [Source](https://vivaldi.com/blog/vivaldi-fires-up-performance-2/)
* [VPN Tracker 365](https://www.vpntracker.com) - ✅ Yes, fully native IPsec, L2TP, OpenVPN, SonicWALL SSL VPN support as of v 21.0 - [Official page](https://www.vpntracker.com/us/VPN-Client-for-macOS-Big-Sur.html)
* [Windscribe](https://windscribe.com/download) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/442#issuecomment-748251300)




#### System Tools

* [Access Menu for macOS](https://titanium-software.fr/en/accessmenu.html) - ✅ Yes, Full Native Apple Silicon Support - [Release Notes](https://titanium-software.fr/en/release_accessmenu.html)
* [AlDente](https://github.com/davidwernhart/AlDente/releases) - ✅ Yes, Full Native Apple Silicon Support as of v2.0 - [Release Notes](https://github.com/davidwernhart/AlDente/releases)
* [AltTab](https://alt-tab-macos.netlify.app/) - ✅ Yes, Native Apple Silicon Support as of v6.28.0 - [Release Notes](https://alt-tab-macos.netlify.app/changelog)
* [AmorphousDiskMark](https://apps.apple.com/us/app/amorphousdiskmark/id1168254295) - ✅ Yes, full native Apple Silicon support as of v3.1
* [Amphetamine](https://apps.apple.com/app/amphetamine/id937984704) - ✅ Yes, full native Apple Silicon support from 5.1 - [GitHub issue](https://github.com/ThatGuySam/doesitarm/issues/295)
* [Android File Transfer](https://www.android.com/filetransfer/) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/707#issue-929848818)
* [AnyTrans](https://www.imobie.com/anytrans/download.htm) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/anytrans)
* [AppCleaner](https://freemacsoft.net/appcleaner/) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/559#issue-803995485)
* [Archiver App](https://archiverapp.com/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/archiver)
* [AVTouchBar](https://www.avtouchbar.com/) - ✅ Yes, Full Native Apple Silicon Support as of v3.0.6 - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Backblaze](https://www.backblaze.com/) - ✅ Yes, Full Native Apple Silicon Support as of v7.0.2.494 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/409#issuecomment-821298155)
* [balenaEtcher](https://github.com/balena-io/etcher/releases) - ✳️ Yes, works via Rosetta 2 translation - [Native Version Pulled](https://github.com/balena-io/etcher/issues/3593) [Verification](https://github.com/balena-io/etcher/issues/3593#issuecomment-978150772)
* [Barrier KVM](https://github.com/debauchee/barrier/releases) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/261#issuecomment-869423175)
* [Bartender](https://www.macbartender.com/) - ✅ Yes, fully supported as of v4.0.20 - [Blog](https://www.macbartender.com/b4blog/Apple-Silicon-Support/) [View on Setapp](https://setapp.sjv.io/c/2708043/443665/5114)
* [Beamer](https://beamer-app.com/) - ✳️ Yes, works via Rosetta 2 Translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/815231/5114)
* [BetterZip](https://macitbetter.com/) - ✅ Yes, Native Apple Silicon Support as of v5.1 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/725#issue-950859858) [Release Notes](https://macitbetter.com/blog/BetterZip-5.1/) [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/354709/5114)
* [BlurScreen App](https://www.blurscreen.app) - ✅ Yes, Full Native Apple Silicon Support 
* [Boom 3D](https://www.globaldelight.com/boom/) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/679#issue-906756300)
* [Burn for Mac](https://burn-osx.sourceforge.io/Pages/English/home.html) - ✅ Yes, Full Native Apple Silicon Support as of v3.0.0 - [Release Notes](https://burn-osx.sourceforge.io/Pages/English/news.html)
* [Caffeinated](https://caffeinated.app/) - ✅ Yes, Native Apple Silicon Support as of v1.20 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/739#issue-961150860)
* [CalHash](https://titanium-software.fr/en/calhash.html) - ✅ Yes, Full Native Apple Silicon Support - [Release Notes](https://titanium-software.fr/en/release_calhash.html)
* [Camo Studio](https://reincubate.com/camo/) - ✅ Yes, Full Native Apple Silicon Support - [Release Notes](https://reincubate.com/support/camo/release-notes/#1.1.3.122)
* [Chia Blockchain](https://www.chia.net/) - ✳️ Yes, works via Rosetta 2 translation - [Issue](https://github.com/Chia-Network/chia-blockchain/issues/2313) [Changelog](https://github.com/Chia-Network/chia-blockchain/blob/main/CHANGELOG.md)
* [CleanMyMac](https://cleanmymac.com/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344326/5114)
* [CleanShot X](https://cleanshot.com) - ✅ Yes, fully supported as of v3.4.4 - [Changelog](https://cleanshot.com/changelog/) [View on Setapp](https://setapp.sjv.io/c/2708043/569389/5114)
* [coconutBattery](https://www.coconut-flavour.com/coconutbattery/) - ✅ Yes, full native support as of v3.9.2
* [DaisyDisk](https://daisydiskapp.com/) - ✅ Yes, Native Apple Silicon Support as of v4.12.1 - [Release Notes](https://daisydiskapp.com/downloads/appcastReleaseNotes.php?appEdition=Standard&osVersion=10.13)
* [Deeper for macOS](https://titanium-software.fr/en/deeper.html) - ✅ Yes, Full Native Apple Silicon Support - [Release Notes](https://titanium-software.fr/en/release_deeper.html)
* [Default Folder X](https://www.stclairsoft.com/DefaultFolderX/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/840195/5114)
* [Disk Drill](https://www.cleverfiles.com/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344358/5114)
* [DisplayBuddy](https://displaybuddy.app) - ✅ Yes, Full Native Apple Silicon Support as of v1.12 - [Release Notes](https://displaybuddy.app/public/DisplayBuddy_1.12.html)
* [DisplayLink Manager](https://www.displaylink.com/downloads/macos) - ✅ Yes, Full Native Apple Silicon Support as of v1.3 - [Release Notes](https://gist.github.com/ThatGuySam/30e5f1d2ee4edacab6323acaa55791fc)
* [Displays for Mac](https://www.jibapps.com/apps/displays/) - ✅ Yes, Full Native Apple Silicon Support as of v1.9.7 - [Source](https://twitter.com/jibapps/status/1338478515453386755)
* [EasyFind](https://www.devontechnologies.com/apps/freeware) - ✅ Yes, Native Apple Silicon Support as of v5.0.1
* [Find Any File](https://apps.tempel.org/FindAnyFile/) - ✅ Yes, Native Apple Silicon Support as of v2.3
* [Gemini 2](https://macpaw.com/gemini) - ✳️ Yes, works via Rosetta 2 - [Official Tweet](https://twitter.com/MacPaw/status/1361651643591364613) [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344369/5114)
* [Gifox](https://gifox.io/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344376/5114)
* [GrandPerspective](https://apps.apple.com/app/grandperspective/id1111570163?mt=12) - ✅ Yes, Full Native Apple Silicon Support as of 2.5.3 - [Release Notes](https://web.archive.org/web/http://grandperspectiv.sourceforge.net/)
* [HazeOver](https://hazeover.com/) - ✅ Yes, Full Native Apple Silicon Support as of 1.8.8 - [Official News](https://hazeover.com/news.html) [View on Setapp](https://setapp.sjv.io/c/2708043/344378/5114)
* [HoudahSpot](https://www.houdah.com/houdahSpot/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/houdahspot)
* [HyperSwitch](https://bahoom.com/hyperswitch) - ✳️ Yes, works via Rosetta 2 Translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/603#issue-835195886)
* [iBoysoft NTFS for Mac](https://iboysoft.com/ntfs-for-mac/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/iboysoft-ntfs)
* [Iriun Webcam](https://iriun.com/) - ✳️ Yes, works via Rosetta 2 Translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/607#issue-835423511)
* [iStat Menus](https://bjango.com/mac/istatmenus/) - ✅ Yes, Full Native Apple Silicon Support as of v6.51 - [Official Twitter](https://twitter.com/bjango/status/1328863648270356482) [View on Setapp](https://setapp.sjv.io/c/2708043/344394/5114)
* [Jamf Self Service](https://docs.jamf.com/10.26.0/jamf-pro/administrator-guide/About_Jamf_Self_Service_for_macOS.html) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Jumpcut](https://snark.github.io/jumpcut) - ✅ Yes, Native Apple Silicon Support as of v0.74 - [GitHub Issue](https://github.com/snark/jumpcut/issues/59#issuecomment-854313788)
* [Karabiner-Elements](https://karabiner-elements.pqrs.org/) - ✅ Yes, Full Native Apple Silicon Support as of v13.0.0 - [Release Notes](https://karabiner-elements.pqrs.org/docs/releasenotes/#karabiner-elements-1300)
* [Keka](https://mas.keka.io/) - ✅ Yes, Full Native Apple Silicon Support as of v1.2.2 - [App Store Link](https://mas.keka.io/)
* [LaCie RAID Manager](https://www.lacie.com/support/software/lacie-raid-manager/) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/715#issue-934314512)
* [Logitech G HUB](https://www.logitechg.com/en-us/innovation/g-hub.html) - ✳️ Yes, works via Rosetta 2 Translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/683#issue-912290618)
* [Logitech Options](https://www.logitech.com/en-us/product/options) - ✳️ Yes, works via Rosetta 2. Some users report issues with the Flow feature. - [MacRumors Discussion](https://forums.macrumors.com/threads/does-logitech-options-works.2270516)
* [Lunar for Mac](https://lunar.fyi/) - ✅ Yes, Native Apple Silicon Support as of v4.0.0 - [Support Notes](https://lunar.fyi/#m1)
* [Lungo](https://sindresorhus.com/lungo) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/400141/5114)
* [Maccy](https://maccy.app/) - ✅ Yes, Full Native Apple Silicon Support - [Release Notes](https://github.com/p0deje/Maccy/releases/tag/0.19.0) [Mac App Store](https://apps.apple.com/us/app/maccy/id1527619437)
* [macFUSE](https://osxfuse.github.io/) - ✅ Yes, Native Apple Silicon Support as of v4.12 - [Release Notes](https://github.com/osxfuse/osxfuse/releases/tag/macfuse-4.1.2)
* [MacPilot](https://www.koingosw.com/products/macpilot/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/550030/5114)
* [MacUpdater](https://www.corecode.io/macupdater/) - ✅ Yes, Native Apple Silicon Support as of v2.0.0 - [Release Notes](https://www.corecode.io/macupdater/history2.html)
* [MacZip](https://ezip.awehunt.com/) - ✅ Yes, Full Native Apple Silicon Support as of v2.0 - [Release Notes](https://ezip.awehunt.com/)
* [Magic Window Air](https://apps.apple.com/us/app/magic-window-air/id1481258399) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/933402/5114) 
* [Magnet for Mac](https://apps.apple.com/app/id441258766?mt=12) - ✅ Yes, Full Native Apple Silicon Support as of 2.5.0 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/652#issue-894999119)
* [Maintenance for macOS](https://titanium-software.fr/en/maintenance.html) - ✅ Yes, Full Native Apple Silicon Support - [Release Notes](https://titanium-software.fr/en/release_maintenance.html)
* [Microsoft OneDrive](https://www.microsoft.com/en-us/microsoft-365/onedrive/online-cloud-storage) - ✅ Yes, Full Native Apple Silicon Support as of v22.022.0130.0001 - [Official Article](https://techcommunity.microsoft.com/t5/microsoft-onedrive-blog/microsoft-works-to-ensure-a-great-onedrive-experience-on-apple/ba-p/2400803?fbclid=IwAR16Kpp8XirFHM4zzLw7cqKvjCwrmdgTMbF_wLpyBBFGult96v3H5G0_0ws) [Verification](https://github.com/ThatGuySam/doesitarm/issues/699#issue-920044889)
* [Moom](https://manytricks.com/moom/) - ✅ Yes, Full Native Apple Silicon Support as of v3.2.20 - [Official Tweet](https://twitter.com/manytricks/status/1333456606449774595)
* [Mosaic for Mac](https://www.lightpillar.com/mosaic.html) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [Release Notes](https://lightpillar.com/appdata/mosaic/features/version-history.html) [View on Setapp](https://setapp.sjv.io/mosaic)
* [NoNotify](https://nonotify.com/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/nonotify)
* [One Switch](https://fireball.studio/oneswitch/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/635280/5114)
* [OnyX for macOS](https://titanium-software.fr/en/onyx.html) - ✅ Yes, Full Native Apple Silicon Support reported as of v3.9.2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/622#issue-849839262) [Release Notes](https://titanium-software.fr/en/release_onyx.html)
* [Pacifist](https://www.charlessoft.com/) - ✳️ Yes, works via Rosetta 2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/573#issue-812045761)
* [Paragon NTFS](https://www.paragon-software.com/home/ntfs-mac/) - ✅ Yes, Full Native Apple Silicon Support
* [Parallels Toolbox](https://prf.hn/l/7QA4VqE) - ✅ Yes, Full Native Apple Silicon Support as of v4.1.1 - [Release Notes](https://prf.hn/l/7Av4eqn)
* [Paste for Mac](https://pasteapp.io/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/paste)
* [Path Finder](https://cocoatech.com/#/) - ✅ Yes, Full Native Apple Silicon Support - [Release Notes](https://cocoatech.com/#/post/introducing-path-finder-10) [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/path-finder)
* [PliimPRO](https://pliim.app/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/860831/5114)
* [Razer macOS](https://github.com/1kc/razer-macos/releases) - ✳️ Yes, runs via Rosetta 2
* [Razer Synapse](https://www.razer.com/synapse-2) - 🚫 No, not yet supported only works on Intel-based Macs - [Working Alternative](https://github.com/1kc/razer-macos)
* [Rectangle for Mac](https://rectangleapp.com/) - ✅ Yes, Full Native Apple Silicon Support - [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [restic](https://restic.net/) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/492#issuecomment-754580871)
* [Rocket for Mac](https://matthewpalmer.net/rocket/) - ✅ Yes, Full Native Apple Silicon Support - [Verifcation](https://github.com/ThatGuySam/doesitarm/issues/605#issue-835338120)
* [Samsung Portable SSD](https://www.samsung.com/semiconductor/minisite/ssd/download/portable/) - ✅ Yes, Native Apple Silicon Support as of v1.7.3.0 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/660#issue-898754377)
* [SheepShaver](https://www.emaculation.com/forum/viewtopic.php?f=20&t=7360) - ✅ Yes, Full Native Apple Silicon Support - [Release Notes](https://www.emaculation.com/sheepshaver/build-history.txt) [🧪 Apple Silicon App Tested](https://doesitarm.com/apple-silicon-app-test/)
* [Silenz](https://silenzapp.com/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/653749/5114)
* [Sleep Warden](https://apps.apple.com/us/app/sleep-warden/id1571743175) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/697#issue-918718225)
* [sndcpy](https://github.com/rom1v/sndcpy) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/645#issuecomment-839911450)
* [Soduto](https://soduto.com/downloads/) - ✳️ Yes, works via Rosetta 2 translation - [Verification](https://github.com/ThatGuySam/doesitarm/issues/879#issue-1127062742)
* [Sound Control](https://staticz.com/soundcontrol/) - ✅ Yes, Native Apple Silicon Support as of v2.6 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/361#issuecomment-869339643)
* [Speedtest by Ookla](https://apps.apple.com/ae/app/speedtest-by-ookla/id1153157709?mt=12) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/666#issue-899017910)
* [start for Mac](https://apps.apple.com/us/app/start/id1329701389?mt=12) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/752736/5114)
* [Swish for macOS](https://highlyopinionated.co/swish/) - ✅ Yes, Full Native Apple Silicon Support as of v1.7.1 - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/swish)
* [System Watcher](https://apps.apple.com/us/app/system-watcher/id1269106895?mt=12) - ✅ Yes, Full Native Apple Silicon Support as of v4.3.2 - [Verification](https://github.com/ThatGuySam/doesitarm/issues/793#issue-1030009696) 
* [TG Pro](https://www.tunabellysoftware.com/tgpro/) - ✅ Yes, Full Native Apple Silicon Support as of v2.53 - [Release Notes](https://www.tunabellysoftware.com/tgpro/releasenotes/)
* [Timeless for Mac](https://www.dangercove.com/timeless/) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/timeless)
* [TinkerTool](https://www.bresink.com/osx/TinkerTool.html) - ✅ Yes, Native Apple Silicon Support - [Release Notes](https://www.bresink.com/osx/0TinkerTool/history.html)
* [ToothFairy](https://c-command.com/toothfairy/) - ✅ Yes, Full Native Apple Silicon Support as of v2.7.1 - [Release Notes](https://c-command.com/blog/2021/01/14/toothfairy-2-7-1/) [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/560495/5114)
* [TouchSwitcher](https://hazeover.com/touchswitcher.html) - ✅ Yes, Full Native Apple Silicon Support as of 1.4 - [Official News](https://hazeover.com/news.html)
* [Transloader](https://eternalstorms.at/transloader/) - ✅ Yes, Full Native Apple Silicon Support as of v2.1.1 - [Blog Post](https://blog.eternalstorms.at/2020/11/09/app-update-galore/)
* [Trickster](https://www.apparentsoft.com/trickster) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/668337/5114)
* [uBar](https://brawersoftware.com/products/ubar) - ✳️ Yes, works via Rosetta 2 translation - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/489433/5114)
* [unpkg](https://www.timdoug.com/unpkg/) - ✅ Yes, Native Apple Silicon Support as of v4.7
* [VueScan](https://www.hamrick.com/) - ✅ Yes, Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/717#issue-935351118) [Official Article](https://www.hamrick.com/blog/vuescan-on-apple-silicon.html)
* [Wifi Explorer](https://www.intuitibits.com/products/wifi-explorer/) - ✅ Yes, Full Native Apple Silicon Support - [Article](https://setapp.sjv.io/apple-silicon-supported-apps) [View on Setapp](https://setapp.sjv.io/c/2708043/344478/5114)
* [Wineskin Winery](https://github.com/Gcenx/WineskinServer/releases) - ✳️ Yes, works via Rosetta 2 translation - [Support Notes](https://github.com/Gcenx/WineskinServer/#apple-silicon-support-rosetta2) [Release Notes](https://github.com/Gcenx/WineskinServer/releases/tag/V1.8.4.2)
* [Witch for Mac](https://manytricks.com/witch/) - ✅ Yes, Full Native Apple Silicon Support - [Verification](https://github.com/ThatGuySam/doesitarm/issues/602#issue-834336906) [Release Notes](https://manytricks.com/witch/releasenotes/)




<!--- end-of-list -->



## More Apple Silicon and ARM Lists
* [Is Apple silicon ready?](https://isapplesiliconready.com/) - Great list with detailed app status
* [Apple Silicon Games](https://applesilicongames.com/) - List of reported Games support including performance info. 
* [Apple Gaming Wiki](https://www.applegamingwiki.com/wiki/Home) - Aggregates reports on Apple Silicon compatibility under different environments
* [State of Mac](https://www.stateofmac.com/) - Information on the performance of games on Mac and the best way to run said games
* [iMobie M1 App Checker List](https://www.imobie.com/m1-app-checker/) - App Scan Results from the iMobie M1 App Checker
* [SweetWater Compatibility Guide](https://www.sweetwater.com/sweetcare/articles/macos-11-big-sur-compatibility-guide/) - Big Sur and Apple Silicon reports for producstion and live performance software
* [Toolfarm Apple Silicon Compatibility](https://www.toolfarm.com/news/apple-silicon-compatibility/) - Product Compatibility for Apple M1 Silicon Macs
* [Toolfarm Big Sur Compatibility](https://www.toolfarm.com/news/apple-silicon-compatibility/) - Product Compatibility for macOS Big Sur
* [Ported2M1](https://ported2m1.com/) - Beautiful list with app support discussion
* [MacRumors List](https://forums.macrumors.com/threads/universal-and-native-apple-silicon-apps.2267176/) - List of Universal and Native Apple Silicon Apps
* [RoaringApps](https://roaringapps.com/collections/list-of-apple-silicon-native-apps) - List of apps ready for Apple Silicon M1 chip Macs
* [Laravel Supported Apps](https://laravelm1.tighten.co/) - List of Laravel-related apps and their status on Apple SIlicon
* [Big List](https://airtable.com/shribWFi8yrG9B1nh/tbl6aypsMfuofEaJi) - An Airtable List of over 400 apps and their support on Big Sur and Apple Silicon
* [Ivan Enderlin Twitter Thread](https://twitter.com/mnt_io/status/1327166454765150208?s=21) - A twitter thread with open status contributions
* [Does It ARM Twitter Thread](https://twitter.com/DoesItARM/status/1330027384041508865) - Does It ARM's own twitter thread for reporting and suggecting apps
* [Official Adobe M1 List](https://helpx.adobe.com/download-install/kb/apple-silicon-m1-chip.html) - Adobe's official list of app support for M1
* [Official Apple List](https://apps.apple.com/us/story/id1540024103) - Apple is a small tech company in Cupertino, CA
* [Mac Source Ports](https://macsourceports.com/) - Classic PC Games ported to run ✅ Natively on Apple Silicon
* [Is Windows on ARM Ready](https://iswindowsonarmready.netlify.app/) - List of _Windows_ apps natively supoorted by Windows on ARM


## Apple Silicon Testing Tools
* [Uni Detetector](https://apps.apple.com/app/id1531249804) - Check all your Mac's apps and display Binary Architecture and more. 
* [Silicon by DigiDNA](https://github.com/DigiDNA/Silicon) - Identify Intel-Only Apps on your Mac with ease. 
* [ascheck](https://github.com/harryzcy/ascheck) - A command-line app that bulk-checks your apps for the Apple Silicon support. 
* [Silicon Info](https://github.com/billycastelli/Silicon-Info) - Mac menu bar tool to view the architecture of the running application. 
* [Does it arm? 🚀](https://github.com/mik3sw/doesitarm) - (no relation) Check support for apps on your Mac with arm processor M1. 
* [iMobie M1 App Checker List](https://www.imobie.com/m1-app-checker/) - Scan apps accross your system. 
* [Does It ARM App Test](https://doesitarm.com/apple-silicon-app-test/) - Test any app for Native Apple Silicon support or check for reported native versions all in the browser. 


## Youtube Apple Silicon Playlists
* [Awais Mirza Video Tests](https://www.youtube.com/playlist?list=PLz5rnvLVJX5XF8cXAOQuarPIeP8Xr7b1_)
* [Andrew Tsai Game Benchmarks](https://www.youtube.com/playlist?list=PLFbqxkNlqrHNK0i4WN99Jc8g-qSbKoZEy)
* [Created Labs M1 MacBook](https://www.youtube.com/playlist?list=PLcbQnQIwz6qSt-qsD3jCJaEw9fK8yXarA)
* [Tonyisgaming M1 Benchmarks](https://www.youtube.com/playlist?list=PLgz-h_Uy9AwOctqRcm6hEYEqTO9yIawoO)
* [DevChannel M1 Videos](https://www.youtube.com/playlist?list=PLEi3_qsqIyclc-3NqbEYlIvXEdcLXy1qX)
* [Ben G Kaiser - M1 for Creative Professionals](https://www.youtube.com/playlist?list=PL_9qmWdi19yCOCzAdTfFxpZtXonyfWTYJ)
* [Constant Geekery Apple Silicon](https://www.youtube.com/playlist?list=PLQncOO7KICBIH-1Jv3fhOOU9b3-j6XoED)




## License
Unless otherwise noted, this list available under the [Creative Commons Attribution 4.0 International License](https://creativecommons.org/licenses/by/4.0/), and the code is available under the [Apache-2.0](https://opensource.org/licenses/Apache-2.0). 


## Join our amazing community as a contributor, and help us accelerate
<br>
<a href="https://github.com/ThatGuySam/doesitarm/graphs/contributors">
  <img class="dark-light" src="https://contrib.rocks/image?repo=ThatGuySam/doesitarm&anon=0&columns=21&max=100&r=true" />
</a>
