import 'package:flutter/material.dart';

class ChatItem extends StatelessWidget {
  final String text;
  final bool isMe;

  const ChatItem({super.key, required this.text, required this.isMe});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.symmetric(
        vertical: 10,horizontal: 12,
      ),
      child: Row(
        mainAxisAlignment: isMe ? MainAxisAlignment.end : MainAxisAlignment.start,
        children: [
          if (!isMe) ProfileContainer(isMe: isMe),
          if (!isMe) const SizedBox(width: 15,),
          Container(
            padding: EdgeInsets.all(15),
            constraints: BoxConstraints(maxWidth: MediaQuery.of(context).size.width * 0.60),
            decoration: BoxDecoration(
                color: isMe
                    ? Theme.of(context).colorScheme.secondary
                    : Colors.grey.shade800,
                borderRadius: BorderRadius.only(  
                  topLeft: Radius.circular(15),
                  topRight: Radius.circular(15),
                  bottomLeft: Radius.circular(isMe ? 15 : 0),
                  bottomRight: Radius.circular(isMe ? 0 : 15),
                )),
                child: Text(text,
                style: TextStyle(
                  color: Theme.of(context).colorScheme.onSecondary,
                  fontSize: 15,
                ),),
          ),
          if (isMe) const SizedBox(width: 15,),
          if (isMe) ProfileContainer(isMe: isMe),
    
        ],
      ),
    );
  }
}

class ProfileContainer extends StatelessWidget {
  const ProfileContainer({
    super.key,
    required this.isMe,
  });

  final bool isMe;

  @override
  Widget build(BuildContext context) {
    return Container(
      width: 40,
      height: 40,
      decoration: BoxDecoration(
          color: isMe
              ? Theme.of(context).colorScheme.secondary
              : Colors.grey.shade800,
          borderRadius: BorderRadius.only(
            topLeft: Radius.circular(10),
            topRight: Radius.circular(10),
            bottomLeft: Radius.circular(isMe ? 0 : 15),
            bottomRight: Radius.circular(isMe ? 15 : 0),
          )), // person_pin
      child: Icon(
        isMe ? Icons.person : Icons.psychology_rounded,
        color: Theme.of(context).colorScheme.onSecondary,
      ),
    );
  }
}
