training_data = """

Page extended-protected
2022 Russian invasion of Ukraine
From Wikipedia, the free encyclopedia
Jump to navigationJump to search
"Russian invasion of Ukraine" redirects here. For other uses, see List of invasions and occupations of Ukraine.
2022 Russian invasion of Ukraine
Part of the Russo-Ukrainian War
2022 Russian invasion of Ukraine.svg
Military situation as of 27 June 2022
   Controlled by Ukraine   Occupied by Russia
For a more detailed map, see the Russo-Ukrainian War detailed map
Date	24 February 2022 – present
(4 months and 4 days)
Location	
Ukraine[c]
Status	Ongoing (list of engagements · control of cities · timeline of events)
 
Belligerents
 Russia
 Donetsk PR[a]
 Luhansk PR[a]
Supported by:
 Belarus[b]
 Ukraine
Commanders and leaders
Russia Vladimir Putin
Ukraine Volodymyr Zelenskyy
Strength
 Russia: ~175,000–190,000[12][13]
 Donetsk PR: 20,000[14]
 Luhansk PR: 14,000[14]
 Ukraine:
196,600 (armed forces)
102,000 (paramilitary)[15]
Strength estimates are as of the start of the invasion.
See also: Order of battle for the 2022 Russian invasion of Ukraine
Casualties and losses
Reports vary widely.
See Casualties and humanitarian impact for details.
vte
2022 Russian invasion of Ukraine
vte
Russo-Ukrainian War
vte
Post-Soviet conflicts
On 24 February 2022, Russia invaded Ukraine in a major escalation of the Russo-Ukrainian War that began in 2014. The invasion caused Europe's largest refugee crisis since World War II,[16][17] with more than eight million Ukrainians fleeing the country[18] and a third of the population displaced.[19][20] The invasion also caused global food shortages.[21][22]

In 2014, Russia invaded and annexed Crimea, and Russian-backed separatists seized part of the Donbas region of south-eastern Ukraine, consisting of Luhansk and Donetsk oblasts, sparking a regional war.[23][24] In 2021, Russia began a large military build-up along its border with Ukraine, amassing up to 190,000 troops and their equipment. In a televised address shortly before the invasion, Russian president Vladimir Putin espoused irredentist views,[25] challenged Ukraine's right to statehood,[26][27] and falsely[28] claimed Ukraine was governed by neo-Nazis who persecuted the ethnic Russian minority.[29] On 21 February 2022, Russia recognised the Donetsk People's Republic and the Luhansk People's Republic, two self-proclaimed breakaway statelets in Donbas.[30] The following day, the Federation Council of Russia authorised the use of military force, and Russian troops overtly entered both territories.[31]

The invasion began on the morning of 24 February,[32] when Putin announced a "special military operation" to "demilitarise and denazify" Ukraine.[33][34] Minutes later, missiles and airstrikes hit across Ukraine, including the capital Kyiv. A large ground invasion followed from multiple directions.[35][36] Ukrainian President Volodymyr Zelenskyy enacted martial law and a general mobilisation of all male Ukrainian citizens between 18 and 60, who were banned from leaving the country.[37][38] Russian attacks were initially launched on a northern front from Belarus towards Kyiv, a north-eastern front towards Kharkiv, a southern front from Crimea, and a south-eastern front from Luhansk and Donetsk.[39][40] During March, the Russian advance towards Kyiv stalled. Amidst heavy losses and strong Ukrainian resistance, Russian troops retreated from Kyiv Oblast by 3 April. On 19 April, Russia launched a renewed attack on Donbas, with simultaneous missile attacks directed at Kyiv in the north and Lviv in western Ukraine.[41]

The invasion has received widespread international condemnation. The United Nations General Assembly passed a resolution condemning the invasion and demanding a full withdrawal of Russian forces.[42] The International Court of Justice ordered Russia to suspend military operations and the Council of Europe expelled Russia. Many countries imposed sanctions on Russia, which have affected the economies of Russia and the world,[43] and provided humanitarian and military aid to Ukraine.[44] Protests occurred around the world; those in Russia were met with mass arrests and increased media censorship,[45][46] including a ban on the words "war" and "invasion".[36][47] The International Criminal Court has opened an investigation into crimes against humanity in Ukraine since 2013, as well as war crimes in the 2022 invasion.[48]


Contents
1	Background
2	Prelude
2.1	Russian military buildups (March 2021–February 2022)
2.2	Russian accusations and demands
2.3	Alleged clashes (17–21 February 2022)
2.4	Escalation (21–23 February 2022)
2.5	Declaration of military operations
3	Invasion and resistance
3.1	First phase: Invasion of Ukraine (24 February–7 April)
3.2	Second phase: South-eastern offensive (8 April–present)
3.3	Western Ukraine
3.4	Air warfare
3.5	Naval warfare
3.6	Potential Russian use of tactical nuclear weapons
3.7	Popular resistance
3.8	Peace efforts
4	Foreign military support
4.1	Foreign military sales and aid
4.2	Foreign military involvement
5	Casualties and humanitarian impact
5.1	Casualties
5.2	Prisoners of war
5.3	Refugees
5.4	Agriculture and food supplies
5.5	Effects on Russian forces
5.6	Crimes against cultural heritage
5.7	Other impact
6	Reactions
6.1	Media depictions
6.2	Sanctions and ramifications
6.3	Legal implications
7	See also
8	Notes
9	References
10	Further reading
11	External links
Background
Main articles: Russia–Ukraine relations and Russo-Ukrainian War
Further information: Orange Revolution, Euromaidan, and Revolution of Dignity
See also: Historical background of the 2014 pro-Russian unrest in Ukraine and Russian imperialism

Protesters in Independence Square in Kyiv during the Orange Revolution, November 2004
After the Soviet Union (USSR) dissolved in 1991, the newly independent republics of Ukraine and Russia maintained ties. Ukraine agreed in 1994 to sign the Nuclear Non-Proliferation Treaty and dismantle the nuclear weapons in Ukraine left by the USSR.[49] In return, Russia, the United Kingdom (UK), and the United States (US) agreed in the Budapest Memorandum to uphold the territorial integrity of Ukraine.[50][51]

In 1999, Russia signed the Charter for European Security, which "reaffirmed the inherent right of each and every participating state to be free to choose or change its security arrangements, including treaties of alliance".[52] After the Soviet Union collapsed, several former Eastern Bloc countries joined NATO, partly due to regional security threats such as the 1993 Russian constitutional crisis, the War in Abkhazia (1992–1993) and the First Chechen War (1994–1996). Russian leaders claimed Western powers pledged that NATO would not expand eastward, although this is disputed.[53][54][55]


Ukraine, with the annexed Crimea at bottom and two self-proclaimed separatist republics in Donbas at right
Following the Euromaidan protests and a revolution resulting in the removal of pro-Russian President Viktor Yanukovych in February 2014, pro-Russian unrest erupted in parts of Ukraine. Russian soldiers without insignia took control of strategic positions and infrastructure in the Ukrainian territory of Crimea, and seized the Crimean Parliament. Russia organized a controversial referendum, whose outcome was for Crimea to join Russia. Russia's annexation of Crimea followed in March 2014, then the war in Donbas, which began in April 2014 with the formation of two Russia-backed separatist quasi-states: the Donetsk People's Republic and the Luhansk People's Republic.[56][57] Russian troops were involved in the conflict.[58][59][60] The Minsk agreements signed in September 2014 and February 2015 were a bid to stop the fighting, but ceasefires repeatedly failed.[61] A dispute emerged over the role of Russia: Normandy Format members France, Germany, and Ukraine saw Minsk as an agreement between Russia and Ukraine, whereas Russia insisted Ukraine should negotiate directly with the two separatist republics.[62][63] In 2021, Putin refused offers from Zelenskyy to hold high-level talks, and the Russian government subsequently endorsed an article by former president Dmitry Medvedev arguing it was pointless to deal with Ukraine while it remained a "vassal" of the US.[64]

The annexation of Crimea led to a new wave of Russian nationalism, with much of the Russian neo-imperial movement aspiring to annex more Ukrainian land, including the unrecognised Novorossiya.[65] Analyst Vladimir Socor argued that Putin's 2014 speech after the annexation of Crimea was a de facto "manifesto of Greater-Russia Irredentism".[66] In July 2021, Putin published an essay titled "On the Historical Unity of Russians and Ukrainians", reaffirming that Russians and Ukrainians were "one people".[67]

Prelude
Main article: Prelude to the 2022 Russian invasion of Ukraine
Russian military buildups (March 2021–February 2022)
See also: Belarusian involvement in the 2022 Russian invasion of Ukraine

US paratroopers of 2nd Battalion, 503rd Infantry Regiment depart Italy's Aviano Air Base for Latvia, 23 February 2022. Thousands of US troops were deployed to Eastern Europe amid Russia's military build-up.[68]
In March and April 2021, Russia began a major military build-up near the Russo-Ukrainian border. A second build-up followed from October 2021 to February 2022, in both Russia and Belarus.[69] Members of the Russian government repeatedly denied having plans to invade or attack Ukraine;[70][71] including government spokesman Dmitry Peskov on 28 November 2021, Deputy Foreign Minister Sergei Ryabkov on 19 January 2022,[72] Russian ambassador to the US Anatoly Antonov on 20 February 2022,[70] and Russian ambassador to the Czech Republic Alexander Zmeevsky on 23 February 2022.[73][74]

Putin's chief national security adviser, Nikolai Patrushev,[75] believed that the West had been in an undeclared war with Russia for years.[76] Russia's updated national security strategy, published in May 2021, said that Russia may use "forceful methods" to "thwart or avert unfriendly actions that threaten the sovereignty and territorial integrity of the Russian Federation".[77][78] Sources say the decision to invade Ukraine was made by Putin and a small group of war hawks in Putin's inner circle, including Patrushev and Russian Defence Minister Sergei Shoigu.[79]

When in early December 2021 Russia denied plans to invade, the US released intelligence, including satellite photographs of Russian troops and equipment near the Russo-Ukrainian border, that indicated otherwise, and continued to accurately predict invasion events.[80][81] The intelligence also said that the Russians had a list of key sites, and of individuals to be killed or neutralised in the invasion.[80]

Russian accusations and demands
Further information: Disinformation in the 2021–2022 Russo-Ukrainian crisis
See also: Russian opposition to Ukrainian NATO membership and Humanitarian situation during the war in Donbas

On 10 January 2022, Ukrainian deputy prime minister Olha Stefanishyna and NATO secretary-general Jens Stoltenberg spoke to media about the prospect of a Russian invasion.
In the months preceding the invasion, Russian officials accused Ukraine of Russophobia, inciting tensions, and repressing Russian speakers in Ukraine. They also made multiple security demands of Ukraine, NATO, and non-NATO allies in the EU. Commentators and Western officials described these as attempts to justify war.[82][83] "Russophobia is a first step towards genocide", Putin said on 9 December 2021.[84][85] Putin's claims about "de-Nazification" have been described as absurd,[86] and Russian claims of genocide were widely rejected as baseless.[87][88][89] Scholars of genocide and Nazism said that Putin's claims were "factually wrong".[90][91][92] Both Lavrov and Putin were criticized by US Ambassador Deborah Lipstadt for their weaponization of nazism and of the Holocaust, which she characterised as racially prejudiced, including Lavrov's claim that Hitler's mother was Jewish. Lipstadt similarly criticized the two Russian leaders for their weaponization of the term nazism for their own self-interest.[93] Zelenskyy declared that 16 February, a speculated date for the invasion, a "Day of Unity".[94][95]

Putin challenged the legitimacy of the Ukrainian state and claimed[96] that "Ukraine never had a tradition of genuine statehood",[97] incorrectly described it as created by Soviet Russia,[26] and falsely said Ukrainian society and government were dominated by neo-Nazism.[29]

Ukraine, like pro-Russian separatists in Donbas,[98][99][100][101] has a far-right fringe, including the neo-Nazi-linked Azov Battalion and Right Sector,[105] but experts have described Putin's rhetoric as greatly exaggerating the influence of far-right groups within Ukraine; there is no widespread support for the ideology in the government, military, or electorate.[82][29][106] Zelenskyy, who is Jewish, rebuked Putin's allegations, noting that his grandfather served in the Soviet army fighting Nazis.[107] The US Holocaust Memorial Museum and Yad Vashem condemned this use of Holocaust history and allusion to Nazi ideology in propaganda.[108][109]


Vladimir Putin (right) and his long-time confidant Defence Minister Sergei Shoigu.[110]
During the second build-up, Russia demanded that the US and NATO enter into a legally binding arrangement preventing Ukraine from ever joining NATO, and remove multinational forces from NATO's Eastern European member states.[111] Russia threatened an unspecified military response if NATO followed an "aggressive line".[112] These demands were widely seen as non-viable; new NATO members in Central and Eastern Europe had joined the alliance because they preferred the safety and economic opportunities offered by NATO and the EU, and their governments sought protection from Russian irredentism.[113] A formal treaty to prevent Ukraine from joining NATO would contravene the treaty's "open door" policy, despite NATO's unenthusiastic response to Ukrainian requests to join.[114]

Emmanuel Macron and Olaf Scholz made efforts to prevent the war in February. Macron met with Putin but failed to convince him not to go forward with the attack. Scholz warned Putin about heavy sanctions that would be imposed should the invasion happen. Scholz also pleaded with Zelensky to renounce the aspiration to join NATO and declare neutrality, however Zelensky refused it.[115]

Alleged clashes (17–21 February 2022)
Further information: Timeline of the war in Donbas (2022)
Fighting in Donbas escalated after 17 February 2022.[116] Ukraine and Donbas each accused the other of firing across the line of conflict.[117][118] On 18 February, the Donetsk and Luhansk people's republics ordered all civilians to leave their capitals,[119][120][121] Ukrainian media described a sharp increase in artillery shelling by the Russian-led militants in Donbas as an attempt to provoke the Ukrainian army.[122][123] On 19 February both separatist republics declared full mobilisation.[124]

In the days leading up to the invasion, the Russian government intensified a disinformation campaign intended to mute public criticism. Russian state media promoted fabricated videos (many amateurish)[125][126] that purported to show Ukrainian forces attacking Russians in Donbas; evidence showed that the purported attacks, explosions, and evacuations were staged by Russia.[127] On 21 February, the head of the Russian Federal Security Service (FSB) said that Russian forces had killed five Ukrainian "saboteurs" that had crossed into Russian territory, captured one Ukrainian serviceman and destroyed two armoured vehicles. Ukraine denied this, and warned that Russia sought a pretext for an invasion. The Sunday Times described it as "the first move in Putin's war plan".[128][129]

Escalation (21–23 February 2022)
Putin's address to the nation on 21 February (English subtitles available)
On 21 February,[130] The Russian government recognised the Donetsk and Luhansk people's republics.[131] The same evening, Putin ordered Russian troops into Donbas, on what he called a "peacekeeping mission".[132][133] Several members of the UN Security Council condemned the 21 February intervention in Donbas; none voiced support.[134] On 22 February, video footage shot in the early morning showed Russian armed forces and tanks moving in the Donbas region.[135] The Federation Council authorised the use of military force outside Russia.[136] Zelenskyy called up army reservists;[137] and Ukraine's parliament proclaimed a 30-day national state of emergency.[138][139] Russia evacuated its embassy from Kyiv.[140] DDoS attacks widely attributed to Russian-backed hackers[141][142] hit the websites of the Ukrainian parliament and executive branch, and many bank websites also.[143] Ukraine's Security Service (SBU) denied reports of Chinese military espionage on the eve of the invasion, including on nuclear infrastructure.[144][145][146]

On 23 February,[147] Zelenskyy gave a speech in Russian, appealing to Russian citizens to prevent war.[148][149] He refuted Russian claims of neo-Nazis in the Ukrainian government and said that he had no intention of attacking Donbas.[150] Kremlin spokesman Dmitry Peskov said on 23 February that separatist leaders in Donetsk and Luhansk had sent Putin a letter saying that Ukrainian shelling had caused civilian deaths and appealing for military support from Russia.[151] Ukraine requested an urgent UN Security Council meeting.[152][153] Half an hour into the emergency meeting, Putin announced the start of military operations in Ukraine. Sergiy Kyslytsya, the Ukrainian representative, called on the Russian representative, Vasily Nebenzya, to "do everything possible to stop the war" or relinquish his position as president of the UN Security Council; Nebenzya refused.[154][155]

Declaration of military operations
On 24 February, before 5 a.m. Kyiv time,[156] Putin announced a "special military operation" in eastern Ukraine and "effectively declared war on Ukraine."[157][158] In his speech, Putin said he had no plans to occupy Ukrainian territory and that he supported the right of the Ukrainian people to self-determination.[159] He said the purpose of the "operation" was to "protect the people" in the predominantly Russian-speaking region of Donbas who, according to him, "for eight years now, [had] been facing humiliation and genocide perpetrated by the Kyiv regime".[160]

Putin said that Russia sought "demilitarisation and denazification" of Ukraine.[161] Within minutes of Putin's announcement, explosions were reported in Kyiv, Kharkiv, Odessa, and the Donbas region.[162] An alleged leaked report from within the FSB claimed that the intelligence agency was not warned of Putin's plan to invade Ukraine.[163] Immediately following the attack, Zelenskyy declared martial law in Ukraine.[164] The same evening, he ordered a general mobilisation of all Ukrainian males between 18 and 60 years old[38] who were prohibited from leaving the country.[165] Russian troops entered Ukraine from the north in Belarus (towards Kyiv); from the north-east in Russia (towards Kharkiv); from the east in the DPR and the Luhansk People's Republic; and from the south in Crimea.[166] Russian equipment and vehicles were marked with a white Z military symbol (a non-Cyrillic letter), believed to be a measure to prevent friendly fire.[69]

Invasion and resistance
For a chronological guide, see Timeline of the 2022 Russian invasion of Ukraine.
For a more comprehensive list, see List of military engagements during the 2022 Russian invasion of Ukraine.
Further information: Kyiv offensive (2022), Northeastern Ukraine offensive, Eastern Ukraine offensive, and Southern Ukraine offensive
See also: Order of battle for the 2022 Russian invasion of Ukraine
Ambox current red Asia Australia.svg
This section needs to be updated. Please help update this article to reflect recent events or newly available information. (April 2022)

Military control around Kyiv on 2 April 2022
The invasion began at dawn of 24 February,[157] with infantry divisions and armoured and air support in Eastern Ukraine, and dozens of missile attacks across both Eastern Ukraine and Western Ukraine.[167][168] The first fighting took place in Luhansk Oblast near Milove village on the border with Russia at 3:40 a.m. Kyiv time.[169] The main infantry and tank attacks were launched in four spearhead incursions, creating a northern front launched towards Kyiv, a southern front originating in Crimea, a south-eastern front launched at the cities of Luhansk and Donbas, and an eastern front.[39][40] Dozens of missile strikes across Ukraine reached as far west as Lviv.[170][171] Wagner Group mercenaries and Chechen forces reportedly made several attempts to assassinate Volodymyr Zelenskyy. The Ukrainian government said these efforts were thwarted by anti-war officials in Russia's Federal Security Service (FSB), who shared intelligence of the plans.[172]

On 25 March, the Russian Defence Ministry said the "first stage" of what they called the "military operation in Ukraine" was generally complete, that the Ukrainian military forces had suffered serious losses, and the Russian military would now concentrate on the "liberation of Donbas".[173][174] The "first stage" of the invasion was conducted on four fronts[175][176] including one towards western Kyiv from Belarus, conducted by the Russian Eastern Military District, comprising the 29th, 35th, and 36th Combined Arms Armies. A second axis deployed towards eastern Kyiv from Russia by the Central Military District (north-eastern front), comprised the 41st Combined Arms Army and 2nd Guards Combined Arms Army. A third axis deployed towards Kharkiv by the Western Military District (eastern front), with the 1st Guards Tank Army and 20th Combined Arms Army. A fourth, southern, front originating in occupied Crimea and Russia's Rostov oblast with an eastern axis towards Odessa and a western area of operations toward Mariupol, by the Southern Military District, including the 58th, 49th, and 8th Combined Arms Army, the latter also commanding the 1st and 2nd Army Corps of the Russian separatist forces in Donbas[177]

By 7 April, Russian troops deployed to the northern front by the Russian Eastern Military District pulled back from the Kyiv offensive, apparently to resupply and then redeploy to the Donbas region to reinforce the renewed invasion of south-eastern Ukraine. The north-eastern front, including the Central Military District, was similarly withdrawn for resupply and redeployment to south-eastern Ukraine.[177][178] By 8 April, General Alexander Dvornikov was placed in charge of military operations during the invasion.[179] On 18 April, retired Lieutenant General Douglas Lute, the former US ambassador to NATO, reported in a PBS NewsHour interview that Russia had repositioned its troops to initiate a new assault on Eastern Ukraine which would be limited to Russia's original deployment of 150,000 to 190,000 troops for the invasion, though the troops were being well supplied from adequate weapon stockpiles in Russia. For Lute, this contrasted sharply with the vast size of the Ukrainian conscription of all-male Ukrainian citizens between 16 and 60 years of age, but without adequate weapons in Ukraine's highly limited stockpiles of weapons.[180] On 26 April, delegates of the US and 40 allied nations met at Ramstein Air Base in Germany to discuss forming a coalition to provide economic support and military supplies and refitting to Ukraine.[181] Following Putin's Victory Day speech in early May, US Director of National Intelligence Avril Haines said no short term resolution to the invasion should be expected.[182]

Russian forces improved their focus on protecting their supply lines by advancing more slowly, and more methodically. They also benefited from centralising command under General Dvornikov.[183] Ukraine's reliance on Western-supplied equipment constrained it, as Western countries feared that Ukraine would use it to strike targets in Russia.[184] Military experts disagree on the future of the conflict; some have suggested trading territory for peace,[185] while others believe that Ukraine can sustain their resistance to the invasion, due to the Russian losses.[186] On 26 May 2022, the Conflict Intelligence Team, citing Russian soldiers, reported that Colonel General Gennady Zhidko had been put in charge of Russian forces during the 2022 Russian invasion of Ukraine, replacing Army General Dvornikov.[187][188] By 30 May, disparities between Russian and Ukrainian artillery were apparent. Russian artillery had a longer range, for example.[189] In response to Biden's indication that enhanced artillery would be provided to Ukraine, Putin indicated that Russian would expand its invasion front to include new cities in Ukraine and in apparent retribution ordered a missile strike against Kyiv on 6 June after not directly attacking the city for several weeks.[190] On 10 June 2022, Vadym Skibitsky, deputy head of Ukraine's military intelligence, stated during the Severodonetsk campaign that the frontlines were where the future of the invasion would be decided: “This is an artillery war now, and we are losing in terms of artillery. Everything now depends on what [the west] gives us. Ukraine has one artillery piece to 10 to 15 Russian artillery pieces. Our western partners have given us about 10% of what they have.”[191]

First phase: Invasion of Ukraine (24 February–7 April)

2022 Russian Invasion of Ukraine Phase 1 from 24 February to 7 April 2022
The invasion began on 24 February, launched out of Belarus to target Kyiv, and from the northeast against the city of Kharkiv. The southeastern front was conducted as two separate spearheads, from Crimea and the southeast against Luhansk and Donetsk.[39][40]

First phase – Northern front
Further information: Capture of Chernobyl, Battle of Kyiv (2022), and Bucha massacre
Russian efforts to capture Kyiv included a probative spearhead on 24 February, from Belarus south along the west bank of the Dnipro River, apparently to encircle the city from the west, supported by two separate axes of attack from Russia along the east bank of the Dnipro: the western at Chernihiv, and the eastern at Sumy. These were likely intended to encircle Kyiv from the north-east and east.[168][167]

Russia apparently tried to rapidly seize Kyiv, with Spetsnaz infiltrating into the city supported by airborne operations and a rapid mechanised advance from the north, but was unsuccessful.[192][193][194][195] Russian forces advancing on Kyiv from Belarus gained control of the ghost towns of Chernobyl and Pripyat.[196][197] Russian Airborne Forces attempted to seize two key airfields near Kyiv, launching an airborne assault on Antonov Airport,[198][199] And a similar landing at Vasylkiv, near Vasylkiv Air Base, on 26 February.[200][201]

By early March, Russian advances along the west side of the Dnipro were limited by Ukrainian defences.[168][167] As of 5 March, a large Russian convoy, reportedly 64 kilometres (40 mi) long, had made little progress toward Kyiv.[202] The London-based think tank Royal United Services Institute (RUSI) assessed Russian advances from the north and east as "stalled".[203] Advances from Chernihiv largely halted as a siege began there. Russian forces continued to advance on Kyiv from the northwest, capturing Bucha, Hostomel, and Vorzel by 5 March,[204][205] though Irpin remained contested as of 9 March.[206] By 11 March, the lengthy convoy had largely dispersed and taken cover.[207] On 16 March, Ukrainian forces began a counter-offensive to repel Russian forces.[208] Unable to achieve a quick victory in Kyiv, Russian forces switched their strategy to indiscriminate bombing and siege warfare.[209][210]

On 25 March, a Ukrainian counter-offensive retook several towns to the east and west of Kyiv, including Makariv.[211][212] Russian troops in the Bucha area retreated north at the end of March. Ukrainian forces entered the city on 1 April.[213] Ukraine said it had recaptured the entire region around Kyiv, including Irpin, Bucha, and Hostomel, and uncovered evidence of war crimes in Bucha.[214] On 6 April, NATO secretary-general Jens Stoltenberg said that the Russian "retraction, resupply, and redeployment" of their troops from the Kyiv area should be interpreted as an expansion of Putin's plans for Ukraine, by redeploying and concentrating his forces on Eastern Ukraine.[178] Kyiv was generally left free from attack apart from isolated missile strikes. One did occur during the 28 April visit of UN Secretary-General António Guterres to discuss with Zelenskyy the survivors of the siege of Mariupol.[215]

First phase – North-eastern front
Further information: Siege of Chernihiv and Battle of Sumy
See also: Russian occupation of Sumy Oblast
Russian forces advanced into Chernihiv Oblast on 24 February and besieged its administrative capital. The next day Russian forces attacked and captured Konotop.[216][217] A separate advance into Sumy Oblast the same day attacked the city of Sumy, just 35 kilometres (22 mi) from the Russo-Ukrainian border. The advance bogged down in urban fighting, and Ukrainian forces successfully held the city, claiming more than 100 Russian armoured vehicles were destroyed and dozens of soldiers were captured.[218] Russian forces also attacked Okhtyrka, deploying thermobaric weapons.[219]

On 4 March, Frederick Kagan wrote that the Sumy axis was then "the most successful and dangerous Russian avenue of advance on Kyiv", and commented that the geography favoured mechanised advances as the terrain "is flat and sparsely populated, offering few good defensive positions".[167] Travelling along highways, Russian forces reached Brovary, an eastern suburb of Kyiv, on 4 March.[168][167] The Pentagon confirmed on 6 April that the Russian army had left Chernihiv Oblast, but Sumy Oblast remained contested.[220] On 7 April, the governor of Sumy Oblast said that Russian troops were gone, but left behind rigged explosives and other hazards.[221]

First phase – Southern front
Further information: Siege of Mariupol, 2022 bombing of Odessa, Battle of Kherson, and Battle of Enerhodar
See also: Russian occupation of Kherson Oblast and Russian occupation of Zaporizhzhia Oblast

A destroyed Russian BMP-3 near Mariupol, 7 March
On 24 February, Russian forces took control of the North Crimean Canal, allowing Crimea to obtain water from the Dnieper, cut off since 2014.[222] On 26 February, the siege of Mariupol began as the attack moved east towards the city, linking to separatist-held Donbas.[219][223] En route, Russian forces entered Berdiansk and captured it.[224] On 1 March, Russian forces attacked Melitopol and nearby cities.[225][226] On 25 February, Russian units from the DPR moves on Mariupol and were defeated near Pavlopil.[227][228][229] By evening, the Russian Navy reportedly began an amphibious assault on the coast of the Sea of Azov 70 kilometres (43 mi) west of Mariupol. A US defence official said that Russian forces might be deploying thousands of marines from this beachhead.[230][231][232]

The Russian 22nd Army Corps approached the Zaporizhzhia Nuclear Power Plant on 26 February[233][234] and besieged Enerhodar to take control of it.[235] A fire began,[236] but the International Atomic Energy Agency (IAEA) subsequently said that essential equipment was undamaged.[237] The nuclear power plant fell under Russian control but despite the fires, it recorded no radiation leaks.[238]

A third Russian attack group from Crimea moved northwest and captured bridges over the Dnieper.[239] On 2 March, Russian troops won a battle at Kherson the first major city to fall to Russian forces in the invasion.[240] Russian troops moved on Mykolaiv and attacked it two days later, but were repelled by Ukrainian forces.[241] Also on 2 March, Ukrainian forces initiated a counter-offensive on Horlivka,[242] controlled by the DPR since 2014.[243]

After renewed missile attacks on 14 March in Mariupol, the Ukrainian government said more than 2,500 had died.[244] By 18 March, Mariupol was completely encircled and fighting reached the city centre, hampering efforts to evacuate civilians.[245] On 20 March, an art school sheltering around 400 people, was destroyed by Russian bombs.[246] The Russians demanded surrender, and the Ukrainians refused.[39][40] On 24 March, Russian forces entered central Mariupol.[247] On 27 March, Ukrainian deputy prime minister Olha Stefanishyna said that “(m)ore than 85 percent of the whole town is destroyed.”[248] Putin told Emmanuel Macron in a phone call on 29 March that the bombardment of Mariupol would only end when the Ukrainians surrendered.[249]

On 1 April Russian troops refused safe passage into Mariupol to 50 buses sent by the United Nations to evacuate civilians, as peace talks continued in Istanbul.[250] On 3 April, following the retreat of Russian forces from Kyiv, Russia expanded its attack on Southern Ukraine further west, with bombardment and strikes against Odessa, Mykolaiv, and the Zaporizhzhia Nuclear Power Plant.[251][252]

First phase – Eastern front
Further information: Battle of Kharkiv (2022), Battle of Izium (2022), and Millerovo air base attack
See also: Russian occupation of Kharkiv Oblast

Russian bombardment on the outskirts of Kharkiv, 1 March
In the east, Russian troops attempted to capture Kharkiv, less than 35 kilometres (22 mi) from the Russian border,[253][254] and met strong Ukrainian resistance. On 25 February, the Millerovo air base was attacked by Ukrainian military forces with OTR-21 Tochka missiles, which according to Ukrainian officials, destroyed several Russian Air Force planes and started a fire.[170][171] On 28 February, missile attacks killed several people in Kharkiv.[255] On 1 March, Denis Pushilin, head of the DPR, announced that DPR forces had almost completely surrounded the city of Volnovakha.[256] On 2 March, Russian forces were repelled from Sievierodonetsk during an attack against the city.[257] Izium was reportedly captured by Russian forces on 17 March,[258] although fighting continued.[259]

On 25 March, the Russian defence ministry said it would seek to occupy major cities in Eastern Ukraine.[260] On 31 March, the Ukrainian military confirmed Izium was under Russian control,[261][262] and PBS News reported renewed shelling and missile attacks in Kharkiv, as bad or worse than before, as peace talks with Russia were to resume in Istanbul.[263]

Amid the heightened Russian shelling of Kharkiv on 31 March, Russia reported a helicopter strike against an oil supply depot approximately 35 kilometres (22 mi) north of the border in Belgorod, and accused Ukraine of the attack.[264] Ukraine denied responsibility.[265] By 7 April, the renewed massing of Russian invasion troops and tank divisions around the towns of Izium, Sloviansk, and Kramatorsk prompted Ukrainian government officials to advise the remaining residents near the eastern border of Ukraine to evacuate to western Ukraine within 2–3 days, given the absence of arms and munitions previously promised to Ukraine by then.[266]

Second phase: South-eastern offensive (8 April–present)

2022 Russian Invasion of Ukraine Phase 2 from 7 April to 10 June 2022
On 8 April, the Russian ministry announced that all troops and divisions in south-eastern Ukraine would unite under General Aleksandr Dvornikov, who was placed in charge of combined military operations, including the units redeployed from the northern front and north-eastern fronts.[179] By 17 April, Russian progress on the south-eastern front appeared to be impeded by troops continuing to hold out in an abandoned steel mill in Mariupol and refusing to surrender.[267] On 19 April, The New York Times confirmed that Russia had launched a renewed invasion front referred to as an "eastern assault" across a 300-mile (480 km) front extending from Kharkiv to Donetsk and Luhansk, with simultaneous missile attacks again directed at Kyiv in the north and Lviv in Western Ukraine.[41] As of 30 April, a NATO official described Russian advances as "uneven" and "minor".[268] An anonymous US Defence Official called the Russian offensive: "very tepid", "minimal at best" and "anaemic".[269] On 26 May 2022, the Conflict Intelligence Team, citing Russian soldiers, reported that Colonel General Gennady Zhidko had been put in charge of Russian forces during the 2022 Russian invasion of Ukraine, replacing Army General Dvornikov.[187][188] In June 2022 the chief spokesman for the Ministry of Defence of the Russian Federation Igor Konashenkov revealed that Russian troops are divided between the Army Groups "Center" commanded by Colonel General Aleksander Lapin and "South" commanded by Army General Sergey Surovikin.[270]

Second phase – Donbas front; Fall of Sievierodonetsk
Main article: Battle of Donbas (2022)
Further information: Battle of Kharkiv (2022), Kramatorsk railway station attack, and Battle of Sievierodonetsk (2022)
See also: Russian occupation of Kharkiv Oblast

Military control around Donbas as of 31 May 2022
A Russian missile attack on Kramatorsk railway station in the city of Kramatorsk took place on 8 April, reportedly killing at least 52[271] and injuring 87 to 300.[272] On 11 April, Zelenskyy said that Ukraine expected a major new Russian offensive in the east.[273] American officials said that Russia had withdrawn or been repulsed elsewhere in Ukraine, and therefore was preparing a retraction, resupply, and redeployment of infantry and tank divisions to the south-eastern Ukraine front.[274][275] Military satellites photographed extensive Russian convoys of infantry and mechanised units deploying south from Kharkiv to Izium on 11 April, apparently part of the planned Russian redeployment of its north-eastern troops to the south-eastern front of the invasion.[276]

On 14 April, Ukrainian troops reportedly blew up a bridge between Kharkiv and Izium used by Russian forces to redeploy troops to Izium, impeding the Russian convoy.[277] On 18 April, with Mariupol almost entirely overtaken by Russian forces, the Ukrainian government announced that the second phase of the reinforced invasion of the Donetsk, Luhansk and Kharkiv regions had intensified with expanded invasion forces occupying of the Donbas.[278] On 5 May, David Axe writing for Forbes stated that the Ukrainian army had concentrated its 4th and 17th Tank Brigades and the 95th Air Assault Brigade around Izium for possible rearguard action against the deployed Russian troops in the area; Axe added that the other major concentration of Ukraine's forces around Kharkiv included the 92nd and 93rd Mechanized Brigades which could similarly be deployed for rearguard action against Russian troops around Kharkiv or link up with Ukrainian troops contemporaneously being deployed around Izium.[279]

On 13 May, BBC reported that Russian troops in Kharkiv were being retracted and redeployed to other fronts in Ukraine following the advances of Ukrainian troops into surrounding cities and Kharkiv itself, which included the destruction of strategic pontoon bridges built by Russian troops to cross over the Seversky Donets river and previously used for rapid tank deployment in the region.[280] On 22 May, the BBC reported that after the fall of Mariupol, Russia had intensified offensives in Luhansk and Donetsk while concentrating missile attacks and intense artillery fire on Sievierodonetsk, the largest city under Ukrainian control in Luhansk province.[281] On 23 May, Russian forces were reported entering the city of Lyman, fully capturing the city by 26 May.[282][283] Ukrainian forces were reported leaving Sviatohirsk.[284] By 24 May, Russian forces captured the city of Svitlodarsk.[285] On 30 May, Reuters reported that Russian troops had breached the outskirts of Sievierodonetsk.[286] By 2 June, The Washington Post reported that Sievierodonetsk was on the brink of capitulation to Russian occupation with over 80 percent of the city in the hands of Russian troops.[287] On 3 June, Ukrainian forces reportedly began a counter-attack in Sievierodonetsk. By 4 June, Ukrainian government sources claimed 20% or more of the city had been recaptured.[288] However, on 5 June Ukrainian governor of Luhansk Serhiy Haidai said Dvornikov was still in command and had been given until 10 June by his superiors to complete the reduction of Severodonetsk.[289]

On 12 June it was reported by the BBC that eight hundred Ukrainian citizens and 300–400 soldiers were besieged at the Azot chemical factory in Severodonetsk with dwindling arms supplies negotiating for safe conduct out of the city.[290] With the Ukrainian defenses of Severodonetsk faultering, Russian invasion troops began intensifying their attack upon the neighboring city of Lysychansk as their next target city in the invasion.[291] On 20 June it was reported that Russian troops continued to tighten their grip on Severodonetsk by capturing surrounding villages and hamlets surrounding the city, most recently the village of Metelkine.[292] On 24 June, CNN reported that amid continuing scorched earth tactics being applied by advancing Russian troops that Ukraine's armed forces were ordered to evacuate the city, leaving several hundred civilians seeking refuge in the Azot chemical plant in Severodenetsk, which has been compared to the civilian refugees left at the Azovstal steel works in Mariupol during May.[293]

Second phase – Mykolaiv–Odessa front
Further information: 2022 bombing of Odessa, Battle of Mykolaiv, and 2022 Transnistria attacks
See also: Russian occupation of Kherson Oblast
Missile attacks and bombardment of the key cities of Mykolaiv and Odessa continued as the second phase of the invasion began.[41] On 22 April, Russia's Brigadier General Rustam Minnekayev in a defence ministry meeting said that Russia planned to extend its Mykolayiv–Odessa front after the siege of Mariupol further west to include the breakaway region of Transnistria on the Ukrainian border with Moldova.[294][295] The Ministry of Defence of Ukraine described this intention as imperialism, saying that it contradicted previous Russian claims that it did not have territorial ambitions in Ukraine and that the statement was an admission that "the goal of the 'second phase' of the war is not victory over the mythical Nazis, but simply the occupation of eastern and southern Ukraine".[294] Georgi Gotev, writing for Reuters on 22 April, noted that occupying Ukraine from Odessa to Transnistria would transform it into a landlocked nation without any practical access to the Black Sea.[296] On 24 April, Russia resumed its missile strikes on Odessa, destroying military facilities and causing two dozen civilian casualties.[297]

On 27 April, Ukrainian sources indicated that explosions had destroyed two Russian broadcast towers in Transnistria, primarily used to rebroadcast Russian television programming.[298] At the end of April, Russia renewed missile attacks on runways in Odessa, destroying some of them.[299] During the week of 10 May, Ukrainian troops began to take military action to dislodge Russian forces installing themselves on Snake Island in the Black Sea approximately 200 kilometres (120 mi) from Odessa.[300]

Second phase – Dnipro–Zaporizhzhia front
See also: Russian occupation of Zaporizhzhia Oblast
Russian forces continued to fire missiles and drop bombs on the key cities of Dnipro and Zaporizhzhia.[41] On 10 April, Russian missiles destroyed the Dnipro International Airport.[301][302] On 2 May the UN reportedly evacuated about 100 survivors from the siege at Mariupol with the cooperation of Russian troops, to the village of Bezimenne near Donetsk, from whence they were to move to Zaporizhzhia.[303]

Second phase – Fall of Mariupol
Further information: Siege of Mariupol
On 13 April, Russian forces intensified their attack on the Azovstal iron and steel works in Mariupol, and the Ukrainian defence forces that remained there.[304] By 17 April, Russian forces had surrounded the factory. Ukrainian prime minister Denys Shmyhal said that the Ukrainian soldiers had vowed to ignore the renewed ultimatum to surrender and to fight to the last soul.[305] On 20 April, Putin said that the siege of Mariupol could be considered tactically complete, since the 500 Ukrainian troops entrenched in bunkers within the Azovstal iron works and estimated 1,000 Ukrainian civilians were completely sealed off from any type of relief in their siege.[306]

After consecutive meetings with Putin and Zelenskyy, UN Secretary-General Guterres on 28 April said he would attempt to organise an emergency evacuation of survivors in Azovstal in accordance with assurances he had received from Putin on his visit to the Kremlin.[307] On 30 April, Russian troops allowed civilians to leave under UN protection.[308] By 3 May, after allowing approximately 100 Ukrainian civilians to depart from the Azovstal steel factory, Russian troops renewed non-stop bombardment of the steel factory.[309] On 6 May, The Telegraph reported that Russia had used thermobaric bombs against the remaining Ukrainian soldiers, who had lost contact with the Kyiv government; in his last communications, Zelenskyy had authorised the commander of the besieged steel factory to surrender as necessary under the pressure of increased Russian attacks.[310] On 7 May, the Associated Press reported that all civilians were evacuated from the Azovstal steel works at the end of the three-day ceasefire.[311]

After the last civilians evacuated from the Azovstal bunkers, nearly two thousand Ukrainian soldiers remained barricaded there, with 700 injured; they were able to communicate a plea for a military corridor to evacuate, as they expected summary execution if they surrendered to the Russians.[312] Reports of dissent within the Ukrainian troops at Azovstal were reported by Ukrainskaya Pravda on 8 May indicating that the commander of the Ukrainian Marines assigned to defend the Azovstal bunkers made an unauthorised acquisition of tanks, munitions, and personnel, broke out from the position there and fled. The remaining soldiers spoke of a weakened defensive position in Azovstal as a result, which allowed progress to advancing Russian lines of attack.[313] Ilia Somolienko, deputy commander of the remaining Ukrainian troops barricaded at Azovstal, said: "We are basically here dead men. Most of us know this and it's why we fight so fearlessly."[314]

On 16 May, the Ukrainian General staff announced that the Mariupol garrison had "fulfilled its combat mission" and that final evacuations from the Azovstal steel factory had begun. The military said that 264 service members were evacuated to Olenivka under Russian control, while 53 of them who were "seriously injured" had been taken to a hospital in Novoazovsk also controlled by Russian forces.[315][316] Following the evacuation of Ukrainian personnel from Azovstal, Russian and DPR forces fully controlled all areas of Mariupol. The end of the battle also brought an end to the Siege of Mariupol. Russia press secretary Dmitry Peskov said Russian President Vladimir Putin had guaranteed that the fighters who surrendered would be treated "in accordance with international standards" while Ukrainian President Volodymyr Zelenskyy said in an address that "the work of bringing the boys home continues, and this work needs delicacy — and time". Some prominent Russian lawmakers called on the government to deny prisoner exchanges for members of the Azov Regiment.[317]

Western Ukraine
On 14 March, Russian forces conducted multiple cruise missile attacks on a military training facility in Yavoriv, Lviv Oblast, close to the Polish border. Local governor Maksym Kozytskyy reported that at least 35 people had been killed.[318][319] On 18 March, Russia expanded the attack to Lviv, with Ukrainian military officials saying initial information suggested that the missiles which hit Lviv were likely air-launched cruise missiles originating from warplanes flying over the Black Sea.[320] On 16 May, US defense officials say that in the previous 24 hours Russians fired long range missiles targeting military training facility near Lviv.[321]

Air warfare
See also: List of aircraft losses during the Russo-Ukrainian War
On 24 February, Russian forces attacked the Chuhuiv air base,[322] which housed Bayraktar TB2 drones. The attack caused damage to fuel storage areas and infrastructure.[323] The next day, Ukrainian forces attacked the Millerovo air base.[170][171] On 27 February, Russia reportedly fired 9K720 Iskander missiles from Belarus at the civilian Zhytomyr Airport.[324][325] Many Ukrainian air defence facilities were destroyed or damaged in the first days of the invasion by Russian air strikes.[326] In the opening days of the conflict, Russia fired many cruise and ballistic missiles at the principal Ukrainian ground-based early warning radars, thereby blinding the Ukrainian Air Force to their air activity. Additionally, craters in the operating surfaces at the major Ukrainian air bases hindered Ukrainian aircraft movements, and several Ukrainian long-range S-300P surface-to-air missile batteries were destroyed.[327]

On 1 March, Russia and the US established a deconfliction line to avoid any misunderstanding that could cause an unintentional escalation.[328]

Russia lost at least ten aircraft on 5 March.[329] On 6 March, the General Staff of the Armed Forces of Ukraine reported that 88 Russian aircraft had been destroyed since the war began.[330] However, an anonymous senior US defence official told Reuters on 7 March that Russia still had the "vast majority" of its fighter jets and helicopters that had been amassed near Ukraine available to fly.[331] After the first month of the invasion, Justin Bronk, a British military observer, counted the Russian aircraft losses at 15 fixed-wing aircraft and 35 helicopters, but noted that the true total was certainly higher.[332] In contrast, according to the United States, 49 Ukrainian fighter aircraft were lost by 18 March.[333]

On 11 March, US officials said that Russian aircraft launched up to 200 sorties a day, most not entering Ukrainian airspace, instead staying in Russian airspace.[334]

On 13 March, Russian forces conducted multiple cruise missile attacks on a military training facility in Yavoriv, Lviv Oblast, close to the Polish border. Local governor Maksym Kozytskyy reported that at least 35 people had been killed in the attacks.[335][336] The poor performance of the Russian Air Force has been attributed by The Economist to Russia's inability to suppress Ukraine's medium-range surface-to-air missile (SAM) batteries and Russia's lack of precision-guided bombs. Ukrainian mid-range SAM sites force planes to fly low, making them vulnerable to Stinger and other shoulder-launched surface-to-air missiles, and lack of training and flight hours for Russian pilots renders them inexperienced for the type of close ground support missions typical of modern air forces.[337] On 5 May, Forbes magazine reported that Russians had continued air attacks and "continue to send Su-24 and Su-25 attack planes on treetop-level bombing runs targeting Ukrainian positions."[338]

By June 2022, Russia had not achieved air superiority, having lost around 165 of its combat aircraft over Ukraine which amounted to circa 10% of its frontline combat strength. Western commentators, noted the qualitative and quantative advantages the Russian air Force had over its Ukrainian counterpart but attributed the poor performance of Russian aviation to the extensive ground-based anti-aircraft capabilities of the Ukrainians.[339]

Naval warfare
See also: List of ship losses during the Russo-Ukrainian War

Russian Black Sea flagship Moskva sunk on 14 April 2022, reportedly after being hit by two Ukrainian Neptune anti-ship missiles
Ukraine lies on the Black Sea, which only has access through the Turkish-held Bosphorus and Dardanelles straits. On 28 February, Turkey invoked the 1936 Montreux Convention and sealed off the straits to Russian warships not registered to Black Sea home bases and not returning to their ports of origin. This prevented the passage of four Russian naval vessels through the Turkish Straits.[340][341][342] On 24 February, the State Border Guard Service of Ukraine announced that an attack on Snake Island by Russian Navy ships had begun.[343] The guided missile cruiser Moskva and patrol boat Vasily Bykov bombarded the island with their deck guns.[344] When the Russian warship identified itself and instructed the Ukrainian soldiers stationed on the island to surrender, their response was "Russian warship, go fuck yourself!"[345][346] After the bombardment, a detachment of Russian soldiers landed and took control of Snake Island.[347]

Russia stated on 26 February that US drones supplied intelligence to the Ukrainian navy to help target Russian warships in the Black Sea, which the US denied.[348] By 3 March, the Ukrainian frigate Hetman Sahaidachny, the flagship of the Ukrainian navy, was scuttled in Mykolaiv to prevent its capture by Russian forces.[349][350][351][352] On 14 March, the Russian source RT reported that the Russian Armed Forces had captured about a dozen Ukrainian ships in Berdiansk, including the Polnocny-class landing ship Yuri Olefirenko.[353] On 24 March, Ukrainian officials said that a Russian landing ship docked in Berdiansk – initially reported to be the Orsk and then its sister ship, the Saratov – was destroyed by a Ukrainian rocket attack.[354][212][224]

In March 2022, the UN International Maritime Organization (IMO) sought to create a safe sea corridor for commercial vessels to leave Ukrainian ports.[355] On 27 March, Russia established a sea corridor 80 miles (130 km) long and 3 miles (4.8 km) wide through its Maritime Exclusion Zone, for the transit of merchant vessels from the edge of Ukrainian territorial waters south-east of Odesa.[356][357] Ukraine closed its ports at MARSEC level 3, with sea mines laid in port approaches, until the end to hostilities.[358]

The Russian cruiser Moskva, the flagship of the Black Sea Fleet, was, according to Ukrainian sources and a US senior official,[359] hit on 13 April by two Ukrainian Neptune anti-ship cruise missiles, setting the ship on fire. The Russian Defence Ministry confirmed the warship had suffered serious damage due to a munition explosion caused by a fire, and said that its entire crew had been evacuated.[360] The Pentagon spokesman John Kirby reported on 14 April that satellite images showed that the Russian warship had suffered a sizeable explosion onboard but was heading to the east for expected repairs and refitting in Sevastopol.[361] Later on the same day, the Russian Ministry of Defence stated that Moskva had sunk while under tow in rough weather.[362] On 15 April, Reuters reported that Russia launched an apparent retaliatory missile strike against the missile factory Luch Design Bureau in Kyiv where the Neptune missiles used in the Moskva attack were manufactured and designed.[363]

In early May, Ukrainian forces launched counterattacks on Snake Island. The Russian Ministry of Defense claimed to have repelled these counterattacks. Ukraine released footage of a Russian Serna-class landing craft located in the Black Sea being destroyed near Snake Island by a Ukrainian drone.[364][365] The same day, a pair of Ukrainian Su-27s conducted a high-speed, low level bombing run on Russian-occupied Snake Island; the attack was captured on film by a Baykar Bayraktar TB2 drone.[366]

On 1 June Russian Foreign Minister Sergey Lavrov asserted that Ukraine's policy of mining its own harbors to impede Russia maritime aggression had contributed to the food export crisis stating that: "If Kyiv solves the problem of demining ports, the Russian Navy will ensure the unimpeded passage of ships with grain to the Mediterranean Sea."[367]

Potential Russian use of tactical nuclear weapons
On 14 April, The New York Times reported that William Burns of the CIA had announced that the threat of using tactical nuclear weapons was within the weapons capacity of Russia, stating: "The director of the C.I.A. said on Thursday that 'potential desperation' to extract the semblance of a victory in Ukraine could tempt President Vladimir V. Putin of Russia to order the use of a tactical or low-yield nuclear weapon."[368] On 22 April, it was reported that Russia was continuing to test its RS-28 Sarmat (nicknamed "Satan 2") long-range intercontinental ballistic missiles (ICBMs) to upgrade its nuclear arsenal in Autumn of 2022 with Putin stating that other nations should be more wary of Russia's nuclear arsenal.[369] On 24 April, in apparent response to Biden sending Antony Blinken to Kyiv for military support meetings with Zelenskyy on 23 April, Russian Foreign Minister Sergei Lavrov stated that further support of Ukraine could cause tensions which could potentially lead to a World War III scenario involving Russia's full arsenal of weapons.[370] The next day after Lavrov's comments, CNBC reported that Secretary Lloyd Austin referred to Russia's nuclear war rhetoric as being "dangerous and unhelpful".[371]

In response to Russia's apparent disregard of safety precautions during the invasion of Ukraine's nuclear power plant at Zaporizhzhia and its disabled former nuclear power plant at Chernobyl, on 26 April Zelenskyy voiced concern that Russian irresponsibility in firing their missiles in the vicinity of Ukraine's active nuclear power plant should lead to international discussion directed toward limiting and controlling Russia as a nation no longer being qualified for the responsible management of its nuclear resources and nuclear weapons stating: "I believe that after all that the Russian military has done in the Chernobyl zone and at the Zaporizhzhia power plant, no one in the world can feel safe knowing how many nuclear facilities, nuclear weapons and related technologies the Russian state has ... If Russia has forgotten what Chernobyl is, it means that global control over Russia's nuclear facilities, and nuclear technology is needed."[372]

In apparent response to Germany deploying armed tanks to Ukraine, Putin announced in Russia's main legislative assembly that Russia would respond to any combative military provocation from outside of Ukraine with prompt peremptory action possible only with Russia's unique arsenal of nuclear weapons.[373] Pentagon Press secretary John Kirby, after announcing the successful delivery of a large deployment of M777 howitzer cannons to Ukraine, called Putin's assertion of nuclear potency contrary to the process of the peaceful resolution of the current conflict in Ukraine.[374] On 4 May, the US Senate held the "Hearing on Nuclear Readiness Amid Russia-Ukraine War" where Admiral Charles A. Richard stated that current nuclear triad defence capabilities in the US were operating at a minimal acceptable level of operational capacity, with Russian stockpiles and Chinese stockpiles currently larger than those of the US.[375] On 6 May, Russian foreign ministry spokesman Alexei Zaitsev stated that Russia would not use nuclear weapons in Ukraine, describing their use as "not applicable to the Russian 'special military operation'".[376]

On 23 May, Russian diplomat Boris Bondarev resigned and issued a critique of the invasion, singling out Lavrov's position on the potential use of Russian nuclear arms: "In 18 years, he (Lavrov) went from a professional and educated intellectual ... to a person who constantly broadcasts conflicting statements and threatens the world with nuclear weapons!"[377] On 29 May, after repudiating accusations made against Russia regarding atrocities in Bucha, Andrei Kelin in an interview with the BBC tried to walkback earlier Russian comments about the use of nuclear arms by stating that Russian presently had no plans for using them unless Russian sovereignty was found to be in peril.[378] Japan's Prime Minister Fumio Kishida stated that Japan would support further international discussion about Russia and its nuclear arms threats during the invasion of Ukraine at the upcoming nuclear non-proliferation meeting taking place next August.[379][380] On 20 June, the "Conference on the Humanitarian Impact of Nuclear Weapons" opened in Vienna to discuss potential catastrophic effects of nuclear arms amid rising fears over Russia's possible use of nuclear weapons during the 2022 invasion of Ukraine.[381]

Popular resistance
Main article: Ukrainian resistance during the 2022 Russian invasion of Ukraine
See also: 2022 protests in Russian-occupied Ukraine

Civilians in Kyiv preparing Molotov cocktails, 26 February 2022
Ukrainian civilians resisted the Russian invasion, volunteered for territorial defence units, made Molotov cocktails, donated food, built barriers such as Czech hedgehogs,[382] and helped to transport refugees.[383] Responding to a call from Ukraine's transportation agency, Ukravtodor, civilians dismantled or altered road signs, constructed makeshift barriers, and blocked roadways. Social media reports showed spontaneous street protests against Russian forces in occupied settlements, often evolving into verbal altercations and physical standoffs with Russian troops.[384] By the beginning of April, Ukrainian civilians began to organise as guerrillas, mostly in the wooded north and east of the country. The Ukrainian military announced plans to launch a large-scale guerrilla campaign to complement its conventional defence against the Russian invasion.[385]

People physically blocked Russian military vehicles, sometimes forcing them to retreat.[384][386][387] The Russian soldiers' response to unarmed civilian resistance varied from reluctance to engage the protesters[384] to firing into the air or directly into crowds.[388] There have been mass detentions of Ukrainian protesters, and Ukrainian media reported forced disappearances, mock executions, hostage-taking, extrajudicial killing, and sexual violence perpetrated by the Russian military.[389] To facilitate Ukrainian attacks, civilians reported Russian military positions via a Telegram chatbot and Diia, a Ukrainian government app previously used by citizens to upload official identity and medical documents. In response, Russian forces began destroying mobile phone network equipment, searching door-to-door for smartphones and computers, and in at least one case killing a civilian found with pictures of Russian tanks.[390]

As of 21 May, President Zelensky indicated that Ukraine had 700,000 servicemembers on active duty combatting the Russian invasion.[391]

Peace efforts
Main article: 2022 Russia–Ukraine peace negotiations
Peace negotiations between Russia and Ukraine took place on 28 February,[392] 3 March,[393] and 7 March 2022,[394] in an undisclosed location in the Gomel region on the Belarus–Ukraine border,[395] with further talks held on 10 March in Turkey prior to a fourth round of negotiations which began on 14 March. Peace talks and stability of international borders were further discussed in parliament during the week of 9 May within both Sweden and Finland for application to become full members of NATO.[396]

Foreign military support
Foreign military sales and aid
For a more comprehensive list, see List of foreign aid to Ukraine during the Russo-Ukrainian War.

  Russia
  Ukraine
  Countries sending military aid to Ukraine during the 2022 invasion

  Russia
  Ukraine
  Countries sending any aid, including humanitarian aid, to Ukraine
Between 2014 and 2021, the UK, US, EU, and NATO provided mostly non-lethal military aid to Ukraine.[397] Lethal military support was initially limited. The US began to sell weapons including Javelin anti-tank missiles starting in 2018,[397] and Ukraine agreed to purchase TB2 combat drones from Turkey in 2019.[398] Russia built up equipment and troops on Ukraine's borders in January 2022. In response, the US worked with other NATO member states to transfer US-produced weapons to Ukraine.[399] The UK also began to supply Ukraine with NLAW and Javelin anti-tank weapons.[400] After the invasion, NATO member states including Germany agreed to supply weapons, but NATO as an organisation did not.[44][401][402] NATO and its members also refused to send troops into Ukraine, or to establish a no fly-zone, lest this spark a larger-scale war,[403][404] a decision some labelled appeasement.[405][406]

On 26 February, US Secretary of State Antony Blinken announced $350 million in lethal military assistance, including anti-armor and anti-aircraft systems.[407][408] The next day the EU stated that it would purchase €450 million (US$502 million) in lethal assistance and an additional €50 million ($56 million) in non-lethal supplies for Ukraine, with Poland handling distribution.[409][410] During the first week of the invasion, NATO member states supplied more than 17,000 anti-tank weapons to Ukraine;[411] by mid-March, the number was estimated to be more than 20,000.[412] In three tranches agreed in February, March and April 2022, the European Union committed to €1.5 billion to support the capabilities and resilience of the Ukrainian Armed Forces and the protection of the Ukrainian civilian population, under the purview of the European Peace Facility line.[413]

As of 11 April, Ukraine had been provided with approximately 25,000 anti-air and 60,000 anti-tank weapon systems by the US and its allies.[414] The following day, Russia reportedly received anti-tank missiles and RPGs from Iran, supplied through undercover networks via Iraq.[415]

On 19 April 2022 Romania announced a planned reform to the government decree that regulates the export of military weapons and national defence products in order to provide these weapons not only to NATO allies but also to Ukraine.[416] The Ministry of Defense developed the draft decree which states that the reason behind this decision was Russia's aggression against Ukraine.[417] However, on 27 April Defense Minister Vasile Dincu said that his plan had been discontinued.[418]

On 26 April, the US convened a conference in which representatives of more than 40 countries met at the Ramstein Air Base to discuss military support for Ukraine.[419]

On 28 April, US President Biden asked Congress for an additional $33 billion to assist Ukraine, including $20 billion to provide weapons to Ukraine.[420] On 5 May, Ukraine's Prime Minister Denys Shmyhal announced that Ukraine had received more than $12 billion worth of weapons and financial aid from Western countries since the start of Russia's invasion on 24 February.[421] On 10 May, the House passed legislation that would provide $40 billion in new aid to Ukraine.[422] After the legislation was approved by the Senate, Biden signed the legislation on 21 May.[423][424]

On 30 May French Foreign Minister Catherine Colonna announced the provision to Ukraine of additional CAESAR self-propelled howitzer self-propelled howitzer systems,[425] mounted on the Renault Sherpa 5 6×6 chassis. On May 25, the Commander-in-Chief of the Armed Forces of Ukraine Valery Zaluzhny said that the first batch was already on the front lines fighting the invader.[426] On 10 June the AFU demonstrated the combat systems to representatives from the press; by that date the Ukrainian gunners had possession of 18 CAESAR units.[427][428]

On 31 May the White House informed the press that the US would be supplying HIMARS multiple launch rocket system to Ukraine.[429] Some analysts have said HIMARS can be a “game-changer” in the war.[430] Under Secretary of Defense for Policy Colin Kahl stated that the US would be able to send more systems as the fighting evolves.[431]

On 10 June an official from the Ukrainian military said that they were using 5,000 to 6,000 artillery rounds a day and were then using 155-calibre Nato standard shells because all their Soviet-era guns had been destroyed. The official said the Russians had transformed the war into an artillery duel focused on the southeast of the country.[432] On 12 June a Ukrainian Presidential advisor put on Twitter a list of weapons that Ukraine needs to achieve "heavy weapons parity". The top item is "1000 howitzers caliber 155 mm".[433] Ukraine claims it has enough 155 mm ammunition, it lacks the artillery to use it. According to Oryxspioenkop only 250 howitzers have been promised or delivered.[434] On 13 June a Deutsche Welle correspondent said that the Ukrainian supply of Soviet-era ammunition had been exhausted and all they had as a dwindling supply obtained from friendly ex-Soviet countries.[435]

Foreign military involvement
Further information: International Legion of Territorial Defense of Ukraine
Although NATO and the EU have taken a strict policy of "no boots on the ground" in support against the Russian invasion of Ukraine,[436] Ukraine has actively sought volunteers from other countries. On 1 March, Ukraine temporarily lifted visa requirements for foreign volunteers who wished to join the fight against Russian forces. The move came after Zelenskyy created the International Legion of Territorial Defense of Ukraine and called on volunteers to "join the defence of Ukraine, Europe and the world".[437] Ukraine's foreign minister Dmytro Kuleba stated that as of 6 March, approximately 20,000 foreign nationals from 52 countries have volunteered to fight.[438] Most of these volunteers joined the newly created International Legion of Territorial Defense of Ukraine.[438] On 9 June, the Donetsk People's Republic sentenced three foreign volunteers to death. Two of them were British citizens and one was a Moroccan national.[439][440]

On 3 March, Russian Defence Ministry spokesman Igor Konashenkov warned that mercenaries are not entitled to protection under the Geneva Conventions, and captured foreign fighters would not be considered prisoners of war, but prosecuted as criminals.[441] Shortly thereafter, however, on 11 March, Moscow announced that 16,000 volunteers from the Middle East were ready to join other pro-Russian foreign fighters alongside the Donbas separatists.[442] A video uploaded online showed armed Central African paramilitaries calling to arms to fight in Ukraine with Russian troops.[443] On 5 May, a US official confirmed that US gave “a range of intelligence” (including real-time battlefield targeting intelligence)[444] to assist in the sinking of the Russian cruiser Moskva.[445]

Casualties and humanitarian impact
Casualties
Further information: Casualties of the Russo-Ukrainian War
See also: List of Russian generals killed during the 2022 invasion of Ukraine and List of journalists killed during the Russo-Ukrainian War
Breakdown	Casualties	Time period	Source
Civilians	12,000–27,999+ killed (est.)[446][d]
4,600 killed (conf.)[447]	24 February – 27 June 2022
24 February – 23 May 2022	Ukrainian government
730 killed, 2,357 wounded	17 February – 23 June 2022	DPR[e] & LPR[450]
4,731 killed, 5,900 wounded[f]	24 February – 26 June 2022	United Nations[451]
Ukrainian forces
(ZSU, NGU)	23,367 killed	24 February – 16 April 2022	Russian government[452]
5,500–11,000 killed, 18,000+ wounded	24 February – 19 April 2022	US estimate[453]
10,000 killed, 30,000 wounded	24 February – 3 June 2022	Ukrainian government[454][455]
Russian and other forces
(Russian Armed Forces, Rosgvardiya,
FSB, PMC Wagner, DPR & LPR)	16,000 killed	24 February – 15 June 2022	US estimate[456]
35,000 losses[g]	24 February – 27 June 2022	Ukrainian government[457]
Russian forces
(VSRF, Rosgvardiya, FSB)	4,010 killed[f]	24 February – 23 June 2022	BBC News Russian & Meduza[462]
3,954 killed[f]	24 February – 26 June 2022	IStories[463]
Donetsk People's Republic forces	2,183 killed, 9,196 wounded	26 February – 23 June 2022	Donetsk People's Republic[h]
Luhansk People's Republic forces	500–600 killed	24 February – 5 April 2022	Russian government[i]
Combat deaths can be inferred from a variety of sources, including satellite imagery and video footage of military actions.[467] Both Russian and Ukrainian sources are widely considered to inflate casualty numbers in opposing forces, while downplaying their own losses for the sake of morale. Both sides also tend to be quieter about their own military fatalities, with Russian news outlets having largely stopped reporting the Russian death toll.[468][469][470][471] Russia and Ukraine admitted to suffering "significant" and "considerable" losses, respectively.[470][471] According to BBC News, Ukrainian claims of Russian fatalities were including the injured as well.[458][459] AFP, as well as independent conflict monitors, reported that they had not been able to verify Russian and Ukrainian claims of enemy losses, but suspected they were inflated.[472]

The number of civilian and military deaths is impossible to determine with precision given the fog of war.[473][467] The Office of the United Nations High Commissioner for Human Rights (OHCHR) considers the number of civilian casualties to be considerably higher than the figure the United Nations are able to certify.[474]

On 16 June, the Ukrainian Minister of Defense told CNN that he believed tens of thousands of Ukrainians had died; adding that he "hoped" that the true death toll was below 100,000.[456]

Prisoners of war
See also: Casualties of the Russo-Ukrainian War § Prisoners of war, and War crimes in the 2022 Russian invasion of Ukraine § Treatment of prisoners of war
Official statistics and informed estimates about prisoners of war have varied.[475] In the initial stages of the invasion, on 24 February, Oksana Markarova, Ukraine's ambassador to the US, said that a platoon of the 74th Guards Motor Rifle Brigade from Kemerovo Oblast surrendered, saying they were unaware that they had been brought to Ukraine and tasked with killing Ukrainians.[476] Russia claimed to have captured 572 Ukrainian soldiers by 2 March 2022,[477] while Ukraine claimed 562 Russian soldiers were being held as prisoners as of 20 March,[478] with 10 previously reported released in a prisoner exchange for five Ukrainian soldiers and the mayor of Melitopol.[479][480] Subsequently, the first large prisoner exchange took place on 24 March, when 10 Russian and 10 Ukrainian soldiers, as well as 11 Russian and 19 Ukrainian civilian sailors, were exchanged.[481][482] On 1 April 86 Ukrainian servicemen were exchanged[483] for an unknown number of Russian troops.[484]

On 8 March, a Ukrainian defence reporter with The Kyiv Independent announced that the Ukrainian government was working towards having Russian POWs work to help revive the Ukrainian economy, in full compliance with international law.[485] In the first weeks of March, human rights organisations called on the Ukrainian government to uphold the rights of Russian prisoners of war under the Third Geneva Convention and to stop circulating videos of captured Russian soldiers being humiliated or intimidated.[486][487] On 27 March, a video purportedly showing Ukrainian soldiers shooting Russian prisoners in the knees was uploaded on Telegram, prompting concerns about torture and arbitrary executions of prisoners of war.[488][489][490] Another video showing Ukrainian troops killing Russian prisoners was posted on Telegram on 6 April and was verified by The New York Times and by Reuters.[491][492] The UN Human Rights Monitoring Mission in Ukraine expressed worries about the treatment of Ukrainian prisoners of war held by forces of Russia and the Donetsk and Luhansk people's republics. Videos showing Ukrainian war prisoners being forced to sing pro-Russian songs or carrying bruises attracted concerns about their treatment.[493]

Refugees
Main article: 2022 Ukrainian refugee crisis
See also: Women in the 2022 Russian invasion of Ukraine

Refugees crossing into Poland, March 2022

Ukrainian refugees in Kraków protest against the war, 6 March 2022
The war caused the largest refugee and humanitarian crisis within Europe since the Yugoslav Wars in the 1990s;[494][495] the UN described it as the fastest-growing such crisis since World War II.[496] As Russia built up military forces along the Ukrainian border, many neighbouring governments and aid organisations prepared for a mass displacement event in the weeks before the invasion. In December 2021, the Ukrainian defence minister estimated that an invasion could force three to five million people to flee their homes.[497]

In the first week of the invasion, the UN reported over a million refugees had fled Ukraine; this subsequently rose to over 7.5 million by 15 June.[18][16] Most refugees were women, children, the elderly, or people with disabilities.[498][499] As of 3 May, another 8 million people were displaced inside Ukraine.[500] By 20 March, a total of ten million Ukrainians had fled their homes, making it the fastest-growing refugee crisis in the contemporary era.[501] Most male Ukrainian nationals aged 18 to 60 were denied exit from Ukraine as part of mandatory conscription,[502][503] unless they were responsible for the financial support of three or more children, single fathers, or were the parent/guardian of children with disabilities.[504] Many Ukrainian men, including teenagers, in any case opted to remain in Ukraine to join the resistance.[505]

According to the UN High Commission for Refugees, as of 13 May, there were 3,315,711 refugees in Poland, 901,696 in Romania, 594,664 in Hungary, 461,742 in Moldova, 415,402 in Slovakia, and 27,308 in Belarus, while Russia reported it had received over 800,104 refugees.[506] As of 23 March, over 300,000 refugees had arrived in the Czech Republic.[507] Turkey has been another significant destination, registering more than 58,000 Ukrainian refugees as of 22 March, and more than 58,000 as of 25 April.[508][509] The EU invoked the Temporary Protection Directive for the first time in its history, granting Ukrainian refugees the right to live and work in the EU for up to three years.[510]

Ukraine has accused Russia of forcibly moving civilians to "filtration centers" in Russian-held territory and thence to Russia, which Ukrainian sources compared to Soviet-era population transfers and Russian actions in the Chechen War of Independence.[511][512] As of 8 April, Russia claimed to have evacuated about 121,000 Mariupol residents to Russia.[512] RIA Novosti and Ukrainian officials said that thousands were dispatched to various centers in cities in Russia and Russian-occupied Ukraine,[513] from which people were sent to economically depressed regions of Russia.[514] Ukraine's National Security and Defence Council Secretary Oleksiy Danilov said Russia also plans to build concentration camps for Ukrainians in western Siberia, where prisoners will be forced to help build new cities.[515][516][j]

On 20 May, NPR reported that, following a significant influx of foreign military equipment into Ukraine, a significant number of refugees are seeking to return to regions of Ukraine which are relatively isolated from the invasion front in south-eastern Ukraine.[518]

A second refugee crisis created by the invasion and by the Russian government's suppression of human rights has been the flight of more than 300,000 Russian political refugees and economic migrants, the largest exodus from Russia since the October Revolution of 1917,[519][520] to countries such as the Baltic states, Finland, Georgia, Turkey, and Central Asia.[521][522] By 22 March, it was estimated that between 50,000 and 70,000 high-tech workers had left the country, and that 70,000 to 100,000 more might follow. Fears arose over the effect of this flight of talent on Russian economic development.[523] Some joined the Russian resistance to the Putin regime and sought to help Ukraine,[524] and some faced discrimination for being Russian.[525][526] There has also been an exodus of millionaires.[527] On 6 May, The Moscow Times, citing data from the FSB, reported that almost four million Russians had left the country, although this figure does not distinguish between emigres and travellers for business or tourism, etc.[528]

Agriculture and food supplies
Further information: 2022 food crises

Putin met with the President of the African Union, Macky Sall, to discuss grain deliveries from Russia and Ukraine to Africa, 3 June 2022
Ukraine is among the world's top agricultural producers and exporters and is often described as the "breadbasket of Europe".[529] During the 2020/21 international wheat marketing season (July–June), it ranked as the sixth-largest wheat exporter, accounting for nine percent of world wheat trade.[530] The country is also a major global exporter of maize, barley and rapeseed. In 2020/21, it accounted for 12 percent of global trade in maize and barley and for 14 percent of world rapeseed exports. Its trade share is even greater in the sunflower oil sector, with the country accounting for about 50 percent of world exports in 2020/2021.[530]

Disruptions to the grain and oilseed sectors of Ukraine were thought inevitable. On the eve of the invasion, an estimated 6 million tons of wheat and 15 million tons of corn had been readied for export.[531] According to the Food and Agriculture Organization of the United Nations (FAO), this would cause further loss of life and increase humanitarian needs.[532] In addition, potential food and fertiliser export difficulties encountered by the Russian Federation, which is a major exporter of potash, ammonia, urea and other soil nutrients,[533] as a result of economic sanctions could jeopardise the food security of many countries.[532][534] Rising natural gas prices are pushing agricultural fertiliser prices higher, contributing to increasing food prices globally.[535] Particularly vulnerable are those that are highly dependent on Ukraine and the Russian Federation for their food and fertiliser imports.[532] Several of these countries fall into the Least Developed Country (LDC) group, while many others belong to the group of Low-Income Food-Deficit Countries (LIFDCs).[536][537] For example Eritrea sourced 47% of its wheat imports in 2021 from Ukraine. The other 53% came from the Russian Federation. Overall, more than 30 nations depend on Ukraine and Russia for over 30% of their wheat import needs, with many of them located in North Africa, and in Western and Central Asia.[530]

A Russian attack damaged the Kozarovychi Dam [uk], which regulates flow from the Kyiv Reservoir, causing flooding along the Irpin River.[390] A Russian missile attack on Kyiv Dam on the Dnieper River was blocked by Ukrainian defences. A breach could have triggered flooding of parts of Kyiv, damaged downstream dams, and threatened the Zaporizhzhia Nuclear Power Plant.[538] Russian forces blew up the dam on the North Crimean Canal which Ukraine had erected to block water flow to agricultural lands in Crimea seized by Russia in 2014.[538] Russians cut civilian water service as part of the Siege of Mariupol.[538]

The Ukrainian Defence Ministry accused Russia of stealing "hundreds of thousands of tonnes of grain" from grain elevators and other storage facilities throughout occupied Ukraine, and transporting the grain to occupied ports for export.[539][540] Substantial quantities of farm equipment, combine harvesters and tractors have also been looted from farms and dealerships and transported to Russia, as far away as Chechnya in some cases.[531][541] Theft of grain from occupied regions of Ukraine has the potential to intensify food crises, with both the Ukrainian Minister of Agriculture and the U.N. World Food Programme warning that this could worsen the Ukrainian food crisis, and even exacerbate global hunger.[542] On 30 May, Russia claimed that it had started exporting last year's grain from Kherson to Russia, and were working on exporting sunflower seeds.[543] Russian Foreign Minister Sergey Lavrov said: "If Kyiv solves the problem of demining ports, the Russian Navy will ensure the unimpeded passage of ships with grain to the Mediterranean Sea."[367] According to locals, Russian soldiers were picking strawberries in Kherson Oblast.[544]

Several African leaders said the western expansion of NATO contributed to the war, and blamed the west for food shortages and price increases.[545] African Union head, Senegalese President Macky Sall, met with President Putin on 3 June to discuss the "liberation of the stocks of grain and fertilizers," President Sall's office said, and discuss efforts "to contribute to the lull of the war in Ukraine."[546] He also blamed EU sanctions on Russian banks and products for worsening the situation.[545]

Effects on Russian forces
Several Russian soldiers, captured by Ukrainian forces, claimed that Russian officers killed their wounded.[547] There were also claims that Russian soldiers have killed their commanding officers,[548] and sometimes themselves.[549] For example, Ukrainian intelligence released a phone intercept that it claims is between a soldier and his mother: "I had a commander who shot himself in the leg just to get out of here. And that was in the very beginning [of the war]." In another call, the wife of a soldier tells him to "fall off a tank or something – I don't fucking know! Because you'd be able to go home straight from the hospital."[549] A Russian court revealed that it had dismissed 115 National Guard members for refusing to fight in the invasion.[550]

In March 2022 it was revealed that Russian conscripts had taken part in the war despite it having been denied earlier.[551] Some mothers of conscripted Russian soldiers have tried to get them out of Ukraine and returned to Russia.[552] A number of mothers have approached the Soldiers' Mothers Committee for advice.[553] Human rights lawyers and activists are claiming that Russian professional soldiers, also known as contract soldiers, are seeking legal advice so that they do not have to fight in Ukraine.[554] Russian soldiers continue to complain of an extended tour of duty. Some have sought legal advice to get out of the army however they have been told that they are in for the length of their contracts. The pro-Russia militias raised in Donetsk and Luhansk have videos showing that they lack even basic protective armor and have old equipment. Russian forces have made up the shortages of troops by recruiting from non-Russian sources including mercenaries such as the Wagner Group, and recruiting from Russian controlled areas of Ukraine.[555]

The UK MoD claimed, on 19 June, that: “The Russian authorities likely struggle to bring legal pressure to bear on military dissenters, hampered by the invasion’s official status as a ‘special military operation’ rather than as a war.” It has also been reported that Russian soldiers and whole units have refused to obey their commanders' orders and have engaged in armed stand-offs with them.[556] The Donetsk People’s Republic’s militia has suffered 55% during the fighting in the Donbas according to the UK MoD: “UK military intelligence said Russia was very likely aiming to deploy a large number of reserve units to Ukraine's eastern Donbas, which is made up of Donetsk and Luhansk.” Russia has stopped sending conscripts to the Donbas. Forcing Russian forces to rely on local proxies due to what UK intelligence calls "extraordinary attrition".[557]

Crimes against cultural heritage
As of late May, Russian forces had destroyed or damaged 250 museums and institutions in Ukraine. 2,000 art objects are estimated to have been looted, and special squads exist to track down and expropriate antiquities such as Scythian artifacts from archaeological digs, to relocate to Russia.[558] Notable heritage sites destroyed during the invasion include the All Saints Monastery in Donbas[559][560] and the house of Russian composer Pyotr Ilyich Tchaikovsky in Trostyanets.[561]

Other impact
Ukraine has a significant fertility tourism service industry which was severely impacted.[562] At the start of the invasion, surrogate mothers were displaced and distressed, requiring evacuation to safe areas.[563] One IVF clinic struggled to obtain enough liquid nitrogen to keep 19,000 embryos and eggs viable.[564]

According to researchers, Black Sea dolphins are dying or being injured by the war. Powerful military sonar is being blamed, as are underwater explosions. Exact numbers are thought to be high, with many showing up on the coast near Odessa and in other countries.[565]

According to local officials, the first Russian passports have been handed out to citizens in Kherson and Zaporizhzhia Region.[566]

Reactions
Main articles: Government and intergovernmental reactions to the 2022 Russian invasion of Ukraine and Non-government reactions to the 2022 Russian invasion of Ukraine
Further information: Protests against the 2022 Russian invasion of Ukraine and Derussification in Ukraine

UN General Assembly Resolution ES-11/1 vote on 2 March 2022 condemning the invasion of Ukraine and demanding a complete withdrawal of Russian troops.
  In favour
  Against
  Abstained
  Absent
  Non-member
The invasion received widespread international condemnation from governments and intergovernmental organisations, with reactions including new sanctions imposed on Russia, which triggered widespread economic effects on the Russian and world economies.[43] The European Union financed and delivered military equipment to Ukraine. The bloc also implemented various economic sanctions, including a ban on Russian aircraft using EU airspace,[567] a SWIFT ban on certain Russian banks, and a ban on certain Russian media outlets.[568] Non-government reactions to the invasion included widespread boycotts of Russia and Belarus in the areas of entertainment, media, business, and sport.[569] Many Indians,[570] Africans and Middle Easterners working and studying in Ukraine have reported racism at the hands of Ukrainian and other Eastern European countries.[571] The head of the World Health Organization, Dr Tedros Adhanom Ghebreyesus, has asked whether or not "the world really gives equal attention to black and white lives". He then proceeded to list other countries and compared them to the coverage of Ukraine: Ethiopia, Yemen, Afghanistan and Syria.[572]


Protest by Russians living in the Czech Republic, 26 March 2022. The white-blue-white flag is a symbol of anti-war protests in Russia.
There were also immediate worldwide protests against the invasion and daily protests in Russia itself.[573] As well as the demonstrations, petitions and open letters were published in opposition to the war, and public figures, both cultural and political, released statements against the war.[574] The protests were met with widespread repression by the Russian authorities. According to OVD-Info, at least 14,906 people were detained from 24 February to 13 March 2022.[575][576] The Russian government cracked down on other forms of opposition to the war, including introducing widespread censorship measures and repression against people who signed anti-war petitions.[577] As well as the protests, there were also reported instances of anti-Russian sentiment and discrimination against the Russian diaspora and Russian-speaking immigrants as a result of the war.[578][579] Ukraine has decided to rename the streets of Ukrainian cities named after Russian historical figures like Tchaikovsky or Tolstoy.[580]

In some parts of Ukraine that were newly occupied by Russian armed forces, protests against the occupiers took place.[581][582] In March 2022, 98% of Ukrainians – including 82% of ethnic Russians living in Ukraine – said they did not believe that any part of Ukraine was rightfully part of Russia.[583] In China,[584] India,[585][586] Indonesia,[587] Malaysia,[588] Serbia[589][590] and the Arab regions, many social media users showed sympathy for Russian narratives due in part to distrust of US foreign policy.[591] At the end of April, a poll conducted in Russia by the Levada Center concluded the following: "74% of Russians support Russia's invasion in Ukraine and the actions of the Russian military. 19% of respondents said they did not support the actions of the Russian Federation. Meanwhile, 39% of respondents said that they were not following the war in Ukraine."[592] Many respondents in Russia do not want to answer pollsters' questions for fear of negative consequences.[593] When a group of researchers commissioned a survey on Russians' attitudes to the war in Ukraine, 29,400 of the 31,000 people they called refused to answer when they heard the question.[594]

Pope Francis said that NATO may have caused Russia's invasion of Ukraine, because the alliance was "barking" at Russia's door.[595] He also warned that the war in Ukraine was becoming like the Spanish Civil War, in which new and more powerful weapons were tested.[596]

Media depictions
Further information: Disinformation in the 2021–2022 Russo-Ukrainian crisis, Media portrayal of the Ukrainian crisis, and Russian information war against Ukraine
See also: Media freedom in Russia

Russian state-controlled media systematically downplays both civilian and military losses, and denounces reports of attacks on civilians as "fake" or blames Ukrainian forces.[597]

Putin and Konstantin Ernst, chief of Russia's main state-controlled TV station Channel One.[598]
Social media users shared real-time information about the invasion.[599]

Depictions of earlier events or other misinformation, sometimes deliberate, were also shared, in addition to authentic first-hand portrayals.[600][601][602] While many outlets tagged these misleading videos and images as false content, other sites did not.[603]

Putin introduced prison sentences of up to 15 years for publishing "fake news" about Russian military operations,[604] and fines or up to three years prison for calling for sanctions,[605][606] prompting most Russian outlets to stop reporting on Ukraine. Russian censor Roskomnadzor ordered media to only use information from Russian state sources,[607] and to describe the war as a "special military operation".[608][609][610] Roskomnadzor also restricted access to Facebook,[611] after it refused to stop fact-checking posts by state-owned Zvezda, RIA Novosti, Lenta.ru, and Gazeta.Ru.[612] Pro-Kremlin television pundits like Vladimir Solovyov and Russian state-controlled channels like Russia-24,[613] Russia-1,[614] and Channel One[615] follow the government narrative.[616][617][618] The state-controlled TV where most Russians get their news[619] presented the invasion as a liberation mission.[620][621] Echo of Moscow closed down,[622] and Roskomnadzor blocked access to BBC News Russian, Voice of America, RFE/RL, Deutsche Welle, and Meduza, as well as Facebook and Twitter.[623][624][625] A Moscow court demanded that Russian-language Wikipedia remove information about the invasion, and it fined the Wikimedia Foundation 5 million rubles for refusing to comply.[626][627]

Ukrainian propaganda focused on awareness of the war and Ukraine's need for weapons.[628] Official Ukrainian social media accounts targeted recruiting and international aid.[629]

State-controlled media in China saw an opportunity for anti-American propaganda,[630] and along with Cuban state media,[631] amplified false claims of "secret US biolabs".[632] State outlets in Serbia[633] and Iran[634][635] repeated Russian propaganda, as did RT Actualidad in Latin America.[636] Pro-government Turkish media blamed NATO and the US for the war.[637] Pro-Fidesz media outlets in Hungary claimed that Ukraine provoked the war by becoming "a military base for America".[638] Vietnam told reporters not to say "invasion", and to minimise coverage.[639] South Africa's African National Congress endorsed the denazification narrative.[640][639] Some Indonesian social media users and academics also spread Russian propaganda.[641][642]

Some criticised the greater emphasis on events in Ukraine than on those in Afghanistan, Ethiopia, Iraq, Libya, Palestine, Syria, and Yemen, claiming racial bias and a racial "double standard" when it comes to news reporting.[643][644][645]

With the Russian takeover of Severodonetsk on 24 June 2022, as well as Russian control of the Luhansk, and Donetsk regions, the Western press grew increasingly critical towards a possible victory in the conflict. The German newspaper Süddeutsche Zeitung noted - after the strategic loss of Severodonetsk - that the chances for a victory by the West "tend towards zero".[646][647]

Sanctions and ramifications
Main articles: International sanctions during the 2022 Russian invasion of Ukraine and Economic impact of the 2022 Russian invasion of Ukraine
Further information: 2021–2022 global energy crisis and 2022 food crises
See also: Russia in the European energy sector
US president Joe Biden's statements and a short question and answer session on 24 February 2022
Western countries and others imposed limited sanctions on Russia when it recognised Donbas as an independent nation. When the attack began, many other countries applied sanctions intended to cripple the Russian economy.[648] The sanctions targeted individuals, banks, businesses, monetary exchanges, bank transfers, exports, and imports.[649][650] The sanctions cut major Russian banks from SWIFT, the global messaging network for international payments, but left some limited accessibility to ensure the continued ability to pay for gas shipments.[651] Sanctions also included asset freezes on the Russian Central Bank, which holds $630 billion in foreign-exchange reserves,[652] to prevent it from offsetting the impact of sanctions[653][654] and froze the Nord Stream 2 gas pipeline.[655] By 1 March, total Russian assets frozen by sanctions amounted to $1 trillion.[656]

Kristalina Georgieva, managing director of the International Monetary Fund (IMF), warned that the conflict posed a substantial economic risk both regionally and internationally. The IMF could help other countries affected, she said, in addition to the $2.2 billion loan package for Ukraine. David Malpass, president of the World Bank Group, warned of far-reaching economic and social effects, and reported that the bank was preparing options for significant economic and fiscal support to Ukraine and the region.[657] Economic sanctions affected Russia from the first day of the invasion, with its stock market falling by up to 39% (RTS Index). The Russian ruble fell to record lows, and Russians rushed to exchange currency.[658][659][660] Stock exchanges in Moscow and Saint Petersburg closed until at least 18 March,[661] the longest closure in Russia's history.[662] On 26 February, S&P Global Ratings downgraded the Russian government credit rating to "junk", causing funds that require investment-grade bonds to dump Russian debt, making further borrowing very difficult for Russia.[663] On 11 April, S&P Global placed Russia under "selective default" on its foreign debt for insisting on payments in rubles.[664] Dozens of corporations, including Unilever, McDonald's, Coca-Cola, Starbucks, Hermès, Chanel and Prada ceased trading in Russia.[665]

The National Bank of Ukraine suspended currency markets, announcing that it would fix the official exchange rate. The central bank also limited cash withdrawals to 100,000 hryvnia a day and prohibited foreign currency withdrawals by the general public. The PFTS Ukraine Stock Exchange on 24 February suspended trading due to the emergency.[666]

On 24 March, Joe Biden's administration issued an executive order, which barred the sale of Russian gold reserves in the international market.[667] Gold has been one of Russia's major avenues to protect its economy from the impact of the sanctions imposed since the 2014 annexation of Crimea.[668] In April 2022, Russia supplied 45% of EU's natural gas imports, earning $900 million a day.[669] Russia is the world's largest exporter of natural gas,[670] grains, and fertilisers, and among the world's largest suppliers of crude oil, coal, steel and metals,[671] including palladium, platinum, gold, cobalt, nickel, and aluminium.[672][673] In May 2022, the European Commission proposed a ban on oil imports from Russia.[674] With European policy-makers deciding to replace Russian fossil fuel imports with other fossil fuels imports and European coal energy production,[675][676] as well as due to Russia being "a key supplier" of materials used for "clean energy technologies", the reactions to the war may also have an overall negative impact on the climate emissions pathway.[677] Due to the sanctions imposed on Russia, Moscow is now looking to capitalise on alternative trade routes as the country has practically broken all logistic corridors for trade.[678]

The Russia–EU gas dispute flared up in March 2022.[679] On June 14, Russia's Gazprom has announced it will be slashing gas flow via the Nord Stream 1 pipeline, due to (what it claimed) was Siemens’ failure to return compressor units on time that had been sent off to Canada for repair. The explanation was challenged by Germany's energy regulator.[680]

On 17 June, President Putin spoke to investors at St. Petersburg International Economic Forum about economic sanctions, saying: “the economic blitzkrieg against Russia had no chance of succeeding from the very beginning". He further claimed that they would hurt those imposing them more than Russia. Calling them "mad and thoughtless". He said to the investors: "Invest here. It's safer in your own house. Those who didn't want to listen to this have lost millions abroad,"[681]

Legal implications
Main articles: Legality of the 2022 Russian invasion of Ukraine, War crimes in the 2022 Russian invasion of Ukraine, and Universal jurisdiction investigations of war crimes in Ukraine
Further information: International Criminal Court investigation in Ukraine, Ukraine v. Russian Federation (2022), and Independent International Commission of Inquiry on Ukraine

Executed people with wrists bound in plastic restraints, in a basement in Bucha

A children's hospital in Mariupol after Russian airstrike
The Russian invasion of Ukraine was an act of aggression that violated the Charter of the United Nations. In addition, Russia was accused of war crimes and crimes against humanity, and waging war in violation of international law, indiscriminately attacking densely populated areas and exposing civilians to unnecessary and disproportionate harm.[682][683][684] Russian forces used cluster munitions, repudiated by most states because of their immediate and long-term danger to civilians.[685][686][687] and fired other wide-area explosives like air-dropped bombs, missiles, heavy artillery shells and multiple launch rockets.[685] Ukrainian forces reportedly also fired cluster munition rockets.[688] Russian attacks damaged or destroyed homes, hospitals, schools and kindergartens[685] the Zaporizhzhia Nuclear Power Plant,[689] and 191 cultural properties such as historic buildings and churches.[690][691] As of 25 March, the attacks had resulted in at least 1,035 civilian deaths and at least 1,650 civilian injuries.[684][685] Russian forces were accused of forcibly deporting thousands of civilians to Russia,[692] sexual assaults,[693] and deliberately killing Ukrainian civilians.[694] When Ukrainian forces recaptured Bucha in late March, evidence emerged of war crimes, including torture and deliberate killings of civilians, including children.[695][696][697]

The invasion also violated the Rome Statute, which created the International Criminal Court and prohibits "the invasion or attack ... or any annexation by the use of force". Russia withdrew from the statute in 2016 and does not recognise ICC authority,[698] but thirty-nine member states officially referred the matter to the ICC,[699] and Ukraine accepted ICC jurisdiction in 2014.[700] On 2 March, Karim Ahmad Khan, prosecutor for the ICC, opened a full investigation into past and present allegations of war crimes, crimes against humanity, and genocide committed in Ukraine by any person from 21 November 2013 on.[701] The ICC also set up an online portal for people with evidence to contact investigators, and sent investigators, lawyers and other professionals to Ukraine to collect evidence.[702][703]

On 4 March 2022, the United Nations Human Rights Council created the International Commission of Inquiry on Ukraine, an independent committee of three human rights experts with a mandate to investigate violations of human rights and international humanitarian law in the invasion.[704][705] In the first month of the invasion, the UN Human Rights Monitoring Mission in Ukraine, deployed by OHCHR, documented arbitrary detentions in Russian-occupied territories of 21 journalists and civil society activists, and 24 public officials and civil servants.[706][707] They also expressed concern about reports and videos of ill-treatment, torture, and public humiliation of civilians and prisoners of war in territory controlled by Ukraine, allegedly committed by police officers and territorial defence forces.[685][490] They have been monitoring human rights violations by all parties since 2014, employing nearly 60 UN human rights monitors.

In late March, Prosecutor General of Ukraine Iryna Venediktova stated that Ukrainian prosecutors had collected evidence for 2,500 "possible war crimes cases" and had "several hundred suspects".[708] On 13 May the first war crimes trial began in Kyiv, of a Russian soldier who was ordered to shoot an unarmed civilian.[709]

Ukraine filed a lawsuit at the International Court of Justice (ICJ) accusing Russia of violating the 1948 Genocide Convention, which both Ukraine and Russia had signed, with false claims of genocide as a pretext for the invasion.[710] The International Association of Genocide Scholars supported Ukraine's request that the ICJ direct Russia to halt its offensive in Ukraine. On 16 March, the ICJ ordered Russia to "immediately suspend the military operations" on a 13–2 vote, with the Russian and Chinese judges in opposition.[711][712] The order is binding, but the ICJ has no means of enforcement.[713]

Under international criminal law's principle of universal jurisdiction,[714][715] investigations were opened in Estonia, Germany, Lithuania, Poland, Slovakia, Spain, Sweden, and Switzerland.[716][717]

See also
icon	Modern history portal
flag	Russia portal
flag	Ukraine portal
	War portal
2022 in Russia
2022 in Ukraine
2022 Russian mystery fires
Control of cities during the Russo-Ukrainian War
List of interstate wars since 1945
List of invasions and occupations of Ukraine
List of ongoing armed conflicts
List of wars between Russia and Ukraine
Post-Soviet conflicts – Military conflicts in the former Soviet Union
Russo-Georgian War – 2008 conflict between Russia and Georgia
Transnistria War – 1990–1992 conflict between Moldova and Russian-backed self-proclaimed Transnistria
Second Cold War – Tensions between the United States and China or Russia since 1991
Warsaw Pact invasion of Czechoslovakia – Soviet-led 1968 invasion of Czechoslovakia
Notes
 The Donetsk People's Republic and the Luhansk People's Republic are separatist states that declared their independence in May 2014. They have received recognition from each other, from the de facto states of Abkhazia and South Ossetia, and from Russia (since 2022).[1][2][3][4]
 Russian forces were permitted to stage part of the invasion from Belarusian territory.[5][6] Belarusian president Alexander Lukashenko also stated that Belarusian troops could take part in the invasion if needed,[7] and Belarusian territory was used to launch missiles into Ukraine.[8] Ukrainian officials have claimed that Belarusian troops have entered Ukraine.[9] See also: Belarusian involvement in the 2022 Russian invasion of Ukraine
 Outside of Ukraine, there was spillover into Russian cities of Millerovo, Belgorod, Klimovo and Otradny in Belgorodsky District of Belgorod Oblast[10][11]
 See table here for a detailed breakdown of civilian deaths by oblast, according to Ukrainian authorities
 The DPR stated 677 of its civilians were killed and 2,186 wounded between 1 January and 23 June 2022,[448] of which 8 died and 23 were wounded between 1 January and 25 February 2022,[449] leaving a total of 669 killed and 2,163 wounded in the period of the Russian invasion.
 Confirmed figure by source, not final (confirmations ongoing), estimates are higher.
 The Ministry of Defence of Ukraine uses the terms "combat losses" and "liquidated".[457] According to the BBC, these figures include wounded soldiers,[458][459] while others interpret the figures to be referring to only those killed.[460][461]
 The DPR stated 2,196 of its servicemen were killed and 9,246 wounded between 1 January and 23 June 2022,[464] of which 13 died and 50 were wounded between 1 January and 25 February 2022,[449] leaving a total of 2,183 killed and 9,196 wounded in the period of the Russian invasion.
 Russia stated 1,500 DPR and LPR servicemen were killed 24 Feb.–5 April 2022.[465] Taking into account that officially confirmed DPR losses were 979 killed 26 Feb.–7 April 2022,[466][449] it can be estimated 500–600 LPR servicemen died 24 Feb.–5 April 2022.
 Most likely, new cities meant new industrial cities in Siberia, the construction plans of which were announced by Shoigu in the fall of 2021.[517]
References
 "South Ossetia recognises independence of Donetsk People's Republic". TASS. 27 June 2014. Archived from the original on 4 January 2022. Retrieved 29 March 2022.
 "The Republic of Abkhazia and the Donetsk People's Republic established diplomatic relations". 9 March 2022. Retrieved 12 March 2022.
 "respublika abkhaziya i luganskaya narodnaya respublika ustanovili diplomaticheskie otnosheniya" АБХАЗИЯ И ЛУГАНСКАЯ НАРОДНАЯ РЕСПУБЛИКА УСТАНОВИЛИ ДИПЛОМАТИЧЕСКИЕ ОТНОШЕНИЯ [ABKHAZIA AND THE LUGANSK PEOPLE'S REPUBLIC HAVE ESTABLISHED DIPLOMATIC RELATIONS] (in Russian). 10 March 2022. Retrieved 12 March 2022.
 Luhn, Alec (6 November 2014). "Ukraine's rebel 'people's republics' begin work of building new states". The Guardian. Donetsk. eISSN 1756-3224. ISSN 0261-3077. OCLC 60623878. Archived from the original on 26 January 2022. Retrieved 31 January 2022.
 Lister, Tim; Kesa, Julia (24 February 2022). "Ukraine says it was attacked through Russian, Belarus and Crimea borders". Kyiv: CNN. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 Murphy, Palu (24 February 2022). "Troops and military vehicles have entered Ukraine from Belarus". CNN. Archived from the original on 23 February 2022. Retrieved 24 February 2022.
 Rodionov, Maxim; Balmforth, Tom (25 February 2022). "Belarusian troops could be used in operation against Ukraine if needed, Lukashenko says". Reuters. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 "Missiles launched into Ukraine from Belarus". BBC News. 27 February 2022. Archived from the original on 2 March 2022. Retrieved 27 February 2022.
 "Ukrainian Official Says Belarus Has Joined the War, as Russia Pummels Kharkiv". Time. 1 March 2022. Archived from the original on 2 March 2022. Retrieved 1 March 2022.
 "В Белгородском районе сообщили, что село Отрадное обстреляли с территории Украины" [In the Belgorod region reported that the village of Otradnoe was fired from the territory of Ukraine]. TASS (in Russian). 24 April 2022.
 "В поле у села Отрадное в Белгородской области прилетел снаряд со стороны Украины" [A shell from Ukraine landed in a field near the village of Otradnoe in the Belgorod region]. Kommersant (in Russian). 24 April 2022.
 Barnes, Julian E.; Crowley, Michael; Schmitt, Eric (10 January 2022). "Russia Positioning Helicopters, in Possible Sign of Ukraine Plans". The New York Times. Archived from the original on 22 January 2022. Retrieved 20 January 2022.
 Bengali, Shashank (18 February 2022). "The U.S. says Russia's troop buildup could be as high as 190,000 in and near Ukraine". The New York Times. Archived from the original on 18 February 2022. Retrieved 18 February 2022.
 Hackett, James, ed. (February 2021). The Military Balance 2021 (1st ed.). Abingdon, Oxfordshire: International Institute for Strategic Studies. ISBN 978-1-03-201227-8. OCLC 1292198893. OL 32226712M.
 The Military Balance 2022. International Institute for Strategic Studies. February 2022. ISBN 9781000620030.
 Keane, Daniel; Blake, Elly (14 March 2022). "What is the Homes for Ukraine refugees scheme and how do you apply?". Evening Standard. ISSN 2041-4404. Archived from the original on 14 March 2022. Retrieved 15 March 2022.
 Pita, Antonio; Costa, Raúl Sánchez (3 March 2022). "Ukrainian exodus could be Europe's biggest refugee crisis since World War II". El País. ISSN 0213-4608. Archived from the original on 5 April 2022. Retrieved 9 May 2022.
 "Situation Ukraine Refugee Situation". United Nations High Commissioner for Refugees. Retrieved 10 May 2022.
 Ratcliffe, Rebecca; Clayton, Abené; Gabbatt, Adam; Chao-Fong, Léonie; Lock, Samantha; Ambrose, Tom (19 March 2022). "Biden outlines 'consequences' if China aids Russia – as it happened". The Guardian. ISSN 1756-3224. OCLC 60623878. Archived from the original on 29 March 2022. Retrieved 28 March 2022.
 "Ukraine war: Putin being misled by fearful advisers, US says". BBC News. BBC. 31 March 2022. Archived from the original on 31 March 2022. Retrieved 31 March 2022.
 Barbaro, Michael; Chaturvedi, Asthaa; Szypko, Rob; Quester, Rachel; Johnson, Michael; Baylen, Liz O.; Daniel, Chelsea; Powell, Dan; Lozano, Marion (5 April 2022). "How the War in Ukraine is Creating a Global Food Crisis". The New York Times. ISSN 0362-4331. Retrieved 15 June 2022.
 "The coming food catastrophe". The Economist. ISSN 0013-0613. Retrieved 15 June 2022.
 Kirby, Jen; Guyer, Jonathan (24 February 2022). "Russia's war in Ukraine, explained". Vox. Archived from the original on 24 February 2022. Retrieved 31 May 2022.
 "Conflict in Ukraine". Global Conflict Tracker. Council on Foreign Relations. 28 February 2022. Retrieved 28 February 2022.
 "Russia's invasion of Ukraine". The Economist. 26 February 2022. ISSN 0013-0613. Archived from the original on 26 February 2022. Retrieved 26 February 2022. Though the target of Mr. Putin's tirade on February 21st was Ukraine, the former Soviet republics now in NATO, Estonia, Latvia and Lithuania, have cause for alarm over his irredentism.
 Perrigo, Billy (22 February 2022). "How Putin's Denial of Ukraine's Statehood Rewrites History". Time. ISSN 0040-781X. OCLC 1311479. Archived from the original on 22 February 2022. Retrieved 28 February 2022.
 "Putin Says He Does Not Plan to 'Restore Empire'". The Moscow Times. 22 February 2022. OCLC 1097137921. Archived from the original on 22 February 2022. Retrieved 31 May 2022.
 Tabarovsky, Izabella; Finkel, Eugene (27 February 2022). "Statement on the War in Ukraine by Scholars of Genocide, Nazism and World War II". The Jewish Journal of Greater Los Angeles. Retrieved 31 May 2022.
 Abbruzzese, Jason (24 February 2022). "Putin says he is fighting a resurgence of Nazism. That's not true". NBC News. NBC. Archived from the original on 24 February 2022. Retrieved 31 May 2022.
 Hernandez, Joe (22 February 2022). "Why Luhansk and Donetsk are key to understanding the latest escalation in Ukraine". NPR. Archived from the original on 22 February 2022. Retrieved 31 May 2022.
 Hodge, Nathan (22 February 2022). "Russia's Federation Council gives consent to Putin on use of armed forces abroad, Russian agencies report". CNN International. Moscow. Archived from the original on 22 February 2022. Retrieved 31 May 2022.
 Nikolskaya, Polina; Osborn, Andrew (24 February 2022). "Russia's Putin authorises 'special military operation' against Ukraine". Reuters. Moscow: Thomson Reuters. Archived from the original on 24 February 2022. Retrieved 31 May 2022.
 Grunau, Andrea; von Hein, Matthias; Theise, Eugen; Weber, Joscha (25 February 2022). "Fact check: Do Vladimir Putin's justifications for going to war against Ukraine add up?". Deutsche Welle. Archived from the original on 25 February 2022. Retrieved 1 June 2022.
 Waxman, Olivia B. (3 March 2022). "Historians on What Putin Gets Wrong About 'Denazification' in Ukraine". Time. ISSN 0040-781X. OCLC 1311479. Archived from the original on 3 March 2022. Retrieved 1 June 2022.
 "Russia attacks Ukraine". CNN International. 24 February 2022. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 Kirby, Paul (9 March 2022). "Why is Russia invading Ukraine and what does Putin want?". BBC News. Retrieved 9 March 2022.
 "Ukrainian president signs decree on general mobilisation of population -Interfax". Reuters. 24 February 2022. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 "Zelensky signs decree declaring general mobilization". Interfax-Ukraine. 25 February 2022. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 "Ukraine rejects Russian demand to surrender port city of Mariupol in exchange for safe passage". CBS News. 20 March 2022. Retrieved 21 March 2022.
 "Ukraine refuses to surrender Mariupol as scope of human toll remains unclear". Canadian Broadcasting Corporation. 21 March 2022. Retrieved 21 March 2022.
 Arraf, Jane; Nechepurenko, Ivan; Landler, Mark (19 April 2022). "Ukraine Says Russia Begins Assault in the East After Raining Missiles Nationwide". The New York Times. Retrieved 20 April 2022.
 "UN resolution against Ukraine invasion: Full text". Al Jazeera. 2 March 2022. Retrieved 25 March 2022. The General Assembly ... [d]eplores in the strongest terms the aggression by the Russian Federation against Ukraine in violation of Article 2 (4) of the Charter
 Chernova, Anna; Cotovio, Vasco; Thompson, Mark (28 February 2022). "Sanctions slams Russian economy". CNN. Archived from the original on 28 February 2022. Retrieved 28 May 2022.
 "NATO to deploy thousands of commandos to nations near Ukraine". Al Jazeera. 25 February 2022. Archived from the original on 27 February 2022. Retrieved 26 February 2022.
 Morin, Rebecca; Subramanian, Courtney; Collins, Michael; Garrison, Joey; Groppe, Maureen (24 February 2022). "World leaders condemn Russian invasion of Ukraine; EU promises 'harshest' sanctions – live updates". USA Today. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 Stewart, Briar; Seminoff, Corinne; Kozlov, Dmitry (24 February 2022). "More than 1,700 people detained in widespread Russian protests against Ukraine invasion". CBC News. Associated Press. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 Simon, Scott (5 March 2022). "Russian law bans journalists from calling Ukraine conflict a 'war' or an 'invasion'". NPR. Retrieved 20 June 2022.
 Corder, Mike (3 March 2022). "ICC prosecutor launches Ukraine war crimes investigation". Associated Press. Archived from the original on 16 April 2022. Retrieved 9 May 2022.
 Budjeryn, Mariana. "Issue Brief #3: The Breach: Ukraine's Territorial Integrity and the Budapest Memorandum" (PDF). Woodrow Wilson International Center for Scholars. Retrieved 6 March 2022.
 Vasylenko, Volodymyr (15 December 2009). "On assurances without guarantees in a 'shelved document'". The Day. Retrieved 7 March 2022.
 Harahan, Joseph P. (2014). "With Courage and Persistence: Eliminating and Securing Weapons of Mass Destruction with the Nunn-Luger Cooperative Threat Reduction Programs" (PDF). DTRA History Series. Defense Threat Reduction Agency. ASIN B01LYEJ56H. Archived from the original (PDF) on 28 February 2022. Retrieved 7 March 2022.
 "Istanbul Document 1999". Organization for Security and Co-operation in Europe. 19 November 1999. Archived from the original on 1 June 2014. Retrieved 21 July 2015.
 Wiegrefe, Klaus (15 February 2022). "NATO's Eastward Expansion: Is Vladimir Putin Right?". Der Spiegel. ISSN 2195-1349. Archived from the original on 15 February 2022. Retrieved 31 May 2022.
 Hall, Gavin E. L. (14 February 2022). "Ukraine: the history behind Russia's claim that Nato promised not to expand to the east". The Conversation. Retrieved 14 March 2022.
 Baker, Peter (9 January 2022). "In Ukraine Conflict, Putin Relies on a Promise That Ultimately Wasn't". The New York Times. ISSN 0362-4331.
 Grytsenko, Oksana; Vlasova, Anastasia (12 April 2014). "Armed pro-Russian insurgents in Luhansk say they are ready for police raid". Kyiv Post. Luhansk: Businessgroup LLC. Archived from the original on 12 April 2014. Retrieved 1 February 2022.
 Ragozin, Leonid (16 March 2019). "Annexation of Crimea: A masterclass in political manipulation". Al Jazeera. Archived from the original on 7 November 2020. Retrieved 24 May 2022.
 Charap, Samuel; Boston, Scott (21 January 2022). "U.S. Military Aid to Ukraine: A Silver Bullet?". RAND Corporation.
 Walker, Shaun; Grytsenko, Oksana; Ragozin, Leonid (3 September 2014). "Russian soldier: 'You're better clueless because the truth is horrible'". The Guardian. ISSN 1756-3224. OCLC 60623878. Archived from the original on 1 March 2022. Retrieved 28 February 2022.
 "Exclusive: Charred tanks in Ukraine point to Russian involvement". Reuters. 23 October 2014. Archived from the original on 1 March 2022. Retrieved 28 February 2022.
 "Ukraine ceasefire violated more than 100 times within days: OSCE". Al Jazeera. 29 July 2020. Archived from the original on 1 March 2022. Retrieved 28 February 2022.
 "France says Russia refused to hold ministerial meeting on Ukraine". Reuters. 9 November 2021. Retrieved 26 January 2022.
 "Article by Vladimir Putin 'On the Historical Unity of Russians and Ukrainians'". President of Russia. 12 July 2021. Archived from the original on 19 February 2022. Retrieved 26 January 2022. ... the outcome of both Minsk‑1 and Minsk‑2 which give a real chance to peacefully restore the territorial integrity of Ukraine by coming to an agreement directly with the DPR and LPR with Russia, Germany and France as mediators, contradicts the entire logic of the anti-Russia project.
 "Russia Shouldn't Negotiate With 'Vassal' Ukraine, Ex-President Medvedev Says". Moscow Times. 11 October 2021. Retrieved 26 January 2022.
 Michael, Casey (19 June 2015). "Pew Survey: Irredentism Alive and Well in Russia". The Diplomat.
 Socor, Vladimir (24 March 2014). "Putin's Crimea Speech: A Manifesto of Greater-Russia Irredentism". Vol. 11, no. 56. Eurasia Daily Monitor.
 Putin, Vladimir (12 July 2021). "Article by Vladimir Putin 'On the Historical Unity of Russians and Ukrainians'". The Kremlin. Government of Russia. Archived from the original on 25 January 2022. Retrieved 1 February 2022.
 "173rd Airborne Brigade battalion heads to Latvia as Ukraine comes under Russian attack". Stars and Stripes. 24 February 2022. Archived from the original on 26 February 2022. Retrieved 25 February 2022.
 Schogol, Jeff (22 February 2022). "Here's what those mysterious white 'Z' markings on Russian military equipment may mean". Task & Purpose. North Equity. Archived from the original on 27 February 2022. Retrieved 27 February 2022. [B]ottom line is the 'Z' markings (and others like it) are a deconfliction measure to help prevent friendly fire incidents.
 Taylor, Adam (24 February 2022). "Russia's attack on Ukraine came after months of denials it would attack". The Washington Post. Photograph by Evgeniy Maloletka (Associated Press). Archived from the original on 24 February 2022. Retrieved 26 February 2022. On Sunday ... "There is no invasion. There is no such plans," Antonov said.
 "Putin attacked Ukraine after insisting for months there was no plan to do so. Now he says there's no plan to take over". Kharkiv: CBS News (published 22 February 2022). 24 February 2022. Archived from the original on 27 February 2022. Retrieved 26 February 2022.
 Farley, Robert; Kiely, Eugene (24 February 2022). "Russian Rhetoric Ahead of Attack Against Ukraine: Deny, Deflect, Mislead". FactCheck.org. Photograph by Aris Messinis (Agence-France Presse). Annenberg Public Policy Center. Archived from the original on 27 February 2022. Retrieved 26 February 2022. Nov. 28 – ... 'Russia has never hatched, is not hatching and will never hatch any plans to attack anyone,' Peskov said. ... Jan. 19 – ... Ryabkov ... 'We do not want and will not take any action of aggressive character. We will not attack, strike, invade, quote unquote, whatever Ukraine.'
 Fořtová, Klára (8 March 2022). "Velvyslanec Ukrajiny v Česku denně promlouvá, ruský mlčí a je 'neviditelný'" [Ukraine's ambassador to the Czech Republic speaks daily, the Russian is silent and 'invisible']. Mladá fronta DNES (in Czech). Archived from the original on 8 March 2022. Retrieved 10 March 2022. Zmejevský ... 'Důrazně jsme odmítli jako nepodložená obvinění Ruska z přípravy, agrese vůči Ukrajině a fámy o vstupu ruských jednotek na ukrajinské území,' stojí v něm. [Zmeevsky ... 'We emphatically dismissed Russia's allegations of preparation, aggression against Ukraine and rumors of Russian troops entering Ukrainian territory,' he said.]
 Levchenko, Grigory (22 April 2021). "'A path towards destroying relations' Czech Republic to limit Russian Embassy staff in Prague amid escalating diplomatic tensions". Meduza.
 Troianovski, Anton (30 January 2022). "The Hard-Line Russian Advisers Who Have Putin's Ear". The New York Times. Archived from the original on 1 February 2022. Retrieved 28 May 2022.
 Galeotti, Mark (5 July 2021). "New National Security Strategy Is a Paranoid's Charter". Moscow Times. Retrieved 28 March 2022.
 "Russia's security strategy envisages 'forceful methods'". ABC News. 31 May 2021. Retrieved 28 March 2022.
 Paulick, Jane, ed. (11 March 2022). "Putin's inner circle: Who has the Russian president's ear on the war in Ukraine?". Deutsche Welle. Retrieved 28 March 2022.
 "Kremlin Insiders Alarmed Over Growing Toll of Putin's War in Ukraine". Bloomberg News. 20 March 2022.
 Merchant, Nomaan (25 February 2022). "US intel predicted Russia's invasion plans. Did it matter?". Associated Press. Photographs by Alexei Alexandrov and Alex Brandon (AP Photo). Washington, D.C. Archived from the original on 1 March 2022. Retrieved 28 February 2022.
 Harris, Shane; Sonne, Paul (3 December 2021). "Russia planning massive military offensive against Ukraine involving 175,000 troops, U.S. intelligence warns". The Washington Post. Retrieved 4 March 2022. [U].S. intelligence has found the Kremlin is planning a multi-frontal offensive as soon as early next year involving up to 175,000 troops ....
 Li, David K.; Allen, Jonathan; Siemaszko, Corky (24 February 2022). "Putin using false 'Nazi' narrative to justify Russia's attack on Ukraine, experts say". NBC News. Archived from the original on 25 February 2022. Retrieved 24 February 2022.
 "US accuses Moscow of creating Ukraine invasion pretext with 'genocide' claims". France 24. Agence France-Presse. 15 February 2021. Archived from the original on 24 February 2022. Retrieved 23 February 2022.
 "Putin Says Conflict in Eastern Ukraine 'Looks Like Genocide'". Moscow Times. 10 December 2021. Archived from the original on 21 February 2022. Retrieved 23 February 2022.
 Путин заявил о геноциде на Донбассе [Putin announced the genocide in the Donbas]. Rossiyskaya Gazeta (in Russian). 9 December 2021. Archived from the original on 22 February 2022. Retrieved 23 February 2022.
 Stanley, Jason (26 February 2022). "The antisemitism animating Putin's claim to 'denazify' Ukraine". The Guardian. Archived from the original on 1 March 2022. Retrieved 28 February 2022.
 "Ukraine crisis: Vladimir Putin address fact-checked". BBC News. 22 February 2022. Archived from the original on 23 February 2022. Retrieved 24 February 2022.
 Hinton, Alexander (24 February 2022). "Putin's claims that Ukraine is committing genocide are baseless, but not unprecedented". The Conversation. Archived from the original on 26 February 2022. Retrieved 25 February 2022.
 "Disinformation About the Current Russia-Ukraine Conflict – Seven Myths Debunked". Directorate-General for European Neighbourhood Policy and Enlargement Negotiations (Press release). 24 January 2022. Archived from the original on 18 February 2022. Retrieved 22 February 2022.
 Tabarovsky, Izabella; Finkel, Evgeny (27 February 2022). "Statement on the War in Ukraine by Scholars of Genocide, Nazism and World War II". The Jewish Journal of Greater Los Angeles. Retrieved 6 April 2022.
 Treisman, Rachel (1 March 2022). "Putin's claim of fighting against Ukraine 'neo-Nazis' distorts history, scholars say". NPR. Retrieved 8 April 2022.
 Troianovski, Anton (17 March 2022). "Why Vladimir Putin Invokes Nazis to Justify His Invasion of Ukraine". The New York Times. Archived from the original on 17 March 2022. Retrieved 8 April 2022.
 "Deborah Lipstadt interview with Walter Isaacson". Amanpour and Company. PBS. June 10, 2022. [1]
 "Ukrainians Display Patriotism On First Day Of Unity Amid Uncertainty About Russian Invasion". RadioFreeEurope/RadioLiberty. 16 February 2022. Retrieved 12 March 2022.
 Hendrix, Steve; Khurshudyan, Isabelle (16 February 2022). "With solidarity, apathy and a few songs, Ukraine's Unity Day reflects a weary nation". The Washington Post. Archived from the original on 16 February 2022. Retrieved 28 May 2022.
 "Extracts from Putin's speech on Ukraine". Reuters. 21 February 2022. Archived from the original on 1 March 2022. Retrieved 28 February 2022.
 Düben, Björn Alexander (1 July 2020). "'There is no Ukraine': Fact-Checking the Kremlin's Version of Ukrainian History". LSE International History. London School of Economics. Retrieved 7 March 2022.
 Likhachev, Vyacheslav (July 2016). "The Far Right in the Conflict between Russia and Ukraine" (PDF). Institut français des relations internationales. pp. 18–28. Archived (PDF) from the original on 8 November 2020. Retrieved 1 March 2022.
 Shekhovtsov, Anton (13 April 2022). "The Shocking Inspiration for Russia's Atrocities in Ukraine". Haaretz. Retrieved 19 April 2022.
 "Neo-Nazi Russian nationalist exposes how Russia's leaders sent them to Ukraine to kill Ukrainians". Kharkiv Human Rights Protection Group. Retrieved 19 April 2022.
 Horvath, Robert. "Putin's fascists: the Russian state's long history of cultivating homegrown neo-Nazis". The Conversation. Retrieved 19 April 2022.
 Berger, Miriam (24 February 2022). "Russian President Valdimir Putin says he will 'denazify' Ukraine. Here's the history behind that claim". The Washington Post. Archived from the original on 27 February 2022. Retrieved 27 February 2022.
 Campbell, Eric (3 March 2022). "Inside Donetsk, the separatist republic that triggered the war in Ukraine". Australian Broadcasting Corporation. Retrieved 3 March 2022.
 Schipani, Andres; Olearchyk, Roman (29 March 2022). "'Don't confuse patriotism and Nazism': Ukraine's Azov forces face scrutiny". Financial Times. Retrieved 11 April 2022.
 [102][103][104]
 "The Azov Battalion: How Putin built a false premise for a war against 'Nazis' in Ukraine". CBS News. 22 March 2022. Retrieved 25 March 2022.
 Lawler, Dave; Basu, Zachary (24 February 2022). "Ukrainian President Zelensky says Putin has ordered invasion as country prepares for war". Axios. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 Snyder, Timothy. "Putin's Hitler-like tricks and tactics in Ukraine". The Boston Globe. Archived from the original on 26 February 2022. Retrieved 25 February 2022.
 "Yad Vashem Statement Regarding the Russian Invasion of Ukraine" (Press release). Yad Vashem. 27 February 2022. Retrieved 4 March 2022.
 Kirby, Paul (2 March 2022). "Ukraine conflict: Who's in Putin's inner circle and running the war?". BBC News. Retrieved 4 March 2022.
 Tétrault-Farber, Gabrielle; Balmforth, Tom (17 December 2021). "Russia demands NATO roll back from East Europe and stay out of Ukraine". Reuters. Archived from the original on 22 February 2022. Retrieved 24 February 2022.
 MacKinnon, Mark (21 December 2021). "Putin warns of unspecified military response if U.S. and NATO continue 'aggressive line'". The Globe and Mail. Archived from the original on 15 January 2022. Retrieved 24 February 2022.
 Szayna, Thomas S. (29 October 1997). "The Enlargement of NATO and Central European Politics". Woodrow Wilson International Center for Scholars. Retrieved 14 March 2022.
 Coyer, Cassandre (25 February 2022). "Why is Ukraine not in NATO and is it too late to join? Here's what experts, NATO say". The Miami Herald. Archived from the original on 29 March 2022. Retrieved 28 February 2022.
 "Vladimir Putin's 20-Year March to War in Ukraine—and How the West Mishandled It". The Wall Strett Journal. 1 April 2022. Retrieved 18 June 2022.
 MacKinnon, Mark; Morrow, Adrian. "Putin orders snap nuclear drill". The Globe and Mail. p. A3.
 Brown, David (17 February 2022). "Ukraine: How big is Russia's military build-up?". BBC News. Photograph by the Russian Defence Ministry; Graphics by Sandra Rodriguez Chillida and Prina Shah. BBC. Archived from the original on 23 February 2022. Retrieved 23 February 2022.
 Talmazan, Yuliya; Shabad, Rebecca; Williams, Abigail (17 February 2022). "Ukraine, West accuse Russia of trying to create pretext for invasion after shelling in east". NBC News. Archived from the original on 22 February 2022. Retrieved 23 February 2022.
 "Russian-backed separatists announce civilian evacuation from eastern Ukraine as escalation stokes Russian invasion fears". NBC News. 18 February 2022. Archived from the original on 23 February 2022. Retrieved 23 February 2022.
 "Ukraine conflict: Rebels declare general mobilisation as fighting grows". BBC News. 19 February 2022. Archived from the original on 19 February 2022. Retrieved 19 February 2022.
 Light, Felix (20 February 2022). "In the Closest Russian City to Ukraine's Separatist Region, There Are Few Signs of Refugees". Moscow Times. Archived from the original on 20 February 2022. Retrieved 20 February 2022.
 Ponomarenko, Illia (18 February 2022). "47 shelling incidents leave 5 injured in Donbas". The Kyiv Independent. Archived from the original on 17 February 2022. Retrieved 18 February 2022.
 Volvach, Yaroslava (18 February 2022). "How Russian proxy forces are attempting to provoke the Ukrainian army and are lying about a new Ukrainian offensive". NV.UA. Archived from the original on 18 February 2022. Retrieved 18 February 2022.
 "Separatist leaders in eastern Ukraine declare full military mobilisation". Reuters. 19 February 2022. Retrieved 1 May 2022.
 Bellingcat Investigation Team (23 February 2022). "Documenting and Debunking Dubious Footage from Ukraine's Frontlines". Bellingcat. Archived from the original on 23 February 2022. Retrieved 24 February 2022.
 Harding, Luke; Roth, Andrew; Walker, Shaun (21 February 2022). "'Dumb and lazy': the flawed films of Ukrainian 'attacks' made by Russia's 'fake factory'". The Guardian. Archived from the original on 21 February 2022. Retrieved 22 February 2022.
 Gilbert, David (21 February 2022). "Russia's 'Idiotic' Disinformation Campaign Could Still Lead to War in Ukraine". Archived from the original on 21 February 2022. Retrieved 22 February 2022.
 Philp, Catherine (22 February 2022). "Russian claim of sabotage 'the first move in Putin's war plan'". The Sunday Times. Retrieved 20 March 2022.
 "Russian Army Says Killed 5 'Saboteurs' From Ukraine On Russian Territory". Barron's. 21 February 2022. Retrieved 20 March 2022.
 "Address by the President of the Russian Federation". President of Russia. 21 February 2022. Archived from the original on 21 February 2022. Retrieved 2 March 2022.
 "Extracts from Putin's speech on Ukraine". Reuters. 21 February 2022. Retrieved 2 March 2022.
 Kottasová, Ivana; Qiblawi, Tamara; Regan, Helen (21 February 2022). "Putin orders troops into separatist-held parts of Ukraine". CNN. Archived from the original on 23 February 2022. Retrieved 23 February 2022.
 Philp, Catherine; Wright, Oliver; Brown, Larissa (22 February 2022). "Putin sends Russian tanks into Ukraine". The Times. Archived from the original on 23 February 2022. Retrieved 23 February 2022.
 Lederer, Edith (22 February 2022). "Putin gets no support from UN Security Council over Ukraine". ABC News. Archived from the original on 23 February 2022. Retrieved 24 February 2022.
 "Videos appear to show Russian armed forces moving deep into separatist region of Ukraine". Business Insider. 22 February 2022.
 Hodge, Nathan (22 February 2022). "Russia's Federation Council gives consent to Putin on use of armed forces abroad, Russian agencies report". CNN. Moscow. Archived from the original on 26 February 2022. Retrieved 31 May 2022.
 Zinets, Natalia; Williams, Matthias (22 February 2022). "Ukrainian president drafts reservists but rules out general mobilisation for now". Reuters. Archived from the original on 22 February 2022. Retrieved 23 February 2022.
 "Ukraine's Parliament approves state of emergency". Reuters. 23 February 2022. Archived from the original on 23 February 2022. Retrieved 24 February 2022.
 D'agata, Charlie; Redman, Justine; Ott, Haley (23 February 2022). "Ukraine calls up reservists, declares national emergency as U.S. and allies hit Russia with new sanctions". CBS News. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 Litvinova, Dasha (23 February 2022). "Russia evacuates embassy in Ukraine as crisis escalates". Associated Press. Archived from the original on 23 February 2022. Retrieved 23 February 2022.
 Bajak, Frank (25 February 2022). "Cyberattacks accompany Russian military assault on Ukraine". Associated Press. Archived from the original on 28 February 2022. Retrieved 4 March 2022.
 Milmo, Dan (25 February 2022). "Russia unleashed data-wiper malware on Ukraine, say cyber experts". The Guardian. Archived from the original on 28 February 2022. Retrieved 4 March 2022.
 Bajak, Frank (23 February 2022). "Ukraine hit by more cyberattacks, destructive malware". Associated Press. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 Milmo, Dan (1 April 2022). "China accused of launching cyber-attacks on Ukraine before Russian invasion". The Guardian. Retrieved 2 April 2022.
 "Mystery of alleged Chinese hack on eve of Ukraine invasion". BBC News. 7 April 2022. Retrieved 8 April 2022.
 @ServiceSsu (1 April 2022). "Щодо публікації британського видання The Times -bit.ly/3LywSuT" (Tweet) (in Ukrainian) – via Twitter.
 Zelenskyy, Volodymyr (23 February 2022). Україна прагне миру! І робить для цього все! [Ukraine seeks peace! And does everything for this!] (Video) (in Russian). Ukraine. Archived from the original on 23 February 2022. Alt URL
 Sonne, Paul (24 February 2022). "Ukraine's Zelensky to Russians: 'What are you fighting for and with whom?'". The Washington Post. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 "Zelensky's Last-Ditch Plea for Peace". Foreign Policy. 23 February 2022. Archived from the original on 24 February 2022. Retrieved 25 February 2022.
 Cruz Bustillos, Dominic (24 February 2022). "Full Translation: Ukrainian President Volodymyr Zelenskyy's Feb. 23 Speech". Lawfare. Archived from the original on 26 February 2022. Retrieved 25 February 2022.
 "Kremlin Says Ukraine Rebels Have Asked Russia for 'Help' Against Kyiv". Moscow Times. 23 February 2022. Archived from the original on 27 February 2022.
 "Russia says Donbas separatists ask Putin for military support". Deutsche Welle. 23 February 2022. Archived from the original on 27 February 2022.
 "Ukraine – Security Council, 8974th meeting". United Nations. 27 February 2022. Retrieved 2 March 2022.
 Mauldin, William (23 February 2022). "U.S. Says Russia Will Face U.N. Security Council Resolution". The Wall Street Journal. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 Leff, Alex; Wood, Patrick (24 February 2022). "Read the impassioned plea from Ukraine's U.N. ambassador to Russia to stop the war". NPR. Retrieved 2 March 2022.
 desk, The Kyiv Independent news (24 February 2022). "PUTIN DECLARES WAR ON UKRAINE". The Kyiv Independent. Retrieved 24 June 2022.
 "Putin announces formal start of Russia's invasion in eastern Ukraine". Meduza. 24 February 2022. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 Haltiwager, John (23 February 2022). "Russian President Vladimir Putin announces military assault against Ukraine in surprise speech". MSN. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 "Full text: Putin's declaration of war on Ukraine". The Spectator. 24 February 2022.
 Hinton, Alexander (25 February 2022). "Putin's claims that Ukraine is committing genocide are baseless, but not unprecedented". The Conversation.
 "Ukraine conflict: Russian forces attack after Putin TV declaration". BBC News. 24 February 2022. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 Sheftalovich, Zoya (24 February 2022). "Putin announces 'special military operation' in Ukraine". Politico. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 Ball, Tom (7 March 2022). "This war will be a total failure, FSB whistleblower says". The Times. Retrieved 21 March 2022.
 Lock, Samantha (24 February 2022). "Russia-Ukraine crisis live news: Putin has launched 'full-scale invasion', says Ukrainian foreign minister – latest updates". The Guardian. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 Gilbert, Asha C. (25 February 2022). "Reports: Ukraine bans all male citizens ages 18 to 60 from leaving the country". USA Today. Retrieved 26 March 2022.
 Peltz, Jennifer; Lederer, Edith (23 February 2022). "'It's too late': Russian move roils UN meeting on Ukraine". AP News. Retrieved 3 March 2022.
 Kagan, Frederick; Barros, George; Stepanenko, Kateryna (5 March 2022). "Russian Offensive Campaign Assessment, March 4". CriticalThreats. Retrieved 5 March 2022.
 Kagan, Frederick; Barros, George; Stepanenko, Kateryna (4 March 2022). "Russian Offensive Campaign Assessment, March 4". Institute for the Study of War. Retrieved 5 March 2022.
 "Олексій Данілов: Росія розпадеться ще при нашому житті". Українська правда (in Ukrainian). Retrieved 24 June 2022.
 Dutton, Jack (25 February 2022). "Russian Military Base Blown Up as Ukraine Fights Back". Newsweek. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 "Ukrainian Armed Forces attacked Millerovo with Tochka-U". Rostov Gazeta. 25 February 2022. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 Rana, Manveen (3 March 2022). "Volodymyr Zelensky survives three assassination attempts in days". The Times. Retrieved 21 March 2022.
 "Operation in Ukraine proceeds as planned, first stage goals complete". TASS. 26 March 2022. Retrieved 27 March 2022.
 "Russia targets east Ukraine, says first phase over". BBC. 26 March 2022. Retrieved 27 March 2022.
 Varner, Joe (28 March 2022). "It's been one month since Russia began its invasion of Ukraine. Here's where we stand". The Hub. Retrieved 3 April 2022.
 "Russian invasion of Ukraine lacks a battlefield commander, U.S. officials say". Yahoo! News. 1 April 2022. Retrieved 3 April 2022.
 Bielieskov, Mykola (21 September 2021). "The Russian and Ukrainian Spring 2021 War Scare". Center for Strategic & International Studies. Retrieved 25 November 2021.
 Epstein, Jake; Haltiwanger, John (6 April 2022). "NATO chief says Putin still wants to control all of Ukraine, despite repositioning forces to the eastern Donbas region". Retrieved 7 April 2022.
 "Trending news: BBC: Putin replaces military commander in Ukraine – The Moscow Times". Hindustan News Hub. 8 April 2022. Retrieved 9 April 2022.
 "Russia's battle for the east has begun, Zelenskyy says". PBS NewsHour. 18 April 2022. Retrieved 20 April 2022.
 Vandiver, John; Svan, Jennifer H. (26 April 2022). "US and allies gather at Ramstein to discuss how to help Ukraine defeat Russia's 'unjust invasion'". Stars and Stripes. Archived from the original on 4 May 2022. Retrieved 9 May 2022.
 Barnes, Julian E. (10 May 2022). "The U.S. intelligence chief says Putin is preparing for a prolonged conflict". The New York Times. ISSN 1553-8095. OCLC 1645522. Archived from the original on 10 May 2022. Retrieved 27 May 2022.
 "The Russians may be learning from the mistakes of the Ukraine war. But are they adapting fast enough?". ABC. 31 May 2022.
 "Biden will not supply Ukraine with long-range rockets that can hit Russia". The Guardian. 31 May 2022.
 "Russian Wins in Eastern Ukraine Spark Debate Over Course of War". Bloomberg. 28 May 2022.
 "War in Ukraine, Day 96 Update: Russia's Military Losses are 'Unsustainable'". 19fortyfive.com. 30 May 2022.
 Conflict Intelligence Team [@CITeam_en] (26 May 2022). "Also reportedly, Russia's command in the battle for Donbas has undergone another shakeup — the overall commander is now said to be Colonel General Gennady Zhidko. Like Dvornikov, he once commanded operations in Syria and also headed the Eastern Military District" (Tweet) – via Twitter.
 "General Dvornikov 'no longer in command' of Russian Army in Ukraine". The New Voice of Ukraine. 3 June 2022.
 "Biden will not supply Ukraine with long-range rockets that can hit Russia". The Guardian. 31 May 2022.
 CBS News Videos. "Russia bombards Kyiv, vows to strike new targets if U.S. sends long-range missiles to Ukraine". June 6, 2022. [2]
 "We're almost out of ammunition and relying on western arms, says Ukraine". TheGuardian.com. 10 June 2022.
 Roblin, Sebastien (27 February 2022). "At Vasylkiv, Ukrainians Repel Russia's Paratroopers and Commandos in Frantic Night Battle". 19FortyFive. Retrieved 5 March 2022.
 Sly, Liz; Lamothe, Dan (20 March 2022). "Russia's war for Ukraine could be headed toward stalemate". The Washington Post. ISSN 0190-8286. OCLC 2269358. Archived from the original on 20 March 2022. Retrieved 6 June 2022.
 Boot, Max (21 March 2022). "Opinion: Against all odds, Ukrainians are winning. Russia's initial offensive has failed". The Washington Post. Retrieved 24 March 2022.
 Kemp, Richard (22 March 2022). "The Russian army has run out of time". The Daily Telegraph. Retrieved 24 March 2022.
 "Ukraine loses control of Chernobyl nuclear site, amid battles in Kyiv outskirts". The Times of Israel. 24 February 2022. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 Українські військові під Києвом зупинили колону російських танків [The Ukrainian military stopped a column of Russian tanks near Kyiv]. Gazeta (in Ukrainian). 25 February 2022. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 "Battle Underway for Airbase on Kyiv Outskirts". Moscow Times. AFP. 24 February 2022. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 "Russia claims to take control of Hostomel airport just outside Kyiv". The Times of Israel. Associated Press. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 Окупанти намагаються висадити десант у Василькові, йдуть бої [The occupiers are trying to land in Vasylkiv, fighting is going on] (in Ukrainian). Ukrinform. Archived from the original on 26 February 2022. Retrieved 26 February 2022.
 У Василькові збили винищувач та два гвинтокрили окупантів [A fighter and two helicopters of the occupiers were shot down in Vasylkiv] (in Ukrainian). Ukrainian Independent Information Agency. Archived from the original on 26 February 2022. Retrieved 26 February 2022.
 Stern, David L. (5 March 2022). "After temporary cease-fires break down, Putin threatens Ukraine's government". The Washington Post. Retrieved 6 March 2022.
 Arnold, Edward (6 March 2022). How is the war in Ukraine going for Russia?. DW News. Interviewed by Rebecca Ritters. Archived from the original on 14 March 2022. Retrieved 18 March 2022 – via YouTube.
 Lister, Tim; Pennington, Josh; McGee, Luke; Gigova, Radina (7 March 2022). "'A family died ... in front of my eyes': Civilians killed as Russian military strike hits evacuation route in Kyiv suburb". CNN. Retrieved 9 March 2022.
 "Bucha, Vorzel, Hostomel under enemy's control, situation remains critical". Ukrinform. 7 March 2022. Retrieved 9 March 2022.
 Lister, Tim; Voitovych, Olga (8 March 2022). ""Irpin can't be bought, Irpin fights": Mayor refuses Russian demand to surrender". CNN. Retrieved 8 March 2022.
 Murphy, Paul (11 March 2022). "Stalled 40-mile-long Russian convoy near Kyiv now largely dispersed, satellite images show". CNN. Retrieved 11 March 2022.
 Cullison, Alan; Coles, Isabel; Trofimov, Yaroslav (16 March 2022). "Ukraine Mounts Counteroffensive to Drive Russians Back From Kyiv, Key Cities". The Wall Street Journal. Archived from the original on 16 March 2022. Retrieved 16 March 2022.
 Gordon, Michael R.; Leary, Alex (21 March 2022). "The Wall Street Journal News Exclusive | Russia, Failing to Achieve Early Victory in Ukraine, Is Seen Shifting to 'Plan B'". The Wall Street Journal. Retrieved 24 March 2022.
 Ali, Idrees; Stewart, Phil (27 February 2022). "Russian forces appear to shift to siege warfare in Ukraine- U.S. official". Reuters. Retrieved 24 March 2022.
 "Ukraine war: Ukrainian fightback gains ground west of Kyiv". BBC News. 23 March 2022. Retrieved 29 March 2022.
 Walters, Joanna; Bartholomew, Jem; Belam, Martin; Lock, Samantha (25 March 2022). "Russia-Ukraine war latest: Ukraine takes back towns east of Kyiv; hopes of Mariupol humanitarian corridor grow – live". The Guardian. Retrieved 25 March 2022.
 Rudenko, Olga (2 April 2022). "Hundreds of murdered civilians discovered as Russians withdraw from towns near Kyiv (GRAPHIC IMAGES)". The Kyiv Independent. Archived from the original on 3 April 2022. Retrieved 3 April 2022.
 "Ukraine war latest: Ukraine says it has retaken entire Kyiv region". BBC News. Retrieved 2 April 2022.
 Tebor, Celina; Miller, Ryan W.; Hayes, Christal; Santucci, Jeanine (30 April 2022). "Ukraine in 'a fight for life' in Donbas region, Zelenskyy says in nightly address; Russian strike kills at least 1 in Kyiv: Live updates". Yahoo News. Retrieved 2 June 2022.
 Ward, Alexander (25 February 2022). "'Almost not possible' for Ukraine to win without West's help, Ukraine official says". Politico. Archived from the original on 26 February 2022. Retrieved 26 February 2022.
 "Ukraine war news from February 25: Kyiv suburbs breached, Russian forces face resistance, Zelensky warns Russia will 'storm' capital". Financial Times. 26 February 2022. ISSN 0307-1766. Archived from the original on 26 February 2022. Retrieved 26 February 2022.
 "Бои под Сумами: артиллерия и "Байрактары" уничтожили 100 танков и 20 "Градов" оккупантов". Archived from the original on 28 February 2022. Retrieved 28 February 2022.
 Polyakovskaya, Tanya (26 February 2022). Российская военная техника заняла территорию бывшего аэропорта "Бердянск" – горсовет [Russian military equipment occupied the territory of the former airport "Berdyansk" – city council] (in Russian). Berdyansk City Council. Ukrainian Independent Information Agency. Archived from the original on 26 February 2022. Retrieved 26 February 2022.
 "Pentagon: Russia has fully withdrawn from Kyiv, Chernihiv". The Washington Post. 6 April 2022. Retrieved 7 April 2022.
 Kalatur, Anastasiya (8 April 2022). "Sumy region liberated from Russian troops". Ukrayinska Pravda. Retrieved 15 April 2022.
 Marrow, Alexander; Ostroukh, Andrey (24 February 2022). "Russian forces unblock water flow for canal to annexed Crimea, Moscow says". Reuters. Archived from the original on 1 March 2022.
 NEXTA [@nexta_tv] (26 February 2022). "The tanks of the occupiers have circled #Berdyansk and are heading towards #Mariupol. t.co/jwsIoORzH0" (Tweet). Archived from the original on 27 February 2022. Retrieved 28 February 2022 – via Twitter.
 Lister, Tim; Alkhaldi, Celine; Voitovych, Olga; Mezzofiore, Gianluca (24 March 2022). "Ukrainians claim to have destroyed large Russian warship in Berdyansk". CNN. Retrieved 24 March 2022.
 Zadorozhnaya, Anastasia (1 March 2022). Войска оккупанта готовят наступление на Мелитополь [Invader's troops are preparing an attack on Melitopol]. RIA Melitopol (in Russian). Archived from the original on 2 March 2022. Retrieved 2 March 2022.
 Korobova, Marina (1 March 2022). "Мелитополь не сдался, Мелитополь – временно оккупирован" – городской голова о ситуации на 1 марта ["Melitopol did not surrender, Melitopol is temporarily occupied" – the mayor on the situation on March 1]. Mestnyye Vesti (in Russian). Archived from the original on 2 March 2022. Retrieved 2 March 2022.
 "Fierce battles raging in all directions near Mariupol – mayor". Interfax-Ukraine. Archived from the original on 26 February 2022. Retrieved 25 February 2022.
 Richárd, Jabronka (25 February 2022). "Így áll most a háború Ukrajnában: több nagyvárosban harcok dúlnak, megtámadtak egy orosz repülőteret" [This is how the war in Ukraine is now: fighting is raging in several big cities, a Russian airport has been attacked]. Ellenszél (in Hungarian). Archived from the original on 26 February 2022. Retrieved 25 February 2022.
 "Battle ongoing near Mariupol – mayor". Ukrinform. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 ""Amphibious assault" underway west of Mariupol on the Sea of Azov, senior US defense official says". CNN. 25 February 2022. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 "Russian Navy Carries Out Amphibious Assault Near Mariupol". The Maritime Executive. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 "Russian forces are about 31 miles outside southeastern Ukrainian city of Mariupol, US defense official says". CNN. 27 February 2022. Archived from the original on 27 February 2022. Retrieved 27 February 2022.
 "Ukraine official says Russian troops approaching Zaporizhzhia nuclear plant". National Post. 26 February 2022. Retrieved 28 February 2022.
 "The Russians paused the invasion, but aren't losing". Australian Financial Review. 28 February 2022. Archived from the original on 28 February 2022. Retrieved 28 February 2022.
 "Ukraine nuclear plant on fire after Russia shelling". News.com.au. 4 March 2022. Retrieved 4 March 2022.
 "Russian forces attacking Zaporizhzhia nuclear power plant in Ukraine, per multiple reports". Business Insider Australia. 3 March 2022. Retrieved 4 March 2022.
 "Russian forces strike Ukraine from multiple fronts, including at power plant". ABC News. 3 March 2022. Retrieved 4 March 2022.
 "Russian troops take Zaporizhzhia nuclear plant". ABC News. 4 March 2022. Retrieved 4 March 2022.
 "Ukraine loses control over crossing to Kherson". Ukrinform. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 Schwirtz, Michael; Pérez-Peña, Richard (2 March 2022). "First Ukraine City Falls as Russia Strikes More Civilian Targets". The New York Times. Archived from the original on 3 March 2022. Retrieved 3 March 2022.
 "Ukrainian defenders repelled attack on Mykolaiv city, fighting continues on outskirts". Ukrinform. 4 March 2022. Retrieved 4 March 2022.
 "First in 7 days of war Ukrainian units go on offensive advancing to Horlivka – Arestovych". Interfax Ukraine. 2 March 2022. Retrieved 2 March 2022.
 Huijboom, Stefan (22 June 2015). "Resident of Russian-held Horlivka: 'We have nothing'". Kyiv Post. Retrieved 11 March 2022.
 Lister, Tim; Kesa, Julia (14 March 2022). "Ukraine puts death toll in Mariupol bombardment at more than 2,500". CNN. Retrieved 14 March 2022.
 Boffey, Daniel; Tondo, Lorenzo (18 March 2022). "Fighting reaches central Mariupol as shelling hinders rescue attempts". The Guardian. Retrieved 21 March 2022.
 "Russian forces bomb school sheltering 400 people in Mariupol, city council says". CNN. 20 March 2022. Retrieved 20 March 2022.
 "Ukraine war in maps: Tracking the Russian invasion". BBC News. 25 March 2022. Retrieved 25 March 2022.
 Scully, Rachel (27 March 2022). "Ukrainian official: Mariupol 'simply does not exist anymore'". The Hill. Retrieved 29 March 2022.
 "Ukraine War: Putin demands Mariupol surrender to end shelling". BBC News. 30 March 2022. Retrieved 31 March 2022.
 "Ukraine: No 'plan B' for evacuation of shattered Mariupol, say humanitarians, as Friday attempt fails". UN News. 1 April 2022. Retrieved 3 April 2022.
 "Missiles hit Ukraine refinery, 'critical infrastructure' near Odessa". The Straits Times. SPH Media Trust. Reuters. 3 April 2022. Retrieved 6 April 2022.
 "Video analysis reveals Russian attack on Ukrainian nuclear plant veered near disaster". NPR. 11 March 2022. Retrieved 1 April 2022.
 Losh, Jack (25 February 2022). "Kharkiv's Resistance to Russia's War Has Already Begun". Foreign Policy. Archived from the original on 25 February 2022. Retrieved 27 February 2022.
 "Росія атакувала українські міста: де відбулися бої" [Russia attacked Ukrainian cities: where the fighting took place]. Channel 24. Archived from the original on 25 February 2022. Retrieved 27 February 2022.
 "Russia-Ukraine War: What to know on Day 7 of Russian assault". AP News. 2 March 2022. Archived from the original on 2 March 2022. Retrieved 2 March 2022.
 Lister, Tim; Voitovych, Olya (1 March 2022). "Russian-backed separatist leader expects his forces to surround Mariupol on Tuesday". CNN. Retrieved 1 March 2022.
 Новини України: Російське вторгнення: поточна ситуація на Луганщині [News of Ukraine: Russian invasion: the current situation in Luhansk region]. galinfo.com.ua (in Ukrainian). Retrieved 3 March 2022.
 "Pentagon says Russian advance is frozen". BBC News. 17 March 2022. Archived from the original on 17 March 2022. Retrieved 17 March 2022.
 "Russian Offensive Campaign Assessment, March 18". Institute for the Study of War. 18 March 2022. Retrieved 19 March 2022.
 "Russia says first phase of Ukraine operation mostly complete, focus now on Donbass". Yahoo! Finance. 25 March 2022. Retrieved 28 March 2022.
 "На Київщині ЗСУ звільнили 15 населених пунктів – зведення Генерального штабу". Радіо Свобода. 1 April 2022. Retrieved 3 April 2022.
 "Росіяни контролюють Ізюм – Генштаб ЗСУ". Український мілітарний центр. 1 April 2022. Retrieved 3 April 2022.
 Hewson, Jack; Ram, Ed; Frantsev, Dmitri (30 March 2022). "Civilians endure intense suffering as Russian shelling reduces Kharkiv to 'a smoking ruin'". PBS NewsHour. Retrieved 1 April 2022.
 "Russia alleges Ukrainian helicopters struck Belgorod fuel depot". Al Jazeera. 1 April 2022. Retrieved 6 April 2022.
 "War in Ukraine: Russia accuses Ukraine of attacking oil depot". BBC News. 1 April 2022. Retrieved 6 April 2022.
 Picheta, Rob (6 April 2022). "The fight for Sloviansk may be 'the next pivotal battle' of Russia's war in Ukraine". CNN. Retrieved 15 April 2022.
 "Ukraine war: Mariupol defenders will fight to the end". Radio New Zealand. 17 April 2022. Retrieved 20 April 2022.
 "Russia bombards Kharkiv but Ukrainians having 'tactical successes', says Zelenskiy". The Guardian. 30 April 2022.
 "US official briefs on Russia's war effort". BBC. 2 May 2022.
 Cherkasov, Alexander (26 June 2022). "Люди, стрелявшие в наших отцов". Novaya Gazeta.
 Laizans, Janis; Piper, Elizabeth (8 April 2022). "Ukraine and allies blame Russia for strike on station that killed over 50". Reuters. Kyiv. Archived from the original on 7 April 2022. Retrieved 8 April 2022.
 Tebor, Celina; Lee, Ella (8 April 2022). "'An evil without limits': Dozens killed, injured in rocket strike on train station in eastern Ukraine: Live updates". USA Today. Retrieved 8 April 2022.
 "Live Updates / Tens of thousands feared dead in Mariupol". NBC News. 11 April 2022. Retrieved 15 April 2022.
 Bacon, John; Mansfield, Erin; Wadington, Katie; Santucci, Jeanine; Vanden Brook, Tom; Tebor, Celina (10 April 2022). "EU to consider Ukraine membership in weeks; Russia warns of 'direct military confrontation' with US: April 10 recap". USA Today. Archived from the original on 10 April 2022. Retrieved 28 May 2022.
 Telford, Taylor; Timsit, Annabelle; Pietsch, Bryan; Duplain, Julian (10 April 2022). "As war enters bloody new phase, Ukraine again calls for more weapons". The Washington Post. Archived from the original on 11 April 2022. Retrieved 23 May 2022.
 Saric, Ivana (10 April 2022). "Satellite images: Russian military convoy heads south toward Donbas region". Axios.
 Chaturvedi, Amit, ed. (14 April 2022). "Ukraine Military Claims It Blew Up A Bridge Destroying Russian Convoy". NDTV. Retrieved 20 April 2022.
 "Ukraine says 'Battle of Donbas' has begun, Russia pushing in east". Reuters. 18 April 2022. Archived from the original on 18 April 2022. Retrieved 23 May 2022.
 Axe, David (5 May 2022). "The Ukrainian Army Is On The Attack. This Is How The War With Russia Could End". Forbes. Retrieved 26 May 2022.
 Sommerville, Quentin (11 May 2022). "Ukraine war: Russia pushed back from Kharkiv — report from front line". BBC. Archived from the original on 11 May 2022. Retrieved 27 May 2022.
 Murphy, Matt (23 May 2022). "Ukraine war: Russian assault on key Donbas city intensifies". BBC. Archived from the original on 23 May 2022. Retrieved 26 May 2022.
 "Russia seeking to capture Ukraine's Lyman: separatist leader". The Australian. News Corp Australia. 25 May 2022. ISSN 1038-8761. Archived from the original on 26 May 2022. Retrieved 15 June 2022.
 "Russian forces have 'upper hand' in Donbas fighting, Ukrainian officials say". TheGuardian.com. 26 May 2022.
 Markic, Igor. "Ucraina, Belgorod sotto attacco, ma i Russi stringono la morsa su Severodonetsk". Rivista Italiana Difesa (in Italian). Coop Giornalistica La Riviera. Retrieved 22 May 2022.
 "Donetsk region: occupying forces capture Svitlodarsk". Yahoo News. Retrieved 24 May 2022.
 "Russian troops enter outskirts of key city in eastern Ukraine's Donbas". NBC News. 30 May 2022. Retrieved 2 June 2022.
 Thebault, Reis; Iati, Marisa; Timsit, Annabelle; Suliman, Adela; Pietsch, Bryan; Pannett, Rachel (2 June 2022). "Russia, U.S. trade barbs over weapons pledge; Severodonetsk on the brink". The Washington Post. Retrieved 5 June 2022.
 "Russia 'suffering huge casualties' as troops retreat: Ukraine". Al Jazeera. 4 June 2022. Retrieved 5 June 2022.
 "Kremlin orders army commander Dvornikov to take Severodonetsk by June 10 — regional governor". Yahoo.com. The New Voice of Ukraine. 5 June 2022.
 "Ukraine war: Chemical plant hit as fighting rages in Severodonetsk". BBC News. June 12, 2022. [3]
 "Ukraine Allies Ponder Options As Cities Falter." By Thomas Gibbons-Neff. The NY Times. June 13, 2022. Page 1.
 UPI. JUNE 20, 2022. "Russian troops capture key suburb near Severodonetsk after months of battle." By Clyde Hughes. [4]
 "Ukraine to withdraw from key city of Severodonetsk as Russia’s advance grinds on". By Joshua Berlinger and Tim Lister. CNN. June 24, 2022. [5]
 Hubenko, Dmytro (22 April 2022). "Russia eyes route to Trans-Dniester: What do we know?". Deutsche Welle.
 "Russia plans to seize Donbas, southern Ukraine: Military official". Al Jazeera. 22 April 2022.
 Gotev, Georgi (22 April 2022). "Russian general says Moscow aim is to leave Ukraine as a landlocked country". EURACTIV.com. Reuters.
 The Jerusalem Post staff (24 April 2022). "Russia renews Mariupol attack, missiles hit Odesa". The Jerusalem Post. Reuters.
 Petrenko, Roman (26 April 2022). "New explosions in Transnistria: antennas broadcasting Russian radio channel destroyed". Ukrainian Pravda.
 Al-Arshani, Sarah (30 April 2022). "A Russian missile strike damaged the runway of an airport in Odesa, rendering it unusable, Ukraine says". Yahoo News.
 Latschan, Thomas (14 May 2022). "Ukraine and Russia fight intense battles for Snake Island". Deutsche Welle. Retrieved 2 June 2022.
 Cojan, Liviu, ed. (10 April 2022). "Dnipro airport in eastern Ukraine "completely destroyed" by new Russian military bombing: "And missiles continue to fly"". Tylaz. Retrieved 15 April 2022.
 "Russian rockets destroy airport in Ukrainian city of Dnipro". Al Jazeera. 10 April 2022. Retrieved 15 April 2022.
 Rai, Arpan; Bancroft, Holly (2 May 2022). "Mariupol steelworks shelling resumes as doctors describe dire bunker conditions". Yahoo! News. Retrieved 2 June 2022.
 Harding, Luke; Koshiw, Isobel; McKernan, Bethan (13 April 2022). "Last marines defending Mariupol 'running out of ammunition'". The Guardian. Retrieved 15 April 2022.
 "Ukraine war: Mariupol defenders will fight to the end". Radio New Zealand News. 17 April 2022.
 Schreck, Adam (21 April 2022). "Putin claims victory in Mariupol despite steel-mill holdouts". Associated Press. Associated Press.
 Prentice, Alessandra (28 April 2022). "U.N. chief Guterres calls for escape route from Mariupol 'apocalypse'". Reuters. Kyiv. Archived from the original on 29 April 2022. Retrieved 24 May 2022.
 "Civilians flee Azovstal bunkers in evacuation led by U.N." Reuters. 1 May 2022.
 "Russia shells Mariupol plant with civilians still reported trapped". Reuters. 3 May 2022. Archived from the original on 6 May 2022. Retrieved 9 May 2022.
 Vasilyeva, Nataliya (5 May 2022). "Ukraine loses contact with Azovstal defenders as Russian troops storm steelworks". The Daily Telegraph.
 "'All' civilians have been evacuated from a besieged steel plant in Mariupol". NPR. 7 May 2022. Retrieved 2 June 2022.
 Koshiw, Isobel (8 May 2022). "'Surrender is not an option': Azov battalion commander in plea for help to escape Mariupol". The Guardian.
 Petrenko, Roman (8 May 2022). "Mariupol defenders tell how the commander of marines fled the city". Retrieved 2 June 2022.
 Krasnolutska, Daryna; Champion, Marc (8 May 2022). "Mariupol Steel Plant's 'Dead Men' Defenders Call for Rescue Plan". Bloomberg News. Retrieved 2 June 2022.
 Hopkins, Valerie; Nechepurenko, Ivan; Santora, Marc (16 May 2022). "Ukrainian authorities declare an end to the combat mission in Mariupol after weeks of Russian siege". The New York Times. ISSN 0362-4331. Archived from the original on 16 May 2022. Retrieved 16 May 2022.
 Virginia Harrison and agencies (17 May 2022). "Hundreds of Ukrainian troops evacuated from Mariupol steelworks after 82-day assault: Blow for Ukraine as removal of soldiers, many wounded, suggests city that became symbol of resistance has fallen into Russian hands". The Guardian. Retrieved 17 May 2022.
 "Azovstal siege ends as hundreds of Ukrainian fighters surrender". Reuters. Mariupol. 17 May 2022. Archived from the original on 17 May 2022. Retrieved 17 May 2022.
 "Russia strikes Ukraine army base near Poland as it widens attacks". Al Jazeera. 14 March 2022. Retrieved 19 March 2022.
 Lister, Tim; Tawfeeq, Mohammed; Voitovych, Olga; McCarthy, Simone; John, Tara (13 March 2022). "Dozens killed as Russian forces strike targets in western Ukraine". CNN. Retrieved 19 March 2022.
 Zadorozhnyy, Petro; Kesaieva, Yulia; Tawfeeq, Mohammed; Federico-O'Murchú, Seán; Renton, Adam; Qiblawi, Tamara (18 March 2022). "Russia has attacked Lviv. Here's why the western city is so important to Ukraine's defense". CNN. Retrieved 19 March 2022.
 Mogul, Rhea; Yeung, Jessie; Woodyatt, Amy; Grez, Matias; Upright, Ed (16 May 2022). "Live updates: Russia's war in Ukraine". CNN. Retrieved 16 May 2022.
 "Ukraine: Video appears to show aftermath of missile strike on air base in Chuhuiv". Sky News. 24 February 2022. Retrieved 6 April 2022.
 Sheetz, Michael (24 February 2022). "Satellite imagery shows Russian attack on Ukraine from space". CNBC. Retrieved 8 March 2022.
 "Airport in central Ukraine reportedly targeted by missile fired from Belarus". The Times of Israel. Archived from the original on 27 February 2022. Retrieved 28 February 2022.
 @KyivIndependent (28 February 2022). "Russia used Iskander missile systems to attack Zhytomyr Airport. The air strikes were conducted from Belarus, using Russian ballistic missile launchers. Earlier, Belarus said it wouldn't allow air strikes from its territory amid Ukraine's upcoming peace talks with Russia" (Tweet). Archived from the original on 5 March 2022. Retrieved 8 March 2022 – via Twitter.
 Beale, Jonathan (14 April 2022). "Ukraine's battle for control of its skies". BBC News. Retrieved 19 April 2022.
 Bronk, Justin (28 February 2022). "The Mysterious Case of the Missing Russian Air Force". Royal United Services Institute. Retrieved 2 June 2022.
 Liebermann, Oren (13 May 2022). "US defense secretary speaks with Russian counterpart for first time since Russia invaded Ukraine". CNN. Retrieved 15 May 2022.
 Trevithick, Joseph. "The Russian Air Force Just Had A Terrible Day Over Ukraine". The Drive. Retrieved 5 March 2022.
 "Enemy loses 88 aircraft, helicopters in Ukraine – General Staff". Interfax-Ukraine. Retrieved 9 March 2022.
 Ali, Idrees; Stewart, Phil (7 March 2022). "Putin has deployed nearly 100% of pre-staged forces into Ukraine- U.S. Official". Reuters. Washington, D.C. Archived from the original on 7 March 2022. Retrieved 28 May 2022.
 Bronk, Justin (24 March 2022). "Analysis: Russia falls back on urban siege warfare in Ukraine". Al Jazeera. Retrieved 24 March 2022.
 Sheerin, Jude, ed. (18 March 2022). "How much of Ukraine's air force is still operational?". BBC News. Retrieved 19 April 2022.
 "Russian Jets Flying 200 Sorties a Day, But Firing from Their Own Airspace, Pentagon Says". Defense One. 11 March 2022.
 "Russia strikes Ukraine army base near Poland as it widens attacks". Al Jazeera. 13 March 2022. Retrieved 14 March 2022.
 Lister, Tim; Tawfeeq, Mohammed; Voitovych, Olga; McCarthy, Simone; John, Tara (13 March 2022). "Dozens killed as Russian forces strike targets in western Ukraine". CNN. Retrieved 14 March 2022.
 "The curious case of Russia's missing air force". The Economist. 3 March 2022. Retrieved 9 March 2022.
 Axe, David (5 May 2022). "The Ukrainian Army Is On The Attack. This Is How The War With Russia Could End". Forbes.
 Corfield, Gareth (19 June 2022). "How Ukraine gave Putin a bloody nose – and rewrote the future of air power". The Telegraph.
 "Turkey to implement pact limiting Russian warships to Black Sea". Reuters. 28 February 2022. Retrieved 17 March 2022.
 Tavsan, Sinan (2 March 2022). "Turkey rejects Russia's request for navy ships to pass Bosporus". Nikkei Asia. Retrieved 17 March 2022.
 "Russia cancelled Black Sea passage bid of four warships: Turkey". Al Jazeera. 2 March 2022. Retrieved 29 March 2022.
 @PokiRae_ (25 February 2022). "Ukrainian soldier deployed on Snake Island live streamed the moment a Russian warship opened fire on the Island. All 13 soldiers lost their lives" (Tweet). Archived from the original on 25 February 2022. Retrieved 25 February 2022 – via Twitter.[non-primary source needed]
 "Russian Navy Captures Ukraine's Outpost on Snake Island". The Maritime Executive. 24 February 2022. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 Lister, Tim; Pennington, Josh (24 February 2022). "February 24, 2022 Russia-Ukraine news". CNN. Entry: Audio emerges appearing to be of Ukrainian fighters defending island from Russian warship. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 "Русский корабль, иди на х.й!": захисники Зміїного відповіли ворогові ['Russian ship, go on f.y!': Defenders of the Serpent responded to the enemy]. Ukrayinska Pravda (in Ukrainian). Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 Visontay, Elias (25 February 2022). "Ukraine soldiers told Russian officer 'go fuck yourself' before they died on island". The Guardian. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 Hodge, Nathan; Cotovio, Vasco; Lieberman, Oren (26 February 2022). "Pentagon denies Russia's claim that it's "highly likely" US used surveillance drones to help Ukrainian navy". CNN. Archived from the original on 27 February 2022.
 Фрегат України "Гетьман Сагайдачний" виведений з ладу [The frigate of Ukraine "Hetman Sagaidachny" is out of order]. Armed Forces of Ukraine (in Ukrainian). 4 March 2022. Retrieved 28 March 2022.
 "Hetman Sahaidachny frigate, being under repair, flooded not to get to enemy – Reznikov". Interfax Ukraine. Retrieved 4 March 2022.
 Evans, Michael (4 March 2022). "Ukraine scuttles its flagship frigate as Russians close in". The Times. Retrieved 4 March 2022.
 Evans, Michael. "Ukraine scuttles its flagship frigate as the Russians close in". The Times. Retrieved 4 March 2022.
 "Analysis: Russian Armed Forces capture dozen Ukrainian ships in Berdyansk". Navy Recognition. 14 March 2022. Retrieved 18 March 2022.
 Polityuk, Pavel; Heritage, Timothy (24 March 2022). Heavens, Andrew (ed.). "Ukraine says it has destroyed a large Russian landing ship". Reuters. Retrieved 24 March 2022.
 Saul, Jonathan (12 March 2022). "UN to work on safe corridor for ships stranded by Ukraine conflict". Reuters. Retrieved 22 May 2022.
 Pedrozo, Raul (12 April 2022). "Ukraine Symposium – Maritime Exclusion Zones in Armed Conflicts". West Point. United States Military Academy. Retrieved 22 May 2022.
 "Communication from the Government of the Russian Federation" (PDF). Mission of the Russian Federation to the IMO. International Maritime Organization. 28 March 2022. Circular Letter No.4543. Retrieved 8 June 2022.
 "Maritime Security and Safety in the Black Sea and Sea of Azov". International Maritime Organization. Retrieved 22 May 2022.
 "Russia-Ukraine war latest: Ukraine PM to head to Washington; Russian warship sunk by Ukraine missile strike, say US officials – live". The Guardian. 16 April 2022. ISSN 0261-3077. Retrieved 16 April 2022.
 "Russia confirms severe damage to Black Sea Fleet Flagship Moskva, Crew Abandoned Ship". Free Press Journal. 14 April 2022. Retrieved 14 April 2022.
 Forgey, Quint. "Pentagon confirms explosion aboard Russian warship". Politico. Retrieved 14 April 2022.
 "Russian warship Moskva has sunk – state media". BBC News. 14 April 2022. Retrieved 14 April 2022.
 Polityuk, Pavel; Piper, Elizabeth (15 April 2022). "Ukraine says fighting rages in Mariupol, blasts rattle Kyiv". Reuters.
 "Ukrainian Military Says Drone Destroys Russian Landing Craft Near Snake Island In Black Sea". RadioFreeEurope/RadioLiberty.
 "Russian landing craft in Black Sea's Snake Island sunk in drone strike, claims Ukraine". WION News. 7 May 2022. Retrieved 7 May 2022.
 Payne, Stetson (7 May 2022), Ukraine Strikes Back: Su-27s Bomb Occupied Snake Island In Daring Raid, The Drive, retrieved 8 May 2022
 "Lavrov said Russians would let through ships carrying grain if Ukraine demined ports". Yahoo. 31 May 2022. Retrieved 1 June 2022.
 Sanger, David E.; Barnes, Julian E. (14 April 2022). "C.I.A. Director Airs Concern That Putin Might Turn to Nuclear Weapons". The New York Times. Washington, D.C. Archived from the original on 14 April 2022. Retrieved 28 May 2022.
 "Russia to deploy new intercontinental nuclear missiles by autumn". Al Jazeera. 23 April 2022.
 "Russia's Lavrov Warns of 'Real' Danger of World War III". The Moscow Times. 25 April 2022.
 Ellyatt, Holly; Turak, Natasha; Macias, Amanda (26 April 2022). "Pentagon chief calls Russia nuclear rhetoric 'dangerous'; U.S. to send diplomats back to Ukraine". CNBC.
 O'Neil, Tyler (27 April 2022). "Zelenskyy demands 'global control' over Russia's nuclear capabilities after 'completely irresponsible actions'".
 Wolfgang, Ben (27 April 2022). "Angry Putin wields energy, nuclear threats against West". Washington Times.
 "Pentagon press secretary John Kirby holds a news briefing". PBS News Hour. 27 April 2022.
 "Hearing on Nuclear Readiness Amid Russia-Ukraine War". C-SPAN. 4 May 2022. Retrieved 2 June 2022.
 "Russian will not use nuclear weapons in Ukraine, foreign ministry says". Reuters. 6 May 2022. Retrieved 2 June 2022.
 Keaten, Jamey (23 May 2022). "'Never have I been so ashamed': Russian envoy criticizes war". Associated Press. Davos. Retrieved 11 June 2022.
 "Russia won't use tactical nuclear weapons in Ukraine, says ambassador to UK". BBC News. 29 May 2022. Retrieved 2 June 2022.
 "Japan vows bigger security role in region to tackle threats". By MARI YAMAGUCHI and SYAWALLUDIN ZAIN – Associated Press. January 10, 2022. [6]
 "Japan PM Kishida eyes attending NPT review conference in August". KYODO NEWS. June 10, 2022. [7]
 "Conference on catastrophic effects of nuclear arms to open in Vienna". June 19, 2022. NHK World News. [8]
 Raghavan, Sudarsan; O'Grady, Siobhán; Shefte, Whitney; Khudov, Kostiantyn (28 February 2022). "In a Kyiv under siege, neighbors dig trenches and raise barriers to brace for Russian assault". The Washington Post. Kyiv. ISSN 0190-8286. OCLC 2269358. Archived from the original on 1 March 2022. Retrieved 30 May 2022.
 Kirby, Jen (3 March 2022). "The other members of Ukraine's resistance". Vox. Retrieved 10 March 2022.
 Hunter, Daniel (1 March 2022). "How Ukrainian Civilians Are Resisting Military Force". YES! Magazine. Retrieved 8 March 2022.
 Motyl, Alexander J. (12 April 2022). "Russians Likely to Encounter Growing Guerrilla Warfare in Ukraine". Foreign Policy. Retrieved 13 April 2022.
 "Ukrainian Civilians Take On Russian Invaders With Words And Deeds". Radio Free Europe/Radio Liberty. 28 February 2022. Retrieved 8 March 2022.
 Schwirtz, Michael; Santora, Marc; Hill, Evan; Cardia, Alexander (5 March 2022). "Ukrainian protesters take to the streets in occupied Kherson". The New York Times. ISSN 1553-8095. OCLC 1645522. Archived from the original on 5 March 2022. Retrieved 8 March 2022.
 "Ukrainian authorities accuse Russians of opening fire on civilian protest". CNN International. 5 March 2022. Retrieved 8 March 2022.
 "Ordinary Ukrainians are resisting Vladimir Putin's occupying force in Kherson and elsewhere". The Economist. 9 March 2022. Retrieved 10 March 2022.
 Judah, Tim (10 April 2022). "How Kyiv was saved by Ukrainian ingenuity as well as Russian blunders". Financial Times.
 "Zelensky: 700,000 soldiers defending Ukraine now". The Kyiv Independent. 21 May 2022. Retrieved 2 June 2022.
 Hopkins, Valerie (28 February 2022). "Initial talks between Russia and Ukraine yield no resolution". The New York Times. ISSN 0362-4331. Archived from the original on 14 March 2022. Retrieved 16 March 2022.
 Reevell, Patrick; Hutchinson, Bill (2 March 2022). "2nd round of talks between Russia and Ukraine end with no cease-fire". ABC News. Archived from the original on 14 March 2022. Retrieved 15 March 2022.
 "Ukraine and Russia hold third round of talks". Deutsche Welle. Reuters, Agence France-Presse, Deutsche Presse-Agentur. 7 March 2022. Archived from the original on 14 March 2022. Retrieved 15 March 2022.
 Roshchina, Olena (28 February 2022). Переговори делегацій України та Росії почалися [Negotiations between the delegations of Ukraine and Russia began]. Українська правда [Ukrayinska Pravda] (in Ukrainian). Archived from the original on 14 March 2022. Retrieved 7 March 2022. Деталі: Переговори відбуваються на Гомельщині на березі річки Прип'ять. Із міркувань безпеки точне місце організатори переговорів не називають. [Details: Negotiations are taking place in the Gomel region on the banks of the Pripyat River. For security reasons, the organisers of the talks did not name the exact location.]
 Tanner, Jari (12 May 2022). "Finland's leaders call for NATO membership 'without delay'". Associated Press. Retrieved 2 June 2022.
 "Military assistance to Ukraine" (PDF). House of Commons Library. 25 February 2022. Retrieved 4 March 2022.
 "Turkey, Ukraine sign military cooperation agreements". ABC News. 17 October 2020. Retrieved 12 March 2022.
 Brennan, Margaret; Watson, Eleanor (20 January 2022). "U.S. and NATO to surge lethal weaponry to Ukraine to help shore up defenses against Russia". CBS News. Archived from the original on 27 February 2022.
 Ripley, Tim (18 January 2022). "UK supplies anti-tank weapons to Ukraine". Janes Information Services. Retrieved 16 March 2022.
 "Germany to ship anti-aircraft missiles to Ukraine — reports". Deutsche Welle. 3 March 2022.
 "Defence Secretary statement to the House of Commons on Ukraine: 9 March 2022". GOV.UK. Retrieved 12 March 2022.
 Chalmers, John (24 February 2022). "NATO has no plans to send troops into Ukraine, Stoltenberg says". Reuters.
 Dimsdale, Connie (25 February 2022). "How the response to Russia's invasion would be different if Ukraine was a Nato member". i.
 Bond, Ian (22 February 2022). "The west knows the cost of appeasement. We can't rule out any option for stopping Putin". The Guardian. Retrieved 5 March 2022.
 Lewis, Simon; Melander, Ingrid (4 March 2022). "NATO rejects Ukraine no-fly zone, unhappy Zelenskiy says this means more bombing". Reuters. Retrieved 5 March 2022.
 Vogt, Adrienne; Said-Moorhouse, Lauren; Ravindran, Jeevan; Wilkinson, Peter; Yeung, Jessie; Lendon, Brad; George, Steve; Wagner, Meg (26 February 2022). "Blinken authorizes $350 million more in US military assistance to Ukraine". CNN. Archived from the original on 27 February 2022. Retrieved 26 February 2022.
 Vogt, Adrienne; Said-Moorhouse, Lauren; Ravindran, Jeevan; Wilkinson, Peter; Yeung, Jessie; Lendon, Brad; George, Steve; Wagner, Meg (26 February 2022). "$350 million in US military assistance will include "anti-armor and anti-aircraft systems," official says". CNN. Archived from the original on 27 February 2022. Retrieved 26 February 2022.
 "EU shuts airspace to Russian airlines, will buy Ukraine arms". AP News. Associated Press. 27 February 2022. Archived from the original on 1 March 2022. Retrieved 28 February 2022.
 Blenkinsop, Philip; Siebold, Sabine (27 February 2022). "EU tightens Russian sanctions and buys weapons for Ukraine". Reuters. Archived from the original on 1 March 2022.
 Schmitt, Eric (12 March 2022). "The White House approves $200 million in arms and equipment for Ukraine". The New York Times. Retrieved 23 March 2022.
 Emmott, Robin; Melander, Ingrid (17 March 2022). "NATO vows more help for Ukraine, begins planning to adapt to 'new reality'". Reuters. Retrieved 8 March 2022.
 "EU support to Ukraine: Council agrees on third tranche of support under the European Peace Facility for total €1.5 billion". 13 April 2022.
 Park, Chan-kyong (11 April 2022). "Zelensky cites Korean war in appeal to Seoul to send anti-aircraft weapons". South China Morning Post. Retrieved 15 April 2022.
 Slawson, Nicola (12 April 2022). "First Thing: Russia using weapons 'smuggled by Iran' in Ukraine". The Guardian. Retrieved 15 April 2022.
 Garzon, Elsy Fors (19 April 2022). "Romania to modify its laws to deliver weapons to Ukraine". Prensa Latina.
 "Romania is planning to hand over lethal weapons to Ukraine". «Ukrainian Military Center» Public Organization. 19 April 2022.
 Ali, Ayeza (27 April 2022). "Romanian Defense Minister Says Weapons Supplies To Ukraine Not On Agenda". Pakistan Point.
 Herszenhorn, David M.; Bayer, Lili (26 April 2022). "US rallies global allies to help Ukraine repel Russia". Politico. Retrieved 27 April 2022.
 "War in Ukraine: U.S. dramatically upgrades its aid package to Kyiv". Le Monde. 29 April 2022.
 "Ukraine gets over $12 billion in weapons, financial aid since start of Russian invasion- Ukraine's PM". Reuters. 5 May 2022.
 Fram, Alan (11 May 2022). "House approves $40B in Ukraine aid, beefing up Biden request". Associated Press. Archived from the original on 11 May 2022. Retrieved 28 May 2022.
 "Biden signs $40 billion aid package for Ukraine during trip to Asia". CNBC. 21 May 2022. Retrieved 31 May 2022.
 Scholtes, Jennifer; O'Brien, Connor (19 May 2022). "Senate clears $40B Ukraine aid package". Politico. Retrieved 31 May 2022.
 "Ukraine is to receive a new batch of Caesar ACS from France". «Ukrainian Military Center» Public Organization. 30 May 2022.
 "55th Brigade receives CAESAR ACS". «Ukrainian Military Center» Public Organization. 25 May 2022.
 Rushworth, Nicholas (10 June 2022). "Meet the Ukrainian forces using French-supplied Caesar howitzers". France 24. Archived from the original on 10 June 2022. Alt URL
 "Ukrainian Army Uses New Caesar Long-Range Howitzer Supplied By France". Radio Free Europe/Radio Liberty. 10 June 2022.
 "What is HIMARS? The advanced rocket system US is sending Ukraine". Al Jazeera. 1 June 2022.
 "Will US rockets for Ukraine be a game changer in the war against Russia?". Australian Broadcasting Corporation (ABC). 1 June 2022.
 "US will send HIMARS precision rockets to Ukraine". Defense News. 1 June 2022.
 Koshiw, Isobel (10 June 2022). "We're almost out of ammunition and relying on western arms, says Ukraine".
 Sand, Leo (13 June 2022). "Ukraine war: Every bridge leading to key city Severodonetsk destroyed". BBC.com. Retrieved 14 June 2022.
 Rathbone, John Paul; Olearchyk, Roman (13 June 2022). "Military briefing: which weapons has Ukraine received and how many more does it need?". ft.com. Retrieved 14 June 2022.
 "Why western weapons aren't reaching Ukrainian troops". DW News. YouTube. 13 June 2022.
 LeBlanc, Paul (28 February 2022). "Why the US isn't sending troops into Ukraine". CNN. Retrieved 20 April 2022.
 Timsit, Annabelle; Taylor, Adam; Cheng, Amy (1 March 2022). "Ukraine is asking foreigners to help fight Russia. Some are heeding the call, despite enormous risks". The Washington Post. Retrieved 12 March 2022.
 Abend, Lisa (7 March 2022). "Meet the Foreign Fighters Risking Their Lives in Ukraine". Time. Retrieved 9 March 2022.
 Bilefsky, Dan; Hopkins, Valerie (9 June 2022). "3 Foreign Fighters in Ukraine's Army Sentenced to Death in Russian-Held Territory". The New York Times. ISSN 1553-8095. OCLC 1645522. Archived from the original on 9 June 2022. Retrieved 20 June 2022.
 "Britons, Moroccan sentenced to death in separatist-held Ukraine". Aljazeera.com. Al Jazeera Media Network. 9 June 2022. Archived from the original on 9 June 2022. Retrieved 20 June 2022.
 Lemon, Jason (3 March 2022). "Russia Vows Prosecution of Foreign Fighters After 16K Join Ukraine". Newsweek. Retrieved 4 March 2022.
 "Ukraine war: Putin seeks foreign volunteers to fight in Ukraine". BBC News. 11 March 2022. Retrieved 13 March 2022.
 Ball, Tom (11 March 2022). "African fighters prepare to join Russian troops". The Times. Retrieved 14 March 2022.
 "Did US intelligence-sharing with Ukraine cross a line?". Deutsche Welle. 14 May 2022.
 "US intelligence helped Ukraine sink Russia's flagship cruiser Moskva". Australian Broadcasting Corporation. 6 May 2022.
 "National Police Chief: 1,200 bodies of dead Ukrainians not yet identified". Interfax-Ukraine.
 Saidel, Peter (23 May 2022). "Number of Civilian Deaths Confirmed by Ukraine Reaches 4,600". The Wall Street Journal. News Corp. Retrieved 2 June 2022.
 "Обзор социально-гуманитарной ситуации, сложившейся на территории Донецкой Народной Республики вследствие военных действий в период с 18 по 24 июня 2022 г." [Overview of the social and humanitarian situation that has developed on the territory of the Donetsk People's Republic as a result of military operations in the period from June 18 to June 24, 2022] (in Russian).
 "The overview of the current social and humanitarian situation in the territory of the Donetsk People's Republic as a result of hostilities in the period from 19 and 25 February 2022". Human Rights Ombudsman in the Donetsk People's Republic. 12 February 2022. Retrieved 21 March 2022.
 "61 LPR residents killed in Ukrainian army strikes since February 17 - JCCC". Lugansk Media Centre. 23 June 2022. Retrieved 23 June 2022.
 "Ukraine: civilian casualty update 27 June 2022". Office of the United Nations High Commissioner for Human Rights. 27 June 2022. Retrieved 27 June 2022.
 "Russian Defense Ministry to publish data on military deaths from Ukrainian documents". TASS. 16 April 2022. Retrieved 20 April 2022.
 Gibbons-Neff, Thomas; Schwirtz, Michael (19 April 2022). "Russia's Thrust in Eastern Ukraine Combines Firepower and New Caution". The New York Times. Retrieved 19 April 2022.
 "10,000 Ukrainian soldiers killed, Kyiv says". BBC News. 11 June 2022. Retrieved 11 June 2022.
 "Ukraine lost about 10,000 soldiers in war with Russia – Arestovich".
 "Tens of thousands have been killed since the invasion, says Ukrainian defense minister". 16 June 2022.
 "Із початку повномасштабного вторгнення в Україну РФ втратила близько 35 тис. осіб особового складу, 1552 танки - Генштаб ЗСУ". Interfax-Ukraine. 27 June 2022. Retrieved 27 June 2022.
 Ivshina, Olga; Prosvirova, Olga (21 March 2022). "BBC investigation reveals confirmed Russian military deaths". BBC News. Retrieved 21 March 2022. Ukrainian military sources say that so far as many as 15,000 have been killed, though this figure may include injured as well as dead.
 "ВСУ: Российские потери составляют почти 22 тысячи человек". BBC News Russian. 24 April 2022. Retrieved 24 April 2022.
 Mehta, Amar. "Ukraine war: Putin accuses West of plot to destroy Russia – and says secret service foiled attempt to kill journalist". Sky News.
 Зубкова, Даша (25 April 2022). "Russian Troops Personnel Losses On April 24 Up 100 To 21,900 Killed, Equipment By 11 Tanks And 2 Aircraft". Ukrainian News Agency.
 Что мы знаем о потерях России в Украине за четыре месяца войны
"Russian casualties in Ukraine. Mediazona count, updated". Meduza. 20 May 2022. Retrieved 20 May 2022.
 "Война в цифрах". 27 June 2022. Retrieved 27 June 2022.
 "Обзор социально-гуманитарной ситуации, сложившейся на территории Донецкой Народной Республики вследствие военных действий в период с 18 по 24 июня 2022 г." ombudsman-dnr.ru.
 Новости, Р. И. А. (5 April 2022). Буча и концентрированное зло: последний аргумент против русских [Butch and concentrated evil: the last argument against the Russians]. РИА Новости (in Russian).
 "Overview of the social and humanitarian situation that has developed on the territory of the Donetsk People's Republic as a result of military operations in the period from 2 to 8 April 2022". Human Rights Ombudsman in the Donetsk People's Republic. 8 April 2022. Retrieved 8 April 2022.
 "As Russian Troop Deaths Climb, Morale Becomes an Issue, Officials Say". The New York Times. 17 March 2022. Archived from the original on 16 March 2022. Retrieved 16 March 2022.
 Meyer, David (14 March 2022). "Why is it so hard to get accurate death tolls in the Russia-Ukraine war?". Fortune. Retrieved 21 March 2022.
 Roth, Andrew (22 March 2022). "How many Russian soldiers have died in the war in Ukraine?". The Guardian. Retrieved 22 March 2022.
 "Russia admits 'significant losses of troops' in Ukraine". 8 April 2022. Retrieved 8 April 2022.
 "Ukraine not to reveal own military death toll until war ends". www.ukrinform.net.
 "Ukraine conflict death toll: what we know". France 24. 13 April 2022. Retrieved 20 April 2022.
 Khurshudyan, Isabelle; Witte, Griff (26 February 2022). "Civilians are dying in Ukraine. But exactly how many remains a mystery". The Washington Post. Retrieved 21 March 2022.
 "Ukraine: Civilian casualties as of 24.00 15 March 2022 [EN/RU/UK] – Ukraine". ReliefWeb. 15 March 2022. Retrieved 17 March 2022.
 "Reliable death tolls from the Ukraine war are hard to come by – the result of undercounts and manipulation". The Conversation. 4 April 2022.
 Choi, Joseph (24 February 2022). "Ukrainian ambassador says Russian platoon surrendered to Ukrainian forces". The Hill. Retrieved 29 March 2022.
 "Moscow: Nearly 500 of its troops have been killed in Ukraine". WHDH. Archived from the original on 2 March 2022. Retrieved 3 March 2022.
 Abdulkerimov, Bahtiyar (20 March 2022). "Ukraine holding 562 Russian prisoners of war". Anadolu Agency. Retrieved 20 March 2022.
 "Ukraine, Russia Exchange Prisoners For First Time Since Invasion, Ukrainian Military Officer Says". Radio Free Europe/Radio Liberty. 1 March 2022. Retrieved 20 March 2022.
 Ljunggren, David (17 March 2022). "Ukraine swapped nine Russian soldiers to free detained mayor". Reuters. Retrieved 25 March 2022.
 "Ukraine announces first proper POWs exchange with Russia". Interfax. 24 March 2022. Retrieved 24 March 2022.
 "Today's key developments". BBC News. 24 March 2022. Retrieved 24 March 2022.
 "Some 86 Ukrainian servicemen released under exchange with Russia – President's Office dpty head". Interfax-Ukraine. 1 April 2022. Retrieved 6 April 2022.
 "Ukraine war latest: Red Cross forced to postpone evacuation of Mariupol". BBC News.
 Villarreal, Daniel (8 March 2022). "Ukraine government says Russian POWs will 'work to revive' economy". Newsweek. Retrieved 9 March 2022.
 "Prisoners of war in the Russian invasion of Ukraine must be protected". Amnesty International. 7 March 2022. Retrieved 22 March 2022.
 "Ukraine: Respect the Rights of Prisoners of War". Human Rights Watch. 16 March 2022. Retrieved 19 March 2022.
 "Ukraine promises "immediate investigation" after video surfaces of soldiers shooting Russian prisoners". CNN. 27 March 2022. Archived from the original on 28 March 2022. Retrieved 28 March 2022.
 "Does video show Russian prisoners being shot?". BBC News. 30 March 2022. Archived from the original on 31 March 2022. Retrieved 31 March 2022.
 "Ukraine: Apparent POW Abuse Would Be War Crime". Human Rights Watch. 31 March 2022. Retrieved 1 April 2022.
 Hill, Evan (6 April 2022). "Video appears to show Ukrainian troops killing captured Russian soldiers". The New York Times. ISSN 0362-4331. Retrieved 7 April 2022.
 "Video appears to show Ukrainian forces killing Russian captive". Reuters. 7 April 2022. Retrieved 15 April 2022.
 "Update on the human rights situation in Ukraine (Reporting period: 24 February – 26 March)" (PDF). United Nations Human Rights Monitoring Mission in Ukraine.
 "Protecting Ukrainian refugees: What can we learn from the response to Kosovo in the 90s?". British Future. 7 March 2022. Retrieved 29 March 2022.
 "IntelBrief: China Seeks to Balance Its Interests as Russia's War on Ukraine Intensifies". The Soufan Center. 4 March 2022. Retrieved 29 March 2022. Over a week into the Russian invasion of Ukraine, the war has raged on, spurring the most serious humanitarian crisis in Europe since the wars in the Balkans in the 1990s.
 Beaumont, Peter (6 March 2022). "Ukraine has fastest-growing refugee crisis since second world war, says UN". The Guardian. Retrieved 8 March 2022.
 Aguilera, Jasmine (25 February 2022). "Russia's Invasion of Ukraine May Trigger a Refugee Crisis. Here's How the World Is Preparing". Time. Archived from the original on 26 February 2022. Retrieved 25 February 2022.
 Michaels, Samantha (7 March 2022). "More Than 1.5 Million Refugees Have Fled Ukraine". Mother Jones. Retrieved 10 March 2022.
 "Refugees flee Ukraine for the EU, men told to stay and fight". ABC News. 26 February 2022. Retrieved 3 March 2022.
 "Ukraine". IDMC. Retrieved 15 May 2022.
 "Ukraine war latest: Our neighbours want us dead, Zelensky tells Israeli MPs". BBC News. Retrieved 20 March 2022.
 "Russia hits Ukraine fuel supplies, airfields in new attacks". Associated Press. 27 February 2022. Archived from the original on 27 February 2022. Retrieved 27 February 2022.
 "Why banning men from leaving Ukraine violates their human rights". The Conversation. 8 March 2022.
 Tondo, Lorenzo (9 March 2022). "Ukraine urged to take 'humane' approach as men try to flee war". The Guardian. Retrieved 9 March 2022.
 Men, some in their teens, join Ukraine's resistance fighters | DW News. DW News. 5 March 2022. Archived from the original on 6 March 2022. Retrieved 8 March 2022 – via YouTube.
 "Situation Ukraine Refugee Situation". data2.unhcr.org. UNHCR. Retrieved 15 May 2022.
 "How the Czech Republic's Vietnamese community is rallying for refugees". euronews. 6 April 2022. Retrieved 15 May 2022.
 "Over 20,000 Ukrainians arrive in Turkey, says top official". Hürriyet Daily News. 8 March 2022. Retrieved 24 March 2022.
 "İçişleri Bakanı Soylu: 58 bin Ukraynalı savaş sonrası Türkiye'ye geldi" [Interior Minister Soylu: 58 thousand Ukrainians came to Turkey after the war] (in Turkish). BBC. 22 March 2022. Retrieved 24 March 2022.
 "How many refugees have fled Ukraine and where are they going?". BBC News. 30 March 2022. Retrieved 15 April 2022.
 Peter, Laurence (27 March 2022). "Russia transfers thousands of Mariupol civilians to its territory". BBC News. Retrieved 1 April 2022.
 Mackintosh, Eliza; Ochman, Oleksandra; Mezzofiore, Gianluca; Polglase, Katie; Rebane, Teele; Graham-Yooll, Anastasia (8 April 2022). "Russia or die: After weeks under Putin's bombs, these Ukrainians were given only one way out". CNN. Retrieved 9 April 2022.
Бутченко, Максим (15 April 2022). "В духе Сталина. Фильтрационные лагеря, допросы и вывоз в глушь — как Москва насильно депортирует украинцев Донбасса" [In the spirit of Stalin. Filtration camps, interrogations and removal into the wilderness – how Moscow forcibly deports Ukrainians from Donbass]. NV.ua (in Russian). Retrieved 20 April 2022.
Шаповал, Валентина (18 April 2022). "Денисова: оккупанты держат в фильтрационных лагерях РФ более 20 000 мариупольцев" [Denisov: occupiers keep more than 20,000 Mariupol residents in filtration camps of the Russian Federation]. Segodnya (in Russian). Retrieved 20 April 2022.
Горичева, Юлия; Тохмахчи, Анна (11 April 2022). ""Раздевали, татушки мои смотрели". Артем уехал из Мариуполя в "ДНР", а потом и из России. Он рассказывает о том, что происходило на границах" ["They undressed, they looked at my tattoos." Artem left Mariupol for the "DPR", and then from Russia. He talks about what happened at the borders]. Current Time TV (in Russian). Retrieved 20 April 2022.
Ганюкова, Ольга (10 April 2022). "Оккупанты создали в России лагерь для депортированных из Украины: там содержат более 400 человек" [The occupiers created a camp in Russia for deportees from Ukraine: more than 400 people are kept there]. Obozrevatel (in Russian). Retrieved 20 April 2022.
Курпита, Татьяна (17 April 2022). ""Не имели одежды, еды и предметов гигиены": в России обнаружили три лагеря для депортированных мариупольцев" [“They didn’t have clothes, food and hygiene items”: three camps for deported Mariupol residents were found in Russia]. TSN (in Russian). Retrieved 20 April 2022.
Пилипенко, Евгений (24 March 2022). "Россия создала близ Донецка фильтрационный лагерь для украинцев – разведка" [Russia has created a filtration camp for Ukrainians near Donetsk – intelligence]. LIGA.net (in Russian). Retrieved 20 April 2022.
Климов, Александр (5 April 2022). "В Харьковской области оккупанты создают фильтрационные лагеря — Денисова" [Invaders create filtration camps in Kharkiv region – Denisova]. NV.ua (in Russian). Retrieved 20 April 2022.
Ball, Tom (20 March 2022). "Ukraine accuses Russia of killing 56 care home residents in Luhansk". The Times. Retrieved 20 April 2022.
"ФОТО. Оккупанты строят фильтрационные лагеря для украинцев" [A PHOTO. Occupiers build filtration camps for Ukrainians]. sport.ua (in Russian). 28 March 2022. Retrieved 20 April 2022.
 Куприянова, Ольга (24 March 2022). "Фильтрационные лагеря и трудоустройство на Сахалине: украинцев из оккупированных городов принудительно отправляют в россию" [Filtration camps and employment on Sakhalin: Ukrainians from occupied cities are forcibly sent to Russia]. 1+1 (in Russian). Retrieved 20 April 2022.
 "Путин и Шойгу планировали создать концлагеря для украинцев в Западной Сибири, – Данилов" [Putin and Shoigu planned to create concentration camps for Ukrainians in Western Siberia – Danilov]. Цензор.НЕТ (in Russian). Retrieved 25 April 2022.
 "Путин и Шойгу планировали создать концлагеря для украинцев в Западной Сибири – Данилов" [Putin and Shoigu planned to create concentration camps for Ukrainians in Western Siberia – Danilov]. LIGA (in Russian). 22 April 2022. Retrieved 25 April 2022.
 "Шойгу назвал места для строительства новых городов в Сибири" [Shoigu named places for the construction of new cities in Siberia]. РБК (in Russian).
 Bior, Ayen; Shapiro, Ari; Ozug, Matt (20 May 2022). "Millions rushed to leave Ukraine. Now the queue to return home stretches for miles". NPR. Archived from the original on 20 May 2022. Retrieved 28 May 2022.
 Bacchi, Umberto; Davydova, Angelina (4 April 2022). "Russia's war migrants find mixed reception in Georgia". The Japan Times. Retrieved 11 April 2022.
 "Who are the Russians leaving their country?". Deutsche Welle. 5 April 2022. Retrieved 11 April 2022.
 "Растет число россиян, претендующих на право временного проживания в Казахстане" [The number of Russians claiming the right of temporary residence in Kazakhstan is growing]. Radio Ozodi (in Russian). Radio Free Europe/Radio Liberty. 14 April 2022. Retrieved 21 April 2022.
 Бишкек. Жизнь по-новому [Bishkek: Life in a New Way] (in Russian). Настоящее время. Док. 6 April 2022. Retrieved 19 April 2022.
 Metz, Cade; Satariano, Adam (13 April 2022). "'Russian Tech Industry Faces 'Brain Drain' as Workers Flee". The New York Times. Retrieved 15 April 2022.
 "Russians who left their country since the invasion of Ukraine – BBC News". BBC News. 14 April 2022. Retrieved 15 April 2022 – via YouTube.
 "Georgia, a bleak new home for Russian exiles". France 24, Agence France-Presse. 8 March 2022.
 Kolotilov, Vasiliy; King, Laura (1 April 2022). "Fleeing Putin's Russia: Exiles search for new identity, but find new problems". Los Angeles Times. Retrieved 11 April 2022.
 Anna Cooban. "Russia is 'hemorrhaging' millionaires". CNN. Retrieved 15 June 2022.
 "Nearly 4M Russians Left Russia in Early 2022 – FSB". The Moscow Times.
 Ullrich, Klaus (15 March 2022). "Ukraine's economy is more than just wheat and commodities: Following independence in 1991, Ukraine's economic development was hamstrung by corruption, capital flight and a lack of reforms. Recent improvements are now being threatened by Russia's war in the country". Deutsche Welle.
 Food and Agriculture Organization of the United Nations (2022). Food Outlook – Biannual Report on Global Food Markets: November 2021. [S.l.]: Food & Agriculture Org. ISBN 978-92-5-135248-9. OCLC 1291390883.
 Lister, Tim; Fylyppov, Sanyo (5 May 2022). "Russians steal vast amounts of Ukrainian grain and equipment, threatening this year's harvest". CNN.
 "FAO Information Note: The importance of Ukraine and the Russian Federation for global agricultural markets and the risks associated with the current conflict, 25 March 2022 Update" (PDF). Food and Agriculture Organization. 25 March 2022.
 "As sanctions bite Russia, fertilizer shortage imperils world food supply". Reuters. 23 March 2022.
 "Soaring fertilizer prices put global food security at risk". Axios. 6 May 2022.
 "Russia-Ukraine war worsens fertilizer crunch, risking food supplies". NPR. 12 April 2022.
 "LDCs at a Glance | Department of Economic and Social Affairs". United Nations. Retrieved 15 April 2022.
 "FAO Country Profiles". fao.org. Retrieved 15 April 2022.
 Hildyard, Nicholas; Klemm, Josh (8 April 2022). "Weaponising water — Ukraine's dams are targets in Putin's war".
 "Russia-Flagged Ships Transport Stolen Grain to Syria, Ukraine Says". The Wall Street Journal. Retrieved 11 May 2022.
 "Ukraine says Russia stole 'several hundred thousand tonnes' of grain". Reuters. 30 April 2022. Retrieved 11 May 2022.
 Isabel van Brugen, 'Video Appears to Show Russian Convoy With Stolen Ukrainian Equipment,' Newsweek 2 May 2022
 "Ukraine says Russia is stealing grain, which could worsen food crisis". The Washington Post. 5 May 2022.
 Vasilyeva, Nataliya (30 May 2022). "Russian-controlled Kherson region in Ukraine starts grain exports to Russia – TASS". Reuters. Retrieved 30 May 2022.
 "Russian soldiers seek jobs in Kherson Oblast". Yahoo.com. 2 June 2022. Retrieved 2 June 2022.
 "The Congolese student fighting with pro-Russia separatists in Ukraine". The Guardian. London. 31 January 2018. ISSN 0261-3077. Retrieved 10 June 2022.
 "African Union chief will hold talks with Putin on Friday over food security". CNN.com. 2 June 2022. Retrieved 3 June 2022.
 "Russian Officers Killing Their Own Wounded, Say Captured Soldiers in Video". Newsweek. 16 April 2022.
 "A Russian Soldier Ran Over His Commander with a Tank in Ukraine". The Times. 25 March 2022. ISSN 0140-0460.
 "Russian troops reportedly deliberately wounding themselves to avoid fighting war". News.com.au. 17 May 2022. Retrieved 17 May 2022.
 Nerozzi, Timothy (27 May 2022). "Russian court confirms 115 Russian servicemen refusing to join invading forces against Ukraine". Fox News. Retrieved 27 May 2022.
 "Russia to covertly mobilize reserves, conscript Chechen convicts - GUR". The Jerusalem Post. Retrieved 20 June 2022.
 "Russian mum's fight to save sons from Putin's war". BBC. 26 May 2022. Retrieved 27 May 2022.
 "Russian war dead soldiers bodies". Washington Post. 8 April 2022. Retrieved 2 June 2022.
 "The Russian soldiers refusing to fight in Ukraine". BBC.com. 2 June 2022. Retrieved 3 June 2022.
 "Exhausted Russian fighters complain of conditions in eastern Ukraine". The Guardian.com. 8 June 2022. Retrieved 8 June 2022.
 "UK military intelligence: Multiple factors driving low morale among Russian forces in Ukraine". yahoo.com. 20 June 2022. Retrieved 20 June 2022.
 "Half Russian separatist force dead or wounded - UK". www.bbc.com. 22 June 2022. Retrieved 22 June 2022.
 Mullins, Charlotte (27 May 2022). "'Ukraine's heritage is under direct attack': why Russia is looting the country's museums". The Guardian. Retrieved 2 June 2022.
 "Russian attack destroys ancient monastery in Ukraine: Zelenskyy".
 "Russian artillery hits monastery in Ukraine's east, says Zelenskiy". Reuters. 4 June 2022.
 "Tchaikovsky's house destroyed by Russian army in north-east Ukraine".
 Levy, Max G. (16 March 2022). "The War in Ukraine Is a Reproductive Health Crisis for Millions". Wired. ISSN 1078-3148. Archived from the original on 16 March 2022. Retrieved 29 May 2022.
 "The Nightmare of Being a Surrogate Mother in the Ukraine War". The New York Times magazine. 3 May 2022. Retrieved 28 May 2022.
 Campoamor, Danielle. "Ukrainian Doctor Trying To Keep 19,000 Embryos Viable During". Today.com. Retrieved 28 May 2022.
 "Black Sea dolphins are being killed by military sonars, researchers say". CNN. 3 June 2022. Retrieved 4 June 2022.
 "First Russian passports issued in occupied areas of Ukraine". www.BBCcom. Retrieved 11 June 2022.
 "EU adopts new set of measures to respond to Russia's military aggression against Ukraine". Europa (web portal).
 "EU imposes sanctions on state-owned outlets RT/Russia Today and Sputnik's broadcasting in the EU". Europa (web portal).
 Timsit, Annabelle; Simon, Maite Fernández (2 March 2022). "Russia boycott: A list of global campaigns that are underway in support of Ukraine". The Washington Post. ISSN 0190-8286. OCLC 2269358. Archived from the original on 5 March 2022. Retrieved 4 March 2022.
 "How Indians fleeing Ukraine ran into racism". The Times of India. 2 March 2022. Archived from the original on 26 March 2022. Retrieved 26 March 2022.
 Tobore Ovuorie (9 April 2022). "Ukraine war: African students face Russian missiles and racism". Deutsche Welle. Retrieved 2 May 2022.
 "Ukraine attention shows bias against black lives, WHO chief says". BBC News. 13 April 2022. Retrieved 2 May 2022.
 Burakovsky, Arik (3 March 2022). "Putin's Invasion of Ukraine Has Sparked Antiwar Protests in Russia. They Could Be His Undoing". Time. ISSN 0040-781X. OCLC 1311479. Archived from the original on 3 March 2022. Retrieved 4 March 2022.
 "Russia's anti-war lobby goes online". France 24. 26 February 2022.
 Нет войне – Как российские власти борются с антивоенными протестами [No to war – How Russian authorities are fighting anti-war protests]. OVD-Info (in Russian). Retrieved 28 March 2022.
 Shevchenko, Vitaly (15 March 2022). "Ukraine war: Protester exposes cracks in Kremlin's war message". BBC News. Archived from the original on 15 March 2022. Retrieved 15 March 2022.
 "Joint Letter to the United Nations Human Rights Council on the human rights situation in Russia". Human Rights Watch. 4 March 2022. Archived from the original on 5 March 2022. Retrieved 4 March 2022.
 "As Ukraine war intensifies, some Russian speakers far from Moscow are feeling hostility". The Washington Post. 3 March 2022.
 Beardsworth, James (4 March 2022). "Russians Abroad: Blamed for a Regime They Sought to Escape". The Moscow Times.
 "Goodbye, Tchaikovsky and Tolstoy: Ukrainians look to 'decolonize' their streets". The New York Times. 7 June 2022.
 "Ukraine war: Protests held in Russian occupied Ukrainian cities Kherson, Energodar and Berdyansk". inews.co.uk. 20 March 2022.
 "Ukraine war: A glimpse inside Kherson, the city occupied by Russian forces, through the eyes of a Ukrainian resistance volunteer". Sky News. 20 March 2022.
 "Ukrainians want to stay and fight, but don't see Russian people as the enemy. A remarkable poll from Kyiv". European Leadership Network. 14 March 2022.
 Repnikova, Maria; Zhou, Wendy (11 March 2022). "What China's Social Media Is Saying About Ukraine". The Atlantic. Archived from the original on 11 March 2022. Retrieved 28 May 2022.
 "#IStandWithPutin trending in India amid Russia-Ukraine conflict". DT Next. 2 March 2022. Archived from the original on 21 March 2022.
 Poddar, Umang (8 March 2022). "How Indians on the internet view India's tacit support of Russia". Quartz. Archived from the original on 29 March 2022.
 "5 Alasan yang Bikin Banyak Warga RI Dukung Rusia Invasi Ukraina" [5 reasons why many Indonesians support Russia's invasion of Ukraine]. CNN Indonesia (in Indonesian). 14 March 2022.
 Azmi, Hadi (19 March 2022). "How the battle on Malaysia's social media has become a propaganda tool for Russia and Ukraine". South China Morning Post. ISSN 1563-9371. OCLC 648902513. Archived from the original on 19 March 2022. Retrieved 29 May 2022.
 Serbia, Russia and the war in Ukraine, DW News, 24 May 2022
 "In Serbia, Threats And Insults Are A Cost Of Reporting On Russia's Invasion Of Ukraine". RadioFreeEurope/RadioLiberty. 16 March 2022.
 Danya Hajjaji (7 April 2022). "Ukraine War: Arab Social Media Unsympathetic, Sees Western Hypocrisy". Newsweek. Archived from the original on 19 April 2022.
 Mazurenko, Alyona (28 April 2022). "74% Russians support war with Ukraine despite atrocities committed by Russian army". Ukrayinska Pravda.
 "In Russia, opinion polls are a political weapon". openDemocracy. 9 March 2022.
 Yaffa, Joshua (29 March 2022). "Why Do So Many Russians Say They Support the War in Ukraine?". The New Yorker.
 Roberts, Hannah (3 May 2022). "Pope says NATO may have caused Russia's invasion of Ukraine". Politico. Archived from the original on 3 May 2022. Retrieved 28 May 2022.
 Coleman, Julie (3 May 2022). "The Pope says the Russians are learning that 'their tanks are useless' in Ukraine". Business Insider. Archived from the original on 3 May 2022. Retrieved 28 May 2022.
 Kralova, Simona; Vetsko, Sandro (2 March 2022). "Ukraine: Watching the war on Russian TV – a whole different story". BBC News. Retrieved 31 March 2022.
 Cosic, Jelena (8 March 2022). "Canada sanctions 10 Putin allies, including Russia's leading TV propagandists". International Consortium of Investigative Journalists.
 Stelter, Brian (17 March 2022). "Zelensky meets Americans where they are with video calls and mass media". CNN. Retrieved 22 March 2022.
 Seitz, Amanda; Klepper, David (25 February 2022). "Propaganda, fake videos of Ukraine invasion bombard users". ABC News. Archived from the original on 27 February 2022. Retrieved 27 February 2022.
 Coleman, Alistair; Sardarizadeh, Shayan (24 February 2022). "Ukraine conflict: Many misleading images have been shared online". BBC News. Archived from the original on 1 March 2022.
 Kern, Rebecca; Scott, Mark; Goujard, Clothilde (24 February 2022). "Social media platforms on the defensive as Russian-based disinformation about Ukraine spreads". Politico. Archived from the original on 1 March 2022. Retrieved 1 March 2022.
 Sardarizadeh, Shayan (25 April 2022). "Ukraine war: False TikTok videos draw millions of views". BBC News. Retrieved 25 April 2022.
 "Even Russia's Kremlin-backed media is going off message and beginning to question Putin's war on Ukraine". Fortune. 11 March 2022. Retrieved 29 March 2022.
 "Putin Signs Law Introducing Jail Terms for 'Fake News' on Army". Moscow Times. 4 March 2022. Retrieved 29 March 2022.
 "Ukraine invasion: Russia passes law threatening 15 years in jail for spreading 'fake' information about the military". Sky News. 4 March 2022. Retrieved 29 March 2022.
 "Use Only Official Sources About Ukraine War, Russian Media Watchdog Tells Journalists". Moscow Times. 24 February 2022. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 "Do not call Ukraine invasion a 'war', Russia tells media, schools". Al Jazeera. 2 March 2022. Retrieved 27 March 2022.
 Landen, Xander (26 February 2022). "Russia Tells Media to Delete Stories Mentioning Ukraine 'Invasion'". Newsweek. Archived from the original on 27 February 2022.
 "Russia Bans Media Outlets From Using Words 'War,' 'Invasion'". Moscow Times. 26 February 2022. Archived from the original on 27 February 2022.
 "Russia Puts 'Partial Restriction' on Facebook Access Citing Censorship on State Media". India.com. 25 February 2022. Archived from the original on 26 February 2022.
 Bond, Shannon (25 February 2022). "Russia is limiting access to Facebook. The company says it was ordered to stop fact-checking". NPR. Archived from the original on 26 February 2022. Retrieved 26 February 2022.
 Gessen, Masha (4 March 2022). "The War That Russians Do Not See". The New Yorker. Retrieved 25 March 2022.
 Grafton-Green, Patrick (3 March 2022). "School children force fed Putin's propaganda as Russian media hides Ukraine truths". LBC. Retrieved 25 March 2022.
 Gray, Emma (27 March 2000). "Putin's Media War". CPJ Press Freedom Reports. Retrieved 23 April 2008.
 Vorobyov, Niko (24 February 2022). "How is the Ukraine invasion being viewed in Russia?". Al Jazeera. Saint Petersburg. Archived from the original on 27 February 2022. Retrieved 25 March 2022.
 Simmons, Ann (26 February 2022). "Russian State Media Bolster Putin's Narrative for Ukraine Invasion". The Wall Street Journal. Archived from the original on 27 February 2022. Retrieved 25 March 2022.
 Korenyuk, Maria; Goodman, Jack (4 March 2022). "Ukraine war: 'My city's being shelled, but mum won't believe me'". BBC News. Retrieved 25 March 2022.
 "How Russian media outlets are preparing an attack on Ukraine". Deutsche Welle. 16 February 2022.
 "'Pure Orwell': how Russian state media spins invasion as liberation". The Guardian. 25 February 2022.
 "Russians in the dark about true state of war amid country's Orwellian media coverage". CNN. 3 April 2022.
 Troianovski, Anton (3 March 2022). "Echo of Moscow, a liberal Russian radio station, is shut down". The New York Times.
 "Russia blocks access to BBC and Voice of America websites". Reuters. 4 March 2022.
 "Facebook, Multiple Media Sites Partially Down in Russia – AFP, NGO". Moscow Times. 4 March 2022.
 Milmo, Dan (4 March 2022). "Russia blocks access to Facebook and Twitter". The Guardian. Retrieved 4 March 2022.
 Walker, David (14 June 2002). "Wikipedia Appeals over Moscow Court Order to Remove Articles on Invasion". The Washington Post. Retrieved 14 June 2022.
 "Wikipedia Challenges Russian Order to Remove Ukraine War Information". DW. 13 June 2022. Retrieved 14 June 2022.
 Brewster, Thomas (1 March 2022). "Ukraine's Propaganda Offensive, Led By Ad-Tech Entrepreneurs, Appears To Be Winning". Forbes. Retrieved 5 April 2022.
 Schechner, Sam; Meichtry, Stacy (27 February 2022). "How Zelensky and Putin Are Using Online Media in the War for Ukraine". The Wall Street Journal. Retrieved 22 March 2022.
 Kroll, Andy (2 March 2022). "China's Propaganda Machine Gears Up for Putin — and Blames America for the Invasion". Rolling Stone.
 Wilner, Michael; Maria Delgado, Antonio; Gámez Torres, Nora (14 March 2022). "Explainer: How Russia's war in Ukraine is shuffling U.S. alliances in Latin America". Miami Herald. Retrieved 21 March 2022.
 Wong, Edward (11 March 2022). "U.S. Fights Bioweapons Disinformation Pushed by Russia and China". The New York Times. Retrieved 12 March 2022.
 "Putin supporters demonstrate in Belgrade backing Ukrainian invasion". Business Standard India, Associated Press. 14 March 2022.
 Brodsky, Jason M.; Daoud, David (10 March 2022). "Why Iran and Hezbollah Are Quietly Applauding Putin's War on Ukraine". Haaretz. Retrieved 21 March 2022.
 Ziabari, Kourosh (9 March 2022). "In Backing Russia on Ukraine, Iran Is on the Wrong Side of History". Foreign Policy.
 Sesin, Carmen (8 March 2022). "Russian propaganda targeting Spanish-language users proliferates on social media". NBC News. Retrieved 21 March 2022.
 Soylu, Ragip (13 April 2022). "Russia-Ukraine war: Turkey's talk show generals sway public against Nato". Middle East Eye.
 Higgins, Andrew; Novak, Benjamin (3 April 2022). "Pro-Putin Leaders in Hungary and Serbia Set to Win Re-election". The New York Times. ISSN 0362-4331. Archived from the original on 27 April 2022.
 Eligon, John (17 March 2022). "In Some Parts of the World, the War in Ukraine Seems Justified". The New York Times. Retrieved 19 March 2022.
 Dikole, S. A. (11–17 March 2022). "Situation in Ukraine is about denazification of the country by Russia" (PDF). ANC Today. African National Congress. pp. 5–6. Retrieved 20 March 2022.
 "Why are Indonesians on social media so supportive of Russia?". Al Jazeera. 19 March 2022.
 Iswara, Aditya Jaya, ed. (15 March 2022). "Kenapa Mayoritas Netizen Indonesia Dukung Invasi Rusia ke Ukraina dan Kagum dengan Putin?" [Why do the majority of Indonesian netizens support the Russian invasion of Ukraine and admire Putin?]. Kompas (in Indonesian). BBC News Indonesia. Retrieved 27 March 2022.
 White, Nadine (1 March 2022). "The racial bias in western media's Ukraine coverage is shameful". The Independent. Archived from the original on 28 February 2022.
 "'Double standards': Western coverage of Ukraine war criticised". Al Jazeera. 27 February 2022.
 JOSEPH KRAUSS (29 March 2022). "Many in Mideast see hypocrisy in Western embrace of Ukraine". Associated Press.
 "What does Russia’s capture of Severodonetsk mean for Ukraine?" aljazeera. Retrieved 26 June 2022.
 "Die Chance, dass die Ukraine diesen Krieg gewinnt, tendiert gegen null" Sueddeutsche Zeitung. Retrieved 26 June 2022.
 Funakoshi, Minami; Lawson, Hugh; Deka, Kannaki (9 March 2022). "Tracking sanctions against Russia". Reuters. Retrieved 28 May 2022.
 Melander, Ingrid; Gabriela, Baczynska (24 February 2022). "EU targets Russian economy after 'deluded autocrat' Putin invades Ukraine". Reuters. Archived from the original on 26 February 2022. Retrieved 26 February 2022.
 "Western Countries Agree To Add Putin, Lavrov To Sanctions List". Radio Free Europe/Radio Liberty. 25 February 2022. Archived from the original on 26 February 2022. Retrieved 26 February 2022.
 "Western allies will remove Russian banks from Swift". BBC News. Retrieved 26 February 2022.
 Davidson, Kate; Weaver, Aubree Eliza (28 February 2022). "The West declares economic war on Russia". Politico. Archived from the original on 1 March 2022.
 Fleming, Sam; Solomon, Erika; Borrelli, Silvia Sciorilli (26 February 2022). "Italy move adds to EU momentum for cutting Russian banks from Swift". Financial Times. Archived from the original on 27 February 2022. Retrieved 28 May 2022.
 Pop, Valentina (25 February 2022). "EU leaders agree more Russia sanctions, but save some for later". Financial Times. Archived from the original on 26 February 2022. Retrieved 25 February 2022.
 Chazan, Guy (22 February 2022). "Scholz takes heat off Germany with decision to freeze Nord Stream 2 project". Financial Times. ISSN 0307-1766. Archived from the original on 27 February 2022. Retrieved 26 February 2022.
 Riley, Charles (1 March 2022). "The West's $1 trillion bid to collapse Russia's economy". CNN.
 "IMF, World Bank Chiefs Warn Of Global Impacts From Ukraine War". Barron's. Retrieved 24 February 2022.
 Thompson, Mark. "Russian stocks crash 33% and ruble plunges to record low". CNN. Archived from the original on 24 February 2022. Retrieved 25 February 2022.
 "Moscow Exchange resumes trading on its markets at 10:00am". Moscow Exchange. 24 February 2022. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 Mudgill, Amit (24 February 2022). "Russian stocks nosedive 20% as trading resumes on Moscow Exchange". The Economic Times. New Delhi. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 "Russian central bank decides not to reopen stock market trading next week". Reuters. 12 March 2022.
 Elbahrawy, Farah (4 March 2022). "Russia Keeps Stock Trading Shut in Nation's Longest Closure". Bloomberg News. Retrieved 4 March 2022.
 Ostroff, Caitlin (26 February 2022). "Russia Cut to Junk Rating by S&P, Ukraine's Rating Lowered". The Wall Street Journal. Archived from the original on 1 March 2022. Retrieved 1 March 2022.
 "Live updates: Russia invades Ukraine, country braces for major Donbas offensive". CNN. 11 April 2022. Retrieved 11 April 2022.
 "Ukraine publishes list of 50 global brands that are continuing to operate in Russia". The Independent. 11 March 2022. Archived from the original on 25 June 2022.
 Ostroff, Caitlin (24 February 2022). "Ukraine Central Bank Halts Currency Market, Limits Cash Withdrawals". The Wall Street Journal. Archived from the original on 24 February 2022. Retrieved 24 February 2022.
 "U.S. Executive Order Sanctions the Trade of Russia's Gold Reserves". OCCRP. Retrieved 31 March 2022.
 Klein, David (11 April 2022). "Report: Isolated Russia Could Turn to Africa's Gold Industry". OCCRP. Retrieved 24 April 2022.
 "Missiles fly, but Ukraine's pipeline network keeps Russian gas flowing to Europe". CBC News. 12 April 2022.
 Partington, Richard (1 March 2022). "UK manufacturers face higher costs as Ukraine crisis hits supply chains". The Guardian.
 "Russia faces major disruptions to oil, commodities flows without SWIFT". Reuters. 27 February 2022.
 Phillips, Matt (4 March 2022). "Metal prices soar after Russia's invasion of Ukraine". Axios.
 "Metals world agonizes over war but keeps buying from Russia". Mining.com. 4 April 2022.
 Chappell, Bill (4 May 2022). "The EU just proposed a ban on oil from Russia, its main energy supplier". NPR. Archived from the original on 4 May 2022. Retrieved 28 May 2022.
 "UN chief: Don't let Russia crisis fuel climate destruction". ABC News. 21 March 2022.
 "EU warns of fossil fuel 'backsliding' as countries turn to coal". Al Jazeera. 21 June 2022.
 Geman, Ben (14 March 2022). "The climate spillover of Russia's invasion of Ukraine". Axios.
 Jessie Yeung; Hannah Ryan; Luke McGee; Adrienne Vogt; Joe Ruiz (21 May 2022). "Russian transportation minister says sanctions have "practically broken all" logistics corridors for trade". CNN. Retrieved 27 May 2022.
 "Russian demand for ruble gas payments causes first shutdowns in Poland, Bulgaria". Deutsche Welle. 26 April 2022.
 "RNord Stream 1 gas supply cut aimed at sowing uncertainty, Germany warns". Reuters. 15 June 2022. Retrieved 22 June 2022.
 "Russia's Putin condemns 'mad and thoughtless' Western sanctions". BBC News. 17 June 2022. Retrieved 18 June 2022.
 "Russian military commits indiscriminate attacks during the invasion of Ukraine". Amnesty International. 25 February 2022. Archived from the original on 25 February 2022. Retrieved 25 February 2022.
 "Ukraine: Deadly Attacks Kill, Injure Civilians, Destroy Homes". Human Rights Watch. 18 March 2022. Retrieved 27 March 2022.
 Bogner, Matilda (25 March 2022). "Situation in Ukraine. Statement delivered by the Head of Human Rights Monitoring Mission in Ukraine on the situation in Ukraine". Office of the High Commissioner for Human Rights.
 HRMMU Update on the human rights situation in Ukraine, 24 February – 26 March 2022 (PDF) (Report). UN Human Rights Monitoring Mission in Ukraine. 28 March 2022.
 Lance, Rachel. "The Enduring Danger of Cluster Bombs". Wired. ISSN 1059-1028. Retrieved 2 April 2022.
 Cheetham, Josh; Devlin, Kayleen; Goodman, Jack; Korenyuk, Maria (3 March 2022). "Anatomy of an attack: Is Russia using cluster bombs in Ukraine?". BBC News.
 Bostock, Bill (19 April 2022). "Ukraine used cluster munitions — which many countries have banned — to force Russian troops out of a village, report says". Yahoo! News. Retrieved 20 April 2022.
 "Ukraine nuclear power plant attack: All you need to know". Al Jazeera. 4 March 2022. Retrieved 3 April 2022.
 Reid, Anna (15 March 2022). "Ukrainian heritage is under threat – and so is the truth about Soviet-era Russia". The Guardian. Retrieved 2 April 2022.
 "Crimes against history: mapping the destruction of Ukraine's culture". The Guardian. 24 April 2022. Retrieved 24 April 2022.
 "Ukraine: US condemns 'unconscionable' forced deportations of civilians from Mariupol". The Guardian. 20 March 2022. Retrieved 2 April 2022.
 Engelbrecht, Cora (29 March 2022). "Reports of sexual violence involving Russian soldiers are multiplying, Ukrainian officials say". The New York Times. Archived from the original on 29 March 2022. Retrieved 1 April 2022.
 "War in Ukraine: Street in Bucha found strewn with dead bodies". BBC News. 2 April 2022. Retrieved 3 April 2022.
 "In Bucha, the scope of Russian barbarity is coming into focus". The Washington Post. 7 April 2022. Archived from the original on 7 April 2022.
 Callaghan, Louise (2 April 2022). "Bodies of mutilated children among horrors the Russians left behind". The Times. Archived from the original on 4 April 2022. Retrieved 5 April 2022.
 "Ukraine documents alleged atrocities by retreating Russians". CBS News. Retrieved 3 April 2022.
 Dworkin, Anthony (25 February 2022). "International law and the invasion of Ukraine – European Council on Foreign Relations". European Council on Foreign Relations. Archived from the original on 1 March 2022. Retrieved 25 February 2022.
 "ICC to begin investigation into possible war crimes in Ukraine: Prosecutor says referrals by dozens of countries after Russian invasion enables court to 'immediately' launch probe". Al Jazeera. 2 March 2022. Retrieved 10 May 2022.
 "Statement of ICC Prosecutor, Karim A.A. Khan QC, on the Situation in Ukraine: "I have decided to proceed with opening an investigation."". icc-cpi.int. 28 February 2022. Retrieved 23 March 2022.
 "Ukraine: Russia faces war crimes investigation". BBC News. 3 March 2022. Retrieved 3 March 2022.
 "ICC prosecutor: Team leaves to investigate war crimes in Ukraine". Thomson Reuters. 3 April 2022. Archived from the original on 3 March 2022. Retrieved 4 April 2022.
 "Statement of ICC Prosecutor, Karim A.A. Khan QC, on the Situation in Ukraine: Additional Referrals from Japan and North Macedonia; Contact portal launched for provision of information". icc-cpi.int. 11 March 2022. Retrieved 23 March 2022.
 Johnson, Heidi (4 March 2022). "UN Human Rights Council establishes commission to investigate Russian human rights violations against Ukraine". JURIST. Archived from the original on 7 March 2022. Retrieved 25 March 2022.
 "Human Rights Council establishes an Independent International Commission of Inquiry to investigate all alleged violations of human rights in the context of the Russian Federation's aggression against Ukraine". United Nations Human Rights Council. 4 March 2022. Archived from the original on 19 March 2022. Retrieved 25 March 2022.
 "Russians use abduction, hostage-taking to threaten Ukrainian journalists in occupied zones". Reporters without borders. 25 March 2022. Retrieved 27 March 2022.
 "Ukraine War: Civilians abducted as Russia tries to assert control". BBC News. 25 March 2022. Retrieved 27 March 2022.
 Farmer, Ben; Kozyreva, Tan ya; Townsley, Simon (30 March 2022). "I'm building 2,500 war crimes cases against Vladimir Putin's invasion, says Ukraine's chief prosecutor". The Daily Telegraph. Archived from the original on 31 March 2022. Retrieved 2 April 2022.
 "Ukraine begins first war crimes trial of Russian soldier". BBC. 13 May 2022. Retrieved 13 May 2022.
 Milanovic, Marko (27 February 2022). "Ukraine Files ICJ Claim against Russia". European Journal of International Law. Archived from the original on 1 March 2022. Retrieved 2 March 2022.
 "Order of 16 March 2022" (PDF). International Court of Justice. 16 March 2022.
 "International Court of Justice orders Russia to suspend invasion of Ukraine". Deutsche Welle. 16 March 2022. Retrieved 16 March 2022.
 "Guerre en Ukraine, en direct". Le Monde (in French). 16 March 2022. Retrieved 16 March 2022.
 "A Reminder of the Importance of the Crime of Aggression: Considering the Situation of Russia and Ukraine". Opinio Juris. 4 February 2022. Archived from the original on 25 February 2022. Retrieved 26 February 2022.
 Guilfoyle, Douglas; McIntyre, Juliette; Paige, Tamsin Phillipa (24 February 2020). "Is international law powerless against Russian aggression in Ukraine? No, but it's complicated". The Conversation. Archived from the original on 25 February 2022. Retrieved 26 February 2022.
 Kinetz, Erika (25 March 2022). "How Would Those Accused of Ukraine War Crimes Be Prosecuted?". Frontline. PBS. Retrieved 30 March 2022.
 "Judgment Day: European Nations Start Probing Alleged Russian War Crimes in Ukraine". Voice of America. 9 March 2022. Retrieved 30 March 2022.
Further reading
Watling, Jack; Reynolds, Nick (22 April 2022). Operation Z: The Death Throes of an Imperial Delusion (PDF) (Report). Royal United Services Institute.
Smith, Christopher M. (15 March 2022). Ukraine's Revolt, Russia's Revenge. Brookings Institution Press. ISBN 978-0-8157-3925-8. OCLC 1287616684.
D'Anieri, Paul (31 October 2019). Ukraine and Russia: From Civilized Divorce to Uncivil War. Cambridge University Press. ISBN 978-1-108-48609-5.
Wood, Elizabeth A.; Pomeranz, William E.; Merry, E. Wayne; Trudolyubov, Maxim (15 December 2015). Roots of Russia's War in Ukraine. Columbia University Press. ISBN 978-0-231-80138-6. OCLC 1008637056.
Menon, Rajan; Rumer, Eugene B. (6 February 2015). Conflict in Ukraine: The Unwinding of the Post-Cold War Order. MIT Press. ISBN 978-0-262-53629-5. OCLC 1029335958.
External links
2022 Russian invasion of Ukraine
at Wikipedia's sister projects
Media from Commons
News from Wikinews
The UN and the war in Ukraine at the United Nations
Think Tank reports on the invasion of Ukraine at the Council of the European Union
Ukraine conflict updates by the Institute for the Study of War
Russia invades Ukraine at Reuters
2022 Russian invasion of Ukraine at Google News
vte
2022 Russian invasion of Ukraine
vte
Russo-Ukrainian War
vte
War in Donbas
vte
Russia Russia–Ukraine relations Ukraine
vte
Post–Cold War conflicts in Europe
vte
Ongoing armed conflicts
vte
Vladimir Putin
Authority control: National libraries Edit this at Wikidata	
France (data)LatviaCzech RepublicPoland
Categories: 2022 Russian invasion of Ukraine2022 controversiesRusso-Ukrainian WarOngoing conflicts in EuropeConflicts in 2022February 2022 events in UkraineMarch 2022 events in UkraineApril 2022 events in UkraineFebruary 2022 events in EuropeMarch 2022 events in EuropeApril 2022 events in Europe2022 in international relations2022 in Ukraine2022 in RussiaInvasions of UkraineInvasions by RussiaMilitary history of UkrainePost-Soviet conflictsRussian irredentismRussia–NATO relationsRussia–Ukraine military relationsUkraine–NATO relationsBelarus–Ukraine relationsVladimir PutinVolodymyr ZelenskyyWars involving BelarusWars involving ChechnyaWars involving the Donetsk People's RepublicWars involving the Luhansk People's RepublicWars involving RussiaWars involving Ukraine
Navigation menu
Not logged in
Talk
Contributions
Create account
Log in
ArticleTalk
ReadView sourceView history
Search
Search Wikipedia
Main page
Contents
Current events
Random article
About Wikipedia
Contact us
Donate
Contribute
Help
Learn to edit
Community portal
Recent changes
Upload file
Tools
What links here
Related changes
Special pages
Permanent link
Page information
Cite this page
Wikidata item
Print/export
Download as PDF
Printable version
In other projects
Wikimedia Commons
Meta-Wiki
Wikinews

Languages
العربية
Español
हिन्दी
Bahasa Indonesia
Bahasa Melayu
Русский
Українська
اردو
中文
110 more
Edit links
This page was last edited on 27 June 2022, at 22:00 (UTC).
Text is available under the Creative Commons Attribution-ShareAlike License 3.0; additional terms may apply. By using this site, you agree to the Terms of Use and Privacy Policy. Wikipedia® is a registered trademark of the Wikimedia Foundation, Inc., a non-profit organization.
Privacy policyAbout WikipediaDisclaimersContact WikipediaMobile viewDevelopersStatisticsCookie statementWikimedia FoundationPowered by MediaWiki"""



training_data_chunks = []
for i in range(1000, len(training_data), 1000):
    training_data_chunks.append(training_data[i-1000:i])